use Game::Quest::Entity;

use Game::Quest::EntityNoUpdate;
use Game::Quest::EntityLeftUpdate;
use Game::Quest::EntityRightUpdate;
use Game::Quest::EntityUpUpdate;
use Game::Quest::EntityDownUpdate;

class Player {

	has $!ddx;
	has $!ddy;

	has $!update-obj;

	submethod BUILD(:$x, :$y, :$ddx, :$ddy) {
		.init($x,$y, $ddx, $ddy);
	}

	multi method init($x, $y, $ddx, $ddy) {
		.x = $x;
		.y = $y;

		.ddx = $ddx;
		.ddy = $ddy;

		.update-obj = EntityNoUpdate.new(.ddx, .ddy);
		.update-obj.update;
	}

	multi method move-not {
		.update-obj = EntityNoUpdate.new(.ddx, .ddy);
		.update-obj.update;
	}

	multi method move-left {
		.update-obj = EntityLeftUpdate.new(.ddx, .ddy);
		.update-obj.update;
	}

	multi method move-right {
		.update-obj = EntityRightUpdate.new(.ddx, .ddy);
		.update-obj.update;
	}

	multi method move-up {
		.update-obj = EntityUpUpdate.new(.ddx, .ddy);
		.update-obj.update;
	}

	multi method move-down {
		.update-obj = EntityDownUpdate.new(.ddx, .ddy);
		.update-obj.update;
	}


	
}
