///
/// @file
/// @brief dams????????????static??????
///

#ifndef _DAMS_H
#define _DAMS_H

#include <string>
#include <vector>
#include <stdexcept>

extern "C" {
  int dams_is_present(void);
}


namespace damswrapper { 
	
  ///
  /// @file
  /// @brief dams??????????????????
  ///
  class AddressElement {
  private:
		
    std::string name;
		
    int level;
		
    float x;
		
    float y;
		
  public:
		
  AddressElement() : level(0), x(0.0), y(0.0) {}
		
    inline std::string get_name() const {
      return name;
    }
		
    inline void set_name(std::string v) {
      name = v;
    }
		
    inline int get_level() const {
      return level;
    }
		
    inline void set_level(int v) {
      level = v;
    }
		
    inline float get_x() const {
      return x;
    }
		
    inline void set_x(float v) {
      x = v;
    }
		
    inline float get_y() const {
      return y;
    }
		
    inline void set_y(float v) {
      y = v;
    }
  };

  ///
  /// @file
  /// @brief dams??????????????
  ///

  class DamsInitException : public std::runtime_error {
  public:
  DamsInitException(const char* msg) : runtime_error(msg) {}
  };
	
  class DamsException : public std::runtime_error {
  public:
  DamsException(const char* msg) : runtime_error(msg) {}
  };

  typedef std::vector<AddressElement> Candidate;
	
  /// @brief ??????????????
  /// @param [in] damsFileName ??????????????
  /// @exception ????????????????????????????????????????????
  void init(const std::string& damsFileName) throw (DamsInitException);

  /// @brief ??????????????????????????????????????????????????????????????
  void init(void);

  /// @brief ??????????????????????????????????????????
  void _init(void);

  /// @brief ????????????
  void final();

  /// @brief ????????????????????????????????????????
  const char* default_dic_path(void);

  /// @brief ????????????????????????
  std::string utf8_to_euc(const std::string& utf_string);
  std::string euc_to_utf8(const std::string& euc_string);
	
  /// @brief ????????????????????????
  /// @param [out] score
  /// @param [out] tail
  /// @param [out] candidates
  /// @param [in] ??????????????UTF-8??????????????????????????
  void retrieve(
		int& score, 
		std::string& tail, 
		std::vector<Candidate>& candidates, 
		const std::string& query) throw (DamsException);
	
  /// @brief ????????????????????????????????????????????????????????????????????????false
  /// @param [in] flag
  void debugmode(bool flag);
	
  /// @brief ??????????????????????????????????????????????????????????????????????????????????????false
  /// @param [in] flag
  void set_check_new_address(bool flag);
	
  /// @brief ????????????????????????????????????????????????????????????????????????????10
  /// @param [in] limit
  void set_limit(int limit);
	
  /// @brief ????????????????????????????????????????????????????????????????????????????????????5
  /// @param [in] level
  void set_exact_match_level(int level);
	
  /// @brief ????????????????????????????????????????
  /// @return
  int get_exact_match_level();
	
  /// @brief ?????? retrieve() ????????????????????????????????????
  /// @return
  long elapsedtime();

  /// @brief ??????????????????????????????????????
  /// @param [in] str ??????????????????
  /// @return ????????????
  std::string get_standardized_string(const std::string& str);
	
}

#endif /* _DAMS_H */
