use strict;
use Test::More 0.98;
use Test::Base::Less;

use JSON5;
use JSON5::Parser;

filters {
    expected => [qw/eval/],
};

my $parser = JSON5::Parser->new->allow_nonref->utf8;
for my $block (blocks) {
    my $parsed = eval { $parser->parse($block->input) };
    is_deeply $parsed, $block->expected, $block->get_section('name')
        or diag $block->input;
    diag $@ if $@;
}

done_testing;

__DATA__
===
--- name: empty object
--- input
/* here */{/* is */}/* ignored */
--- expected
{}

===
--- name: object keys
--- input
// {
{
  //aaaaaaaaa: "should be ignored!!!!!!",
  $1:  "$1" /*,*/ , /* , */
  _1:  '_1',
  a1:  'a1',
  aA:  'aA',
  '':  '',
  "1": '1',
  /*
  bbbb: "should be ignored!!!!!!",
  */
}
--- expected
{'$1' => '$1', '_1' => '_1', a1 => 'a1', aA => 'aA', '' => '', 1 => '1'}

===
--- name: object values
--- input
{
  $1: [ // ]
    {$2: [3, 4.5, {$6: {$7: 8, $9: "10"}}, "1-1"/* a */]},
    {$2: [3, 4.5, {$6: {$7: 8, $9: "10"}}, "1-2"/* b */ , ]},
  ],
  $2: /* [] */ [
    {$1: [3, 4.5, {$6: /* a */ {$7: 8, $9: "10"}}, "2-1"]},
    {$1: [3, 4.5, {$6: {$7: 8, $9: "10" /* b */ }}, "2-2"]},
  ],
}
--- expected
{
  '$1' => [
    {'$2' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "1-1"]},
    {'$2' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "1-2"]},
  ],
  '$2' => [
    {'$1' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "2-1"]},
    {'$1' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "2-2"]},
  ],
}

===
--- name: empty array
--- input
/* here */[/* is   */]  /*ignored*/
--- expected
[]

===
--- name: nested object values
--- input
[
  /* { */ {
    $1: [ // [
      {$2: [3, 4.5, {$6: {$7: 8, $9: "10"}}, "1-1"]},
      {$2: [3, 4.5, {$6: {$7: 8, $9: "10"}}, "1-2"]},
    // ],
    ],
    $2: [
      {$1: [3, 4.5, {$6: {$7: 8, $9: "10"}}, "2-1"]},
      {$1: [3, 4.5, {$6: {$7: 8, $9: "10"}}, "2-2"]},
    ],
  }
]
--- expected
[
  {
    '$1' => [
      {'$2' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "1-1"]},
      {'$2' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "1-2"]},
    ],
    '$2' => [
      {'$1' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "2-1"]},
      {'$1' => [3, 4.5, {'$6' => {'$7' => 8, '$9' => "10"}}, "2-2"]},
    ],
  }
]
