#!/usr/bin/perl
# vim:set filetype=perl:

use warnings;
use strict;

use lib "./lib";

use Test::More tests => 25;
use Hardware::Simulator::MIX;

my $mix = Hardware::Simulator::MIX->new;
$mix->reset();

### CODE
my $loc = 0;

$mix->write_mem($loc++, ['+', 31, 16, 0, 005, 24]); #STA 2000(0:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 015, 24]); #STA 2000(1:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 055, 24]); #STA 2000(5:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 022, 24]); #STA 2000(2:2)
$mix->write_mem($loc++, ['+', 31, 16, 0, 023, 24]); #STA 2000(2:3)
$mix->write_mem($loc++, ['+', 31, 16, 0, 001, 24]); #STA 2000(0:1)

$mix->write_mem($loc++, ['+', 31, 16, 0, 005, 31]); #STX 2000(0:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 015, 31]); #STX 2000(1:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 055, 31]); #STX 2000(5:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 022, 31]); #STX 2000(2:2)
$mix->write_mem($loc++, ['+', 31, 16, 0, 023, 31]); #STX 2000(2:3)
$mix->write_mem($loc++, ['+', 31, 16, 0, 001, 31]); #STX 2000(0:1)

$mix->write_mem($loc++, ['+', 31, 16, 0, 005, 33]); #STZ 2000(0:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 015, 33]); #STZ 2000(1:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 055, 33]); #STZ 2000(5:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 022, 33]); #STZ 2000(2:2)
$mix->write_mem($loc++, ['+', 31, 16, 0, 023, 33]); #STZ 2000(2:3)
$mix->write_mem($loc++, ['+', 31, 16, 0, 001, 33]); #STZ 2000(0:1)

$mix->write_mem($loc++, ['+', 31, 16, 0, 002, 32]); #STJ 2000(0:2)

$mix->write_mem($loc++, ['+', 31, 16, 0, 005, 25]); #ST1 2000(0:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 015, 25]); #ST2 2000(1:5)
$mix->write_mem($loc++, ['+', 31, 16, 0, 023, 25]); #ST3 2000(2:3)
$mix->write_mem($loc++, ['+', 31, 16, 0, 012, 25]); #ST4 2000(1:2)
$mix->write_mem($loc++, ['+', 31, 16, 0, 002, 25]); #ST5 2000(0:2)
$mix->write_mem($loc++, ['+', 31, 16, 0, 022, 25]); #ST6 2000(2:2)

$mix->set_reg('rA',  ['+', 6, 7, 8, 9, 0]);
$mix->set_reg('rX',  ['+', 6, 7, 8, 9, 0]);
$mix->set_reg('rJ',  ['+', 0, 0, 0, 6, 7]);

$mix->set_reg('rI1',  ['+', 0, 0, 0, 6, 7]);
$mix->set_reg('rI2',  ['+', 0, 0, 0, 6, 7]);
$mix->set_reg('rI3',  ['+', 0, 0, 0, 6, 7]);
$mix->set_reg('rI4',  ['+', 0, 0, 0, 6, 7]);
$mix->set_reg('rI5',  ['+', 0, 0, 0, 6, 7]);
$mix->set_reg('rI6',  ['+', 0, 0, 0, 6, 7]);

### TEST 
my @tmp;
my $i;
my @expect = (
## STA
	['+', 6, 7, 8, 9, 0],
	['-', 6, 7, 8, 9, 0],
	['-', 1, 2, 3, 4, 0],
	['-', 1, 0, 3, 4, 5],
	['-', 1, 9, 0, 4, 5],
	['+', 0, 2, 3, 4, 5],
## STX
	['+', 6, 7, 8, 9, 0],
	['-', 6, 7, 8, 9, 0],
	['-', 1, 2, 3, 4, 0],
	['-', 1, 0, 3, 4, 5],
	['-', 1, 9, 0, 4, 5],
	['+', 0, 2, 3, 4, 5],
## STZ
	['+', 0, 0, 0, 0, 0],
	['-', 0, 0, 0, 0, 0],
	['-', 1, 2, 3, 4, 0],
	['-', 1, 0, 3, 4, 5],
	['-', 1, 0, 0, 4, 5],
	['+', 0, 2, 3, 4, 5],
## STJ
	['+', 6, 7, 3, 4, 5],
## STi
	['+', 0, 0, 0, 6, 7],
	['-', 0, 0, 0, 6, 7],
	['-', 1, 6, 7, 4, 5],
	['-', 6, 7, 3, 4, 5],
	['+', 6, 7, 3, 4, 5],
	['-', 1, 7, 3, 4, 5]
);

for ($i = 0; $i < 25; $i++) {
	$mix->write_mem(2000, ['-',  1,  2,  3,  4,  5]);
	$mix->step();
	@tmp = $mix->read_mem(2000);
	is_deeply(\@tmp, $expect[$i]);
}


