# Generated by default/object.tt
package Paws::Lightsail::ContainerService;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ContainerServiceName => (is => 'ro', isa => 'Str', request_name => 'containerServiceName', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CurrentDeployment => (is => 'ro', isa => 'Paws::Lightsail::ContainerServiceDeployment', request_name => 'currentDeployment', traits => ['NameInRequest']);
  has IsDisabled => (is => 'ro', isa => 'Bool', request_name => 'isDisabled', traits => ['NameInRequest']);
  has Location => (is => 'ro', isa => 'Paws::Lightsail::ResourceLocation', request_name => 'location', traits => ['NameInRequest']);
  has NextDeployment => (is => 'ro', isa => 'Paws::Lightsail::ContainerServiceDeployment', request_name => 'nextDeployment', traits => ['NameInRequest']);
  has Power => (is => 'ro', isa => 'Str', request_name => 'power', traits => ['NameInRequest']);
  has PowerId => (is => 'ro', isa => 'Str', request_name => 'powerId', traits => ['NameInRequest']);
  has PrincipalArn => (is => 'ro', isa => 'Str', request_name => 'principalArn', traits => ['NameInRequest']);
  has PrivateDomainName => (is => 'ro', isa => 'Str', request_name => 'privateDomainName', traits => ['NameInRequest']);
  has PublicDomainNames => (is => 'ro', isa => 'Paws::Lightsail::ContainerServicePublicDomains', request_name => 'publicDomainNames', traits => ['NameInRequest']);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest']);
  has Scale => (is => 'ro', isa => 'Int', request_name => 'scale', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has StateDetail => (is => 'ro', isa => 'Paws::Lightsail::ContainerServiceStateDetail', request_name => 'stateDetail', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::Lightsail::Tag]', request_name => 'tags', traits => ['NameInRequest']);
  has Url => (is => 'ro', isa => 'Str', request_name => 'url', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerService

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerService object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Url => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerService object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Describes an Amazon Lightsail container service.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the container service.


=head2 ContainerServiceName => Str

The name of the container service.


=head2 CreatedAt => Str

The timestamp when the container service was created.


=head2 CurrentDeployment => L<Paws::Lightsail::ContainerServiceDeployment>

An object that describes the current container deployment of the
container service.


=head2 IsDisabled => Bool

A Boolean value indicating whether the container service is disabled.


=head2 Location => L<Paws::Lightsail::ResourceLocation>

An object that describes the location of the container service, such as
the AWS Region and Availability Zone.


=head2 NextDeployment => L<Paws::Lightsail::ContainerServiceDeployment>

An object that describes the next deployment of the container service.

This value is C<null> when there is no deployment in a C<pending>
state.


=head2 Power => Str

The power specification of the container service.

The power specifies the amount of RAM, the number of vCPUs, and the
base price of the container service.


=head2 PowerId => Str

The ID of the power of the container service.


=head2 PrincipalArn => Str

The principal ARN of the container service.

The principal ARN can be used to create a trust relationship between
your standard AWS account and your Lightsail container service. This
allows you to give your service permission to access resources in your
standard AWS account.


=head2 PrivateDomainName => Str

The private domain name of the container service.

The private domain name is accessible only by other resources within
the default virtual private cloud (VPC) of your Lightsail account.


=head2 PublicDomainNames => L<Paws::Lightsail::ContainerServicePublicDomains>

The public domain name of the container service, such as C<example.com>
and C<www.example.com>.

You can specify up to four public domain names for a container service.
The domain names that you specify are used when you create a deployment
with a container configured as the public endpoint of your container
service.

If you don't specify public domain names, then you can use the default
domain of the container service.

You must create and validate an SSL/TLS certificate before you can use
public domain names with your container service. Use the
C<CreateCertificate> action to create a certificate for the public
domain names you want to use with your container service.

See C<CreateContainerService> or C<UpdateContainerService> for
information about how to specify public domain names for your Lightsail
container service.


=head2 ResourceType => Str

The Lightsail resource type of the container service (i.e.,
C<ContainerService>).


=head2 Scale => Int

The scale specification of the container service.

The scale specifies the allocated compute nodes of the container
service.


=head2 State => Str

The current state of the container service.

The following container service states are possible:

=over

=item *

C<PENDING> - The container service is being created.

=item *

C<READY> - The container service is running but it does not have an
active container deployment.

=item *

C<DEPLOYING> - The container service is launching a container
deployment.

=item *

C<RUNNING> - The container service is running and it has an active
container deployment.

=item *

C<UPDATING> - The container service capacity or its custom domains are
being updated.

=item *

C<DELETING> - The container service is being deleted.

=item *

C<DISABLED> - The container service is disabled, and its active
deployment and containers, if any, are shut down.

=back



=head2 StateDetail => L<Paws::Lightsail::ContainerServiceStateDetail>

An object that describes the current state of the container service.

The state detail is populated only when a container service is in a
C<PENDING>, C<DEPLOYING>, or C<UPDATING> state.


=head2 Tags => ArrayRef[L<Paws::Lightsail::Tag>]

The tag keys and optional values for the resource. For more information
about tags in Lightsail, see the Lightsail Dev Guide
(https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags).


=head2 Url => Str

The publicly accessible URL of the container service.

If no public endpoint is specified in the C<currentDeployment>, this
URL returns a 404 response.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

