# Generated by default/object.tt
package Paws::IoTEventsData::AlarmSummary;
  use Moose;
  has AlarmModelName => (is => 'ro', isa => 'Str', request_name => 'alarmModelName', traits => ['NameInRequest']);
  has AlarmModelVersion => (is => 'ro', isa => 'Str', request_name => 'alarmModelVersion', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has KeyValue => (is => 'ro', isa => 'Str', request_name => 'keyValue', traits => ['NameInRequest']);
  has LastUpdateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdateTime', traits => ['NameInRequest']);
  has StateName => (is => 'ro', isa => 'Str', request_name => 'stateName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEventsData::AlarmSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEventsData::AlarmSummary object:

  $service_obj->Method(Att1 => { AlarmModelName => $value, ..., StateName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEventsData::AlarmSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AlarmModelName

=head1 DESCRIPTION

Contains a summary of an alarm.

=head1 ATTRIBUTES


=head2 AlarmModelName => Str

The name of the alarm model.


=head2 AlarmModelVersion => Str

The version of the alarm model.


=head2 CreationTime => Str

The time the alarm was created, in the Unix epoch format.


=head2 KeyValue => Str

The value of the key used as a filter to select only the alarms
associated with the key
(https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).


=head2 LastUpdateTime => Str

The time the alarm was last updated, in the Unix epoch format.


=head2 StateName => Str

The name of the alarm state. The state name can be one of the following
values:

=over

=item *

C<DISABLED> - When the alarm is in the C<DISABLED> state, it isn't
ready to evaluate data. To enable the alarm, you must change the alarm
to the C<NORMAL> state.

=item *

C<NORMAL> - When the alarm is in the C<NORMAL> state, it's ready to
evaluate data.

=item *

C<ACTIVE> - If the alarm is in the C<ACTIVE> state, the alarm is
invoked.

=item *

C<ACKNOWLEDGED> - When the alarm is in the C<ACKNOWLEDGED> state, the
alarm was invoked and you acknowledged the alarm.

=item *

C<SNOOZE_DISABLED> - When the alarm is in the C<SNOOZE_DISABLED> state,
the alarm is disabled for a specified period of time. After the snooze
time, the alarm automatically changes to the C<NORMAL> state.

=item *

C<LATCHED> - When the alarm is in the C<LATCHED> state, the alarm was
invoked. However, the data that the alarm is currently evaluating is
within the specified range. To change the alarm to the C<NORMAL> state,
you must acknowledge the alarm.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEventsData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

