# Generated by default/object.tt
package Paws::Glue::MLUserDataEncryption;
  use Moose;
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has MlUserDataEncryptionMode => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::MLUserDataEncryption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::MLUserDataEncryption object:

  $service_obj->Method(Att1 => { KmsKeyId => $value, ..., MlUserDataEncryptionMode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::MLUserDataEncryption object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyId

=head1 DESCRIPTION

The encryption-at-rest settings of the transform that apply to
accessing user data.

=head1 ATTRIBUTES


=head2 KmsKeyId => Str

The ID for the customer-provided KMS key.


=head2 B<REQUIRED> MlUserDataEncryptionMode => Str

The encryption mode applied to user data. Valid values are:

=over

=item *

DISABLED: encryption is disabled

=item *

SSEKMS: use of server-side encryption with Key Management Service
(SSE-KMS) for user data stored in Amazon S3.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

