package Paws::ForecastQuery;
  use Moose;
  sub service { 'forecastquery' }
  sub signing_name { 'forecast' }
  sub version { '2018-06-26' }
  sub target_prefix { 'AmazonForecastRuntime' }
  sub json_version { "1.1" }
  has max_attempts => (is => 'ro', isa => 'Int', default => 5);
  has retry => (is => 'ro', isa => 'HashRef', default => sub {
    { base => 'rand', type => 'exponential', growth_factor => 2 }
  });
  has retriables => (is => 'ro', isa => 'ArrayRef', default => sub { [
  ] });

  with 'Paws::API::Caller', 'Paws::API::EndpointResolver', 'Paws::Net::V4Signature', 'Paws::Net::JsonCaller';

  
  sub QueryForecast {
    my $self = shift;
    my $call_object = $self->new_with_coercions('Paws::ForecastQuery::QueryForecast', @_);
    return $self->caller->do_call($self, $call_object);
  }
  


  sub operations { qw/QueryForecast / }

1;

### main pod documentation begin ###

=head1 NAME

Paws::ForecastQuery - Perl Interface to AWS Amazon Forecast Query Service

=head1 SYNOPSIS

  use Paws;

  my $obj = Paws->service('ForecastQuery');
  my $res = $obj->Method(
    Arg1 => $val1,
    Arg2 => [ 'V1', 'V2' ],
    # if Arg3 is an object, the HashRef will be used as arguments to the constructor
    # of the arguments type
    Arg3 => { Att1 => 'Val1' },
    # if Arg4 is an array of objects, the HashRefs will be passed as arguments to
    # the constructor of the arguments type
    Arg4 => [ { Att1 => 'Val1'  }, { Att1 => 'Val2' } ],
  );

=head1 DESCRIPTION

Provides APIs for creating and managing Amazon Forecast resources.

For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/forecastquery-2018-06-26>


=head1 METHODS

=head2 QueryForecast

=over

=item Filters => L<Paws::ForecastQuery::Filters>

=item ForecastArn => Str

=item [EndDate => Str]

=item [NextToken => Str]

=item [StartDate => Str]


=back

Each argument is described in detail in: L<Paws::ForecastQuery::QueryForecast>

Returns: a L<Paws::ForecastQuery::QueryForecastResponse> instance

Retrieves a forecast for a single item, filtered by the supplied
criteria.

The criteria is a key-value pair. The key is either C<item_id> (or the
equivalent non-timestamp, non-target field) from the
C<TARGET_TIME_SERIES> dataset, or one of the forecast dimensions
specified as part of the C<FeaturizationConfig> object.

By default, C<QueryForecast> returns the complete date range for the
filtered forecast. You can request a specific date range.

To get the full forecast, use the CreateForecastExportJob
(https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html)
operation.

The forecasts generated by Amazon Forecast are in the same timezone as
the dataset that was used to create the predictor.




=head1 PAGINATORS

Paginator methods are helpers that repetively call methods that return partial results




=head1 SEE ALSO

This service class forms part of L<Paws>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

