/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PRCurve {
    double[] scores;
    int[] classes;
    int[] guesses;
    int[] numpositive;
    int[] numnegative;

    public PRCurve(String filename) {
        try {
            ArrayList<Pair<Double, Integer>> dataScores = new ArrayList<Pair<Double, Integer>>();
            for (String line : ObjectBank.getLineIterator(new File(filename))) {
                List<String> elems = StringUtils.split(line);
                Pair<Double, Integer> p = new Pair<Double, Integer>(new Double(elems.get(0).toString()), Integer.valueOf(elems.get(1).toString()));
                dataScores.add(p);
            }
            this.init(dataScores);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PRCurve(String filename, boolean svm) {
        try {
            ArrayList<Pair<Double, Integer>> dataScores = new ArrayList<Pair<Double, Integer>>();
            for (String line : ObjectBank.getLineIterator(new File(filename))) {
                List<String> elems = StringUtils.split(line);
                int cls = new Double(elems.get(0).toString()).intValue();
                if (cls == -1) {
                    cls = 0;
                }
                double score = Double.parseDouble(elems.get(1).toString()) + 0.5;
                Pair<Double, Integer> p = new Pair<Double, Integer>(new Double(score), cls);
                dataScores.add(p);
            }
            this.init(dataScores);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double optimalAccuracy() {
        return (double)this.precision(this.numSamples()) / (double)this.numSamples();
    }

    public double accuracy() {
        return (double)this.logPrecision(this.numSamples()) / (double)this.numSamples();
    }

    public PRCurve(List<Pair<Double, Integer>> dataScores) {
        this.init(dataScores);
    }

    public void init(List<Pair<Double, Integer>> dataScores) {
        BinaryHeapPriorityQueue<Pair<Integer, Pair<Double, Integer>>> q = new BinaryHeapPriorityQueue<Pair<Integer, Pair<Double, Integer>>>();
        for (int i = 0; i < dataScores.size(); ++i) {
            q.add(new Pair<Integer, Pair<Double, Integer>>(i, dataScores.get(i)), -dataScores.get(i).first().doubleValue());
        }
        List sorted = q.toSortedList();
        this.scores = new double[sorted.size()];
        this.classes = new int[sorted.size()];
        System.err.println("incoming size " + dataScores.size() + " resulting " + sorted.size());
        for (int i = 0; i < sorted.size(); ++i) {
            Pair next = (Pair)((Pair)sorted.get(i)).second();
            this.scores[i] = (Double)next.first();
            this.classes[i] = (Integer)next.second();
        }
        this.init();
    }

    public void initMC(ArrayList<Triple<Double, Integer, Integer>> dataScores) {
        BinaryHeapPriorityQueue<Pair<Integer, Triple<Double, Integer, Integer>>> q = new BinaryHeapPriorityQueue<Pair<Integer, Triple<Double, Integer, Integer>>>();
        for (int i = 0; i < dataScores.size(); ++i) {
            q.add(new Pair<Integer, Triple<Double, Integer, Integer>>(i, dataScores.get(i)), -dataScores.get(i).first().doubleValue());
        }
        List sorted = q.toSortedList();
        this.scores = new double[sorted.size()];
        this.classes = new int[sorted.size()];
        this.guesses = new int[sorted.size()];
        System.err.println("incoming size " + dataScores.size() + " resulting " + sorted.size());
        for (int i = 0; i < sorted.size(); ++i) {
            Triple next = (Triple)((Pair)sorted.get(i)).second();
            this.scores[i] = (Double)next.first();
            this.classes[i] = (Integer)next.second();
            this.guesses[i] = (Integer)next.third();
        }
        this.init();
    }

    void init() {
        int i;
        this.numnegative = new int[this.numSamples() + 1];
        this.numpositive = new int[this.numSamples() + 1];
        this.numnegative[0] = 0;
        this.numpositive[0] = 0;
        int num = this.numSamples();
        for (i = 1; i <= num; ++i) {
            this.numnegative[i] = this.numnegative[i - 1] + (this.classes[i - 1] == 0 ? 1 : 0);
        }
        for (i = 1; i <= num; ++i) {
            this.numpositive[i] = this.numpositive[i - 1] + (this.classes[num - i] == 0 ? 0 : 1);
        }
        System.err.println("total positive " + this.numpositive[num] + " total negative " + this.numnegative[num] + " total " + num);
        for (i = 1; i < this.numpositive.length; ++i) {
        }
    }

    int numSamples() {
        return this.scores.length;
    }

    public int precision(int recall) {
        int optimum = 0;
        for (int right = 0; right <= recall; ++right) {
            int candidate = this.numpositive[right] + this.numnegative[recall - right];
            if (candidate <= optimum) continue;
            optimum = candidate;
        }
        return optimum;
    }

    public static double f1(int tp, int fp, int fn) {
        double prec = 1.0;
        double recall = 1.0;
        if (tp + fp > 0) {
            prec = (double)tp / (double)(tp + fp);
        }
        if (tp + fn > 0) {
            recall = (double)tp / (double)(tp + fn);
        }
        return 2.0 * prec * recall / (prec + recall);
    }

    public double fmeasure(int numleft, int numright) {
        int tp = 0;
        int fp = 0;
        int fn = 0;
        tp = this.numpositive[numright];
        fp = numright - tp;
        fn = numleft - this.numnegative[numleft];
        return PRCurve.f1(tp, fp, fn);
    }

    public int logPrecision(int recall) {
        int rightIndex = this.numSamples() - 1;
        int leftIndex = 0;
        int totalcorrect = 0;
        for (int totaltaken = 0; totaltaken < recall; ++totaltaken) {
            double confr = Math.abs(this.scores[rightIndex] - 0.5);
            double confl = Math.abs(this.scores[leftIndex] - 0.5);
            int chosen = leftIndex++;
            if (confr > confl) {
                chosen = rightIndex--;
            }
            if (this.scores[chosen] >= 0.5 && this.classes[chosen] == 1) {
                ++totalcorrect;
            }
            if (!(this.scores[chosen] < 0.5) || this.classes[chosen] != 0) continue;
            ++totalcorrect;
        }
        return totalcorrect;
    }

    public double optFmeasure(int recall) {
        double max = 0.0;
        for (int i = 0; i < recall + 1; ++i) {
            double f = this.fmeasure(i, recall - i);
            if (!(f > max)) continue;
            max = f;
        }
        return max;
    }

    public double opFmeasure() {
        return this.optFmeasure(this.numSamples());
    }

    public double fmeasure(int recall) {
        int rightIndex = this.numSamples() - 1;
        int leftIndex = 0;
        int tp = 0;
        int fp = 0;
        int fn = 0;
        for (int totaltaken = 0; totaltaken < recall; ++totaltaken) {
            double confr = Math.abs(this.scores[rightIndex] - 0.5);
            double confl = Math.abs(this.scores[leftIndex] - 0.5);
            int chosen = leftIndex++;
            if (confr > confl) {
                chosen = rightIndex--;
            }
            if (this.scores[chosen] >= 0.5) {
                if (this.classes[chosen] == 1) {
                    ++tp;
                } else {
                    ++fp;
                }
            }
            if (!(this.scores[chosen] < 0.5) || this.classes[chosen] != 1) continue;
            ++fn;
        }
        return PRCurve.f1(tp, fp, fn);
    }

    public double logLikelihood() {
        double loglik = 0.0;
        for (int i = 0; i < this.scores.length; ++i) {
            loglik += Math.log(this.classes[i] == 0 ? 1.0 - this.scores[i] : this.scores[i]);
        }
        return loglik;
    }

    public double cwa() {
        double acc = 0.0;
        for (int recall = 1; recall <= this.numSamples(); ++recall) {
            acc += (double)this.logPrecision(recall) / (double)recall;
        }
        return acc / (double)this.numSamples();
    }

    public int[] cwaArray() {
        int[] arr = new int[this.numSamples()];
        for (int recall = 1; recall <= this.numSamples(); ++recall) {
            arr[recall - 1] = this.logPrecision(recall);
        }
        return arr;
    }

    public int[] optimalCwaArray() {
        int[] arr = new int[this.numSamples()];
        for (int recall = 1; recall <= this.numSamples(); ++recall) {
            arr[recall - 1] = this.precision(recall);
        }
        return arr;
    }

    public double optimalCwa() {
        double acc = 0.0;
        for (int recall = 1; recall <= this.numSamples(); ++recall) {
            acc += (double)this.precision(recall) / (double)recall;
        }
        return acc / (double)this.numSamples();
    }

    public static boolean correct(double score, int cls) {
        return score >= 0.5 && cls == 1 || score < 0.5 && cls == 0;
    }

    public static void main(String[] args) {
        BinaryHeapPriorityQueue<String> q = new BinaryHeapPriorityQueue<String>();
        q.add("bla", 2.0);
        q.add("bla3", 2.0);
        System.err.println("size of q " + q.size());
        PRCurve pr = new PRCurve("c:/data0204/precsvm", true);
        System.err.println("acc " + pr.accuracy() + " opt " + pr.optimalAccuracy() + " cwa " + pr.cwa() + " optcwa " + pr.optimalCwa());
        for (int r = 1; r <= pr.numSamples(); ++r) {
            System.err.println("optimal precision at recall " + r + " " + pr.precision(r));
            System.err.println("model precision at recall " + r + " " + pr.logPrecision(r));
        }
    }
}

