// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Created by postproc-shortwords 1.9 on 2011-04-06 13:52:48
// From command line:
//  --quad --standard --minchars=2 --mincount=2
//  --max_items_per_langscript=6000 --flatmap --rr_alloc --freq_alloc
//  --boostcloseweakerpercent=10 --indirectbits=16 --thresh=210 --v25
//  --kentries=256 --34_full
//  --remap=xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl
//  nn-Latn=>no-Latn bh-Deva=>ut-Deva mr-Deva=>ut-Deva ne-Deva=>ut-Deva
//  lg-Latn=>ut-Latn rw-Latn=>ut-Latn gd-Latn=>ut-Latn  --include=af-Latn
//  ar-Arab be-Cyrl bg-Cyrl ca-Latn cs-Latn cy-Latn da-Latn de-Latn el-Grek
//  en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn hi-Deva
//  hr-Latn hu-Latn id-Latn is-Latn is-Latn it-Latn iw-Hebr ja-Hani ko-Hani
//  lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn pl-Latn pt-Latn
//  ro-Latn ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl sv-Latn
//  sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr zh-Hani zh-TW
//  sq-Latn az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab
//  ut-Latn ut-Deva  --force_to_lang_soft --soft_cram2 --nomsidlevel
//  --shapeflatprob --langpriorpercent=10 --skipnuc --shapeforcetop
//  --shapeeventop --shapesteep2 --langcounts --writebin --list_items=120
//  /export/hda3/cld/all_text_quad_0120_sort.utf8
//
//
// See compact_lang_det.cc for usage
//
#include "encodings/compact_lang_det/cldutil.h"

static const int kQuadChromeBuildDate = 20110406;    // yyyymmdd

COMPILE_ASSERT(MONTENEGRIN == 160, k_montenegrin_changed);
COMPILE_ASSERT(EXT_NUM_LANGUAGES >= 209, k_ext_num_languages_changed);

// Nil-grams: 20 languages
//     GREEK BENGALI MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA
//     PUNJABI GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI
//     CHEROKEE SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 6 languages
//     Japanese Korean Chinese VIETNAMESE ChineseT ZHUANG

// Words/Quads/Gibberish: 52 languages in range ENGLISH..HAITIAN_CREOLE:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Ignore BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG
//     TURKISH UKRAINIAN HINDI MACEDONIAN INDONESIAN MALAY WELSH
//     ALBANIAN BELARUSIAN URDU ARABIC CATALAN BASQUE SWAHILI
//     SLOVENIAN MALTESE VIETNAMESE SLOVAK AZERBAIJANI PERSIAN
//     YIDDISH AFRIKAANS HAITIAN_CREOLE

//  ENGLISH 3456
//  DANISH 3484
//  DUTCH 3417
//  FINNISH 3487
//  FRENCH 3448
//  GERMAN 3397
//  HEBREW 3443
//  ITALIAN 3063
//  NORWEGIAN 3400
//  POLISH 3433
//  PORTUGUESE 3437
//  RUSSIAN 3467
//  SPANISH 3529
//  SWEDISH 3546
//  CZECH 3497
//  ICELANDIC 3422
//  LATVIAN 3497
//  LITHUANIAN 3458
//  ROMANIAN 3465
//  HUNGARIAN 3520
//  ESTONIAN 3430
//  Ignore 6663
//  BULGARIAN 3486
//  CROATIAN 3470
//  SERBIAN 6873
//  IRISH 3469
//  GALICIAN 616
//  TAGALOG 3262
//  TURKISH 3453
//  UKRAINIAN 3465
//  HINDI 3426
//  MACEDONIAN 3437
//  BENGALI 3498
//  INDONESIAN 3328
//  MALAY 3405
//  WELSH 3438
//  ALBANIAN 3500
//  BELARUSIAN 3431
//  URDU 3457
//  ARABIC 3463
//  CATALAN 3422
//  BASQUE 3475
//  SWAHILI 3425
//  SLOVENIAN 3475
//  MALTESE 3432
//  VIETNAMESE 3483
//  SLOVAK 3396
//  AZERBAIJANI 3502
//  PERSIAN 3460
//  YIDDISH 3436
//  AFRIKAANS 3455
//  HAITIAN_CREOLE 3417


static const int kQuadChromeSize = 65536;    // Bucket count
static const int kQuadChromeKeyMask = 0xffff0000;    // Mask hash key

// Of 1187812 offered items (into 262144 table entries):
// 182469 filled (15%), 345 merged (0%), 131090 dropped (11%)
// 873908 items ignored: over --max_items_per_langscript
static const cld::IndirectProbBucket4 kQuadChrome[kQuadChromeSize] = {
  // key[4], words[4] in UTF-8
  // value[4]
  { {0xe9da0001, 0x7c2e0002, 0x394a0003, 0x00000000}},  // [000] вка_, ssbr, _pcbs_,
  { {0x20070004, 0xbddb0005, 0x7bc40006, 0x00000000}},  //   _kuni_, stèr, sniu,
  { {0x65630007, 0xddc40008, 0x7c2e0009, 0x00000000}},  //   denh, _križ, qsbr,
  { {0x27ed000a, 0x63bb000b, 0x2007000c, 0x00000000}},  //   _chen_, jiun, _muni_,
  { {0x2007000d, 0x63a9000e, 0x27ed000f, 0x00000000}},  //   _luni_, dhen, _dhen_,
  { {0xef1f0010, 0x24510011, 0x64430012, 0x00000000}},  //   tjük_, _bơm_, funi,
  { {0x64430013, 0x24510011, 0x28160014, 0x00000000}},  //   guni, _cơm_, _خوزس,
  { {0x63bb0015, 0x63a90016, 0xef1f0010, 0x00000000}},  //   giun, ghen, rjük_,
  { {0x36670017, 0x65630018, 0x443c0019, 0x00000000}},  //   _като_, benh, srv_,
  { {0x6443001a, 0x2007001a, 0x6f04001b, 0x00000000}},  //   buni, _buni_, _agic,
  { {0x6f0f001c, 0x2b9c001d, 0x7528001e, 0x00000000}},  //   tccc, _tích_, _iedz,
  { {0x63a9001f, 0x63bb001a, 0x20070020, 0x00000000}},  //   chen, ciun, _duni_,
  { {0x69dc0021, 0x20000022, 0x6d470023, 0x00000000}},  //   _okre, _diii_, tgja,
  { {0x75280024, 0x71730025, 0x20070026, 0x00000000}},  //   _jedz, _وهنا, _funi_,
  { {0x75280027, 0x6d470028, 0x212c0029, 0x00000000}},  //   _medz, rgja, madh_,
  { {0x212c002a, 0x69c5002b, 0x6d41000c, 0x00000000}},  //   ladh_, wnhe, ólab,
  { {0xafb8002c, 0x6443002d, 0x6b8d002e, 0x00000000}},  // [010] _خطوط_, zuni, rjag,
  { {0x212c002a, 0x63bb001a, 0x63a9002f, 0x00000000}},  //   nadh_, ziun, zhen,
  { {0x65630030, 0x27ed0031, 0x69d70032, 0x00000000}},  //   venh, _phen_, roxe,
  { {0x212c0033, 0x64430034, 0x63bb0035, 0x00000000}},  //   hadh_, vuni, xiun,
  { {0x75280036, 0xd6ab0025, 0x672b0037, 0x00000000}},  //   _bedz, خدام_, ragj,
  { {0x27ed0038, 0x26df0020, 0x672b0023, 0x00000000}},  //   _when_, _vyuo_, sagj,
  { {0x27ed0038, 0x65630039, 0x63bb000d, 0x00000000}},  //   _then_, renh, tiun,
  { {0x6563003a, 0xb385003b, 0x7e6d003c, 0x00000000}},  //   senh, слил, _osap,
  { {0x6563003d, 0x6443003e, 0x63a9003f, 0x00000000}},  //   penh, suni, rhen,
  { {0x212c002a, 0x63bb0040, 0x63a90041, 0x00000000}},  //   gadh_, siun, shen,
  { {0xddc40042, 0x7e6d0032, 0x2a690043, 0x00000000}},  //   _priž, _asap, hwab_,
  { {0x6601002d, 0x06ae0044, 0x44250045, 0x00000000}},  //   _hilk, _ছুটি, _iwl_,
  { {0x66010046, 0x7e6d0047, 0x212c0048, 0x00000000}},  //   _kilk, _csap, badh_,
  { {0x212c002a, 0xb2760049, 0x2000004a, 0x00000000}},  //   cadh_, _לענג_, _wiii_,
  { {0x1015004b, 0xfce6004c, 0xdca3004d, 0x00000000}},  //   _ابتد, сово, пари,
  { {0x69dc004e, 0xee3f004f, 0x6e240050, 0x00000000}},  //   _skre, brý_, _twib,
  { {0x6d410051, 0xddc4002b, 0x00000000, 0x00000000}},  // [020] ólac, _kriż,   ,
  { {0x66010052, 0x44250053, 0x00000000, 0x00000000}},  //   _nilk, _owl_,   ,
  { {0x7528001e, 0x4d7b0049, 0x00000000, 0x00000000}},  //   _redz, _ערטע,   ,
  { {0xbb860054, 0x06d10055, 0x66090056, 0x00000000}},  //   _الحي, ়েছি, _buek,
  { {0x65940057, 0x212c0058, 0x6601002d, 0x00000000}},  //   жалу, yadh_, _bilk,
  { {0xdb16000c, 0x69dc0059, 0xdb0d000c, 0x00000000}},  //   ábær, _ukre, lnað,
  { {0xe644005a, 0xb8960025, 0x4425005b, 0x00000000}},  //   ğlığ, _الزع, _cwl_,
  { {0x5214005c, 0xe644005d, 0x5398005e, 0x00000000}},  //   одит, şlığ, рвия_,
  { {0x6fc8005f, 0x212c0060, 0x00000000, 0x00000000}},  //   rıcl, tadh_,   ,
  { {0x26f60061, 0x44250048, 0xddcd0062, 0x00000000}},  //   ेशीर_, _fwl_, _krať,
  { {0x212c002a, 0xdb0d000c, 0x74130063, 0x00000000}},  //   radh_, knað, _فولا,
  { {0x212c0051, 0x66010064, 0x7f9f0065, 0x00000000}},  //   sadh_, _zilk, _këqi,
  { {0x212c0051, 0xddc40066, 0x00000000, 0x00000000}},  //   padh_, _friż,   ,
  { {0xa2c50067, 0xddc40066, 0x9f490068, 0x00000000}},  //   ापर्, _griż, _thaï_,
  { {0x79950046, 0x5ba70069, 0x63b90016, 0x00000000}},  //   _rozw, браз, _ymwn,
  { {0x2d8c0002, 0xdb0d000c, 0x00000000, 0x00000000}},  //   öder_, gnað,   ,
  { {0x79950046, 0x7e6d006a, 0x6815006b, 0x00000000}},  // [030] _pozw, _usap, _işdə,
  { {0x5a34004c, 0x6729006c, 0x00000000, 0x00000000}},  //   янут, _seej,   ,
  { {0xe719006d, 0x00000000, 0x00000000, 0x00000000}},  //   ليات_,   ,   ,
  { {0x66010030, 0xe00b006e, 0x00000000, 0x00000000}},  //   _silk, _संसद_,   ,
  { {0x6601006f, 0xd2460070, 0x44250071, 0x00000000}},  //   _pilk, _تن_, _swl_,
  { {0xcfcf0044, 0x44150072, 0x00000000, 0x00000000}},  //   রতিন, офит,   ,
  { {0x66010073, 0xddc40066, 0x67290074, 0x00000000}},  //   _vilk, _rriż, _teej,
  { {0x66010075, 0xe3b10076, 0x13090077, 0x00000000}},  //   _wilk, برت_, шний_,
  { {0x66010078, 0xb5fd0079, 0x6609006c, 0x00000000}},  //   _tilk, _apše, _uuek,
  { {0x11d60025, 0x00000000, 0x00000000, 0x00000000}},  //   يوية_,   ,   ,
  { {0xe2a8007a, 0x98b8005d, 0x00000000, 0x00000000}},  //   لاین_, _yarı_,   ,
  { {0x14d6007b, 0x2259007c, 0x31650045, 0x00000000}},  //   _וועל_, _виды_, selz_,
  { {0xc8e6007d, 0x00000000, 0x00000000, 0x00000000}},  //   _कर्म_,   ,   ,
  { {0xa0a5007e, 0x853c007f, 0x00000000, 0x00000000}},  //   _малд, _alėj,   ,
  { {0x09c40055, 0x3b960080, 0x8b960081, 0x00000000}},  //   ্তমা, ојат, орач,
  { {0xe8e00082, 0x00000000, 0x00000000, 0x00000000}},  //   liệu_,   ,   ,
  { {0xdb0d000c, 0x891a0025, 0x00000000, 0x00000000}},  // [040] rnað, لغاز_,   ,
  { {0x2b580014, 0x98b8005a, 0xbc660083, 0x00000000}},  //   _گیرد_, _sarı_, _двок,
  { {0xc8ca0084, 0xd90d0014, 0x00000000, 0x00000000}},  //   جوان_, ایف_,   ,
  { {0x81c10044, 0x00000000, 0x00000000, 0x00000000}},  //   ূতি_,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x2a620085, 0x00000000, 0x00000000, 0x00000000}},  //   _ipkb_,   ,   ,
  { {0x07a60086, 0x6d5e0087, 0x00000000, 0x00000000}},  //   _давн, _mbpa,   ,
  { {0x81e70044, 0xd3260088, 0x00000000, 0x00000000}},  //   _মূল_, цьки,   ,
  { {0xdcfe0089, 0x6722008a, 0x9f400048, 0x00000000}},  //   _kopē, mboj, _fhiú_,
  { {0xd257008b, 0x27e6008c, 0xdb230051, 0x00000000}},  //   іцы_, llon_, árúc,
  { {0x2018008d, 0xdb060010, 0x26100011, 0x00000000}},  //   ëri_, _elké, _hào_,
  { {0x75ed008e, 0x45220044, 0x00000000, 0x00000000}},  //   púzc, _নাটক_,   ,
  { {0xd2500025, 0xa2d60014, 0x2018008f, 0x00000000}},  //   _أنت_, _بيشت, ūri_,
  { {0x27e60090, 0x99890087, 0x26100082, 0x00000000}},  //   hlon_, ksaš_, _mào_,
  { {0x26100011, 0x27e60091, 0x2ca50092, 0x00000000}},  //   _lào_, klon_, áld_,
  { {0x2a620093, 0xdb1f0023, 0x76420094, 0x00000000}},  //   _bpkb_, miqë, kroy,
  { {0x2610001d, 0x291c006b, 0x27e60016, 0x00000000}},  // [050] _nào_, ıvan_, dlon_,
  { {0xceb20049, 0x76420095, 0x00000000, 0x00000000}},  //   _ניי_, droy,   ,
  { {0x27e60096, 0x00000000, 0x00000000, 0x00000000}},  //   flon_,   ,   ,
  { {0x26100011, 0x27e60016, 0xf0930097, 0x00000000}},  //   _bào_, glon_, ונע_,
  { {0xff7c0049, 0x79a70098, 0x26100082, 0x00000000}},  //   יטאמ, _дрве, _cào_,
  { {0x5a340099, 0x9964009a, 0xbafa009b, 0x00000000}},  //   _інст, _отсл, _להרש,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xd90e009c, 0x00000000, 0x00000000, 0x00000000}},  //   _لیے_,   ,   ,
  { {0x7642009d, 0x26100082, 0xe1f2009e, 0x00000000}},  //   croy, _gào_, کسٹ_,
  { {0xd6c60014, 0x14190025, 0x661b008a, 0x00000000}},  //   _عملی, _هيئة_, _ituk,
  { {0x3cdb006e, 0x00000000, 0x00000000, 0x00000000}},  //   _खुले_,   ,   ,
  { {0x6d41009f, 0xc4d200a0, 0xe3b30084, 0x00000000}},  //   ólan, _אגב_, _غرض_,
  { {0x26100011, 0x64df0061, 0xb2c700a1, 0x00000000}},  //   _xào_, _पुतळ, _بغاو,
  { {0xdd9200a2, 0x427a00a3, 0x661b0020, 0x00000000}},  //   روز_, _לאנג, _mtuk,
  { {0x27e600a4, 0xa0a5005e, 0x0c7900a5, 0x00000000}},  //   ylon_, _хайд, осты_,
  { {0xbebb0023, 0x5f7600a6, 0x673b0026, 0x00000000}},  //   mbën, _رابر, _nduj,
  { {0x661b00a7, 0xeb9700a8, 0x4a46007e, 0x00000000}},  // [060] _ntuk, чит_, янав,
  { {0x26100011, 0xfa490025, 0x7e640058, 0x00000000}},  //   _rào_, تشفى_, _ipip,
  { {0x661b00a9, 0x26100082, 0xfce600aa, 0x00000000}},  //   _atuk, _sào_, _хоно,
  { {0x2d9a00ab, 0x6d5c00ac, 0xe737004d, 0x00000000}},  //   _hope_, lfra, зец_,
  { {0x67220089, 0xd90d00a1, 0xf99100a1, 0x00000000}},  //   rboj, ایہ_, ربے_,
  { {0x261000ad, 0x6d4e00ae, 0x6d5c005f, 0x00000000}},  //   _vào_, ngba, nfra,
  { {0x27e600af, 0x7e640009, 0x661b00b0, 0x00000000}},  //   plon_, _lpip, _etuk,
  { {0x69de00b1, 0x764200b2, 0xa85700b3, 0x00000000}},  //   lope, proy, _מילה_,
  { {0x41e6007e, 0x644300b4, 0x04fe0044, 0x00000000}},  //   зіна, arni, ুরের_,
  { {0x69de00b0, 0x6d4e00b5, 0x56370049, 0x00000000}},  //   nope, jgba, _מאמע_,
  { {0xf99300b6, 0x6d5c00b7, 0xe8df0011, 0x00000000}},  //   תרת_, dfra, _trục_,
  { {0xd36f00b8, 0x69de00b9, 0x6d4e00ba, 0x00000000}},  //   _مهم_, hope, egba,
  { {0xe3b3007b, 0x69de00bb, 0x6d5c00bc, 0x00000000}},  //   _אױף_, kope, ffra,
  { {0x72eb00bd, 0x6d5c00be, 0x00000000, 0x00000000}},  //   _פֿאַ, gfra,   ,
  { {0xd5c800ad, 0x645800bf, 0x5ba700c0, 0x00000000}},  //   yền_, ntvi, праз,
  { {0x6d4e00c1, 0xc1780006, 0x6d5c0048, 0x00000000}},  //   agba, ldė_, afra,
  { {0xb99900c2, 0xdcfd00c3, 0xdb0d00c4, 0x00000000}},  // [070] овах_, ızıs, nhaé,
  { {0x5c0700c5, 0x69de007f, 0x644300c6, 0x00000000}},  //   _няма, gope, yrni,
  { {0x3ea6001e, 0x661b00c7, 0xa3be0061, 0x00000000}},  //   _ļoti_, _stuk, ुचा_,
  { {0x64430059, 0x2d9a0032, 0xdc360049, 0x00000000}},  //   vrni, _zope_, _קארט_,
  { {0x69de0035, 0x7bdf004a, 0xb5fd00c8, 0x00000000}},  //   bope, moqu, _apša,
  { {0x7bdf00c9, 0x644300ca, 0x645800cb, 0x00000000}},  //   loqu, trni, ftvi,
  { {0x64580039, 0xbddb0068, 0x644300cc, 0x00000000}},  //   gtvi, yrèn, urni,
  { {0x7bcd00cd, 0x644300ce, 0x22150069, 0x00000000}},  //   nnau, rrni, мфор,
  { {0x6d5c0016, 0x661b0020, 0xd11e0061, 0x00000000}},  //   yfra, _utuk, _म्हण_,
  { {0x7bcd00cf, 0x644300d0, 0x10a500d1, 0x00000000}},  //   hnau, prni, дион,
  { {0x54550001, 0x7e640026, 0x645800d2, 0x00000000}},  //   _цвет, _spip, ctvi,
  { {0xd24e00d3, 0x201800d4, 0xe29100a2, 0x00000000}},  //   دنی_, íria_, _لذت_,
  { {0x6d5c00d5, 0x69de0020, 0x7bdf00d6, 0x00000000}},  //   tfra, yope, doqu,
  { {0x90c500d7, 0x7ae600d8, 0x69de00d9, 0x00000000}},  //   _обле, _rykt, xope,
  { {0xfce300da, 0x6d5c00db, 0x7bdf00dc, 0x00000000}},  //   воро, rfra, foqu,
  { {0x6d5c00dd, 0x8ffa0014, 0x69de00de, 0x00000000}},  //   sfra, _برتر_, wope,
  { {0x69de0056, 0x2d9a008e, 0x6d5c00df, 0x00000000}},  // [080] tope, _tope_, pfra,
  { {0x7bcd00d9, 0x764b00e0, 0x200e0022, 0x00000000}},  //   anau, dugy, _yufi_,
  { {0x8b2600e1, 0xeb9a00e2, 0x7bdf00c4, 0x00000000}},  //   _одне, _дин_, boqu,
  { {0x46ea00e3, 0x69de00b0, 0x7bdf009d, 0x00000000}},  //   оден_, sope, coqu,
  { {0x69de00e4, 0xe67700e5, 0x00000000, 0x00000000}},  //   pope, _aţâţ,   ,
  { {0x645800e6, 0x644a00e7, 0x28d900e8, 0x00000000}},  //   ttvi, tufi, _बुकि,
  { {0xd90d00e9, 0x799c005b, 0x645800ea, 0x00000000}},  //   _ایم_, _iorw, utvi,
  { {0x645800eb, 0xc27400ec, 0x02a600ed, 0x00000000}},  //   rtvi, елиј, дром,
  { {0x645800ee, 0x200e00ef, 0x6aa400f0, 0x00000000}},  //   stvi, _sufi_, nyif,
  { {0xb5aa0025, 0x2fc000f1, 0xc178007f, 0x00000000}},  //   _بارك_, _amig_, udė_,
  { {0x799c005b, 0x7bcd0068, 0xc1780006, 0x00000000}},  //   _morw, ynau, rdė_,
  { {0x2d9e00f2, 0x733600f3, 0xdce50027, 0x00000000}},  //   öten_, _آرائ, _pohľ,
  { {0x799c0007, 0x7bdf00f4, 0x69cb0010, 0x00000000}},  //   _oorw, voqu, égek,
  { {0x29070006, 0x200e00f5, 0x320700f6, 0x00000000}},  //   žnai_, _tufi_, _giny_,
  { {0x7bdf00f7, 0x00000000, 0x00000000, 0x00000000}},  //   toqu,   ,   ,
  { {0x62820004, 0x26ee007d, 0x660800f8, 0x00000000}},  //   _kroo, _जरूर_, _lidk,
  { {0x7bcd00f4, 0x7bdf009d, 0xdee7006d, 0x00000000}},  // [090] rnau, roqu, _تأثي,
  { {0xf99300f9, 0x6e2d0009, 0xdb0d009d, 0x00000000}},  //   خبر_, _iwab, chaî,
  { {0x20090093, 0x7bdf00fa, 0x00000000, 0x00000000}},  //   _kiai_, poqu,   ,
  { {0x6e2d00fb, 0x6aa40045, 0x764b00e0, 0x00000000}},  //   _kwab, byif, tugy,
  { {0x799c00ab, 0x68e70036, 0x00000000, 0x00000000}},  //   _forw, _wyjd,   ,
  { {0xba430006, 0x442c0022, 0x799c0016, 0x00000000}},  //   žįst, _bwd_, _gorw,
  { {0x76590016, 0x645c006c, 0x69c50052, 0x00000000}},  //   stwy, _äril, mihe,
  { {0x6f0d00fc, 0x7c3a00fd, 0x628200fe, 0x00000000}},  //   _ngac, átri, _broo,
  { {0x020500d7, 0x09c40044, 0x6b9d00ff, 0x00000000}},  //   нзин, ্তরা, _mosg,
  { {0x62820100, 0x6f0d0101, 0xe5c40102, 0x00000000}},  //   _droo, _agac, _исхо,
  { {0x62820103, 0xf9920104, 0x444500a1, 0x00000000}},  //   _eroo, ארי_, _سراہ,
  { {0x6e2d0009, 0x69c50105, 0x62820056, 0x00000000}},  //   _bwab, hihe, _froo,
  { {0xee370106, 0x62820100, 0x614500d7, 0x00000000}},  //   ння_, _groo, _зела,
  { {0x7c220107, 0x4cc10044, 0x6f0d00f6, 0x00000000}},  //   _čorb, _শুধু, _egac,
  { {0x61e10108, 0x6b9d002d, 0x69c500e0, 0x00000000}},  //   moll, _bosg, dihe,
  { {0x63a90109, 0xddcd010a, 0x20090011, 0x00000000}},  //   nken, _graž, _giai_,
  { {0x799c010b, 0x6e2d0045, 0x63a9010c, 0x00000000}},  // [0a0] _porw, _gwab, iken,
  { {0x61e1010d, 0x63a9010e, 0x00000000, 0x00000000}},  //   noll, hken,   ,
  { {0x799c010f, 0x5746004d, 0x6aa40022, 0x00000000}},  //   _vorw, енеб, syif,
  { {0x61e100b0, 0x1bba0076, 0x63a900b5, 0x00000000}},  //   holl, _راجع_, jken,
  { {0x61e10110, 0x63a90030, 0x99800006, 0x00000000}},  //   koll, dken, usių_,
  { {0x442c0111, 0x63a90112, 0x224d0032, 0x00000000}},  //   _pwd_, eken, duek_,
  { {0x18670113, 0x61e100b0, 0x63a900d9, 0x00000000}},  //   _пари_, doll, fken,
  { {0x62820114, 0x645c006c, 0x00000000, 0x00000000}},  //   _proo, _ärim,   ,
  { {0x61e1001c, 0x6d41000c, 0x660800ea, 0x00000000}},  //   foll, ólak, _tidk,
  { {0xbddb0115, 0x62820116, 0x6e2d0117, 0x00000000}},  //   trèm, _vroo, _rwab,
  { {0x6e2d002b, 0xddcd00b9, 0x316c0089, 0x00000000}},  //   _swab, _praž, redz_,
  { {0x645a005f, 0x63a9010f, 0xd4690054, 0x00000000}},  //   _iqti, cken, _تحكم_,
  { {0x71a6008b, 0x657a010f, 0x61e1006c, 0x00000000}},  //   _падз, _kath, boll,
  { {0x61e10118, 0xd12f007a, 0x40940025, 0x00000000}},  //   coll, _همه_, _للتر,
  { {0xddcd0119, 0x6b9d011a, 0x6280011b, 0x00000000}},  //   _traž, _posg, lvmo,
  { {0x657a011c, 0x6e2d011d, 0x69c50045, 0x00000000}},  //   _lath, _twab, wihe,
  { {0x245a008d, 0x3df5011e, 0xef64005e, 0x00000000}},  // [0b0] hëm_, _изис, _също,
  { {0xdb0d002a, 0x3eb3011f, 0x63a9002d, 0x00000000}},  //   mhaí, ıntı_, zken,
  { {0x69c50065, 0x63a90120, 0x00000000, 0x00000000}},  //   rihe, yken,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x8b9a009b, 0x657a00ab, 0x8a180121, 0x00000000}},  //   _חברת, _bath, _пояс_,
  { {0x657a0122, 0x65940088, 0x1a680123, 0x00000000}},  //   _cath, лачу, _سیمی_,
  { {0x657a0124, 0x61e10125, 0x63a900b0, 0x00000000}},  //   _dath, voll, tken,
  { {0xc178010a, 0x68e3010f, 0x657a0126, 0x00000000}},  //   klės_, ündu, _eath,
  { {0x63a90127, 0x61e100b0, 0x657a00ab, 0x00000000}},  //   rken, toll, _fath,
  { {0x63a90128, 0x92640025, 0x777b002d, 0x00000000}},  //   sken, اديم, _haux,
  { {0x63a90023, 0x224d0032, 0x00000000, 0x00000000}},  //   pken, suek_,   ,
  { {0x61e100b0, 0x00000000, 0x00000000, 0x00000000}},  //   soll,   ,   ,
  { {0x61e10129, 0xddcd002b, 0x657a012a, 0x00000000}},  //   poll, _fraż, _yath,
  { {0x6145012b, 0x777b0082, 0x00000000, 0x00000000}},  //   _река, _laux,   ,
  { {0xb02400ad, 0xfce6012c, 0x00000000, 0x00000000}},  //   _trườ, тово,   ,
  { {0xf4130055, 0x8e4a0025, 0x69d5012d, 0x00000000}},  //   _সবার_, _قلبك_, _ajze,
  { {0xc332012e, 0x7f77012f, 0x245a0065, 0x00000000}},  // [0c0] יון_, _יעקב_, zëm_,
  { {0xe9d70130, 0x2d950131, 0x9f4000f6, 0x00000000}},  //   вку_, _брюс, _thió_,
  { {0x657a0132, 0x777b0082, 0xdd050035, 0x00000000}},  //   _rath, _baux, ăsăt,
  { {0x657a0051, 0x7bda009d, 0xb09a0049, 0x00000000}},  //   _sath, étud, ויער,
  { {0x657a0133, 0x4991009e, 0x00000000, 0x00000000}},  //   _path, _گیلر,   ,
  { {0x245a008d, 0x645c006c, 0x7c3a0134, 0x00000000}},  //   tëm_, _ärik, štru,
  { {0x629d00f8, 0xd467003b, 0x657a0135, 0x00000000}},  //   äson, вије_, _vath,
  { {0x07a30136, 0x657a00e7, 0x245a0023, 0x00000000}},  //   _касн, _wath, rëm_,
  { {0xa6650137, 0x657a0138, 0x245a0065, 0x00000000}},  //   _مطلو, _tath, sëm_,
  { {0x657a002a, 0x601e001e, 0x909800e2, 0x00000000}},  //   _uath, _līme, евот_,
  { {0x8f350139, 0x9f35013a, 0x00000000, 0x00000000}},  //   ленц, лені,   ,
  { {0xdb0d0051, 0x1fa7013b, 0xddcd0036, 0x00000000}},  //   thaí, трог, _wraż,
  { {0x7c22013c, 0xecdb013d, 0xddcd0066, 0x00000000}},  //   _čora, _मुजफ, _traż,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xa3d6007d, 0xc1f70049, 0x3ead013e, 0x00000000}},  //   _सदा_, _שמוץ_, šet_,
  { {0x644a0051, 0x7d080010, 0x443e013f, 0x00000000}},  //   irfi, _sérü, _mvt_,
  { {0x62840006, 0x00000000, 0x00000000, 0x00000000}},  // [0d0] _šioj,   ,   ,
  { {0x4c950140, 0x443e0141, 0x23b10142, 0x00000000}},  //   _биос, _ovt_, _mája_,
  { {0x29070039, 0x98140025, 0x4cc10044, 0x00000000}},  //   äna_, لبنا, _শুরু,
  { {0x2cac0056, 0xc8640143, 0x00000000, 0x00000000}},  //   ødde_, ртфи,   ,
  { {0x499300a1, 0x443e0144, 0x7bda009d, 0x00000000}},  //   _پیار, _avt_, étue,
  { {0x6d5500b5, 0x601e0089, 0xf4830014, 0x00000000}},  //   ngza, _zīme, لاعی,
  { {0x69d80061, 0xe894007c, 0x00000000, 0x00000000}},  //   _मदती, _карь,   ,
  { {0x29070006, 0x58d40131, 0x2a790145, 0x00000000}},  //   žnas_, _тост, _kssb_,
  { {0x443e0030, 0x644a0066, 0xdb060146, 0x00000000}},  //   _evt_, arfi, _elkæ,
  { {0xdb040051, 0x443e0056, 0x00000000, 0x00000000}},  //   thiú, _fvt_,   ,
  { {0xcea9007b, 0x8fa6005e, 0x443e00c4, 0x00000000}},  //   _צי_, гане, _gvt_,
  { {0x26190082, 0x01c800a1, 0xdb0f0068, 0x00000000}},  //   _kèo_, _یونٹ_, _ulcè,
  { {0xe1ee0147, 0x2bc6006e, 0x00000000, 0x00000000}},  //   _гг_, रोफा,   ,
  { {0x26190011, 0x00000000, 0x00000000, 0x00000000}},  //   _mèo_,   ,   ,
  { {0x225f0148, 0xbb460140, 0x26190082, 0x00000000}},  //   ltuk_, левк, _lèo_,
  { {0xc05200b6, 0x39430009, 0x3a220022, 0x00000000}},  //   _הזה_, _adjs_, _ptkp_,
  { {0x225f0149, 0x26190082, 0x00000000, 0x00000000}},  // [0e0] ntuk_, _nèo_,   ,
  { {0x6e24014a, 0x8d56003b, 0x44270022, 0x00000000}},  //   _itib, _стич, kpn_,
  { {0xdca600d7, 0x395800fa, 0x31360049, 0x00000000}},  //   _сани, _vcrs_, רנעם_,
  { {0x26190082, 0x225f014b, 0xfaff0023, 0x00000000}},  //   _bèo_, ktuk_, _ibën_,
  { {0x443e0039, 0xe5c6014c, 0xe5a6014d, 0x00000000}},  //   _svt_, лско, лиди,
  { {0x443e014e, 0x2816007a, 0x6e2400e7, 0x00000000}},  //   _pvt_, _موسس, _mtib,
  { {0xdd32006b, 0x644a014f, 0x00000000, 0x00000000}},  //   zəşt, urfi,   ,
  { {0x7f440065, 0x644a0150, 0x722a007c, 0x00000000}},  //   _ndiq, rrfi, нцов_,
  { {0x27e60007, 0x6e240061, 0x8556004b, 0x00000000}},  //   moon_, _ntib, _مخاط,
  { {0x27e600b0, 0xd6cf0151, 0x104a0152, 0x00000000}},  //   loon_, _عقل_, нями_,
  { {0xe7b80061, 0x94260153, 0x6e240154, 0x00000000}},  //   _आताप, _смее, _atib,
  { {0x27e60155, 0x2a600156, 0x00000000, 0x00000000}},  //   noon_, ktib_,   ,
  { {0x44ce006b, 0x00000000, 0x00000000, 0x00000000}},  //   _hə_,   ,   ,
  { {0x63a2006c, 0x27e60157, 0x3cb5007e, 0x00000000}},  //   _hoon, hoon_, айгр,
  { {0x63a2006c, 0x27e60158, 0x6e24006b, 0x00000000}},  //   _koon, koon_, _etib,
  { {0x764b0159, 0x63a2015a, 0x44ce006b, 0x00000000}},  //   yrgy, _joon, _mə_,
  { {0x38c900a1, 0x27e60058, 0x44ce006b, 0x00000000}},  // [0f0] ھائی_, doon_, _lə_,
  { {0x63a2015b, 0x2bc6013d, 0x60d30089, 0x00000000}},  //   _loon, रोबा, ņemš,
  { {0x44ce005f, 0x27e6015c, 0x6d45015d, 0x00000000}},  //   _nə_, foon_, _idha,
  { {0x63a2006a, 0xbddb00f4, 0x205700a0, 0x00000000}},  //   _noon, ssèd, ריאל_,
  { {0x69cb0010, 0x6e2400fa, 0xbb3a00a0, 0x00000000}},  //   éges, _xtib, _בערי,
  { {0xce38009b, 0x7e6d015e, 0x9f42015f, 0x00000000}},  //   נאות_, _mpap, roké_,
  { {0x63a20160, 0x9f420161, 0x6d450162, 0x00000000}},  //   _boon, soké_, _mdha,
  { {0x44ce0163, 0xc245003b, 0x225f0010, 0x00000000}},  //   _də_, аник, ttuk_,
  { {0xa3d60164, 0x6d450165, 0x63a2010e, 0x00000000}},  //   _सदर_, _odha, _doon,
  { {0xb5fd0166, 0xf4850167, 0x7dc9012d, 0x00000000}},  //   _opši, _پائی, džso,
  { {0x225f0168, 0x7e6d0169, 0xf07600a1, 0x00000000}},  //   stuk_, _apap, لیوں_,
  { {0x6d45016a, 0x63a2016b, 0x9989016c, 0x00000000}},  //   _adha, _goon, jsaž_,
  { {0x7c25016d, 0x69c7016e, 0x7f440023, 0x00000000}},  //   _athr, _omje, _vdiq,
  { {0x63a200bb, 0x44ce006b, 0x27e6016f, 0x00000000}},  //   _zoon, _yə_, zoon_,
  { {0x7e6d0170, 0x417400a2, 0x30790049, 0x00000000}},  //   _epap, _دانس, _יאַנ,
  { {0x44250171, 0x4b26007e, 0x63a20082, 0x00000000}},  //   _mtl_, рмав, _xoon,
  { {0x44250172, 0x3f920058, 0x98b10173, 0x00000000}},  // [100] _ltl_, _inyu_, _dezč_,
  { {0x27e6015c, 0x644100b9, 0xd946005c, 0x00000000}},  //   woon_, _ovli, режи,
  { {0x27e600b0, 0xe73a0174, 0xb6070089, 0x00000000}},  //   toon_, вее_, _mašī,
  { {0xb6cb00a1, 0xd62a0175, 0xbebb0065, 0x00000000}},  //   ھانے_, воде_, rbëv,
  { {0x27e6006a, 0x64410039, 0x63a20082, 0x00000000}},  //   roon_, _avli, _roon,
  { {0xbebb008d, 0x27e60176, 0x44250177, 0x00000000}},  //   mbët, soon_, _btl_,
  { {0x44250061, 0x27e600b0, 0x63a20178, 0x00000000}},  //   _ctl_, poon_, _poon,
  { {0x44ce0163, 0x44250179, 0x3266017a, 0x00000000}},  //   _və_, _dtl_, атов,
  { {0x6441014a, 0xe57a003b, 0x4425017b, 0x00000000}},  //   _evli, _иза_, _etl_,
  { {0x63a2017c, 0x44ce006b, 0xdce700b4, 0x00000000}},  //   _woon, _tə_, leją,
  { {0x63a2017d, 0x00000000, 0x00000000, 0x00000000}},  //   _toon,   ,   ,
  { {0x224d017e, 0xc477009b, 0x232a017f, 0x00000000}},  //   brek_, _כתבו_, _роди_,
  { {0x539b0104, 0x44250026, 0xef1f0180, 0x00000000}},  //   _שידו, _ztl_, rcü_,
  { {0xdb0d0181, 0x4425014a, 0x00000000, 0x00000000}},  //   lhaç, _ytl_,   ,
  { {0xab95003b, 0xd1380036, 0x00000000, 0x00000000}},  //   бављ, ając_,   ,
  { {0x69c70182, 0x5b15003b, 0xdb0d00c4, 0x00000000}},  //   _smje, смат, nhaç,
  { {0x2bc60183, 0x2fc90096, 0x6d41000c, 0x00000000}},  // [110] रोधा, _imag_, ólas,
  { {0x6d450020, 0x2887003b, 0x61e800f8, 0x00000000}},  //   _udha, ићев, nodl,
  { {0x2fc90087, 0xcd76009b, 0x4dda009b, 0x00000000}},  //   _kmag_, _העתק_, _תחתו,
  { {0x61e80161, 0x9a870184, 0x2d830185, 0x00000000}},  //   hodl, _кугл, ldje_,
  { {0x7bcd010a, 0x44250186, 0x2d81006c, 0x00000000}},  //   miau, _stl_, _kahe_,
  { {0x69c70182, 0x2d830187, 0x7bcd010a, 0x00000000}},  //   _umje, ndje_, liau,
  { {0xf7730188, 0x58d4013b, 0x77690066, 0x00000000}},  //   _وار_, _дорт, _tbex,
  { {0x224d0007, 0x7bcd0006, 0x2d81006c, 0x00000000}},  //   trek_, niau, _lahe_,
  { {0x6aad00d4, 0x27ed0189, 0x3f800022, 0x00000000}},  //   nyaf, _iken_, _raiu_,
  { {0x224d018a, 0xddc4018b, 0x4425018c, 0x00000000}},  //   rrek_, _opiš, _ttl_,
  { {0x600a0175, 0x7bcd0006, 0x27ed018d, 0x00000000}},  //   лном_, kiau, _kken_,
  { {0x25a5018e, 0xdb0d00c4, 0x224d018f, 0x00000000}},  //   _holl_, chaç, prek_,
  { {0x2169005e, 0x25a50039, 0x4ac7013d, 0x00000000}},  //   _били_, _koll_, _रेलव,
  { {0x2d830182, 0x412600e3, 0x63bb0190, 0x00000000}},  //   gdje_, _лошо_, lhun,
  { {0x25a50191, 0x27ed0192, 0x705500a1, 0x00000000}},  //   _moll_, _oken_, _انعا,
  { {0x7bcd0006, 0x25a5006c, 0x6d41000c, 0x00000000}},  //   giau, _loll_, ólar,
  { {0x3946007e, 0xdb1d0030, 0xdb0f00c4, 0x00000000}},  // [120] йнаг, _omsæ, _alcâ,
  { {0x645c0193, 0x0d830194, 0x25a500f8, 0x00000000}},  //   _årig, _ельн, _noll_,
  { {0x6c860054, 0x7bcd0006, 0x27ff0051, 0x00000000}},  //   _الجم, biau, _bhun_,
  { {0x27ff0195, 0x7bcd0196, 0x628b0197, 0x00000000}},  //   _chun_, ciau, _orgo,
  { {0x25a50150, 0x95ca00ed, 0x6b8400f6, 0x00000000}},  //   _boll_, лука_, mdig,
  { {0x6b840073, 0x25a50129, 0x27ff002d, 0x00000000}},  //   ldig, _coll_, _ehun_,
  { {0x628b0198, 0x31cd0055, 0x61e80142, 0x00000000}},  //   _argo, রকাশ, vodl,
  { {0x63bb0199, 0x2915019a, 0x78a100d4, 0x00000000}},  //   ghun, ğdaş_, _àlva,
  { {0x1a9a007b, 0xd1300025, 0x6b84010f, 0x00000000}},  //   ריִע, ومة_, idig,
  { {0x361b019b, 0x154300c0, 0x2fc9019c, 0x00000000}},  //   _עובד, _неум, _smag_,
  { {0x9f99019d, 0x63bb0048, 0x00000000, 0x00000000}},  //   авну_, bhun,   ,
  { {0x63bb019e, 0xf8b300b6, 0x753a00b5, 0x00000000}},  //   chun, פשר_, _hetz,
  { {0x6b84019f, 0x7bcd0006, 0xddc40142, 0x00000000}},  //   ddig, viau, _spiš,
  { {0x753a001f, 0x6b8401a0, 0x0dc800d7, 0x00000000}},  //   _jetz, edig, буси_,
  { {0x2d8301a1, 0x753a01a2, 0x7bcd01a3, 0x00000000}},  //   rdje_, _metz, tiau,
  { {0x753a001f, 0xddc40059, 0x5c0701a4, 0x00000000}},  //   _letz, _vpiš, сяга,
  { {0x7bcd010a, 0x6e36018e, 0x00000000, 0x00000000}},  // [130] riau, _gwyb,   ,
  { {0x753a001f, 0x6b8401a5, 0x7bcd0006, 0x00000000}},  //   _netz, adig, siau,
  { {0x27ff0011, 0x8af0006b, 0x25a501a6, 0x00000000}},  //   _phun_, lgəl, _roll_,
  { {0x25a5001f, 0x64c3001c, 0x63bb01a7, 0x00000000}},  //   _soll_, _वेगळ, xhun,
  { {0x95990088, 0xb5fd01a8, 0xe738007e, 0x00000000}},  //   итку_, _opšt, сеі_,
  { {0x7afd01a9, 0x3c1801aa, 0x00000000, 0x00000000}},  //   _izst, _sčvi_,   ,
  { {0x25a5010f, 0x7995010f, 0x27ff0011, 0x00000000}},  //   _voll_, _inzw, _thun_,
  { {0x42250131, 0x27ed00ea, 0xb22501ab, 0x00000000}},  //   одив, _uken_, омил,
  { {0x25a501ac, 0x248c004a, 0x00000000, 0x00000000}},  //   _toll_, _erdm_,   ,
  { {0x63bb01ad, 0x628b016e, 0xdb1d000c, 0x00000000}},  //   shun, _vrgo, _umsæ,
  { {0xc952019b, 0x00e2008b, 0x6b840007, 0x00000000}},  //   ומי_, джэн, ydig,
  { {0x628b01ae, 0xe3b301af, 0x661b01b0, 0x00000000}},  //   _trgo, _عرض_, _kuuk,
  { {0x61450057, 0x333f00f4, 0x64430039, 0x00000000}},  //   _дела, maux_, lsni,
  { {0x661b01b1, 0x116701b2, 0x00000000, 0x00000000}},  //   _muuk, _طلبی_,   ,
  { {0x8fa601b3, 0x64430056, 0x661b01b4, 0x00000000}},  //   _маке, nsni, _luuk,
  { {0x333f00f4, 0x6b8401b5, 0xbebb0065, 0x00000000}},  //   naux_, udig, rbër,
  { {0x6b8401b6, 0x37cf0044, 0xba2901b7, 0x00000000}},  // [140] rdig, িকার, مسلم_,
  { {0x64430006, 0x6b8401b8, 0x00000000, 0x00000000}},  //   ksni, sdig,   ,
  { {0x2d95008b, 0xdb060065, 0x64430190, 0x00000000}},  //   _хрыс, _kokë, jsni,
  { {0x6d5c01b9, 0x753a010f, 0xbddb01aa, 0x00000000}},  //   lgra, _setz, nsèn,
  { {0x3e6401ba, 0x7c2e01bb, 0x64430089, 0x00000000}},  //   nöt_, lpbr, esni,
  { {0x6d5c01bc, 0x2738001d, 0xc7b90010, 0x00000000}},  //   ngra, ẩn_, _elő_,
  { {0xe73a01bd, 0x26360046, 0x29180059, 0x00000000}},  //   _веб_, sło_, _igra_,
  { {0x66e601be, 0x938a0072, 0x2b400051, 0x00000000}},  //   _доба, рска_, naic_,
  { {0x6d5c00ea, 0xbddb00f6, 0x00000000, 0x00000000}},  //   kgra, krèp,   ,
  { {0x23b800f4, 0x00000000, 0x00000000, 0x00000000}},  //   _déja_,   ,   ,
  { {0x6d5c00ee, 0x213e00cf, 0xdfd10025, 0x00000000}},  //   dgra, rath_, فيد_,
  { {0xa2cb001c, 0x333f00f4, 0x442e010f, 0x00000000}},  //   _तेव्, caux_, mpf_,
  { {0x645800b0, 0x2294005e, 0x213e0133, 0x00000000}},  //   luvi, _хиля, path_,
  { {0x6d5c01bf, 0xe2a900a6, 0xb5fd012d, 0x00000000}},  //   ggra, _دامن_, _upšt,
  { {0x5ba701c0, 0xe0d40049, 0x60210089, 0x00000000}},  //   ораз, _מײַ_, _tēma,
  { {0x6d5c002a, 0x291801c1, 0xc05300b3, 0x00000000}},  //   agra, _agra_, _חזק_,
  { {0x201c006c, 0x645801c2, 0x7c2e01c3, 0x00000000}},  // [150] _huvi_, huvi, apbr,
  { {0x644301c4, 0x645800b0, 0x673b0022, 0x00000000}},  //   ysni, kuvi, _seuj,
  { {0xe7190025, 0x333f009d, 0xf8b100a6, 0x00000000}},  //   ميات_, yaux_, رکس_,
  { {0x7e7d0061, 0x6c7a0049, 0x5c7a0049, 0x00000000}},  //   owsp, _פארפ, _פארה,
  { {0x333f00f4, 0x7afd001e, 0xcb9a009b, 0x00000000}},  //   vaux_, _uzst, _הסרט,
  { {0x64430039, 0x201c00c4, 0xf783002b, 0x00000000}},  //   tsni, _ouvi_, _seħħ_,
  { {0x333f00f4, 0x2246000a, 0x645801c5, 0x00000000}},  //   taux_, _avok_, guvi,
  { {0x64430089, 0x394101c6, 0x6d5c0091, 0x00000000}},  //   rsni, lahs_, zgra,
  { {0x64430039, 0x333f00f4, 0xe43000a1, 0x00000000}},  //   ssni, raux_, _یہود,
  { {0x6443010a, 0x6578014a, 0x2b4001c7, 0x00000000}},  //   psni, cevh, zaic_,
  { {0x645c006c, 0x333f00f4, 0xc9520049, 0x00000000}},  //   _ärip, paux_, עמט_,
  { {0xbebb0065, 0xb4fa009b, 0x6d5c005b, 0x00000000}},  //   rcën, _הפעי, wgra,
  { {0x3fc90014, 0x00000000, 0x00000000, 0x00000000}},  //   تگوی_,   ,   ,
  { {0x6d5c0129, 0xda1f013d, 0x00000000, 0x00000000}},  //   ugra, _बढ़त_,   ,
  { {0x9f9201c8, 0x6d5c0056, 0xdb060065, 0x00000000}},  //   lší_, rgra, _tokë,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6e460054, 0x6d5c01c9, 0x9f9201ca, 0x00000000}},  // [160] _عندم, pgra, nší_,
  { {0x2b4001cb, 0x00000000, 0x00000000, 0x00000000}},  //   saic_,   ,   ,
  { {0x9d1b00a3, 0x2b400048, 0x00000000, 0x00000000}},  //   _לויט, paic_,   ,
  { {0xdc9b0097, 0x00000000, 0x00000000, 0x00000000}},  //   _היטל,   ,   ,
  { {0x9f92004f, 0x9b17009b, 0x7f8d0049, 0x00000000}},  //   jší_, _מחכה_, ינאַ,
  { {0x6458010a, 0x8afb009b, 0x9f9201ca, 0x00000000}},  //   tuvi, _להכי, dší_,
  { {0x69ce011c, 0x80d00055, 0xdd570049, 0x00000000}},  //   _imbe, _সুন্, לבסט_,
  { {0x645800f8, 0xdb060026, 0x7d0701cc, 0x00000000}},  //   ruvi, _pokè, léré,
  { {0x201c01c2, 0xd046006b, 0x00000000, 0x00000000}},  //   _suvi_, əmək,   ,
  { {0x7d0700f4, 0x00000000, 0x00000000, 0x00000000}},  //   néré,   ,   ,
  { {0xf993009b, 0x69ce0145, 0x00000000, 0x00000000}},  //   גרת_, _mmbe,   ,
  { {0x442c01cd, 0x602800b9, 0x78fb01ce, 0x00000000}},  //   _itd_, _něme, מפיו,
  { {0x442c01cf, 0x9f4b004a, 0x9f590048, 0x00000000}},  //   _htd_, nocé_, omsú_,
  { {0x2b4b01d0, 0x442c01d1, 0x127b01ce, 0x00000000}},  //   _sdcc_, _ktd_, _לאדע,
  { {0x6b8601d2, 0x7d0700f4, 0x9f420161, 0x00000000}},  //   _bakg, déré, soká_,
  { {0x442c01d3, 0x69ce01d4, 0x3a2b0026, 0x00000000}},  //   _mtd_, _ambe, _ptcp_,
  { {0x442c01d5, 0xdcf20089, 0x394101d6, 0x00000000}},  // [170] _ltd_, īgāk, tahs_,
  { {0xceb2007b, 0x6e2d01d7, 0x291c016c, 0x00000000}},  //   _סיי_, _itab, žvan_,
  { {0x39410146, 0xf1b30049, 0xa3be013d, 0x00000000}},  //   rahs_, עסע_, ीफा_,
  { {0x69ce0047, 0x256f005a, 0x00000000, 0x00000000}},  //   _embe, zılı_,   ,
  { {0xd24601d8, 0x442c01ca, 0x644801d9, 0x00000000}},  //   _جن_, _atd_, _avdi,
  { {0xcb1200b6, 0x79e700a1, 0x93b50082, 0x00000000}},  //   _שלך_, _روزہ_, _cũn,
  { {0x62820007, 0x442c01da, 0x2409007c, 0x00000000}},  //   _asoo, _ctd_, онки_,
  { {0x442c01db, 0x9f9201dc, 0xc2e60044, 0x00000000}},  //   _dtd_, tší_, খেছি_,
  { {0x6e2d01dd, 0x442c0022, 0x2a690058, 0x00000000}},  //   _ntab, _etd_, ntab_,
  { {0x9f9201ca, 0xab5b010f, 0x442c01de, 0x00000000}},  //   rší_, _flüg, _ftd_,
  { {0xd3710054, 0x6e2d0095, 0x256f01df, 0x00000000}},  //   _لها_, _atab, rılı_,
  { {0x9f92004f, 0x2a6901a3, 0x79870173, 0x00000000}},  //   pší_, ktab_, _lajw,
  { {0xee3701e0, 0xa29401e1, 0xc61f0044, 0x00000000}},  //   мня_, _паці, নীরা_,
  { {0x79870046, 0x6e2d0051, 0x63ab01e2, 0x00000000}},  //   _najw, _dtab, _hogn,
  { {0x6e2d01e3, 0x2c8700b9, 0x6b8601c3, 0x00000000}},  //   _etab, vídá_, _pakg,
  { {0xeb9701e4, 0x6e2d0022, 0x00000000, 0x00000000}},  //   мис_, _ftab,   ,
  { {0x63a60039, 0x63ab00f8, 0xeafa0061, 0x00000000}},  // [180] ökni, _mogn, ्धेत_,
  { {0x63ab01e5, 0x00000000, 0x00000000, 0x00000000}},  //   _logn,   ,   ,
  { {0x7649009d, 0x1d0a00ed, 0x2d9a00fa, 0x00000000}},  //   _avey, _фени_, _inpe_,
  { {0xb7be0044, 0x442c00e7, 0x7d0701e6, 0x00000000}},  //   েক্ট, _rtd_, séré,
  { {0x4cd30055, 0x442c01e7, 0x47330088, 0x00000000}},  //   _দুপু, _std_, тніс,
  { {0x69ce006c, 0x442c0145, 0x00000000, 0x00000000}},  //   _umbe, _ptd_,   ,
  { {0x63ab0190, 0xb8f30044, 0x644d0089, 0x00000000}},  //   _bogn, _হু_, ņain,
  { {0x63ab01e8, 0x00000000, 0x00000000, 0x00000000}},  //   _cogn,   ,   ,
  { {0x9f55000c, 0x056601e9, 0x63ab01ea, 0x00000000}},  //   ófíl_, _ован, _dogn,
  { {0x442c0093, 0x602800b9, 0x26c6004a, 0x00000000}},  //   _ttd_, _němc, mzoo_,
  { {0x6e2d01eb, 0x395700b6, 0x63ab01ec, 0x00000000}},  //   _stab, ושים_, _fogn,
  { {0xe29a008b, 0x69de0026, 0x63ab0026, 0x00000000}},  //   _мае_, hnpe, _gogn,
  { {0x26c60146, 0xdde201ed, 0x31c601ee, 0x00000000}},  //   nzoo_, _šušk, _оскв,
  { {0xe0cf01ef, 0x25ac012d, 0x63ab0026, 0x00000000}},  //   ازی_, _jodl_, _zogn,
  { {0xdb060047, 0x7987000a, 0x00000000, 0x00000000}},  //   _elkü, _rajw,   ,
  { {0x6e2d0022, 0x2d9a01aa, 0x3eae0065, 0x00000000}},  //   _ttab, _enpe_, ëjtë_,
  { {0x6e2d0020, 0x27ef0030, 0xdb1601aa, 0x00000000}},  // [190] _utab, vogn_, nkyè,
  { {0x2a6901f0, 0x00000000, 0x00000000, 0x00000000}},  //   rtab_,   ,   ,
  { {0x2a690004, 0x22510036, 0x917b0082, 0x00000000}},  //   stab_, ązki_, _hệ_,
  { {0x2a6900de, 0x25ac00f6, 0x00000000, 0x00000000}},  //   ptab_, _aodl_,   ,
  { {0xcb36019b, 0x7987002b, 0x1fc10044, 0x00000000}},  //   _ראשי_, _tajw, _উদাস,
  { {0x63ab01f1, 0x659401f2, 0x00000000, 0x00000000}},  //   _sogn, качу,   ,
  { {0x63ab01ed, 0xd914007e, 0x672901f3, 0x00000000}},  //   _pogn, _адры, _tfej,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x645c0039, 0x63ab0030, 0xd24e006d, 0x00000000}},  //   _årin, _vogn, مني_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x63ab01f4, 0x67240161, 0x00000000, 0x00000000}},  //   _togn, žije,   ,
  { {0xd9cc01f5, 0x8fa600e2, 0x00000000, 0x00000000}},  //   _ाष्ट, хаме,   ,
  { {0xf1a80014, 0x00000000, 0x00000000, 0x00000000}},  //   سایه_,   ,   ,
  { {0x92c101f6, 0xdd9201f7, 0x7bdf00f6, 0x00000000}},  //   ığın, دوس_, enqu,
  { {0xfce30088, 0xddcd001a, 0x61e60010, 0x00000000}},  //   горо, _spaţ, ékle,
  { {0x24850026, 0x7a160173, 0x00000000, 0x00000000}},  //   _mslm_, _pņto,   ,
  { {0xc33201f8, 0xf412007b, 0x395600ed, 0x00000000}},  // [1a0] טון_, רפן_, ењет,
  { {0xac8601f9, 0x4c860088, 0xdcfe0035, 0x00000000}},  //   _згол, _злов, _capă,
  { {0xa81a01fa, 0xc172009b, 0xbb4600d7, 0x00000000}},  //   ستار_, רחב_, _пенк,
  { {0xfaa601fb, 0xe66601fc, 0x26c601fd, 0x00000000}},  //   _замо, етко, tzoo_,
  { {0x98ac005f, 0x24850022, 0xcb15007e, 0x00000000}},  //   ğlıq_, _aslm_, _афры,
  { {0xe5a301fe, 0x98ac005f, 0xa4d401ff, 0x00000000}},  //   личи, şlıq_, колі,
  { {0x6c7a0049, 0x00000000, 0x00000000, 0x00000000}},  //   לאַפ,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x66e301ab, 0x00000000, 0x00000000, 0x00000000}},  //   _бота,   ,   ,
  { {0xb5ca00a1, 0x64a60200, 0xbbad0201, 0x00000000}},  //   _عوام_, _паза, _टक्क,
  { {0xdb12000c, 0x6f040202, 0x3f8900f6, 0x00000000}},  //   _ágæt, _azic, _paau_,
  { {0x644a0203, 0x09dd0204, 0x00000000, 0x00000000}},  //   msfi, _मद्य,   ,
  { {0x661a0205, 0x644a00f8, 0x443e0146, 0x00000000}},  //   _kitk, lsfi, _hwt_,
  { {0x9f4b01dc, 0x661a0206, 0x2fc00146, 0x00000000}},  //   mocí_, _jitk, _elig_,
  { {0x661a00b0, 0x2fc00146, 0x00000000, 0x00000000}},  //   _mitk, _flig_,   ,
  { {0x7bdf0207, 0xd1380006, 0x317e0208, 0x00000000}},  //   unqu, lbą_, letz_,
  { {0x66d30047, 0x9f4b008e, 0x443e0022, 0x00000000}},  // [1b0] _műkö, nocí_, _lwt_,
  { {0x661a0209, 0xd8e70088, 0x317e010f, 0x00000000}},  //   _nitk, нцеп, netz_,
  { {0x2009020a, 0x6d470004, 0x443e020b, 0x00000000}},  //   _khai_, maja, _nwt_,
  { {0x6d47020c, 0x7bc4001a, 0x644a00eb, 0x00000000}},  //   laja, chiu, dsfi,
  { {0x661a020d, 0x6b9d010f, 0x46a40088, 0x00000000}},  //   _bitk, _insg, лаїв,
  { {0xb9070055, 0x443e020e, 0xab5b01a2, 0x00000000}},  //   _পর_, _bwt_, _flüc,
  { {0x69d7020f, 0xab5b010f, 0x644a0210, 0x00000000}},  //   mixe, _glüc, gsfi,
  { {0x6d470059, 0x443e01d6, 0xe65d014a, 0x00000000}},  //   haja, _dwt_, ştığ,
  { {0xdb0f00d4, 0x64580052, 0x74120014, 0x00000000}},  //   _alcú, arvi, جويا,
  { {0x6d470211, 0x27fd0016, 0x443e0022, 0x00000000}},  //   jaja, llwn_, _fwt_,
  { {0x6d4701d9, 0xf99200b3, 0x76590016, 0x00000000}},  //   daja, ברי_, lrwy,
  { {0x20090212, 0x69c500e0, 0x6b8d00bb, 0x00000000}},  //   _chai_, hhhe, jdag,
  { {0x63a90182, 0x93b600b6, 0x6b8d01bf, 0x00000000}},  //   mjen, _שלנו_, ddag,
  { {0x63a90213, 0x6d470214, 0x63bb0215, 0x00000000}},  //   ljen, gaja, lkun,
  { {0x22510036, 0x6da30216, 0x63a90217, 0x00000000}},  //   ązku_, шира, ojen,
  { {0x63a90213, 0x63bb0218, 0x6b8d006a, 0x00000000}},  //   njen, nkun, gdag,
  { {0x6d470219, 0x4b2301fb, 0x6f040107, 0x00000000}},  // [1c0] baja, рмув, _uzic,
  { {0x63a901c2, 0x6d470091, 0x76590016, 0x00000000}},  //   hjen, caja, drwy,
  { {0x661a0010, 0x63a9021a, 0x6e24021b, 0x00000000}},  //   _ritk, kjen, _huib,
  { {0x63bb021c, 0x6e240020, 0x2a790022, 0x00000000}},  //   jkun, _kuib, _fpsb_,
  { {0x63a9021d, 0x661a021e, 0x7659018e, 0x00000000}},  //   djen, _pitk, grwy,
  { {0x986600a1, 0xd49a0088, 0x69c5010f, 0x00000000}},  //   _لیئے_, дри_, chhe,
  { {0x63bb021f, 0x18a3005c, 0x6e240051, 0x00000000}},  //   fkun, _карм, _luib,
  { {0x63a90220, 0x61e10221, 0x63bb0222, 0x00000000}},  //   gjen, enll, gkun,
  { {0xfbd300b6, 0x2009018e, 0x661a0223, 0x00000000}},  //   יתה_, _rhai_, _titk,
  { {0xa3f50224, 0x661a00c7, 0x20090225, 0x00000000}},  //   ější_, _uitk, _shai_,
  { {0x6d4701d9, 0x63a90226, 0xd138010a, 0x00000000}},  //   vaja, bjen, rbą_,
  { {0x63bb010f, 0x317e010f, 0x6d4700f0, 0x00000000}},  //   ckun, setz_, waja,
  { {0x6d470004, 0x6e240227, 0xa1580228, 0x00000000}},  //   taja, _cuib, _залу_,
  { {0x6e240048, 0xbf9b01c3, 0x00000000, 0x00000000}},  //   _duib, dlêe,   ,
  { {0x6d470127, 0x80a300d3, 0x6b8d00c7, 0x00000000}},  //   raja, _نمون, tdag,
  { {0x5f770084, 0x6d47003c, 0x20090020, 0x00000000}},  //   _شاعر, saja, _uhai_,
  { {0x6d470229, 0xf96b022a, 0xfaff0023, 0x00000000}},  // [1d0] paja, дрей_, _ecën_,
  { {0x63bb022b, 0x6b8d0039, 0x68fc022c, 0x00000000}},  //   zkun, sdag, _byrd,
  { {0x3eb9022d, 0x6b8d0056, 0xf795007e, 0x00000000}},  //   lyst_, pdag, лажэ,
  { {0x7659018e, 0x69c50023, 0x00000000, 0x00000000}},  //   trwy, shhe,   ,
  { {0x63a9022e, 0x6d45022f, 0x69d70011, 0x00000000}},  //   vjen, _keha, pixe,
  { {0xa9340230, 0xa509017f, 0xe6180088, 0x00000000}},  //   _верш, нела_, вді_,
  { {0x7afd0016, 0x63a90231, 0x63bb000c, 0x00000000}},  //   _hyst, tjen, tkun,
  { {0x7afd01e3, 0x93bc001a, 0x6d450232, 0x00000000}},  //   _kyst, _stăr, _leha,
  { {0x63a90233, 0x63bb001f, 0x59b70067, 0x00000000}},  //   rjen, rkun, _आकार,
  { {0x63bb0234, 0x6d450235, 0x004700a1, 0x00000000}},  //   skun, _neha, نیتي_,
  { {0x0467012b, 0x63a90236, 0x7afd0030, 0x00000000}},  //   _штам, pjen, _lyst,
  { {0xdb0f0181, 0x4425001a, 0xc43a00b3, 0x00000000}},  //   _você, _iul_, _נתני,
  { {0x44250237, 0x6d450238, 0x7afd0239, 0x00000000}},  //   _hul_, _beha, _nyst,
  { {0x44250039, 0x614500ed, 0x4ed50088, 0x00000000}},  //   _kul_, _сека, рюют,
  { {0x44250018, 0x224d023a, 0x30790049, 0x00000000}},  //   _jul_, lsek_, _טאַנ,
  { {0x44250004, 0x7afd0027, 0x7dd4005f, 0x00000000}},  //   _mul_, _byst, _müsə,
  { {0x7afd0016, 0x4425023b, 0xa95a023c, 0x00000000}},  // [1e0] _cyst, _lul_, فجار_,
  { {0x6d45023d, 0x7afd010b, 0x3f82023e, 0x00000000}},  //   _geha, _dyst, leku_,
  { {0x31ba0049, 0x4425023f, 0xdb060161, 0x00000000}},  //   עזענ, _nul_, _doká,
  { {0x6d45022b, 0x224d011f, 0x3f82006c, 0x00000000}},  //   _zeha, ksek_, neku_,
  { {0x7f3b007b, 0x7afd0016, 0x68fc0016, 0x00000000}},  //   גענו, _gyst, _wyrd,
  { {0x4425011f, 0xd5b10011, 0x38610240, 0x00000000}},  //   _bul_, _có_, buhr_,
  { {0x442500f4, 0xd467003b, 0x88840241, 0x00000000}},  //   _cul_, гије_, _خیان,
  { {0x4425002a, 0x53980242, 0x3f820243, 0x00000000}},  //   _dul_, твия_, jeku_,
  { {0x6441002b, 0xbebb0065, 0x798e0244, 0x00000000}},  //   _ewli, ncët, _kabw,
  { {0x44250087, 0x6021001e, 0xc05a0245, 0x00000000}},  //   _ful_, _lēmu, нім_,
  { {0x44250193, 0x798e0246, 0x09f7009b, 0x00000000}},  //   _gul_, _mabw, רמים_,
  { {0x6d450149, 0x7c2501a2, 0x98b80006, 0x00000000}},  //   _seha, _ruhr, _gerą_,
  { {0x442500b5, 0x6d450247, 0x00000000, 0x00000000}},  //   _zul_, _peha,   ,
  { {0xbb1b00f4, 0x7afd0030, 0x798e0248, 0x00000000}},  //   _maît, _ryst, _nabw,
  { {0x48bf0044, 0x3f820032, 0x44250249, 0x00000000}},  //   _আশ্র, beku_, _xul_,
  { {0xc4c4024a, 0x7afd021e, 0x246e006b, 0x00000000}},  //   _ہے_, _pyst, _cəmi_,
  { {0x6d45006c, 0x2d85009d, 0x79d50088, 0x00000000}},  // [1f0] _teha, ôles_, ажає,
  { {0x7afd024b, 0xdcf50089, 0x00000000, 0x00000000}},  //   _vyst, udzē,   ,
  { {0x7afd0046, 0x2d830061, 0xd7c80014, 0x00000000}},  //   _wyst, meje_, گونه_,
  { {0x2d830030, 0x31e1024c, 0x7afd024d, 0x00000000}},  //   leje_, _पद्ध, _tyst,
  { {0x4425024e, 0x98aa0089, 0x64410009, 0x00000000}},  //   _sul_, ējām_, _swli,
  { {0x4425006b, 0x2d83024f, 0xf4830167, 0x00000000}},  //   _pul_, neje_, ماعی,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x44250250, 0xdb1d000c, 0xddc40251, 0x00000000}},  //   _vul_, _umsó, _spiż,
  { {0x290c0051, 0x798e0009, 0xa235007e, 0x00000000}},  //   _údar_, _yabw, шэйш,
  { {0x2d830252, 0x4425002b, 0x41b5005e, 0x00000000}},  //   jeje_, _tul_, рсит,
  { {0x2d8301ca, 0x66ca0010, 0x224d0232, 0x00000000}},  //   deje_, _töké, ssek_,
  { {0xe0d6005e, 0x52d9007c, 0x224d0022, 0x00000000}},  //   рвю_, _имею_, psek_,
  { {0x2d830253, 0x00000000, 0x00000000, 0x00000000}},  //   feje_,   ,   ,
  { {0x2d830254, 0x62990066, 0x3f820255, 0x00000000}},  //   geje_, _irwo, seku_,
  { {0xdd0e014a, 0x8c4600e2, 0x798e000a, 0x00000000}},  //   _dışa, ребе, _rabw,
  { {0xc05200b6, 0xb7b00044, 0x798e00e0, 0x00000000}},  //   _וזה_, _কষ্ট, _sabw,
  { {0x09c10044, 0xeab70256, 0x00000000, 0x00000000}},  // [200] োচনা, айт_,   ,
  { {0xfb8200a1, 0xc8960184, 0x00000000, 0x00000000}},  //   _ڈگری, ирењ,   ,
  { {0xc8ca0257, 0x00000000, 0x00000000, 0x00000000}},  //   خوان_,   ,   ,
  { {0x628b0016, 0x6e9301b2, 0x798e0258, 0x00000000}},  //   _osgo, _الیا, _wabw,
  { {0xb8fd0183, 0x6b84000c, 0xe5340259, 0x00000000}},  //   _ते_, meig, бель,
  { {0x6b84000c, 0xb866025a, 0x00000000, 0x00000000}},  //   leig, _پاسو,   ,
  { {0x92e20055, 0x26c0025b, 0x628b00f6, 0x00000000}},  //   _ধরে_, šio_, _asgo,
  { {0x6b84025c, 0x0fc10044, 0x290a025d, 0x00000000}},  //   neig, _উদ্ধ, _izba_,
  { {0x27e6025e, 0xc1a6025f, 0xe61a017f, 0x00000000}},  //   mnon_, ајни, _ада_,
  { {0x6b840260, 0xda16006e, 0x00000000, 0x00000000}},  //   heig, थगित_,   ,
  { {0x628b0261, 0x2d830262, 0xc95300b3, 0x00000000}},  //   _esgo, veje_, חמת_,
  { {0x27e6021e, 0x78a1000c, 0x248c0022, 0x00000000}},  //   nnon_, _álve, _isdm_,
  { {0x2d830263, 0x91e60264, 0x5f940265, 0x00000000}},  //   teje_, _коде, цият,
  { {0x7bc6021e, 0xa3d2006e, 0x20020266, 0x00000000}},  //   _alku, होर_, alki_,
  { {0xf2e80044, 0x70540070, 0x2d910267, 0x00000000}},  //   _পরিণ, _انبا, rdze_,
  { {0x628b018e, 0xe457007b, 0x2ba400ed, 0x00000000}},  //   _ysgo, יילט_, ојув,
  { {0x29050268, 0xac180269, 0x290a000a, 0x00000000}},  // [210] _šla_, роту_, _azba_,
  { {0x2d830023, 0x780f006e, 0x00000000, 0x00000000}},  //   qeje_, िष्क_,   ,
  { {0x63a20116, 0x6b840089, 0x6d57006b, 0x00000000}},  //   _onon, beig, _idxa,
  { {0x27e600f4, 0x20140129, 0xdc9a0049, 0x00000000}},  //   gnon_, _èxit_, _עירל,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x63a2026a, 0x7c940123, 0xdcfe00b9, 0x00000000}},  //   _anon, _اشیا, _napě,
  { {0x97a7026b, 0x05740014, 0x798500e0, 0x00000000}},  //   _крал, تاند, mehw,
  { {0xab5b006c, 0xc2450088, 0xdcfc0089, 0x00000000}},  //   _olüm, бник, nerā,
  { {0xe730026c, 0xdd2c0006, 0xe1f900d7, 0x00000000}},  //   _آصف_, vėži, лги_,
  { {0x6b84001f, 0x63a20052, 0xbec4007f, 0x00000000}},  //   zeig, _enon, šūki,
  { {0xf07600a1, 0x69c7016e, 0xab5b026d, 0x00000000}},  //   میوں_, _mlje, _alüm,
  { {0x7dc20027, 0x6299026e, 0x00000000, 0x00000000}},  //   _pôso, _trwo,   ,
  { {0x69c7026f, 0x6fc60051, 0x6b8401e5, 0x00000000}},  //   _olje, _cóca, veig,
  { {0x6b840270, 0xb6da0049, 0xa069003b, 0x00000000}},  //   weig, אַלט, _бака_,
  { {0x6b84010f, 0x27e60271, 0x7d0900b9, 0x00000000}},  //   teig, ynon_, řesn,
  { {0x69c70272, 0x6fc60048, 0x00000000, 0x00000000}},  //   _alje, _fóca,   ,
  { {0x6b840273, 0x7f3b0049, 0x69c70166, 0x00000000}},  // [220] reig, _געפו, _blje,
  { {0x6b8400f4, 0x5d860025, 0xdb0f0051, 0x00000000}},  //   seig, _الدل, _alcó,
  { {0x6d4e006a, 0x3f920169, 0x291c0274, 0x00000000}},  //   maba, _kayu_, äva_,
  { {0x6d4e006a, 0x7ae90087, 0xd62a0140, 0x00000000}},  //   laba, _žete, годе_,
  { {0x27e60275, 0xdd070276, 0x7e6600e0, 0x00000000}},  //   rnon_, _köşk, nukp,
  { {0x6d4e006a, 0x225f0277, 0x27e60278, 0x00000000}},  //   naba, druk_, snon_,
  { {0xef1f0279, 0x69de027a, 0x00000000, 0x00000000}},  //   ndür_, mipe,   ,
  { {0x69de027b, 0x6d4e027c, 0xa857009b, 0x00000000}},  //   lipe, haba, _לילה_,
  { {0x6d4e006a, 0x7dcb027d, 0xaade0061, 0x00000000}},  //   kaba, _hüse, _नेमक,
  { {0x8c000055, 0x6d4e027e, 0x69de0020, 0x00000000}},  //   ্দিন_, jaba, nipe,
  { {0x3f92008a, 0x6fc600c4, 0x63a20058, 0x00000000}},  //   _bayu_, _sóca, _tnon,
  { {0x69de001a, 0x225f01c9, 0x63a2027f, 0x00000000}},  //   hipe, bruk_, _unon,
  { {0x06bc0044, 0x394a0280, 0x3f920281, 0x00000000}},  //   _আইডি, _oebs_, _dayu_,
  { {0x30a60088, 0x3fc900a2, 0xea010011, 0x00000000}},  //   _грив, ادگی_, _đắp_,
  { {0x69de0282, 0x2a60006c, 0x61fa00f6, 0x00000000}},  //   dipe, erib_, motl,
  { {0x69c70182, 0x22460283, 0x61fa0284, 0x00000000}},  //   _slje, _kwok_, lotl,
  { {0x6d4e006a, 0x59d9007e, 0x69c70091, 0x00000000}},  // [230] baba, адаў_, _plje,
  { {0x6d4e0285, 0x7f4f0197, 0x24890036, 0x00000000}},  //   caba, lacq, łami_,
  { {0x2fc90286, 0x6d410276, 0x61e80287, 0x00000000}},  //   _klag_, ılad, indl,
  { {0x61fa0270, 0x7f4f0026, 0x2d930288, 0x00000000}},  //   hotl, nacq, _haxe_,
  { {0x7bdf0289, 0x00000000, 0x00000000, 0x00000000}},  //   miqu,   ,   ,
  { {0x7bdf00f4, 0x69de028a, 0x69c7028b, 0x00000000}},  //   liqu, cipe, _ulje,
  { {0xddcc010a, 0x9965013e, 0x22460085, 0x00000000}},  //   _žiūr, _kůži_, _awok_,
  { {0x7bdf028c, 0x6d4e028d, 0x7bcd010f, 0x00000000}},  //   niqu, zaba, nhau,
  { {0x6d4e028e, 0x27ff01d5, 0x7dcb006b, 0x00000000}},  //   yaba, _ikun_, _müsb,
  { {0x7bdf00f4, 0x6d4e028f, 0x225f01c3, 0x00000000}},  //   hiqu, xaba, rruk_,
  { {0x2fc9002a, 0x6d4e0290, 0x3a3900f6, 0x00000000}},  //   _blag_, vaba, _ltsp_,
  { {0x27ff01d5, 0x6d4e0291, 0x69de002d, 0x00000000}},  //   _jkun_, waba, zipe,
  { {0x6d4e0292, 0x7bdf028c, 0xf8a60061, 0x00000000}},  //   taba, diqu, _गप्प,
  { {0x2b4b00f6, 0x112b0088, 0x00000000, 0x00000000}},  //   _aecc_, _сюди_,   ,
  { {0x7bdf0068, 0xcfaa025a, 0x2fc900ab, 0x00000000}},  //   fiqu, _ناظم_, _flag_,
  { {0x7bdf0293, 0x6d4e0294, 0x27ed0295, 0x00000000}},  //   giqu, saba, _njen_,
  { {0xe9da012b, 0x6d4e011c, 0x2d930296, 0x00000000}},  // [240] ака_, paba, _faxe_,
  { {0x27ff0297, 0x2a600066, 0xdcf501df, 0x00000000}},  //   _akun_, rrib_, _çağr,
  { {0x32050298, 0x7bdf0299, 0x881a007e, 0x00000000}},  //   illy_, biqu, аўду_,
  { {0x394a029a, 0xeb9a029b, 0x7bcd029c, 0x00000000}},  //   _webs_, _тим_, chau,
  { {0xacf60014, 0x00000000, 0x00000000, 0x00000000}},  //   _دسکت,   ,   ,
  { {0x69de008d, 0xfc4b00b9, 0xfe9b00a3, 0x00000000}},  //   qipe, říž_, יינמ,
  { {0x69dc0051, 0x602800b9, 0xa7860025, 0x00000000}},  //   _imre, _těmi, _وشرو,
  { {0x78a1029d, 0xa3ba0025, 0x27ed0065, 0x00000000}},  //   _álva, شاعر_, _gjen_,
  { {0x69dc0022, 0x6f040022, 0x61fa029e, 0x00000000}},  //   _kmre, _nyic, totl,
  { {0x61e8010f, 0x7bcd029f, 0x2000004a, 0x00000000}},  //   undl, zhau, _akii_,
  { {0xdb0f02a0, 0x6f0d0036, 0x399b0049, 0x00000000}},  //   _rocí, _szac, בייד,
  { {0x9325007a, 0x32050038, 0x7bdf00f4, 0x00000000}},  //   _فرهن, ally_, xiqu,
  { {0x6b96018e, 0x69dc02a1, 0x2fc90116, 0x00000000}},  //   ddyg, _omre, _vlag_,
  { {0x72e90049, 0x442c00ca, 0x7f4f0026, 0x00000000}},  //   _פֿײַ, _kud_, sacq,
  { {0x7bdf02a2, 0x442c001a, 0x7bcd010f, 0x00000000}},  //   tiqu, _jud_, thau,
  { {0x5a350072, 0x69dc0016, 0x7bcd02a3, 0x00000000}},  //   знат, _amre, uhau,
  { {0x7bdf028c, 0x7bcd010f, 0x2d9302a4, 0x00000000}},  // [250] riqu, rhau, _taxe_,
  { {0x7bdf0293, 0x7bcd02a5, 0x442c01b5, 0x00000000}},  //   siqu, shau, _oud_,
  { {0x7bdf00f4, 0x442c02a6, 0x48ab02a7, 0x00000000}},  //   piqu, _nud_, штам_,
  { {0x201901aa, 0x6e2d00e7, 0x69dc0095, 0x00000000}},  //   nmsi_, _kuab, _emre,
  { {0xd6db02a8, 0x27ed008d, 0xf77000f9, 0x00000000}},  //   јте_, _vjen_, ضان_,
  { {0x442c02a9, 0x6e2d0011, 0xdcf50089, 0x00000000}},  //   _bud_, _muab, jdzī,
  { {0x27ff01d5, 0xddcd02aa, 0xc44700a1, 0x00000000}},  //   _tkun_, _opaž, زیشن_,
  { {0x442c0066, 0x69c502ab, 0x00000000, 0x00000000}},  //   _dud_, lkhe,   ,
  { {0x644802ac, 0x442c0146, 0xa2ab0061, 0x00000000}},  //   _ewdi, _eud_, जमध्,
  { {0x442c002a, 0x69c5010f, 0x00000000, 0x00000000}},  //   _fud_, nkhe,   ,
  { {0x442c0239, 0x7bc40006, 0x00000000, 0x00000000}},  //   _gud_, ykiu,   ,
  { {0x60330035, 0x76490258, 0x00000000, 0x00000000}},  //   _căma, _kwey,   ,
  { {0x6e2d02ad, 0x00000000, 0x00000000, 0x00000000}},  //   _cuab,   ,   ,
  { {0x79950046, 0x69c502ae, 0x6e2d0022, 0x00000000}},  //   _nazw, jkhe, _duab,
  { {0x61e102af, 0xdca302b0, 0xc18300a1, 0x00000000}},  //   mill, нари, _فیکٹ,
  { {0x61e102b1, 0x67290093, 0x69dc02b2, 0x00000000}},  //   lill, _ngej, _smre,
  { {0x3c19008b, 0x27fd00ab, 0x6e2d00fa, 0x00000000}},  // [260] іўся_, down_, _guab,
  { {0x6d410279, 0x63b901f3, 0x3ea00093, 0x00000000}},  //   ılac, _lown, _irit_,
  { {0x799501a2, 0x778602b3, 0x00000000, 0x00000000}},  //   _dazw, злез,   ,
  { {0x442c002a, 0x2d980030, 0x5faf0061, 0x00000000}},  //   _rud_, ldre_, टायल,
  { {0x61e102b4, 0xc6150055, 0x3f8002b5, 0x00000000}},  //   kill, াদনা_, _mbiu_,
  { {0x2d9802b6, 0x61e102b7, 0x8e570097, 0x00000000}},  //   ndre_, jill, לינג_,
  { {0x62820168, 0x61e10211, 0xf74602b8, 0x00000000}},  //   _spoo, dill, _нево,
  { {0x7dcb02b9, 0x9f5900f4, 0x3ea0000a, 0x00000000}},  //   _müsa, posé_, _orit_,
  { {0x63b90038, 0x61e102ba, 0x6033001a, 0x00000000}},  //   _down, fill, _răma,
  { {0x442c02bb, 0x61e10197, 0xdcf50089, 0x00000000}},  //   _tud_, gill, udzī,
  { {0xdcf5001e, 0x442c023a, 0x03260131, 0x00000000}},  //   rdzī, _uud_, _еден,
  { {0x3ea00010, 0x61e102bc, 0x00000000, 0x00000000}},  //   _brit_, aill,   ,
  { {0x61e102bd, 0x71a602be, 0x3ea000d4, 0x00000000}},  //   bill, _надз, _crit_,
  { {0x61e1027b, 0x57b90204, 0x442602bf, 0x00000000}},  //   cill, _आव्ह, _hio_,
  { {0x48dc0061, 0x7c2602c0, 0x442602c1, 0x00000000}},  //   _गेलो_, _bikr, _kio_,
  { {0xcf270054, 0x2d980207, 0x3ea00030, 0x00000000}},  //   _عربي, adre_, _frit_,
  { {0x44260198, 0x2d8a01aa, 0x3ea002c2, 0x00000000}},  // [270] _mio_, bebe_, _grit_,
  { {0x2d8a0181, 0x3f8b02c3, 0x442602c4, 0x00000000}},  //   cebe_, lecu_, _lio_,
  { {0x7c2602c5, 0x69c50145, 0x27fd00ab, 0x00000000}},  //   _fikr, rkhe, town_,
  { {0x61e10051, 0x442602c6, 0xc794007e, 0x00000000}},  //   zill, _nio_, ершы,
  { {0x63b9010b, 0x61e102c7, 0xcb9a009b, 0x00000000}},  //   _rown, yill, _וסרט,
  { {0xd1260025, 0x61e10275, 0x442602c8, 0x00000000}},  //   _لم_, xill, _aio_,
  { {0x61e1008d, 0xdb0601aa, 0x6fc60051, 0x00000000}},  //   vill, _ankè, _sócm,
  { {0x442602c9, 0x291100ca, 0x61e102ca, 0x00000000}},  //   _cio_, _izza_, will,
  { {0x442602cb, 0x61e102cc, 0x3f8b0107, 0x00000000}},  //   _dio_, till, decu_,
  { {0x61e100f4, 0x3ea00065, 0x629b0006, 0x00000000}},  //   uill, _rrit_, rvuo,
  { {0x61e1021e, 0x7dd0021e, 0x44260181, 0x00000000}},  //   rill, _jäse, _fio_,
  { {0x61e1021e, 0x442602cd, 0xdee601fb, 0x00000000}},  //   sill, _gio_, доми,
  { {0x61e10030, 0x7dd00039, 0x2d8a02ce, 0x00000000}},  //   pill, _läse, tebe_,
  { {0x7c2602cc, 0x442602cf, 0x3e760030, 0x00000000}},  //   _sikr, _zio_, ræt_,
  { {0x2d9802d0, 0x3b9601f9, 0x2d8a02d1, 0x00000000}},  //   rdre_, мјат, rebe_,
  { {0x6ff60054, 0xea010011, 0x2d8a014a, 0x00000000}},  //   _تستط, _đạp_, sebe_,
  { {0x7c2601aa, 0x3b070265, 0x2bdf01f5, 0x00000000}},  // [280] _vikr, дето_, _नगरा,
  { {0xc9860025, 0x6028013e, 0x00000000, 0x00000000}},  //   بشري, _těmt,   ,
  { {0x8cb502d2, 0x7c26010a, 0x19b902d3, 0x00000000}},  //   _उपयो, _tikr, чуть_,
  { {0xb0b60049, 0xf0b60049, 0x7c3e02d4, 0x00000000}},  //   ופעס_, ולער_, _itpr,
  { {0x442602d5, 0xdb0f004a, 0x12e80044, 0x00000000}},  //   _rio_, _tocá, _পর্দ,
  { {0x4426000b, 0x3f8b016c, 0x645e00fa, 0x00000000}},  //   _sio_, zecu_, ápio,
  { {0xd4970147, 0x69ce02d6, 0x442602d7, 0x00000000}},  //   дры_, _ilbe, _pio_,
  { {0x29180036, 0xc178007f, 0x00000000, 0x00000000}},  //   ągać_, ynės_,   ,
  { {0x8cb5013d, 0x44260211, 0xd166005e, 0x00000000}},  //   _उपभो, _vio_, мъни,
  { {0xe29f000c, 0x7c3e0091, 0x00000000, 0x00000000}},  //   æða_, _otpr,   ,
  { {0x44260039, 0xf993009b, 0xd36f00e2, 0x00000000}},  //   _tio_, דרת_, _ич_,
  { {0x443e0047, 0x72c60072, 0xdb0d000c, 0x00000000}},  //   _itt_, _обез, kkað,
  { {0x441b007b, 0x645802d8, 0xff0402d9, 0x00000000}},  //   _וואס, lsvi, вярн,
  { {0x7ae90209, 0x443e02da, 0x3f8b02db, 0x00000000}},  //   _žeto, _ktt_, secu_,
  { {0x6458004e, 0xc1780006, 0xac190088, 0x00000000}},  //   nsvi, snės_, зову_,
  { {0x5bc90204, 0x443e0052, 0x5f9502dc, 0x00000000}},  //   रसेव, _mtt_, _чиит,
  { {0x6feb0046, 0x9f420065, 0xda7802dd, 0x00000000}},  // [290] jęci, zikë_, дях_,
  { {0x443e0047, 0x627700b3, 0xc5f30044, 0x00000000}},  //   _ott_, וגמא_, _চীনা_,
  { {0x6d5502de, 0x443e02da, 0x6d4702df, 0x00000000}},  //   maza, _ntt_, mbja,
  { {0x6d5502e0, 0x64580056, 0x69ce014a, 0x00000000}},  //   laza, dsvi, _elbe,
  { {0x443e02e1, 0x6fc60051, 0xbb3a0104, 0x00000000}},  //   _att_, _dóch, _מערי,
  { {0x443e0129, 0x9f420065, 0x6d5502e2, 0x00000000}},  //   _btt_, tikë_, naza,
  { {0x26c90119, 0x645802e3, 0x443e00c4, 0x00000000}},  //   šao_, gsvi, _ctt_,
  { {0x6d55002b, 0x443e02e4, 0x9f420065, 0x00000000}},  //   haza, _dtt_, rikë_,
  { {0x443e02e1, 0x644e01d5, 0x601601ca, 0x00000000}},  //   _ett_, _ħbie, náme,
  { {0xf1b10054, 0x443e02e5, 0x6b8d0048, 0x00000000}},  //   اءة_, _ftt_, heag,
  { {0x443e0022, 0x672400b9, 0x6b8d02e6, 0x00000000}},  //   _gtt_, žijt, keag,
  { {0x649a00b6, 0x644302e7, 0x14d80061, 0x00000000}},  //   _מסעד, mpni, _भेटण,
  { {0xe1ee0265, 0x712400a1, 0x6d41005d, 0x00000000}},  //   _бг_, ٹریل, ılan,
  { {0x7bcf0198, 0x683301f3, 0x443e02e8, 0x00000000}},  //   _alcu, _aħdm, _ytt_,
  { {0xafe602e9, 0xb042001d, 0xbddb0173, 0x00000000}},  //   _покл, _trưở, nsèy,
  { {0x6b8d0146, 0x8b2602ea, 0x00000000, 0x00000000}},  //   geag, едбе,   ,
  { {0xada60265, 0x6d550161, 0x200202eb, 0x00000000}},  // [2a0] _запл, baza, moki_,
  { {0xdb0d009f, 0x6d5502ec, 0x20020032, 0x00000000}},  //   rkað, caza, loki_,
  { {0x7dcb014a, 0x6b8d002d, 0x7c3e02e1, 0x00000000}},  //   _müsl, beag, _utpr,
  { {0x48c30055, 0x2ca50030, 0x6016008e, 0x00000000}},  //   ্পূর, ælde_, lámb,
  { {0x2d9a011c, 0x69d10089, 0x645802ed, 0x00000000}},  //   _kape_, _ūdeņ, wsvi,
  { {0xab5b010f, 0x245a0089, 0x443e0095, 0x00000000}},  //   _flüs, tīm_, _ptt_,
  { {0xc7b000a1, 0x2002002d, 0x2d9a0027, 0x00000000}},  //   _پڑا_, koki_, _mape_,
  { {0x64580239, 0x443e00f4, 0x9f59008e, 0x00000000}},  //   rsvi, _vtt_, tosí_,
  { {0x6458000c, 0x443e02ee, 0x245a01c5, 0x00000000}},  //   ssvi, _wtt_, sīm_,
  { {0x27e602ef, 0x443e01c5, 0x2d9a01a3, 0x00000000}},  //   lion_, _ttt_, _nape_,
  { {0xc05702f0, 0x6d550010, 0x443e0089, 0x00000000}},  //   нія_, vaza, _utt_,
  { {0x27e602f1, 0x6b8d0032, 0x6d5502f2, 0x00000000}},  //   nion_, xeag, waza,
  { {0x6d550020, 0xf8ad0061, 0x2d9a02f3, 0x00000000}},  //   taza, _टप्प, _bape_,
  { {0xbbc902f4, 0x7d0302cc, 0x27e60016, 0x00000000}},  //   रस्क, _ønsk, hion_,
  { {0x6d5502f5, 0x5ff50265, 0x27e602f6, 0x00000000}},  //   raza, _изку, kion_,
  { {0x6d5a02f7, 0xfc300025, 0x6d5502f8, 0x00000000}},  //   ótar, صحف_, saza,
  { {0x27e6018e, 0x6b8d002a, 0x49750264, 0x00000000}},  // [2b0] dion_, reag, клас,
  { {0x601602f9, 0xab5b02fa, 0x6b8d010e, 0x00000000}},  //   ráme, _plüs, seag,
  { {0x4ddc009b, 0x6fc60181, 0x27e60016, 0x00000000}},  //   _מחזו, _sóci, fion_,
  { {0x27e602f1, 0x76590016, 0x2d9a016c, 0x00000000}},  //   gion_, tswy, _zape_,
  { {0xa3b402fb, 0x7e7d001e, 0x9f4b008e, 0x00000000}},  //   ञान_, ntsp, locó_,
  { {0x7e7d01a2, 0xeabf0082, 0x200202fc, 0x00000000}},  //   itsp, _ngùi_, zoki_,
  { {0x27e6018e, 0xd90f02fd, 0xa8020276, 0x00000000}},  //   bion_, _ایا_, ğıra,
  { {0x27e602fe, 0x644302ff, 0x25ac0300, 0x00000000}},  //   cion_, rpni, _endl_,
  { {0x7dd00039, 0x765b0045, 0x00000000, 0x00000000}},  //   _läsa, _uvuy,   ,
  { {0x64430301, 0x7e7d0302, 0x00000000, 0x00000000}},  //   ppni, dtsp,   ,
  { {0x66030051, 0x20020303, 0xf07600a1, 0x00000000}},  //   monk, toki_, نیوں_,
  { {0x6441000a, 0x7e7d0304, 0xb4bf01f5, 0x00000000}},  //   _itli, ftsp, ुनी_,
  { {0x20020305, 0x7e7d0306, 0x00000000, 0x00000000}},  //   roki_, gtsp,   ,
  { {0x27e60307, 0x212e00d9, 0xd656009b, 0x00000000}},  //   zion_, _ggfh_, כישת_,
  { {0x2d9a0066, 0x7e7d021f, 0x1d07005e, 0x00000000}},  //   _vape_, atsp, вери_,
  { {0x27e6028c, 0x66030308, 0x2d9a00e7, 0x00000000}},  //   xion_, honk, _wape_,
  { {0x27e60052, 0xf1b50309, 0x3ae80014, 0x00000000}},  // [2c0] vion_, _अचान, ربری_,
  { {0xdcfc0089, 0x249200b4, 0x64410087, 0x00000000}},  //   ndrī, łymi_, _otli,
  { {0x27e6030a, 0x66030052, 0xdb060036, 0x00000000}},  //   tion_, donk, _pokó,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x27e6018e, 0x6441030b, 0xa3ab013d, 0x00000000}},  //   rion_, _atli, खाई_,
  { {0x27e6030a, 0xd943013b, 0xd64500a1, 0x00000000}},  //   sion_, _вери, ائنٹ,
  { {0x27e600b0, 0xe7f40061, 0x65610026, 0x00000000}},  //   pion_, ेकदा_, _ddlh,
  { {0x799c030c, 0xc27400ed, 0x329800e2, 0x00000000}},  //   _harw, глиј, евиќ_,
  { {0x877b0049, 0x762600e2, 0x3134030d, 0x00000000}},  //   _קאמי, _амаз, лепр,
  { {0xf1a6005e, 0x65610022, 0x799c0022, 0x00000000}},  //   трин, _gdlh, _jarw,
  { {0x799c0016, 0x2fc000d4, 0x32070253, 0x00000000}},  //   _marw, _boig_, _dkny_,
  { {0x7e7d030e, 0x9f4b008e, 0x6d41005a, 0x00000000}},  //   ttsp, vocó_, ılam,
  { {0xdbdc000c, 0x00000000, 0x00000000, 0x00000000}},  //   _ráðn,   ,   ,
  { {0x7e7d0089, 0xdd110161, 0x00000000, 0x00000000}},  //   rtsp, _výži,   ,
  { {0xf4140049, 0x61e8030f, 0x2fd20039, 0x00000000}},  //   ָפּ_, midl, _flyg_,
  { {0x3ec7008b, 0xef67005e, 0x2a6900c4, 0x00000000}},  //   _асоб, _ръко, trab_,
  { {0x5b1501e0, 0x799c0036, 0x00000000, 0x00000000}},  // [2d0] умат, _barw,   ,
  { {0x2a690310, 0x799c005b, 0x98c7005c, 0x00000000}},  //   rrab_, _carw, ксел,
  { {0x2d910311, 0x48c30044, 0xd24600a6, 0x00000000}},  //   meze_, ্প্র, _گن_,
  { {0x2d9101d1, 0x4cdc0044, 0x61e80312, 0x00000000}},  //   leze_, _মুকু, hidl,
  { {0xd24600a1, 0x66030313, 0x799c0016, 0x00000000}},  //   _دن_, tonk, _farw,
  { {0x2d910314, 0x09ad0044, 0x6f0d0019, 0x00000000}},  //   neze_, _গতকা, _myac,
  { {0x66030315, 0xb4bf0316, 0x6b9d00d9, 0x00000000}},  //   ronk, ुने_, _kasg,
  { {0x7bcd010f, 0x2d910317, 0x7d08010e, 0x00000000}},  //   nkau, heze_, üdsi,
  { {0x2fc00129, 0x66030059, 0x2d9100e7, 0x00000000}},  //   _roig_, ponk, keze_,
  { {0xe5730318, 0x2d9100e5, 0x61e80319, 0x00000000}},  //   _خطر_, jeze_, gidl,
  { {0x7bcd021e, 0x43750076, 0x2d91031a, 0x00000000}},  //   kkau, _مهار, deze_,
  { {0x5275031b, 0x6f0d0009, 0xeb9f0030, 0x00000000}},  //   _буку, _byac, _skøn_,
  { {0x6f0d0009, 0x61e8031c, 0xee37005e, 0x00000000}},  //   _cyac, bidl, лня_,
  { {0x409501f9, 0x63bb0313, 0x2d910061, 0x00000000}},  //   _брит, ljun, geze_,
  { {0x6c36031d, 0x32050010, 0x6f0d008e, 0x00000000}},  //   افرا, moly_, _eyac,
  { {0x63bb0149, 0x6b9d018e, 0xdb0f0181, 0x00000000}},  //   njun, _casg, _incê,
  { {0xc332019b, 0x6016008e, 0x6b9d005b, 0x00000000}},  // [2e0] מון_, cáma, _dasg,
  { {0x7bd60061, 0xfd4a0088, 0x6299000a, 0x00000000}},  //   shyu, _язок_, _mswo,
  { {0x63bb000c, 0x6b9d005b, 0x00000000, 0x00000000}},  //   kjun, _fasg,   ,
  { {0x6b9d0016, 0x3205031e, 0x61e8031f, 0x00000000}},  //   _gasg, holy_, zidl,
  { {0x63bb0320, 0x799c00bb, 0x00000000, 0x00000000}},  //   djun, _tarw,   ,
  { {0x6b840321, 0x6e36004a, 0x00000000, 0x00000000}},  //   lfig, _muyb,   ,
  { {0x61e8004f, 0x395a0056, 0x6aa40026, 0x00000000}},  //   vidl, maps_, lvif,
  { {0x6b840322, 0x2d910323, 0x395a006c, 0x00000000}},  //   nfig, zeze_, laps_,
  { {0xd1300054, 0x46a30147, 0xdb1d00f4, 0x00000000}},  //   يمة_, _латв, _posé,
  { {0x7a7b0049, 0xda7b0049, 0x00000000, 0x00000000}},  //   עריס, עניר,   ,
  { {0x63bb0066, 0xe475007e, 0x2d910091, 0x00000000}},  //   bjun, _вучэ, veze_,
  { {0x09c10204, 0x2d910020, 0x8f47007e, 0x00000000}},  //   _शक्य, weze_, ыход,
  { {0x61e80324, 0x2d91001a, 0x6b9d0325, 0x00000000}},  //   pidl, teze_, _rasg,
  { {0x7dcb0004, 0x23270326, 0x60160327, 0x00000000}},  //   _küsi, _сочи_, ráma,
  { {0x2d91001a, 0x62800190, 0x6b840197, 0x00000000}},  //   reze_, ltmo, ffig,
  { {0x2d91001a, 0x6b840010, 0x62800328, 0x00000000}},  //   seze_, gfig, otmo,
  { {0x99550001, 0x7bcd001f, 0x6b9d0007, 0x00000000}},  // [2f0] икац, rkau, _vasg,
  { {0x7bcd0329, 0x6b9d032a, 0x62800270, 0x00000000}},  //   skau, _wasg, itmo,
  { {0x6b9d032b, 0x63bb01e5, 0x00000000, 0x00000000}},  //   _tasg, yjun,   ,
  { {0x3ea90235, 0x6b9d0051, 0x6d57032c, 0x00000000}},  //   _krat_, _uasg, _hexa,
  { {0x6d570032, 0x395a00f6, 0x00000000, 0x00000000}},  //   _kexa, baps_,   ,
  { {0xb5fd00b9, 0x5e580049, 0x4ade007d, 0x00000000}},  //   _ovše, ריגע_, _नेटव,
  { {0x23d5003b, 0xdb060047, 0x6d57006b, 0x00000000}},  //   ицир, _inká, _mexa,
  { {0xea01001d, 0x6265032d, 0x6280032e, 0x00000000}},  //   _đẹp_, авиа, ftmo,
  { {0x63bb00b0, 0xd7f8007e, 0x3205032f, 0x00000000}},  //   rjun, _сур_, toly_,
  { {0xbbd201f5, 0x98a10180, 0x7c2f0249, 0x00000000}},  //   _सत्क, lahı_, _licr,
  { {0x7dd00039, 0xf992009b, 0x6ff20089, 0x00000000}},  //   _säso, חרי_, lāci,
  { {0x3ea90142, 0xf1d901f5, 0x543a0049, 0x00000000}},  //   _brat_, योजन, _סענא,
  { {0x32050142, 0x6ff20089, 0x62800330, 0x00000000}},  //   poly_, nāci, ctmo,
  { {0xc5f20049, 0x10a50331, 0x00000000, 0x00000000}},  //   ַדן_, _викн,   ,
  { {0x442f0030, 0xed57007c, 0x6b840232, 0x00000000}},  //   _kig_, рос_, tfig,
  { {0x6016027b, 0x6ff2001e, 0x2d9e01ca, 0x00000000}},  //   mámo, kāci, žte_,
  { {0x442f0332, 0x3ea90313, 0x6b840333, 0x00000000}},  // [300] _mig_, _grat_, rfig,
  { {0x442f0334, 0xe9d7025f, 0x6b840232, 0x00000000}},  //   _lig_, аку_, sfig,
  { {0xd9100167, 0x6fcd009d, 0x395a0335, 0x00000000}},  //   سیر_, _bûch, raps_,
  { {0x7afd01f3, 0x442f0336, 0x657a0009, 0x00000000}},  //   _fxst, _nig_, _scth,
  { {0x7c240337, 0xeb97005e, 0x2b400338, 0x00000000}},  //   mmir, _тия_, mcic_,
  { {0x6d5c0127, 0x7c24005f, 0x442f0061, 0x00000000}},  //   nara, lmir, _aig_,
  { {0x442f0339, 0x601d00f4, 0x6d5c033a, 0x00000000}},  //   _big_, léme, iara,
  { {0x6d5c033b, 0x938a033c, 0x442f0016, 0x00000000}},  //   hara, тска_, _cig_,
  { {0x442f033d, 0x6d5c033e, 0x05160044, 0x00000000}},  //   _dig_, kara, াশের_,
  { {0x6d5c0149, 0x442f0109, 0x91b800e2, 0x00000000}},  //   jara, _eig_, угот_,
  { {0x442f00ab, 0x3958001a, 0x6d57033f, 0x00000000}},  //   _fig_, _mers_, _rexa,
  { {0x442f0016, 0x3ea90129, 0x6d570190, 0x00000000}},  //   _gig_, _prat_, _sexa,
  { {0x6d5c0073, 0x7c2f0197, 0xdb1d0026, 0x00000000}},  //   fara, _ricr, _così,
  { {0x6d5c0149, 0x7c2f018e, 0x3ea90340, 0x00000000}},  //   gara, _sicr, _vrat_,
  { {0x6ff2001e, 0x61ef009d, 0x6d5700fa, 0x00000000}},  //   zāci, ècle, _vexa,
  { {0x44240341, 0x3ea90342, 0x6d5c012d, 0x00000000}},  //   nmm_, _trat_, aara,
  { {0x6d5c0127, 0x69d50224, 0x6d5700ab, 0x00000000}},  // [310] bara, _plze, _texa,
  { {0xe29f009f, 0xc178010a, 0x442400e0, 0x00000000}},  //   æði_, ngė_, hmm_,
  { {0x3958014a, 0x7c2f00f6, 0x00000000, 0x00000000}},  //   _ders_, _ticr,   ,
  { {0x39580343, 0x6ff20089, 0x224602db, 0x00000000}},  //   _eers_, tāci, _otok_,
  { {0x60160344, 0x442f0345, 0x4424012d, 0x00000000}},  //   zámo, _rig_, dmm_,
  { {0x442f0346, 0x6ff2001e, 0x3958009d, 0x00000000}},  //   _sig_, rāci, _gers_,
  { {0xe3b10054, 0x442f0133, 0x98aa0066, 0x00000000}},  //   كرة_, _pig_, _rebħ_,
  { {0x6d5c0347, 0xb7bd0035, 0x317c00d9, 0x00000000}},  //   zara, _piţu, _acvz_,
  { {0x442f0348, 0x36d40088, 0xdcfe0089, 0x00000000}},  //   _vig_, _дотр, _papī,
  { {0x7c24001e, 0x6d5c0349, 0x442f00b4, 0x00000000}},  //   zmir, xara, _wig_,
  { {0x6d5c0119, 0x442f034a, 0x8fa6034b, 0x00000000}},  //   vara, _tig_, бане,
  { {0xcdc900b6, 0x6d5c034c, 0xdb0f02d0, 0x00000000}},  //   _אך_, wara, _encé,
  { {0x6d5c034d, 0x539a034e, 0xdb24005d, 0x00000000}},  //   tara, _תינו, üsün,
  { {0x32b80025, 0x7dd000b0, 0x61390049, 0x00000000}},  //   _خدمة_, _täsm, _גײַס,
  { {0x6d5c034f, 0xc885006b, 0x7c240350, 0x00000000}},  //   rara, naşı_, tmir,
  { {0x6d5c020c, 0x2b5900d4, 0x9f82000c, 0x00000000}},  //   sara, _cesc_, _góð_,
  { {0x39580351, 0x2b590061, 0x2b40016c, 0x00000000}},  // [320] _pers_, _desc_, rcic_,
  { {0x2a600352, 0x601d0353, 0x7c240232, 0x00000000}},  //   rsib_, réme, smir,
  { {0x39580354, 0xfbd20355, 0x2a60002b, 0x00000000}},  //   _vers_, _فتح_, ssib_,
  { {0xc8850279, 0x9f4b0023, 0x3958005b, 0x00000000}},  //   daşı_, vicë_, _wers_,
  { {0xe5c60356, 0xe775006b, 0x3958014a, 0x00000000}},  //   йско, zıçı, _ters_,
  { {0x7e6400ca, 0x00000000, 0x00000000, 0x00000000}},  //   _mvip,   ,   ,
  { {0x2246033b, 0x7bc60357, 0xe9d70088, 0x00000000}},  //   _stok_, _koku, _укр_,
  { {0x7e6400ea, 0x644a0026, 0x7bc60358, 0x00000000}},  //   _ovip, rpfi, _joku,
  { {0x7ae90359, 0x60290036, 0x7dcb035a, 0x00000000}},  //   _þett, _uśmi, _küst,
  { {0x7bc6000c, 0x104a0077, 0x6d5a000c, 0x00000000}},  //   _loku, лями_, ðtal,
  { {0xe452035b, 0x7dcb035c, 0x7e640022, 0x00000000}},  //   _رضا_, _xüsu, _avip,
  { {0x7bc60145, 0x9426007c, 0x00000000, 0x00000000}},  //   _noku, _умее,   ,
  { {0xdb1d035d, 0x00000000, 0x00000000, 0x00000000}},  //   _posí,   ,   ,
  { {0x270700ad, 0x63a2035e, 0x2b5900c4, 0x00000000}},  //   ống_, _haon, _sesc_,
  { {0x7bc6035f, 0x7a290006, 0x7f5d0026, 0x00000000}},  //   _boku, _užti, pasq,
  { {0x1b020044, 0xdb1d00fa, 0x4a55007e, 0x00000000}},  //   লেছে_, _rosâ, жкас,
  { {0x7bc60292, 0x63a2000b, 0x200b01ca, 0x00000000}},  // [330] _doku, _maon, moci_,
  { {0x200b0207, 0x63a2017b, 0x00000000, 0x00000000}},  //   loci_, _laon,   ,
  { {0x394101a2, 0x7dcb0360, 0x00000000, 0x00000000}},  //   rchs_, _düst,   ,
  { {0x61c502f4, 0x63a20020, 0x7bc60288, 0x00000000}},  //   _लक्ष, _naon, _goku,
  { {0x25ed001c, 0x4ae4008b, 0x249e0035, 0x00000000}},  //   _अगदी_, _еўра, _astm_,
  { {0xdcfc0089, 0x3e5c0049, 0x96280025, 0x00000000}},  //   cerē, נדוס, مكنك_,
  { {0xdb0600f8, 0x63a20361, 0x7bc60362, 0x00000000}},  //   _enkä, _baon, _yoku,
  { {0xc2450081, 0x7dcb01a2, 0x00000000, 0x00000000}},  //   оник, _küss,   ,
  { {0x69c70363, 0x6448005f, 0x85b90364, 0x00000000}},  //   _koje, _etdi, _клас_,
  { {0x27ef0365, 0x7dcb001f, 0x7dd00039, 0x00000000}},  //   lign_, _müss, _väsk,
  { {0x69c70366, 0x7e64000c, 0xcea900b3, 0x00000000}},  //   _moje, _svip, _שי_,
  { {0x6d450367, 0x200b0129, 0xd00a003b, 0x00000000}},  //   _afha, goci_, реме_,
  { {0xa2940106, 0xd9fb0061, 0x24650089, 0x00000000}},  //   _наці, ्वात_, lēm_,
  { {0x7dd00368, 0x41290369, 0x224d008a, 0x00000000}},  //   _käsi, _коло_, mpek_,
  { {0x7bc6036a, 0x63a2036b, 0x7dcb036c, 0x00000000}},  //   _poku, _yaon, _rüst,
  { {0xb068036d, 0x7dcb006c, 0x200b036e, 0x00000000}},  //   _اصول_, _süst, coci_,
  { {0x69c700ee, 0x7dcb006c, 0x19c60088, 0x00000000}},  // [340] _boje, _püst, обам,
  { {0x3ea001aa, 0x7dcb010f, 0x69c702f9, 0x00000000}},  //   _isit_, _düss, _coje,
  { {0x2d980198, 0x69c701d9, 0x5faf0061, 0x00000000}},  //   mere_, _doje, _जोडल,
  { {0x2d98011f, 0x510c007b, 0x7dcb01a2, 0x00000000}},  //   lere_, נהאַ, _wüst,
  { {0xd5ba0057, 0x63a20129, 0x601d00f4, 0x00000000}},  //   иск_, _raon, néma,
  { {0x69c7036f, 0xe4520025, 0x63a20370, 0x00000000}},  //   _goje, وضع_, _saon,
  { {0x601d0371, 0x2caa0009, 0x63a20026, 0x00000000}},  //   héma, nvbd_, _paon,
  { {0x2d980372, 0x32660373, 0x9faf00b9, 0x00000000}},  //   here_, отов, tří_,
  { {0x2d980374, 0xdb1d0010, 0x200b0375, 0x00000000}},  //   kere_, _kosá, voci_,
  { {0x2d980030, 0x63a20020, 0x3f800006, 0x00000000}},  //   jere_, _waon, _aciu_,
  { {0x2d980376, 0x63a2006a, 0x24650089, 0x00000000}},  //   dere_, _taon, cēm_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x200b0059, 0x2d980377, 0x00000000, 0x00000000}},  //   roci_, fere_,   ,
  { {0x2d980378, 0xddcf001a, 0x61ea001a, 0x00000000}},  //   gere_, ducţ, _umfl,
  { {0xa17700b6, 0xfbd30379, 0x69c7037a, 0x00000000}},  //   _ועוד_, وتر_, _roje,
  { {0x69c700ca, 0xdb1d00f6, 0x6446012d, 0x00000000}},  //   _soje, _posà, _čkil,
  { {0x69c7037b, 0x24650089, 0x00000000, 0x00000000}},  // [350] _poje, zēm_,   ,
  { {0x2d98037c, 0x3f990059, 0xdb1d0048, 0x00000000}},  //   cere_, lesu_, _cosá,
  { {0x7649037d, 0xdb1d00b9, 0x69c70161, 0x00000000}},  //   _stey, _dosá, _voje,
  { {0x3f99037e, 0x69c70046, 0x4c9a00b3, 0x00000000}},  //   nesu_, _woje, _פברו,
  { {0x320c00b4, 0x00000000, 0x00000000, 0x00000000}},  //   kody_,   ,   ,
  { {0x2465001e, 0x69de037f, 0x85e80088, 0x00000000}},  //   tēm_, chpe, одів_,
  { {0xd5ae0380, 0x00000000, 0x00000000, 0x00000000}},  //   طفي_,   ,   ,
  { {0x3cfc00a3, 0x61fa0186, 0x7dd0006c, 0x00000000}},  //   ילונ, entl, _väsi,
  { {0x27ed0381, 0x37da0049, 0x2d980056, 0x00000000}},  //   _imen_, _פֿלע, yere_,
  { {0x320c0036, 0x2d980382, 0x6d480276, 0x00000000}},  //   gody_, xere_, ıdak,
  { {0x2d980383, 0x224d0384, 0x60160385, 0x00000000}},  //   vere_, spek_, lámi,
  { {0x2d980007, 0x2d810386, 0xd8d6009b, 0x00000000}},  //   were_, _ache_, פורט_,
  { {0x2d98001f, 0x60160387, 0x320c0388, 0x00000000}},  //   tere_, námi, body_,
  { {0x7bcb000c, 0x7dd000f8, 0xd1bb0389, 0x00000000}},  //   ögun, _läsv, _خاصا_,
  { {0x27ed002d, 0xdb1d00c4, 0x3f99038a, 0x00000000}},  //   _omen_, _rosá, besu_,
  { {0x2d98038b, 0x9e66025f, 0x7bdf0066, 0x00000000}},  //   sere_, _евид, ghqu,
  { {0x6d41038c, 0x2d98038d, 0xe9da0264, 0x00000000}},  // [360] ılar, pere_, бка_,
  { {0xdb04038e, 0x8af0006b, 0x27ff0022, 0x00000000}},  //   ndié, vbəd, _ajun_,
  { {0x6d5e001e, 0x6d3b009b, 0x6376019a, 0x00000000}},  //   _iepa, _לתינ, nünü,
  { {0xf1ba0011, 0x69de0023, 0x25a5005b, 0x00000000}},  //   _nhơn_, shpe, _aall_,
  { {0x6d5e020c, 0x25a5038f, 0x27ff0066, 0x00000000}},  //   _kepa, _ball_, _djun_,
  { {0x6d5e0390, 0x25a50038, 0x7c3e0391, 0x00000000}},  //   _jepa, _call_, _kupr,
  { {0x25a50198, 0x320c01ca, 0x7ae40035, 0x00000000}},  //   _dall_, vody_, lzit,
  { {0x6d5e0127, 0x320c0036, 0x25a5006c, 0x00000000}},  //   _lepa, wody_, _eall_,
  { {0x320c0392, 0x25a50393, 0xdb04009d, 0x00000000}},  //   tody_, _fall_, udiè,
  { {0x6d5e0394, 0x64a60057, 0x20030091, 0x00000000}},  //   _nepa, _наза, čkim_,
  { {0x931600a1, 0x320c0395, 0xef1f0396, 0x00000000}},  //   _کوشش, rody_, rfüm_,
  { {0x443e009d, 0x2ca10022, 0x27ed02d4, 0x00000000}},  //   _iut_, _rshd_, _xmen_,
  { {0x6d5e015c, 0x3f990161, 0x7c3e00f4, 0x00000000}},  //   _bepa, resu_, _aupr,
  { {0x6d5e020c, 0x443e0397, 0x3f990016, 0x00000000}},  //   _cepa, _kut_, sesu_,
  { {0x7c3e001a, 0x443e0010, 0x9f4b00b9, 0x00000000}},  //   _cupr, _jut_, licí_,
  { {0x443e00b0, 0x69dc0398, 0xd11701ce, 0x00000000}},  //   _mut_, _alre, _מקוה_,
  { {0x5a350113, 0x443e0036, 0x9f4b0399, 0x00000000}},  // [370] днат, _lut_, nicí_,
  { {0x443e0038, 0x6d5e0168, 0x2019039a, 0x00000000}},  //   _out_, _gepa, llsi_,
  { {0x443e02c2, 0x25a501c3, 0x7c670257, 0x00000000}},  //   _nut_, _rall_, _عادل,
  { {0x69dc0010, 0x80bd0061, 0x00000000, 0x00000000}},  //   _elre, षमते,   ,
  { {0xf7700137, 0x443e039b, 0x81bc0089, 0x00000000}},  //   طان_, _aut_, rmēj,
  { {0x443e0038, 0x6016039c, 0xf650039d, 0x00000000}},  //   _but_, rámi, ائن_,
  { {0x25a50129, 0x443e00ab, 0x64a2005e, 0x00000000}},  //   _vall_, _cut_, ваща,
  { {0x443e022b, 0x7dd0039e, 0x25a500ab, 0x00000000}},  //   _dut_, _häst, _wall_,
  { {0x443e009d, 0x25a5039f, 0x644902db, 0x00000000}},  //   _eut_, _tall_, _žlič,
  { {0x443e00f4, 0xdb0401a2, 0x8af0006b, 0x00000000}},  //   _fut_, heiß, lbəc,
  { {0x656303a0, 0x7bdd01f6, 0x443e03a1, 0x00000000}},  //   manh, _olsu, _gut_,
  { {0x6d5e020c, 0x5ec60055, 0x7dd003a2, 0x00000000}},  //   _sepa, _লেগে, _läst,
  { {0x6d5e008a, 0x8af0006b, 0x443e0068, 0x00000000}},  //   _pepa, naət, _zut_,
  { {0x7dd00073, 0x63a902cc, 0x656303a3, 0x00000000}},  //   _näst, lden, nanh,
  { {0x62890048, 0x6b8d03a4, 0x443e00d4, 0x00000000}},  //   lteo, ffag, _xut_,
  { {0x7ae4002d, 0x656303a5, 0x673b0023, 0x00000000}},  //   tzit, hanh, _nguj,
  { {0x7dd00073, 0x6d5e0169, 0x6289002a, 0x00000000}},  // [380] _bäst, _tepa, nteo,
  { {0x673b0211, 0x7ae40161, 0x62890051, 0x00000000}},  //   _aguj, rzit, iteo,
  { {0xdb0f00d4, 0xab670089, 0x65630082, 0x00000000}},  //   _encà, _beļģ, danh,
  { {0x63a903a6, 0x443e01e5, 0x628903a7, 0x00000000}},  //   jden, _rut_, kteo,
  { {0x443e018e, 0x7dd00039, 0xd76500a2, 0x00000000}},  //   _sut_, _fäst, رنوی,
  { {0x63a903a8, 0x7dd003a9, 0x443e00ab, 0x00000000}},  //   eden, _gäst, _put_,
  { {0x7dd003aa, 0x78450006, 0xf77203ab, 0x00000000}},  //   _häss, _tėva, _لاء_,
  { {0x63a900ea, 0x6008005d, 0x7a29007f, 0x00000000}},  //   gden, nımd, _užtr,
  { {0xa802005d, 0x291803ac, 0x656303ad, 0x00000000}},  //   ğıda, _hyra_, banh,
  { {0x443e03ae, 0x7dd003af, 0x63a90142, 0x00000000}},  //   _tut_, _mäss, aden,
  { {0x7dd0010f, 0x443e006c, 0xc05701e1, 0x00000000}},  //   _läss, _uut_, мія_,
  { {0x291803b0, 0x601d009d, 0x3eb203b1, 0x00000000}},  //   _myra_, rémo, _bryt_,
  { {0x03d700a0, 0xa30800a1, 0x7dd000f8, 0x00000000}},  //   _קודם_, _عرصے_, _näss,
  { {0xdb0401a2, 0x00000000, 0x00000000, 0x00000000}},  //   weiß,   ,   ,
  { {0x4426001d, 0x2ba700ed, 0x6d4703b2, 0x00000000}},  //   _kho_, мјав, rcja,
  { {0x44260145, 0x3eb20023, 0x00000000, 0x00000000}},  //   _jho_, _fryt_,   ,
  { {0x160e007d, 0x442603b3, 0x6b8d03b4, 0x00000000}},  // [390] ाकार_, _mho_, rfag,
  { {0x4426023a, 0x63a903b5, 0x7e7d03b6, 0x00000000}},  //   _lho_, zden, musp,
  { {0x7dd00073, 0x63a903b7, 0x44260089, 0x00000000}},  //   _väst, yden, _oho_,
  { {0x44260011, 0x291803b8, 0x764000e0, 0x00000000}},  //   _nho_, _dyra_, _bumy,
  { {0x7c2d02e1, 0x20030091, 0x7dd0021e, 0x00000000}},  //   mmar, čkih_, _täst,
  { {0x442603b9, 0x29180039, 0x00000000, 0x00000000}},  //   _aho_, _fyra_,   ,
  { {0x65630181, 0x44260061, 0x63a903ba, 0x00000000}},  //   ranh, _bho_, tden,
  { {0x442600ad, 0x7c2d0018, 0x7e7d002d, 0x00000000}},  //   _cho_, nmar, kusp,
  { {0x63a9004e, 0x66f30164, 0x2a6903bb, 0x00000000}},  //   rden, _अधिक_, nsab_,
  { {0x600802b9, 0x7c2d010f, 0x628903bc, 0x00000000}},  //   zımd, hmar, rteo,
  { {0x62890051, 0x7c2d00ab, 0xdb060065, 0x00000000}},  //   steo, kmar, _pakë,
  { {0x6441000d, 0x656103bd, 0x2a69006c, 0x00000000}},  //   _iuli, _helh, ksab_,
  { {0x442d03be, 0x6441006a, 0x81d50242, 0x00000000}},  //   mme_, _huli, _подх,
  { {0x644103bf, 0x7c26008d, 0x270e0011, 0x00000000}},  //   _kuli, _shkr, ộng_,
  { {0x656102d5, 0xfce603c0, 0x644103c1, 0x00000000}},  //   _melh, хово, _juli,
  { {0x442d011f, 0x644102cc, 0x7c2d03c2, 0x00000000}},  //   nme_, _muli, gmar,
  { {0x291e01cd, 0x160f02fb, 0xe9da00d7, 0x00000000}},  // [3a0] _šta_, िवार_, пка_,
  { {0x442d03c3, 0x7c2d0207, 0xdb0600b9, 0x00000000}},  //   hme_, amar, _jaké,
  { {0x7c2d0181, 0x2b4b0061, 0x64410006, 0x00000000}},  //   bmar, _ffcc_, _nuli,
  { {0x442d03c4, 0x7dd0021e, 0xe853007a, 0x00000000}},  //   jme_, _täss, انند,
  { {0x442603c5, 0x00000000, 0x00000000, 0x00000000}},  //   _rho_,   ,   ,
  { {0x64410010, 0x442601c5, 0x442d03c6, 0x00000000}},  //   _buli, _sho_, eme_,
  { {0x644103c7, 0xd49703c8, 0xdcfc0089, 0x00000000}},  //   _culi, еры_, derī,
  { {0x69ce022b, 0xdb0601aa, 0x442d0213, 0x00000000}},  //   _hobe, _pakè, gme_,
  { {0x65610047, 0x69ce01ca, 0x64410032, 0x00000000}},  //   _felh, _kobe, _euli,
  { {0x44260038, 0x442d03c9, 0xf1ba0011, 0x00000000}},  //   _who_, ame_, _thơm_,
  { {0x33d601fb, 0xdfd10076, 0x442603ca, 0x00000000}},  //   _підт, ليد_, _tho_,
  { {0xa2e600da, 0x7e7d03b6, 0x04db009b, 0x00000000}},  //   _поед, tusp, _מקבל,
  { {0x644103cb, 0x9f4b0129, 0x7c2d03cc, 0x00000000}},  //   _zuli, ricà_, vmar,
  { {0x69ce01d9, 0x64410093, 0x7c2d03cd, 0x00000000}},  //   _nobe, _yuli, wmar,
  { {0xac1901e1, 0x7c2d03ce, 0x7e7d03cf, 0x00000000}},  //   дову_, tmar, susp,
  { {0x7c2d03d0, 0x00000000, 0x00000000, 0x00000000}},  //   umar,   ,   ,
  { {0x7f49004a, 0x9f4b010e, 0x00000000, 0x00000000}},  // [3b0] ñequ, öjõu_,   ,
  { {0x69ce03d1, 0x9f590048, 0x7e6d0032, 0x00000000}},  //   _cobe, insí_, _ivap,
  { {0x69ce0059, 0x7c2d0061, 0x442d0023, 0x00000000}},  //   _dobe, pmar, yme_,
  { {0x6561013e, 0x442d0288, 0x64410133, 0x00000000}},  //   _selh, xme_, _ruli,
  { {0x6441023a, 0x656100b9, 0xe7e200e8, 0x00000000}},  //   _suli, _pelh, _खतरा_,
  { {0x644103d2, 0x69ce03d3, 0x888200a1, 0x00000000}},  //   _puli, _gobe, _چیلن,
  { {0x442d03d4, 0x65610181, 0x6441006b, 0x00000000}},  //   tme_, _velh, _quli,
  { {0x7bcf000d, 0x6b9f001c, 0x442d00f4, 0x00000000}},  //   _jocu, neqg, ume_,
  { {0x130901fb, 0x9f420065, 0x69d80010, 0x00000000}},  //   ьний_, shkë_, öveg,
  { {0x442d03d5, 0x7bcf000d, 0xb63503d6, 0x00000000}},  //   sme_, _locu, _شفاع,
  { {0xf8e103d7, 0xdb1d002a, 0x644103d8, 0x00000000}},  //   पनिय, _cosú, _uuli,
  { {0x13a70063, 0x00000000, 0x00000000, 0x00000000}},  //   _سنتی_,   ,   ,
  { {0x69c4007d, 0x3f8c0036, 0xdb060142, 0x00000000}},  //   रामी, ędu_, _také,
  { {0x82760049, 0x63ab000c, 0xd24e03d9, 0x00000000}},  //   _יענע_, _hagn, _بنو_,
  { {0xa0a50088, 0x4094007e, 0xa3d5013d, 0x00000000}},  //   _райд, _брыт, _सका_,
  { {0x69ce0325, 0x63ab0107, 0xd00f0379, 0x00000000}},  //   _sobe, _jagn, _ولو_,
  { {0x63ab03da, 0x7bcf03db, 0x69ce012b, 0x00000000}},  // [3c0] _magn, _docu, _pobe,
  { {0xdb0d000c, 0x00000000, 0x00000000, 0x00000000}},  //   rjað,   ,   ,
  { {0x1d0a03dc, 0x7bcf00ab, 0xddc400e5, 0x00000000}},  //   _цени_, _focu, _eviţ,
  { {0x63ab03dd, 0x69ce03de, 0x27e003df, 0x00000000}},  //   _nagn, _wobe, óin_,
  { {0xe73703e0, 0x69ce03e1, 0xe7f3013d, 0x00000000}},  //   вец_, _tobe, _आगरा_,
  { {0xa613007e, 0x6aa40045, 0x00000000, 0x00000000}},  //   аміч, mwif,   ,
  { {0x63ab0207, 0x629901aa, 0x44a30025, 0x00000000}},  //   _bagn, _apwo, لموق,
  { {0x63ab03e2, 0x7dd90026, 0x00000000, 0x00000000}},  //   _cagn, _pìsk,   ,
  { {0x41e6007e, 0x63ab03e3, 0x8c1b0104, 0x00000000}},  //   віна, _dagn, ווקי,
  { {0xf1ba0011, 0x63ab0048, 0x27e60052, 0x00000000}},  //   _khơi_, _eagn, lhon_,
  { {0x25be0061, 0x601d038e, 0xb97b009b, 0x00000000}},  //   _intl_, lémi, וניי,
  { {0x63ab03e4, 0x7ec9008d, 0x27e603e5, 0x00000000}},  //   _gagn, _nëpë, nhon_,
  { {0xd2500054, 0xd336008b, 0x6b840146, 0x00000000}},  //   _انت_, _рэжы, dgig,
  { {0x63ab00ca, 0x628001c5, 0x7bcf0035, 0x00000000}},  //   _zagn, mumo, _socu,
  { {0x27e60066, 0xa3d60309, 0x62800006, 0x00000000}},  //   khon_, _हवा_, lumo,
  { {0x313700a0, 0x6008014a, 0x3ed503e6, 0x00000000}},  //   _ברוך_, rımc, _مقبر,
  { {0x27e603e7, 0x00000000, 0x00000000, 0x00000000}},  // [3d0] dhon_,   ,   ,
  { {0x3ea90058, 0x9f4000d4, 0x6008014a, 0x00000000}},  //   _isat_, _aliè_, pımc,
  { {0xf1ba001d, 0xf77503e8, 0x7bcf0035, 0x00000000}},  //   _chơi_, гулю, _tocu,
  { {0xf093007b, 0x1a65026c, 0x63a003e9, 0x00000000}},  //   ינע_, _میری_, jemn,
  { {0x63ab000c, 0x62800089, 0x6008005d, 0x00000000}},  //   _ragn, jumo, nıma,
  { {0x63ab000c, 0x2e24000c, 0x27e600e0, 0x00000000}},  //   _sagn, höfn_, ahon_,
  { {0x63ab03ea, 0x20020036, 0xcd980104, 0x00000000}},  //   _pagn, ynki_, דדות_,
  { {0x27e603eb, 0x249603ec, 0x3d3c00a0, 0x00000000}},  //   chon_, انيد_, וגוס,
  { {0x63ab03ed, 0x628003ee, 0x7c3d03ef, 0x00000000}},  //   _vagn, gumo, _misr,
  { {0x10a50081, 0x63ab02a3, 0xdb0403f0, 0x00000000}},  //   гион, _wagn, ndiá,
  { {0x54550216, 0x69c4001c, 0x63ab03f1, 0x00000000}},  //   _свет, राती, _tagn,
  { {0x628003b5, 0x92b50355, 0x7c3d0066, 0x00000000}},  //   bumo, _محتا, _nisr,
  { {0x94100061, 0x3ea90035, 0x62c70025, 0x00000000}},  //   ावरच_, _csat_, _جزاك,
  { {0xc332009b, 0xdb1e0068, 0x3ea90146, 0x00000000}},  //   _הוד_, _éxéc, _dsat_,
  { {0xfce30264, 0xd1b800a1, 0x3ea90089, 0x00000000}},  //   боро, _جانا_, _esat_,
  { {0xfaa602ea, 0x81bc0089, 0xd0120025, 0x00000000}},  //   лабо, smēt, _دلع_,
  { {0xfe72035b, 0x6b8403f2, 0x7c3d0133, 0x00000000}},  // [3e0] _ادب_, rgig, _disr,
  { {0xf1ba0011, 0x443d0016, 0xd6c40014, 0x00000000}},  //   _phơi_, _liw_, یمای,
  { {0x27e60010, 0x6d5c00d6, 0x81bc001e, 0x00000000}},  //   thon_, mbra, slēg,
  { {0x6d5c0240, 0x4b55005e, 0xdb1d000a, 0x00000000}},  //   lbra, _върт, _onsè,
  { {0xcc3b0049, 0x6d5c0340, 0xddc400ca, 0x00000000}},  //   _רעכט, obra, _zviš,
  { {0xe9df0051, 0x27e60065, 0x8675007e, 0x00000000}},  //   _dtús_, shon_, рыцц,
  { {0xe0c70014, 0x63a00190, 0xdb1d01aa, 0x00000000}},  //   _از_, temn, _ansè,
  { {0xc27403f3, 0xb27403f4, 0x752400b9, 0x00000000}},  //   алиј, алиш, řizo,
  { {0x443d01aa, 0x7d1e03f5, 0x370603f6, 0x00000000}},  //   _diw_, _lyps, _спаг,
  { {0x628003f7, 0x63a003f8, 0xe617007e, 0x00000000}},  //   rumo, semn, _бду_,
  { {0x43860123, 0x6280002d, 0xb97b0049, 0x00000000}},  //   _ملاق, sumo, ענטי,
  { {0x273a038c, 0x9f590065, 0x75280089, 0x00000000}},  //   _günü_, misë_, _izdz,
  { {0x9f590065, 0x98b8002b, 0x244a0082, 0x00000000}},  //   lisë_, _ferħ_, _hùm_,
  { {0x2fc003f9, 0x2e24000c, 0x6d5c03fa, 0x00000000}},  //   _enig_, söfn_, gbra,
  { {0x9f59008d, 0xfaff0065, 0xdb1d00f4, 0x00000000}},  //   nisë_, _ndër_, _insé,
  { {0x81bc0089, 0x3b5500ed, 0x61fa03fb, 0x00000000}},  //   slēd, ркар, litl,
  { {0x6d5c0198, 0x3ea900d4, 0x9f49014a, 0x00000000}},  // [3f0] bbra, _usat_, _amaç_,
  { {0xdcfc0089, 0x9f590065, 0x61fa03fc, 0x00000000}},  //   sgrā, kisë_, nitl,
  { {0x9f590065, 0xf9880025, 0xdb0403fd, 0x00000000}},  //   jisë_, انمي_, rdiá,
  { {0x7e7d01d6, 0x9f590065, 0x61fa014a, 0x00000000}},  //   orsp, disë_, hitl,
  { {0xd90f026c, 0x61fa03fe, 0x22460173, 0x00000000}},  //   _کیا_, kitl, _nuok_,
  { {0x443d01aa, 0xaaa8005e, 0x9f590065, 0x00000000}},  //   _siw_, _съюз_, fisë_,
  { {0x7aed0207, 0x61fa006b, 0x7e7d01a2, 0x00000000}},  //   lzat, ditl, hrsp,
  { {0x7bcd03ff, 0x244a0011, 0x6d5c0089, 0x00000000}},  //   njau, _dùm_, zbra,
  { {0x7aed0400, 0x11e501e0, 0x64580061, 0x00000000}},  //   nzat, ижим, apvi,
  { {0x4375007a, 0x84670265, 0x20b5007e, 0x00000000}},  //   _چهار, _бъде, аёмс,
  { {0x9f590065, 0x55ba00a0, 0x23c5013d, 0x00000000}},  //   cisë_, _שמעו, वादद,
  { {0x22950401, 0x9f590173, 0xdb1d004a, 0x00000000}},  //   _видя, nisè_, _ensé,
  { {0x6d5c0007, 0x61fa0402, 0xceb4006b, 0x00000000}},  //   tbra, bitl, _azər_,
  { {0x91640054, 0x61fa0403, 0xdb0400c4, 0x00000000}},  //   _هههه, citl, ldiç,
  { {0x6d5c010f, 0x8f760245, 0x7f7601ee, 0x00000000}},  //   rbra, _купі, _купц,
  { {0xdb0402d5, 0x2fc0018e, 0x35c7013d, 0x00000000}},  //   ndiç, _unig_, लाड़,

  { {0x896602a8, 0x31670173, 0x9f590065, 0x00000000}},  // [400] икаж, _kenz_, zisë_,
  { {0x48b6005e, 0x7d1e00f8, 0x00000000, 0x00000000}},  //   ищет, _typs,   ,
  { {0x320500ab, 0xac0a0404, 0xeb9f00ea, 0x00000000}},  //   inly_, _анна_, _kjøl_,
  { {0x7bdf0061, 0x9f590065, 0x244a0405, 0x00000000}},  //   ckqu, visë_, _rùm_,
  { {0x61fa01df, 0x7aed0036, 0x00000000, 0x00000000}},  //   yitl, czat,   ,
  { {0xd49a0200, 0x5d7a007b, 0x67290089, 0x00000000}},  //   ври_, דאַק, _dzej,
  { {0x53e601e0, 0x83f80364, 0x399b0097, 0x00000000}},  //   ициа, лекс_, _שילד,
  { {0x9f59008d, 0x32050022, 0x69c40204, 0x00000000}},  //   risë_, enly_, रावी,
  { {0x9f59008d, 0x61fa0406, 0x66e30407, 0x00000000}},  //   sisë_, titl, _дота,
  { {0x9f590408, 0x645802e1, 0x244a0082, 0x00000000}},  //   pisë_, ppvi, _tùm_,
  { {0x7aed0409, 0x9f59040a, 0x66180142, 0x00000000}},  //   zzat, lisé_, movk,
  { {0x61fa040b, 0x6568040c, 0x6618040d, 0x00000000}},  //   sitl, _hedh, lovk,
  { {0x6448040e, 0x9f5900f4, 0x7e7d040f, 0x00000000}},  //   _hudi, nisé_, ursp,
  { {0x64480006, 0x752d00b9, 0x66180410, 0x00000000}},  //   _kudi, řaze, novk,
  { {0x65680065, 0x3157009b, 0x7b67007c, 0x00000000}},  //   _medh, _דיון_, итае,
  { {0x81e80055, 0x7aed0411, 0x80ab0061, 0x00000000}},  //   _যদি_, tzat, _जनते,
  { {0x6e950054, 0x5e950054, 0x7bcd021e, 0x00000000}},  // [410] _الخا, _الخط, rjau,
  { {0x20190412, 0x7bcd0413, 0x64480007, 0x00000000}},  //   losi_, sjau, _oudi,
  { {0x6008014a, 0x66180161, 0xa3d60061, 0x00000000}},  //   kıml, dovk, _हवं_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xef1f0279, 0x60080414, 0x656800d9, 0x00000000}},  //   zgün_, dıml, _bedh,
  { {0x64480415, 0xa509003b, 0xbb3a009b, 0x00000000}},  //   _budi, лела_, _תעשי,
  { {0x20190416, 0x64480417, 0x6d450418, 0x00000000}},  //   kosi_, _cudi, _mgha,
  { {0xd774035b, 0x31670197, 0x69d5012d, 0x00000000}},  //   _واقع, _senz_, _hoze,
  { {0x6568000b, 0x20190419, 0xdb0400c4, 0x00000000}},  //   _fedh, dosi_, rdiç,
  { {0x6d45018e, 0xbbd40164, 0x27fd0016, 0x00000000}},  //   _ngha, _धक्क, liwn_,
  { {0x273300ad, 0x69d5041a, 0xa8790049, 0x00000000}},  //   _ảnh_, _moze, װאָר,
  { {0x6d45041b, 0xdb06041c, 0xfaff0007, 0x00000000}},  //   _agha, _laká, _reën_,
  { {0x69d5041d, 0xfaff0007, 0x6d4501f3, 0x00000000}},  //   _ooze, _seën_, _bgha,
  { {0xc5f2007b, 0x9f59021e, 0x69d5041e, 0x00000000}},  //   ִדן_, ensä_, _noze,
  { {0xdcf7005f, 0xe0550025, 0xfce3041f, 0x00000000}},  //   _baxı, _اختب, поро,
  { {0x20190420, 0x66180421, 0x77690422, 0x00000000}},  //   cosi_, zovk, _neex,
  { {0x69d5002d, 0x4a430423, 0xef1f0424, 0x00000000}},  // [420] _boze, знув, ngül_,
  { {0xe9d70425, 0x9f59009d, 0xa96a0426, 0x00000000}},  //   бку_, visé_, امام_,
  { {0xdb1d027b, 0x65680427, 0xb86501b7, 0x00000000}},  //   _bosó, _redh, قانو,
  { {0x64480020, 0x6d45002b, 0x9f59009d, 0x00000000}},  //   _rudi, _zgha, tisé_,
  { {0x6448037e, 0x7641011c, 0xa6fa0025, 0x00000000}},  //   _sudi, _bily, دعاء_,
  { {0x7c240129, 0x9f5900f4, 0x64480211, 0x00000000}},  //   llir, risé_, _pudi,
  { {0xd467012b, 0xdcf7005f, 0x7641018e, 0x00000000}},  //   бије_, _yaxı, _dily,
  { {0x325400ed, 0xdb060428, 0x938a004d, 0x00000000}},  //   овир, _zaká, уска_,
  { {0x20190429, 0x600801df, 0x7641042a, 0x00000000}},  //   vosi_, rıml, _fily,
  { {0x64480093, 0x7641018e, 0x909800ed, 0x00000000}},  //   _tudi, _gily, авот_,
  { {0x6448042b, 0x7c24016c, 0x2019042c, 0x00000000}},  //   _uudi, klir, tosi_,
  { {0x7c29002b, 0x2019007f, 0x00000000, 0x00000000}},  //   ċerk, uosi_,   ,
  { {0x2019042d, 0x2d9800f4, 0x8af0006b, 0x00000000}},  //   rosi_, ffre_, ncəd,
  { {0xddcd0036, 0x44240093, 0x10f900a1, 0x00000000}},  //   _stał, llm_, ابیں_,
  { {0x69d5042e, 0x7c240066, 0xd12f0245, 0x00000000}},  //   _roze, flir, _хх_,
  { {0x68e1006c, 0xdb0f008e, 0x7c240026, 0x00000000}},  //   _üldi, _hacé, glir,
  { {0x69d50062, 0xdd910054, 0x4424006c, 0x00000000}},  // [430] _poze, _قوة_, ilm_,
  { {0x44240039, 0x6d4500e7, 0xceb40049, 0x00000000}},  //   hlm_, _ugha, _זיץ_,
  { {0x7c2400d4, 0xdb1d042f, 0xdcf7006b, 0x00000000}},  //   blir, _insí, _taxı,
  { {0x76410430, 0x7649004a, 0xe76b0431, 0x00000000}},  //   _sily, _puey, احان_,
  { {0xdb2300a2, 0x76410432, 0xdce500ca, 0x00000000}},  //   _روسی, _pily, _mehč,
  { {0x27fd018e, 0x442f0433, 0x4efc00b3, 0x00000000}},  //   siwn_, _shg_, נהגו,
  { {0x362300a1, 0x62800434, 0x64420133, 0x00000000}},  //   _ہورہ, ermo, _bioi,
  { {0x76410435, 0xd79402dc, 0x84360025, 0x00000000}},  //   _wily, _нисъ, يكور_,
  { {0x644202d0, 0x00000000, 0x00000000, 0x00000000}},  //   _dioi,   ,   ,
  { {0xfaff0007, 0xe1f9030d, 0xef1f026d, 0x00000000}},  //   _reël_, рго_, rgül_,
  { {0x3ea00436, 0x600a0437, 0xa069003b, 0x00000000}},  //   _spit_, ином_, јама_,
  { {0x64420438, 0xd9a6007d, 0xdb1d004a, 0x00000000}},  //   _gioi, _ऑस्ट, _ansí,
  { {0x11d501e1, 0x8db60088, 0x51f50439, 0x00000000}},  //   _мікр, осві, _وستر,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7a30043a, 0x00000000, 0x00000000, 0x00000000}},  //   näte,   ,   ,
  { {0xdb0d0051, 0xf09200a0, 0xec160014, 0x00000000}},  //   adaí, _חנה_, آورد,
  { {0x5336007b, 0x44ef0044, 0x2d98004a, 0x00000000}},  // [440] ַנען_, টপিক_, pfre_,
  { {0x7a30043b, 0x998a007f, 0x00000000, 0x00000000}},  //   käte, _ribų_,   ,
  { {0x7c24043c, 0xa17a0049, 0xb17a0049, 0x00000000}},  //   plir, שטעט, שטער,
  { {0xb09a0049, 0xdb040051, 0x6abd0009, 0x00000000}},  //   ייער, idiú, _frsf,
  { {0x7bc6043d, 0xdce70089, 0x00000000, 0x00000000}},  //   _inku, majā,   ,
  { {0x78af00b0, 0xdce70089, 0x00000000, 0x00000000}},  //   äivä, lajā,   ,
  { {0x37e60088, 0xa6d80044, 0x00000000, 0x00000000}},  //   _довг, _দেশট,   ,
  { {0x68e3043e, 0x7dd000b0, 0xdce70089, 0x00000000}},  //   ønde, _väsy, najā,
  { {0xc1a601fc, 0xdceb00d0, 0x7762043f, 0x00000000}},  //   ојни, _čiče, mbox,
  { {0x776200f8, 0x68e900b9, 0x2be1013d, 0x00000000}},  //   lbox, _ředi, _नवभा,
  { {0xc95300b6, 0x3d1a0061, 0xa0540088, 0x00000000}},  //   ומת_, _मुले_, явні,
  { {0x645a005f, 0x6831032e, 0x00000000, 0x00000000}},  //   _itti, rådg,   ,
  { {0xf77300b6, 0x2ef4007e, 0xf1a90014, 0x00000000}},  //   וקר_, дзяр, _گانه_,
  { {0x77620009, 0x7bc60440, 0x00000000, 0x00000000}},  //   hbox, _anku,   ,
  { {0xdb6b0441, 0xf1a9023c, 0x9b6b00ed, 0x00000000}},  //   ирал_, _دانه_, ишаа_,
  { {0x3d1a0061, 0x3eb000b0, 0x80b80061, 0x00000000}},  //   _मुळे_, ältä_, ेमीं,
  { {0x161a03d7, 0x2aab0098, 0x7762004a, 0x00000000}},  // [450] धवार_, штво_, dbox,
  { {0x645a0282, 0x657a0082, 0x99980087, 0x00000000}},  //   _otti, _ndth, _pirš_,
  { {0x6d550036, 0x00000000, 0x00000000, 0x00000000}},  //   mcza,   ,   ,
  { {0x27e90010, 0x99980006, 0x80380049, 0x00000000}},  //   óan_, _virš_, ַנגע_,
  { {0x645a0442, 0x68e30030, 0xf1bc0164, 0x00000000}},  //   _atti, øndb, ्ञान,
  { {0x7a30010f, 0x6b8d0443, 0x00000000, 0x00000000}},  //   täte, lgag,   ,
  { {0x69cd0061, 0x7d180056, 0x00000000, 0x00000000}},  //   साठी, _øvst,   ,
  { {0x7a300444, 0xf7730445, 0x6aad00e7, 0x00000000}},  //   räte, _زار_, owaf,
  { {0x645a011f, 0x35f5025f, 0xdb0f0446, 0x00000000}},  //   _etti, _епар, _incó,
  { {0x200b0036, 0x95c8004d, 0x00000000, 0x00000000}},  //   enci_, _муха_,   ,
  { {0x6d550046, 0xc6170309, 0x69c701ee, 0x00000000}},  //   dcza, दकीय_, _mnje,
  { {0xdb040051, 0x6d5500b4, 0x00000000, 0x00000000}},  //   rdiú, ecza,   ,
  { {0x63a90100, 0x33f40447, 0x24770035, 0x00000000}},  //   meen, _تسلس, lăm_,
  { {0x63a90343, 0xed570242, 0x225f008a, 0x00000000}},  //   leen, зор_, mpuk_,
  { {0x8af0006b, 0xdce70089, 0x800b00a1, 0x00000000}},  //   hbət, tajā, _گروہ_,
  { {0x60dc0039, 0x24510428, 0x63a90448, 0x00000000}},  //   ärme, _mám_, neen,
  { {0xfaa300ed, 0x20020036, 0x765b00e7, 0x00000000}},  // [460] нато, miki_, _ntuy,
  { {0x20020149, 0x63a900b0, 0xe9d7007c, 0x00000000}},  //   liki_, heen, пку_,
  { {0x24510428, 0x63a90449, 0x02a80316, 0x00000000}},  //   _nám_, keen, _कन्न,
  { {0x6b8d001c, 0x200203e9, 0x63a900b5, 0x00000000}},  //   cgag, niki_, jeen,
  { {0x63a9044a, 0xdb060039, 0x5694044b, 0x00000000}},  //   deen, _bakå, фалт,
  { {0xf1d00011, 0x24510011, 0x200200e7, 0x00000000}},  //   _mạch_, _bám_, hiki_,
  { {0x3958044c, 0x2451001d, 0x2477001a, 0x00000000}},  //   _ifrs_, _cám_, găm_,
  { {0x2451044d, 0x63a9044e, 0xa6d30044, 0x00000000}},  //   _dám_, geen, _দেওয়,
  { {0x366701f9, 0x2002006b, 0x6d550036, 0x00000000}},  //   _нато_, diki_, ycza,
  { {0x6831044f, 0x00000000, 0x00000000, 0x00000000}},  //   råde,   ,   ,
  { {0x80df0055, 0x2002000b, 0x92cc0044, 0x00000000}},  //   _ফেব্, fiki_, রনে_,
  { {0xf1d00011, 0x20020450, 0x27e60010, 0x00000000}},  //   _bạch_, giki_, nkon_,
  { {0xf194007c, 0x41e60451, 0x00000000, 0x00000000}},  //   _жиль, _ніка,   ,
  { {0xc27b0452, 0x7a2b014a, 0xdb0f00f6, 0x00000000}},  //   _פרוי, gütl, _oncò,
  { {0x20020453, 0x24510011, 0x6d550036, 0x00000000}},  //   biki_, _xám_, rcza,
  { {0x1bd40454, 0x69c70166, 0x394a01a2, 0x00000000}},  //   нося, _snje, _agbs_,
  { {0xf1d00011, 0x24770035, 0x59d9007e, 0x00000000}},  // [470] _gạch_, zăm_, одаў_,
  { {0x8af0005f, 0xceb400b3, 0x63a90032, 0x00000000}},  //   vbət, _טיפ_, zeen,
  { {0x63a90455, 0x765b0456, 0x67d50457, 0x00000000}},  //   yeen, _stuy, можу,
  { {0xdb0f0211, 0x24510458, 0xeabf0082, 0x00000000}},  //   _hací, _rám_, _trù_,
  { {0x24510161, 0x9f4b008e, 0x63a9010e, 0x00000000}},  //   _sám_, licó_, veen,
  { {0x20020459, 0x2477001a, 0x8af0013f, 0x00000000}},  //   ziki_, tăm_, rbət,
  { {0x5884045a, 0x63a90368, 0xdb0f027b, 0x00000000}},  //   _пыта, teen, _mací,
  { {0x245101ca, 0xf8b2009b, 0x2477001a, 0x00000000}},  //   _vám_, _בשל_, răm_,
  { {0x765b0009, 0x27ff0145, 0x24770035, 0x00000000}},  //   _utuy, _imun_, săm_,
  { {0x13060057, 0x81bc001e, 0x63a901e2, 0x00000000}},  //   ьный_, blēm, seen,
  { {0x660300b9, 0x20020059, 0xf1d00011, 0x00000000}},  //   mink, tiki_, _sạch_,
  { {0x6603010a, 0x9f4b0211, 0x351a0049, 0x00000000}},  //   link, dicó_, _ווענ,
  { {0x2002000b, 0x8af0005f, 0x6289045b, 0x00000000}},  //   riki_, hbər, queo,
  { {0x6603010a, 0xc33200b6, 0x9f4b008e, 0x00000000}},  //   nink, _סוג_, ficó_,
  { {0x27ed0368, 0x81bc001e, 0x20020020, 0x00000000}},  //   _olen_, klēj, piki_,
  { {0x660300b0, 0x2d84014a, 0xbf9b00fa, 0x00000000}},  //   hink, şme_, liên,
  { {0x66030169, 0x2247010e, 0x78a90166, 0x00000000}},  // [480] kink, _kink_, _ćeva,
  { {0xceb4005f, 0x6603045c, 0xbf9b00c4, 0x00000000}},  //   _isə_, jink, niên,
  { {0x2247045d, 0x66030161, 0x2fc90022, 0x00000000}},  //   _mink_, dink, _ynag_,
  { {0x2247045e, 0xbf9b0011, 0xfbdf0082, 0x00000000}},  //   _link_, hiên, _hiên_,
  { {0x27e6045f, 0xfbdf0011, 0x8af0006b, 0x00000000}},  //   rkon_, _kiên_, rbəs,
  { {0x27e60460, 0x66030461, 0x27ed0462, 0x00000000}},  //   skon_, gink, _elen_,
  { {0xbf9b0181, 0xdcfe014a, 0x64a3003b, 0x00000000}},  //   diên, _kapı, ваја,
  { {0xfbdf00ad, 0x69dc0463, 0x24800213, 0x00000000}},  //   _liên_, _hore, čim_,
  { {0x51860088, 0x12be0044, 0x2327003b, 0x00000000}},  //   муна, েন্দ, моћи_,
  { {0xfbdf001d, 0x66030036, 0xdce70036, 0x00000000}},  //   _niên_, cink, lają,
  { {0x69dc01d9, 0x22470343, 0x9f4b0026, 0x00000000}},  //   _more, _dink_, dicò_,
  { {0xe36302a8, 0xd0110464, 0xdce70036, 0x00000000}},  //   _акци, الح_, nają,
  { {0x3f8501f6, 0xfbdf001d, 0x63a20058, 0x00000000}},  //   ğlu_, _biên_, _ibon,
  { {0x69dc0292, 0xbf9b0181, 0x9f4b008e, 0x00000000}},  //   _nore, ciên, ticó_,
  { {0xdb0f0211, 0x62860465, 0xdce70036, 0x00000000}},  //   _vací, škod, kają,
  { {0xdb0d0181, 0x22470240, 0x66030466, 0x00000000}},  //   ndaç, _zink_, zink,
  { {0x5a350467, 0xdce70046, 0xa3cf001c, 0x00000000}},  // [490] енат, dają, शात_,
  { {0x69dc0468, 0x7e6d0020, 0x27ff0093, 0x00000000}},  //   _core, _iwap, _smun_,
  { {0x69dc000d, 0x66030469, 0x27ed01aa, 0x00000000}},  //   _dore, vink, _plen_,
  { {0x6603046a, 0xdd0d0036, 0x7e6d046b, 0x00000000}},  //   wink, półp, _kwap,
  { {0x69dc02cc, 0xf77001fa, 0x3669046c, 0x00000000}},  //   _fore, شان_, чало_,
  { {0x69dc0059, 0x7e6d00e7, 0xfbdf0082, 0x00000000}},  //   _gore, _mwap, _xiên_,
  { {0xdcfe011f, 0x7648046d, 0x6603046e, 0x00000000}},  //   _yapı, _didy, rink,
  { {0x6603046f, 0x69dc0470, 0x7bdd0032, 0x00000000}},  //   sink, _zore, _josu,
  { {0xc245004c, 0x69dc008e, 0x66030471, 0x00000000}},  //   нник, _yore, pink,
  { {0xdb1d0039, 0x63a20472, 0x7bdd0473, 0x00000000}},  //   _insä, _ebon, _losu,
  { {0xbf9b0181, 0x059600a6, 0x91d00044, 0x00000000}},  //   riên, _سالگ, িসংখ,
  { {0x34bd013d, 0x6e250127, 0x7e6d0173, 0x00000000}},  //   ्मीद, _akhb, _bwap,
  { {0x224700f6, 0x62640088, 0x63b90016, 0x00000000}},  //   _tink_, _авіа, _iawn,
  { {0x63bb0474, 0xf1d0001d, 0x63b9002b, 0x00000000}},  //   ldun, _hạnh_, _hawn,
  { {0xfbdf00ad, 0x32050038, 0xa3e30061, 0x00000000}},  //   _viên_, mily_, _नका_,
  { {0x63bb0475, 0xc4d20476, 0x69dc0207, 0x00000000}},  //   ndun, נגן_, _sore,
  { {0x69dc01cd, 0xfbdf001d, 0xf1d0001d, 0x00000000}},  // [4a0] _pore, _tiên_, _mạnh_,
  { {0xf1d0001d, 0x81e10055, 0x7ae40009, 0x00000000}},  //   _lạnh_, নোর_, ryit,
  { {0x69dc0018, 0xdcfe0477, 0x229901aa, 0x00000000}},  //   _vore, _tapı, hèk_,
  { {0xf7720379, 0x629b0006, 0xe73a0478, 0x00000000}},  //   ااا_, ktuo, пее_,
  { {0x69dc01d9, 0xdce70036, 0x7c260066, 0x00000000}},  //   _tore, rają, _ikkr,
  { {0xb9060055, 0x629b00e0, 0x68310479, 0x00000000}},  //   _বই_, dtuo, råda,
  { {0x06d80044, 0xf7720025, 0x76480095, 0x00000000}},  //   _দেখি, _ماء_, _vidy,
  { {0xf1d0001d, 0x32660088, 0xd3700025, 0x00000000}},  //   _cạnh_, нтов, جهة_,
  { {0x63b9047a, 0x7648000a, 0x75280036, 0x00000000}},  //   _dawn, _tidy, _wydz,
  { {0x75280036, 0x26c40032, 0x51f701ab, 0x00000000}},  //   _tydz, _irmo_, енью_,
  { {0x7e6d001c, 0x68150036, 0x63b90066, 0x00000000}},  //   _swap, ląda, _fawn,
  { {0x63a2047b, 0x20d50006, 0x26c40087, 0x00000000}},  //   _ubon, džią_, _krmo_,
  { {0x91e60216, 0x629b00f6, 0x2d85029d, 0x00000000}},  //   _поде, ctuo, óleo_,
  { {0x92f2005d, 0x7bdd0035, 0x00000000, 0x00000000}},  //   ığım, _sosu,   ,
  { {0x7bdd047c, 0xe5710049, 0x442601c5, 0x00000000}},  //   _posu, יַן_, _kko_,
  { {0x7e6d0418, 0x44260087, 0x00000000, 0x00000000}},  //   _twap, _jko_,   ,
  { {0x442600e7, 0xe987003b, 0xafdb0190, 0x00000000}},  // [4b0] _mko_, ећен, rmød,
  { {0xafdb0030, 0x99990006, 0x3ea90022, 0x00000000}},  //   smød, _rusų_, _ipat_,
  { {0xa775047d, 0x78ba0027, 0x26c40023, 0x00000000}},  //   влеч, _štvr, _armo_,
  { {0x4426047e, 0xfbdf0011, 0x6b67009d, 0x00000000}},  //   _nko_, _kiêm_, _dégâ,
  { {0x7c2d047f, 0x63b9002b, 0x212b0011, 0x00000000}},  //   mlar, _rawn, ́ch_,
  { {0x44260480, 0x7c2d0481, 0x66e2007c, 0x00000000}},  //   _ako_, llar, роша,
  { {0x32050482, 0xfbdf0011, 0x66e70089, 0x00000000}},  //   vily_, _liêm_, _sīkā,
  { {0x7c2d01f6, 0xd6d80055, 0xe795026c, 0x00000000}},  //   nlar, _দেওয, _جاسک,
  { {0x63bb022b, 0x7c2d002d, 0xfbdf0011, 0x00000000}},  //   rdun, ilar, _niêm_,
  { {0x3d1a03d7, 0x629b0006, 0x4426022b, 0x00000000}},  //   _मुझे_, rtuo, _eko_,
  { {0x7c2d0483, 0x629b0484, 0x23e701fb, 0x00000000}},  //   klar, stuo, _підв,
  { {0x7c2d011f, 0x320500ab, 0x629b007f, 0x00000000}},  //   jlar, sily_, ptuo,
  { {0x443f0485, 0x442d0486, 0x7c2d01f6, 0x00000000}},  //   mmu_, mle_, dlar,
  { {0x644b006a, 0x7c2d006c, 0x3ea90487, 0x00000000}},  //   _higi, elar, _dpat_,
  { {0x442d0488, 0x68380489, 0xed57003b, 0x00000000}},  //   ole_, líde, тос_,
  { {0x2d81048a, 0xb7bc0055, 0x442d048b, 0x00000000}},  //   _edhe_, _অক্ট, nle_,
  { {0x442d048c, 0xdb0f0051, 0x2019048d, 0x00000000}},  // [4c0] ile_, _pacá, érie_,
  { {0x442d048e, 0x644b048f, 0x7c2d0032, 0x00000000}},  //   hle_, _ligi, alar,
  { {0x7c2d006b, 0x7db5008b, 0x442d0490, 0x00000000}},  //   blar, _ёсьц, kle_,
  { {0x443f01ca, 0x442d0030, 0x7c2d0491, 0x00000000}},  //   jmu_, jle_, clar,
  { {0x442d0224, 0x443f0066, 0x9696005e, 0x00000000}},  //   dle_, dmu_, треш,
  { {0x442d001f, 0x44260492, 0x628900f8, 0x00000000}},  //   ele_, _sko_, dreo,
  { {0x69ce0493, 0x644b0494, 0x442d02f1, 0x00000000}},  //   _inbe, _bigi, fle_,
  { {0x442d0018, 0x68e30495, 0xe4e301fb, 0x00000000}},  //   gle_, ände, рішн,
  { {0x62890496, 0x26c4010e, 0x00000000, 0x00000000}},  //   greo, _urmo_,   ,
  { {0x442d0198, 0x644b009f, 0x7c2d0497, 0x00000000}},  //   ale_, _eigi, zlar,
  { {0x442d0498, 0x44260209, 0xf99300b6, 0x00000000}},  //   ble_, _tko_, ברת_,
  { {0x442d028a, 0x44260499, 0x62890051, 0x00000000}},  //   cle_, _uko_, breo,
  { {0x7c24049a, 0x69ce049b, 0x4424049c, 0x00000000}},  //   doir, _onbe, mom_,
  { {0x8277007b, 0x24580011, 0xfbdf0011, 0x00000000}},  //   _יעדע_, _kém_, _viêm_,
  { {0x7c2d038c, 0x2d5802d3, 0x7c240051, 0x00000000}},  //   tlar, тись_, foir,
  { {0x69ce02cc, 0x0a6b01fc, 0x6c6a00a1, 0x00000000}},  //   _anbe, држи_, علقہ_,
  { {0x7c2d049d, 0x6d5c0026, 0x644000b0, 0x00000000}},  // [4d0] rlar, bcra, immi,
  { {0x4424049e, 0x7c2d049f, 0x442d04a0, 0x00000000}},  //   hom_, slar, zle_,
  { {0x442d04a1, 0x7c2d047f, 0x443f04a2, 0x00000000}},  //   yle_, plar, ymu_,
  { {0x442404a3, 0x7c2d005f, 0xb8db0204, 0x00000000}},  //   jom_, qlar, _अन_,
  { {0x442d04a4, 0x7e7d01d6, 0xc1780006, 0x00000000}},  //   vle_, nssp, nkės_,
  { {0x69d80010, 0xdb0600b9, 0x1a680014, 0x00000000}},  //   övet, _jaký, _شیمی_,
  { {0x442d0365, 0x18b80057, 0x644b04a5, 0x00000000}},  //   tle_, _игры_, _pigi,
  { {0x44240119, 0x442d00f4, 0x7e7d0109, 0x00000000}},  //   gom_, ule_, kssp,
  { {0x442d04a6, 0x11d90025, 0x6d5c0093, 0x00000000}},  //   rle_, فوظة_, ycra,
  { {0x442d04a7, 0xe0d900ed, 0x628904a8, 0x00000000}},  //   sle_, ево_, rreo,
  { {0x442d0038, 0x4424049c, 0x339500f3, 0x00000000}},  //   ple_, bom_, _ملاز,
  { {0x442404a9, 0x7f5d0009, 0x644b00e7, 0x00000000}},  //   com_, gcsq, _uigi,
  { {0x7c2400f4, 0x3f9e0036, 0x00000000, 0x00000000}},  //   voir, ętu_,   ,
  { {0x7bcf04aa, 0xdb0404ab, 0x645c00c4, 0x00000000}},  //   _ancu, leiç, _éric,
  { {0x7c24028c, 0x6d5c00ab, 0x2019009d, 0x00000000}},  //   toir, rcra, éric_,
  { {0xf092009b, 0x6d5c0051, 0xabf504ac, 0x00000000}},  //   _הנה_, scra, ачущ,
  { {0xed5a00c0, 0x7c2404ad, 0x00000000, 0x00000000}},  // [4e0] _поп_, roir,   ,
  { {0x7bcf0219, 0x7c24009d, 0x7a2b006c, 0x00000000}},  //   _encu, soir, kütu,
  { {0xdb0404ae, 0x2fd7007a, 0x6fd80204, 0x00000000}},  //   rdiñ, _شوید_, यापू,
  { {0x61e00201, 0x27e0009f, 0x78800428, 0x00000000}},  //   _पक्ष, ðin_, _návš,
  { {0x442404a3, 0x4a7504af, 0x2bd10061, 0x00000000}},  //   vom_, _выст, हारा,
  { {0x69ce010f, 0x00000000, 0x00000000, 0x00000000}},  //   _unbe,   ,   ,
  { {0x44240027, 0xdb040181, 0x657800ea, 0x00000000}},  //   tom_, feiç, ravh,
  { {0xd90d007a, 0x7e6404b0, 0x3a2a0093, 0x00000000}},  //   _تیم_, _otip, _hkbp_,
  { {0x81bc001e, 0x659604b1, 0x00000000, 0x00000000}},  //   klēt, _مجار,   ,
  { {0x683800b9, 0x00000000, 0x00000000, 0x00000000}},  //   bídc,   ,   ,
  { {0xf99300b6, 0x7e640058, 0xf48700a6, 0x00000000}},  //   זרת_, _atip, _مانی,
  { {0xde59008b, 0x7e7d04b2, 0x1e1d013d, 0x00000000}},  //   камі_, tssp, पक्ष_,
  { {0x81e30044, 0xbb1b0035, 0x00000000, 0x00000000}},  //   _নগর_, _adîn,   ,
  { {0xdb070047, 0x7e7d04b3, 0xdb060010, 0x00000000}},  //   ámít, rssp, _lakó,
  { {0x7e6400d9, 0x9f52000a, 0x00000000, 0x00000000}},  //   _etip, _olyè_,   ,
  { {0xdb06005a, 0x3a2a0093, 0x7a2b010f, 0x00000000}},  //   _fakü, _akbp_, hütt,
  { {0x200b04b4, 0x497504b5, 0x7b6404b6, 0x00000000}},  // [4f0] mici_, илас, стсе,
  { {0xdd910014, 0x200b0207, 0xd91b007c, 0x00000000}},  //   _بود_, lici_, нье_,
  { {0xd7e701ff, 0x00000000, 0x00000000, 0x00000000}},  //   лідо,   ,   ,
  { {0x200b0119, 0x69d80039, 0xf3f10082, 0x00000000}},  //   nici_, över, _mục_,
  { {0x3a2a04b7, 0x7c3a00f4, 0xdae600a1, 0x00000000}},  //   _fkbp_, ître, _پہلو_,
  { {0x48770137, 0x7bd70006, 0xdb0e000c, 0x00000000}},  //   _مدرس, šbuč, _þjál,
  { {0xdb1d0030, 0x200b014a, 0x25b60025, 0x00000000}},  //   _ansø, kici_, شهيد_,
  { {0x69c901f5, 0x73e50242, 0x200b036a, 0x00000000}},  //   _होती, роиз, jici_,
  { {0x200b04b8, 0x2215025f, 0x00000000, 0x00000000}},  //   dici_, ифор,   ,
  { {0xe12500ed, 0x7a3000b0, 0x9f590026, 0x00000000}},  //   импи, vätk, misù_,
  { {0x200b04b9, 0xdb0601aa, 0x7e6404ba, 0x00000000}},  //   fici_, _jakò, _stip,
  { {0x200b0207, 0x76430093, 0xdb060173, 0x00000000}},  //   gici_, lmny, _makò,
  { {0x3263026c, 0xdb0601aa, 0x32670098, 0x00000000}},  //   _انتہ, _lakò, _стев,
  { {0x3f8c006b, 0x7e6404bb, 0x00000000, 0x00000000}},  //   şdu_, _vtip,   ,
  { {0x76430022, 0x61e304bc, 0x00000000, 0x00000000}},  //   imny, _ionl,   ,
  { {0x61e30047, 0x78450006, 0x6ab601d6, 0x00000000}},  //   _honl, _tėvy, twyf,
  { {0x395601f9, 0x7a2b0010, 0xda650025, 0x00000000}},  // [500] ањет, yütt, مالي,
  { {0x2fc000d4, 0xdb06000a, 0xdb1d000a, 0x00000000}},  //   _haig_, _bakò, _masè,
  { {0x61e300fa, 0xd826005e, 0xdb1d000a, 0x00000000}},  //   _monl, аджи, _lasè,
  { {0x443d018e, 0xe666008b, 0xb8ce03d7, 0x00000000}},  //   _nhw_, атко, _कह_,
  { {0x2fc004bd, 0x660a04be, 0xb86600a1, 0x00000000}},  //   _maig_, tifk, _چارو,
  { {0x200b013e, 0x2d9802e1, 0x645e0181, 0x00000000}},  //   zici_, ngre_, ípio,
  { {0x200b014a, 0x443d0145, 0x7a3000b0, 0x00000000}},  //   yici_, _bhw_, jäti,
  { {0x443d04bf, 0xe8d7009b, 0x25a000b9, 0x00000000}},  //   _chw_, _דולר_, řil_,
  { {0x9f49014a, 0x443d04c0, 0x61e304c1, 0x00000000}},  //   _ilaç_, _dhw_, _bonl,
  { {0xc05a008b, 0x61e3008e, 0x443d0022, 0x00000000}},  //   кім_, _conl, _ehw_,
  { {0x200b04c2, 0x61e304c3, 0x3a3700b3, 0x00000000}},  //   tici_, _donl, שרים_,
  { {0x61e304c4, 0x00000000, 0x00000000, 0x00000000}},  //   _eonl,   ,   ,
  { {0x200b005f, 0x2fc00058, 0x00000000, 0x00000000}},  //   rici_, _daig_,   ,
  { {0x200b001a, 0x628204c5, 0x628000f8, 0x00000000}},  //   sici_, _ivoo, msmo,
  { {0x52b602d2, 0x200b04c6, 0x2fc00129, 0x00000000}},  //   _अनुस, pici_, _faig_,
  { {0xd0f7009b, 0x3b55007e, 0x2fc000f6, 0x00000000}},  //   _כמות_, скар, _gaig_,
  { {0xa3a80201, 0x62800056, 0x69de00ea, 0x00000000}},  // [510] ख्य_, nsmo, fjpe,
  { {0xf9930464, 0x683801dc, 0x9967005c, 0x00000000}},  //   تبر_, vída, ртал,
  { {0xb9c40025, 0x00000000, 0x00000000, 0x00000000}},  //   تقلي,   ,   ,
  { {0x3f9904c7, 0x2a69010e, 0x27ed0066, 0x00000000}},  //   ngsu_, ppab_, _ċens_,
  { {0x6fd8001c, 0xf9930025, 0x27e40035, 0x00000000}},  //   यातू, _وبس_, _domn_,
  { {0x6280005b, 0x7aed0093, 0x443d013e, 0x00000000}},  //   dsmo, myat, _shw_,
  { {0xfc3f001d, 0x628604c8, 0x7aed04c9, 0x00000000}},  //   _khí_, škol, lyat,
  { {0x81c30055, 0x1d18009b, 0x61e3005d, 0x00000000}},  //   _একই_, יקור_, _sonl,
  { {0xfc3f002a, 0x7aed020c, 0xf1d20061, 0x00000000}},  //   _mhí_, nyat, तांन,
  { {0x61fa00ab, 0x673b016c, 0x7a3004ca, 0x00000000}},  //   ghtl, _izuj, täti,
  { {0x628001d6, 0x20090022, 0x7aed0022, 0x00000000}},  //   asmo, _bmai_, hyat,
  { {0xfc3f0011, 0xfbdf0082, 0x7aed04cb, 0x00000000}},  //   _nhí_, _kiêu_, kyat,
  { {0x2fc004bd, 0x62800066, 0x7a3000b0, 0x00000000}},  //   _vaig_, csmo, säti,
  { {0x61fa04cc, 0xfc3f0211, 0x7aed04cd, 0x00000000}},  //   chtl, _ahí_, dyat,
  { {0x40950025, 0xfc3f0195, 0xfbdf0011, 0x00000000}},  //   _العر, _bhí_, _liêu_,
  { {0xfc3f001d, 0x3ce50039, 0x7ff60167, 0x00000000}},  //   _chí_, älva_, _دستا,
  { {0x68e304ce, 0x44c70082, 0x7aed0010, 0x00000000}},  // [520] ändn, _lđ_, gyat,
  { {0xc33200b6, 0x27e4001a, 0xdb04009d, 0x00000000}},  //   לון_, _somn_, nfié,
  { {0xe93a00ed, 0x44c70011, 0xb17a0049, 0x00000000}},  //   учај_, _nđ_, רטער,
  { {0x62800016, 0x8b960088, 0x7aed0045, 0x00000000}},  //   ysmo, _уроч, byat,
  { {0x673b0036, 0x683800b9, 0x661a0093, 0x00000000}},  //   _czuj, bídn, _pjtk,
  { {0x99d60151, 0x44c70082, 0x8af0006b, 0x00000000}},  //   _اتحا, _bđ_, dbəx,
  { {0x6aa40161, 0x44c70011, 0x75890088, 0x00000000}},  //   ltif, _cđ_, рсів_,
  { {0xc7a304cf, 0x7bc404d0, 0x628000f8, 0x00000000}},  //   _ниск, ndiu, tsmo,
  { {0x320c013e, 0x20090145, 0x00000000, 0x00000000}},  //   tidy_, _rmai_,   ,
  { {0x628004d1, 0x776204d2, 0x00000000, 0x00000000}},  //   rsmo, lcox,   ,
  { {0x201902d5, 0x628004d3, 0x546a00ed, 0x00000000}},  //   ério_, ssmo, _саем_,
  { {0x7aed005f, 0x6aa404d4, 0xf537009b, 0x00000000}},  //   yyat, ktif, _פנאי_,
  { {0x7336007a, 0x833603d6, 0x657a0023, 0x00000000}},  //   _ارائ, _اراض, _keth,
  { {0x329b019b, 0x645a04d5, 0x9f4000f6, 0x00000000}},  //   _עבוד, _kuti, _alió_,
  { {0xfc3f001d, 0x657a0038, 0xf1a9007a, 0x00000000}},  //   _phí_, _meth, _خانه_,
  { {0x645a002d, 0x317e010f, 0xddcd0161, 0x00000000}},  //   _muti, latz_, _uvaž,
  { {0x1a5b0025, 0xed4e00a1, 0x3f890145, 0x00000000}},  // [530] اشرة_, ٹھی_, _idau_,
  { {0x645a028c, 0x7aed04be, 0x657a00ab, 0x00000000}},  //   _outi, ryat, _neth,
  { {0xe8e000ad, 0x2bc4024c, 0xfbdf0011, 0x00000000}},  //   ười_, _लोका, _siêu_,
  { {0x317e04d6, 0x473500ed, 0x657a0016, 0x00000000}},  //   hatz_, онес, _aeth,
  { {0x657a0016, 0x6aa400f4, 0x3f890020, 0x00000000}},  //   _beth, ctif, _mdau_,
  { {0x645a04d7, 0x25a90166, 0x1958007e, 0x00000000}},  //   _buti, đalo_, _гары_,
  { {0x69d50428, 0x645a001a, 0x6d570061, 0x00000000}},  //   _inze, _cuti, _mgxa,
  { {0xfbdf001d, 0x69c504d8, 0x645a04d9, 0x00000000}},  //   _tiêu_, ldhe, _duti,
  { {0x6fdd04da, 0xdb1d00dc, 0x657a04db, 0x00000000}},  //   यानं, _insó, _feth,
  { {0x645a0052, 0x657a04dc, 0x80a904dd, 0x00000000}},  //   _futi, _geth, авов_,
  { {0xf99201f8, 0x645a04de, 0x69c504df, 0x00000000}},  //   ורי_, _guti, idhe,
  { {0x7a3004e0, 0x777b00f4, 0x81bc0089, 0x00000000}},  //   lätt, _jeux, slēp,
  { {0xeef5008b, 0x3f89018e, 0x645a0032, 0x00000000}},  //   пярэ, _ddau_, _zuti,
  { {0x317e0061, 0x20190093, 0x63a901a2, 0x00000000}},  //   catz_, ansi_, lfen,
  { {0xb1470014, 0x68e301a2, 0x442f0022, 0x00000000}},  //   _دیدم_, ändl, _kkg_,
  { {0x69d5001f, 0x26cd00e0, 0x6aa40197, 0x00000000}},  //   _anze, _oreo_, ttif,
  { {0x6aa400ab, 0x7bc4006c, 0xb4b6007d, 0x00000000}},  // [540] utif, rdiu, _छन्_,
  { {0x8eb3026c, 0xe9d701e1, 0x69c50250, 0x00000000}},  //   _کمیش, оку_, gdhe,
  { {0xd91004e1, 0x02b60309, 0x9dd701ce, 0x00000000}},  //   ریر_, _अन्न, _וויק_,
  { {0x645a001a, 0x5fdd0061, 0x657a04e2, 0x00000000}},  //   _ruti, यायल, _seth,
  { {0x26cd0219, 0x645a010a, 0x777b00f4, 0x00000000}},  //   _creo_, _suti, _deux,
  { {0x645a04e3, 0x7c36000c, 0x63a904e4, 0x00000000}},  //   _puti, llyr, efen,
  { {0x63a904e5, 0x6fca0164, 0x442f04e6, 0x00000000}},  //   ffen, ियां, _bkg_,
  { {0x657a00bb, 0x63a90016, 0x044300ed, 0x00000000}},  //   _weth, gfen, мејн,
  { {0x442f04e7, 0x657a0322, 0x00000000, 0x00000000}},  //   _dkg_, _teth,   ,
  { {0x645a0232, 0x238c0006, 0x51f803e8, 0x00000000}},  //   _tuti, dėjų_, сною_,
  { {0x645a021e, 0x4254007a, 0x69db0061, 0x00000000}},  //   _uuti, _کنتر, नाती,
  { {0x317e010f, 0x442f01e5, 0x00000000, 0x00000000}},  //   satz_, _gkg_,   ,
  { {0x41e6007e, 0x53160014, 0x00000000, 0x00000000}},  //   _міка, _بذار,   ,
  { {0x81f804e8, 0x386a00fa, 0x3f8401e5, 0x00000000}},  //   _دفتر_, _otbr_, ómur_,
  { {0x271c001d, 0x644204e9, 0x71260025, 0x00000000}},  //   ỉnh_, _khoi, _برشل,
  { {0x3eb20045, 0xdfd10025, 0x929d00b4, 0x00000000}},  //   _fpyt_, _أية_, szłe,
  { {0x8af0006b, 0x64420051, 0x69c50023, 0x00000000}},  // [550] dcəs, _mhoi, tdhe,
  { {0x78a5009f, 0x00000000, 0x00000000, 0x00000000}},  //   tthv,   ,   ,
  { {0x69c504ea, 0x9f40000c, 0x26cd04eb, 0x00000000}},  //   rdhe, _hlið_, _sreo_,
  { {0x78a500ea, 0x76410023, 0x69c50023, 0x00000000}},  //   rthv, _shly, sdhe,
  { {0x7c2d002d, 0x7bda009b, 0x7a3004ec, 0x00000000}},  //   moar, _הקרו, tätt,
  { {0x7c2d000d, 0x26cd001a, 0x290704ed, 0x00000000}},  //   loar, _vreo_, únas_,
  { {0x7a3004ee, 0x6ab9006b, 0x442f01a3, 0x00000000}},  //   rätt, şafı, _pkg_,
  { {0x7a3004ee, 0x57b404ef, 0x644204f0, 0x00000000}},  //   sätt, _обст, _choi,
  { {0xd5bb04f1, 0x63a904f2, 0x64420051, 0x00000000}},  //   _все_, rfen, _dhoi,
  { {0xdb0d04f3, 0x7c2d04f4, 0x00000000, 0x00000000}},  //   ndañ, hoar,   ,
  { {0xf99200bd, 0x6442002a, 0x7c2d022b, 0x00000000}},  //   ערט_, _fhoi, koar,
  { {0xa3bb0070, 0xb4d7007d, 0x7f8500a1, 0x00000000}},  //   _خاطر_, ामी_, ولپن,
  { {0x7c2d04f5, 0x644900f4, 0xdb1d04f6, 0x00000000}},  //   doar, mmei, _basí,
  { {0x64490181, 0x238c007f, 0x8b0800b4, 0x00000000}},  //   lmei, rėjų_, nięż,
  { {0x7c2d04f7, 0xe6b8013d, 0x7c3a009d, 0x00000000}},  //   foar, _इन्ज, îtro,
  { {0x442d0253, 0x7c2d04f8, 0x1e8604f9, 0x00000000}},  //   noe_, goar, _елим,
  { {0x3f8201a3, 0x00000000, 0x00000000, 0x00000000}},  // [560] maku_,   ,   ,
  { {0x3f8204fa, 0x644904fb, 0xdcfc04fc, 0x00000000}},  //   laku_, hmei, larč,
  { {0x53bd0164, 0x442d04fd, 0x23bd0309, 0x00000000}},  //   ्याश, koe_, ्याद,
  { {0x442d0066, 0x7a30010f, 0xdb1d00b9, 0x00000000}},  //   joe_, täts, _zasí,
  { {0x5fdd001c, 0x442d0112, 0x644904fe, 0x00000000}},  //   यातल, doe_, dmei,
  { {0x7bc604ff, 0xe5340500, 0x3f8200b0, 0x00000000}},  //   _haku, мель, haku_,
  { {0x6442002a, 0x7bc6011c, 0x64490501, 0x00000000}},  //   _phoi, _kaku, fmei,
  { {0x2937007b, 0x7bc60502, 0x442d0035, 0x00000000}},  //   _זאלן_, _jaku, goe_,
  { {0x7bc60503, 0x31650061, 0x3f8201a3, 0x00000000}},  //   _maku, fclz_, daku_,
  { {0x7bc604cb, 0x7c2d04f8, 0x6e2e00f8, 0x00000000}},  //   _laku, zoar, jobb,
  { {0x6442002a, 0x442d046a, 0x6e2e0197, 0x00000000}},  //   _thoi, boe_, dobb,
  { {0x7bc601d9, 0x7c2d002d, 0xdcfc0107, 0x00000000}},  //   _naku, xoar, garč,
  { {0x63a20472, 0x7c2d001a, 0xdb0d00c4, 0x00000000}},  //   _icon, voar, meaç,
  { {0x91e30216, 0x611402a8, 0x7bc60058, 0x00000000}},  //   _поче, _одлу, _aaku,
  { {0x7c2d000d, 0x7bc60504, 0xdcfc0505, 0x00000000}},  //   toar, _baku, barč,
  { {0x7bc60093, 0x2c0d0061, 0x61ea0506, 0x00000000}},  //   _caku, _सगळं_, _hofl,
  { {0x7c2d002d, 0x4a55007e, 0x7bc60142, 0x00000000}},  // [570] roar, дкас, _daku,
  { {0x68380224, 0x7c2d0507, 0x7e6d0508, 0x00000000}},  //   bídk, soar, _itap,
  { {0x2d830509, 0x7c2d001a, 0x41ae0309, 0x00000000}},  //   maje_, poar, ज्यस,
  { {0x27e9009f, 0x2d9c0073, 0x2d83050a, 0x00000000}},  //   ðan_, _över_, laje_,
  { {0x6fa503d7, 0x442d016c, 0x7e69001a, 0x00000000}},  //   _कानू, voe_, _împă,
  { {0x63a2050b, 0x7bc60046, 0x2d830211, 0x00000000}},  //   _acon, _zaku, naje_,
  { {0x442d050c, 0x7bc60453, 0x6449050d, 0x00000000}},  //   toe_, _yaku, tmei,
  { {0x69c70190, 0x2d83000a, 0x63a20009, 0x00000000}},  //   _haje, haje_, _ccon,
  { {0x69c7050e, 0x6449010f, 0xdcfc050f, 0x00000000}},  //   _kaje, rmei, varč,
  { {0xa8790049, 0x3f8201a3, 0x78a10510, 0x00000000}},  //   ֿאָר, waku_, _älvs,
  { {0x69c70161, 0x9327025a, 0x3f8201a3, 0x00000000}},  //   _maje, _کران, taku_,
  { {0x63a20051, 0x69c70511, 0x683801dc, 0x00000000}},  //   _gcon, _laje, vídk,
  { {0x7bc60512, 0x3f820513, 0x63bb00e7, 0x00000000}},  //   _raku, raku_, meun,
  { {0x7bc60209, 0x69c70514, 0x2d8301aa, 0x00000000}},  //   _saku, _naje, gaje_,
  { {0x7bc60515, 0x6e2e0516, 0xed570517, 0x00000000}},  //   _paku, robb, дор_,
  { {0x8c4300e2, 0x6e2e0026, 0xf3f80089, 0x00000000}},  //   весе, sobb, _kuģa_,
  { {0x7bc600b0, 0x69c70518, 0xc22200a1, 0x00000000}},  // [580] _vaku, _baje, _سکیو,
  { {0x7bc6000b, 0x68380181, 0x7c290091, 0x00000000}},  //   _waku, mídi, čera,
  { {0x7bc60127, 0x69c70213, 0x1c46003b, 0x00000000}},  //   _taku, _daje, _оном,
  { {0x63bb00f4, 0x00000000, 0x00000000, 0x00000000}},  //   jeun,   ,   ,
  { {0xa3e10164, 0x69c70519, 0x6b840048, 0x00000000}},  //   दान_, _faje, maig,
  { {0x6b84002a, 0x69c7051a, 0x63a2051b, 0x00000000}},  //   laig, _gaje, _scon,
  { {0x63a20009, 0x628f00fa, 0x61ea0095, 0x00000000}},  //   _pcon, ácon, _rofl,
  { {0x69c70119, 0x6b84002a, 0x2d830211, 0x00000000}},  //   _zaje, naig, zaje_,
  { {0x2d8301aa, 0x752d005a, 0xdb0d00fa, 0x00000000}},  //   yaje_, ğaza, reaç,
  { {0x27e6021e, 0x6b84051c, 0x24f6007c, 0x00000000}},  //   ljon_, haig, _очер,
  { {0x2d830470, 0xd4c60439, 0x6b8400e0, 0x00000000}},  //   vaje_, _تغذي, kaig,
  { {0x68e3051d, 0x2d83051e, 0x6e95051f, 0x00000000}},  //   ändi, waje_, ниму,
  { {0x6b840051, 0x2d830213, 0xfe6e025a, 0x00000000}},  //   daig, taje_, یگی_,
  { {0x61ac0044, 0x00000000, 0x00000000, 0x00000000}},  //   _কোরআ,   ,   ,
  { {0x2d830520, 0x6b840051, 0x69c70253, 0x00000000}},  //   raje_, faig, _raje,
  { {0x2d83000d, 0xa0080054, 0x20020521, 0x00000000}},  //   saje_, _يقول_, chki_,
  { {0x2d830522, 0x7e6d0523, 0x68380181, 0x00000000}},  // [590] paje_, _utap, cídi,
  { {0x2fc900b5, 0xdb1d0524, 0x00000000, 0x00000000}},  //   _haag_, _casá,   ,
  { {0x6b84010a, 0x61e70039, 0x26c4002d, 0x00000000}},  //   baig, öjli, _asmo_,
  { {0x2d810525, 0x69c70526, 0x2fc90007, 0x00000000}},  //   _hehe_, _waje, _jaag_,
  { {0xdb1d0527, 0x2fc90168, 0x69c70528, 0x00000000}},  //   _ansö, _maag_, _taje,
  { {0x7a2b010f, 0x2fc901b5, 0xa594005e, 0x00000000}},  //   hütz, _laag_, връщ,
  { {0x63bb015c, 0x6fa50061, 0x2d81006c, 0x00000000}},  //   teun, _काढू, _mehe_,
  { {0x321e013e, 0x2d81006c, 0x75fd0173, 0x00000000}},  //   enty_, _lehe_, _dèza,
  { {0xc6a40081, 0x63bb010f, 0xb06500b0, 0x00000000}},  //   _архи, reun, kyää,
  { {0xddc40091, 0x63bb0529, 0xdb0400c4, 0x00000000}},  //   _otiš, seun, nfiá,
  { {0x27ed00bb, 0x83fc0091, 0x932400a2, 0x00000000}},  //   _koen_, _suđe, فرین,
  { {0x6838052a, 0x321e0022, 0x00000000, 0x00000000}},  //   tídi, anty_,   ,
  { {0x2d81002d, 0x2fc9052b, 0x6b84052c, 0x00000000}},  //   _behe_, _daag_, vaig,
  { {0x6838052d, 0x27ff018e, 0x11d90025, 0x00000000}},  //   rídi, _llun_, _روعة_,
  { {0x6b84052e, 0xc5f2052f, 0x62860530, 0x00000000}},  //   taig, נדל_, škot,
  { {0x27ed0292, 0x64590009, 0x683800fa, 0x00000000}},  //   _noen_, _jiwi, pídi,
  { {0x64590020, 0x6b840531, 0x62890056, 0x00000000}},  // [5a0] _miwi, raig, nseo,
  { {0x6b84002a, 0x2d81010f, 0x27ff0532, 0x00000000}},  //   saig, _gehe_, _alun_,
  { {0xdb1d0010, 0x7d7b009b, 0x6b840533, 0x00000000}},  //   _vasá, _מניו, paig,
  { {0x27ed00bb, 0xc6a60534, 0x25a5005b, 0x00000000}},  //   _coen_, ерки, _acll_,
  { {0x27ed0100, 0x79850009, 0x27e60232, 0x00000000}},  //   _doen_, bahw, rjon_,
  { {0x27e60535, 0x25a500f6, 0x3e660082, 0x00000000}},  //   sjon_, _ccll_, _môt_,
  { {0x69dc0536, 0x20000026, 0x8cd3013d, 0x00000000}},  //   _inre, _olii_, डियो,
  { {0xb5fd049c, 0x3447007e, 0xafdb00ea, 0x00000000}},  //   _ruše, нчын_, nmøt,
  { {0xb5fd040d, 0xf1db0061, 0x64590537, 0x00000000}},  //   _suše, बांन, _diwi,
  { {0x44ce0036, 0x171b0049, 0x22580538, 0x00000000}},  //   _tę_, _זומע, örk_,
  { {0x7a2b010f, 0x5a17009b, 0x00000000, 0x00000000}},  //   tütz, תקין_,   ,
  { {0x2d81010f, 0x00000000, 0x00000000, 0x00000000}},  //   _sehe_,   ,   ,
  { {0x69dc00c7, 0xee3f0062, 0x2fc90539, 0x00000000}},  //   _onre, stým_, _vaag_,
  { {0xb5fd00ca, 0x6286053a, 0x2fc90007, 0x00000000}},  //   _tuše, škos, _waag_,
  { {0x9c470147, 0x765a0006, 0x11e90025, 0x00000000}},  //   ехал, _mity, _تعني_,
  { {0x69dc053b, 0x765a0173, 0xc1780006, 0x00000000}},  //   _anre, _lity, lbė_,
  { {0x5a35053c, 0xa3e101f5, 0x2d8100e7, 0x00000000}},  // [5b0] внат, दात_, _tehe_,
  { {0x27ed0007, 0x61fa053d, 0x00000000, 0x00000000}},  //   _soen_, nktl,   ,
  { {0xe611025a, 0x27ed0016, 0xdcfc0089, 0x00000000}},  //   یشت_, _poen_, parā,
  { {0x69dc053e, 0x87e4053f, 0xe7190025, 0x00000000}},  //   _enre, люче, ويات_,
  { {0xf7700188, 0x7bdd00ab, 0x765a0540, 0x00000000}},  //   صان_, _insu, _bity,
  { {0x765a0541, 0x0c74007a, 0xceb400a0, 0x00000000}},  //   _city, _جدید, ריס_,
  { {0x27ed02ae, 0xdb04009f, 0x6aad01e5, 0x00000000}},  //   _toen_, leið, ltaf,
  { {0xc447026c, 0x7bcd0542, 0x19580147, 0x00000000}},  //   ریشن_, ndau, _часы_,
  { {0x62890061, 0x24800091, 0x7c3a00f4, 0x00000000}},  //   useo, ćima_, îtri,
  { {0x929d0036, 0x64590093, 0x6289008a, 0x00000000}},  //   szło, _wiwi, rseo,
  { {0x7bdd0543, 0x628900ea, 0xdb04000c, 0x00000000}},  //   _onsu, sseo, heið,
  { {0xdb04000c, 0x6289010e, 0x00000000, 0x00000000}},  //   keið, pseo,   ,
  { {0x764800b0, 0x6d450145, 0x7bcd0544, 0x00000000}},  //   _yhdy, _azha, ddau,
  { {0x51870545, 0x7bdd01a3, 0x7af600b0, 0x00000000}},  //   _чуда, _ansu, vyyt,
  { {0x15f4013d, 0x6aad0546, 0xc223009e, 0x00000000}},  //   _अवसर_, etaf, _لکھو,
  { {0x7ae4002d, 0x3e660547, 0x7bcd0548, 0x00000000}},  //   txit, _tôt_, gdau,
  { {0xdfd2026c, 0x00000000, 0x00000000, 0x00000000}},  // [5c0] _ميں_,   ,   ,
  { {0xfe9b00b3, 0x7bdd0549, 0xafdb00ea, 0x00000000}},  //   _קיימ, _ensu, smøt,
  { {0x7e6400b0, 0x7af600b0, 0xeb9f0030, 0x00000000}},  //   _huip, syyt, _blød_,
  { {0x7e640020, 0x6601006c, 0x765a01aa, 0x00000000}},  //   _kuip, _allk, _sity,
  { {0x765a054a, 0x77910167, 0xc7a3017f, 0x00000000}},  //   _pity, صیلا, ричк,
  { {0x6838054b, 0x69dc01ac, 0x9633007e, 0x00000000}},  //   vídu, _unre, аніц,
  { {0x7e64054c, 0x32050022, 0xeb9f0190, 0x00000000}},  //   _luip, dhly_, _flød_,
  { {0x59e00061, 0x2cba0085, 0xeb9f0146, 0x00000000}},  //   नावर, _mppd_, _glød_,
  { {0x2a660048, 0x2cba0093, 0xd403054d, 0x00000000}},  //   íobh_, _lppd_, рящи,
  { {0x320500ab, 0x7bcd007f, 0x00000000, 0x00000000}},  //   ghly_, zdau,   ,
  { {0xa99b0049, 0x68380181, 0x61fa054e, 0x00000000}},  //   וביר, sídu, rktl,
  { {0xc058008b, 0x66180062, 0x2d87012d, 0x00000000}},  //   кія_, livk, _žne_,
  { {0xa294007e, 0x44260093, 0x672901f3, 0x00000000}},  //   _салі, _ijo_, _xxej,
  { {0x2731001d, 0xdb04000c, 0x32050142, 0x00000000}},  //   ỡng_, veið, chly_,
  { {0x4426008d, 0xab950088, 0xd042006b, 0x00000000}},  //   _kjo_, ливі, hvlə,
  { {0x6aad054f, 0xb5fd0550, 0xa4b7009b, 0x00000000}},  //   ttaf, _muša, כללה_,
  { {0xab840551, 0x20190552, 0x7e640553, 0x00000000}},  // [5d0] руск, misi_, _guip,
  { {0x20190554, 0x6aad0555, 0xdb04000c, 0x00000000}},  //   lisi_, rtaf, reið,
  { {0x6aad014a, 0x44260556, 0x67d500ed, 0x00000000}},  //   staf, _ojo_, ложу,
  { {0x7bdd033b, 0xc794008b, 0x20190557, 0x00000000}},  //   _unsu, аршы, nisi_,
  { {0x4b7a019b, 0x3a8400a5, 0xa3e10309, 0x00000000}},  //   _ראשו, _высв, दास_,
  { {0xd1260558, 0x4426008d, 0x2019000b, 0x00000000}},  //   _هم_, _ajo_, hisi_,
  { {0x2019014a, 0x44260559, 0x64b50426, 0x00000000}},  //   kisi_, _bjo_, احتر,
  { {0xb5fd055a, 0x2019055b, 0x6e35055c, 0x00000000}},  //   _duša, jisi_, hozb,
  { {0xe3b60147, 0x55a500a1, 0x4426055d, 0x00000000}},  //   убы_, _مجاہ, _djo_,
  { {0x4426055e, 0x00000000, 0x00000000, 0x00000000}},  //   _ejo_,   ,   ,
  { {0x201904cd, 0x7c2901ae, 0x7e64055f, 0x00000000}},  //   fisi_, čerj, _suip,
  { {0xc50c0049, 0xbb1b0035, 0x20190560, 0x00000000}},  //   _קלאָ, _reîn, gisi_,
  { {0x443f0561, 0xd24e0063, 0x7e64009d, 0x00000000}},  //   mlu_, تنی_, _quip,
  { {0x443f0562, 0x831a007b, 0x22920025, 0x00000000}},  //   llu_, _אונז, _الوس,
  { {0x20190563, 0x443f006c, 0x00000000, 0x00000000}},  //   bisi_, olu_,   ,
  { {0x66180107, 0x443f0564, 0x20190565, 0x00000000}},  //   zivk, nlu_, cisi_,
  { {0x443f021e, 0x9e5a005e, 0x8c4300e3, 0x00000000}},  // [5e0] ilu_, _проф_, сете,
  { {0x443f0566, 0x7a3001a2, 0xd839000a, 0x00000000}},  //   hlu_, lätz, _akō_,
  { {0x443f0567, 0x3ea20568, 0x00000000, 0x00000000}},  //   klu_, lukt_,   ,
  { {0x2bab01f5, 0x2d8a0569, 0xdc9b00b3, 0x00000000}},  //   _छाया, labe_, _איטל,
  { {0x443f056a, 0x6006056b, 0x68e30039, 0x00000000}},  //   dlu_, _góme, ändr,
  { {0x7c24001a, 0x7a30010f, 0x443f056c, 0x00000000}},  //   lnir, hätz, elu_,
  { {0x5faa0061, 0x443f056d, 0x2955005e, 0x00000000}},  //   _काढल, flu_, _вътр,
  { {0x69ce056e, 0x443f000c, 0x7c24056f, 0x00000000}},  //   _habe, glu_, nnir,
  { {0x2d8a0570, 0x6b86012d, 0x629b0006, 0x00000000}},  //   kabe_, _mekg, gruo,
  { {0x69ce002d, 0x32b70025, 0x201900e7, 0x00000000}},  //   _jabe, ادية_, wisi_,
  { {0x443f0571, 0x69ce0572, 0x2019023a, 0x00000000}},  //   blu_, _mabe, tisi_,
  { {0x443f02a4, 0x69ce0573, 0x9f49000c, 0x00000000}},  //   clu_, _labe, _blað_,
  { {0xa3e102f4, 0x2019011f, 0x80ca0044, 0x00000000}},  //   दार_, risi_, িমধ্,
  { {0x20190574, 0xd25001b7, 0x2d8a010f, 0x00000000}},  //   sisi_, _بنت_, gabe_,
  { {0x201902db, 0x0217009b, 0xafdb0030, 0x00000000}},  //   pisi_, _תחום_, rløb,
  { {0xfbdf001d, 0x69ce0030, 0x44240173, 0x00000000}},  //   _thêm_, _aabe, nnm_,
  { {0x7c3f001c, 0x3f8b008a, 0x69ce0575, 0x00000000}},  // [5f0] rlqr, macu_, _babe,
  { {0x69ce0576, 0x3b54005e, 0x443f0279, 0x00000000}},  //   _cabe, скур, zlu_,
  { {0x69ce0577, 0x443f0578, 0xb5fd016c, 0x00000000}},  //   _dabe, ylu_, _bušn,
  { {0x8d74007a, 0x443f006b, 0x7c240579, 0x00000000}},  //   _پایا, xlu_, cnir,
  { {0xb5fd057a, 0x66e50478, 0x443f0095, 0x00000000}},  //   _dušn, рола, vlu_,
  { {0x69ce002d, 0x00000000, 0x00000000, 0x00000000}},  //   _gabe,   ,   ,
  { {0x2aaf006b, 0x3dd70044, 0x3f8b0107, 0x00000000}},  //   lüb_, _সকাল, kacu_,
  { {0x69ce0027, 0x7bcf057b, 0x3f8b057c, 0x00000000}},  //   _zabe, _jacu, jacu_,
  { {0x443f020c, 0x49190061, 0x020501fc, 0x00000000}},  //   rlu_, _येतो_, изин,
  { {0x443f009f, 0xd24e057d, 0x7bcf001a, 0x00000000}},  //   slu_, وني_, _lacu,
  { {0x443f057e, 0x6faa0061, 0x7bcf057f, 0x00000000}},  //   plu_, _कादं, _oacu,
  { {0xdcfe0089, 0xc059007e, 0x3f8b0064, 0x00000000}},  //   _nepā, ліў_, gacu_,
  { {0x91e5003b, 0xf38c0049, 0x2d8a0032, 0x00000000}},  //   _воле, _טראָ, tabe_,
  { {0x44d50580, 0x7a30001f, 0xee370581, 0x00000000}},  //   _kā_, sätz, иня_,
  { {0x2d8a01d9, 0x44d5001e, 0x3f8b0582, 0x00000000}},  //   rabe_, _jā_, bacu_,
  { {0x7bcf00fa, 0x3f8b00fa, 0x00000000, 0x00000000}},  //   _cacu, cacu_,   ,
  { {0x7c240583, 0xfaa60057, 0xcb0003d7, 0x00000000}},  // [600] rnir, разо, लैंड_,
  { {0x69ce01d5, 0x7bcf0584, 0x2d96005e, 0x00000000}},  //   _qabe, _eacu, _трис,
  { {0x7bcf0585, 0x44c70010, 0x08c601ee, 0x00000000}},  //   _facu, _nő_, рбен,
  { {0x7bcf0020, 0xf0b60049, 0x69ce0586, 0x00000000}},  //   _gacu, ילער_, _wabe,
  { {0x69ce049a, 0x7bc40035, 0x00000000, 0x00000000}},  //   _tabe, meiu,   ,
  { {0xa61301fb, 0x3f8b0587, 0x96f700ed, 0x00000000}},  //   оміч, zacu_, решт_,
  { {0x291e0039, 0x64aa006b, 0xb5fd016c, 0x00000000}},  //   _äta_, _rəis, _tušn,
  { {0x07a30545, 0xf3f801c5, 0x00000000, 0x00000000}},  //   _масн, _kuģi_,   ,
  { {0x3f8b0107, 0x41e6007e, 0x5214007c, 0x00000000}},  //   vacu_, аіна, йдит,
  { {0x44c70010, 0x3f8b0045, 0x00000000, 0x00000000}},  //   _fő_, wacu_,   ,
  { {0x7e760387, 0x3f8b01ee, 0xf993009b, 0x00000000}},  //   _atyp, tacu_, חרת_,
  { {0xb5fc0066, 0x6aa4050c, 0x7e760045, 0x00000000}},  //   _diġe, kuif, _btyp,
  { {0x7bcf0588, 0xc7b3009b, 0x3f8b012d, 0x00000000}},  //   _racu, חבר_, racu_,
  { {0x7bcf0107, 0x27230011, 0x3f8b0521, 0x00000000}},  //   _sacu, ằng_, sacu_,
  { {0x40940025, 0x7bcf04aa, 0x4c94007c, 0x00000000}},  //   _البر, _pacu, жисс,
  { {0x95fe0044, 0x7e760009, 0x3ced0091, 0x00000000}},  //   ্চিম_, _ftyp, ćev_,
  { {0x99670589, 0x7bcf058a, 0xddcd002b, 0x00000000}},  // [610] ател, _vacu, _kważ,
  { {0x2aaf006b, 0x69a70061, 0x2b850082, 0x00000000}},  //   rüb_, _चाळी, ặc_,
  { {0x7bcf058b, 0xc7c7058c, 0x00000000, 0x00000000}},  //   _tacu, исди,   ,
  { {0xf7f40014, 0x7bc4001a, 0x5f0a0044, 0x00000000}},  //   يسند, ceiu, রপরও_,
  { {0xa3ea0164, 0xd6d90046, 0x09cf0044, 0x00000000}},  //   मान_, _była_, রাবা,
  { {0x6b8d006c, 0xb8cd0044, 0x00000000, 0x00000000}},  //   laag, _কন_,   ,
  { {0x69c5006c, 0xcd98009b, 0x18a4007e, 0x00000000}},  //   mehe, בדות_, _маём,
  { {0x69c50004, 0x6b8d011c, 0x53c9058d, 0x00000000}},  //   lehe, naag, угим_,
  { {0x6006004a, 0xe5c7058e, 0x00000000, 0x00000000}},  //   _nóma, _всео,   ,
  { {0xa205058f, 0x44d5001e, 0x69c50056, 0x00000000}},  //   спод, _tā_, nehe,
  { {0x3f8900f4, 0x7e760590, 0x6b8d0058, 0x00000000}},  //   _beau_, _styp, kaag,
  { {0x69c50591, 0xdb040592, 0x6b8d0112, 0x00000000}},  //   hehe, rfiú, jaag,
  { {0x6b8d00c7, 0x69c5003f, 0x237f0065, 0x00000000}},  //   daag, kehe, mbuj_,
  { {0x63a90376, 0x3f9e014a, 0x69c50065, 0x00000000}},  //   lgen, ştu_, jehe,
  { {0x61e30593, 0xeb9a0594, 0x1d070595, 0x00000000}},  //   _innl, лив_, бери_,
  { {0x63a90596, 0x78a50107, 0x60dc0030, 0x00000000}},  //   ngen, duhv, ærme,
  { {0x63a9010f, 0xfe720025, 0xb5fd0087, 0x00000000}},  // [620] igen, _عدة_, _pušl,
  { {0x69c50597, 0x443d0598, 0x20020052, 0x00000000}},  //   gehe, _lkw_, lkki_,
  { {0xa3d703d7, 0x395c0039, 0xdcfe001a, 0x00000000}},  //   ाया_, ävs_, _depă,
  { {0x6b8d001c, 0x2002021e, 0x07a6003b, 0x00000000}},  //   caag, nkki_, садн,
  { {0xadec03d7, 0x69c50599, 0x6aa4059a, 0x00000000}},  //   ञापन_, behe, quif,
  { {0x63a9059b, 0xb8660439, 0x69c5059c, 0x00000000}},  //   egen, _هارو, cehe,
  { {0x18a3007e, 0x63a9010f, 0x7d7b0049, 0x00000000}},  //   _нарм, fgen, אנצו,
  { {0x63a9059d, 0x68150036, 0x3a3a0039, 0x00000000}},  //   ggen, ządz, lopp_,
  { {0x443d01d6, 0x78bb012d, 0xfbd3009b, 0x00000000}},  //   _dkw_, _ćuvi, לתה_,
  { {0x63a9059e, 0xd9cf0044, 0x60060092, 0x00000000}},  //   agen, রাথম, _róma,
  { {0x3f8900f4, 0x63a902c2, 0xb5fc0066, 0x00000000}},  //   _peau_, bgen, _tiġb,
  { {0x82a601e0, 0x61e300ea, 0x3a3a00f8, 0x00000000}},  //   _гадж, _ennl, hopp_,
  { {0x3f89009d, 0x3a3a059f, 0xddcd05a0, 0x00000000}},  //   _veau_, kopp_, _ataš,
  { {0xddcd0036, 0x6b8d00e7, 0x00000000, 0x00000000}},  //   _uważ, waag,   ,
  { {0x69c50010, 0x6b8d05a1, 0x00000000, 0x00000000}},  //   vehe, taag,   ,
  { {0x321e05a2, 0x600605a3, 0x27e400e0, 0x00000000}},  //   lity_, _tóma, _nnmn_,
  { {0x69c5010f, 0x6b8d01b5, 0xfaff0065, 0x00000000}},  // [630] tehe, raag, _afër_,
  { {0x996705a4, 0x321e0038, 0xddab05a5, 0x00000000}},  //   стал, nity_, _стил_,
  { {0x63a905a6, 0x094b05a7, 0x69c505a8, 0x00000000}},  //   ygen, учаи_, rehe,
  { {0x69c5001f, 0xb8f10316, 0xad1a00b6, 0x00000000}},  //   sehe, _वन_, _כותר,
  { {0x63a9013f, 0x8f9c0104, 0x00000000, 0x00000000}},  //   vgen, רידי,   ,
  { {0x2009018e, 0x00000000, 0x00000000, 0x00000000}},  //   _llai_,   ,   ,
  { {0x63a90270, 0x2002000c, 0x321e05a9, 0x00000000}},  //   tgen, ykki_, dity_,
  { {0x6683026c, 0xdb0d0211, 0x5fd90061, 0x00000000}},  //   _فیصل, leañ, _बोलल,
  { {0x2329019d, 0x4209003b, 0xb5fd05a0, 0x00000000}},  //   ропи_, инио_, _jušk,
  { {0xb5fd0119, 0x63a90168, 0x3125007c, 0x00000000}},  //   _mušk, sgen, ждог,
  { {0xd12e00a1, 0x443d0093, 0x200905aa, 0x00000000}},  //   ہمی_, _tkw_, _blai_,
  { {0xa3ea02f4, 0xb4d5006e, 0x2009005b, 0x00000000}},  //   माण_, िटी_, _clai_,
  { {0xe2da026c, 0x200200b0, 0xb5fd05ab, 0x00000000}},  //   _پانچ_, rkki_, _nušk,
  { {0x2738001d, 0x321e05ac, 0x27e00089, 0x00000000}},  //   ứng_, city_, ķini_,
  { {0xed5a0057, 0xdbc7009f, 0x20090026, 0x00000000}},  //   ров_, töðu, _flai_,
  { {0xc4d200b3, 0x1c4601ff, 0x20040089, 0x00000000}},  //   וגל_, інам, ījis_,
  { {0xa3ea0061, 0x3a3a05ad, 0x00000000, 0x00000000}},  // [640] मात_, topp_,   ,
  { {0xb5fd04eb, 0x497a007e, 0xc18c0049, 0x00000000}},  //   _dušk, рсаў_, ָטאָ,
  { {0xd6d90046, 0x6e3c001b, 0x3a3a00f8, 0x00000000}},  //   _było_, morb, ropp_,
  { {0x2d9a05ae, 0x3a3a0145, 0x6e3c05af, 0x00000000}},  //   _hdpe_, sopp_, lorb,
  { {0x628600b9, 0x00000000, 0x00000000, 0x00000000}},  //   škoz,   ,   ,
  { {0xd49a00d7, 0x2ba803d7, 0x321e0133, 0x00000000}},  //   ари_, गलवा, xity_,
  { {0x25a0011f, 0xd5ad026c, 0x321e05b0, 0x00000000}},  //   ğil_, اہم_, vity_,
  { {0x25a0014a, 0xaa7b01dc, 0x186700e2, 0x00000000}},  //   şil_, _frýd, _фати_,
  { {0x24890091, 0x6e3c0010, 0x6ab60036, 0x00000000}},  //   ćama_, korb, ntyf,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x321e0038, 0xb3ca026b, 0x104b007c, 0x00000000}},  //   rity_, _влез_, иями_,
  { {0x321e00ab, 0x7d03006b, 0x320c00e7, 0x00000000}},  //   sity_, _ünsi, shdy_,
  { {0x6e3c05b1, 0x7aed05b2, 0x185b0049, 0x00000000}},  //   forb, xxat, יכטע,
  { {0xf287026c, 0x6e3c0032, 0x00000000, 0x00000000}},  //   _بھٹو_, gorb,   ,
  { {0x48c50055, 0x3f820022, 0x00000000, 0x00000000}},  //   _এপ্র, bbku_,   ,
  { {0x7aed05b3, 0x61f800ea, 0x7e7d05b4, 0x00000000}},  //   txat, _hovl, ppsp,
  { {0x7f4d006b, 0x6e3c0232, 0x00000000, 0x00000000}},  // [650] _uzaq, borb,   ,
  { {0x527b007b, 0x386400e5, 0xc98405b5, 0x00000000}},  //   ינמא, _aimr_, дуци,
  { {0x2d9105b6, 0x2d830065, 0x81bc0089, 0x00000000}},  //   maze_, mbje_, tnēj,
  { {0x2d910119, 0x61f805b7, 0x80c40044, 0x00000000}},  //   laze_, _lovl, ষিপ্,
  { {0xeb760049, 0xb5fc0066, 0x00000000, 0x00000000}},  //   _מערץ_, _siġa,   ,
  { {0xe6180088, 0x2d910095, 0xb5fc01f3, 0x00000000}},  //   оді_, naze_, _piġa,
  { {0xf50505b8, 0x7e6d0093, 0x92aa0044, 0x00000000}},  //   язко, _luap, খবো_,
  { {0xfbdf0082, 0x6d4501a2, 0x00000000, 0x00000000}},  //   _thêu_, _myha,   ,
  { {0x69d5012b, 0x2d91041a, 0x29ff0036, 0x00000000}},  //   _kaze, kaze_, ałań_,
  { {0x11d50025, 0xddc40091, 0x69d50142, 0x00000000}},  //   ستخد, _stiž, _jaze,
  { {0x69d50006, 0x61f80035, 0xb5fd05b9, 0x00000000}},  //   _maze, _dovl, _nuši,
  { {0x69d50181, 0x6e3c01a2, 0x4429004a, 0x00000000}},  //   _laze, worb, _ña_,
  { {0x63bb05ba, 0x932704e8, 0x216905bb, 0x00000000}},  //   mfun, _بران, _лили_,
  { {0x2d8c05bc, 0x63bb00db, 0x2d9105bd, 0x00000000}},  //   úde_, lfun, gaze_,
  { {0xe166007a, 0x614205be, 0x6e3c040f, 0x00000000}},  //   _عضوی, _пеша, rorb,
  { {0x6e3c0010, 0xc4d2007b, 0xbc630072, 0x00000000}},  //   sorb, עגן_, евск,
  { {0x2fc0006a, 0x7e6d0211, 0x2d9105bf, 0x00000000}},  // [660] _ibig_, _guap, baze_,
  { {0x4a4305c0, 0xa3e202fb, 0x25db00e8, 0x00000000}},  //   енув, _फोन_, _गोली_,
  { {0x38b505c1, 0x63bb05c2, 0x9d460478, 0x00000000}},  //   går_, kfun, _хенд,
  { {0xde6d001d, 0xdb1d05c3, 0x83fc0166, 0x00000000}},  //   _hươn, _obsè, _tuđi,
  { {0x69d502d5, 0x6d40005a, 0x63bb00ea, 0x00000000}},  //   _faze, şmad, dfun,
  { {0x63bb01a2, 0x00000000, 0x00000000, 0x00000000}},  //   efun,   ,   ,
  { {0xdb0f028c, 0x63bb05c4, 0xdb1d00d4, 0x00000000}},  //   _accè, ffun, _absè,
  { {0xde6d001d, 0x6b840066, 0x02a60088, 0x00000000}},  //   _lươn, nbig, пром,
  { {0x81d50044, 0x93c800a1, 0x61f805c5, 0x00000000}},  //   হান_, ماکہ_, _povl,
  { {0xdb0d0181, 0xde6d0011, 0x909800ed, 0x00000000}},  //   sfaç, _nươn, овот_,
  { {0x6aa405c6, 0x733600a1, 0xd25000a1, 0x00000000}},  //   hrif, _کرائ, ٹنگ_,
  { {0xe45a05c7, 0x6aa405c8, 0x2ee00016, 0x00000000}},  //   _уже_, krif, _brif_,
  { {0xf2060265, 0xe2da00a1, 0x2ee003e2, 0x00000000}},  //   _няко, _دباؤ_, _crif_,
  { {0xde6d0011, 0x6aa40056, 0xd29b0104, 0x00000000}},  //   _cươn, drif, _פשוט,
  { {0xde6d001d, 0x69d505c9, 0xc1bb009b, 0x00000000}},  //   _dươn, _raze, _המוש,
  { {0x6aa4018e, 0x6b84006a, 0x69d5013e, 0x00000000}},  //   frif, gbig, _saze,
  { {0x6aa405ca, 0x69d50089, 0x8f9c009b, 0x00000000}},  // [670] grif, _paze, _היחי,
  { {0xde6d0011, 0x38b505cb, 0xb5fd016e, 0x00000000}},  //   _gươn, tår_, _tuši,
  { {0x6b840039, 0xe3c70006, 0x69d50471, 0x00000000}},  //   bbig, ščių_, _vaze,
  { {0x290701d5, 0x69d50020, 0x76410006, 0x00000000}},  //   ġna_, _waze, _skly,
  { {0x38b505cc, 0x29070340, 0x7c2d001a, 0x00000000}},  //   sår_, šna_, mnar,
  { {0xde6d0011, 0xb9c50257, 0x7c2d013f, 0x00000000}},  //   _xươn, _تقسي, lnar,
  { {0x7c2d049a, 0x24890091, 0x442f05cd, 0x00000000}},  //   onar, ćamo_, _pjg_,
  { {0xdb0f03d5, 0x7c2d05ce, 0x130902d3, 0x00000000}},  //   _accé, nnar, жний_,
  { {0x63bb008d, 0x7c2d05cf, 0x00000000, 0x00000000}},  //   rfun, inar,   ,
  { {0x3eab05d0, 0x6442002d, 0x7c2d010f, 0x00000000}},  //   duct_, _ekoi, hnar,
  { {0x7c2d000c, 0x63bb010f, 0x8fa602dc, 0x00000000}},  //   knar, pfun, мане,
  { {0x2ee0018e, 0x81b50044, 0xe3b00025, 0x00000000}},  //   _prif_, _চোখ_, _مره_,
  { {0xa3ea02fb, 0x7c2d0059, 0x644905d1, 0x00000000}},  //   मार_, dnar, mlei,
  { {0x443f05d2, 0x7c2d0032, 0x4df5007e, 0x00000000}},  //   lou_, enar, няст,
  { {0x442d05d3, 0xe1f005d4, 0x3eb902ae, 0x00000000}},  //   one_, _حسن_, atst_,
  { {0x442d05d5, 0x7c2d05d6, 0x644900db, 0x00000000}},  //   nne_, gnar, nlei,
  { {0x442d05d7, 0xde6d001d, 0xc05300b3, 0x00000000}},  // [680] ine_, _tươn, _בזה_,
  { {0x6aa405d8, 0x443f05d9, 0x2b8c001d, 0x00000000}},  //   rrif, hou_, ếc_,
  { {0x443f004f, 0x644905da, 0xc8ca0014, 0x00000000}},  //   kou_, klei, توان_,
  { {0x442d05db, 0x798e05dc, 0x443f05dd, 0x00000000}},  //   jne_, _webw, jou_,
  { {0x442d04a3, 0x443f004f, 0xb86502fd, 0x00000000}},  //   dne_, dou_, رامو,
  { {0x64490270, 0x44ce00b9, 0x443f01c3, 0x00000000}},  //   elei, _př_, eou_,
  { {0x443f01aa, 0x3e740039, 0x644905de, 0x00000000}},  //   fou_, _lät_, flei,
  { {0x442d02b6, 0x443f0181, 0x68e305df, 0x00000000}},  //   gne_, gou_, ænde,
  { {0x395100ca, 0x3e7400f8, 0x00000000, 0x00000000}},  //   _zzzs_, _nät_,   ,
  { {0x442d000d, 0x64490052, 0x7c2405e0, 0x00000000}},  //   ane_, alei, hiir,
  { {0x850600d3, 0x442d05e1, 0x64490129, 0x00000000}},  //   _توان, bne_, blei,
  { {0x443f05e2, 0x442d0027, 0x64490472, 0x00000000}},  //   cou_, cne_, clei,
  { {0x4424016c, 0x64400006, 0x25f50061, 0x00000000}},  //   mim_, momi, ्सची_,
  { {0x44240213, 0x60320089, 0x7c2d0050, 0x00000000}},  //   lim_, rāma, wnar,
  { {0x7c2d05e3, 0x7c2405e4, 0xb5fc0066, 0x00000000}},  //   tnar, fiir, _riġl,
  { {0x80c40044, 0x7c2d05e5, 0x2bdf00e8, 0x00000000}},  //   ষিদ্, unar, _पोशा,
  { {0x7c2d009f, 0xa3b6006e, 0xcd0400b9, 0x00000000}},  // [690] rnar, _जान_, vněž_,
  { {0x443f049a, 0x7c2d002d, 0x644004eb, 0x00000000}},  //   zou_, snar, homi,
  { {0x443f05e6, 0x442d0142, 0xb5fd016c, 0x00000000}},  //   you_, yne_, _mušt,
  { {0x44240119, 0x27e905e7, 0x64400006, 0x00000000}},  //   jim_, ñan_, jomi,
  { {0x442d05e8, 0x443f0428, 0x7bcd009d, 0x00000000}},  //   vne_, vou_, meau,
  { {0x442d0046, 0x443f01aa, 0x7bcd009d, 0x00000000}},  //   wne_, wou_, leau,
  { {0x6006002a, 0x644905e9, 0xe3b10025, 0x00000000}},  //   _fómh, tlei, هرة_,
  { {0x442d000d, 0x644005ea, 0x61ea05eb, 0x00000000}},  //   une_, gomi, _anfl,
  { {0x442d05ec, 0x644905ed, 0x63a605ee, 0x00000000}},  //   rne_, rlei, ókna,
  { {0x443f05ef, 0xe1f10054, 0x645b0051, 0x00000000}},  //   sou_, اسة_, smui,
  { {0x602600d7, 0x442d0027, 0x65940106, 0x00000000}},  //   една, pne_, _раху,
  { {0x644005f0, 0x4424055a, 0x61ea05f1, 0x00000000}},  //   comi, cim_, _enfl,
  { {0x7bcd05f2, 0x2ac30089, 0x7c2405e0, 0x00000000}},  //   deau, nībā_, viir,
  { {0xdd9205f3, 0x2c750030, 0xa3d7007d, 0x00000000}},  //   طور_, _båd_, ायक_,
  { {0x1b1d0055, 0xa3b6006e, 0x81d50044, 0x00000000}},  //   _ভুলে_, _जाम_, হাদ_,
  { {0x3e7404ce, 0x2c750146, 0x00000000, 0x00000000}},  //   _tät_, _dåd_,   ,
  { {0xf412007b, 0x600605f4, 0x1f660088, 0x00000000}},  // [6a0] אפן_, _nómi, _яким,
  { {0xe9d70099, 0x7c3b016c, 0x2ac30089, 0x00000000}},  //   нку_, čura, dībā_,
  { {0x442405f5, 0x7c24003c, 0x1bea05f6, 0x00000000}},  //   yim_, piir, _едни_,
  { {0x442405f7, 0x6440027b, 0x7bcd0068, 0x00000000}},  //   xim_, xomi, ceau,
  { {0x44240119, 0x6006008e, 0x644005f8, 0x00000000}},  //   vim_, _cómi, vomi,
  { {0x6b9600e0, 0x44240145, 0x644000b4, 0x00000000}},  //   layg, wim_, womi,
  { {0x442405f9, 0x64400036, 0x7c2f002a, 0x00000000}},  //   tim_, tomi, _áirí,
  { {0xb5fd05fa, 0xccf301f8, 0xd467012b, 0x00000000}},  //   _sušt, רכה_, није_,
  { {0x442405fb, 0x2ac3001e, 0xb5fd0091, 0x00000000}},  //   rim_, cībā_, _pušt,
  { {0x644005fc, 0x00000000, 0x00000000, 0x00000000}},  //   somi,   ,   ,
  { {0x644005fd, 0x2a6a0026, 0x64a301ee, 0x00000000}},  //   pomi, _mibb_, _баха,
  { {0x2c7505fe, 0x929d0036, 0x442405ff, 0x00000000}},  //   _råd_, syła, qim_,
  { {0x7bcd028c, 0xb5fd007f, 0x00000000, 0x00000000}},  //   veau, _tušt,   ,
  { {0x61ea0600, 0xaa7b000c, 0x00000000, 0x00000000}},  //   _unfl, _brýn,   ,
  { {0x7bcd0601, 0x71f700a1, 0x2ac301c5, 0x00000000}},  //   teau, _سروس_, zībā_,
  { {0x7c8400ed, 0x6b960009, 0x00000000, 0x00000000}},  //   ѓусе, gayg,   ,
  { {0x7bcd0602, 0x7b740025, 0x39a70603, 0x00000000}},  // [6b0] reau, اطفا, ешев,
  { {0x7bcd00f4, 0x13d90044, 0x49d80604, 0x00000000}},  //   seau, থায়, ндую_,
  { {0x48ab0605, 0x7bcd009d, 0x5d5502ea, 0x00000000}},  //   ятам_, peau, _шкот,
  { {0xfbab0057, 0x629d0010, 0x200b00b9, 0x00000000}},  //   _этой_, ások, nkci_,
  { {0x79a700ec, 0x6aad0197, 0xc66b007c, 0x00000000}},  //   _прве, quaf, чшее_,
  { {0x2a6a0606, 0x2ac30089, 0x600600dc, 0x00000000}},  //   _gibb_, rībā_, _vómi,
  { {0xda340147, 0x2ac30089, 0x2d9300c4, 0x00000000}},  //   _серы, sībā_, _mexe_,
  { {0x2a6a00d9, 0x00000000, 0x00000000, 0x00000000}},  //   _zibb_,   ,   ,
  { {0x961d0089, 0x00000000, 0x00000000, 0x00000000}},  //   _atņe,   ,   ,
  { {0x85b800ed, 0x2d9300f6, 0x27ff000a, 0x00000000}},  //   _плус_, _nexe_, _houn_,
  { {0x7643011c, 0x27ff000a, 0x00000000, 0x00000000}},  //   mony, _koun_,   ,
  { {0x69c101f5, 0x27ff000a, 0x00000000, 0x00000000}},  //   र्ती, _joun_,   ,
  { {0x27ff0607, 0xa3b60183, 0x441a00a0, 0x00000000}},  //   _moun_, _जात_, _קונס,
  { {0x6b960190, 0x76430608, 0x00000000, 0x00000000}},  //   wayg, nony,   ,
  { {0xdcfc0089, 0x629b0006, 0x27ed0609, 0x00000000}},  //   varē, lsuo, _onen_,
  { {0x7ae90091, 0x7643060a, 0x27ff060b, 0x00000000}},  //   _šeta, hony, _noun_,
  { {0xee3a0057, 0xe9da01a4, 0xab27005e, 0x00000000}},  // [6c0] _они_, мка_, вота_,
  { {0x27ed0065, 0x00000000, 0x00000000, 0x00000000}},  //   _anen_,   ,   ,
  { {0x2d98001a, 0x27ff000a, 0x940c006b, 0x00000000}},  //   mare_, _boun_, _evdə_,
  { {0x2d98060c, 0x629b0006, 0x661d0006, 0x00000000}},  //   lare_, ksuo, _įska,
  { {0x76430093, 0x2a6a006b, 0x27ff0288, 0x00000000}},  //   fony, _tibb_, _doun_,
  { {0x7643060d, 0xe534060e, 0x27ed060f, 0x00000000}},  //   gony, лель, _enen_,
  { {0xb5fc002b, 0x2d9800ea, 0x69dc0288, 0x00000000}},  //   _jiġi, iare_, _iare,
  { {0x64590610, 0x2d980611, 0x69dc0612, 0x00000000}},  //   _chwi, hare_, _hare,
  { {0x69dc0390, 0x2d980073, 0xf5b4026c, 0x00000000}},  //   _kare, kare_, _مشاھ,
  { {0x69dc02ae, 0x2d980613, 0x69de0614, 0x00000000}},  //   _jare, jare_, ndpe,
  { {0x69dc000b, 0x2d980615, 0x27ff0263, 0x00000000}},  //   _mare, dare_, _youn_,
  { {0x69dc027b, 0x0326025f, 0x2d930616, 0x00000000}},  //   _lare, _иден, _sexe_,
  { {0xdcf5001e, 0x2d980617, 0x63a20207, 0x00000000}},  //   pazī, fare_, _idon,
  { {0x69dc0618, 0xc0aa00a6, 0x2d9801e2, 0x00000000}},  //   _nare, _قابل_, gare_,
  { {0x6d40005a, 0x7ae600ea, 0x20d30464, 0x00000000}},  //   şman, _arkt, _نتيج,
  { {0x76430619, 0xec340088, 0x69dc006c, 0x00000000}},  //   zony, ансь, _aare,
  { {0x81d50055, 0x69dc0209, 0x5a3500e3, 0x00000000}},  // [6d0] হার_, _bare, гнат,
  { {0x2d98061a, 0x69dc0038, 0x3f99061b, 0x00000000}},  //   care_, _care, lasu_,
  { {0x69dc0007, 0x63a2061c, 0x27ff01aa, 0x00000000}},  //   _dare, _odon, _poun_,
  { {0x63a2008d, 0xac190088, 0x69dc0032, 0x00000000}},  //   _ndon, _чому_, _eare,
  { {0xf770023c, 0x7643061d, 0x501c061e, 0x00000000}},  //   زان_, tony, וואו,
  { {0x63a20129, 0x69dc002d, 0x62720046, 0x00000000}},  //   _adon, _gare, _młod,
  { {0x7bdd061f, 0x7643031e, 0x5e580049, 0x00000000}},  //   _kasu, rony, דיגע_,
  { {0x69dc0620, 0x2d98000d, 0x27ed0621, 0x00000000}},  //   _zare, zare_, _unen_,
  { {0x7bdd0149, 0x76430622, 0x6113006b, 0x00000000}},  //   _masu, pony, mələ,
  { {0x386d0623, 0x6113005f, 0x63a2002d, 0x00000000}},  //   _hier_, lələ, _edon,
  { {0x2d980624, 0x629b0625, 0x7f4d006b, 0x00000000}},  //   vare_, ssuo, _ayaq,
  { {0x7bdd011c, 0x660100b9, 0x6113006b, 0x00000000}},  //   _nasu, _holk, nələ,
  { {0x66010626, 0x7ae90091, 0x765a00b0, 0x00000000}},  //   _kolk, _šetn, _yhty,
  { {0x6113005f, 0xddcd0627, 0x386d0628, 0x00000000}},  //   hələ, _etaž, _lier_,
  { {0x2d980629, 0x6113005f, 0x69dc062a, 0x00000000}},  //   rare_, kələ, _rare,
  { {0x69dc062b, 0x2d98062c, 0x44e3011f, 0x00000000}},  //   _sare, sare_, _mı_,
  { {0x79950263, 0x2d98062d, 0x6113006b, 0x00000000}},  // [6e0] _bezw, pare_, dələ,
  { {0x2d980023, 0xb5fc002b, 0x00000000, 0x00000000}},  //   qare_, _tiġi,   ,
  { {0x69dc0018, 0x6113005f, 0x69de00f8, 0x00000000}},  //   _vare, fələ, rdpe,
  { {0xe73a0057, 0x765a008d, 0xb8dc062e, 0x00000000}},  //   нее_, _shty, _आम_,
  { {0x69dc062f, 0x386d0630, 0xc7a3004d, 0x00000000}},  //   _tare, _dier_, сичк,
  { {0xceb300a0, 0x386d0631, 0x7ae40190, 0x00000000}},  //   מיד_, _eier_, mvit,
  { {0x44e3005f, 0x386d0632, 0x6113005f, 0x00000000}},  //   _cı_, _fier_, bələ,
  { {0x6113005f, 0x386d0036, 0x8d5b0049, 0x00000000}},  //   cələ, _gier_, עכקי,
  { {0x66010374, 0x69c10061, 0x7ae40181, 0x00000000}},  //   _folk, र्वी, nvit,
  { {0xddcd0224, 0x66010633, 0x408600ed, 0x00000000}},  //   _staž, _golk, лумб,
  { {0x7c260634, 0x3f99006c, 0x5ff500c0, 0x00000000}},  //   _omkr, tasu_, азну,
  { {0x63a20020, 0x7e7601d6, 0x6d400276, 0x00000000}},  //   _udon, _buyp, ğmal,
  { {0x44260058, 0x6d40047f, 0x7bdd027e, 0x00000000}},  //   _imo_, şmal, _rasu,
  { {0x2731001d, 0x7ae40635, 0x44e3014a, 0x00000000}},  //   ạng_, dvit, _yı_,
  { {0x7bdd0636, 0xdb0d0051, 0x317b00a3, 0x00000000}},  //   _pasu, rgaí, _ארומ,
  { {0x6006000c, 0xafdb0030, 0x442600e7, 0x00000000}},  //   _dóms, rløs, _jmo_,
  { {0xafdb0637, 0x6113006b, 0x7ac7007e, 0x00000000}},  // [6f0] sløs, vələ, ысве,
  { {0xe29f000c, 0x386d0056, 0x7bdd00e7, 0x00000000}},  //   áði_, _sier_, _wasu,
  { {0x7bdd0004, 0x386d0638, 0x6113006b, 0x00000000}},  //   _tasu, _pier_, tələ,
  { {0x20da0107, 0xe84b0379, 0x660100f8, 0x00000000}},  //   mšić_, رجان_, _solk,
  { {0x386d037f, 0x6b8d0149, 0x66010639, 0x00000000}},  //   _vier_, mbag, _polk,
  { {0x6113005f, 0x6b8d063a, 0x68e3063b, 0x00000000}},  //   sələ, lbag, ånds,
  { {0x66010343, 0x22450007, 0x386d03a1, 0x00000000}},  //   _volk, volk_, _tier_,
  { {0x6601063c, 0x6113005f, 0x22450250, 0x00000000}},  //   _wolk, qələ, wolk_,
  { {0x2bc7001c, 0x6601063d, 0x21f50088, 0x00000000}},  //   ऱ्या, _tolk, аїнс,
  { {0x0322008b, 0x20c50088, 0x69c50051, 0x00000000}},  //   ідэн, айом, nfhe,
  { {0x2ee90016, 0x442600e5, 0x7ae40340, 0x00000000}},  //   _araf_, _fmo_, zvit,
  { {0x6aad05ad, 0xa4fa007b, 0x2ee90016, 0x00000000}},  //   kraf, _בלעט, _braf_,
  { {0x636b047f, 0x1f5600a5, 0xc7d6009b, 0x00000000}},  //   _dönü, ртнё, בורי_,
  { {0x91fc001e, 0x6289029d, 0x6aad063e, 0x00000000}},  //   rmāc, mpeo, draf,
  { {0x3b9600e1, 0x8b9600e3, 0x2ee9063f, 0x00000000}},  //   ијат, ирач, _eraf_,
  { {0xe8e0001d, 0x636b014a, 0xafdb0637, 0x00000000}},  //   _hiệp_, _gönü, slør,
  { {0x2ee90640, 0x6da600ed, 0xada60641, 0x00000000}},  // [700] _graf_, _кипа, _капл,
  { {0x7ae4021e, 0x6006000c, 0xac760014, 0x00000000}},  //   rvit, _tóms, _پادش,
  { {0x7ae40635, 0x636b005a, 0x81c80044, 0x00000000}},  //   svit, _yönü, _লোড_,
  { {0xbc7b00b6, 0x6aad0190, 0xdb200010, 0x00000000}},  //   _שנכת, braf, ítóg,
  { {0x2bdf0204, 0x6aad0133, 0xdcfc0006, 0x00000000}},  //   _पोटा, craf, tarė,
  { {0x442601d9, 0x7aeb0030, 0xe4a600ed, 0x00000000}},  //   _smo_, ægte, арио,
  { {0xd4970642, 0x44260643, 0x18a302dc, 0x00000000}},  //   ары_, _pmo_, _марм,
  { {0xa6860072, 0x7c360016, 0xddcd0036, 0x00000000}},  //   _влад, nnyr, _staż,
  { {0x20190023, 0x00000000, 0x00000000, 0x00000000}},  //   ërim_,   ,   ,
  { {0x1db201f5, 0x38780065, 0x442600bb, 0x00000000}},  //   _जागत, _kurr_, _wmo_,
  { {0xe3ba00e3, 0x80270644, 0xe8e00011, 0x00000000}},  //   _абе_, لرحم, _diệp_,
  { {0x6f1d010f, 0x7c3b0107, 0x20da0645, 0x00000000}},  //   tzsc, čurk, všić_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6aad0026, 0x6f1d01a2, 0x9f4900fa, 0x00000000}},  //   vraf, rzsc, _unaí_,
  { {0x6b8d0646, 0xac19003b, 0x61fc00f8, 0x00000000}},  //   tbag, гову_, örlu,
  { {0x6aad0036, 0x2ee901a2, 0xb068007e, 0x00000000}},  //   traf, _traf_, _крыж_,
  { {0x6b8d04fa, 0xda78007c, 0xf9930379, 0x00000000}},  // [710] rbag, аях_, قبض_,
  { {0xd9990647, 0x6aad00d6, 0x3da701fc, 0x00000000}},  //   انات_, rraf, _триб,
  { {0xa3b601f5, 0x2907001a, 0x69c50051, 0x00000000}},  //   जला_, âna_, rfhe,
  { {0x6aad001a, 0x24850648, 0x00000000, 0x00000000}},  //   praf, _rtlm_,   ,
  { {0x7c2d0649, 0x6aad006b, 0xfaff0023, 0x00000000}},  //   miar, qraf, _egër_,
  { {0x929d0036, 0x387801f3, 0x00000000, 0x00000000}},  //   syłk, _furr_,   ,
  { {0x610a006b, 0x00000000, 0x00000000, 0x00000000}},  //   nəld,   ,   ,
  { {0xf77f005d, 0xa9540088, 0x2a71064a, 0x00000000}},  //   _üç_, _єкті, _hizb_,
  { {0xa3d6013d, 0x26cd0020, 0xa715003b, 0x00000000}},  //   ाज़_, _upeo_, _удаљ,
  { {0xe1f9064b, 0xe61301fa, 0x7c2d064c, 0x00000000}},  //   уго_, _بشر_, hiar,
  { {0x614500ed, 0x7c2d002d, 0xd24e0014, 0x00000000}},  //   сена, kiar, رچه_,
  { {0x6006064d, 0x9f060025, 0xc50c0049, 0x00000000}},  //   _cómp, موجو, _שלאָ,
  { {0x91e50113, 0x7c2d064e, 0x61e1001c, 0x00000000}},  //   _голе, diar, pdll,
  { {0x442d064f, 0x6449046a, 0x62720036, 0x00000000}},  //   lie_, loei, _włoc,
  { {0x7c2d0032, 0x0c79007c, 0x442d0650, 0x00000000}},  //   fiar, исты_, oie_,
  { {0x442d0620, 0x7c2d002d, 0xb5fc002b, 0x00000000}},  //   nie_, giar, _jiġr,
  { {0x63a60651, 0x7c360006, 0x2a710009, 0x00000000}},  // [720] ókni, rnyr, _bizb_,
  { {0x442d0207, 0x644900d9, 0xc3010044, 0x00000000}},  //   hie_, hoei, এনপি_,
  { {0x442d0652, 0x7c2d0653, 0x3ea200f8, 0x00000000}},  //   kie_, biar, lskt_,
  { {0x442d0654, 0x2d9a0058, 0x00000000, 0x00000000}},  //   jie_, _hepe_,   ,
  { {0x442d0428, 0x3ea203ed, 0xdcfc0089, 0x00000000}},  //   die_, nskt_, karī,
  { {0x27e00655, 0x6e2e01d5, 0x9e7b0049, 0x00000000}},  //   žin_, nibb, אנספ,
  { {0xdcfc001e, 0x00000000, 0x00000000, 0x00000000}},  //   darī,   ,   ,
  { {0x2d9a0059, 0x644900c4, 0x6e2e0145, 0x00000000}},  //   _lepe_, goei, hibb,
  { {0x38660039, 0x610a006b, 0xe73a00ed, 0x00000000}},  //   mmor_, zəld, _сеа_,
  { {0x7c2d0656, 0x442d0657, 0x2d9a01aa, 0x00000000}},  //   ziar, aie_, _nepe_,
  { {0x442d0046, 0xa1580175, 0xa3b60061, 0x00000000}},  //   bie_, рану_, _जाऊ_,
  { {0x442d0620, 0x38660658, 0x3957009b, 0x00000000}},  //   cie_, nmor_, משים_,
  { {0x7c2d0207, 0x2d9a0022, 0x6e2e001b, 0x00000000}},  //   viar, _bepe_, fibb,
  { {0xdb0d0181, 0x2d9a00e5, 0x7c2d0036, 0x00000000}},  //   lgaç, _cepe_, wiar,
  { {0x7c2d0659, 0x0ba7007e, 0x6a69007f, 0x00000000}},  //   tiar, йшам, _užfi,
  { {0x3881010a, 0xdb0d065a, 0x00000000, 0x00000000}},  //   _nėra_, ngaç,   ,
  { {0x7c2d022b, 0x9999003b, 0xa3b60061, 0x00000000}},  // [730] riar, икат_, _जाई_,
  { {0x442d065b, 0x6fb501ef, 0x7c2d065c, 0x00000000}},  //   zie_, _امکا, siar,
  { {0x7c2d065d, 0x442d065e, 0x9f520173, 0x00000000}},  //   piar, yie_, _anyè_,
  { {0x38660190, 0x442d065f, 0x81be0044, 0x00000000}},  //   gmor_, xie_, ঁজি_,
  { {0x442d0660, 0xc987003b, 0xb6c7007c, 0x00000000}},  //   vie_, _губи, ссей,
  { {0x442d0661, 0x2d830036, 0x853c0006, 0x00000000}},  //   wie_, ncje_, _idėj,
  { {0x442d0662, 0x1a68009e, 0x64490663, 0x00000000}},  //   tie_, _ایلی_, toei,
  { {0x52a900c0, 0x00000000, 0x00000000, 0x00000000}},  //   авим_,   ,   ,
  { {0x2d830046, 0x64490664, 0x1306007c, 0x00000000}},  //   kcje_, roei, жный_,
  { {0x442d0665, 0x69d70666, 0x7d0800ea, 0x00000000}},  //   sie_, nexe, ødsk,
  { {0x442d0667, 0x644900c4, 0x2d9a0052, 0x00000000}},  //   pie_, poei, _repe_,
  { {0xa2b2001c, 0xa3b602d2, 0x2d9a00ca, 0x00000000}},  //   _आमच्, _जाए_, _sepe_,
  { {0x2d9a0020, 0x6e2e002b, 0x823400a1, 0x00000000}},  //   _pepe_, tibb, _کرنا,
  { {0x63bb0668, 0x3ea20669, 0x00000000, 0x00000000}},  //   lgun, rskt_,   ,
  { {0xc5f2009b, 0xfce3004c, 0x69d7066a, 0x00000000}},  //   ודם_, моро, dexe,
  { {0x63bb020c, 0x799e00e7, 0x6b9f0045, 0x00000000}},  //   ngun, wapw, gaqg,
  { {0x81dc0044, 0x61e3066b, 0x8d760076, 0x00000000}},  // [740] ডার_, _kanl, _وادا,
  { {0x63bb04cb, 0x3866005b, 0x2002066c, 0x00000000}},  //   hgun, wmor_, ljki_,
  { {0x61e3066d, 0x00000000, 0x00000000, 0x00000000}},  //   _manl,   ,   ,
  { {0xb8f203d7, 0x6d5e066e, 0x46ea005e, 0x00000000}},  //   _वह_, _izpa, иден_,
  { {0x386601bf, 0x4e0e006e, 0x25be0009, 0x00000000}},  //   rmor_, _हवाई_, _pctl_,
  { {0x63bb066f, 0xb0a9007d, 0x61e3011c, 0x00000000}},  //   egun, _किंग, _nanl,
  { {0x6aa40023, 0xf8b000a1, 0x9f4500b9, 0x00000000}},  //   lsif, _سکا_, ělé_,
  { {0x61e30100, 0x799c0016, 0x6b840197, 0x00000000}},  //   _aanl, _herw, ncig,
  { {0x61e30670, 0x2d830036, 0x75d6023c, 0x00000000}},  //   _banl, ycje_, _ويرا,
  { {0x61e30671, 0x32180046, 0xd25a025f, 0x00000000}},  //   _canl, óry_, јци_,
  { {0x63bb022b, 0x799c0007, 0xb97b00b3, 0x00000000}},  //   bgun, _merw, יניי,
  { {0x68e30030, 0x27e60672, 0x69ca0164, 0x00000000}},  //   ændi, ndon_, स्ती,
  { {0x733600a1, 0x69ce0197, 0x63a00673, 0x00000000}},  //   _برائ, _obbe, mamn,
  { {0xd344007a, 0x61e3018e, 0x63a0033b, 0x00000000}},  //   _ویژه_, _ganl, lamn,
  { {0x6b84016c, 0x2cb800ea, 0x66080190, 0x00000000}},  //   fcig, gurd_, _modk,
  { {0x27e40674, 0xe3ac0044, 0x228001aa, 0x00000000}},  //   _namn_, ক্রব, _kòk_,
  { {0x27e60675, 0x61e30676, 0xa3cc007d, 0x00000000}},  // [750] ddon_, _yanl, श्य_,
  { {0x3eb90677, 0x63a000f8, 0x20090082, 0x00000000}},  //   must_, hamn, _hoai_,
  { {0x3eb9006c, 0x799c0678, 0x68e20036, 0x00000000}},  //   lust_, _derw, łodn,
  { {0x69ce0047, 0x6b840197, 0x661a010e, 0x00000000}},  //   _ebbe, ccig, _altk,
  { {0x3eb9006c, 0xd6db0679, 0xf770067a, 0x00000000}},  //   nust_, рте_, ناه_,
  { {0x62720036, 0x20090082, 0x799c005b, 0x00000000}},  //   _słon, _loai_, _gerw,
  { {0x1c0f02d2, 0x91fc0089, 0x61e300ca, 0x00000000}},  //   _सवाल_, rmāl, _ranl,
  { {0x3207067b, 0xd7c90558, 0x61e3067c, 0x00000000}},  //   _sony_, _دوره_, _sanl,
  { {0x63bb067d, 0x61e3011c, 0x660802a9, 0x00000000}},  //   rgun, _panl, _fodk,
  { {0x3eb90677, 0x6608063b, 0x6b9d00bb, 0x00000000}},  //   dust_, _godk, _lesg,
  { {0x61e3067e, 0xd87400a1, 0x610a006b, 0x00000000}},  //   _vanl, _راہب, vəlc,
  { {0x22800263, 0x63a00093, 0x54370167, 0x00000000}},  //   _fòk_, camn, _برطر,
  { {0xe803007d, 0x2f5602d3, 0xdbd9000c, 0x00000000}},  //   _रचना_, ятос, væðu,
  { {0x91e50594, 0x321e067f, 0x27380082, 0x00000000}},  //   _хоке, chty_, ẩng_,
  { {0xed5a0680, 0xdbd9000c, 0x8d63003b, 0x00000000}},  //   сов_, tæðu, евре,
  { {0x799c0046, 0x6b9d0681, 0x6c360025, 0x00000000}},  //   _serw, _cesg, أفرا,
  { {0x6b9d0682, 0xdbd9009f, 0x799c0169, 0x00000000}},  // [760] _desg, ræðu, _perw,
  { {0x6aa40169, 0xa3ab007d, 0x19b9007e, 0x00000000}},  //   rsif, कृत_, жуць_,
  { {0x799c0683, 0x6aa40684, 0x1b040044, 0x00000000}},  //   _verw, ssif, _রেখে_,
  { {0xdcf50036, 0x799c021f, 0x27e60685, 0x00000000}},  //   jczę, _werw, udon_,
  { {0x799c0686, 0x66080395, 0xe3c30044, 0x00000000}},  //   _terw, _podk, ্যাব,
  { {0xd49a00e3, 0x26c600b0, 0xd90d00a1, 0x00000000}},  //   бри_, rtoo_, دیہ_,
  { {0x628b0016, 0x3eb90687, 0x25fe007d, 0x00000000}},  //   _atgo, zust_, लाबी_,
  { {0xb6030089, 0xa3b6013d, 0x493b009b, 0x00000000}},  //   īšan, _जाओ_, _הגלו,
  { {0x2bce001c, 0x27f701c8, 0x85760688, 0x00000000}},  //   ह्या, šení_, _فدائ,
  { {0xe8e00011, 0x3eb9006c, 0x63a0000c, 0x00000000}},  //   _nhịp_, vust_, samn,
  { {0x3eb900b5, 0x69c10164, 0x00000000, 0x00000000}},  //   wust_, र्टी,   ,
  { {0x3eb90004, 0x8fa400ec, 0x5ed60044, 0x00000000}},  //   tust_, наџе, দিনে,
  { {0x6b9d0181, 0x79850016, 0x00000000, 0x00000000}},  //   _resg, ychw,   ,
  { {0x99ce0055, 0x3ead016c, 0x6b9d004a, 0x00000000}},  //   রযুক, šeto_, _sesg,
  { {0x61f801b5, 0x3eb9006c, 0x9d180264, 0x00000000}},  //   _invl, sust_, порт_,
  { {0x5c7403dc, 0x3eb90059, 0x99d400a1, 0x00000000}},  //   елст, pust_, ہتما,
  { {0x3eb90689, 0x00000000, 0x00000000, 0x00000000}},  // [770] qust_,   ,   ,
  { {0xdce7011f, 0xdcf50036, 0x601f0023, 0x00000000}},  //   sajı, zczę, _dëme,
  { {0x7985068a, 0x20190006, 0x02d9007d, 0x00000000}},  //   rchw, ūriu_, _भन्न,
  { {0x7985001f, 0x69c8014a, 0x00000000, 0x00000000}},  //   schw, _öden,   ,
  { {0x601f0065, 0x7c2f0022, 0x61f800d9, 0x00000000}},  //   _këmb, _imcr, _onvl,
  { {0x2bcb0061, 0x8afa009b, 0x00000000, 0x00000000}},  //   ाभवा, _והשי,   ,
  { {0x20f00521, 0x7aed051b, 0xa50602dc, 0x00000000}},  //   nđić_, lvat, деща_,
  { {0xfcaa007b, 0x3ea9021e, 0x61f80173, 0x00000000}},  //   קיפּ, _ovat_, _anvl,
  { {0x7aed00bb, 0x00000000, 0x00000000, 0x00000000}},  //   nvat,   ,   ,
  { {0xf0a90264, 0xbebb0023, 0x69c10061, 0x00000000}},  //   окол_, tzën, र्ची,
  { {0x7aed068b, 0xa06a0216, 0x3494005e, 0x00000000}},  //   hvat, жана_, _захр,
  { {0x7aed037e, 0xe4d400a1, 0x00000000, 0x00000000}},  //   kvat, _ستمب,   ,
  { {0x442f0365, 0x6d490035, 0x628b00ea, 0x00000000}},  //   _img_, şeal, _utgo,
  { {0x7a200047, 0x7aed068c, 0x00000000, 0x00000000}},  //   _köte, dvat,   ,
  { {0x425200a1, 0xc0a803ec, 0x7bcd068d, 0x00000000}},  //   _جنور, _فايل_, ffau,
  { {0x7a200039, 0xc172009b, 0x20190065, 0x00000000}},  //   _möte, _בחו_, ërit_,
  { {0xfaa3008b, 0x442f0127, 0x6d4500ab, 0x00000000}},  // [780] като, _mmg_, _exha,
  { {0xe9d70245, 0x601f0065, 0x00000000, 0x00000000}},  //   мку_, _vëme,   ,
  { {0x6d400477, 0x49990088, 0xd7e60088, 0x00000000}},  //   ğmas, яття_, діло,
  { {0x6d4001f6, 0x9f40068e, 0xafdb068f, 0x00000000}},  //   şmas, _unió_, fløy,
  { {0xc7a300e1, 0xa3c8013d, 0xd6d0035b, 0x00000000}},  //   тичк, _लॉग_, اقت_,
  { {0x3eaf0030, 0xe8df0082, 0x7a2000f8, 0x00000000}},  //   _ægte_, _luộc_, _böte,
  { {0x442f0690, 0x68e30190, 0xa5c4013d, 0x00000000}},  //   _bmg_, ændt, _राठौ,
  { {0x6b960056, 0x442f0691, 0xd467003b, 0x00000000}},  //   nbyg, _cmg_, мије_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xf8d202d2, 0x442f0093, 0xdb15009d, 0x00000000}},  //   _सहाय, _emg_, ébéc,
  { {0xd1300054, 0x7a200073, 0xe8df0011, 0x00000000}},  //   امج_, _göte, _buộc_,
  { {0xe8df001d, 0x7aed0161, 0x442f0692, 0x00000000}},  //   _cuộc_, yvat, _gmg_,
  { {0xd6d90036, 0x6b960693, 0x2ef20016, 0x00000000}},  //   _były_, dbyg, _cryf_,
  { {0x6ab60007, 0x2ef20007, 0x00000000, 0x00000000}},  //   dryf, _dryf_,   ,
  { {0x1bd50694, 0xfe24007c, 0x645c0089, 0x00000000}},  //   новя, тьян, _īrij,
  { {0x21b700a1, 0xec6803e8, 0x7aed0695, 0x00000000}},  //   _ٹھیک_, друк_, tvat,
  { {0x2ef20696, 0x2019008f, 0x7e770066, 0x00000000}},  // [790] _gryf_, ūris_, _tixp,
  { {0xe9d30025, 0xc95b007e, 0x9e6701b2, 0x00000000}},  //   ضغط_, оўе_, _تابن,
  { {0x7aed03b6, 0x58840147, 0x5c75007c, 0x00000000}},  //   svat, выча, _плот,
  { {0x2019023a, 0xafdb00ea, 0x39580146, 0x00000000}},  //   nksi_, tløy, _dyrs_,
  { {0x201900b0, 0x2a780026, 0x442f00d2, 0x00000000}},  //   iksi_, _firb_, _rmg_,
  { {0x442f0697, 0x68e30698, 0x644200b0, 0x00000000}},  //   _smg_, ænds, _ajoi,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xe7390016, 0x58d401e1, 0xc2fa0044, 0x00000000}},  //   _ddŵr_, _шост, েননি_,
  { {0x7c3a0699, 0x9f9d000c, 0xf6b500a1, 0x00000000}},  //   étri, væði_, _سماج,
  { {0x201900b0, 0x7a2001a2, 0x00000000, 0x00000000}},  //   eksi_, _töte,   ,
  { {0x6e3504eb, 0x9f9d01e5, 0x442f069a, 0x00000000}},  //   dizb, tæði_, _tmg_,
  { {0xcdc900b6, 0x80a003d7, 0x59cf0309, 0x00000000}},  //   _לך_, _खबरे, स्तर,
  { {0xef170057, 0x9f9d009f, 0x443f069b, 0x00000000}},  //   емя_, ræði_, mnu_,
  { {0xfce60216, 0x6145025f, 0xc69201ce, 0x00000000}},  //   ного, _пела, ראם_,
  { {0xa3cc02d2, 0x81c80055, 0xe8df0082, 0x00000000}},  //   श्व_, _লোক_, _tuộc_,
  { {0x443f069c, 0x645b069d, 0xfbdf01c3, 0x00000000}},  //   nnu_, nlui, _skêr_,
  { {0x6b96037d, 0x443f069e, 0xbdfa069f, 0x00000000}},  // [7a0] rbyg, inu_, _فردا_,
  { {0x443f06a0, 0x6b9606a1, 0x8e97009b, 0x00000000}},  //   hnu_, sbyg, _רדיו_,
  { {0xf1c201f5, 0x69c8011f, 0x6b96000c, 0x00000000}},  //   _शासन, _ödem, pbyg,
  { {0x443f06a2, 0x41cf0061, 0x96ea01e1, 0x00000000}},  //   jnu_, त्तस, зька_,
  { {0xc87901df, 0x68e30030, 0x645b0168, 0x00000000}},  //   _diş_, ændr, dlui,
  { {0x443f06a3, 0x2d980173, 0x857400a1, 0x00000000}},  //   enu_, nbre_, نگائ,
  { {0x443f069c, 0x5fc6001c, 0x69de06a4, 0x00000000}},  //   fnu_, _वाढल, mepe,
  { {0x443f037e, 0x66e601bd, 0x69de0010, 0x00000000}},  //   gnu_, _поба, lepe,
  { {0xe7d5005d, 0x00000000, 0x00000000, 0x00000000}},  //   lığı,   ,   ,
  { {0x443f001a, 0x9fd00044, 0x69de06a5, 0x00000000}},  //   anu_, িযোগ, nepe,
  { {0x443f06a6, 0x7c2406a7, 0x3a37009b, 0x00000000}},  //   bnu_, khir, תרים_,
  { {0x443f037e, 0x645b0489, 0x69de06a8, 0x00000000}},  //   cnu_, clui, hepe,
  { {0x7c2406a9, 0x4ea7007e, 0x201906aa, 0x00000000}},  //   dhir, эрна, rksi_,
  { {0x932500a1, 0x127b0049, 0xa3cc007d, 0x00000000}},  //   _جرمن, _זאגע, श्र_,
  { {0x69de01cb, 0xc0e301fc, 0x63a2008a, 0x00000000}},  //   depe, _бојк, _keon,
  { {0xe7d5047f, 0x61ea06ab, 0x63a20082, 0x00000000}},  //   dığı, _hafl, _jeon,
  { {0x61ea0651, 0x63a20022, 0x610a006b, 0x00000000}},  // [7b0] _kafl, _meon, zəll,
  { {0x443f06ac, 0x69de06ad, 0x7c240020, 0x00000000}},  //   znu_, gepe, ahir,
  { {0x443f018e, 0x7ae600ea, 0xdb160010, 0x00000000}},  //   ynu_, _eskt, rgyá,
  { {0x7c24001a, 0x63a206ae, 0x61ea06af, 0x00000000}},  //   chir, _neon, _lafl,
  { {0x4424002a, 0x443f0466, 0x69de01b5, 0x00000000}},  //   dhm_, vnu_, bepe,
  { {0x27e90091, 0xcfea0044, 0x69de001a, 0x00000000}},  //   žan_, গায়_, cepe,
  { {0x443f0091, 0x645b0007, 0x6e200023, 0x00000000}},  //   tnu_, tlui, ëmbi,
  { {0x7bdf00c4, 0x3eb9016c, 0x443f0205, 0x00000000}},  //   nequ, krst_, unu_,
  { {0x443f06b0, 0x63a20051, 0x645b06b1, 0x00000000}},  //   rnu_, _deon, rlui,
  { {0x645b06b2, 0xd24e006d, 0x443f0091, 0x00000000}},  //   slui, يني_, snu_,
  { {0x61ea0016, 0x443f036a, 0x645b009d, 0x00000000}},  //   _dafl, pnu_, plui,
  { {0x63a2007f, 0x69de0010, 0x9f4000f6, 0x00000000}},  //   _geon, zepe, _paià_,
  { {0x7bdf06b3, 0x69c7016e, 0x0ef9007e, 0x00000000}},  //   dequ, _ocje, нэры_,
  { {0xc3320452, 0xdd9206b4, 0x61ea06b5, 0x00000000}},  //   _דוד_, شور_, _gafl,
  { {0xed5700d7, 0x7c240020, 0xada306b6, 0x00000000}},  //   вор_, thir, расл,
  { {0x60d60104, 0x8c4300ed, 0x44f10066, 0x00000000}},  //   _יוצא_, аесе, _mġ_,
  { {0xeab1026c, 0x69de008e, 0xc1e50309, 0x00000000}},  // [7c0] یعے_, tepe, _कसाब_,
  { {0x7c2406b7, 0xceb90224, 0xba23007e, 0x00000000}},  //   shir, áře_, адук,
  { {0x69de0010, 0x291c06b8, 0x7bdf06b9, 0x00000000}},  //   repe, áva_, bequ,
  { {0x3ea001aa, 0x69de06ba, 0x7ae60058, 0x00000000}},  //   _kwit_, sepe, _tskt,
  { {0x62720036, 0xa6fa0025, 0x69de00e7, 0x00000000}},  //   _głow, بعاء_, pepe,
  { {0x4a750057, 0xaa4606bb, 0x7ae40020, 0x00000000}},  //   _быст, _регл, mwit,
  { {0x7a200039, 0x7ae40007, 0x63a206bc, 0x00000000}},  //   _göta, lwit, _peon,
  { {0x61ea018e, 0xa7850054, 0x7bc406bd, 0x00000000}},  //   _safl, _مشكو, ngiu,
  { {0x7ae406be, 0x7c23001a, 0x3ea001aa, 0x00000000}},  //   nwit, _înre, _nwit_,
  { {0x610a006b, 0x63a2004a, 0x7aeb0190, 0x00000000}},  //   səlm, _weon, ægti,
  { {0x859b0104, 0x85060070, 0x3ea0011c, 0x00000000}},  //   _חשבו, _جوان, _awit_,
  { {0xc95300b6, 0x7bdf00d4, 0x7d0300d4, 0x00000000}},  //   ימת_, xequ, _ànsi,
  { {0x61ea06bf, 0x7bdf0068, 0x00000000, 0x00000000}},  //   _tafl, vequ,   ,
  { {0xf77301f8, 0x6e94007c, 0x00000000, 0x00000000}},  //   יקר_, риру,   ,
  { {0x62720046, 0x7bdf06c0, 0x7ae406c1, 0x00000000}},  //   _słow, tequ, ewit,
  { {0x7bc40207, 0xa177009b, 0xd10f007d, 0x00000000}},  //   ggiu, _בעוד_, ाहरण_,
  { {0x7ae4002b, 0xdb1d0173, 0x00000000, 0x00000000}},  // [7d0] gwit, _absò,   ,
  { {0x7bdf06c2, 0xf7f4007a, 0x2ee90016, 0x00000000}},  //   sequ, یسند, _isaf_,
  { {0x7bdf004a, 0x00000000, 0x00000000, 0x00000000}},  //   pequ,   ,   ,
  { {0x787a00b9, 0x7ae40066, 0x00000000, 0x00000000}},  //   _důvo, bwit,   ,
  { {0x81d20082, 0x601f0023, 0x00000000, 0x00000000}},  //   _rồng, _lëmo,   ,
  { {0x6aad06c3, 0x6b8d0026, 0xc98700ed, 0x00000000}},  //   msaf, lcag, _шуми,
  { {0x6aad0475, 0xd5ae0439, 0x00000000, 0x00000000}},  //   lsaf, سفي_,   ,
  { {0xd46606c4, 0x6b8d008e, 0x69c506c5, 0x00000000}},  //   лище_, ncag, lghe,
  { {0x2bd5001c, 0x6aad03ba, 0x65950088, 0x00000000}},  //   ड्या, nsaf, _базу,
  { {0x2d81001d, 0x95d8007c, 0xc5fb006d, 0x00000000}},  //   _nghe_, _идут_, _تعرض_,
  { {0xe4cb06c6, 0x2ee906c7, 0x69c50051, 0x00000000}},  //   _زبان_, _asaf_, ighe,
  { {0x25a50019, 0xf3f00025, 0x27ed06c8, 0x00000000}},  //   _hell_, _وأن_, _jaen_,
  { {0x25a506c9, 0x27ed06ca, 0x63a90056, 0x00000000}},  //   _kell_, _maen_, maen,
  { {0x27ed06cb, 0x63a9006c, 0x6aad0190, 0x00000000}},  //   _laen_, laen, dsaf,
  { {0x27ff027d, 0x61e1049a, 0x03e60055, 0x00000000}},  //   _onun_, mell, কারী_,
  { {0x6b8d001c, 0x61e1021e, 0x63a906cc, 0x00000000}},  //   gcag, lell, naen,
  { {0xab6606cd, 0x60c10026, 0x6aad06ce, 0x00000000}},  // [7e0] увал, lulm, gsaf,
  { {0x25a50198, 0x787a0224, 0xdcee0279, 0x00000000}},  //   _nell_, _půvo, sabı,
  { {0x610a005f, 0x60c106cf, 0x63a906d0, 0x00000000}},  //   vəlk, nulm, kaen,
  { {0x61e100b0, 0x6b8d06d1, 0x27ed06d2, 0x00000000}},  //   hell, ccag, _caen_,
  { {0x61e10018, 0x60c106d3, 0x6d5e06d4, 0x00000000}},  //   kell, hulm, _hypa,
  { {0x7e7e01d5, 0x25a50038, 0x61e10065, 0x00000000}},  //   _jipp, _cell_, jell,
  { {0x61e106d5, 0x25a5051b, 0x83fd0010, 0x00000000}},  //   dell, _dell_, klőd,
  { {0x7e7e00b0, 0x3a3a0002, 0x44220047, 0x00000000}},  //   _lipp, lipp_, ók_,
  { {0x61e106d6, 0x610a006b, 0x25a506d7, 0x00000000}},  //   fell, məli, _fell_,
  { {0x61e1014a, 0xf1c600b9, 0x645906d8, 0x00000000}},  //   gell, _část_, _ekwi,
  { {0x63a9011c, 0x00000000, 0x00000000, 0x00000000}},  //   baen,   ,   ,
  { {0x0eeb007c, 0x7e7e00ea, 0x25a50440, 0x00000000}},  //   ньги_, _aipp, _zell_,
  { {0xe29600ed, 0x7e7e01ee, 0x69c506d9, 0x00000000}},  //   _среќ, _bipp, yghe,
  { {0x61e106da, 0x7e7e0197, 0x2fc900c4, 0x00000000}},  //   cell, _cipp, _wcag_,
  { {0x6b8d001c, 0x7e7e0436, 0x00000000, 0x00000000}},  //   tcag, _dipp,   ,
  { {0x60df0047, 0x6aad00eb, 0x6d5e0023, 0x00000000}},  //   őzmé, tsaf, _dypa,
  { {0x5a35026b, 0x765a06db, 0x2ee90085, 0x00000000}},  // [7f0] анат, _okty, _usaf_,
  { {0x6b8d0197, 0x321e0036, 0x6aad03d0, 0x00000000}},  //   scag, nkty_, rsaf,
  { {0x69c50207, 0x6aad0197, 0x9967003b, 0x00000000}},  //   rghe, ssaf, утал,
  { {0x765a06dc, 0x61e10284, 0x62720036, 0x00000000}},  //   _akty, zell, _złot,
  { {0x25a50221, 0x61e102fa, 0x60c10279, 0x00000000}},  //   _pell_, yell, zulm,
  { {0xf77006dd, 0x61e100f4, 0x60c10180, 0x00000000}},  //   سان_, xell, yulm,
  { {0x63a906de, 0x61e1032c, 0x25a50129, 0x00000000}},  //   taen, vell, _vell_,
  { {0x25a50038, 0x61e105af, 0xb6c900a1, 0x00000000}},  //   _well_, well, _لائے_,
  { {0x61e103a1, 0x25a500ab, 0xcb120049, 0x00000000}},  //   tell, _tell_, ַלט_,
  { {0x60c106df, 0x22150140, 0xdb0d004a, 0x00000000}},  //   tulm, рфир, ngañ,
  { {0xc5fa007b, 0xb5fa0049, 0x386d000a, 0x00000000}},  //   _שפעט, _שלעכ, _kher_,
  { {0x61e106e0, 0x437506e1, 0x60c1005d, 0x00000000}},  //   sell, _култ, rulm,
  { {0x2055008b, 0x61e106e2, 0xeac00044, 0x00000000}},  //   стэр, pell, _উন্ম,
  { {0x6da3026b, 0x533206e3, 0x610a006b, 0x00000000}},  //   жира, _фељт, zəli,
  { {0xed5a0057, 0x7e7e0190, 0x62860161, 0x00000000}},  //   тов_, _vipp, íkov,
  { {0x1e86005e, 0x200006e4, 0x6d5e01ca, 0x00000000}},  //   _клим, _unii_, _vypa,

  { {0x7e7e06e5, 0x62720046, 0x6d5e0046, 0x00000000}},  // [800] _tipp, _głos, _wypa,
  { {0x6d410051, 0x3ead002b, 0x3c3f00b0, 0x00000000}},  //   úlac, ġett_, tävä_,
  { {0x6e3c06e6, 0x610a006b, 0x386d0146, 0x00000000}},  //   mirb, təli, _bher_,
  { {0x386d00f4, 0xd90d00a6, 0xe8df0082, 0x00000000}},  //   _cher_, ریق_, _cuốc_,
  { {0x66f406e7, 0xc6a302d3, 0x610a006b, 0x00000000}},  //   сплу, орщи, rəli,
  { {0x386d010f, 0xdb060023, 0xfaa302dc, 0x00000000}},  //   _eher_, _lekë, _фаро,
  { {0x290700f8, 0x00000000, 0x00000000, 0x00000000}},  //   änat_,   ,   ,
  { {0x6a6b010f, 0x387f0026, 0xe8df0082, 0x00000000}},  //   rüfe, _giur_, _guốc_,
  { {0xf5ea026b, 0xdb0d000c, 0x00000000, 0x00000000}},  //   _имал_, ngað,   ,
  { {0xd4d6008b, 0x387f002d, 0xe8040061, 0x00000000}},  //   _відэ, _ziur_, ळावा_,
  { {0x6e3c06e8, 0x741600a2, 0x321e06e9, 0x00000000}},  //   dirb, _پوشا, rkty_,
  { {0x91fc01c5, 0x00000000, 0x00000000, 0x00000000}},  //   flāc,   ,   ,
  { {0x229406ea, 0x32940025, 0xd042006b, 0x00000000}},  //   _التس, _التأ, ntlə,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x2ba702a8, 0x442606eb, 0x62720036, 0x00000000}},  //   ијав, _klo_, _włos,
  { {0x5bb80057, 0x717b009b, 0xd042006b, 0x00000000}},  //   ился_, _בנוס, ktlə,
  { {0xaed5003b, 0xb066006c, 0x442600e7, 0x00000000}},  // [810] _уопш, svää, _mlo_,
  { {0x4426049a, 0x7d1c06ec, 0x7c2600f8, 0x00000000}},  //   _llo_, byrs, _elkr,
  { {0xda780242, 0x4f5800a6, 0x442600b0, 0x00000000}},  //   рят_, _مجید_, _olo_,
  { {0xd126009c, 0xe8df00ad, 0x442606ed, 0x00000000}},  //   _ہم_, _quốc_, _nlo_,
  { {0x610a006b, 0x3a3800fa, 0x00000000, 0x00000000}},  //   məlu, _fmrp_,   ,
  { {0x442606ee, 0x386d00e0, 0xe5a2007c, 0x00000000}},  //   _alo_, _wher_, пиши,
  { {0x442606ef, 0x29070479, 0x81ac0044, 0x00000000}},  //   _blo_, ånad_, গলা_,
  { {0x436901be, 0x44260462, 0xd4e40088, 0x00000000}},  //   лайн_, _clo_, юючи,
  { {0x44260263, 0x00000000, 0x00000000, 0x00000000}},  //   _dlo_,   ,   ,
  { {0x442600b0, 0x00000000, 0x00000000, 0x00000000}},  //   _elo_,   ,   ,
  { {0x442606f0, 0x6d400279, 0x1b1b0044, 0x00000000}},  //   _flo_, şmaz, _নেমে_,
  { {0x44260343, 0x00000000, 0x00000000, 0x00000000}},  //   _glo_,   ,   ,
  { {0x2bcb013d, 0x00000000, 0x00000000, 0x00000000}},  //   िलना,   ,   ,
  { {0xe29c007b, 0x44260091, 0x7d1c0065, 0x00000000}},  //   _ישׂר, _zlo_, tyrs,
  { {0x823406f1, 0x1d1901fb, 0x6fc10061, 0x00000000}},  //   _برنا, ають_, _वाचू,
  { {0x61b7024c, 0x6f1d06f2, 0x3b8606f3, 0x00000000}},  //   _आयुष, bysc, слаг,
  { {0xe9da0001, 0xc053009b, 0x3b0705f6, 0x00000000}},  // [820] лка_, _מזה_, бето_,
  { {0x7dea007c, 0xdb0d01e5, 0x00000000, 0x00000000}},  //   _смог_, rgað,   ,
  { {0xe8040061, 0xd23a0049, 0x00000000, 0x00000000}},  //   ळाला_, נגעל,   ,
  { {0xa967005e, 0x00000000, 0x00000000, 0x00000000}},  //   щиха_,   ,   ,
  { {0x29070039, 0x628f06f4, 0x00000000, 0x00000000}},  //   änar_, ícol,   ,
  { {0x442606f5, 0xd042005f, 0xe4a60081, 0x00000000}},  //   _slo_, rtlə, брио,
  { {0x442606f6, 0xd042005f, 0xd4970642, 0x00000000}},  //   _plo_, stlə, бры_,
  { {0x29050107, 0x786a01ca, 0x9418007c, 0x00000000}},  //   _šlag_, býva, ржит_,
  { {0x59cf00e8, 0x6a700039, 0x69c800f8, 0x00000000}},  //   स्कर, räff, _ödes,
  { {0x27e60061, 0x6d40005a, 0xf23800ed, 0x00000000}},  //   leon_, şmay, рпош_,
  { {0x69dc06f7, 0x69ce000a, 0x4426016e, 0x00000000}},  //   _mbre, _mcbe, _tlo_,
  { {0x6f1d001c, 0x43860054, 0x4426006a, 0x00000000}},  //   tysc, _الإق, _ulo_,
  { {0x69dc04bd, 0x00000000, 0x00000000, 0x00000000}},  //   _obre,   ,   ,
  { {0x44f80011, 0x13ad0044, 0x7d0100ea, 0x00000000}},  //   _kĩ_, _গায়, ålso,
  { {0x2d910036, 0xb4250036, 0xceb4006b, 0x00000000}},  //   rcze_, łżeń, _evə_,
  { {0x69dc06f8, 0x44f80082, 0x649501f3, 0x00000000}},  //   _abre, _mĩ_, _wġig,
  { {0x7b67051f, 0x69dc01f3, 0xd24d00a1, 0x00000000}},  // [830] стве, _bbre, _سچی_,
  { {0x6495002b, 0x00000000, 0x00000000, 0x00000000}},  //   _uġig,   ,   ,
  { {0xdd9200a2, 0xa8cb0439, 0x00000000, 0x00000000}},  //   _توپ_, طباق_,   ,
  { {0x7c67004b, 0x69dc06f9, 0x27e606fa, 0x00000000}},  //   _داخل, _ebre, geon_,
  { {0x7c2d06fb, 0xdcf50279, 0x64950066, 0x00000000}},  //   mhar, mazı, _mġie,
  { {0x601f0023, 0x00000000, 0x00000000, 0x00000000}},  //   _dëmi,   ,   ,
  { {0x2409007c, 0xafdb0030, 0x7afd06fc, 0x00000000}},  //   инки_, rnøj, _hrst,
  { {0x7afd041a, 0x7c2d0181, 0x601f008d, 0x00000000}},  //   _krst, nhar, _fëmi,
  { {0xc7b90010, 0x20f7001a, 0x7afb01ed, 0x00000000}},  //   _idő_, _săi_, _šutj,
  { {0x80cd0044, 0x20f70035, 0xdcf501df, 0x00000000}},  //   ়বস্, _păi_, hazı,
  { {0x7bcf06fd, 0x7c2d008a, 0x629b00b0, 0x00000000}},  //   _occu, khar, spuo,
  { {0xe8e00082, 0x00000000, 0x00000000, 0x00000000}},  //   _chộp_,   ,   ,
  { {0x7c2d06fe, 0x442d002a, 0xc7d6009b, 0x00000000}},  //   dhar, mhe_, חורי_,
  { {0x443f010a, 0x7bcf06ff, 0x442d0181, 0x00000000}},  //   liu_, _accu, lhe_,
  { {0x628b0058, 0x7afd006c, 0xa06a0517, 0x00000000}},  //   _hugo, _arst, _кака_,
  { {0x443f0700, 0x7c2d0020, 0x442d0701, 0x00000000}},  //   niu_, ghar, nhe_,
  { {0x628b0702, 0x63ab0047, 0x64490103, 0x00000000}},  // [840] _jugo, _megn, inei,
  { {0x63ab0703, 0x6449010f, 0x628b0202, 0x00000000}},  //   _legn, hnei, _mugo,
  { {0x7afd0109, 0x7c2d002a, 0x443f010a, 0x00000000}},  //   _erst, bhar, kiu_,
  { {0x7c2d032c, 0x60da0049, 0x62990036, 0x00000000}},  //   char, יקענ, _otwo,
  { {0x442d008d, 0x443f0704, 0x44f8001d, 0x00000000}},  //   dhe_, diu_, _sĩ_,
  { {0x6283011c, 0x7c240004, 0x27e60705, 0x00000000}},  //   _nino, lkir, seon_,
  { {0x7a20010f, 0x628b0089, 0x291c006c, 0x00000000}},  //   _nöti, _augo, ävad_,
  { {0x442d0375, 0x7c240706, 0x628300b0, 0x00000000}},  //   ghe_, nkir, _aino,
  { {0x62830058, 0x63ab0197, 0x64950066, 0x00000000}},  //   _bino, _degn, _rġie,
  { {0x386604bd, 0x628b0091, 0x644900c4, 0x00000000}},  //   llor_, _dugo, anei,
  { {0x9354026c, 0xf993019b, 0x2fcb001c, 0x00000000}},  //   _کراچ, ורת_, tgcg_,
  { {0x442d0707, 0x63ab0708, 0x443f0027, 0x00000000}},  //   che_, _gegn, ciu_,
  { {0xe1ef00d3, 0xc7b300b6, 0x6440011c, 0x00000000}},  //   رسی_, ובר_, mimi,
  { {0x62830709, 0x6440070a, 0x63ab0190, 0x00000000}},  //   _gino, limi, _zegn,
  { {0x7c2d070b, 0xfe6e02fd, 0x7c240066, 0x00000000}},  //   thar, دگي_, fkir,
  { {0x6440070c, 0x7afd0091, 0x62830006, 0x00000000}},  //   nimi, _prst, _zino,
  { {0x7c2d04cb, 0xdceb005d, 0xdcf50180, 0x00000000}},  // [850] rhar, ınız, razı,
  { {0x7c2d000b, 0x6440070d, 0x7afd01d9, 0x00000000}},  //   shar, himi, _vrst,
  { {0x6440070e, 0x7c2d0541, 0x3866008e, 0x00000000}},  //   kimi, phar, flor_,
  { {0xdce5001d, 0x6440070f, 0x443f04bd, 0x00000000}},  //   _nghĩ, jimi, xiu_,
  { {0x64400710, 0x63ab068f, 0x66050265, 0x00000000}},  //   dimi, _regn, зпла,
  { {0x63ab0198, 0x628b0065, 0x61e80166, 0x00000000}},  //   _segn, _rugo, jedl,
  { {0x442d0711, 0x443f04bd, 0x7aed01aa, 0x00000000}},  //   the_, tiu_, lwat,
  { {0x64400712, 0x7bcd0006, 0x628b0058, 0x00000000}},  //   gimi, ngau, _pugo,
  { {0x443f0713, 0x6283006a, 0x63ab009f, 0x00000000}},  //   riu_, _pino, _vegn,
  { {0x442d0714, 0x443f04a5, 0x63ab0168, 0x00000000}},  //   she_, siu_, _wegn,
  { {0x442d00f4, 0x64400715, 0x443f0716, 0x00000000}},  //   phe_, bimi, piu_,
  { {0x64400219, 0x628b0717, 0x3ea901aa, 0x00000000}},  //   cimi, _tugo, _bwat_,
  { {0x62990036, 0x62830718, 0x628b00e0, 0x00000000}},  //   _utwo, _tino, _uugo,
  { {0x7aed0719, 0x3ea90263, 0xe8e00082, 0x00000000}},  //   dwat, _dwat_, _chớp_,
  { {0x7aed00e0, 0x32070036, 0x386600ab, 0x00000000}},  //   ewat, _inny_, ylor_,
  { {0x5fc6001c, 0x7aed00e7, 0xdddc0161, 0x00000000}},  //   _वाटल, fwat, zorň,
  { {0x7c24071a, 0x7aed071b, 0xd5b80089, 0x00000000}},  // [860] rkir, gwat, _klāt_,
  { {0x64400714, 0x7c2404a5, 0x4efb071c, 0x00000000}},  //   zimi, skir, _פליג,
  { {0x6440006b, 0xae1b01ce, 0x7aed0022, 0x00000000}},  //   yimi, _הויכ, awat,
  { {0x644000f4, 0x00000000, 0x00000000, 0x00000000}},  //   ximi,   ,   ,
  { {0x6440071d, 0x38660210, 0xb86600a1, 0x00000000}},  //   vimi, rlor_, _ہارو,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6440071e, 0xb86603ab, 0x61e805d2, 0x00000000}},  //   timi, _فارو, vedl,
  { {0x329800ed, 0x443d01c3, 0x7afb0166, 0x00000000}},  //   овиќ_, _cmw_, _šuti,
  { {0x5fc60061, 0x61e80133, 0x00000000, 0x00000000}},  //   _वाजल, tedl,   ,
  { {0x64400710, 0x80c002fb, 0x4b3700a0, 0x00000000}},  //   simi, _विदे, פריל_,
  { {0x64a3008b, 0x3ea90066, 0x61e8003b, 0x00000000}},  //   _заха, _swat_, redl,
  { {0x7aed0046, 0xdcb10082, 0x6440071f, 0x00000000}},  //   ywat, ẩm_, qimi,
  { {0x661a044e, 0x82fa00a6, 0x00000000, 0x00000000}},  //   _kotk, _دراز_,   ,
  { {0x661a021e, 0x6e3e0009, 0xe3b00167, 0x00000000}},  //   _jotk, _cmpb, _سرچ_,
  { {0x61db01f8, 0x601f0065, 0x5fc60061, 0x00000000}},  //   _הקוד, _sëmu, _वाचल,
  { {0x7bcd0006, 0x00000000, 0x00000000, 0x00000000}},  //   ugau,   ,   ,
  { {0xa3de02d2, 0x7bcd04cb, 0x601f0065, 0x00000000}},  // [870] द्य_, rgau, _dëmt,
  { {0x2486002a, 0x91fc001e, 0x661a0720, 0x00000000}},  //   _liom_, klām, _notk,
  { {0x7aed00bb, 0xf9880025, 0x9f52009d, 0x00000000}},  //   swat, أنمي_, _rayé_,
  { {0xa2bd0309, 0x6608010e, 0x6b960145, 0x00000000}},  //   _शिल्, _andk, ccyg,
  { {0xd6db012b, 0x9f52009d, 0x661a00f8, 0x00000000}},  //   сте_, _payé_, _botk,
  { {0x443d0022, 0x95cb007c, 0x661a0087, 0x00000000}},  //   _smw_, суда_, _cotk,
  { {0x661a0721, 0xf8ae0014, 0x443d0722, 0x00000000}},  //   _dotk, _نکن_, _pmw_,
  { {0x3e640010, 0x00000000, 0x00000000, 0x00000000}},  //   lött_,   ,   ,
  { {0x661a0428, 0xe1f200a1, 0x443d00d9, 0x00000000}},  //   _fotk, چسپ_, _vmw_,
  { {0x20090723, 0x80d90088, 0x7a2001e5, 0x00000000}},  //   _anai_, оєму_, _fötu,
  { {0x764301a3, 0x7a20000c, 0x443d0724, 0x00000000}},  //   miny, _götu, _tmw_,
  { {0xa3ae02d2, 0x76430129, 0x3f6a003b, 0x00000000}},  //   करण_, liny, жимо_,
  { {0xd092005f, 0x7a2003ed, 0xdb06008e, 0x00000000}},  //   _müəy, _kött, _pekí,
  { {0xfce60088, 0x1e83007e, 0x7643033b, 0x00000000}},  //   мого, клям, niny,
  { {0x91fc0089, 0x7a200039, 0x3e640010, 0x00000000}},  //   klāj, _mött, dött_,
  { {0x7643027c, 0x601f0065, 0x7a200725, 0x00000000}},  //   hiny, _dëms, _lött,
  { {0xdd8f026c, 0x764304cb, 0xcb670726, 0x00000000}},  // [880] اوہ_, kiny, дате_,
  { {0x76430727, 0x67220020, 0x3e640010, 0x00000000}},  //   jiny, vyoj, gött_,
  { {0x76430728, 0x6ab60203, 0x00000000, 0x00000000}},  //   diny, ssyf,   ,
  { {0x8c460081, 0x2d9802d0, 0x661a00b0, 0x00000000}},  //   _цеме, lcre_, _sotk,
  { {0x76430729, 0x00000000, 0x00000000, 0x00000000}},  //   finy,   ,   ,
  { {0xd49a0200, 0x9d45026c, 0x7643072a, 0x00000000}},  //   ори_, _آئین, giny,
  { {0xf983072b, 0x661a072c, 0x7a2000f8, 0x00000000}},  //   _агро, _votk, _dött,
  { {0xa803005e, 0x69de00d9, 0x00000000, 0x00000000}},  //   _изсл, lfpe,   ,
  { {0x76430056, 0x7a20072d, 0xa01b072e, 0x00000000}},  //   biny, _fött, lmög,
  { {0x7a20072f, 0x20090026, 0x7643008a, 0x00000000}},  //   _gött, _snai_, ciny,
  { {0x644b01e5, 0x00000000, 0x00000000, 0x00000000}},  //   ðmið,   ,   ,
  { {0x3e640047, 0x53460730, 0x03260140, 0x00000000}},  //   zött_, _охла, _оден,
  { {0x80c00309, 0x00000000, 0x00000000, 0x00000000}},  //   _विवे,   ,   ,
  { {0x7412009e, 0x00000000, 0x00000000, 0x00000000}},  //   _سوڈا,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x61f80731, 0x76430173, 0x2009002d, 0x00000000}},  //   _havl, ziny, _unai_,
  { {0x76430732, 0x3a750072, 0x61f80460, 0x00000000}},  // [890] yiny, елар, _kavl,
  { {0x61f80091, 0x61fa05b7, 0x9987013e, 0x00000000}},  //   _javl, ndtl, ónů_,
  { {0x7643007f, 0xa3ae0164, 0x7a2004ce, 0x00000000}},  //   viny, करा_, _rött,
  { {0x2c2701fb, 0xfc3f01dc, 0x6d5701f3, 0x00000000}},  //   _цьог, _umí_, _ixxa,
  { {0x76430169, 0x6b9a009b, 0x00000000, 0x00000000}},  //   tiny, _משרד,   ,
  { {0xf77002fd, 0x61f80733, 0x321c04bb, 0x00000000}},  //   جام_, _navl, _novy_,
  { {0x76430734, 0x9f4e00b9, 0x00000000, 0x00000000}},  //   riny, čném_,   ,
  { {0x76430169, 0x00000000, 0x00000000, 0x00000000}},  //   siny,   ,   ,
  { {0xa3de0164, 0x61f80161, 0xe8df0011, 0x00000000}},  //   द्ध_, _bavl, _khỏa_,
  { {0x80c00201, 0x29030022, 0x00000000, 0x00000000}},  //   _विशे, _krja_,   ,
  { {0xa06a005e, 0xe0460735, 0x90460014, 0x00000000}},  //   зана_, енни, فنده,
  { {0x44f10736, 0xdb060027, 0xa3de0164, 0x00000000}},  //   _iš_, _leká, द्द_,
  { {0xd12e00e9, 0xc2c80151, 0x932701fa, 0x00000000}},  //   لمی_, _قبول_, _تران,
  { {0x2d8c0737, 0x32d90173, 0x44f1012d, 0x00000000}},  //   øde_, mèy_, _kš_,
  { {0xdb040219, 0x32d90263, 0x1d070594, 0x00000000}},  //   mbié, lèy_, нери_,
  { {0x61f80738, 0x00000000, 0x00000000, 0x00000000}},  //   _zavl,   ,   ,
  { {0x2903002b, 0x442f0739, 0x44f101ee, 0x00000000}},  // [8a0] _arja_, _mlg_, _lš_,
  { {0x4a4300ed, 0x44f1073a, 0x442f01c3, 0x00000000}},  //   гнув, _oš_, _llg_,
  { {0x4c860265, 0x442f01a2, 0xd826073b, 0x00000000}},  //   _плов, _olg_, нджи,
  { {0x6f04073c, 0x69d50382, 0xa01b073d, 0x00000000}},  //   _kric, _ecze, rmög,
  { {0xdcfc005f, 0x44f1010a, 0x45d4031b, 0x00000000}},  //   marı, _aš_, волс,
  { {0xdcfc01f6, 0xceb3073e, 0x6f040022, 0x00000000}},  //   ları, ניו_, _mric,
  { {0xdb1d000a, 0x6e200023, 0x442f010e, 0x00000000}},  //   _adsè, ëmby, _blg_,
  { {0x6f04000d, 0x61f8037e, 0xdcfc005d, 0x00000000}},  //   _oric, _savl, narı,
  { {0x61f8003b, 0x32d90173, 0x99610089, 0x00000000}},  //   _pavl, gèy_, _cīņa_,
  { {0x442f00ea, 0xdb0f00f6, 0x249e0082, 0x00000000}},  //   _elg_, _decè, _tttm_,
  { {0x403500ed, 0xdcfc011f, 0x3a37009b, 0x00000000}},  //   венс, karı, גרים_,
  { {0x6f04032c, 0x00000000, 0x00000000, 0x00000000}},  //   _bric,   ,   ,
  { {0x61f800eb, 0x6d48073f, 0x9346007c, 0x00000000}},  //   _tavl, údan, _янде,
  { {0x6f040039, 0xbe88007c, 0x00000000, 0x00000000}},  //   _dric, ессе_,   ,
  { {0x6f040740, 0xf1b300b3, 0xcfb00044, 0x00000000}},  //   _eric, _עסק_, _কারন,
  { {0x6f04001a, 0x3ea001d5, 0xac18003b, 0x00000000}},  //   _fric, _ftit_, носу_,
  { {0x06e80055, 0xf9c70741, 0x628a0010, 0x00000000}},  // [8b0] পিডি, ещен, _kifo,
  { {0x8b08013e, 0x9f400288, 0x00000000, 0x00000000}},  //   _spřá, _gaiñ_,   ,
  { {0xdcfc0279, 0xa928007e, 0xbc790088, 0x00000000}},  //   barı, ніце_, _обох_,
  { {0x69d50036, 0xdcfc006b, 0x628a005b, 0x00000000}},  //   _wcze, carı, _lifo,
  { {0xe8df001d, 0x799c0016, 0x80380049, 0x00000000}},  //   _thỏa_, _ffrw, ענדע_,
  { {0x69d50046, 0xb5c202f0, 0x32d901aa, 0x00000000}},  //   _ucze, айшл, vèy_,
  { {0x442f033b, 0x224500ca, 0xaa540545, 0x00000000}},  //   _plg_, vilk_, _сврш,
  { {0xd1380046, 0x130902d3, 0x32d901aa, 0x00000000}},  //   dzą_, дний_, tèy_,
  { {0x628a0039, 0x5695005e, 0x95d900ed, 0x00000000}},  //   _bifo, _разт, _одат_,
  { {0xdcfc0279, 0x32d90263, 0x6442002d, 0x00000000}},  //   zarı, rèy_, _emoi,
  { {0xa2bd02f4, 0xf992009b, 0x628a0056, 0x00000000}},  //   _शिक्, ירי_, _difo,
  { {0xdcfc005f, 0x3ea00742, 0x22450190, 0x00000000}},  //   xarı, _ptit_, silk_,
  { {0x63a90743, 0xe1ee0256, 0x539a0104, 0x00000000}},  //   mben, _кг_, _חינו,
  { {0x63a90089, 0x787800fa, 0x6fa2007d, 0x00000000}},  //   lben, míve, _क्रू,
  { {0x61d6012f, 0xdcfc027d, 0xd1380036, 0x00000000}},  //   _יוסף_, tarı, czą_,
  { {0x6b8f001c, 0x2188007b, 0x51840099, 0x00000000}},  //   _cgcg, _אָפּ, _суча,
  { {0x78780181, 0x27fd018e, 0xea8a06e3, 0x00000000}},  // [8c0] níve, ddwn_, дбал_,
  { {0xdcfc014a, 0x26cf0744, 0x00000000, 0x00000000}},  //   sarı, dugo_,   ,
  { {0xdcfc005d, 0xd7fa0745, 0x7d010374, 0x00000000}},  //   parı, дул_, ålst,
  { {0x26cf0020, 0xb6a600e2, 0x3ead0035, 0x00000000}},  //   fugo_, видл, ţete_,
  { {0x63a90746, 0xfaa60098, 0x00000000, 0x00000000}},  //   dben, _јаго,   ,
  { {0x63a9010f, 0x787800b9, 0x00000000, 0x00000000}},  //   eben, díve,   ,
  { {0x628a01bc, 0xd94601fc, 0x499100a1, 0x00000000}},  //   _rifo, _реви, _ایمر,
  { {0xd70600d7, 0x7c36018e, 0x628a04be, 0x00000000}},  //   _изби, nhyr, _sifo,
  { {0x97ea005f, 0x26dd0046, 0xe0ae0044, 0x00000000}},  //   ışdı, ctwo_, _কমেন,
  { {0x62060088, 0x00000000, 0x00000000, 0x00000000}},  //   тчиз,   ,   ,
  { {0xc4c50464, 0x1be2006e, 0x6457004a, 0x00000000}},  //   _متنو, खभाल_, éxic,
  { {0x23ba004b, 0x14d700b3, 0x787800c4, 0x00000000}},  //   _آداب_, _יובל_, bíve,
  { {0xd1380046, 0x628a0747, 0x787800c4, 0x00000000}},  //   szą_, _tifo, cíve,
  { {0xa3de02fb, 0xdb1601aa, 0x00000000, 0x00000000}},  //   द्र_, mayè,   ,
  { {0x69c8014a, 0x00000000, 0x00000000, 0x00000000}},  //   _ödey,   ,   ,
  { {0xdb0f0035, 0xdfd10025, 0xc61f0309, 0x00000000}},  //   _decî, _اية_, _भव्य_,
  { {0x06d70044, 0x9f5200f6, 0x00000000, 0x00000000}},  // [8d0] _দৈনি, _gayà_,   ,
  { {0x63a90209, 0x26cf0009, 0xbdf5025f, 0x00000000}},  //   zben, vugo_, _спој,
  { {0x27ef01e3, 0x00000000, 0x00000000, 0x00000000}},  //   tegn_,   ,   ,
  { {0xdb060002, 0x00000000, 0x00000000, 0x00000000}},  //   _bekä,   ,   ,
  { {0x7c2d006b, 0x27ef0748, 0x787800c4, 0x00000000}},  //   mkar, regn_, xíve,
  { {0xd7740054, 0x26cf0058, 0xbb3a0049, 0x00000000}},  //   جامع, rugo_, _טערי,
  { {0xd4690175, 0x245a0089, 0x26dd0036, 0x00000000}},  //   нике_, zīme_, stwo_,
  { {0x7c2d002d, 0x78780749, 0x63a9074a, 0x00000000}},  //   nkar, tíve, uben,
  { {0x63a904cb, 0xc7b2034e, 0x7c2d000c, 0x00000000}},  //   rben, _לבן_, ikar,
  { {0x63a90059, 0x96f8002c, 0x7c2d074b, 0x00000000}},  //   sben, _جعفر_, hkar,
  { {0x7c2d00b0, 0x78780181, 0x9f4e00b9, 0x00000000}},  //   kkar, síve, čním_,
  { {0xddd500b9, 0x7c2d00f8, 0x6d48004a, 0x00000000}},  //   mozř, jkar, údam,
  { {0x91e50057, 0x442d074c, 0x7c2d0036, 0x00000000}},  //   _боле, mke_, dkar,
  { {0xdd920426, 0xf7760049, 0x6449074d, 0x00000000}},  //   صور_, טערי_, liei,
  { {0x7c36074e, 0x09b20055, 0xed570269, 0x00000000}},  //   thyr, _চালা, гор_,
  { {0xaca9026c, 0x7c2d006a, 0x09cc0061, 0x00000000}},  //   کھیے_, gkar, ाल्य,
  { {0x9b930054, 0x442d046a, 0xed1700a1, 0x00000000}},  // [8e0] إلكت, ike_, نہیں_,
  { {0xe9d701f9, 0x3b830099, 0x442d006c, 0x00000000}},  //   лку_, слуг, hke_,
  { {0x442d0374, 0x7c2d006b, 0x8c460478, 0x00000000}},  //   kke_, bkar, _бене,
  { {0x442d02ae, 0x7c2d0039, 0xdbd701a2, 0x00000000}},  //   jke_, ckar, mäßi,
  { {0x442d074f, 0xd707007c, 0x64490750, 0x00000000}},  //   dke_, лнце_, diei,
  { {0x442d0100, 0x9f5b0023, 0x7af6005b, 0x00000000}},  //   eke_, _saqë_, mwyt,
  { {0x64490016, 0x7af60016, 0x04660751, 0x00000000}},  //   fiei, lwyt, лтим,
  { {0x25f0013d, 0x4d7b0049, 0xd467003b, 0x00000000}},  //   _इसकी_, ערקע, лије_,
  { {0xa6ca0167, 0xd5d60752, 0x386601d6, 0x00000000}},  //   _سوال_, _متاث, moor_,
  { {0xd6cf0647, 0xe29f009f, 0x7c2d022b, 0x00000000}},  //   _رقم_, íða_, zkar,
  { {0xf5930054, 0x055603f6, 0xa158003b, 0x00000000}},  //   _المج, _стая, тану_,
  { {0x442d001f, 0x764a01aa, 0x5577007b, 0x00000000}},  //   cke_, lify, _געבן_,
  { {0x09cc0055, 0x80c0006e, 0x6d5a009d, 0x00000000}},  //   র্যা, _विके, ûtan,
  { {0x38660007, 0x764a0753, 0xb80b013d, 0x00000000}},  //   hoor_, nify, _सोनम_,
  { {0x16d10754, 0x7c2d0089, 0x38660755, 0x00000000}},  //   _सम्ब, tkar, koor_,
  { {0x09cc0055, 0x386601d6, 0xd175007e, 0x00000000}},  //   র্মা, joor_, _тычы,
  { {0x7c2d0127, 0x386600ab, 0xead50451, 0x00000000}},  // [8f0] rkar, door_, розь,
  { {0x7c2d0756, 0x442d0757, 0xdfd100a1, 0x00000000}},  //   skar, zke_, _ايک_,
  { {0x764a0758, 0x442d0007, 0x09cc0044, 0x00000000}},  //   dify, yke_, র্ভা,
  { {0x386601d6, 0x00000000, 0x00000000, 0x00000000}},  //   goor_,   ,   ,
  { {0x442d0209, 0x644900c4, 0x6f1b01a2, 0x00000000}},  //   vke_, viei, äuch,
  { {0x80aa0055, 0x09cc0055, 0x19940088, 0x00000000}},  //   _কিন্, র্বা, _гаря,
  { {0x442d0759, 0x8459005e, 0x6449032e, 0x00000000}},  //   tke_, крит_, tiei,
  { {0x442d075a, 0x6a6b010f, 0x91fc0089, 0x00000000}},  //   uke_, rüfu, klās,
  { {0xe80b013d, 0x64490145, 0x7cec075b, 0x00000000}},  //   _सोया_, riei, _körö,
  { {0x442d0374, 0xc245004d, 0x27ff0052, 0x00000000}},  //   ske_, рнок, _haun_,
  { {0xc3230055, 0x7878008e, 0x442d016e, 0x00000000}},  //   _বেশি_, líva, pke_,
  { {0xdb0f0181, 0x27ff075c, 0x00000000, 0x00000000}},  //   _mecâ, _jaun_,   ,
  { {0x92b70054, 0x02a7003b, 0x63bb075d, 0x00000000}},  //   _إحصا, _срем, maun,
  { {0x63bb075e, 0xed5a012b, 0x27ff000c, 0x00000000}},  //   laun, вог_, _laun_,
  { {0xdb0f0211, 0x629b06b9, 0x6142075f, 0x00000000}},  //   _decí, lquo, _меша,
  { {0x63bb00e0, 0x229b01c3, 0x27ff0288, 0x00000000}},  //   naun, _kêk_, _naun_,
  { {0x4a46008b, 0x386600b5, 0xa3e70164, 0x00000000}},  // [900] анав, voor_, म्य_,
  { {0x7af60016, 0x787801dc, 0x20000145, 0x00000000}},  //   rwyt, díva, _haii_,
  { {0x41dd007d, 0x63bb0760, 0xf1dd006e, 0x00000000}},  //   _मानस, kaun, _मानन,
  { {0xdb0f001a, 0x63bb001e, 0x20020036, 0x00000000}},  //   _decâ, jaun, ndki_,
  { {0x38660343, 0x764a01aa, 0x27ff04cb, 0x00000000}},  //   roor_, tify, _daun_,
  { {0x7cec0010, 0xb8dc0044, 0x00000000, 0x00000000}},  //   _görö, _আম_,   ,
  { {0x01bb0055, 0x764a0761, 0x38660168, 0x00000000}},  //   ংলাদ, rify, poor_,
  { {0x27ff0762, 0x63bb0006, 0x764a0173, 0x00000000}},  //   _gaun_, gaun, sify,
  { {0x46a30264, 0x07a3030d, 0x00000000, 0x00000000}},  //   _матв, _фаун,   ,
  { {0x27e6000a, 0x201200e7, 0x00000000, 0x00000000}},  //   lfon_, _anyi_,   ,
  { {0x7bc60763, 0xdb0f06f4, 0x20120145, 0x00000000}},  //   _odku, _recí, _bnyi_,
  { {0x78a10010, 0x63bb00ea, 0x27e60016, 0x00000000}},  //   _élve, caun, nfon_,
  { {0x200500b9, 0x629b0068, 0x44f80082, 0x00000000}},  //   ěli_, cquo, _hũ_,
  { {0x20050046, 0x20120020, 0x290a05ae, 0x00000000}},  //   śli_, _enyi_, _orba_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x8f470764, 0x7055007a, 0x44f80011, 0x00000000}},  //   _вход, _دنبا, _mũ_,
  { {0x290a010a, 0x207c0049, 0x27ff000c, 0x00000000}},  // [910] _arba_, _באהא, _raun_,
  { {0x39a7007e, 0x24840058, 0x27ff010e, 0x00000000}},  //   ршав, hmmm_, _saun_,
  { {0x69dd0061, 0x7cec0010, 0x69dc0009, 0x00000000}},  //   _पाठी, _vörö, _dcre,
  { {0xdd1c00b9, 0x629b0068, 0x78780765, 0x00000000}},  //   _nářa, yquo, tíva,
  { {0x290a0766, 0x8c1a00b6, 0x7cec0010, 0x00000000}},  //   _erba_, _עושי, _törö,
  { {0x63a20767, 0x7afd0768, 0x63bb00e7, 0x00000000}},  //   _afon, _isst, waun,
  { {0x44f8001d, 0x27ff0085, 0x63bb00e7, 0x00000000}},  //   _cũ_, _taun_, taun,
  { {0xed58012e, 0x80c00309, 0x6d480051, 0x00000000}},  //   יבור_, _विजे, údai,
  { {0x63bb002d, 0x386d002d, 0x86980769, 0x00000000}},  //   raun, _iker_, _вкус_,
  { {0xe4e701fb, 0x629b028c, 0xdb0f0129, 0x00000000}},  //   _відн, rquo, _mecà,
  { {0x92d70055, 0x63a20016, 0x63bb011c, 0x00000000}},  //   াবে_, _ffon, paun,
  { {0x6601014a, 0x44e1076a, 0xc95200b3, 0x00000000}},  //   _halk, mó_, למי_,
  { {0x69c70209, 0x44e10047, 0x539a009b, 0x00000000}},  //   _odje, ló_, _עיסו,
  { {0x69c7008d, 0x6da30200, 0x660100b0, 0x00000000}},  //   _ndje, зира, _jalk,
  { {0x44e1076b, 0x7afd00e0, 0x386d002d, 0x00000000}},  //   nó_, _asst, _oker_,
  { {0x69dc0038, 0x69c7076c, 0xdb0a00b9, 0x00000000}},  //   _scre, _adje, šníh,
  { {0x290a05fa, 0x63b9018e, 0x7afd0009, 0x00000000}},  // [920] _srba_, _mewn, _csst,
  { {0xbf9b0181, 0x69dd0061, 0x386d00ea, 0x00000000}},  //   ndên, _पाणी, _aker_,
  { {0x31ba007b, 0x93f9001c, 0x78a70061, 0x00000000}},  //   רזענ, ्याच_, _ctjv,
  { {0x387f002a, 0x44e1076d, 0xe73a0057, 0x00000000}},  //   _chur_, dó_, лее_,
  { {0x27e6076e, 0x00000000, 0x00000000, 0x00000000}},  //   rfon_,   ,   ,
  { {0x63a20207, 0xceb300a3, 0x660100b4, 0x00000000}},  //   _sfon, ליד_, _calk,
  { {0x44e1076f, 0x96c4013d, 0x7c260023, 0x00000000}},  //   gó_, _रिकॉ, _kokr,
  { {0x44f8001d, 0x69c70770, 0x62990022, 0x00000000}},  //   _vũ_, _zdje, _buwo,
  { {0x8c1b00b6, 0x66010039, 0x3266005e, 0x00000000}},  //   רופי, _falk, йтов,
  { {0x41dd001c, 0x44e10771, 0x11d80025, 0x00000000}},  //   _माणस, bó_, جودة_,
  { {0x04960054, 0x44e10211, 0xdb0f0211, 0x00000000}},  //   _الصح, có_, _mecá,
  { {0x6e25011f, 0x7ae40772, 0x7c260773, 0x00000000}},  //   _sohb, ktit, _nokr,
  { {0x447b007b, 0x00000000, 0x00000000, 0x00000000}},  //   _ענדע,   ,   ,
  { {0x63b90036, 0x4426010e, 0xbc9500ed, 0x00000000}},  //   _zewn, _hoo_, жавј,
  { {0x90a60774, 0x442600e7, 0x7c2606d4, 0x00000000}},  //   _احتم, _koo_, _bokr,
  { {0x442600b0, 0x62990093, 0x7c260022, 0x00000000}},  //   _joo_, _yuwo, _cokr,
  { {0x2fc90775, 0x44e10776, 0x7ae4006a, 0x00000000}},  // [930] _idag_, zó_, gtit,
  { {0x386d0193, 0x98b8005d, 0x4426006c, 0x00000000}},  //   _sker_, _ayrı_, _loo_,
  { {0xda7801e0, 0x7ae40026, 0xdb0f004a, 0x00000000}},  //   сят_, atit, _decá,
  { {0x6f0d00b5, 0x4426011c, 0x44e10211, 0x00000000}},  //   _krac, _noo_, vó_,
  { {0x66010777, 0xe610025a, 0xd3660076, 0x00000000}},  //   _palk, کشن_, _آه_,
  { {0x44e10047, 0xd12605f3, 0x34a9003b, 0x00000000}},  //   tó_, _قم_, авко_,
  { {0x63b90046, 0x66010778, 0xe3b10054, 0x00000000}},  //   _pewn, _valk, ورة_,
  { {0x44e10779, 0x6601077a, 0x42c90140, 0x00000000}},  //   ró_, _walk, агин_,
  { {0xe816001c, 0x44e1076f, 0x660100ab, 0x00000000}},  //   णारा_, só_, _talk,
  { {0x63b90036, 0x44e1077b, 0x60e90437, 0x00000000}},  //   _wewn, pó_, амом_,
  { {0x6f0d077c, 0x3ea9000d, 0x7a3b009d, 0x00000000}},  //   _arac, _atat_, _gîte,
  { {0xa06a0113, 0x4426077d, 0x68e50016, 0x00000000}},  //   рама_, _goo_, ithd,
  { {0x44c5001e, 0x644b077e, 0x7ae40009, 0x00000000}},  //   lē_, _imgi, xtit,
  { {0x6f0d077f, 0x7ae4001c, 0x00000000, 0x00000000}},  //   _drac, vtit,   ,
  { {0x8c010055, 0x27ed001f, 0x3ea900f4, 0x00000000}},  //   _একজন_, _oben_, _etat_,
  { {0x6a70001f, 0xeb97007c, 0x5baa0780, 0x00000000}},  //   häft, жит_, ркам_,
  { {0x3b07026b, 0x6f0d0781, 0x3a26005e, 0x00000000}},  // [940] оето_, _grac, омаг,
  { {0x27ed0146, 0x32050133, 0x2b4000e5, 0x00000000}},  //   _aben_, ndly_, rzic_,
  { {0x7ae40782, 0x6f0d0107, 0xe8160061, 0x00000000}},  //   stit, _zrac, णाला_,
  { {0xdb2400a1, 0xb6c800a1, 0x7ae40048, 0x00000000}},  //   _فوجی, ماتے_, ptit,
  { {0x4426008e, 0xafdb00ea, 0x290702e1, 0x00000000}},  //   _roo_, shøg, ånar_,
  { {0x27ed010f, 0x3af90049, 0xe4a600ed, 0x00000000}},  //   _eben_, _פּרע, орио,
  { {0xd4970783, 0x44260784, 0xd0b1006b, 0x00000000}},  //   оры_, _poo_, _təəs,
  { {0x68e300d4, 0x00000000, 0x00000000, 0x00000000}},  //   ànde,   ,   ,
  { {0x442600c4, 0x69da01df, 0x00000000, 0x00000000}},  //   _voo_, _ötes,   ,
  { {0x81d20055, 0x44260785, 0x6f0d0023, 0x00000000}},  //   হ্ন_, _woo_, _rrac,
  { {0x4a7b007b, 0x44260038, 0xd257007e, 0x00000000}},  //   שריב, _too_, ўцы_,
  { {0x6f0d0395, 0x4034007c, 0x32050133, 0x00000000}},  //   _prac, деюс, adly_,
  { {0x2fc901c3, 0x3d950745, 0x00000000, 0x00000000}},  //   _vdag_, зигр,   ,
  { {0xdef8008b, 0x00000000, 0x00000000, 0x00000000}},  //   цыю_,   ,   ,
  { {0x6ce40088, 0x6f0d0036, 0xbc4b007e, 0x00000000}},  //   міте, _wrac, ачае_,
  { {0x2611006e, 0xafdb0737, 0x69dd0061, 0x00000000}},  //   _धोनी_, riøs, _पाही,
  { {0x6f0d016c, 0x5a350786, 0x97ea005a, 0x00000000}},  // [950] _urac, пнат, ışlı,
  { {0xceb20097, 0x78a30010, 0xd042013f, 0x00000000}},  //   _ריי_, ínvo, drlə,
  { {0x6aad0026, 0x00000000, 0x00000000, 0x00000000}},  //   spaf,   ,   ,
  { {0xdb1f0065, 0x68e50787, 0xa802014a, 0x00000000}},  //   naqë, rthd, _çılg,
  { {0x8c1a009b, 0x00000000, 0x00000000, 0x00000000}},  //   _הורי,   ,   ,
  { {0x3866016c, 0x59e201f5, 0x44c50089, 0x00000000}},  //   čora_, _पायर, tē_,
  { {0x6a700788, 0xafdb00ea, 0x7af9026d, 0x00000000}},  //   räft, snøy, şatı,
  { {0x44390789, 0x57f4025f, 0x44c50089, 0x00000000}},  //   ós_, _опст, rē_,
  { {0xf7490054, 0x051b0044, 0x44c50089, 0x00000000}},  //   _الذي_, তনের_, sē_,
  { {0x3637007a, 0xc2420259, 0xd5b10082, 0x00000000}},  //   _بررس, еньк, _góp_,
  { {0x32050133, 0xdb1d0190, 0x86220167, 0x00000000}},  //   rdly_, _udsæ, _سکول,
  { {0x29360049, 0x3e76000c, 0x00000000, 0x00000000}},  //   פארן_, mæti_,   ,
  { {0x20040027, 0x3e76000c, 0x00000000, 0x00000000}},  //   ľmi_, læti_,   ,
  { {0x443f001c, 0x3d080061, 0x614501ee, 0x00000000}},  //   lhu_, हिले_, _нела,
  { {0xc692009b, 0x91ba009b, 0xed52025a, 0x00000000}},  //   תאם_, _המצי, رپر_,
  { {0x443f078a, 0x645b078b, 0x00000000, 0x00000000}},  //   nhu_, nnui,   ,
  { {0x6b63007e, 0x00000000, 0x00000000, 0x00000000}},  // [960] екта,   ,   ,
  { {0x443f0066, 0xd042006b, 0x499a0783, 0x00000000}},  //   hhu_, vrlə, стая_,
  { {0x290e000c, 0xd88a00a1, 0xa96a0025, 0x00000000}},  //   ífa_, مپئن_, حمام_,
  { {0xfc320054, 0xdb0400b5, 0x7a32000c, 0x00000000}},  //   _أحد_, ncië, _mæti,
  { {0xfbd300b6, 0xf3f9001a, 0x00000000, 0x00000000}},  //   _אתר_, deţ_,   ,
  { {0xe8df001d, 0xdb0f00c4, 0x4b7b009b, 0x00000000}},  //   _giữa_, _secç, _לאכו,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x443f01d5, 0xb3c6013d, 0xe73a00ed, 0x00000000}},  //   ghu_, रृंख, _леб_,
  { {0xdb060010, 0x00000000, 0x00000000, 0x00000000}},  //   _nekü,   ,   ,
  { {0x443f0022, 0x69de0145, 0x7a32000c, 0x00000000}},  //   ahu_, ngpe, _bæti,
  { {0x443f0066, 0x26190309, 0xf1dd013d, 0x00000000}},  //   bhu_, पारी_, _मारन,
  { {0x443f078c, 0xc48603c8, 0x395700b6, 0x00000000}},  //   chu_, _элек, לשים_,
  { {0xee87007c, 0x26c6010e, 0x00000000, 0x00000000}},  //   зыво, nsoo_,   ,
  { {0xd2500084, 0x6ca7078d, 0x9f590023, 0x00000000}},  //   _جنت_, зраж, lesë_,
  { {0xa157078e, 0x61fa0148, 0xe9ff0011, 0x00000000}},  //   _нашу_, metl, _ngạc_,
  { {0x61fa06cf, 0x31c600b9, 0x415b034e, 0x00000000}},  //   letl, bízí_, _לדוג,
  { {0xa3df0204, 0xdb0400f4, 0x8f9c00a0, 0x00000000}},  // [970] _तास_, nciè, _פיזי,
  { {0x61fa078f, 0x443f0790, 0x7c2400e7, 0x00000000}},  //   netl, zhu_, ajir,
  { {0x7c38004a, 0x64400022, 0x00000000, 0x00000000}},  //   ñará, khmi,   ,
  { {0xf7700014, 0x9f590023, 0x61fa0479, 0x00000000}},  //   گام_, jesë_, hetl,
  { {0x61fa011f, 0x64400051, 0x2619007d, 0x00000000}},  //   ketl, dhmi, पाली_,
  { {0xf770031d, 0x61fa0182, 0xf3f90035, 0x00000000}},  //   دام_, jetl, inţe_,
  { {0x443f0791, 0x61fa0792, 0x00000000, 0x00000000}},  //   thu_, detl,   ,
  { {0xc952009b, 0xdb1d0065, 0x52a90793, 0x00000000}},  //   _סמן_, _nesë, овим_,
  { {0x1306007c, 0x443f016e, 0x61fa014a, 0x00000000}},  //   дный_, rhu_, fetl,
  { {0x443f0089, 0x645b001a, 0x10a50794, 0x00000000}},  //   shu_, snui, мион,
  { {0x3de30055, 0x443f0082, 0xdb1d0023, 0x00000000}},  //   য়াল, phu_, _besë,
  { {0xcdc900b6, 0x644003de, 0x78a90059, 0x00000000}},  //   _כך_, chmi, _čevl,
  { {0xdb060263, 0x09d50044, 0x437401fc, 0x00000000}},  //   _lekò, স্যা, _пушт,
  { {0x291100e5, 0x00000000, 0x00000000, 0x00000000}},  //   _orza_,   ,   ,
  { {0x1d07005e, 0x6da302ea, 0x64850051, 0x00000000}},  //   мери_, тиса, róif,
  { {0x6e21000c, 0xdb1d01c3, 0x00000000, 0x00000000}},  //   ölbr, _gesë,   ,
  { {0x29030795, 0xfaff0089, 0x7c360796, 0x00000000}},  // [980] _asja_, šīnu_, rkyr,
  { {0x7c360006, 0x64850051, 0xdb04009d, 0x00000000}},  //   skyr, lóid, ncié,
  { {0x32070038, 0xd00f04e1, 0xeb9a0797, 0x00000000}},  //   _many_, _صلی_, _мин_,
  { {0x9f5901aa, 0x61fa0798, 0x32070799, 0x00000000}},  //   fesè_, zetl, _lany_,
  { {0x61fa079a, 0x46a3007e, 0x96fa0257, 0x00000000}},  //   yetl, вачв, تعار_,
  { {0x6f040020, 0x443d0016, 0x7bc402a6, 0x00000000}},  //   _msic, _alw_, laiu,
  { {0x5e57007b, 0x64400020, 0xe0c70014, 0x00000000}},  //   ויסע_, thmi, _جز_,
  { {0x7bc4079b, 0x672d0023, 0x61fa01d6, 0x00000000}},  //   naiu, ënjë, wetl,
  { {0x3ea000f4, 0x68e10039, 0x61fa079c, 0x00000000}},  //   _nuit_, _äldr, tetl,
  { {0x64400065, 0x2fc000f6, 0x443d079d, 0x00000000}},  //   shmi, _aeig_, _elw_,
  { {0x61fa079e, 0x443d00c4, 0xdb1d0023, 0x00000000}},  //   retl, _flw_, _pesë,
  { {0x68e10039, 0xf993009b, 0x3ea0079f, 0x00000000}},  //   _ålde, כרת_, _buit_,
  { {0x61fa07a0, 0x3ea001a3, 0xdb0d006b, 0x00000000}},  //   petl, _cuit_, çkün,
  { {0x3ea007a1, 0x3207000a, 0x00000000, 0x00000000}},  //   _duit_, _gany_,   ,
  { {0xd30800ad, 0x6e940077, 0x66080190, 0x00000000}},  //   _hệ_, тиру, _madk,
  { {0xdb0601aa, 0xd3080011, 0x3ea0009d, 0x00000000}},  //   _rekò, _kệ_, _fuit_,
  { {0x661a00c7, 0x7a32000c, 0xae0c006e, 0x00000000}},  // [990] _ontk, _lætu, िएशन_,
  { {0x2009054c, 0xdb06000a, 0x00000000, 0x00000000}},  //   _haai_, _pekò,   ,
  { {0xd308001d, 0xdb1d0010, 0x7a32000c, 0x00000000}},  //   _lệ_, _mesé, _nætu,
  { {0xa2cf02fb, 0xec35007b, 0x3157007b, 0x00000000}},  //   _दिल्, _נאָר_, ויבן_,
  { {0x660807a2, 0x200901d6, 0x00000000, 0x00000000}},  //   _badk, _maai_,   ,
  { {0x6298016c, 0x20090007, 0xdb1d01aa, 0x00000000}},  //   _nivo, _laai_, _resè,
  { {0x6d4701d5, 0x9f5901aa, 0x69c501c5, 0x00000000}},  //   nzja, sesè_, mahe,
  { {0xcd98019b, 0x13050098, 0x20090007, 0x00000000}},  //   ודות_, езим, _naai_,
  { {0x320700f6, 0x2fc000d4, 0x443d00c4, 0x00000000}},  //   _pany_, _reig_, _vlw_,
  { {0x660807a3, 0x69c507a4, 0x2486012d, 0x00000000}},  //   _gadk, nahe, _ehom_,
  { {0x09d50055, 0x200907a5, 0x3ea00549, 0x00000000}},  //   স্থা, _baai_, _suit_,
  { {0x7a32009f, 0xf99200a0, 0x78780161, 0x00000000}},  //   _hætt, טרי_, tívi,
  { {0x20090343, 0x63a907a6, 0x648507a7, 0x00000000}},  //   _daai_, mcen, róid,
  { {0x09d50055, 0x63a900bb, 0x3ea00129, 0x00000000}},  //   স্তা, lcen, _vuit_,
  { {0x75f30279, 0x7a3207a8, 0x69c50023, 0x00000000}},  //   mızı, _mætt, dahe,
  { {0x6298016c, 0x98a700b9, 0x3ea007a9, 0x00000000}},  //   _zivo, šně_, _tuit_,
  { {0x1e96013b, 0xfc3f002a, 0xab66003b, 0x00000000}},  // [9a0] _прор, _dlí_, хвал,
  { {0x19b9008b, 0x69c5006c, 0x75f3005a, 0x00000000}},  //   дуць_, gahe, nızı,
  { {0xa3df024c, 0x66080062, 0xba3b07aa, 0x00000000}},  //   तला_, _radk, _suïc,
  { {0xc18c0049, 0xe78607ab, 0x63a907ac, 0x00000000}},  //   קטאָ, нуло, jcen,
  { {0xe7370121, 0x66080007, 0x69c50023, 0x00000000}},  //   нец_, _padk, bahe,
  { {0x63a907ad, 0x69ce0030, 0x69c50082, 0x00000000}},  //   ecen, _udbe, cahe,
  { {0x62980207, 0x00000000, 0x00000000, 0x00000000}},  //   _rivo,   ,   ,
  { {0x63a90190, 0x629801ed, 0x00000000, 0x00000000}},  //   gcen, _sivo,   ,
  { {0xa01b000c, 0x20090007, 0x8857009b, 0x00000000}},  //   llög, _raai_, _נשמע_,
  { {0xd308001d, 0x63a907ae, 0x200900c7, 0x00000000}},  //   _vệ_, acen, _saai_,
  { {0x248607af, 0x63a90030, 0x62980555, 0x00000000}},  //   _thom_, bcen, _vivo,
  { {0xd3080011, 0x44cc00b9, 0x63a90197, 0x00000000}},  //   _tệ_, mě_, ccen,
  { {0x629807b0, 0x69c507b1, 0x00000000, 0x00000000}},  //   _tivo, yahe,   ,
  { {0x614600f4, 0x20090007, 0xfc3f0051, 0x00000000}},  //   _célé, _waai_, _slí_,
  { {0x69c50004, 0x44cc00b9, 0x225901aa, 0x00000000}},  //   vahe, ně_, èske_,
  { {0x9f52008e, 0x657a028a, 0xb7bd0035, 0x00000000}},  //   _cayó_, _myth, _toţi,
  { {0x69c5006c, 0x657a0016, 0x3e76000c, 0x00000000}},  // [9b0] tahe, _lyth, tætt_,
  { {0xbbeb007a, 0xddc701a8, 0xf3f90035, 0x00000000}},  //   _کردم_, bojš, inţa_,
  { {0xe61f001d, 0x63a9013e, 0x69c507b2, 0x00000000}},  //   _đô_, ycen, rahe,
  { {0x7a3207b3, 0x44cc0224, 0x69c507b4, 0x00000000}},  //   _sætt, dě_, sahe,
  { {0xd90f009c, 0xab8402dc, 0x76430022, 0x00000000}},  //   _گیا_, _бурк, thny,
  { {0x7aed0047, 0x657a07b5, 0x649501ca, 0x00000000}},  //   mtat, _byth, _všim,
  { {0xd90f009c, 0x657a005b, 0xf3f90035, 0x00000000}},  //   _دیا_, _cyth, enţa_,
  { {0x6d5807b6, 0x7aed0197, 0x756800a1, 0x00000000}},  //   _žvak, otat, رینہ_,
  { {0x7aed0198, 0x63a907b7, 0x4864005e, 0x00000000}},  //   ntat, rcen, _сърб,
  { {0x7aed00f4, 0x25ac07b8, 0x248d013e, 0x00000000}},  //   itat, _gfdl_, smem_,
  { {0x7aed0065, 0xe8160061, 0x63a900f8, 0x00000000}},  //   htat, णाचा_, pcen,
  { {0x7c2f07b9, 0x6146009d, 0x321c0133, 0x00000000}},  //   _nocr, _sélé, _envy_,
  { {0xe28e008b, 0x09cc0044, 0x00000000, 0x00000000}},  //   _ва_, র্টা,   ,
  { {0xc0a8007a, 0x7aed07ba, 0x82d600a3, 0x00000000}},  //   بایل_, dtat, _יונג_,
  { {0x1fb607bb, 0x442f037e, 0x7aed04f8, 0x00000000}},  //   _испр, _kog_, etat,
  { {0x442f07bc, 0xe8df0011, 0xbc63003b, 0x00000000}},  //   _jog_, _nhựa_, авск,
  { {0x6146028c, 0x7aed07bd, 0x442f0091, 0x00000000}},  // [9c0] _télé, gtat, _mog_,
  { {0x4a43072b, 0xa01b0039, 0x00000000, 0x00000000}},  //   анув, smöt,   ,
  { {0x2dd9007b, 0x442f00c7, 0x4dd90049, 0x00000000}},  //   _אַרב, _oog_, _אַרױ,
  { {0x44cc0224, 0x76410016, 0x657a00f4, 0x00000000}},  //   vě_, _ally, _ryth,
  { {0x7aed000d, 0xa3e80204, 0x6495012d, 0x00000000}},  //   ctat, _बाब_, _iših,
  { {0x657a07be, 0x09cc0055, 0x44cc00b9, 0x00000000}},  //   _pyth, র্জা, tě_,
  { {0x442f0146, 0xe9760014, 0x7f4a006b, 0x00000000}},  //   _bog_, _شهرد, _əfqa,
  { {0x442f0719, 0x6f1600f6, 0x76410145, 0x00000000}},  //   _cog_, _oryc, _elly,
  { {0x657a018e, 0x442f07bf, 0x65c60264, 0x00000000}},  //   _wyth, _dog_, _абза,
  { {0x44cc00b9, 0x442f07c0, 0xb3550014, 0x00000000}},  //   pě_, _eog_, دیها_,
  { {0x7aed07c1, 0x442f0010, 0xd3e40014, 0x00000000}},  //   ztat, _fog_, _مقای,
  { {0x320a004f, 0x7658000b, 0xe537007b, 0x00000000}},  //   žby_, livy, _שטאט_,
  { {0x644200b0, 0xdb0d07c2, 0xdd3b0035, 0x00000000}},  //   _iloi, mbaç, _băşt,
  { {0x7c2f002a, 0x6f1607c3, 0x539b00a0, 0x00000000}},  //   _socr, _dryc, _חידו,
  { {0x442f0022, 0xe29b009b, 0x2d8507c4, 0x00000000}},  //   _yog_, _קשור, åle_,
  { {0x7aed07c5, 0x3d08001c, 0x09cb0061, 0x00000000}},  //   ttat, हिजे_, ाण्य,
  { {0x7aed001a, 0xc4c400a1, 0x4c94007c, 0x00000000}},  // [9d0] utat, _ڈے_, ритс,
  { {0x7aed07c6, 0x201e0089, 0x3eda0049, 0x00000000}},  //   rtat, ētie_, _אַטא,
  { {0x7aed07c7, 0xda7801e0, 0x39a40457, 0x00000000}},  //   stat, тят_, ршув,
  { {0x7aed07c8, 0x00000000, 0x00000000, 0x00000000}},  //   ptat,   ,   ,
  { {0x4421001d, 0x442f001a, 0xdcfe0089, 0x00000000}},  //   _đh_, _rog_, _izpā,
  { {0x69dd001c, 0x6442021e, 0x6d580006, 0x00000000}},  //   _पाटी, _aloi, _žvai,
  { {0x442f0305, 0x644207c9, 0xb7bd001a, 0x00000000}},  //   _pog_, _bloi, _soţu,
  { {0x130907ca, 0x644207cb, 0xe80b013d, 0x00000000}},  //   ений_, _cloi, _सोचा_,
  { {0x628a002a, 0x97ea011f, 0xe5e50014, 0x00000000}},  //   _bhfo, ıştı, _مزای,
  { {0x42250264, 0x00000000, 0x00000000, 0x00000000}},  //   удов,   ,   ,
  { {0x442f07cc, 0xf3f50014, 0xe4e40088, 0x00000000}},  //   _tog_, _متشک, _вічн,
  { {0x644207cd, 0x6f1607ce, 0x00000000, 0x00000000}},  //   _gloi, _pryc,   ,
  { {0xa3e802d2, 0x63bb020c, 0x60da00bb, 0x00000000}},  //   _बात_, mbun, artm,
  { {0xa2d802f4, 0xfce6007c, 0x63bb0039, 0x00000000}},  //   _मित्, лого, lbun,
  { {0xdb1d00b9, 0x00000000, 0x00000000, 0x00000000}},  //   _desí,   ,   ,
  { {0x6e3c07a0, 0x6f1607cf, 0x409507d0, 0x00000000}},  //   skrb, _tryc, _крыт,
  { {0x63bb010f, 0xc053009b, 0x20020145, 0x00000000}},  // [9e0] ibun, _לזה_, meki_,
  { {0x63bb04be, 0x01d50044, 0x00000000, 0x00000000}},  //   hbun, ত্রদ,   ,
  { {0x291e07d1, 0x38cb01b2, 0x9c660014, 0x00000000}},  //   _štab_, فانی_, _مهدو,
  { {0x46a6007e, 0x64950066, 0x200204eb, 0x00000000}},  //   гадв, _eġiz, neki_,
  { {0xa2cf0309, 0x63bb0190, 0x601b00b0, 0x00000000}},  //   _दिग्, dbun, _hämä,
  { {0x7bc60065, 0x64420048, 0x200207d2, 0x00000000}},  //   _heku, _sloi, heki_,
  { {0xa3e802d2, 0x7bc6020c, 0x6442001a, 0x00000000}},  //   _बाद_, _keku, _ploi,
  { {0x765807d3, 0x200207d4, 0x63bb07d5, 0x00000000}},  //   sivy, jeki_, gbun,
  { {0x38550265, 0xc1ea008b, 0x2002014a, 0x00000000}},  //   _търс, ньне_, deki_,
  { {0x7bc6022b, 0x64a60088, 0x27e606d4, 0x00000000}},  //   _leku, _бажа, lgon_,
  { {0xdb1d0181, 0x00000000, 0x00000000, 0x00000000}},  //   _resí,   ,   ,
  { {0x7bc6001e, 0x27e6070d, 0xa3bb0164, 0x00000000}},  //   _neku, ngon_, _अभय_,
  { {0xa857009b, 0x63a207d6, 0x27e60082, 0x00000000}},  //   ריכה_, _igon, igon_,
  { {0x539b00a3, 0xc6940049, 0xdb1d00c4, 0x00000000}},  //   _ניגו, יאָ_, _lesã,
  { {0xf1b300a0, 0x7bc60023, 0x20020032, 0x00000000}},  //   _פסק_, _beku, beki_,
  { {0x2002014a, 0x7bc607d7, 0x00000000, 0x00000000}},  //   ceki_, _ceku,   ,
  { {0x29180047, 0xba5507d8, 0x7bc607d9, 0x00000000}},  // [9f0] _arra_, авај, _deku,
  { {0x63bb0035, 0x2b4b0082, 0x00000000, 0x00000000}},  //   zbun, _đhcđ_,   ,
  { {0x648507da, 0x63bb0036, 0x3eb90089, 0x00000000}},  //   dóin, ybun, lpst_,
  { {0x63a20020, 0x64b10089, 0x7bc601d6, 0x00000000}},  //   _ngon, _jāie, _geku,
  { {0x61f80059, 0x67d407db, 0x291801a3, 0x00000000}},  //   _obvl, сочу, _erra_,
  { {0x7c2d07dc, 0x63a201a3, 0xd00e0044, 0x00000000}},  //   ljar, _agon, ষায়_,
  { {0xce3800b6, 0x7bc6006b, 0x63bb0168, 0x00000000}},  //   ראות_, _yeku, tbun,
  { {0x7c2d07dd, 0xd3f9007e, 0x00000000, 0x00000000}},  //   njar, тэкі_,   ,
  { {0x63bb0109, 0x69c707de, 0xc2450069, 0x00000000}},  //   rbun, _keje, иник,
  { {0xdb040010, 0x63a2022b, 0x69c707df, 0x00000000}},  //   nciá, _egon, _jeje,
  { {0x7c2d07e0, 0x216907e1, 0xafdb0030, 0x00000000}},  //   kjar, тини_, dkøb,
  { {0x660307e2, 0x69c70030, 0x7c2d0066, 0x00000000}},  //   lenk, _leje, jjar,
  { {0x387e028c, 0x7c2d07e3, 0x443f0161, 0x00000000}},  //   _être_, djar, mku_,
  { {0x442d0340, 0x443f07e4, 0x69c70224, 0x00000000}},  //   lje_, lku_, _neje,
  { {0x7afd001e, 0x7c2d07e5, 0x442d0006, 0x00000000}},  //   _apst, fjar, oje_,
  { {0x442d00ee, 0x644907e6, 0x443f07e7, 0x00000000}},  //   nje_, nhei, nku_,
  { {0x69c70047, 0x207b007b, 0x443f07e8, 0x00000000}},  // [a00] _beje, _באקא, iku_,
  { {0xba230364, 0x442d07e9, 0x601b021e, 0x00000000}},  //   одук, hje_, _tämä,
  { {0x7bc6000c, 0x443f0004, 0x64490343, 0x00000000}},  //   _teku, kku_, khei,
  { {0x1ae60057, 0xf0930049, 0x443f0213, 0x00000000}},  //   _комм, ַנג_, jku_,
  { {0x442d07ea, 0x27e60039, 0x443f0395, 0x00000000}},  //   dje_, rgon_, dku_,
  { {0x660307eb, 0x443f001e, 0x442d0036, 0x00000000}},  //   genk, eku_, eje_,
  { {0x44f1001d, 0x7ae400b5, 0x6449002a, 0x00000000}},  //   _cơ_, luit, fhei,
  { {0x64490100, 0x442d008d, 0x62810211, 0x00000000}},  //   ghei, gje_, ello,
  { {0x7ae407ec, 0x2338007c, 0x32660175, 0x00000000}},  //   nuit, уппы_, итов,
  { {0x442d07ed, 0x3866000a, 0x443f0145, 0x00000000}},  //   aje_, lnor_, aku_,
  { {0x850600a2, 0x442d0059, 0x443f0161, 0x00000000}},  //   _خوان, bje_, bku_,
  { {0x442d0046, 0x38660039, 0x6449001f, 0x00000000}},  //   cje_, nnor_, chei,
  { {0x386600e0, 0xfe7f00d4, 0xd3720014, 0x00000000}},  //   inor_, juïc_, _بهش_,
  { {0x7ae4028c, 0x30a602a8, 0x6e95044b, 0x00000000}},  //   duit, _крив, сигу,
  { {0x0ed301f5, 0x7c2d07ee, 0x69c70652, 0x00000000}},  //   _तिकड, tjar, _reje,
  { {0xe51703d7, 0x69c704cb, 0x660307ef, 0x00000000}},  //   थिति_, _seje, zenk,
  { {0x7ae40198, 0xdb0f07f0, 0x66fa0089, 0x00000000}},  // [a10] guit, _recó, nākā,
  { {0x443f07f1, 0x442d07f2, 0x7c2d07f3, 0x00000000}},  //   zku_, zje_, sjar,
  { {0x69c707f4, 0x442d010a, 0x64490007, 0x00000000}},  //   _veje, yje_, yhei,
  { {0x7ae404b4, 0x38660197, 0x3ea904cb, 0x00000000}},  //   buit, gnor_, _kuat_,
  { {0x6603021e, 0x44f1001d, 0x443f0428, 0x00000000}},  //   tenk, _sơ_, vku_,
  { {0xba4500a1, 0x3ea907f5, 0x644900d9, 0x00000000}},  //   _انسٹ, _muat_, whei,
  { {0x442d07f6, 0x64490007, 0x3ea9000d, 0x00000000}},  //   tje_, thei, _luat_,
  { {0x66030036, 0x442d010a, 0x443f07f7, 0x00000000}},  //   senk, uje_, uku_,
  { {0x644907f8, 0x442d07f9, 0xa3e803d7, 0x00000000}},  //   rhei, rje_, _बार_,
  { {0x442d07fa, 0x64490007, 0xa2d8006e, 0x00000000}},  //   sje_, shei, _मिर्,
  { {0x2fc9002a, 0x442d00b5, 0x84670265, 0x00000000}},  //   _beag_, pje_, _къде,
  { {0x3ea9020c, 0x644002a3, 0x442d0065, 0x00000000}},  //   _buat_, ckmi, qje_,
  { {0x14740025, 0x9e660025, 0x6459002b, 0x00000000}},  //   _بالج, ماسن, _imwi,
  { {0x6d4e010f, 0xed5a01ee, 0x7ae40035, 0x00000000}},  //   tzba, гог_, vuit,
  { {0x50b504b6, 0xc212009b, 0x320507fb, 0x00000000}},  //   _услу, _זהו_, mely_,
  { {0xb60301ca, 0x320507fc, 0x2fc901d6, 0x00000000}},  //   _hráč, lely_, _geag_,
  { {0xab270265, 0x9ce80044, 0x7ae400fa, 0x00000000}},  // [a20] бота_, খবেন_, uuit,
  { {0x9d4602e9, 0x27ed0016, 0x78a0006b, 0x00000000}},  //   _геод, _acen_, _simv,
  { {0x7ae400f4, 0xa3e802d2, 0x3979007e, 0x00000000}},  //   suit, _बाल_, асцю_,
  { {0x320507fd, 0x20120173, 0x317a0049, 0x00000000}},  //   hely_, _jayi_, ארעמ,
  { {0x386607fe, 0x7ae400d6, 0x78bb037e, 0x00000000}},  //   rnor_, quit, _čuve,
  { {0xdb1d0030, 0x38660146, 0x27ed0023, 0x00000000}},  //   _besæ, snor_, _ecen_,
  { {0x78a00011, 0x320507ff, 0x64590026, 0x00000000}},  //   _timv, dely_, _bmwi,
  { {0xe8e0001d, 0xa2b400ed, 0x66fa0089, 0x00000000}},  //   _chụp_, обич, tākā,
  { {0x6440000c, 0x661100b0, 0x68fb016c, 0x00000000}},  //   rkmi, ökkä, _ćudi,
  { {0x64400004, 0xc50a031d, 0x66fa0089, 0x00000000}},  //   skmi, _متصل_, rākā,
  { {0x531601ef, 0x20120800, 0x09d50044, 0x00000000}},  //   _گذار, _bayi_, স্কা,
  { {0xa2e6007e, 0x6f0d0801, 0xfe7f00d4, 0x00000000}},  //   _годд, _psac, duïa_,
  { {0x32050802, 0x7e7e0022, 0x3ea902d4, 0x00000000}},  //   bely_, _bkpp, _quat_,
  { {0x6d14007d, 0x32050133, 0x00000000, 0x00000000}},  //   डिंग_, cely_,   ,
  { {0x403501bd, 0x463b0049, 0x00000000, 0x00000000}},  //   _мекс, נעלע,   ,
  { {0x0ca800d7, 0x225e0803, 0x3ea90023, 0x00000000}},  //   стри_, litk_, _tuat_,
  { {0x5a35005e, 0x6a35012b, 0x7e7e0022, 0x00000000}},  // [a30] онат, онађ, _fkpp,
  { {0x27ed0804, 0x6aad0065, 0xfe7f00f6, 0x00000000}},  //   _scen_, rqaf, buïa_,
  { {0xa3e8007d, 0x00000000, 0x00000000, 0x00000000}},  //   बला_,   ,   ,
  { {0xac190805, 0xb90101f5, 0xc0b20082, 0x00000000}},  //   _тому_, _दि_, _sưởi_,
  { {0xd6db0216, 0x1dbf0164, 0xb06600b0, 0x00000000}},  //   уте_, ्रपत, ltää,
  { {0xf7700070, 0x1a94007e, 0x00000000, 0x00000000}},  //   ران_, _наяў,   ,
  { {0x32050038, 0x91fc001e, 0xb06600b0, 0x00000000}},  //   vely_, rnāl, ntää,
  { {0x3205005b, 0x00000000, 0x00000000, 0x00000000}},  //   wely_,   ,   ,
  { {0x32050038, 0x52a60147, 0xe7330318, 0x00000000}},  //   tely_, овым_, _عصر_,
  { {0xe4e70088, 0x2012019a, 0x00000000, 0x00000000}},  //   _гідн, _sayi_,   ,
  { {0x69d802d5, 0x386d01d9, 0xe3b30318, 0x00000000}},  //   óvei, _kjer_, _فرش_,
  { {0xdb1d021e, 0x64590806, 0x60dc0092, 0x00000000}},  //   _kesä, _umwi, árma,
  { {0x6e370807, 0x2d850808, 0x32050161, 0x00000000}},  //   _boxb, ülen_, pely_,
  { {0x76430809, 0xdca600ed, 0xdef8002b, 0x00000000}},  //   nkny, жави, ċċ_,
  { {0xdfd2026c, 0x6da3017a, 0x2d8c080a, 0x00000000}},  //   _ہيں_, дира, åde_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xd042005f, 0xe7ff013d, 0xa09b01ce, 0x00000000}},  // [a40] xslə, ोजना_, _דיקט,
  { {0x5e570025, 0x386d080b, 0x25fb006e, 0x00000000}},  //   _وليس_, _ajer_, ल्मी_,
  { {0x7e7c0133, 0xe7aa0745, 0x00000000, 0x00000000}},  //   morp, авел_,   ,
  { {0x7e7c0146, 0xdb1d04ce, 0x7786080c, 0x00000000}},  //   lorp, _besä, олез,
  { {0x7c260066, 0x00000000, 0x00000000, 0x00000000}},  //   _inkr,   ,   ,
  { {0x9633007e, 0x386d0030, 0xc4da003b, 0x00000000}},  //   мніц, _ejer_, ађи_,
  { {0x8675008b, 0x344a080d, 0xdb07000c, 0x00000000}},  //   чыцц, ичин_, élög,
  { {0x386d080e, 0x9cd7009b, 0x7e7c021b, 0x00000000}},  //   _gjer_, קופה_, horp,
  { {0x1666005e, 0x213e0016, 0x7e7c0056, 0x00000000}},  //   _двам, wyth_, korp,
  { {0x7af6010a, 0x76430093, 0xb06600b0, 0x00000000}},  //   ityt, ckny, ytää,
  { {0x7e7c0168, 0x7c26080f, 0x00000000, 0x00000000}},  //   dorp, _onkr,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x09d50055, 0x289b0049, 0x7e7c0810, 0x00000000}},  //   স্টা, ייטא, forp,
  { {0x3f85001e, 0x7c260066, 0xb06600b0, 0x00000000}},  //   ālu_, _ankr, ttää,
  { {0x442602c2, 0x25b9006b, 0x91bb009b, 0x00000000}},  //   _kno_, _əsl_, _דמוי,
  { {0x1bbb0025, 0x00000000, 0x00000000, 0x00000000}},  //   شارع_,   ,   ,
  { {0xe8df0011, 0x44260020, 0xb06600b0, 0x00000000}},  // [a50] _thừa_, _mno_, stää,
  { {0x09e30055, 0x7c2601d9, 0x387f0066, 0x00000000}},  //   ন্না, _enkr, _skur_,
  { {0x3a3800c7, 0x999100b9, 0x00000000, 0x00000000}},  //   _dorp_, _vozů_,   ,
  { {0x442600d2, 0x3835007e, 0xdb1d00b0, 0x00000000}},  //   _nno_, янер, _pesä,
  { {0x2b520036, 0xab8402ea, 0x58bb00a1, 0x00000000}},  //   czyc_, _журк, _چارج_,
  { {0x44260811, 0xd1260025, 0xdb1601aa, 0x00000000}},  //   _ano_, _كم_, payò,
  { {0x04450812, 0x386d0023, 0x44260232, 0x00000000}},  //   зейн, _tjer_, _bno_,
  { {0x387f0169, 0x44f300c4, 0x290300ca, 0x00000000}},  //   _ukur_, rã_, _ipja_,
  { {0x44260466, 0x44f300fa, 0x00000000, 0x00000000}},  //   _dno_, sã_,   ,
  { {0x442601d9, 0x00000000, 0x00000000, 0x00000000}},  //   _eno_,   ,   ,
  { {0x44260009, 0x05190025, 0x00000000, 0x00000000}},  //   _fno_, _دياب_,   ,
  { {0x44d7001a, 0xe8df0011, 0xbbaa006e, 0x00000000}},  //   mă_, _chứa_, _कलेक,
  { {0x7d1e021d, 0x644b0813, 0x44d7000d, 0x00000000}},  //   _srps, _ilgi, lă_,
  { {0x629d0224, 0x00000000, 0x00000000, 0x00000000}},  //   ůsob,   ,   ,
  { {0x44d7000d, 0x4426018e, 0x00000000, 0x00000000}},  //   nă_, _yno_,   ,
  { {0x09e30055, 0x7e7c00ab, 0xc7a500a1, 0x00000000}},  //   ন্মা, sorp, _لڑ_,
  { {0xe9da0256, 0x78bb0091, 0xeb97004c, 0x00000000}},  // [a60] йка_, _čuva, зит_,
  { {0x6f0400f6, 0x9e0a0025, 0x3af400f8, 0x00000000}},  //   _ipic, _ايدك_, räp_,
  { {0xe8fa0057, 0x7af60814, 0x44d7001a, 0x00000000}},  //   сле_, styt, jă_,
  { {0xafdb01e3, 0x44d7001a, 0x7c2601a2, 0x00000000}},  //   lhør, dă_, _unkr,
  { {0xf7430423, 0x3a3804d3, 0x44260068, 0x00000000}},  //   нецо, _torp_, _rno_,
  { {0x644b0006, 0x442600f8, 0xf3f90035, 0x00000000}},  //   _algi, _sno_, viţa_,
  { {0x44d7001a, 0x44260815, 0x69dc00ea, 0x00000000}},  //   gă_, _pno_, _idre,
  { {0xb603001e, 0x68e30211, 0x69ce01a2, 0x00000000}},  //   ēšan, ánde, _hebe,
  { {0x69ce020c, 0x96b90816, 0x7ae401e5, 0x00000000}},  //   _kebe, _духу_, nrit,
  { {0x64aa0224, 0x69ce0166, 0x644b007f, 0x00000000}},  //   _přid, _jebe, _elgi,
  { {0x44d7000d, 0x7ae4010f, 0x69ce023a, 0x00000000}},  //   că_, hrit, _mebe,
  { {0x44260817, 0x69ce001f, 0x00000000, 0x00000000}},  //   _uno_, _lebe,   ,
  { {0x69dc0119, 0xa857009b, 0x00000000, 0x00000000}},  //   _odre, ליטה_,   ,
  { {0x6266023c, 0x8cb10309, 0xbeed007d, 0x00000000}},  //   _عاشق, _आंदो, _जमीन_,
  { {0x7ae40004, 0x6f040142, 0xd7cc001c, 0x00000000}},  //   erit, _epic, ाराच,
  { {0x7ae401c9, 0x69ce002d, 0xdb0d04bc, 0x00000000}},  //   frit, _aebe, scaí,
  { {0x69ce0475, 0x44d7000d, 0x6fc3006e, 0x00000000}},  // [a70] _bebe, ză_, _व्यं,
  { {0x19ab0818, 0x69ce0095, 0x00000000, 0x00000000}},  //   стап_, _cebe,   ,
  { {0x69ce0819, 0xdb1d081a, 0x7ae40197, 0x00000000}},  //   _debe, _jesú, arit,
  { {0x7ae4081b, 0x44d7001a, 0x9cd6009b, 0x00000000}},  //   brit, vă_, _קורה_,
  { {0x7ae40555, 0x69ce02e7, 0x7bdd00f6, 0x00000000}},  //   crit, _febe, _idsu,
  { {0x69ce037f, 0x44d7000d, 0xcb1200b3, 0x00000000}},  //   _gebe, tă_, _שלם_,
  { {0x7bcf04cb, 0x78a20161, 0x7d02016c, 0x00000000}},  //   _kecu, ňova, _ćosk,
  { {0x44d7000d, 0x200b0166, 0xa01b0039, 0x00000000}},  //   ră_, jeci_, slöj,
  { {0x200b037e, 0x44d7000d, 0x1dbf0061, 0x00000000}},  //   deci_, să_, ्रात,
  { {0xe0d9081c, 0x44d7001a, 0x7bcf00e5, 0x00000000}},  //   ово_, pă_, _lecu,
  { {0x7bdd037e, 0x7bcf00d9, 0x69c50048, 0x00000000}},  //   _odsu, _oecu, ibhe,
  { {0x7bcf001a, 0xe3b30025, 0xdb1d00f6, 0x00000000}},  //   _necu, _أرض_, _desú,
  { {0xdb040048, 0x9983007f, 0x6d4100ea, 0x00000000}},  //   sciú, _kojų_, ølan,
  { {0x09e30044, 0x7ae4010e, 0xf2d2009b, 0x00000000}},  //   ন্তা, vrit, _יעד_,
  { {0x7bcf0035, 0xbea3007e, 0x7ae400ab, 0x00000000}},  //   _becu, тарк, writ,
  { {0x69ce020c, 0xdd8f0426, 0x7bcf0035, 0x00000000}},  //   _sebe, شوق_, _cecu,
  { {0x78ae081d, 0x7bcf001a, 0xd91000a6, 0x00000000}},  // [a80] _subv, _decu, گیز_,
  { {0x7ae4022b, 0xe8df001d, 0x6aa700b5, 0x00000000}},  //   rrit, _chữa_, _cijf,
  { {0xfbc6007c, 0x2d96081e, 0x27fd0016, 0x00000000}},  //   _обно, _юрис, ffwn_,
  { {0xab2a01f9, 0x3136007b, 0x7ae40065, 0x00000000}},  //   _дома_, ונעם_, prit,
  { {0x09e30055, 0x69ce081f, 0xe737004d, 0x00000000}},  //   ন্ধা, _tebe, мец_,
  { {0x69dc0820, 0x200b0821, 0x69ce010f, 0x00000000}},  //   _udre, zeci_, _uebe,
  { {0x6935013e, 0xdb060190, 0x00000000, 0x00000000}},  //   _přeš, _afkø,   ,
  { {0x64aa00b9, 0x09e30044, 0xd706003b, 0x00000000}},  //   _přib, ন্দা, _озби,
  { {0x41e60822, 0x64aa013e, 0x69a20061, 0x00000000}},  //   міна, _břic, _कृती,
  { {0xd25003ec, 0xd626006d, 0x63ab00e0, 0x00000000}},  //   اند_, _تعري, _eggn,
  { {0xa01b00b0, 0x629a0203, 0x6935013e, 0x00000000}},  //   llöi, rmto, _třeš,
  { {0xc32a0054, 0x6283000a, 0xd5b10082, 0x00000000}},  //   _وكان_, _ekno, _tác_,
  { {0x200b0823, 0xa2d8006e, 0x00000000, 0x00000000}},  //   reci_, _मिट्,   ,
  { {0x7bcf0824, 0x200b0825, 0x00000000, 0x00000000}},  //   _secu, seci_,   ,
  { {0x38b701d5, 0x320c00ab, 0x6d550026, 0x00000000}},  //   _oħra_, medy_, uzza,
  { {0x28d8006e, 0x320c0826, 0x00000000, 0x00000000}},  //   _डिजि, ledy_,   ,
  { {0x7bcf001e, 0x7b6700ec, 0xfe6e025a, 0x00000000}},  // [a90] _vecu, фтве, شگی_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xa3c30164, 0x1bd50827, 0x7bcf0035, 0x00000000}},  //   ्रम_, _поня, _tecu,
  { {0x883500a1, 0x2aad0087, 0x00000000, 0x00000000}},  //   رکزئ, _ažbe_,   ,
  { {0x7d0205fa, 0x7c3d0051, 0x320c0027, 0x00000000}},  //   _ćosi, _iosr, kedy_,
  { {0x245101ca, 0x7aed01a3, 0x00000000, 0x00000000}},  //   _máme_, muat,   ,
  { {0x7aed0549, 0x7c3d0828, 0x04b800a1, 0x00000000}},  //   luat, _kosr, وپوں_,
  { {0xdb1d02cc, 0xe8cb0061, 0x00000000, 0x00000000}},  //   _besø, ाठीच,   ,
  { {0x64aa00b9, 0x25a90014, 0x7c3d0829, 0x00000000}},  //   _přic, _فضای_, _mosr,
  { {0x291e0006, 0x320c0133, 0x00000000, 0x00000000}},  //   _štai_, gedy_,   ,
  { {0x75210061, 0x7aed082a, 0x7c3d01c3, 0x00000000}},  //   _urlz, huat, _oosr,
  { {0x7aed04cb, 0x1b060044, 0x00000000, 0x00000000}},  //   kuat, রিতে_,   ,
  { {0xe801001c, 0x7aed008e, 0x6449010f, 0x00000000}},  //   ळ्या_, juat, mkei,
  { {0x443d0038, 0x78a900d9, 0x644900b0, 0x00000000}},  //   _how_, _liev, lkei,
  { {0x6281082b, 0x7c960264, 0x443d0173, 0x00000000}},  //   molo, ерац, _kow_,
  { {0x7aed000b, 0x6281082c, 0x78a90211, 0x00000000}},  //   fuat, lolo, _niev,
  { {0x3b07005e, 0xfe7200a1, 0x7aed0207, 0x00000000}},  // [aa0] нето_, _مدد_, guat,
  { {0x443d0038, 0x9b930025, 0x6449082d, 0x00000000}},  //   _low_, الكت, hkei,
  { {0x6449021e, 0x64850048, 0xef180089, 0x00000000}},  //   kkei, nóis, āļu_,
  { {0x443d0038, 0x7aed003f, 0x38600009, 0x00000000}},  //   _now_, buat, òir_,
  { {0x78a9082e, 0x91fc0089, 0x0c23005e, 0x00000000}},  //   _diev, onāt, _смян,
  { {0x25fb02d2, 0x62810066, 0x7bd60487, 0x00000000}},  //   ल्ली_, jolo, layu,
  { {0x628104f4, 0x3eb201d6, 0x443d0133, 0x00000000}},  //   dolo, _luyt_, _bow_,
  { {0x6449001f, 0x98a3003b, 0x7bd60058, 0x00000000}},  //   gkei, _бисе, nayu,
  { {0x6281082f, 0x443d0082, 0xa3b70025, 0x00000000}},  //   folo, _dow_, راير_,
  { {0x62810830, 0xa68301ee, 0x7bd60831, 0x00000000}},  //   golo, _блуд, hayu,
  { {0x7bd60058, 0x75d30025, 0x00000000, 0x00000000}},  //   kayu, _إيما,   ,
  { {0x44fa048a, 0xd25000a6, 0x00000000, 0x00000000}},  //   më_, انگ_,   ,
  { {0x6281012b, 0x44fa008d, 0xc43b00b6, 0x00000000}},  //   bolo, lë_, _מתאי,
  { {0x62810365, 0x661a021e, 0x386600fa, 0x00000000}},  //   colo, _jatk, hior_,
  { {0x44fa008d, 0x661a021e, 0x7c3d0087, 0x00000000}},  //   në_, _matk, _posr,
  { {0x661a0832, 0x7bd60487, 0x60da00ea, 0x00000000}},  //   _latk, gayu, mstm,
  { {0x44fa0065, 0xeab30025, 0x78a90197, 0x00000000}},  // [ab0] hë_, اعر_, _riev,
  { {0x78a9001e, 0x44fa008d, 0xda780425, 0x00000000}},  //   _siev, kë_, нях_,
  { {0xdd9101ef, 0x78a9001e, 0x44fa008d, 0x00000000}},  //   _خود_, _piev, jë_,
  { {0x64850051, 0x44fa0065, 0x7aed008e, 0x00000000}},  //   hóir, dë_, puat,
  { {0x44fa0007, 0x6281014a, 0xdb0700b0, 0x00000000}},  //   eë_, yolo, ämäs,
  { {0xa50901f9, 0x6281006b, 0x99d4023c, 0x00000000}},  //   дека_, xolo, _متفا,
  { {0x6485002a, 0x44fa0065, 0x443d0036, 0x00000000}},  //   dóir, gë_, _pow_,
  { {0x38660833, 0x62810834, 0x69d70835, 0x00000000}},  //   cior_, wolo, laxe,
  { {0x64490706, 0x661a0065, 0xf7730025, 0x00000000}},  //   rkei, _fatk, _صار_,
  { {0x6485002a, 0x64490836, 0x443d0837, 0x00000000}},  //   góir, skei, _wow_,
  { {0x44fa0023, 0x443d0838, 0x00000000, 0x00000000}},  //   cë_, _tow_,   ,
  { {0x3f6a0404, 0xd5640839, 0x62810232, 0x00000000}},  //   димо_, _ступ, solo,
  { {0x62810207, 0x6e3e01fd, 0x249f01e5, 0x00000000}},  //   polo, _popb, mmum_,
  { {0x248d05a6, 0x63bb0207, 0xfce6004c, 0x00000000}},  //   llem_, lcun, кого,
  { {0x7bd6011c, 0x8d6300ed, 0xfc3f00d4, 0x00000000}},  //   tayu, авре, _boí_,
  { {0x63bb083a, 0x3ce50010, 0x2cab00d9, 0x00000000}},  //   ncun, álva_, _cicd_,
  { {0xcb6704cf, 0x6e3e01a3, 0x44fa0065, 0x00000000}},  // [ac0] вате_, _topb, zë_,
  { {0x7bd6083b, 0xbea601e0, 0x6fa7013d, 0x00000000}},  //   sayu, _шапк, _गणतं,
  { {0x661a083c, 0xa3c30164, 0x7bd6083d, 0x00000000}},  //   _ratk, ्रा_, payu,
  { {0xb90a0164, 0x44fa0065, 0x076a083e, 0x00000000}},  //   _मि_, vë_, وماً_,
  { {0x248d083f, 0x69ca000c, 0x2ca0006c, 0x00000000}},  //   dlem_, ðfes, mmid_,
  { {0x44fa048a, 0x2ca0006c, 0xe737003b, 0x00000000}},  //   të_, lmid_, тељ_,
  { {0x81d70044, 0x386600f8, 0xda0201f5, 0x00000000}},  //   িলা_, pior_, र्णत_,
  { {0x44fa048a, 0x291804d4, 0x661a0075, 0x00000000}},  //   rë_, _isra_, _watk,
  { {0x44fa008d, 0x6d470046, 0x64850051, 0x00000000}},  //   së_, zyja, tóir,
  { {0x91fc001e, 0xd05d006b, 0x44fa0065, 0x00000000}},  //   ciāl, əyəc, pë_,
  { {0x67220840, 0x64850051, 0x44fa0023, 0x00000000}},  //   lvoj, róir, që_,
  { {0xdb040841, 0x64850051, 0x60da054e, 0x00000000}},  //   nció, sóir, rstm,
  { {0x733601f7, 0xf09f0129, 0xdb04008e, 0x00000000}},  //   _جرائ, rmà_, ició,
  { {0x52d700b6, 0x2ca0006c, 0xc6940049, 0x00000000}},  //   _יודע_, emid_, טאָ_,
  { {0x4fc700c0, 0xdb040010, 0x7e6700bb, 0x00000000}},  //   _испа, kció, rijp,
  { {0x30a4007e, 0x3f85006b, 0x5c740478, 0x00000000}},  //   _крыв, ğlub_, алст,
  { {0x2c77002b, 0x6e450379, 0x00000000, 0x00000000}},  // [ad0] għda_, _منظم,   ,
  { {0x68e30842, 0x67220247, 0x99d501d8, 0x00000000}},  //   ándo, dvoj, اقات,
  { {0x248d0667, 0x8af0006b, 0x69d70843, 0x00000000}},  //   ylem_, lzəl, raxe,
  { {0x69ca009f, 0xa01b0210, 0x00000000, 0x00000000}},  //   ðfer, mlös,   ,
  { {0x7c2f0038, 0x64aa00b9, 0xa01b0844, 0x00000000}},  //   _incr, _přin, llös,
  { {0xe29a00ad, 0xdb040819, 0x4519004d, 0x00000000}},  //   _như_, ació, еция_,
  { {0x91fc001e, 0x58d4007c, 0xa01b0210, 0x00000000}},  //   riāl, _вост, nlös,
  { {0xdb040845, 0x69d50032, 0x33260846, 0x00000000}},  //   cció, _heze, _brox_,
  { {0x63bb049a, 0x248d0847, 0x69d50047, 0x00000000}},  //   rcun, rlem_, _keze,
  { {0xa3c30164, 0x63bb0848, 0x248d0062, 0x00000000}},  //   ्रह_, scun, slem_,
  { {0x10a60849, 0x69d500b5, 0x321c0471, 0x00000000}},  //   лион, _meze, _davy_,
  { {0xcea9007b, 0x69d502ae, 0xf99200b3, 0x00000000}},  //   _זי_, _leze, מרי_,
  { {0xe28e012b, 0x442f0161, 0xa2e5041f, 0x00000000}},  //   _га_, _ing_, _солд,
  { {0xa01b084a, 0x764101c3, 0x7c2f009d, 0x00000000}},  //   flös, _joly, _ancr,
  { {0xed5a0175, 0x672207ac, 0x2d8c0030, 0x00000000}},  //   хов_, zvoj, æde_,
  { {0x09cd0044, 0xfe7f00d4, 0x442f0022, 0x00000000}},  //   _লাগা, duïu_, _jng_,
  { {0x69d5084b, 0x2ca0084c, 0x7053023c, 0x00000000}},  // [ae0] _beze, rmid_, _دنيا,
  { {0x442f011c, 0x7c2f084d, 0x2ca00114, 0x00000000}},  //   _lng_, _encr, smid_,
  { {0x69d50691, 0x4996007c, 0x20d1050f, 0x00000000}},  //   _deze, ушат, nši_,
  { {0x442f00e0, 0xa967003b, 0xf3f90035, 0x00000000}},  //   _nng_, ћица_, biţi_,
  { {0xdb040211, 0x69d500c4, 0x76410010, 0x00000000}},  //   rció, _feze, _boly,
  { {0x442f084e, 0x69d5084f, 0x67220850, 0x00000000}},  //   _ang_, _geze, rvoj,
  { {0xdb040219, 0x67220059, 0x20d101d9, 0x00000000}},  //   pció, svoj, jši_,
  { {0x44de01d5, 0x69d5002d, 0x33260851, 0x00000000}},  //   rċ_, _zeze, _prox_,
  { {0x76410047, 0x442f04be, 0x926a0594, 0x00000000}},  //   _foly, _dng_, ерна_,
  { {0x76410852, 0xda14013d, 0x00000000, 0x00000000}},  //   _goly, ड़ित_,   ,
  { {0xd48f0265, 0x74130014, 0x2d8c0036, 0x00000000}},  //   _гр_, _گونا, żdej_,
  { {0x78a2008e, 0x442f0058, 0xd0e5007d, 0x00000000}},  //   nmov, _gng_, _किरण_,
  { {0xe29a001d, 0xdd250089, 0x78a200fa, 0x00000000}},  //   _thư_, dīša, imov,
  { {0x98bc0224, 0xa01b0210, 0x644200bb, 0x00000000}},  //   ávě_, tlös, _hooi,
  { {0x442f018e, 0x78a20059, 0xfe7f0129, 0x00000000}},  //   _yng_, kmov, duït_,
  { {0x78a2016e, 0xf3f9001a, 0x69d50853, 0x00000000}},  //   jmov, tiţi_, _seze,
  { {0x90980070, 0x6442015c, 0x69d5002d, 0x00000000}},  // [af0] _حضور_, _mooi, _peze,
  { {0xf3f9001a, 0xdb1d0129, 0xa01b0039, 0x00000000}},  //   riţi_, _besò, plös,
  { {0x69d50854, 0x98510036, 0x57b500ed, 0x00000000}},  //   _veze, nąć_, абет,
  { {0x64420100, 0x69d500b5, 0xdddc0035, 0x00000000}},  //   _nooi, _weze, porţ,
  { {0x7bcd0855, 0x7bda00b3, 0x17070123, 0x00000000}},  //   mbau, _בקרו, افتی_,
  { {0x7aed0039, 0x7bcd010f, 0x6d480856, 0x00000000}},  //   mrat, lbau, ädag,
  { {0xe3b10054, 0x442f0857, 0x7a4100b9, 0x00000000}},  //   يرة_, _png_, _vítě,
  { {0x20d10119, 0x130901fb, 0x7bcd010f, 0x00000000}},  //   vši_, вний_, nbau,
  { {0x644207a5, 0x442f0858, 0x7aed0859, 0x00000000}},  //   _dooi, _vng_, nrat,
  { {0x24800091, 0xdd250089, 0x7aed085a, 0x00000000}},  //   čima_, zīša, irat,
  { {0x29010010, 0x442f085b, 0x27e0000c, 0x00000000}},  //   ntha_, _tng_, ðing_,
  { {0x442f006a, 0x67290065, 0x20d10059, 0x00000000}},  //   _ung_, _krej, rši_,
  { {0x6f0d0045, 0x999800ca, 0x00000000, 0x00000000}},  //   _cpac, _morš_,   ,
  { {0x20d1085c, 0x8cb1013d, 0x00000000, 0x00000000}},  //   pši_, _आंखो,   ,
  { {0xada604ef, 0xdb12009f, 0xdd25001e, 0x00000000}},  //   равл, _ágús, tīša,
  { {0x67290553, 0x32050190, 0x7bcd0548, 0x00000000}},  //   _orej, lfly_, gbau,
  { {0x7aed085d, 0x2d85085e, 0xfe7f0129, 0x00000000}},  // [b00] grat, üler_, tuït_,
  { {0x09e6085f, 0x8d7600a1, 0xdd250089, 0x00000000}},  //   рожн, _ناجا, sīša,
  { {0x2901002a, 0x7aed0207, 0xaa7b00b9, 0x00000000}},  //   gtha_, arat, _svýc,
  { {0x67290860, 0x64aa00b9, 0x78a20861, 0x00000000}},  //   _brej, _přim, umov,
  { {0x7aed049a, 0x64420007, 0x2bd30309, 0x00000000}},  //   crat, _rooi, तररा,
  { {0x67290862, 0x29010051, 0x78a20387, 0x00000000}},  //   _drej, btha_, smov,
  { {0x250804e1, 0x29010051, 0xafdb01e3, 0x00000000}},  //   ارتی_, ctha_, ljøe,
  { {0x67290863, 0x32050133, 0x941801ab, 0x00000000}},  //   _frej, efly_, ужит_,
  { {0x67290864, 0xd1ca007c, 0xa2b3007c, 0x00000000}},  //   _grej, кунд_, обыч,
  { {0x16630865, 0x228b00ea, 0x3254013b, 0x00000000}},  //   _двум, døks_, свор,
  { {0x7aed0061, 0x6f0d0866, 0x91a90082, 0x00000000}},  //   zrat, _spac, _đã_,
  { {0x7aed007f, 0x50670867, 0x00000000, 0x00000000}},  //   yrat, ртоа,   ,
  { {0xfe7f00d4, 0x00000000, 0x00000000, 0x00000000}},  //   duïr_,   ,   ,
  { {0x7aed0868, 0x9f40001f, 0x69d8000c, 0x00000000}},  //   vrat, _weiß_, ðvel,
  { {0x7aed0869, 0xdd95007e, 0x929b009b, 0x00000000}},  //   wrat, савы, _שיות,
  { {0x7aed086a, 0x228b00ea, 0x628801ed, 0x00000000}},  //   trat, søkt_, lodo,
  { {0x7bcd086b, 0x64aa0224, 0xdb99072b, 0x00000000}},  // [b10] rbau, _přij, увач_,
  { {0x6288018e, 0xe9ab06c6, 0xab84086c, 0x00000000}},  //   nodo, ندان_, цуск,
  { {0x7aed086d, 0x6729012d, 0x39470035, 0x00000000}},  //   srat, _srej, âns_,
  { {0x6729086e, 0x7aed086f, 0x628806b8, 0x00000000}},  //   _prej, prat, hodo,
  { {0x29010870, 0x62880871, 0xdd280089, 0x00000000}},  //   stha_, kodo, mēša,
  { {0xb6070373, 0xdd28001e, 0x29010051, 0x00000000}},  //   рядк, lēša, ptha_,
  { {0xd4690872, 0x628801c5, 0x00000000, 0x00000000}},  //   лике_, dodo,   ,
  { {0x67290873, 0xdd280089, 0xb733009e, 0x00000000}},  //   _trej, nēša, _وہاب,
  { {0x672901d9, 0x6288018e, 0x9f440279, 0x00000000}},  //   _urej, fodo, ümü_,
  { {0x62880874, 0x8b58009b, 0x00000000, 0x00000000}},  //   godo, ייחס_,   ,
  { {0x32050875, 0xf5950054, 0x00000000, 0x00000000}},  //   rfly_, _الاج,   ,
  { {0x2056008b, 0x7ae20876, 0xb7bd00e5, 0x00000000}},  //   стор, šoti, _faţe,
  { {0x62880016, 0x443f0089, 0xdd280089, 0x00000000}},  //   bodo, mju_, dēša,
  { {0x62880082, 0xb6cc0279, 0x645b0877, 0x00000000}},  //   codo, _şükü, lhui,
  { {0xdd9201fa, 0x443f0006, 0xc69200a3, 0x00000000}},  //   سور_, oju_, פאל_,
  { {0x443f0213, 0x645b00b5, 0x78a30112, 0x00000000}},  //   nju_, nhui, ïnvl,
  { {0xbbb80061, 0x8c43005e, 0x00000000, 0x00000000}},  // [b20] _अलीक, чете,   ,
  { {0x443f006c, 0xe9d70878, 0x64aa00b9, 0x00000000}},  //   hju_, йку_, _přik,
  { {0x08fa0879, 0x645b0112, 0x443f000c, 0x00000000}},  //   طراب_, khui, kju_,
  { {0x443f01d5, 0xb8eb00a1, 0xdd280089, 0x00000000}},  //   jju_, ابلے_, cēša,
  { {0x443f087a, 0xf3ff0055, 0xeb75007e, 0x00000000}},  //   dju_, ্যার_, _дырэ,
  { {0x7c24038c, 0x89f5008b, 0x443f087b, 0x00000000}},  //   ldir, _мясц, eju_,
  { {0x62880027, 0x69de087c, 0x645b0048, 0x00000000}},  //   vodo, mape, fhui,
  { {0x7c240475, 0x62880046, 0x443f0028, 0x00000000}},  //   ndir, wodo, gju_,
  { {0x35fa01f7, 0x00000000, 0x00000000, 0x00000000}},  //   _مراد_,   ,   ,
  { {0x69de0020, 0xdd280089, 0x443f087d, 0x00000000}},  //   nape, zēša, aju_,
  { {0x628806dc, 0x7c24087e, 0x443f087f, 0x00000000}},  //   rodo, kdir, bju_,
  { {0x62880880, 0x69de0881, 0x645b0882, 0x00000000}},  //   sodo, hape, chui,
  { {0x69de04d3, 0x628805fd, 0x7c24018e, 0x00000000}},  //   kape, podo, ddir,
  { {0x3dd90055, 0x5eb80044, 0x69de0883, 0x00000000}},  //   _তাহল, _অবশে, jape,
  { {0x69de0047, 0x64aa0224, 0xdd280089, 0x00000000}},  //   dape, _přih, tēša,
  { {0x7c24011c, 0x60c70884, 0xa177009b, 0x00000000}},  //   gdir, íjme, _לעוד_,
  { {0xdd28001e, 0xeabf0011, 0xf3fa0044, 0x00000000}},  // [b30] rēša, _trùm_, _আসার_,
  { {0x443f01d5, 0x7b740025, 0x69de0885, 0x00000000}},  //   zju_, أطفا, gape,
  { {0x7c240886, 0x984b0887, 0xdd2801c5, 0x00000000}},  //   bdir, ляда_, pēša,
  { {0x19a80888, 0x987c00b9, 0x00000000, 0x00000000}},  //   ступ_, bíč_,   ,
  { {0x443f0889, 0x7bdf088a, 0xe73900a8, 0x00000000}},  //   vju_, maqu, рел_,
  { {0xdb1d0073, 0x7bdf00d6, 0x1b060044, 0x00000000}},  //   _besö, laqu, রিখে_,
  { {0xf53201f9, 0x443f088b, 0x3eb3088c, 0x00000000}},  //   дејќ, tju_, _mixt_,
  { {0x7bdf088d, 0x9479003b, 0x443f088e, 0x00000000}},  //   naqu, јску_, uju_,
  { {0x443f088f, 0x645b01b5, 0xa5f9003b, 0x00000000}},  //   rju_, rhui, _везу_,
  { {0x645b0168, 0x7c240890, 0xdd1c01ca, 0x00000000}},  //   shui, zdir, váže,
  { {0x443f0891, 0x932700a6, 0x61450269, 0x00000000}},  //   pju_, _گران, цена,
  { {0x69de0892, 0x1faa0893, 0x00000000, 0x00000000}},  //   zape, икни_,   ,
  { {0x7bdf00d4, 0x93270123, 0x645901f3, 0x00000000}},  //   daqu, _دران, _ilwi,
  { {0x6d4e007f, 0xdd1c0062, 0x69de0288, 0x00000000}},  //   tyba, ráže, xape,
  { {0xa3bd0183, 0x69de0894, 0x7bdf0895, 0x00000000}},  //   _आला_, vape, faqu,
  { {0x69de0896, 0x224700d9, 0xdb1d00c4, 0x00000000}},  //   wape, _honk_, _lesõ,
  { {0x7c240897, 0x2005005f, 0xf412019b, 0x00000000}},  // [b40] rdir, əli_, ופן_,
  { {0x22470007, 0x49960545, 0x00000000, 0x00000000}},  //   _jonk_, ошет,   ,
  { {0x8c460898, 0x69de022b, 0xdd0f011f, 0x00000000}},  //   _дене, rape, mışt,
  { {0xdd0f014a, 0x9f480011, 0x7af600d9, 0x00000000}},  //   lışt, _điêu_, puyt,
  { {0xcfbc0044, 0x64aa00b9, 0xfaa602b8, 0x00000000}},  //   _অজান, _křiv, _мамо,
  { {0x7bc40899, 0x64590066, 0x7ae40051, 0x00000000}},  //   lciu, _alwi, msit,
  { {0xd90d00e9, 0x7ae40051, 0x81cf0044, 0x00000000}},  //   _میل_, lsit, ষণা_,
  { {0x7bc4001a, 0x7ae405e0, 0x00000000, 0x00000000}},  //   nciu, osit,   ,
  { {0x69dc089a, 0x224700e0, 0x7bc40006, 0x00000000}},  //   _kere, _bonk_, iciu,
  { {0x69dc0030, 0x7ae4089b, 0x24510051, 0x00000000}},  //   _jere, isit, _lámh_,
  { {0xd257008b, 0x69dc020c, 0x2247089c, 0x00000000}},  //   іць_, _mere, _donk_,
  { {0xe0cf089d, 0x69dc00b5, 0x7bdf00d6, 0x00000000}},  //   کزی_, _lere, xaqu,
  { {0x7bdf06d2, 0x76480022, 0x78bc0203, 0x00000000}},  //   vaqu, _kody, _lurv,
  { {0x69dc012b, 0x764801aa, 0x7ae4017d, 0x00000000}},  //   _nere, _jody, dsit,
  { {0x7bdf00f4, 0x7ae4089e, 0x76480036, 0x00000000}},  //   taqu, esit, _mody,
  { {0x69dc0207, 0x3ced089f, 0xa06807d8, 0x00000000}},  //   _aere, čev_, _маја_,
  { {0x69dc08a0, 0x201908a1, 0x7ae40058, 0x00000000}},  // [b50] _bere, mesi_, gsit,
  { {0x2019014a, 0x69dc0585, 0x76480016, 0x00000000}},  //   lesi_, _cere, _nody,
  { {0x69dc08a2, 0x7bdf008e, 0xfe700076, 0x00000000}},  //   _dere, paqu, _جدي_,
  { {0x765a08a3, 0x2019011f, 0xb17b007b, 0x00000000}},  //   _alty, nesi_, סטאר,
  { {0x69dc08a4, 0x2ca904cb, 0x27e0000c, 0x00000000}},  //   _fere, mmad_, ðina_,
  { {0x69dc08a5, 0x201908a6, 0x2ca9006c, 0x00000000}},  //   _gere, hesi_, lmad_,
  { {0x7bdd04cb, 0x201908a7, 0x6e250066, 0x00000000}},  //   _kesu, kesi_, _mahb,
  { {0x7bdd0343, 0x69c505ca, 0x201906e6, 0x00000000}},  //   _jesu, lche, jesi_,
  { {0x76d5006d, 0x69dc005a, 0x2019014a, 0x00000000}},  //   _رياض, _yere, desi_,
  { {0x69c503a1, 0x7bdd0170, 0x2ca908a8, 0x00000000}},  //   nche, _lesu, hmad_,
  { {0x69c5001f, 0x201908a9, 0x69d8000c, 0x00000000}},  //   iche, fesi_, ðvei,
  { {0x7bdd010a, 0x245808aa, 0x7ae4007f, 0x00000000}},  //   _nesu, _téma_, ysit,
  { {0x245108ab, 0x64aa00b9, 0x62350437, 0x00000000}},  //   _námi_, _přiv, _неду,
  { {0x248d0116, 0x69c508ac, 0xe29801e1, 0x00000000}},  //   loem_, jche, _даі_,
  { {0x61e1021e, 0x7bdd001f, 0xdca60517, 0x00000000}},  //   mall, _besu, зави,
  { {0x2019014a, 0x61e100b0, 0x248d0007, 0x00000000}},  //   cesi_, lall, noem_,
  { {0x69dc04d4, 0x7bdd0030, 0x78bc0549, 0x00000000}},  // [b60] _pere, _desu, _surv,
  { {0x61e10038, 0x7bc40207, 0x78bc08ad, 0x00000000}},  //   nall, sciu, _purv,
  { {0x7ae404bd, 0x7648010a, 0x7bdd0016, 0x00000000}},  //   ssit, _rody, _fesu,
  { {0x69c508ae, 0x61e108af, 0x69dc08b0, 0x00000000}},  //   ache, hall, _were,
  { {0x61e106d5, 0x387f0039, 0x69c501a2, 0x00000000}},  //   kall, _djur_, bche,
  { {0x61e108b1, 0x78bc08b2, 0x69c50207, 0x00000000}},  //   jall, _turv, cche,
  { {0x20c1001d, 0x2019014a, 0xfaa30816, 0x00000000}},  //   _nói_, yesi_, _чаро,
  { {0x7c2608b3, 0x6d4100b0, 0x06660123, 0x00000000}},  //   _jakr, älai, _کارپ,
  { {0x66180027, 0x61e1010f, 0x67200243, 0x00000000}},  //   pevk, fall, _usmj,
  { {0x61e10625, 0x2019023a, 0x20c10011, 0x00000000}},  //   gall, wesi_, _bói_,
  { {0x2019011f, 0xcfe10044, 0x69c30059, 0x00000000}},  //   tesi_, _ভাবন, žneg,
  { {0xe3a7026c, 0x7c260142, 0x3dd90044, 0x00000000}},  //   _کشمی, _nakr, _তাইল,
  { {0x61e108b4, 0x2019011f, 0x69c50462, 0x00000000}},  //   ball, resi_, yche,
  { {0x4426000b, 0x61e10038, 0x7bdd020c, 0x00000000}},  //   _hao_, call, _sesu,
  { {0x442601cd, 0x20c10011, 0x7bdd003c, 0x00000000}},  //   _kao_, _gói_, _pesu,
  { {0x442608b5, 0x201908b6, 0x7c26008a, 0x00000000}},  //   _jao_, qesi_, _cakr,
  { {0xd6d708b7, 0x4426011c, 0x69c50038, 0x00000000}},  // [b70] _সম্প, _mao_, tche,
  { {0x4426001d, 0x27e0009f, 0x69c5010f, 0x00000000}},  //   _lao_, ðinn_, uche,
  { {0x69c508b8, 0x291901fa, 0x7bdd08b9, 0x00000000}},  //   rche, تقاد_, _tesu,
  { {0x69c508ba, 0x442608bb, 0x61e1027b, 0x00000000}},  //   sche, _nao_, zall,
  { {0x69c508bc, 0x61e1005d, 0x79950036, 0x00000000}},  //   pche, yall, _wyzw,
  { {0x7c260046, 0x61e100d4, 0xf1ba0082, 0x00000000}},  //   _zakr, xall, _ngơ_,
  { {0x61e108bd, 0x4426001d, 0x7c3a0051, 0x00000000}},  //   vall, _bao_, _úcrá,
  { {0x4426001d, 0xdb0d027b, 0x61e10016, 0x00000000}},  //   _cao_, lcañ, wall,
  { {0x442608be, 0x20c10011, 0x3b09006b, 0x00000000}},  //   _dao_, _sói_, ntaq_,
  { {0x81bc0089, 0x25a000b9, 0x44260288, 0x00000000}},  //   ldēj, řila_, _eao_,
  { {0x26cd01a8, 0x61e108bf, 0x355503ab, 0x00000000}},  //   _hteo_, rall, _تناز,
  { {0xd36e007a, 0x44260082, 0x81bc0089, 0x00000000}},  //   اهی_, _gao_, ndēj,
  { {0x61e108c0, 0x00000000, 0x00000000, 0x00000000}},  //   pall,   ,   ,
  { {0x7c26037e, 0x4426000b, 0x13e20044, 0x00000000}},  //   _sakr, _zao_, _যায়,
  { {0x4426000b, 0x7c260006, 0x27ed00f8, 0x00000000}},  //   _yao_, _pakr, _oden_,
  { {0x44260011, 0x8af0006b, 0x27ed014a, 0x00000000}},  //   _xao_, yyəd, _nden_,
  { {0xeb97007c, 0x7c2600ea, 0xc6240044, 0x00000000}},  // [b80] дит_, _vakr, পাতা_,
  { {0x7c2608c1, 0x63bc00b9, 0x24800059, 0x00000000}},  //   _wakr, ěrni, čimi_,
  { {0x7c2608c2, 0xa806008b, 0xa3bd0061, 0x00000000}},  //   _takr, дзел, _आलं_,
  { {0xd7ef0025, 0x27ed0146, 0x00000000, 0x00000000}},  //   لكم_, _cden_,   ,
  { {0x4426001d, 0xdb1d0190, 0x47360025, 0x00000000}},  //   _rao_, _afsæ, براز,
  { {0x442608c3, 0x27ed08c4, 0xdd1d01ca, 0x00000000}},  //   _sao_, _eden_, lášt,
  { {0x44260091, 0x644b08c5, 0x00000000, 0x00000000}},  //   _pao_, _bogi,   ,
  { {0x644b04bf, 0xfc3f0082, 0x7af60036, 0x00000000}},  //   _cogi, _khía_, oryt,
  { {0x84ea013d, 0x442608c6, 0xb286007e, 0x00000000}},  //   _टिकट_, _vao_, дынк,
  { {0x4426000b, 0x64aa00b9, 0x65790051, 0x00000000}},  //   _wao_, _přis, ábhá,
  { {0x09f700b6, 0x4426006a, 0xd48f030d, 0x00000000}},  //   ומים_, _tao_, _ар_,
  { {0xdbd603b6, 0x644b0016, 0x442600f6, 0x00000000}},  //   _jääd, _gogi, _uao_,
  { {0xfe730076, 0x00000000, 0x00000000, 0x00000000}},  //   ندس_,   ,   ,
  { {0x63a20032, 0x7af608c7, 0x00000000, 0x00000000}},  //   _izon, dryt,   ,
  { {0xdd94008b, 0xafdb08c8, 0x425500a1, 0x00000000}},  //   вары, ljøm, _سنٹر,
  { {0x7af60065, 0x3b09002b, 0xaa7b04bb, 0x00000000}},  //   fryt, ttaq_, _zvýh,
  { {0x5a35005e, 0xf094009b, 0x7af608c9, 0x00000000}},  // [b90] ннат, _בנק_, gryt,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x80e00044, 0x57f5013b, 0x629a057b, 0x00000000}},  //   পূর্, епет, ilto,
  { {0x63a20007, 0x7af601c9, 0xc19b009b, 0x00000000}},  //   _ozon, bryt, חשבי,
  { {0x6d550010, 0x81bc0089, 0x387d0016, 0x00000000}},  //   lyza, rdēj, rnwr_,
  { {0x644b08ca, 0xe5a5058e, 0x00000000, 0x00000000}},  //   _sogi, нили,   ,
  { {0x63a20047, 0x644b0213, 0x00000000, 0x00000000}},  //   _azon, _pogi,   ,
  { {0x03250072, 0x27ed0018, 0x63a2002b, 0x00000000}},  //   един, _uden_, _bzon,
  { {0xe61000d3, 0x64aa00b9, 0x200c0010, 0x00000000}},  //   _چشم_, _přir, ődik_,
  { {0x63a201ee, 0x64b10089, 0x24510062, 0x00000000}},  //   _dzon, _jāiz, _rámu_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xe730026c, 0x629a08cb, 0xb602002b, 0x00000000}},  //   _حصہ_, alto, _ħġie,
  { {0xafdb0056, 0x00000000, 0x00000000, 0x00000000}},  //   nkøy,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x40960072, 0xdd9206dd, 0x00000000, 0x00000000}},  //   _прит, اوز_,   ,
  { {0xfc3f001d, 0x7af604a5, 0x00000000, 0x00000000}},  //   _phía_, tryt,   ,
  { {0x7bd60058, 0xc2cc0049, 0x00000000, 0x00000000}},  // [ba0] rbyu, ַמאָ,   ,
  { {0xcfb7009b, 0xdbd600b0, 0x7af60052, 0x00000000}},  //   _אלפי_, _sääd, rryt,
  { {0xdbd60103, 0x00000000, 0x00000000, 0x00000000}},  //   _pääd,   ,   ,
  { {0x27e008cc, 0xe3a701f7, 0x2002003f, 0x00000000}},  //   úin_, _مر_, ngki_,
  { {0x81d60044, 0x00000000, 0x00000000, 0x00000000}},  //   িণত_,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x245101e5, 0xfc3f0048, 0x00000000, 0x00000000}},  //   _náms_, _mhín_,   ,
  { {0x25a000b9, 0xccf308cd, 0x629a08ce, 0x00000000}},  //   řilo_, אכה_, wlto,
  { {0x0877007b, 0x27e60058, 0xb5fc002b, 0x00000000}},  //   _נעמט_, maon_, _alġe,
  { {0x27e608cf, 0xaa16007e, 0x3eba00d9, 0x00000000}},  //   laon_, дзiц, _nipt_,
  { {0x64a6013b, 0x629a08d0, 0x00000000, 0x00000000}},  //   _зажа, rlto,   ,
  { {0x20b4007e, 0x25a101a2, 0x27e60058, 0x00000000}},  //   лёўс, ühle_, naon_,
  { {0x3ce30061, 0x3eba00d9, 0x00000000, 0x00000000}},  //   टीने_, _bipt_,   ,
  { {0xfc3f0011, 0x6114007e, 0x6d550036, 0x00000000}},  //   _chín_, _адку, tyza,
  { {0x27e608d1, 0xdd95007e, 0x2d9a004a, 0x00000000}},  //   kaon_, тавы, _cype_,
  { {0x6d550036, 0x321e08d2, 0xc5e60044, 0x00000000}},  //   ryza, lety_, নলিপ,
  { {0x200c005f, 0x291808d3, 0x00000000, 0x00000000}},  // [bb0] ədi_, _apra_,   ,
  { {0x321e0036, 0x06cf0044, 0x9e670025, 0x00000000}},  //   nety_, _রিলি, _ساخن,
  { {0xa3c2007d, 0xfe7f00f6, 0xf8b108d4, 0x00000000}},  //   ्डा_, duïx_, لکر_,
  { {0xab5b00c4, 0x9cd600a0, 0x69d8000c, 0x00000000}},  //   _agüe, _שורה_, ðver,
  { {0x58b80025, 0x7c2d08d5, 0x38a7006c, 0x00000000}},  //   رامج_, mdar, võrd_,
  { {0x7c2d009f, 0xafdb00ea, 0xf6d40014, 0x00000000}},  //   ldar, rkøy, ازند,
  { {0x64aa0224, 0xc984005e, 0x60cd016c, 0x00000000}},  //   _přip, _бути, _čamo,
  { {0x248901ae, 0x00000000, 0x00000000, 0x00000000}},  //   čamo_,   ,   ,
  { {0x321e00ab, 0x1306007c, 0x7c2d00ea, 0x00000000}},  //   fety_, вный_, idar,
  { {0xa77408d6, 0x68e10030, 0x7c2d005b, 0x00000000}},  //   _случ, _ælds, hdar,
  { {0x320b0036, 0x332608d7, 0x3eba0009, 0x00000000}},  //   ęcy_, _esox_, _ript_,
  { {0x7c2d0089, 0x2bd30061, 0x3f8c013f, 0x00000000}},  //   jdar, धुमा, şdum_,
  { {0xf8b2007b, 0x7c2d018e, 0x442d0483, 0x00000000}},  //   ישט_, ddar, mde_,
  { {0x7c2d08d8, 0x2d9a01d6, 0x443d08d9, 0x00000000}},  //   edar, _pype_, _hnw_,
  { {0x442d03fd, 0x67220036, 0x2d9a01a2, 0x00000000}},  //   ode_, zwoj, _qype_,
  { {0x61e300b7, 0x644908da, 0x7c2d011c, 0x00000000}},  //   _henl, njei, gdar,
  { {0x442d001e, 0xc05300b6, 0x7c3d0009, 0x00000000}},  // [bc0] ide_, _כזה_, _dnsr,
  { {0x2d9a0365, 0x442d021e, 0x628108db, 0x00000000}},  //   _type_, hde_, nnlo,
  { {0x442d08dc, 0x61e30093, 0x27e6006a, 0x00000000}},  //   kde_, _menl, taon_,
  { {0x442d08dd, 0x3860002a, 0x78a9028a, 0x00000000}},  //   jde_, óir_, _chev,
  { {0xe1e700d3, 0x442d0292, 0x2ee001aa, 0x00000000}},  //   _پس_, dde_, _jwif_,
  { {0x442d0168, 0x27e60058, 0x443d00d9, 0x00000000}},  //   ede_, saon_, _anw_,
  { {0x442d06b2, 0x291808de, 0x60c301a2, 0x00000000}},  //   fde_, _upra_, _nunm,
  { {0x442d08df, 0x98a60478, 0x443d0068, 0x00000000}},  //   gde_, _рибе, _cnw_,
  { {0x68e10030, 0x799c0016, 0xd707007c, 0x00000000}},  //   _ældr, _hyrw, _инте_,
  { {0x7c2d066e, 0x386602d5, 0x443d018e, 0x00000000}},  //   zdar, lhor_, _enw_,
  { {0x26c40020, 0x442d08e0, 0x321e0395, 0x00000000}},  //   _humo_, bde_, rety_,
  { {0xf993019b, 0x38660181, 0x68e308e1, 0x00000000}},  //   ירת_, nhor_, ândi,
  { {0x321e08e2, 0x61e30173, 0x69ce000c, 0x00000000}},  //   pety_, _fenl, _ofbe,
  { {0x4256025f, 0xdce50027, 0x61e304cd, 0x00000000}},  //   _штет, _vyhľ, _genl,
  { {0xac19012b, 0x26c40032, 0x61e808e3, 0x00000000}},  //   нову_, _lumo_, madl,
  { {0xfbd300d3, 0x69ce02ae, 0x7c2d008a, 0x00000000}},  //   شتر_, _afbe, udar,
  { {0x38660065, 0x00000000, 0x00000000, 0x00000000}},  // [bd0] dhor_,   ,   ,
  { {0x442d08e4, 0xf09f04bd, 0x78a90023, 0x00000000}},  //   zde_, llà_, _shev,
  { {0x442d08e5, 0x9f4e0010, 0x6abc08e6, 0x00000000}},  //   yde_, önöm_, _dirf,
  { {0x24860091, 0x7c3d0170, 0x7c2d006b, 0x00000000}},  //   _njom_, _unsr, qdar,
  { {0x442d0018, 0xdbd1006c, 0x443d00d9, 0x00000000}},  //   vde_, _müüd, _rnw_,
  { {0x442d08e7, 0x6a6001e5, 0x7aed08e8, 0x00000000}},  //   wde_, _höfn, msat,
  { {0x2609001c, 0x78a908e9, 0x26c400f6, 0x00000000}},  //   _साठी_, _thev, _eumo_,
  { {0x442d08ea, 0x2901011c, 0x26c408eb, 0x00000000}},  //   ude_, muha_, _fumo_,
  { {0x387c009d, 0x645b0288, 0x2901011c, 0x00000000}},  //   èvre_, rkui, luha_,
  { {0x442d08ec, 0xb7bd000d, 0x645b0007, 0x00000000}},  //   sde_, _naţi, skui,
  { {0x61e30030, 0x442d0129, 0x2901011c, 0x00000000}},  //   _venl, pde_, nuha_,
  { {0x44e1010a, 0xbf9b0181, 0x833501fa, 0x00000000}},  //   mų_, rgên, _مرتض,
  { {0x44e10006, 0xa3c20316, 0x09ca0044, 0x00000000}},  //   lų_, ्डर_, ষরতা,
  { {0x249f000c, 0x7aed0030, 0x2901006a, 0x00000000}},  //   llum_, dsat, kuha_,
  { {0x44e1010a, 0x10f5007e, 0x7aed08ed, 0x00000000}},  //   nų_, _сяля, esat,
  { {0x6b9d0016, 0xc00602b0, 0x7aed08ee, 0x00000000}},  //   _bysg, _спик, fsat,
  { {0x6f0f001c, 0xfc3f0428, 0x6b9d0016, 0x00000000}},  // [be0] ctcc, _dní_, _cysg,
  { {0xfeba035b, 0x6b9d018e, 0x44e1010a, 0x00000000}},  //   _ثابت_, _dysg, kų_,
  { {0x44e1010a, 0x386608ef, 0x3e6600f4, 0x00000000}},  //   jų_, thor_, _côte_,
  { {0x8c4600d7, 0x6abc068a, 0x44e10006, 0x00000000}},  //   _семе, _wirf, dų_,
  { {0x09e80055, 0xe73703e0, 0x81bc0089, 0x00000000}},  //   _পাঠা, лец_, ldēt,
  { {0x290108f0, 0x2ca008f1, 0xfc3f013e, 0x00000000}},  //   buha_, llid_, _zní_,
  { {0x67290089, 0x44e10006, 0x61e808f2, 0x00000000}},  //   _esej, gų_, vadl,
  { {0x545408f3, 0x249f000c, 0x2609006e, 0x00000000}},  //   рвит, glum_, _साथी_,
  { {0x1867003b, 0x61e80161, 0x41e60245, 0x00000000}},  //   _сати_, tadl, ліна,
  { {0x471b00a3, 0xdbd10004, 0x44e10006, 0x00000000}},  //   _אומג, _süüd, bų_,
  { {0x3de208b7, 0x2ca0006c, 0xdbd1006c, 0x00000000}},  //   _বাংল, klid_, _püüd,
  { {0xfc3f0011, 0x61e808f4, 0x442008f5, 0x00000000}},  //   _phím_, sadl, _úi_,
  { {0x543b007b, 0x08770049, 0x61e80387, 0x00000000}},  //   _רעדא, רעכט_, padl,
  { {0x6a60000c, 0x00000000, 0x00000000, 0x00000000}},  //   _söfn,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7aed08f6, 0x2ca0006c, 0x6b9d0016, 0x00000000}},  //   tsat, glid_, _pysg,
  { {0x0ca8007c, 0x998c01ee, 0x7bcd08f7, 0x00000000}},  // [bf0] утри_, _ćoše_, rcau,
  { {0x7aed08f8, 0x7ed40025, 0x29010066, 0x00000000}},  //   rsat, _ازيا, tuha_,
  { {0x7aed08f9, 0x6675007a, 0xc9840478, 0x00000000}},  //   ssat, یدتر, буци,
  { {0x2c2701fb, 0x7aed0039, 0x44e10006, 0x00000000}},  //   _сьог, psat, vų_,
  { {0xd6db005e, 0x66b500ed, 0xf745007c, 0x00000000}},  //   хте_, абду, рело,
  { {0x44e1010a, 0x09df0055, 0xa2c3007d, 0x00000000}},  //   tų_, _ঢাকা, रदस्,
  { {0x249f08fa, 0xdb1d0190, 0x00000000, 0x00000000}},  //   tlum_, _afsø,   ,
  { {0x99840054, 0x44e1010a, 0x60c408fb, 0x00000000}},  //   _الفو, rų_, _čimp,
  { {0x09e80055, 0xc864072b, 0x44e10006, 0x00000000}},  //   _পাতা, _утри, sų_,
  { {0x7c2f0375, 0x425508fc, 0x249f000c, 0x00000000}},  //   _lacr, ртит, slum_,
  { {0xa06a08fd, 0xc4f8006d, 0x249f014a, 0x00000000}},  //   вана_, _معنا_, plum_,
  { {0xb4c102fb, 0x54a700f3, 0xe3b000a6, 0x00000000}},  //   ंदी_, _صحاف, _کرم_,
  { {0x442f031c, 0x324500e2, 0x00000000, 0x00000000}},  //   _iag_, _велг,   ,
  { {0x3ebe08fe, 0x442f000c, 0x2ca008ff, 0x00000000}},  //   ött_, _hag_, wlid_,
  { {0x442f0058, 0xfce60900, 0x94ee013f, 0x00000000}},  //   _kag_, робо, _bəə_,
  { {0x442f0901, 0xbc630081, 0xa3ac0309, 0x00000000}},  //   _jag_, овск, _गरम_,

  { {0x442f0222, 0x6b850025, 0x91fc0089, 0x00000000}},  // [c00] _mag_, مشكل, bkād,
  { {0xe9d70902, 0x442f0292, 0x7ea00039, 0x00000000}},  //   ику_, _lag_, köpi,
  { {0xdca6007c, 0xa9260081, 0x00000000, 0x00000000}},  //   _вани, рдел,   ,
  { {0x442f0903, 0x6d5c0904, 0x00000000, 0x00000000}},  //   _nag_, myra,   ,
  { {0x7c2402d5, 0x7e770009, 0x28130426, 0x00000000}},  //   meir, _ymxp, تونس,
  { {0x7c2402d5, 0xb4c10164, 0x442f01d6, 0x00000000}},  //   leir, ंदू_, _aag_,
  { {0x39470039, 0x442f0905, 0x6d5c0906, 0x00000000}},  //   änst_, _bag_, nyra,
  { {0x7c240907, 0x8af0006b, 0x442f0908, 0x00000000}},  //   neir, yyəl, _cag_,
  { {0x27e0009f, 0xd5b10011, 0x6d5c0909, 0x00000000}},  //   ðinu_, _máy_, hyra,
  { {0x80ca0164, 0x78a2090a, 0x7c24090b, 0x00000000}},  //   _संदे, llov, heir,
  { {0x3a3700b6, 0x442f05b7, 0xd5750088, 0x00000000}},  //   ברים_, _fag_, _луць,
  { {0x442f0093, 0x6d5c00ea, 0x7c2400c4, 0x00000000}},  //   _gag_, dyra, jeir,
  { {0x7c24090c, 0x236d0046, 0x6442002d, 0x00000000}},  //   deir, czej_, _inoi,
  { {0xa2c302d2, 0x442f00b5, 0x78a20161, 0x00000000}},  //   रदर्, _zag_, hlov,
  { {0x7c24018e, 0x442f033b, 0xd087007c, 0x00000000}},  //   feir, _yag_, _выпи,
  { {0x4424090d, 0x78a2037e, 0x7c24090e, 0x00000000}},  //   nem_, jlov, geir,
  { {0x44240191, 0xf9c70827, 0x78a20161, 0x00000000}},  // [c10] iem_, ащен, dlov,
  { {0x4424090f, 0x6d5c00eb, 0x24890910, 0x00000000}},  //   hem_, byra, čami_,
  { {0x44240911, 0x7c2405bc, 0x00000000, 0x00000000}},  //   kem_, beir,   ,
  { {0x7c2400c4, 0x78a20213, 0x00000000, 0x00000000}},  //   ceir, glov,   ,
  { {0x4424059c, 0x442f0912, 0x753a002d, 0x00000000}},  //   dem_, _rag_, _artz,
  { {0x64420913, 0x442f05a6, 0x442401ee, 0x00000000}},  //   _anoi, _sag_, eem_,
  { {0x442f0811, 0xb4c101f5, 0x78a20142, 0x00000000}},  //   _pag_, ंदे_, blov,
  { {0x442402d5, 0x78a20914, 0xe894007e, 0x00000000}},  //   gem_, clov, _дась,
  { {0x442f01aa, 0xdbf40055, 0xd8b600a1, 0x00000000}},  //   _vag_, ঙ্কস_, _اگلا_,
  { {0x442f0915, 0x7c240181, 0x9f4201ca, 0x00000000}},  //   _wag_, zeir, jaká_,
  { {0x44240916, 0x236d0046, 0x2913002d, 0x00000000}},  //   bem_, szej_, ntxa_,
  { {0x7c240181, 0x673b0065, 0x442f004a, 0x00000000}},  //   xeir, _kruj, _uag_,
  { {0x7c240917, 0x7e7c007f, 0x6d5c0696, 0x00000000}},  //   veir, tirp, wyra,
  { {0x6d5c0065, 0x1d0a0918, 0xda030309, 0x00000000}},  //   tyra, леги_, _लागत_,
  { {0x7c240181, 0x78a20062, 0x98a7013e, 0x00000000}},  //   teir, ylov, íně_,
  { {0x3fe6025f, 0x6d5c0544, 0x673b0919, 0x00000000}},  //   _ужив, ryra, _oruj,
  { {0x7c2402d5, 0x78a2037e, 0x387d018e, 0x00000000}},  // [c20] reir, vlov, diwr_,
  { {0x7c2408da, 0x09e80044, 0x00000000, 0x00000000}},  //   seir, _পাহা,   ,
  { {0x7d1e091a, 0xed5a091b, 0x1e57009b, 0x00000000}},  //   _upps, _сон_, _השיר_,
  { {0x44240129, 0x673b0211, 0x16050061, 0x00000000}},  //   xem_, _bruj, _राउर_,
  { {0x4424091c, 0x78a2091d, 0x673b008e, 0x00000000}},  //   vem_, rlov, _cruj,
  { {0x78a2091e, 0x44240036, 0xd946025f, 0x00000000}},  //   slov, wem_, _леги,
  { {0x78a20738, 0x9ac3002b, 0x2609006e, 0x00000000}},  //   plov, ċċes, _सारी_,
  { {0x4424091f, 0xafdb0190, 0x00000000, 0x00000000}},  //   uem_, hjør,   ,
  { {0xe7370057, 0x533401e0, 0x66e30920, 0x00000000}},  //   _лет_, цепт, _нота,
  { {0x44240921, 0x3d1903d7, 0x6f060667, 0x00000000}},  //   sem_, _पहले_, dukc,
  { {0x442400b9, 0x1a9b0049, 0x3a37009b, 0x00000000}},  //   pem_, רייע, זרים_,
  { {0x5edd0044, 0x9f4b009d, 0xc953009b, 0x00000000}},  //   _বিবে, lacé_, למת_,
  { {0xa3bc0365, 0x80ca007d, 0x987b0049, 0x00000000}},  //   _आणि_, _संवे, ראכט,
  { {0x63a20811, 0x9f4000f6, 0x92a40036, 0x00000000}},  //   _iyon, _deià_, ółdz,
  { {0x865b01ce, 0xdd3a001a, 0x00000000, 0x00000000}},  //   נדלי, văţa,   ,
  { {0x629a0142, 0x63a20922, 0xd7ba0061, 0x00000000}},  //   loto, _kyon, ेशाच,
  { {0x260901f5, 0x62880020, 0x61ea000c, 0x00000000}},  // [c30] _साली_, ondo, _kefl,
  { {0x80db0044, 0xe9ab0014, 0x00000000, 0x00000000}},  //   _ভিত্, هدان_,   ,
  { {0x628801d6, 0x63a20923, 0x09e80044, 0x00000000}},  //   indo, _lyon, _পাশা,
  { {0xf77000e9, 0x629a0142, 0xbd880014, 0x00000000}},  //   کام_, hoto, _چنین_,
  { {0x63a2036b, 0x629a0924, 0x387d0016, 0x00000000}},  //   _nyon, koto, riwr_,
  { {0x673b0925, 0xddc500b9, 0x34b3006e, 0x00000000}},  //   _vruj, _pohř, ुद्द,
  { {0x629a0006, 0x69c70292, 0x63a2009d, 0x00000000}},  //   doto, _igje, _ayon,
  { {0xe459026b, 0x673b0926, 0x63a20927, 0x00000000}},  //   ржи_, _truj, _byon,
  { {0x60ca010f, 0x63a20009, 0x673b0045, 0x00000000}},  //   _aufm, _cyon, _uruj,
  { {0x63a20173, 0x60d800f6, 0x7d070023, 0x00000000}},  //   _dyon, _btvm, kujs,
  { {0x6026008b, 0xdddc0006, 0x404a0069, 0x00000000}},  //   одна, sirū, апно_,
  { {0x62880197, 0x5046012b, 0xe45f006c, 0x00000000}},  //   ando, цемб, ööd_,
  { {0x629a0928, 0x63a20232, 0x00000000, 0x00000000}},  //   boto, _gyon,   ,
  { {0x6f060036, 0x61ea03a9, 0x629a0299, 0x00000000}},  //   rukc, _gefl, coto,
  { {0x8c7a005e, 0x2c67006c, 0xdd9203d6, 0x00000000}},  //   ащат_, _sõda_, ذور_,
  { {0x69c70065, 0x69d500b5, 0xc5f30044, 0x00000000}},  //   _agje, _afze, চ্চা_,
  { {0x2ea700a1, 0x20e70010, 0x00000000, 0x00000000}},  // [c40] _ڈپٹی_, lői_,   ,
  { {0x89f5007e, 0xafdb08c8, 0xa01b0010, 0x00000000}},  //   зяцц, ljøp, ynök,
  { {0x38cb0167, 0x60c40929, 0xc92a005e, 0x00000000}},  //   لانی_, _kiim, роеж_,
  { {0x629a0020, 0x186a00ed, 0x09aa0061, 0x00000000}},  //   zoto, јади_, _करीय,
  { {0x41c9007d, 0x629a000b, 0xc5f30044, 0x00000000}},  //   रशास, yoto, চ্ছা_,
  { {0x473301fb, 0x63a20022, 0x60c4092a, 0x00000000}},  //   ьніс, _ryon, _liim,
  { {0x629a0142, 0x00000000, 0x00000000, 0x00000000}},  //   voto,   ,   ,
  { {0x69c7008d, 0x60c4006c, 0x6d4e00f6, 0x00000000}},  //   _zgje, _niim, ixba,
  { {0x629a006a, 0x00000000, 0x00000000, 0x00000000}},  //   toto,   ,   ,
  { {0xd25a092b, 0x628800c4, 0x60c40068, 0x00000000}},  //   рци_, undo, _aiim,
  { {0x629a092c, 0x5bb70061, 0x7c360635, 0x00000000}},  //   roto, _अण्व, kdyr,
  { {0x629a0052, 0x7ea00039, 0x6a60000c, 0x00000000}},  //   soto, köps, _döfi,
  { {0x61ea092d, 0x629a0020, 0x60c404cb, 0x00000000}},  //   _tefl, poto, _diim,
  { {0x5edd0055, 0x00000000, 0x00000000, 0x00000000}},  //   _বিদে,   ,   ,
  { {0xa6e90082, 0x00000000, 0x00000000, 0x00000000}},  //   _giươ,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x3f8c005f, 0x27ef092e, 0x00000000, 0x00000000}},  // [c50] şdur_, vagn_,   ,
  { {0x3cfe092f, 0x0b880088, 0xea000082, 0x00000000}},  //   štva_, істи_, _đản_,
  { {0xeeb80930, 0xfeb8006d, 0x00000000, 0x00000000}},  //   _флэш_, _بايت_,   ,
  { {0xfc3f0011, 0x6faf0061, 0x88c80088, 0x00000000}},  //   _chít_, _घरां, ілів_,
  { {0xe739005e, 0x87270025, 0x4907013d, 0x00000000}},  //   сел_, تعام, _हमको_,
  { {0xb9010044, 0x69c700ea, 0xd6290931, 0x00000000}},  //   _দি_, _ugje, соке_,
  { {0x22490932, 0xb06600b0, 0x2fc900e0, 0x00000000}},  //   _đak_, nsää, _ogag_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x66f4003b, 0xc6a70098, 0x60c40933, 0x00000000}},  //   _опту, _држи, _riim,
  { {0x27ed01b5, 0xcb1200b3, 0x20e70010, 0x00000000}},  //   _heen_, עלי_, tői_,
  { {0x60c40934, 0x61450745, 0x2d84014a, 0x00000000}},  //   _piim, чена, şmez_,
  { {0x26c5000b, 0xc4d200b6, 0x27ed00d9, 0x00000000}},  //   _hilo_, _נגד_, _jeen_,
  { {0x60c408b2, 0x26c5014a, 0x27ed0935, 0x00000000}},  //   _viim, _kilo_, _meen_,
  { {0x27ed0168, 0xd35600b3, 0x6459005b, 0x00000000}},  //   _leen_, _מיני_, _howi,
  { {0x60c40103, 0x2fcd0936, 0x00000000, 0x00000000}},  //   _tiim, žega_,   ,
  { {0x62810937, 0x26c50082, 0xd0fa0049, 0x00000000}},  //   lilo, _lilo_, _פּור,
  { {0x64590036, 0x2d85009d, 0x00000000, 0x00000000}},  // [c60] _mowi, ûler_,   ,
  { {0x6281000d, 0x26c500c4, 0x00000000, 0x00000000}},  //   nilo, _nilo_,   ,
  { {0x27ed0038, 0x2f160030, 0x00000000, 0x00000000}},  //   _been_, læg_,   ,
  { {0x62810938, 0xc18c0049, 0x64590036, 0x00000000}},  //   hilo, סטאָ, _nowi,
  { {0x26c501d9, 0x6281009f, 0x16340242, 0x00000000}},  //   _bilo_, kilo, деля,
  { {0x6b890359, 0x98ac0279, 0x62810939, 0x00000000}},  //   _þega, ılır_, jilo,
  { {0x3494008b, 0x628100ca, 0x6459093a, 0x00000000}},  //   макр, dilo, _bowi,
  { {0x27ed015c, 0xc955007e, 0x00000000, 0x00000000}},  //   _geen_, _ўтры,   ,
  { {0x64590036, 0x26c50207, 0x62810321, 0x00000000}},  //   _dowi, _filo_, filo,
  { {0x6281001a, 0x25a5093b, 0xa3dc007d, 0x00000000}},  //   gilo, _fyll_, _त्र_,
  { {0x76480036, 0xfc3f0051, 0x2ee90173, 0x00000000}},  //   _indy, _mhír_, _swaf_,
  { {0x38660010, 0xa3e6013d, 0x7af600b0, 0x00000000}},  //   nkor_, _बजट_, ksyt,
  { {0x6a60009f, 0x62810142, 0x533400e3, 0x00000000}},  //   _höfu, bilo, _целт,
  { {0x6281001a, 0x64470089, 0x645900bb, 0x00000000}},  //   cilo, ējie, _zowi,
  { {0x38660010, 0x765a093c, 0x1bd5004d, 0x00000000}},  //   kkor_, _moty, добя,
  { {0xea000011, 0x9f4b0802, 0x00000000, 0x00000000}},  //   _đạn_, lací_,   ,
  { {0x5a35041f, 0xb06600b0, 0x27ed01d6, 0x00000000}},  // [c70] мнат, ssää, _reen_,
  { {0x27ed00ab, 0x32d20011, 0x765a04c4, 0x00000000}},  //   _seen_, _mây_, _noty,
  { {0x80a400d3, 0x32d20011, 0x6dc301f3, 0x00000000}},  //   _زمین, _lây_, _qċaċ,
  { {0x76480178, 0x26c5093d, 0x6281093e, 0x00000000}},  //   _andy, _silo_, zilo,
  { {0x9f4b093f, 0x2ca90940, 0xcc5600b3, 0x00000000}},  //   kací_, mlad_, _חברי_,
  { {0x6459001f, 0x2ca9074e, 0x6281002d, 0x00000000}},  //   _sowi, llad_, xilo,
  { {0x64590046, 0x765a0941, 0x62810942, 0x00000000}},  //   _powi, _doty, vilo,
  { {0x38660073, 0x32d2001d, 0x764801aa, 0x00000000}},  //   ckor_, _bây_, _endy,
  { {0x6281000d, 0x32d2001d, 0x2ca90016, 0x00000000}},  //   tilo, _cây_, ilad_,
  { {0x32d2001d, 0x64590943, 0x00000000, 0x00000000}},  //   _dây_, _wowi,   ,
  { {0x6281000d, 0x2ca90161, 0xd5670783, 0x00000000}},  //   rilo, klad_, _этап,
  { {0x628105d2, 0x23720036, 0xd59a009b, 0x00000000}},  //   silo, _żyje_, _ובעל,
  { {0x32d2001d, 0xd3d80025, 0x248d00ca, 0x00000000}},  //   _gây_, _ربنا_, mnem_,
  { {0x5edd0055, 0x7cd5010a, 0x248d0059, 0x00000000}},  //   _বিশে, _sąra, lnem_,
  { {0x6da300aa, 0x248d00d4, 0xdca60140, 0x00000000}},  //   вира, onem_, дави,
  { {0x3cfe01ae, 0x248d0018, 0x2ca90190, 0x00000000}},  //   štvo_, nnem_, glad_,
  { {0x32d2001d, 0xdca301bd, 0xa5a4013d, 0x00000000}},  // [c80] _xây_, тати, _चुनौ,
  { {0x2bde006e, 0x7af60036, 0x386d00d4, 0x00000000}},  //   _फ्रा, rsyt, _aler_,
  { {0x2ca90944, 0x248d0091, 0x249f0068, 0x00000000}},  //   blad_, knem_, koum_,
  { {0x20d3001d, 0x31560049, 0x9f4b01dc, 0x00000000}},  //   _mãi_, ויען_, zací_,
  { {0x248d0059, 0x20d30011, 0x386600f8, 0x00000000}},  //   dnem_, _lãi_, rkor_,
  { {0x38660073, 0xa3c1013d, 0xd042006b, 0x00000000}},  //   skor_, ंधन_, rqlə,
  { {0x386d0073, 0xceb3007b, 0x9f4b01c8, 0x00000000}},  //   _fler_, דיג_, vací_,
  { {0x38b50945, 0x3a38020d, 0x248d0091, 0x00000000}},  //   gård_, _harp_, gnem_,
  { {0x27e60946, 0xd6260054, 0x41c9006e, 0x00000000}},  //   mbon_, _يعطي, रशंस,
  { {0x51860454, 0x20d30011, 0x27e6002d, 0x00000000}},  //   дума, _bãi_, lbon_,
  { {0x248d0947, 0x20d30011, 0x9f4b0802, 0x00000000}},  //   bnem_, _cãi_, rací_,
  { {0x32d2001d, 0x248d0107, 0x27e601ed, 0x00000000}},  //   _tây_, cnem_, nbon_,
  { {0x80ca02f4, 0x44fa0089, 0x62790062, 0x00000000}},  //   _संके, lī_, vňov,
  { {0x8d6b00ed, 0x2005005d, 0x2ca90016, 0x00000000}},  //   ојба_, şli_, wlad_,
  { {0x2ca00022, 0x44fa0089, 0x20d30082, 0x00000000}},  //   foid_, nī_, _gãi_,
  { {0x8af00163, 0xfc3f0082, 0x2ca008ce, 0x00000000}},  //   yyət, _chíp_, goid_,
  { {0x7b18007c, 0x291801d5, 0x2d9e036c, 0x00000000}},  // [c90] мотр_, _aqra_, üter_,
  { {0xd5a4009c, 0x248d0059, 0x00000000, 0x00000000}},  //   _نہ_, znem_,   ,
  { {0x249f042a, 0x386d00f6, 0x00000000, 0x00000000}},  //   youm_, _pler_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x248d01d9, 0x7c2d002d, 0x38b50039, 0x00000000}},  //   vnem_, mear, vård_,
  { {0x7c2d0948, 0x8cb9006e, 0xe610006b, 0x00000000}},  //   lear, ्दको, rüşə,
  { {0x248d0059, 0xe5a20088, 0x387f002b, 0x00000000}},  //   tnem_, лиши, _tmur_,
  { {0x7c2d0949, 0x387f0149, 0x20d30011, 0x00000000}},  //   near, _umur_, _rãi_,
  { {0x248d0059, 0x6d43016c, 0x00000000, 0x00000000}},  //   rnem_, _šnal,   ,
  { {0x7c2d002a, 0x248d0087, 0x00000000, 0x00000000}},  //   hear, snem_,   ,
  { {0x0086014c, 0x7c2d002d, 0x332600e5, 0x00000000}},  //   елно, kear, _epox_,
  { {0xcea900a0, 0x20d30082, 0x7c2d0032, 0x00000000}},  //   _הי_, _vãi_, jear,
  { {0x644b033b, 0x7c2d094a, 0x270d0061, 0x00000000}},  //   _ingi, dear, _समोर_,
  { {0x442d021e, 0x877a0104, 0x00000000, 0x00000000}},  //   lee_, לארי,   ,
  { {0x8af0005f, 0x7c2d0048, 0x6fa0007d, 0x00000000}},  //   yyəs, fear, _गुरू,
  { {0x442d021e, 0x7c2d0949, 0xdca60216, 0x00000000}},  //   nee_, gear, хаби,
  { {0xac07008b, 0xdb1c0477, 0xab27094b, 0x00000000}},  // [ca0] энта_, _özüm, нота_,
  { {0x27ff094c, 0x00000000, 0x00000000, 0x00000000}},  //   _adun_,   ,   ,
  { {0x442d094d, 0x7c2d084b, 0x644b02f6, 0x00000000}},  //   kee_, bear, _ongi,
  { {0x7c2d094e, 0x442d094f, 0x27e600bb, 0x00000000}},  //   cear, jee_, ubon_,
  { {0x3a38010a, 0x00000000, 0x00000000, 0x00000000}},  //   _tarp_,   ,   ,
  { {0x644b0292, 0x7ae40207, 0x442d0950, 0x00000000}},  //   _angi, mpit, eee_,
  { {0x442d01d6, 0x2b400951, 0x7ae40207, 0x00000000}},  //   fee_, lvic_, lpit,
  { {0x442d0343, 0x7ae40020, 0x6e2e0952, 0x00000000}},  //   gee_, opit, hebb,
  { {0x7ae400b0, 0x96ba03ab, 0x00000000, 0x00000000}},  //   npit, _فائز_,   ,
  { {0x644b0953, 0x7c2d002d, 0x75d60025, 0x00000000}},  //   _engi, zear, _أيضا,
  { {0xd48f0954, 0x7c2d0955, 0x2ee0012d, 0x00000000}},  //   _бр_, year, _atif_,
  { {0x442d0956, 0x7f440957, 0x7c2d002d, 0x00000000}},  //   cee_, _briq, xear,
  { {0x69dc0958, 0x7c2d0190, 0x7f440068, 0x00000000}},  //   _ofre, vear, _criq,
  { {0x7ae4012d, 0x6e2e0010, 0x78a2010e, 0x00000000}},  //   dpit, gebb, hoov,
  { {0x7c2d022b, 0x3ced0107, 0xac190451, 0x00000000}},  //   tear, ćevo_, мову_,
  { {0x69dc000c, 0xa01b0039, 0x2ee00022, 0x00000000}},  //   _afre, rnös, _ftif_,
  { {0x7c2d002d, 0x9f530036, 0x5f950959, 0x00000000}},  // [cb0] rear, ędów_, _шиит,
  { {0x7c2d0038, 0x442d0020, 0x6f0f0197, 0x00000000}},  //   sear, zee_, mucc,
  { {0x7c2d00ab, 0x6f0f0197, 0x6f1d010f, 0x00000000}},  //   pear, lucc, ltsc,
  { {0xdddc010a, 0x69ce00bb, 0x6f1d00bb, 0x00000000}},  //   mirš, _egbe, otsc,
  { {0x442d095a, 0x6f1d05c6, 0x6f0f0197, 0x00000000}},  //   vee_, ntsc, nucc,
  { {0x442d095b, 0x6d4a0051, 0x6f1d01a2, 0x00000000}},  //   wee_, _áfac, itsc,
  { {0x442d095c, 0xc44700a1, 0x6f1d095d, 0x00000000}},  //   tee_, ٹیشن_, htsc,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x36d501fb, 0x2ba702d2, 0x442d0038, 0x00000000}},  //   _розр, _कुमा, ree_,
  { {0x442d00b0, 0x6f0f095e, 0xcb1401ce, 0x00000000}},  //   see_, ducc, אלץ_,
  { {0x442d095f, 0xd00a003b, 0x6e2e0010, 0x00000000}},  //   pee_, мене_, vebb,
  { {0x6e2e0009, 0x644b01e5, 0x6f1d01a2, 0x00000000}},  //   webb, _ungi, ftsc,
  { {0xa3a80061, 0x547a009b, 0x6f0f0026, 0x00000000}},  //   _खुप_, _קטנו, gucc,
  { {0xdee301fc, 0x78a2012d, 0x00000000, 0x00000000}},  //   рори, zoov,   ,
  { {0x6e2e0198, 0x6da602e9, 0xada605c7, 0x00000000}},  //   rebb, тива, тавл,
  { {0x7f440066, 0x6e2e0010, 0x69dc0197, 0x00000000}},  //   _triq, sebb, _sfre,
  { {0x6d45001f, 0x7d1c01d9, 0x6b63007e, 0x00000000}},  // [cc0] _erha, strs, акта,
  { {0x2b4001f3, 0x7ae40960, 0xeef70097, 0x00000000}},  //   rvic_, rpit, _שמיר_,
  { {0x1bea007c, 0xb05b0961, 0x00000000, 0x00000000}},  //   _одни_, smäe,   ,
  { {0x7ae40052, 0xe7860478, 0xe3a70241, 0x00000000}},  //   ppit, куло, _نر_,
  { {0x78a2017b, 0x3eba0082, 0x00000000, 0x00000000}},  //   roov, _khpt_,   ,
  { {0xb7d20044, 0x20ee00b9, 0x78a2006c, 0x00000000}},  //   ারেট, yři_, soov,
  { {0x6f0f0026, 0x91fc0089, 0xafdb00ea, 0x00000000}},  //   zucc, skāk, ldøe,
  { {0x63ab0637, 0x62830962, 0x39470030, 0x00000000}},  //   _bygn, _amno, ænse_,
  { {0x872505f3, 0x63ab0068, 0xa7a70264, 0x00000000}},  //   _معلم, _cygn, _акта_,
  { {0x63ab0039, 0x6fec0044, 0x00000000, 0x00000000}},  //   _dygn, _কাগজ_,   ,
  { {0x60f8008b, 0x7c260268, 0x26170963, 0x00000000}},  //   эння_, _obkr, _नाती_,
  { {0x64a3007e, 0x6f0f0197, 0xdddc0964, 0x00000000}},  //   _каха, tucc, virš,
  { {0x26cc0093, 0xd36f0379, 0x6f1d010f, 0x00000000}},  //   _kido_, _وهم_, utsc,
  { {0x6f0f029a, 0x6f1d001f, 0x2c750018, 0x00000000}},  //   rucc, rtsc, _måde_,
  { {0x6288029d, 0x6f1d010f, 0xeca700ed, 0x00000000}},  //   mido, stsc, вјан,
  { {0x26cc0089, 0x6f1d01a2, 0x2005007f, 0x00000000}},  //   _lido_, ptsc, ėlis_,
  { {0x201e005f, 0x44260965, 0x26cc008e, 0x00000000}},  // [cd0] əti_, _mbo_, _oido_,
  { {0x62880966, 0x2ba70183, 0xadbd008b, 0x00000000}},  //   nido, _कुणा, _напi,
  { {0x67290030, 0x49a406e3, 0x60cd033b, 0x00000000}},  //   _spej, ајца, _kiam,
  { {0x2c75044f, 0x24580027, 0x442600bb, 0x00000000}},  //   _både_, _témy_, _nbo_,
  { {0x60cd0967, 0x62880968, 0x160e0061, 0x00000000}},  //   _miam, kido, _साखर_,
  { {0x98b301f6, 0xa3ac0183, 0x442600ac, 0x00000000}},  //   ıdır_, _गरज_, _abo_,
  { {0x6288029d, 0x63ab0036, 0x7c3d0969, 0x00000000}},  //   dido, _sygn, _kasr,
  { {0x60cd096a, 0x9f52000a, 0x67290066, 0x00000000}},  //   _niam, _feyè_, _tpej,
  { {0x26cc0197, 0x7c3d014a, 0x5884007e, 0x00000000}},  //   _fido_, _masr, _тыра,
  { {0x6288096b, 0x4426096c, 0x7c3d096d, 0x00000000}},  //   gido, _ebo_, _lasr,
  { {0x60cd096e, 0x659400e2, 0x64150025, 0x00000000}},  //   _biam, _кафу, _مواط,
  { {0x7c3d096f, 0x60cd0970, 0xdee60088, 0x00000000}},  //   _nasr, _ciam, ломи,
  { {0x6288029d, 0x60cd0971, 0x443f0972, 0x00000000}},  //   bido, _diam, mdu_,
  { {0x443f0756, 0x62880489, 0x62830973, 0x00000000}},  //   ldu_, cido, _umno,
  { {0x443f010a, 0x60cd0207, 0x443d0760, 0x00000000}},  //   odu_, _fiam, _kaw_,
  { {0x443f0974, 0x60cd0197, 0x443d0652, 0x00000000}},  //   ndu_, _giam, _jaw_,
  { {0x4bd90373, 0x443d0016, 0x3b07026b, 0x00000000}},  // [ce0] ться_, _maw_, лето_,
  { {0x443d0975, 0xfaaa0014, 0x443f0976, 0x00000000}},  //   _law_, رهاي_, hdu_,
  { {0x9f520263, 0x090601a4, 0x26cc01aa, 0x00000000}},  //   _seyè_, упен, _rido_,
  { {0x3860009f, 0x26cc0977, 0x62880978, 0x00000000}},  //   ðir_, _sido_, zido,
  { {0x443f0979, 0x26cc097a, 0x7c240035, 0x00000000}},  //   ddu_, _pido_, mfir,
  { {0x0f3700b6, 0x6288049a, 0x443f097b, 0x00000000}},  //   טרנט_, xido, edu_,
  { {0x62880181, 0x26cc097c, 0x443d00be, 0x00000000}},  //   vido, _vido_, _baw_,
  { {0xdd04010a, 0x7c240335, 0x26cc0022, 0x00000000}},  //   ūrėt, nfir, _wido_,
  { {0x443d097d, 0x62880576, 0x60cd002a, 0x00000000}},  //   _daw_, tido, _riam,
  { {0x60cd0198, 0x443f0016, 0x78bb097e, 0x00000000}},  //   _siam, adu_, _zhuv,
  { {0x6288029d, 0x443f097f, 0x443d0980, 0x00000000}},  //   rido, bdu_, _faw_,
  { {0xf53700b6, 0x62880981, 0x443d00e0, 0x00000000}},  //   _תנאי_, sido, _gaw_,
  { {0x628800b0, 0x64400045, 0x9f590023, 0x00000000}},  //   pido, mdmi, masë_,
  { {0x6440000c, 0x6e3e0982, 0x7c3d016c, 0x00000000}},  //   ldmi, _capb, _sasr,
  { {0x7c240983, 0x61fa005f, 0x60cd00d4, 0x00000000}},  //   ffir, matl, _tiam,
  { {0x61fa0984, 0x6440006c, 0xaed500ed, 0x00000000}},  //   latl, ndmi, _коиш,
  { {0x50b80318, 0x6e950985, 0x6d4a000c, 0x00000000}},  // [cf0] _حدود_, _випу, _áfan,
  { {0x61fa0890, 0xda780986, 0xdb240010, 0x00000000}},  //   natl, лях_, ásán,
  { {0x628f009d, 0x443f005d, 0x7c3d0022, 0x00000000}},  //   écoi, ydu_, _tasr,
  { {0x2617001c, 0x61fa0279, 0x443f006b, 0x00000000}},  //   _नाही_, hatl, xdu_,
  { {0xe73905b5, 0x443f0987, 0x07a502a8, 0x00000000}},  //   тел_, vdu_, јалн,
  { {0xa5090121, 0x443f0988, 0x61fa00ca, 0x00000000}},  //   века_, wdu_, jatl,
  { {0x61fa0989, 0x443d0173, 0x3e74006c, 0x00000000}},  //   datl, _paw_, _jäta_,
  { {0x443f098a, 0xc6060044, 0x3e74098b, 0x00000000}},  //   udu_, ল্লা_, _mäta_,
  { {0xfc3f0359, 0x443f011f, 0xa3a803d7, 0x00000000}},  //   _maí_, rdu_, _खुद_,
  { {0xc6a7098c, 0x61fa0047, 0x64400056, 0x00000000}},  //   _срби, gatl, admi,
  { {0x443d098d, 0x7c24000c, 0x6e3e0093, 0x00000000}},  //   _taw_, yfir, _rapb,
  { {0x44f3001a, 0x3f6a003b, 0x00000000, 0x00000000}},  //   mţ_, вимо_,   ,
  { {0x61fa006b, 0xa3c10061, 0x00000000, 0x00000000}},  //   batl, ंधळ_,   ,
  { {0x200c005f, 0x61fa01ee, 0x00000000, 0x00000000}},  //   şdi_, catl,   ,
  { {0x7c24098e, 0x8d63013b, 0xa3dc0061, 0x00000000}},  //   tfir, овре, तुक_,
  { {0xb05b0073, 0x9ce5007e, 0xfc3f098f, 0x00000000}},  //   lmän, сцёл, _caí_,
  { {0x7c240990, 0xfc3f0181, 0x63880089, 0x00000000}},  // [d00] rfir, _daí_, cīnī,
  { {0x7c24006c, 0xab27005e, 0x7bdf0197, 0x00000000}},  //   sfir, рофа_, acqu,
  { {0xd00f089d, 0x19b9008b, 0x7c240991, 0x00000000}},  //   _علی_, гуць_, pfir,
  { {0x8c46025f, 0x61fa0010, 0xa01b00b0, 0x00000000}},  //   _теме, zatl, tiöi,
  { {0x27e90211, 0x61fa047f, 0xbb430088, 0x00000000}},  //   ñana_, yatl, _деяк,
  { {0x3cfe0295, 0xbb4300ed, 0x248601d6, 0x00000000}},  //   štvu_, _ќерк, _smom_,
  { {0xd49a00aa, 0x2617006e, 0x5e570049, 0x00000000}},  //   кри_, _नारी_, ייסע_,
  { {0x98a30088, 0x00000000, 0x00000000, 0x00000000}},  //   _дисе,   ,   ,
  { {0xc178010a, 0x61fa0992, 0x9f590023, 0x00000000}},  //   ybės_, tatl, rasë_,
  { {0x09ca0044, 0x67220993, 0x00000000, 0x00000000}},  //   _ল্যা, mtoj,   ,
  { {0x272001aa, 0x61fa0994, 0x6722042c, 0x00000000}},  //   lòn_, ratl, ltoj,
  { {0x6722010a, 0x44320082, 0x61fa0994, 0x00000000}},  //   otoj, _úy_, satl,
  { {0x67220995, 0x61fa0996, 0x3ce6016c, 0x00000000}},  //   ntoj, patl, _čova_,
  { {0xea0000ad, 0x67220997, 0x7ae9014a, 0x00000000}},  //   _đến_, itoj, _çeti,
  { {0xb2bb00b6, 0x67220998, 0x307b0025, 0x00000000}},  //   _שמור, htoj, _لحظة_,
  { {0x2c750039, 0x67220065, 0x5c740999, 0x00000000}},  //   _båda_, ktoj, олст,
  { {0x67220065, 0x27200173, 0xa9e70025, 0x00000000}},  // [d10] jtoj, jòn_, لثان,
  { {0x4a540131, 0x00000000, 0x00000000, 0x00000000}},  //   окус,   ,   ,
  { {0xdd910137, 0x06e60044, 0x61f8014a, 0x00000000}},  //   _روح_, _নিষি, _mevl,
  { {0x3157007b, 0x2019099a, 0x673b099b, 0x00000000}},  //   ייבן_, ngsi_, _psuj,
  { {0x25b2006b, 0x2720099c, 0x00000000, 0x00000000}},  //   əyli_, gòn_,   ,
  { {0xbb3a007b, 0x61f8099d, 0x78a20428, 0x00000000}},  //   _געשי, _nevl, čova,
  { {0x28f8041f, 0x1994004d, 0x00000000, 0x00000000}},  //   _весь_, _даря,   ,
  { {0xcd9800a0, 0x29010020, 0x272001aa, 0x00000000}},  //   ידות_, msha_, bòn_,
  { {0x61f80116, 0x00000000, 0x00000000, 0x00000000}},  //   _bevl,   ,   ,
  { {0x38bc0051, 0x27fd005b, 0x290100e7, 0x00000000}},  //   ríre_, lawn_, osha_,
  { {0x61f8099e, 0xa06a003b, 0x290104e7, 0x00000000}},  //   _devl, гана_, nsha_,
  { {0xf992009b, 0x290100e7, 0xb05b099f, 0x00000000}},  //   לרי_, isha_, smän,
  { {0x248d001e, 0x7641011c, 0x72050014, 0x00000000}},  //   miem_, _kaly, _هوشم,
  { {0x248d0089, 0x61f800c7, 0x27fd0016, 0x00000000}},  //   liem_, _gevl, hawn_,
  { {0x01c50044, 0x764105e1, 0x91680082, 0x00000000}},  //   _শ্রদ, _maly, _tức_,
  { {0x248d09a0, 0x6722010a, 0xb05b0039, 0x00000000}},  //   niem_, ytoj, nmäl,
  { {0xf1bf00b9, 0x290100e0, 0xd5b10082, 0x00000000}},  // [d20] řád_, esha_, _lý_,
  { {0x6f040166, 0x248d09a1, 0x764100ea, 0x00000000}},  //   _ivic, hiem_, _naly,
  { {0xfe3700b6, 0x248d09a2, 0xdca601ee, 0x00000000}},  //   _פרטי_, kiem_, _гани,
  { {0x248d001e, 0x91fc001e, 0x17fa0025, 0x00000000}},  //   jiem_, nkār, اراة_,
  { {0x501b01f8, 0x248d001e, 0x67220997, 0x00000000}},  //   רונו, diem_, utoj,
  { {0x67220006, 0x1ae305f6, 0x7c3609a3, 0x00000000}},  //   rtoj, _хорм, leyr,
  { {0x672206a6, 0x7641010a, 0x9f59009d, 0x00000000}},  //   stoj, _daly, rasé_,
  { {0x248d09a4, 0x67220065, 0xb1760011, 0x00000000}},  //   giem_, ptoj, _ngượ,
  { {0xa3a8006e, 0x61f8012d, 0x76410288, 0x00000000}},  //   _खुश_, _pevl, _faly,
  { {0x06650014, 0x7641007f, 0xda7b0049, 0x00000000}},  //   _والپ, _galy, ָנטר,
  { {0xd0110076, 0x909900ed, 0x248d0089, 0x00000000}},  //   ولد_, ивот_, biem_,
  { {0x248d02ff, 0x00000000, 0x00000000, 0x00000000}},  //   ciem_,   ,   ,
  { {0x3e970025, 0x5f94005e, 0x6e350032, 0x00000000}},  //   مؤسس, зият, tezb,
  { {0x64420051, 0x29010058, 0x539b009b, 0x00000000}},  //   _haoi, ysha_, _גידו,
  { {0x90e6031d, 0x7c36000c, 0x628a004a, 0x00000000}},  //   _استن, feyr, _imfo,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x5eb80055, 0x64420051, 0x20090697, 0x00000000}},  // [d30] _ইংরে, _maoi, _idai_,
  { {0x7f4d006b, 0x290109a5, 0x248d09a6, 0x00000000}},  //   _iraq, tsha_, ziem_,
  { {0x6f040065, 0xa01b09a7, 0xb05b00b0, 0x00000000}},  //   _zvic, rhöf, ymäl,
  { {0x6d40001e, 0xdb0f00f4, 0x764109a8, 0x00000000}},  //   āmat, _lycé, _saly,
  { {0x76410006, 0x248d09a9, 0x29010066, 0x00000000}},  //   _paly, viem_, ssha_,
  { {0x7aed020c, 0xf1c802d2, 0x248d09aa, 0x00000000}},  //   mpat, रधान, wiem_,
  { {0x248d001e, 0x9f40009f, 0x764109ab, 0x00000000}},  //   tiem_, _leið_, _valy,
  { {0x130907ca, 0x7b08009f, 0x64420051, 0x00000000}},  //   аний_, _ástæ, _caoi,
  { {0x6442002a, 0x7aed09ac, 0x248d09a9, 0x00000000}},  //   _daoi, npat, riem_,
  { {0x248d001e, 0x7aed09ad, 0x20090020, 0x00000000}},  //   siem_, ipat, _adai_,
  { {0x6442002a, 0x645d010f, 0x248d0089, 0x00000000}},  //   _faoi, ösis, piem_,
  { {0xf48500a1, 0x437509ae, 0x9fca026b, 0x00000000}},  //   _بائی, _мулт, игна_,
  { {0xe28e008b, 0x7f4d09af, 0x083a0049, 0x00000000}},  //   _жа_, _craq, בערל,
  { {0x7aed00d2, 0x7f4d0026, 0xc5f90049, 0x00000000}},  //   dpat, _draq, יפֿט,
  { {0xa01b09b0, 0x6442004a, 0x00000000, 0x00000000}},  //   giös, _yaoi,   ,
  { {0x7d05001c, 0x7f4d09b1, 0x7aed00d9, 0x00000000}},  //   _dvhs, _fraq, fpat,
  { {0x7c36000c, 0x7aed011c, 0x68e900ca, 0x00000000}},  // [d40] reyr, gpat, _čeda,
  { {0x25a00095, 0x00000000, 0x00000000, 0x00000000}},  //   şili_,   ,   ,
  { {0xed5a09b2, 0x64970089, 0x6ee500a2, 0x00000000}},  //   _тон_, rģij, _وسیل,
  { {0x7aed09b3, 0xd7ef0025, 0xcfad0044, 0x00000000}},  //   bpat, نكم_, _গণতন,
  { {0x8af0006b, 0x7aed06ed, 0xa01b09b4, 0x00000000}},  //   yyəy, cpat, shög,
  { {0x6442002a, 0x6b63007e, 0x00000000, 0x00000000}},  //   _saoi, _ўкра,   ,
  { {0x385a09b5, 0x69230478, 0xd839000a, 0x00000000}},  //   _краю_, _омра, _djōb_,
  { {0x387d005b, 0x00000000, 0x00000000, 0x00000000}},  //   chwr_,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x026a0088, 0x3f8209b6, 0x862b009e, 0x00000000}},  //   рший_, dzku_, _نغمہ_,
  { {0x3a37034e, 0x2ee904cb, 0x64420051, 0x00000000}},  //   חרים_, _staf_, _taoi,
  { {0x232a0517, 0x7aed04a5, 0xb05b00b0, 0x00000000}},  //   _води_, ypat, mmäk,
  { {0xe29a012b, 0xb05b00b0, 0x00000000, 0x00000000}},  //   _кад_, lmäk,   ,
  { {0x29070047, 0x9f5b0023, 0x63a20288, 0x00000000}},  //   ának_, _heqë_, _ixon,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xa01b09b7, 0xe5710049, 0x69d80006, 0x00000000}},  //   riös, ײַל_, žvel,
  { {0x629a0009, 0x9f5b0065, 0x6d480039, 0x00000000}},  // [d50] onto, _meqë_, ådar,
  { {0x7aed09b8, 0x629a00ea, 0x00000000, 0x00000000}},  //   rpat, nnto,   ,
  { {0xa3ca0061, 0x629a00b0, 0x387d005b, 0x00000000}},  //   ळेत_, into, thwr_,
  { {0x7aed01bc, 0x7c590025, 0x00000000, 0x00000000}},  //   ppat, _الحر_,   ,
  { {0xfc5a009b, 0x00000000, 0x00000000, 0x00000000}},  //   _הכרמ,   ,   ,
  { {0x26c70618, 0x00000000, 0x00000000, 0x00000000}},  //   umno_,   ,   ,
  { {0x2d830036, 0x63a20133, 0x00000000, 0x00000000}},  //   nzje_, _axon,   ,
  { {0x629a0142, 0x00000000, 0x00000000, 0x00000000}},  //   ento,   ,   ,
  { {0x383401ff, 0xf77309b9, 0xafdb00ea, 0x00000000}},  //   _інфр, _غار_, gdøm,
  { {0x629a0146, 0xb05b04ec, 0x00000000, 0x00000000}},  //   gnto, lmäh,   ,
  { {0x27e00087, 0x85050167, 0x91fc0089, 0x00000000}},  //   žine_, _روشن, rkāp,
  { {0x8fa60783, 0x55ba009b, 0x61ee006b, 0x00000000}},  //   заме, _המעו, ıbla,
  { {0xc3190055, 0xe80c0061, 0x442f09ba, 0x00000000}},  //   _তৈরি_, हणता_, _ibg_,
  { {0x442f0203, 0x13a9009e, 0x00000000, 0x00000000}},  //   _hbg_, _پنڈی_,   ,
  { {0xdd920137, 0x00000000, 0x00000000, 0x00000000}},  //   رور_,   ,   ,
  { {0xda1e0061, 0x442f0091, 0xaf0609bb, 0x00000000}},  //   _पाहत_, _jbg_, _епил,
  { {0x3aeb09bc, 0x200209bd, 0x207b01ce, 0x00000000}},  // [d60] مبلی_, maki_, _לאקא,
  { {0x20020127, 0xdb060036, 0xa6e90082, 0x00000000}},  //   laki_, _szkó, _khươ,
  { {0xceb300bd, 0x4ddb009b, 0xe8530014, 0x00000000}},  //   _איז_, _לחיו, کنند,
  { {0x38cb01ef, 0x20020052, 0xdca600ed, 0x00000000}},  //   مانی_, naki_, _хами,
  { {0x629a09be, 0x60c400e7, 0x00000000, 0x00000000}},  //   ynto, _mhim,   ,
  { {0x442f003f, 0xd6d90088, 0x200209bf, 0x00000000}},  //   _abg_, іті_, haki_,
  { {0xe9a309c0, 0x442f0173, 0x20020145, 0x00000000}},  //   _зарп, _bbg_, kaki_,
  { {0x399b00b6, 0x20020059, 0x442f09c1, 0x00000000}},  //   _הילד, jaki_, _cbg_,
  { {0x2002011f, 0x6b84010f, 0x291a0161, 0x00000000}},  //   daki_, nzig, lupa_,
  { {0x2a6a09c2, 0xb05b021e, 0x877b00b3, 0x00000000}},  //   _jobb_, mmäi, _האמי,
  { {0x2497007a, 0xa6e9001d, 0x2bb90309, 0x00000000}},  //   _کنند_, _chươ, _आर्थ,
  { {0x27e6008e, 0x60c409c3, 0x2a6a0066, 0x00000000}},  //   ncon_, _chim, _lobb_,
  { {0x6b8402ae, 0x60c40065, 0x291a0058, 0x00000000}},  //   jzig, _dhim, hupa_,
  { {0x291a09c4, 0x60c4000a, 0x539b0097, 0x00000000}},  //   kupa_, _ehim, _פיגו,
  { {0x200209c5, 0x68e909c6, 0x60c40066, 0x00000000}},  //   baki_, _čedo, _fhim,
  { {0x30a4008b, 0x60c40035, 0x291a0022, 0x00000000}},  //   _прыв, _ghim, dupa_,
  { {0x3f9e014a, 0x2a6a01ee, 0x7c2f0082, 0x00000000}},  // [d70] ştur_, _bobb_, _vbcr,
  { {0x6d4107a8, 0x291a09c7, 0x2a6a0133, 0x00000000}},  //   ælas, fupa_, _cobb_,
  { {0x29070884, 0x27e60087, 0x291a0058, 0x00000000}},  //   éna_, fcon_, gupa_,
  { {0x3869009f, 0x6a7301df, 0x00000000, 0x00000000}},  //   ðar_, _sıfı,   ,
  { {0x7c2d000c, 0x6497001a, 0xf72b007e, 0x00000000}},  //   mfar, nţie, сцей_,
  { {0x200209c8, 0x442f01a3, 0x7c2d09c9, 0x00000000}},  //   zaki_, _sbg_, lfar,
  { {0xa9340822, 0x20020058, 0x291a0207, 0x00000000}},  //   _перш, yaki_, cupa_,
  { {0x7c2d000c, 0x200200c4, 0x00000000, 0x00000000}},  //   nfar, xaki_,   ,
  { {0x200209ca, 0x7c2d09cb, 0x00000000, 0x00000000}},  //   vaki_, ifar,   ,
  { {0xa6e9001d, 0x60c401a3, 0x200209cc, 0x00000000}},  //   _phươ, _shim, waki_,
  { {0x660300b0, 0x20020020, 0x60c40082, 0x00000000}},  //   mank, taki_, _phim,
  { {0x60d6005f, 0x660309cd, 0xf4b60014, 0x00000000}},  //   _qiym, lank, _قشنگ,
  { {0x6449018e, 0x64590270, 0x7c2d0190, 0x00000000}},  //   mdei, _inwi, dfar,
  { {0x20020089, 0x442d001f, 0xa6e9001d, 0x00000000}},  //   saki_, lfe_, _thươ,
  { {0x2002011c, 0x7c2d02e5, 0x60c40048, 0x00000000}},  //   paki_, ffar, _thim,
  { {0x64490004, 0x442d0129, 0x6b8409ce, 0x00000000}},  //   ndei, nfe_, tzig,
  { {0x660309cf, 0x06e30044, 0x3e74006c, 0x00000000}},  // [d80] kank, নীতি, _läti_,
  { {0x291a0020, 0x224701f3, 0x20000087, 0x00000000}},  //   tupa_, _jank_, _heii_,
  { {0x660309d0, 0x2ee009d1, 0x224701aa, 0x00000000}},  //   dank, _ভবিষ, _mank_,
  { {0x291a09d2, 0x224709d3, 0x7d1c050f, 0x00000000}},  //   rupa_, _lank_, murs,
  { {0x442d0009, 0x073a0355, 0xc6f70245, 0x00000000}},  //   dfe_, تساب_, дніх_,
  { {0x660300b5, 0x6e3c09d4, 0x442d01a2, 0x00000000}},  //   gank, nerb, efe_,
  { {0x442d0109, 0x69dc0181, 0x27e60283, 0x00000000}},  //   ffe_, _igre, pcon_,
  { {0x3ae40073, 0x6e3c05de, 0x22470022, 0x00000000}},  //   _köp_, herb, _aank_,
  { {0x6603000c, 0x6e3c01d6, 0x224709d5, 0x00000000}},  //   bank, kerb, _bank_,
  { {0x7d1c0110, 0x6e3c01ee, 0x6459005b, 0x00000000}},  //   kurs, jerb, _enwi,
  { {0x6e3c0039, 0x224709d6, 0x7c2d0016, 0x00000000}},  //   derb, _dank_, yfar,
  { {0x7d1c000c, 0x38660203, 0x1c1d007d, 0x00000000}},  //   durs, njor_, _फाइल_,
  { {0x69dc066e, 0x6e3c010f, 0x764809d7, 0x00000000}},  //   _ogre, ferb, _kady,
  { {0x62810161, 0x6e3c0030, 0x69dc0065, 0x00000000}},  //   chlo, gerb, _ngre,
  { {0xf1aa007a, 0xc3480011, 0xec6b003b, 0x00000000}},  //   _باشه_, _hổ_, орак_,
  { {0x660309d8, 0x69dc09d9, 0x6e3c0026, 0x00000000}},  //   zank, _agre, aerb,
  { {0x3ec70373, 0x6e3c02fa, 0x6d4e0009, 0x00000000}},  // [d90] _особ, berb, avba,
  { {0x27ff0343, 0x68fc018e, 0x7c2d0197, 0x00000000}},  //   _seun_, _bwrd, sfar,
  { {0x7d1c00d6, 0x6603003b, 0x481509da, 0x00000000}},  //   curs, vank, емес,
  { {0x765a09db, 0x6d450020, 0x69dc008e, 0x00000000}},  //   _anty, _isha, _egre,
  { {0x660309dc, 0xc3480011, 0x76480058, 0x00000000}},  //   tank, _nổ_, _bady,
  { {0x68fc0016, 0x00000000, 0x00000000, 0x00000000}},  //   _fwrd,   ,   ,
  { {0x442d00f6, 0x27e002db, 0x224709dd, 0x00000000}},  //   tfe_, žina_, _rank_,
  { {0x934509de, 0xc3480011, 0x6d450020, 0x00000000}},  //   ение, _bổ_, _msha,
  { {0xc348001d, 0x64490016, 0x660300b0, 0x00000000}},  //   _cổ_, rdei, pank,
  { {0x27290211, 0xe1f10025, 0x6f1d0210, 0x00000000}},  //   mún_, دسة_, dusc,
  { {0x27290051, 0x6d4509df, 0x386d006c, 0x00000000}},  //   lún_, _nsha, _koer_,
  { {0x6e3c001f, 0x7f4400d6, 0x6f1d0026, 0x00000000}},  //   werb, _psiq, fusc,
  { {0x660109e0, 0x6d4500f0, 0xda0f0061, 0x00000000}},  //   _kelk, _asha, ाणात_,
  { {0x249f000c, 0x660109e1, 0x386d0007, 0x00000000}},  //   lnum_, _jelk, _loer_,
  { {0x387f01f6, 0x7afd09e2, 0x6601021e, 0x00000000}},  //   _olur_, _awst, _melk,
  { {0x249f009f, 0x6e3c002d, 0x66010010, 0x00000000}},  //   nnum_, serb, _lelk,
  { {0x7d1c09e3, 0x6e3c033b, 0xc3480011, 0x00000000}},  // [da0] surs, perb, _xổ_,
  { {0x6d45008d, 0x32050062, 0x387f09e4, 0x00000000}},  //   _fsha, naly_, _alur_,
  { {0x386d0007, 0x387f04e2, 0x764809e5, 0x00000000}},  //   _boer_, _blur_, _rady,
  { {0x7648011c, 0x7afd0544, 0x07a609e6, 0x00000000}},  //   _sady, _fwst, наен,
  { {0x27290958, 0x61360047, 0x6601014a, 0x00000000}},  //   gún_, _külö, _belk,
  { {0x66010428, 0x69dc0107, 0xc3480011, 0x00000000}},  //   _celk, _ugre, _rổ_,
  { {0x2ca009e7, 0xc348001d, 0x249f009f, 0x00000000}},  //   onid_, _sổ_, fnum_,
  { {0x249f009f, 0x545409e8, 0x95530076, 0x00000000}},  //   gnum_, твит, اخوا,
  { {0xc7a30331, 0x660109e9, 0xb05b0039, 0x00000000}},  //   _битк, _felk, lläg,
  { {0x2c7c008e, 0x320505f0, 0x2ca00048, 0x00000000}},  //   _oído_, galy_, hnid_,
  { {0xb05b0039, 0x5a170049, 0xd6cf006d, 0x00000000}},  //   nläg, עקטן_, _اقل_,
  { {0xc348001d, 0xbebb0065, 0x6f1d0210, 0x00000000}},  //   _tổ_, ntëv, tusc,
  { {0x44260061, 0xb05b010f, 0x32050062, 0x00000000}},  //   _ico_, hläg, baly_,
  { {0x6f1d09ea, 0xa01b010f, 0x7c2609eb, 0x00000000}},  //   rusc, chön, _ackr,
  { {0xac95058d, 0x2ca0012d, 0xfe6e0014, 0x00000000}},  //   вавш, fnid_, تگي_,
  { {0xdcb80265, 0x6f1d001a, 0x9404006b, 0x00000000}},  //   ещу_, pusc, timə_,
  { {0x6497001a, 0x00d800f3, 0x92de0044, 0x00000000}},  // [db0] nţia, _ثبوت_, _তবু_,
  { {0xdb260014, 0x2ca0006c, 0x9404006b, 0x00000000}},  //   ئولی, anid_, rimə_,
  { {0x6d45000b, 0x387f0870, 0x94200061, 0x00000000}},  //   _usha, _plur_, _यांच_,
  { {0x660100b0, 0xb06600b0, 0x272909ec, 0x00000000}},  //   _selk, mpää, tún_,
  { {0xf7450898, 0x386d00c7, 0x6601021e, 0x00000000}},  //   тело, _voer_, _pelk,
  { {0x272909ed, 0xe9d300a2, 0xbebb0023, 0x00000000}},  //   rún_, _مغز_, atëv,
  { {0x66010224, 0x320509ee, 0x386d0007, 0x00000000}},  //   _velk, valy_, _toer_,
  { {0x6601015c, 0x442600f6, 0x387f09ef, 0x00000000}},  //   _welk, _cco_, _ulur_,
  { {0x249f000c, 0x320504b8, 0xd84200b9, 0x00000000}},  //   rnum_, taly_, áčů_,
  { {0x4426027b, 0x249f000c, 0x425500e2, 0x00000000}},  //   _eco_, snum_, ттит,
  { {0xb05b09f0, 0x442600d6, 0x249f000c, 0x00000000}},  //   kläd, _fco_, pnum_,
  { {0x3e740039, 0xdee6007c, 0xcea90104, 0x00000000}},  //   _lätt_, коми, _וי_,
  { {0x443f0129, 0xab5b0010, 0x10a309f1, 0x00000000}},  //   meu_, _szün, риян,
  { {0x443f096b, 0x644b0129, 0x6da6051f, 0x00000000}},  //   leu_, _hagi, вига,
  { {0x6f0d0035, 0x644b011c, 0x27ed01a2, 0x00000000}},  //   _evac, _kagi, _ofen_,
  { {0x443f0129, 0x7f860025, 0x6f960025, 0x00000000}},  //   neu_, _للبن, _للعض,
  { {0x644b006a, 0x7c2b09f2, 0x443f00d4, 0x00000000}},  // [dc0] _magi, ògra, ieu_,
  { {0x644b09f3, 0x443f0065, 0xaa7b000c, 0x00000000}},  //   _lagi, heu_, _stýr,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x644b006a, 0x63a4009f, 0x7f560065, 0x00000000}},  //   _nagi, _þing, _kryq,
  { {0x443f04bd, 0x27e009f4, 0xb05b0039, 0x00000000}},  //   deu_, žino_, släg,
  { {0x7c240006, 0x7bc601d9, 0xbebb0065, 0x00000000}},  //   lgir, _izku, stëv,
  { {0x92de0055, 0xc5d50055, 0x644b0149, 0x00000000}},  //   _তবে_, _স্বপ, _bagi,
  { {0x7c2409f5, 0x38c801ef, 0x443f0129, 0x00000000}},  //   ngir, _سازی_, geu_,
  { {0x644b09f6, 0x44260093, 0xb05b00f8, 0x00000000}},  //   _dagi, _vco_, kmär,
  { {0x78a20062, 0x7c24000a, 0x64970035, 0x00000000}},  //   lnov, hgir, rţia,
  { {0x443f09f7, 0x6f0d09f8, 0x644b09f9, 0x00000000}},  //   beu_, _svac, _fagi,
  { {0x0446045e, 0x443f02d5, 0x78a209fa, 0x00000000}},  //   _једн, ceu_, nnov,
  { {0x6440014a, 0x7c24017b, 0x442406e9, 0x00000000}},  //   memi, dgir, mgm_,
  { {0x6497001a, 0x442409fb, 0x7c240032, 0x00000000}},  //   nţin, lgm_, egir,
  { {0x3e740073, 0x644b0061, 0xac2700ed, 0x00000000}},  //   _rätt_, _yagi, кфак,
  { {0x78a209fc, 0x644009fd, 0x3e740073, 0x00000000}},  //   jnov, nemi, _sätt_,
  { {0x5a350200, 0xbebb0065, 0xb05b09fe, 0x00000000}},  // [dd0] лнат, ftët, smäs,
  { {0x644009ff, 0x443f000d, 0xdce70036, 0x00000000}},  //   hemi, zeu_, zyję,
  { {0x7bc6002d, 0x443f0011, 0x64400a00, 0x00000000}},  //   _ezku, yeu_, kemi,
  { {0x443f0a01, 0x78a20062, 0x64870a02, 0x00000000}},  //   xeu_, gnov, _iñig,
  { {0x644b0a03, 0x443f09f7, 0x8c1a0104, 0x00000000}},  //   _ragi, veu_, _אורי,
  { {0x644b0a04, 0x332d0066, 0x00000000, 0x00000000}},  //   _sagi, vtex_,   ,
  { {0x644b0a05, 0x443f0a06, 0x6440009d, 0x00000000}},  //   _pagi, teu_, femi,
  { {0x69c70059, 0x64400004, 0x332d01d5, 0x00000000}},  //   _izje, gemi, ttex_,
  { {0x443f0a07, 0x91e500d7, 0x2cb90022, 0x00000000}},  //   reu_, лопе, _mksd_,
  { {0x443f0a08, 0x644b0a09, 0x332d0133, 0x00000000}},  //   seu_, _wagi, rtex_,
  { {0xe4e701fb, 0x644b0039, 0x443f0a0a, 0x00000000}},  //   _різн, _tagi, peu_,
  { {0xa3550151, 0xbebb0065, 0x644b00e7, 0x00000000}},  //   _مختص, ktës, _uagi,
  { {0xbebb008d, 0x6d57006b, 0x6d4101df, 0x00000000}},  //   jtës, _arxa, çlan,
  { {0x78a20059, 0x539a00a3, 0xdee302dc, 0x00000000}},  //   znov, _אינו, сори,
  { {0x6497001a, 0x7c240a0b, 0x78a20a0c, 0x00000000}},  //   nţio, tgir, ynov,
  { {0xb05b0004, 0xdd8f0025, 0xbebb0023, 0x00000000}},  //   smär, سوق_, ftës,
  { {0xb05b0039, 0x69c70066, 0x5f460014, 0x00000000}},  // [de0] pmär, _azje, _صندل,
  { {0x7c2400f8, 0x64400036, 0x8af0006b, 0x00000000}},  //   sgir, zemi, vvəd,
  { {0x64400a0d, 0x7c2400d4, 0xdce80089, 0x00000000}},  //   yemi, pgir, ēlēt,
  { {0xe3a7007a, 0x64400288, 0x66e60816, 0x00000000}},  //   _هر_, xemi, года,
  { {0x78a20142, 0x64400a0e, 0x2bba0025, 0x00000000}},  //   rnov, vemi, _ساحة_,
  { {0x78a20a0f, 0x09e30256, 0x00000000, 0x00000000}},  //   snov, _горн,   ,
  { {0x6440011f, 0xafdb05b7, 0x6497001a, 0x00000000}},  //   temi, ndør, rţin,
  { {0x6497001a, 0x62830a10, 0xe31400e2, 0x00000000}},  //   sţin, _alno, амињ,
  { {0x6d580a11, 0xf20607e1, 0x00000000, 0x00000000}},  //   _šval, ляно,   ,
  { {0x7ae6008a, 0x67220006, 0x86c60025, 0x00000000}},  //   _mukt, muoj, _صيان,
  { {0x27e90059, 0x6440023a, 0x7ae60039, 0x00000000}},  //   žane_, pemi, _lukt,
  { {0xf993019b, 0x6497001a, 0x26de004a, 0x00000000}},  //   מרת_, nţil, _hito_,
  { {0x6722010a, 0xf4870167, 0x26de0006, 0x00000000}},  //   nuoj, _حالی, _kito_,
  { {0xc7b30104, 0xb05b0788, 0x0cbf0309, 0x00000000}},  //   מבר_, fläc, ्ष्म,
  { {0x7ae600eb, 0x26de0207, 0x6ca70a12, 0x00000000}},  //   _aukt, _mito_, граж,
  { {0x629a0a13, 0x26de025e, 0x1f750242, 0x00000000}},  //   lito, _lito_, _влия,
  { {0x200b09c6, 0x26de0181, 0x60cd0058, 0x00000000}},  // [df0] maci_, _oito_, _iham,
  { {0x44ea028c, 0x200b00b9, 0x26de006a, 0x00000000}},  //   _où_, laci_, _nito_,
  { {0x81b60044, 0x60cd01a3, 0xbebb0065, 0x00000000}},  //   চের_, _kham, stës,
  { {0x200b0a14, 0x89340054, 0xa5650014, 0x00000000}},  //   naci_, إعلا, یگان,
  { {0x629a0020, 0x67220006, 0x26de0146, 0x00000000}},  //   kito, guoj, _bito_,
  { {0x629a000b, 0x8704007c, 0x44ea0011, 0x00000000}},  //   jito, сяце, _bù_,
  { {0x26de006a, 0x6f1d010f, 0x200b00b9, 0x00000000}},  //   _dito_, hrsc, kaci_,
  { {0x200b0868, 0x44ea001d, 0x628800b0, 0x00000000}},  //   jaci_, _dù_, ehdo,
  { {0x6b8d0a15, 0xc4820088, 0x200b05c5, 0x00000000}},  //   nzag, ільк, daci_,
  { {0x68e70065, 0x6595007e, 0x629a01b1, 0x00000000}},  //   _kujd, _казу, gito,
  { {0x7643010a, 0x4254007e, 0x200b0a16, 0x00000000}},  //   meny, стыт, faci_,
  { {0x60cd0a17, 0x200b00b9, 0x76430a18, 0x00000000}},  //   _cham, gaci_, leny,
  { {0x60cd000b, 0xe1ee0920, 0xdee6007c, 0x00000000}},  //   _dham, _мг_, роги,
  { {0x629a0142, 0x6288059c, 0x78a90243, 0x00000000}},  //   cito, chdo, _ljev,
  { {0x75230a19, 0x78bb0009, 0x67220006, 0x00000000}},  //   nunz, _okuv, zuoj,
  { {0x60cd002b, 0x200b0197, 0x76430010, 0x00000000}},  //   _gham, caci_, heny,
  { {0x76430a1a, 0x4e1a007c, 0xbebb0065, 0x00000000}},  // [e00] keny, _июня_, rtër,
  { {0x75230a1b, 0xda790088, 0xef1f0010, 0x00000000}},  //   kunz, ляє_, zzük_,
  { {0xfe37007b, 0x26de011c, 0x960b0044, 0x00000000}},  //   _דריי_, _rito_, রলাম_,
  { {0x26de0198, 0x6288008d, 0x3136007b, 0x00000000}},  //   _sito_, zhdo, ינעם_,
  { {0x78a90a1c, 0x26de0a1d, 0x87030a1e, 0x00000000}},  //   _djev, _pito_, ояще,
  { {0x7523000b, 0x200b00b9, 0x67220006, 0x00000000}},  //   funz, zaci_, ruoj,
  { {0x629a00b9, 0x32180036, 0x26de0197, 0x00000000}},  //   vito, órym_, _vito_,
  { {0x26de0020, 0x6b9b003b, 0x78a90056, 0x00000000}},  //   _wito_, _žugi, _gjev,
  { {0x629a001a, 0x26de0a1f, 0x32070a20, 0x00000000}},  //   tito, _tito_, _beny_,
  { {0x60cd002a, 0x320708e2, 0xab5b0047, 0x00000000}},  //   _sham, _ceny_, _szük,
  { {0x68e0005d, 0x6b8d0197, 0x60cd0082, 0x00000000}},  //   _kimd, zzag, _pham,
  { {0x859b009b, 0x6f040009, 0x757b0049, 0x00000000}},  //   _בשבו, _bwic, _שטאפ,
  { {0x200b00b9, 0x3eb803a1, 0x2486012d, 0x00000000}},  //   raci_, fort_, _ilom_,
  { {0x200b041a, 0x6f1d0a21, 0x66080087, 0x00000000}},  //   saci_, rrsc, _jedk,
  { {0xa3ea001c, 0x60cd0020, 0xbc0709f1, 0x00000000}},  //   _मला_, _tham, ичай,
  { {0x60cd0020, 0x320c0161, 0x6b8d002d, 0x00000000}},  //   _uham, lady_, tzag,
  { {0xa3ca0061, 0x764300e7, 0x00000000, 0x00000000}},  // [e10] ळेच_, yeny,   ,
  { {0x78a90243, 0x78bb02c3, 0x62860065, 0x00000000}},  //   _sjev, _skuv, ëkoh,
  { {0x78a90243, 0xbebb0065, 0x7ed40025, 0x00000000}},  //   _pjev, rrëd, _بزيا,
  { {0x7643005b, 0x25470010, 0x66080288, 0x00000000}},  //   weny, _ről_, _aedk,
  { {0xa01b01a2, 0x78a9016e, 0x62980116, 0x00000000}},  //   rhöh, _vjev, _omvo,
  { {0x7bda009b, 0x75230020, 0x24860a22, 0x00000000}},  //   _תקשו, tunz, _alom_,
  { {0x24860a23, 0x2bdb0061, 0x32070a24, 0x00000000}},  //   _blom_, _मृता, _reny_,
  { {0x76430a25, 0x68e00006, 0x78bb0009, 0x00000000}},  //   seny, _gimd, _ukuv,
  { {0x75230207, 0x764306fe, 0x6487004a, 0x00000000}},  //   sunz, peny, _añic,
  { {0xf6740054, 0x75230a26, 0x25470010, 0x00000000}},  //   _والخ, punz, _től_,
  { {0x6f040145, 0xd00a0a27, 0x3eb80a28, 0x00000000}},  //   _swic, лене_, vort_,
  { {0x3eb8001f, 0xb7bd001a, 0x2009001a, 0x00000000}},  //   wort_, _acţi, _ceai_,
  { {0xd12e00d3, 0x3eb80010, 0x42d50088, 0x00000000}},  //   ومی_, tort_, _ліку,
  { {0x201e0a29, 0x24860253, 0xddde00e5, 0x00000000}},  //   şti_, _zlom_, _copş,
  { {0x22450a2a, 0x80f50025, 0x3eb805b4, 0x00000000}},  //   melk_, _استض, rort_,
  { {0x27e0089f, 0xb05b0a2b, 0x6f0400ab, 0x00000000}},  //   žini_, llän, _twic,
  { {0x3eb80a2c, 0x7c360a2d, 0x00000000, 0x00000000}},  // [e20] port_, rfyr,   ,
  { {0xb05b0210, 0x62810a2e, 0xa96a005e, 0x00000000}},  //   nlän, nklo, лиза_,
  { {0x66080059, 0xb05b0210, 0xfeba00a1, 0x00000000}},  //   _redk, ilän, _لاگت_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x68fb073a, 0xb05b0a2f, 0x00000000, 0x00000000}},  //   _čude, klän,   ,
  { {0xfd65001d, 0x00000000, 0x00000000, 0x00000000}},  //   _nguồ,   ,   ,
  { {0x99860054, 0x660805b7, 0x5d7a0049, 0x00000000}},  //   _الأو, _vedk, טאַק,
  { {0x62810168, 0x00000000, 0x00000000, 0x00000000}},  //   eklo,   ,   ,
  { {0xc4450014, 0x7786003b, 0xf3ef0025, 0x00000000}},  //   زیون_, _улаз, رأي_,
  { {0x32660a30, 0x2732001a, 0xe5a600d7, 0x00000000}},  //   стив, mân_, _лизи,
  { {0x320c0a31, 0xd257008b, 0xaabb0049, 0x00000000}},  //   rady_, сцы_, רזיכ,
  { {0x320c0a32, 0x629d009d, 0x62810168, 0x00000000}},  //   sady_, ésor, aklo,
  { {0x320c067f, 0x937a0445, 0xdb0f00fa, 0x00000000}},  //   pady_, _حصار_, _excê,
  { {0xacf90a33, 0xddde0173, 0x00000000, 0x00000000}},  //   ингу_, _enpō,   ,
  { {0x403501be, 0x27320016, 0x00000000, 0x00000000}},  //   _дейс, hân_,   ,
  { {0xa0a40080, 0xce33007a, 0xd011025a, 0x00000000}},  //   _најд, _کودک, _کلک_,
  { {0xf09f0129, 0x3a750545, 0x00000000, 0x00000000}},  // [e30] mià_, олар,   ,
  { {0x9e070200, 0xf09f0129, 0x00000000, 0x00000000}},  //   _учил, lià_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x50c9007d, 0x00000000, 0x00000000, 0x00000000}},  //   रतिष,   ,   ,
  { {0xf10502fb, 0x2ca90a34, 0x628104a5, 0x00000000}},  //   _शब्द_, mnad_, yklo,
  { {0x45190001, 0x2ca902e1, 0xf09f0026, 0x00000000}},  //   ация_, lnad_, hià_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x2ca90004, 0x833900ed, 0xf1c3013e, 0x00000000}},  //   nnad_, ачот_, _liší_,
  { {0x6497001a, 0x2d8c004a, 0xb05b04ce, 0x00000000}},  //   nţii, údez_, tlän,
  { {0xe299012b, 0x2ca90016, 0x7c2f01c3, 0x00000000}},  //   рао_, hnad_, _lccr,
  { {0xc66801f9, 0xb05b0002, 0xe04604ef, 0x00000000}},  //   _уште_, rlän, онни,
  { {0x628101d6, 0x61fc0279, 0xb05b0a35, 0x00000000}},  //   sklo, ırla, slän,
  { {0xb05b01a2, 0x2d910026, 0x7e770203, 0x00000000}},  //   plän, ezze_, _boxp,
  { {0x7c2f062a, 0x0eba0147, 0x2eb403d7, 0x00000000}},  //   _accr, румы_, ंकेत,
  { {0x1d0a0545, 0x00000000, 0x00000000, 0x00000000}},  //   реби_,   ,   ,
  { {0x90c301be, 0x9f5201aa, 0x248d00b5, 0x00000000}},  //   _обще, _deyò_, nhem_,
  { {0x8af7005f, 0x443d01c3, 0x2d910026, 0x00000000}},  // [e40] _şəra, _mbw_, azze_,
  { {0xa01b0a36, 0x443d01d6, 0x4a4300ed, 0x00000000}},  //   nkön, _lbw_, мнув,
  { {0x443d0a37, 0x02b60049, 0xdb0600f8, 0x00000000}},  //   _obw_, קלעך_, _nykö,
  { {0xd7f00025, 0xa01b0052, 0x00000000, 0x00000000}},  //   ركت_, hkön,   ,
  { {0x05260055, 0x6497001a, 0x248d0829, 0x00000000}},  //   _মনের_, cţii, dhem_,
  { {0x057601d8, 0x63a4010a, 0x6d5e00d0, 0x00000000}},  //   قاعد, _žino, _krpa,
  { {0x248d002b, 0x443d0133, 0x00000000, 0x00000000}},  //   fhem_, _bbw_,   ,
  { {0x69ce0a38, 0x248d00f8, 0x7d7b0049, 0x00000000}},  //   _izbe, ghem_, ינצו,
  { {0x6843008b, 0xe3af00a1, 0xd7ef0025, 0x00000000}},  //   _інфа, ہری_, _شكل_,
  { {0xa5f7012b, 0x442f0253, 0x443d01c3, 0x00000000}},  //   _међу_, _ecg_, _ebw_,
  { {0xe3af00a6, 0xdb0f0a39, 0x21660088, 0x00000000}},  //   فری_, _excè, ітог,
  { {0x248d0a3a, 0x442f0093, 0x27e00213, 0x00000000}},  //   chem_, _gcg_, žinu_,
  { {0x14d70049, 0xf09f0129, 0x6722004a, 0x00000000}},  //   _וואל_, rià_, nroj,
  { {0x6263005e, 0x69ce0a3b, 0x9f520173, 0x00000000}},  //   _овча, _ozbe, _peyò_,
  { {0x2d85004f, 0x628a001a, 0xb05b0a3c, 0x00000000}},  //   ále_, _ilfo, lläm,
  { {0xbca50025, 0x67220a3d, 0x6fd30309, 0x00000000}},  //   أمري, kroj, _सरपं,
  { {0x2d850091, 0x2ca900ea, 0x6d5e0058, 0x00000000}},  // [e50] šle_, rnad_, _erpa,
  { {0x67220a3e, 0x248d0645, 0xc5e400a1, 0x00000000}},  //   droj, zhem_, _لۓ_,
  { {0xdcef0089, 0x5f740014, 0x6aae0146, 0x00000000}},  //   ēdēt, _فایر, _djbf,
  { {0x63ad000c, 0x249f062a, 0x00000000, 0x00000000}},  //   _þang, xium_,   ,
  { {0x69ce0a3f, 0xae1f013d, 0x442f012d, 0x00000000}},  //   _ezbe, _बयान_, _rcg_,
  { {0x7bda009b, 0x442f0a40, 0x249f0a41, 0x00000000}},  //   _לקרו, _scg_, wium_,
  { {0xa8a7007c, 0x20020036, 0x248d02f1, 0x00000000}},  //   _драк, ybki_, them_,
  { {0x7c2d0a42, 0x628a0779, 0x67220091, 0x00000000}},  //   ngar, _alfo, broj,
  { {0x248d0a43, 0x7c2d0032, 0xec790082, 0x00000000}},  //   rhem_, igar, _độc_,
  { {0x248d008d, 0x7c2d018e, 0xc879014a, 0x00000000}},  //   shem_, hgar, _hoş_,
  { {0x63ad0107, 0x6b890036, 0x78ab0082, 0x00000000}},  //   _žand, _żegl, ongv,
  { {0x628a0047, 0x2eb60164, 0x443d0a44, 0x00000000}},  //   _elfo, ृत्त, _ubw_,
  { {0xe28e00aa, 0x44f102d5, 0x6d5e0209, 0x00000000}},  //   _за_, _há_, _srpa,
  { {0x7c2d0207, 0x644906c0, 0x00000000, 0x00000000}},  //   egar, leei,   ,
  { {0x44f10a45, 0x68fe0009, 0x6722012d, 0x00000000}},  //   _já_, xppd, zroj,
  { {0x7c2d0a46, 0xb5fc0066, 0x644900ea, 0x00000000}},  //   ggar, _anġl, neei,
  { {0x44f10a47, 0x442d0a48, 0xfbd1026c, 0x00000000}},  // [e60] _lá_, ige_, ہتے_,
  { {0x20d20051, 0x7c2d0a49, 0x68fe0009, 0x00000000}},  //   sáid_, agar, tppd,
  { {0x44f10a4a, 0xc879005d, 0xd7fa01bd, 0x00000000}},  //   _ná_, _boş_, бул_,
  { {0x67220161, 0xc8790a4b, 0x26c701ee, 0x00000000}},  //   troj, _coş_, elno_,
  { {0x442d0038, 0x27e0021e, 0x6d5c0007, 0x00000000}},  //   dge_, äin_, lvra,
  { {0xa96a017a, 0x67220065, 0x44f10011, 0x00000000}},  //   _лига_, rroj, _bá_,
  { {0x44f10a4c, 0x69ce0a4d, 0x6d5c02ae, 0x00000000}},  //   _cá_, _uzbe, nvra,
  { {0x67220089, 0x44f1002a, 0x442d0374, 0x00000000}},  //   proj, _dá_, gge_,
  { {0x68ee0022, 0xa01b04ce, 0x00000000, 0x00000000}},  //   _hubd, khör,   ,
  { {0x44f10a4e, 0x442d0866, 0x8af0005f, 0x00000000}},  //   _fá_, age_, vvəl,
  { {0x44f1002a, 0x7c2d0006, 0x044602b8, 0x00000000}},  //   _gá_, ygar, _нежн,
  { {0xc879006b, 0x84960a4f, 0x232a0216, 0x00000000}},  //   _xoş_, _عجائ, _годи_,
  { {0x4abe007d, 0xb05b00b0, 0x7c2d02a9, 0x00000000}},  //   ्ताव, lläk, vgar,
  { {0x68fc0089, 0x2ee501a2, 0x7c2d00d9, 0x00000000}},  //   _otrd, ölf_, wgar,
  { {0x291c0a50, 0xd23b009b, 0xdb1d00b9, 0x00000000}},  //   ával_, _הגול, _vysí,
  { {0x7c2d0a51, 0xd1380a52, 0xb4fb00a3, 0x00000000}},  //   ugar, mtą_, מפלי,
  { {0x7c2d009f, 0x78a20a53, 0x64970a54, 0x00000000}},  // [e70] rgar, diov, cţiu,
  { {0x7c2d022b, 0x6ce70088, 0xd1380a55, 0x00000000}},  //   sgar, _німе, otą_,
  { {0xd1380006, 0x442d08c8, 0x9f590919, 0x00000000}},  //   ntą_, yge_, pasó_,
  { {0x44f10a56, 0x78a20a57, 0xd1380006, 0x00000000}},  //   _rá_, giov, itą_,
  { {0xb8f402d2, 0x2918003b, 0x44f1009f, 0x00000000}},  //   _सी_, _evra_, _sá_,
  { {0x44f100b9, 0xd1380006, 0x764a00eb, 0x00000000}},  //   _pá_, ktą_, gefy,
  { {0x442d04bd, 0x2d83010a, 0xe6100076, 0x00000000}},  //   tge_, nyje_, اشه_,
  { {0x44f10a58, 0x442d0a59, 0x6d450146, 0x00000000}},  //   _vá_, uge_, _mpha,
  { {0x44f10011, 0x6d450919, 0x6d5c0466, 0x00000000}},  //   _wá_, _lpha, zvra,
  { {0x44f10195, 0x6d450a5a, 0xe2990088, 0x00000000}},  //   _tá_, _opha, іан_,
  { {0xbebb0023, 0x442d00f8, 0x00000000, 0x00000000}},  //   trën, pge_,   ,
  { {0xbe250055, 0xa06a003b, 0x7afd006c, 0x00000000}},  //   ম্মদ_, цама_, _otst,
  { {0x3ea30a5b, 0x7afd01d6, 0xa01b06d3, 0x00000000}},  //   fijt_, _ntst, thör,
  { {0x68fb0091, 0xdd9200a6, 0x6d5c0023, 0x00000000}},  //   _čudn, پور_, tvra,
  { {0x7afd0a5c, 0xed5701bd, 0xa01b0a5d, 0x00000000}},  //   _atst, мор_, rhör,
  { {0x69da0181, 0x6d5c0a5e, 0xa01b06d3, 0x00000000}},  //   _útei, rvra, shör,
  { {0x7ae70a5b, 0x68fc00ca, 0x6d5c0112, 0x00000000}},  // [e80] _bijt, _strd, svra,
  { {0x68ee0a5f, 0xab5b0010, 0x7aef0a60, 0x00000000}},  //   _pubd, _gyüm, _duct,
  { {0xceb3007b, 0xbebb0065, 0x994a0380, 0x00000000}},  //   _ביז_, ytëz, تلال_,
  { {0x672b0a61, 0x7aef00e5, 0xcb6a0545, 0x00000000}},  //   fugj, _fuct, _даме_,
  { {0x78a20161, 0x7bc6014a, 0x60c400e7, 0x00000000}},  //   riov, _uyku, _mkim,
  { {0xd1380a62, 0xa92601fc, 0x6eeb0066, 0x00000000}},  //   ytą_, _одгл, _użbe,
  { {0x98a6017a, 0x250700a1, 0x764a0016, 0x00000000}},  //   _живе, ورٹی_, refy,
  { {0x7afd00ea, 0x764a0016, 0x00000000, 0x00000000}},  //   _ytst, sefy,   ,
  { {0x98a3004d, 0x6b840a63, 0xb05b00f8, 0x00000000}},  //   _рите, nyig, släk,
  { {0x60c40a64, 0x325401ff, 0xa01b01a2, 0x00000000}},  //   _akim, хвор, rköm,
  { {0x60f803e8, 0x403502dc, 0x6b840a65, 0x00000000}},  //   яння_, ненс, hyig,
  { {0xd1380a66, 0x60d6018e, 0x42ce0044, 0x00000000}},  //   rtą_, _chym, রদেশ,
  { {0xd1380a67, 0x32050a68, 0x00000000, 0x00000000}},  //   stą_, bbly_,   ,
  { {0x60c40a69, 0x2d830006, 0x2bd5007d, 0x00000000}},  //   _ekim, tyje_, _दरबा,
  { {0x68fb0627, 0x6d580006, 0x7ae700bb, 0x00000000}},  //   _čudo, _švar, _rijt,
  { {0x96140044, 0x2d830006, 0xbf350088, 0x00000000}},  //   সলিম_, ryje_, _знищ,
  { {0x3f4f01d5, 0x7ebf00b9, 0x92c20044, 0x00000000}},  // [e90] _użu_, tápě, ্দী_,
  { {0x6f0d0117, 0x2d830006, 0x2a6a00c4, 0x00000000}},  //   _iwac, pyje_, _cnbb_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x38690841, 0xc879047f, 0x80d10044, 0x00000000}},  //   ñar_, _kişi_, _সূত্,
  { {0x7afd01c9, 0x3669003b, 0xfc3f0010, 0x00000000}},  //   _utst, зало_, _amíg_,
  { {0x29010061, 0xaa4500b0, 0x6f0d00e7, 0x00000000}},  //   ppha_, ävää_, _mwac,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xa3ba007d, 0xf99200b3, 0x6aa50022, 0x00000000}},  //   _आँख_, _ערן_, lihf,
  { {0x27ed0a6a, 0x60d60a6b, 0x00000000, 0x00000000}},  //   _igen_, _rhym,   ,
  { {0x68e90a6c, 0x60d604a5, 0x00000000, 0x00000000}},  //   _hied, _shym,   ,
  { {0x68e90046, 0x32050007, 0x00000000, 0x00000000}},  //   _kied, rbly_,   ,
  { {0x6f0d0a5f, 0x2280000a, 0x62880133, 0x00000000}},  //   _bwac, _bòks_, akdo,
  { {0x68e90a6d, 0x443f0a6e, 0x00000000, 0x00000000}},  //   _mied, mfu_,   ,
  { {0x443f088f, 0x5239007b, 0x68e901c3, 0x00000000}},  //   lfu_, _זײַנ, _lied,
  { {0xfaff008d, 0x64590a6f, 0x7bcb010f, 0x00000000}},  //   _atë_, _kawi, ügun,
  { {0x68e90a70, 0x60c4000b, 0x63a4010a, 0x00000000}},  //   _nied, _ukim, _žini,
  { {0x6d41011f, 0x64590020, 0x443f0020, 0x00000000}},  // [ea0] çlar, _mawi, ifu_,
  { {0x27ed0169, 0x64590a71, 0x00000000, 0x00000000}},  //   _agen_, _lawi,   ,
  { {0x68e90a72, 0x20120a73, 0x9c8300ca, 0x00000000}},  //   _bied, _keyi_, ščav,
  { {0x7e7e0073, 0x64590036, 0xb5fc002b, 0x00000000}},  //   _hopp, _nawi, _inġi,
  { {0x7e7e0a5e, 0x1754007c, 0xe7c00044, 0x00000000}},  //   _kopp, твля, েশ্য,
  { {0x27ed05cb, 0x443f0020, 0x7e7e0a74, 0x00000000}},  //   _egen_, efu_, _jopp,
  { {0x80d10055, 0x443f0016, 0x7e7e0a75, 0x00000000}},  //   _সংস্, ffu_, _mopp,
  { {0x7e7e021e, 0xd497007c, 0x68e90a76, 0x00000000}},  //   _lopp, ерь_, _gied,
  { {0x64590a77, 0x82a60a78, 0x7e7e0052, 0x00000000}},  //   _dawi, ешне, _oopp,
  { {0x68e9001e, 0x443f0a79, 0x07a30242, 0x00000000}},  //   _zied, afu_, _саун,
  { {0xc5690025, 0x3ce10061, 0x00000000, 0x00000000}},  //   _يحمل_, _कळले_,   ,
  { {0x6459006a, 0x92c20044, 0x765a0a7a, 0x00000000}},  //   _gawi, ্দে_, _haty,
  { {0x765a000a, 0x7e7e01ee, 0x00000000, 0x00000000}},  //   _katy, _bopp,   ,
  { {0x64590046, 0x7e7e051b, 0xa6e70082, 0x00000000}},  //   _zawi, _copp, _nhữ,
  { {0x7e7e09fa, 0x765a0a7b, 0x20d20051, 0x00000000}},  //   _dopp, _maty, máin_,
  { {0x6ca40a7c, 0x765a01d6, 0x20d20051, 0x00000000}},  //   груж, _laty, láin_,
  { {0x68e9002b, 0xfaf30084, 0x5a350893, 0x00000000}},  // [eb0] _ried, اثر_, кнат,
  { {0x765a0a7d, 0x68e90036, 0x20d20051, 0x00000000}},  //   _naty, _sied, náin_,
  { {0x68e9001e, 0x39470129, 0x48150242, 0x00000000}},  //   _pied, ïns_, вмес,
  { {0x20d2002a, 0xe0df0263, 0x7e7e0a7e, 0x00000000}},  //   háin_, nmò_, _zopp,
  { {0x68e90a7f, 0x20d90051, 0xed590089, 0x00000000}},  //   _vied, méid_, āžu_,
  { {0x68e90a80, 0x945d0036, 0x645904cb, 0x00000000}},  //   _wied, końc, _sawi,
  { {0x68e9021e, 0x64590a81, 0x20d20051, 0x00000000}},  //   _tied, _pawi, dáin_,
  { {0x27ed0030, 0x20d90051, 0x69d601f5, 0x00000000}},  //   _ugen_, néid_, _भरती,
  { {0x645b0007, 0x443f0a82, 0x00000000, 0x00000000}},  //   rdui, rfu_,   ,
  { {0x09e50055, 0x6459000b, 0x2362000c, 0x00000000}},  //   _প্যা, _wawi, ækja_,
  { {0x20120607, 0x81c90055, 0x443f0009, 0x00000000}},  //   _peyi_, লেন_, pfu_,
  { {0x387f028c, 0x7e7e0a83, 0x7e0a007d, 0x00000000}},  //   _jour_, _sopp, वर्ग_,
  { {0xa4d401fb, 0x08760049, 0x0478025a, 0x00000000}},  //   _соці, דערט_, _سلوک_,
  { {0x9f9e0181, 0xe0df0026, 0x387f000a, 0x00000000}},  //   _ação_, amò_, _lour_,
  { {0x71640025, 0x386d0085, 0x00000000, 0x00000000}},  //   _مايك, _oner_,   ,
  { {0x09b00055, 0x387f0a84, 0x00000000, 0x00000000}},  //   _করলা, _nour_,   ,
  { {0xf412007b, 0x69d50197, 0xebe60a85, 0x00000000}},  // [ec0] יפן_, _azze, тоап,
  { {0x386d0190, 0xdee60745, 0x0d860478, 0x00000000}},  //   _aner_, _шопи, _алон,
  { {0x386d0093, 0x387f0a86, 0xceb900b9, 0x00000000}},  //   _bner_, _bour_, éře_,
  { {0x387f00f4, 0x765a0036, 0x20d90a87, 0x00000000}},  //   _cour_, _saty, céid_,
  { {0x765a010a, 0x69d50047, 0x387f0685, 0x00000000}},  //   _paty, _ezze, _dour_,
  { {0x6f02011f, 0x64950051, 0xa6340088, 0x00000000}},  //   _çocu, _láid, ункі,
  { {0x387f0a88, 0xc60b0044, 0x64b3001a, 0x00000000}},  //   _four_, _রাখা_, răin,
  { {0xb4cc0061, 0x2cb20544, 0x00000000, 0x00000000}},  //   ळते_, nnyd_,   ,
  { {0x20d20051, 0xd2500025, 0x765a0a89, 0x00000000}},  //   táin_, منة_, _taty,
  { {0x7c290089, 0x00000000, 0x00000000, 0x00000000}},  //   _ķerm,   ,   ,
  { {0x387f0a8a, 0x63ad009f, 0x20d203df, 0x00000000}},  //   _your_, _þann, ráin_,
  { {0x20d2002a, 0x63a4010a, 0x661800ca, 0x00000000}},  //   sáin_, _žinu, lavk,
  { {0x44f80a8b, 0xe0df0197, 0x20d20051, 0x00000000}},  //   _hé_, rmò_, máil_,
  { {0x6fe90089, 0x768f00ea, 0x44f80082, 0x00000000}},  //   _rīcī, _løyn, _ké_,
  { {0x3958012d, 0xac950140, 0x00000000, 0x00000000}},  //   _nsrs_, гавш,   ,
  { {0x44f80195, 0x273b00ad, 0x80d10044, 0x00000000}},  //   _mé_, yên_, _সূর্,
  { {0x44f80048, 0x3084006d, 0xdad9003b, 0x00000000}},  // [ed0] _lé_, _خليف, емац_,
  { {0x20d2002a, 0x20190a8c, 0x7e5501fb, 0x00000000}},  //   háil_, lasi_, _своє,
  { {0x387f0a8d, 0x44f80a8e, 0x20d90051, 0x00000000}},  //   _pour_, _né_, péid_,
  { {0x20190a8f, 0xdb1d00b0, 0xb4cc0061, 0x00000000}},  //   nasi_, _pysä, ळतो_,
  { {0xfeb80a90, 0x9cd6061e, 0x20d2002a, 0x00000000}},  //   _سایت_, _תורה_, dáil_,
  { {0x2ca9018e, 0x44f80a91, 0x2557005f, 0x00000000}},  //   liad_, _bé_, _hələ_,
  { {0x20190149, 0x44f8002a, 0x8883007a, 0x00000000}},  //   kasi_, _cé_, _پیشن,
  { {0x236601cd, 0x20d2002a, 0x2ca9018e, 0x00000000}},  //   _broj_, gáil_, niad_,
  { {0x2019023a, 0x69da00b9, 0x661804eb, 0x00000000}},  //   dasi_, _úter, bavk,
  { {0x44f80a92, 0x2019001a, 0x2ca90016, 0x00000000}},  //   _fé_, easi_, hiad_,
  { {0x2019000b, 0xe43500f3, 0x2366002b, 0x00000000}},  //   fasi_, _مفاد, _eroj_,
  { {0x20190a93, 0x20d20051, 0x672b0023, 0x00000000}},  //   gasi_, cáil_, orgj,
  { {0x2ca9018e, 0x324500ed, 0x44f80181, 0x00000000}},  //   diad_, _белг, _zé_,
  { {0xed5a012b, 0x248d0224, 0xf2070077, 0x00000000}},  //   ног_, lkem_, _рядо,
  { {0x2ca9018e, 0xf8b301f5, 0x20190020, 0x00000000}},  //   fiad_, ंचाय, basi_,
  { {0x2ca9018e, 0x6abe0309, 0x1bea0a94, 0x00000000}},  //   giad_, ्त्र, едби_,
  { {0xab66045a, 0x7c2b0a58, 0xb05b0039, 0x00000000}},  // [ee0] ывал, ógra, rlät,
  { {0x248d0004, 0x68f5014a, 0xb86500a6, 0x00000000}},  //   hkem_, _buzd, یانو,
  { {0xb05b010f, 0xdca601c0, 0x2ca90016, 0x00000000}},  //   plät, _бани, biad_,
  { {0x44f80a95, 0x63b6000c, 0x2ca90016, 0x00000000}},  //   _ré_, _þyng, ciad_,
  { {0x44f80a96, 0x248d00b9, 0xc60b0044, 0x00000000}},  //   _sé_, dkem_, _রাজা_,
  { {0x44f80a97, 0x4ab80309, 0x248d00bb, 0x00000000}},  //   _pé_, _आदिव, ekem_,
  { {0x20d2002a, 0x2019027d, 0x2b400a98, 0x00000000}},  //   táil_, yasi_, ltic_,
  { {0x44f80011, 0x768f00ea, 0x6f0404eb, 0x00000000}},  //   _vé_, _høyl, _otic,
  { {0x20d2002a, 0xe80a001c, 0x36360151, 0x00000000}},  //   ráil_, _ह्या_, _مراس,
  { {0x44f80a99, 0x20d20051, 0x20190a9a, 0x00000000}},  //   _té_, sáil_, wasi_,
  { {0x20190149, 0x326307d0, 0x6f04008e, 0x00000000}},  //   tasi_, стыв, _atic,
  { {0x68e20302, 0x6f1d0a9b, 0x248d013e, 0x00000000}},  //   nmod, tssc, ckem_,
  { {0x20190149, 0xb4c20061, 0xb4c0006e, 0x00000000}},  //   rasi_, ृती_, ंकी_,
  { {0x20190149, 0x2563011f, 0x2ca9010b, 0x00000000}},  //   sasi_, _yıl_, wiad_,
  { {0x6f040a9c, 0x20190169, 0x2ca90016, 0x00000000}},  //   _etic, pasi_, tiad_,
  { {0xb05b0788, 0x2b4b00d4, 0x68e20471, 0x00000000}},  //   rläs, _ppcc_, jmod,
  { {0x2ca9018e, 0x68e20a9d, 0x68f50166, 0x00000000}},  // [ef0] riad_, dmod, _suzd,
  { {0x69ce0343, 0x2ca9018e, 0x8f9c0049, 0x00000000}},  //   _bybe, siad_, _ריזי,
  { {0xb9b50a4f, 0x81e60044, 0x2ca9010e, 0x00000000}},  //   جماع, যুর_, piad_,
  { {0x69ce0190, 0x21370049, 0x68e202fa, 0x00000000}},  //   _dybe, רטאל_, gmod,
  { {0x65680a9e, 0x2b400899, 0xdc36007b, 0x00000000}},  //   _ardh, ctic_, _דארט_,
  { {0x7aee010f, 0x83fd0010, 0x8af0006b, 0x00000000}},  //   _gibt, zdőd, rvət,
  { {0xd6180379, 0x248d0a9f, 0x291c093f, 0x00000000}},  //   اتها_, tkem_, ávat_,
  { {0x032509bb, 0x7f4d0aa0, 0x68e206ed, 0x00000000}},  //   адин, _opaq, cmod,
  { {0x65680065, 0xc6140055, 0x248d0aa1, 0x00000000}},  //   _erdh, _সারা_, rkem_,
  { {0x248d018b, 0x78ab0030, 0x6487008e, 0x00000000}},  //   skem_, ligv, _añit,
  { {0xe0da0aa2, 0x39410038, 0x26c70aa3, 0x00000000}},  //   кво_, nths_, mono_,
  { {0x6f040825, 0x6e2504df, 0x78ab0112, 0x00000000}},  //   _ptic, _adhb, nigv,
  { {0xe28e017f, 0x7d050051, 0xa856009b, 0x00000000}},  //   _да_, _aths, בירה_,
  { {0x91e50364, 0x539a009b, 0x1167025a, 0x00000000}},  //   _коле, _בינו, _ملتی_,
  { {0x6283031e, 0x26c70197, 0x5fd80061, 0x00000000}},  //   _iono, iono_, _ठरवल,
  { {0x62830aa4, 0x26c70658, 0x77690032, 0x00000000}},  //   _hono, hono_, _orex,
  { {0x62830aa5, 0x6f0405fa, 0x26c70020, 0x00000000}},  // [f00] _kono, _utic, kono_,
  { {0x26c70006, 0x68e200d9, 0x628300b0, 0x00000000}},  //   jono_, wmod, _jono,
  { {0x26c70207, 0x20d90181, 0x394100e0, 0x00000000}},  //   dono_, léia_, gths_,
  { {0x69ce0428, 0x2b400133, 0xa01b0aa6, 0x00000000}},  //   _vybe, ptic_, lkör,
  { {0x26c70682, 0x68e20039, 0xbebb0065, 0x00000000}},  //   fono_, rmod, rrëv,
  { {0x26c7027b, 0x62830207, 0x69ce026e, 0x00000000}},  //   gono_, _nono, _tybe,
  { {0x68e200ea, 0xa01b0039, 0x768f00ea, 0x00000000}},  //   pmod, ljöe, _gøym,
  { {0xd7060242, 0x69d80089, 0x77690288, 0x00000000}},  //   _взаи, ļved, _frex,
  { {0xa2c2024c, 0x26c70066, 0x6283008e, 0x00000000}},  //   रकल्, bono_, _bono,
  { {0x62830aa7, 0xc2c30054, 0x26c70207, 0x00000000}},  //   _cono, يييي, cono_,
  { {0x62830aa8, 0xd48f017f, 0x7c260aa9, 0x00000000}},  //   _dono, _др_, _odkr,
  { {0xdcee010a, 0x75d30014, 0xb97b009b, 0x00000000}},  //   mybė, _بيما, דנטי,
  { {0x44260211, 0x6283002d, 0xe3b20151, 0x00000000}},  //   _ido_, _fono, _برا_,
  { {0x62830010, 0xef1f0095, 0x442600d2, 0x00000000}},  //   _gono, rsü_, _hdo_,
  { {0x44260aaa, 0xdcee0006, 0x6ca7007e, 0x00000000}},  //   _kdo_, nybė, араж,
  { {0x80d10055, 0x1bf5007e, 0x62830006, 0x00000000}},  //   _সংক্, спаў, _zono,
  { {0x26c7023a, 0x39410319, 0x60cd0284, 0x00000000}},  // [f10] yono_, wths_, _ikam,
  { {0x99670001, 0x3b09006b, 0xdcee0006, 0x00000000}},  //   ител, rpaq_, kybė,
  { {0xd366007a, 0x26c70207, 0x44260aab, 0x00000000}},  //   _که_, vono_, _odo_,
  { {0x7769027b, 0x44260020, 0x649c0051, 0x00000000}},  //   _prex, _ndo_, _héif,
  { {0x26c70006, 0xcc7600b3, 0x60cd00e7, 0x00000000}},  //   tono_, _הערה_, _mkam,
  { {0x1af600a0, 0x4426009d, 0x39410133, 0x00000000}},  //   _למשל_, _ado_, pths_,
  { {0x09e50055, 0x99850054, 0x4518008b, 0x00000000}},  //   _প্রা, _الزو, ацыя_,
  { {0x4426008d, 0xa8a40aac, 0xe459003b, 0x00000000}},  //   _cdo_, _друк, ужи_,
  { {0x62830119, 0x6b8d0010, 0x26c70aad, 0x00000000}},  //   _pono, nyag, pono_,
  { {0x44260756, 0x60cd0aae, 0x80d10044, 0x00000000}},  //   _edo_, _akam, _সংগ্,
  { {0xb5a70605, 0x62830023, 0x4426004a, 0x00000000}},  //   _трай, _vono, _fdo_,
  { {0x656e002a, 0x160b03d7, 0x62830093, 0x00000000}},  //   _ábha, _स्तर_, _wono,
  { {0x80d10055, 0xafdb0030, 0x443d0093, 0x00000000}},  //   _সংখ্, lføj, _icw_,
  { {0x629a0aaf, 0x20d900c4, 0xde030ab0, 0x00000000}},  //   chto, réia_, зпри,
  { {0x753c010f, 0x7c96007e, 0x69a7013d, 0x00000000}},  //   _ärzt, брац, _टेली,
  { {0x20d900c4, 0xa01b0010, 0xa5c30036, 0x00000000}},  //   péia_, skör, ciół,
  { {0xc9f60025, 0x09e50044, 0x5f4600a1, 0x00000000}},  // [f20] مساع, _প্লা, _انخل,
  { {0xe810007d, 0x2bac0061, 0x7810006e, 0x00000000}},  //   ार्थ_, _घेणा, ार्क_,
  { {0x81c90055, 0x443d05aa, 0x186a01ee, 0x00000000}},  //   লের_, _ocw_, лажи_,
  { {0x6d5e0209, 0xa01b0039, 0xe81a05f3, 0x00000000}},  //   _ispa, nköp, ازات_,
  { {0x6d5e001c, 0x20020521, 0x649c0048, 0x00000000}},  //   _hspa, icki_, _héig,
  { {0xdcee010a, 0xa01b021e, 0x44260065, 0x00000000}},  //   tybė, hköp, _sdo_,
  { {0x2bac0061, 0x443d0009, 0xdcfc0006, 0x00000000}},  //   _घेता, _bcw_, tyrę,
  { {0x69dc0059, 0x44260ab1, 0x629d0023, 0x00000000}},  //   _izre, _qdo_, ëson,
  { {0x649c002a, 0xd6d20318, 0x57fb0097, 0x00000000}},  //   _léig, _فقر_, _תלמו,
  { {0x60cd06e8, 0x6d5e002d, 0xd25a014c, 0x00000000}},  //   _skam, _ospa, уци_,
  { {0x67220089, 0x38cb00a1, 0x44260ab2, 0x00000000}},  //   lsoj, _شاہی_, _tdo_,
  { {0x5577007b, 0x629a008d, 0x661a08b2, 0x00000000}},  //   _לעבן_, shto, _hetk,
  { {0x6d5e0ab3, 0x7e2b008b, 0x32cb00ea, 0x00000000}},  //   _aspa, ліва_, røyr_,
  { {0x0dcb0a94, 0x20020190, 0x768f00ea, 0x00000000}},  //   губи_, acki_, _røyk,
  { {0x321e0036, 0x64950051, 0x661a016e, 0x00000000}},  //   maty_, _máin, _metk,
  { {0x6d5e0ab4, 0x661a0052, 0x60cd0020, 0x00000000}},  //   _dspa, _letk, _ukam,
  { {0xfbd30076, 0x6f160016, 0x3cfa00f6, 0x00000000}},  // [f30] ستر_, _gwyc, _eupv_,
  { {0x661a0209, 0xbebb0065, 0x24860ab5, 0x00000000}},  //   _netk, rrës, _loom_,
  { {0x6f160036, 0x29070065, 0x79590ab6, 0x00000000}},  //   _zwyc, ëna_, риер_,
  { {0x29070089, 0xd7d50ab7, 0x00000000, 0x00000000}},  //   īna_, ожењ,   ,
  { {0x321e0036, 0x649c0048, 0x69dc0010, 0x00000000}},  //   katy_, _méid, _ezre,
  { {0x661a0ab8, 0xda7b007e, 0x57a90061, 0x00000000}},  //   _cetk, _сям_, _कधीह,
  { {0x24860007, 0x78bb00d8, 0xe8100061, 0x00000000}},  //   _boom_, _tjuv, ारखा_,
  { {0x629805b7, 0x661a0116, 0x78a90ab9, 0x00000000}},  //   _alvo, _eetk, _umev,
  { {0x254e006b, 0x64950051, 0x24860aba, 0x00000000}},  //   _cəlb_, _fáin, _doom_,
  { {0x52a9007c, 0x81bd0044, 0x321e00b4, 0x00000000}},  //   рвом_, _আরব_, gaty_,
  { {0xdb06000c, 0x6f1600b4, 0x00000000, 0x00000000}},  //   _ómög, _swyc,   ,
  { {0x649c0051, 0x6d5e0022, 0x090e0044, 0x00000000}},  //   _réig, _rspa, _হিমু_,
  { {0x661a0676, 0x6d5e0061, 0x2d8504ce, 0x00000000}},  //   _yetk, _sspa, älen_,
  { {0x64490abb, 0xfc3f0129, 0xa01b0abc, 0x00000000}},  //   lfei, _ací_, sköp,
  { {0x649c0195, 0xed5a0088, 0x6724002b, 0x00000000}},  //   _féid, шов_, ġiji,
  { {0x6d5e001c, 0x644902a3, 0x20d90051, 0x00000000}},  //   _vspa, nfei, néil_,
  { {0x6d5e0036, 0xbb4308d6, 0x8b2601ab, 0x00000000}},  // [f40] _wspa, метк, юдае,
  { {0x649c002a, 0x1ae3013b, 0xddde00e5, 0x00000000}},  //   _téig, доум, _copţ,
  { {0x661a0abd, 0x6d5e0091, 0xa01b00f8, 0x00000000}},  //   _retk, _uspa, ljöa,
  { {0x50ca03d7, 0x661a00b9, 0x672200b0, 0x00000000}},  //   रविष, _setk, tsoj,
  { {0x661a00ee, 0x248600ab, 0x20d90051, 0x00000000}},  //   _petk, _room_, déil_,
  { {0x6d5c0061, 0x6b8b0039, 0x248601c3, 0x00000000}},  //   owra, ägge, _soom_,
  { {0x64490abe, 0x69dc0089, 0xd49a017a, 0x00000000}},  //   ffei, _uzre, ири_,
  { {0xb1980011, 0x672d08ad, 0xe9d70088, 0x00000000}},  //   _ngưỡ, šaja, _єкт_,
  { {0x661a016c, 0x61ef005f, 0x649c0051, 0x00000000}},  //   _tetk, əklə, _réid,
  { {0x7f46001c, 0x68fc014a, 0x38660007, 0x00000000}},  //   dtkq, _kurd, ldor_,
  { {0xe45a01fb, 0x321e05fd, 0x24860abf, 0x00000000}},  //   _вже_, raty_, _toom_,
  { {0x38660010, 0x68fc08ce, 0x76580ac0, 0x00000000}},  //   ndor_, _murd, levy,
  { {0x6101001e, 0x38660285, 0xdfdb02dc, 0x00000000}},  //   _vēla, idor_, рън_,
  { {0x81c90055, 0x76580020, 0xbbb40061, 0x00000000}},  //   লেই_, nevy, ंपैक,
  { {0x68fc0563, 0x6d5c005b, 0x20d90048, 0x00000000}},  //   _nurd, gwra, léim_,
  { {0x90c401fc, 0x90e703ec, 0x00000000, 0x00000000}},  //   _обје, _بستن,   ,
  { {0x1eab0025, 0x7bc10036, 0x3866024d, 0x00000000}},  // [f50] _نادي_, _ślub, ddor_,
  { {0x1b040044, 0x768f00ea, 0x00000000, 0x00000000}},  //   _লিখে_, _høyv,   ,
  { {0xad27007a, 0xe9f80088, 0x64490016, 0x00000000}},  //   _برخو, інці_, yfei,
  { {0xe8f802f0, 0x321c0ac1, 0x64950051, 0x00000000}},  //   ілі_, _levy_, _cáil,
  { {0xcb4401f9, 0x0c24007e, 0x64950051, 0x00000000}},  //   _охри, _імён, _dáil,
  { {0x38660446, 0x8afa009b, 0x24670082, 0x00000000}},  //   ador_, _להשי, _ốm_,
  { {0xceb4007b, 0x8557089d, 0x6495002a, 0x00000000}},  //   ויס_, تیار_, _fáil,
  { {0x7afd0ac2, 0x7af5022b, 0x81c20044, 0x00000000}},  //   _kust, _hizt, ্ধা_,
  { {0xe3b10054, 0x64490181, 0x68fc008e, 0x00000000}},  //   عرب_, rfei, _zurd,
  { {0xe299012b, 0x6449003a, 0x68fc005d, 0x00000000}},  //   сао_, sfei, _yurd,
  { {0x76b20036, 0xe8100061, 0x7af50288, 0x00000000}},  //   słyc, ारचा_, _mizt,
  { {0x69d50023, 0x7af50288, 0x00000000, 0x00000000}},  //   _myze, _lizt,   ,
  { {0x7afd010a, 0x3f8f01d5, 0xbf9b00c4, 0x00000000}},  //   _nust, _żgur_, scên,
  { {0x91fc0089, 0x00000000, 0x00000000, 0x00000000}},  //   ndāl,   ,   ,
  { {0x7c9602f0, 0x64950051, 0xfce6004c, 0x00000000}},  //   прац, _láim, зово,
  { {0x7afd001c, 0x249f0181, 0x6d5c005b, 0x00000000}},  //   _bust, nhum_, rwra,
  { {0x7af50ac3, 0x7afd0ac4, 0x68fc00c4, 0x00000000}},  // [f60] _bizt, _cust, _surd,
  { {0x7afd0406, 0x290a0022, 0x64950048, 0x00000000}},  //   _dust, _ptba_, _sáil,
  { {0x7afd002d, 0x68fc006b, 0x0d94025a, 0x00000000}},  //   _eust, _qurd, _غیرح,
  { {0x7afd0129, 0x68fc02cc, 0x69d50ac5, 0x00000000}},  //   _fust, _vurd, _dyze,
  { {0x7afd0ac6, 0x68fc001f, 0x38660ac7, 0x00000000}},  //   _gust, _wurd, rdor_,
  { {0x68fc0ac8, 0xba55005e, 0x2d8700d4, 0x00000000}},  //   _turd, _отсъ, _ànec_,
  { {0x7afd010f, 0x64950051, 0x321c07c4, 0x00000000}},  //   _zust, _táil, _revy_,
  { {0x2ca00ac9, 0xf746007c, 0x7de70010, 0x00000000}},  //   nhid_, _небо, lésé,
  { {0x7afd049a, 0x00000000, 0x00000000, 0x00000000}},  //   _xust,   ,   ,
  { {0xcb13009b, 0x6d47000c, 0x7de70010, 0x00000000}},  //   עלת_, ytja, nésé,
  { {0x20d2004a, 0xc5160014, 0x00000000, 0x00000000}},  //   jáis_, _ربات,   ,
  { {0x249f01a2, 0x64a307d0, 0x7bc3001a, 0x00000000}},  //   chum_, _паха, şnui,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7afd00c7, 0x6d470aca, 0xfd13006d, 0x00000000}},  //   _rust, ttja, فجر_,
  { {0x71f70076, 0x7afd0acb, 0x7de70010, 0x00000000}},  //   _عروس_, _sust, désé,
  { {0x7afd0119, 0x6d47002b, 0x768f00ea, 0x00000000}},  //   _pust, rtja, _høyt,
  { {0x6d470acc, 0xc6220044, 0x7af5002d, 0x00000000}},  // [f70] stja, _নানা_, _pizt,
  { {0x6f0d0acd, 0xbd02004a, 0x00000000, 0x00000000}},  //   _itac, ñéca,   ,
  { {0xb5fc01d5, 0x628a0ace, 0x96220044, 0x00000000}},  //   _paġn, _mofo, নলাম_,
  { {0xddde01a8, 0x2ca0001a, 0x20d20051, 0x00000000}},  //   _uopš, chid_, láir_,
  { {0x26ce00fa, 0x00000000, 0x00000000, 0x00000000}},  //   fofo_,   ,   ,
  { {0x628a0acf, 0xfbd200a0, 0x20d2002a, 0x00000000}},  //   _nofo, _סתם_, náir_,
  { {0x249f005b, 0x00000000, 0x00000000, 0x00000000}},  //   thum_,   ,   ,
  { {0x64950051, 0x6f0d0ad0, 0x9f650142, 0x00000000}},  //   _táim, _otac, _štýl_,
  { {0x6f0d0009, 0x249f00ef, 0x628a02e7, 0x00000000}},  //   _ntac, rhum_, _bofo,
  { {0xd048006b, 0x64420a40, 0x628a0666, 0x00000000}},  //   əməy, _ecoi, _cofo,
  { {0x628a0022, 0x61010089, 0x648e0009, 0x00000000}},  //   _dofo, _vēlo, _cùis,
  { {0x6442002a, 0x7de70047, 0xf4850167, 0x00000000}},  //   _gcoi, zésé, _تائی,
  { {0x628a00c4, 0x10a307e1, 0xe3ae007e, 0x00000000}},  //   _fofo, тиян, _рб_,
  { {0x12fa00b6, 0x83fd0010, 0x443f0ad1, 0x00000000}},  //   _והסב, zdől, lgu_,
  { {0x2ca00ad2, 0x443f0ad3, 0x768f00ea, 0x00000000}},  //   thid_, ogu_, _høys,
  { {0x443f0ad4, 0x20d205f4, 0x645b0115, 0x00000000}},  //   ngu_, ráis_, neui,
  { {0x7de70047, 0xaec6003b, 0x9f4400b0, 0x00000000}},  // [f80] tésé, _обил, ämä_,
  { {0x2ca00518, 0x629d0023, 0x6b8b00f8, 0x00000000}},  //   shid_, ësoh, ägga,
  { {0x610800b9, 0x443f01a3, 0x768f0056, 0x00000000}},  //   _těle, kgu_, _løys,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7c2400f4, 0x00000000, 0x00000000, 0x00000000}},  //   mair,   ,   ,
  { {0x7c240ad5, 0x6442002a, 0x443f0004, 0x00000000}},  //   lair, _scoi, egu_,
  { {0xa01b000c, 0xd82601fc, 0x645b0ad6, 0x00000000}},  //   fjöl, _одви, feui,
  { {0x7c24028c, 0x628a010f, 0x443f0ad7, 0x00000000}},  //   nair, _sofo, ggu_,
  { {0x64420011, 0x628a0232, 0x00000000, 0x00000000}},  //   _vcoi, _pofo,   ,
  { {0x7c24002a, 0x78a200ea, 0x443f007f, 0x00000000}},  //   hair, lhov, agu_,
  { {0x3a3701f8, 0x60cf001a, 0x6f0d0652, 0x00000000}},  //   ורים_, tocm, _stac,
  { {0x78a200bb, 0x645b009d, 0xa19301e1, 0x00000000}},  //   nhov, ceui, таюч,
  { {0x44240ad8, 0x7c2400f4, 0x78a2012d, 0x00000000}},  //   mam_, dair, ihov,
  { {0x4424020c, 0x60cf0061, 0x768f0292, 0x00000000}},  //   lam_, socm, _høyr,
  { {0x20c70ad9, 0x7c240549, 0x78a200bb, 0x00000000}},  //   _осиг, fair, khov,
  { {0x44240ada, 0x6f0d001c, 0x7c24002a, 0x00000000}},  //   nam_, _ttac, gair,
  { {0x44240adb, 0x6f0d00e7, 0xfbd00025, 0x00000000}},  // [f90] iam_, _utac, لتك_,
  { {0x4424005f, 0x81c90055, 0x5a34013b, 0x00000000}},  //   ham_, লেও_, кнут,
  { {0x443f0adc, 0x67290091, 0x7c240add, 0x00000000}},  //   ygu_, _svej, bair,
  { {0x44240ade, 0xe8c90061, 0x7c240adf, 0x00000000}},  //   jam_, िकेच, cair,
  { {0xfe7000a1, 0xe7080439, 0x00000000, 0x00000000}},  //   _صدی_, وتون_,   ,
  { {0x81c90044, 0xa01b0010, 0x45190ae0, 0x00000000}},  //   লেট_, gköz, пция_,
  { {0xddde0036, 0x645b00f4, 0x44240142, 0x00000000}},  //   _zapł, teui, fam_,
  { {0x44240149, 0x78a2004f, 0xfdf800b6, 0x00000000}},  //   gam_, chov, וצות_,
  { {0x254e006b, 0x61010089, 0x645b009d, 0x00000000}},  //   _həll_, _vēlm, reui,
  { {0x443f018e, 0x236d0030, 0xf3f90035, 0x00000000}},  //   sgu_, rvej_, deţe_,
  { {0x236d0030, 0xa06a06f3, 0x00000000, 0x00000000}},  //   svej_, пана_,   ,
  { {0x4424020c, 0x20050036, 0x236d0190, 0x00000000}},  //   cam_, ślin_, pvej_,
  { {0x442f0ae1, 0x7c240089, 0x9f4c005d, 0x00000000}},  //   _idg_, vair, _ölüm_,
  { {0x78a20161, 0xa3b80025, 0xdbd9000c, 0x00000000}},  //   zhov, _تامر_, _ræði,
  { {0x7c240ae2, 0x69c70065, 0xc6920097, 0x00000000}},  //   tair, _nxje, נאל_,
  { {0x649c0051, 0xa01b0047, 0x7c2f00f6, 0x00000000}},  //   _léin, zköz, _cdcr,
  { {0x7c24028c, 0x442f0ae3, 0x69cb014a, 0x00000000}},  // [fa0] rair, _mdg_, şgel,
  { {0x442401cd, 0x7c240ae4, 0x4a430893, 0x00000000}},  //   zam_, sair, лнув,
  { {0x44240ae5, 0x442f0059, 0x78a20142, 0x00000000}},  //   yam_, _odg_, thov,
  { {0x44240ae6, 0xafdb01e3, 0xaca800a1, 0x00000000}},  //   xam_, mfør, _کھڑے_,
  { {0x78a20146, 0xa01b0010, 0xafdb043e, 0x00000000}},  //   rhov, tköz, lfør,
  { {0x44240ae7, 0xfaff0023, 0x00000000, 0x00000000}},  //   wam_, _erës_,   ,
  { {0x442f0093, 0xb7bd001a, 0x78a20039, 0x00000000}},  //   _bdg_, _reţe, phov,
  { {0x60c40825, 0x442f00d4, 0x2a6a01f3, 0x00000000}},  //   _njim, _cdg_, _habb_,
  { {0x4424090b, 0x64400004, 0xe73700e3, 0x00000000}},  //   ram_, rgmi, _пет_,
  { {0x44240673, 0x442f0ae8, 0xafdb00ea, 0x00000000}},  //   sam_, _edg_, kfør,
  { {0xf3f90035, 0xa2a6007d, 0x00000000, 0x00000000}},  //   veţe_, टोग्,   ,
  { {0xafdb01e3, 0x39580093, 0x44240312, 0x00000000}},  //   dfør, _mprs_, qam_,
  { {0x610800b9, 0x60c40022, 0x2d8c09b0, 0x00000000}},  //   _děla, _djim, äden_,
  { {0xd36f0014, 0x00000000, 0x00000000, 0x00000000}},  //   _دهه_,   ,   ,
  { {0xafdb08e0, 0x6ee000f8, 0x62880861, 0x00000000}},  //   gfør, möbl, mjdo,
  { {0x11db00b6, 0x60c40ae9, 0x2a6a00fa, 0x00000000}},  //   _מחוב, _gjim, _aabb_,
  { {0x6fb90088, 0x6ad90044, 0x00000000, 0x00000000}},  // [fb0] _ігор_, _ভূগো,   ,
  { {0x60dd0239, 0x39580022, 0x200b00fa, 0x00000000}},  //   llsm, _bprs_, lcci_,
  { {0x649c0aea, 0xb8120044, 0x200b0026, 0x00000000}},  //   _réin, _হয়ত_, occi_,
  { {0x893401b7, 0xb4ca007d, 0x00000000, 0x00000000}},  //   اعلا, लको_,   ,
  { {0x3669003b, 0x649c0051, 0x00000000, 0x00000000}},  //   дало_, _péin,   ,
  { {0x38690aeb, 0xd1380aec, 0x442f0145, 0x00000000}},  //   žar_, krą_, _sdg_,
  { {0x39580011, 0x6abf013d, 0x64a50aed, 0x00000000}},  //   _gprs_, ्वीर, кака,
  { {0x29110032, 0xd1380a67, 0xfaff0023, 0x00000000}},  //   _itza_, drą_, _urës_,
  { {0x2a6a0052, 0x290300e7, 0x3a230085, 0x00000000}},  //   _yabb_, _huja_, _kejp_,
  { {0x29030aee, 0x60d600f8, 0x2366003b, 0x00000000}},  //   _kuja_, _skym, _dsoj_,
  { {0x10a60aef, 0x442f00d4, 0xbbde0164, 0x00000000}},  //   винн, _tdg_, _मर्क,
  { {0x92c30055, 0x442f0af0, 0x629a0af1, 0x00000000}},  //   ্ষে_, _udg_, akto,
  { {0x6f63008b, 0x68e90af2, 0x68fb00fa, 0x00000000}},  //   авяз, _mhed, _miud,
  { {0x7643020c, 0xed5a019d, 0x68fb0006, 0x00000000}},  //   ngny, мог_, _liud,
  { {0x63a901a2, 0x29030af3, 0x00000000, 0x00000000}},  //   lzen, _nuja_,   ,
  { {0xafdb043e, 0x6fb60025, 0x27ff00e0, 0x00000000}},  //   rfør, _لمعا, _ngun_,
  { {0x63a9010f, 0xab2702dc, 0x00000000, 0x00000000}},  // [fc0] nzen, кота_,   ,
  { {0x63a900bb, 0xafdb0292, 0x27ff0022, 0x00000000}},  //   izen, pfør, _agun_,
  { {0x29030181, 0x68fb0006, 0x3eb80af4, 0x00000000}},  //   _cuja_, _biud, mirt_,
  { {0x68fb0af5, 0x68e9027b, 0x649c0af6, 0x00000000}},  //   _ciud, _ched, _céil,
  { {0x649c0051, 0x2d980010, 0x6f040af7, 0x00000000}},  //   _déil, lyre_, _juic,
  { {0x63a90af8, 0x27ff0756, 0x248f00ea, 0x00000000}},  //   dzen, _egun_, _aogm_,
  { {0x649c002a, 0x6846003b, 0x2d980af9, 0x00000000}},  //   _féil, _инва, nyre_,
  { {0x68fb0198, 0x3eb80afa, 0x68e90afb, 0x00000000}},  //   _giud, hirt_, _ghed,
  { {0x69dc0afc, 0x7afc007f, 0x3eb80145, 0x00000000}},  //   _hyre, _kirt, kirt_,
  { {0x6d4e05d5, 0xd1380a67, 0x6108013e, 0x00000000}},  //   ktba, trą_, _děln,
  { {0x629a00bb, 0x6f040022, 0x2d980023, 0x00000000}},  //   rkto, _auic, jyre_,
  { {0x6f040051, 0x69dc0190, 0x4035008b, 0x00000000}},  //   _buic, _myre, ыемс,
  { {0x63a90046, 0x6d4e00bb, 0x6f0401f3, 0x00000000}},  //   czen, etba, _cuic,
  { {0x6f04000a, 0x2d980afd, 0xf773009b, 0x00000000}},  //   _duic, fyre_, בקש_,
  { {0x5c0700a5, 0x69dc032e, 0xb5fc002b, 0x00000000}},  //   вяза, _nyre, _baġi,
  { {0x7afc002a, 0x672d0afe, 0x3eb80051, 0x00000000}},  //   _airt, šaji, airt_,
  { {0x649c002a, 0x7afc0953, 0x68e90aff, 0x00000000}},  // [fd0] _réil, _birt, _rhed,
  { {0x29030129, 0x69dc004e, 0x64950051, 0x00000000}},  //   _puja_, _byre, _háit,
  { {0x69dc01d6, 0x7afc039f, 0x2d8c0030, 0x00000000}},  //   _cyre, _dirt, ødet_,
  { {0x69dc0b00, 0xf8d10055, 0x08d40088, 0x00000000}},  //   _dyre, িষ্ঠ, ація,
  { {0x649c0051, 0x68fb008e, 0x7afc0792, 0x00000000}},  //   _céim, _viud, _firt,
  { {0x6495002a, 0xf7700084, 0x0dba00a1, 0x00000000}},  //   _láit, غان_, _آئیں_,
  { {0x68e9002b, 0x20d90b01, 0xb8120044, 0x00000000}},  //   _thed, néis_, _হযরত_,
  { {0x20050046, 0x63a9010f, 0xe89405b8, 0x00000000}},  //   ślij_, tzen, _кась,
  { {0xe894007c, 0x69dc0023, 0x6108013e, 0x00000000}},  //   _тать, _zyre, _bělo,
  { {0x63a90b02, 0x45450774, 0x69080010, 0x00000000}},  //   rzen, _منطق, _ördö,
  { {0x63a90046, 0x6d4e0203, 0x6108013e, 0x00000000}},  //   szen, xtba, _dělo,
  { {0x20d9008e, 0x23750b03, 0x71a2007e, 0x00000000}},  //   déis_, _ماتح, саюз,
  { {0x6f040038, 0x386d0b04, 0x6e25013f, 0x00000000}},  //   _quic, _maer_, _behb,
  { {0x2d98008d, 0x6d4e02e1, 0x66e30061, 0x00000000}},  //   tyre_, ttba, गतिक_,
  { {0x09be0055, 0x6da30057, 0x332d0b05, 0x00000000}},  //   _অর্থ, бира, lsex_,
  { {0x09e20044, 0x7afc08c0, 0x6f040b06, 0x00000000}},  //   _বললা, _sirt, _tuic,
  { {0x7afc0b07, 0x0aea005e, 0x3eb80065, 0x00000000}},  // [fe0] _pirt, едай_, pirt_,
  { {0x649c002a, 0x0e66007e, 0x20d9008e, 0x00000000}},  //   _réim, _скон, béis_,
  { {0x20d9008e, 0xddde0089, 0x649c0048, 0x00000000}},  //   céis_, _sapņ, _séim,
  { {0x7afc0a80, 0x386d0966, 0x20d90051, 0x00000000}},  //   _wirt, _caer_, léir_,
  { {0x7afc0b08, 0x3ce00b09, 0x7c2601c5, 0x00000000}},  //   _tirt, mliv_, _iekr,
  { {0x20d90051, 0x7afc0051, 0xe9440063, 0x00000000}},  //   néir_, _uirt, _پرسی,
  { {0x2aa40047, 0x6495002a, 0x7c260b0a, 0x00000000}},  //   _több_, _náis, _kekr,
  { {0xa01b0b0b, 0x386d005b, 0x938a00e2, 0x00000000}},  //   ljöv, _gaer_, есоа_,
  { {0x6495002a, 0x5c370049, 0x00000000, 0x00000000}},  //   _ráit, ארפן_,   ,
  { {0x59b8007d, 0xa5da0025, 0x64950048, 0x00000000}},  //   _आधार, _كبار_, _báis,
  { {0x6e25011f, 0xdd120477, 0xba570049, 0x00000000}},  //   _rehb, _rüşv, נסטו_,
  { {0x7c26016e, 0x629d0065, 0x7d05014a, 0x00000000}},  //   _nekr, ësor, _ruhs,
  { {0xe29a008b, 0xe0df0026, 0x91fc0089, 0x00000000}},  //   _пад_, rlò_, edāt,
  { {0x20d90b0c, 0x44260011, 0x7bdd0024, 0x00000000}},  //   téis_, _heo_, _rysu,
  { {0x7c260292, 0x254e006b, 0x44260011, 0x00000000}},  //   _bekr, _bəli_, _keo_,
  { {0x64950051, 0x20d90b0d, 0x3ce00190, 0x00000000}},  //   _háir, réis_, gliv_,
  { {0x7c26002d, 0x44260082, 0x2d8c0030, 0x00000000}},  // [ff0] _dekr, _meo_, øder_,
  { {0x44260b0e, 0x20d90b0f, 0x386d005b, 0x00000000}},  //   _leo_, péis_, _saer_,
  { {0x64950051, 0x7c260066, 0xca48023c, 0x00000000}},  //   _máir, _fekr, المه_,
  { {0x7c260b10, 0xddde00b9, 0x64950048, 0x00000000}},  //   _gekr, _např, _láir,
  { {0xd366007a, 0xddd7005f, 0x2ca90051, 0x00000000}},  //   _به_, _yaxş, mhad_,
  { {0xca490014, 0xe77800a1, 0x44260058, 0x00000000}},  //   _جلسه_, الوں_, _aeo_,
  { {0x44260051, 0x00000000, 0x00000000, 0x00000000}},  //   _beo_,   ,   ,
  { {0x4426003b, 0x332d0146, 0xa4230044, 0x00000000}},  //   _ceo_, tsex_, ফল্য_,
  { {0xd05d005f, 0x44260051, 0x730506e3, 0x00000000}},  //   _üzər, _deo_, јпоз,
  { {0x64950051, 0xe299012b, 0x00000000, 0x00000000}},  //   _páis, тао_,   ,
  { {0x00860b11, 0x91e502be, 0x4426008e, 0x00000000}},  //   ално, роне, _feo_,
  { {0x2c150309, 0x3ce0032e, 0x672d04eb, 0x00000000}},  //   _फ्लू_, xliv_, šaju,
  { {0x81bd0055, 0x20d90051, 0x2ca90b12, 0x00000000}},  //   _আরও_, téir_, dhad_,
  { {0xe29601fe, 0x64950051, 0x7bc0012d, 0x00000000}},  //   _ваш_, _gáir, _žmuo,
  { {0x20d90051, 0x442600e0, 0x8cb60b13, 0x00000000}},  //   réir_, _yeo_, асач,
  { {0x248d0295, 0x2ca90b14, 0x64ba01d5, 0x00000000}},  //   njem_, ghad_, nċip,

  { {0x3b0703dc, 0x249f0b15, 0x20d90051, 0x00000000}},  // [1000] ието_, ikum_, péir_,
  { {0x3ce00b16, 0x249f0180, 0x248d0190, 0x00000000}},  //   sliv_, hkum_, hjem_,
  { {0x186a005e, 0x7c26011f, 0x249f000c, 0x00000000}},  //   кажи_, _tekr, kkum_,
  { {0x3156007b, 0x2ca90b17, 0x248d01d5, 0x00000000}},  //   ייען_, chad_, jjem_,
  { {0x248d0b18, 0x91fc0089, 0x44260082, 0x00000000}},  //   djem_, ndār, _reo_,
  { {0x44260195, 0xfaa60aa2, 0x64590b19, 0x00000000}},  //   _seo_, _таго, _abwi,
  { {0x44260b1a, 0x8af0006b, 0x00000000, 0x00000000}},  //   _peo_, ttəf,   ,
  { {0xd766026c, 0x2ca00b1b, 0x248d0023, 0x00000000}},  //   _پارٹ, nkid_, gjem_,
  { {0x6495002a, 0x44260211, 0xb5fc002b, 0x00000000}},  //   _páir, _veo_, _raġu,
  { {0x6d5e055f, 0x68e20016, 0xd2570088, 0x00000000}},  //   _oppa, llod, ацю_,
  { {0x672d0209, 0x64a60b1c, 0x69130066, 0x00000000}},  //   šajt, _кажа, _għed,
  { {0x249f06be, 0xd83f01ca, 0xd13000a1, 0x00000000}},  //   ckum_, _účtu_, _ہمت_,
  { {0x6495002a, 0x6d5e06e2, 0x657a0009, 0x00000000}},  //   _táir, _appa, _hrth,
  { {0x68e20061, 0xd065006b, 0x539b009b, 0x00000000}},  //   hlod, _əsər, _בידו,
  { {0x3cf30204, 0x6143025f, 0x61130035, 0x00000000}},  //   ंगले_, _деја, _căld,
  { {0x76b20036, 0xbd440025, 0x00000000, 0x00000000}},  //   pływ, تنفي,   ,
  { {0x90a7025a, 0x2ca90b1d, 0x5a35005e, 0x00000000}},  // [1010] _محکم, rhad_, йнат,
  { {0xda78007c, 0x2ca90b1e, 0x657a0122, 0x00000000}},  //   иях_, shad_, _orth,
  { {0xceb200bd, 0x83fd0010, 0x249f0b1f, 0x00000000}},  //   _זיי_, ndőr, ykum_,
  { {0x2ca00009, 0x68e2005b, 0x00000000, 0x00000000}},  //   ckid_, glod,   ,
  { {0x7c2d010e, 0x291a08a6, 0x96b9003b, 0x00000000}},  //   maar, appa_, луку_,
  { {0x7c2d0b20, 0x5b140088, 0x7b3d00e5, 0x00000000}},  //   laar, _ємст, _căuş,
  { {0x248d0059, 0xd5750b21, 0x6d9e002b, 0x00000000}},  //   tjem_, суль, _għaġ,
  { {0x58d401be, 0x7c2d0343, 0x64950048, 0x00000000}},  //   _дост, naar, _cáip,
  { {0xf77300a2, 0x248d0059, 0x657a018e, 0x00000000}},  //   _باز_, rjem_, _erth,
  { {0x249f0b22, 0x248d089f, 0x777b0288, 0x00000000}},  //   skum_, sjem_, _irux,
  { {0x7c2d017d, 0x6f160b23, 0xfa980049, 0x00000000}},  //   kaar, _styc, ידזש_,
  { {0x64590061, 0x7c2d0a2a, 0x00000000, 0x00000000}},  //   _ubwi, jaar,   ,
  { {0x442d0acd, 0xf4560879, 0x116700a1, 0x00000000}},  //   mae_, _طلوع_, _چلتی_,
  { {0x442d0b24, 0x644903d0, 0xd839000a, 0x00000000}},  //   lae_, lgei, _blōk_,
  { {0x6da3005e, 0x62830b25, 0xf1cf0164, 0x00000000}},  //   пира, _inno, _सुचन,
  { {0x7c2d0030, 0x64490b26, 0xdd8f03ab, 0x00000000}},  //   gaar, ngei, روق_,
  { {0x09b50055, 0xbebb0065, 0x7e9a0084, 0x00000000}},  // [1020] _জুলা, rsër, _منظر_,
  { {0xe3a7026c, 0x442d0abb, 0x2ca00b27, 0x00000000}},  //   _ہر_, hae_, skid_,
  { {0x9e7b007b, 0x7c2d01b5, 0x7bcf01cb, 0x00000000}},  //   _ענטפ, baar, _excu,
  { {0x6c8601b7, 0x777b00f4, 0xe3a7004b, 0x00000000}},  //   _الحم, _brux, _فر_,
  { {0x442d0b28, 0x628300c7, 0x68e20146, 0x00000000}},  //   dae_, _onno, rlod,
  { {0xcd29089d, 0x68e20b29, 0xa01b00f8, 0x00000000}},  //   _حسین_, slod, njör,
  { {0x2b400115, 0x64950051, 0xb99601b7, 0x00000000}},  //   lric_, _páip, _الزب,
  { {0x62830b2a, 0x6e2e0b2b, 0x5fc80164, 0x00000000}},  //   _anno, habb, रपाल,
  { {0xdc9b007b, 0x213e018e, 0x657a018e, 0x00000000}},  //   טיקל, wrth_, _wrth,
  { {0x290a0b2c, 0x78a20428, 0x6e2e0b2d, 0x00000000}},  //   _kuba_, lkov, jabb,
  { {0x290a0004, 0x442d006a, 0x867b00b6, 0x00000000}},  //   _juba_, bae_, _תרבו,
  { {0x290a0022, 0xa49200a2, 0x2fc60b2e, 0x00000000}},  //   _muba_, _ریخت, _žoga_,
  { {0x7c2d0168, 0x6234025f, 0xa01b000c, 0x00000000}},  //   vaar, _делу, fjör,
  { {0x29180b2f, 0x7c2d015c, 0xa01b000c, 0x00000000}},  //   _otra_, waar, gjör,
  { {0x8af0005f, 0x6ca701fb, 0x7c2d006c, 0x00000000}},  //   ktəb, браж, taar,
  { {0x78a20b30, 0xfc3f000c, 0x2b400048, 0x00000000}},  //   jkov, _elín_, fric_,
  { {0x7c2d00b5, 0x60cd0061, 0x6e2e002b, 0x00000000}},  // [1030] raar, _ijam, babb,
  { {0x7c2d0b31, 0xff500025, 0x6f1d00d9, 0x00000000}},  //   saar, _أخي_, mpsc,
  { {0x290a0127, 0x7c2d0168, 0x29180b32, 0x00000000}},  //   _cuba_, paar, _ctra_,
  { {0xec6b01e0, 0xfc3f01dc, 0x2b400133, 0x00000000}},  //   _срок_, _zlín_, bric_,
  { {0x6d55022b, 0x6d470142, 0x2b4000d4, 0x00000000}},  //   ltza, luja, cric_,
  { {0x29070b33, 0x6d550b34, 0xb7c60089, 0x00000000}},  //   ínas_, otza, diģē,
  { {0x6d550756, 0x64490253, 0x6d470059, 0x00000000}},  //   ntza, tgei, nuja,
  { {0x6d55022b, 0x78a20161, 0x60cd0020, 0x00000000}},  //   itza, ckov, _njam,
  { {0x442d0b35, 0x9868026c, 0xc64b0426, 0x00000000}},  //   rae_, _دینے_, _مجال_,
  { {0x442d0b36, 0x27ed002d, 0x6d470b37, 0x00000000}},  //   sae_, _izen_, kuja,
  { {0x29180b38, 0x208a0b39, 0x71b5007c, 0x00000000}},  //   _xtra_, айни_, ющих,
  { {0x25d600bd, 0x6d470027, 0x6abe0b3a, 0x00000000}},  //   _ווען_, duja, zipf,
  { {0x78a90b3b, 0x60cd000c, 0x6e2e002b, 0x00000000}},  //   _mlev, _djam, tabb,
  { {0x78a90b3c, 0x62830b3d, 0x78a201ca, 0x00000000}},  //   _llev, _unno, zkov,
  { {0xde0301fb, 0x6e2e0a19, 0x78a90b3e, 0x00000000}},  //   дпри, rabb, _olev,
  { {0x2b400b3f, 0x6e2e0010, 0x8b26022a, 0x00000000}},  //   tric_, sabb, ждае,
  { {0x78a20161, 0x6d55022b, 0x7eab011f, 0x00000000}},  // [1040] vkov, atza, _süpe,
  { {0x2b400719, 0x6d47008e, 0x78a9014a, 0x00000000}},  //   rric_, buja, _alev,
  { {0x78a20428, 0x78a90018, 0x386601aa, 0x00000000}},  //   tkov, _blev, teor_,
  { {0x290a0009, 0x80370049, 0x78a900ab, 0x00000000}},  //   _vuba_, ַנצע_, _clev,
  { {0x8af0006b, 0x61e30190, 0x38660b40, 0x00000000}},  //   rtəb, _lynl, reor_,
  { {0x78a20b41, 0x649c0051, 0x290a006c, 0x00000000}},  //   skov, _léit, _tuba_,
  { {0x27ed0b42, 0x98a6005e, 0x78a90b43, 0x00000000}},  //   _ezen_, _диве, _flev,
  { {0xd91b00b3, 0x78a900d4, 0x00000000, 0x00000000}},  //   _כולל, _glev,   ,
  { {0xccf301f8, 0xf3660088, 0x00000000, 0x00000000}},  //   וכה_, ітин,   ,
  { {0x29040b44, 0x60cd0b45, 0x78a90b46, 0x00000000}},  //   _hima_, _sjam, _zlev,
  { {0x61e3018e, 0x290400e7, 0x27e40075, 0x00000000}},  //   _cynl, _kima_, _hymn_,
  { {0x290400ca, 0x00000000, 0x00000000, 0x00000000}},  //   _jima_,   ,   ,
  { {0x24860b47, 0x78fb00a3, 0x649c0048, 0x00000000}},  //   _inom_, יפטו, _déit,
  { {0x26dc01cd, 0x2904033b, 0x6d470b48, 0x00000000}},  //   novo_, _lima_, tuja,
  { {0x621b00a0, 0x61e3018e, 0xdcbb0b49, 0x00000000}},  //   _דווק, _gynl, аща_,
  { {0x6d55022b, 0x29040059, 0x26dc0059, 0x00000000}},  //   rtza, _nima_, hovo_,
  { {0x26dc0b4a, 0x24860091, 0x62980b4b, 0x00000000}},  // [1050] kovo_, _mnom_, _kovo,
  { {0x78a90224, 0x78bb0107, 0x6d470b4c, 0x00000000}},  //   _slev, _smuv, puja,
  { {0x26dc0006, 0x89d90025, 0x24860091, 0x00000000}},  //   dovo_, حوار_, _onom_,
  { {0xf7710379, 0x62980b4d, 0x29040b4e, 0x00000000}},  //   فات_, _lovo, _cima_,
  { {0x7c22008e, 0x2904010e, 0x0a6b003b, 0x00000000}},  //   ñore, _dima_, _крви_,
  { {0xd6db098c, 0x26dc0059, 0xaa6409da, 0x00000000}},  //   ште_, govo_, _отск,
  { {0x6f0d0051, 0x170500a1, 0xa9540088, 0x00000000}},  //   _luac, _کہتی_, _окрі,
  { {0x78bb0b4f, 0x27ed002d, 0x20090082, 0x00000000}},  //   _umuv, _tzen_, _ngai_,
  { {0x6f0d002a, 0x649c002a, 0xf77000f3, 0x00000000}},  //   _nuac, _réit, _لال_,
  { {0xd2a9007c, 0x62980b50, 0x649c0b51, 0x00000000}},  //   ское_, _covo, _béis,
  { {0x216909f1, 0x60dd000a, 0x67290066, 0x00000000}},  //   щини_, fosm, _hwej,
  { {0x92cb0044, 0x60dd0107, 0x6f0d0051, 0x00000000}},  //   লতে_, gosm, _buac,
  { {0x7ea200f4, 0x61fe0428, 0x6f0d003f, 0x00000000}},  //   _hôpi, _úpln, _cuac,
  { {0x62980295, 0x5239007b, 0xe3b00167, 0x00000000}},  //   _govo, _הײַנ, _جرم_,
  { {0xf3f9001a, 0xb7bd001a, 0x91e2007c, 0x00000000}},  //   deţi_, _deţi, _поше,
  { {0x649c002a, 0x60dd008e, 0x236d0036, 0x00000000}},  //   _héir, cosm, owej_,
  { {0x6b630b52, 0x6f0d008e, 0x29040b53, 0x00000000}},  // [1060] нкта, _guac, _rima_,
  { {0x6d41002a, 0x29040010, 0xf3f90035, 0x00000000}},  //   álac, _sima_, geţi_,
  { {0xfe9b01ce, 0x5e9b009b, 0x29040258, 0x00000000}},  //   _היימ, _הביק, _pima_,
  { {0x649c002a, 0x7b0900ca, 0x29040066, 0x00000000}},  //   _léir, _džub, _qima_,
  { {0x7c24003f, 0x26dc0340, 0x66e60088, 0x00000000}},  //   mbir, tovo_, пода,
  { {0x24860b54, 0xf3f9001a, 0x7c240288, 0x00000000}},  //   _snom_, ceţi_, lbir,
  { {0x26dc09fc, 0x29040091, 0x00000000, 0x00000000}},  //   rovo_, _tima_,   ,
  { {0x7c240051, 0x7d06002b, 0x27e903b2, 0x00000000}},  //   nbir, _jiks, żana_,
  { {0x7d06021e, 0xf74301fc, 0x7c240a15, 0x00000000}},  //   _miks, _пето, ibir,
  { {0x7d0600d8, 0x0bb7009b, 0x61130035, 0x00000000}},  //   _liks, פלים_, _săla,
  { {0xb7bd001a, 0x7c240b55, 0x649c0048, 0x00000000}},  //   _reţi, kbir, _déir,
  { {0x7d060b56, 0x75d30025, 0x24860b57, 0x00000000}},  //   _niks, _ثيما, _unom_,
  { {0x7c240b58, 0x62980059, 0x6f0d0082, 0x00000000}},  //   dbir, _tovo, _quac,
  { {0xd24f0b59, 0xdb23026c, 0xef1f006b, 0x00000000}},  //   _منه_, ہوری, rpü_,
  { {0x7d060089, 0x00000000, 0x00000000, 0x00000000}},  //   _biks,   ,   ,
  { {0x7c240b5a, 0x6f0d096a, 0x44240022, 0x00000000}},  //   gbir, _tuac, nbm_,
  { {0x2d8c0b5b, 0x7d060b5c, 0xf3f9001a, 0x00000000}},  // [1070] äder_, _diks, teţi_,
  { {0xed4e00a1, 0x0dcb0b5d, 0x7c240288, 0x00000000}},  //   دھی_, _гуми_, abir,
  { {0x7c240b5e, 0xa90701f7, 0xa3de0061, 0x00000000}},  //   bbir, سبان, _दुस_,
  { {0xe9f80088, 0x6ef20190, 0x00000000, 0x00000000}},  //   їнці_, ræbe,   ,
  { {0x3b640265, 0x69130066, 0x00000000, 0x00000000}},  //   _първ, _għen,   ,
  { {0x64470006, 0x45190401, 0x3ce90023, 0x00000000}},  //   ėjim, оция_, llav_,
  { {0x7e7700f8, 0x6724001e, 0x00000000, 0x00000000}},  //   _maxp, ģija,   ,
  { {0xc952009b, 0x8af0006b, 0x2d810087, 0x00000000}},  //   _שמן_, ntən, _mrhe_,
  { {0x2d57011f, 0x649c0051, 0x00000000, 0x00000000}},  //   hçe_, _péir,   ,
  { {0x2d57014a, 0x7c2f0068, 0x957c00b4, 0x00000000}},  //   kçe_, _lecr, _cząs,
  { {0x9046007a, 0x3ce901aa, 0xf4870b5f, 0x00000000}},  //   ونده, klav_, _нудн,
  { {0xcea9007b, 0x7c2f0129, 0x7c24006b, 0x00000000}},  //   _די_, _necr, xbir,
  { {0x7d06093b, 0x00000000, 0x00000000, 0x00000000}},  //   _riks,   ,   ,
  { {0x7d060b60, 0xa1c50088, 0x442f01d6, 0x00000000}},  //   _siks, _облд, _heg_,
  { {0xfce602e9, 0x7c240095, 0x8af0006b, 0x00000000}},  //   дово, tbir, ftən,
  { {0x442f01e3, 0x3ce90059, 0x7c2f0544, 0x00000000}},  //   _jeg_, glav_, _cecr,
  { {0x442f0b61, 0x7c240b62, 0x7c2f0b63, 0x00000000}},  // [1080] _meg_, rbir, _decr,
  { {0x4a4300ed, 0x7d060b64, 0x442f0b65, 0x00000000}},  //   кнув, _wiks, _leg_,
  { {0x7d060b66, 0xa96a01f7, 0xd9100014, 0x00000000}},  //   _tiks, تمام_, ایر_,
  { {0x442f0b67, 0x3ce90802, 0x7c2f00bb, 0x00000000}},  //   _neg_, clav_, _gecr,
  { {0x69d501a2, 0xafdb0190, 0x00000000, 0x00000000}},  //   _exze, lgør,   ,
  { {0x442f0004, 0xd7f90088, 0x00000000, 0x00000000}},  //   _aeg_, чує_,   ,
  { {0x442f0145, 0xafdb0637, 0x443d0846, 0x00000000}},  //   _beg_, ngør, _bdw_,
  { {0x442f005b, 0x9855007e, 0xb05b0052, 0x00000000}},  //   _ceg_, _птуш, nnät,
  { {0x442f0b68, 0x443d0b69, 0xfc3f000c, 0x00000000}},  //   _deg_, _ddw_, _slík_,
  { {0x6722007f, 0x00000000, 0x00000000, 0x00000000}},  //   mpoj,   ,   ,
  { {0x6722001e, 0x443d008e, 0x442f0b6a, 0x00000000}},  //   lpoj, _fdw_, _feg_,
  { {0x3cfa013d, 0x442f0b6b, 0x14170025, 0x00000000}},  //   ्दों_, _geg_, _قيمة_,
  { {0xceeb0b6c, 0x7c2f032c, 0x26ce0197, 0x00000000}},  //   قرآن_, _recr, onfo_,
  { {0x442f00b5, 0x2d57014a, 0x00000000, 0x00000000}},  //   _zeg_, tçe_,   ,
  { {0x26ce006c, 0x9d18017f, 0xafdb0030, 0x00000000}},  //   info_, дост_, ggør,
  { {0x9f550088, 0x2cb20016, 0x6aae0023, 0x00000000}},  //   _звич, ghyd_, _albf,
  { {0x7c220b6d, 0x7c2f0089, 0x7e770133, 0x00000000}},  // [1090] ñora, _vecr, _taxp,
  { {0x3ce904c8, 0x2a7801a3, 0x7d1e00d9, 0x00000000}},  //   slav_, _carb_, _ftps,
  { {0x7c2f011f, 0x2a78002b, 0x6913002b, 0x00000000}},  //   _tecr, _darb_, _għel,
  { {0x2cb2018e, 0x20190010, 0x20d900f6, 0x00000000}},  //   chyd_, ncsi_, géix_,
  { {0x442f0b6e, 0x628a0061, 0xe76b031d, 0x00000000}},  //   _reg_, _onfo, تحان_,
  { {0x442f0292, 0x443d01f3, 0x9967073b, 0x00000000}},  //   _seg_, _sdw_, _отбл,
  { {0x442f0145, 0x26c904eb, 0xb05b0b6f, 0x00000000}},  //   _peg_, đao_, nnäs,
  { {0x628a0b70, 0x2ca900f8, 0x00000000, 0x00000000}},  //   _anfo, nkad_,   ,
  { {0x442f0b71, 0xe3b10025, 0x6e350288, 0x00000000}},  //   _veg_, طرة_, kazb,
  { {0x442f0b72, 0x29110117, 0x00000000, 0x00000000}},  //   _weg_, _kuza_,   ,
  { {0x442f0b73, 0x2ca9006c, 0x2f1400f8, 0x00000000}},  //   _teg_, kkad_, _säg_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xc0000055, 0x2ca90717, 0xe3ae0121, 0x00000000}},  //   ূর্ণ_, dkad_, _сб_,
  { {0x539a0097, 0x2f140039, 0xafdb0030, 0x00000000}},  //   _מינו, _väg_, tgør,
  { {0x98a700b9, 0xacf600ec, 0xd24e0025, 0x00000000}},  //   éně_, ечај, _انى_,
  { {0x2ca900e0, 0x00000000, 0x00000000, 0x00000000}},  //   gkad_,   ,   ,
  { {0xcb670140, 0x60d7009b, 0xbb430a85, 0x00000000}},  // [10a0] нате_, _רופא_, летк,
  { {0x2911031a, 0x60c60b74, 0x69130066, 0x00000000}},  //   _buza_, likm, _iħej,
  { {0xc87902b9, 0xc86600e3, 0x29110035, 0x00000000}},  //   _baş_, етли, _cuza_,
  { {0x6d4e0009, 0x2ca90039, 0x60c604cb, 0x00000000}},  //   muba, ckad_, nikm,
  { {0x6d5c0211, 0xb05b0b75, 0x7c3600e0, 0x00000000}},  //   ltra, onär, mayr,
  { {0x26ce0b76, 0x7c36006b, 0x69130066, 0x00000000}},  //   unfo_, layr, _mħej,
  { {0x6d4e0111, 0x672204eb, 0x2366016e, 0x00000000}},  //   nuba, spoj, _spoj_,
  { {0x6d5c0b77, 0x09e30b5f, 0xb05b01a2, 0x00000000}},  //   itra, _сосн, hnär,
  { {0x68e2006c, 0x6d4e011c, 0x60c60022, 0x00000000}},  //   mood, huba, dikm,
  { {0x6d4e000b, 0x6d5c0059, 0x8af0005f, 0x00000000}},  //   kuba, ktra, xtəl,
  { {0xe3af00d3, 0xc879047f, 0x6d5c0626, 0x00000000}},  //   لری_, _yaş_, jtra,
  { {0xe61f001d, 0x68e20168, 0x60c6000a, 0x00000000}},  //   _đôi_, nood, gikm,
  { {0xdefb007c, 0x6d5c010e, 0x00000000, 0x00000000}},  //   зыв_, etra,   ,
  { {0x6d5c010f, 0x628a00ab, 0xb8160044, 0x00000000}},  //   ftra, _unfo, ারিত_,
  { {0x6d5c011c, 0xc27b009b, 0x68e2003c, 0x00000000}},  //   gtra, _מרגי, kood,
  { {0x8af0006b, 0x6143012b, 0xdef801d5, 0x00000000}},  //   stəl, _сећа, ċċa_,
  { {0x29110091, 0x6d5c0b78, 0x2ca90039, 0x00000000}},  // [10b0] _suza_, atra, rkad_,
  { {0x2ca900f8, 0x6d4e0145, 0x8af0006b, 0x00000000}},  //   skad_, buba, qtəl,
  { {0xc984025f, 0x7c360b79, 0x6d4e00ab, 0x00000000}},  //   луци, bayr, cuba,
  { {0x61ea00c4, 0xcd96009b, 0x7afe01d6, 0x00000000}},  //   _myfl, _סדרת_, ampt,
  { {0x4c9a019b, 0x00000000, 0x00000000, 0x00000000}},  //   _חברו,   ,   ,
  { {0x07a20b7a, 0x29110066, 0xc668003b, 0x00000000}},  //   рашн, _tuza_, ешће_,
  { {0x68e20168, 0xc879014a, 0xd5750b7b, 0x00000000}},  //   bood, _taş_, туль,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6d4e0b7c, 0x6d5c0b7d, 0x77550a85, 0x00000000}},  //   zuba, ztra, _шкаф,
  { {0x6d5c0056, 0x6d4e0b7e, 0x00000000, 0x00000000}},  //   ytra, yuba,   ,
  { {0x61ea018e, 0x26c70b7f, 0x6d5c00f8, 0x00000000}},  //   _cyfl, mino_, xtra,
  { {0xf485026c, 0x6d5c07f9, 0x3cf901d6, 0x00000000}},  //   _جائی, vtra, _nhsv_,
  { {0x6d5c002b, 0x3f8401dc, 0xb05b0039, 0x00000000}},  //   wtra, ímu_, tnär,
  { {0x6d5c002b, 0x6d4e0b80, 0x60c6023a, 0x00000000}},  //   ttra, tuba, sikm,
  { {0x61ea018e, 0xed5700ed, 0xddc30b81, 0x00000000}},  //   _gyfl, кор_, абри,
  { {0x6d4e020c, 0x26c70207, 0x6d5c03a1, 0x00000000}},  //   ruba, hino_, rtra,
  { {0x26c70006, 0x387d0016, 0x6d4e011c, 0x00000000}},  // [10c0] kino_, ddwr_, suba,
  { {0x68e20061, 0x26c70059, 0x0f370049, 0x00000000}},  //   wood, jino_, _שריט_,
  { {0x26c70119, 0xfbd100a1, 0x68e2006c, 0x00000000}},  //   dino_, لتے_, tood,
  { {0xd3080082, 0xdca60478, 0x2b490b82, 0x00000000}},  //   _hệt_, _рами, brac_,
  { {0xdb0a0048, 0x68e20b83, 0x00000000, 0x00000000}},  //   únói, rood,   ,
  { {0x26c705fc, 0xb05b010f, 0x68e20b84, 0x00000000}},  //   gino_, hnäp, sood,
  { {0xceb300b6, 0xd3080011, 0xd5af0380, 0x00000000}},  //   שיו_, _mệt_, يفه_,
  { {0x98a300d7, 0x60c400e0, 0x982800a1, 0x00000000}},  //   _кисе, _nmim, _سترہ_,
  { {0x26c70059, 0x98a30140, 0xf9f40044, 0x00000000}},  //   bino_, _тите, _জলিল_,
  { {0x26c70207, 0x00000000, 0x00000000, 0x00000000}},  //   cino_,   ,   ,
  { {0x4035007e, 0x3a37009b, 0xaa370049, 0x00000000}},  //   ленс, כרים_, כטיק_,
  { {0x7f5d001c, 0x60c40065, 0xd250025a, 0x00000000}},  //   ttsq, _cmim, جنگ_,
  { {0x2d8c05cc, 0x64420032, 0x2d9e0b85, 0x00000000}},  //   åden_, _idoi, äten_,
  { {0x41dd0309, 0x60c4013e, 0x00000000, 0x00000000}},  //   _नुकस, _emim,   ,
  { {0xd3080011, 0x2d850051, 0x7b0901c5, 0x00000000}},  //   _dệt_, íle_, _džul,
  { {0x2b49023a, 0x60d60023, 0x1fa70b86, 0x00000000}},  //   trac_, _gjym, _арог,
  { {0x0bf50b87, 0x09bd0309, 0x9be70088, 0x00000000}},  // [10d0] упаю, ्प्य, тівк,
  { {0x6d480b88, 0xdd03005d, 0x629a0023, 0x00000000}},  //   ádac, ırıc, njto,
  { {0x26c70059, 0x81e40055, 0x6cd50879, 0x00000000}},  //   vino_, পের_, _مقدا,
  { {0x78a0013e, 0x64420048, 0x00000000, 0x00000000}},  //   _comv, _ndoi,   ,
  { {0x26c70207, 0x3ea10b89, 0x7b090006, 0x00000000}},  //   tino_, _koht_, _užuo,
  { {0x644201a3, 0x00000000, 0x00000000, 0x00000000}},  //   _adoi,   ,   ,
  { {0x26c70198, 0x00000000, 0x00000000, 0x00000000}},  //   rino_,   ,   ,
  { {0x26c70181, 0xf773025a, 0x00000000, 0x00000000}},  //   sino_, _پار_,   ,
  { {0x26c7006a, 0xdce5001e, 0x130902d3, 0x00000000}},  //   pino_, _arhī, нний_,
  { {0xd7f80088, 0x6b670089, 0x3ea100ca, 0x00000000}},  //   _рус_, mīgā, _noht_,
  { {0x24550879, 0x27fa0036, 0x68fb0022, 0x00000000}},  //   _مناس, ępne_, _khud,
  { {0xd3080082, 0x00000000, 0x00000000, 0x00000000}},  //   _sệt_,   ,   ,
  { {0x7ae50368, 0x68fb00e7, 0x27ed000a, 0x00000000}},  //   koht, _mhud, _jyen_,
  { {0x7ae500b0, 0x63a90058, 0x63bb00e7, 0x00000000}},  //   joht, myen, mzun,
  { {0x27ed0263, 0x925606e3, 0x8af0006b, 0x00000000}},  //   _lyen_, _сајт_, stək,
  { {0x60c40058, 0x27ed004a, 0x00000000, 0x00000000}},  //   _umim, _oyen_,   ,
  { {0x8b26008b, 0x63a904cb, 0x63bb0b8a, 0x00000000}},  // [10e0] удзе, nyen, nzun,
  { {0xfeba007a, 0x290d0b8b, 0x7e56003b, 0x00000000}},  //   _ساخت_, _aiea_, _стиц,
  { {0x09f6022a, 0x27ed0173, 0xa84a0025, 0x00000000}},  //   учая, _ayen_, فلام_,
  { {0x27ed0b8c, 0x7e7e0b8d, 0x68fb0142, 0x00000000}},  //   _byen_, _happ, _chud,
  { {0x7e7e00b0, 0x7c95007e, 0x96ea085f, 0x00000000}},  //   _kapp, _трэц, нька_,
  { {0x7e7e01d5, 0xddc70165, 0x66e30147, 0x00000000}},  //   _japp, lejš, боча,
  { {0x7e7e0198, 0x7b090209, 0x6b840277, 0x00000000}},  //   _mapp, _ožuj, lvig,
  { {0x7e7e00b0, 0xddc70b8e, 0x3a3a0b8f, 0x00000000}},  //   _lapp, nejš, lapp_,
  { {0x63a90047, 0x6b8402e1, 0xa3de007d, 0x00000000}},  //   gyen, nvig, _दुख_,
  { {0x7e7e0b90, 0x3a3a00f8, 0xf1260b91, 0x00000000}},  //   _napp, napp_, льмо,
  { {0x6b84010e, 0x63a901c3, 0x00000000, 0x00000000}},  //   hvig, ayen,   ,
  { {0x657a00ea, 0x6f160b92, 0x63a90146, 0x00000000}},  //   _isth, _buyc, byen,
  { {0x7e7e023a, 0x4fc7005e, 0x3a3a0894, 0x00000000}},  //   _bapp, усна, kapp_,
  { {0x7e7e07c5, 0x00000000, 0x00000000, 0x00000000}},  //   _capp,   ,   ,
  { {0x7e7e0b93, 0xccfb012b, 0x7eb0006c, 0x00000000}},  //   _dapp, ећа_, _täpn,
  { {0x657a0009, 0x61f80295, 0x00000000, 0x00000000}},  //   _msth, _izvl,   ,
  { {0x5a35053c, 0x7ae50b94, 0x68fb005b, 0x00000000}},  // [10f0] инат, toht, _rhud,
  { {0x7e7e01f3, 0x68fb0b95, 0x6b670089, 0x00000000}},  //   _gapp, _shud, vīgā,
  { {0x7ae50b96, 0xb81500ed, 0x1ed80379, 0x00000000}},  //   roht, адеј, _حبيب_,
  { {0xf7710137, 0x3f890b97, 0x765a00d9, 0x00000000}},  //   قات_, _krau_, _acty,
  { {0x7c2d0b98, 0x3a3a0b99, 0x7e7e0b9a, 0x00000000}},  //   mbar, bapp_, _yapp,
  { {0x6b670089, 0xe4630180, 0x3a3a0026, 0x00000000}},  //   rīgā, şmüş, capp_,
  { {0x7d0f0047, 0x5e580049, 0x68fb0b9b, 0x00000000}},  //   _kics, טיגע_, _thud,
  { {0x93450797, 0x63bb0577, 0x58d50088, 0x00000000}},  //   ание, tzun, _тобт,
  { {0x657a00f4, 0x7c2d0032, 0x63bb0b9c, 0x00000000}},  //   _esth, ibar, uzun,
  { {0x52a90b9d, 0x387f002d, 0x63a9011c, 0x00000000}},  //   твом_, _haur_, ryen,
  { {0x7c2d00b5, 0x7e7e0b9e, 0x3f89002d, 0x00000000}},  //   kbar, _rapp, _arau_,
  { {0x7e7e01bc, 0x7c2d0036, 0x3f890a16, 0x00000000}},  //   _sapp, jbar, _brau_,
  { {0x442d000b, 0x7e7e0039, 0xddc70b9f, 0x00000000}},  //   mbe_, _papp, vejš,
  { {0x442d010f, 0x321e0009, 0x7b09016c, 0x00000000}},  //   lbe_, ccty_, _džuk,
  { {0x3f89001a, 0x3c420010, 0x7a40000c, 0x00000000}},  //   _erau_, _lévő_, hátí,
  { {0x0c260517, 0x442d0263, 0x3f89010f, 0x00000000}},  //   рман, nbe_, _frau_,
  { {0x3f8906c0, 0xddc701d9, 0x2c010061, 0x00000000}},  // [1100] _grau_, rejš, लेलं_,
  { {0x6b8400cd, 0x62810652, 0x7c2d0288, 0x00000000}},  //   rvig, ndlo, abar,
  { {0x6e3c004e, 0x7c2d0039, 0x81e70055, 0x00000000}},  //   marb, bbar, _মৃত_,
  { {0x6e3c0002, 0x387f0089, 0x442d016e, 0x00000000}},  //   larb, _caur_, jbe_,
  { {0x7d040ba0, 0x442d01d9, 0xdddc0010, 0x00000000}},  //   mmis, dbe_, merő,
  { {0x7d040368, 0x6b8b0030, 0x442d010f, 0x00000000}},  //   lmis, ægge, ebe_,
  { {0xd943003b, 0x3856005e, 0x387f00e5, 0x00000000}},  //   _мери, _възс, _faur_,
  { {0x387f0ba1, 0x48e303e8, 0x6e3c002d, 0x00000000}},  //   _gaur_, _досв, harb,
  { {0x7d040ba2, 0x6e3c002d, 0x2918002d, 0x00000000}},  //   imis, karb, _hura_,
  { {0x29180ba3, 0xc5fd0044, 0x7d040ba4, 0x00000000}},  //   _kura_, ুড়া_, hmis,
  { {0x6e3c0ba5, 0x442d0198, 0x29180ba6, 0x00000000}},  //   darb, bbe_, _jura_,
  { {0x29180ba7, 0xd57700b6, 0x386605ba, 0x00000000}},  //   _mura_, _כתבה_, nfor_,
  { {0x7d040004, 0x291801d5, 0x7c2d0ba8, 0x00000000}},  //   dmis, _lura_, vbar,
  { {0x6e3c0006, 0x2bf0013d, 0x7c2d00bb, 0x00000000}},  //   garb, _आरजू_, wbar,
  { {0x02fb0104, 0x7d0f0232, 0x7d040190, 0x00000000}},  //   _שלומ, _pics, fmis,
  { {0xb035025f, 0xc03501fc, 0x7c2d0ba9, 0x00000000}},  //   _униш, _униј, ubar,
  { {0x7c2d0149, 0x29180baa, 0x5c07005e, 0x00000000}},  // [1110] rbar, _aura_, рява,
  { {0x7c2d0bab, 0x7d040bac, 0x442d016e, 0x00000000}},  //   sbar, amis, zbe_,
  { {0x29180bad, 0x442d0bae, 0x7d0400ab, 0x00000000}},  //   _cura_, ybe_, bmis,
  { {0x7c950025, 0x442d0066, 0x6205006b, 0x00000000}},  //   _الحص, xbe_, ürlə,
  { {0x7bd8011f, 0x6d550baf, 0x442d0142, 0x00000000}},  //   şvur, luza, vbe_,
  { {0x1fd90044, 0x29180bb0, 0x442d000a, 0x00000000}},  //   _সরাস, _fura_, wbe_,
  { {0x6a22026c, 0x291804f8, 0x20d20027, 0x00000000}},  //   _رہنم, _gura_, lšie_,
  { {0x6f1d001c, 0x442d010f, 0x9dd8009b, 0x00000000}},  //   kqsc, ube_, יווק_,
  { {0x7c22008e, 0x6e3c014a, 0x29180bb1, 0x00000000}},  //   ñori, yarb, _zura_,
  { {0x7d04037e, 0x442d0880, 0x6d550bb2, 0x00000000}},  //   zmis, sbe_, kuza,
  { {0x62810007, 0xd298008b, 0x7d04021e, 0x00000000}},  //   rdlo, ртыі_, ymis,
  { {0xcea901f8, 0x2b4000f6, 0x6d550bb3, 0x00000000}},  //   _אי_, ysic_, duza,
  { {0x6e3c010f, 0x20d20027, 0xd34100a1, 0x00000000}},  //   tarb, jšie_, _عہدی,
  { {0x249f07e0, 0x6d55001a, 0x7e230143, 0x00000000}},  //   ljum_, fuza, здрж,
  { {0x7d040004, 0x6e3c010f, 0x6d550032, 0x00000000}},  //   tmis, rarb, guza,
  { {0x6e3c04d3, 0xceb4006b, 0x3a380bb4, 0x00000000}},  //   sarb, _atət_, _serp_,
  { {0x7e7508e2, 0x29180020, 0x6a160a4f, 0x00000000}},  // [1120] bezp, _sura_, مبار,
  { {0x3f8f0181, 0x6d5501f3, 0x2b400bb5, 0x00000000}},  //   _água_, buza, rsic_,
  { {0x5d860025, 0x8fc50014, 0xd23a0049, 0x00000000}},  //   _الجل, _هزین, רגעל,
  { {0x3a3801d6, 0x29180350, 0x00000000, 0x00000000}},  //   _werp_, _vura_,   ,
  { {0x386602cc, 0xdd8f00a2, 0x3a380146, 0x00000000}},  //   rfor_, _قوی_, _terp_,
  { {0xe9440bb6, 0x00000000, 0x00000000, 0x00000000}},  //   _ورزی,   ,   ,
  { {0x249f000c, 0xceb300a0, 0x386600fa, 0x00000000}},  //   fjum_, היג_, pfor_,
  { {0x249f000c, 0x00000000, 0x00000000, 0x00000000}},  //   gjum_,   ,   ,
  { {0x6d550bb7, 0x00000000, 0x00000000, 0x00000000}},  //   zuza,   ,   ,
  { {0x25610047, 0xe643003b, 0x22470288, 0x00000000}},  //   ból_, _неуп, _cdnk_,
  { {0x7648018e, 0xf09f0129, 0x6a9b0049, 0x00000000}},  //   _iddy, tjà_, אשינ,
  { {0x64a30bb8, 0x00000000, 0x00000000, 0x00000000}},  //   _наха,   ,   ,
  { {0x33f6023c, 0x2ca00bb9, 0xc7b40049, 0x00000000}},  //   _اساس, djid_, קבֿ_,
  { {0x20d20027, 0x3d950bba, 0x121a007e, 0x00000000}},  //   všie_, оигр, _сюды_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x8cf50106, 0x6d550bbb, 0x853b0049, 0x00000000}},  //   ізац, ruza, טגלי,
  { {0xab87005e, 0x764809b6, 0x5b14004d, 0x00000000}},  // [1130] щувк, _oddy, змут,
  { {0x70550123, 0x249f0036, 0x20d20027, 0x00000000}},  //   _انکا, zjum_, ršie_,
  { {0xceb20104, 0x69c801ed, 0x249f01e5, 0x00000000}},  //   _חיי_, _žder, yjum_,
  { {0x7648018e, 0x515b0097, 0x20d20027, 0x00000000}},  //   _addy, רכאו, pšie_,
  { {0x75280089, 0x46a502dc, 0x00000000, 0x00000000}},  //   _atdz, жалв,   ,
  { {0x25610047, 0x7f3c0049, 0xf7700380, 0x00000000}},  //   tól_, נעוו, عان_,
  { {0x04590025, 0x249f01e5, 0x00000000, 0x00000000}},  //   للغة_, tjum_,   ,
  { {0x25610047, 0xc32501e0, 0x0325003b, 0x00000000}},  //   ról_, омик, один,
  { {0x249f009f, 0xd2990088, 0x7b09012d, 0x00000000}},  //   rjum_, атні_, _džuv,
  { {0x02c501fb, 0x68eb0bbc, 0x8af0006b, 0x00000000}},  //   ійно, logd, ltər,
  { {0xe0da0bbd, 0xd4e701fb, 0x21690364, 0x00000000}},  //   иво_, _люди, шини_,
  { {0x60cf009d, 0x67290066, 0xc1060025, 0x00000000}},  //   gicm, _ktej, توجي,
  { {0x443f0bbe, 0xe9ff0082, 0x6d450479, 0x00000000}},  //   mau_, _trặc_, _avha,
  { {0x443f04be, 0x645b0129, 0x67290bbf, 0x00000000}},  //   lau_, lgui, _mtej,
  { {0x62830bc0, 0xa0a6004d, 0x2d8c0142, 0x00000000}},  //   _iano, _макд, íde_,
  { {0x443f0bc1, 0x62830011, 0x00000000, 0x00000000}},  //   nau_, _hano,   ,
  { {0xeab200a1, 0x5aca0147, 0x443f0bc2, 0x00000000}},  // [1140] وٹر_, алам_, iau_,
  { {0x443f018e, 0x386d001f, 0x62830161, 0x00000000}},  //   hau_, _aber_, _jano,
  { {0xdca601fb, 0x443f09cf, 0x6d410010, 0x00000000}},  //   _дани, kau_, álat,
  { {0x186a0113, 0x443f0bc3, 0x62830161, 0x00000000}},  //   ради_, jau_, _lano,
  { {0x443f0bc4, 0x27e00bc5, 0x47330088, 0x00000000}},  //   dau_, çin_, дніс,
  { {0x2906002d, 0x27e001d5, 0x9f610010, 0x00000000}},  //   smoa_, ħin_, ését_,
  { {0x443f018e, 0xe1e701d8, 0x8af0006b, 0x00000000}},  //   fau_, _آس_, stəs,
  { {0x7c240627, 0x443f018e, 0x2005005f, 0x00000000}},  //   ncir, gau_, əlif_,
  { {0x62830065, 0x8af0006b, 0x6d480062, 0x00000000}},  //   _bano, qtəs, ádaj,
  { {0x62830b69, 0x78a200ea, 0x645b0325, 0x00000000}},  //   _cano, ljov, agui,
  { {0x443f0bc6, 0xe29a001d, 0x645b0bc7, 0x00000000}},  //   bau_, _chưa_, bgui,
  { {0x443f0bc8, 0x00000000, 0x00000000, 0x00000000}},  //   cau_,   ,   ,
  { {0x6283091d, 0x64400258, 0x34d90049, 0x00000000}},  //   _fano, mami, _פֿעב,
  { {0x62830bc9, 0x60cf0bca, 0x7c260bcb, 0x00000000}},  //   _gano, sicm, _afkr,
  { {0xeca701fc, 0x9c8300b9, 0x64400020, 0x00000000}},  //   ојан, íčov, oami,
  { {0x628300ee, 0x6aaa010f, 0x4c94007c, 0x00000000}},  //   _zano, öffn, мисс,
  { {0x60cd0059, 0x628300e0, 0xdfd10464, 0x00000000}},  // [1150] _imam, _yano, _سيد_,
  { {0x6440000b, 0x44240011, 0x443f001a, 0x00000000}},  //   hami, hcm_, zau_,
  { {0xceb2007b, 0xe2a6009f, 0x67290224, 0x00000000}},  //   _ניט_, _áður_, _stej,
  { {0x5d7a0476, 0x2d810bcc, 0x44260403, 0x00000000}},  //   _פארק, _ishe_, _nfo_,
  { {0x64400004, 0x443f010a, 0x7b64007c, 0x00000000}},  //   dami, vau_, _отре,
  { {0x8af0005f, 0xcf58009b, 0x443f0bcd, 0x00000000}},  //   stər, קבות_, wau_,
  { {0x6440027b, 0x443f0bce, 0x60cd006c, 0x00000000}},  //   fami, tau_, _omam,
  { {0x64400bcf, 0x6283021e, 0x78a200f6, 0x00000000}},  //   gami, _sano, cjov,
  { {0x443f0bc4, 0x645b0190, 0x7c3d01a3, 0x00000000}},  //   rau_, rgui, _mesr,
  { {0x443f0bd0, 0x78a9049b, 0x60cd00d6, 0x00000000}},  //   sau_, _hoev, _amam,
  { {0x62830007, 0x443f0016, 0x6440006c, 0x00000000}},  //   _vano, pau_, bami,
  { {0x64400181, 0x7c3d0340, 0x44240020, 0x00000000}},  //   cami, _nesr, ccm_,
  { {0x6283006a, 0xa29501fb, 0x78bb00b9, 0x00000000}},  //   _tano, _наді, _mluv,
  { {0x78bb0211, 0xe29a0011, 0x60cd0288, 0x00000000}},  //   _lluv, _thưa_, _emam,
  { {0x443d0bd1, 0x6da60bd2, 0x6b8f0bd3, 0x00000000}},  //   _kew_, чива, _arcg,
  { {0x61fc011f, 0x8b26007c, 0x78a9012d, 0x00000000}},  //   ürle, здае, _noev,
  { {0xeb970407, 0x7c3d00c4, 0x7c240145, 0x00000000}},  // [1160] пит_, _desr, rcir,
  { {0x64400814, 0x09e60200, 0x7c240bd4, 0x00000000}},  //   zami, позн, scir,
  { {0x78bb0617, 0x78a2008e, 0x78a900d9, 0x00000000}},  //   _bluv, tjov, _boev,
  { {0x443d0038, 0x6440062c, 0x78a900bb, 0x00000000}},  //   _new_, xami, _coev,
  { {0x8af0005f, 0x64400bd5, 0x7d1e04fd, 0x00000000}},  //   stəq, vami, _hups,
  { {0xab270265, 0x44260190, 0xd94601fc, 0x00000000}},  //   _хора_, _sfo_, _неги,
  { {0x78bb0129, 0x64400114, 0x78a2007f, 0x00000000}},  //   _fluv, tami, pjov,
  { {0x78bb0107, 0x89db009b, 0x443d0093, 0x00000000}},  //   _gluv, _החלי, _cew_,
  { {0x6440006a, 0xe7370057, 0x68e3004a, 0x00000000}},  //   rami, _нет_, énde,
  { {0x6440006c, 0xbebb0023, 0x6e3e00d9, 0x00000000}},  //   sami, hpër, _nepb,
  { {0x64400814, 0x443d0038, 0x705504b1, 0x00000000}},  //   pami, _few_, وندا,
  { {0x443d0bd6, 0xdfd507d0, 0x69c1006c, 0x00000000}},  //   _gew_, домы, _ülee,
  { {0x2d8c0030, 0xdcb10082, 0x7c3d0203, 0x00000000}},  //   æden_, ểm_, _resr,
  { {0x7bc40bd7, 0x7c3d00f6, 0x00000000, 0x00000000}},  //   dziu, _sesr,   ,
  { {0x629800ab, 0x443d0085, 0x7eb0006c, 0x00000000}},  //   _invo, _yew_, _näpu,
  { {0x60cd0058, 0x62880bd8, 0x00000000, 0x00000000}},  //   _umam, lddo,   ,
  { {0x9f54008b, 0x2bc7006e, 0xfbd301fa, 0x00000000}},  // [1170] _звыч, _रेखा, رتر_,
  { {0x7b090bd9, 0x628803cd, 0x7c3d01c3, 0x00000000}},  //   _ažur, nddo, _wesr,
  { {0x2d8c0bda, 0x7d1e0606, 0x78bb0bdb, 0x00000000}},  //   ådet_, _gups, _pluv,
  { {0x315701ce, 0x60dd0bdc, 0x00000000, 0x00000000}},  //   ליבן_, nnsm,   ,
  { {0x629801b5, 0x2cf90061, 0x60dd0146, 0x00000000}},  //   _onvo, ंतील_, insm,
  { {0x443d002b, 0x6b8d03cc, 0x00000000, 0x00000000}},  //   _sew_, mvag,   ,
  { {0x78a9017c, 0x443d0bdd, 0x58d50088, 0x00000000}},  //   _toev, _pew_, _жовт,
  { {0xe3b901bd, 0xcd9800a0, 0x62880016, 0x00000000}},  //   жби_, לדות_, eddo,
  { {0x27ff01f6, 0xf770002c, 0x628800bb, 0x00000000}},  //   _uzun_, _مال_, fddo,
  { {0x25e8013d, 0x443d0bde, 0x04fd0044, 0x00000000}},  //   _चुकी_, _wew_, ঁদের_,
  { {0x69c50bdf, 0x7643033b, 0x6d550036, 0x00000000}},  //   nzhe, many, jrza,
  { {0x62980be0, 0x6d55057c, 0x644b0018, 0x00000000}},  //   _envo, drza, _udgi,
  { {0x7d1e0107, 0x6d550036, 0x945d00b4, 0x00000000}},  //   _sups, erza, sińs,
  { {0x76430169, 0x7d1e0be1, 0x8fa3003b, 0x00000000}},  //   nany, _pups, њаре,
  { {0x9fa00112, 0x00000000, 0x00000000, 0x00000000}},  //   _méér_,   ,   ,
  { {0xc1060025, 0x76430be2, 0x69c5012d, 0x00000000}},  //   _توبي, hany, dzhe,
  { {0x09ab0044, 0xcb6700c0, 0x6d47006c, 0x00000000}},  // [1180] _গেলা, мате_, asja,
  { {0x0f57009b, 0x76430145, 0xbebb0023, 0x00000000}},  //   _קיים_, jany, spër,
  { {0x76430127, 0x7e7c0277, 0xa967005e, 0x00000000}},  //   dany, merp, диха_,
  { {0x6d5c09f3, 0x395a00eb, 0x2c7800a1, 0x00000000}},  //   mura, rups_, _ڈیڑھ_,
  { {0x76430be3, 0x6288018e, 0x6d5c0169, 0x00000000}},  //   fany, yddo, lura,
  { {0x395a01db, 0x07a3012b, 0xfbd3009b, 0x00000000}},  //   pups_, таљн, _יתר_,
  { {0x6d5c0be4, 0xf983007c, 0x00000000, 0x00000000}},  //   nura, _игро,   ,
  { {0x2ebb0201, 0x7e7c0be5, 0x00000000, 0x00000000}},  //   _उत्त, herp,   ,
  { {0x7643020c, 0x6d5c01a3, 0x20c20048, 0x00000000}},  //   bany, hura, _móid_,
  { {0xd250007a, 0x6d5c0653, 0xeb910049, 0x00000000}},  //   دند_, kura, אָט_,
  { {0x7e7c0af1, 0x6288018e, 0x6d5c0be6, 0x00000000}},  //   derp, rddo, jura,
  { {0x6d5c022b, 0x67200020, 0x04930025, 0x00000000}},  //   dura, _kumj, _للمح,
  { {0x7c360190, 0x60dd0be7, 0x2d6801a2, 0x00000000}},  //   dbyr, rnsm, eße_,
  { {0x6d5c0020, 0x7e7c0030, 0x826800a1, 0x00000000}},  //   fura, gerp, _رشتہ_,
  { {0x9f9901d6, 0x00000000, 0x00000000, 0x00000000}},  //   _dáár_,   ,   ,
  { {0x6d47002b, 0x76430036, 0x20c20051, 0x00000000}},  //   rsja, zany, _cóid_,
  { {0x2d9e010f, 0x2d8c043e, 0xfc3f0129, 0x00000000}},  // [1190] äter_, åder_, _veí_,
  { {0x6d5c020c, 0x9af50025, 0x7e7c08d0, 0x00000000}},  //   bura, ركات, cerp,
  { {0x6d5c0be8, 0x6b8d0039, 0x76430321, 0x00000000}},  //   cura, svag, vany,
  { {0x76430046, 0x2bd002d2, 0xe0df0197, 0x00000000}},  //   wany, _सेवा, nnò_,
  { {0x7643020c, 0x7d0d003c, 0xf3880011, 0x00000000}},  //   tany, mmas, _nợ_,
  { {0x7d0d038c, 0xddde05fa, 0xbb3a00a0, 0x00000000}},  //   lmas, _hapš, _מעשי,
  { {0x7643020c, 0x00000000, 0x00000000, 0x00000000}},  //   rany,   ,   ,
  { {0x7d0d038c, 0x76430149, 0xb38500c0, 0x00000000}},  //   nmas, sany, елил,
  { {0x76430be9, 0x7e7c0009, 0x7d0d010e, 0x00000000}},  //   pany, yerp, imas,
  { {0x13060057, 0x6d5c033b, 0x7d0d0bea, 0x00000000}},  //   нный_, yura, hmas,
  { {0xd12e00d3, 0xe1f9008b, 0x6d5c002d, 0x00000000}},  //   یمی_, яго_, xura,
  { {0x76410047, 0xf9920476, 0x2ec803d7, 0x00000000}},  //   _hely, ארט_, रफ्त,
  { {0x42cd0044, 0x6d5c0093, 0x76410006, 0x00000000}},  //   রকৌশ, wura, _kely,
  { {0x91e50001, 0x7d0d01a3, 0x3ebe000c, 0x00000000}},  //   _поле, emas, ótt_,
  { {0x76410047, 0xc5f20049, 0x7e7c0146, 0x00000000}},  //   _mely, ָדן_, rerp,
  { {0x7d0d011c, 0x7e7c0056, 0x6d5c0beb, 0x00000000}},  //   gmas, serp, rura,
  { {0x7e7c0bec, 0x245a011f, 0x75210023, 0x00000000}},  // [11a0] perp, lümü_, _lulz,
  { {0x6d5c0016, 0xb05b0a35, 0xea87026b, 0x00000000}},  //   pura, nhän, нбул_,
  { {0xcee90014, 0x245a0279, 0x8c460745, 0x00000000}},  //   _ترين_, nümü_, _пене,
  { {0x7eb00004, 0x22450bed, 0x00000000, 0x00000000}},  //   _täps, halk_,   ,
  { {0x68e3008e, 0x20d20059, 0x224500ea, 0x00000000}},  //   énda, jšim_, kalk_,
  { {0x09bf0044, 0x75210026, 0x0cc30044, 0x00000000}},  //   _আশরা, _bulz, ্কৃত,
  { {0xf3880011, 0xceb3009b, 0x76410016, 0x00000000}},  //   _sợ_, ריו_, _dely,
  { {0x7521008e, 0xd3a6004c, 0x69c1006c, 0x00000000}},  //   _dulz, ероп, _ülea,
  { {0x76410bee, 0x22450239, 0xb05b01a2, 0x00000000}},  //   _fely, falk_, fhän,
  { {0xf388001d, 0x76410bef, 0x6aae0190, 0x00000000}},  //   _vợ_, _gely, _jobf,
  { {0xba570049, 0xf48400a1, 0x752100d9, 0x00000000}},  //   עסטו_, _لاشی, _gulz,
  { {0x7d0d006b, 0x254c00b9, 0x00000000, 0x00000000}},  //   xmas, měl_,   ,
  { {0xb05b010f, 0xe0df0197, 0x224500bb, 0x00000000}},  //   bhän, rnò_, balk_,
  { {0x245a014a, 0xddde012d, 0x539b00a0, 0x00000000}},  //   bümü_, _sapš, _מידו,
  { {0x7d0d0279, 0x20240048, 0x00000000, 0x00000000}},  //   tmas, íriú_,   ,
  { {0xccf8012b, 0x628a005b, 0x00000000, 0x00000000}},  //   ећу_, _hafo,   ,
  { {0x7d0d0bf0, 0x628a01aa, 0x6aae00fa, 0x00000000}},  // [11b0] rmas, _kafo, _bobf,
  { {0x2b490068, 0x64420048, 0x00000000, 0x00000000}},  //   rsac_, _leoi,   ,
  { {0x764101aa, 0xd9990054, 0xddde0bf1, 0x00000000}},  //   _rely, بنات_, _tapš,
  { {0x48cf0044, 0x254c00b9, 0x628a0bf2, 0x00000000}},  //   িক্র, děl_, _lafo,
  { {0x81bc0089, 0x245a005a, 0x7eb00bf3, 0x00000000}},  //   ucēj, zümü_, _käpp,
  { {0x69d5001c, 0xf65300a1, 0x75210096, 0x00000000}},  //   _येथी, ائش_, _pulz,
  { {0x64420051, 0x76410006, 0xb5c20088, 0x00000000}},  //   _beoi, _vely, ийшл,
  { {0x64420051, 0x7eb00bf4, 0x798701c3, 0x00000000}},  //   _ceoi, _läpp, _isjw,
  { {0xe3b10025, 0x69d50061, 0x130902d3, 0x00000000}},  //   شرة_, _येती, мний_,
  { {0x628a018e, 0x7eb00103, 0x00000000, 0x00000000}},  //   _cafo, _näpp,   ,
  { {0x628a005b, 0xb05b09b0, 0x64420048, 0x00000000}},  //   _dafo, rhän, _feoi,
  { {0xe3b002fd, 0xe5080025, 0x64420bf5, 0x00000000}},  //   _گرم_, _كيلو_, _geoi,
  { {0xb05b0bf6, 0x2ca9006c, 0xe3ae013a, 0x00000000}},  //   mhäl, djad_, _тб_,
  { {0x79820046, 0x628a0016, 0x248d00b4, 0x00000000}},  //   łowi, _gafo, ldem_,
  { {0xbea301fc, 0x8af0006b, 0xb05b01a2, 0x00000000}},  //   шарк, frən, chäo,
  { {0x248d0bf7, 0x1fb6030d, 0x3ce000ea, 0x00000000}},  //   ndem_, _асор, univ_,
  { {0x248d042e, 0x00000000, 0x00000000, 0x00000000}},  // [11c0] idem_,   ,   ,
  { {0x3ced0bf8, 0x248d0bf9, 0x63a600f8, 0x00000000}},  //   čeva_, hdem_, äkni,
  { {0x19b9008b, 0xae57009b, 0x7d0a003b, 0x00000000}},  //   нуць_, _בסיס_, _оног_,
  { {0x79950036, 0x38cb00a6, 0x248d0bfa, 0x00000000}},  //   _drzw, وانی_, jdem_,
  { {0xe7d201f5, 0x6d5a0006, 0x248d098d, 0x00000000}},  //   _देशप, štad, ddem_,
  { {0x248d01d5, 0x254c00b9, 0x64420bfb, 0x00000000}},  //   edem_, těl_, _seoi,
  { {0xe9a30594, 0x628a01e5, 0xa01b0010, 0x00000000}},  //   _карп, _rafo, ldöt,
  { {0x628a018e, 0xb86604e8, 0xfb8500a1, 0x00000000}},  //   _safo, _جاسو, _جگہی,
  { {0x2c6d0010, 0xaa82000c, 0xa766007e, 0x00000000}},  //   lódó_, _þýsk, _шкад,
  { {0x68e20bfc, 0x00000000, 0x00000000, 0x00000000}},  //   lnod,   ,   ,
  { {0x64420bfd, 0x9f4f000c, 0xe3af0bb6, 0x00000000}},  //   _teoi, _ágú_, مری_,
  { {0x68e20016, 0x6b840009, 0xd5d90049, 0x00000000}},  //   nnod, kwig, _אַנש,
  { {0x35a8013d, 0x628a0016, 0xe7030082, 0x00000000}},  //   _कपड़, _tafo, _hướ,
  { {0x6b840090, 0x7a480089, 0x68e20544, 0x00000000}},  //   dwig, nūtē, hnod,
  { {0x2ca9006c, 0x1df80147, 0x51f30014, 0x00000000}},  //   tjad_, веры_, _پسور,
  { {0x20d20059, 0x0217009b, 0x00000000, 0x00000000}},  //   jših_, _בחום_,   ,
  { {0x68e20428, 0x2ca90bfe, 0x3a75007c, 0x00000000}},  // [11d0] dnod, rjad_, ллар,
  { {0x5a340bff, 0x2ca9006c, 0x248d0528, 0x00000000}},  //   инут, sjad_, zdem_,
  { {0x68e2018e, 0x68e30211, 0xceb20104, 0x00000000}},  //   fnod, éndo, _היי_,
  { {0x68e20016, 0x3f890022, 0x236d013e, 0x00000000}},  //   gnod, _ksau_, ytej_,
  { {0xe9ff0011, 0x7c2d0145, 0x2fcb0009, 0x00000000}},  //   _trắc_, mcar, nzcg_,
  { {0x7d1d038c, 0x7c2d001a, 0xda34007e, 0x00000000}},  //   _hiss, lcar, _веры,
  { {0x45190401, 0xb05b0c00, 0xc98404cf, 0x00000000}},  //   нция_, thäl, _кути,
  { {0x7c2d020c, 0x7d1d01d5, 0x05760025, 0x00000000}},  //   ncar, _jiss, امية_,
  { {0x7d1d01cb, 0x248d010f, 0xb05b010f, 0x00000000}},  //   _miss, rdem_, rhäl,
  { {0x236d0c01, 0xf77000a1, 0x27e00051, 0x00000000}},  //   rtej_, _گاہ_, úine_,
  { {0x291e00f4, 0xa06a013a, 0x236d05fd, 0x00000000}},  //   _état_, нана_, stej_,
  { {0x7c2d0c02, 0xd5ba0049, 0x6b8401d6, 0x00000000}},  //   jcar, _אזעל, ywig,
  { {0x442d00d2, 0xe28e008b, 0x7c2d05eb, 0x00000000}},  //   mce_, _ла_, dcar,
  { {0x442d0763, 0x66f503d7, 0x64490051, 0x00000000}},  //   lce_, ेतिक_, laei,
  { {0x62810314, 0x7d1d010f, 0x3f8900e0, 0x00000000}},  //   melo, _biss, _esau_,
  { {0x442d0c03, 0x6281001a, 0x7d1d00c4, 0x00000000}},  //   nce_, lelo, _ciss,
  { {0x442f010f, 0x60c40c04, 0x442d00ab, 0x00000000}},  // [11e0] _mfg_, _ilim, ice_,
  { {0x7bc0005f, 0x628100e5, 0xc33200b6, 0x00000000}},  //   _ümum, nelo, צוב_,
  { {0x2d96098c, 0x442d0224, 0x7d1d0207, 0x00000000}},  //   _српс, kce_, _fiss,
  { {0xdca601f9, 0x442d00b9, 0x7c2d0207, 0x00000000}},  //   _сами, jce_, ccar,
  { {0x442d0c05, 0x6281023a, 0x6d4e0039, 0x00000000}},  //   dce_, kelo, lsba,
  { {0x62810209, 0x6d5c046a, 0x60c400d4, 0x00000000}},  //   jelo, orra, _llim,
  { {0x60c4006b, 0x62810c06, 0x6d4e0039, 0x00000000}},  //   _olim, delo, nsba,
  { {0x442f0c07, 0x6f1e0046, 0x64490048, 0x00000000}},  //   _cfg_, _lipc, gaei,
  { {0xb4e40316, 0x62810951, 0x6d5c010f, 0x00000000}},  //   _नदी_, felo, hrra,
  { {0x6281049b, 0x26c700b9, 0x3866018e, 0x00000000}},  //   gelo, chno_, lgor_,
  { {0x60c40c08, 0x442d00b9, 0x7c2d0133, 0x00000000}},  //   _blim, bce_, ycar,
  { {0x38660bbe, 0x442d0207, 0x30a70364, 0x00000000}},  //   ngor_, cce_, уров,
  { {0x8af0006b, 0x6d4e0168, 0x2d9e01c9, 0x00000000}},  //   stəy, esba, åten_,
  { {0x60c4000b, 0x7d1d0004, 0x62810c09, 0x00000000}},  //   _elim, _siss, celo,
  { {0x7d1d03b4, 0x60c401d5, 0x7c2d00b5, 0x00000000}},  //   _piss, _flim, tcar,
  { {0x60c40007, 0x3ced0c0a, 0xd7c40061, 0x00000000}},  //   _glim, čevo_, वनाच,
  { {0x7d1d0c0b, 0x7c2d0412, 0x6d5c0add, 0x00000000}},  // [11f0] _viss, rcar, arra,
  { {0x7d1d0c0c, 0x442d011f, 0x7c2d0781, 0x00000000}},  //   _wiss, zce_, scar,
  { {0x7d1d0c0d, 0x442d0036, 0x60c400b0, 0x00000000}},  //   _tiss, yce_, _ylim,
  { {0x62810c0e, 0x69c1006c, 0x6f1e0019, 0x00000000}},  //   zelo, _ülem, _zipc,
  { {0x442d0428, 0x07a509ae, 0x499300a1, 0x00000000}},  //   vce_, ралн, _گیار,
  { {0x442d0036, 0x0555005e, 0x442f0bf5, 0x00000000}},  //   wce_, атия, _sfg_,
  { {0x6281030a, 0x442d0c0f, 0x442f0c10, 0x00000000}},  //   velo, tce_, _pfg_,
  { {0x26c7012d, 0x473507e1, 0xed640161, 0x00000000}},  //   shno_, _внас, leží_,
  { {0x442d0c11, 0x62810c12, 0xe73001fa, 0x00000000}},  //   rce_, telo, _فصل_,
  { {0x442d0c13, 0x60c40089, 0x27ff0c14, 0x00000000}},  //   sce_, _slim, _iyun_,
  { {0x442d091d, 0x6281001a, 0x60c4001a, 0x00000000}},  //   pce_, relo, _plim,
  { {0x6281001a, 0x65630181, 0x272b0030, 0x00000000}},  //   selo, munh, _køn_,
  { {0x68e90065, 0x62810716, 0x20c20048, 0x00000000}},  //   _mjed, pelo, _fóin_,
  { {0xed5a012b, 0x6d4e00bb, 0x200900fa, 0x00000000}},  //   ког_, tsba, _dzai_,
  { {0x272b0737, 0x68fb014a, 0x63bb0232, 0x00000000}},  //   _løn_, _okud, lyun,
  { {0x27ff0676, 0x60c40020, 0x224700b5, 0x00000000}},  //   _oyun_, _ulim, _henk_,
  { {0x6d4e010f, 0x63bb008a, 0x63a90c15, 0x00000000}},  // [1200] ssba, nyun, nxen,
  { {0xc879005f, 0xed460454, 0x68fb08ff, 0x00000000}},  //   _abş_, _кноп, _akud,
  { {0x27ff011c, 0x63bb0093, 0x212700d4, 0x00000000}},  //   _ayun_, hyun, _junh_,
  { {0x26c50c16, 0x290d0061, 0xe73a0780, 0x00000000}},  //   _allo_, _chea_, вед_,
  { {0x18670b86, 0x1634005e, 0x68e9016e, 0x00000000}},  //   рачи_, беля, _djed,
  { {0x8b190256, 0x68fb00bb, 0x68e90190, 0x00000000}},  //   _бюст_, _ekud, _ejed,
  { {0x68e90190, 0x3866005b, 0x27ed00d9, 0x00000000}},  //   _fjed, pgor_, _exen_,
  { {0x26c50211, 0xd497007c, 0x68e900ea, 0x00000000}},  //   _ello_, арь_, _gjed,
  { {0x2247016c, 0x63bb0010, 0x00000000, 0x00000000}},  //   _benk_, gyun,   ,
  { {0x291f000d, 0x68e90a32, 0xb2730147, 0x00000000}},  //   _ziua_, _zjed, ольш,
  { {0x22470c17, 0x2ef8010f, 0x21630088, 0x00000000}},  //   _denk_, dorf_, отяг,
  { {0x64a3005e, 0xddc500b9, 0x26dc04bb, 0x00000000}},  //   _маха, _schů, livo_,
  { {0xa2940c18, 0xdc2e006b, 0x224701aa, 0x00000000}},  //   _галі, _sığo, _fenk_,
  { {0x76480046, 0x7b10010f, 0x24840066, 0x00000000}},  //   _jedy, läuf, lemm_,
  { {0xe3e80055, 0x00000000, 0x00000000, 0x00000000}},  //   _পরিব,   ,   ,
  { {0xc05b01fb, 0x6ca40c19, 0x26dc0555, 0x00000000}},  //   _рік_, оруж, hivo_,
  { {0x75280c1a, 0x60dd0c1b, 0x290d01eb, 0x00000000}},  // [1210] _ludz, mism, _rhea_,
  { {0x60dd0c1c, 0x68e90c1d, 0x26dc0c1e, 0x00000000}},  //   lism, _sjed, jivo_,
  { {0xc8ab005e, 0x272b0737, 0x248401d5, 0x00000000}},  //   къде_, _søn_, kemm_,
  { {0xf77106ea, 0x60dd0c1f, 0x00000000, 0x00000000}},  //   كات_, nism,   ,
  { {0x2bde02fb, 0x68e90065, 0x75280089, 0x00000000}},  //   _नेपा, _vjed, _audz,
  { {0x75280c20, 0xdc3c0066, 0x00000000, 0x00000000}},  //   _budz, _iġġo,   ,
  { {0x68e90209, 0x785700d3, 0xa8a7005e, 0x00000000}},  //   _tjed, _نیاز_, _крак,
  { {0x224701aa, 0x68e90091, 0x60dd008e, 0x00000000}},  //   _senk_, _ujed, jism,
  { {0x60dd0779, 0x7648005b, 0x00000000, 0x00000000}},  //   dism, _fedy,   ,
  { {0x26dc037e, 0x68f90066, 0x7528012d, 0x00000000}},  //   civo_, lowd, _fudz,
  { {0x60dd030e, 0x63bb011c, 0xdcf001ee, 0x00000000}},  //   fism, syun, _šeči,
  { {0x67210c21, 0x297a061e, 0x397a00b6, 0x00000000}},  //   _hilj, נטרא, נטרנ,
  { {0x443f0b98, 0x22470c22, 0x2005006b, 0x00000000}},  //   mbu_, _tenk_, əlik_,
  { {0x443f002b, 0x6d450c23, 0x7d180010, 0x00000000}},  //   lbu_, _bwha, _évsz,
  { {0x672107dc, 0xdca60057, 0x2d95025f, 0x00000000}},  //   _milj, бави, ортс,
  { {0x672106a1, 0x26dc055a, 0x443f0253, 0x00000000}},  //   _lilj, zivo_, nbu_,
  { {0x1d070c24, 0x443f0c25, 0x00000000, 0x00000000}},  // [1220] сети_, ibu_,   ,
  { {0x386d0c26, 0x9e660c27, 0x8e860025, 0x00000000}},  //   _acer_, _увод, _الده,
  { {0x76480c28, 0x248400e0, 0x499a0641, 0x00000000}},  //   _redy, yemm_, ытая_,
  { {0x443f0c29, 0x75280c2a, 0xa3c70067, 0x00000000}},  //   jbu_, _rudz, ईना_,
  { {0x26dc0a15, 0x443f0142, 0x7d040c2b, 0x00000000}},  //   tivo_, dbu_, mlis,
  { {0x7d040b3e, 0x67210295, 0x386d0c2c, 0x00000000}},  //   llis, _cilj, _ecer_,
  { {0x26dc0207, 0x60dd0c2d, 0x6721016e, 0x00000000}},  //   rivo_, yism, _dilj,
  { {0x7d04009f, 0x26dc0c2e, 0x60dd0c2f, 0x00000000}},  //   nlis, sivo_, xism,
  { {0x60dd049a, 0x47c600ed, 0x26dc0c30, 0x00000000}},  //   vism, _убав, pivo_,
  { {0x7d040052, 0x415402d3, 0x66010c31, 0x00000000}},  //   hlis, овос, _fylk,
  { {0x7d040161, 0x8afb0049, 0x443f0c32, 0x00000000}},  //   klis, רהיי, bbu_,
  { {0x7d040085, 0x67210c33, 0x00000000, 0x00000000}},  //   jlis, _zilj,   ,
  { {0x68e30c34, 0xe6c4009f, 0x44260c35, 0x00000000}},  //   éndi, _þjóð, _igo_,
  { {0x7d040c36, 0x7d160027, 0x4426004a, 0x00000000}},  //   elis, emys, _hgo_,
  { {0x6d5a0091, 0x7d040c37, 0x60dd0036, 0x00000000}},  //   štan, flis, pism,
  { {0xd904089d, 0x4426004a, 0x9c39030d, 0x00000000}},  //   _سی_, _jgo_, рпат_,
  { {0x2d8c0030, 0x752200f6, 0x88bd0036, 0x00000000}},  // [1230] æder_, _mioz, _liśc,
  { {0x443f016e, 0x2d98009d, 0x31790036, 0x00000000}},  //   zbu_, bvre_, ńsze_,
  { {0x7d040038, 0x443f04bb, 0x27e00c38, 0x00000000}},  //   blis, ybu_, úinn_,
  { {0x7d04006b, 0x442604e6, 0x3eb1012d, 0x00000000}},  //   clis, _ngo_, ljzt_,
  { {0x67290211, 0xe81401f5, 0xd366023c, 0x00000000}},  //   _quej, तेला_, _ته_,
  { {0x44260038, 0x3ce90c39, 0x91fc0089, 0x00000000}},  //   _ago_, lnav_, rgāj,
  { {0x67210c3a, 0x443f0062, 0x44260c3b, 0x00000000}},  //   _vilj, tbu_, _bgo_,
  { {0x3ce90009, 0x44260c3c, 0x00000000, 0x00000000}},  //   nnav_, _cgo_,   ,
  { {0x443f0c3d, 0x7b10010f, 0xb05b010f, 0x00000000}},  //   rbu_, bäud, nhäu,
  { {0x66010046, 0x443f0c3e, 0x7d04020d, 0x00000000}},  //   _tylk, sbu_, zlis,
  { {0x7d0403ca, 0x0086013b, 0x44260c3f, 0x00000000}},  //   ylis, олно, _fgo_,
  { {0xcea900a0, 0x2eb4007d, 0xe0df0026, 0x00000000}},  //   _בי_, ुस्त, giò_,
  { {0xbebb0065, 0x7d04014a, 0xfc460142, 0x00000000}},  //   jqës, vlis, šíka_,
  { {0x6145007c, 0x7d040c40, 0x644b0c41, 0x00000000}},  //   _дека, wlis, _hegi,
  { {0x644b04fa, 0x7e2300ed, 0xdddc016c, 0x00000000}},  //   _kegi, ддрж, ferš,
  { {0x0ce80044, 0xe0df0c42, 0xb05b0c43, 0x00000000}},  //   পত্ত, ciò_, lkän,
  { {0x7d040a48, 0x644b0c44, 0xeb970c45, 0x00000000}},  // [1240] rlis, _megi, оит_,
  { {0x7d040c46, 0xda660054, 0x7d1600b9, 0x00000000}},  //   slis, تاري, smys,
  { {0x3ce90061, 0x64590036, 0xe9da003b, 0x00000000}},  //   bnav_, _odwi, јке_,
  { {0x644b0c47, 0xa8a30098, 0xb17a0049, 0x00000000}},  //   _negi, дршк, יטער,
  { {0xb05b00f8, 0x44260068, 0x00000000, 0x00000000}},  //   phäv, _rgo_,   ,
  { {0x8f9b012f, 0xe0df0197, 0xbf9b00a3, 0x00000000}},  //   ייני, ziò_, יינש,
  { {0xb05b0039, 0x2bde006e, 0x44260c48, 0x00000000}},  //   dkän, _नेता, _pgo_,
  { {0x18670364, 0x644b026e, 0x64400009, 0x00000000}},  //   _маси_, _cegi, ubmi,
  { {0x644b014a, 0xe0df0026, 0x00000000, 0x00000000}},  //   _degi, viò_,   ,
  { {0x3ce00004, 0x64590016, 0x8af0005f, 0x00000000}},  //   hiiv_, _edwi, qsəd,
  { {0x2730001d, 0x44260026, 0x644b01e5, 0x00000000}},  //   _hàn_, _tgo_, _fegi,
  { {0x44260197, 0xbebb0065, 0x6ab7007d, 0x00000000}},  //   _ugo_, yqës, _आक्र,
  { {0x6d5a0142, 0x69c1006c, 0x3ce900ca, 0x00000000}},  //   štal, _ülev, vnav_,
  { {0x2730001d, 0x2005001e, 0xdefb0a78, 0x00000000}},  //   _màn_, āli_, рым_,
  { {0x62880211, 0x27300011, 0x3ce90009, 0x00000000}},  //   medo, _làn_, tnav_,
  { {0x628801d9, 0x00000000, 0x00000000, 0x00000000}},  //   ledo,   ,   ,
  { {0x60c00c49, 0x27300082, 0x3ce90c4a, 0x00000000}},  // [1250] ömme, _nàn_, rnav_,
  { {0x62880544, 0x3ce90c4b, 0x77620133, 0x00000000}},  //   nedo, snav_, drox,
  { {0x3ce90061, 0xdc3f0161, 0x00000000, 0x00000000}},  //   pnav_, líčk,   ,
  { {0xd04f005f, 0x2730001d, 0x628800ea, 0x00000000}},  //   ticə, _bàn_, hedo,
  { {0x6d550010, 0x62880091, 0xdc3f01ca, 0x00000000}},  //   lsza, kedo, níčk,
  { {0x644b009f, 0x62880209, 0x27300011, 0x00000000}},  //   _segi, jedo, _dàn_,
  { {0x62880325, 0x6b8d00b5, 0x644b008a, 0x00000000}},  //   dedo, lwag, _pegi,
  { {0x213e0009, 0x28f80088, 0x00000000, 0x00000000}},  //   dpth_, _десь_,   ,
  { {0x644b000c, 0xf41f00b0, 0x6b8d0c4c, 0x00000000}},  //   _vegi, ää_, nwag,
  { {0x628800c4, 0x04fd0044, 0x4255004d, 0x00000000}},  //   gedo, ুদের_, чтит,
  { {0x644b0004, 0xb05b0c43, 0x68eb0082, 0x00000000}},  //   _tegi, rkän, ongd,
  { {0x6b8d0168, 0x69c1010e, 0xb05b00f8, 0x00000000}},  //   kwag, _üleu, skän,
  { {0xa3d30061, 0x62880181, 0x2004000c, 0x00000000}},  //   _हेच_, bedo, æmi_,
  { {0x62880335, 0x6d5a04eb, 0x00000000, 0x00000000}},  //   cedo, štam,   ,
  { {0x2d9e004f, 0x6da30794, 0x6d550010, 0x00000000}},  //   íte_, нира, gsza,
  { {0xd7bd0061, 0xb05b0c4d, 0x8af0013f, 0x00000000}},  //   ्नाच, nkäl, hrət,
  { {0x6b8d0058, 0xab660c4e, 0x00000000, 0x00000000}},  // [1260] gwag, явал,   ,
  { {0x0e660057, 0x3f92011c, 0x387f0c4f, 0x00000000}},  //   _экон, _isyu_, _abur_,
  { {0x2730001d, 0x3ebb009b, 0xdebb009b, 0x00000000}},  //   _sàn_, _הציב, _המיל,
  { {0x77620190, 0x186a0088, 0x779400a1, 0x00000000}},  //   trox, сади_, ویزا,
  { {0x656301a2, 0x47330c50, 0x6b8d0045, 0x00000000}},  //   ernh, еніс, cwag,
  { {0x2b400c51, 0x628800d4, 0x996400b9, 0x00000000}},  //   mpic_, xedo, může_,
  { {0x62880062, 0x9d000044, 0xe1e70025, 0x00000000}},  //   vedo, ্দীন_, _أس_,
  { {0x6288018e, 0x27300011, 0x776200ab, 0x00000000}},  //   wedo, _tàn_, prox,
  { {0x2b400061, 0x76430c52, 0x00000000, 0x00000000}},  //   npic_, bbny,   ,
  { {0xb6c8026c, 0x7afe0c53, 0x68e20c54, 0x00000000}},  //   _بارے_, nopt, liod,
  { {0x62880142, 0x6d5a0091, 0x69c1006c, 0x00000000}},  //   redo, štaj, _ület,
  { {0x62880c55, 0xeafa00e8, 0x68e2010b, 0x00000000}},  //   sedo, ्तुत_, niod,
  { {0x62880c56, 0xa4b7009b, 0x14a90061, 0x00000000}},  //   pedo, _מלאה_, कारण,
  { {0x6288008d, 0x6d550c57, 0x3eba0035, 0x00000000}},  //   qedo, tsza, _copt_,
  { {0x7afe0bbc, 0xf29700b3, 0x200c006b, 0x00000000}},  //   dopt, _זכור_, ədim_,
  { {0x6d550c58, 0xfbde001c, 0xf1ba0011, 0x00000000}},  //   rsza, _नेहम, _ngơi_,
  { {0x6d550047, 0x68e204bf, 0x60cd0996, 0x00000000}},  // [1270] ssza, diod, _ilam,
  { {0x6b8d0007, 0x6d550c59, 0x88bd0036, 0x00000000}},  //   rwag, psza, _ciśn,
  { {0x60cd0142, 0xc1780006, 0x673b099a, 0x00000000}},  //   _klam, ntė_, _stuj,
  { {0xa3be02d2, 0x26cc0197, 0x2ee300b5, 0x00000000}},  //   ीना_, _aldo_, lijf_,
  { {0x2b400061, 0x60cd015e, 0x69d80c5a, 0x00000000}},  //   cpic_, _mlam, úver,
  { {0x60cd0219, 0x7afe001a, 0x2557001a, 0x00000000}},  //   _llam, copt, tăl_,
  { {0xf65000b8, 0x60cd014a, 0xb05b0c4d, 0x00000000}},  //   ائه_, _olam, tkäl,
  { {0xe894008b, 0x68e2001a, 0x2ee300b5, 0x00000000}},  //   _пась, ciod, hijf_,
  { {0xd702007e, 0xc1780006, 0x00000000, 0x00000000}},  //   _кiра, etė_,   ,
  { {0x60cd020c, 0x78bb0c5b, 0x69c1006c, 0x00000000}},  //   _alam, _houv, _üles,
  { {0x78bb0c5c, 0x208a005e, 0x78a900d9, 0x00000000}},  //   _kouv, ойни_, _knev,
  { {0xafe601fb, 0xd00a00ed, 0x5558007e, 0x00000000}},  //   домл, жеме_, _хаця_,
  { {0x78bb03eb, 0x92b50025, 0x3eba0c5d, 0x00000000}},  //   _mouv, _يحتا, _popt_,
  { {0x78bb0c5e, 0x60cd006c, 0x68e20032, 0x00000000}},  //   _louv, _elam, ziod,
  { {0x78a90270, 0x60cd0c5f, 0x2b400009, 0x00000000}},  //   _onev, _flam, wpic_,
  { {0x78bb0c60, 0x2b400c61, 0x7afe0a5f, 0x00000000}},  //   _nouv, tpic_, wopt,
  { {0xb05b010f, 0x7afe00bb, 0xa2b40061, 0x00000000}},  // [1280] phär, topt, ेसच्,
  { {0x273b0035, 0x78a90035, 0x2b400c62, 0x00000000}},  //   _mână_, _anev, rpic_,
  { {0x2d9c0010, 0xfbd100a1, 0x7afe00ea, 0x00000000}},  //   _éve_, نتے_, ropt,
  { {0x78bb00f4, 0x58830147, 0x88bd0036, 0x00000000}},  //   _couv, выша, _wiśn,
  { {0x68e20292, 0x78a90746, 0x78bb01aa, 0x00000000}},  //   riod, _dnev, _douv,
  { {0x68e20016, 0x78a9068f, 0xc1780006, 0x00000000}},  //   siod, _enev, ytė_,
  { {0x68e2005b, 0x00000000, 0x00000000, 0x00000000}},  //   piod,   ,   ,
  { {0x78bb0c63, 0x6abc009f, 0x78a907d1, 0x00000000}},  //   _gouv, _horf, _gnev,
  { {0x66cf0c64, 0x6abc0253, 0x69c1010e, 0x00000000}},  //   _søke, _korf, _üler,
  { {0xf743072b, 0xc17a0088, 0x6abc00f6, 0x00000000}},  //   _рефо, оїм_, _jorf,
  { {0x6abc049a, 0x60cd016e, 0xb05b0210, 0x00000000}},  //   _morf, _plam, skäm,
  { {0x30a70c65, 0x2249016c, 0xc1780006, 0x00000000}},  //   фров, _đake_, rtė_,
  { {0x351b007b, 0xc1780006, 0x60cd0116, 0x00000000}},  //   _וואנ, stė_, _vlam,
  { {0x32070016, 0x213c0011, 0x6abc046e, 0x00000000}},  //   _fyny_, _ttvh_, _norf,
  { {0x27fa0036, 0x67280aca, 0x63a20c66, 0x00000000}},  //   ępny_, _midj, _hron,
  { {0x63a20239, 0x629a0af1, 0x60cd04cb, 0x00000000}},  //   _kron, ldto, _ulam,
  { {0x5b15005e, 0x62980006, 0x78bb0c67, 0x00000000}},  // [1290] емат, _kavo, _rouv,
  { {0x78bb0c68, 0x6abc018e, 0x62980161, 0x00000000}},  //   _souv, _corf, _javo,
  { {0x25de001c, 0x78bb0c69, 0x78a90059, 0x00000000}},  //   _केली_, _pouv, _pnev,
  { {0x62980198, 0x7d0901d5, 0x20090093, 0x00000000}},  //   _lavo, ċess, _kyai_,
  { {0x6abc02cc, 0x672801aa, 0x7f4d0066, 0x00000000}},  //   _forf, _bidj, _jwaq,
  { {0x6abc018e, 0x21290022, 0x66cf0056, 0x00000000}},  //   _gorf, _liah_, _søkb,
  { {0xd5b106dd, 0x629a0009, 0x78bb0068, 0x00000000}},  //   افع_, ddto, _touv,
  { {0x273b000d, 0x629a09d0, 0xb9250025, 0x00000000}},  //   _până_, edto, _أفري,
  { {0x63a20207, 0x6593005f, 0x69c50010, 0x00000000}},  //   _cron, _məhə, lyhe,
  { {0x62980207, 0x7dee0010, 0x3f4d0089, 0x00000000}},  //   _cavo, nősé, džu_,
  { {0x6298010f, 0x69c50039, 0x20090085, 0x00000000}},  //   _davo, nyhe, _ayai_,
  { {0xf9da007b, 0x0ef8013d, 0x6593006b, 0x00000000}},  //   פֿיל, ंक्स_, _nəhə,
  { {0x63a20100, 0x21290093, 0x00000000, 0x00000000}},  //   _gron, _diah_,   ,
  { {0xe3b00123, 0x62980006, 0x248d0145, 0x00000000}},  //   _خرم_, _gavo, leem_,
  { {0xdd920355, 0x2ee10146, 0x00000000, 0x00000000}},  //   دوز_, _dmhf_,   ,
  { {0x248d0343, 0x6593006b, 0x91fc0089, 0x00000000}},  //   neem_, _cəhə, rgāt,
  { {0xc4d20476, 0x6abc0211, 0x63a2013f, 0x00000000}},  // [12a0] אגן_, _porf, _xron,
  { {0x248d0066, 0x09c40044, 0x629800f6, 0x00000000}},  //   heem_, _এইবা, _xavo,
  { {0xa84a0025, 0x6abc010f, 0x91fc0089, 0x00000000}},  //   كلام_, _vorf, lgār,
  { {0x67280107, 0xa2a10316, 0x212902d4, 0x00000000}},  //   _sidj, _कोस्, _xiah_,
  { {0x66e601fb, 0x248d0c6a, 0x6abc06d6, 0x00000000}},  //   нода, deem_, _torf,
  { {0x248d012d, 0x69c50c6b, 0x6593006b, 0x00000000}},  //   eeem_, byhe, _zəhə,
  { {0x67280c6c, 0x69c10c6d, 0x00000000, 0x00000000}},  //   _vidj, _ülep,   ,
  { {0x6298028c, 0x67280093, 0x62830133, 0x00000000}},  //   _savo, _widj, _abno,
  { {0x62980c6e, 0xe3b2006d, 0xa6860c6f, 0x00000000}},  //   _pavo, ارع_, _плад,
  { {0x21290c70, 0x00000000, 0x00000000, 0x00000000}},  //   _siah_,   ,   ,
  { {0x63a200ab, 0x629a00ea, 0x250b00a1, 0x00000000}},  //   _wron, rdto, _کرلی_,
  { {0x63a200ad, 0x3cfa013d, 0x00000000, 0x00000000}},  //   _tron, ंवों_,   ,
  { {0x09dd0201, 0x62980c71, 0xbfa8007c, 0x00000000}},  //   _मध्य, _tavo, нтре_,
  { {0x61eb0010, 0xb3e90025, 0x6593006b, 0x00000000}},  //   állá, _تعمل_, _səhə,
  { {0xe29b007b, 0x7ae500ca, 0xe2970545, 0x00000000}},  //   _זשור, viht, _чај_,
  { {0x7f4d002b, 0xb05b00b0, 0x2f160190, 0x00000000}},  //   _twaq, kkäi, væge_,
  { {0x7dee0047, 0x3a750364, 0x2d9e0c72, 0x00000000}},  // [12b0] tősé, клар, åter_,
  { {0x69110c73, 0x69c50023, 0x63bd0637, 0x00000000}},  //   gåen, tyhe, øsni,
  { {0x1df9007c, 0x7ae5014a, 0x20c200fa, 0x00000000}},  //   _цены_, riht, _góis_,
  { {0xf7710137, 0xa9070084, 0x69c501d6, 0x00000000}},  //   لات_, ربان, ryhe,
  { {0x7d0d006c, 0x257a0007, 0xafdb0056, 0x00000000}},  //   mlas, eël_, dbøk,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6d5a0363, 0x1af40c74, 0x257a0065, 0x00000000}},  //   štav, _спря, gël_,
  { {0x7d0d0c75, 0xafdb00ea, 0x00000000, 0x00000000}},  //   nlas, gbøk,   ,
  { {0x0735081e, 0x248d0abf, 0x8af0006b, 0x00000000}},  //   _резю, reem_, ksəl,
  { {0x7d0d06b8, 0xc3c80025, 0x257a0065, 0x00000000}},  //   hlas, عظيم_, bël_,
  { {0x3de10055, 0x8602007a, 0x63ad0c76, 0x00000000}},  //   _মুসল, _پژوه, _šand,
  { {0xa2a102fb, 0x349501fc, 0xf992009b, 0x00000000}},  //   _कोर्, _јадр, ברט_,
  { {0xe28e012b, 0x7d0d0c77, 0x64490181, 0x00000000}},  //   _ка_, dlas, mbei,
  { {0x644901e5, 0x20c20051, 0x7d0d0c78, 0x00000000}},  //   lbei, _cóir_, elas,
  { {0x628101e5, 0x442f00e0, 0x64490c79, 0x00000000}},  //   mflo, _kgg_, obei,
  { {0x7d0d01cd, 0x64490c7a, 0x753c0010, 0x00000000}},  //   glas, nbei, _érze,
  { {0x69110c7b, 0x1d0700ed, 0x60dd0c7c, 0x00000000}},  // [12c0] tåen, тети_, ërme,
  { {0x6281002b, 0x4a43072b, 0x7d0d006c, 0x00000000}},  //   nflo, инув, alas,
  { {0x7d0d0c7d, 0x64490635, 0x00000000, 0x00000000}},  //   blas, kbei,   ,
  { {0x6d5c0240, 0x8af0006b, 0x00000000, 0x00000000}},  //   msra, msəm,   ,
  { {0xd7ef0054, 0x7d04089e, 0xb86500a1, 0x00000000}},  //   يكم_, mois, طانو,
  { {0xa2a101f5, 0x7d0400b0, 0x442f0197, 0x00000000}},  //   _कोल्, lois, _agg_,
  { {0x6d5c0039, 0x1ae3022a, 0x09e6007c, 0x00000000}},  //   nsra, _торм, _ровн,
  { {0x7d040c7e, 0x443d0022, 0x22490107, 0x00000000}},  //   nois, _cfw_, _đaka_,
  { {0x613e0089, 0x628100f8, 0x64a301fc, 0x00000000}},  //   _mīle, fflo, рања,
  { {0x02a601fb, 0x7d0d014a, 0x7d040c7f, 0x00000000}},  //   трим, zlas, hois,
  { {0x7d04021e, 0xf484007a, 0x443d0c80, 0x00000000}},  //   kois, _ماشی, _ffw_,
  { {0x6d5c00ea, 0x044602dc, 0x7d0400b0, 0x00000000}},  //   dsra, _редн, jois,
  { {0x7d0400b0, 0xc0e4007e, 0xfbdf01c3, 0x00000000}},  //   dois, роўк, _leêr_,
  { {0x7658000b, 0x00000000, 0x00000000, 0x00000000}},  //   navy,   ,   ,
  { {0x2fcd0119, 0x7d0d0c75, 0x6d5c00ea, 0x00000000}},  //   šeg_, tlas, gsra,
  { {0x48bd0044, 0x656a0051, 0x7d040c81, 0x00000000}},  //   _আগ্র, irfh, gois,
  { {0x7d0d010f, 0x20c20051, 0xe7bd0044, 0x00000000}},  // [12d0] rlas, _tóir_, _অধ্য,
  { {0x7d0d006c, 0x76580c82, 0xf09f00d4, 0x00000000}},  //   slas, javy, ldà_,
  { {0x7d0d0292, 0x6f020051, 0x7d040c83, 0x00000000}},  //   plas, _íoca, bois,
  { {0x658a006b, 0x6d470066, 0x48e10044, 0x00000000}},  //   _məhd, mpja, যক্র,
  { {0x973500e9, 0x62810016, 0x6d5a0c84, 0x00000000}},  //   اکرا, yflo, štat,
  { {0xfc3f013e, 0x00000000, 0x00000000, 0x00000000}},  //   _sníh_,   ,   ,
  { {0xceb4012f, 0x940d006b, 0x443d00d9, 0x00000000}},  //   ייס_, ənən_, _pfw_,
  { {0x2619013d, 0x8a1801ab, 0x00000000, 0x00000000}},  //   येगी_, _росс_,   ,
  { {0x64490c85, 0x27e0002a, 0xf794008b, 0x00000000}},  //   rbei, úint_, _катэ,
  { {0xf09f0129, 0x64490c86, 0x7d0400e7, 0x00000000}},  //   edà_, sbei, zois,
  { {0x6281000c, 0x7d0400e7, 0x658a006b, 0x00000000}},  //   rflo, yois, _cəhd,
  { {0x6281000c, 0x20c20051, 0xe7b70061, 0x00000000}},  //   sflo, _cóip_, _आपाप,
  { {0x6e29005f, 0x273901aa, 0x7d040c7e, 0x00000000}},  //   əmbə, _jèn_, vois,
  { {0x249f0c87, 0x6d5c04b2, 0xe29600ed, 0x00000000}},  //   ldum_, tsra, _баш_,
  { {0x7d04021e, 0x69110c88, 0xa0a60c89, 0x00000000}},  //   tois, tåel, _байд,
  { {0x249f009f, 0x724200a1, 0x6d5c0089, 0x00000000}},  //   ndum_, _پھیل, rsra,
  { {0x7d0400b0, 0x237f0036, 0x8fa6007e, 0x00000000}},  // [12e0] rois, ntuj_, _сапе,
  { {0xda650054, 0x8f9b00b3, 0x63a40c8a, 0x00000000}},  //   لامي, _טיפי, _šink,
  { {0x7d040c8b, 0xbebb0023, 0x00000000, 0x00000000}},  //   pois, yqëz,   ,
  { {0x237f0c8c, 0x27390082, 0x00000000, 0x00000000}},  //   ktuj_, _bèn_,   ,
  { {0x27e00009, 0x249f0c8d, 0x76580c8e, 0x00000000}},  //   àin_, ddum_, tavy,
  { {0xb8cb0754, 0x3b0a0057, 0x2ca00004, 0x00000000}},  //   _को_, _чего_, ldid_,
  { {0x2ca0006c, 0x00000000, 0x00000000, 0x00000000}},  //   odid_,   ,   ,
  { {0x2ca00004, 0x765807d3, 0x8af0006b, 0x00000000}},  //   ndid_, savy, ksək,
  { {0xc676025a, 0xe646081c, 0x66760318, 0x00000000}},  //   _مطاب, _безп, _مدار,
  { {0x4b7b0049, 0x63ad0161, 0x5b7b0049, 0x00000000}},  //   עטיג, _šanc, עריא,
  { {0xdb060023, 0x5ab70049, 0x00000000, 0x00000000}},  //   _arkë, אליע_,   ,
  { {0x2ca00022, 0x00000000, 0x00000000, 0x00000000}},  //   jdid_,   ,   ,
  { {0xf09f0129, 0x2d9a0c8f, 0x2ca00c90, 0x00000000}},  //   rdà_, _aspe_, ddid_,
  { {0x11d6002c, 0x539b0104, 0x66cf00ea, 0x00000000}},  //   _متعد, _ניוו, _nøkl,
  { {0x7f440919, 0x56370049, 0xfce90025, 0x00000000}},  //   _etiq, ראלע_, نفسي_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x4a550072, 0xba550098, 0x6d470c91, 0x00000000}},  // [12f0] икас, ивај, spja,
  { {0xb05b0c92, 0x658a006b, 0x27390c93, 0x00000000}},  //   rkäu, _məhb, _rèn_,
  { {0x6d5a09fc, 0x273901aa, 0x249f005a, 0x00000000}},  //   štar, _sèn_, ydum_,
  { {0x6d45014a, 0x237f0036, 0x5c0702dc, 0x00000000}},  //   _itha, ytuj_, _бяга,
  { {0x0a6b01fc, 0xb05b00b0, 0x00000000, 0x00000000}},  //   _први_, lkäs,   ,
  { {0xe736005e, 0x00000000, 0x00000000, 0x00000000}},  //   шеш_,   ,   ,
  { {0xa5640025, 0xb05b0c94, 0xb9250025, 0x00000000}},  //   مدين, nkäs, _نفسي,
  { {0x38600051, 0x6d4501c3, 0xe79502fd, 0x00000000}},  //   óirt_, _mtha, _پارک,
  { {0x249f014a, 0x00000000, 0x00000000, 0x00000000}},  //   rdum_,   ,   ,
  { {0x6d450051, 0x237f0036, 0x68eb0c95, 0x00000000}},  //   _otha, rtuj_, ligd,
  { {0x25b90076, 0x7f4400f6, 0x237f00b4, 0x00000000}},  //   _جهاد_, _stiq, stuj_,
  { {0x68eb0250, 0x60260c96, 0x00000000, 0x00000000}},  //   nigd, идна,   ,
  { {0x6d450c97, 0x443f0142, 0x60dd0065, 0x00000000}},  //   _atha, mcu_, ërma,
  { {0x443f0c98, 0x00000000, 0x00000000, 0x00000000}},  //   lcu_,   ,   ,
  { {0xa01b0047, 0xddc300ed, 0x1c3a007e, 0x00000000}},  //   lföl, обри, вязь_,
  { {0x645b01a2, 0x00000000, 0x00000000, 0x00000000}},  //   naui,   ,   ,
  { {0x2ca0006c, 0x68eb00c1, 0xef1a007c, 0x00000000}},  // [1300] rdid_, digd, _ими_,
  { {0xc33200b3, 0x6723012d, 0xb05b010e, 0x00000000}},  //   קוב_, jmnj, skät,
  { {0x2d9a00ca, 0x00000000, 0x00000000, 0x00000000}},  //   _uspe_,   ,   ,
  { {0x200c005f, 0xa967017f, 0x270e02d2, 0x00000000}},  //   ədir_, рица_, ित्र_,
  { {0x2b4901f3, 0x443f0142, 0xb05b04ce, 0x00000000}},  //   cpac_, dcu_, sjäg,
  { {0x658a005f, 0x236d0465, 0x316b0036, 0x00000000}},  //   _rəhb, drej_, ńczy_,
  { {0x60d60161, 0x00000000, 0x00000000, 0x00000000}},  //   _olym,   ,   ,
  { {0x399b061e, 0xe3e70044, 0x60c40c99, 0x00000000}},  //   _בילד, _পড়ব, _noim,
  { {0xf74301fb, 0x7581009e, 0x00000000, 0x00000000}},  //   _мето, _ہیوم,   ,
  { {0x78a2000d, 0xdce70036, 0x00000000, 0x00000000}},  //   ldov, mują,   ,
  { {0x3a37019b, 0x6f07037e, 0xaa370049, 0x00000000}},  //   ירים_, vojc, יטיק_,
  { {0x60c40c9a, 0x78a20209, 0x236d0a32, 0x00000000}},  //   _coim, ndov, brej_,
  { {0x60c40c9b, 0x77f40309, 0x6d450066, 0x00000000}},  //   _doim, _अशोक_, _stha,
  { {0x0eeb004c, 0xb05b00b0, 0x00000000, 0x00000000}},  //   тьми_, tkäs,   ,
  { {0xdef8008b, 0xd2f8026c, 0xeda40088, 0x00000000}},  //   рыя_, _لکھا_, ошто,
  { {0xdce70036, 0x60d60c9c, 0x8af0006b, 0x00000000}},  //   kują, _glym, mrəy,
  { {0x78a20197, 0x00000000, 0x00000000, 0x00000000}},  // [1310] ddov,   ,   ,
  { {0x6e950054, 0xdce70036, 0x00000000, 0x00000000}},  //   _الدا, dują,   ,
  { {0x6d450c9d, 0x68eb0328, 0x2b49009d, 0x00000000}},  //   _utha, tigd, spac_,
  { {0x78a002ad, 0x00000000, 0x00000000, 0x00000000}},  //   _camv,   ,   ,
  { {0x2d8300b5, 0x443f0466, 0x36690256, 0x00000000}},  //   ltje_, vcu_, гало_,
  { {0x98bc0089, 0x236d012d, 0x68eb0bed, 0x00000000}},  //   īvā_, vrej_, sigd,
  { {0x2d830c9e, 0x443f00ca, 0x645b00ea, 0x00000000}},  //   ntje_, tcu_, taui,
  { {0xfdf80c9f, 0x66cf0030, 0x443f0ca0, 0x00000000}},  //   ימוש_, _køkk, ucu_,
  { {0x60c4002a, 0x443f0ca1, 0x68e903c7, 0x00000000}},  //   _roim, rcu_, _imed,
  { {0x443f000d, 0x236d0ca2, 0xa01b0ca3, 0x00000000}},  //   scu_, rrej_, rföl,
  { {0x60d60ca4, 0x2d830ca5, 0x66cf0030, 0x00000000}},  //   _plym, jtje_, _løkk,
  { {0x236d01d9, 0xfd1f0011, 0xa01b0039, 0x00000000}},  //   prej_, _nhì_, pföl,
  { {0x60c4021e, 0x26c505d2, 0x2d8300bb, 0x00000000}},  //   _voim, _kolo_, etje_,
  { {0x68fb0213, 0x78a20161, 0xc332009b, 0x00000000}},  //   _ljud, zdov, _זוג_,
  { {0x60c40368, 0x645904be, 0x68e90039, 0x00000000}},  //   _toim, _kewi, _omed,
  { {0x26c5011c, 0xcd2a0ca6, 0xb05b0039, 0x00000000}},  //   _lolo_, ужбе_, skär,
  { {0x63bb049a, 0x2d8300b5, 0xfc3f00f6, 0x00000000}},  // [1320] nxun, atje_, _anís_,
  { {0x64590675, 0x68fb0ca7, 0xd05d005f, 0x00000000}},  //   _lewi, _ajud, disə,
  { {0x2722001d, 0x68fb0039, 0xdb040ca8, 0x00000000}},  //   _hưng_, _bjud, nvié,
  { {0x6459018e, 0x291f0ca9, 0x63ab0caa, 0x00000000}},  //   _newi, _chua_, _orgn,
  { {0x78a20b30, 0x96ea0cab, 0x26c50027, 0x00000000}},  //   rdov, лька_, _bolo_,
  { {0x68e900f8, 0x26c50325, 0xdce70036, 0x00000000}},  //   _emed, _colo_, rują,
  { {0x64590cac, 0x6b840a35, 0x98a60cad, 0x00000000}},  //   _bewi, ltig, _ливе,
  { {0xdce70036, 0xd497007c, 0x26c50026, 0x00000000}},  //   pują, брь_, _eolo_,
  { {0x6b84027b, 0x6459018e, 0xd2500054, 0x00000000}},  //   ntig, _dewi, ونة_,
  { {0x6b84010f, 0x68e900ca, 0x291f00fa, 0x00000000}},  //   itig, _zmed, _zhua_,
  { {0x6b84010f, 0x3abb0097, 0x60dd0023, 0x00000000}},  //   htig, אמינ, ërmo,
  { {0x645909d6, 0x6b84067e, 0x2120004a, 0x00000000}},  //   _gewi, ktig, _chih_,
  { {0xdfd8005e, 0x765a0037, 0x27220011, 0x00000000}},  //   бър_, _kety, _cưng_,
  { {0xd9fa0164, 0x27220011, 0x8c000044, 0x00000000}},  //   ्थात_, _dưng_, ্ধান_,
  { {0x6b840112, 0xfd1f0082, 0x765a0cae, 0x00000000}},  //   etig, _phì_, _mety,
  { {0x2d8300b5, 0x3ea100e0, 0xed4e00a1, 0x00000000}},  //   rtje_, _waht_, کھی_,
  { {0x6b840caf, 0x3ea1002b, 0x2d830cb0, 0x00000000}},  // [1330] gtig, _taht_, stje_,
  { {0x68e90cb1, 0x433b0049, 0xf41a0044, 0x00000000}},  //   _smed, טעמב, _ডলার_,
  { {0xfd1f00ad, 0x753a001f, 0x99990364, 0x00000000}},  //   _thì_, _nutz, ркет_,
  { {0x26c50555, 0x628800ea, 0xdced007f, 0x00000000}},  //   _solo_, hfdo, _įkėl,
  { {0x765a0cb2, 0x6c7a007b, 0x6604005d, 0x00000000}},  //   _bety, _דארפ, şikl,
  { {0x35c90cb3, 0x765a0cb4, 0x64590133, 0x00000000}},  //   игло_, _cety, _sewi,
  { {0x765a008d, 0x291f0cb5, 0xd05d005f, 0x00000000}},  //   _dety, _thua_, sisə,
  { {0xf9920104, 0x68e90cb6, 0x9345009a, 0x00000000}},  //   _קרן_, _umed, оние,
  { {0xdcfc0089, 0x03a50cb7, 0x26c5007f, 0x00000000}},  //   ntrā, ципо, _tolo_,
  { {0xdddc0047, 0x21200cb8, 0x765a0cb9, 0x00000000}},  //   zerű, _shih_, _gety,
  { {0x27220082, 0xb05b0cba, 0x00000000, 0x00000000}},  //   _sưng_, tkäp,   ,
  { {0x297a0049, 0x79850016, 0x7b10010f, 0x00000000}},  //   סטרא, ithw, läut,
  { {0xa3bb04e8, 0xbf050061, 0x94050014, 0x00000000}},  //   _حاضر_, ळवून_, _بوشه,
  { {0x63a90cbb, 0x161d006e, 0x673b00e7, 0x00000000}},  //   mven, _फरार_, _muuj,
  { {0x63a9001e, 0x6da30265, 0x2120012d, 0x00000000}},  //   lven, мира, _thih_,
  { {0x27220082, 0x63a90026, 0x60dd01a2, 0x00000000}},  //   _tưng_, oven, chsm,
  { {0xab660cbc, 0x79850016, 0x6b8401a2, 0x00000000}},  // [1340] ювал, ethw, utig,
  { {0x6b840cbd, 0x6023007e, 0x63a90ad6, 0x00000000}},  //   rtig, _ідэа, iven,
  { {0x765a0133, 0x00000000, 0x00000000, 0x00000000}},  //   _rety,   ,   ,
  { {0x63a90292, 0x765a0cbe, 0x6d4e0146, 0x00000000}},  //   kven, _sety, mpba,
  { {0x765a01aa, 0x63a900b5, 0x7cf301d5, 0x00000000}},  //   _pety, jven, għru,
  { {0x63a90cbf, 0x7d1600b0, 0x645d000c, 0x00000000}},  //   dven, llys, ðsin,
  { {0xd54701f9, 0xa967007c, 0x63a90cc0, 0x00000000}},  //   опје_, _мира_, even,
  { {0x387f0051, 0x7d160190, 0x94aa01a4, 0x00000000}},  //   _gcur_, nlys, ртка_,
  { {0x63a90cc1, 0x60ce0066, 0x00000000, 0x00000000}},  //   gven, _ċamp,   ,
  { {0x7d160016, 0x6f020048, 0x8af0006b, 0x00000000}},  //   hlys, _íoch, msəs,
  { {0x63a90cc2, 0x7d160cc3, 0x8af0013f, 0x00000000}},  //   aven, klys, lsəs,
  { {0x63a9081d, 0x00000000, 0x00000000, 0x00000000}},  //   bven,   ,   ,
  { {0x63a90cc4, 0x7d160cc5, 0x4ea70783, 0x00000000}},  //   cven, dlys, орва,
  { {0xe297005e, 0x7d1601c3, 0x00000000, 0x00000000}},  //   _мач_, elys,   ,
  { {0x7b10010f, 0x752201c3, 0x3ceb00e2, 0x00000000}},  //   häus, _khoz, аќам_,
  { {0xd5a4009c, 0x69c3006c, 0xdcee0089, 0x00000000}},  //   _یہ_, änem, tubā,
  { {0x28ab007d, 0x2d9e06ec, 0x6d4e01c3, 0x00000000}},  // [1350] _घोषि, æter_, apba,
  { {0x7e99025a, 0x6d48013e, 0x00000000, 0x00000000}},  //   _اندر_, ídac,   ,
  { {0xdcfc001e, 0x63a9016c, 0x39580016, 0x00000000}},  //   strā, zven, _cwrs_,
  { {0x79850cc6, 0x23660119, 0x6ee90521, 0x00000000}},  //   rthw, _ovoj_, džbi,
  { {0xba770379, 0x7d0d001a, 0x66dd000a, 0x00000000}},  //   _واست, moas, _lèke,
  { {0x60dd0065, 0x7d0d0cc7, 0x63a90cc8, 0x00000000}},  //   ërmj, loas, vven,
  { {0x39580016, 0x00000000, 0x00000000, 0x00000000}},  //   _gwrs_,   ,   ,
  { {0x63a90a0f, 0x7d0d0cc9, 0x2ec80164, 0x00000000}},  //   tven, noas, _रक्त,
  { {0x3a380061, 0x63a900f4, 0xf3f90035, 0x00000000}},  //   _ygrp_, uven, faţa_,
  { {0x2b4b0082, 0x00000000, 0x00000000, 0x00000000}},  //   _mtcc_,   ,   ,
  { {0x7d0d00b0, 0xa0a600e2, 0x00000000, 0x00000000}},  //   koas, панд,   ,
  { {0x210602f4, 0x63a90190, 0x7d0d0035, 0x00000000}},  //   रवेश_, pven, joas,
  { {0x0876007b, 0xe4560049, 0xdfd2006d, 0x00000000}},  //   הערט_, _זינט_, ريس_,
  { {0x75290cca, 0x00000000, 0x00000000, 0x00000000}},  //   lmez,   ,   ,
  { {0x412a02dc, 0x00000000, 0x00000000, 0x00000000}},  //   _локо_,   ,   ,
  { {0x0b460364, 0x201e005f, 0x2b590066, 0x00000000}},  //   знан, ətin_, _bwsc_,
  { {0x7d160193, 0xfc0300e2, 0x394a0022, 0x00000000}},  // [1360] rlys, епто, _stbs_,
  { {0x7d1601e5, 0x6d4e0ccb, 0x2bf00061, 0x00000000}},  //   slys, ppba, _घेणं_,
  { {0x7d160ccc, 0xbe3b009b, 0xf1cb0061, 0x00000000}},  //   plys, _לעית, ाहिन,
  { {0x7d0d001a, 0xc18c0049, 0x658a006b, 0x00000000}},  //   coas, שטאָ, _dəhl,
  { {0xdc37007b, 0x68e30ccd, 0x00000000, 0x00000000}},  //   _מאכט_, ënda,   ,
  { {0x66e301e1, 0x7b10010f, 0xa01b000c, 0x00000000}},  //   ноча, räus, sgög,
  { {0x8af0005f, 0x23660cce, 0xceb3009b, 0x00000000}},  //   ssəs, _svoj_, תיו_,
  { {0x68130036, 0xd37a0478, 0x225c0095, 0x00000000}},  //   _będą, бчо_, _sevk_,
  { {0x2005014a, 0x09c40044, 0x225c0087, 0x00000000}},  //   ğlik_, _এইটা, _pevk_,
  { {0xe5a602dc, 0x2005026d, 0x7d0d0ccf, 0x00000000}},  //   _низи, şlik_, zoas,
  { {0x74160123, 0x7d0d00e7, 0x00000000, 0x00000000}},  //   _کوشا, yoas,   ,
  { {0x69370166, 0x09f7034e, 0x23660465, 0x00000000}},  //   _kćer, למים_, _tvoj_,
  { {0xa3cd007d, 0xdfd802dc, 0x00000000, 0x00000000}},  //   रहण_, пър_,   ,
  { {0x63a20052, 0x00000000, 0x00000000, 0x00000000}},  //   _ison,   ,   ,
  { {0x7d0d001a, 0x629a0cd0, 0x00000000, 0x00000000}},  //   toas, meto,   ,
  { {0x7aee00b5, 0x629a066d, 0x51fb009b, 0x00000000}},  //   _ambt, leto, _להוצ,
  { {0x7d0d001a, 0xfc3f004a, 0x00000000, 0x00000000}},  // [1370] roas, _caía_,   ,
  { {0x63a20cd1, 0x801805f3, 0x7f4d00c4, 0x00000000}},  //   _mson, _عزيز_, _itaq,
  { {0x7d0d0adb, 0x2b4b00d2, 0x75290023, 0x00000000}},  //   poas, _wtcc_, ymez,
  { {0x3ce00cd2, 0x63a20129, 0x57f507e1, 0x00000000}},  //   chiv_, _oson, мпет,
  { {0x6d4a008d, 0x629a0209, 0xdcfc001a, 0x00000000}},  //   _çfar, keto, stră,
  { {0x629a0cd3, 0x658a005f, 0x2ca90cd4, 0x00000000}},  //   jeto, _təhl, ldad_,
  { {0x63a20058, 0x6592003b, 0x7f4d0066, 0x00000000}},  //   _ason, вају, _ltaq,
  { {0x2ca90c1b, 0x7f4d006b, 0xddde000a, 0x00000000}},  //   ndad_, _otaq, _depň,
  { {0x752901d5, 0x290f04cb, 0xb05b0039, 0x00000000}},  //   rmez, moga_, tjän,
  { {0x290f02db, 0x658a006b, 0xe3ca004a, 0x00000000}},  //   loga_, _zəhm, _soñó_,
  { {0x7f4d0489, 0x93ca00a1, 0x63a20197, 0x00000000}},  //   _ataq, مایہ_, _eson,
  { {0x290f016e, 0x6aa700ca, 0x63a204a5, 0x00000000}},  //   noga_, _lajf, _fson,
  { {0x2ca900f8, 0x629a0cd5, 0x00000000, 0x00000000}},  //   ddad_, beto,   ,
  { {0x290f00e7, 0x2ca9004a, 0x853c0006, 0x00000000}},  //   hoga_, edad_, _grės,
  { {0x386d08ba, 0x290f0825, 0x6f0e0428, 0x00000000}},  //   _oder_, koga_, robc,
  { {0x386d0065, 0xb5fc0066, 0x00000000, 0x00000000}},  //   _nder_, _weġg,   ,
  { {0x658a006b, 0x63a20026, 0x394d0059, 0x00000000}},  // [1380] _rəhm, _xson, _česa_,
  { {0x658a006b, 0xb05b0510, 0x7d090cd6, 0x00000000}},  //   _səhm, hjäl, česa,
  { {0x888601fc, 0x6283004a, 0x290f00f8, 0x00000000}},  //   длеж, _mcno, foga_,
  { {0x290f016e, 0x386d0190, 0xddde000a, 0x00000000}},  //   goga_, _cder_, _repň,
  { {0x629a0cd7, 0x872a007e, 0x60dd0023, 0x00000000}},  //   yeto, оўка_, ërmi,
  { {0x473301fb, 0x386d0cd8, 0x00000000, 0x00000000}},  //   вніс, _eder_,   ,
  { {0x69d80030, 0x248d005b, 0x290f0213, 0x00000000}},  //   øved, ffem_, boga_,
  { {0x63a2004a, 0x66cf0056, 0x3eba0085, 0x00000000}},  //   _pson, _søkt, _lnpt_,
  { {0xd90d0cd9, 0x629a0cda, 0xb6cb00a1, 0x00000000}},  //   _این_, teto, _ڈالے_,
  { {0xb6cb026c, 0x628300f6, 0x00000000, 0x00000000}},  //   _والے_, _ccno,   ,
  { {0x658a005f, 0x629a02d5, 0x02a3008b, 0x00000000}},  //   _məhk, reto, трым,
  { {0x63a20058, 0x75490010, 0x629a0213, 0x00000000}},  //   _tson, őszö, seto,
  { {0x044300e3, 0x26cc024f, 0x937703ab, 0x00000000}},  //   _речн, _kodo_, _قصور_,
  { {0xe1ef06c6, 0x7ce30004, 0x2cb90cdb, 0x00000000}},  //   اسی_, _kõrg, _snsd_,
  { {0x26cc0cdc, 0x9f3401fb, 0xdc3a011f, 0x00000000}},  //   _modo_, тері, _açık,
  { {0x26cc0cdd, 0x2ca9004a, 0x00000000, 0x00000000}},  //   _lodo_, udad_,   ,
  { {0x2ca90219, 0x68e20059, 0x290f016e, 0x00000000}},  // [1390] rdad_, dhod, voga_,
  { {0x26cc0555, 0xcf270464, 0x60cd0082, 0x00000000}},  //   _nodo_, _تربي, _hoam,
  { {0x290f0cde, 0x7ce3006c, 0x68e30ccd, 0x00000000}},  //   toga_, _nõrg, ëndo,
  { {0x26de0cdf, 0x2fe4014a, 0xf8690025, 0x00000000}},  //   _alto_, _örgü_, سمتي_,
  { {0x26cc01d9, 0x6aa70c8a, 0x60cd0ce0, 0x00000000}},  //   _bodo_, _tajf, _moam,
  { {0x26cc008e, 0x6f020051, 0xdb060190, 0x00000000}},  //   _codo_, _íoct, _arkæ,
  { {0x04450ce1, 0x6283000a, 0x00000000, 0x00000000}},  //   нейн, _rcno,   ,
  { {0x68e20ce2, 0x27e6014a, 0x2f16000c, 0x00000000}},  //   chod, bzon_, lægt_,
  { {0xe3b10426, 0x248d0466, 0x92f50451, 0x00000000}},  //   ارب_, rfem_, ечні,
  { {0x26cc0ce3, 0x888100a1, 0x00000000, 0x00000000}},  //   _godo_, _شیڈن,   ,
  { {0x78a9006c, 0xcb12009b, 0x78bb01c3, 0x00000000}},  //   _kaev, רלי_, _knuv,
  { {0x26c70ce4, 0xe454008b, 0x98b8001e, 0x00000000}},  //   ljno_, _акцы, _kurā_,
  { {0x952204e1, 0x60cd0ce5, 0xb05b00b0, 0x00000000}},  //   _حکوم, _doam, nkäy,
  { {0x68e20428, 0x78a9006c, 0x25a50022, 0x00000000}},  //   zhod, _laev, _ksll_,
  { {0x60cd0ce6, 0x7d090ab8, 0x3eba0011, 0x00000000}},  //   _foam, česn, _vnpt_,
  { {0xdca3013b, 0x7693005d, 0x64490335, 0x00000000}},  //   ласи, lıyı, ncei,
  { {0xac070264, 0x6836011f, 0x68e206b8, 0x00000000}},  // [13a0] ента_, _müdü, vhod,
  { {0x09e6005c, 0x76930180, 0x00000000, 0x00000000}},  //   нозн, nıyı,   ,
  { {0xd910026c, 0xae5b00b6, 0xe93a0076, 0x00000000}},  //   لیس_, _מכיר, سسات_,
  { {0x38600ce7, 0xa01b0073, 0x68e200b9, 0x00000000}},  //   úir_, mför, uhod,
  { {0xa01b03a2, 0xcc3b0049, 0x68e20b4a, 0x00000000}},  //   lför, _מעכט, rhod,
  { {0x68e20107, 0x644b0030, 0x27e60032, 0x00000000}},  //   shod, _afgi, rzon_,
  { {0x68e2037e, 0xa01b0ce8, 0x26cc0059, 0x00000000}},  //   phod, nför, _vodo_,
  { {0x7ce3006c, 0xd37a00ed, 0x693401b2, 0x00000000}},  //   _võrg, пчо_, _شکار,
  { {0x26cc0219, 0x60cd0253, 0x29040093, 0x00000000}},  //   _todo_, _roam, _ijma_,
  { {0x026a007c, 0xa01b0039, 0x60cd012d, 0x00000000}},  //   чший_, kför, _soam,
  { {0xb5fc0066, 0x00000000, 0x00000000, 0x00000000}},  //   _weġb,   ,   ,
  { {0xa01b0039, 0x73e6007c, 0x644900d4, 0x00000000}},  //   dför, _поез, ccei,
  { {0xddcc00b9, 0x658a013f, 0x673a00d9, 0x00000000}},  //   _čišt, _səhh, _kitj,
  { {0x661a0ce9, 0x673a0066, 0x00000000, 0x00000000}},  //   _kytk, _jitj,   ,
  { {0x673a04bd, 0xfcd900a1, 0x60cd001a, 0x00000000}},  //   _mitj, وارڈ_, _toam,
  { {0x673a0ba0, 0x658a013f, 0x00000000, 0x00000000}},  //   _litj, _vəhh,   ,
  { {0x317e00e5, 0x2f160190, 0x5b15004d, 0x00000000}},  // [13b0] lutz_, tægt_, вмат,
  { {0xff500025, 0x00000000, 0x00000000, 0x00000000}},  //   _اخي_,   ,   ,
  { {0x317e0cea, 0x00000000, 0x00000000, 0x00000000}},  //   nutz_,   ,   ,
  { {0x6ee20142, 0x00000000, 0x00000000, 0x00000000}},  //   _vôbe,   ,   ,
  { {0x9814008b, 0x07a504f9, 0x317e010f, 0x00000000}},  //   льшч, талн, hutz_,
  { {0xcf94007b, 0x443d0270, 0xbdf800a2, 0x00000000}},  //   רטס_, _sgw_, _آریا_,
  { {0x6b8d04d7, 0xceb40104, 0x673a023a, 0x00000000}},  //   ltag, טיס_, _ditj,
  { {0xdb060a5d, 0xe3b90ceb, 0x673a00bb, 0x00000000}},  //   _erkä, дби_, _eitj,
  { {0x47940070, 0x64490335, 0x62810462, 0x00000000}},  //   _مجلس, rcei, tglo,
  { {0x24860009, 0xd90d00a1, 0x21290cec, 0x00000000}},  //   _ecom_, _ایچ_, _ahah_,
  { {0x057400a2, 0x69c50023, 0x00000000, 0x00000000}},  //   _ماند, nxhe,   ,
  { {0x62810ced, 0x3f6a0cee, 0xa01b0039, 0x00000000}},  //   sglo, мимо_, vför,
  { {0x6f1c001c, 0xa85600b6, 0x660401df, 0x00000000}},  //   tlrc, כירה_, şikt,
  { {0x658a005f, 0xe1f1007a, 0x6b8d0018, 0x00000000}},  //   _səhi, _پست_, dtag,
  { {0x8d63098c, 0x92580025, 0x6b8d01c3, 0x00000000}},  //   ивре, _أشهر_, etag,
  { {0xa01b03ed, 0x00000000, 0x00000000, 0x00000000}},  //   rför,   ,   ,
  { {0xa01b03a2, 0xcb67026b, 0x6b8d011c, 0x00000000}},  // [13c0] sför, кате_, gtag,
  { {0xa01b00f8, 0x249f0022, 0x00000000, 0x00000000}},  //   pför, heum_,   ,
  { {0xa01b000c, 0x673a00bb, 0xef1f0010, 0x00000000}},  //   ngön, _ritj, ztük_,
  { {0x673a0cef, 0x080a0014, 0x6b8d0c4c, 0x00000000}},  //   _sitj, وزشي_, btag,
  { {0x2ca0006c, 0x673a0129, 0x98b800e5, 0x00000000}},  //   meid_, _pitj, _aură_,
  { {0x2ca00cf0, 0x7c260089, 0xda65006d, 0x00000000}},  //   leid_, _izkr, _مافي,
  { {0x44200006, 0x888402fd, 0x673a0cf1, 0x00000000}},  //   _ši_, _میان, _vitj,
  { {0x4420001d, 0x2ca0006c, 0xef1f0010, 0x00000000}},  //   _ơi_, neid_, ttük_,
  { {0xccf300b6, 0x2b46002a, 0x673a002b, 0x00000000}},  //   יכה_, íoch_, _titj,
  { {0x2ca0049b, 0x21290127, 0x2d9a05b7, 0x00000000}},  //   heid_, _shah_, _oppe_,
  { {0x60f90cf2, 0xc4860057, 0x2ca0095a, 0x00000000}},  //   ення_, _алек, keid_,
  { {0x6b8d0cf3, 0x249f0036, 0x64a602ea, 0x00000000}},  //   ytag, ceum_, _јада,
  { {0x2ca0006c, 0x44200011, 0x996200b9, 0x00000000}},  //   deid_, _ái_, _níže_,
  { {0x44260061, 0x2d470cf4, 0x6b8d0cf5, 0x00000000}},  //   _izo_, _põe_, vtag,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6b8d0cf6, 0x2ca00cf7, 0x00000000, 0x00000000}},  //   ttag, geid_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  // [13d0]   ,   ,   ,
  { {0x6b8d028c, 0xbb190054, 0x60dd021f, 0x00000000}},  //   rtag, رياض_, lksm,
  { {0x6b8d0cf8, 0x2ca00cf9, 0x249f0022, 0x00000000}},  //   stag, beid_, yeum_,
  { {0xf7710355, 0x60dd0006, 0x98ad0036, 0x00000000}},  //   مات_, nksm, _mieć_,
  { {0xb05b0cfa, 0x6d4500e7, 0x36d501ab, 0x00000000}},  //   rjäh, _huha, лодр,
  { {0x6d450cfb, 0x6f150211, 0xd6db0077, 0x00000000}},  //   _kuha, nozc, ьте_,
  { {0x298801f9, 0x6d450cfc, 0xf3f9001a, 0x00000000}},  //   _исто_, _juha, maţi_,
  { {0xf3f9001a, 0x60dd00bb, 0x63890023, 0x00000000}},  //   laţi_, jksm, _nënç,
  { {0xf49500a2, 0x42d5007e, 0xe7960167, 0x00000000}},  //   نشکد, гіну, _مالک,
  { {0xdb0402d5, 0x2fd9018e, 0x63ad0091, 0x00000000}},  //   rviç, dysg_, _šans,
  { {0x658a006b, 0x6d450110, 0x442604e7, 0x00000000}},  //   _səhv, _nuha, _ezo_,
  { {0xcea900b6, 0xf48701fc, 0x758200a1, 0x00000000}},  //   _מי_, _јужн, _ایٹم,
  { {0x645b0007, 0x2ca00cfd, 0xe2a80014, 0x00000000}},  //   mbui, veid_, راین_,
  { {0x6d45006a, 0x201e001e, 0x645b0cfe, 0x00000000}},  //   _buha, āti_, lbui,
  { {0x2ca0084c, 0xe296005e, 0x44260cff, 0x00000000}},  //   teid_, _сащ_, _zzo_,
  { {0x6d450d00, 0x645b00bb, 0x658a006b, 0x00000000}},  //   _duha, nbui, _təhv,
  { {0x2ca0095c, 0x0c260b7a, 0x6d4501ed, 0x00000000}},  // [13e0] reid_, уман, _euha,
  { {0x2ca00004, 0xf3f9001a, 0x3f8204a5, 0x00000000}},  //   seid_, gaţi_, muku_,
  { {0x3f820d01, 0x6d450061, 0x2d9a0039, 0x00000000}},  //   luku_, _guha, _uppe_,
  { {0x7d7b00a3, 0xa3e3013d, 0x00000000, 0x00000000}},  //   _אנטו, नना_,   ,
  { {0x6d450668, 0x3f820d02, 0x7c260089, 0x00000000}},  //   _zuha, nuku_, _uzkr,
  { {0xf3f9001a, 0x7d0401a2, 0x6d450085, 0x00000000}},  //   caţi_, lnis, _yuha,
  { {0x7d040207, 0x3f820085, 0x00000000, 0x00000000}},  //   onis, huku_,   ,
  { {0x33740d03, 0x7d040d04, 0x3f82014a, 0x00000000}},  //   агир, nnis, kuku_,
  { {0xd70a026b, 0x7d040051, 0x3f820093, 0x00000000}},  //   _знае_, inis, juku_,
  { {0x7d040d05, 0x92b60379, 0x00000000, 0x00000000}},  //   hnis, احظا,   ,
  { {0x645b0026, 0xe3b20bb6, 0x00000000, 0x00000000}},  //   bbui, _گرا_,   ,
  { {0x33860081, 0x2ba502fb, 0x6d450d06, 0x00000000}},  //   _букв, _ऑनला, _ruha,
  { {0x7d040107, 0x6d4504cb, 0x3f820022, 0x00000000}},  //   dnis, _suha, guku_,
  { {0x6d450d07, 0x7d04095c, 0xf1a6003b, 0x00000000}},  //   _puha, enis, _брин,
  { {0x59a4013d, 0x7d040d08, 0xf3f90035, 0x00000000}},  //   _गैलर, fnis, vaţi_,
  { {0x7d0405af, 0xd90400a6, 0x7d1600e0, 0x00000000}},  //   gnis, _ری_, goys,
  { {0x78a20179, 0x6d450066, 0xf3f9001a, 0x00000000}},  // [13f0] deov, _wuha, taţi_,
  { {0x7d0400d4, 0x6d450127, 0x00000000, 0x00000000}},  //   anis, _tuha,   ,
  { {0x7d04001f, 0x658a005f, 0xad2700a6, 0x00000000}},  //   bnis, _məhs, _مرحو,
  { {0x64420d09, 0x2d8305fd, 0xf3f9001a, 0x00000000}},  //   _ngoi, muje_, saţi_,
  { {0x2d91022b, 0x47350256, 0x62980165, 0x00000000}},  //   ltze_, андс, _obvo,
  { {0x4b7a0049, 0x64420032, 0x645b00d9, 0x00000000}},  //   _באשו, _agoi, wbui,
  { {0x2d830395, 0x645b01d6, 0x2d91002d, 0x00000000}},  //   nuje_, tbui, ntze_,
  { {0x09e103d7, 0x78a20d0a, 0x2d910032, 0x00000000}},  //   पनीय, ceov, itze_,
  { {0xe78700e1, 0x2d830428, 0xe7980d0b, 0x00000000}},  //   _љубо, huje_, _مخلص_,
  { {0x3ae40073, 0x6442002d, 0x3f820107, 0x00000000}},  //   _köpa_, _egoi, vuku_,
  { {0x2d8306a6, 0x3ea30d0c, 0x7d04000c, 0x00000000}},  //   juje_, dejt_, ynis,
  { {0xf5300025, 0x3f82007f, 0x00000000, 0x00000000}},  //   _فإن_, tuku_,   ,
  { {0x7d040107, 0x8c3b01a2, 0x00000000, 0x00000000}},  //   vnis, _maßs,   ,
  { {0x3f820119, 0xc8e2013d, 0x7d040052, 0x00000000}},  //   ruku_, _खत्म_, wnis,
  { {0x7d040d0d, 0xacf6025f, 0x6da6058d, 0x00000000}},  //   tnis, ачај, шива,
  { {0x7ce3006c, 0xdb0f00f6, 0x3f820d0e, 0x00000000}},  //   _põra, _arcà, puku_,

  { {0x7d04032c, 0x8fa600c0, 0xac050025, 0x00000000}},  // [1400] rnis, _тапе, مذكو,
  { {0x7d040d0f, 0x2d830b41, 0xba26007e, 0x00000000}},  //   snis, buje_, адзк,
  { {0x78a20d10, 0x7e7b009b, 0xc8660d11, 0x00000000}},  //   teov, _באיז, атли,
  { {0xd7fa008b, 0x00000000, 0x00000000, 0x00000000}},  //   кул_,   ,   ,
  { {0x27e00195, 0x78a20133, 0x00000000, 0x00000000}},  //   áin_, reov,   ,
  { {0x78a2001c, 0x64420d12, 0x6b840d13, 0x00000000}},  //   seov, _sgoi, muig,
  { {0xafdb0030, 0x27e00340, 0x00000000, 0x00000000}},  //   ncør, šin_,   ,
  { {0xd9430140, 0x658a006b, 0x00000000, 0x00000000}},  //   _фети, _bəhr,   ,
  { {0x6676007a, 0xb4d60061, 0x1afb0044, 0x00000000}},  //   _ندار, _हवी_, ্তরে_,
  { {0x4ac901f5, 0x63ab0146, 0x00000000, 0x00000000}},  //   रायव, _dsgn,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x2d830428, 0x00000000, 0x00000000, 0x00000000}},  //   vuje_,   ,   ,
  { {0x658a005f, 0x89370049, 0x61ff006b, 0x00000000}},  //   _təhs, ירטע_, _əylə,
  { {0xdefb0642, 0x272001aa, 0x539b00b3, 0x00000000}},  //   тым_, fòni_, _סיוו,
  { {0x27290051, 0x3ea30065, 0x8e380025, 0x00000000}},  //   núna_, rejt_, لسفر_,
  { {0x2d91002d, 0x3ea30d14, 0x2c780088, 0x00000000}},  //   rtze_, sejt_, ийсь_,
  { {0x2d830036, 0x3ea30065, 0x6f950025, 0x00000000}},  // [1410] suje_, pejt_, _الخض,
  { {0x2d830161, 0x628800ab, 0xed4e00a1, 0x00000000}},  //   puje_, ngdo, بھی_,
  { {0xf9f901b7, 0xdb2600a1, 0x3ce90056, 0x00000000}},  //   دفاع_, حولی, phav_,
  { {0x6d57002d, 0xb4d5006e, 0x6b8401c3, 0x00000000}},  //   _itxa, _सके_, buig,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x9a840098, 0x00000000, 0x00000000, 0x00000000}},  //   _мусл,   ,   ,
  { {0x25ac0082, 0x00000000, 0x00000000, 0x00000000}},  //   _csdl_,   ,   ,
  { {0xe9190088, 0x00000000, 0x00000000, 0x00000000}},  //   _собі_,   ,   ,
  { {0x658a006b, 0x368b005e, 0xa82501b2, 0x00000000}},  //   _qəhr, _асен_, _اکان,
  { {0x2d730107, 0x6d570032, 0xa2e500e2, 0x00000000}},  //   kće_, _otxa, соод,
  { {0x6b8400bb, 0x00000000, 0x00000000, 0x00000000}},  //   zuig,   ,   ,
  { {0x658a006b, 0x00000000, 0x00000000, 0x00000000}},  //   _təhr,   ,   ,
  { {0xe2990d15, 0x6d57002d, 0x7e770009, 0x00000000}},  //   _бал_, _atxa, _bdxp,
  { {0x63a90d16, 0x2d73012d, 0xd9f9007d, 0x00000000}},  //   mwen, fće_, ्पात_,
  { {0xdef9007e, 0x63a90036, 0x8db50088, 0x00000000}},  //   рыў_, lwen, ості,
  { {0x6b8400b5, 0xa5da0049, 0x00000000, 0x00000000}},  //   tuig, אַמי,   ,
  { {0x60c40004, 0x3ce005d5, 0x6d57002d, 0x00000000}},  // [1420] _inim, rkiv_, _etxa,
  { {0x60d6008e, 0x4bd9007c, 0x00000000, 0x00000000}},  //   _hoym, шься_,   ,
  { {0xbed70049, 0x60d6014a, 0x63a901a2, 0x00000000}},  //   _הויז_, _koym, hwen,
  { {0x6d5c0977, 0x63a9000b, 0xe89401fb, 0x00000000}},  //   mpra, kwen, іаль,
  { {0x6b8400c4, 0xb796003b, 0x29060d17, 0x00000000}},  //   quig, срећ, rnoa_,
  { {0xef1f011f, 0x6ffc0089, 0x63a90007, 0x00000000}},  //   ltür_, mācī, dwen,
  { {0x6d5c0263, 0x60c40091, 0xc7af00a1, 0x00000000}},  //   npra, _onim, وڑے_,
  { {0x98bc0089, 0xdbdd0027, 0x63a90d18, 0x00000000}},  //   īvē_, zšír, fwen,
  { {0x394a0b8b, 0x9696017f, 0x63a9002b, 0x00000000}},  //   _hubs_, _греш, gwen,
  { {0x68e20010, 0x6eeb050d, 0x6d5c01c3, 0x00000000}},  //   lkod, _kübe, kpra,
  { {0xba9b01ce, 0x658a006b, 0x5a9b0049, 0x00000000}},  //   נסטי, _təhq, נשטא,
  { {0x68e20006, 0x692c001a, 0x7afe014a, 0x00000000}},  //   nkod, _aşez, hipt,
  { {0x7afe009f, 0x6eeb01a2, 0x53a30228, 0x00000000}},  //   kipt, _lübe, _нацб,
  { {0x39580d19, 0x7afe0065, 0x60c403b6, 0x00000000}},  //   _otrs_, jipt, _enim,
  { {0x6d5c0336, 0x68e20d1a, 0x8af0013f, 0x00000000}},  //   gpra, kkod, rpəl,
  { {0x99860046, 0x657c068f, 0x2d730107, 0x00000000}},  //   łoś_, _århu, rće_,
  { {0x09e10061, 0x8b580025, 0x8af902dc, 0x00000000}},  // [1430] पन्य, مجلس_, анас_,
  { {0x2d730d1b, 0x6e99007e, 0x7afe0048, 0x00000000}},  //   pće_, _твор_, gipt,
  { {0x69de001c, 0x7f3c007b, 0x39580009, 0x00000000}},  //   gype, _געזו, _ctrs_,
  { {0xad2706c6, 0x3869009f, 0x0cab0441, 0x00000000}},  //   _درخو, úar_, _стои_,
  { {0x395800f6, 0x2a6a0026, 0x00000000, 0x00000000}},  //   _etrs_, _febb_,   ,
  { {0xab5b010f, 0xe739007c, 0x7afe04cb, 0x00000000}},  //   _prüf, шел_, cipt,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x63a9010f, 0x280401dc, 0x00000000, 0x00000000}},  //   twen, ásná_,   ,
  { {0x6d5c0235, 0x63a900b5, 0x25a00035, 0x00000000}},  //   zpra, uwen, ăila_,
  { {0x81d40055, 0x68e90224, 0x63a9001f, 0x00000000}},  //   _সেই_, _hled, rwen,
  { {0x5455026b, 0x68e90d1c, 0x63a9037f, 0x00000000}},  //   _двет, _kled, swen,
  { {0x60d6006b, 0x6d5c0059, 0x63a90173, 0x00000000}},  //   _qoym, vpra, pwen,
  { {0xb05b0510, 0x00000000, 0x00000000, 0x00000000}},  //   tjär,   ,   ,
  { {0x6d5c06ed, 0x68e20d1d, 0x539a00b3, 0x00000000}},  //   tpra, zkod, _כינו,
  { {0x8237035b, 0x68e90d1e, 0xe3b90010, 0x00000000}},  //   _ارشا, _oled, lvű_,
  { {0x60c40d1f, 0xb05b0d20, 0x6eeb01a2, 0x00000000}},  //   _unim, sjär, _rübe,
  { {0x6d5c0d21, 0x2a780093, 0x611201c5, 0x00000000}},  // [1440] spra, _pdrb_, rāld,
  { {0x6d5c0c08, 0x68e9008e, 0x25550089, 0x00000000}},  //   ppra, _aled, _zāle_,
  { {0x7afe062a, 0x8c460259, 0x68e200ea, 0x00000000}},  //   ript, _мене, tkod,
  { {0x319a0049, 0x69de01d6, 0x6f1c0197, 0x00000000}},  //   יבענ, rype, lorc,
  { {0x7d0902db, 0x68e20232, 0x7afe00e0, 0x00000000}},  //   čest, rkod, pipt,
  { {0x7afe048a, 0x68e20d22, 0x6f1c0129, 0x00000000}},  //   qipt, skod, norc,
  { {0xc44804e1, 0xbb430373, 0xab5b0d23, 0x00000000}},  //   میان_, _церк, _prüg,
  { {0x68e90340, 0x15170025, 0xd2500014, 0x00000000}},  //   _gled, يزية_, کند_,
  { {0x39440093, 0x6b960af1, 0x00000000, 0x00000000}},  //   _iims_, ntyg,   ,
  { {0xb5fc002b, 0x7f5d0045, 0xe5a60c96, 0x00000000}},  //   _leġi, vpsq, _мизи,
  { {0x7ce3006c, 0xab5b0d24, 0xdcfc01c5, 0x00000000}},  //   _sõrm, _trüg, ntrē,
  { {0x39440203, 0x00000000, 0x00000000, 0x00000000}},  //   _jims_,   ,   ,
  { {0x6f1c00ab, 0x00000000, 0x00000000, 0x00000000}},  //   forc,   ,   ,
  { {0x63a20d25, 0x6b960675, 0x6f1c0091, 0x00000000}},  //   _ipon, dtyg, gorc,
  { {0x3eb3005f, 0x2b4b0197, 0xdb0d00c4, 0x00000000}},  //   _vaxt_, _succ_, lvaç,
  { {0x9f6b012b, 0x1fa700ed, 0x8b670025, 0x00000000}},  //   _кроз_, _дрог, قائم,
  { {0x200c005f, 0x6f1c0871, 0x00000000, 0x00000000}},  // [1450] şdir_, borc,   ,
  { {0x6f1c0555, 0x2732001a, 0x61120089, 0x00000000}},  //   corc, nând_, rāle,
  { {0xfc3f0d26, 0xdcf50036, 0x68e9060b, 0x00000000}},  //   _país_, erzą, _pled,
  { {0x63a20036, 0x394400d4, 0xaac9007d, 0x00000000}},  //   _opon, _cims_, राहक,
  { {0x995400b9, 0x39440190, 0x37ab0ab6, 0x00000000}},  //   _výše_, _dims_, ртен_,
  { {0xb34500c4, 0x7bda009b, 0x68e90016, 0x00000000}},  //   _liçã, _הקשו, _wled,
  { {0x63a20181, 0x3944000a, 0xfc3f00fa, 0x00000000}},  //   _apon, _fims_, _taís_,
  { {0x68fb0d27, 0x6fcb01f5, 0x2ca90d28, 0x00000000}},  //   _umud, ामां, nead_,
  { {0x291d0036, 0x46150123, 0x399502e7, 0x00000000}},  //   mowa_, _کوار, lås_,
  { {0x386d0b10, 0x291d0036, 0x2ca90d29, 0x00000000}},  //   _heer_, lowa_, head_,
  { {0x386d049b, 0x63a20d2a, 0x6f1c08d0, 0x00000000}},  //   _keer_, _epon, vorc,
  { {0x291d0036, 0x7cf10d2b, 0x8fa60072, 0x00000000}},  //   nowa_, _hårf, паме,
  { {0x386d049b, 0x6f1c0606, 0xb5fc01d5, 0x00000000}},  //   _meer_, torc, _reġi,
  { {0x386d0d2c, 0x2732001a, 0x248d0d2d, 0x00000000}},  //   _leer_, când_, lgem_,
  { {0x63bb000c, 0x291d0036, 0x2ca90051, 0x00000000}},  //   lvun, kowa_, fead_,
  { {0x2ca90061, 0x248d0d2e, 0x386d00c7, 0x00000000}},  //   gead_, ngem_, _neer_,
  { {0x291d0036, 0x39440d2f, 0x61e10d30, 0x00000000}},  // [1460] dowa_, _rims_, lyll,
  { {0xe81f02d2, 0x8b23007c, 0x6b960039, 0x00000000}},  //   _बड़ा_, едуе, rtyg,
  { {0x6edb009b, 0x6b960d31, 0x39950d32, 0x00000000}},  //   _החיפ, styg, gås_,
  { {0x2fc00c88, 0x3eaa010f, 0x2732001a, 0x00000000}},  //   _krig_, lebt_, zând_,
  { {0xdcfc001e, 0x4cbb00b6, 0x2d9804b9, 0x00000000}},  //   strē, _הזכו, ltre_,
  { {0x6d46011f, 0x8f9b00a0, 0x6b840d33, 0x00000000}},  //   _hika, מיני, mrig,
  { {0x6d460d34, 0x61e10030, 0x6b840190, 0x00000000}},  //   _kika, jyll, lrig,
  { {0x6eeb02b9, 0x94aa007e, 0x2d980d35, 0x00000000}},  //   _müba, стка_, itre_,
  { {0x6d460d36, 0x6b840030, 0x2732001a, 0x00000000}},  //   _mika, nrig, tând_,
  { {0x6d460d37, 0x386d02ae, 0xdb0d0181, 0x00000000}},  //   _lika, _zeer_, rvaç,
  { {0x64a60175, 0x6b84010f, 0x2732001a, 0x00000000}},  //   _нажа, hrig, rând_,
  { {0x6d460119, 0x2fc0018e, 0x6b840cb2, 0x00000000}},  //   _nika, _brig_, krig,
  { {0x613f001e, 0x3869000c, 0x2732001a, 0x00000000}},  //   _jūli, ðari_, pând_,
  { {0x44260d38, 0x6b8406f8, 0x6d46021e, 0x00000000}},  //   _iyo_, drig, _aika,
  { {0x6d46002d, 0x6b84010f, 0x06fd00b9, 0x00000000}},  //   _bika, erig, _říká_,
  { {0x2d830065, 0x6d460563, 0x44260d39, 0x00000000}},  //   rrje_, _cika, _kyo_,
  { {0x2d9c0073, 0x6d46020c, 0x66dd01aa, 0x00000000}},  // [1470] _även_, _dika, _mèkr,
  { {0x386d0007, 0x13df0055, 0x7cea0428, 0x00000000}},  //   _seer_, _বেড়, _výra,
  { {0x291d0036, 0x2d8a008e, 0x75220010, 0x00000000}},  //   towa_, cube_, _okoz,
  { {0xf7710d3a, 0xddde0224, 0x39950039, 0x00000000}},  //   نات_, _nepř, rås_,
  { {0x7d0d01bf, 0x4426006a, 0x386d0c95, 0x00000000}},  //   mnas, _nyo_, _veer_,
  { {0x386d049b, 0xea63026c, 0xd2460025, 0x00000000}},  //   _weer_, _سپری, _لن_,
  { {0x44260d3b, 0x67210059, 0x386d0007, 0x00000000}},  //   _ayo_, _vklj, _teer_,
  { {0x7d0d0d3c, 0x0445005e, 0x44260061, 0x00000000}},  //   nnas, мейн, _byo_,
  { {0x44260061, 0x61e1018e, 0x248d0d3d, 0x00000000}},  //   _cyo_, wyll, rgem_,
  { {0x7cf101bf, 0x7d0d018e, 0x67210091, 0x00000000}},  //   _hård, hnas, _uklj,
  { {0x7d0d0d3e, 0x44260d3f, 0x00000000, 0x00000000}},  //   knas, _eyo_,   ,
  { {0x61e10016, 0x63a40035, 0x00000000, 0x00000000}},  //   ryll, _ţine,   ,
  { {0x61e1018e, 0x3f8b016c, 0xdb0f008e, 0x00000000}},  //   syll, gucu_, _escé,
  { {0x2d980d40, 0x75290555, 0x6b840193, 0x00000000}},  //   ttre_, llez, vrig,
  { {0x6d4603b6, 0x311601e0, 0x6b840d41, 0x00000000}},  //   _pika, _офис, wrig,
  { {0xd132004b, 0x7d0d000c, 0x2d9806f0, 0x00000000}},  //   _جمع_, gnas, rtre_,
  { {0x2d980d42, 0x6d460d43, 0x0b460088, 0x00000000}},  // [1480] stre_, _vika, днан,
  { {0x6b840d44, 0xa01b03ed, 0x6d46011c, 0x00000000}},  //   rrig, rgöt, _wika,
  { {0x6d46001e, 0x644b0d45, 0x7c260036, 0x00000000}},  //   _tika, _oggi, _wykr,
  { {0x6b840d46, 0xfd45007e, 0x395c0089, 0x00000000}},  //   prig, _пэўн, īvs_,
  { {0x75290521, 0xa01b00f8, 0x7d0401b1, 0x00000000}},  //   dlez, lgör, miis,
  { {0x644b0198, 0x7529000b, 0x7d0400b0, 0x00000000}},  //   _aggi, elez, liis,
  { {0x7ae300b0, 0xa01b0d47, 0xdcf50036, 0x00000000}},  //   önte, ngör, erzę,
  { {0x7529001a, 0x7cf105cb, 0x29020039, 0x00000000}},  //   glez, _gård, _öka_,
  { {0x386601a3, 0xddde013e, 0x00000000, 0x00000000}},  //   mbor_, _vepř,   ,
  { {0x65c60401, 0x6d5e0091, 0x644b01e5, 0x00000000}},  //   _обза, _otpa, _eggi,
  { {0xe8df0011, 0x75290d48, 0x7cf103bd, 0x00000000}},  //   _hiền_, blez, _håre,
  { {0x44260058, 0xf503005e, 0x7cf107c4, 0x00000000}},  //   _tyo_, _изхо, _kåre,
  { {0x6d5e001e, 0x7ce30004, 0xc0e4007e, 0x00000000}},  //   _atpa, _kõrv, тоўк,
  { {0xe8df001d, 0x3f990d49, 0x3f8b014a, 0x00000000}},  //   _miền_, rtsu_, rucu_,
  { {0xdd94008b, 0xc348001d, 0xe8df0011, 0x00000000}},  //   кары, _nổi_, _liền_,
  { {0x30a702a8, 0x7d040d4a, 0x201e001a, 0x00000000}},  //   _цркв, giis, ştia_,
  { {0x7d0d0d4b, 0xfd44008b, 0x3866012d, 0x00000000}},  // [1490] rnas, тэрн, dbor_,
  { {0x0dcb005e, 0x19eb0025, 0x4ac9006e, 0x00000000}},  //   _думи_, يراً_, राइव,
  { {0xceb201ce, 0x212b0016, 0x00000000, 0x00000000}},  //   _גיי_, olch_,   ,
  { {0x25a50022, 0x7cf10190, 0xe8df0082, 0x00000000}},  //   _rpll_, _båre, _biền_,
  { {0x7cf10039, 0x78ab0d4c, 0xc7ab0d0b, 0x00000000}},  //   _vård, regv, تدال_,
  { {0x6b8d0020, 0x6d58009d, 0x7aee00fa, 0x00000000}},  //   muag, _évac, _glbt,
  { {0x27e90466, 0x75290d4d, 0x657a0068, 0x00000000}},  //   šan_, tlez, _cvth,
  { {0x672a040f, 0x7cf1032e, 0x00000000, 0x00000000}},  //   alfj, _fåre,   ,
  { {0x752900bb, 0x387f0066, 0x68e400b0, 0x00000000}},  //   rlez, _idur_, öide,
  { {0x752900b9, 0x290f00e0, 0x00000000, 0x00000000}},  //   slez, lnga_,   ,
  { {0x75290cc1, 0x00000000, 0x00000000, 0x00000000}},  //   plez,   ,   ,
  { {0x644b0026, 0x6b8d0bb2, 0x387f0066, 0x00000000}},  //   _uggi, kuag, _jdur_,
  { {0x7d0403b6, 0x13a70014, 0x290f0056, 0x00000000}},  //   viis, _آنتی_, inga_,
  { {0x613601ca, 0x7e75002d, 0x2d5500ea, 0x00000000}},  //   dále, gazp, _båe_,
  { {0x6da30751, 0x387f0477, 0x7d040052, 0x00000000}},  //   лира, _odur_, tiis,
  { {0x7cea0428, 0xe05800a2, 0x387f01f3, 0x00000000}},  //   _výro, _زیست_, _ndur_,
  { {0x7d0401c2, 0x6b8d0197, 0x61360d4e, 0x00000000}},  // [14a0] riis, guag, ráld,
  { {0x7d04010e, 0x2cb900f6, 0x387f0d4f, 0x00000000}},  //   siis, _easd_, _adur_,
  { {0x88860098, 0x7cf101c4, 0xf9690088, 0x00000000}},  //   ележ, _såre, дрій_,
  { {0xdd2f00b9, 0x00000000, 0x00000000, 0x00000000}},  //   pěšn,   ,   ,
  { {0x3c77009b, 0x387f0af2, 0x38660133, 0x00000000}},  //   _אתכם_, _ddur_, rbor_,
  { {0x290f0051, 0x7cf1093b, 0xa8240014, 0x00000000}},  //   anga_, _våre, _یکشن,
  { {0x212b018e, 0x6b490d50, 0x940a006b, 0x00000000}},  //   ylch_, _užga, əbə_,
  { {0xe8df001d, 0xd9430d51, 0xf3660b81, 0x00000000}},  //   _tiền_, _беси, нтон,
  { {0x7ce3010e, 0x29060032, 0x2ca00048, 0x00000000}},  //   _tõrv, mioa_, ifid_,
  { {0x877b00b3, 0xdb970049, 0x2906002d, 0x00000000}},  //   _מאמי, עדיט_, lioa_,
  { {0x27e60890, 0x26cc0d52, 0xe6d9000c, 0x00000000}},  //   lyon_, _indo_, _þráð,
  { {0x29060d53, 0x00000000, 0x00000000, 0x00000000}},  //   nioa_,   ,   ,
  { {0xa30b009c, 0xa2e60d54, 0xe8df0011, 0x00000000}},  //   _کرنے_, _подд, _hiển_,
  { {0x26de0020, 0x9f350088, 0x3eba0133, 0x00000000}},  //   _joto_, тегі, _capt_,
  { {0x7e750d55, 0x3eba0d56, 0x00000000, 0x00000000}},  //   razp, _dapt_,   ,
  { {0x0ccf0055, 0x26de0035, 0x6b8d0d57, 0x00000000}},  //   রস্ত, _loto_, tuag,
  { {0x60cd0b1f, 0x26cc022b, 0x27e60263, 0x00000000}},  // [14b0] _inam, _ondo_, jyon_,
  { {0x26de0207, 0x6b8d002d, 0x2cb9000a, 0x00000000}},  //   _noto_, ruag, _wasd_,
  { {0xab5b001f, 0x7b0b0089, 0x6b8d0032, 0x00000000}},  //   _grün, kļuv, suag,
  { {0xa95401fb, 0x6c790049, 0xdb04000c, 0x00000000}},  //   укці, _קאָפ, svið,
  { {0x27e60047, 0x60cd0020, 0x26de0d58, 0x00000000}},  //   gyon_, _mnam, _boto_,
  { {0xe8df001d, 0x04ed0044, 0x8698005e, 0x00000000}},  //   _biển_, _ওদের_, етът_,
  { {0x5b14025f, 0x27e60058, 0x26de01c5, 0x00000000}},  //   _смрт, ayon_, _doto_,
  { {0x81c80044, 0x60cd0045, 0xe8df0082, 0x00000000}},  //   োনা_, _nnam, _diển_,
  { {0x249f000c, 0xf699012b, 0x1fcb0061, 0x00000000}},  //   rfum_, _овај_, ामोड,
  { {0x60cd0020, 0x26de0d59, 0x00000000, 0x00000000}},  //   _anam, _goto_,   ,
  { {0x67230d5a, 0xe4e70088, 0x60cd00ea, 0x00000000}},  //   monj, _підн, _bnam,
  { {0x6723002b, 0x60cd0019, 0xd00a00ed, 0x00000000}},  //   lonj, _cnam, деме_,
  { {0x78bb00f4, 0x3ae40039, 0xe29900ed, 0x00000000}},  //   _mauv, _köpt_, _жал_,
  { {0x2906022b, 0x60cd0004, 0x672307d7, 0x00000000}},  //   zioa_, _enam, nonj,
  { {0x27e60d5b, 0xeab200a1, 0x60cd0009, 0x00000000}},  //   zyon_, یٹر_, _fnam,
  { {0xfbe70011, 0x645b0d5c, 0x29060032, 0x00000000}},  //   _thể_, ncui, xioa_,
  { {0x3eba0056, 0x672304eb, 0x00000000, 0x00000000}},  // [14c0] _tapt_, konj,   ,
  { {0x67230066, 0x00000000, 0x00000000, 0x00000000}},  //   jonj,   ,   ,
  { {0x67230d5d, 0x26de004a, 0x29060032, 0x00000000}},  //   donj, _roto_, tioa_,
  { {0xe786008b, 0x27e601aa, 0xa9670d5e, 0x00000000}},  //   вуко, tyon_, тица_,
  { {0xa2b2001c, 0x26de01aa, 0x2906022b, 0x00000000}},  //   _असल्, _poto_, rioa_,
  { {0x27e6049a, 0x67230020, 0x7bc6002b, 0x00000000}},  //   ryon_, gonj, _irku,
  { {0x27e60d5f, 0x26de0d60, 0x66e306e3, 0x00000000}},  //   syon_, _voto_, роја,
  { {0x399c0129, 0x6abc014a, 0x27e60173, 0x00000000}},  //   mís_, _harf, pyon_,
  { {0x290401d5, 0x26de0428, 0x67230d61, 0x00000000}},  //   _imma_, _toto_, bonj,
  { {0x6723001a, 0x78bb0091, 0x60cd00ca, 0x00000000}},  //   conj, _zauv, _snam,
  { {0x6abc001a, 0x68e007e0, 0x399c0d62, 0x00000000}},  //   _marf, _komd, nís_,
  { {0x7bc60d63, 0x645b0026, 0xb97b00a0, 0x00000000}},  //   _orku, ccui, ונטי,
  { {0x399c0051, 0x68e300c4, 0x6f0700d0, 0x00000000}},  //   hís_, êndi, tijc,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xdef8008b, 0x5e5801fb, 0x6f0700ca, 0x00000000}},  //   тыя_, тися_, rijc,
  { {0x399c0d64, 0x60cd0020, 0x853c0006, 0x00000000}},  //   dís_, _unam, _spėj,
  { {0x6d58009d, 0x7bc60087, 0x67230045, 0x00000000}},  // [14d0] _évan, _crku, yonj,
  { {0x2904005f, 0x78bb028c, 0x6136009f, 0x00000000}},  //   _amma_, _sauv, mála,
  { {0xce330167, 0x61360047, 0x6abc0d65, 0x00000000}},  //   _خودک, lála, _darf,
  { {0xfc640265, 0xfc3f008e, 0x68e00048, 0x00000000}},  //   _върн, _maíz_, _comd,
  { {0xd3660076, 0x6723002b, 0x9cd600b6, 0x00000000}},  //   _ده_, tonj, _עושה_,
  { {0x29040039, 0x6abc005b, 0x399c0d66, 0x00000000}},  //   _emma_, _garf, bís_,
  { {0x399c0d67, 0x61360051, 0x67230c33, 0x00000000}},  //   cís_, hála, ronj,
  { {0x2602001c, 0xe3b90d68, 0x69c70093, 0x00000000}},  //   _वेळी_, еби_, _irje,
  { {0x67230d69, 0xecc50044, 0x6136000c, 0x00000000}},  //   ponj, _একাড, jála,
  { {0xe8df00ad, 0x645b001a, 0x61e8018e, 0x00000000}},  //   _diễn_, scui, fydl,
  { {0x394d01b5, 0x04950355, 0xb1460595, 0x00000000}},  //   _kies_, _ملاح, лнол,
  { {0xa6e2009f, 0x201e014a, 0x00000000, 0x00000000}},  //   _öðru, ştim_,   ,
  { {0x61360d6a, 0x394d00b0, 0xdcfc0089, 0x00000000}},  //   gála, _mies_, strī,
  { {0x69c70d6b, 0xe299012b, 0x2d910d6c, 0x00000000}},  //   _orje, _чак_, fuze_,
  { {0x5239007b, 0x62830982, 0xd336009b, 0x00000000}},  //   _אײַנ, _idno, _גרסה_,
  { {0x394d01d5, 0x399c0d6d, 0x6abc0095, 0x00000000}},  //   _nies_, vís_, _sarf,
  { {0x6abc0d6e, 0x69c70d6f, 0xdc75007e, 0x00000000}},  // [14e0] _parf, _arje, рысь,
  { {0x89f6008b, 0x80a002d2, 0x2d910c39, 0x00000000}},  //   ляец, ग्रे, buze_,
  { {0x6abc0d70, 0x7ce30004, 0x80d80061, 0x00000000}},  //   _varf, _võrr, यापे,
  { {0x399c0d71, 0x394d00d4, 0x7bc60521, 0x00000000}},  //   rís_, _cies_, _trku,
  { {0x394d0d72, 0x62830119, 0x66e60878, 0x00000000}},  //   _dies_, _odno, лода,
  { {0xd5ba0594, 0x00000000, 0x00000000, 0x00000000}},  //   еси_,   ,   ,
  { {0x394d06f8, 0xdb230010, 0xc7b90010, 0x00000000}},  //   _fies_, _óráj, _eső_,
  { {0x2904000b, 0x6283018e, 0xc448007a, 0x00000000}},  //   _umma_, _adno, نیان_,
  { {0xd2500054, 0x2729027b, 0x9cd7009b, 0x00000000}},  //   ينة_, gúns_, רופה_,
  { {0xe8df0011, 0x61e80039, 0x61360010, 0x00000000}},  //   _viễn_, tydl, vála,
  { {0x62340ab7, 0xe61600ed, 0x546a0d73, 0x00000000}},  //   рену, _сфаќ, _заем_,
  { {0x2d910061, 0x62830d74, 0xe8df0011, 0x00000000}},  //   vuze_, _edno, _tiễn_,
  { {0x8cbf03d7, 0xe47b0049, 0x72d40467, 0x00000000}},  //   _लोगो, _טראכ, _волф,
  { {0x43830d75, 0x61360d76, 0xef1f0180, 0x00000000}},  //   _الوق, rála, mrük_,
  { {0x6d5800f4, 0x61360d77, 0xeca700ed, 0x00000000}},  //   _éval, máln, лјан,
  { {0x69c7008d, 0x55770049, 0xf19300a1, 0x00000000}},  //   _rrje, טעלן_, _اُٹھ,
  { {0xe8df00ad, 0x1bd4005e, 0x394d0d78, 0x00000000}},  // [14f0] _hiện_, ботя, _ries_,
  { {0xe8df001d, 0x613608aa, 0x394d0944, 0x00000000}},  //   _kiện_, náln, _sies_,
  { {0xc33300b6, 0x394d0a6d, 0x00000000, 0x00000000}},  //   צוע_, _pies_,   ,
  { {0x2fc90343, 0xe8df0082, 0xd7f10025, 0x00000000}},  //   _krag_, _miện_, يكا_,
  { {0x394d0d79, 0x61360d7a, 0xdb0f008e, 0x00000000}},  //   _vies_, káln, _escá,
  { {0x6d4f0180, 0x6b8d0190, 0x394d01a2, 0x00000000}},  //   _hica, mrag, _wies_,
  { {0x394d0006, 0x45190001, 0x8aa40088, 0x00000000}},  //   _ties_, кция_, _уряд,
  { {0x7cf80d7b, 0x6d4f000a, 0x7e770d7c, 0x00000000}},  //   _vírg, _jica, _lexp,
  { {0x28f80077, 0x6d4f0d7d, 0x00000000, 0x00000000}},  //   _сеть_, _mica,   ,
  { {0x425502a8, 0xe8df0011, 0x6d4f0197, 0x00000000}},  //   штит, _biện_, _lica,
  { {0x7cf80047, 0x6b8d0d7e, 0xa06a00ed, 0x00000000}},  //   _híre, hrag, кана_,
  { {0xe8df001d, 0x2fc90190, 0x6b8d01d6, 0x00000000}},  //   _diện_, _brag_, krag,
  { {0xf3670242, 0x61120089, 0x61360d7f, 0x00000000}},  //   _стен, nāli, báln,
  { {0x7cf80051, 0x6d57006b, 0xdcee00b9, 0x00000000}},  //   _míre, _buxa, ědče,
  { {0x6d4f04cb, 0x2d9e00f4, 0x442f01d6, 0x00000000}},  //   _bica, îte_, _hyg_,
  { {0x6b8d001f, 0xb4e30061, 0xa2cd0204, 0x00000000}},  //   frag, _नको_, ताक्,
  { {0x6d4f0d80, 0x61360010, 0x7cf10748, 0x00000000}},  // [1500] _dica, lálo, _tårn,
  { {0xff7b007b, 0x7bc40cc7, 0x442f0190, 0x00000000}},  //   _שטימ, rviu, _myg_,
  { {0x6d4f02d5, 0x442f0006, 0x61360d81, 0x00000000}},  //   _fica, _lyg_, nálo,
  { {0xdbdc01ca, 0x2c5c0036, 0x3ead0091, 0x00000000}},  //   lšíc, _bądź_, đete_,
  { {0x3869004a, 0x69c500ea, 0x6b8d009d, 0x00000000}},  //   ñara_, avhe, crag,
  { {0x7cf8002a, 0x6d57006b, 0x613d0010, 0x00000000}},  //   _díre, _yuxa, méle,
  { {0x6d5c0d82, 0x7cf80051, 0x6d4f0009, 0x00000000}},  //   nqra, _tírd, _yica,
  { {0x7d1600b0, 0x442f0030, 0x7e7c009d, 0x00000000}},  //   nnys, _byg_, harp,
  { {0x2bc9007d, 0x61360d83, 0x7e7c0d84, 0x00000000}},  //   रिया, táln, karp,
  { {0x39580036, 0xdbdc0161, 0x6eeb0d85, 0x00000000}},  //   _kurs_, jšíc, _tübi,
  { {0x61360d86, 0x7e7c00ea, 0x8af0006b, 0x00000000}},  //   ráln, darp, vqəl,
  { {0xb356089d, 0xe8df001d, 0xab5b001f, 0x00000000}},  //   _پیدا_, _viện_, _früh,
  { {0x6d4f0d87, 0x7cf101e3, 0x7e7c0016, 0x00000000}},  //   _rica, _dårl, farp,
  { {0xe8df001d, 0x6b8d05f2, 0x395806fa, 0x00000000}},  //   _tiện_, vrag, _ours_,
  { {0x13b602f4, 0xab5b0d88, 0x6136004a, 0x00000000}},  //   _अनुभ, _trük, cálo,
  { {0x6b8d001f, 0x2fc90035, 0x61360010, 0x00000000}},  //   trag, _trag_, náll,
  { {0x2a780093, 0xa0680098, 0xa2cb0061, 0x00000000}},  // [1510] _berb_, _тања_, _थोड्,
  { {0x6b8d0d89, 0xf9c702d3, 0x6d4f0093, 0x00000000}},  //   rrag, ищен, _wica,
  { {0x39580d8a, 0x6d4f005d, 0x6b8d01a2, 0x00000000}},  //   _curs_, _tica, srag,
  { {0x39580d8b, 0x69c10089, 0x61120089, 0x00000000}},  //   _durs_, _šles, tāli,
  { {0x7d0d0046, 0x00000000, 0x00000000, 0x00000000}},  //   mias,   ,   ,
  { {0x395800f6, 0x7cf80051, 0x442f08c8, 0x00000000}},  //   _furs_, _víre, _ryg_,
  { {0xa50900ed, 0x442f0d8c, 0x39580087, 0x00000000}},  //   лека_, _syg_, _gurs_,
  { {0x7d0d0006, 0x61360d8d, 0x201e001a, 0x00000000}},  //   nias, gáll, ştii_,
  { {0x57f500ed, 0xe3b10025, 0x387d005b, 0x00000000}},  //   _упат, سرة_, mawr_,
  { {0x81e20055, 0x61360d8e, 0x6d440036, 0x00000000}},  //   _নেই_, tálo, zmia,
  { {0x7e7c009f, 0x6d440016, 0x7d0d0d8f, 0x00000000}},  //   varp, ymia, kias,
  { {0x387d0016, 0x3f6a003b, 0x2d5c008e, 0x00000000}},  //   nawr_, лимо_, _ríe_,
  { {0x7e7c0d90, 0x320b0036, 0xdbdc0861, 0x00000000}},  //   tarp, ńcy_, tšíc,
  { {0x2cab00c4, 0x613d0d91, 0x3f5d0082, 0x00000000}},  //   _abcd_, véle, _dìu_,
  { {0x61460265, 0x7e7c00ea, 0x51950025, 0x00000000}},  //   _лека, rarp, _العذ,
  { {0x3d080061, 0x2a780065, 0x4bda007c, 0x00000000}},  //   _सगळे_, _serb_, льзя_,
  { {0x4aaa01f9, 0x6d440904, 0x7e7c0052, 0x00000000}},  // [1520] лкан_, rmia, parp,
  { {0x6d4401a3, 0x7d160a67, 0x61360010, 0x00000000}},  //   smia, snys, záll,
  { {0x7d0d0d92, 0xc8790279, 0x7cf80d93, 0x00000000}},  //   bias, _beş_, _círc,
  { {0x7d0d0d94, 0x2732001a, 0x7c96005e, 0x00000000}},  //   cias, mâni_, _уроц,
  { {0x3f820027, 0x09e00055, 0x02b70061, 0x00000000}},  //   nsku_, _যেখা, _असून,
  { {0xb8ef03d7, 0xe3e8026c, 0x3ce00c1e, 0x00000000}},  //   _वो_, یکشن_, ljiv_,
  { {0xceb300b6, 0x61360010, 0x395800bb, 0x00000000}},  //   פיה_, táll, _uurs_,
  { {0x18a30216, 0xdb1d0039, 0x4d7b0049, 0x00000000}},  //   _насм, _ersä, ארקע,
  { {0xe73a01f9, 0x24180147, 0x3f820091, 0x00000000}},  //   _беа_, ропы_, jsku_,
  { {0x27f9006c, 0x39460d95, 0x3f5d0082, 0x00000000}},  //   _üsna_, lmos_, _rìu_,
  { {0xd2500070, 0x613d0010, 0x00000000, 0x00000000}},  //   بند_, vélb,   ,
  { {0x3a37019b, 0x463b0049, 0xca37009b, 0x00000000}},  //   מרים_, _געבע, מניה_,
  { {0x7d0d023a, 0x394600dc, 0x00000000, 0x00000000}},  //   vias, imos_,   ,
  { {0x61360010, 0xdb1d00c4, 0x28cf007d, 0x00000000}},  //   nálj, _essê, _सोनि,
  { {0xc27b007b, 0x7d0d044e, 0x25be00fa, 0x00000000}},  //   _גרוי, tias, _jstl_,
  { {0xdb060010, 0x00000000, 0x00000000, 0x00000000}},  //   _eskü,   ,   ,
  { {0x6eeb006b, 0xa2cd0061, 0xfc330025, 0x00000000}},  // [1530] _sübu, ताच्, سحر_,
  { {0x7d0d000b, 0xda670054, 0x629a00ab, 0x00000000}},  //   sias, صائي, ngto,
  { {0xb9b5031d, 0x7d0d0d96, 0x99620161, 0x00000000}},  //   تماع, pias, _píše_,
  { {0x38350594, 0x212b0d97, 0x00000000, 0x00000000}},  //   онер, noch_,   ,
  { {0x65680065, 0x7d1d00bb, 0x00000000, 0x00000000}},  //   _atdh, _ijss,   ,
  { {0x39460d98, 0x3cef0061, 0x212b0142, 0x00000000}},  //   amos_, _इकडे_, hoch_,
  { {0x286b025f, 0x19940d99, 0x05790025, 0x00000000}},  //   _брзо_, _наря, جمعة_,
  { {0x2d8300bb, 0x394600e5, 0xe9190088, 0x00000000}},  //   isje_, cmos_, _тобі_,
  { {0x212b0d9a, 0x290f006c, 0x9f4e013e, 0x00000000}},  //   doch_, miga_, žném_,
  { {0x290f0073, 0xf6f500d3, 0x1309007c, 0x00000000}},  //   liga_, _بزرگ, рной_,
  { {0xf7480054, 0x75290d9b, 0x2d8300bb, 0x00000000}},  //   _اللي_, poez, jsje_,
  { {0xa4f7007a, 0xa2a90316, 0x3f82016e, 0x00000000}},  //   _دکتر_, _जॉर्, tsku_,
  { {0x3f84004f, 0x61360010, 0x6ef0010e, 0x00000000}},  //   ému_, lálk, _häbi,
  { {0x290f0d9c, 0x7cea000c, 0x68f80089, 0x00000000}},  //   higa_, _nýrr, īvdi,
  { {0xdd9204e8, 0x290f0d9d, 0x25550089, 0x00000000}},  //   ظور_, kiga_, _tālu_,
  { {0x3f82037e, 0x290f0059, 0x61120089, 0x00000000}},  //   psku_, jiga_, tālu,
  { {0x290f03af, 0x6ef00004, 0xeb9a00ed, 0x00000000}},  // [1540] diga_, _läbi, риз_,
  { {0x2d910046, 0x80d80061, 0xdcfc001e, 0x00000000}},  //   brze_, यावे, turē,
  { {0x60c40d9e, 0xfce6003b, 0x3eb80d9f, 0x00000000}},  //   _kaim, _доно, mert_,
  { {0x60c40211, 0x3eb80056, 0x290f006c, 0x00000000}},  //   _jaim, lert_, giga_,
  { {0x39460da0, 0x39400089, 0x2d980549, 0x00000000}},  //   rmos_, ķis_, lure_,
  { {0x39460325, 0x60c40a5c, 0x6b84002a, 0x00000000}},  //   smos_, _laim, msig,
  { {0x20dd0061, 0x290f0da1, 0x2d980133, 0x00000000}},  //   यामध, biga_, nure_,
  { {0x443d001f, 0x60c40247, 0x3eb8010f, 0x00000000}},  //   _bzw_, _naim, hert_,
  { {0xa686017f, 0x6b840198, 0x3eb8009f, 0x00000000}},  //   _млад, nsig, kert_,
  { {0x2d9801c5, 0x61360047, 0x6b840da2, 0x00000000}},  //   kure_, lálh, isig,
  { {0xd62a0057, 0x3eb80c7a, 0x60c40da3, 0x00000000}},  //   _тоже_, dert_, _baim,
  { {0x613d009f, 0x61360010, 0xdb1d00d4, 0x00000000}},  //   féla, nálh, _essè,
  { {0x60c40da4, 0x3eb80da5, 0x212b0142, 0x00000000}},  //   _daim, fert_, roch_,
  { {0x6b840030, 0x3eb80da6, 0x69ce0032, 0x00000000}},  //   dsig, gert_, _orbe,
  { {0x2d9800ab, 0x60c40035, 0x2d850010, 0x00000000}},  //   gure_, _faim, éle_,
  { {0x290f0da7, 0x60c4005b, 0x2d830da8, 0x00000000}},  //   xiga_, _gaim, rsje_,
  { {0x20020046, 0x69de0da9, 0x290f0daa, 0x00000000}},  // [1550] czki_, expe, viga_,
  { {0x3eb800d4, 0xdb0400f4, 0xad670025, 0x00000000}},  //   cert_, ntiè, _واجه,
  { {0xfd10026c, 0x6d3500ed, 0x7ae705d2, 0x00000000}},  //   رجہ_, _неоф, _vojt,
  { {0x52b70164, 0x7ae70036, 0x6b84004a, 0x00000000}},  //   _अस्स, _wojt, bsig,
  { {0x290f07dc, 0x3f99014a, 0x69ce0dab, 0x00000000}},  //   riga_, nusu_, _erbe,
  { {0x290f0dac, 0x69ce0087, 0x00000000, 0x00000000}},  //   siga_, _frbe,   ,
  { {0x3f99000b, 0x290f000b, 0x7cf800b9, 0x00000000}},  //   husu_, piga_, _mírn,
  { {0xd5ae0379, 0x3f990dad, 0x7bcf01ee, 0x00000000}},  //   افي_, kusu_, _krcu,
  { {0x48fa0049, 0x13090088, 0x3ea10051, 0x00000000}},  //   _פּלא, йний_, _ocht_,
  { {0x60c4001e, 0x613d0dae, 0x61360daf, 0x00000000}},  //   _saim, véla, máli,
  { {0x60c40997, 0x68e90db0, 0xe8df0082, 0x00000000}},  //   _paim, _koed, _nhịn_,
  { {0x3ea10db1, 0x3eb8010f, 0x2d98009d, 0x00000000}},  //   _acht_, wert_, vure_,
  { {0xe28e0db2, 0x68e90db3, 0x26c50db4, 0x00000000}},  //   _па_, _moed, _kalo_,
  { {0x2d98030a, 0x60c400a9, 0x3eb801a2, 0x00000000}},  //   ture_, _waim, uert_,
  { {0x6281011c, 0x26c50cce, 0x60c401c2, 0x00000000}},  //   malo, _malo_, _taim,
  { {0x3ea10db5, 0x3eb80292, 0x3f990089, 0x00000000}},  //   _echt_, sert_, busu_,
  { {0x2d980db6, 0x3f990279, 0x69ce0db7, 0x00000000}},  // [1560] sure_, cusu_, _srbe,
  { {0x6b840018, 0x2d980198, 0x62810020, 0x00000000}},  //   rsig, pure_, nalo,
  { {0x68e90db8, 0x68fb0db9, 0x14bd0309, 0x00000000}},  //   _boed, _blud, ्याण,
  { {0x7e7e000c, 0x68fb0016, 0x68e90016, 0x00000000}},  //   _hepp, _clud, _coed,
  { {0x62810010, 0x7e7e009f, 0x68e2002b, 0x00000000}},  //   kalo, _kepp, rjod,
  { {0x6d5e000b, 0x26c50026, 0x7e7e0dba, 0x00000000}},  //   _kupa, _calo_, _jepp,
  { {0x62810dbb, 0x69da0142, 0xbb430088, 0x00000000}},  //   dalo, _štef, _черк,
  { {0x68e90dbc, 0x21200dbd, 0x7e7e03b6, 0x00000000}},  //   _goed, _njih_, _lepp,
  { {0x6d5e0dbe, 0x62810dbf, 0x26c500c4, 0x00000000}},  //   _lupa, falo, _falo_,
  { {0xe3af05f3, 0x6281006a, 0x26c50dc0, 0x00000000}},  //   اري_, galo, _galo_,
  { {0xb5ca03e6, 0x6d5e00c8, 0x68e90022, 0x00000000}},  //   _دوام_, _nupa, _yoed,
  { {0x3f99049d, 0x38660dc1, 0x63a4001a, 0x00000000}},  //   tusu_, ncor_, _ţinu,
  { {0x6281002d, 0x6d5e0dc2, 0xe50503ec, 0x00000000}},  //   balo, _aupa, _تبلي,
  { {0x6d5e023a, 0x628a0030, 0x26c50011, 0x00000000}},  //   _bupa, _udfo, _xalo_,
  { {0xa2a101f5, 0x7e7e0740, 0x63ac0dc3, 0x00000000}},  //   _खात्, _depp, žinč,
  { {0x291c0dc4, 0x5d54012c, 0xa3c00061, 0x00000000}},  //   éval_, екст, _ंना_,
  { {0x68e9018e, 0x201e011f, 0xd008012b, 0x00000000}},  // [1570] _roed, ştir_, _неће_,
  { {0x765a001c, 0x68fb001e, 0x7cf80047, 0x00000000}},  //   _ngty, _slud, _hírl,
  { {0xed5800ed, 0x68fb0dc5, 0x68e90112, 0x00000000}},  //   _ноќ_, _plud, _poed,
  { {0xf990031d, 0x6281016c, 0x61360010, 0x00000000}},  //   ابل_, zalo, táli,
  { {0x2b93089d, 0x37ab005e, 0x68e901b5, 0x00000000}},  //   _سیاس, стен_, _voed,
  { {0x61360010, 0x8f9c00a0, 0x68e901bb, 0x00000000}},  //   ráli, מידי, _woed,
  { {0x62810dc6, 0x68e90116, 0x26c500b0, 0x00000000}},  //   valo, _toed, _valo_,
  { {0x26c50058, 0x68fb014a, 0x290d0032, 0x00000000}},  //   _walo_, _ulud, _umea_,
  { {0xa2a102d2, 0x26c50dc7, 0x7f5f002b, 0x00000000}},  //   _खाद्, _talo_, _nuqq,
  { {0x7bcd0dc8, 0x21cc013e, 0x00000000, 0x00000000}},  //   ivau, _běh_,   ,
  { {0x7e7e0052, 0x387f0116, 0x63a40035, 0x00000000}},  //   _repp, _keur_, _ţint,
  { {0x6281006c, 0x7e7e0dc9, 0x6d5e01a3, 0x00000000}},  //   salo, _sepp, _rupa,
  { {0x6d5e0127, 0x387f00d4, 0xe8df0082, 0x00000000}},  //   _supa, _meur_, _nhọn_,
  { {0x387f028c, 0x56b50049, 0x6d5e0dca, 0x00000000}},  //   _leur_, ופֿן_, _pupa,
  { {0x6da305a5, 0xd10a0439, 0x00000000, 0x00000000}},  //   кира, _وقته_,   ,
  { {0x249f009f, 0x20560057, 0x63a90bb2, 0x00000000}},  //   ngum_, _отпр, oten,
  { {0x63a90dcb, 0xe8df001d, 0x38c60006, 0x00000000}},  // [1580] nten, _chọn_, _jūrų_,
  { {0x6d5e00b0, 0x63a90dcc, 0xc31f0044, 0x00000000}},  //   _tupa, iten, _নীতি_,
  { {0x63a90dcd, 0xf8da0061, 0x387f0dce, 0x00000000}},  //   hten, णालय, _beur_,
  { {0x63a90056, 0x00000000, 0x00000000, 0x00000000}},  //   kten,   ,   ,
  { {0x387f0343, 0x386606c2, 0x69da0091, 0x00000000}},  //   _deur_, rcor_, _šted,
  { {0x386600d4, 0x6136000c, 0xdcfc0006, 0x00000000}},  //   scor_, málu, turė,
  { {0x9418005f, 0x63a9000d, 0xceb300b6, 0x00000000}},  //   ərə_, eten, דיו_,
  { {0x63a90056, 0x2ca0006c, 0x387f0116, 0x00000000}},  //   ften, ngid_, _geur_,
  { {0x63a90dcf, 0x2ca0006c, 0x69e30035, 0x00000000}},  //   gten, igid_, ăteş,
  { {0x7cf1032e, 0x27320035, 0x00000000, 0x00000000}},  //   _hårt, râns_,   ,
  { {0x63a9095c, 0x6128014a, 0x2b580095, 0x00000000}},  //   aten, kıld, _mirc_,
  { {0x63a90dd0, 0x2b580943, 0x00000000, 0x00000000}},  //   bten, _lirc_,   ,
  { {0xa29401ff, 0x63a90dd1, 0x2bd2013d, 0x00000000}},  //   _залі, cten, सिफा,
  { {0x44260288, 0x24840145, 0x6d460dd2, 0x00000000}},  //   _ixo_, lamm_, _ahka,
  { {0x7bcd0009, 0x929b009b, 0xfcc7003b, 0x00000000}},  //   wvau, _ויות, мљам,
  { {0x2b580dd3, 0x2ca00dd4, 0x00000000, 0x00000000}},  //   _airc_, ggid_,   ,
  { {0x8aa7005e, 0x00000000, 0x00000000, 0x00000000}},  // [1590] дред,   ,   ,
  { {0x2b580dd5, 0x2d85008e, 0x7bcd0103, 0x00000000}},  //   _circ_, áles_, rvau,
  { {0x387f00f4, 0x63a90dd6, 0x13b70044, 0x00000000}},  //   _peur_, zten, জিয়,
  { {0x09b10055, 0x63a9000c, 0x4426098e, 0x00000000}},  //   ছিলা, yten, _oxo_,
  { {0x36690175, 0x6d4d0052, 0x387f00d9, 0x00000000}},  //   пало_, mmaa, _veur_,
  { {0xd246006d, 0x6d4d0128, 0x61360010, 0x00000000}},  //   _من_, lmaa, lált,
  { {0x442600c4, 0x6d4d0dd7, 0x644200e5, 0x00000000}},  //   _axo_, omaa, _azoi,
  { {0x6d4d0dd8, 0x61360010, 0xe3c80082, 0x00000000}},  //   nmaa, nált, _bự_,
  { {0x63a90dd9, 0x249f000c, 0xe3c80011, 0x00000000}},  //   uten, rgum_, _cự_,
  { {0x63a90dda, 0xe3c8001d, 0x8af0006b, 0x00000000}},  //   rten, _dự_, qqət,
  { {0x6d4d00bb, 0x6128019a, 0x2747013e, 0x00000000}},  //   kmaa, yıld, _vůně_,
  { {0xcea900b6, 0x00000000, 0x00000000, 0x00000000}},  //   _לי_,   ,   ,
  { {0xc4cf026c, 0x6d4d00c7, 0xdb1d0ddb, 0x00000000}},  //   _مےں_, dmaa, _assí,
  { {0x6d46008d, 0x6561002b, 0x6d4d0112, 0x00000000}},  //   _shka, _kulh, emaa,
  { {0x656102d5, 0xe816013d, 0x6128005a, 0x00000000}},  //   _julh, _देना_, tıld,
  { {0x656102d5, 0x6d4d0222, 0x6b96000c, 0x00000000}},  //   _mulh, gmaa, tryg,
  { {0xf1c9001d, 0x2ca00ddc, 0x6128005d, 0x00000000}},  // [15a0] _hạ_, rgid_, rıld,
  { {0x6b960190, 0x6d4d0103, 0x61280095, 0x00000000}},  //   rryg, amaa, sıld,
  { {0x6128005a, 0x753b0161, 0x499a0147, 0x00000000}},  //   pıld, kluz, ятая_,
  { {0xf1c90011, 0x57a6017a, 0x6d4600b0, 0x00000000}},  //   _mạ_, ешка, _uhka,
  { {0xf1c9001d, 0xe73a0081, 0x69c30030, 0x00000000}},  //   _lạ_, пед_, æner,
  { {0x7bc60119, 0xe5c6064b, 0x8f9b01ce, 0x00000000}},  //   _isku, есио, פיצי,
  { {0xe3c800ad, 0xf1c90011, 0x24840d24, 0x00000000}},  //   _sự_, _nạ_, tamm_,
  { {0x2d98008e, 0x38c800a1, 0x7d040ddd, 0x00000000}},  //   irre_, _غازی_, nhis,
  { {0xd90d01ef, 0xe8b5005d, 0x00000000, 0x00000000}},  //   _بین_, lışı,   ,
  { {0x7aee0bc7, 0xf1c90011, 0x78a200ca, 0x00000000}},  //   _jobt, _bạ_, lgov,
  { {0xe8b502b9, 0x61360daf, 0x7d0402e1, 0x00000000}},  //   nışı, jáls, khis,
  { {0xe3c8001d, 0x78a201ca, 0x7bc6006c, 0x00000000}},  //   _tự_, ngov, _osku,
  { {0x04570054, 0x7d040020, 0x61360010, 0x00000000}},  //   _كلمة_, dhis, vált,
  { {0x3ea50047, 0x1ee70014, 0xbe0500a1, 0x00000000}},  //   ült_, روزی_, پورٹ,
  { {0x7bc60065, 0x6d4d01b5, 0x00000000, 0x00000000}},  //   _asku, tmaa,   ,
  { {0x23b7007d, 0xd9040014, 0xe8b501df, 0x00000000}},  //   _अहमद, _طی_, dışı,
  { {0x6d4d0dde, 0x61360ddf, 0x78a20de0, 0x00000000}},  // [15b0] rmaa, rált, dgov,
  { {0xadf5008b, 0x6d4d006c, 0xab180088, 0x00000000}},  //   _апош, smaa, нієї_,
  { {0x7bc6022b, 0xf1c90011, 0x6d4d07a5, 0x00000000}},  //   _esku, _xạ_, pmaa,
  { {0x7d04001a, 0x38c904e1, 0x57f500e2, 0x00000000}},  //   chis, بائی_, кпет,
  { {0xa2a10061, 0x8af0013f, 0x00000000, 0x00000000}},  //   _खाल्, rqər,   ,
  { {0x7aee0254, 0x65610de1, 0x00000000, 0x00000000}},  //   _gobt, _pulh,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x3ce9021c, 0x69c701ed, 0x00000000, 0x00000000}},  //   njav_, _isje,   ,
  { {0x3f8b0036, 0xd4680025, 0x753b0de2, 0x00000000}},  //   jscu_, رحيم_, rluz,
  { {0x753b037e, 0x7790026c, 0x69d50036, 0x00000000}},  //   sluz, _ایوا, _krze,
  { {0x3f8b0de3, 0x7d040de4, 0x00000000, 0x00000000}},  //   escu_, yhis,   ,
  { {0x69d50de5, 0xdddc0521, 0xf1c90082, 0x00000000}},  //   _mrze, jarš, _vạ_,
  { {0xc9520049, 0x00000000, 0x00000000, 0x00000000}},  //   ימט_,   ,   ,
  { {0x69c70182, 0x78a20119, 0xf1c90011, 0x00000000}},  //   _osje, zgov, _tạ_,
  { {0x386d0de6, 0xe8b5006b, 0x2d980032, 0x00000000}},  //   _ofer_, xışı, urre_,
  { {0x62830de7, 0x7aee00d4, 0xad390088, 0x00000000}},  //   _heno, _sobt, ечує_,
  { {0x7d040056, 0x69c700d9, 0xc0c9003b, 0x00000000}},  // [15c0] rhis, _asje, _чује_,
  { {0x628300b9, 0x7d040de8, 0x386d0065, 0x00000000}},  //   _jeno, shis, _afer_,
  { {0x62830de9, 0x7d0400f4, 0x1d0a0751, 0x00000000}},  //   _meno, phis, _жени_,
  { {0x62830dea, 0xe8b5005d, 0x69d50036, 0x00000000}},  //   _leno, rışı, _drze,
  { {0x98a30242, 0x7bc60deb, 0x69d5010f, 0x00000000}},  //   риче, _usku, _erze,
  { {0x62830dec, 0x799e0061, 0x473301e1, 0x00000000}},  //   _neno, pupw, аніс,
  { {0x69d50036, 0x27e0001a, 0x09e3007c, 0x00000000}},  //   _grze, ţin_, _корн,
  { {0x62830982, 0x00000000, 0x00000000, 0x00000000}},  //   _aeno,   ,   ,
  { {0x62830de7, 0x7d03001a, 0x7cf800fa, 0x00000000}},  //   _beno, _înse, _círi,
  { {0x62830161, 0x7cf80051, 0xe6c50025, 0x00000000}},  //   _ceno, _díri, _متمي,
  { {0x26de0038, 0xe816007d, 0x31c3005e, 0x00000000}},  //   _into_, _देता_, асяв,
  { {0x29060ded, 0x7cf80051, 0x26cc0145, 0x00000000}},  //   nhoa_, _fíri, _hado_,
  { {0x26cc0dee, 0x7cf80def, 0x9443009e, 0x00000000}},  //   _kado_, _gíri, _پھٹن,
  { {0x62830a5e, 0x26cc021c, 0xe57100a1, 0x00000000}},  //   _geno, _jado_, _خطے_,
  { {0x628808cb, 0x63a00149, 0x823300a6, 0x00000000}},  //   mado, lumn, _پروا,
  { {0x26cc029d, 0x6283016c, 0x00000000, 0x00000000}},  //   _lado_, _zeno,   ,
  { {0xac18003b, 0x26de00ab, 0x2b4a0009, 0x00000000}},  // [15d0] воту_, _onto_, _bhbc_,
  { {0x69d50df0, 0x62880977, 0x62830df1, 0x00000000}},  //   _prze, nado, _xeno,
  { {0xb0aa0183, 0x61280279, 0xed4e00a1, 0x00000000}},  //   _कामग, lıla, تھی_,
  { {0xf1b3007b, 0x62880471, 0x63a0008a, 0x00000000}},  //   יסע_, hado, kumn,
  { {0x26cc000b, 0x6128047f, 0x60cd0b48, 0x00000000}},  //   _bado_, nıla, _maam,
  { {0x69d50046, 0x62880211, 0x6d5d0df2, 0x00000000}},  //   _trze, jado, _hisa,
  { {0x6d5d0127, 0x62880df3, 0x26cc0489, 0x00000000}},  //   _kisa, dado, _dado_,
  { {0x62830006, 0x23ab0018, 0x6d5d0020, 0x00000000}},  //   _seno, tøj_, _jisa,
  { {0x6b8d02d5, 0x62830df4, 0x62880df5, 0x00000000}},  //   nsag, _peno, fado,
  { {0x6d5d0004, 0x61280279, 0x26cc0df6, 0x00000000}},  //   _lisa, dıla, _gado_,
  { {0x62830142, 0x60cd0011, 0x0596025a, 0x00000000}},  //   _veno, _baam, _مانگ,
  { {0x6d5d0df7, 0x6b8d016c, 0xd5fa0049, 0x00000000}},  //   _nisa, ksag, _אפער,
  { {0x6128014a, 0xe2990900, 0x26cc0045, 0x00000000}},  //   gıla, _зал_, _yado_,
  { {0x62880df8, 0x33920025, 0x48160049, 0x00000000}},  //   cado, _الوز, אַלן_,
  { {0x6d5d011c, 0x78a90107, 0xb1760011, 0x00000000}},  //   _bisa, _ocev, _trượ,
  { {0x6d5d0690, 0x6b8d000c, 0x6128026d, 0x00000000}},  //   _cisa, fsag, bıla,
  { {0x61280676, 0xeb97007c, 0x6b8d011c, 0x00000000}},  // [15e0] cıla, лит_, gsag,
  { {0x4e3606b4, 0x78a9008e, 0x6d5d0ba5, 0x00000000}},  //   _معجز, _acev, _eisa,
  { {0x6d5d00e7, 0x69c500d9, 0x26cc0a76, 0x00000000}},  //   _fisa, gwhe, _rado_,
  { {0x62880df9, 0x613d0dfa, 0x26cc0065, 0x00000000}},  //   zado, téli, _sado_,
  { {0x01370049, 0x62880dfb, 0x2796030d, 0x00000000}},  //   אָגט_, yado, ушер,
  { {0x62880181, 0x613d09af, 0x6d5d0dfc, 0x00000000}},  //   xado, réli, _zisa,
  { {0xe1e7025a, 0x6288029d, 0x612801f6, 0x00000000}},  //   _اس_, vado, zıla,
  { {0x443d018e, 0x6128005d, 0xd37a00e3, 0x00000000}},  //   _byw_, yıla, нчо_,
  { {0x62880977, 0x60cd0004, 0x29040dfd, 0x00000000}},  //   tado, _raam, _ilma_,
  { {0x60cd0dfe, 0x63a00dff, 0xc8790279, 0x00000000}},  //   _saam, rumn, _inşa_,
  { {0x628800d6, 0x63a00e00, 0xba9b0049, 0x00000000}},  //   rado, sumn, עסטי,
  { {0x62880211, 0x6128005a, 0x443d0016, 0x00000000}},  //   sado, tıla, _fyw_,
  { {0x6d5d0cec, 0x62880142, 0x33f605f3, 0x00000000}},  //   _risa, pado, _حساس,
  { {0x6d5d0515, 0x6128038c, 0x60cd0020, 0x00000000}},  //   _sisa, rıla, _waam,
  { {0x69da0626, 0xbcfb00f4, 0x6b4b010f, 0x00000000}},  //   _šten, _liée, nüge,
  { {0x61280676, 0x6b8d0e01, 0x463b0049, 0x00000000}},  //   pıla, tsag, געלע,
  { {0x6d5d0995, 0x5b150c4e, 0xaae00316, 0x00000000}},  // [15f0] _visa, амат, नांक,
  { {0x6d5d023a, 0x6b8d010f, 0xa3d50309, 0x00000000}},  //   _wisa, rsag, हित_,
  { {0x6b8d0e02, 0x64b40061, 0xba470c18, 0x00000000}},  //   ssag, ंभाळ, ухай,
  { {0xd7d506e3, 0xc9130044, 0x69c502f1, 0x00000000}},  //   ижењ, িক্ত_, rwhe,
  { {0xdb040211, 0x212900d9, 0x00000000, 0x00000000}},  //   stiá, _mjah_,   ,
  { {0x6b4b010f, 0x443d0016, 0x2904014a, 0x00000000}},  //   füge, _ryw_, _elma_,
  { {0x5a44008b, 0xba74026c, 0xf77000a1, 0x00000000}},  //   _гэта, _چاہت, _ہال_,
  { {0x2d9e01ee, 0xe81601f5, 0xd6180025, 0x00000000}},  //   šteg_, _देवा_, دتها_,
  { {0xf77000a2, 0xab5b006c, 0x394d002d, 0x00000000}},  //   _فال_, _psüh, _ihes_,
  { {0x21290093, 0x57f4003b, 0x9814002c, 0x00000000}},  //   _ajah_, _упут, _طبقا,
  { {0xf8c9007d, 0x75dc00e5, 0x00000000, 0x00000000}},  //   _रसाय, _căză,   ,
  { {0x33d501e1, 0x24860197, 0x628e0e03, 0x00000000}},  //   _вікт, _geom_, óbor,
  { {0x9554004b, 0xa936009b, 0x320c0036, 0x00000000}},  //   _اخلا, שטרה_, azdy_,
  { {0x394d0181, 0xa856009b, 0x2cab0045, 0x00000000}},  //   _lhes_, יירה_, _accd_,
  { {0xe2da00a1, 0x63b5007f, 0x00000000, 0x00000000}},  //   _جانچ_, žanč,   ,
  { {0x25ed03d7, 0x395f00d4, 0x6f660098, 0x00000000}},  //   _अपनी_, _nius_, _квиз,
  { {0xed5701f9, 0x6b4b036c, 0x2cb90009, 0x00000000}},  // [1600] рот_, züge, _dbsd_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6f1c0b62, 0x7e9b009b, 0x395f099a, 0x00000000}},  //   mirc, _בסיו, _bius_,
  { {0x394d0462, 0x613d00d6, 0x00000000, 0x00000000}},  //   _ches_, bélu,   ,
  { {0x67d4025f, 0x395f0129, 0xe8160204, 0x00000000}},  //   солу, _dius_, _देशा_,
  { {0x7cf80e04, 0x9713013a, 0x3ce201c3, 0x00000000}},  //   _víru, оміц, _hnkv_,
  { {0x4420001a, 0x95ca0e05, 0x394d0087, 0x00000000}},  //   _ţi_, тула_, _fhes_,
  { {0x395f0026, 0xc4480014, 0x00000000, 0x00000000}},  //   _gius_, هیان_,   ,
  { {0x6f1c010f, 0x248601ee, 0xdb040374, 0x00000000}},  //   kirc, _veom_, rtiæ,
  { {0x212900d9, 0x00000000, 0x00000000, 0x00000000}},  //   _sjah_,   ,   ,
  { {0x8ad90049, 0x98af0089, 0x0566007c, 0x00000000}},  //   אַרפ, logā_, _твен,
  { {0x23660006, 0x25be00e7, 0xd5fb0049, 0x00000000}},  //   _tuoj_, _iptl_, _שפאר,
  { {0x69da00d0, 0x65680e06, 0x853500a1, 0x00000000}},  //   _štel, _hudh, _اونچ,
  { {0x65680020, 0x31670026, 0x7d060e07, 0x00000000}},  //   _kudh, _funz_, _alks,
  { {0xe297012b, 0x31670e08, 0x3eba00e0, 0x00000000}},  //   _тај_, _gunz_, _dbpt_,
  { {0x6568033b, 0x00000000, 0x00000000, 0x00000000}},  //   _mudh,   ,   ,
  { {0x6738022e, 0x2d580e09, 0x395f0129, 0x00000000}},  // [1610] kovj, рить_, _rius_,
  { {0x394d0e0a, 0x21390065, 0x6f1c0133, 0x00000000}},  //   _shes_, losh_, circ,
  { {0x395f0e0b, 0x9c830087, 0xdb1d01e5, 0x00000000}},  //   _pius_, _ščuk, _orsö,
  { {0x80c50044, 0x21390023, 0x00000000, 0x00000000}},  //   ষাক্, nosh_,   ,
  { {0x395f00d4, 0x2d910036, 0x386400d9, 0x00000000}},  //   _vius_, lsze_, _dgmr_,
  { {0x16a9005e, 0x6128006b, 0x2ca9006c, 0x00000000}},  //   увки_, yılo, lgad_,
  { {0x21390065, 0x394d0b97, 0xa49300a1, 0x00000000}},  //   kosh_, _thes_, قیات,
  { {0x2ca90013, 0x65680022, 0x7af50e0c, 0x00000000}},  //   ngad_, _dudh, _hozt,
  { {0x291d000b, 0x67380e0d, 0x21390023, 0x00000000}},  //   miwa_, bovj, dosh_,
  { {0x291d000b, 0xddde0428, 0xdb040e0e, 0x00000000}},  //   liwa_, _lepš, rtiç,
  { {0xdb0402d5, 0x7af50347, 0x2d910036, 0x00000000}},  //   stiç, _mozt, jsze_,
  { {0x291d0020, 0x21390023, 0x14ca0014, 0x00000000}},  //   niwa_, gosh_, _مهمی_,
  { {0xc50c0049, 0x9fd60044, 0xb05b00b0, 0x00000000}},  //   _בלאָ, সঙ্গ, seän,
  { {0x6568023a, 0x644b0e0f, 0x291d0020, 0x00000000}},  //   _yudh, _izgi, hiwa_,
  { {0x291d000b, 0x6b500073, 0xf2d20049, 0x00000000}},  //   kiwa_, lägg, _מעג_,
  { {0x3c66008b, 0x291d0e10, 0x2ca90039, 0x00000000}},  //   скаг, jiwa_, ggad_,
  { {0x6128047f, 0x291d0020, 0x6f1c0e11, 0x00000000}},  // [1620] nılm, diwa_, pirc,
  { {0xbcfb009d, 0x60c60010, 0x00000000, 0x00000000}},  //   _piéc, lekm,   ,
  { {0x8db60088, 0x291d0020, 0x7c2f0835, 0x00000000}},  //   _успі, fiwa_, _excr,
  { {0x6128014a, 0x291d0020, 0xc9850025, 0x00000000}},  //   kılm, giwa_, تشكي,
  { {0xc7a302a8, 0x31b10010, 0x65680e12, 0x00000000}},  //   зичк, ház_, _sudh,
  { {0x6128005f, 0x6d4402f1, 0x09e60265, 0x00000000}},  //   dılm, llia, _логн,
  { {0x6d44018e, 0x291d0020, 0x690700c4, 0x00000000}},  //   olia, biwa_, órdã,
  { {0x69dc049a, 0x6d440051, 0x53980ae0, 0x00000000}},  //   _irre, nlia, авия_,
  { {0x2d850211, 0x6738016e, 0xe8df0011, 0x00000000}},  //   ález_, povj, _nhộn_,
  { {0x6d440027, 0x91b800e2, 0x65680232, 0x00000000}},  //   hlia, агот_, _tudh,
  { {0xe3af089d, 0x6d440e13, 0x21390065, 0x00000000}},  //   وری_, klia, tosh_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x2d910046, 0x6d440e14, 0x21390065, 0x00000000}},  //   wsze_, dlia, rosh_,
  { {0x291d0e15, 0x69dc002d, 0x21390065, 0x00000000}},  //   ziwa_, _orre, sosh_,
  { {0x8cda0061, 0x7af5067f, 0x2d850e16, 0x00000000}},  //   _पोहो, _rozt, èle_,
  { {0x6d440198, 0x2d910e17, 0x91e3003b, 0x00000000}},  //   glia, rsze_, _хоће,
  { {0x69ce002b, 0x2ca90dac, 0x7af5002d, 0x00000000}},  // [1630] _asbe, rgad_, _pozt,
  { {0x2d910036, 0x6d440e18, 0xaa67007e, 0x00000000}},  //   psze_, alia, стак,
  { {0x291d000b, 0x6128005d, 0x7d03001a, 0x00000000}},  //   tiwa_, zılm, _înso,
  { {0x61280279, 0x628a0010, 0xdcfc0089, 0x00000000}},  //   yılm, _lefo, rurģ,
  { {0x69dc0756, 0x62980027, 0x291d0e19, 0x00000000}},  //   _erre, _odvo, riwa_,
  { {0x7d0d0047, 0x291d0e1a, 0xdb0d0051, 0x00000000}},  //   lhas, siwa_, otaí,
  { {0x24e90265, 0x65620061, 0xceb4019b, 0x00000000}},  //   имки_, _bioh, פיק_,
  { {0x6128005a, 0x7d0d00b0, 0x62980335, 0x00000000}},  //   tılm, nhas, _advo,
  { {0x628a0038, 0x13090e1b, 0xd6ab0439, 0x00000000}},  //   _befo, иний_, _مدام_,
  { {0x6128038c, 0xe299025f, 0x42250b11, 0x00000000}},  //   rılm, јан_, ждов,
  { {0x26c70e1c, 0x90c60604, 0x6d440016, 0x00000000}},  //   meno_, обне, ylia,
  { {0xf992019b, 0x7bcf0e1d, 0x61280676, 0x00000000}},  //   ורט_, _oscu, pılm,
  { {0x6b500a5d, 0x7529000d, 0x60c6014a, 0x00000000}},  //   läge, mnez, rekm,
  { {0x26c7000b, 0x6d44018e, 0x753b01aa, 0x00000000}},  //   neno_, wlia, louz,
  { {0x62810e1e, 0x7bcf000d, 0x7529031a, 0x00000000}},  //   mblo, _ascu, onez,
  { {0x62810007, 0x6d440e1f, 0x26c70e20, 0x00000000}},  //   lblo, ulia, heno_,
  { {0x8c43004d, 0x26c704a5, 0x6d560048, 0x00000000}},  // [1640] дете, keno_, rmya,
  { {0x26c7089f, 0xb0aa001c, 0x00000000, 0x00000000}},  //   jeno_, _काँग,   ,
  { {0x26c70c76, 0x7bcf0219, 0x7d0d0e21, 0x00000000}},  //   deno_, _escu, bhas,
  { {0x7d0d0e22, 0x31ba007b, 0xdb040051, 0x00000000}},  //   chas, יזענ, ntiú,
  { {0x765f005f, 0x75290173, 0x628100f8, 0x00000000}},  //   əyyə, dnez, kblo,
  { {0x6281037e, 0x26c70555, 0x7d04021e, 0x00000000}},  //   jblo, geno_, lkis,
  { {0xb0aa03d7, 0x69dc0ab3, 0x69ce010e, 0x00000000}},  //   _कांग, _urre, _usbe,
  { {0x7d040e23, 0x75290010, 0x62810e24, 0x00000000}},  //   nkis, gnez, eblo,
  { {0x628a000a, 0x3946010f, 0x26c70e25, 0x00000000}},  //   _pefo, mlos_, beno_,
  { {0x39460845, 0x26c70e26, 0x20d70082, 0x00000000}},  //   llos_, ceno_, _ủi_,
  { {0x753b013e, 0xdb04004a, 0xb5ca0014, 0x00000000}},  //   bouz, guié, _خوام_,
  { {0x3946001f, 0x657a0010, 0x00000000, 0x00000000}},  //   nlos_, _itth,   ,
  { {0x3946008e, 0x628100f8, 0x00000000, 0x00000000}},  //   ilos_, bblo,   ,
  { {0x62810e27, 0xdb040e28, 0xf1a6003b, 0x00000000}},  //   cblo, quiè, _дрин,
  { {0x7d0d0e29, 0xf27b00b6, 0x3946010a, 0x00000000}},  //   thas, _דרוש, klos_,
  { {0xdb04002a, 0x26c700b9, 0x7d040e2a, 0x00000000}},  //   ctiú, zeno_, gkis,
  { {0x7d0d04fa, 0xdb0d0051, 0x00000000, 0x00000000}},  // [1650] rhas, staí,   ,
  { {0x7d0d06d0, 0x657a0047, 0x3946008e, 0x00000000}},  //   shas, _otth, elos_,
  { {0xceb20097, 0x7d0d00ab, 0x753b00e7, 0x00000000}},  //   _איי_, phas, youz,
  { {0x7d040c43, 0x39460211, 0x6b500e2b, 0x00000000}},  //   ckis, glos_, väge,
  { {0x7bdd0de1, 0x60dc007b, 0x26c70059, 0x00000000}},  //   _ursu, יקאנ, teno_,
  { {0x62810030, 0xff7c01ce, 0x3946004a, 0x00000000}},  //   xblo, סטומ, alos_,
  { {0x80ac001c, 0x39460211, 0x26c70091, 0x00000000}},  //   _झाले, blos_, reno_,
  { {0x61360047, 0x39460325, 0x6b50010f, 0x00000000}},  //   bály, clos_, räge,
  { {0x628100eb, 0x6b500210, 0x75290035, 0x00000000}},  //   tblo, säge, rnez,
  { {0x13090783, 0x753b00b9, 0x00000000, 0x00000000}},  //   сной_, souz,   ,
  { {0x62810039, 0x7d040193, 0x753b049c, 0x00000000}},  //   rblo, ykis, pouz,
  { {0x62810af1, 0xbcfb02a0, 0x00000000, 0x00000000}},  //   sblo, _sién,   ,
  { {0x4aac0061, 0xb4d7007d, 0x628106ba, 0x00000000}},  //   _चालव, ायी_, pblo,
  { {0x3f9e0161, 0x63a900e7, 0x3ebe000c, 0x00000000}},  //   čtu_, muen, ýtt_,
  { {0x7d040e2c, 0xdb04009d, 0xbcfb004a, 0x00000000}},  //   tkis, quié, _vién,
  { {0x2571009f, 0x41b20025, 0xa01b000c, 0x00000000}},  //   _mál_, _أمير, mbön,
  { {0x7d040e2d, 0xfbdf00c4, 0x63a90e2e, 0x00000000}},  // [1660] rkis, _crê_, nuen,
  { {0x7d040263, 0xa3dc0309, 0x6ea800a1, 0x00000000}},  //   skis, डित_, _بندہ_,
  { {0x9d4600ed, 0x60d6014a, 0x63a9004a, 0x00000000}},  //   _неод, _kaym, huen,
  { {0x63a90e2f, 0x7ae70065, 0x61360010, 0x00000000}},  //   kuen, _enjt, tály,
  { {0x39460977, 0xe81603d7, 0x2efa010f, 0x00000000}},  //   rlos_, _देखा_, _kopf_,
  { {0x61360010, 0x394601a2, 0x4e7a0049, 0x00000000}},  //   rály, slos_, זאַצ,
  { {0x39460e30, 0x00000000, 0x00000000, 0x00000000}},  //   plos_,   ,   ,
  { {0x399b00b6, 0x257100b9, 0xd3a60088, 0x00000000}},  //   _לילד, _dál_, проп,
  { {0x63a90198, 0x07a300ed, 0x00000000, 0x00000000}},  //   guen, _патн,   ,
  { {0xa3ab013d, 0x877b00a3, 0x957c0036, 0x00000000}},  //   गढ़_, _לאמי, _prąd,
  { {0x29060e31, 0xbcfb009d, 0x00000000, 0x00000000}},  //   okoa_, _biél,   ,
  { {0x63a90e32, 0x29060e33, 0x644e006b, 0x00000000}},  //   buen, nkoa_, əbin,
  { {0x63a90219, 0x5f940265, 0xe8df0082, 0x00000000}},  //   cuen, ният, _nhờn_,
  { {0x7d1d00d9, 0x00000000, 0x00000000, 0x00000000}},  //   _smss,   ,   ,
  { {0xb2bb009b, 0x290600b0, 0x2d9e0091, 0x00000000}},  //   _המור, kkoa_, šten_,
  { {0x614406e3, 0x60d60203, 0x9d1801ee, 0x00000000}},  //   _пеја, _gaym, пост_,
  { {0xa3d503d7, 0xe8df0082, 0x00000000, 0x00000000}},  // [1670] हिए_, _chờn_,   ,
  { {0xc87900e5, 0x00000000, 0x00000000, 0x00000000}},  //   _inşi_,   ,   ,
  { {0x63a9002d, 0x30a600a1, 0x5d550745, 0x00000000}},  //   zuen, _علیہ, _окот,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xdb1601aa, 0x25710e34, 0x63a90032, 0x00000000}},  //   ktyè, _sál_, xuen,
  { {0x8579007c, 0x25710e35, 0x00000000, 0x00000000}},  //   осит_, _pál_,   ,
  { {0x69da01d9, 0x20020036, 0xd6ce0439, 0x00000000}},  //   _štev, zyki_, شقي_,
  { {0x63a9022b, 0xb4d700e8, 0x6b4b010f, 0x00000000}},  //   tuen, ाये_, zügl,
  { {0x68e90412, 0x2be0006e, 0x29070e36, 0x00000000}},  //   _ined, निया, ūnas_,
  { {0x68fb02ae, 0x63a9002d, 0x60d60279, 0x00000000}},  //   _houd, ruen, _saym,
  { {0xa0a6008b, 0x6723016c, 0x68fb0e37, 0x00000000}},  //   манд, minj, _koud,
  { {0x67230e38, 0x20020036, 0x68fb0b60, 0x00000000}},  //   linj, tyki_, _joud,
  { {0x68fb013e, 0x21220127, 0xe2990069, 0x00000000}},  //   _moud, rikh_, _дал_,
  { {0x2906022b, 0x672304be, 0x7f19007e, 0x00000000}},  //   zkoa_, ninj, пісу_,
  { {0xa3d5007d, 0x6e4301fc, 0xdd1c0161, 0x00000000}},  //   हिक_, верз, _vážn,
  { {0x672300ee, 0xdb0d010f, 0x68fb0158, 0x00000000}},  //   hinj, traß, _noud,
  { {0x67230295, 0xab66007e, 0x6f1e0009, 0x00000000}},  // [1680] kinj, двал, _tmpc,
  { {0x290d04f8, 0x68e9005b, 0x68fb01f3, 0x00000000}},  //   _alea_, _aned, _aoud,
  { {0x672300ee, 0x68fb0e39, 0x6b960190, 0x00000000}},  //   dinj, _boud, ssyg,
  { {0xc7c60072, 0x66030036, 0x68fb009d, 0x00000000}},  //   дски, dynk, _coud,
  { {0x4c36008b, 0x68fb009d, 0x29060d17, 0x00000000}},  //   _цэнт, _doud, rkoa_,
  { {0x29060e3a, 0x67230e3b, 0x68e9005b, 0x00000000}},  //   skoa_, ginj, _ened,
  { {0x68fb009d, 0x290d0133, 0x7afc0288, 0x00000000}},  //   _foud, _flea_, _iort,
  { {0x7afc002d, 0x25a00e3c, 0x68fb00b5, 0x00000000}},  //   _hort, čil_, _goud,
  { {0x644e0036, 0x672304eb, 0x06bd0044, 0x00000000}},  //   ębio, binj, _আফরি,
  { {0x6723037e, 0x68fb00b5, 0x291f012d, 0x00000000}},  //   cinj, _zoud, _zmua_,
  { {0x36060076, 0x2d9e00b9, 0x66e30143, 0x00000000}},  //   _تواف, átel_, _јоха,
  { {0x7afc022b, 0x849600a1, 0xd1310379, 0x00000000}},  //   _lort, _آجائ, امح_,
  { {0x7afc0007, 0x2d9e0e3d, 0x00000000, 0x00000000}},  //   _oort, štel_,   ,
  { {0x7afc0e3e, 0x00000000, 0x00000000, 0x00000000}},  //   _nort,   ,   ,
  { {0xa3d6007d, 0x7bc60e3f, 0x64550036, 0x00000000}},  //   ाटक_, _apku, ęzie,
  { {0x7afc0e40, 0x506700aa, 0x6ca40081, 0x00000000}},  //   _aort, _отпа, круж,
  { {0xdb0d02d5, 0x3b5500e3, 0x68fb013e, 0x00000000}},  // [1690] ntaç, екар, _roud,
  { {0x7afc08d3, 0x68fb00b9, 0x68e9032e, 0x00000000}},  //   _cort, _soud, _sned,
  { {0x67230925, 0x68fb0e41, 0x7afc0e42, 0x00000000}},  //   vinj, _poud, _dort,
  { {0x2d8300bb, 0x3835041f, 0x00000000, 0x00000000}},  //   mpje_, ннер,   ,
  { {0x7afc004e, 0x67230119, 0x68fb00f4, 0x00000000}},  //   _fort, tinj, _voud,
  { {0xe73306dd, 0x7afc0add, 0x68fb0328, 0x00000000}},  //   خصص_, _gort, _woud,
  { {0xe81f03d7, 0x67230059, 0x23670065, 0x00000000}},  //   _मेरा_, rinj, _rinj_,
  { {0x6723002b, 0x67d50088, 0x68e90016, 0x00000000}},  //   sinj, _побу, _uned,
  { {0x3735007e, 0x386d0e43, 0x75d3006b, 0x00000000}},  //   _знаё, _iger_, _məzə,
  { {0xcb12007b, 0xfbd2009b, 0x7afc002b, 0x00000000}},  //   ָלט_, נתי_, _xort,
  { {0x76480e44, 0x0322008b, 0xe1260088, 0x00000000}},  //   _gydy, удэн, емни,
  { {0x75d3005f, 0x70aa0061, 0xab5b01a2, 0x00000000}},  //   _nəzə, कलेल, _spül,
  { {0x3169008e, 0x13f4005e, 0x2d8300bb, 0x00000000}},  //   _diaz_, _изця, epje_,
  { {0x63bb0020, 0x2d9e0e45, 0x61ee0048, 0x00000000}},  //   mtun, štem_, óilí,
  { {0x63bb001f, 0x2f140073, 0x2d8c00f4, 0x00000000}},  //   ltun, _lägg_, ède_,
  { {0x7afc0e46, 0xc5f20049, 0x00000000, 0x00000000}},  //   _sort, נדן_,   ,
  { {0x63bb020c, 0x60c40009, 0xe81f007d, 0x00000000}},  // [16a0] ntun, _ibim, _मेला_,
  { {0x63bb001f, 0x7afc0226, 0x4e1c0044, 0x00000000}},  //   itun, _qort, _দুঃখ_,
  { {0x7afc04b2, 0x63bb0e47, 0xfbdf0011, 0x00000000}},  //   _vort, htun, _uyên_,
  { {0x7648018e, 0x63bb0e48, 0x7afc01ac, 0x00000000}},  //   _rydy, ktun, _wort,
  { {0x6d460ab5, 0x69d50e49, 0x7afc0e4a, 0x00000000}},  //   _ikka, _esze, _tort,
  { {0x6b840e4b, 0x63bb0e4c, 0x98c50089, 0x00000000}},  //   mpig, dtun, ītās_,
  { {0x60c40107, 0xceb30049, 0x63bb0e4d, 0x00000000}},  //   _obim, טיג_, etun,
  { {0x75d3005f, 0x63bb010f, 0x6721012d, 0x00000000}},  //   _xəzə, ftun, _emlj,
  { {0xd4e30057, 0x63bb00e0, 0xdb04009d, 0x00000000}},  //   ующи, gtun, triè,
  { {0x60c40e4e, 0xdb0d0e4f, 0x0bb7009b, 0x00000000}},  //   _abim, rtaç, עלים_,
  { {0x6d46009f, 0xdb0400f4, 0xdb0d0181, 0x00000000}},  //   _okka, rriè, staç,
  { {0xdb0d0181, 0x26ce000a, 0x6d460e50, 0x00000000}},  //   ptaç, lefo_, _nkka,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x545301fb, 0x6d460e51, 0x320501dc, 0x00000000}},  //   _світ, _akka, byly_,
  { {0x720300a1, 0x7c87003b, 0xac950aed, 0x00000000}},  //   _مووم, еузе, кавш,
  { {0x75d3006b, 0x38690e3b, 0xdb0f013f, 0x00000000}},  //   _qəzə, žari_, şdür,
  { {0x69c70e52, 0x8aa7041f, 0xfaa70242, 0x00000000}},  // [16b0] _spje, еред, ешен,
  { {0x60dd08e0, 0x6d46020b, 0x2fc90058, 0x00000000}},  //   ldsm, _ekka, _ipag_,
  { {0xf9930d3a, 0x7dc40752, 0x63bb028d, 0x00000000}},  //   ابط_, _یقین, ztun,
  { {0x60dd000c, 0x2d810051, 0x63bb0016, 0x00000000}},  //   ndsm, _ithe_, ytun,
  { {0xb8c903d7, 0x69d50046, 0x60dd0112, 0x00000000}},  //   _गए_, _wsze, idsm,
  { {0x6d4d021e, 0x2f1400f8, 0x00000000, 0x00000000}},  //   llaa, _vägg_,   ,
  { {0xa3b30061, 0x6d46000c, 0x98c7003b, 0x00000000}},  //   जून_, _ykka, _псал,
  { {0x63bb0e53, 0x386d0030, 0x60dd0030, 0x00000000}},  //   ttun, _uger_, jdsm,
  { {0x63bb00b0, 0x7d03001a, 0x7c290e54, 0x00000000}},  //   utun, _însu, _žerj,
  { {0x63bb03a1, 0x613d0047, 0x75220e55, 0x00000000}},  //   rtun, mély, _emoz,
  { {0x6d4d0004, 0x3f80000d, 0x6b840032, 0x00000000}},  //   klaa, _stiu_, zpig,
  { {0xbcfb00c4, 0xdb040068, 0x00000000, 0x00000000}},  //   _fiéi, rrié,   ,
  { {0x889a009b, 0x2f140039, 0x6b8400ea, 0x00000000}},  //   וברי, _läge_, xpig,
  { {0x656b0038, 0xdb0400f4, 0x4ed50147, 0x00000000}},  //   _high, prié, люст,
  { {0x644b0387, 0x00000000, 0x00000000, 0x00000000}},  //   _hygi,   ,   ,
  { {0x63a90197, 0x6d4d011c, 0x657c0010, 0x00000000}},  //   oren, glaa, _érhe,
  { {0x656b0038, 0x63a90232, 0xeb9702b3, 0x00000000}},  // [16c0] _migh, nren, кит_,
  { {0x656b0038, 0x613d0010, 0x63a90dc0, 0x00000000}},  //   _ligh, dély, iren,
  { {0x63a9001f, 0x644b010a, 0x6d4d00c7, 0x00000000}},  //   hren, _lygi, blaa,
  { {0x656b0038, 0x63a90091, 0xdcfc0089, 0x00000000}},  //   _nigh, kren, bprā,
  { {0x63a90190, 0x68430e56, 0x6d440e57, 0x00000000}},  //   jren, анца, moia,
  { {0x63a90142, 0x656b0051, 0xd09a006b, 0x00000000}},  //   dren, _aigh, rçək,
  { {0xdb040841, 0x656b0058, 0x63a90125, 0x00000000}},  //   stió, _bigh, eren,
  { {0x63a90bf7, 0x6d44065d, 0x00000000, 0x00000000}},  //   fren, noia,   ,
  { {0x63a90e58, 0x656b0026, 0xdce6016c, 0x00000000}},  //   gren, _digh, _nikč,
  { {0x86ea0025, 0x656b00ab, 0x14ae0061, 0x00000000}},  //   _تعرف_, _eigh, _टाकण,
  { {0x63a9002d, 0x656b00ab, 0x2fc90066, 0x00000000}},  //   aren, _figh, _spag_,
  { {0x63a9011c, 0x94260057, 0x6913014a, 0x00000000}},  //   bren, _имее, _içec,
  { {0x60dd01c9, 0x6d440e57, 0x63a90e59, 0x00000000}},  //   rdsm, doia, cren,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7e280822, 0x6d4d0e5a, 0xb0ac006b, 0x00000000}},  //   віта_, tlaa, _şüşə,
  { {0xe7f3001c, 0x6d440032, 0x7d160016, 0x00000000}},  //   _आपला_, goia, ghys,
  { {0xdc5501f9, 0x6d4d00c7, 0xfbd00025, 0x00000000}},  // [16d0] увањ, rlaa, يتك_,
  { {0x6d4d01b5, 0x200401a2, 0x00000000, 0x00000000}},  //   slaa, ämie_,   ,
  { {0x6d4d0e5b, 0x63a90e5c, 0x6d440982, 0x00000000}},  //   plaa, zren, boia,
  { {0x63a9060a, 0xe0df0e5d, 0x6d4400f6, 0x00000000}},  //   yren, ndò_, coia,
  { {0x656b0866, 0x499300a1, 0xfd5601ce, 0x00000000}},  //   _righ, _چیئر, _תשרי_,
  { {0x7d0d0dcd, 0x63a90e5e, 0x656b0e5f, 0x00000000}},  //   lkas, vren, _sigh,
  { {0xdb040285, 0x656b0058, 0x63a9086a, 0x00000000}},  //   quiá, _pigh, wren,
  { {0x7d0d03fb, 0x25780010, 0x00000000, 0x00000000}},  //   nkas, _dél_,   ,
  { {0x63a90685, 0x7d0d00b0, 0x3835007c, 0x00000000}},  //   uren, ikas, _снар,
  { {0xe1f90057, 0x63a90e60, 0x25780010, 0x00000000}},  //   его_, rren, _fél_,
  { {0x7d0d003c, 0x656b00ab, 0x63a90e61, 0x00000000}},  //   kkas, _tigh, sren,
  { {0x6455005f, 0x7fb6007e, 0x7d0d0340, 0x00000000}},  //   əzin, лёгі, jkas,
  { {0x03a5013b, 0x7d0d006b, 0x6d440035, 0x00000000}},  //   _сило, dkas, voia,
  { {0xfd650082, 0x00000000, 0x00000000, 0x00000000}},  //   _truồ,   ,   ,
  { {0xc0e6005e, 0xdd1d00b9, 0xdb0400c4, 0x00000000}},  //   _бойк, lářs, luiç,
  { {0x7d0d0e62, 0xd24e0025, 0x75290035, 0x00000000}},  //   gkas, _عني_, niez,
  { {0x6eac013d, 0xdd1d00b9, 0xdb0400c4, 0x00000000}},  // [16e0] _जयपु, nářs, nuiç,
  { {0x7d0d00b0, 0x945d0036, 0x8a3a007c, 0x00000000}},  //   akas, leńs, няет_,
  { {0x8886005e, 0x7d160e63, 0x6d440e64, 0x00000000}},  //   глеж, phys, poia,
  { {0x7d0d04eb, 0x7aeb0089, 0xdb040e65, 0x00000000}},  //   ckas, ēgta, rtiñ,
  { {0xa3d20754, 0xdb04049a, 0x6ac90055, 0x00000000}},  //   _हैं_, stiñ, রয়ো,
  { {0xdd1d00b9, 0x3ce0010e, 0x00000000, 0x00000000}},  //   dářs, ldiv_,   ,
  { {0x645d009f, 0xceb300b6, 0xe5c602b8, 0x00000000}},  //   ýsin, ציה_, усло,
  { {0x7529002d, 0x3ce00b1b, 0x2578000c, 0x00000000}},  //   giez, ndiv_, _vél_,
  { {0x46b601fa, 0xdb0400c4, 0x28dd006e, 0x00000000}},  //   _محاس, guiç, _नोटि,
  { {0x39460a2a, 0x257800f4, 0x9bbb0049, 0x00000000}},  //   loos_, _tél_, עציפ,
  { {0xaac602f4, 0xd2500014, 0x80de0055, 0x00000000}},  //   र्यक, تند_, যান্,
  { {0xdb040181, 0x75290e66, 0x26de004a, 0x00000000}},  //   buiç, ciez, _hato_,
  { {0x7d0d0030, 0x26de0052, 0xa3b3013d, 0x00000000}},  //   vkas, _kato_, जूद_,
  { {0x26de00c4, 0x1ee70014, 0x3dda01a2, 0x00000000}},  //   _jato_, دوسی_, _bspw_,
  { {0xc27b007b, 0x26de0181, 0x7d0d0e67, 0x00000000}},  //   _ארוי, _mato_, tkas,
  { {0xf1a903d7, 0x26de0e68, 0x629a0e69, 0x00000000}},  //   _कितन, _lato_, lato,
  { {0x7d0d021e, 0x39460112, 0x212b0253, 0x00000000}},  // [16f0] rkas, doos_, mich_,
  { {0x629a000d, 0x212b001f, 0x26de070c, 0x00000000}},  //   nato, lich_, _nato_,
  { {0x987509e6, 0x00000000, 0x00000000, 0x00000000}},  //   алец,   ,   ,
  { {0x629a0e49, 0xaa6401ee, 0x00000000, 0x00000000}},  //   hato, стук,   ,
  { {0x26de0e6a, 0xbcfb0e6b, 0xab5b00f6, 0x00000000}},  //   _bato_, _diét, _aqüe,
  { {0x7ceb0073, 0x945d0036, 0x16a60407, 0x00000000}},  //   _förä, zeńs, авши_,
  { {0x212b0046, 0x629a0e6c, 0x2d9e0059, 0x00000000}},  //   kich_, dato, štev_,
  { {0x212b004f, 0xdb0402d5, 0x81cd0044, 0x00000000}},  //   jich_, tuiç, রিম_,
  { {0x26de0181, 0x80de0044, 0x629a00c4, 0x00000000}},  //   _fato_, যাম্, fato,
  { {0xa1c5008b, 0x26de0325, 0x1309007c, 0x00000000}},  //   абод, _gato_, тной_,
  { {0xcb1400b6, 0x75290211, 0x212b0e6d, 0x00000000}},  //   מלץ_, piez, fich_,
  { {0x75ca005f, 0x95670265, 0x26de01d9, 0x00000000}},  //   _qəze, _създ, _zato_,
  { {0x248d0181, 0x5edf0044, 0x2fdb01f3, 0x00000000}},  //   mbem_, মানে, _csqg_,
  { {0xb05b09b0, 0x629a0e6e, 0x6d5d00e7, 0x00000000}},  //   pfän, cato, _ahsa,
  { {0x212b0173, 0x78bb0107, 0xb05b0788, 0x00000000}},  //   bich_, _ocuv, lfäl,
  { {0x212b0e6f, 0x4fea00e2, 0x00000000, 0x00000000}},  //   cich_, _амин_,   ,
  { {0x998d0091, 0x8b260147, 0x3ce00e70, 0x00000000}},  // [1700] _ćeš_, адае, rdiv_,
  { {0x6d5d0e71, 0xfaa6091b, 0xdb0400b0, 0x00000000}},  //   _ehsa, ражо, htiö,
  { {0x26de0e72, 0xa2bd007d, 0xbcfb009d, 0x00000000}},  //   _rato_, _शान्, _piét,
  { {0x629a0e73, 0x497305b8, 0xbcfb004a, 0x00000000}},  //   zato, іліс, _diés,
  { {0xa81a01fa, 0x26de094f, 0x39460b1a, 0x00000000}},  //   ختار_, _pato_, roos_,
  { {0x212b00bb, 0xc9860014, 0x38af014a, 0x00000000}},  //   zich_, _نشري, törü_,
  { {0x629a0010, 0x80d70061, 0x26de0087, 0x00000000}},  //   vato, _बसले, _vato_,
  { {0x629a0e74, 0xd9430e75, 0x69dc007f, 0x00000000}},  //   wato, _деси, _isre,
  { {0x26de01c8, 0x5397008b, 0x672a0023, 0x00000000}},  //   _tato_, авыя_, pifj,
  { {0x68e00016, 0x29040020, 0x68e20168, 0x00000000}},  //   _hamd, _homa_, ldod,
  { {0xbcfb0e76, 0x2904009f, 0x212b0142, 0x00000000}},  //   _miér, _koma_, tich_,
  { {0x629a001a, 0x68e20065, 0x29040089, 0x00000000}},  //   sato, ndod, _joma_,
  { {0x629a0e77, 0x212b010f, 0x2f140073, 0x00000000}},  //   pato, rich_, _säga_,
  { {0x69dc0059, 0x290402c8, 0x69ce0e78, 0x00000000}},  //   _osre, _loma_, _opbe,
  { {0x2d8501b5, 0x4d2700ed, 0x7095005e, 0x00000000}},  //   ële_, аќаа, _лайф,
  { {0x2f140004, 0x5c750a27, 0x29040e79, 0x00000000}},  //   _väga_, слат, _noma_,
  { {0x68e2018e, 0x645c006b, 0x5ecc0044, 0x00000000}},  // [1710] ddod, əric, ায়ে,
  { {0xf1da03d7, 0x62980e7a, 0xa3d70061, 0x00000000}},  //   _बनान, _jevo, ाबत_,
  { {0xceb20049, 0xf8750025, 0x29040e7b, 0x00000000}},  //   _ציט_, مهاج, _boma_,
  { {0x29040b32, 0xc879027d, 0x68e00016, 0x00000000}},  //   _coma_, _başa_, _camd,
  { {0x27e90e7c, 0x29040b41, 0x68e0011c, 0x00000000}},  //   ían_, _doma_, _damd,
  { {0x62980e7d, 0x7bdd0038, 0x81cd0055, 0x00000000}},  //   _nevo, _issu, রিত_,
  { {0x63a20e7e, 0xe7f303d7, 0x2904012d, 0x00000000}},  //   _avon, _आपका_, _foma_,
  { {0xce38019b, 0x29040e7f, 0x25a90e80, 0x00000000}},  //   יאות_, _goma_, čal_,
  { {0x62980125, 0xa3d2006e, 0x00000000, 0x00000000}},  //   _bevo, हौल_,   ,
  { {0xf7700054, 0xc2e9026c, 0xb05b09b0, 0x00000000}},  //   _قال_, اعظم_, rfäl,
  { {0x7c3b009f, 0x62980e81, 0x41b40152, 0x00000000}},  //   _þurf, _devo, осят,
  { {0x628e000c, 0x80fa00e2, 0xc879019a, 0x00000000}},  //   ðbor, ухот_, _yaşa_,
  { {0xe28e0113, 0x43850054, 0x63850e82, 0x00000000}},  //   _на_, _التق, _угла,
  { {0x6298049b, 0xe7fa0061, 0x00000000, 0x00000000}},  //   _gevo, ्हता_,   ,
  { {0x63a20e83, 0x7bdd0e84, 0xa3b30309, 0x00000000}},  //   _zvon, _assu, जूर_,
  { {0x31a301f6, 0x62810adb, 0x61430e85, 0x00000000}},  //   mız_, lclo, _неща,
  { {0x29040198, 0xed5701f9, 0x68e0011c, 0x00000000}},  // [1720] _roma_, сот_, _ramd,
  { {0x628100d4, 0x29040020, 0x68e00e86, 0x00000000}},  //   nclo, _soma_, _samd,
  { {0x31a30676, 0x290400d4, 0xe0df0129, 0x00000000}},  //   nız_, _poma_, clòs_,
  { {0x75ca005f, 0x61fc03a2, 0x68e201ee, 0x00000000}},  //   _nəza, ärli, udod,
  { {0xe1e7089d, 0x68e20e87, 0x765a00b4, 0x00000000}},  //   _کس_, rdod, _szty,
  { {0x29040061, 0x27e60cba, 0x612f0173, 0x00000000}},  //   _woma_, rvon_, _kòlè,
  { {0x63a2009f, 0x6d41009f, 0x7bc406c2, 0x00000000}},  //   _svon, élag, ltiu,
  { {0x75ca006b, 0x7d060e88, 0x7644014a, 0x00000000}},  //   _cəza, _joks, şiyo,
  { {0x7d06010a, 0x5edf0044, 0x97bd0245, 0x00000000}},  //   _moks, মাতে, _архi,
  { {0x62810e89, 0x7d06000c, 0x00000000, 0x00000000}},  //   gclo, _loks,   ,
  { {0x60f90cf2, 0x14ca0057, 0x8afb0097, 0x00000000}},  //   ання_, _были_, אליז,
  { {0x63a2023a, 0x7d060056, 0x05660e8a, 0x00000000}},  //   _tvon, _noks, _увен,
  { {0x321e0036, 0x62980112, 0x25710091, 0x00000000}},  //   szty_, _tevo, _ušla_,
  { {0x543b007b, 0x657a0020, 0x612f0173, 0x00000000}},  //   _געדא, _kuth, _bòlè,
  { {0x91860318, 0x7d060292, 0x98bd00b4, 0x00000000}},  //   _اجتم, _boks, lową_,
  { {0x657a0e8b, 0x5d5501ff, 0x212901a3, 0x00000000}},  //   _muth, ікат, _umah_,
  { {0x2d58004c, 0x60cd00c4, 0xba990088, 0x00000000}},  // [1730] сить_, _ibam, иває_,
  { {0x2dd50256, 0x657a0203, 0x3f8900fa, 0x00000000}},  //   _джор, _outh, _itau_,
  { {0x5edf0044, 0x7d06006b, 0xc27b0049, 0x00000000}},  //   মাদে, _foks, ארבי,
  { {0xfbd000a1, 0x7d060e8c, 0x7644014a, 0x00000000}},  //   بتہ_, _goks, ğiyl,
  { {0x657a08ef, 0x7bc40d8a, 0x2b9300e9, 0x00000000}},  //   _auth, ctiu, _ریاس,
  { {0x6b8d0e8d, 0x31a3005a, 0x657a01c3, 0x00000000}},  //   mpag, yız_, _buth,
  { {0x6b8d0e8e, 0x451901e0, 0x7d06014a, 0x00000000}},  //   lpag, иция_, _yoks,
  { {0x69c50016, 0x75ca006b, 0xb385012c, 0x00000000}},  //   mthe, _qəza, олил,
  { {0x69c50e8f, 0x6b8d00b5, 0x78a90e90, 0x00000000}},  //   lthe, npag, _idev,
  { {0x69c507eb, 0x6b8d0e91, 0x60cd0e92, 0x00000000}},  //   othe, ipag, _abam,
  { {0x3f890149, 0x657a0e93, 0x69c50aba, 0x00000000}},  //   _atau_, _guth, nthe,
  { {0xe56e01fb, 0x69c5002a, 0x27ed04be, 0x00000000}},  //   _із_, ithe, _kren_,
  { {0x31a3005d, 0xb05b01a2, 0x225c00d9, 0x00000000}},  //   sız_, nfäh, _ezvk_,
  { {0x6b8d0e94, 0x69c50065, 0x7d060010, 0x00000000}},  //   dpag, kthe, _soks,
  { {0xec9a06e3, 0x6b8d00bb, 0x78a90142, 0x00000000}},  //   итај_, epag, _odev,
  { {0xa01b06d3, 0x6b8d0009, 0x78a900e7, 0x00000000}},  //   rbör, fpag, _ndev,
  { {0xdee60a27, 0x7d0601e3, 0x6b8d0e95, 0x00000000}},  // [1740] _допи, _voks, gpag,
  { {0x7bc40e96, 0x78a9000d, 0xab5b010f, 0x00000000}},  //   rtiu, _adev, _spür,
  { {0x27ed0e97, 0xe9da0175, 0x7bc40e98, 0x00000000}},  //   _aren_, рке_, stiu,
  { {0x6b8d00b5, 0x27ed005b, 0x7c3b0bf8, 0x00000000}},  //   bpag, _bren_, _žure,
  { {0x2ca0006c, 0x6b8d0050, 0xc7a302dc, 0x00000000}},  //   maid_, cpag, дичк,
  { {0x657a0065, 0x6d560e99, 0xb86500a1, 0x00000000}},  //   _puth, llya, سانو,
  { {0xd5b00054, 0x27ed00f6, 0x69c503b3, 0x00000000}},  //   رفة_, _eren_, cthe,
  { {0x291d0d16, 0x2ca00ddc, 0x4ac6013d, 0x00000000}},  //   chwa_, naid_, र्रव,
  { {0x27ed0239, 0x2be00061, 0xdddc04eb, 0x00000000}},  //   _gren_, निटा, jbrž,
  { {0xbcfb0051, 0x657a0e9a, 0xb6cb00a1, 0x00000000}},  //   _mhéa, _tuth, _نامے_,
  { {0x3f89001a, 0x2ca0006c, 0x660300ed, 0x00000000}},  //   _stau_, kaid_, _опфа,
  { {0x645c0163, 0x2ca00004, 0x6b8d0e9b, 0x00000000}},  //   ərin, jaid_, ypag,
  { {0xb4b602d2, 0xdb0400c4, 0xb4d60309, 0x00000000}},  //   जली_, criç, ाजी_,
  { {0xf651026c, 0xa3d7006e, 0x764d006b, 0x00000000}},  //   _آئے_, ाबर_, şaye,
  { {0x6b8d0061, 0xf1c300b9, 0xdb0d009d, 0x00000000}},  //   wpag, _vaší_, fraî,
  { {0xbcfb0051, 0x6b8d0e9c, 0x2ca00016, 0x00000000}},  //   _bhéa, tpag, gaid_,
  { {0xbcfb002a, 0x0ca8005e, 0x6b8d0e9d, 0x00000000}},  // [1750] _chéa, ютри_, upag,
  { {0xbcfb0195, 0x6b8d0e8e, 0x81cd0044, 0x00000000}},  //   _dhéa, rpag, রির_,
  { {0x13d30055, 0x693c0142, 0xa2bd0309, 0x00000000}},  //   ়িয়, rčen, _शास्,
  { {0x2ca00e9e, 0xbcfb002a, 0xa2ca024c, 0x00000000}},  //   caid_, _fhéa, त्त्,
  { {0x6cfa009b, 0xbcfb0051, 0x27ed00fa, 0x00000000}},  //   _הפרס, _ghéa, _qren_,
  { {0x291d000b, 0x69c50e9f, 0x3946016c, 0x00000000}},  //   shwa_, pthe, čosa_,
  { {0x6ecd007d, 0xb05b010f, 0xa8a701ee, 0x00000000}},  //   द्यु, sfäh, _мрак,
  { {0xd4d901fb, 0xdb040181, 0x2e3c01ce, 0x00000000}},  //   ські_, triç, יגונ,
  { {0x249f0ea0, 0xe3b10025, 0x27ed00b5, 0x00000000}},  //   raum_, ررة_, _uren_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xdb0d0ea1, 0x06760049, 0x00000000, 0x00000000}},  //   ntañ, _זײער_,   ,
  { {0xdb0d0116, 0x00000000, 0x00000000, 0x00000000}},  //   kraï,   ,   ,
  { {0x2ca00004, 0x65690190, 0x2458007e, 0x00000000}},  //   vaid_, mmeh, _даць_,
  { {0xd34300a1, 0x656901a2, 0x2ca0005b, 0x00000000}},  //   _تفتی, lmeh, waid_,
  { {0xdb0d00f4, 0xbcfb0051, 0x12fa009b, 0x00000000}},  //   traî, _shéa, _להסב,
  { {0x753b0026, 0x3b86078d, 0x656901a2, 0x00000000}},  //   nnuz, злаг, nmeh,
  { {0x1d070ea2, 0x6d5600e0, 0x25dd013d, 0x00000000}},  // [1760] чети_, rlya, _कैसी_,
  { {0x2ca0006c, 0x7c3b0ea3, 0xdb1c0276, 0x00000000}},  //   said_, _žurc, _üzüm,
  { {0x2ca00ea4, 0x6d5600e0, 0x49ca00c0, 0x00000000}},  //   paid_, plya, слен_,
  { {0xbcfb0ea5, 0x203300a1, 0x00000000, 0x00000000}},  //   _théa, _آفیس,   ,
  { {0xdb040007, 0x24c30044, 0x80ce0061, 0x00000000}},  //   nsië, ্যাহ, ध्ये,
  { {0x65620065, 0xdbc7006c, 0x7d040c31, 0x00000000}},  //   _shoh, tööt, ljis,
  { {0xdb040039, 0x7c24001a, 0x9f4001d6, 0x00000000}},  //   rriä, lzir, _asië_,
  { {0x48e30216, 0xdce4037e, 0x7d040173, 0x00000000}},  //   _посв, kmič, njis,
  { {0xd9430a94, 0x7c240ea6, 0xa2bd01f5, 0x00000000}},  //   _чети, nzir, _शाश्,
  { {0x645c005f, 0x98bd0036, 0xdb0d000c, 0x00000000}},  //   əril, dowę_, ntað,
  { {0x8675008b, 0x65620022, 0x00000000, 0x00000000}},  //   _жыцц, _thoh,   ,
  { {0x2d57014a, 0x7aeb0089, 0x81cd0044, 0x00000000}},  //   rçek_, ēgti, রিং_,
  { {0x5064012b, 0x75ca006b, 0xdb0d0032, 0x00000000}},  //   етра, _məzm, ztañ,
  { {0x70770167, 0xdb0400fa, 0xf1a60140, 0x00000000}},  //   _کاغذ, ssiê, _ерин,
  { {0x97570104, 0x9f44013e, 0x78a20253, 0x00000000}},  //   פילו_, ímá_, kaov,
  { {0x7d04008d, 0x00000000, 0x00000000, 0x00000000}},  //   gjis,   ,   ,
  { {0xdb0d00c4, 0x6f010010, 0x00000000, 0x00000000}},  // [1770] nuaç, ölcs,   ,
  { {0x501c009b, 0x44240ea7, 0x00000000, 0x00000000}},  //   _לוחו, izm_,   ,
  { {0xceb2007b, 0xdb0400f4, 0x99d903d9, 0x00000000}},  //   _ביי_, isiè, تواء_,
  { {0x7c240107, 0x7d160c51, 0xa3ac0061, 0x00000000}},  //   bzir, ckys, गळा_,
  { {0xdb0d0ea8, 0x66e50088, 0xa8780025, 0x00000000}},  //   stañ, дола, أحمر_,
  { {0x8ae401fb, 0xdb0d0181, 0x3ea30ea9, 0x00000000}},  //   _післ, duaç, najt_,
  { {0xdb0d0051, 0xdce40e3d, 0x2d7800ca, 0x00000000}},  //   nraí, zmič, _hčer_,
  { {0xfdf8009b, 0x7ae70010, 0x3ce9006c, 0x00000000}},  //   לצות_, _hajt, ndav_,
  { {0x0477026c, 0x65690eaa, 0x7ae70059, 0x00000000}},  //   _ہلاک_, rmeh, _kajt,
  { {0x394f001e, 0x65690d2d, 0x81d60044, 0x00000000}},  //   logs_, smeh, সিন_,
  { {0x645c005f, 0x7ae70eab, 0xf748023c, 0x00000000}},  //   ərim, _majt, _علمي_,
  { {0xcea900b6, 0x7ae70023, 0x8fa60478, 0x00000000}},  //   _כי_, _lajt, маме,
  { {0xbcfb00f4, 0x00000000, 0x00000000, 0x00000000}},  //   _phén,   ,   ,
  { {0x7ae7016e, 0x69d500b5, 0x63bb0eac, 0x00000000}},  //   _najt, _opze, muun,
  { {0xdb0d002a, 0xc1060025, 0xdce4021c, 0x00000000}},  //   graí, _يوتي, smič,
  { {0x7c24002d, 0x2f14006c, 0x61fc00ea, 0x00000000}},  //   tzir, _mägi_, årle,
  { {0x394f0c0d, 0x3ce60027, 0x7d040279, 0x00000000}},  // [1780] dogs_, ľov_, rjis,
  { {0x7c240107, 0xd91000a6, 0xa2d30164, 0x00000000}},  //   rzir, گیر_, _बॉम्,
  { {0x7ae709fc, 0x6e4602e9, 0xdb0d0051, 0x00000000}},  //   _dajt, _ценз, craí,
  { {0xdb0d009f, 0x63bb0ead, 0xd9100167, 0x00000000}},  //   stað, kuun, دیر_,
  { {0x98a30680, 0x87da0b6c, 0x97da06b4, 0x00000000}},  //   тиче, تباس_, تظار_,
  { {0x66e3003b, 0x758a0152, 0x78a200fa, 0x00000000}},  //   воља, осив_, saov,
  { {0x60c40091, 0x693c0eae, 0x7d1d0045, 0x00000000}},  //   _ocim, nček, _ylss,
  { {0xdb0d0181, 0x38ca00a1, 0x7ae70134, 0x00000000}},  //   tuaç, _گاڑی_, _zajt,
  { {0x693c00b9, 0x33740eaf, 0x63bb0eb0, 0x00000000}},  //   yčej, нгир, guun,
  { {0x764d0279, 0x60c40181, 0x59d2006e, 0x00000000}},  //   şaya, _acim, _सहार,
  { {0xe1350eb1, 0x3ea3022e, 0xdb040ea5, 0x00000000}},  //   енны, vajt_, friú,
  { {0x26dc0207, 0x92be0044, 0xdb0400f4, 0x00000000}},  //   levo_, ঁজে_, ssiè,
  { {0xdb0d00c4, 0xc1780006, 0x78a00093, 0x00000000}},  //   quaç, tvės_, _memv,
  { {0xdb0d0eb2, 0x26dc0724, 0x78a00190, 0x00000000}},  //   traí, nevo_, _lemv,
  { {0x7ae70010, 0xdb040051, 0x628a0066, 0x00000000}},  //   _rajt, briú, _iffo,
  { {0x7ae70320, 0xa2ca0204, 0xdb0d0eb3, 0x00000000}},  //   _sajt, त्र्, rraí,
  { {0x7ae70065, 0x60dd0116, 0x3f67007c, 0x00000000}},  // [1790] _pajt, mesm, _отоб,
  { {0x26dc06a6, 0xbcfb0eb4, 0x60dd0181, 0x00000000}},  //   jevo_, _théo, lesm,
  { {0x26dc0eb5, 0x7ae70065, 0x79e700a1, 0x00000000}},  //   devo_, _vajt, بوضہ_,
  { {0x2561000c, 0x60dd0032, 0x25f4006e, 0x00000000}},  //   kóla_, nesm, ्मनी_,
  { {0x628a0eb6, 0x06e80044, 0x394f01c5, 0x00000000}},  //   _offo, পানি, rogs_,
  { {0x2d7800d0, 0x7c200095, 0x00000000, 0x00000000}},  //   _učer_, _ümra,   ,
  { {0x60dd098e, 0x2d810eb7, 0x63bb0045, 0x00000000}},  //   kesm, _juhe_, wuun,
  { {0xfba3007d, 0x3ea10eb8, 0x63bb0058, 0x00000000}},  //   _ओबाम, _leht_, tuun,
  { {0x2d8106be, 0xf77801f3, 0xa24700a1, 0x00000000}},  //   _luhe_, _fiħ_, ڈیشل_,
  { {0x26dc0eb9, 0x60c40eba, 0xa20502b8, 0x00000000}},  //   cevo_, _scim, епод,
  { {0x68fb0ebb, 0x63bb0103, 0x68e901a3, 0x00000000}},  //   _knud, suun, _kaed,
  { {0xaacf0201, 0x628a0549, 0x4acf0309, 0x00000000}},  //   स्तक, _effo, स्तव,
  { {0x7c3b0ebc, 0x653a0049, 0xdb040068, 0x00000000}},  //   _žurn, _צענד, ssié,
  { {0x63a9014a, 0xfd1f0026, 0x68e90240, 0x00000000}},  //   msen, _alì_, _laed,
  { {0x63a905b7, 0x52390049, 0x60dd0ebd, 0x00000000}},  //   lsen, _מײַנ, besm,
  { {0xfce3005c, 0x60c40ebe, 0x693c0027, 0x00000000}},  //   лосо, _ucim, rček,
  { {0x63a90322, 0x6b4b0010, 0xab6602b8, 0x00000000}},  // [17a0] nsen, lügy, евал,
  { {0x3ea1001f, 0x63a900b0, 0x64590ebf, 0x00000000}},  //   _geht_, isen, _mywi,
  { {0x81cd0055, 0x26dc0197, 0x13d80044, 0x00000000}},  //   রিক_, vevo_, তিয়,
  { {0xc7c60680, 0x63a9021e, 0x80de0044, 0x00000000}},  //   ески, ksen, যাক্,
  { {0x26dc0ec0, 0x63a90030, 0xb05b0039, 0x00000000}},  //   tevo_, jsen, lfär,
  { {0x63a90030, 0x290d000a, 0x81d60044, 0x00000000}},  //   dsen, _eoea_, সিত_,
  { {0xd91006c6, 0x78a00059, 0xb05b04ce, 0x00000000}},  //   _پیش_, _temv, nfär,
  { {0x44f40098, 0x68fb00ea, 0x68e9096d, 0x00000000}},  //   тпис, _gnud, _gaed,
  { {0x6459047a, 0x26dc0197, 0x63a90bce, 0x00000000}},  //   _cywi, pevo_, gsen,
  { {0x212004cb, 0x2f14010e, 0x6723012d, 0x00000000}},  //   _alih_, _kägu_, chnj,
  { {0x22580030, 0x60dd006c, 0x75d3006d, 0x00000000}},  //   ærk_, tesm, _ميلا,
  { {0x2d81010f, 0x3ea101a2, 0x63a904fb, 0x00000000}},  //   _ruhe_, _seht_, bsen,
  { {0x60dd0ec1, 0x64590016, 0x2d810ec2, 0x00000000}},  //   resm, _gywi, _suhe_,
  { {0xb05b03a2, 0x60dd010e, 0x2d810052, 0x00000000}},  //   ffär, sesm, _puhe_,
  { {0xa01b0010, 0x1df80a78, 0x777a002d, 0x00000000}},  //   nböz, неры_, _mitx,
  { {0x81cd0055, 0xbcfb00f4, 0x67230ec3, 0x00000000}},  //   রিখ_, _thém, zhnj,
  { {0x80de0044, 0xfe7000a1, 0x7ff70025, 0x00000000}},  // [17b0] যাখ্, لدہ_, _أسعا,
  { {0x68fb00ea, 0x291f0048, 0x777a0032, 0x00000000}},  //   _snud, _slua_, _nitx,
  { {0xc33300b6, 0x68e90253, 0x290d00e0, 0x00000000}},  //   נוע_, _paed, _poea_,
  { {0xa3e00164, 0x9f520173, 0x63a90095, 0x00000000}},  //   दबा_, _aryè_, ysen,
  { {0x67230065, 0x777a002d, 0x25710ec4, 0x00000000}},  //   thnj, _bitx, _ušli_,
  { {0x45d50893, 0x7bcd0ec5, 0x63a905d5, 0x00000000}},  //   вцит, mtau, vsen,
  { {0x7d0f0010, 0xb8950025, 0x7bcd0ec6, 0x00000000}},  //   _kocs, _للأع, ltau,
  { {0x63a90004, 0x26c50061, 0x67230ec7, 0x00000000}},  //   tsen, _wclo_, shnj,
  { {0x777a0ec8, 0x7bcd01a3, 0x63a901a2, 0x00000000}},  //   _fitx, ntau, usen,
  { {0x63a90ec9, 0x765a0065, 0x7d0f0eca, 0x00000000}},  //   rsen, _fyty, _locs,
  { {0x63a903a1, 0x64590036, 0x7bcd00b0, 0x00000000}},  //   ssen, _wywi, htau,
  { {0x63a90ecb, 0x7bcd01a2, 0x00000000, 0x00000000}},  //   psen, ktau,   ,
  { {0x61e10016, 0xa3e50309, 0x81bc0089, 0x00000000}},  //   swll, _पनि_, nzēj,
  { {0x7bcd08db, 0x81bc0089, 0xb4640088, 0x00000000}},  //   dtau, izēj, _скіл,
  { {0xed5a0057, 0x2d9e0e16, 0xdca60088, 0x00000000}},  //   дов_, ète_, кави,
  { {0xed4301fb, 0xb05b04ce, 0x7bcd01a2, 0x00000000}},  //   ансп, rfär, ftau,
  { {0xed5701f9, 0x75ca005f, 0x7d0f01ee, 0x00000000}},  // [17c0] тот_, _vəzi, _docs,
  { {0x81bc001e, 0x693c0ecc, 0x387f002d, 0x00000000}},  //   dzēj, nčev, _agur_,
  { {0x18a60ecd, 0x7d0f0ece, 0xb05b04ec, 0x00000000}},  //   ваем, _focs, ngän,
  { {0xdcfe0ecf, 0x672103e1, 0xe9950014, 0x00000000}},  //   _kupč, _allj, اهنگ,
  { {0x765a00b0, 0xc0ad0049, 0x2ba9006e, 0x00000000}},  //   _syty, ליאָ, _चौपा,
  { {0xcf93007b, 0x693c02aa, 0x387f0032, 0x00000000}},  //   סטו_, jčev, _egur_,
  { {0x644e006b, 0x19b9007c, 0xe9a3003b, 0x00000000}},  //   əbiy, _путь_, _васп,
  { {0x291c0089, 0xaa43003b, 0x00000000, 0x00000000}},  //   īvas_, _тесл,   ,
  { {0xf36600e2, 0x765a00b4, 0x00000000, 0x00000000}},  //   ктон, _wyty,   ,
  { {0xd7640014, 0x81d60044, 0x764d0010, 0x00000000}},  //   _صنای, সিস_, ényé,
  { {0x6913011f, 0xaad4013d, 0x3abb0104, 0x00000000}},  //   _içer, ठ्यक, ומינ,
  { {0x7bcd0006, 0x00000000, 0x00000000, 0x00000000}},  //   ytau,   ,   ,
  { {0x693c050f, 0xc0580088, 0x7d0f00e5, 0x00000000}},  //   bčev, вір_, _rocs,
  { {0x82330123, 0x81cd0044, 0xdb23014a, 0x00000000}},  //   اریا, রিজ_, örün,
  { {0x75220095, 0xd37b08cd, 0x00000000, 0x00000000}},  //   _kloz, _קרוט,   ,
  { {0x7bcd00b0, 0xdb21014a, 0x629a0ed0, 0x00000000}},  //   ttau, ştür, lbto,
  { {0x2d580057, 0x8aa703f3, 0x21390048, 0x00000000}},  // [17d0] тить_, вред, mish_,
  { {0xd5a4009c, 0xdd11001e, 0x7bcd0ed1, 0x00000000}},  //   _وہ_, _kļūd, rtau,
  { {0x7bcd0ed2, 0x9f49014a, 0x7d0f0ed3, 0x00000000}},  //   stau, _araç_, _tocs,
  { {0x213900ab, 0x7bcd0ed4, 0x9f4900d4, 0x00000000}},  //   nish_, ptau, _braç_,
  { {0x2ca9006c, 0x75ca006b, 0x8c67007e, 0x00000000}},  //   maad_, _məzu, _штод,
  { {0x3669005e, 0xd2460379, 0x21390350, 0x00000000}},  //   нало_, _هن_, hish_,
  { {0x21390ed5, 0xa4930167, 0x44290142, 0x00000000}},  //   kish_, لیات, _ťa_,
  { {0xdb0d00c4, 0x75220ed6, 0xa3e908f3, 0x00000000}},  //   fraç, _cloz, едиа_,
  { {0xbcfb002a, 0xdb0d0181, 0x291d0ed7, 0x00000000}},  //   _chéi, graç, mkwa_,
  { {0x2ca900d9, 0xbcfb0048, 0xb05b06d3, 0x00000000}},  //   haad_, _dhéi, tgän,
  { {0xc6920476, 0x693c0ed8, 0x10a604dd, 0x00000000}},  //   _האב_, rčev, линн,
  { {0xbcfb002a, 0xdb0d0181, 0xb05b0788, 0x00000000}},  //   _fhéi, braç, rgän,
  { {0x693c0ed9, 0x2ca9018f, 0xbcfb0048, 0x00000000}},  //   mčet, daad_, _ghéi,
  { {0x248d0059, 0xf5390027, 0x343a0049, 0x00000000}},  //   lcem_, liť_, _אײנע,
  { {0x63bb0089, 0xa30a00a1, 0x2f140039, 0x00000000}},  //   lrun, _سروے_, _sägs_,
  { {0x693c0a14, 0xf5390027, 0x2139012d, 0x00000000}},  //   nčet, niť_, cish_,
  { {0xb7be0055, 0x2d93002d, 0x61260325, 0x00000000}},  // [17e0] _ইন্ট, _etxe_, _cóle,
  { {0x81d60044, 0x291d01c3, 0x4f9b01ce, 0x00000000}},  //   সির_, ekwa_, _רביצ,
  { {0x63bb001f, 0xeb75007e, 0x248d012d, 0x00000000}},  //   hrun, рытэ, kcem_,
  { {0x248d00ca, 0xb95a0025, 0x63a40180, 0x00000000}},  //   jcem_, رجاء_, _çing,
  { {0x6d440036, 0xf5390027, 0x645d006c, 0x00000000}},  //   mnia, diť_, üsil,
  { {0x6d440eda, 0x7522037e, 0x63bb0edb, 0x00000000}},  //   lnia, _sloz, drun,
  { {0x63bb001f, 0x6d44010e, 0xbcfb0048, 0x00000000}},  //   erun, onia, _shéi,
  { {0x6d4403b6, 0xdb0d0181, 0x69dc00f8, 0x00000000}},  //   nnia, traç, _ipre,
  { {0xd90d026c, 0x21390edc, 0x6d440904, 0x00000000}},  //   _تین_, vish_, inia,
  { {0x7c3b01ee, 0xdb0d00c4, 0x51f80088, 0x00000000}},  //   _žurk, rraç, вною_,
  { {0x2d9805fa, 0x21390edd, 0xf5390027, 0x00000000}},  //   jpre_, tish_, biť_,
  { {0x63bb0039, 0x7aee01c5, 0x69dc0ede, 0x00000000}},  //   brun, _labt, _mpre,
  { {0x6d440871, 0x29370049, 0x2139071e, 0x00000000}},  //   dnia, ראכן_, rish_,
  { {0x69dc0edf, 0xa2940ee0, 0x6d440036, 0x00000000}},  //   _opre, _такі, enia,
  { {0x6d440016, 0x693c01ee, 0x65600051, 0x00000000}},  //   fnia, nčes, olmh,
  { {0x63a20ee1, 0x6d440a6d, 0x5c070ee2, 0x00000000}},  //   _kwon, gnia, ляза,
  { {0x69dc02d5, 0x2ca90ee3, 0x81c60044, 0x00000000}},  // [17f0] _apre, raad_, _উনি_,
  { {0x63a20020, 0x6d44006c, 0xf5390027, 0x00000000}},  //   _mwon, ania, ziť_,
  { {0x0cd50364, 0x6d560ee4, 0x2ca900ea, 0x00000000}},  //   _коню, boya, paad_,
  { {0x6d440024, 0x63a2000a, 0x6d56004a, 0x00000000}},  //   cnia, _owon, coya,
  { {0xf5390027, 0x248d0340, 0x69dc0ee5, 0x00000000}},  //   viť_, vcem_, _epre,
  { {0x7d0d0004, 0xc5f90055, 0x7bdd0ee6, 0x00000000}},  //   ljas, _অথবা_, _ipsu,
  { {0x63a201aa, 0x80ab0044, 0xceb400a0, 0x00000000}},  //   _awon, _কান্, ציק_,
  { {0x63bb001a, 0x7d0d0ee7, 0x63a20a5f, 0x00000000}},  //   trun, njas, _bwon,
  { {0x7c2d000d, 0xf5760054, 0x693c016c, 0x00000000}},  //   nzar, جميع_, rčet,
  { {0xc6a401f9, 0x63bb0668, 0x6d440006, 0x00000000}},  //   _грци, rrun, znia,
  { {0x6d44018e, 0x6d560ee8, 0x7d0d000c, 0x00000000}},  //   ynia, yoya, kjas,
  { {0x63bb0ee9, 0x7bdd0eea, 0x63a201aa, 0x00000000}},  //   prun, _opsu, _fwon,
  { {0xe28e012b, 0x63a20173, 0xa6e80044, 0x00000000}},  //   _ма_, _gwon, পারট,
  { {0x6d440eeb, 0x08760049, 0x82350014, 0x00000000}},  //   wnia, יערט_, _پرتا,
  { {0x442d048e, 0x7bdd0c47, 0xada60eec, 0x00000000}},  //   lze_, _apsu, рабл,
  { {0xef860265, 0x7aee0169, 0x27e60b69, 0x00000000}},  //   _клип, _sabt, ywon_,

  { {0x69dc01d9, 0x2d980eed, 0xafe60726, 0x00000000}},  // [1800] _spre, spre_, _топл,
  { {0x442d0061, 0x69dc0eee, 0x2561000c, 0x00000000}},  //   ize_, _ppre, fólk_,
  { {0x09e60242, 0x2d8501dc, 0x7d0d016c, 0x00000000}},  //   роен, ílet_, bjas,
  { {0xe3a70d3a, 0x27e601aa, 0x753b0020, 0x00000000}},  //   _ور_, twon_, jiuz,
  { {0x442d00b5, 0x06af0044, 0x7aee0030, 0x00000000}},  //   jze_, চ্ছি, _tabt,
  { {0x442d0eef, 0x69960088, 0x501b0104, 0x00000000}},  //   dze_, _врах, כונו,
  { {0xe1e70647, 0x69dc0142, 0xdce4016c, 0x00000000}},  //   _بس_, _upre, gmić,
  { {0x6283027b, 0x63a201aa, 0xa96a005e, 0x00000000}},  //   _agno, _pwon, _риба_,
  { {0x39460211, 0x43060088, 0x00000000, 0x00000000}},  //   mnos_, аїна,   ,
  { {0x7d0d016c, 0xf36600ec, 0x394605a0, 0x00000000}},  //   zjas, јтин, lnos_,
  { {0x79800cd1, 0xd48f003b, 0x7c2d051b, 0x00000000}},  //   _kimw, _мр_, zzar,
  { {0x7529000b, 0x63a201aa, 0x39460052, 0x00000000}},  //   chez, _twon, nnos_,
  { {0x442d0046, 0x394600c4, 0x63a20020, 0x00000000}},  //   cze_, inos_, _uwon,
  { {0xdced0161, 0x39460016, 0x6d48009d, 0x00000000}},  //   rmač, hnos_, édan,
  { {0xeca700e1, 0x7d0d021a, 0x3f84000c, 0x00000000}},  //   ијан, tjas, ímur_,
  { {0x7c2d0ef0, 0xc27b071c, 0x39460010, 0x00000000}},  //   tzar, _ברוי, jnos_,
  { {0x29e8000d, 0x67da0089, 0x60cd0085, 0x00000000}},  // [1810] _aşa_, nājā, _icam,
  { {0x7c2d0197, 0x3946008f, 0x6aa70065, 0x00000000}},  //   rzar, enos_, _qejf,
  { {0x442d0ef1, 0x79800009, 0x7c2d0ef2, 0x00000000}},  //   zze_, _bimw, szar,
  { {0x39460ef3, 0x645d006c, 0x59c90061, 0x00000000}},  //   gnos_, üsik, ांबर,
  { {0x6126009f, 0x79800173, 0x6d5d020e, 0x00000000}},  //   _jóla, _dimw, _iksa,
  { {0x39460489, 0x66e5007e, 0x8698005e, 0x00000000}},  //   anos_, сока, атът_,
  { {0x60cd03fd, 0x3f890ef4, 0x7afa000c, 0x00000000}},  //   _ocam, _luau_, _ótta,
  { {0x442d0474, 0x7ae50368, 0x39460ef5, 0x00000000}},  //   tze_, leht, cnos_,
  { {0xc952019b, 0x442d00b5, 0xf794008b, 0x00000000}},  //   _זמן_, uze_, _матэ,
  { {0x442d0667, 0x60cd0919, 0x79800dfc, 0x00000000}},  //   rze_, _acam, _zimw,
  { {0x442d0ef6, 0x6d5d0ef7, 0x69c50009, 0x00000000}},  //   sze_, _oksa, nuhe,
  { {0x2d68010f, 0x7ae50065, 0x2561000c, 0x00000000}},  //   eßen_, heht, kóli_,
  { {0x249f0ab2, 0x78a900bb, 0x69c501a2, 0x00000000}},  //   mbum_, _meev, huhe,
  { {0x539a00b6, 0x61260489, 0x6d5d014a, 0x00000000}},  //   _עיצו, _dóla, _aksa,
  { {0xe1640014, 0x6d5d0022, 0x853c0006, 0x00000000}},  //   _وضعی, _bksa, _kvėp,
  { {0x4c8606b6, 0x61360d90, 0x61fc0c31, 0x00000000}},  //   слав, kšli, ærle,
  { {0x79800009, 0xf3880011, 0xdb0400c4, 0x00000000}},  // [1820] _rimw, _lợn_, nsiç,
  { {0x6ac60025, 0xdb040181, 0xf1db013d, 0x00000000}},  //   إقام, isiç, _बहान,
  { {0x1efb007b, 0x27ed0173, 0x69c50ef8, 0x00000000}},  //   _עלטע, _asen_, guhe,
  { {0x984a0888, 0x1d0a0131, 0xdb040e65, 0x00000000}},  //   ляла_, _семи_, rriñ,
  { {0x39460977, 0xaab80167, 0x27ed0026, 0x00000000}},  //   rnos_, _نگار_, _csen_,
  { {0x254c00b9, 0xe9aa0014, 0x3946007f, 0x00000000}},  //   děla_, _مدرن_, snos_,
  { {0x2d820020, 0x79800ef9, 0xa91d0089, 0x00000000}},  //   _kike_, _timw, _siže,
  { {0x7786007c, 0x2ca00007, 0x81bf0044, 0x00000000}},  //   _глаз, nbid_, ুবা_,
  { {0x2d8200ab, 0xccf300b3, 0xd37a0478, 0x00000000}},  //   _mike_, לכה_, лчо_,
  { {0x2d820038, 0xaaa80309, 0x60cd0efa, 0x00000000}},  //   _like_, गरिक, _scam,
  { {0xd5b901fb, 0x6126000c, 0x71270025, 0x00000000}},  //   _всі_, _sóla, مرحل,
  { {0x81bc001e, 0x59c90164, 0xa15901e1, 0x00000000}},  //   dzēt, ांतर, раму_,
  { {0xa2d3006e, 0xd8d70049, 0x2ca00146, 0x00000000}},  //   _बॉक्, זוכט_, dbid_,
  { {0x4374007a, 0x2d6801a2, 0x2cad016c, 0x00000000}},  //   _بهتر, ußen_, _žed_,
  { {0xd047005f, 0xe1890011, 0x9cf505b8, 0x00000000}},  //   _əməl, _hẳn_, озві,
  { {0x61440545, 0x2d820023, 0x00000000, 0x00000000}},  //   _неја, _cike_,   ,
  { {0x78a90951, 0x2d820065, 0xdb04000c, 0x00000000}},  // [1830] _reev, _dike_, trið,
  { {0x333e002b, 0x2d820efb, 0xbcfb0bf2, 0x00000000}},  //   nitx_, _eike_, _chér,
  { {0x7ae50efc, 0x78a90943, 0x13e10044, 0x00000000}},  //   reht, _peev, বিয়,
  { {0x2ca00061, 0x69c50efd, 0xf3880082, 0x00000000}},  //   cbid_, ruhe, _rợn_,
  { {0xf7710379, 0x78a9010e, 0x272b00ea, 0x00000000}},  //   وات_, _veev, _løne_,
  { {0x69c500b0, 0x2d82016c, 0x25a50016, 0x00000000}},  //   puhe, _zike_, _pwll_,
  { {0x78a9006c, 0x212904cb, 0xf59201b7, 0x00000000}},  //   _teev, _olah_, ولوج,
  { {0x58d4007c, 0x321e0036, 0x254c00b9, 0x00000000}},  //   _ност, dyty_, těla_,
  { {0x9817007a, 0x395f002d, 0x27ed0efe, 0x00000000}},  //   _ابزا, _ikus_, _usen_,
  { {0xdb16021e, 0x21290145, 0x15ab02dc, 0x00000000}},  //   styö, _alah_, _бъди_,
  { {0x21290eff, 0x9f49010f, 0x2cab0253, 0x00000000}},  //   _blah_, _spaß_, _oecd_,
  { {0x2ca00009, 0x6f050082, 0x00000000, 0x00000000}},  //   xbid_, _anhc,   ,
  { {0x2d820056, 0x6f170f00, 0xd24e0014, 0x00000000}},  //   _rike_, _boxc, فنی_,
  { {0xe2990b21, 0x2d820173, 0x321e0f01, 0x00000000}},  //   _так_, _sike_, byty_,
  { {0xad3a0088, 0x2ca00d12, 0x395f02db, 0x00000000}},  //   ачає_, tbid_, _okus_,
  { {0x8d66007e, 0xc5f200b3, 0x4d660451, 0x00000000}},  //   івае, ודל_, ікав,
  { {0x6f170f02, 0xcb05013d, 0x4aaa0517, 0x00000000}},  // [1840] _foxc, रांड_, икан_,
  { {0x5ec10044, 0x2cb90009, 0x00000000, 0x00000000}},  //   শ্বে, _edsd_,   ,
  { {0xa3a902fb, 0x2d82000a, 0x7f5c009d, 0x00000000}},  //   गीत_, _tike_, morq,
  { {0x6d41009d, 0x7f5c0026, 0xdd0f0095, 0x00000000}},  //   élat, lorq, mışs,
  { {0x7d060006, 0xbcfb00f4, 0x321e0036, 0x00000000}},  //   _inks, _thér, zyty_,
  { {0xab2a012b, 0xd5ba0517, 0x394d0f03, 0x00000000}},  //   _тога_, аси_, _ejes_,
  { {0x386d028d, 0x76a90088, 0xe1890082, 0x00000000}},  //   _ezer_, стів_, _sẳn_,
  { {0x89d700a1, 0x00000000, 0x00000000, 0x00000000}},  //   _گوہر_,   ,   ,
  { {0x73fa0055, 0x78a20f04, 0x25a90091, 0x00000000}},  //   েন্ট_, mbov, ćala_,
  { {0x5edf0044, 0x1fd00044, 0xd370006d, 0x00000000}},  //   _ফোনে, িবাস, عهد_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x69c30059, 0x7bd60058, 0x254c013e, 0x00000000}},  //   šneg, ktyu, mělo_,
  { {0xb97b00a3, 0xf8b3034e, 0x357300a1, 0x00000000}},  //   ינטי, ושר_, _تھوڑ,
  { {0x7d06010a, 0xa91d0087, 0x25450089, 0x00000000}},  //   _anks, _miža, vēli_,
  { {0xdef8008b, 0x00000000, 0x00000000, 0x00000000}},  //   цыя_,   ,   ,
  { {0x21290093, 0x25450089, 0x69c100ea, 0x00000000}},  //   _ulah_, tēli_, _ålei,
  { {0xb7c50044, 0xa91d00ca, 0x00000000, 0x00000000}},  // [1850] _এন্ট, _niža,   ,
  { {0xdea100a1, 0x6f0500e7, 0x99d70426, 0x00000000}},  //   _سیری, _unhc, قتصا,
  { {0x386d0c59, 0x394d0023, 0x00000000, 0x00000000}},  //   _szer_, _pjes_,   ,
  { {0xdb0d0051, 0x00000000, 0x00000000, 0x00000000}},  //   msaí,   ,   ,
  { {0x07a505f6, 0x3d08013d, 0x00000000, 0x00000000}},  //   чалн, हारे_,   ,
  { {0x3707007c, 0x00000000, 0x00000000, 0x00000000}},  //   ючев,   ,   ,
  { {0x394d0f05, 0xf6250152, 0x7af50288, 0x00000000}},  //   _tjes_, ядко, _iazt,
  { {0x395f037e, 0x7af50f06, 0x00000000, 0x00000000}},  //   _ukus_, _hazt,   ,
  { {0x59c90061, 0x7f5c004a, 0x3a2100e0, 0x00000000}},  //   ांवर, yorq, lyhp_,
  { {0xfbd2019b, 0x395d00ab, 0x27ff002d, 0x00000000}},  //   עתי_, lows_, _irun_,
  { {0x644d010a, 0x69d7002d, 0x4add0204, 0x00000000}},  //   _žaid, ntxe, न्यव,
  { {0x70c60061, 0x395d00e0, 0x7af50032, 0x00000000}},  //   वलेल, nows_, _lazt,
  { {0x4f96007e, 0x3eba0022, 0x7f5c0f07, 0x00000000}},  //   ярну, _pdpt_, torq,
  { {0x2d960d54, 0x539a009b, 0x4ac70204, 0x00000000}},  //   зрас, _היסו, _लागव,
  { {0x80ab0055, 0x78bb0091, 0x6126000c, 0x00000000}},  //   _কার্, _oduv, _hólm,
  { {0x80da0055, 0x6d4f00f6, 0x7af50288, 0x00000000}},  //   _বোর্, _cjca, _aazt,
  { {0x7af5002d, 0x3b180f08, 0xe8df0011, 0x00000000}},  // [1860] _bazt, _porq_, _ngựa_,
  { {0x7bd600e0, 0xa91d0087, 0x00000000, 0x00000000}},  //   rtyu, _riža,   ,
  { {0x273000ad, 0xe9da0f09, 0xdb0d0048, 0x00000000}},  //   _hàng_, ске_, csaí,
  { {0x27ff0056, 0xd9100167, 0xdb040051, 0x00000000}},  //   _brun_, خیر_, nsiú,
  { {0x78a20bca, 0xdb040051, 0x4c83005e, 0x00000000}},  //   rbov, isiú, _плюв,
  { {0x7af5022b, 0x27300011, 0x7bc40129, 0x00000000}},  //   _gazt, _màng_, mriu,
  { {0x09e30057, 0x2730001d, 0xa5d70025, 0x00000000}},  //   _порн, _làng_, كبير_,
  { {0x5398005e, 0x00000000, 0x00000000, 0x00000000}},  //   овия_,   ,   ,
  { {0x2730001d, 0xf4930439, 0x27ff01e5, 0x00000000}},  //   _nàng_, رشيد, _grun_,
  { {0x59d003d7, 0x798e000b, 0xaacc0201, 0x00000000}},  //   _हमार, _kubw, ालिक,
  { {0xc4860920, 0x20000089, 0x27e0002b, 0x00000000}},  //   _елек, _arii_, ħinu_,
  { {0x27300011, 0x798e0009, 0x92ac0044, 0x00000000}},  //   _bàng_, _mubw, গলে_,
  { {0x2730001d, 0x64a3003b, 0x63ae013e, 0x00000000}},  //   _càng_, _чача, áhně,
  { {0x27300011, 0x7bc40006, 0x3f8501e5, 0x00000000}},  //   _dàng_, driu, ölu_,
  { {0x7bc40004, 0x798e0009, 0x7af50059, 0x00000000}},  //   eriu, _nubw, _razt,
  { {0x20000022, 0x8d7401fa, 0x7bc40026, 0x00000000}},  //   _frii_, فاقا, friu,
  { {0xc15800b6, 0x31ae0044, 0x70550014, 0x00000000}},  // [1870] _משהו_, _কমিশ, _زندا,
  { {0x60dd01a2, 0x00000000, 0x00000000, 0x00000000}},  //   lfsm,   ,   ,
  { {0x79a4007c, 0xa2cf013d, 0x69c40316, 0x00000000}},  //   ерче, _दास्, ांगी,
  { {0x69d70032, 0x7bc40133, 0x29d500ea, 0x00000000}},  //   rtxe, briu, råa_,
  { {0x7bc404bd, 0x6d4d006c, 0x395d0133, 0x00000000}},  //   criu, mnaa, rows_,
  { {0x656200e0, 0x6d4d00bb, 0x0f1b0061, 0x00000000}},  //   _akoh, lnaa, _नकोस_,
  { {0x6d4d006c, 0x00000000, 0x00000000, 0x00000000}},  //   onaa,   ,   ,
  { {0x6d4d00b5, 0x92ac0044, 0x62980f0a, 0x00000000}},  //   nnaa, গলো_, _afvo,
  { {0x47d50054, 0x6ece001c, 0x23d4007e, 0x00000000}},  //   _زيار, _तालु, нцэр,
  { {0x27300011, 0x68eb00bb, 0x20fa0082, 0x00000000}},  //   _ràng_, legd, _ỏi_,
  { {0x69c50016, 0x27300011, 0x6d4d0f0b, 0x00000000}},  //   nrhe, _sàng_, knaa,
  { {0xd7d103d7, 0xe7d1006e, 0x7bc40006, 0x00000000}},  //   _समाच, _समाप, yriu,
  { {0x69c5010f, 0x316c0089, 0x00000000, 0x00000000}},  //   hrhe, ēdz_,   ,
  { {0x2730001d, 0x6569068f, 0x6d4d0128, 0x00000000}},  //   _vàng_, lleh, enaa,
  { {0xa3a9006e, 0xa91d0087, 0x00000000, 0x00000000}},  //   गीर_, _rižn,   ,
  { {0x6d4d0f0c, 0x27300011, 0x65690cba, 0x00000000}},  //   gnaa, _tàng_, nleh,
  { {0x6b8700b5, 0x799c0016, 0x8c430478, 0x00000000}},  // [1880] _bijg, _strw, вете,
  { {0xdcfd0089, 0x2d57002b, 0x7bc40f0d, 0x00000000}},  //   _visā, eħed_, rriu,
  { {0xfe720025, 0x0ed30061, 0x20050089, 0x00000000}},  //   _جدة_, _तातड, ālie_,
  { {0x2d57002b, 0xeb9f0637, 0x7bc4001a, 0x00000000}},  //   għed_, _brød_, priu,
  { {0x69c50250, 0xeb9a004d, 0x9f4900f6, 0x00000000}},  //   arhe, _фиг_, _graó_,
  { {0x81e40044, 0x1de20061, 0xa91d00ca, 0x00000000}},  //   নিত_, _पहात, _fižo,
  { {0xa3b0013d, 0xb05b0210, 0xdce40062, 0x00000000}},  //   टीन_, ngär, hlič,
  { {0xdce40059, 0x6ba50039, 0x65690010, 0x00000000}},  //   klič, _åtgä, gleh,
  { {0x7c240f0e, 0xd8d7007b, 0xa3a9001c, 0x00000000}},  //   nyir, _קומט_, गील_,
  { {0x6126009f, 0xdce40062, 0x52140242, 0x00000000}},  //   _fólk, dlič, едот,
  { {0x7c240009, 0x65690009, 0x75ca013f, 0x00000000}},  //   hyir, bleh, _ləzz,
  { {0xf388001d, 0x65690f0f, 0x00000000, 0x00000000}},  //   _lợi_, cleh,   ,
  { {0x60dd009f, 0x28d1013d, 0x61ed0107, 0x00000000}},  //   rfsm, _हासि, _ćale,
  { {0x44240036, 0x636f05b7, 0x272b00ea, 0x00000000}},  //   mym_, lønn, _lønn_,
  { {0x1df80147, 0x44240462, 0x200d001a, 0x00000000}},  //   меры_, lym_, ţei_,
  { {0xdce4037e, 0xc4450014, 0x5cc402ea, 0x00000000}},  //   blič, _آیین_, ксуз,
  { {0x44240046, 0x6d4d02ae, 0x4ea7012c, 0x00000000}},  // [1890] nym_, rnaa, _орна,
  { {0x65600051, 0xdb1601aa, 0x6d4d0250, 0x00000000}},  //   homh, nsyè, snaa,
  { {0x65690943, 0x637400f6, 0x69c50052, 0x00000000}},  //   yleh, càne, urhe,
  { {0x7c240009, 0x69c50f10, 0x636f0056, 0x00000000}},  //   byir, rrhe, jønn,
  { {0xdb1601aa, 0x7c240009, 0x6b8700bb, 0x00000000}},  //   ksyè, cyir, _tijg,
  { {0x7d1d0047, 0x4424018e, 0x68eb01d6, 0x00000000}},  //   _hoss, dym_, segd,
  { {0xdce400ee, 0xf3880011, 0x7d1d0f11, 0x00000000}},  //   zlič, _gợi_, _koss,
  { {0x7d1d021e, 0x00000000, 0x00000000, 0x00000000}},  //   _joss,   ,   ,
  { {0x7d1d0129, 0x65690eaa, 0x13e6007c, 0x00000000}},  //   _moss, rleh, емый_,
  { {0x6569003c, 0xdce4050f, 0x7d1d0f12, 0x00000000}},  //   sleh, vlič, _loss,
  { {0xcb12019b, 0x216a005e, 0x6569041d, 0x00000000}},  //   אלי_, зини_, pleh,
  { {0x7d1d02d5, 0xdce40059, 0x44240036, 0x00000000}},  //   _noss, tlič, bym_,
  { {0xb4270151, 0x44240036, 0x44270076, 0x00000000}},  //   _تعاو, cym_, _تراف,
  { {0x79890343, 0x75290047, 0x7bcd006c, 0x00000000}},  //   _liew, lkez, duau,
  { {0xc6920452, 0xdd920151, 0xfce60f13, 0x00000000}},  //   ראל_, اور_, ново,
  { {0x7d1d00d4, 0x79890046, 0x5ec10044, 0x00000000}},  //   _coss, _niew, শ্লে,
  { {0x7d1d028c, 0xf3880011, 0x7ff60025, 0x00000000}},  // [18a0] _doss, _sợi_, _أسبا,
  { {0x80d60061, 0x00000000, 0x00000000, 0x00000000}},  //   _भाडे,   ,   ,
  { {0x7d1d0d87, 0x3f92000b, 0x44240036, 0x00000000}},  //   _foss, _huyu_, zym_,
  { {0x69c3008e, 0x59d20309, 0x6f1e0544, 0x00000000}},  //   ánea, दंबर, _hopc,
  { {0x6f1e07e4, 0x798901d6, 0xa7fd0010, 0x00000000}},  //   _kopc, _diew, _szűr,
  { {0x57f3012b, 0xa84701b7, 0x254c00b9, 0x00000000}},  //   упшт, علوم_, měli_,
  { {0x44240046, 0x7d1d0697, 0x61260b33, 0x00000000}},  //   wym_, _yoss, _eóli,
  { {0x89db0104, 0x44240832, 0x61260f14, 0x00000000}},  //   _מחלי, tym_, _fóli,
  { {0x39460f15, 0x84970025, 0x00000000, 0x00000000}},  //   mios_, رئيس_,   ,
  { {0x39460006, 0x65600378, 0x81e40044, 0x00000000}},  //   lios_, somh, নিস_,
  { {0x041e0055, 0xa1590088, 0x53c20316, 0x00000000}},  //   _বেশী_, дану_, _शिवश,
  { {0x39460f16, 0x63740129, 0x2a6a0095, 0x00000000}},  //   nios_, fànc, _mybb_,
  { {0x7d1d0703, 0xe803007d, 0xc54200a1, 0x00000000}},  //   _ross, लिया_, _لڑکی,
  { {0x7d1d003d, 0x6f1e0a16, 0xdefb007e, 0x00000000}},  //   _soss, _copc, чым_,
  { {0x7d1d0f17, 0x3946010a, 0xdb0d000c, 0x00000000}},  //   _poss, kios_, drað,
  { {0x9d1804f9, 0xe7f10061, 0x00000000, 0x00000000}},  //   ност_, _आईला_,   ,
  { {0x39460977, 0xdb0d0e4f, 0x7d1d0181, 0x00000000}},  // [18b0] dios_, nsaç, _voss,
  { {0xdb0d0211, 0x798903b2, 0x00000000, 0x00000000}},  //   trañ, _siew,   ,
  { {0x7d1d0ba0, 0xa2d80201, 0x61260f18, 0x00000000}},  //   _toss, _मान्, _sóli,
  { {0x39460181, 0x612605a3, 0x3f9200f6, 0x00000000}},  //   gios_, _póli, _yuyu_,
  { {0x79890038, 0x2ca90277, 0x7c6709b9, 0x00000000}},  //   _view, mbad_, _ساحل,
  { {0x3669003b, 0x2d8b0211, 0xdcef0089, 0x00000000}},  //   мало_, _hice_, _ticē,
  { {0x75290047, 0x39460325, 0x56920ab7, 0x00000000}},  //   tkez, bios_, шајт,
  { {0x39460f19, 0x2ca90e42, 0x73e50216, 0x00000000}},  //   cios_, nbad_, воиз,
  { {0x80a202fb, 0x75290f1a, 0x2d9305f2, 0x00000000}},  //   _क्षे, rkez, _luxe_,
  { {0x3eb30038, 0x2d8b0091, 0x69ca0181, 0x00000000}},  //   _next_, _lice_, áfeg,
  { {0x2d8b0f1b, 0x68fb0f1c, 0x3f92005a, 0x00000000}},  //   _oice_, _kaud, _suyu_,
  { {0x61460264, 0x2d8b0549, 0x6f1e0f1d, 0x00000000}},  //   тема, _nice_, _sopc,
  { {0x20040f1e, 0x68fb0a64, 0x2ca90f1f, 0x00000000}},  //   ími_, _maud, dbad_,
  { {0x2d8b0051, 0x39460914, 0x80a2006e, 0x00000000}},  //   _aice_, zios_, _क्रे,
  { {0x63bb01e5, 0x2d8b01ee, 0x63a401d5, 0x00000000}},  //   lsun, _bice_, _ħini,
  { {0x68fb0394, 0x291f000d, 0xf2880049, 0x00000000}},  //   _naud, _noua_, _אָפֿ,
  { {0x6f1e003b, 0x39460211, 0x63bb0f20, 0x00000000}},  // [18c0] _topc, vios_, nsun,
  { {0x5fb700b6, 0x81e40044, 0x63bb010f, 0x00000000}},  //   _שהיא_, নির_, isun,
  { {0x39460211, 0x68fb0d90, 0x3eb80082, 0x00000000}},  //   tios_, _baud, mart_,
  { {0x3eb80039, 0xc7c600a8, 0x68fb008e, 0x00000000}},  //   lart_, вски, _caud,
  { {0x39460977, 0x68fb0f21, 0x2d800007, 0x00000000}},  //   rios_, _daud, mmie_,
  { {0x3946010a, 0x3eb80f22, 0x2d8b001a, 0x00000000}},  //   sios_, nart_, _zice_,
  { {0x3946029d, 0x68fb00f4, 0x7afc0f23, 0x00000000}},  //   pios_, _faud, _iart,
  { {0x7afc022b, 0x29dc0845, 0x68fb0f24, 0x00000000}},  //   _hart, mía_, _gaud,
  { {0x7afc010a, 0x3eb80f25, 0x29dc0f26, 0x00000000}},  //   _kart, kart_, lía_,
  { {0x68fb0f27, 0x7afc022b, 0xa6c70a94, 0x00000000}},  //   _zaud, _jart, _алфа_,
  { {0x29dc0f28, 0x7c3a005f, 0x69de00f4, 0x00000000}},  //   nía_, _ətra, ntpe,
  { {0x7afc008d, 0x64a6007e, 0x68e20016, 0x00000000}},  //   _lart, _рада, nfod,
  { {0xdb040211, 0xb4ae0309, 0x29dc0f29, 0x00000000}},  //   nsió, करी_, hía_,
  { {0x3eb8010f, 0x63a2006a, 0x2d8b01ca, 0x00000000}},  //   gart_, _iton, _sice_,
  { {0x29dc02a0, 0x63a2016c, 0x2ca900ea, 0x00000000}},  //   jía_, _hton, tbad_,
  { {0x29dc0f2a, 0x7afc0f2b, 0xa3e60061, 0x00000000}},  //   día_, _aart, _पहा_,
  { {0x3eb30472, 0x2d8b0181, 0x3eb8093b, 0x00000000}},  // [18d0] _text_, _vice_, bart_,
  { {0x68fb0f2c, 0x29dc0211, 0xe4e2013d, 0x00000000}},  //   _saud, fía_, क्ति_,
  { {0x29dc0219, 0x68e20016, 0x2d8b037a, 0x00000000}},  //   gía_, ffod, _tice_,
  { {0x63a20f2d, 0x7afc00ab, 0x23c20204, 0x00000000}},  //   _oton, _eart, _शिंद,
  { {0xb8db02f4, 0x69dc0f2e, 0x68fb009d, 0x00000000}},  //   _आज_, _eqre, _vaud,
  { {0x29dc0219, 0x7afc05ca, 0xe70700a1, 0x00000000}},  //   bía_, _gart, کسچی,
  { {0x29dc0219, 0x63a20f2f, 0x3a84007e, 0x00000000}},  //   cía_, _aton, _вытв,
  { {0x63bb002d, 0x7afc0f30, 0x290d0032, 0x00000000}},  //   tsun, _zart, _unea_,
  { {0xa8550057, 0x25be010f, 0x3eb802d0, 0x00000000}},  //   _скач, _evtl_, yart_,
  { {0x63bb0f31, 0x3eb80f32, 0x31690173, 0x00000000}},  //   rsun, xart_, _akaz_,
  { {0x63bb0f33, 0x3eb80d3e, 0x63a2000a, 0x00000000}},  //   ssun, vart_, _eton,
  { {0x7fd60245, 0x34950f34, 0x6d4b01aa, 0x00000000}},  //   лігі, _садр, _ňgan,
  { {0x67210f35, 0xf487003b, 0x00000000, 0x00000000}},  //   _kolj, _ружн,   ,
  { {0x61260010, 0x08760049, 0x083a0049, 0x00000000}},  //   _rólu, טערט_, געשל,
  { {0xa2d80201, 0x29dc049a, 0xf3880011, 0x00000000}},  //   _मात्, xía_, _vợt_,
  { {0x7afc022b, 0x29dc0f2a, 0x5c160057, 0x00000000}},  //   _sart, vía_, льзу,
  { {0x3eb80f36, 0x2d800036, 0x386d0f37, 0x00000000}},  // [18e0] part_, rmie_, _nyer_,
  { {0x7afc0065, 0x0eaa008b, 0x29dc008e, 0x00000000}},  //   _qart, _якой_, tía_,
  { {0x7afc0f38, 0x386d0211, 0xbf9b0181, 0x00000000}},  //   _vart, _ayer_, nvên,
  { {0x29dc0845, 0x7afc0046, 0x386d05b7, 0x00000000}},  //   ría_, _wart, _byer_,
  { {0x7afc0f39, 0x6d46038c, 0x67210f3a, 0x00000000}},  //   _tart, _imka, _bolj,
  { {0xdb040819, 0xa2d802f4, 0x29dc0f3b, 0x00000000}},  //   rsió, _माध्, pía_,
  { {0xf41f0f3c, 0xe9a3008b, 0x63a20f3d, 0x00000000}},  //   ään_, _гасп, _ston,
  { {0xb4ae0201, 0x80d60061, 0x60c40f3e, 0x00000000}},  //   करे_, _भाषे, _ndim,
  { {0x6721043d, 0x68e4006c, 0x00000000, 0x00000000}},  //   _folj, õidu,   ,
  { {0x60c4002d, 0x672100ca, 0x79820036, 0x00000000}},  //   _adim, _golj, lmow,
  { {0xe6930054, 0x41550594, 0x6d460066, 0x00000000}},  //   _المد, ивос, _omka,
  { {0x6ed70316, 0x00000000, 0x00000000, 0x00000000}},  //   _बाहु,   ,   ,
  { {0x63a203dd, 0x5ede0044, 0x81e40044, 0x00000000}},  //   _uton, য়নে, নিই_,
  { {0x88bd0036, 0x2fc000ca, 0x636f00ea, 0x00000000}},  //   _kośc, _dvig_, jønh,
  { {0x2bc70309, 0xd2b701ce, 0x2fc0032e, 0x00000000}},  //   _लिहा, _גלות_, _evig_,
  { {0x79820036, 0x316900ca, 0xeb9f0190, 0x00000000}},  //   jmow, _ukaz_, _drøn_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  // [18f0]   ,   ,   ,
  { {0x9b440025, 0x69c300ca, 0x2009009d, 0x00000000}},  //   منقو, šnem, _irai_,
  { {0xdb58007c, 0xeb9f0737, 0x672100d9, 0x00000000}},  //   уют_, _grøn_, _rolj,
  { {0x20090085, 0x00000000, 0x00000000, 0x00000000}},  //   _krai_,   ,   ,
  { {0x67210c1e, 0xdcef00b4, 0x00000000, 0x00000000}},  //   _polj, _chcą,   ,
  { {0x386d0f3f, 0x00000000, 0x00000000, 0x00000000}},  //   _vyer_,   ,   ,
  { {0x67210295, 0x7bcd000c, 0x23650059, 0x00000000}},  //   _volj, lrau, volj_,
  { {0x20090006, 0x00000000, 0x00000000, 0x00000000}},  //   _orai_,   ,   ,
  { {0xa3b00201, 0x36d50f40, 0x752201f3, 0x00000000}},  //   टील_, _возр, _dooz,
  { {0x6ac70044, 0x7bcd0f41, 0x27ed00fa, 0x00000000}},  //   র্রো, irau, _ipen_,
  { {0x88bd0036, 0x7bcd010f, 0x20090f42, 0x00000000}},  //   _gośc, hrau, _arai_,
  { {0x291d000b, 0x7bcd0006, 0x008604f9, 0x00000000}},  //   njwa_, krau, илно,
  { {0x2365012d, 0x20090f43, 0x00000000, 0x00000000}},  //   polj_, _crai_,   ,
  { {0x7bcd03ee, 0x82a50057, 0x56b5007b, 0x00000000}},  //   drau, _такж, יפֿן_,
  { {0x63a9022b, 0x99d70044, 0x20090035, 0x00000000}},  //   lpen, সবুক, _erai_,
  { {0xf388001d, 0x27ed0f44, 0x7bcd01a2, 0x00000000}},  //   _hợp_, _open_, frau,
  { {0x63a90f45, 0x4d630088, 0x26c50f46, 0x00000000}},  // [1900] npen, ікув, _odlo_,
  { {0x68e901d6, 0x63a9002d, 0x09e6017a, 0x00000000}},  //   _abed, ipen, иозн,
  { {0xe9da0f47, 0xa2d80309, 0xfce6012c, 0x00000000}},  //   тке_, _मास्, _коно,
  { {0x7bcd0f48, 0x88e6007c, 0x76000010, 0x00000000}},  //   brau, ржде, házá,
  { {0x79820046, 0x76000f49, 0x6b8e002b, 0x00000000}},  //   rmow, kázá, _tibg,
  { {0x63a90f4a, 0x88bd0036, 0x6d560022, 0x00000000}},  //   dpen, _pośc, lnya,
  { {0xd5b70147, 0xdced006b, 0x27ed00d9, 0x00000000}},  //   асы_, nmağ, _epen_,
  { {0x6d560010, 0xa91d0471, 0x00000000, 0x00000000}},  //   nnya, _bižu,   ,
  { {0x63a90f4b, 0x27e90666, 0xa5070ab7, 0x00000000}},  //   gpen, çant_, рења_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6d560f4c, 0x7bcd0089, 0xd2570088, 0x00000000}},  //   knya, zrau, ицю_,
  { {0x2bc70061, 0x6126000c, 0x20090145, 0x00000000}},  //   _लिला, _sólr, _prai_,
  { {0xe53b00b6, 0x00000000, 0x00000000, 0x00000000}},  //   _בתאר,   ,   ,
  { {0x200900f4, 0x00000000, 0x00000000, 0x00000000}},  //   _vrai_,   ,   ,
  { {0x937b01ce, 0x00000000, 0x00000000, 0x00000000}},  //   _שטות,   ,   ,
  { {0x7bcd010a, 0x2009001d, 0xc0cb0e82, 0x00000000}},  //   trau, _trai_, _руке_,
  { {0x20090f4d, 0xbc790f4e, 0x2d9c0010, 0x00000000}},  // [1910] _urai_, убах_, _éven_,
  { {0x7bcd0f4f, 0xdab90439, 0x00000000, 0x00000000}},  //   rrau, اهات_,   ,
  { {0x81e40055, 0x63a9022b, 0xceb200a3, 0x00000000}},  //   নিক_, zpen, _מיי_,
  { {0x637d0666, 0x2739009d, 0x63a90f50, 0x00000000}},  //   mène, _mène_, ypen,
  { {0x9ac700a1, 0x98e40025, 0x63a90133, 0x00000000}},  //   _نگاہ_, تكنو, xpen,
  { {0x57a4007e, 0x00000000, 0x00000000, 0x00000000}},  //   ішча,   ,   ,
  { {0x80c20055, 0x7c2d006b, 0x80dd0044, 0x00000000}},  //   ষ্ট্, lyar, _বসন্,
  { {0x68e9003b, 0x63a90f51, 0x1e58009b, 0x00000000}},  //   _ubed, tpen, ישור_,
  { {0x7c2d0f52, 0x63a90f53, 0x637d009d, 0x00000000}},  //   nyar, upen, hène,
  { {0xf5e701fb, 0x63a90f54, 0x6d4d006c, 0x00000000}},  //   _відм, rpen, hiaa,
  { {0xa2d802f4, 0x7c2d01a3, 0x22490545, 0x00000000}},  //   _मार्, hyar, упни_,
  { {0x63a90292, 0x04950025, 0x645e0036, 0x00000000}},  //   ppen, _الإح, _śpie,
  { {0x6d4d0f55, 0x7c2d0009, 0x00000000, 0x00000000}},  //   diaa, jyar,   ,
  { {0x442d0263, 0xdced006b, 0x00000000, 0x00000000}},  //   mye_, tmağ,   ,
  { {0x442d0263, 0x443f0f56, 0x637d0f57, 0x00000000}},  //   lye_, lzu_, rènd,
  { {0xe0da012b, 0xdced0f58, 0x6d4d01a3, 0x00000000}},  //   _сви_, rmağ, giaa,
  { {0x442d0f59, 0xec7a0265, 0x7c2d0047, 0x00000000}},  // [1920] nye_, упа_, gyar,
  { {0x8a3a0057, 0x2ca00276, 0x442d0f5a, 0x00000000}},  //   ляет_, scid_, iye_,
  { {0xd910007a, 0xb4f90309, 0x442d0065, 0x00000000}},  //   ویس_, ्याय_, hye_,
  { {0x6d4d00b5, 0x7c2d0020, 0x442d0a20, 0x00000000}},  //   ciaa, byar, kye_,
  { {0x442d0f5b, 0x2912005a, 0x2bba0025, 0x00000000}},  //   jye_, ıya_, _حاجة_,
  { {0x443f001e, 0x7d040ad1, 0x442d0f5c, 0x00000000}},  //   dzu_, ldis, dye_,
  { {0x2d9a009d, 0x442d0f5d, 0xe7f4006e, 0x00000000}},  //   _jupe_, eye_, _इनका_,
  { {0x442d0263, 0x3e83009d, 0x00000000, 0x00000000}},  //   fye_, lété_,   ,
  { {0x442d0047, 0x7d040051, 0x2d9a0f5e, 0x00000000}},  //   gye_, idis, _lupe_,
  { {0xdced0ecc, 0x7d04021e, 0xd6d2031d, 0x00000000}},  //   vlač, hdis, _رقص_,
  { {0x443f00f6, 0x7d040460, 0x442d0f5f, 0x00000000}},  //   azu_, kdis, aye_,
  { {0xd2570ee0, 0x442d0f60, 0x753b0020, 0x00000000}},  //   сць_, bye_, chuz,
  { {0x7d0401bc, 0x506701e0, 0xa2b10061, 0x00000000}},  //   ddis, стна, _आजच्,
  { {0x3eba01c5, 0x6d5a009d, 0xdcef0089, 0x00000000}},  //   _cept_, étan, _ticī,
  { {0xdced037e, 0x8d77023c, 0x6d4d0f61, 0x00000000}},  //   slač, مارا, tiaa,
  { {0xdced0059, 0x2d9a00bb, 0x7d040058, 0x00000000}},  //   plač, _dupe_, gdis,
  { {0xac180f62, 0x6d4d021e, 0x7bd60093, 0x00000000}},  // [1930] боту_, riaa, guyu,
  { {0x6d4d021e, 0x64400089, 0x7c2d0f63, 0x00000000}},  //   siaa, izmi, ryar,
  { {0x7c2d0149, 0x443f0209, 0x637d0129, 0x00000000}},  //   syar, zzu_, lènc,
  { {0x2730001d, 0x26de0211, 0xcebc006b, 0x00000000}},  //   _hành_, _acto_, _şəxs_,
  { {0x81e40044, 0x186901fc, 0x2d9a016c, 0x00000000}},  //   নিট_, јали_, _zupe_,
  { {0xe7360265, 0x443f005f, 0x442d09e5, 0x00000000}},  //   жеш_, vzu_, vye_,
  { {0xf7700558, 0x27300082, 0x442d0f64, 0x00000000}},  //   راه_, _mành_, wye_,
  { {0x442d0263, 0x443f022b, 0x27300011, 0x00000000}},  //   tye_, tzu_, _lành_,
  { {0x442d0f65, 0xdce40107, 0x00000000, 0x00000000}},  //   uye_, slić,   ,
  { {0x442d0f66, 0x637d0129, 0x78bb00bb, 0x00000000}},  //   rye_, dènc, _heuv,
  { {0x442d0f67, 0x2d570f68, 0x443f0036, 0x00000000}},  //   sye_, għek_, szu_,
  { {0x2d9a016c, 0x3eba0f69, 0x442d01aa, 0x00000000}},  //   _rupe_, _sept_, pye_,
  { {0x637d0129, 0x2d9a0f6a, 0x41c5007d, 0x00000000}},  //   gènc, _supe_, _विकस,
  { {0x78bb00bb, 0x27300011, 0x7d040009, 0x00000000}},  //   _leuv, _cành_, wdis,
  { {0x2730001d, 0x78bb00f4, 0x7d0401a2, 0x00000000}},  //   _dành_, _oeuv, tdis,
  { {0x78bb0f6b, 0x2fcd0059, 0x6cd60076, 0x00000000}},  //   _neuv, šega_, تقرا,
  { {0x637d0129, 0x78a20f6c, 0xa3dc0061, 0x00000000}},  // [1940] cènc, vcov, तंय_,
  { {0x7bd6005d, 0x2d9a0020, 0x63a40051, 0x00000000}},  //   ruyu, _tupe_, _éine,
  { {0x7d040f6d, 0x6abe0c3f, 0x3e83009d, 0x00000000}},  //   pdis, rapf, rété_,
  { {0x1d0a0364, 0x69c30f6e, 0x27ff00e5, 0x00000000}},  //   _теми_, ânea, _bsun_,
  { {0x78a20142, 0x3860006b, 0xa81700a1, 0x00000000}},  //   rcov, çir_, قتور_,
  { {0x78a200ab, 0x3860002b, 0x00000000, 0x00000000}},  //   scov, ħir_,   ,
  { {0xa3dc04da, 0x78a20142, 0x00000000, 0x00000000}},  //   तून_, pcov,   ,
  { {0x6abc0030, 0x63740129, 0x7bc40006, 0x00000000}},  //   _herf, màni, osiu,
  { {0x54540f6f, 0x7bc404f5, 0x5397007e, 0x00000000}},  //   явит, nsiu, овыя_,
  { {0x29040093, 0x799c0590, 0x637d0129, 0x00000000}},  //   _hama_, _kurw, vènc,
  { {0x29040be3, 0x7bc400e0, 0x2ef801d6, 0x00000000}},  //   _kama_, hsiu, derf_,
  { {0x09cf0055, 0x2904006c, 0x29060f70, 0x00000000}},  //   _রহমা, _jama_, ndoa_,
  { {0x27e604cb, 0x29040727, 0x74130025, 0x00000000}},  //   nton_, _mama_, _يوما,
  { {0x2904020c, 0x637d04bd, 0x6abc04c1, 0x00000000}},  //   _lama_, rènc, _nerf,
  { {0xdcbb0f71, 0x637d0129, 0x313502b0, 0x00000000}},  //   ища_, sènc, _некр,
  { {0x5c9904af, 0x29040149, 0x27e60f72, 0x00000000}},  //   ская_, _nama_, kton_,
  { {0x7af70f73, 0xdfdb005e, 0x6abc0f74, 0x00000000}},  // [1950] text, _тъй_, _berf,
  { {0x501c00a0, 0x6abc0f75, 0x60dd0296, 0x00000000}},  //   _כוחו, _cerf, lgsm,
  { {0x78bb028c, 0x6abc0f76, 0x27e6008e, 0x00000000}},  //   _peuv, _derf, eton_,
  { {0x27e60f77, 0x2904029d, 0x7af7004a, 0x00000000}},  //   fton_, _cama_, sext,
  { {0x01e00055, 0x27e60011, 0x394f09b3, 0x00000000}},  //   ববিদ, gton_, rigs_,
  { {0x394f00f6, 0x2739000a, 0xdb0400c4, 0x00000000}},  //   sigs_, _bèna_, rpiã,
  { {0x6728037e, 0x27e600b0, 0x63740129, 0x00000000}},  //   _dodj, aton_, càni,
  { {0x21290058, 0x29040f6a, 0x69c50023, 0x00000000}},  //   _noah_, _gama_, mshe,
  { {0x69c504f2, 0x394d00ea, 0x27ff0f78, 0x00000000}},  //   lshe, _imes_, _usun_,
  { {0x466b01e0, 0x6f050146, 0x69c50f79, 0x00000000}},  //   _крем_, _nahc, oshe,
  { {0xe8030309, 0x2ef80f7a, 0x29040095, 0x00000000}},  //   लिका_, verf_, _yama_,
  { {0x67230ed8, 0x2ef8040f, 0x69c50133, 0x00000000}},  //   ljnj, werf_, ishe,
  { {0x88bd0036, 0x200f0285, 0x2ef801d6, 0x00000000}},  //   _rośl, _ágil_, terf_,
  { {0x69c50065, 0x395f0039, 0x2d9c0010, 0x00000000}},  //   kshe, _ljus_, _évek_,
  { {0x6b9d001f, 0x69c50f7b, 0x6b400abc, 0x00000000}},  //   _ausg, jshe, _högg,
  { {0x69c50030, 0x6abc01d6, 0x6b950089, 0x00000000}},  //   dshe, _serf, _aizg,
  { {0x29040f7c, 0x2cb20016, 0x69c50f7d, 0x00000000}},  // [1960] _rama_, rbyd_, eshe,
  { {0x2904020c, 0x4a9a008b, 0x7bc4001a, 0x00000000}},  //   _sama_, стаў_, rsiu,
  { {0x6abc0a9b, 0x6728037e, 0x4ae2001c, 0x00000000}},  //   _verf, _rodj, _पाठव,
  { {0x27e60866, 0x6abc0125, 0x2d82010e, 0x00000000}},  //   tton_, _werf, _uhke_,
  { {0x672801d9, 0x29040091, 0x6abc030c, 0x00000000}},  //   _podj, _vama_, _terf,
  { {0x395f0173, 0x47330088, 0x7d06014a, 0x00000000}},  //   _ejus_, нніс, _haks,
  { {0x7d060f7e, 0x2904006a, 0x27e60f7f, 0x00000000}},  //   _kaks, _tama_, ston_,
  { {0x27e60065, 0x7d060f80, 0xda5b00b3, 0x00000000}},  //   pton_, _jaks, _הכלל,
  { {0x7d060f81, 0x69c7016e, 0x00000000, 0x00000000}},  //   _maks, _zvje,   ,
  { {0x883b00b6, 0x637d0263, 0x63ab0145, 0x00000000}},  //   _התמו, tèna, _dtgn,
  { {0x76430046, 0x26cc018e, 0x6587000c, 0x00000000}},  //   czny, _iddo_, árhæ,
  { {0xf48704e1, 0x7d060052, 0x867b0049, 0x00000000}},  //   _کامی, _naks, _פראו,
  { {0x60dd00eb, 0xcfa7007c, 0xfc3f004a, 0x00000000}},  //   rgsm, яшни, _afín_,
  { {0x3da701be, 0x69c50f82, 0x7d060f83, 0x00000000}},  //   зраб, yshe, _aaks,
  { {0x7d060039, 0xdef8007e, 0x9e140088, 0x00000000}},  //   _baks, чыя_, ндрі,
  { {0x69c50190, 0x6b9d0089, 0x00000000, 0x00000000}},  //   vshe, _pusg,   ,
  { {0x69c70182, 0xfe70026c, 0xd11a0309, 0x00000000}},  // [1970] _svje, ندہ_, धारण_,
  { {0x69c50de8, 0x394d087a, 0x69c300c4, 0x00000000}},  //   tshe, _smes_, âneo,
  { {0x7d060f84, 0x6aa50f85, 0xf9f90380, 0x00000000}},  //   _faks, rchf, تفاع_,
  { {0x69c5008d, 0xac19003b, 0x26cc0016, 0x00000000}},  //   rshe, _дому_, _addo_,
  { {0x69c50efd, 0x394d0059, 0xfc64005e, 0x00000000}},  //   sshe, _vmes_, _зърн,
  { {0xe29a0011, 0x69c50f86, 0x00000000, 0x00000000}},  //   _ngư_, pshe,   ,
  { {0x69c70182, 0xba77089d, 0x945d0036, 0x00000000}},  //   _uvje, _راست, kańc,
  { {0xbe3c009b, 0x60cd0f87, 0x394d01ee, 0x00000000}},  //   מעות, _ndam, _umes_,
  { {0xb4ad03d7, 0x67d40088, 0x76430f88, 0x00000000}},  //   _कभी_, _поту, szny,
  { {0x60cd038c, 0xd75b0014, 0x644d0006, 0x00000000}},  //   _adam, _اجرا_, _žais,
  { {0x77640129, 0xa51d007e, 0x6ed70204, 0x00000000}},  //   éixe, _вялi, _बाजु,
  { {0xa3b0013d, 0x00000000, 0x00000000, 0x00000000}},  //   टीङ_,   ,   ,
  { {0x7d06001e, 0x6b400039, 0x60cd0016, 0x00000000}},  //   _raks, _höge, _ddam,
  { {0x7d0608b2, 0x6d4f0f89, 0x60cd013f, 0x00000000}},  //   _saks, _amca, _edam,
  { {0x7d06006a, 0x2d9e00f4, 0x1b060055, 0x00000000}},  //   _paks, ête_, রামে_,
  { {0x6b4009b0, 0x6d4f0009, 0x00000000, 0x00000000}},  //   _möge, _cmca,   ,
  { {0x7d060f8a, 0x5ed30044, 0xed5700ed, 0x00000000}},  // [1980] _vaks, দ্ধে, фот_,
  { {0x7d060145, 0x4c8300e2, 0x00000000, 0x00000000}},  //   _waks, тлув,   ,
  { {0xe0df00f6, 0xe800013d, 0x752b00d9, 0x00000000}},  //   ciòs_, लौना_, _oogz,
  { {0x637400d4, 0x00000000, 0x00000000, 0x00000000}},  //   lànt,   ,   ,
  { {0x07fa0f8b, 0x07a309e6, 0xf746012d, 0x00000000}},  //   تراع_, вачн, медо,
  { {0xeb9f02cc, 0xb865035b, 0x2fcf06ec, 0x00000000}},  //   _prøv_, رانو, _ægge_,
  { {0x8a030216, 0x00000000, 0x00000000, 0x00000000}},  //   _изре,   ,   ,
  { {0xa926007e, 0x00000000, 0x00000000, 0x00000000}},  //   _ўдал,   ,   ,
  { {0x671e0309, 0x14180025, 0x752b0023, 0x00000000}},  //   पादक_, سيدة_, _dogz,
  { {0xf7720054, 0x6b4000f8, 0x00000000, 0x00000000}},  //   _شاء_, _högb,   ,
  { {0x2fc902e7, 0x00000000, 0x00000000, 0x00000000}},  //   _svag_,   ,   ,
  { {0x92be0055, 0x914b01e1, 0xd2570a7c, 0x00000000}},  //   ইলে_, ічна_, ьцы_,
  { {0xe0df0026, 0xf41f00b0, 0x945d00b4, 0x00000000}},  //   rgò_, äät_, rańc,
  { {0x6b40000c, 0x00000000, 0x00000000, 0x00000000}},  //   _lögb,   ,   ,
  { {0xf206005e, 0x00000000, 0x00000000, 0x00000000}},  //   _цяло,   ,   ,
  { {0x9d18005e, 0x2c0b0061, 0x00000000, 0x00000000}},  //   мост_, हटलं_,   ,
  { {0x63ad0f8c, 0xfd1f0082, 0x37be0044, 0x00000000}},  // [1990] _çant, _chìa_, _উৎসর,
  { {0xdb0d000c, 0x637400f6, 0x00000000, 0x00000000}},  //   gsað, cànt,   ,
  { {0x6d4f0009, 0x00000000, 0x00000000, 0x00000000}},  //   _tmca,   ,   ,
  { {0xa2d8001c, 0x6562008d, 0xdce4014a, 0x00000000}},  //   _माझ्, _njoh, mliğ,
  { {0x7ac700aa, 0xdce4014a, 0x00000000, 0x00000000}},  //   _осве, lliğ,   ,
  { {0x2d99070c, 0x6d910142, 0x80380049, 0x00000000}},  //   _hise_, _sťah, ונדע_,
  { {0x58d501f9, 0xdce4011f, 0x2d990f8d, 0x00000000}},  //   _повт, nliğ, _kise_,
  { {0x6b4001a2, 0xd618006d, 0x00000000, 0x00000000}},  //   _vöge, بتها_,   ,
  { {0x2d990f8e, 0x47d50054, 0x443903f0, 0x00000000}},  //   _mise_, _سيار, ás_,
  { {0x42250057, 0x2d99014a, 0xdce4014a, 0x00000000}},  //   едов, _lise_, kliğ,
  { {0x4ae203d7, 0x78a40dbd, 0x2d9900f4, 0x00000000}},  //   _पासव, žive, _oise_,
  { {0x2d990b97, 0xa06a003b, 0x00000000, 0x00000000}},  //   _nise_, зама_,   ,
  { {0x98a40089, 0x1b060044, 0x00000000, 0x00000000}},  //   _jomā_, রাতে_,   ,
  { {0xa3570f8f, 0x2d990f90, 0xcad50044, 0x00000000}},  //   _تخصص, _aise_, স্তফ,
  { {0x2d990f91, 0x00000000, 0x00000000, 0x00000000}},  //   _bise_,   ,   ,
  { {0x62830f92, 0x00000000, 0x00000000, 0x00000000}},  //   _izno,   ,   ,
  { {0xe7da0055, 0x4f960f93, 0xbea6007c, 0x00000000}},  // [19a0] _ধন্য, _проу, _папк,
  { {0xdce40180, 0x2d990007, 0x2d9e00c4, 0x00000000}},  //   bliğ, _eise_, ítes_,
  { {0x5336007b, 0xdebb0097, 0xe8fa0f94, 0x00000000}},  //   ענען_, _ממיל, зле_,
  { {0xe1ff0046, 0xeb9a041f, 0xfd1f0082, 0x00000000}},  //   łów_, _ним_, _thìa_,
  { {0x6d56006b, 0x3f9a0052, 0x4e960014, 0x00000000}},  //   miya, _kipu_, _تشکر,
  { {0x6d56005d, 0x98a40089, 0x2d990035, 0x00000000}},  //   liya, _domā_, _zise_,
  { {0xceb300b6, 0x6b6306b6, 0x850400a1, 0x00000000}},  //   ניה_, _скра, ہوںن,
  { {0x6d560f95, 0x657b0f96, 0x6d4400c4, 0x00000000}},  //   niya, gluh, nhia,
  { {0xe3af01ef, 0xd9430f97, 0xa9670f98, 0x00000000}},  //   یری_, _сети, _чита_,
  { {0xfd1f001d, 0x6d5600e0, 0x68e20190, 0x00000000}},  //   _nhìn_, hiya, lgod,
  { {0x6d560f99, 0x6d4405cd, 0xf41f006c, 0x00000000}},  //   kiya, khia, äär_,
  { {0x88bd0036, 0x8466005e, 0x7afe01d6, 0x00000000}},  //   _dośw, _пъле, hept,
  { {0x6d560f9a, 0x54330380, 0x55770049, 0x00000000}},  //   diya, _مرور, _װעגן_,
  { {0x69de00b0, 0x2d990f9b, 0x15f4006e, 0x00000000}},  //   kupe, _sise_, _आहार_,
  { {0x2d99016c, 0x63a20f9c, 0xf8d00061, 0x00000000}},  //   _pise_, _huon, हणाय,
  { {0x63a2000b, 0x6d56005f, 0x6d440412, 0x00000000}},  //   _kuon, giya, ghia,
  { {0x2d990292, 0x63a200b0, 0x65600048, 0x00000000}},  // [19b0] _vise_, _juon, inmh,
  { {0x63a20020, 0x2d990133, 0xdced012d, 0x00000000}},  //   _muon, _wise_, klać,
  { {0x63a20f9d, 0xda670426, 0x2d990f9e, 0x00000000}},  //   _luon, رائي, _tise_,
  { {0x6d440198, 0x637d0263, 0xacbb00f4, 0x00000000}},  //   chia, vènm, _coût,
  { {0x7d0d000c, 0x63a20f9f, 0x66e50fa0, 0x00000000}},  //   mdas, _nuon, вола,
  { {0xf72b007e, 0x7d0d0ad1, 0x7bdf0026, 0x00000000}},  //   яцей_, ldas, muqu,
  { {0x7bdf008e, 0xc1790006, 0xae14006e, 0x00000000}},  //   luqu, ntės_, डियन_,
  { {0x63a20fa1, 0x7d0d0fa2, 0xacbb00f4, 0x00000000}},  //   _buon, ndas, _goût,
  { {0x63a20011, 0x6b4000f8, 0x00000000, 0x00000000}},  //   _cuon, _höga,   ,
  { {0x63a20fa3, 0x6d56006b, 0x88bd0036, 0x00000000}},  //   _duon, ziya, _pośw,
  { {0x216a0113, 0x26c70fa4, 0x614600e3, 0x00000000}},  //   дини_, mano_, вена,
  { {0x26c70198, 0x7afe0fa5, 0x8fa6007e, 0x00000000}},  //   lano_, zept, каме,
  { {0xf992007b, 0xa3a8001c, 0xaae201f5, 0x00000000}},  //   ירט_, _खूप_, _पालक,
  { {0x26c70207, 0x75290166, 0x6d5604be, 0x00000000}},  //   nano_, ljez, wiya,
  { {0x6d44018e, 0x6d560890, 0x50b60fa6, 0x00000000}},  //   thia, tiya, _испу,
  { {0x26120204, 0x7d0d0058, 0x7c24002d, 0x00000000}},  //   थिती_, gdas, txir,
  { {0x6449001f, 0x26c709bd, 0x7afe001a, 0x00000000}},  // [19c0] nzei, kano_, tept,
  { {0x6d56005f, 0x60c40fa7, 0x69de01ca, 0x00000000}},  //   siya, _heim, tupe,
  { {0x26c70036, 0x3ed9007b, 0x6449010f, 0x00000000}},  //   dano_, _אַרא, hzei,
  { {0x7afe0fa8, 0x79890016, 0x6c860025, 0x00000000}},  //   sept, _chew, _للجم,
  { {0x26c70fa9, 0x69de010e, 0x68e20faa, 0x00000000}},  //   fano_, supe, rgod,
  { {0x26c7016e, 0x60c400b0, 0x68e20016, 0x00000000}},  //   gano_, _leim, sgod,
  { {0x63a20207, 0x2d9c0047, 0x24800089, 0x00000000}},  //   _suon, _éves_, _šim_,
  { {0x60c40391, 0x6449010f, 0xe56f0439, 0x00000000}},  //   _neim, fzei, يطي_,
  { {0x07a60057, 0x26c700d6, 0x6b9c006c, 0x00000000}},  //   _разн, bano_, _kirg,
  { {0x26c70555, 0x394602d5, 0x7d0d0047, 0x00000000}},  //   cano_, lhos_, zdas,
  { {0x53d4001c, 0x61ea0009, 0x7d0d0279, 0x00000000}},  //   _दिवश, _qqfl, ydas,
  { {0x394602d5, 0x63a20fab, 0x5187012b, 0x00000000}},  //   nhos_, _tuon, ђуна,
  { {0x14d70476, 0x60c40fac, 0x934608d6, 0x00000000}},  //   _יואל_, _deim, _инде,
  { {0x5333025f, 0x6b9c01a2, 0x00000000, 0x00000000}},  //   _вешт, _nirg,   ,
  { {0x2fc0063c, 0x02fb0104, 0x60c40fad, 0x00000000}},  //   _ewig_, _חלומ, _feim,
  { {0x60c4000c, 0x26c70340, 0x6b9c0122, 0x00000000}},  //   _geim, zano_, _airg,
  { {0x7d0d0149, 0x6b9c0fae, 0x26c7011c, 0x00000000}},  // [19d0] rdas, _birg, yano_,
  { {0x7cde001a, 0x20090b97, 0x26c70faf, 0x00000000}},  //   tărâ, _isai_, xano_,
  { {0x26c70198, 0x6b9c0016, 0x7d0d046a, 0x00000000}},  //   vano_, _dirg, pdas,
  { {0x26c70fb0, 0x00000000, 0x00000000, 0x00000000}},  //   wano_,   ,   ,
  { {0x26c70fb1, 0x386903d1, 0x9bc4007e, 0x00000000}},  //   tano_, çar_, _вёск,
  { {0xa03c00b6, 0x386901d5, 0x6b9c0fb2, 0x00000000}},  //   ועדפ, ħar_, _girg,
  { {0x78a40119, 0xa3e50061, 0xa3a8006e, 0x00000000}},  //   živa, बून_, _खूब_,
  { {0xf3ff0fb3, 0x39460219, 0xb4ad001c, 0x00000000}},  //   ção_, chos_, कडे_,
  { {0xf8ae026c, 0x26c70fb4, 0x68e90066, 0x00000000}},  //   _رکن_, pano_, _iced,
  { {0x6449001f, 0x60c4010a, 0x753b0224, 0x00000000}},  //   rzei, _seim, skuz,
  { {0x64490fb5, 0x7ae50051, 0x2fc00fb6, 0x00000000}},  //   szei, ight, _swig_,
  { {0xe4cb007a, 0x26c5005b, 0x7bcd01b1, 0x00000000}},  //   _آبان_, _helo_, ksau,
  { {0xb4df024c, 0x25a50fb7, 0xfd1f0011, 0x00000000}},  //   तली_, _hull_, _chìm_,
  { {0x25a501d5, 0x60c404b2, 0x26c50e45, 0x00000000}},  //   _kull_, _weim, _jelo_,
  { {0x60c40fb8, 0x26c50181, 0x20090fb9, 0x00000000}},  //   _teim, _melo_, _esai_,
  { {0x2d8b0ce2, 0x61e100b0, 0xf1b200a0, 0x00000000}},  //   _chce_, mull, _פסח_,
  { {0x61e10127, 0xac86026b, 0x25a50fba, 0x00000000}},  // [19e0] lull, угал, _lull_,
  { {0xec770fbb, 0xaf060fbc, 0x68e900c4, 0x00000000}},  //   упу_, _спол, _aced,
  { {0x61e10fbd, 0x25a50541, 0x637d0129, 0x00000000}},  //   null, _null_, gèni,
  { {0x07a6007e, 0xb4ad0204, 0x6b40000c, 0x00000000}},  //   гадн, कडो_, _gögn,
  { {0x26c50181, 0x6b9c001e, 0x7e7e00b0, 0x00000000}},  //   _belo_, _tirg, _hypp,
  { {0x61e1008d, 0x26c501d9, 0xfaa3007e, 0x00000000}},  //   kull, _celo_, _гаро,
  { {0x212001cd, 0x26c501d9, 0x290d0022, 0x00000000}},  //   _onih_, _delo_, _faea_,
  { {0x9d220055, 0x61e10fbe, 0x2d8001d6, 0x00000000}},  //   _নতুন_, dull, nlie_,
  { {0x78660454, 0x26c50145, 0x00000000, 0x00000000}},  //   _сказ, _felo_,   ,
  { {0x25a50038, 0x61e100ab, 0x26c500c4, 0x00000000}},  //   _full_, full, _gelo_,
  { {0x61e10fbf, 0x00000000, 0x00000000, 0x00000000}},  //   gull,   ,   ,
  { {0x26c501d9, 0xa1590fc0, 0x64a6003b, 0x00000000}},  //   _zelo_, таму_, _сада,
  { {0xd0e602fb, 0x5436031d, 0x26c5011c, 0x00000000}},  //   _कारण_, _حرار, _yelo_,
  { {0xa2940451, 0x2d800fc1, 0x212000ca, 0x00000000}},  //   _калі, elie_, _enih_,
  { {0x61e100d4, 0x1df80783, 0x00000000, 0x00000000}},  //   cull, леры_,   ,
  { {0x2d8004b8, 0x7bcd0706, 0x20090085, 0x00000000}},  //   glie_, tsau, _tsai_,
  { {0x2009023a, 0x5c990147, 0x7bcd0be1, 0x00000000}},  // [19f0] _usai_, ткая_, usau,
  { {0x7ae500ab, 0x6d5a0e9d, 0x637d0173, 0x00000000}},  //   ught, étar, tèni,
  { {0x7bcd006c, 0x2d800fc2, 0x26c5011c, 0x00000000}},  //   ssau, blie_, _relo_,
  { {0x26c50209, 0x98c70025, 0x25a50fc3, 0x00000000}},  //   _selo_, اغان, _rull_,
  { {0xf7710025, 0x26c502d5, 0x25a50198, 0x00000000}},  //   يات_, _pelo_, _sull_,
  { {0x45d50517, 0x25a500ab, 0x39440fc4, 0x00000000}},  //   ацит, _pull_, _elms_,
  { {0x6b40001f, 0x26c508f7, 0x65c20242, 0x00000000}},  //   _mögl, _velo_, обща,
  { {0xb4df0183, 0x613f008d, 0x61e10fc5, 0x00000000}},  //   तले_, _qëll, vull,
  { {0xa3e5007d, 0x613f0065, 0x7d0f0010, 0x00000000}},  //   बंध_, _vëll, _macs,
  { {0x61e1008d, 0x7d0f041d, 0x25a500f8, 0x00000000}},  //   tull, _lacs, _tull_,
  { {0x2d80074e, 0xcb120097, 0xe1260088, 0x00000000}},  //   ylie_, קלט_, амни,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x22590036, 0x61e10329, 0x316901aa, 0x00000000}},  //   ńsk_, sull, _djaz_,
  { {0x61e10fc6, 0x3f9e0fc7, 0xdee60098, 0x00000000}},  //   pull, ötu_, јови,
  { {0x42790049, 0x3f84001e, 0xed5a007c, 0x00000000}},  //   _באַג, ēmu_, вов_,
  { {0x20560c96, 0xdca30900, 0xee3700e2, 0x00000000}},  //   _втор, жати, шнс_,
  { {0x0c26017f, 0x00000000, 0x00000000, 0x00000000}},  // [1a00] шман,   ,   ,
  { {0x2d800133, 0x7e7e0fc8, 0x00000000, 0x00000000}},  //   slie_, _typp,   ,
  { {0x7d0f031e, 0xa3e5007d, 0x6edb009b, 0x00000000}},  //   _facs, बूत_, _בחיפ,
  { {0xd946012b, 0xaae20061, 0xdb060023, 0x00000000}},  //   једи, _पाकक, _kukë,
  { {0x7d04021e, 0x78a4040d, 0xfaa60088, 0x00000000}},  //   meis, živo, _ваго,
  { {0x5777007e, 0xed590142, 0x00000000, 0x00000000}},  //   абіў_, ďže_,   ,
  { {0x645d000c, 0xe7370545, 0x60d60085, 0x00000000}},  //   úsin, реј_, _odym,
  { {0x7d04021e, 0x2b580544, 0x00000000, 0x00000000}},  //   neis, _hmrc_,   ,
  { {0x66e601fc, 0xc34a005e, 0x6b40000c, 0x00000000}},  //   _воза, вяне_, _lögm,
  { {0x7d040fc9, 0x79820038, 0x973c0107, 0x00000000}},  //   heis, llow, _biće,
  { {0x7d040ecb, 0x6d4600b0, 0x00000000, 0x00000000}},  //   keis, _olka,   ,
  { {0x9257007c, 0x8556025a, 0xdb060023, 0x00000000}},  //   рают_, _خیبر_, _bukë,
  { {0x320200b9, 0x7522016e, 0x7d040052, 0x00000000}},  //   ňky_, _inoz, deis,
  { {0x6d460fca, 0x7d0f096b, 0xc0580088, 0x00000000}},  //   _alka, _sacs, рію_,
  { {0xd3780119, 0x7d040016, 0x79820036, 0x00000000}},  //   moć_, feis, klow,
  { {0x929b00b6, 0x7d040abe, 0x7c87007c, 0x00000000}},  //   _ביות, geis, аузе,
  { {0xfaa7007c, 0x75220062, 0xdfd1006d, 0x00000000}},  // [1a10] ашен, _mnoz, _عيد_,
  { {0x6d460fcb, 0xd5a400a1, 0x78a40f3a, 0x00000000}},  //   _elka, _يہ_, živl,
  { {0x3f830ce4, 0x7d0f0fcc, 0xce68007c, 0x00000000}},  //   mlju_, _tacs, _вряд_,
  { {0xae1a009b, 0x3e160049, 0x79820036, 0x00000000}},  //   _עורכ, _פֿיל_, glow,
  { {0x1b0f0044, 0xf8070256, 0xd3780fcd, 0x00000000}},  //   সাবে_, рчен, koć_,
  { {0xd246002c, 0x4429002b, 0xdb2300a2, 0x00000000}},  //   _فن_, _ħa_, _بوسی,
  { {0x79820036, 0x69de012d, 0x5a44007e, 0x00000000}},  //   blow, crpe, _дэта,
  { {0x798200d9, 0x00000000, 0x00000000, 0x00000000}},  //   clow,   ,   ,
  { {0x1422007e, 0x461500a6, 0x00000000, 0x00000000}},  //   здым, _گوار,   ,
  { {0xc8c800a1, 0x75220087, 0x00000000, 0x00000000}},  //   _موہن_, _enoz,   ,
  { {0xc4cf00a1, 0x7d0400e7, 0x00000000, 0x00000000}},  //   _ہےں_, yeis,   ,
  { {0xcea90097, 0x973c012d, 0x00000000, 0x00000000}},  //   _טי_, _viće,   ,
  { {0x4429028c, 0x05740025, 0xd3a7003b, 0x00000000}},  //   _ça_, _بالد, _треп,
  { {0x63bb020c, 0x7d04010f, 0x0239004b, 0x00000000}},  //   mpun, weis, _مثبت_,
  { {0x7d040fce, 0x6ade0044, 0x68fb0036, 0x00000000}},  //   teis, ন্ডো, _obud,
  { {0x90c60893, 0x00000000, 0x00000000, 0x00000000}},  //   _убие,   ,   ,
  { {0x63bb0039, 0x3f830166, 0x6d580006, 0x00000000}},  // [1a20] npun, blju_, _įvad,
  { {0x7d0403b6, 0x68fb03c9, 0x798205d2, 0x00000000}},  //   seis, _abud, wlow,
  { {0x7d040292, 0xe9da0aed, 0x993a01e1, 0x00000000}},  //   peis, уке_, ляду_,
  { {0x63bb07af, 0x00000000, 0x00000000, 0x00000000}},  //   kpun,   ,   ,
  { {0xe73a017f, 0x1867012b, 0xacf700a1, 0x00000000}},  //   лед_, баци_, _اسپت,
  { {0x63bb0039, 0xdce4002b, 0x78250025, 0x00000000}},  //   dpun, kniċ, تعمل,
  { {0xa96a05f6, 0xceb300a3, 0x63bb00d9, 0x00000000}},  //   _бива_, ליג_, epun,
  { {0x63bb0fcf, 0x00000000, 0x00000000, 0x00000000}},  //   fpun,   ,   ,
  { {0x63bb011c, 0x00000000, 0x00000000, 0x00000000}},  //   gpun,   ,   ,
  { {0xaaba02fb, 0x68fb05c9, 0x1b0f0044, 0x00000000}},  //   ेरिक, _zbud, সাথে_,
  { {0x3f830091, 0x63bb002d, 0x4b7b0049, 0x00000000}},  //   vlju_, apun, רטיג,
  { {0x73e6008b, 0x1a9b0049, 0x7147007c, 0x00000000}},  //   _годз, טייע, схож,
  { {0x3f830107, 0x27e60058, 0x637d0129, 0x00000000}},  //   tlju_, nuon_, tènt,
  { {0x2e180173, 0x3ea500ea, 0x00000000, 0x00000000}},  //   _bčf_, ølt_,   ,
  { {0x2000000a, 0x27e60022, 0x00000000, 0x00000000}},  //   _epii_, huon_,   ,
  { {0x52830054, 0x78a40243, 0x3f830fd0, 0x00000000}},  //   _عليك, živj, slju_,
  { {0xfd4f001d, 0x2906002d, 0x09d10061, 0x00000000}},  // [1a30] _khiế, deoa_, हळ्य,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x27ff000d, 0xc987017f, 0x3ce902e1, 0x00000000}},  //   _spun_, буди, pgav_,
  { {0x63bb0fd1, 0x00000000, 0x00000000, 0x00000000}},  //   ypun,   ,   ,
  { {0x6aa9001a, 0x6d4d0434, 0x4ae20204, 0x00000000}},  //   _şefu, mhaa, _पाचव,
  { {0x70b50164, 0xfd4f0011, 0x68fb0036, 0x00000000}},  //   ंडुल, _nhiế, _wbud,
  { {0xc5d50088, 0x00000000, 0x00000000, 0x00000000}},  //   ціль,   ,   ,
  { {0x63bb0fd2, 0x68fb0415, 0x27e60fd3, 0x00000000}},  //   tpun, _ubud, buon_,
  { {0x69da0073, 0x63bb00b0, 0x7c2d0129, 0x00000000}},  //   _åter, upun, nxar,
  { {0xfd4f001d, 0x63bb0fd4, 0xe1f9003b, 0x00000000}},  //   _chiế, rpun, аго_,
  { {0x63bb000d, 0x6f0700b9, 0x6d4d0fd5, 0x00000000}},  //   spun, dejc, khaa,
  { {0x63bb0ba0, 0x27e00340, 0xd24e0014, 0x00000000}},  //   ppun, šine_, خچه_,
  { {0x6d4d0518, 0x297a0049, 0x00000000, 0x00000000}},  //   dhaa, שטרא,   ,
  { {0x65690fd6, 0x6da60fd7, 0x973c016c, 0x00000000}},  //   lneh, жива, _kića,
  { {0x417600a6, 0xbea30a78, 0x8d5a0fd8, 0x00000000}},  //   _وابس, дарк, ашат_,
  { {0x63a30004, 0x6d43001a, 0x657b01ee, 0x00000000}},  //   _hinn, _înal, nouh,
  { {0x63a30004, 0x3c66008b, 0xfd1f0011, 0x00000000}},  // [1a40] _kinn, цкаг, _nhìu_,
  { {0x63a3002b, 0x63ab0fd9, 0xbad5007e, 0x00000000}},  //   _jinn, _mugn, зіцы,
  { {0xdce40fda, 0xdca6017a, 0x2d8c0fdb, 0x00000000}},  //   lnič, _мани, ïdes_,
  { {0x63a30004, 0x98a60893, 0x6d4d00b5, 0x00000000}},  //   _linn, циде, chaa,
  { {0xd90d025a, 0x38cb02fd, 0x6b40000c, 0x00000000}},  //   دیق_, شانی_, _lögi,
  { {0xd04e005f, 0x501b0104, 0x1754041f, 0x00000000}},  //   ükəs, יונו, явля,
  { {0xdce4092f, 0x63ab0fdc, 0x5693025f, 0x00000000}},  //   hnič, _augn, машт,
  { {0x6d44010a, 0x7d160fdd, 0x63a30051, 0x00000000}},  //   nkia, ndys, _ainn,
  { {0x63a3049b, 0xfd4f001d, 0xdce40213, 0x00000000}},  //   _binn, _phiế, jnič,
  { {0x63a3002a, 0xdce40466, 0x63ab0006, 0x00000000}},  //   _cinn, dnič, _dugn,
  { {0x62830016, 0x63a300ab, 0x6d4400b0, 0x00000000}},  //   _cyno, _dinn, kkia,
  { {0x63a30fde, 0x62830016, 0x63ab0fdf, 0x00000000}},  //   _einn, _dyno, _fugn,
  { {0x63a30332, 0xfd4f001d, 0x7d16005b, 0x00000000}},  //   _finn, _thiế, ddys,
  { {0x63a30fe0, 0x93770025, 0x26cc00ca, 0x00000000}},  //   _ginn, _وصور_, _jedo_,
  { {0x6d5f005f, 0x26cc0fe1, 0x6d4d0fe2, 0x00000000}},  //   tiqa, _medo_, thaa,
  { {0x63a3095d, 0x91b70167, 0x7c2d002d, 0x00000000}},  //   _zinn, _بطور_, txar,
  { {0x6d4d0fe3, 0x64400142, 0x6f070450, 0x00000000}},  // [1a50] rhaa, nymi, pejc,
  { {0xce95005e, 0x6d4d0020, 0xbcfb0fe4, 0x00000000}},  //   _напъ, shaa, _omég,
  { {0x60cd0169, 0x64400943, 0x2fc90058, 0x00000000}},  //   _keam, hymi, _hwag_,
  { {0x6d440048, 0x64400052, 0x00000000, 0x00000000}},  //   ckia, kymi,   ,
  { {0x880700e9, 0x6d5d002b, 0xb807023c, 0x00000000}},  //   تظام, _imsa, تباه,
  { {0x26cc08e1, 0x60cd0048, 0x644000b4, 0x00000000}},  //   _cedo_, _leam, dymi,
  { {0x63a3002a, 0xdce40142, 0x26cc0d8e, 0x00000000}},  //   _rinn, znič, _dedo_,
  { {0x60cd0fe5, 0x442d0411, 0x63ab0197, 0x00000000}},  //   _neam, txe_, _pugn,
  { {0x65690fe6, 0xb4bb03d7, 0x442d00c4, 0x00000000}},  //   rneh, _अभी_, uxe_,
  { {0x6d44022b, 0x6d930181, 0xaacb007d, 0x00000000}},  //   zkia, lçad, िरिक,
  { {0x63a30635, 0x6d440006, 0x443f0fe7, 0x00000000}},  //   _vinn, ykia, syu_,
  { {0x6d9309f7, 0xdce40091, 0x63a30fe8, 0x00000000}},  //   nçad, tnič, _winn,
  { {0x63a30fe9, 0x82350014, 0x62830036, 0x00000000}},  //   _tinn, زرگا, _wyno,
  { {0x61e80027, 0xdce40626, 0x6d5d0fea, 0x00000000}},  //   budl, rnič, _amsa,
  { {0x61460feb, 0xdce40209, 0x00000000, 0x00000000}},  //   _нека, snič,   ,
  { {0x60cd001a, 0x78a40247, 0x6d440006, 0x00000000}},  //   _geam, živi, ukia,
  { {0x6d440fec, 0x2fc90016, 0xb05b06d3, 0x00000000}},  // [1a60] rkia, _gwag_, lbän,
  { {0x78a90207, 0x8eea0088, 0x6d44042c, 0x00000000}},  //   _agev, _умов_, skia,
  { {0x26cc0039, 0x64400fed, 0x00000000, 0x00000000}},  //   _redo_, zymi,   ,
  { {0x26cc0133, 0xdb04004a, 0x00000000, 0x00000000}},  //   _sedo_, rpiñ,   ,
  { {0x2d8202cc, 0x0c23007e, 0x26cc008e, 0x00000000}},  //   _ikke_, _змян, _pedo_,
  { {0x6d9300c4, 0xeb97004d, 0x78a90146, 0x00000000}},  //   açad, _ния_, _egev,
  { {0x78ad0825, 0x26cc0fee, 0x945d0036, 0x00000000}},  //   žava, _vedo_, kańs,
  { {0x644000b0, 0xe5a3003b, 0x945d0036, 0x00000000}},  //   tymi, нији, jańs,
  { {0x60cd0035, 0x7bd60fef, 0x26cc0087, 0x00000000}},  //   _ream, nsyu, _tedo_,
  { {0x60cd094e, 0x65600066, 0x39460ff0, 0x00000000}},  //   _seam, simh, lkos_,
  { {0x628701d5, 0x60cd0004, 0x672801d5, 0x00000000}},  //   żjon, _peam, _indj,
  { {0xf8cc03d7, 0x3946010a, 0x673a0ff1, 0x00000000}},  //   ारिय, nkos_, _hotj,
  { {0x60cd008e, 0x39460ff2, 0xa30b00a1, 0x00000000}},  //   _veam, ikos_, _گرنے_,
  { {0x973c016c, 0x6d5d0145, 0x673a0906, 0x00000000}},  //   _mićo, _smsa, _jotj,
  { {0x60cd0ff3, 0xfe700025, 0x6fd90061, 0x00000000}},  //   _team, هدف_, _भटकं,
  { {0x6b40000c, 0x2d58007c, 0x2fc90058, 0x00000000}},  //   _mögu, пись_, _twag_,
  { {0x6b40000c, 0x6728016e, 0x25a60022, 0x00000000}},  // [1a70] _lögu, _ondj, _miol_,
  { {0x2d820ff4, 0x2aab003b, 0x673a012d, 0x00000000}},  //   _ekke_, стао_, _notj,
  { {0x7f3c034e, 0x62860036, 0x442b0011, 0x00000000}},  //   _לעזו, ękow, ̣c_,
  { {0xbcfb0211, 0x39460ff5, 0x6d5d0218, 0x00000000}},  //   _ejér, gkos_, _umsa,
  { {0x6d9300c4, 0xe7390893, 0x2ba70061, 0x00000000}},  //   rçad, жел_, _कंटा,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xf8ae026c, 0x25a600ab, 0x673a01ed, 0x00000000}},  //   اکہ_, _biol_, _dotj,
  { {0xe3b901fb, 0x6b40000c, 0xf99300d3, 0x00000000}},  //   оби_, _dögu, _سبز_,
  { {0x394d0ff6, 0x25a6000a, 0x395f0319, 0x00000000}},  //   _iles_, _diol_, _imus_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x779000a2, 0x25a60ff7, 0x6f0c006b, 0x00000000}},  //   _حیوا, _fiol_, _öncə,
  { {0x69d80181, 0x6b400039, 0xb05b010f, 0x00000000}},  //   ávei, _högt, rbän,
  { {0x657c0010, 0x76430ff8, 0xb05b06d3, 0x00000000}},  //   _írha, lyny, sbän,
  { {0x6265025f, 0x394d0016, 0x25a600f6, 0x00000000}},  //   _овла, _lles_, _ziol_,
  { {0xdef9008b, 0x8fa3007c, 0x945d0036, 0x00000000}},  //   чыў_, таре, pańs,
  { {0xa187005e, 0x00000000, 0x00000000, 0x00000000}},  //   _обща_,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  // [1a80]   ,   ,   ,
  { {0x394d000d, 0x5f06007e, 0x7bd6003f, 0x00000000}},  //   _ales_, _ўзна, rsyu,
  { {0xceb301f8, 0x6b520030, 0x394d0944, 0x00000000}},  //   _בית_, _lægg, _bles_,
  { {0x78ad092f, 0x3946010a, 0x9cb60014, 0x00000000}},  //   žavn, ukos_, _زمست,
  { {0x39460ff9, 0x6b40000c, 0x673a016e, 0x00000000}},  //   rkos_, _sögu, _potj,
  { {0x394d02d5, 0xd5ba0ffa, 0x39460dec, 0x00000000}},  //   _eles_, оси_, skos_,
  { {0x394d00bb, 0xda650025, 0xfbb00044, 0x00000000}},  //   _fles_, _كافي, _ছবিত,
  { {0xb4e800e8, 0x2d800026, 0x00000000, 0x00000000}},  //   बले_, noie_,   ,
  { {0xd90d0167, 0x25a60b50, 0xdc11006b, 0x00000000}},  //   _دین_, _viol_, _məğl,
  { {0x25f6013d, 0x628f0036, 0x00000000, 0x00000000}},  //   _एमपी_, ęcon,   ,
  { {0x6b400073, 0x3b180ffb, 0x21290022, 0x00000000}},  //   _högs, _marq_, _pnah_,
  { {0x056602dc, 0x2d8006f0, 0x2d4700fa, 0x00000000}},  //   _ювен, joie_, _põem_,
  { {0x6d43001a, 0x59ce0061, 0x104b0088, 0x00000000}},  //   _înai, हीतर, іями_,
  { {0x2bb5007d, 0x27e60ffc, 0x00000000, 0x00000000}},  //   _अंबा, iron_,   ,
  { {0x3da7008b, 0x6b4001e5, 0xbf9b01d6, 0x00000000}},  //   драб, _lögs, fwêr,
  { {0x98a4000a, 0x00000000, 0x00000000, 0x00000000}},  //   _anmč_,   ,   ,
  { {0x1eab0025, 0x27e60ed5, 0x00000000, 0x00000000}},  // [1a90] _وادي_, jron_,   ,
  { {0x6ec0001c, 0x27e6005b, 0xa3e6006e, 0x00000000}},  //   वडणु, dron_, _बटन_,
  { {0x27e60211, 0x27e003df, 0x1a65025a, 0x00000000}},  //   eron_, áinn_, ریری_,
  { {0x26de0058, 0x27e60ffd, 0xab5b0095, 0x00000000}},  //   _adto_, fron_, _stüd,
  { {0x7d0d001a, 0x6d4f0026, 0x25be0045, 0x00000000}},  //   meas, _ilca, _attl_,
  { {0xf7730426, 0x7d0d0038, 0xae030061, 0x00000000}},  //   خاص_, leas, _लहान_,
  { {0x27e60211, 0xb9050044, 0x00000000, 0x00000000}},  //   aron_, _বউ_,   ,
  { {0x7d0d001a, 0x00000000, 0x00000000, 0x00000000}},  //   neas,   ,   ,
  { {0xa775007e, 0x99850010, 0xf8b20097, 0x00000000}},  //   _злач, _élő_, _תשמ_,
  { {0x7d0d0051, 0x6b400039, 0x7c20016e, 0x00000000}},  //   heas, _högr, _šmrk,
  { {0x7d0d00b0, 0x26c70059, 0x6d4f0095, 0x00000000}},  //   keas, mbno_, _olca,
  { {0x361a00b6, 0xdb070023, 0x00000000, 0x00000000}},  //   _מועד, _bijë,   ,
  { {0x2d800ffe, 0x7d0d0fff, 0xab640279, 0x00000000}},  //   voie_, deas, lmüş,
  { {0x6d4f0919, 0x6b40009f, 0x3eac0030, 0x00000000}},  //   _alca, _lögr, ødt_,
  { {0x23650039, 0x6b5205b7, 0x2d9602ea, 0x00000000}},  //   milj_, _jæge, ерас,
  { {0x27e60f91, 0x7d0d0657, 0x1de10164, 0x00000000}},  //   yron_, geas, _फिरत,
  { {0x6b520030, 0xed5700ed, 0xec7702ea, 0x00000000}},  // [1aa0] _læge, хот_, епт_,
  { {0x78ad1000, 0x27e6062a, 0x6d4f0efe, 0x00000000}},  //   žavl, vron_, _elca,
  { {0x7d0d0035, 0xeef7009b, 0x817500a1, 0x00000000}},  //   beas, _אמיר_, _سنیچ,
  { {0xcee900a1, 0x7d0d0e5f, 0x00000000, 0x00000000}},  //   _ٹرین_, ceas,   ,
  { {0x58831001, 0x27e60068, 0x00000000, 0x00000000}},  //   лыша, uron_,   ,
  { {0xf093007b, 0x7bc4010a, 0x27e6088d, 0x00000000}},  //   אנד_, mpiu, rron_,
  { {0x3872001a, 0xe1e701fa, 0x06cf0044, 0x00000000}},  //   _ţară_, _حس_, _রাশি,
  { {0x27e61002, 0x85ba00a1, 0x69dc1003, 0x00000000}},  //   pron_, _ہاؤس_, _ivre,
  { {0x8881007a, 0xb6030089, 0xd7ca0025, 0x00000000}},  //   _پیون, āšan, _رواه_,
  { {0x41e601e1, 0x973c016c, 0x778302dc, 0x00000000}},  //   німа, _mićk, _блуз,
  { {0xdb07000a, 0xf6290025, 0x00000000, 0x00000000}},  //   _dijè, _يسمى_,   ,
  { {0x613f0065, 0x29020039, 0xd046006b, 0x00000000}},  //   _pëlq, _ökad_, lakə,
  { {0x2bb50164, 0xe53b009b, 0x7d0d0035, 0x00000000}},  //   _अंधा, _מתאר, veas,
  { {0x7d0d00e0, 0x4ea7007c, 0x69dc1004, 0x00000000}},  //   weas, ерба, _ovre,
  { {0x7d0d001a, 0x3ea50c75, 0xdcfd0066, 0x00000000}},  //   teas, ält_, _jisħ,
  { {0x2bb50309, 0xdcfd0066, 0x3a230085, 0x00000000}},  //   _अंदा, _misħ, _rrjp_,
  { {0x69dc1005, 0xe7cf013d, 0x7d0d1006, 0x00000000}},  // [1ab0] _avre, _सौंप, reas,
  { {0x7d0d0e5f, 0x64c4013e, 0x290400d9, 0x00000000}},  //   seas, lčič, _abma_,
  { {0x7d0d00b0, 0xdcfd0089, 0x26c700ca, 0x00000000}},  //   peas, _eksā, vbno_,
  { {0x64c400ca, 0x20090093, 0x21391007, 0x00000000}},  //   nčič, _kpai_, njsh_,
  { {0x69dc1008, 0x399e00b9, 0xdb0f00fa, 0x00000000}},  //   _evre, _růst_, _lucé,
  { {0x3f830006, 0x00000000, 0x00000000, 0x00000000}},  //   noju_,   ,   ,
  { {0xc8f50265, 0xf7700647, 0xceb40097, 0x00000000}},  //   _извъ, حان_, ניק_,
  { {0xab640279, 0x69c501ac, 0x00000000, 0x00000000}},  //   rmüş, mphe,   ,
  { {0x290f1009, 0x3f830036, 0x00000000, 0x00000000}},  //   mega_, koju_,   ,
  { {0x290f100a, 0x628a068f, 0x3f83007f, 0x00000000}},  //   lega_, _byfo, joju_,
  { {0x2fc0000c, 0x628a0016, 0x63aa0026, 0x00000000}},  //   _stig_, _cyfo, _difn,
  { {0x291d0d16, 0x290f01d9, 0x628a018e, 0x00000000}},  //   ndwa_, nega_, _dyfo,
  { {0x307600e2, 0x61e8100b, 0xc8da009b, 0x00000000}},  //   тунс, ardl, וקרט,
  { {0xdf1501fb, 0x290f006c, 0x2d9900f6, 0x00000000}},  //   льсь, hega_, _ahse_,
  { {0x5ed40055, 0x290f01d9, 0x628a0016, 0x00000000}},  //   _তাদে, kega_, _gyfo,
  { {0x290f100c, 0x00000000, 0x00000000, 0x00000000}},  //   jega_,   ,   ,
  { {0xc4d2007b, 0x290f0004, 0x291d0009, 0x00000000}},  // [1ac0] יגן_, dega_, ddwa_,
  { {0x7bc4007f, 0x00000000, 0x00000000, 0x00000000}},  //   rpiu,   ,   ,
  { {0xe8fa008b, 0xab5b010f, 0xbea601fc, 0x00000000}},  //   дле_, _stüc, _јанк,
  { {0x290f0059, 0x81bc0089, 0xd7e6013a, 0x00000000}},  //   gega_, lvēc, віко,
  { {0xa41c0055, 0x00000000, 0x00000000, 0x00000000}},  //   _তথ্য_,   ,   ,
  { {0x6d93100d, 0xbcfb0224, 0x69d801ca, 0x00000000}},  //   nçan, _jmén, áves,
  { {0x69dc037e, 0x6f03011f, 0x290f00ca, 0x00000000}},  //   _uvre, _önce, bega_,
  { {0x290f0107, 0x38c80123, 0x973c016c, 0x00000000}},  //   cega_, _ساری_, _mići,
  { {0x98a3003b, 0x49170061, 0xa507003b, 0x00000000}},  //   _вите, _नसतो_, тења_,
  { {0x5fdc03d7, 0xdc9b0049, 0xdcfd002b, 0x00000000}},  //   _बिजल, ויפל, _tisħ,
  { {0xe737026b, 0x6d560022, 0x00000000, 0x00000000}},  //   _шеф_, khya,   ,
  { {0xbcfb00f4, 0x27e90e3b, 0x628a0861, 0x00000000}},  //   _amén, šane_, _vyfo,
  { {0x5064012b, 0x3f830d90, 0x442005d7, 0x00000000}},  //   атра, toju_, _éi_,
  { {0x44260435, 0x643b0049, 0x628a0750, 0x00000000}},  //   _iro_, _קעגנ, _tyfo,
  { {0x3f8309a4, 0x00000000, 0x00000000, 0x00000000}},  //   roju_,   ,   ,
  { {0x44260570, 0xf1a4007e, 0x3f83100e, 0x00000000}},  //   _kro_, _крын, soju_,
  { {0x290f100f, 0x9da802dc, 0xdb0f00e5, 0x00000000}},  // [1ad0] vega_, търа_, _ducî,
  { {0x69c500bb, 0x3b54007e, 0x4426005b, 0x00000000}},  //   tphe, акур, _mro_,
  { {0x290f1010, 0x7c26010f, 0x2bdf0316, 0x00000000}},  //   tega_, _erkr, _फटका,
  { {0x69c501ed, 0x00000000, 0x00000000, 0x00000000}},  //   rphe,   ,   ,
  { {0x290f0059, 0x44261011, 0x69c51012, 0x00000000}},  //   rega_, _nro_, sphe,
  { {0x290f0004, 0x77840099, 0x6d4d0ac2, 0x00000000}},  //   sega_, аліз, lkaa,
  { {0x44260ed6, 0x290f1013, 0x7f3c0049, 0x00000000}},  //   _aro_, pega_, ועגו,
  { {0xdb0d0845, 0x7d1d002b, 0x6d4d021e, 0x00000000}},  //   mpañ, _jass, nkaa,
  { {0x442600ca, 0x38600051, 0xb4650014, 0x00000000}},  //   _cro_, úirt_, دگاه,
  { {0x7d1d001f, 0x44261014, 0xdced0091, 0x00000000}},  //   _lass, _dro_, dnač,
  { {0x6d4d021e, 0x44261015, 0xfb160049, 0x00000000}},  //   kkaa, _ero_, אַכט_,
  { {0x44260016, 0x6d4d1016, 0x7d1d0b8a, 0x00000000}},  //   _fro_, jkaa, _nass,
  { {0x442601aa, 0x79890020, 0x656900b0, 0x00000000}},  //   _gro_, _mkew, mieh,
  { {0x06e50044, 0xd6e50044, 0x65690142, 0x00000000}},  //   প্রি, প্রয, lieh,
  { {0x7d1d1017, 0xfce607ca, 0x6d9300f4, 0x00000000}},  //   _bass, лово, rçan,
  { {0x7d1d1017, 0xbacd0044, 0x6d4d1018, 0x00000000}},  //   _cass, _লাগছ, gkaa,
  { {0x5f761019, 0x0c26007e, 0x7d1d01a2, 0x00000000}},  // [1ae0] _مادر, ыман, _dass,
  { {0x6d5601dd, 0x6d4d00b0, 0x656901a2, 0x00000000}},  //   shya, akaa, hieh,
  { {0x7d1d101a, 0x60d600ea, 0x1efb0097, 0x00000000}},  //   _fass, _keym, _אליע,
  { {0x7d1d0056, 0x6d930181, 0x3940000c, 0x00000000}},  //   _gass, nçal, ðis_,
  { {0x6f1e0047, 0x48e30605, 0x65690190, 0x00000000}},  //   _kapc, сочв, dieh,
  { {0x7c24101b, 0x77910167, 0xe737005e, 0x00000000}},  //   mvir, قیقا, леч_,
  { {0xdced0161, 0x7c2401e5, 0x7d1d01a3, 0x00000000}},  //   znač, lvir, _yass,
  { {0x4426101c, 0x60d6101d, 0x645b00bb, 0x00000000}},  //   _pro_, _neym, fzui,
  { {0x136a064b, 0x69de101e, 0x7c240211, 0x00000000}},  //   ешни_, lspe, nvir,
  { {0xa3e503d7, 0xbcfb00f4, 0x07a6012b, 0x00000000}},  //   _फिर_, _amél, _сазн,
  { {0xe1350057, 0x929400c0, 0xa2940245, 0x00000000}},  //   анны, ранц, рані,
  { {0xd257008b, 0x518701f9, 0x4426101f, 0x00000000}},  //   уць_, ѓуна, _tro_,
  { {0x44260059, 0x7d0400eb, 0x6446006c, 0x00000000}},  //   _uro_, dfis, äkid,
  { {0x2b8f001f, 0x6f1e0035, 0x7d1d0207, 0x00000000}},  //   rück_, _capc, _sass,
  { {0xd904026c, 0x7d0400f4, 0x6d4d00b0, 0x00000000}},  //   _ٹی_, ffis, tkaa,
  { {0x62980119, 0x69de05ad, 0x9d181020, 0x00000000}},  //   _izvo, dspe, лост_,
  { {0x81b60055, 0x7d1d0056, 0x69de002d, 0x00000000}},  // [1af0] _ছবি_, _vass, espe,
  { {0x7d1d001f, 0x6569001f, 0x6d4d021e, 0x00000000}},  //   _wass, zieh, skaa,
  { {0x7d1d01bc, 0x69de0479, 0xda1500ed, 0x00000000}},  //   _tass, gspe, рдењ,
  { {0xe0e70044, 0x973c016c, 0xdce40036, 0x00000000}},  //   গ্রহ_, _miću, knię,
  { {0x6d9309f7, 0x69de0035, 0xdb0d004a, 0x00000000}},  //   nçam, aspe, spañ,
  { {0x6d58010a, 0x69de0048, 0x99d7002c, 0x00000000}},  //   _įvai, bspe, _مترا,
  { {0xb8db0055, 0xf8c900f4, 0x764a005b, 0x00000000}},  //   _আজ_, _créé_, gyfy,
  { {0x79a401f9, 0x7bdf0ddb, 0x00000000, 0x00000000}},  //   _груе, osqu,   ,
  { {0x65690193, 0xdb0f008e, 0x7bdf01a2, 0x00000000}},  //   rieh, _lucí, nsqu,
  { {0xe7871021, 0x60d6013f, 0x7bdf0181, 0x00000000}},  //   _субо, _seym, isqu,
  { {0x7d04000c, 0x291f006c, 0x60d60173, 0x00000000}},  //   yfis, _kaua_, _peym,
  { {0xc4f80025, 0x216a030d, 0x63a10022, 0x00000000}},  //   _معها_, тими_, smln,
  { {0xb4c302fb, 0x6d93005d, 0x291f0020, 0x00000000}},  //   ्री_, rçal, _maua_,
  { {0x2d8b0224, 0x69de01d6, 0x291f1022, 0x00000000}},  //   _akce_, yspe, _laua_,
  { {0x7d040332, 0x69de098e, 0xbea61023, 0x00000000}},  //   tfis, xspe, равк,
  { {0x7c24010a, 0x27e00f3a, 0x69de02e7, 0x00000000}},  //   tvir, šini_, vspe,
  { {0xab66008b, 0x7d04009f, 0xdee60242, 0x00000000}},  // [1b00] авал, rfis, _копи,
  { {0x7c24037e, 0x69de0a74, 0x68fb1024, 0x00000000}},  //   rvir, tspe, _acud,
  { {0xbd8a0188, 0x399c002a, 0x7d0400ea, 0x00000000}},  //   _لندن_, híse_, pfis,
  { {0x06cf0044, 0x6d43001a, 0xc7c6004d, 0x00000000}},  //   _রাগি, _înap, аски,
  { {0x779402fd, 0x27e00051, 0xdb0d000c, 0x00000000}},  //   میرا, éin_, ppað,
  { {0x2d921025, 0x18670467, 0x00000000, 0x00000000}},  //   llye_, шачи_,   ,
  { {0xdb0e0065, 0x06d80044, 0x09e30867, 0x00000000}},  //   _libë, _সাদি, _морн,
  { {0x27e9001e, 0xa5340c24, 0x399c0051, 0x00000000}},  //   šana_, снич, físe_,
  { {0x362400a1, 0xc955007e, 0x00000000, 0x00000000}},  //   _گواہ, _утры,   ,
  { {0x316b0036, 0x394400f6, 0xb35402b8, 0x00000000}},  //   wicz_, _homs_, скош,
  { {0x7c29002b, 0xe81e006e, 0x44e80044, 0x00000000}},  //   _ġerm, पिका_, ক্ষক_,
  { {0x26dc0ecf, 0x7bc60091, 0x8c48005d, 0x00000000}},  //   lavo_, _otku, _kağı,
  { {0x39440193, 0xb4d202d2, 0x1b1d0044, 0x00000000}},  //   _moms_, वरी_, নাতে_,
  { {0x200501d5, 0x26dc0006, 0x6d9300d4, 0x00000000}},  //   ċli_, navo_, rçam,
  { {0x139b0104, 0x539b009b, 0xc1790006, 0x00000000}},  //   _שבוע, _שיוו, urės_,
  { {0x39440fdb, 0x5d781026, 0x00000000, 0x00000000}},  //   _noms_, айся_,   ,
  { {0x60dd0058, 0x8c48006b, 0x31690032, 0x00000000}},  // [1b10] masm, _nağı, _imaz_,
  { {0x7bdf00f4, 0x68fb0207, 0x26dc0059, 0x00000000}},  //   rsqu, _scud, javo_,
  { {0x26dc0006, 0x6f15008e, 0x49b80439, 0x00000000}},  //   davo_, mezc, لاند_,
  { {0xdb0e1027, 0x8c48005d, 0x3944009d, 0x00000000}},  //   _libè, _bağı, _coms_,
  { {0xdc3500bd, 0x394400ea, 0x27ff009d, 0x00000000}},  //   _האָט_, _doms_, _qqun_,
  { {0x8c48005d, 0x26dc0006, 0xf3fe0044, 0x00000000}},  //   _dağı, gavo_, ্টার_,
  { {0xcf580104, 0x6b520190, 0xb34500fa, 0x00000000}},  //   שבות_, _mægl, _loçã,
  { {0xb4c301f5, 0x74150025, 0x5e78009b, 0x00000000}},  //   ्रे_, موعا, יתון_,
  { {0x69c70182, 0x26dc0059, 0x212009e4, 0x00000000}},  //   _htje, bavo_, _raih_,
  { {0x26dc1028, 0x43740088, 0xda0e007d, 0x00000000}},  //   cavo_, жуют, _सहमत_,
  { {0xe6950054, 0x6f15008e, 0x00000000, 0x00000000}},  //   _الاد, dezc,   ,
  { {0xf65201f8, 0x67211029, 0x8c480279, 0x00000000}},  //   _מצב_, _halj, _yağı,
  { {0x672103b6, 0xc882006b, 0x5fb80061, 0x00000000}},  //   _kalj, _peşə_, _आढळल,
  { {0x20020770, 0x69c70243, 0x00000000, 0x00000000}},  //   rtki_, _otje,   ,
  { {0xed5a102a, 0x6721003b, 0x2002102b, 0x00000000}},  //   гов_, _malj, stki_,
  { {0x26dc102c, 0x20020022, 0xc212009b, 0x00000000}},  //   zavo_, ptki_, _זהה_,
  { {0x39440299, 0x0ab60025, 0x69c70023, 0x00000000}},  // [1b20] _roms_, محاد, _atje,
  { {0xef1a012b, 0x6721102d, 0x3944049b, 0x00000000}},  //   _смо_, _nalj, _soms_,
  { {0x26dc0006, 0x2601004a, 0x316901c3, 0x00000000}},  //   vavo_, jóo_, _ymaz_,
  { {0xb4c30316, 0xd9100167, 0x69c3102e, 0x00000000}},  //   ्रो_, بیر_, ínea,
  { {0x67210107, 0xdb0e00f4, 0x2be2013d, 0x00000000}},  //   _balj, _libé, _पिटा,
  { {0xa09b061e, 0x06d80055, 0x7d160c87, 0x00000000}},  //   ניסט, _সাহি, leys,
  { {0x26dc102f, 0x6d46002d, 0x67210340, 0x00000000}},  //   ravo_, _koka, _dalj,
  { {0x6d460234, 0x7d161030, 0x26dc0059, 0x00000000}},  //   _joka, neys, savo_,
  { {0x6d460006, 0x67210065, 0x6843007c, 0x00000000}},  //   _moka, _falj, _ента,
  { {0x69c1028c, 0x8c1b009b, 0x60c40173, 0x00000000}},  //   _élec, נויי, _afim,
  { {0x60dd002d, 0x6d460007, 0x7179013b, 0x00000000}},  //   tasm, _ooka, ибор_,
  { {0x6d461031, 0x67211032, 0x27e00091, 0x00000000}},  //   _noka, _zalj, šinu_,
  { {0xd46705b5, 0xc05803e8, 0x60dd01a3, 0x00000000}},  //   _лице_, бір_, rasm,
  { {0xc0580245, 0x60c40146, 0x2bdb013d, 0x00000000}},  //   сію_, _efim, मीफा,
  { {0x6f150211, 0x6d9300d4, 0x00000000, 0x00000000}},  //   rezc, lçai,   ,
  { {0x22ae005f, 0x2b940210, 0x00000000, 0x00000000}},  //   mək_, bäck_,   ,
  { {0x69c71033, 0x6d93028c, 0x6d460213, 0x00000000}},  // [1b30] _stje, nçai, _doka,
  { {0x8aa70423, 0x69c7012d, 0x3f8a00d0, 0x00000000}},  //   бред, _ptje, cobu_,
  { {0x2bb501f5, 0x22ae013f, 0x2b5800e5, 0x00000000}},  //   _अंका, nək_, _dlrc_,
  { {0x6721037e, 0x6dbc0091, 0x75220027, 0x00000000}},  //   _salj, _očaj, _naoz,
  { {0x672108b2, 0x387f0066, 0xf74501ab, 0x00000000}},  //   _palj, _qxur_, жело,
  { {0x27e91034, 0x7bcd1035, 0xdb07004a, 0x00000000}},  //   šano_, mpau, _fijá,
  { {0x672101cd, 0x6723037e, 0x69c70182, 0x00000000}},  //   _valj, rdnj, _utje,
  { {0x22ae006b, 0xdb0e0923, 0x6b52000c, 0x00000000}},  //   dək_, _ribé, _nægj,
  { {0xe3b61036, 0x6721002b, 0x27e0002a, 0x00000000}},  //   обы_, _talj, áint_,
  { {0x798b005b, 0x98ad0142, 0xd6d800e2, 0x00000000}},  //   logw, _hneď_, _гтц_,
  { {0xe2990200, 0x442700d3, 0xd064006b, 0x00000000}},  //   ран_, _گراف, ərəs,
  { {0xe43504e8, 0x75220288, 0x00000000, 0x00000000}},  //   _وفاد, _gaoz,   ,
  { {0x6d461037, 0x2bb501f5, 0x656b0066, 0x00000000}},  //   _roka, _अंगा, _imgh,
  { {0x6d461038, 0xbf9b02d5, 0x83fd0010, 0x00000000}},  //   _soka, stên, rződ,
  { {0x22ae005f, 0x7d16021e, 0x3f8a0161, 0x00000000}},  //   cək_, teys, robu_,
  { {0x2fc90009, 0x2b9401a2, 0x3f8a0941, 0x00000000}},  //   _ftag_, päck_, sobu_,
  { {0xed5700ed, 0x7bcd011c, 0x7d161039, 0x00000000}},  // [1b40] цот_, gpau, reys,
  { {0x68e9014a, 0x6d460036, 0x290d0035, 0x00000000}},  //   _aded, _woka, _abea_,
  { {0x32050038, 0x6d46103a, 0xc8ca01af, 0x00000000}},  //   ntly_, _toka, لوان_,
  { {0xc27a0049, 0x25ef0061, 0x798b103b, 0x00000000}},  //   ברעי, ींनी_, gogw,
  { {0x68e9103c, 0x88160558, 0x57a600e2, 0x00000000}},  //   _dded, تباط, ошка,
  { {0x05ea103d, 0x68e90009, 0xe3a70355, 0x00000000}},  //   афии_, _eded, _زر_,
  { {0xd6d9103e, 0xd5b70057, 0xda0e03d7, 0x00000000}},  //   сті_, осы_, _सहित_,
  { {0x7c2904eb, 0x15d9009e, 0x00000000, 0x00000000}},  //   _šeri, حدوں_,   ,
  { {0x8d5b0049, 0xe0df01aa, 0x1b1d0044, 0x00000000}},  //   יכקי, chòy_, নারে_,
  { {0x46a6008b, 0xc7b90010, 0xd7640167, 0x00000000}},  //   _дазв, _erős_, _عنای,
  { {0x2fc9103f, 0x2b94010f, 0x3abb00a0, 0x00000000}},  //   _stag_, räch_, ימינ,
  { {0x81bc001e, 0x22ae005f, 0x6d9300f6, 0x00000000}},  //   lvēk, rək_, lçav,
  { {0x32050133, 0x22ae006b, 0x00000000, 0x00000000}},  //   atly_, sək_,   ,
  { {0xdefb008b, 0x6d930a06, 0x7c3b00f6, 0x00000000}},  //   шым_, nçav, _àuri,
  { {0xd2500054, 0x320500ab, 0x2cb0006b, 0x00000000}},  //   _سنة_, ctly_, əndə_,
  { {0x8d7700a1, 0x2fc90009, 0x5cb9007e, 0x00000000}},  //   زازا, _ttag_, слаў_,
  { {0x4c94007c, 0x0cab0d15, 0x00000000, 0x00000000}},  // [1b50] дитс, ртви_,   ,
  { {0x69c3004a, 0x88d70044, 0x00000000, 0x00000000}},  //   íneo, _হাইক,   ,
  { {0x39150242, 0x7bcd0006, 0x0a680751, 0x00000000}},  //   змер, spau, орци_,
  { {0x7bcd0052, 0x9b450014, 0x628e00b4, 0x00000000}},  //   ppau, _کنسو, żbow,
  { {0xdd3a009b, 0x798b1040, 0x00000000, 0x00000000}},  //   _הערכ, rogw,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xd90f026c, 0x80dc0044, 0xb9010044, 0x00000000}},  //   _لیا_, _ভাস্, _দা_,
  { {0xea000011, 0xab5b01a2, 0x00000000, 0x00000000}},  //   _hiếp_, _stüh,   ,
  { {0x657e00f4, 0xb7d503ec, 0xf3f10025, 0x00000000}},  //   épha, _رقاب, رأة_,
  { {0xdce4014a, 0x00000000, 0x00000000, 0x00000000}},  //   kniğ,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x9f420802, 0x320500ab, 0x00000000, 0x00000000}},  //   mské_, rtly_,   ,
  { {0x9f4201ca, 0x320500ab, 0x232900aa, 0x00000000}},  //   lské_, stly_, _голи_,
  { {0x443f002b, 0x13a700a1, 0x00000000, 0x00000000}},  //   mxu_, _بنتی_,   ,
  { {0x9f42004f, 0x6da60bbd, 0xd24e023c, 0x00000000}},  //   nské_, зива, _منو_,
  { {0xf8b90011, 0x657b1041, 0x442f0145, 0x00000000}},  //   _ngũ_, nnuh, _krg_,
  { {0x27e907a0, 0x442f00d9, 0x81a5023c, 0x00000000}},  // [1b60] šanj_, _jrg_, _تحول,
  { {0x8b26008b, 0x7d0f0061, 0xed160036, 0x00000000}},  //   ядзе, _ebcs, _łódź_,
  { {0x2d9e00d4, 0x69da0025, 0x442f0d96, 0x00000000}},  //   ïtes_, صباح_, _lrg_,
  { {0x442f1042, 0xa6d80044, 0x9f4201ca, 0x00000000}},  //   _org_, _সাইট, dské_,
  { {0x181800a2, 0x3eba012d, 0x00000000, 0x00000000}},  //   تراک_, _kgpt_,   ,
  { {0xbb4a0054, 0x7bcb056b, 0xf8af00a1, 0x00000000}},  //   _الآن_, ígue, اکِ_,
  { {0x442f00f8, 0x6b52000c, 0x00000000, 0x00000000}},  //   _arg_, _nægi,   ,
  { {0x6d440169, 0xceb300b3, 0xd90d0167, 0x00000000}},  //   njia, עיה_, _نیم_,
  { {0x9f590073, 0x00000000, 0x00000000, 0x00000000}},  //   ltså_,   ,   ,
  { {0x325400ed, 0x442f1043, 0xdb1d0181, 0x00000000}},  //   двор, _drg_, _ausê,
  { {0x442f015c, 0x27e61044, 0x98bf0066, 0x00000000}},  //   _erg_, lson_, _qmuħ_,
  { {0x463b0049, 0x443f0009, 0x55bb009b, 0x00000000}},  //   _לעבע, bxu_, _המאו,
  { {0x26de008d, 0x24aa0055, 0xdb050051, 0x00000000}},  //   _keto_, _গ্রহ, smhé,
  { {0x27e6028c, 0xd370007a, 0xbf9b009d, 0x00000000}},  //   ison_, _جهت_, ptêm,
  { {0x80dc0044, 0x26de0d94, 0x2cb90022, 0x00000000}},  //   _ভার্, _meto_, _pgsd_,
  { {0x5d99008b, 0x26de086e, 0xebd9005e, 0x00000000}},  //   ікаў_, _leto_, ждаш_,
  { {0x27e6016c, 0x61fa1045, 0x7bc0009d, 0x00000000}},  // [1b70] json_, lutl, _émul,
  { {0x8aa70072, 0x26de0181, 0x6d5f1046, 0x00000000}},  //   пред, _neto_, shqa,
  { {0x98bf001a, 0x61fa1047, 0x7c290066, 0x00000000}},  //   _nouă_, nutl, _ġeru,
  { {0x1a6801ef, 0x0dba00a1, 0x27e61048, 0x00000000}},  //   سیقی_, _گئیں_, fson_,
  { {0xea00001d, 0x26de1049, 0x7d0d0093, 0x00000000}},  //   _tiếp_, _beto_, mfas,
  { {0x7c2d021a, 0x9f420161, 0x49bb03ec, 0x00000000}},  //   mvar, tské_, _هارد_,
  { {0x442f063e, 0x68e201ee, 0xe708023c, 0x00000000}},  //   _srg_, baod, ستون_,
  { {0x9f42004f, 0x98bf000d, 0x53c90175, 0x00000000}},  //   rské_, _două_, огим_,
  { {0xb4bd001c, 0x7c2d104a, 0xbcfb0010, 0x00000000}},  //   _आली_, nvar, _elég,
  { {0x04ff0055, 0x9f4201dc, 0xdb1d0039, 0x00000000}},  //   ্যের_, pské_, _utsä,
  { {0x6d5d005d, 0x7d0d01c3, 0x7c2d104b, 0x00000000}},  //   _olsa, kfas, hvar,
  { {0x442f0059, 0x65600051, 0x5455104c, 0x00000000}},  //   _trg_, chmh, _овет,
  { {0x7d0d0190, 0x442f0085, 0x63a30022, 0x00000000}},  //   dfas, _urg_, _thnn,
  { {0xdfcf0054, 0x6d5d00f4, 0x442d0023, 0x00000000}},  //   شيف_, _alsa, mve_,
  { {0x7c2d0006, 0x7d0d104d, 0x00000000, 0x00000000}},  //   evar, ffas,   ,
  { {0x75290047, 0x78bb000b, 0x27e60ca4, 0x00000000}},  //   ndez, _nguv, yson_,
  { {0xdced0521, 0x442d0023, 0x6d440022, 0x00000000}},  // [1b80] znać, nve_, rjia,
  { {0x6d5d0232, 0xda660025, 0xeb9f0056, 0x00000000}},  //   _elsa, واضي, _spør_,
  { {0x0f5701f8, 0x27e60ca4, 0x26de008e, 0x00000000}},  //   _חיים_, wson_, _reto_,
  { {0x442d0119, 0x98a00059, 0x26de104e, 0x00000000}},  //   kve_, žič_, _seto_,
  { {0xa3f80055, 0x442d104f, 0x75290026, 0x00000000}},  //   _অন্য_, jve_, ddez,
  { {0x442d07fd, 0x6f1c005b, 0x6446006c, 0x00000000}},  //   dve_, nerc, äkim,
  { {0xe1e7009c, 0x442d00b5, 0x26de0052, 0x00000000}},  //   _جس_, eve_, _veto_,
  { {0x27e60c0d, 0x6f1c0161, 0x6d9300f6, 0x00000000}},  //   pson_, herc, lçar,
  { {0xea000011, 0x26de1050, 0x6f1c0232, 0x00000000}},  //   _khắp_, _teto_, kerc,
  { {0x6d930a0a, 0x6f1c00ca, 0x68e0014a, 0x00000000}},  //   nçar, jerc, _hemd,
  { {0x6f1c1051, 0x442d0207, 0x7d0d014a, 0x00000000}},  //   derc, ave_, yfas,
  { {0x39461052, 0x67280e61, 0x2fc0054c, 0x00000000}},  //   njos_, _hadj, _buig_,
  { {0x442d1053, 0x38660b41, 0x6f1c005b, 0x00000000}},  //   cve_, nzor_, ferc,
  { {0x6f1c1054, 0x61fa067c, 0x7c2d013f, 0x00000000}},  //   gerc, putl, vvar,
  { {0x67280065, 0x7d0d0066, 0x6e94007c, 0x00000000}},  //   _madj, tfas, виру,
  { {0xbcfb1055, 0x67280059, 0x2fc000d4, 0x00000000}},  //   _amér, _ladj, _fuig_,
  { {0x6f1c05d2, 0x7d0d001f, 0x25a60048, 0x00000000}},  // [1b90] berc, rfas, _mhol_,
  { {0x7c2d06a1, 0x6f1c1056, 0x6728037e, 0x00000000}},  //   rvar, cerc, _nadj,
  { {0x442d1057, 0xfe350049, 0x00000000, 0x00000000}},  //   zve_, _װאָך_,   ,
  { {0xb4bd001c, 0x8aa40242, 0x673a1058, 0x00000000}},  //   _आले_, труд, _antj,
  { {0xdd91026c, 0xe739008b, 0x27e91059, 0x00000000}},  //   _لوگ_, зел_, éan_,
  { {0x25a60047, 0x9f59009d, 0x442d00f8, 0x00000000}},  //   _ahol_, fusé_, vve_,
  { {0xf77001fa, 0xe61100a2, 0x69dc0016, 0x00000000}},  //   جان_, اشت_, _gwre,
  { {0x442d03f7, 0x94250893, 0x6f1c0428, 0x00000000}},  //   tve_, емие, zerc,
  { {0x442d0c60, 0x75290010, 0x291d105a, 0x00000000}},  //   uve_, rdez, mewa_,
  { {0x442d0004, 0x291d000b, 0x1b1d0055, 0x00000000}},  //   rve_, lewa_, নাকে_,
  { {0x63b8037e, 0x442d105b, 0x6f1c014a, 0x00000000}},  //   _divn, sve_, verc,
  { {0x6f1c0061, 0x2fc00129, 0x6728016c, 0x00000000}},  //   werc, _puig_, _zadj,
  { {0x394d0343, 0xdbd701c2, 0x6f1c0781, 0x00000000}},  //   _moes_, _jäät, terc,
  { {0x7ae504cb, 0x291d00e7, 0xdb1d009d, 0x00000000}},  //   jaht, hewa_, _fusé,
  { {0x291d0020, 0x42520355, 0x6298007f, 0x00000000}},  //   kewa_, _منور, _gyvo,
  { {0x6f1c059a, 0xb4bd0061, 0x2fc00058, 0x00000000}},  //   serc, _आलो_, _tuig_,
  { {0x6f1c04cb, 0xac86105c, 0xa802006b, 0x00000000}},  // [1ba0] perc, хгал, _çıxd,
  { {0xe625001d, 0x395f06ed, 0x6b520030, 0x00000000}},  //   _đông_, _alus_, _nægt,
  { {0x672801f3, 0xfce6012b, 0x68e0023a, 0x00000000}},  //   _radj, _поно, _pemd,
  { {0x8c4607e1, 0x707700a6, 0x67280059, 0x00000000}},  //   _земе, _آمیز_, _sadj,
  { {0x394d0975, 0x2d800036, 0xea000082, 0x00000000}},  //   _does_, mnie_, _thắp_,
  { {0x2d800046, 0x7c260213, 0x25ad0066, 0x00000000}},  //   lnie_, _iskr, emel_,
  { {0x56930407, 0xfaa3091b, 0x395f01d5, 0x00000000}},  //   лашт, _баро, _flus_,
  { {0xa5340216, 0x394d00ab, 0x2d800aba, 0x00000000}},  //   тнич, _goes_, nnie_,
  { {0x63b80161, 0x6728105d, 0x6b520146, 0x00000000}},  //   _pivn, _tadj, _fægt,
  { {0x2d800007, 0x3f85016c, 0xd62a00ed, 0x00000000}},  //   hnie_, čluk_, _нозе_,
  { {0x7d060073, 0x3f9100b9, 0x2d920173, 0x00000000}},  //   _ocks, vozu_, koye_,
  { {0xea00001d, 0x25d9007a, 0x2d800036, 0x00000000}},  //   _nhập_, _آهنگ_, jnie_,
  { {0x2d800046, 0xe5a3004d, 0x00000000, 0x00000000}},  //   dnie_, _сици,   ,
  { {0x2d800046, 0x291d105e, 0x21290022, 0x00000000}},  //   enie_, zewa_, _waah_,
  { {0xbe88007c, 0x7c26105f, 0x3da70745, 0x00000000}},  //   есте_, _askr, ераб,
  { {0x2d801060, 0x44260058, 0x2d920dfc, 0x00000000}},  //   gnie_, _kso_, goye_,
  { {0x7ae501c2, 0x4426012d, 0xab64014a, 0x00000000}},  // [1bb0] taht, _jso_, klüğ,
  { {0x6d5a008d, 0x4426001c, 0x2d800832, 0x00000000}},  //   ëtar, _mso_, anie_,
  { {0x395f032c, 0xf7710167, 0x2d920061, 0x00000000}},  //   _plus_, یات_, boye_,
  { {0x4426022b, 0xdbd7021e, 0x2d800036, 0x00000000}},  //   _oso_, _päät, cnie_,
  { {0x7ae5021e, 0xbcfb0211, 0x44261061, 0x00000000}},  //   paht, _eléc, _nso_,
  { {0x394d0343, 0x6d4f014a, 0x291d01a3, 0x00000000}},  //   _woes_, _hoca, sewa_,
  { {0x291d000b, 0x4426011c, 0x6d4f014a, 0x00000000}},  //   pewa_, _aso_, _koca,
  { {0x44261062, 0x1da7013d, 0x6d4f00d9, 0x00000000}},  //   _bso_, _कीमत, _joca,
  { {0x6d4f01ee, 0x42d5007e, 0x44261063, 0x00000000}},  //   _moca, кіну, _cso_,
  { {0x2d800ef2, 0x6b52000c, 0x60cd0082, 0x00000000}},  //   znie_, _hægr, _afam,
  { {0x44260b3c, 0x36d4007c, 0x31600c8f, 0x00000000}},  //   _eso_, _сохр, _pliz_,
  { {0x27e9001e, 0x29020039, 0x6d4f016e, 0x00000000}},  //   šanu_, _ökat_, _noca,
  { {0xd24e0167, 0x44260087, 0x2d920068, 0x00000000}},  //   منی_, _gso_, voye_,
  { {0x6b52000c, 0x2d800652, 0x636400f6, 0x00000000}},  //   _lægr, wnie_, _cònd,
  { {0x2d800046, 0x7c290107, 0xdee3007c, 0x00000000}},  //   tnie_, _šerp, роси,
  { {0xc5f20049, 0xab64014a, 0x2d8000d9, 0x00000000}},  //   ידל_, zlüğ, unie_,
  { {0x2d800036, 0x81bc01c5, 0x00000000, 0x00000000}},  // [1bc0] rnie_, svēt,   ,
  { {0x2d800036, 0xab5b010f, 0x998d0936, 0x00000000}},  //   snie_, _stür, _češ_,
  { {0x6d4f002a, 0x6dbc0cd6, 0xea000011, 0x00000000}},  //   _foca, _včas, _thập_,
  { {0x6d4f1064, 0x00000000, 0x00000000, 0x00000000}},  //   _goca,   ,   ,
  { {0xf74601b3, 0x7c260166, 0x4c83005e, 0x00000000}},  //   кедо, _uskr, _вляв,
  { {0x7d04011f, 0x7bd61065, 0x6d4f004a, 0x00000000}},  //   lgis, mpyu, _zoca,
  { {0x27ed00b1, 0xab64014a, 0x1602013d, 0x00000000}},  //   _even_, rlüğ, रंधर_,
  { {0x6d4f1066, 0x4426007f, 0x00000000, 0x00000000}},  //   _xoca, _pso_,   ,
  { {0x7c24010f, 0xd3a601ee, 0x00000000, 0x00000000}},  //   nwir, кроп,   ,
  { {0x44260059, 0x80dc0044, 0x60cd0026, 0x00000000}},  //   _vso_, _ভাগ্, _sfam,
  { {0xd5af007c, 0x81bc0089, 0xa266005e, 0x00000000}},  //   _вс_, evēr, тъпл,
  { {0x7c240a37, 0x9257007c, 0x44261067, 0x00000000}},  //   kwir, тают_, _tso_,
  { {0x4426049a, 0x6d4f06c2, 0x250b00a1, 0x00000000}},  //   _uso_, _roca, _آرمی_,
  { {0x6d4f0035, 0x7c24004a, 0xc7b40049, 0x00000000}},  //   _soca, dwir, רבֿ_,
  { {0x6d4f1068, 0x798200ab, 0xd3781069, 0x00000000}},  //   _poca, know, mić_,
  { {0xd3781069, 0x7d040a8e, 0x79820046, 0x00000000}},  //   lić_, ggis, jnow,
  { {0x7c24106a, 0xd0110025, 0x6c54030d, 0x00000000}},  // [1bd0] gwir, _الخ_, акту,
  { {0xd378106b, 0x31790036, 0x765800b0, 0x00000000}},  //   nić_, lisz_, kyvy,
  { {0xdb05002a, 0x27ed0039, 0x6d4f00d6, 0x00000000}},  //   gmhá, _sven_, _toca,
  { {0x7c240061, 0xd3780107, 0x6d4f016c, 0x00000000}},  //   bwir, hić_, _uoca,
  { {0x9f4201ca, 0xd3780091, 0xbcfb0051, 0x00000000}},  //   lská_, kić_, _gléa,
  { {0xd3780091, 0x628a00ab, 0x00000000, 0x00000000}},  //   jić_, _oxfo,   ,
  { {0x2d550018, 0x9f4206b8, 0xd3780091, 0x00000000}},  //   _fået_, nská_, dić_,
  { {0x2d550030, 0xdb1d0428, 0xceb400a0, 0x00000000}},  //   _gået_, _musí, סיק_,
  { {0xd378106c, 0xa898106d, 0xe7050014, 0x00000000}},  //   fić_, _акту_, _مسای,
  { {0x65620007, 0x29020039, 0xd3780091, 0x00000000}},  //   _eloh, _ökar_, gić_,
  { {0x3f830091, 0x2fd20007, 0x752b0032, 0x00000000}},  //   dnju_, _styg_, _tagz,
  { {0x7412007a, 0xf5300025, 0xd4350070, 0x00000000}},  //   جویا, _وإن_, _معتب,
  { {0xd378106e, 0x628a106f, 0x44240016, 0x00000000}},  //   bić_, _exfo, cwm_,
  { {0xd3781070, 0x2d991071, 0x00000000, 0x00000000}},  //   cić_, _akse_,   ,
  { {0x31791072, 0x79820036, 0x81bd0089, 0x00000000}},  //   bisz_, ynow, rvēr,
  { {0x7c240503, 0xbcfb0051, 0x81bd0089, 0x00000000}},  //   twir, _pléa, svēr,
  { {0x09cc001c, 0x3f830fcd, 0xeafa0025, 0x00000000}},  // [1be0] ाऱ्य, bnju_, فرات_,
  { {0xfbcd0055, 0x7c241073, 0x3f83016c, 0x00000000}},  //   _লিখত, rwir, cnju_,
  { {0x79820061, 0xe8fa1074, 0x7c241075, 0x00000000}},  //   tnow, еле_, swir,
  { {0xd378106e, 0x786a0010, 0x88e6007c, 0x00000000}},  //   zić_, _növé, ужде,
  { {0xe3c80011, 0x79820036, 0x00000000, 0x00000000}},  //   _mực_, rnow,   ,
  { {0xe3c8001d, 0xa5f81076, 0xdb1c008d, 0x00000000}},  //   _lực_, веку_, _mirë,
  { {0x6b63103e, 0xd37801cd, 0xb90a0055, 0x00000000}},  //   _укра, vić_, _মা_,
  { {0x7bc61077, 0x1db4001c, 0x3f83037e, 0x00000000}},  //   _kuku, ंगित, znju_,
  { {0xa3df001c, 0xd3780166, 0xe644005d, 0x00000000}},  //   धील_, tić_, ılığ,
  { {0x7bc60061, 0x4424018e, 0x06b90044, 0x00000000}},  //   _muku, rwm_, ঁড়ি,
  { {0x7bc61078, 0xd3780363, 0x362400a1, 0x00000000}},  //   _luku, rić_, _خواہ,
  { {0xe3c8001d, 0xd056005f, 0x2906022b, 0x00000000}},  //   _cực_, _heyə, ngoa_,
  { {0xd3781070, 0xf5930054, 0x69c100f4, 0x00000000}},  //   pić_, _النج, _élev,
  { {0x31790036, 0x9f420161, 0x00000000, 0x00000000}},  //   sisz_, tská_,   ,
  { {0x31790046, 0x3f830091, 0xddab1079, 0x00000000}},  //   pisz_, rnju_, етал_,
  { {0x7bc6008d, 0x3f830107, 0x9f420161, 0x00000000}},  //   _buku, snju_, rská_,
  { {0x7bc6107a, 0x3f830243, 0xbb750545, 0x00000000}},  // [1bf0] _cuku, pnju_, агај,
  { {0x7bc6023a, 0x9f420802, 0x332e0066, 0x00000000}},  //   _duku, pská_, _jafx_,
  { {0x0b88003b, 0x00000000, 0x00000000, 0x00000000}},  //   усти_,   ,   ,
  { {0x2d99006c, 0xf1c90082, 0xdc340161, 0x00000000}},  //   _ukse_, _hạc_, _zúča,
  { {0x7bc60061, 0x00000000, 0x00000000, 0x00000000}},  //   _guku,   ,   ,
  { {0x2906002d, 0x6d4d006c, 0x332e002b, 0x00000000}},  //   agoa_, ljaa, _nafx_,
  { {0x2002107b, 0xd056005f, 0x7bc6010f, 0x00000000}},  //   zuki_, _deyə, _zuku,
  { {0xf1c9001d, 0x6d4d107c, 0x69d5107d, 0x00000000}},  //   _lạc_, njaa, _itze,
  { {0x68eb011c, 0xe3c80011, 0x799b107e, 0x00000000}},  //   magd, _rực_, _ikuw,
  { {0x69c7000b, 0x68eb05ad, 0x466b0088, 0x00000000}},  //   _kuje, lagd, _прем_,
  { {0x216a107f, 0x672301d9, 0xdb1c01aa, 0x00000000}},  //   вини_, menj, _dirè,
  { {0x69c70219, 0x672301d9, 0x7c3b01d5, 0x00000000}},  //   _muje, lenj, _ġurn,
  { {0xe3c8001d, 0x660301d5, 0xf1c90011, 0x00000000}},  //   _vực_, lunk, _bạc_,
  { {0x7bc60518, 0x20021080, 0x67231081, 0x00000000}},  //   _ruku, ruki_, nenj,
  { {0x13da08b7, 0x7bc61082, 0x200204cb, 0x00000000}},  //   _দিয়, _suku, suki_,
  { {0x7bc60169, 0x64460039, 0x67231083, 0x00000000}},  //   _puku, åkig, henj,

  { {0x69d5022b, 0x672301d6, 0x68eb011c, 0x00000000}},  // [1c00] _atze, kenj, dagd,
  { {0x672300ee, 0xaaba0167, 0x65691084, 0x00000000}},  //   jenj, ندار_, hheh,
  { {0x672300ee, 0x6da60265, 0x66030006, 0x00000000}},  //   denj, _вина, junk,
  { {0x7bc61085, 0xe3c8001d, 0xd91002fd, 0x00000000}},  //   _tuku, _lựa_, ثیر_,
  { {0x386008cc, 0x65690020, 0x7e97025a, 0x00000000}},  //   áir_, dheh, _منیر_,
  { {0x66030142, 0x67231086, 0x7ae71087, 0x00000000}},  //   funk, genj, _gejt,
  { {0x25fd0164, 0x7aaa0061, 0x66030010, 0x00000000}},  //   रंगी_, _करिअ, gunk,
  { {0x3f980224, 0xa6e90011, 0x74140647, 0x00000000}},  //   horu_, _ngươ, موبا,
  { {0xdb07008e, 0x658800b9, 0x672301a2, 0x00000000}},  //   _gijó, běhn, benj,
  { {0x4aaa001c, 0x67231088, 0x60c41089, 0x00000000}},  //   _कराव, cenj, _agim,
  { {0x69c10047, 0x69c0016a, 0xe3c80011, 0x00000000}},  //   _élet, _kime, _dựa_,
  { {0x69c00f06, 0xf1c90011, 0x2c5e0089, 0x00000000}},  //   _jime, _sạc_, _kādā_,
  { {0xb4c201f5, 0x938a005e, 0x69c00d36, 0x00000000}},  //   ंशी_, _иска_, _mime,
  { {0x69c0000b, 0x09d70055, 0x2bb20061, 0x00000000}},  //   _lime, _হিসা, _जळगा,
  { {0xdef8008b, 0x7ae70010, 0xa1870783, 0x00000000}},  //   шыя_, _rejt, _выпл,
  { {0x6723037e, 0x69c70b94, 0x7ae70010, 0x00000000}},  //   zenj, _ruje, _sejt,
  { {0x69c7028c, 0x6d4d0149, 0x2ac7003b, 0x00000000}},  // [1c10] _suje, rjaa, аљев,
  { {0x69c000f4, 0x6d4d108a, 0x69c700d4, 0x00000000}},  //   _aime, sjaa, _puje,
  { {0x6723002b, 0x69c0065a, 0x7d160009, 0x00000000}},  //   venj, _bime, bfys,
  { {0x69c0108b, 0xdb0f004a, 0x00000000, 0x00000000}},  //   _cime, _pucó,   ,
  { {0x69c0108c, 0x67230a0f, 0x68eb011c, 0x00000000}},  //   _dime, tenj, ragd,
  { {0x6603108d, 0x69c7108e, 0x21cc013e, 0x00000000}},  //   tunk, _tuje, _něho_,
  { {0x6723016c, 0x69c001aa, 0x6569108f, 0x00000000}},  //   renj, _fime, theh,
  { {0x6723037e, 0x99850054, 0x66031090, 0x00000000}},  //   senj, _الرو, runk,
  { {0x681a001e, 0x66031091, 0x67231092, 0x00000000}},  //   gādā, sunk, penj,
  { {0x69c0000b, 0x656900e7, 0xb4e6013d, 0x00000000}},  //   _zime, sheh, _बड़ी_,
  { {0xb6350151, 0xcb1200b3, 0x26c501d6, 0x00000000}},  //   _دفاع, הלי_, _iglo_,
  { {0xd05d006b, 0x261c01f5, 0x3f980036, 0x00000000}},  //   lasə, _महती_, woru_,
  { {0x3f981093, 0x343804e1, 0x68e91094, 0x00000000}},  //   toru_, _پسند_, _meed,
  { {0x68e9006c, 0x98a00091, 0x50d8007d, 0x00000000}},  //   _leed, žić_, _भ्रष,
  { {0xc879001a, 0xbcfb009d, 0x25fd013d, 0x00000000}},  //   _deşi_, _elém, रंटी_,
  { {0x68e90038, 0xbf9b0181, 0x3f980b7d, 0x00000000}},  //   _need, quên, soru_,
  { {0x3f98014a, 0x7ff61095, 0x7d161096, 0x00000000}},  // [1c20] poru_, _اسبا, rfys,
  { {0x69c01097, 0x290d001a, 0x2b4300f6, 0x00000000}},  //   _sime, _acea_, _cnjc_,
  { {0xcf57012e, 0x69c00ac2, 0x627a0049, 0x00000000}},  //   _הבית_, _pime, ְנננ,
  { {0xb4e603d7, 0xea000011, 0x290d00e5, 0x00000000}},  //   _बजे_, _nhấp_, _ccea_,
  { {0x69c00020, 0x68e90133, 0x00000000, 0x00000000}},  //   _vime, _deed,   ,
  { {0xaa46005e, 0x98a40006, 0x681a0089, 0x00000000}},  //   _легл, _namą_, vādā,
  { {0x68e91098, 0x6b630a78, 0x1b7b0049, 0x00000000}},  //   _feed, _экра, _עטלע,
  { {0xea000011, 0x69c01099, 0x2c5e0089, 0x00000000}},  //   _chấp_, _uime, _tādā_,
  { {0x78660057, 0x7c29012d, 0x00000000, 0x00000000}},  //   _указ, _šerz,   ,
  { {0x681a001e, 0x68e900d9, 0x00000000, 0x00000000}},  //   rādā, _zeed,   ,
  { {0x6b9b007b, 0xcb9b00b3, 0x00000000, 0x00000000}},  //   רשיד, רסיט,   ,
  { {0xe5720084, 0x21670f13, 0x00000000, 0x00000000}},  //   _عطا_, стог,   ,
  { {0xf8ba00e8, 0x00000000, 0x00000000, 0x00000000}},  //   ेशिय,   ,   ,
  { {0x25ef0061, 0x995c013e, 0x00000000, 0x00000000}},  //   ींची_, jíž_,   ,
  { {0xf1c9001d, 0x995c00b9, 0x75d101c5, 0x00000000}},  //   _hạn_, díž_, _kāza,
  { {0x2fc90016, 0xf1c90082, 0x00000000, 0x00000000}},  //   _tuag_, _kạn_,   ,
  { {0x68e9109a, 0xd05d005f, 0x3b550069, 0x00000000}},  // [1c30] _reed, yasə, окар,
  { {0xf1c90011, 0x68e9109b, 0x88d20044, 0x00000000}},  //   _mạn_, _seed, ারফক,
  { {0x6aba000c, 0x68e9109c, 0x2d8b00fa, 0x00000000}},  //   _útfl, _peed, _tjce_,
  { {0xad270167, 0x8ed80167, 0xbcfb00b9, 0x00000000}},  //   _اردو, _پذیر_, _mlék,
  { {0xbae80055, 0xf1c90011, 0x68e9017b, 0x00000000}},  //   _পারছ, _nạn_, _veed,
  { {0x7c2f0198, 0x45d500ed, 0xe73901ab, 0x00000000}},  //   _iscr, оцит, рек_,
  { {0x68e9006c, 0x636d0325, 0x27e00089, 0x00000000}},  //   _teed, _húng, ģina_,
  { {0xf1c900ad, 0xf77301ef, 0x160b013d, 0x00000000}},  //   _bạn_, _کار_, संबर_,
  { {0x7c2f0050, 0xf1c90011, 0x972503e6, 0x00000000}},  //   _jscr, _cạn_, _وفرو,
  { {0x6d9301d5, 0x4374041f, 0xf1c90082, 0x00000000}},  //   lħad, зуют, _dạn_,
  { {0xea000011, 0xe12601bd, 0x31690087, 0x00000000}},  //   _thấp_, омни, _blaz_,
  { {0x26130181, 0x2419007c, 0x32050300, 0x00000000}},  //   mão_, _воды_, ruly_,
  { {0x26130181, 0x237e012d, 0x7c2f00e5, 0x00000000}},  //   lão_, bitj_, _nscr,
  { {0x88ba009b, 0x442f01e5, 0x5334007c, 0x00000000}},  //   יזרי, _isg_, _нечт,
  { {0x3ebe0039, 0x26130181, 0x442f109d, 0x00000000}},  //   ätt_, não_, _hsg_,
  { {0x443d0035, 0x7c2f0009, 0xf1c90082, 0x00000000}},  //   _krw_, _bscr, _hạo_,
  { {0x261300c4, 0x636d0048, 0xdca30088, 0x00000000}},  // [1c40] hão_, _cúng, дати,
  { {0x442f03e2, 0x443d004a, 0x8a3a007c, 0x00000000}},  //   _msg_, _mrw_, ияет_,
  { {0x261300c4, 0x2d9e00f4, 0xf1c90011, 0x00000000}},  //   jão_, îtes_, _mạo_,
  { {0x261302d5, 0x8c460478, 0x00000000, 0x00000000}},  //   dão_, _деме,   ,
  { {0x274a109e, 0x443d010f, 0x00000000, 0x00000000}},  //   ичко_, _nrw_,   ,
  { {0x29d70066, 0x261300c4, 0xf1c90082, 0x00000000}},  //   _bħad_, fão_, _nạo_,
  { {0x26130181, 0xf1c90011, 0xc2e80044, 0x00000000}},  //   gão_, _sạn_, _খালি_,
  { {0x5454109f, 0xdb1c00f6, 0x69de00b0, 0x00000000}},  //   звит, _mirí, mppe,
  { {0xf1c90011, 0x186709f1, 0xe9470014, 0x00000000}},  //   _bạo_, _дати_, _ظرفی,
  { {0x2d68011f, 0xf1c910a0, 0x68e200ea, 0x00000000}},  //   rşey_, _vạn_, lbod,
  { {0xf1c90011, 0x26130181, 0x443d0678, 0x00000000}},  //   _dạo_, cão_, _erw_,
  { {0xdb1d010f, 0x68e2054e, 0x443d10a1, 0x00000000}},  //   _zusä, nbod, _frw_,
  { {0xdb1c0051, 0xe73100a1, 0x98c5012d, 0x00000000}},  //   _airí, _غصے_, šuća_,
  { {0x6d46011f, 0xf1c90011, 0x7ada0061, 0x00000000}},  //   _anka, _gạo_, _प्लॅ,
  { {0xcdd8003b, 0xdb1c06c0, 0x00000000, 0x00000000}},  //   жњу_, _cirí,   ,
  { {0xdb1c008e, 0xd657009b, 0x31690091, 0x00000000}},  //   _dirí, חילת_, _ulaz_,
  { {0x26130181, 0x68e210a2, 0x20040129, 0x00000000}},  // [1c50] zão_, dbod, àmit_,
  { {0x69de001c, 0xfaa701fb, 0x8aa706e1, 0x00000000}},  //   fppe, ошен, оред,
  { {0x26130181, 0x539b009b, 0x00000000, 0x00000000}},  //   xão_, סיבו,   ,
  { {0x261300c4, 0x68e210a3, 0xdeb6009b, 0x00000000}},  //   vão_, gbod, _מפתח_,
  { {0x69de0026, 0x9cd600b3, 0xf7450745, 0x00000000}},  //   appe, _מורה_, зело,
  { {0x261302d5, 0x7d0d069e, 0x442f0007, 0x00000000}},  //   tão_, lgas, _rsg_,
  { {0xf9930188, 0x443d016b, 0xe778009e, 0x00000000}},  //   _قبر_, _srw_, تلوں_,
  { {0x261302d5, 0x7d0d0fa2, 0x442f009d, 0x00000000}},  //   rão_, ngas, _psg_,
  { {0x261302d5, 0x7c2d10a4, 0x68fb0058, 0x00000000}},  //   são_, nwar, _idud,
  { {0x26130181, 0x6d9301d5, 0x7c220023, 0x00000000}},  //   pão_, nħab, çori,
  { {0xe2990175, 0x7c2d001f, 0x636d0051, 0x00000000}},  //   сан_, hwar, _rúnd,
  { {0x3a310010, 0x661c006c, 0x225800f8, 0x00000000}},  //   _mszp_, _ärka, ärka_,
  { {0xf1c9001d, 0x81cc0044, 0x645d010f, 0x00000000}},  //   _tạo_, শীল_, äsid,
  { {0x7c2d10a5, 0x442d10a6, 0xdc3a006b, 0x00000000}},  //   dwar, mwe_, xçıv,
  { {0xf2d2007b, 0x442d0007, 0x2ca7006b, 0x00000000}},  //   _טעג_, lwe_, əndi_,
  { {0x7c2d10a7, 0x7d0d0f20, 0x442d0036, 0x00000000}},  //   fwar, ggas, owe_,
  { {0x7c2d01d5, 0xed5700ed, 0x2b580a86, 0x00000000}},  // [1c60] gwar, чот_, _porc_,
  { {0x636d10a8, 0xf1c90011, 0x442d01d6, 0x00000000}},  //   _fúne, _lạm_, iwe_,
  { {0xa92610a9, 0x442d0173, 0x68e20270, 0x00000000}},  //   здел, hwe_, tbod,
  { {0xc7c602a8, 0x31b201ca, 0x442d0020, 0x00000000}},  //   пски, báze_, kwe_,
  { {0x07a60072, 0x442d10aa, 0x68e200b5, 0x00000000}},  //   падн, jwe_, rbod,
  { {0xe3a704e8, 0x501b00b6, 0x656b10ab, 0x00000000}},  //   _سر_, מונו, _algh,
  { {0x442d0343, 0xbcfb0051, 0x68e20009, 0x00000000}},  //   ewe_, _sléi, pbod,
  { {0x6b9e10ac, 0x69ce001a, 0x75290009, 0x00000000}},  //   lopg, _iube, geez,
  { {0x69ce01a2, 0x442d10ad, 0xe3af0014, 0x00000000}},  //   _hube, gwe_, گري_,
  { {0x27f70224, 0x69ce0020, 0xb4bc0061, 0x00000000}},  //   ření_, _kube, _आणी_,
  { {0xcfc40055, 0x7c2d10ae, 0xe3b8005d, 0x00000000}},  //   ্ঠান, zwar, rmı_,
  { {0x79820046, 0x442d0b28, 0x69ce0022, 0x00000000}},  //   niow, bwe_, _mube,
  { {0x69ce0770, 0x434609da, 0xafe4007e, 0x00000000}},  //   _lube, _недв, ноўл,
  { {0x21200022, 0x798200ea, 0x00000000, 0x00000000}},  //   _ebih_, hiow,   ,
  { {0xd788001d, 0x212005fa, 0x798b018e, 0x00000000}},  //   yển_, _fbih_, yngw,
  { {0xbcfb008e, 0x7c2d0652, 0x3a230022, 0x00000000}},  //   _llév, twar, _rpjp_,
  { {0x2d580e09, 0x69dc0779, 0x7d0d01a3, 0x00000000}},  // [1c70] чить_, _atre, rgas,
  { {0x636d10af, 0x212b10b0, 0x69ce0062, 0x00000000}},  //   _túne, lech_, _bube,
  { {0x69ce00d4, 0x200b10b1, 0x442d10b2, 0x00000000}},  //   _cube, luci_, zwe_,
  { {0xfc3f10b3, 0x212b00b9, 0x69ce00b9, 0x00000000}},  //   _trí_, nech_, _dube,
  { {0xf77000d3, 0x2019023e, 0x69ca0b33, 0x00000000}},  //   گان_, ntsi_, ífer,
  { {0xf094007b, 0x3f830213, 0x7bdd0d58, 0x00000000}},  //   ענס_, niju_, _itsu,
  { {0xf7700318, 0x69ce023a, 0x442d0007, 0x00000000}},  //   دان_, _gube, wwe_,
  { {0x442d10b4, 0x79820036, 0x3f8301ee, 0x00000000}},  //   twe_, ciow, hiju_,
  { {0x200b10b5, 0x442d02ae, 0x75290f1d, 0x00000000}},  //   juci_, uwe_, reez,
  { {0xe1f9081e, 0x442d0343, 0xd2f7026c, 0x00000000}},  //   ого_, rwe_, سکتا_,
  { {0x3f830089, 0xf1c90011, 0x7bcf0145, 0x00000000}},  //   diju_, _tạm_, _lucu,
  { {0x290f10b6, 0x7bdd0004, 0xdb1c008e, 0x00000000}},  //   ngga_, _otsu, _mirá,
  { {0xbf9b0181, 0x200b0107, 0x3f8310b7, 0x00000000}},  //   rrên, guci_, fiju_,
  { {0x1b030044, 0x162101f5, 0x3f830091, 0x00000000}},  //   র্তে_, _महार_, giju_,
  { {0x7bcf028c, 0x7bdd007f, 0xad5a09c0, 0x00000000}},  //   _aucu, _atsu, орах_,
  { {0x7bcf000d, 0xc69201ce, 0x2120016c, 0x00000000}},  //   _bucu, דאל_, _ubih_,
  { {0x69dc0027, 0x3f8310b8, 0x672110b9, 0x00000000}},  // [1c80] _stre, biju_, _oblj,
  { {0x3f830bf1, 0x09e6081e, 0x2c0b00a1, 0x00000000}},  //   ciju_, дожн, تعفی_,
  { {0x7bc70169, 0xed5a004d, 0xe9da0140, 0x00000000}},  //   _diju, _дон_, цке_,
  { {0x7aee0007, 0xdb1c008e, 0x6b9e0030, 0x00000000}},  //   _webt, _dirá, sopg,
  { {0x7bcf0009, 0x2baf0164, 0x63a8101b, 0x00000000}},  //   _gucu, _जीवा, yldn,
  { {0x212b0667, 0x798210ba, 0x00000000, 0x00000000}},  //   zech_, siow,   ,
  { {0x69dc10bb, 0x8b0300b9, 0x79820036, 0x00000000}},  //   _utre, _úřad, piow,
  { {0xd826025f, 0x3f8310bc, 0x7434073b, 0x00000000}},  //   _одби, ziju_, ениф,
  { {0x61ea0061, 0x76410016, 0x212b013e, 0x00000000}},  //   _swfl, _erly, vech_,
  { {0xd37000b8, 0x200b0243, 0x212b0016, 0x00000000}},  //   اهد_, vuci_, wech_,
  { {0x212b0224, 0x69c80010, 0x63a80908, 0x00000000}},  //   tech_, _édes, rldn,
  { {0x80fb0309, 0x200b013e, 0x7c260190, 0x00000000}},  //   ्लेख_, tuci_, _opkr,
  { {0x212b0c0f, 0x320500ab, 0x3f830091, 0x00000000}},  //   rech_, arly_, tiju_,
  { {0xa294008b, 0x44260020, 0x212b00b9, 0x00000000}},  //   _палі, _ipo_, sech_,
  { {0x7bcf106f, 0x13e30055, 0x3f830ad8, 0x00000000}},  //   _sucu, _মিয়, riju_,
  { {0x3f8307a6, 0x7bc70020, 0xa2da0164, 0x00000000}},  //   siju_, _siju, पुर्,
  { {0x9f4201ca, 0x60cd10bd, 0x44260066, 0x00000000}},  // [1c90] lský_, _igam, _jpo_,
  { {0x2b4a10be, 0xdb1c10bf, 0x442610c0, 0x00000000}},  //   _cnbc_, _pirá, _mpo_,
  { {0x9f4201ca, 0x2d850010, 0x09e40088, 0x00000000}},  //   nský_, éles_, воєн,
  { {0xaadf02f4, 0x4adf02fb, 0x39490845, 0x00000000}},  //   _प्रक, _प्रव, ñas_,
  { {0xba7401ef, 0x636d0051, 0x7bc7029d, 0x00000000}},  //   _یافت, _lúna, _tiju,
  { {0xbcfb0181, 0x6d5d005b, 0xe73600d7, 0x00000000}},  //   _elét, _hosa, ееш_,
  { {0x4426008d, 0x6d5d0142, 0x386910c1, 0x00000000}},  //   _apo_, _kosa, šar_,
  { {0x60cd0697, 0x442610c2, 0x00000000, 0x00000000}},  //   _ngam, _bpo_,   ,
  { {0x6442028c, 0x442604be, 0x4ad30061, 0x00000000}},  //   _croi, _cpo_, _तलाव,
  { {0x6442028c, 0x60cd0169, 0xf1c90011, 0x00000000}},  //   _droi, _agam, _hại_,
  { {0x636d0051, 0x64420420, 0x442610c3, 0x00000000}},  //   _cúna, _eroi, _epo_,
  { {0x6d5d10c4, 0x644200f4, 0x25d60097, 0x00000000}},  //   _nosa, _froi, _טוען_,
  { {0xf1c9001d, 0x27ed01aa, 0x442610c5, 0x00000000}},  //   _mại_, _jwen_, _gpo_,
  { {0x27ed0607, 0xf1c900ad, 0x443f0117, 0x00000000}},  //   _mwen_, _lại_, mvu_,
  { {0x27ed01aa, 0x443f06ed, 0x6d5d10c6, 0x00000000}},  //   _lwen_, lvu_, _bosa,
  { {0x6d5d10c7, 0x27ed0016, 0xed5703f3, 0x00000000}},  //   _cosa, _owen_, нос_,
  { {0x6d5d06a6, 0xf1ca0011, 0x443f10c8, 0x00000000}},  // [1ca0] _dosa, _nại_, nvu_,
  { {0x99710036, 0xbcfb01e5, 0x909b009b, 0x00000000}},  //   jął_, _slét, _מספק,
  { {0xa3c00204, 0x6d5d10c9, 0x65690190, 0x00000000}},  //   ंगत_, _fosa, kkeh,
  { {0x443f0119, 0x7e610039, 0xf1ca0011, 0x00000000}},  //   kvu_, älpe, _bại_,
  { {0x63a10036, 0x9f4201dc, 0x186700e3, 0x00000000}},  //   koln, zský_, наци_,
  { {0xf1ca0011, 0x443f016c, 0xfc3f00b9, 0x00000000}},  //   _dại_, dvu_, _vzít_,
  { {0xe5c601e0, 0x443f06a3, 0x44260065, 0x00000000}},  //   нсио, evu_, _spo_,
  { {0x9f4206b8, 0x636d056f, 0xdb1c014a, 0x00000000}},  //   vský_, _rúna, _birç,
  { {0x27ed005b, 0xe4520257, 0x70af013d, 0x00000000}},  //   _gwen_, اضع_, _घरेल,
  { {0xbf9b00f4, 0x320c0058, 0x60cd0026, 0x00000000}},  //   trêm, tudy_, _sgam,
  { {0x9294007e, 0x00000000, 0x00000000, 0x00000000}},  //   танц,   ,   ,
  { {0x6442028c, 0x32020428, 0x9f420161, 0x00000000}},  //   _troi, čky_, rský_,
  { {0x6d5d10ca, 0x673a0059, 0x38660129, 0x00000000}},  //   _rosa, _katj, nyor_,
  { {0xbf9b009d, 0x9f420802, 0x00000000, 0x00000000}},  //   prêm, pský_,   ,
  { {0xf1a70057, 0x673a0059, 0x64470089, 0x00000000}},  //   _прин, _matj, ājie,
  { {0xbcfb0285, 0x29d701f3, 0x60cd0145, 0x00000000}},  //   _alér, _bħan_, _ugam,
  { {0x6d5d0129, 0xfbd30879, 0x6386009d, 0x00000000}},  // [1cb0] _vosa, اتر_, _génè,
  { {0x673a0182, 0xbcfb10cb, 0x753b012d, 0x00000000}},  //   _natj, _clér, zduz,
  { {0x6d5d002a, 0x61fa010f, 0x69c9001e, 0x00000000}},  //   _tosa, nstl, _piee,
  { {0xbcfb0047, 0x27ed0263, 0x25a60087, 0x00000000}},  //   _elér, _pwen_, _nkol_,
  { {0xe7390256, 0xa3c0007d, 0x29d701d5, 0x00000000}},  //   дел_, ंगा_, _għan_,
  { {0xdb050051, 0x61fa00ea, 0x00000000, 0x00000000}},  //   rmhó, kstl,   ,
  { {0x63a10802, 0x673a046a, 0xab940088, 0x00000000}},  //   voln, _datj, _сирі,
  { {0xf1ca00ad, 0x443f0213, 0x63a10036, 0x00000000}},  //   _tại_, tvu_, woln,
  { {0x02c90201, 0x6569010f, 0x2104010a, 0x00000000}},  //   रश्न, rkeh, nčių_,
  { {0x443f10cc, 0x21040006, 0x65690142, 0x00000000}},  //   rvu_, ičių_, skeh,
  { {0x779006c6, 0x395f01aa, 0x443f10cd, 0x00000000}},  //   _دیوا, _kous_, svu_,
  { {0x395f0173, 0x63a10010, 0x6386009d, 0x00000000}},  //   _jous_, soln, _pénè,
  { {0x63a101d9, 0x629800f6, 0x395f0068, 0x00000000}},  //   poln, _exvo, _mous_,
  { {0x25ad0004, 0xa283007a, 0x25bf001a, 0x00000000}},  //   llel_, _میخو, lmul_,
  { {0xbea60081, 0xe3c80011, 0x394d0b3f, 0x00000000}},  //   тавк, _cựu_, _ones_,
  { {0x395f10ce, 0x41b600a1, 0xa5c2000c, 0x00000000}},  //   _nous_, _جمعر, _þótt,
  { {0x29d7013f, 0x00000000, 0x00000000, 0x00000000}},  // [1cc0] _aça_,   ,   ,
  { {0x09ca007d, 0x394d0023, 0x00000000, 0x00000000}},  //   िद्य, _anes_,   ,
  { {0xc332012e, 0x395f10cf, 0x673a00d9, 0x00000000}},  //   שוב_, _bous_, _ratj,
  { {0x395f0026, 0x02b60049, 0x394d10d0, 0x00000000}},  //   _cous_, דלעך_, _cnes_,
  { {0x394d004f, 0x395f10d1, 0x673a0065, 0x00000000}},  //   _dnes_, _dous_, _patj,
  { {0xbf9b00f4, 0x394d0095, 0x9873007e, 0x00000000}},  //   quêt, _enes_, шліц,
  { {0x6aa3010f, 0x2bd8007d, 0x395f009d, 0x00000000}},  //   ünft, _भंडा, _fous_,
  { {0x3160002d, 0x2d9201a3, 0x2ef801a2, 0x00000000}},  //   _noiz_, nnye_, harf_,
  { {0x673a016c, 0x47c6008b, 0xd0e30164, 0x00000000}},  //   _tatj, _абав, _क्षण_,
  { {0xbcfb00f6, 0x31600288, 0xc4450014, 0x00000000}},  //   _llép, _aoiz_, ایون_,
  { {0xcb1300b6, 0x2ef8010f, 0x27e6023a, 0x00000000}},  //   בלת_, darf_, lpon_,
  { {0x25a6011c, 0x2104007f, 0x3a2a0145, 0x00000000}},  //   _ukol_, yčių_, _mpbp_,
  { {0x27e610d2, 0xf1bf10d3, 0x00000000, 0x00000000}},  //   npon_, rmá_,   ,
  { {0x29d701d5, 0x200510d4, 0x27e60058, 0x00000000}},  //   _bħal_, čli_, ipon_,
  { {0x636d0051, 0x3da700ed, 0xc33300b3, 0x00000000}},  //   _múnl, враб, _כוס_,
  { {0x3160002d, 0x00000000, 0x00000000, 0x00000000}},  //   _goiz_,   ,   ,
  { {0x0dc801fb, 0xc05b0088, 0x395f0087, 0x00000000}},  // [1cd0] тури_, _цій_, _rous_,
  { {0x395f028c, 0x2571000c, 0xbb74003b, 0x00000000}},  //   _sous_, _mála_, агуј,
  { {0x29d70f68, 0x21040006, 0x395f10d5, 0x00000000}},  //   _għal_, sčių_, _pous_,
  { {0x67d510d6, 0x00000000, 0x00000000, 0x00000000}},  //   году,   ,   ,
  { {0x395f0a8d, 0x6d4f10d7, 0xd8250081, 0x00000000}},  //   _vous_, _inca, удли,
  { {0xf1ca0011, 0x394d0016, 0x00000000, 0x00000000}},  //   _hạt_, _wnes_,   ,
  { {0x395f028c, 0x25bf0035, 0x63760035, 0x00000000}},  //   _tous_, tmul_, _mând,
  { {0x22490119, 0x845901f9, 0x394d04bd, 0x00000000}},  //   _čak_, ерот_, _unes_,
  { {0xc9840364, 0x25bf0938, 0xf1ca0082, 0x00000000}},  //   _тури, rmul_, _mạt_,
  { {0x25bf001a, 0xf1ca0011, 0x69d5014a, 0x00000000}},  //   smul_, _lạt_, _kuze,
  { {0x75150054, 0xa18a10d8, 0x200b0036, 0x00000000}},  //   _مواض, ебна_, erci_,
  { {0xd00a0893, 0x9f5e00b9, 0xdb1d01a2, 0x00000000}},  //   неме_, čtí_, _ausü,
  { {0x69d5002d, 0xe44e022a, 0x2ef8000c, 0x00000000}},  //   _luze, _уж_, tarf_,
  { {0x6d4f01f6, 0x63760f6e, 0xf367003b, 0x00000000}},  //   _anca, _când, _штен,
  { {0x539a00a0, 0xa3c00164, 0x63760035, 0x00000000}},  //   _איסו, ंगर_, _sâng,
  { {0x26140061, 0xcd3600a1, 0x3a380009, 0x00000000}},  //   नंती_, درآب, _rsrp_,
  { {0x7af510d9, 0x69d50035, 0x2d9208f8, 0x00000000}},  // [1ce0] _bezt, _auze, rnye_,
  { {0x6d4f04bd, 0x69d50065, 0x6376001a, 0x00000000}},  //   _enca, _buze, _gând,
  { {0xd9460088, 0x68e4004a, 0x22f60049, 0x00000000}},  //   лежи, ñido, רזען_,
  { {0xf1ca0082, 0xed570b5f, 0x22580961, 0x00000000}},  //   _gạt_, _бою_, ärki_,
  { {0x27e60145, 0xb6c800a1, 0x776100f6, 0x00000000}},  //   upon_, ھاتے_, _bolx,
  { {0x27e600e0, 0x69d50584, 0x07a3060e, 0x00000000}},  //   rpon_, _fuze, бачн,
  { {0x27e60129, 0xe1e710da, 0x69d5014a, 0x00000000}},  //   spon_, _دس_, _guze,
  { {0x7bce020c, 0x27e60145, 0x78b1000c, 0x00000000}},  //   _hibu, ppon_, ðkvæ,
  { {0x69d5022b, 0xa3c2001c, 0xb7160054, 0x00000000}},  //   _zuze, ्दल_, _مباش,
  { {0x3f8a000b, 0x69c20116, 0x00000000, 0x00000000}},  //   jibu_, lmoe,   ,
  { {0x6b7b01ce, 0x2d5c0b32, 0x7bce00e0, 0x00000000}},  //   גרינ, _díez_, _mibu,
  { {0x8446004b, 0x7bce0c35, 0xdb1c00c4, 0x00000000}},  //   _مختل, _libu, _cirú,
  { {0x200b009d, 0x133900a1, 0x29d701f3, 0x00000000}},  //   urci_, رتیں_, _rħam_,
  { {0x447b007b, 0x7bce0141, 0xf4870167, 0x00000000}},  //   _אנדע, _nibu, _حامی,
  { {0x63030025, 0x29040166, 0x63760adb, 0x00000000}},  //   _طويل, _odma_, _vând,
  { {0x7bce00e7, 0x00000000, 0x00000000, 0x00000000}},  //   _aibu,   ,   ,
  { {0x69d501d6, 0x3f8a10db, 0xf1ca0082, 0x00000000}},  // [1cf0] _suze, bibu_, _vạt_,
  { {0x29040066, 0x13d70044, 0x7bce0161, 0x00000000}},  //   _adma_, _দৌড়, _cibu,
  { {0x5a3510dc, 0x7bce020c, 0x65620058, 0x00000000}},  //   рнет, _dibu, _oooh,
  { {0x290410dd, 0x69c207a5, 0x6d4f00ab, 0x00000000}},  //   _cdma_, gmoe, _unca,
  { {0x68f90046, 0x200005aa, 0x69da00f4, 0x00000000}},  //   rawd, _xvii_, _éten,
  { {0xf7450264, 0x68f90016, 0x69d50062, 0x00000000}},  //   реко, sawd, _tuze,
  { {0x7f3c007b, 0xfaa9023c, 0x6f050173, 0x00000000}},  //   געוו, _شهري_, _mdhc,
  { {0x05650088, 0x3f8a0009, 0x7bce10de, 0x00000000}},  //   рвин, zibu_, _zibu,
  { {0x7bce0009, 0x320b0036, 0x67130061, 0x00000000}},  //   _yibu, ącym_, _ठाऊक_,
  { {0x25a001d9, 0x422500c0, 0xb7bd001a, 0x00000000}},  //   čila_, адов, _opţi,
  { {0x45d510df, 0x00000000, 0x00000000, 0x00000000}},  //   _тоес,   ,   ,
  { {0x69d80181, 0x798b0016, 0xa06a003b, 0x00000000}},  //   ívei, nigw, вама_,
  { {0x3f8a000b, 0x671c006e, 0x00000000, 0x00000000}},  //   tibu_, _नामक_,   ,
  { {0xb4c1007d, 0x798b10e0, 0x2d990146, 0x00000000}},  //   ंधी_, higw, _ajse_,
  { {0x3f8a000b, 0x0fc301fb, 0x7bce0169, 0x00000000}},  //   ribu_, ійсн, _ribu,
  { {0x257101ca, 0x7bce01a3, 0x3f8a06a9, 0x00000000}},  //   _málo_, _sibu, sibu_,
  { {0x3b86007e, 0x7d160232, 0x00000000, 0x00000000}},  // [1d00] алаг, rgys,   ,
  { {0xfbdf001d, 0x1db80061, 0xdcf6019a, 0x00000000}},  //   _trên_, _आठवत, ıcın,
  { {0x69c206b2, 0xca56025f, 0xe8fa00a8, 0x00000000}},  //   tmoe, штањ, вле_,
  { {0xc8ca023c, 0xfd120025, 0x7bce0045, 0x00000000}},  //   نوان_, _بجد_, _wibu,
  { {0x69c201b5, 0x97c610e1, 0x7bce0c1b, 0x00000000}},  //   rmoe, айде, _tibu,
  { {0x6376001a, 0x69c20032, 0x00000000, 0x00000000}},  //   _mânc, smoe,   ,
  { {0x798b0066, 0x9c8706b8, 0x656200d2, 0x00000000}},  //   bigw, počí, _pooh,
  { {0xa4f80123, 0x342602dc, 0x00000000, 0x00000000}},  //   اکار_, афов,   ,
  { {0xdb1c00ea, 0xa967003b, 0x68ed004a, 0x00000000}},  //   _birø, _тита_, ñade,
  { {0xf3660069, 0x76550010, 0x00000000, 0x00000000}},  //   ртин, ógyí,   ,
  { {0x1b030055, 0x0bb700b6, 0x81de0044, 0x00000000}},  //   র্কে_, שלים_, দীন_,
  { {0x51f70a78, 0xa194013a, 0x00000000, 0x00000000}},  //   шнюю_, жаюч,   ,
  { {0x04140044, 0x63760181, 0x49070061, 0x00000000}},  //   _তৈরী_, _cânc, हणतो_,
  { {0x93fb00b6, 0x2578013e, 0x637600e5, 0x00000000}},  //   _ילדי, _déle_, _dânc,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x2129003f, 0x63a8016e, 0x25780010, 0x00000000}},  //   _ubah_, lodn, _féle_,
  { {0x91bc009b, 0x00000000, 0x00000000, 0x00000000}},  // [1d10] _במהי,   ,   ,
  { {0x8ae701fb, 0x3b5410e2, 0x3f150088, 0x00000000}},  //   ріал, окур, _удос,
  { {0xcfe20044, 0x69da0010, 0x2bc8022a, 0x00000000}},  //   _বিএন, _étel, руто_,
  { {0x63a80e80, 0x00000000, 0x00000000, 0x00000000}},  //   hodn,   ,   ,
  { {0x8d5a00b6, 0x63a80091, 0x798b10e3, 0x00000000}},  //   _עכשי, kodn, rigw,
  { {0xcc3a007b, 0xdc3a007b, 0x798b037f, 0x00000000}},  //   _געשט, _געשר, sigw,
  { {0x798b0020, 0x6446000c, 0x00000000, 0x00000000}},  //   pigw, ækin,   ,
  { {0xf1ca0011, 0x7bc510e4, 0x7d1d0045, 0x00000000}},  //   _nạp_, lmhu, _jcss,
  { {0x798910e5, 0x2613007d, 0x7bc500bb, 0x00000000}},  //   _imew, _धमकी_, omhu,
  { {0xf77300a6, 0x63a810e6, 0xc6a701fc, 0x00000000}},  //   _بار_, godn, _креи,
  { {0x636d10e7, 0x61460478, 0x00000000, 0x00000000}},  //   _júni, бена,   ,
  { {0xdb050039, 0xf1ca0082, 0x636d004a, 0x00000000}},  //   llhä, _cạp_, _múni,
  { {0x63a806a2, 0x2329013b, 0x2418007e, 0x00000000}},  //   bodn, _боли_, _вочы_,
  { {0x2bdb03d7, 0x53340242, 0xdee3003b, 0x00000000}},  //   _बढ़ा, _мечт, зори,
  { {0xdef9007e, 0x1d0a02dc, 0x225809b0, 0x00000000}},  //   шыў_, леви_, ärkt_,
  { {0xf1d00164, 0xa19301fc, 0x442f10e8, 0x00000000}},  //   _सूचन, _најч, _kpg_,
  { {0x442f001c, 0x443d03b2, 0x7d1d0045, 0x00000000}},  // [1d20] _jpg_, _jsw_, _dcss,
  { {0xf3f908b7, 0x200200ee, 0x79890020, 0x00000000}},  //   _আমার_, mski_, _amew,
  { {0x200210e9, 0x6e46007a, 0x442f10ea, 0x00000000}},  //   lski_, _انجم, _lpg_,
  { {0x9f49009f, 0xf8fa0025, 0x442f0190, 0x00000000}},  //   _hvað_, اءات_, _opg_,
  { {0x200200ee, 0xbf9b009d, 0x799b0022, 0x00000000}},  //   nski_, prêt, _djuw,
  { {0x6d44022b, 0x39400006, 0x7c2410eb, 0x00000000}},  //   ldia, žis_, mtir,
  { {0x644b022b, 0x8afb00b3, 0x65be0065, 0x00000000}},  //   _argi, _תהלי, hëhe,
  { {0x6d44022b, 0x25a001d9, 0x63a80046, 0x00000000}},  //   ndia, čilo_, wodn,
  { {0x7c2400d0, 0x200200ee, 0x69c000b0, 0x00000000}},  //   ntir, jski_, _ihme,
  { {0x7afe0010, 0x200210ec, 0x68e200bb, 0x00000000}},  //   napt, dski_, lcod,
  { {0xe1350a78, 0xdb1c00f4, 0x69c0016b, 0x00000000}},  //   онны, _chré, _khme,
  { {0xf651026c, 0x68e20141, 0x5a9b007b, 0x00000000}},  //   _کئے_, ncod, רשטא,
  { {0x6d440bc4, 0x63a80091, 0x442f0fd1, 0x00000000}},  //   ddia, podn, _gpg_,
  { {0x60d60047, 0x6d440638, 0x7c2401a2, 0x00000000}},  //   _egym, edia, dtir,
  { {0x41e603ec, 0xf1ca0011, 0xdb1c0051, 0x00000000}},  //   _استف, _tạp_, _ghré,
  { {0x1619001c, 0xd0110d3a, 0x20020aa9, 0x00000000}},  //   नंतर_, _قلب_, bski_,
  { {0x68e20e9c, 0xfe7000a1, 0x7c240058, 0x00000000}},  // [1d30] dcod, ودہ_, gtir,
  { {0x69c0014a, 0xda7b007e, 0x68e200d9, 0x00000000}},  //   _ahme, ляе_, ecod,
  { {0x6d4410ed, 0x7a350025, 0xce590478, 0x00000000}},  //   bdia, تفاص, _танц_,
  { {0xac19007c, 0x7c240035, 0x68e200bb, 0x00000000}},  //   _кому_, btir, gcod,
  { {0xe8f801ff, 0x7afe0068, 0x7c2400e5, 0x00000000}},  //   слі_, bapt, ctir,
  { {0x7afe10ee, 0x636d10ef, 0x443d10f0, 0x00000000}},  //   capt, _túni, _rsw_,
  { {0x442f023a, 0x443d01a2, 0x68e210f1, 0x00000000}},  //   _spg_, _ssw_, bcod,
  { {0x240910f2, 0x442f005b, 0x68e20197, 0x00000000}},  //   ании_, _ppg_, ccod,
  { {0x75ca0046, 0xdced0521, 0x657b059c, 0x00000000}},  //   _języ, jkač, rhuh,
  { {0x657b0020, 0x20020213, 0xa20510f3, 0x00000000}},  //   shuh, vski_, опод,
  { {0x20020046, 0xcb12019b, 0x7c24002d, 0x00000000}},  //   wski_, ולי_, ztir,
  { {0x20020ecc, 0x68fb00f4, 0xa4f70167, 0x00000000}},  //   tski_, _jeud, _اکثر_,
  { {0xbee5001c, 0x443d010f, 0x44240045, 0x00000000}},  //   कडून_, _usw_, ctm_,
  { {0x20020209, 0x9474039d, 0xdb1c0051, 0x00000000}},  //   rski_, _عدنا, _thré,
  { {0xfc3f10f4, 0x64490056, 0x68e20019, 0x00000000}},  //   _así_, lvei, ycod,
  { {0x200210f5, 0x68fb0062, 0x75290207, 0x00000000}},  //   pski_, _neud, nfez,
  { {0xab6601fe, 0x644910f6, 0x236710f7, 0x00000000}},  // [1d40] овал, nvei, _konj_,
  { {0x7c240207, 0x6d4410f8, 0x2fd70014, 0x00000000}},  //   rtir, sdia, _گوید_,
  { {0x7c240213, 0x68e20d4d, 0xdce40521, 0x00000000}},  //   stir, tcod, jkić,
  { {0x7c240091, 0x7afe0a3e, 0x68fb0544, 0x00000000}},  //   ptir, sapt, _ceud,
  { {0x1836006d, 0x68fb10f9, 0x68e2010f, 0x00000000}},  //   تراح, _deud, rcod,
  { {0x68e207eb, 0x69d810fa, 0xbb560025, 0x00000000}},  //   scod, íves, _بنسب,
  { {0x68e20019, 0x7afc001a, 0xd95a003b, 0x00000000}},  //   pcod, _iert, _краљ_,
  { {0x7ae9016c, 0x8ebf0044, 0x257807fd, 0x00000000}},  //   _đeti, _আলমগ, _béla_,
  { {0x7afc021e, 0x69dc00b5, 0x39440145, 0x00000000}},  //   _kert, _hure, _iams_,
  { {0x39460006, 0x69dc0b48, 0x7afc0035, 0x00000000}},  //   ldos_, _kure, _jert,
  { {0x7afc01a3, 0xc4e60d99, 0x39460dd1, 0x00000000}},  //   _mert, _джей, odos_,
  { {0x69dc10fb, 0xe1ef00a6, 0x7afc002d, 0x00000000}},  //   _mure, کسی_, _lert,
  { {0x39460b7f, 0x849610fc, 0x81ba0055, 0x00000000}},  //   idos_, _بجائ, _অংশ_,
  { {0x69dc049a, 0xdced00ca, 0x7afc10fd, 0x00000000}},  //   _oure, rkač, _nert,
  { {0xccfb012b, 0x69dc0095, 0x645d00b0, 0x00000000}},  //   ића_, _nure, äsiv,
  { {0x7afc10fe, 0x39440089, 0xfc3f0062, 0x00000000}},  //   _aert, _nams_, _psí_,
  { {0x7afc0653, 0x69dc10ff, 0x21390065, 0x00000000}},  // [1d50] _bert, _aure, mesh_,
  { {0x69dc05f2, 0x20190004, 0x39460181, 0x00000000}},  //   _bure, musi_, edos_,
  { {0x20191100, 0xea000011, 0x69dc0585, 0x00000000}},  //   lusi_, _đảo_, _cure,
  { {0xe9d8008b, 0x69dc001a, 0x3f910107, 0x00000000}},  //   ікі_, _dure, lizu_,
  { {0x69dc0288, 0x66e50256, 0x20190d90, 0x00000000}},  //   _eure, пола, nusi_,
  { {0x39461101, 0x7afc022b, 0x2139008d, 0x00000000}},  //   ados_, _gert, hesh_,
  { {0x7bdd1102, 0x7c39011f, 0x69dc002d, 0x00000000}},  //   _husu, şarı, _gure,
  { {0x20190dec, 0x7afc1103, 0x7bdd0c04, 0x00000000}},  //   kusi_, _zert, _kusu,
  { {0x20191104, 0x69dc09ce, 0x7bdd1105, 0x00000000}},  //   jusi_, _zure, _jusu,
  { {0x644904bd, 0x7bdd0996, 0x2571009f, 0x00000000}},  //   rvei, _musu, _máli_,
  { {0xcb1200bd, 0x64490ba5, 0xa91d010a, 0x00000000}},  //   עלט_, svei, _amži,
  { {0x291d1106, 0x2419007c, 0xb6ba0104, 0x00000000}},  //   ngwa_, _годы_, _הצעי,
  { {0x2019002d, 0x3169002d, 0x7bdd1107, 0x00000000}},  //   gusi_, _doaz_, _nusu,
  { {0x7bd50d53, 0x636d0051, 0x3946007f, 0x00000000}},  //   _nizu, _cúnt, zdos_,
  { {0xe2960888, 0xed5a0920, 0x272f005a, 0x00000000}},  //   _наш_, бов_, mını_,
  { {0x7afc020c, 0x20191108, 0xa0a6007c, 0x00000000}},  //   _sert, busi_, _найд,
  { {0x7afc020c, 0x69dc1109, 0xdca30216, 0x00000000}},  // [1d60] _pert, _sure, еати,
  { {0x69dc110a, 0xef860b7b, 0x272f005d, 0x00000000}},  //   _pure, _хлоп, nını_,
  { {0x19ba0077, 0x7bd5002d, 0x394400f6, 0x00000000}},  //   будь_, _dizu, _pams_,
  { {0x7ae50195, 0x7afc05ca, 0x39460006, 0x00000000}},  //   acht, _wert, udos_,
  { {0x7afc020c, 0x39460211, 0x25ad00c7, 0x00000000}},  //   _tert, rdos_, doel_,
  { {0x69dc0dc6, 0x6d46078f, 0x272f014a, 0x00000000}},  //   _ture, _haka, jını_,
  { {0x6d46006a, 0xfaa30a27, 0x272f0279, 0x00000000}},  //   _kaka, _заро, dını_,
  { {0x6d460390, 0x7ec70047, 0x7bdd014a, 0x00000000}},  //   _jaka, lépé, _yusu,
  { {0x6d46110b, 0x272f0279, 0x21390023, 0x00000000}},  //   _maka, fını_, vesh_,
  { {0x6d46110c, 0x20190ba5, 0x6843005e, 0x00000000}},  //   _laka, vusi_, _януа,
  { {0x21390065, 0x2d920c07, 0x25ad00bb, 0x00000000}},  //   tesh_, kiye_, boel_,
  { {0x6d460811, 0x20190004, 0x6364000a, 0x00000000}},  //   _naka, tusi_, _jònz,
  { {0x21390065, 0x2d92014a, 0x2d800697, 0x00000000}},  //   resh_, diye_, dhie_,
  { {0x2019110d, 0x7bdd008a, 0x21390065, 0x00000000}},  //   rusi_, _rusu, sesh_,
  { {0x6d46110e, 0x2019005f, 0x4ea40920, 0x00000000}},  //   _baka, susi_, ерта,
  { {0xf1a4008b, 0x2d92110f, 0xe3b80279, 0x00000000}},  //   _прын, giye_, llı_,
  { {0x6d460bbb, 0xea00001d, 0x5c9900a5, 0x00000000}},  // [1d70] _daka, _đạo_, цкая_,
  { {0xe3b801f6, 0x7ae5010f, 0x0bb4041f, 0x00000000}},  //   nlı_, ucht, ебую,
  { {0x7bd51110, 0x68ed0211, 0x6d46014a, 0x00000000}},  //   _vizu, ñado, _faka,
  { {0x2d801111, 0x6442021e, 0xe3b80180, 0x00000000}},  //   chie_, _osoi, hlı_,
  { {0x25ad00c7, 0xe3b8014a, 0xf7451112, 0x00000000}},  //   voel_, klı_, дело,
  { {0x6d4601d9, 0xe3b8026d, 0x00000000, 0x00000000}},  //   _zaka, jlı_,   ,
  { {0x6d46014a, 0xda34007e, 0x25ad0112, 0x00000000}},  //   _yaka, _перы, toel_,
  { {0x6faf0061, 0x5ebf0044, 0xd11f007d, 0x00000000}},  //   ंकडू, _আলাই, _भाषण_,
  { {0xe3b802b9, 0x272f0279, 0x25ad0022, 0x00000000}},  //   flı_, tını_, roel_,
  { {0xd3890088, 0x29d7002b, 0x27ed1113, 0x00000000}},  //   ійне_, _għar_, _iten_,
  { {0x272f01f6, 0x320500ab, 0xda7a0049, 0x00000000}},  //   rını_, usly_, ַנשר,
  { {0x272f01f6, 0x7207026c, 0xc6920104, 0x00000000}},  //   sını_, _ہفتہ_, _באב_,
  { {0xe3ae008b, 0xa01b0047, 0x6d461114, 0x00000000}},  //   _аб_, szön, _raka,
  { {0xdb1c002a, 0x2d921115, 0x753b00fa, 0x00000000}},  //   _phrí, wiye_, leuz,
  { {0x6d461116, 0x1d0a00ed, 0x2d8008ea, 0x00000000}},  //   _paka, жеби_, thie_,
  { {0x656b0313, 0x9f5900b0, 0xed570478, 0x00000000}},  //   _jogh, essä_, мос_,
  { {0x6d460ba5, 0x2d921117, 0x656b0066, 0x00000000}},  // [1d80] _vaka, riye_, _mogh,
  { {0x6d460be3, 0x656b0bd6, 0x290d1118, 0x00000000}},  //   _waka, _logh, _adea_,
  { {0x6d46021e, 0x2d801119, 0x637f0699, 0x00000000}},  //   _taka, phie_, _gêne,
  { {0xe3b80676, 0x443f0066, 0x29e8013f, 0x00000000}},  //   zlı_, kwu_, _ağac_,
  { {0x7d04021e, 0xd90d00a6, 0xe3b8005d, 0x00000000}},  //   mais, صیل_, ylı_,
  { {0x7d04021e, 0x75220197, 0x69cb01c3, 0x00000000}},  //   lais, _scoz, amge,
  { {0x27ed111a, 0x656b0030, 0x68e90016, 0x00000000}},  //   _eten_, _bogh, _ffed,
  { {0x7d04021e, 0x257800f4, 0x753b0020, 0x00000000}},  //   nais, _vélo_, geuz,
  { {0xe3b8047f, 0x443f0066, 0x656b111b, 0x00000000}},  //   tlı_, gwu_, _dogh,
  { {0x7d0400b0, 0x636d00f6, 0x656b0048, 0x00000000}},  //   hais, _búnq, _eogh,
  { {0x7d04021e, 0xa3de02fb, 0x81bd001e, 0x00000000}},  //   kais, _दूर_, stēm,
  { {0xe3b80180, 0x7d0400b0, 0x2d9e0010, 0x00000000}},  //   slı_, jais, étel_,
  { {0x637f01d6, 0x9f5900b0, 0xe3b801df, 0x00000000}},  //   _sêne, yssä_, plı_,
  { {0xe3b8005f, 0x81bd0089, 0xd2500647, 0x00000000}},  //   qlı_, otēk, _منت_,
  { {0xdfd41036, 0xd90400e9, 0x656b0239, 0x00000000}},  //   торы, _پی_, _yogh,
  { {0x7d04111c, 0x656b002b, 0x00000000, 0x00000000}},  //   gais, _xogh,   ,
  { {0xfbdf08c6, 0x3b5500ed, 0x4c94007c, 0x00000000}},  // [1d90] _quê_, нкар, витс,
  { {0x31a4005d, 0x60c003e1, 0xa3c3006e, 0x00000000}},  //   mıza_, ümme, ्षय_,
  { {0xdb1c009f, 0x27ed0193, 0xc915012b, 0x00000000}},  //   _virð, _sten_, едећ,
  { {0x7d04009d, 0x79820022, 0x00000000, 0x00000000}},  //   cais, ghow,   ,
  { {0x656b002a, 0x31a4005a, 0x69cb111d, 0x00000000}},  //   _rogh, nıza_, rmge,
  { {0xf1ca001d, 0x656b002a, 0xf6250131, 0x00000000}},  //   _dạy_, _sogh, едко,
  { {0x81bd001e, 0x45d5053c, 0xd90f0123, 0x00000000}},  //   rtēj, нцит, _نیا_,
  { {0x79820046, 0x443f0036, 0x81bd0089, 0x00000000}},  //   chow, twu_, stēj,
  { {0x656b0026, 0x27ed0056, 0xfbdf0082, 0x00000000}},  //   _vogh, _uten_, _trêu_,
  { {0x2d8c009d, 0x7d04007f, 0x00000000, 0x00000000}},  //   édez_, zais,   ,
  { {0x0322008b, 0x656b0051, 0x68e404eb, 0x00000000}},  //   ыдэн, _togh, žide,
  { {0x92df0044, 0x31a4014a, 0x00000000, 0x00000000}},  //   তরে_, fıza_,   ,
  { {0x7d04111e, 0x6007111f, 0xa806004a, 0x00000000}},  //   vais, нням_, mañó,
  { {0x7d040258, 0x00000000, 0x00000000, 0x00000000}},  //   wais,   ,   ,
  { {0x7d040778, 0xf77200a3, 0xed5a0242, 0x00000000}},  //   tais, נקל_, пов_,
  { {0x61ee008e, 0x7bc7006c, 0x00000000, 0x00000000}},  //   íble, _ahju,   ,
  { {0x7d041120, 0xc19b009b, 0xdb1e00b0, 0x00000000}},  // [1da0] rais, _משקי, ympä,
  { {0x7d041121, 0xdb1c0051, 0x60c40087, 0x00000000}},  //   sais, _bhrá, _izim,
  { {0xe9da0f09, 0xc33201f8, 0x7d04044e, 0x00000000}},  //   чке_, רוב_, pais,
  { {0xfbdf00f4, 0x2571000c, 0x307a0049, 0x00000000}},  //   _prêt_, _máls_, ּאַנ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x38cb089d, 0x60c40020, 0xdb1c0048, 0x00000000}},  //   سانی_, _mzim, _fhrá,
  { {0xe2870025, 0xdb1c0051, 0x00000000, 0x00000000}},  //   _إذ_, _ghrá,   ,
  { {0x0466017f, 0x75e7013f, 0x00000000, 0x00000000}},  //   етом, _qıza,   ,
  { {0x81e70055, 0x60c40020, 0x98a300e2, 0x00000000}},  //   মীম_, _nzim, _бите,
  { {0x8835007e, 0x00000000, 0x00000000, 0x00000000}},  //   _шэсц,   ,   ,
  { {0x60c40020, 0x637600fa, 0x00000000, 0x00000000}},  //   _azim, _jâni,   ,
  { {0x4a9b007b, 0x546a0265, 0xbcfb009d, 0x00000000}},  //   לייג, _наем_, _inég,
  { {0xc953019b, 0x25710010, 0x06d50044, 0x00000000}},  //   אמר_, _vált_, _স্পি,
  { {0xa3c302fb, 0x60c4001e, 0x25a00059, 0x00000000}},  //   ्षण_, _dzim, čilu_,
  { {0x60c40045, 0x00000000, 0x00000000, 0x00000000}},  //   _ezim,   ,   ,
  { {0x9f4900fa, 0x00000000, 0x00000000, 0x00000000}},  //   _itaí_,   ,   ,
  { {0x2ef50265, 0x321e00b4, 0xdb1c1122, 0x00000000}},  // [1db0] _изпр, luty_, _shrá,
  { {0xc5f60044, 0x8aa71123, 0x200b0197, 0x00000000}},  //   _ঘটনা_, нред, msci_,
  { {0x321e1124, 0xdd91023c, 0x200b0026, 0x00000000}},  //   nuty_, _نود_, lsci_,
  { {0x397801e1, 0x1a681125, 0x00000000, 0x00000000}},  //   нсію_, ریقی_,   ,
  { {0x6d5d0481, 0x200b0026, 0x00000000, 0x00000000}},  //   _insa, nsci_,   ,
  { {0x7c2d008d, 0x39490ebc, 0x6d4d00c7, 0x00000000}},  //   mtar, žas_, ldaa,
  { {0x7c2d000d, 0xfbdf02d5, 0xe7080076, 0x00000000}},  //   ltar, _três_, رتون_,
  { {0x6d4d02ae, 0x4904023c, 0x7c2d1126, 0x00000000}},  //   ndaa, _موفق, otar,
  { {0x200b1127, 0xbcfb1128, 0xd6db00ed, 0x00000000}},  //   jsci_, _inéd, _ете_,
  { {0x7c2d009f, 0x69da0923, 0x05960014, 0x00000000}},  //   itar, _éter, _یانگ,
  { {0x7c2d0a0d, 0x6d5d02ab, 0x20190197, 0x00000000}},  //   htar, _onsa, ersi_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7c2d0065, 0x1b0c0044, 0x65690166, 0x00000000}},  //   jtar, স্টে_, mjeh,
  { {0x6d5d1129, 0xa067003b, 0x321e0667, 0x00000000}},  //   _ansa, њара_, buty_,
  { {0x7c2d04f4, 0x2019112a, 0xee15007e, 0x00000000}},  //   etar, arsi_, льтэ,
  { {0x7c2d04cb, 0x65690065, 0xe8020061, 0x00000000}},  //   ftar, njeh, रीडा_,
  { {0x442d0555, 0x60c40091, 0x7c2d1002, 0x00000000}},  // [1dc0] nte_, _uzim, gtar,
  { {0x6d5d0cd4, 0xa3c1013d, 0x8ad60025, 0x00000000}},  //   _ensa, ंति_, نتائ,
  { {0x442d048a, 0xbcfb088a, 0x7c2d001a, 0x00000000}},  //   hte_, _poét, atar,
  { {0x69c9112b, 0x3f98003f, 0x637600c4, 0x00000000}},  //   _chee, liru_, _vâni,
  { {0x442d047c, 0xa3c302fb, 0x7c2d050a, 0x00000000}},  //   jte_, ्षा_, ctar,
  { {0x442d0030, 0xbb76005e, 0x3f98112c, 0x00000000}},  //   dte_, _румъ, niru_,
  { {0x442d0007, 0xd6d50044, 0x61e300a4, 0x00000000}},  //   ete_, _স্বয, _nunl,
  { {0x7bdc022b, 0x69c9112d, 0x6288112e, 0x00000000}},  //   _hiru, _ghee, vzdo,
  { {0x442d0343, 0x7bdc0209, 0x37e601fb, 0x00000000}},  //   gte_, _kiru, _розг,
  { {0x61e3005d, 0x20190107, 0x2904112f, 0x00000000}},  //   _bunl, vrsi_, _hema_,
  { {0x442d0038, 0x7bdc0550, 0x7c2d0e49, 0x00000000}},  //   ate_, _miru, ztar,
  { {0x442d04bd, 0x61e30253, 0x7c2d006b, 0x00000000}},  //   bte_, _dunl, ytar,
  { {0x442d04bd, 0x7c2d0543, 0x29040020, 0x00000000}},  //   cte_, xtar, _mema_,
  { {0x290400d4, 0x61e30082, 0xdce60089, 0x00000000}},  //   _lema_, _funl, _rokā,
  { {0x91e3012b, 0x7c2d0036, 0xcddb003b, 0x00000000}},  //   _које, wtar, дња_,
  { {0x2904009f, 0xdd11006b, 0x672d0166, 0x00000000}},  //   _nema_, _düşd, đaji,
  { {0x6d4d01b5, 0xd1b8007a, 0x69c901c3, 0x00000000}},  // [1dd0] rdaa, _جاوا_, _rhee,
  { {0x2d820100, 0xd9cb03d7, 0x7bdc029d, 0x00000000}},  //   _elke_, िष्ट, _ciru,
  { {0x442d022b, 0x7bdc1130, 0x6abc0016, 0x00000000}},  //   zte_, _diru, _cyrf,
  { {0x7c2d048a, 0x6d5d011c, 0x27e4023a, 0x00000000}},  //   ptar, _unsa, _bumn_,
  { {0x442d00f4, 0xec350049, 0x7bdc1131, 0x00000000}},  //   xte_, _גאָר_, _firu,
  { {0x69c900ab, 0x442d0161, 0x7bdc1132, 0x00000000}},  //   _whee, vte_, _giru,
  { {0x69c900bb, 0x6abc0016, 0xc7940014, 0x00000000}},  //   _thee, _gyrf, جشنب,
  { {0x61e300f6, 0x7bdc0032, 0x6f0500b9, 0x00000000}},  //   _runl, _ziru, _lehc,
  { {0x442d0e6d, 0x779304e1, 0xf1bf0027, 0x00000000}},  //   ute_, _پیغا, dlá_,
  { {0xf7700647, 0x657b0058, 0xe1f90517, 0x00000000}},  //   _وال_, skuh, нго_,
  { {0x3f980059, 0x65690243, 0x395f0030, 0x00000000}},  //   viru_, pjeh, _knus_,
  { {0x442d1133, 0x06d50044, 0x3f981134, 0x00000000}},  //   pte_, _স্থি, wiru_,
  { {0x394d018e, 0x442d0065, 0xd0960a78, 0x00000000}},  //   _maes_, qte_, ушны,
  { {0x649a007b, 0x749a061e, 0x00000000, 0x00000000}},  //   _אינה, _אינפ,   ,
  { {0xe1f10a90, 0x395f0ace, 0x3f9801ee, 0x00000000}},  //   _است_, _onus_, riru_,
  { {0x0ce20055, 0x3f980066, 0x22580030, 0x00000000}},  //   বর্ত, siru_, ærke_,
  { {0x29040096, 0x7bdc00b0, 0x3f980091, 0x00000000}},  // [1de0] _rema_, _piru, piru_,
  { {0xdd04038c, 0x09dc0061, 0x29041135, 0x00000000}},  //   ısın, यद्य, _sema_,
  { {0x75e7006b, 0x29040041, 0x00000000, 0x00000000}},  //   _qızl, _pema_,   ,
  { {0xfe9b00a3, 0x394d0325, 0x7bdc0036, 0x00000000}},  //   _טיימ, _caes_, _wiru,
  { {0x29040020, 0x7bdc01a3, 0x00000000, 0x00000000}},  //   _vema_, _tiru,   ,
  { {0xc3190044, 0x7d0600ea, 0x29040020, 0x00000000}},  //   ত্তি_, _heks, _wema_,
  { {0x29040c1b, 0x7d061136, 0x394d0016, 0x00000000}},  //   _tema_, _keks, _faes_,
  { {0x78260025, 0x5e57007b, 0x746a007c, 0x00000000}},  //   _معطل, ריקע_, еров_,
  { {0x7d061137, 0xd90d0014, 0x00000000, 0x00000000}},  //   _meks, _آیه_,   ,
  { {0x7d060056, 0x883b009b, 0x25bf0035, 0x00000000}},  //   _leks, _אתמו, alul_,
  { {0x4ebf0055, 0x317201d0, 0x877b071c, 0x00000000}},  //   _আল্ল, _boyz_, _ראבי,
  { {0x6fc00039, 0x25bf0035, 0x00000000, 0x00000000}},  //   böck, clul_,   ,
  { {0x637600e5, 0x00000000, 0x00000000, 0x00000000}},  //   _bânt,   ,   ,
  { {0x63761138, 0x1b1a0044, 0xf1bf04bb, 0x00000000}},  //   _cânt, ন্তে_, slá_,
  { {0xa3c10183, 0x7d060107, 0xa3c3006e, 0x00000000}},  //   ंतर_, _beks, ्षर_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7d060630, 0xbcfb008e, 0xcb1b00ed, 0x00000000}},  // [1df0] _deks, _anéc, еќе_,
  { {0x7d0600e0, 0x395f00f8, 0x3dc00058, 0x00000000}},  //   _eeks, _snus_, aliw_,
  { {0x394d00c4, 0x00000000, 0x00000000, 0x00000000}},  //   _paes_,   ,   ,
  { {0x4dfa007b, 0xa90701fa, 0x7d0600d9, 0x00000000}},  //   _שפרא, ابان, _geks,
  { {0x1b1a0044, 0x00000000, 0x00000000, 0x00000000}},  //   ন্ধে_,   ,   ,
  { {0x07a500ed, 0x6d4f1139, 0x17f80025, 0x00000000}},  //   јакн, _haca, ارنة_,
  { {0x6d4f0169, 0x25bf001a, 0x27f800ca, 0x00000000}},  //   _kaca, tlul_, _črne_,
  { {0x6d4f0181, 0x395f0022, 0x1b1a0044, 0x00000000}},  //   _jaca, _unus_, ন্দে_,
  { {0x6d4f0127, 0x87270084, 0xb81c007d, 0x00000000}},  //   _maca, _معام, _नियम_,
  { {0x6d4f106f, 0x00000000, 0x00000000, 0x00000000}},  //   _laca,   ,   ,
  { {0x49b800a1, 0x25bf113a, 0x651508d4, 0x00000000}},  //   _شاہد_, plul_, _نوائ,
  { {0x2496007a, 0xe2960454, 0x672d04eb, 0x00000000}},  //   انید_, раю_, đaju,
  { {0x7d06000c, 0x764e009f, 0x63760adb, 0x00000000}},  //   _reks, _ábyr, _pânt,
  { {0x64590719, 0x443d0022, 0x63760035, 0x00000000}},  //   _irwi, _ipw_, _dâns,
  { {0x3ebe000c, 0x645c0089, 0x7d06006c, 0x00000000}},  //   ætt_, ārie, _peks,
  { {0x6d4f001c, 0xa1930545, 0x645900b4, 0x00000000}},  //   _caca, _мајч, _krwi,
  { {0x81bd0089, 0x7d060056, 0x6d4f113b, 0x00000000}},  // [1e00] rtēt, _veks, _daca,
  { {0x6d4f113c, 0x2578000c, 0x907b0104, 0x00000000}},  //   _eaca, _hélt_, _סטיי,
  { {0x7d060292, 0x6d4f113d, 0xeb97012b, 0x00000000}},  //   _teks, _faca, јих_,
  { {0x6d4f0020, 0x32360049, 0x443d03b3, 0x00000000}},  //   _gaca, יטען_, _opw_,
  { {0x6d440035, 0x2d80113e, 0xa01b0010, 0x00000000}},  //   meia, mkie_, szöv,
  { {0x2d800046, 0x6d4f113f, 0x6d440056, 0x00000000}},  //   lkie_, _zaca, leia,
  { {0xfaa3008b, 0x2d800061, 0x7c241140, 0x00000000}},  //   _даро, okie_, luir,
  { {0x2d800343, 0x6d441141, 0xdb070056, 0x00000000}},  //   nkie_, neia, _skjø,
  { {0xb7160014, 0x2d8001d6, 0x69c2006c, 0x00000000}},  //   _نباش, ikie_, mloe,
  { {0x69c20016, 0x443d0093, 0x6e3e0056, 0x00000000}},  //   lloe, _dpw_, _oppb,
  { {0x2d800343, 0xa69602a8, 0x0cc302d2, 0x00000000}},  //   kkie_, _трај, _शर्म,
  { {0x7c24050f, 0x64590009, 0x00000000, 0x00000000}},  //   kuir, _frwi,   ,
  { {0x6d4400c4, 0x248d0036, 0x6e3e0203, 0x00000000}},  //   deia, czem_, _appb,
  { {0x6d4f1142, 0x7c240005, 0xdb050039, 0x00000000}},  //   _saca, duir, llhö,
  { {0x44240b15, 0x6d4f1143, 0x8de801e0, 0x00000000}},  //   lum_, _paca, ифта_,
  { {0x69c8001e, 0xdb1c0051, 0xccf8003b, 0x00000000}},  //   _ūden, _ghrú, ићу_,
  { {0x44240fa2, 0x7c240207, 0x6562004f, 0x00000000}},  // [1e10] num_, guir, _mnoh,
  { {0x25a91144, 0x6d4f04be, 0xde4702fd, 0x00000000}},  //   čali_, _waca, _پیرو_,
  { {0x6d4f002a, 0x5a35005e, 0x7f3c0104, 0x00000000}},  //   _taca, снет, _יעזו,
  { {0x44241145, 0x2d800046, 0x7c2404b4, 0x00000000}},  //   kum_, ckie_, buir,
  { {0x765a0046, 0x44241146, 0xbcfb0051, 0x00000000}},  //   _arty, jum_, _gnéa,
  { {0xbb850054, 0x44241147, 0xf74500ed, 0x00000000}},  //   _السي, dum_, секо,
  { {0x69c21148, 0x443d00bb, 0x7f3c0049, 0x00000000}},  //   bloe, _spw_, דעוו,
  { {0x4424009f, 0xa01b010f, 0x248d0129, 0x00000000}},  //   fum_, nzös, tzem_,
  { {0x44241149, 0xe3b9114a, 0x00000000, 0x00000000}},  //   gum_, лби_,   ,
  { {0xd7740054, 0x248d114b, 0x2d80114c, 0x00000000}},  //   _والع, rzem_, zkie_,
  { {0x248d0c59, 0x7d0d03b6, 0xe10a00e2, 0x00000000}},  //   szem_, kaas, ленд_,
  { {0x443d0584, 0xa06a003b, 0x7d0d01b1, 0x00000000}},  //   _tpw_, гама_, jaas,
  { {0x4424000d, 0x5552026c, 0x645d0030, 0x00000000}},  //   cum_, _رپور, æsid,
  { {0xa027009f, 0x64490016, 0x75290de1, 0x00000000}},  //   _stöð, mwei, lgez,
  { {0x51f50076, 0x6449010f, 0xd5ac00a1, 0x00000000}},  //   _استر, lwei, _سہی_,
  { {0x7529114d, 0x7c2404b4, 0x29d701d5, 0x00000000}},  //   ngez, tuir, _għax_,
  { {0x6449001f, 0x2d800007, 0x69c201b5, 0x00000000}},  // [1e20] nwei, rkie_, vloe,
  { {0x2d8009a2, 0x4f260242, 0x7c2404b4, 0x00000000}},  //   skie_, _удоб, ruir,
  { {0x6449001f, 0x44240047, 0x7c240107, 0x00000000}},  //   hwei, zum_, suir,
  { {0x4424014a, 0x64550089, 0x644900d9, 0x00000000}},  //   yum_, āzij, kwei,
  { {0x7c240038, 0xa3e7006e, 0xe80b013d, 0x00000000}},  //   quir, _मूल_, _सौदा_,
  { {0x64490016, 0x44240f11, 0x9f4000f6, 0x00000000}},  //   dwei, vum_, _juià_,
  { {0x44240036, 0x7529010f, 0xd5ba00aa, 0x00000000}},  //   wum_, fgez, лси_,
  { {0x7529069d, 0x3e5801aa, 0x644901a2, 0x00000000}},  //   ggez, _mčt_, fwei,
  { {0x64490abe, 0x77ca004d, 0x394600c4, 0x00000000}},  //   gwei, _благ_, meos_,
  { {0x4424114e, 0xf3660a30, 0xa3e70061, 0x00000000}},  //   rum_, стин, _मूळ_,
  { {0x4424114f, 0x3e5801aa, 0xb7d7006d, 0x00000000}},  //   sum_, _nčt_, _اولا_,
  { {0x79820046, 0x39461150, 0x656200b0, 0x00000000}},  //   nkow, neos_, _unoh,
  { {0x543306c6, 0x44240d82, 0x7d0d0052, 0x00000000}},  //   _فرور, qum_, vaas,
  { {0x3e580173, 0x7d0d00e7, 0x00000000, 0x00000000}},  //   _bčt_, waas,   ,
  { {0x63ba0161, 0x7a1c001a, 0x7d0d1151, 0x00000000}},  //   motn, nătă, taas,
  { {0x71a4025f, 0x63ba0059, 0x3253005e, 0x00000000}},  //   _најз, lotn, _хвър,
  { {0x2d58007c, 0x79820036, 0x7d0d0052, 0x00000000}},  // [1e30] щить_, dkow, raas,
  { {0x3e5801aa, 0x7d0d006c, 0x2d9e1152, 0x00000000}},  //   _fčt_, saas, éter_,
  { {0x27f80059, 0x3946008e, 0x644901a2, 0x00000000}},  //   _črna_, feos_, zwei,
  { {0x41c90183, 0xf1c90201, 0x63ba0161, 0x00000000}},  //   रतिस, रतिन, hotn,
  { {0x1869003b, 0x63ba0089, 0x00000000, 0x00000000}},  //   рали_, kotn,   ,
  { {0x36190057, 0xa09c0049, 0xb09c01ce, 0x00000000}},  //   ацию_, ניגט, ניגר,
  { {0x752900b5, 0xf1c90061, 0x3946008e, 0x00000000}},  //   tgez, रतान, beos_,
  { {0x64491153, 0xe579064b, 0x7bc500f8, 0x00000000}},  //   twei, рзи_, llhu,
  { {0x290f04d0, 0xe1010055, 0x61ea010f, 0x00000000}},  //   maga_, ্লাহ_, _aufl,
  { {0x290f006a, 0x6449001f, 0x7529059b, 0x00000000}},  //   laga_, rwei, sgez,
  { {0x6449001f, 0x76ab072b, 0x79891154, 0x00000000}},  //   swei, _став_, _klew,
  { {0x290f020c, 0x98a4002b, 0x00000000, 0x00000000}},  //   naga_, _qamħ_,   ,
  { {0x2bbe007d, 0x27fd01f3, 0x637f1155, 0x00000000}},  //   ्तमा, npwn_, _lêni,
  { {0x3e8a008b, 0x290f006c, 0x79890016, 0x00000000}},  //   айго_, haga_, _llew,
  { {0x290f006c, 0x79891156, 0xaf99041f, 0x00000000}},  //   kaga_, _olew, стях_,
  { {0x7242026c, 0x290f006c, 0xa3c30309, 0x00000000}},  //   _کھیل, jaga_, ्षक_,
  { {0x290f0ad1, 0x9f8400b0, 0xbcfb0068, 0x00000000}},  // [1e40] daga_, töä_, _inél,
  { {0x76410018, 0x3e5801aa, 0x79890a20, 0x00000000}},  //   _oply, _tčt_, _alew,
  { {0x79820046, 0xfce6003b, 0x61e4003c, 0x00000000}},  //   tkow, _моно, _kiil,
  { {0x5f4601ef, 0xed5a0057, 0x08c60769, 0x00000000}},  //   _انگل, _том_, обен,
  { {0x79821157, 0x61e41158, 0x394600dc, 0x00000000}},  //   rkow, _miil, reos_,
  { {0x39460211, 0x79820036, 0x39520006, 0x00000000}},  //   seos_, skow, žys_,
  { {0x63ba004f, 0x290f1159, 0x3946008e, 0x00000000}},  //   votn, baga_, peos_,
  { {0x6d560263, 0x61e400b0, 0x63ba0036, 0x00000000}},  //   ndya, _niil, wotn,
  { {0x7c3600eb, 0x61ea001a, 0x60c4115a, 0x00000000}},  //   ntyr, _sufl, _nyim,
  { {0xd37a08fc, 0xe72a02fd, 0x00000000, 0x00000000}},  //   рчи_, _خسرو_,   ,
  { {0x63ba0aa9, 0x32660088, 0x60cd115b, 0x00000000}},  //   rotn, ітов, _szam,
  { {0x63ba115c, 0x60c40045, 0xe5780089, 0x00000000}},  //   sotn, _byim, _puķu_,
  { {0x63ba0059, 0x9f4900c4, 0x1b110044, 0x00000000}},  //   potn, _itaú_, ালতে_,
  { {0x290f0569, 0x60cd0059, 0xa2940245, 0x00000000}},  //   zaga_, _vzam, _налі,
  { {0x290f0b5a, 0xdd9b025f, 0x61e4115d, 0x00000000}},  //   yaga_, аша_, _fiil,
  { {0x1b040055, 0x3f8307e0, 0x6e3500ea, 0x00000000}},  //   _লাগে_, skju_, rtzb,
  { {0x6ebb006e, 0x290f006c, 0x637f00c4, 0x00000000}},  // [1e50] _शुरु, vaga_, _sêni,
  { {0x290f0a71, 0x69c00d90, 0x637f00c4, 0x00000000}},  //   waga_, _akme, _pêni,
  { {0xdced0182, 0x290f011c, 0xdb07000c, 0x00000000}},  //   ljač, taga_, _skjó,
  { {0x2009115e, 0xc9840437, 0x00000000, 0x00000000}},  //   _kwai_, мучи,   ,
  { {0x290f115f, 0x6446005f, 0xa804008b, 0x00000000}},  //   raga_, çkil, дзіл,
  { {0x290f069e, 0x637f0181, 0x69c0014a, 0x00000000}},  //   saga_, _têni, _ekme,
  { {0x64421160, 0xf96b09b2, 0x290f010e, 0x00000000}},  //   _apoi, _край_, paga_,
  { {0xe795089d, 0x64420051, 0x799b011c, 0x00000000}},  //   _کارک, _bpoi, _umuw,
  { {0xdced0091, 0xc9520104, 0x68e901f3, 0x00000000}},  //   jjač, _אמן_, _iged,
  { {0x69d900b4, 0x61e401b1, 0x00000000, 0x00000000}},  //   lmwe, _siil,   ,
  { {0x4b7c007b, 0x61e40103, 0x69d91161, 0x00000000}},  //   יאזו, _piil, omwe,
  { {0x644f0030, 0xe802013d, 0x7c360023, 0x00000000}},  //   æcis, रीका_, ytyr,
  { {0x61e41162, 0xe5c4007e, 0x64421163, 0x00000000}},  //   _viil, _ўсхо, _gpoi,
  { {0x2d8b0555, 0x2215005e, 0x00000000, 0x00000000}},  //   _alce_, _ефир,   ,
  { {0x63a1002b, 0x61e40052, 0x00000000, 0x00000000}},  //   miln, _tiil,   ,
  { {0x68e91164, 0x63a10059, 0xf6520049, 0x00000000}},  //   _nged, liln, עצן_,
  { {0x27ed022b, 0x8b26007e, 0x27f80059, 0x00000000}},  // [1e60] _nuen_, здзе, _črno_,
  { {0x63a100ca, 0x68e91165, 0x69c00145, 0x00000000}},  //   niln, _aged, _skme,
  { {0x7c360018, 0x6ac60025, 0x5eda0044, 0x00000000}},  //   styr, أقام, _ব্রে,
  { {0x27ed0219, 0x290d000d, 0x7e610030, 0x00000000}},  //   _buen_, _ceea_, ælpe,
  { {0xa3cb02d2, 0x63a1010a, 0x7d041166, 0x00000000}},  //   लता_, kiln, mbis,
  { {0x27ed022b, 0x69d90455, 0x26c51167, 0x00000000}},  //   _duen_, amwe, _bylo_,
  { {0x63a11168, 0x68ed1169, 0xaa430364, 0x00000000}},  //   diln, žada, _перл,
  { {0x7f8b005f, 0xb60800b9, 0x69c00006, 0x00000000}},  //   _müqa, jišť, _ukme,
  { {0x63a10062, 0xdb05008e, 0x7d04116a, 0x00000000}},  //   filn, cohó, ibis,
  { {0x57fb009b, 0x7d040433, 0xfbbe0164, 0x00000000}},  //   _ללמו, hbis, ्तिम,
  { {0x27ed022b, 0x200900e7, 0x00000000, 0x00000000}},  //   _zuen_, _swai_,   ,
  { {0x7c24116b, 0x27ed0085, 0x00000000, 0x00000000}},  //   krir, _yuen_,   ,
  { {0x63a107e4, 0x777a002d, 0x5334007c, 0x00000000}},  //   biln, _kotx, _желт,
  { {0xdced016c, 0x00000000, 0x00000000, 0x00000000}},  //   rjač,   ,   ,
  { {0x433b00b6, 0x777a0c2f, 0xe3b30049, 0x00000000}},  //   _העוב, _motx, _אױס_,
  { {0x7c240207, 0x7d04011c, 0x442402d1, 0x00000000}},  //   frir, gbis, orm_,
  { {0x7c2401ed, 0xb60604eb, 0x00000000, 0x00000000}},  // [1e70] grir, lošć,   ,
  { {0x44240051, 0xeb9b0084, 0xdcef00e5, 0x00000000}},  //   irm_, حضرت_, _bocă,
  { {0x7d04116c, 0x7c240197, 0xb60604eb, 0x00000000}},  //   bbis, arir, nošć,
  { {0xdb1c0048, 0xf1bf00fa, 0x00000000, 0x00000000}},  //   _bhró, noá_,   ,
  { {0xdb17049a, 0x27ed116d, 0x98c70025, 0x00000000}},  //   loxí, _quen_, أغان,
  { {0x777a0129, 0x3dc910a5, 0x44240022, 0x00000000}},  //   _cotx, llaw_, drm_,
  { {0x63a101d9, 0xb606016c, 0x7d0f0010, 0x00000000}},  //   viln, jošć, _kecs,
  { {0x4975007e, 0x63a10036, 0x3dc90058, 0x00000000}},  //   _ўлас, wiln, nlaw_,
  { {0x63a10059, 0x69c3009d, 0x753b031a, 0x00000000}},  //   tiln, îneu, rfuz,
  { {0x645b00bb, 0x7d04116e, 0x7d0f0010, 0x00000000}},  //   rvui, zbis, _lecs,
  { {0x63a10059, 0xa91d0bf8, 0x65790600, 0x00000000}},  //   riln, _alži, _towh,
  { {0x7c24000c, 0x62810ad0, 0x7d0f00e5, 0x00000000}},  //   yrir, rylo, _necs,
  { {0x63a10dec, 0x3dc900e0, 0x31690288, 0x00000000}},  //   piln, dlaw_, _dnaz_,
  { {0x7c24116f, 0x25bf0a86, 0xf8ab0082, 0x00000000}},  //   vrir, loul_, _đời_,
  { {0x25ad0030, 0x7d040bb4, 0x7d0f1170, 0x00000000}},  //   onel_, tbis, _becs,
  { {0x25ad0549, 0x7c240065, 0x7f8b006b, 0x00000000}},  //   nnel_, trir, _vüqa,
  { {0x7d041171, 0xdca30bbd, 0x7c24115f, 0x00000000}},  // [1e80] rbis, вати, urir,
  { {0x7c24022b, 0x25bf000a, 0x00000000, 0x00000000}},  //   rrir, houl_,   ,
  { {0x3dc90016, 0x00000000, 0x00000000, 0x00000000}},  //   blaw_,   ,   ,
  { {0x7c240207, 0xdb1c0051, 0x3dc90051, 0x00000000}},  //   prir, _phró, claw_,
  { {0xb8f602d2, 0x25bf1172, 0x00000000, 0x00000000}},  //   _हर_, doul_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x9f8d000c, 0x00000000, 0x00000000, 0x00000000}},  //   nþá_,   ,   ,
  { {0xbf0a0061, 0x442400d9, 0x545400e2, 0x00000000}},  //   वरुन_, trm_, евит,
  { {0x29060020, 0x777a00d4, 0x660d016c, 0x00000000}},  //   mboa_, _totx, ćaka,
  { {0x4274007c, 0x2b580087, 0x00000000, 0x00000000}},  //   егос, _jarc_,   ,
  { {0x2b580129, 0x25bf1173, 0x32180161, 0x00000000}},  //   _marc_, boul_, éry_,
  { {0xc48601fb, 0xe4a6003b, 0xb606016c, 0x00000000}},  //   _олек, _орло, rošć,
  { {0xbf0a001c, 0xa3e703d7, 0xc0580245, 0x00000000}},  //   वरून_, _मंच_, мір_,
  { {0x0efb02fb, 0x47cc0044, 0x2b5809cc, 0x00000000}},  //   ्रेस_, াদকী, _narc_,
  { {0x3ceb1174, 0xf1bf00fa, 0x3dc90133, 0x00000000}},  //   _pgcv_, poá_, tlaw_,
  { {0xcdd8003b, 0x637f01c3, 0x00000000, 0x00000000}},  //   дњу_, _fêns,   ,
  { {0x7d0f0ede, 0x7d02008e, 0x2b58005b, 0x00000000}},  // [1e90] _vecs, ñosa, _barc_,
  { {0x8cd00061, 0xf4000044, 0x00000000, 0x00000000}},  //   _दररो, _এটার_,   ,
  { {0x7d0f005b, 0x2b5800fa, 0xdb1c0045, 0x00000000}},  //   _tecs, _darc_, _phrò,
  { {0x645c0089, 0x2d9201aa, 0x25f2013d, 0x00000000}},  //   ārij, chye_, ँदनी_,
  { {0x2b580b33, 0x201900b0, 0x6cfa00b3, 0x00000000}},  //   _farc_, nssi_, _מפרס,
  { {0x237c0521, 0x7c2d1175, 0x2b58004a, 0x00000000}},  //   _novj_, muar, _garc_,
  { {0x7c2d020c, 0x2bbe006e, 0x199500a5, 0x00000000}},  //   luar, ्तरा, _завя,
  { {0xc867005e, 0x290600f6, 0x00000000, 0x00000000}},  //   _отзи, cboa_,   ,
  { {0x25bf001a, 0x00000000, 0x00000000, 0x00000000}},  //   roul_,   ,   ,
  { {0x25ad0f46, 0x25bf1176, 0x69cb1177, 0x00000000}},  //   snel_, soul_, llge,
  { {0x25ad1178, 0x7c2d006c, 0x69cb0007, 0x00000000}},  //   pnel_, huar, olge,
  { {0x7c2d1179, 0xa3cf007d, 0x00000000, 0x00000000}},  //   kuar, _वीर_,   ,
  { {0x656b0375, 0xbcfb0051, 0x7c2d0065, 0x00000000}},  //   _ingh, _gnéi, juar,
  { {0xdb1e0065, 0x7c2d117a, 0x6d4d00e0, 0x00000000}},  //   ropë, duar, eeaa,
  { {0x442d0472, 0x20190026, 0x3c430089, 0x00000000}},  //   lue_, assi_, hīvā_,
  { {0x7c2d0048, 0x52740025, 0x00000000, 0x00000000}},  //   fuar, _جاهز,   ,
  { {0x2b5800f6, 0x7c2d0198, 0x442d030a, 0x00000000}},  // [1ea0] _parc_, guar, nue_,
  { {0x2d920061, 0x68fb000a, 0xe0d7007e, 0x00000000}},  //   shye_, _afud, _явы_,
  { {0xa926007c, 0x27ff0e65, 0x3ea600e2, 0x00000000}},  //   едел, _atun_, _чинг,
  { {0x442d117b, 0xb17b0039, 0x7c2d0023, 0x00000000}},  //   kue_, rmåg, buar,
  { {0xc7c601f9, 0x7c2d0f6a, 0x6e2e01bf, 0x00000000}},  //   нски, cuar, lubb,
  { {0x7d16117c, 0x656b117d, 0xfaa60069, 0x00000000}},  //   lays, _angh, _заго,
  { {0x442d009d, 0x21200022, 0xb81c0316, 0x00000000}},  //   eue_, _odih_, _निकम_,
  { {0x09e30098, 0x7d16011c, 0x442d00ea, 0x00000000}},  //   _босн, nays, fue_,
  { {0x6e2e0270, 0x98af007f, 0x00000000, 0x00000000}},  //   hubb, degė_,   ,
  { {0x656b018e, 0x5c370049, 0x2120000a, 0x00000000}},  //   _engh, ערין_, _adih_,
  { {0x7c2d1179, 0xbcfb009d, 0x2c520173, 0x00000000}},  //   zuar, _inév, _lņd_,
  { {0x6e2e1054, 0x442d117e, 0xdce60173, 0x00000000}},  //   dubb, bue_, _ankč,
  { {0x442d009d, 0x7c2d117f, 0xf1a4007e, 0x00000000}},  //   cue_, xuar, урэн,
  { {0x20190bac, 0x7c2d0023, 0x00000000, 0x00000000}},  //   rssi_, vuar,   ,
  { {0x656b018e, 0x6f150059, 0x6e2e0d47, 0x00000000}},  //   _yngh, razc, gubb,
  { {0x7c2201d5, 0x7c2d0238, 0x40950025, 0x00000000}},  //   ġorn, tuar, _للبر,
  { {0xb81c013d, 0x00000000, 0x00000000, 0x00000000}},  // [1eb0] _निगम_,   ,   ,
  { {0x6e2e0209, 0x7c2d1180, 0x3df50f93, 0x00000000}},  //   bubb, ruar, _изос,
  { {0x7d160061, 0x442d022b, 0x6d4d0961, 0x00000000}},  //   bays, zue_, peaa,
  { {0x3c430089, 0xa91d0059, 0x27ff0093, 0x00000000}},  //   tīvā_, _možg, _ptun_,
  { {0x7c2d0d87, 0xe10c0049, 0x442d1181, 0x00000000}},  //   quar, פּאָ, xue_,
  { {0x442d00f4, 0xa3cf013d, 0xf74501bd, 0x00000000}},  //   vue_, _वीं_, теко,
  { {0xead4007c, 0x00000000, 0x00000000, 0x00000000}},  //   _борь,   ,   ,
  { {0x442d00f4, 0x0565030d, 0x68fb005b, 0x00000000}},  //   tue_, твин, _ufud,
  { {0xe4320025, 0x00000000, 0x00000000, 0x00000000}},  //   لفيد,   ,   ,
  { {0x394f1182, 0x260e0061, 0xdb1e1183, 0x00000000}},  //   legs_, णीही_, topé,
  { {0x442d0038, 0x2000001a, 0x36750025, 0x00000000}},  //   sue_, _stii_, _جهاز,
  { {0xdb1e1184, 0x656b0412, 0x00000000, 0x00000000}},  //   ropé, _ungh,   ,
  { {0x442d032c, 0x8edf0055, 0x7bde0161, 0x00000000}},  //   que_, _ব্লগ, ympu,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6da600ed, 0x7d02004a, 0x00000000, 0x00000000}},  //   вива, ñoso,   ,
  { {0x12e80049, 0x320500ab, 0xdd920445, 0x00000000}},  //   _אַפּ, mply_, جور_,
  { {0xa91d0119, 0x2bf6007c, 0x6e2e0093, 0x00000000}},  // [1ec0] _možd, тябр, subb,
  { {0x6e2e01bc, 0x7d16006a, 0xaf0a0025, 0x00000000}},  //   pubb, says, _تقدم_,
  { {0x7d16009d, 0x00000000, 0x00000000, 0x00000000}},  //   pays,   ,   ,
  { {0x637e00b9, 0x00000000, 0x00000000, 0x00000000}},  //   _záně,   ,   ,
  { {0xe94700a1, 0xfbd100a1, 0xd90d009e, 0x00000000}},  //   ئرمی, شتے_, ثیق_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6ae00055, 0x98b2014a, 0x00000000, 0x00000000}},  //   _প্রো, ıyı_,   ,
  { {0x80d30061, 0x00000000, 0x00000000, 0x00000000}},  //   _ठरले,   ,   ,
  { {0xdb1c00b9, 0x00000000, 0x00000000, 0x00000000}},  //   _zkrá,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xc56a0025, 0x00000000, 0x00000000, 0x00000000}},  //   _يحصل_,   ,   ,
  { {0x316d04a8, 0xfbdf0016, 0x00000000, 0x00000000}},  //   ñez_, _apêl_,   ,
  { {0x60d60036, 0x94760025, 0x9054007e, 0x00000000}},  //   _czym, _جداا, авяц,
  { {0x547b00b6, 0x32660264, 0x9e350a78, 0x00000000}},  //   _קטגו, _атив, легч,
  { {0xdb06013e, 0x00000000, 0x00000000, 0x00000000}},  //   ámýc,   ,   ,
  { {0x7bc705cb, 0x6288005b, 0xa91d0161, 0x00000000}},  //   _skju, mydo, _kože,
  { {0xdb1c1185, 0xfbd907d8, 0x6288007f, 0x00000000}},  // [1ed0] _skrá, едај_, lydo,
  { {0xa91d0119, 0x8f5501fb, 0x63a800e0, 0x00000000}},  //   _može, _свої, nidn,
  { {0x61ed1186, 0x75221187, 0x7ac4007e, 0x00000000}},  //   _kial, _odoz, асце,
  { {0x61ed0022, 0x798010e4, 0xafdb0190, 0x00000000}},  //   _jial, _comw, stød,
  { {0xa3c2001c, 0x6d5d0051, 0x61ed0036, 0x00000000}},  //   ंवा_, _iasa, _mial,
  { {0x75221188, 0x61ed1189, 0xab8401ab, 0x00000000}},  //   _adoz, _lial, _куск,
  { {0x6d5d0811, 0xe5a5019d, 0x27ec00ab, 0x00000000}},  //   _kasa, лики, _didn_,
  { {0xe459005e, 0x6d5d002d, 0x60cd118a, 0x00000000}},  //   ежи_, _jasa, _oyam,
  { {0x6d5d0d56, 0xa91d01ee, 0x69c90058, 0x00000000}},  //   _masa, _vožd, _ikee,
  { {0x6d5d118b, 0x7522022b, 0x2bd9013d, 0x00000000}},  //   _lasa, _edoz, _बीमा,
  { {0x61ed0a49, 0x60d60036, 0xe7840072, 0x00000000}},  //   _bial, _szym, _туто,
  { {0x61ed118c, 0x6d5d006a, 0x60cd0009, 0x00000000}},  //   _cial, _nasa, _byam,
  { {0x34390049, 0x7bc5006c, 0x60cd0009, 0x00000000}},  //   _נײַע, kohu, _cyam,
  { {0x94740879, 0x443f118d, 0x32050837, 0x00000000}},  //   _خدما, mtu_, pply_,
  { {0x6d5d006a, 0x62880036, 0x22580030, 0x00000000}},  //   _basa, cydo, ærkt_,
  { {0x6d5d00d6, 0x61ed0207, 0xed57007c, 0x00000000}},  //   _casa, _gial, лос_,
  { {0x6d5d020c, 0xbcfb00f6, 0x20040051, 0x00000000}},  // [1ee0] _dasa, _anés, ímid_,
  { {0x443f0288, 0xa09b01ce, 0x69c9118e, 0x00000000}},  //   itu_, _נייט, _akee,
  { {0x443f118f, 0x69db0051, 0x00000000, 0x00000000}},  //   htu_, _bhue,   ,
  { {0x69db001c, 0x644b0030, 0x8d560072, 0x00000000}},  //   _chue, _opgi, _сточ,
  { {0x443f1190, 0xa2ca007d, 0x8eb30014, 0x00000000}},  //   jtu_, _सुन्, _نمیش,
  { {0x6d5d1191, 0xdb1c0698, 0xcb76003b, 0x00000000}},  //   _zasa, _skræ, _сумњ,
  { {0x6d5d011f, 0xbb3b01ce, 0x56941192, 0x00000000}},  //   _yasa, _רעלי, райт,
  { {0xa91d0091, 0x7df50006, 0x77920014, 0x00000000}},  //   _pože, _sąsk, _گیتا,
  { {0x61ed002a, 0x63a80039, 0x2d8200ca, 0x00000000}},  //   _rial, tidn, _moke_,
  { {0x61ed005b, 0xa91d0a0f, 0x2d821092, 0x00000000}},  //   _sial, _vože, _loke_,
  { {0x61ed0169, 0x443f002d, 0x60cd04be, 0x00000000}},  //   _pial, atu_, _syam,
  { {0x443f0169, 0x3f811193, 0x62881194, 0x00000000}},  //   btu_, _sohu_, rydo,
  { {0x629a0e17, 0x6d5d0127, 0x61ed0207, 0x00000000}},  //   szto, _rasa, _vial,
  { {0x60cd0020, 0x6d5d1084, 0xd3700025, 0x00000000}},  //   _vyam, _sasa, _ذهب_,
  { {0xcddb03f3, 0x6d4403c5, 0x61ed0275, 0x00000000}},  //   ења_, ffia, _tial,
  { {0x7ae11195, 0x2d580e09, 0x2d8201a3, 0x00000000}},  //   _últi, лись_, _coke_,
  { {0x6d5d0a5c, 0x5b150242, 0x65600051, 0x00000000}},  // [1ef0] _vasa, имат, idmh,
  { {0x6d5d1196, 0x7bdc1197, 0x69c90160, 0x00000000}},  //   _wasa, _chru, _skee,
  { {0x6d5d1198, 0x443f022b, 0x2cae005f, 0x00000000}},  //   _tasa, ztu_, _əldə_,
  { {0x6d5d0051, 0xbcfb004a, 0x64400a2f, 0x00000000}},  //   _uasa, _enér, ktmi,
  { {0x443f01ca, 0x99870010, 0xb8fd006e, 0x00000000}},  //   xtu_, énő_, _डर_,
  { {0x8ae70822, 0x7d0d0190, 0x660500ed, 0x00000000}},  //   _бібл, lbas, апка,
  { {0x69db1199, 0x7d0d0288, 0x01d60044, 0x00000000}},  //   _thue, obas, _সংসদ,
  { {0x443f0f3c, 0x7c2d0207, 0x1425007c, 0x00000000}},  //   ttu_, orar, адим,
  { {0x99840054, 0x4375005e, 0x765a0016, 0x00000000}},  //   _القو, аунт, _esty,
  { {0x443f119a, 0x395f010f, 0x657b01c2, 0x00000000}},  //   rtu_, _haus_, sjuh,
  { {0x443f009f, 0x659503e0, 0xe10a026b, 0x00000000}},  //   stu_, _кажу, кенд_,
  { {0x9f49009f, 0x443f0209, 0x7c2d049d, 0x00000000}},  //   _stað_, ptu_, krar,
  { {0x7d0d0146, 0x2d820059, 0x395f119b, 0x00000000}},  //   dbas, _roke_, _maus_,
  { {0x765a018e, 0x23290088, 0x7c2d119c, 0x00000000}},  //   _ysty, _роки_, drar,
  { {0xdee60407, 0xeab00055, 0xa3c2024c, 0x00000000}},  //   рови, _কর্ম, ंवर_,
  { {0x442d0198, 0x7d0d119d, 0x395f00d4, 0x00000000}},  //   ore_, gbas, _naus_,
  { {0x442d00f4, 0x6d44119e, 0xed5700e2, 0x00000000}},  // [1f00] nre_, rfia, шот_,
  { {0x442d119f, 0x7d0d11a0, 0x3160002d, 0x00000000}},  //   ire_, abas, _haiz_,
  { {0x6f1c04bd, 0x442d001f, 0x7d0d0039, 0x00000000}},  //   marc, hre_, bbas,
  { {0x442d0e58, 0x7c2d00ab, 0xdb1c0039, 0x00000000}},  //   kre_, brar, _skrä,
  { {0x7c2d001a, 0x442d0030, 0x4bd100a1, 0x00000000}},  //   crar, jre_, _کےلئ,
  { {0x442d02cc, 0x7df50fed, 0x6f1c0122, 0x00000000}},  //   dre_, _sąsi, narc,
  { {0x442d0555, 0xd5ba00e3, 0x660300ed, 0x00000000}},  //   ere_, кси_, опја,
  { {0x442d11a1, 0x3160022b, 0x6f1c0051, 0x00000000}},  //   fre_, _naiz_, harc,
  { {0x6fc60061, 0x3e5801aa, 0x57ea0bb8, 0x00000000}},  //   लकां, _lōt_, _адам_,
  { {0x46a60265, 0x937800ed, 0x883b009b, 0x00000000}},  //   _казв, убот_, _בתמו,
  { {0x6440006c, 0x321e11a2, 0x442d11a3, 0x00000000}},  //   stmi, usty_, are_,
  { {0x442d11a4, 0x044600e3, 0x6f170240, 0x00000000}},  //   bre_, _ведн, _sexc,
  { {0x6f1c0544, 0x442d00f4, 0x2fc70011, 0x00000000}},  //   farc, cre_, _ưng_,
  { {0x6f1c027b, 0x7c2d03c7, 0xa91d11a5, 0x00000000}},  //   garc, vrar, _moža,
  { {0x31600180, 0xa91d016c, 0xbe8811a6, 0x00000000}},  //   _faiz_, _loža, асте_,
  { {0xf27b0452, 0x527b0104, 0x31600288, 0x00000000}},  //   _ירוש, _ינוא, _gaiz_,
  { {0x7d0d11a7, 0xdce60006, 0x395f010f, 0x00000000}},  // [1f10] rbas, _mokė, _raus_,
  { {0x7c2d11a8, 0x6f1c001a, 0x7d0d00ea, 0x00000000}},  //   rrar, carc, sbas,
  { {0x395f00f8, 0x7d0d0e9c, 0x442d0010, 0x00000000}},  //   _paus_, pbas, zre_,
  { {0x442d11a9, 0xa91d0825, 0x7c2d007f, 0x00000000}},  //   yre_, _boža, prar,
  { {0x4dda009b, 0x67d500ed, 0x9f4007f0, 0x00000000}},  //   _תחרו, боду, _guió_,
  { {0x442d028c, 0x6747007e, 0xd8740014, 0x00000000}},  //   vre_, рэдз, تامب,
  { {0xa6c903c8, 0x3618008b, 0xaa950025, 0x00000000}},  //   ылка_, ацыю_, _الأث,
  { {0x442d0a8d, 0xa2c10061, 0xa3cf0061, 0x00000000}},  //   tre_, _रुग्, _वीज_,
  { {0x442d03d5, 0x7f8b005f, 0x291d006a, 0x00000000}},  //   ure_, _hüqu, mawa_,
  { {0x291d006a, 0x61f80521, 0x316001a3, 0x00000000}},  //   lawa_, _buvl, _saiz_,
  { {0x442d0047, 0xa2ca0061, 0x6f1c0e1c, 0x00000000}},  //   sre_, _सुद्, varc,
  { {0x442d11aa, 0x291d006a, 0x568c007b, 0x00000000}},  //   pre_, nawa_, _שטאַ,
  { {0x7dfc01aa, 0xa4d40088, 0xafe60088, 0x00000000}},  //   _pčso, _доці, йомл,
  { {0x291d0127, 0xafe60d51, 0xb17b0c73, 0x00000000}},  //   hawa_, согл, lmål,
  { {0x291d0e74, 0x2d960930, 0x00000000, 0x00000000}},  //   kawa_, брас,   ,
  { {0x6f1c0412, 0x291d00e7, 0xb17b0ccc, 0x00000000}},  //   sarc, jawa_, nmål,
  { {0x6f1c11ab, 0xdd8f0025, 0xcaf60025, 0x00000000}},  // [1f20] parc, روك_, مساب,
  { {0xc4d208cd, 0x3b18002b, 0x00000000, 0x00000000}},  //   לגן_, _qerq_,   ,
  { {0x25ad11ac, 0xdb070047, 0xb17b043e, 0x00000000}},  //   kiel_, ámár, kmål,
  { {0x291d11ad, 0xa91d11ae, 0x38cb00a6, 0x00000000}},  //   gawa_, _poža, گامی_,
  { {0x53c702f4, 0x25ad0027, 0xb5fc002b, 0x00000000}},  //   रकाश, diel_, _irġi,
  { {0x9b960025, 0x6d56006b, 0xaa0800a1, 0x00000000}},  //   _الست, leya, _نعرے_,
  { {0x25ad02ae, 0x3a210061, 0x291d033b, 0x00000000}},  //   fiel_, cshp_, bawa_,
  { {0x2d8001d6, 0xd943017a, 0x1dc80061, 0x00000000}},  //   njie_, _неси, लवित,
  { {0x764310ed, 0xa91d047c, 0x61f811af, 0x00000000}},  //   atny, _kožn, _suvl,
  { {0x5c5b0476, 0x388e0089, 0x00000000, 0x00000000}},  //   נדיק, _vērā_,   ,
  { {0xa91d11b0, 0x25ad0250, 0xcb1300b3, 0x00000000}},  //   _možn, biel_, הלת_,
  { {0x25ad11b1, 0xa91d00b9, 0x7df50006, 0x00000000}},  //   ciel_, _ložn, _mąst,
  { {0x2d800007, 0x23e601e1, 0x7df50006, 0x00000000}},  //   djie_, _лікв, _ląst,
  { {0x291d0046, 0xdbf10224, 0x92940893, 0x00000000}},  //   zawa_, _příl, _малц,
  { {0x656200e0, 0x04b700a1, 0x291d05cd, 0x00000000}},  //   _kaoh, _نھیں_, yawa_,
  { {0x2d800023, 0x00000000, 0x00000000, 0x00000000}},  //   gjie_,   ,   ,
  { {0x4dd40025, 0x656211b2, 0x21290145, 0x00000000}},  // [1f30] ستفس, _maoh, _idah_,
  { {0xdea401ef, 0x291d09bd, 0x25ad0e42, 0x00000000}},  //   _کیفی, wawa_, ziel_,
  { {0x291d03b0, 0x9f84006c, 0xdab90025, 0x00000000}},  //   tawa_, töö_, جهات_,
  { {0x291d0020, 0xe3b8006b, 0x8f5500a2, 0x00000000}},  //   uawa_, hnı_, _انگش,
  { {0xf77006c6, 0x25ad010f, 0x2d99046a, 0x00000000}},  //   کان_, viel_, _ilse_,
  { {0x291d11b3, 0x7761006b, 0x5fc90061, 0x00000000}},  //   sawa_, _qalx, ळविल,
  { {0x1995007e, 0x291d11b4, 0x25ad0253, 0x00000000}},  //   _давя, pawa_, tiel_,
  { {0x7d1f0023, 0x764311b5, 0x200901a3, 0x00000000}},  //   naqs, rtny, _otai_,
  { {0x69cb00b5, 0x25ad028c, 0xb17b11b6, 0x00000000}},  //   moge, riel_, rmål,
  { {0x42250088, 0x249f11b7, 0xb17b11b8, 0x00000000}},  //   одов, rzum_, smål,
  { {0x80d10055, 0x25ad010f, 0x09b50049, 0x00000000}},  //   সেম্, piel_, ַפֿט_,
  { {0x2d9900d9, 0x00000000, 0x00000000, 0x00000000}},  //   _nlse_,   ,   ,
  { {0x6d560e9e, 0xb5c80014, 0x00000000, 0x00000000}},  //   veya, _اونم_,   ,
  { {0x6d560022, 0xaab9013d, 0x2d9900f6, 0x00000000}},  //   weya, _आशंक, _alse_,
  { {0x59c902fb, 0x2d800343, 0xa91d11b9, 0x00000000}},  //   िकार, tjie_, _rožn,
  { {0x753b000b, 0x69cb01ee, 0x7df5007f, 0x00000000}},  //   nguz, joge, _rąst,
  { {0x3b86005e, 0x6d5611ba, 0x8c4300ed, 0x00000000}},  // [1f40] олаг, reya, мете,
  { {0x2d990406, 0x6d5601aa, 0x394d0145, 0x00000000}},  //   _else_, seya, _abes_,
  { {0xe8fa0072, 0xa91d0f3a, 0x6d5611bb, 0x00000000}},  //   але_, _vožn, peya,
  { {0x69cb00eb, 0xfd120025, 0x7d1f006b, 0x00000000}},  //   goge, _تجد_, caqs,
  { {0x7d0411bc, 0xa91d0059, 0x386d00c4, 0x00000000}},  //   mcis, _tožn, _crer_,
  { {0x7c240051, 0x7d0411bd, 0xf0930104, 0x00000000}},  //   msir, lcis, ונד_,
  { {0x69cb0c53, 0x41ca0164, 0x7c240d61, 0x00000000}},  //   boge, रवास, lsir,
  { {0x69cb0211, 0x0d970049, 0x386d000a, 0x00000000}},  //   coge, ַכים_, _frer_,
  { {0x7c240363, 0xdb1e0030, 0xc31e0044, 0x00000000}},  //   nsir, ropæ, _দাবি_,
  { {0x7792007a, 0x7c2411be, 0x21290085, 0x00000000}},  //   _زیبا, isir, _sdah_,
  { {0x200911bf, 0x8afb0049, 0x7dfc0173, 0x00000000}},  //   _stai_, יליז, _dčsk,
  { {0x96330245, 0x7c240145, 0xa1940245, 0x00000000}},  //   _ініц, ksir, даюч,
  { {0x48b80044, 0xa2ca007d, 0x78a20161, 0x00000000}},  //   _জরুর, _सुर्, nzov,
  { {0x09b70164, 0xc05801fb, 0x69cb010f, 0x00000000}},  //   _अद्य, цію_, zoge,
  { {0x7c2603b1, 0x212900d6, 0x8d770025, 0x00000000}},  //   _avkr, _tdah_, يارا,
  { {0x7c24000b, 0x21290762, 0x752000e7, 0x00000000}},  //   fsir, _udah_, namz,
  { {0x69cb054e, 0x1b1f0044, 0x442601ee, 0x00000000}},  // [1f50] voge, _পাবে_, _jvo_,
  { {0x09b30365, 0x63ba010f, 0x69cb11c0, 0x00000000}},  //   ंच्य, nntn, woge,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x442601cd, 0x7d040026, 0x00000000, 0x00000000}},  //   _ovo_, ccis,   ,
  { {0x18690175, 0x442611c1, 0x6c790049, 0x00000000}},  //   сали_, _nvo_, _האָפ,
  { {0xbdf800a6, 0x7d1d010f, 0x69cb11c2, 0x00000000}},  //   _دریا_, _hess, soge,
  { {0x69cb00ea, 0x442605e0, 0x29dc11c3, 0x00000000}},  //   poge, _avo_, mían_,
  { {0xc4850331, 0x29dc11c4, 0x386d00ea, 0x00000000}},  //   злик, lían_, _trer_,
  { {0x7d1d11c5, 0x93790025, 0xe3b10355, 0x00000000}},  //   _mess, مصدر_, فرد_,
  { {0xf8ae00e9, 0x29dc0211, 0x798901b5, 0x00000000}},  //   _حکم_, nían_, _hoew,
  { {0x44260119, 0x6d4f0a32, 0x216a017f, 0x00000000}},  //   _evo_, _obca, бини_,
  { {0x7d1d024e, 0xe6100014, 0x00000000, 0x00000000}},  //   _ness, _ششم_,   ,
  { {0xb4fa00b6, 0x92b50123, 0x764b0006, 0x00000000}},  //   _הפני, تحکا, žnyč,
  { {0x7c24001c, 0x6dac014a, 0x798901a2, 0x00000000}},  //   vsir, rşam, _loew,
  { {0x7d1d001f, 0x29dc008e, 0x2d9607d0, 0x00000000}},  //   _bess, dían_, прас,
  { {0x7d1d11c6, 0xb88301dc, 0x91e3005e, 0x00000000}},  //   _cess, _klíč, _поще,
  { {0x7d0400ab, 0xe3190082, 0x21220068, 0x00000000}},  // [1f60] rcis, _điể, makh_,
  { {0x7c2401a3, 0xa01b00b0, 0x6d4f11c7, 0x00000000}},  //   rsir, pyör, _ebca,
  { {0x4efb00b6, 0x7c240acc, 0xc33200b6, 0x00000000}},  //   _להיו, ssir, תוב_,
  { {0x7d1d11c8, 0x7c2411c9, 0x44240133, 0x00000000}},  //   _gess, psir, ysm_,
  { {0x29dc0211, 0x7c2411ca, 0x61e40051, 0x00000000}},  //   bían_, qsir, _mhil,
  { {0xc7a303f3, 0x07a3012b, 0x29dc0211, 0x00000000}},  //   ничк, начн, cían_,
  { {0x44260359, 0xdb1e010f, 0x7d1d0145, 0x00000000}},  //   _svo_, ropä, _yess,
  { {0x2abb009b, 0x442611cb, 0x798901d6, 0x00000000}},  //   _המלא, _pvo_, _goew,
  { {0x3a3a01d5, 0xa507003b, 0x75200ba5, 0x00000000}},  //   lupp_, чења_, ramz,
  { {0xe44f0b59, 0x44260640, 0x00000000, 0x00000000}},  //   اضي_, _vvo_,   ,
  { {0x61e40048, 0x44240fd1, 0x00000000, 0x00000000}},  //   _bhil, ssm_,   ,
  { {0x61e409d9, 0x4426000c, 0x00000000, 0x00000000}},  //   _chil, _tvo_,   ,
  { {0x7d1d028c, 0xa91d11cc, 0x442611cd, 0x00000000}},  //   _ress, _božj, _uvo_,
  { {0x60c40009, 0x64470035, 0x61e40026, 0x00000000}},  //   _dxim, ăjit, _ehil,
  { {0x7d1d02d5, 0xd3e501ef, 0x29dc008e, 0x00000000}},  //   _pess, _تقوی, vían_,
  { {0x61e40035, 0x5d6402dc, 0x00000000, 0x00000000}},  //   _ghil, нтуз,   ,
  { {0x79890022, 0x29dc008e, 0x6ecd0309, 0x00000000}},  // [1f70] _roew, tían_, _दुरु,
  { {0x7d1d0168, 0x798911ce, 0x7e610190, 0x00000000}},  //   _wess, _soew, ælps,
  { {0x7d1d054f, 0x29dc0211, 0xecf90451, 0x00000000}},  //   _tess, rían_, _менш_,
  { {0xafdb00ea, 0x61e40023, 0x00000000, 0x00000000}},  //   ktøk, _xhil,   ,
  { {0xa3c10061, 0x6d4d0022, 0x00000000, 0x00000000}},  //   ्कम_, mfaa,   ,
  { {0x2d8b11cf, 0x6d4d04fd, 0x00000000, 0x00000000}},  //   _hoce_, lfaa,   ,
  { {0x6b83000c, 0x79890116, 0xc7c8007e, 0x00000000}},  //   öngu, _toew, чыце_,
  { {0x6d4d11d0, 0x2409007c, 0x799b0022, 0x00000000}},  //   nfaa, онии_, _uluw,
  { {0xd469007c, 0xafdb0190, 0x00000000, 0x00000000}},  //   ципе_, rtøj,   ,
  { {0x61e40020, 0x69d9010f, 0x9f53009d, 0x00000000}},  //   _shil, llwe, _fixé_,
  { {0x67230340, 0x95cb0954, 0x00000000, 0x00000000}},  //   manj, _луда_,   ,
  { {0x67230149, 0x2d8b07ad, 0x6f1e00e5, 0x00000000}},  //   lanj, _noce_, _sepc,
  { {0xbf090061, 0x81c20044, 0x291f00d4, 0x00000000}},  //   वडून_, ্গল_, _meua_,
  { {0x61e40038, 0x656911d1, 0x672311d2, 0x00000000}},  //   _whil, ldeh, nanj,
  { {0x2d8b0166, 0x00000000, 0x00000000, 0x00000000}},  //   _boce_,   ,   ,
  { {0x672311d3, 0xf2d20452, 0x656911d4, 0x00000000}},  //   hanj, _שעה_, ndeh,
  { {0x6449021e, 0x672301ae, 0x2d8b029d, 0x00000000}},  // [1f80] ntei, kanj, _doce_,
  { {0x67230e3b, 0xd9b8006e, 0x68fb0b33, 0x00000000}},  //   janj, ेक्ट, _agud,
  { {0x67230295, 0x64490bac, 0x236701d9, 0x00000000}},  //   danj, htei, _manj_,
  { {0x3a3a0039, 0x2d8b0023, 0xdce4012d, 0x00000000}},  //   rupp_, _goce_, ldič,
  { {0x26030219, 0xdcb90057, 0xdb0e000c, 0x00000000}},  //   _año_, _ещё_, þjón,
  { {0x67230e3b, 0x656900c1, 0x31bb0309, 0x00000000}},  //   ganj, edeh, _उद्ध,
  { {0xc34e0011, 0x6e3c004a, 0x64490052, 0x00000000}},  //   _bổng_, nurb, etei,
  { {0xc34e0011, 0x644900db, 0x00000000, 0x00000000}},  //   _cổng_, ftei,   ,
  { {0x672300ee, 0x29e8006b, 0x39440181, 0x00000000}},  //   banj, _uşaq_, _icms_,
  { {0x67230119, 0x6e3c000c, 0x96960c96, 0x00000000}},  //   canj, kurb, _ореш,
  { {0xa29401ff, 0x644911d5, 0x777a002d, 0x00000000}},  //   хані, atei, _intx,
  { {0x14af0061, 0x644901a2, 0x6e3c000c, 0x00000000}},  //   _जेवण, btei, durb,
  { {0x2d8b0224, 0x14e202f4, 0x644911d6, 0x00000000}},  //   _roce_, _परिण, ctei,
  { {0x61ee0027, 0x39440085, 0x6e3c0133, 0x00000000}},  //   _ďale, _lcms_, furb,
  { {0x2bbf0164, 0x6e3c000c, 0xdb0e00f6, 0x00000000}},  //   ्वसा, gurb, _imbè,
  { {0x23670381, 0x67230ecc, 0x7d160007, 0x00000000}},  //   _zanj_, zanj, gbys,
  { {0x2d8b11d7, 0x672311d8, 0xf1bf04bb, 0x00000000}},  // [1f90] _voce_, yanj, mná_,
  { {0x6e3c07b8, 0xf1bf015f, 0x291f0129, 0x00000000}},  //   burb, lná_, _seua_,
  { {0x6723092f, 0x6e3c0173, 0x644911d9, 0x00000000}},  //   vanj, curb, ztei,
  { {0x67230020, 0x777a002d, 0xf1bf0d86, 0x00000000}},  //   wanj, _antx, nná_,
  { {0x672301cd, 0xa91d00ca, 0x644911da, 0x00000000}},  //   tanj, _joži, xtei,
  { {0xf7710025, 0xa3dd013d, 0x06b00044, 0x00000000}},  //   طات_, _थीं_, _ছড়ি,
  { {0x672311db, 0x92c20055, 0xe9190088, 0x00000000}},  //   ranj, ্ধু_, _нові_,
  { {0x6723016c, 0x6449021e, 0xf1bf01ca, 0x00000000}},  //   sanj, ttei, jná_,
  { {0xf1bf01ca, 0x756800a1, 0xa91d040d, 0x00000000}},  //   dná_, بینہ_, _noži,
  { {0x644911dc, 0x43740152, 0x656901a2, 0x00000000}},  //   rtei, вуют, sdeh,
  { {0xc34e001d, 0xfbd200b6, 0xb34500c4, 0x00000000}},  //   _tổng_, רתי_, _acçã,
  { {0x395d07ec, 0xa91d0209, 0x644911dd, 0x00000000}},  //   news_, _boži, ptei,
  { {0x25bf000d, 0x4395007e, 0x6601006c, 0x00000000}},  //   mnul_, _падс, _hulk,
  { {0xa91d0340, 0x660100b0, 0x81bd0089, 0x00000000}},  //   _doži, _kulk, nsēj,
  { {0x6601021e, 0xe2990245, 0xf1bf06b8, 0x00000000}},  //   _julk, _хай_, bná_,
  { {0x6e3c00f6, 0xdd920355, 0xdb0e0299, 0x00000000}},  //   rurb, دور_, _imbé,
  { {0xdca30088, 0x7d1611de, 0xc5f200a0, 0x00000000}},  // [1fa0] гати, rbys, רדן_,
  { {0x672108b2, 0x7d16018e, 0xf4010055, 0x00000000}},  //   _nelj, sbys, _এবার_,
  { {0x1b1f0044, 0xdb1c11df, 0x25bf0c76, 0x00000000}},  //   _পাশে_, _skró, knul_,
  { {0x6da60088, 0xaa570025, 0x08c600e2, 0x00000000}},  //   _чима, علنا_, нбен,
  { {0x1b1f0055, 0x672100ca, 0xa3c1007d, 0x00000000}},  //   _পারে_, _belj, ्का_,
  { {0x660111e0, 0x672101d9, 0xd7ef0025, 0x00000000}},  //   _bulk, _celj, مكن_,
  { {0x66010173, 0x67210087, 0xdb1c0036, 0x00000000}},  //   _culk, _delj, _wkró,
  { {0x66010006, 0x25bf11e1, 0x6b8e0943, 0x00000000}},  //   _dulk, gnul_, _hobg,
  { {0xe73a00ed, 0x5ed20061, 0xf1bf06b8, 0x00000000}},  //   _неа_, _दुसऱ, vná_,
  { {0xc4530054, 0xa91d11e2, 0x25bf0035, 0x00000000}},  //   اضيع, _roži, anul_,
  { {0xf1bf0d86, 0x363600a2, 0xa91d00ca, 0x00000000}},  //   tná_, _سراس, _soži,
  { {0xa91d0027, 0x67210825, 0x00000000, 0x00000000}},  //   _poži, _zelj,   ,
  { {0x5577007b, 0xf1bf0428, 0x660111e3, 0x00000000}},  //   _רעדן_, rná_, _zulk,
  { {0xe47b0097, 0xf1bf0161, 0x6d460bca, 0x00000000}},  //   _מרדכ, sná_, _acka,
  { {0xf1bf0161, 0x00000000, 0x00000000, 0x00000000}},  //   pná_,   ,   ,
  { {0x13d50055, 0xcdd8012b, 0xa91d0059, 0x00000000}},  //   _হওয়, ењу_, _toži,
  { {0x41c40426, 0x00000000, 0x00000000, 0x00000000}},  // [1fb0] _حقيق,   ,   ,
  { {0x79990022, 0x752200fa, 0x00000000, 0x00000000}},  //   wkww, _leoz,   ,
  { {0x75e5008e, 0x672101ed, 0x7cea0010, 0x00000000}},  //   nózc, _relj, töré,
  { {0xc9840057, 0x752211e4, 0x98b900e2, 0x00000000}},  //   лучи, _neoz, млет_,
  { {0x660111e5, 0x67210e0d, 0xf7450264, 0x00000000}},  //   _sulk, _pelj, вело,
  { {0x66010089, 0xb17b00f8, 0xec3600b3, 0x00000000}},  //   _pulk, llåd, _באשר_,
  { {0x672111e6, 0x0cc40044, 0xbbbf0309, 0x00000000}},  //   _velj, ্ধৃত, ्वीक,
  { {0x25bf0035, 0x00000000, 0x00000000, 0x00000000}},  //   unul_,   ,   ,
  { {0x672111e7, 0x9f5304bd, 0x25bf001a, 0x00000000}},  //   _telj, _així_, rnul_,
  { {0x660111e8, 0xe8741019, 0xc6a7007c, 0x00000000}},  //   _tulk, _حافظ, _преи,
  { {0xb2f4007c, 0x2ca911e9, 0x332500fa, 0x00000000}},  //   ляющ, hzad_, ralx_,
  { {0xe2960b87, 0x7afa11ea, 0x75c8013e, 0x00000000}},  //   таю_, _útte, těze,
  { {0x2ca905fa, 0x00000000, 0x00000000, 0x00000000}},  //   jzad_,   ,   ,
  { {0x656b002a, 0x7522002d, 0x443f0052, 0x00000000}},  //   _hagh, _zeoz, muu_,
  { {0x443f00b0, 0x7e230545, 0x00000000, 0x00000000}},  //   luu_, идрж,   ,
  { {0xfce601e0, 0xdde90431, 0x656b002b, 0x00000000}},  //   вобо, فرقه_, _jagh,
  { {0x656b1084, 0x443f11eb, 0x00000000, 0x00000000}},  // [1fc0] _magh, nuu_,   ,
  { {0x656b11ec, 0x4e060242, 0xaaba02fd, 0x00000000}},  //   _lagh, _изоб, ودار_,
  { {0x6a86005e, 0xbea602e9, 0x443f00b0, 0x00000000}},  //   ължа, _ранк, huu_,
  { {0x443f11ed, 0x656b11ee, 0x3f8a0107, 0x00000000}},  //   kuu_, _nagh, ljbu_,
  { {0x92bd0055, 0x91fc001e, 0x443f006c, 0x00000000}},  //   _আরো_, nvār, juu_,
  { {0x6d440006, 0x244b0030, 0xeb9f068f, 0x00000000}},  //   lgia, døm_, _støv_,
  { {0x656b0190, 0x6459000a, 0xacbb009d, 0x00000000}},  //   _bagh, _apwi, _jeûn,
  { {0x6d44010a, 0x7bde06b9, 0x443f0020, 0x00000000}},  //   ngia, llpu, fuu_,
  { {0x443f0020, 0x656b011c, 0x91fc0089, 0x00000000}},  //   guu_, _dagh, jvār,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xbb3b009b, 0x326302dc, 0xc7d7034e, 0x00000000}},  //   ועיי, атяв, _יומי_,
  { {0x80d10055, 0x69c20016, 0x443f1080, 0x00000000}},  //   _সৃষ্, nnoe, buu_,
  { {0x0443003b, 0x64a302dc, 0xb17b00f8, 0x00000000}},  //   _вечн, _каца, vlåd,
  { {0x644011ef, 0x656b11f0, 0x6d4403d3, 0x00000000}},  //   mumi, _zagh, egia,
  { {0x64400207, 0xa3c102fb, 0x75e50010, 0x00000000}},  //   lumi, ्कर_, lóza,
  { {0x6d440198, 0x656b11f1, 0x00000000, 0x00000000}},  //   ggia, _xagh,   ,
  { {0x644011f2, 0x00000000, 0x00000000, 0x00000000}},  // [1fd0] numi,   ,   ,
  { {0x765a0036, 0x5b140088, 0xd24d00a1, 0x00000000}},  //   _opty, имут, _بچی_,
  { {0x6440000b, 0x6d440082, 0x443f11f3, 0x00000000}},  //   humi, bgia, zuu_,
  { {0x644011f4, 0x99d10044, 0x61fe009d, 0x00000000}},  //   kumi, িষ্ক, _éplu,
  { {0x6440001e, 0x656b11f5, 0x97d90f62, 0x00000000}},  //   jumi, _ragh, ньку_,
  { {0x644006ad, 0xb60501c8, 0x7d0d0afb, 0x00000000}},  //   dumi, hláš, lcas,
  { {0x99670517, 0x656b006a, 0x45d50893, 0x00000000}},  //   _итал, _pagh, лцит,
  { {0x7d0d023a, 0x4efc00b6, 0x443f00b0, 0x00000000}},  //   ncas, ולוג, tuu_,
  { {0x644011f6, 0x656b0197, 0xa3c10164, 0x00000000}},  //   gumi, _vagh, ्कल_,
  { {0xa77400ed, 0x656b11f7, 0x7d0d0009, 0x00000000}},  //   _клуч, _wagh, hcas,
  { {0x656b01d5, 0x6d440016, 0xe29900ed, 0x00000000}},  //   _tagh, ygia, хан_,
  { {0x64400004, 0xe5700151, 0x443f03b6, 0x00000000}},  //   bumi, _وطن_, puu_,
  { {0xad9b00c4, 0x644000e7, 0x7c2d00f8, 0x00000000}},  //   _miúd, cumi, jsar,
  { {0x442d11f8, 0x7c2d0193, 0x442f009d, 0x00000000}},  //   mse_, dsar, _ivg_,
  { {0xd5ac026c, 0xed5a0057, 0x442d0905, 0x00000000}},  //   _رہی_, нов_, lse_,
  { {0x442d0273, 0x7d0d00f6, 0x69c30010, 0x00000000}},  //   ose_, gcas, énel,
  { {0x442d11f9, 0x70770025, 0x7c2d11fa, 0x00000000}},  // [1fe0] nse_, _مميز_, gsar,
  { {0x442d101a, 0x442f11fb, 0x6d440016, 0x00000000}},  //   ise_, _mvg_, sgia,
  { {0x644011fc, 0x8ad5008b, 0xb17b0030, 0x00000000}},  //   zumi, аюцц, slåe,
  { {0x442d061f, 0x9f5a0263, 0x7d0d0197, 0x00000000}},  //   kse_, _sipè_, ccas,
  { {0x442d11fd, 0x64e2006e, 0x69c211fe, 0x00000000}},  //   jse_, _परेश, rnoe,
  { {0x38cb01ef, 0x644011ff, 0x442d017b, 0x00000000}},  //   رانی_, vumi, dse_,
  { {0x442f0059, 0x499400d3, 0x442d1200, 0x00000000}},  //   _avg_, _پیشر, ese_,
  { {0x64401201, 0xad9b0051, 0x442d1202, 0x00000000}},  //   tumi, _giúd, fse_,
  { {0xd3260805, 0xb9930025, 0x48e305f6, 0x00000000}},  //   льни, _القب, _готв,
  { {0x644008b2, 0xf3660140, 0x39460006, 0x00000000}},  //   rumi, утин, lgos_,
  { {0x442d0038, 0x7c2d001e, 0x454605f3, 0x00000000}},  //   ase_, zsar, _مناق,
  { {0x39461203, 0x442f0197, 0x644000b0, 0x00000000}},  //   ngos_, _fvg_, pumi,
  { {0x442d1204, 0xc5f300b3, 0x2b4a0022, 0x00000000}},  //   cse_, _הדף_, _ocbc_,
  { {0x7d0d00ab, 0x00000000, 0x00000000, 0x00000000}},  //   wcas,   ,   ,
  { {0x7d0d1205, 0x539b00b3, 0x98ad00ca, 0x00000000}},  //   tcas, _איגו, _rdeč_,
  { {0x63ba004f, 0x7c2d1206, 0xc27b00a3, 0x00000000}},  //   litn, tsar, _טרוי,
  { {0x7d0d0207, 0x69c300f4, 0x61ed014a, 0x00000000}},  // [1ff0] rcas, énem, _ihal,
  { {0x212b1207, 0x7d0d023a, 0x3946008e, 0x00000000}},  //   lach_, scas, egos_,
  { {0x7c2d1208, 0x61ed01a3, 0x7d0d0f1d, 0x00000000}},  //   ssar, _khal, pcas,
  { {0x212b002a, 0x442d1209, 0x61ed0066, 0x00000000}},  //   nach_, yse_, _jhal,
  { {0x1869012b, 0x3949001e, 0x61ed0051, 0x00000000}},  //   тали_, ļas_, _mhal,
  { {0xe73600d7, 0x212b0051, 0x629a0006, 0x00000000}},  //   аеш_, hach_, kyto,
  { {0x212b0871, 0x442d0866, 0x16a60407, 0x00000000}},  //   kach_, wse_, ивши_,
  { {0x629a0a66, 0x212b0036, 0x61ed0af2, 0x00000000}},  //   dyto, jach_, _nhal,
  { {0x212b120a, 0x291d09df, 0x63ba00ca, 0x00000000}},  //   dach_, mbwa_, fitn,
  { {0x61ed022b, 0x68e9012d, 0x92f50088, 0x00000000}},  //   _ahal, _ized, ичні,
  { {0x61ed120b, 0x212b010f, 0x7bc50cba, 0x00000000}},  //   _bhal, fach_, inhu,
  { {0x442d008d, 0x442f027b, 0x212b120c, 0x00000000}},  //   pse_, _tvg_, gach_,
  { {0x7643120d, 0x15f40084, 0x61ed120e, 0x00000000}},  //   luny, _اسلح, _dhal,
  { {0x629a120f, 0x39460d94, 0x63ba0161, 0x00000000}},  //   byto, zgos_, citn,
  { {0x60cd0038, 0x629a1210, 0x212b03de, 0x00000000}},  //   _exam, cyto, bach_,
  { {0x61ed01d5, 0xd1ba026c, 0x4ad902fb, 0x00000000}},  //   _ghal, _جاتا_, _बुधव,

  { {0x4b2600e3, 0x76431211, 0x6da30545, 0x00000000}},  // [2000] имав, huny, цита,
  { {0x76431212, 0x109b00b3, 0x69c90022, 0x00000000}},  //   kuny, _סביב, _ajee,
  { {0x320704bd, 0x7f3b009b, 0x34e2013d, 0x00000000}},  //   _juny_, _בעיו, _पर्द,
  { {0xeae6001c, 0x3946010a, 0x26de0006, 0x00000000}},  //   _करीत_, ugos_, _ryto_,
  { {0x39461213, 0x8eb3007a, 0xa91d02aa, 0x00000000}},  //   rgos_, _همیش, _požr,
  { {0x81bd001e, 0x39460211, 0x212b0832, 0x00000000}},  //   lsēt, sgos_, zach_,
  { {0x7643008a, 0xb86600a1, 0x212b005b, 0x00000000}},  //   guny, _ھارو, yach_,
  { {0x6d560263, 0xe5c6012b, 0xd9430545, 0x00000000}},  //   nfya, јско, _меси,
  { {0x88bd0046, 0x29041214, 0x2fd80039, 0x00000000}},  //   _jeśl, _igma_, korg_,
  { {0x26de0224, 0x61ed1215, 0x38690065, 0x00000000}},  //   _tyto_, _shal, çare_,
  { {0x212b1216, 0x63ba0161, 0xe3af0380, 0x00000000}},  //   tach_, ritn, بري_,
  { {0x629a093c, 0x29dc008e, 0x00000000, 0x00000000}},  //   ryto, mías_,   ,
  { {0x212b120a, 0x7bdc0091, 0x29dc008e, 0x00000000}},  //   rach_, _okru, lías_,
  { {0x212b120a, 0x2d8201d5, 0x644f04bd, 0x00000000}},  //   sach_, _anke_, àcie,
  { {0x67281217, 0x61ed1218, 0x212b0036, 0x00000000}},  //   _medj, _thal, pach_,
  { {0x67280107, 0x61ed1219, 0xdce60089, 0x00000000}},  //   _ledj, _uhal, _sakā,
  { {0x2fd8033d, 0xdce60089, 0x6be50025, 0x00000000}},  // [2010] borg_, _pakā, مكرم,
  { {0x67280209, 0x69db05b7, 0xa3e6006e, 0x00000000}},  //   _nedj, _skue, पति_,
  { {0x290f001c, 0x7ff403ec, 0x7bc500f8, 0x00000000}},  //   tcga_, _بسيا, rnhu,
  { {0x2001121a, 0x29dc008e, 0x764309df, 0x00000000}},  //   _hihi_, días_, vuny,
  { {0x68e0018e, 0xe739005e, 0x7c8700c0, 0x00000000}},  //   _cymd, гел_, _туне,
  { {0x29dc0841, 0x785a001e, 0x8a1703ec, 0x00000000}},  //   fías_, dāvā, _نظرا,
  { {0xf770031d, 0x29dc0211, 0x20010288, 0x00000000}},  //   بان_, gías_, _mihi_,
  { {0x2fd800b5, 0x764304cb, 0x77630129, 0x00000000}},  //   zorg_, runy, senx,
  { {0x68e00016, 0x69d90036, 0x6728121b, 0x00000000}},  //   _gymd, mowe, _fedj,
  { {0x320700d4, 0x69d9077a, 0x29dc008e, 0x00000000}},  //   _puny_, lowe, bías_,
  { {0x29dc064d, 0xd575008b, 0x6b95121c, 0x00000000}},  //   cías_, _гуль, _mozg,
  { {0x69d90036, 0x35f50245, 0x13a70123, 0x00000000}},  //   nowe, _упер, انگی_,
  { {0xd24e01ef, 0x2fd8000c, 0x20090145, 0x00000000}},  //   ونی_, torg_, _cuai_,
  { {0x443f103c, 0xaad0013d, 0x69d900b4, 0x00000000}},  //   mru_, _तुझक, howe,
  { {0x394d0107, 0x69d90036, 0xdee60088, 0x00000000}},  //   _oces_, kowe, сови,
  { {0x7bdc121d, 0x2900010a, 0x2fd80a74, 0x00000000}},  //   _skru, žiai_, sorg_,
  { {0x69d90036, 0x20090197, 0x443f0471, 0x00000000}},  // [2020] dowe, _guai_, nru_,
  { {0x394d121e, 0x68e00039, 0x443f121f, 0x00000000}},  //   _aces_, _rymd, iru_,
  { {0x49060054, 0x29dc049a, 0x443f01a3, 0x00000000}},  //   مواق, xías_, hru_,
  { {0x5d860054, 0x705300e9, 0x443f0161, 0x00000000}},  //   _الحل, _بنیا, kru_,
  { {0x672801ee, 0x236500ca, 0x443f002b, 0x00000000}},  //   _pedj, kelj_, jru_,
  { {0x7bdc1220, 0x29dc02a0, 0x0f7a0049, 0x00000000}},  //   _ukru, tías_, ראַב,
  { {0x443f0096, 0x386d014a, 0x69d90036, 0x00000000}},  //   eru_, _eser_, bowe,
  { {0x29dc0958, 0x443f037e, 0x98a6025f, 0x00000000}},  //   rías_, fru_, _либе,
  { {0x443f001a, 0x29dc008e, 0x9f5a0026, 0x00000000}},  //   gru_, sías_, _pipì_,
  { {0x23650e0d, 0x29dc008e, 0x20090085, 0x00000000}},  //   gelj_, pías_, _ruai_,
  { {0x4df803d7, 0x2258007c, 0x443f00b4, 0x00000000}},  //   ंगाई_, шины_, aru_,
  { {0x443f0d6b, 0x25a60058, 0x00000000, 0x00000000}},  //   bru_, _ulol_,   ,
  { {0x443f000d, 0x23651221, 0x20090742, 0x00000000}},  //   cru_, belj_, _quai_,
  { {0x33f602a8, 0x236500ee, 0x69d9105e, 0x00000000}},  //   _учес, celj_, zowe,
  { {0x6b951222, 0x69d90020, 0xd357009b, 0x00000000}},  //   _rozg, yowe, _השוק_,
  { {0xd131007a, 0x44260cfe, 0x00000000, 0x00000000}},  //   _کمک_, _kwo_,   ,
  { {0xd01102fd, 0x6602007f, 0x6b950032, 0x00000000}},  // [2030] _تلخ_, _miok, _pozg,
  { {0x6ac4006e, 0x64400051, 0x69d91223, 0x00000000}},  //   वपूर, irmi, wowe,
  { {0x69d90036, 0x3cde001c, 0x29dc004a, 0x00000000}},  //   towe, _कुठे_, víar_,
  { {0x127b0049, 0x2365050f, 0x195900a5, 0x00000000}},  //   טאבע, zelj_, рады_,
  { {0x69d90036, 0xf09f04bd, 0x6d4f0066, 0x00000000}},  //   rowe, nyà_, _icca,
  { {0x01cf0044, 0x645c001a, 0x69d9114b, 0x00000000}},  //   রতিদ, ăril, sowe,
  { {0x44261224, 0x64401225, 0x443f0251, 0x00000000}},  //   _awo_, ermi, wru_,
  { {0x443f1226, 0x84591227, 0x44260061, 0x00000000}},  //   tru_, арот_, _bwo_,
  { {0x386d0038, 0x23650295, 0x443f1228, 0x00000000}},  //   _user_, telj_, uru_,
  { {0x443f01f3, 0xdb0e000c, 0xe3b9005e, 0x00000000}},  //   rru_, _embæ, рбо_,
  { {0x6d5d0428, 0x6d4f06e2, 0x443f1229, 0x00000000}},  //   _obsa, _occa, sru_,
  { {0x443f002b, 0x2365021c, 0x66020026, 0x00000000}},  //   pru_, selj_, _giok,
  { {0x44260263, 0x25bf001a, 0x00000000, 0x00000000}},  //   _gwo_, miul_,   ,
  { {0x6d4f0207, 0x25bf001a, 0x6d5d122a, 0x00000000}},  //   _acca, liul_, _absa,
  { {0xf1bf00fa, 0x00000000, 0x00000000, 0x00000000}},  //   biá_,   ,   ,
  { {0x25bf001a, 0x6d4f122b, 0x0c2602ea, 0x00000000}},  //   niul_, _ccca, жман,
  { {0x249f122c, 0x752b122d, 0xfce3122e, 0x00000000}},  // [2040] nyum_, _megz, дото,
  { {0x61e6122f, 0x25bf0035, 0x9e661230, 0x00000000}},  //   llkl, hiul_, _двод,
  { {0xed5a01f9, 0x3dc90058, 0x00000000, 0x00000000}},  //   _кон_, bnaw_,   ,
  { {0xe9da0175, 0xad5a007e, 0x25ad012d, 0x00000000}},  //   шке_, _трох_, jhel_,
  { {0x25bf000d, 0x999c0010, 0x00000000, 0x00000000}},  //   diul_, évő_,   ,
  { {0x44260061, 0xc7a309bb, 0x207b0049, 0x00000000}},  //   _rwo_, мичк, יאנא,
  { {0x81c30044, 0x7bce00bb, 0x00000000, 0x00000000}},  //   ্তত_, _ijbu,   ,
  { {0x2d921231, 0x7e9b0049, 0x25ad1232, 0x00000000}},  //   njye_, יסצו, ghel_,
  { {0xa73a0123, 0x2ca01233, 0xf1bf00fa, 0x00000000}},  //   _نثار_, nyid_, viá_,
  { {0x442600bb, 0x00000000, 0x00000000, 0x00000000}},  //   _vwo_,   ,   ,
  { {0x86c60379, 0xcb13009b, 0xb7d71234, 0x00000000}},  //   _بيان, ולת_, _بولا_,
  { {0x44260038, 0x25ad00f4, 0xb60601a8, 0x00000000}},  //   _two_, chel_, rišć,
  { {0x44260061, 0xcf00006b, 0x25d90014, 0x00000000}},  //   _uwo_, əşən_, _اهنگ_,
  { {0x43740014, 0x4ea702dc, 0x00000000, 0x00000000}},  //   _رهبر, орба,   ,
  { {0x3ea50047, 0xf1bf004a, 0x00000000, 0x00000000}},  //   ált_, piá_,   ,
  { {0x463b0049, 0x00000000, 0x00000000, 0x00000000}},  //   יעלע,   ,   ,
  { {0xa1f900a1, 0x030e013d, 0xc19c009b, 0x00000000}},  // [2050] _پڑھا_, _सलाह_, _כשהי,
  { {0x09d301f5, 0xda7b02dc, 0x00000000, 0x00000000}},  //   तव्य, ияе_,   ,
  { {0xfd4700a1, 0xaf010044, 0xdd9000a1, 0x00000000}},  //   _ویسٹ_, ্রহণ_, روے_,
  { {0x2ca00061, 0x249f1235, 0x67ed004a, 0x00000000}},  //   byid_, yyum_, dúja,
  { {0xb17c01ce, 0x6d4d018d, 0x98f4007e, 0x00000000}},  //   יטאר, mgaa, мяшч,
  { {0x81c30055, 0x6cfa009b, 0x7b640517, 0x00000000}},  //   ্তি_, _לפרס, _отсе,
  { {0x25ad0675, 0x67ed0010, 0x25bf001a, 0x00000000}},  //   thel_, gúja, tiul_,
  { {0x2d990f06, 0x6d4d0168, 0x391501e1, 0x00000000}},  //   _jose_, ngaa, _хмар,
  { {0x81c30055, 0x25bf001a, 0x395f1236, 0x00000000}},  //   ্তা_, riul_, _ibus_,
  { {0x2d991237, 0x25ad1238, 0x249f1239, 0x00000000}},  //   _lose_, shel_, ryum_,
  { {0x69cb000b, 0x95cb007c, 0x25bf001a, 0x00000000}},  //   onge, _куда_, piul_,
  { {0x2ca0013f, 0x2d99123a, 0x6d4d0bbc, 0x00000000}},  //   yyid_, _nose_, jgaa,
  { {0x6d4d123b, 0x920b013d, 0x26110082, 0x00000000}},  //   dgaa, _सूरज_, _háo_,
  { {0xa4fa009b, 0x69cb01a2, 0x6d4d123c, 0x00000000}},  //   _פלסט, hnge, egaa,
  { {0x2d99123d, 0x8e8300ed, 0x6d4d0250, 0x00000000}},  //   _bose_, нгре, fgaa,
  { {0x2d990198, 0x6d4d0343, 0x2ca00009, 0x00000000}},  //   _cose_, ggaa, tyid_,
  { {0xdb1e008d, 0x2d9900ab, 0x6449123e, 0x00000000}},  // [2060] qipë, _dose_, nuei,
  { {0x395f00f4, 0x2ca00009, 0x69cb021f, 0x00000000}},  //   _abus_, ryid_, enge,
  { {0x9f9b009b, 0x2d990962, 0x26110082, 0x00000000}},  //   _הסיפ, _fose_, _náo_,
  { {0x5f460752, 0x2d990032, 0xe8fa0140, 0x00000000}},  //   _بنگل, _gose_, бле_,
  { {0xa3bd04da, 0xa3cb0204, 0x7d7b009b, 0x00000000}},  //   ीचा_, रचा_, _הנכו,
  { {0x261100ad, 0x69cb01d6, 0xdb1e123f, 0x00000000}},  //   _báo_, ange, kipé,
  { {0x2611001d, 0x2d990061, 0xdbc70934, 0x00000000}},  //   _cáo_, _yose_, töös,
  { {0x69c30010, 0x7bde0052, 0x9418004d, 0x00000000}},  //   énet, lopu, ожит_,
  { {0x64491240, 0x7c3604d3, 0xdce40006, 0x00000000}},  //   guei, nsyr, keič,
  { {0x7bde1241, 0x69c21242, 0xdc9b0049, 0x00000000}},  //   nopu, lioe, צייל,
  { {0xe4d601ef, 0x5ec10044, 0xf773009b, 0x00000000}},  //   _کتاب, _শুনে, _רקע_,
  { {0xfbc40044, 0x9257007c, 0x64490129, 0x00000000}},  //   ্তিত, чают_, buei,
  { {0x6449028c, 0x7bde00b0, 0xad9b0051, 0x00000000}},  //   cuei, kopu, _diúl,
  { {0x22590036, 0x7bde016c, 0xa91d0087, 0x00000000}},  //   ńska_, jopu, _anžl,
  { {0x6d4d1243, 0xdb1e0051, 0x69cb1244, 0x00000000}},  //   tgaa, cipé, ynge,
  { {0x91e4012b, 0x00000000, 0x00000000, 0x00000000}},  //   _поје,   ,   ,
  { {0x113c009b, 0x9c190025, 0x2d990919, 0x00000000}},  // [2070] _התחל, زياء_, _vose_,
  { {0x09c50061, 0x6d4d0030, 0x2d990009, 0x00000000}},  //   लच्य, sgaa, _wose_,
  { {0x6d4d1245, 0x2d991246, 0x00000000, 0x00000000}},  //   pgaa, _tose_,   ,
  { {0x69cb0207, 0x69c20032, 0xdb1e00b0, 0x00000000}},  //   unge, gioe, enpä,
  { {0xeab000a1, 0x26110011, 0x69cb01a2, 0x00000000}},  //   نٹے_, _sáo_, rnge,
  { {0xfd1300a1, 0x69da00c4, 0xdb2302fd, 0x00000000}},  //   _تجھ_, _íten, _سوری,
  { {0xe730023c, 0x69c20288, 0x00000000, 0x00000000}},  //   اصه_, bioe,   ,
  { {0x69c203d1, 0x64490129, 0x49b8023c, 0x00000000}},  //   cioe, tuei, _فاقد_,
  { {0x79890253, 0x00000000, 0x00000000, 0x00000000}},  //   _inew,   ,   ,
  { {0x26110011, 0x644900d4, 0xad9b0051, 0x00000000}},  //   _táo_, ruei, _siúl,
  { {0x61460816, 0x799b1247, 0xf65500ed, 0x00000000}},  //   мена, _kouw, _цвеќ,
  { {0x5ec10044, 0x799b1248, 0xdb1e0068, 0x00000000}},  //   _শুভে, _jouw, ripé,
  { {0x64490ddb, 0xad9b00c4, 0x7a0c0095, 0x00000000}},  //   quei, _ciúm, _işte,
  { {0x69c2022b, 0x799b1249, 0xbef90061, 0x00000000}},  //   zioe, _louw, ंधून_,
  { {0x5de6007e, 0x79890275, 0x0ef9007e, 0x00000000}},  //   джва, _onew, зэты_,
  { {0x799b00d4, 0x69bf007d, 0xdb1c0327, 0x00000000}},  //   _nouw, लोमी, _imré,
  { {0x7bde016c, 0x5f7605d4, 0x61e40622, 0x00000000}},  // [2080] topu, _قادر, _ikil,
  { {0x78a200e7, 0xafdb00ea, 0x00000000, 0x00000000}},  //   vyov, ktøy,   ,
  { {0x81c30055, 0x7c36124a, 0x1d0a0184, 0x00000000}},  //   ্তর_, ssyr, _мени_,
  { {0x7bde0c76, 0x799b00d9, 0x7989005b, 0x00000000}},  //   sopu, _couw, _cnew,
  { {0x7bde0d59, 0x69c2002d, 0x799b0112, 0x00000000}},  //   popu, rioe, _douw,
  { {0x7a0c001a, 0x69c2124b, 0xe3a71095, 0x00000000}},  //   _aşte, sioe, _شر_,
  { {0x79890009, 0x6b9c0579, 0x69c20032, 0x00000000}},  //   _fnew, _iorg, pioe,
  { {0x6b9c0010, 0x320e0026, 0x799b0116, 0x00000000}},  //   _horg, _rufy_, _gouw,
  { {0x69c003a1, 0x6b9c0039, 0x236a00ec, 0x00000000}},  //   _imme, _korg, ојно_,
  { {0x6b9c0489, 0x61e40020, 0xf366003b, 0x00000000}},  //   _jorg, _akil, фтин,
  { {0xbcfb0051, 0x6b9c124c, 0x316b00b4, 0x00000000}},  //   _mbéa, _morg, tecz_,
  { {0x61f6010b, 0x6b9c124d, 0x79890066, 0x00000000}},  //   _chyl, _lorg, _xnew,
  { {0x6b9c0007, 0x0cc90044, 0x00000000, 0x00000000}},  //   _oorg, _শর্ত,   ,
  { {0x6b9c01e2, 0xe4c70014, 0xdb0e00f6, 0x00000000}},  //   _norg, _تصمی, _embú,
  { {0xdd9b013b, 0x69c00e38, 0xa3bd013d, 0x00000000}},  //   оша_, _omme, ीचर_,
  { {0xc5f80089, 0x31c4007e, 0x00000000, 0x00000000}},  //   _spēj_, _асьв,   ,
  { {0x6b9c124e, 0x799b00bb, 0x79890022, 0x00000000}},  // [2090] _borg, _rouw, _rnew,
  { {0x69c00207, 0x61fd0239, 0x6b9c0142, 0x00000000}},  //   _amme, lmsl, _corg,
  { {0xfd1000a1, 0x799b0173, 0x6b9c01e5, 0x00000000}},  //   اجہ_, _pouw, _dorg,
  { {0x4c9501fc, 0x9f5a00b0, 0x49b80014, 0x00000000}},  //   _зимс, _eipä_, واند_,
  { {0x6b9c124f, 0x7e620107, 0x2d8b014a, 0x00000000}},  //   _forg, _ćopi, _ince_,
  { {0x69c01250, 0xdce4011f, 0x6b9c032c, 0x00000000}},  //   _emme, ldiğ, _gorg,
  { {0x4ae4008b, 0x16a90581, 0x2fc10253, 0x00000000}},  //   _аўта, явки_, _mmhg_,
  { {0x6b9c02ae, 0xc8c0001c, 0xdce4014a, 0x00000000}},  //   _zorg, _शेवट, ndiğ,
  { {0x44391251, 0x6b9c1252, 0x290d0026, 0x00000000}},  //   és_, _yorg, _igea_,
  { {0x61e4009f, 0x61f600d2, 0x7bc500e7, 0x00000000}},  //   _skil, _shyl, nihu,
  { {0x2d8b00ab, 0x98a40035, 0x61f60133, 0x00000000}},  //   _once_, _temă_, _phyl,
  { {0x22590036, 0xe29a0082, 0xa91d0006, 0x00000000}},  //   ńsko_, _ngưu_, _požy,
  { {0xa5c6000c, 0x32090058, 0x7bc51253, 0x00000000}},  //   sjóð, _diay_, kihu,
  { {0x2d8b0089, 0x7bc50020, 0x09dc0061, 0x00000000}},  //   _ance_, jihu, _बऱ्य,
  { {0x24590263, 0x645b001a, 0x61f608c9, 0x00000000}},  //   lèm_, ltui, _thyl,
  { {0x6b9c03ae, 0x32090011, 0x61e400e7, 0x00000000}},  //   _sorg, _giay_, _ukil,
  { {0x8c43013b, 0x645b1254, 0xf3900011, 0x00000000}},  // [20a0] лете, ntui, _mảnh_,
  { {0x7bc50009, 0x290d0026, 0xe2c600a1, 0x00000000}},  //   gihu, _agea_, _آڈیو_,
  { {0x6b9c001f, 0x645b00b0, 0x68e90085, 0x00000000}},  //   _vorg, htui, _ayed,
  { {0x645b0007, 0x6b9c01d6, 0xe8fa0140, 0x00000000}},  //   ktui, _worg, пле_,
  { {0x6b9c0039, 0x69da0d62, 0xd7e605b8, 0x00000000}},  //   _torg, _ítem, ніко,
  { {0x7c240aa5, 0x290d00f6, 0x62830032, 0x00000000}},  //   mpir, _egea_, _orno,
  { {0xfa67026b, 0xd94601e0, 0x7c24095f, 0x00000000}},  //   _парк_, _певи, lpir,
  { {0xd5b71255, 0xf390001d, 0x69c01256, 0x00000000}},  //   есь_, _cảnh_, _umme,
  { {0x62831257, 0xb88601ca, 0xa3bd0061, 0x00000000}},  //   _arno, _blíž, ीचं_,
  { {0xafdb0190, 0xdb17006b, 0x00000000, 0x00000000}},  //   trøm, rixç,   ,
  { {0x6283037e, 0xf8bf009f, 0x0bb7009b, 0x00000000}},  //   _crno, _þér_, גלים_,
  { {0x645b0007, 0x628300ca, 0x7bc500e7, 0x00000000}},  //   btui, _drno, zihu,
  { {0xdce4014a, 0x777a0032, 0xf1c001f5, 0x00000000}},  //   vdiğ, _katx, शोधन,
  { {0x22940054, 0x7c240059, 0x777a0288, 0x00000000}},  //   _للتس, dpir, _jatx,
  { {0xfe7000a1, 0x777a1258, 0x00000000, 0x00000000}},  //   یدہ_, _matx,   ,
  { {0x777a0288, 0x00000000, 0x00000000, 0x00000000}},  //   _latx,   ,   ,
  { {0x3cfc001c, 0xdce4011f, 0xd164005e, 0x00000000}},  // [20b0] लेले_, rdiğ, _същи,
  { {0x657b003b, 0xe1ff0d62, 0xa91d0c6e, 0x00000000}},  //   zduh, lmó_, _inži,
  { {0xc333009b, 0xdcef001a, 0x7bc50738, 0x00000000}},  //   רוע_, _bacă, rihu,
  { {0x245901aa, 0x7c240270, 0x7bc50052, 0x00000000}},  //   yèm_, bpir, sihu,
  { {0x777a0ec8, 0xf3900011, 0xed60013e, 0x00000000}},  //   _batx, _rảnh_, ížet_,
  { {0xf7710355, 0xf3900082, 0x777a00d4, 0x00000000}},  //   شات_, _sảnh_, _catx,
  { {0xd915008b, 0x245901aa, 0x0675094b, 0x00000000}},  //   _адбы, wèm_, туля,
  { {0xd6ce0054, 0x645b00b0, 0x245901aa, 0x00000000}},  //   تقى_, ttui, tèm_,
  { {0xad9b0051, 0x777a05aa, 0x442400e0, 0x00000000}},  //   _ciúi, _fatx, gpm_,
  { {0x645b00c7, 0x5ed70055, 0x24591259, 0x00000000}},  //   rtui, _ধরনে, rèm_,
  { {0xcb120104, 0x645b1254, 0x6579015e, 0x00000000}},  //   ילי_, stui, _tawh,
  { {0x645b0035, 0xcec4013e, 0x00000000, 0x00000000}},  //   ptui, hoří_,   ,
  { {0x98a4010a, 0x75290020, 0x7c240045, 0x00000000}},  //   _temą_, mbez, xpir,
  { {0x64490016, 0x443d125a, 0x4345004c, 0x00000000}},  //   mrei, _ivw_, _рекв,
  { {0x6449125b, 0xed5a007c, 0xd0070679, 0x00000000}},  //   lrei, мов_, тере_,
  { {0xd00f026c, 0xb602009f, 0x661c0010, 0x00000000}},  //   صلہ_, _þátt, _érke,
  { {0x6449125c, 0x973c0091, 0xac0a00ed, 0x00000000}},  // [20c0] nrei, _hoće, днаа_,
  { {0x7c240089, 0xd00f0167, 0x442f0016, 0x00000000}},  //   rpir, _گلی_, _mwg_,
  { {0x6449125d, 0xf1c6013d, 0x2d9e00f4, 0x00000000}},  //   hrei, _लगान, êtes_,
  { {0x6449125e, 0xd00f0123, 0xdb1c0051, 0x00000000}},  //   krei, _دلی_, _imrí,
  { {0x777a002d, 0xb8220044, 0x38cb0014, 0x00000000}},  //   _patx, _নিহত_, واهی_,
  { {0xb17b0039, 0xda721125, 0x00000000, 0x00000000}},  //   llåt, _پُر_,   ,
  { {0x16370025, 0x2b580173, 0x660b0058, 0x00000000}},  //   نسية_, _icrc_, _bigk,
  { {0x6449125f, 0xd01a0055, 0x55740113, 0x00000000}},  //   frei, তীয়_, угит,
  { {0x64490fd1, 0x660b0007, 0xe8ea00a6, 0x00000000}},  //   grei, _digk, _آرزو_,
  { {0x75c800b9, 0x988b00a1, 0x442400fa, 0x00000000}},  //   tězs, _تحفہ_, rpm_,
  { {0x26110087, 0xf204013d, 0x442f06f2, 0x00000000}},  //   _cšod_, रगढ़_, _ewg_,
  { {0x64491260, 0x6738012d, 0x442f005b, 0x00000000}},  //   brei, lavj, _fwg_,
  { {0xe1ff0211, 0x64491261, 0x10740147, 0x00000000}},  //   rmó_, crei, аляю,
  { {0x9f5304bd, 0x26180011, 0x38690ab1, 0x00000000}},  //   _això_, _kéo_, çari_,
  { {0x4ea40265, 0x9f430065, 0x9f340088, 0x00000000}},  //   арта, lojë_, ресі,
  { {0x26180082, 0x00000000, 0x00000000, 0x00000000}},  //   _méo_,   ,   ,
  { {0x69c300f4, 0x9f430065, 0x26181262, 0x00000000}},  // [20d0] ènem, nojë_, _léo_,
  { {0x61ef0c3f, 0x752901ee, 0x6738016c, 0x00000000}},  //   llcl, zbez, javj,
  { {0x2618009d, 0x00000000, 0x00000000, 0x00000000}},  //   _néo_,   ,   ,
  { {0xdd9503c8, 0x21390065, 0x9f430065, 0x00000000}},  //   _самы, nash_, kojë_,
  { {0xf74500d7, 0xafdb0030, 0x394403e8, 0x00000000}},  //   гело, gsøg, рніг,
  { {0xdb070010, 0x26180011, 0x64491263, 0x00000000}},  //   _eljá, _béo_, vrei,
  { {0xcf9400a3, 0x21390023, 0x063200e2, 0x00000000}},  //   יטס_, kash_, бејџ,
  { {0x6449010f, 0x24860116, 0x973c012d, 0x00000000}},  //   trei, _brom_, _roće,
  { {0x75290fd4, 0x24860c51, 0x21391264, 0x00000000}},  //   rbez, _crom_, dash_,
  { {0x644907e6, 0x75291265, 0x62811266, 0x00000000}},  //   rrei, sbez, tvlo,
  { {0x6449010f, 0x248600bb, 0x660b00e0, 0x00000000}},  //   srei, _erom_, _tigk,
  { {0x24860a8a, 0x644905c6, 0x64460006, 0x00000000}},  //   _from_, prei, škia,
  { {0x3fc8007a, 0x248604eb, 0xd46900e2, 0x00000000}},  //   ندسی_, _grom_, _чиле_,
  { {0x61ef0026, 0xf5390142, 0x00000000, 0x00000000}},  //   alcl, lať_,   ,
  { {0x21390145, 0xfc3f00f6, 0x26180082, 0x00000000}},  //   bash_, _aví_, _xéo_,
  { {0x25ad046a, 0xf5390142, 0xf1aa0025, 0x00000000}},  //   nkel_, nať_, _ساعه_,
  { {0xb17b0039, 0x80a500a1, 0x5ed70044, 0x00000000}},  // [20e0] rlåt, _نمٹن, _ধরণে,
  { {0xb3460181, 0x9f5e00b0, 0x25ad006c, 0x00000000}},  //   moçõ, ötä_, hkel_,
  { {0x25ad1267, 0x5336007b, 0x9f430065, 0x00000000}},  //   kkel_, רנען_, zojë_,
  { {0x3ea51268, 0xe9e50088, 0x26180082, 0x00000000}},  //   älte_, аціо, _réo_,
  { {0xe89409b5, 0x07a60099, 0xf5390027, 0x00000000}},  //   раль, ладн, dať_,
  { {0xafdb0018, 0x9f430065, 0x21390023, 0x00000000}},  //   rsøg, vojë_, zash_,
  { {0x673801d9, 0xa91d0521, 0xad9b00c4, 0x00000000}},  //   ravj, _anžu, _viúv,
  { {0x6d56006a, 0x2d8000f4, 0xd49a00ed, 0x00000000}},  //   ngya, ndie_, еро_,
  { {0xa84a0879, 0x61e6001e, 0x2d801269, 0x00000000}},  //   _سلام_, dokl, idie_,
  { {0x9f430065, 0x261800fa, 0x21f2013e, 0x00000000}},  //   rojë_, _téo_, sáhl_,
  { {0x9f430065, 0x21390065, 0x61e60253, 0x00000000}},  //   sojë_, tash_, fokl,
  { {0x2486126a, 0x25ad03a1, 0x9f430023, 0x00000000}},  //   _trom_, ckel_, pojë_,
  { {0x2d800b36, 0x21390065, 0x00000000, 0x00000000}},  //   ddie_, rash_,   ,
  { {0x2a660036, 0x14d7009b, 0x21390023, 0x00000000}},  //   łoby_, _גודל_, sash_,
  { {0x2139126b, 0x00000000, 0x00000000, 0x00000000}},  //   pash_,   ,   ,
  { {0x6d560010, 0x61e60022, 0x00000000, 0x00000000}},  //   ggya, cokl,   ,
  { {0xdfd5007e, 0x00000000, 0x00000000, 0x00000000}},  // [20f0] _вопы,   ,   ,
  { {0x91fd001e, 0xf5390027, 0xdb1e004a, 0x00000000}},  //   stād, zať_, tipá,
  { {0x20d4089d, 0x25ad126c, 0x2ca90093, 0x00000000}},  //   _نتیج, ykel_, syad_,
  { {0x57dd0204, 0x3e41007f, 0x7aee0146, 0x00000000}},  //   यव्ह, mėt_, _dybt,
  { {0xf5390027, 0xa3d40061, 0xd5b10082, 0x00000000}},  //   vať_, सचा_, _lúc_,
  { {0x22590046, 0x39440436, 0x103800a3, 0x00000000}},  //   ński_, _edms_, נטום_,
  { {0x25ad006c, 0xf5390027, 0xa91d0087, 0x00000000}},  //   tkel_, tať_, _nažg,
  { {0x25ad037f, 0x00000000, 0x00000000, 0x00000000}},  //   ukel_,   ,   ,
  { {0x64460006, 0x98480265, 0x61e6126d, 0x00000000}},  //   škin, _бяха_, vokl,
  { {0x69cb0239, 0x25ad006c, 0x81bd0089, 0x00000000}},  //   lige, skel_, spēl,
  { {0x27e7126e, 0x25b00010, 0x2249005e, 0x00000000}},  //   monn_, álló_, ъпни_,
  { {0x69cb001f, 0x91e6026b, 0x27e7126f, 0x00000000}},  //   nige, роме, lonn_,
  { {0x6e25002a, 0xe3ae0140, 0x00000000, 0x00000000}},  //   _athb, _дб_,   ,
  { {0x753b0ba5, 0xdfd20025, 0x69cb010f, 0x00000000}},  //   lauz, زيز_, hige,
  { {0xa91d0428, 0x09b504da, 0x63a31270, 0x00000000}},  //   _každ, ंसाठ, _ionn,
  { {0x63a31271, 0x32da009b, 0x1d260088, 0x00000000}},  //   _honn, _שחקנ, рмам,
  { {0x63a31272, 0x2d801273, 0x69cb0292, 0x00000000}},  // [2100] _konn, rdie_, dige,
  { {0x63a300b0, 0x443f003c, 0xeab20025, 0x00000000}},  //   _jonn, isu_, يعا_,
  { {0x63a300f4, 0x69cb1274, 0x973c0091, 0x00000000}},  //   _monn, fige, _noća,
  { {0x443f0f81, 0x63a30051, 0xa01b000c, 0x00000000}},  //   ksu_, _lonn, kvöl,
  { {0x38cb00a6, 0x91fd0089, 0x764102e1, 0x00000000}},  //   پانی_, ltāc, _avly,
  { {0x63a30207, 0x98a400b9, 0x443f00ca, 0x00000000}},  //   _nonn, _země_, dsu_,
  { {0x29560265, 0x443f1275, 0xafdb05b7, 0x00000000}},  //   _възр, esu_, prøv,
  { {0xd3780363, 0x443f1276, 0x18a60152, 0x00000000}},  //   moći_, fsu_, _кабм,
  { {0x261603d7, 0x63a3032c, 0x79820066, 0x00000000}},  //   _पूरी_, _bonn, mdow,
  { {0x63a3032c, 0x798001dd, 0x27e700f6, 0x00000000}},  //   _conn, _hamw, conn_,
  { {0x6d460428, 0x63a30db6, 0x798009c7, 0x00000000}},  //   _odka, _donn, _kamw,
  { {0x7c260119, 0x31c71277, 0x753b1278, 0x00000000}},  //   _otkr, рсов, cauz,
  { {0x8463005e, 0x27ec0022, 0x63a30048, 0x00000000}},  //   _дъще, _kkdn_, _fonn,
  { {0x44260811, 0x69cb0f5d, 0x644200f4, 0x00000000}},  //   _ito_, zige, _ivoi,
  { {0xc3fb009b, 0x64400190, 0x7c260d90, 0x00000000}},  //   _שלוש, lsmi, _atkr,
  { {0xa91d1279, 0x44260620, 0x4255026c, 0x00000000}},  //   _kaže, _kto_, _انٹر,
  { {0x69cb0292, 0x61ed011c, 0x63a3009d, 0x00000000}},  // [2110] vige, _ikal, _yonn,
  { {0xa91d0006, 0x69cb0007, 0x69d800f4, 0x00000000}},  //   _maže, wige, éven,
  { {0x69cb001f, 0x79800061, 0x44260058, 0x00000000}},  //   tige, _bamw, _lto_,
  { {0x4426127a, 0x443f03d0, 0x6440127b, 0x00000000}},  //   _oto_, ysu_, ksmi,
  { {0x69cb127c, 0xfd96009b, 0xe6cb000c, 0x00000000}},  //   rige, _הדרך_, _íbúð,
  { {0x69cb127d, 0x64400089, 0x628a0016, 0x00000000}},  //   sige, dsmi, _orfo,
  { {0x4426008d, 0x63a30039, 0x6442127e, 0x00000000}},  //   _ato_, _ronn, _avoi,
  { {0x81bd001e, 0x443f0d49, 0x63a3001f, 0x00000000}},  //   spēj, tsu_, _sonn,
  { {0x27e70263, 0x64400030, 0x3f8111d1, 0x00000000}},  //   ponn_, gsmi, _oahu_,
  { {0x443f127f, 0x61ed006a, 0xd7fb1280, 0x00000000}},  //   rsu_, _akal, _руб_,
  { {0x443f009f, 0x44260bc9, 0x63a31267, 0x00000000}},  //   ssu_, _eto_, _vonn,
  { {0x63a30168, 0x44260022, 0x64400296, 0x00000000}},  //   _wonn, _fto_, bsmi,
  { {0x628a001f, 0x95c40025, 0x644f0b33, 0x00000000}},  //   _erfo, _بينه, ácid,
  { {0x23261281, 0x63ba0c4c, 0x3f810022, 0x00000000}},  //   _лоши_, chtn, _cahu_,
  { {0xa91d0627, 0xdfcf006d, 0x798200b4, 0x00000000}},  //   _zaže, ريف_, ydow,
  { {0x973c0091, 0x3d280014, 0x91e302dc, 0x00000000}},  //   _noćn, شتری_, _ноще,
  { {0x6da30242, 0x798000d9, 0x00000000, 0x00000000}},  // [2120] чита, _ramw,   ,
  { {0x69c9006c, 0x79820784, 0xa3ca007d, 0x00000000}},  //   _amee, wdow, रोप_,
  { {0x8e860054, 0x0a4a007c, 0x2bb901f5, 0x00000000}},  //   _الجه, узей_, _इतरा,
  { {0xe93a01b7, 0xe9da007c, 0x8d56005c, 0x00000000}},  //   اسات_, ыке_, _уточ,
  { {0x79820036, 0x69db004a, 0x3f810095, 0x00000000}},  //   rdow, _djue, _yahu_,
  { {0x798200e0, 0xa91d1282, 0x2d82059f, 0x00000000}},  //   sdow, _raže, _hake_,
  { {0x44261283, 0x79820857, 0x2d820059, 0x00000000}},  //   _sto_, pdow, _kake_,
  { {0xb8ce0055, 0xa91d0006, 0xdb1e0934, 0x00000000}},  //   _ওই_, _paže, sipä,
  { {0x2d820038, 0x442600c4, 0x64401284, 0x00000000}},  //   _make_, _qto_, usmi,
  { {0x61ed02e1, 0x6440032e, 0xd37a026b, 0x00000000}},  //   _skal, rsmi, учи_,
  { {0x44261285, 0xdddc0059, 0x779300a1, 0x00000000}},  //   _wto_, zvrš, _ریٹا,
  { {0xdb1c009f, 0x644002d8, 0x44260082, 0x00000000}},  //   _umræ, psmi, _tto_,
  { {0xafdb0637, 0x673a00b0, 0xd4f6025a, 0x00000000}},  //   drør, _ketj, _اثاث,
  { {0x823300a1, 0x661a1286, 0x00000000, 0x00000000}},  //   _کروا, _kutk,   ,
  { {0x25a61287, 0x2d82002d, 0x3f83012d, 0x00000000}},  //   _kool_, _bake_, rdju_,
  { {0x61ed00e7, 0x7bdc002b, 0x2d8200ab, 0x00000000}},  //   _ukal, _ajru, _cake_,
  { {0x3f810169, 0x21f90161, 0x661a0c1e, 0x00000000}},  // [2130] _tahu_, lého_, _lutk,
  { {0x673a01b5, 0x69c900c7, 0x7afc0009, 0x00000000}},  //   _netj, _smee, _bzrt,
  { {0x21f9004f, 0x2d820a60, 0x00000000, 0x00000000}},  //   ného_, _fake_,   ,
  { {0xd3780209, 0x725b0049, 0xad9b0048, 0x00000000}},  //   moću_, רכאפ, _dhúc,
  { {0x673a05b7, 0x973c04eb, 0xe7390478, 0x00000000}},  //   _betj, _voćn, аел_,
  { {0x2d820020, 0x21f90428, 0x661a1288, 0x00000000}},  //   _zake_, kého_, _butk,
  { {0x2d820be3, 0x2013002b, 0x56920184, 0x00000000}},  //   _yake_, _mixi_, дајт,
  { {0x25a600ab, 0x69c91242, 0x79a70545, 0x00000000}},  //   _cool_, _umee, _урге,
  { {0x7c2d022b, 0x57d500ed, 0x00000000, 0x00000000}},  //   npar, _доаѓ,   ,
  { {0x673a018d, 0xd8741289, 0x387f0288, 0x00000000}},  //   _getj, _عاقب, _isur_,
  { {0x5694091b, 0x27e00051, 0x25a60a6b, 0x00000000}},  //   _нафт, éine_, _fool_,
  { {0x7c2d03f1, 0x201300d4, 0x69d901a2, 0x00000000}},  //   kpar, _aixi_, nnwe,
  { {0xdbc6006c, 0x64a500e2, 0xdb0500f8, 0x00000000}},  //   mööb, _фала, lkhä,
  { {0x442d0018, 0x2d82128a, 0x7c2d0190, 0x00000000}},  //   mpe_, _sake_, dpar,
  { {0x442d0056, 0x2d82023a, 0x5fbb0061, 0x00000000}},  //   lpe_, _pake_, _उतरल,
  { {0x60000039, 0x201b128b, 0x442d0026, 0x00000000}},  //   döme, _fuqi_, ope_,
  { {0x442d0263, 0x90c30057, 0xfaf8001e, 0x00000000}},  // [2140] npe_, _объе, _šī_,
  { {0x7a0c005f, 0x442d128c, 0xdb1c044f, 0x00000000}},  //   _işti, ipe_, _områ,
  { {0x6da602e9, 0x2d820038, 0x65b50161, 0x00000000}},  //   _дина, _take_, _náho,
  { {0x7c2d128d, 0x673a0635, 0x442d01a3, 0x00000000}},  //   bpar, _setj, kpe_,
  { {0x661a0583, 0x673a128e, 0x7c2d0e07, 0x00000000}},  //   _sutk, _petj, cpar,
  { {0xe793012b, 0x661a00b0, 0x69d901d6, 0x00000000}},  //   дишњ, _putk, anwe,
  { {0xd5ba0517, 0x442d0007, 0x25a6109b, 0x00000000}},  //   иси_, epe_, _pool_,
  { {0x21f90428, 0x746a005c, 0x00000000, 0x00000000}},  //   vého_, аров_,   ,
  { {0x7c2905ff, 0x00000000, 0x00000000, 0x00000000}},  //   _çert,   ,   ,
  { {0x661a021e, 0x21f901ca, 0x25a60133, 0x00000000}},  //   _tutk, tého_, _wool_,
  { {0x741400d3, 0x25a600ab, 0x442d0adb, 0x00000000}},  //   _کوتا, _tool_, ape_,
  { {0xd46a007c, 0x21f90161, 0x7c2d128f, 0x00000000}},  //   _виде_, rého_, ypar,
  { {0x38660390, 0x321e0009, 0x55d90049, 0x00000000}},  //   ntor_, sqty_, _פֿענ,
  { {0x9f5a01aa, 0xa91d0006, 0x38661290, 0x00000000}},  //   _sipò_, _maža, itor_,
  { {0x7c2d1291, 0xa187007e, 0x0ef30044, 0x00000000}},  //   wpar, _дыпл, ছেনঃ_,
  { {0x3866020c, 0xd3780036, 0x65b501ca, 0x00000000}},  //   ktor_, leć_, _náhl,
  { {0xf1bf0051, 0xa91d0091, 0x38660065, 0x00000000}},  // [2150] mhá_, _naža, jtor_,
  { {0x7c2d1292, 0x66020093, 0xfc300025, 0x00000000}},  //   rpar, _lhok, ضحك_,
  { {0x7a40002a, 0x38660319, 0x442d1293, 0x00000000}},  //   _rátá, etor_, zpe_,
  { {0x442d0a59, 0x7e7a0049, 0x4e7a0049, 0x00000000}},  //   ype_, _פארז, _פארצ,
  { {0xf1b4009b, 0xd8b80076, 0x69d901a2, 0x00000000}},  //   וסף_, يدها_, rnwe,
  { {0xec36009b, 0xa91d0dec, 0x66020f45, 0x00000000}},  //   _מאשר_, _daža, _ahok,
  { {0x38661294, 0xdb0e0146, 0x00000000, 0x00000000}},  //   ator_, _albæ,   ,
  { {0x66020193, 0x31790036, 0xdb070065, 0x00000000}},  //   _chok, jesz_, _lojë,
  { {0x38661295, 0x442d028c, 0x31790010, 0x00000000}},  //   ctor_, upe_, desz_,
  { {0x442d1296, 0x65691297, 0x75d3001a, 0x00000000}},  //   rpe_, sfeh, văzu,
  { {0x6569001f, 0xa3ca02fb, 0x65151298, 0x00000000}},  //   pfeh, रोध_, _فوائ,
  { {0x442d1299, 0x216a0077, 0xd5b80089, 0x00000000}},  //   ppe_, щими_, _stāv_,
  { {0x6609129a, 0x43950088, 0x00000000, 0x00000000}},  //   mmek, _надс,   ,
  { {0x6609011f, 0x25bf00e0, 0x3f6a003b, 0x00000000}},  //   lmek, lhul_, љиво_,
  { {0xa3b803ec, 0xbcfb009d, 0x00000000, 0x00000000}},  //   _ظاهر_, _obés,   ,
  { {0x9c2600e3, 0x31790036, 0x6609129b, 0x00000000}},  //   здад, cesz_, nmek,
  { {0x90460025, 0x38660253, 0x1d07129c, 0x00000000}},  // [2160] _عنده, xtor_, зети_,
  { {0x0e66029b, 0xa91d129d, 0xdb070023, 0x00000000}},  //   _екон, _raža, _gojë,
  { {0x66091252, 0x25bf0022, 0xa91d04eb, 0x00000000}},  //   kmek, khul_, _saža,
  { {0x3866129e, 0x58860783, 0xd3780036, 0x00000000}},  //   ttor_, зыка, zeć_,
  { {0xd90d0167, 0xc18d0049, 0x6609006c, 0x00000000}},  //   لیف_, יטאָ, dmek,
  { {0x66020065, 0x3866129f, 0xa91d0091, 0x00000000}},  //   _shok, rtor_, _važa,
  { {0x7bce04e3, 0xad9b0048, 0x00000000, 0x00000000}},  //   _imbu, _mhún,   ,
  { {0x9adb00b6, 0xbcfb008e, 0x386612a0, 0x00000000}},  //   _החלט, _ibér, ptor_,
  { {0x6d4b0051, 0xa91d0091, 0x00000000, 0x00000000}},  //   ógai, _kažn,   ,
  { {0xad9b0011, 0x644f12a1, 0x00000000, 0x00000000}},  //   _nhún, ácia,   ,
  { {0xdcfd0089, 0x7bce0085, 0x00000000, 0x00000000}},  //   _masā, _mmbu,   ,
  { {0xa91d1279, 0x80ab0055, 0x25bf12a2, 0x00000000}},  //   _lažn, _চেষ্, chul_,
  { {0x7bce006b, 0x4420001a, 0xbcfb12a3, 0x00000000}},  //   _ombu, _îi_, _océa,
  { {0xad9b001d, 0xefc8005c, 0x00000000, 0x00000000}},  //   _chún, пуск_,   ,
  { {0xad9b0051, 0x00000000, 0x00000000, 0x00000000}},  //   _dhún,   ,   ,
  { {0x22f7009b, 0x7bce08d0, 0x63aa005b, 0x00000000}},  //   _מזון_, _ambu, _hofn,
  { {0xa91d0006, 0x6285000c, 0x00000000, 0x00000000}},  // [2170] _bažn, _áhor,   ,
  { {0x61ef0068, 0x7bce0085, 0x91fd0089, 0x00000000}},  //   locl, _cmbu, itām,
  { {0xa91d010a, 0xfe241001, 0x00000000, 0x00000000}},  //   _dažn, _пьян,   ,
  { {0x6aaa0073, 0x7bce01a3, 0x61ef0133, 0x00000000}},  //   äffa, _embu, nocl,
  { {0x2d9909eb, 0xdcfd01c5, 0x00000000, 0x00000000}},  //   _inse_, _fasā,   ,
  { {0xab84005e, 0xbcfb0051, 0x656200f6, 0x00000000}},  //   _пуск, _gcéa, _acoh,
  { {0x660912a4, 0x25bf12a5, 0x00000000, 0x00000000}},  //   tmek, thul_,   ,
  { {0x2d890eff, 0x75fe0065, 0x9f4a1128, 0x00000000}},  //   ndae_, tëza, robé_,
  { {0x91fd001e, 0x66091038, 0x443912a6, 0x00000000}},  //   rtāl, rmek, ès_,
  { {0x63aa12a7, 0xe3b10025, 0xe795025a, 0x00000000}},  //   _cofn, ئرة_, _تارک,
  { {0x91e600ed, 0x2d990007, 0x61ef0048, 0x00000000}},  //   доне, _onse_, focl,
  { {0x44b5007c, 0xa91d12a8, 0x61ef12a9, 0x00000000}},  //   _обес, _mažo, gocl,
  { {0xa3ca007d, 0x2d8901d6, 0x00000000, 0x00000000}},  //   रोह_, ddae_,   ,
  { {0x6b870213, 0x63aa0016, 0x3fcc0044, 0x00000000}},  //   _najg, _gofn, লক্ষ,
  { {0x394d0107, 0x248d00c4, 0xa91d016e, 0x00000000}},  //   _odes_, lvem_, _ražn,
  { {0xbcfb002a, 0x2616013d, 0x217601e1, 0x00000000}},  //   _scéa, _पंछी_, _цукр,
  { {0xdcfd001e, 0x64460107, 0x3fe6013b, 0x00000000}},  // [2180] _pasā, škiv, _ожив,
  { {0x394d00d4, 0x657b12aa, 0x00000000, 0x00000000}},  //   _ades_, heuh,   ,
  { {0xa91d0119, 0x00000000, 0x00000000, 0x00000000}},  //   _važn,   ,   ,
  { {0xe8fa12ab, 0x394d00fa, 0x00000000, 0x00000000}},  //   оле_, _cdes_,   ,
  { {0x6d440653, 0x00000000, 0x00000000, 0x00000000}},  //   maia,   ,   ,
  { {0x628312ac, 0x394d021e, 0x6d4412ad, 0x00000000}},  //   _osno, _edes_, laia,
  { {0xd90d026c, 0x5a55005e, 0xba2308fc, 0x00000000}},  //   لیہ_, _пъту, _адск,
  { {0x77b40129, 0x1dde013d, 0x6d440032, 0x00000000}},  //   _màxi, नचित, naia,
  { {0x186a003b, 0x62830288, 0x00000000, 0x00000000}},  //   _фази_, _asno,   ,
  { {0x6d44002d, 0x69c212ae, 0x69b40061, 0x00000000}},  //   haia, lhoe, _आवडी,
  { {0x6d440149, 0xc7d700b3, 0x973c04eb, 0x00000000}},  //   kaia, _קובי_, _noći,
  { {0x85060d3a, 0x225101ca, 0x69c200bb, 0x00000000}},  //   _قوان, ázka_, nhoe,
  { {0x6d44002d, 0x3c2412af, 0x64b603ab, 0x00000000}},  //   daia, _növ_, _تحار,
  { {0xafdb00ea, 0x00000000, 0x00000000, 0x00000000}},  //   msøk,   ,   ,
  { {0x6b8707b0, 0x6d4400fa, 0xafdb0056, 0x00000000}},  //   _rajg, faia, lsøk,
  { {0xa91d001e, 0x6d44065c, 0x973c01ee, 0x00000000}},  //   _ražo, gaia, _doći,
  { {0x2d8901d6, 0x75fe0023, 0x00000000, 0x00000000}},  // [2190] rdae_, hëzo,   ,
  { {0x2d890007, 0x09d70061, 0xe3b80180, 0x00000000}},  //   sdae_, ढच्य, nkı_,
  { {0x6d44002d, 0x248d01dc, 0x160e007d, 0x00000000}},  //   baia, zvem_, ागार_,
  { {0xd5a60445, 0xafdb00ea, 0x27e00048, 0x00000000}},  //   _صف_, ksøk, éinn_,
  { {0x6d4f12b0, 0xe3b8014a, 0x394d0065, 0x00000000}},  //   _idca, kkı_, _vdes_,
  { {0x65bc009d, 0xd7c804b1, 0x6d4f00d2, 0x00000000}},  //   _réha, وونه_, _hdca,
  { {0xd49200e5, 0x00000000, 0x00000000, 0x00000000}},  //   _arπ_,   ,   ,
  { {0x69c20181, 0x91fd0089, 0xff18009b, 0x00000000}},  //   choe, stāj, וקות_,
  { {0x60000039, 0x799b0058, 0xa9240161, 0x00000000}},  //   dömn, _inuw, _úžas,
  { {0xf77000a6, 0x65600051, 0xa3ca006e, 0x00000000}},  //   _نام_, agmh, रोल_,
  { {0xeb92007b, 0xe299003b, 0x00000000, 0x00000000}},  //   אָר_, чан_,   ,
  { {0xdb07009f, 0x56b60049, 0xafdb00ea, 0x00000000}},  //   _hljó, _אפען_, bsøk,
  { {0xbcfb12b1, 0x6d4400c4, 0xb143007e, 0x00000000}},  //   _scén, vaia, ынял,
  { {0x75290197, 0x6d4404cb, 0x7d1d00f6, 0x00000000}},  //   lcez, waia, _agss,
  { {0xdee30256, 0x644905da, 0x670f0309, 0x00000000}},  //   гори, lsei, ाधिक_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6449028c, 0x6d44065c, 0x6b560025, 0x00000000}},  // [21a0] nsei, raia, فضائ,
  { {0x7c2b12b2, 0x6d440653, 0x442f0a0b, 0x00000000}},  //   ígra, saia, _mtg_,
  { {0xc0a9007a, 0x443d12b3, 0x69c212b4, 0x00000000}},  //   _فایل_, _lww_, thoe,
  { {0xdca60072, 0x3940002a, 0xc86600e3, 0x00000000}},  //   _зами, úis_, етки,
  { {0x69c200c7, 0x79890011, 0xad1b009b, 0x00000000}},  //   rhoe, _daew, _מוכר,
  { {0x69c2046a, 0xc7a3005e, 0x61e40091, 0x00000000}},  //   shoe, личк, _ljil,
  { {0x69c20007, 0x644b00d8, 0x644901c3, 0x00000000}},  //   phoe, _avgi, esei,
  { {0x38cb089d, 0x9f4a01ca, 0x201a023a, 0x00000000}},  //   _کافی_, dobí_, _lipi_,
  { {0x69c0021e, 0xdb07000c, 0x91fd0089, 0x00000000}},  //   _ilme, _fljó, stāk,
  { {0xa3ca03d7, 0x61e4000b, 0x39460058, 0x00000000}},  //   रों_, _ajil, laos_,
  { {0xe3b8047f, 0xa15902e9, 0x443d12b5, 0x00000000}},  //   rkı_, ману_, _eww_,
  { {0x6449010f, 0x39460058, 0x75290197, 0x00000000}},  //   bsei, naos_, ccez,
  { {0x442f00e0, 0x61e401ee, 0x69c00022, 0x00000000}},  //   _gtg_, _djil, _mlme,
  { {0x6d4f0066, 0x41d201f5, 0x00000000, 0x00000000}},  //   _sdca, दोबस,   ,
  { {0x69c012b6, 0xa91d016c, 0x39460203, 0x00000000}},  //   _olme, _sažm, kaos_,
  { {0x61e40065, 0x3946071d, 0x00000000, 0x00000000}},  //   _gjil, jaos_,   ,
  { {0x394600e0, 0xa01b04ce, 0x00000000, 0x00000000}},  // [21b0] daos_, rvös,   ,
  { {0x69c012b7, 0x61fd03ed, 0x2a780022, 0x00000000}},  //   _alme, llsl, _bprb_,
  { {0x32090082, 0x290400e7, 0xb7b50082, 0x00000000}},  //   _khay_, _azma_, _lịc,
  { {0x201a00e7, 0x32370049, 0x3946004a, 0x00000000}},  //   _zipi_, גטאן_, gaos_,
  { {0x69c00045, 0x201a00f6, 0x186900e2, 0x00000000}},  //   _dlme, _yipi_, фали_,
  { {0x9a870265, 0x2d8b0219, 0xa91d010a, 0x00000000}},  //   _публ, _hace_, _kažk,
  { {0x2d8b0521, 0x442f009d, 0x00000000, 0x00000000}},  //   _kace_, _stg_,   ,
  { {0x644912b8, 0x442f01a3, 0x2d8b04eb, 0x00000000}},  //   tsei, _ptg_, _jace_,
  { {0x75290197, 0x2d8b0e0a, 0x291f00f6, 0x00000000}},  //   rcez, _mace_, _igua_,
  { {0x61f603b4, 0x7bc50082, 0xb7b50082, 0x00000000}},  //   _skyl, nhhu, _dịc,
  { {0x443d067b, 0x6449059e, 0x13090057, 0x00000000}},  //   _www_, ssei, ьной_,
  { {0x2d8b12b9, 0x320912ba, 0x442f12bb, 0x00000000}},  //   _nace_, _chay_, _ttg_,
  { {0x201a01a3, 0x442f12bc, 0x6446016c, 0x00000000}},  //   _pipi_, _utg_, škir,
  { {0x2b4300ca, 0x00000000, 0x00000000, 0x00000000}},  //   _nejc_,   ,   ,
  { {0x201a12bd, 0x2d8b0145, 0xdb070062, 0x00000000}},  //   _vipi_, _bace_, _bojí,
  { {0xd9bd0204, 0xc69200a3, 0xdb07004a, 0x00000000}},  //   ्फोट, סאן_, _cojí,
  { {0x201a057e, 0xa01b000c, 0x2d8b0089, 0x00000000}},  // [21c0] _tipi_, rvör, _dace_,
  { {0x291f0219, 0x25af0009, 0x00000000, 0x00000000}},  //   _agua_, _logl_,   ,
  { {0x68fb0219, 0x0f57007b, 0xcf5700b6, 0x00000000}},  //   _ayud, _ביים_, _בבית_,
  { {0x7e6e0009, 0x2d8b12be, 0x7a470010, 0x00000000}},  //   mtbp, _gace_, _sétá,
  { {0x2d80001a, 0x39460058, 0x63ba00ea, 0x00000000}},  //   meie_, raos_, yktn,
  { {0x2d8000ea, 0x2d8b0c51, 0x00000000, 0x00000000}},  //   leie_, _zace_,   ,
  { {0x692612bf, 0xfaa3007e, 0xaa4301ee, 0x00000000}},  //   _амба, _каро, _весл,
  { {0x5e570049, 0x24860b4a, 0xa2c5013d, 0x00000000}},  //   דיקע_, _psom_, ानन्,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x3209103f, 0x394400eb, 0xa78512c0, 0x00000000}},  //   _shay_, _hems_, _مشمو,
  { {0xe3af0076, 0x2d800007, 0xd7ef0025, 0x00000000}},  //   تري_, keie_, _بكل_,
  { {0xb6d9007b, 0xa5da0257, 0x25af0045, 0x00000000}},  //   _אַנט, _غبار_, _gogl_,
  { {0x2d8b00ab, 0x61fd0146, 0x00000000, 0x00000000}},  //   _race_, rlsl,   ,
  { {0x040d0082, 0x394400c8, 0x00000000, 0x00000000}},  //   _mườn, _lems_,   ,
  { {0x3209001d, 0x2d8b12c1, 0xdb0e0065, 0x00000000}},  //   _thay_, _pace_, _dobë,
  { {0x60b500a1, 0x320900e0, 0x00000000, 0x00000000}},  //   _ممبئ, _uhay_,   ,
  { {0x7afc00c4, 0x00000000, 0x00000000, 0x00000000}},  // [21d0] _ayrt,   ,   ,
  { {0xe1ff12c2, 0x1ae70055, 0xad9b0051, 0x00000000}},  //   lló_, _করবে_, _mhúi,
  { {0x2d8b0375, 0xc9590025, 0x68fb0058, 0x00000000}},  //   _tace_, فلاش_, _syud,
  { {0xe1ff0047, 0xa91d016e, 0x68fb0058, 0x00000000}},  //   nló_, _kaži, _pyud,
  { {0x3da4008b, 0x040d0011, 0x7c220051, 0x00000000}},  //   _трэб, _cườn, íort,
  { {0xa91d010a, 0x040d0011, 0x7afc0c73, 0x00000000}},  //   _maži, _dườn, _fyrt,
  { {0xf770035b, 0x394400f6, 0xdb0e0173, 0x00000000}},  //   تان_, _fems_, _nobè,
  { {0xc7b8016c, 0x7f4501f3, 0x39440133, 0x00000000}},  //   _riđe_, _lehq, _gems_,
  { {0x7afc008d, 0xad9b002a, 0x9868026c, 0x00000000}},  //   _zyrt, _chúi, _لینے_,
  { {0x69d90e15, 0xd7740123, 0x52a90175, 0x00000000}},  //   liwe, _نامع, евом_,
  { {0x6146007e, 0xd57502be, 0xdb0e0065, 0x00000000}},  //   лена, _буль, _robë,
  { {0x69d91196, 0x60000039, 0xe1ff12c3, 0x00000000}},  //   niwe, römm, gló_,
  { {0x753b000b, 0xe3b30014, 0x00000000, 0x00000000}},  //   mbuz, _پرش_,   ,
  { {0x645b00c1, 0x3eb812c4, 0xe1ff004a, 0x00000000}},  //   mrui, tyrt_, aló_,
  { {0x3ebe009f, 0x69d90020, 0xe1ff12c5, 0x00000000}},  //   átt_, kiwe, bló_,
  { {0x69d90020, 0x753b00d9, 0x3f8c1238, 0x00000000}},  //   jiwe, nbuz, ždu_,
  { {0x2d8008db, 0xd00f00a1, 0x645b0882, 0x00000000}},  // [21e0] reie_, زلہ_, nrui,
  { {0x394412c6, 0x8b260cbc, 0x00000000, 0x00000000}},  //   _sems_, удже,   ,
  { {0x645b0051, 0x7c36000c, 0xe94400a1, 0x00000000}},  //   hrui, spyr, لرشی,
  { {0x91fd001e, 0x645b01bb, 0xa91d0161, 0x00000000}},  //   stāv, krui, _zaži,
  { {0x6d460089, 0x753b00d2, 0x00000000, 0x00000000}},  //   _ieka, dbuz,   ,
  { {0x91fd001e, 0x6d4612c7, 0xa6340088, 0x00000000}},  //   ltāt, _heka, анкі,
  { {0x6d46027e, 0xf1c101ca, 0xad9b0051, 0x00000000}},  //   _keka, ášky_, _shúi,
  { {0x545402b8, 0x645b0197, 0x040d0011, 0x00000000}},  //   авит, frui, _tườn,
  { {0x6d4612c8, 0xa2d90164, 0x136a005e, 0x00000000}},  //   _meka, _फेब्, ншни_,
  { {0x1ae708b7, 0x6d4610e9, 0x4274003b, 0x00000000}},  //   _করতে_, _leka, агос,
  { {0xb3450181, 0x7c2612c9, 0x75fe0065, 0x00000000}},  //   _seçã, _lukr, hëzi,
  { {0x6d4601d9, 0x645b015c, 0xd257008b, 0x00000000}},  //   _neka, brui, ыць_,
  { {0xa91d010a, 0x645b0d29, 0x7c2612ca, 0x00000000}},  //   _paži, crui, _nukr,
  { {0xa3e803d7, 0x69d910ba, 0x9f4a00c4, 0x00000000}},  //   _यदि_, ziwe, tobá_,
  { {0x6d4604d4, 0x4426000b, 0xa91d0006, 0x00000000}},  //   _beka, _huo_, _važi,
  { {0x6d4612cb, 0x628a002b, 0x44260006, 0x00000000}},  //   _ceka, _isfo, _kuo_,
  { {0x6d4600ef, 0x7c260161, 0x41c40380, 0x00000000}},  // [21f0] _deka, _cukr, _دقيق,
  { {0xf1bf01dc, 0x7c260006, 0x69d8009d, 0x00000000}},  //   lká_, _dukr, èven,
  { {0x442600b0, 0x6d4612cc, 0x3f83003b, 0x00000000}},  //   _luo_, _feka, meju_,
  { {0x89370054, 0x3ebe05b7, 0x6d4612cd, 0x00000000}},  //   اعضا, øtte_, _geka,
  { {0x442612ce, 0x69d912cf, 0x98a50594, 0x00000000}},  //   _nuo_, riwe, риле,
  { {0x62980047, 0xd2460355, 0x7bd5010f, 0x00000000}},  //   _orvo, _ون_, _umzu,
  { {0x44260203, 0xf40a0044, 0x00000000, 0x00000000}},  //   _auo_, রদার_,   ,
  { {0x4426011c, 0xf773025a, 0x3dc90022, 0x00000000}},  //   _buo_, _گار_, nhaw_,
  { {0x6298021e, 0x4426037e, 0x05a6007c, 0x00000000}},  //   _arvo, _cuo_, рвый_,
  { {0xf773004b, 0xe299012b, 0x645b0112, 0x00000000}},  //   _دار_, вао_, rrui,
  { {0x645b00bb, 0x3f83007f, 0xd5ae02fd, 0x00000000}},  //   srui, deju_, سفی_,
  { {0x645b040f, 0x628a0146, 0xa246009e, 0x00000000}},  //   prui, _dsfo, جیٹل_,
  { {0x6d4612d0, 0x628a0a0a, 0x629800b5, 0x00000000}},  //   _reka, _esfo, _ervo,
  { {0x6d46020c, 0x91fd0089, 0xbcfb0051, 0x00000000}},  //   _seka, tuāc, _gcéi,
  { {0x6d460169, 0x7c260dc6, 0x00000000, 0x00000000}},  //   _peka, _sukr,   ,
  { {0xf1bf0428, 0x65b50027, 0x44260173, 0x00000000}},  //   cká_, _záhr, _yuo_,
  { {0xd7c50061, 0x6d460483, 0x0b46007c, 0x00000000}},  // [2200] वसाच, _veka, инан,
  { {0x75fe008d, 0x91fd12d1, 0x6d4600d9, 0x00000000}},  //   rëzi, grāf, _weka,
  { {0xa91d0b4d, 0x6d4612d2, 0xa926007c, 0x00000000}},  //   _mažu, _teka, адел,
  { {0x25ad12d3, 0xda650025, 0x00000000, 0x00000000}},  //   jjel_, صامي,   ,
  { {0xe894085f, 0xd3780243, 0x83fd0010, 0x00000000}},  //   саль, liće_, ntős,
  { {0x91fd0580, 0xd90d00e9, 0x75220026, 0x00000000}},  //   ntār, ریل_, _sgoz,
  { {0x44260198, 0x4b7b019b, 0x64420046, 0x00000000}},  //   _suo_, _שאלו, _swoi,
  { {0x2d920607, 0xbcfb002a, 0x44260207, 0x00000000}},  //   ndye_, _scéi, _puo_,
  { {0xa4d4007e, 0x98bd0036, 0x00000000, 0x00000000}},  //   сопі, tawą_,   ,
  { {0x629804a3, 0xa507003b, 0x7e7e00e0, 0x00000000}},  //   _prvo, шења_, _oppp,
  { {0x3f830006, 0x9f430023, 0x98bd00b4, 0x00000000}},  //   veju_, snjë_, rawą_,
  { {0x442612d4, 0xf1d20164, 0x64420036, 0x00000000}},  //   _tuo_, दोलन, _twoi,
  { {0xe3af04e1, 0xdb0e011f, 0x75d30025, 0x00000000}},  //   سری_, _albü, _بينا,
  { {0xf1bf004f, 0x33f30445, 0x00000000, 0x00000000}},  //   ská_, _وسوس,   ,
  { {0x3f8312d5, 0x245200a1, 0x3dc900e0, 0x00000000}},  //   reju_, _انڈس, thaw_,
  { {0x3dc900e0, 0x82330379, 0x00000000, 0x00000000}},  //   uhaw_, _بروا,   ,
  { {0x91fd0089, 0x3f8301ee, 0x26e2013d, 0x00000000}},  // [2210] stās, peju_, गपुर_,
  { {0x60c00737, 0xd3780107, 0x3dc90675, 0x00000000}},  //   ømme, biće_, shaw_,
  { {0x200312d6, 0x6e950054, 0xd378012d, 0x00000000}},  //   mlji_, _الجا, ciće_,
  { {0x62860036, 0xaa580cb3, 0xdb0e004a, 0x00000000}},  //   łkow, рицу_, _albó,
  { {0x9f5100b9, 0x97d90f4e, 0x1821007d, 0x00000000}},  //   hozí_, льку_, मदेव_,
  { {0x26e20061, 0x6819000a, 0x600000b0, 0x00000000}},  //   गपूर_, _kňdi, tömi,
  { {0x7bc70066, 0x7c2d006b, 0x75fe0023, 0x00000000}},  //   _ilju, lqar, hëzu,
  { {0x59f90057, 0x6d4d025e, 0x3940009f, 0x00000000}},  //   _себя_, naaa, ðist_,
  { {0x7bc70bf8, 0x38600009, 0x7c2d12d7, 0x00000000}},  //   _klju, àirt_, nqar,
  { {0x68e40051, 0x25bf0093, 0xd6db0467, 0x00000000}},  //   úide, skul_, _ите_,
  { {0x6d4d0058, 0x27e700e0, 0x57fa0049, 0x00000000}},  //   kaaa, mnnn_, _עלעו,
  { {0xd3780107, 0xad9b0051, 0x930d0095, 0x00000000}},  //   viće_, _mhús, _ışık,
  { {0x34ab0025, 0x7bc712d8, 0x61e600f8, 0x00000000}},  //   _جداً_, _olju, rnkl,
  { {0x656901d6, 0x27e712d9, 0x6d4b000c, 0x00000000}},  //   lgeh, nnnn_, ðgan,
  { {0xada60680, 0x6da60081, 0x75fe0065, 0x00000000}},  //   бавл, бива, rëzv,
  { {0xd3780209, 0x6d4d001c, 0x6569010f, 0x00000000}},  //   riće_, gaaa, ngeh,
  { {0xd3780521, 0x9f580065, 0x69d8009d, 0x00000000}},  // [2220] siće_, norë_, èvem,
  { {0x6d4d001c, 0x65bc00f4, 0x7f860054, 0x00000000}},  //   aaaa, _véhi, _الدن,
  { {0x387f002d, 0x6d4d12da, 0xdb0e0173, 0x00000000}},  //   _apur_, baaa, _albò,
  { {0x6d4d001c, 0x27e90051, 0xdb1c0039, 0x00000000}},  //   caaa, éann_, _omrö,
  { {0x28d20316, 0xfbd100a1, 0x7bc7012d, 0x00000000}},  //   _देखि, ستے_, _flju,
  { {0xab2700ed, 0x3a3a0058, 0x7bc712db, 0x00000000}},  //   _гора_, pppp_, _glju,
  { {0x65690dcc, 0x7bde01a3, 0x8f9b009b, 0x00000000}},  //   fgeh, mipu, טיסי,
  { {0x7bde0169, 0x69cb12dc, 0x6569046a, 0x00000000}},  //   lipu, chge, ggeh,
  { {0xc34a09b2, 0xdb0e12dd, 0x00000000, 0x00000000}},  //   ляне_, _mobí,   ,
  { {0x325403f3, 0xd62a003b, 0xdcef0089, 0x00000000}},  //   овор, _боже_, _sacī,
  { {0xd5af005e, 0x6d4d1084, 0xa2a80061, 0x00000000}},  //   _ес_, yaaa, टमध्,
  { {0x645d0211, 0x7bde0be4, 0x31c7007c, 0x00000000}},  //   ásic, hipu, ссов,
  { {0x7bde12de, 0x644f004a, 0x69c20288, 0x00000000}},  //   kipu, ácit, ikoe,
  { {0x02a602dc, 0x75fe0065, 0xe29a0082, 0x00000000}},  //   _грим, rëzu, _trư_,
  { {0x6d4d001c, 0x7bde0c2f, 0x6377009b, 0x00000000}},  //   taaa, dipu, _הגוף_,
  { {0x1ae70055, 0x7c2d12df, 0x7bcb01c5, 0x00000000}},  //   _করলে_, tqar, īgum,
  { {0x22ae006b, 0x7bc70825, 0xcf8e0014, 0x00000000}},  // [2230] dəki_, _plju, رژی_,
  { {0xad9b0051, 0x6d4d12e0, 0x61ed03b4, 0x00000000}},  //   _chúr, saaa, _hjal,
  { {0x387f01a2, 0x61ed000c, 0x7bc700ca, 0x00000000}},  //   _spur_, _kjal, _vlju,
  { {0x394912e1, 0x6d4d0045, 0xdb0e00e5, 0x00000000}},  //   úas_, qaaa, _bobâ,
  { {0x27e9008e, 0x61ed12e2, 0x00000000, 0x00000000}},  //   éano_, _mjal,   ,
  { {0x98480a78, 0xdb0e001a, 0x207c0049, 0x00000000}},  //   сяца_, _dobâ, טאדא,
  { {0x61ed0211, 0x3ffc0049, 0x656912e3, 0x00000000}},  //   _ojal, אפגע, tgeh,
  { {0xe459012b, 0x9f580065, 0x8beb0044, 0x00000000}},  //   ажи_, torë_, _কঠিন_,
  { {0x6569010f, 0x69c90288, 0x00000000, 0x00000000}},  //   rgeh, _ilee,   ,
  { {0x61ed12e4, 0x394f000c, 0xd7fb0106, 0x00000000}},  //   _ajal, lags_, _суб_,
  { {0xf77006c6, 0x69c9017d, 0x9f580065, 0x00000000}},  //   _سال_, _klee, sorë_,
  { {0x216a004c, 0x9f5800d6, 0xb1da0088, 0x00000000}},  //   шими_, moré_, рьох_,
  { {0x61ed008d, 0xd00a0c96, 0x9f58009d, 0x00000000}},  //   _djal, иеме_, loré_,
  { {0xee3a0057, 0xd9b6013d, 0x69c212e5, 0x00000000}},  //   инг_, _अक्ट, zkoe,
  { {0x61ed12e6, 0x80db0055, 0x98bd0036, 0x00000000}},  //   _fjal, _যুদ্, rawę_,
  { {0x61ed12e7, 0xc692012f, 0x80660769, 0x00000000}},  //   _gjal, ואל_, _движ,
  { {0x7bde12e8, 0x394f0332, 0xd3780091, 0x00000000}},  // [2240] tipu, dags_, lića_,
  { {0x69db008e, 0x69c912e9, 0x81ac0044, 0x00000000}},  //   _amue, _alee, _গতি_,
  { {0x8eb300a1, 0xdb1501aa, 0x7bde12ea, 0x00000000}},  //   _ہمیش, _jozè, ripu,
  { {0x7ae305f4, 0x609700a1, 0x7bde00b0, 0x00000000}},  //   únta, _انیس_, sipu,
  { {0xd3780107, 0x69c20116, 0x91fd0089, 0x00000000}},  //   hića_, rkoe, duāl,
  { {0x69c20215, 0xa09b00a3, 0x5fce0061, 0x00000000}},  //   skoe, יינט, होचल,
  { {0x394f0719, 0xeb91007b, 0x69c90133, 0x00000000}},  //   bags_, _אָן_, _flee,
  { {0x69c9020f, 0xd3780091, 0x35f703ec, 0x00000000}},  //   _glee, dića_, يريد_,
  { {0xb7e602dc, 0x6b990048, 0x38660133, 0x00000000}},  //   _джак, _éagó, quor_,
  { {0x61ed000c, 0x9f58009d, 0x7de50006, 0x00000000}},  //   _sjal, boré_, rėsi,
  { {0xd3780107, 0x69c9021e, 0x86560084, 0x00000000}},  //   gića_, _ylee, _ذخائ,
  { {0x20180023, 0x1aec0044, 0x00000000, 0x00000000}},  //   emri_, _করাই_,   ,
  { {0xc953019b, 0xa50700e3, 0x7bdc046a, 0x00000000}},  //   ומר_, _деца_, _omru,
  { {0x425500a1, 0xcf270025, 0xd37804eb, 0x00000000}},  //   _کنٹر, ترحي, bića_,
  { {0xcddb098c, 0x25a600d9, 0x61ed000c, 0x00000000}},  //   ања_, _knol_, _tjal,
  { {0x7bdc0557, 0xad9b0048, 0x00000000, 0x00000000}},  //   _amru, _chúp,   ,
  { {0x61fd008e, 0xbcfb0249, 0x00000000, 0x00000000}},  // [2250] mosl, _acér,   ,
  { {0x69c900ab, 0x9f43004a, 0x61fd0142, 0x00000000}},  //   _slee, rojó_, losl,
  { {0x8ae701fb, 0xaa950025, 0x69c90168, 0x00000000}},  //   ціал, ثلاث, _plee,
  { {0x61fd0107, 0x63b80107, 0x3a2400e5, 0x00000000}},  //   nosl, _lovn, _cimp_,
  { {0x394f125b, 0x69c900c7, 0xe73900e3, 0x00000000}},  //   rags_, _vlee, бел_,
  { {0x2904018e, 0x61fd0142, 0x63b8016c, 0x00000000}},  //   _dyma_, hosl, _novn,
  { {0x61fd00b9, 0x91fd0089, 0x212912eb, 0x00000000}},  //   kosl, tuāl, _ogah_,
  { {0xd37801cd, 0xd90e00a1, 0x38600051, 0x00000000}},  //   vića_, ئیے_, áirc_,
  { {0x61fd09fc, 0x478b0057, 0x63b8012d, 0x00000000}},  //   dosl, _всем_, _bovn,
  { {0x7bc512ec, 0xd3780091, 0x394d12ed, 0x00000000}},  //   nkhu, tića_, _hees_,
  { {0x88bd0055, 0x6b9512ee, 0x394d00bb, 0x00000000}},  //   _অধিক, _mazg, _kees_,
  { {0xd3780182, 0x249d0016, 0x2001033b, 0x00000000}},  //   rića_, _trwm_, _akhi_,
  { {0x394d12ef, 0xd9bd0044, 0x7bc50022, 0x00000000}},  //   _mees_, _আগাম, kkhu,
  { {0x4375007b, 0x394d0100, 0x443f020c, 0x00000000}},  //   _זײַן_, _lees_, mpu_,
  { {0x443f018e, 0x6012009f, 0x6da6004d, 0x00000000}},  //   lpu_, væmd, пива,
  { {0xc8bd007d, 0x62830197, 0x7bc50116, 0x00000000}},  //   ्नाट, _ipno, ekhu,
  { {0xdd8f031d, 0x443f000a, 0x3c66007e, 0x00000000}},  // [2260] دوق_, npu_, якаг,
  { {0x3a2412f0, 0x443f00c4, 0x60000039, 0x00000000}},  //   _simp_, ipu_, röms,
  { {0x394d0436, 0x3a240d29, 0xc7b801ed, 0x00000000}},  //   _bees_, _pimp_, _rođ_,
  { {0x2d8901ee, 0x394d00bb, 0x32360049, 0x00000000}},  //   ceae_, _cees_, לטען_,
  { {0x6d4412f1, 0x394d01d6, 0x18670849, 0x00000000}},  //   mbia, _dees_, зачи_,
  { {0x3f98001a, 0x6d440006, 0x394d12f2, 0x00000000}},  //   ndru_, lbia, _eees_,
  { {0x3a24000d, 0x63b80428, 0x2bc10061, 0x00000000}},  //   _timp_, _rovn, _शकता,
  { {0x394d0343, 0x6fcb01df, 0x3f8a12f3, 0x00000000}},  //   _gees_, _müca, hebu_,
  { {0x61fd0c8a, 0x443f12f4, 0x628304e7, 0x00000000}},  //   vosl, gpu_, _apno,
  { {0x260a0061, 0x6027009d, 0x883b009b, 0x00000000}},  //   ातही_, hémè, _לתמו,
  { {0x61fd12f5, 0x63b812f6, 0xd6c40014, 0x00000000}},  //   tosl, _vovn, _تمای,
  { {0x25a60016, 0xdceb0e54, 0x3f980089, 0x00000000}},  //   _unol_, _žičn, edru_,
  { {0x61fd01ca, 0x859b009b, 0x53a60088, 0x00000000}},  //   rosl, _לשאו, _надб,
  { {0xb7bd001a, 0x3f8a12f7, 0x00000000, 0x00000000}},  //   _puţi, gebu_,   ,
  { {0x61fd01d9, 0x6b950295, 0xddd012f8, 0x00000000}},  //   posl, _razg, _šeši,
  { {0x7c3f0045, 0x660200d9, 0x00000000, 0x00000000}},  //   tpqr, _jkok,   ,
  { {0x394d005b, 0x7de50006, 0x3f8a012d, 0x00000000}},  // [2270] _rees_, dėst, bebu_,
  { {0xfe6e06c6, 0xbca40025, 0x60cf005d, 0x00000000}},  //   دگی_, عملي, ınmı,
  { {0x6d440ef1, 0x7bc501d6, 0x6b95014a, 0x00000000}},  //   bbia, rkhu, _vazg,
  { {0x3ebe12f9, 0x66020045, 0x3eac068f, 0x00000000}},  //   ätte_, _nkok, ådte_,
  { {0x31580476, 0x8819007e, 0x394d010e, 0x00000000}},  //   ליאן_, оўку_, _vees_,
  { {0x394d0343, 0x6d4f00ca, 0x7de50023, 0x00000000}},  //   _wees_, _heca, rėsu,
  { {0x6d4f0169, 0x394d0133, 0x00000000, 0x00000000}},  //   _keca, _tees_,   ,
  { {0x84590898, 0x1994007e, 0x7c27008a, 0x00000000}},  //   орот_, _пася, _hijr,
  { {0x8554007a, 0x6f0900b9, 0x6add01f5, 0x00000000}},  //   ریور_, řech, _मधुर,
  { {0x443f0006, 0x6d4f12fa, 0x00000000, 0x00000000}},  //   rpu_, _leca,   ,
  { {0x7c2f000d, 0x2bae0061, 0x6d440016, 0x00000000}},  //   _lucr, घाता, ybia,
  { {0x443f12fb, 0x6d4f12fc, 0x798b0016, 0x00000000}},  //   ppu_, _neca, negw,
  { {0xc4fb0014, 0x660912fd, 0x224012ac, 0x00000000}},  //   _اعضا_, mlek, _čike_,
  { {0x66090004, 0x6d5d12fe, 0x661b0205, 0x00000000}},  //   llek, _adsa, lmuk,
  { {0x6d4f0038, 0x442f000c, 0x3f8a0016, 0x00000000}},  //   _beca, _hug_, rebu_,
  { {0x442712ff, 0x7e61000c, 0x6d4f01a3, 0x00000000}},  //   _hin_, álpa, _ceca,
  { {0x6d44010a, 0xfce300ec, 0x442f0065, 0x00000000}},  // [2280] rbia, вото, _jug_,
  { {0x6d440365, 0x8bf10055, 0x442f1300, 0x00000000}},  //   sbia, _জীবন_, _mug_,
  { {0x442704d7, 0x442f1301, 0x6e261302, 0x00000000}},  //   _min_, _lug_, _tikb,
  { {0x44271303, 0x6d4f00bb, 0x442f0035, 0x00000000}},  //   _lin_, _geca, _oug_,
  { {0xa3cd0164, 0x66090646, 0xf4e80044, 0x00000000}},  //   रसा_, dlek, _পর্ব,
  { {0x442701f6, 0x66090020, 0xb8d6013d, 0x00000000}},  //   _nin_, elek, _छप_,
  { {0xd6d00054, 0x443d0093, 0x260a0061, 0x00000000}},  //   طقة_, _atw_, ातली_,
  { {0xd5b00054, 0x443d00b5, 0x442701a3, 0x00000000}},  //   افة_, _btw_, _ain_,
  { {0x442f1304, 0x92ea0044, 0x443d0d28, 0x00000000}},  //   _cug_, _মরে_, _ctw_,
  { {0xa3d803d7, 0x3946010a, 0xe8d700b3, 0x00000000}},  //   ठों_, lbos_, _חומר_,
  { {0x44271305, 0xbcfb1306, 0x66091016, 0x00000000}},  //   _din_, _idée, blek,
  { {0x44270c85, 0x7dc3006c, 0xf6690025, 0x00000000}},  //   _ein_, _tõsi, _رحمه_,
  { {0x44270e6d, 0x29f8016e, 0xf77100a1, 0x00000000}},  //   _fin_, mčad_, _جاۓ_,
  { {0x6d4f0149, 0x442701aa, 0x9f430065, 0x00000000}},  //   _seca, _gin_, mijë_,
  { {0x6d4f01a3, 0x7c2f00f4, 0x442f010f, 0x00000000}},  //   _peca, _sucr, _zug_,
  { {0x44271307, 0xa01b010f, 0x7c2f00fa, 0x00000000}},  //   _zin_, gwör, _pucr,
  { {0x6d4f1308, 0x4427013f, 0x00000000, 0x00000000}},  // [2290] _veca, _yin_,   ,
  { {0x2fc7001d, 0x44271309, 0x60c00039, 0x00000000}},  //   _ông_, _xin_, ämme,
  { {0x6d4f014a, 0x798b04c0, 0xf09f00f6, 0x00000000}},  //   _teca, tegw, lvà_,
  { {0x6d5d0030, 0x38660016, 0x7f55004a, 0x00000000}},  //   _udsa, fror_, lazq,
  { {0xdd3a012e, 0x798b130a, 0x660900ca, 0x00000000}},  //   _מערכ, regw, vlek,
  { {0xe739007c, 0xa6950098, 0xe6110014, 0x00000000}},  //   чек_, ериј, گشت_,
  { {0x44270811, 0x2d99130b, 0x27e905fa, 0x00000000}},  //   _rin_, _kase_, đan_,
  { {0x4427130c, 0xfc3f0051, 0x38660d2b, 0x00000000}},  //   _sin_, _tríd_, bror_,
  { {0x4427130d, 0x66090039, 0x661b0169, 0x00000000}},  //   _pin_, rlek, rmuk,
  { {0xe3b10054, 0x78a6000c, 0x6609014a, 0x00000000}},  //   ارة_, _ákva, slek,
  { {0x44270263, 0x660901d6, 0x0394007e, 0x00000000}},  //   _vin_, plek, трыя,
  { {0x2d99037e, 0x442f130e, 0x76430022, 0x00000000}},  //   _nase_, _tug_, mpny,
  { {0x44270a60, 0x00000000, 0x00000000, 0x00000000}},  //   _tin_,   ,   ,
  { {0x25bd1163, 0x4427023a, 0xd0120464, 0x00000000}},  //   _howl_, _uin_, الس_,
  { {0x91e601e0, 0x39460006, 0xdb1c01df, 0x00000000}},  //   _поке, ybos_, üzün,
  { {0x2d99130f, 0xdb1c00f4, 0x00000000, 0x00000000}},  //   _case_, _forê,   ,
  { {0xa3c3001c, 0x3dd2018e, 0x8fa60088, 0x00000000}},  // [22a0] _एका_, rhyw_, _запе,
  { {0xfc3f002a, 0x61e601f6, 0x395f001a, 0x00000000}},  //   _dtí_, likl, _adus_,
  { {0x160f013d, 0x66000020, 0xc3210044, 0x00000000}},  //   ातार_, yomk, পুরি_,
  { {0x61e607e4, 0x39460e20, 0x38660f3f, 0x00000000}},  //   nikl, ubos_, tror_,
  { {0xe894085f, 0x6d56049d, 0x3946049a, 0x00000000}},  //   таль, maya, rbos_,
  { {0x6d560149, 0x2d991310, 0x38661311, 0x00000000}},  //   laya, _zase_, rror_,
  { {0x66000062, 0xd90d00a1, 0xdb1c0065, 0x00000000}},  //   tomk, میہ_, _morë,
  { {0xceb300b6, 0x6d561312, 0x3f9a001e, 0x00000000}},  //   ריה_, naya, _lapu_,
  { {0x186701f9, 0x61e61313, 0x2ca00190, 0x00000000}},  //   _пати_, dikl, nvid_,
  { {0x6d560831, 0xb35600a6, 0xb34600c4, 0x00000000}},  //   haya, ریبا_, diçõ,
  { {0x6d561314, 0xd2570088, 0x61e60095, 0x00000000}},  //   kaya, нця_, fikl,
  { {0x6d560127, 0xab64014a, 0x25bd002b, 0x00000000}},  //   jaya, ldüğ, _gowl_,
  { {0x1ae70055, 0x6d560169, 0x7dca0428, 0x00000000}},  //   _করছে_, daya, _výsl,
  { {0x6fcb005f, 0x2d99001a, 0x2ca00039, 0x00000000}},  //   _gücl, _sase_, dvid_,
  { {0x2d990607, 0x2d801315, 0xdb1c0065, 0x00000000}},  //   _pase_, ffie_, _dorë,
  { {0x32530265, 0x6d561316, 0xb3460181, 0x00000000}},  //   _свър, gaya, biçõ,
  { {0x2d99037e, 0xacf80088, 0xdb150161, 0x00000000}},  // [22b0] _vase_, енту_, _vozí,
  { {0xdb1c0173, 0x9f5800f6, 0xa2c50061, 0x00000000}},  //   _korè, corà_, ानच्,
  { {0x6d561317, 0x3a750816, 0x20030006, 0x00000000}},  //   baya, тлер, moji_,
  { {0x20031318, 0x9f5800c4, 0x6d561319, 0x00000000}},  //   loji_, porã_, caya,
  { {0x7dda00b9, 0x83fd0010, 0xa01b000c, 0x00000000}},  //   růst, rtőz, rtöf,
  { {0x61e604a0, 0x20030006, 0x00000000, 0x00000000}},  //   zikl, noji_,   ,
  { {0x34c9013d, 0x00000000, 0x00000000, 0x00000000}},  //   िन्द,   ,   ,
  { {0x20030020, 0x00000000, 0x00000000, 0x00000000}},  //   hoji_,   ,   ,
  { {0x61e60378, 0x2240131a, 0x20030062, 0x00000000}},  //   vikl, _čika_, koji_,
  { {0xd759004b, 0xe4c80025, 0xf7700380, 0x00000000}},  //   _آلات_, عبين_, _هام_,
  { {0x61e60004, 0x27e7009f, 0x6d56006a, 0x00000000}},  //   tikl, minn_, yaya,
  { {0x27e7131b, 0xe3b1089d, 0xb34600c4, 0x00000000}},  //   linn_, ارک_, tiçõ,
  { {0x61e6131c, 0x799b107e, 0xc952009b, 0x00000000}},  //   rikl, _mauw, סמך_,
  { {0x200301d9, 0x61e6011f, 0xb3460181, 0x00000000}},  //   goji_, sikl, riçõ,
  { {0x6d56006a, 0xb3460181, 0x645b0116, 0x00000000}},  //   taya, siçõ, lsui,
  { {0x27e7131d, 0x799b131e, 0x69cb00bb, 0x00000000}},  //   hinn_, _nauw, jkge,
  { {0x27e7009f, 0x61e4131f, 0x645b01c3, 0x00000000}},  // [22c0] kinn_, _imil, nsui,
  { {0x6d56011f, 0x80db0055, 0xfaa61320, 0x00000000}},  //   saya, _যুক্, казо,
  { {0x6d560760, 0x81f70123, 0x7c360065, 0x00000000}},  //   paya, _سفیر_, sqyr,
  { {0x5e57007b, 0x186a00e2, 0x645b0052, 0x00000000}},  //   _ביטע_, дади_, ksui,
  { {0x27e7000c, 0xf7721095, 0x76410006, 0x00000000}},  //   finn_, لاغ_, _atly,
  { {0x27e70fde, 0xf09300a3, 0x00000000, 0x00000000}},  //   ginn_, ינד_,   ,
  { {0xbcfb1321, 0xd6cf006d, 0x7dc3006c, 0x00000000}},  //   _idéa, يقه_, _tõst,
  { {0x6b9c0149, 0xd87600a1, 0x69cb010f, 0x00000000}},  //   _harg, _لائب, ckge,
  { {0xb4be02f4, 0x3949027b, 0x6b9c0612, 0x00000000}},  //   ीने_, ñase_, _karg,
  { {0x61e40994, 0x6b9c0145, 0x799b0036, 0x00000000}},  //   _amil, _jarg, _zauw,
  { {0xa3e302d2, 0x6b9c124c, 0xd6c4089d, 0x00000000}},  //   _नगर_, _marg, _حمای,
  { {0x79820a44, 0xdb1c1184, 0x61e401ee, 0x00000000}},  //   nfow, _coré, _cmil,
  { {0x20031322, 0xdb1c009d, 0xf99300b3, 0x00000000}},  //   toji_, _doré, ברר_,
  { {0x61e40207, 0x6b9c1323, 0xbcfb002a, 0x00000000}},  //   _emil, _narg, _ndéa,
  { {0x20030059, 0x9e0701fb, 0xdb1c0051, 0x00000000}},  //   roji_, вчал, _foré,
  { {0x200300ca, 0xd3780166, 0x27e70173, 0x00000000}},  //   soji_, dići_, zinn_,
  { {0x27e70f99, 0x3209011c, 0x799b00bb, 0x00000000}},  // [22d0] yinn_, _ikay_, _rauw,
  { {0x6b9c0c2e, 0xfc3f008e, 0x2003006b, 0x00000000}},  //   _carg, _cría_, qoji_,
  { {0x6b9c0abe, 0x69c000b5, 0x799b0058, 0x00000000}},  //   _darg, _bome, _pauw,
  { {0x6442002d, 0x645b01d6, 0x27e7010f, 0x00000000}},  //   _otoi, ysui, winn_,
  { {0x27e71324, 0x26c7018e, 0x6b9c0056, 0x00000000}},  //   tinn_, wyno_, _farg,
  { {0x6b9c1325, 0x62980091, 0x628a0030, 0x00000000}},  //   _garg, _osvo, _opfo,
  { {0x27e70a4e, 0x3209011c, 0x69c0049a, 0x00000000}},  //   rinn_, _okay_, _fome,
  { {0x27e71326, 0x69c01327, 0x09ca0055, 0x00000000}},  //   sinn_, _gome, লোবা,
  { {0x6b9c014a, 0x3f91002d, 0x753b0026, 0x00000000}},  //   _yarg, kezu_, rcuz,
  { {0x69c000b5, 0x6b9c11c7, 0x3a2d1328, 0x00000000}},  //   _zome, _xarg, _hiep_,
  { {0xdb1c0181, 0x645b1329, 0x422602be, 0x00000000}},  //   _poré, ssui, лдов,
  { {0xa06a012b, 0x9f4e0161, 0xcb12009b, 0x00000000}},  //   нама_, čník_, מלי_,
  { {0x6fcb010f, 0xa91d0006, 0xd3780107, 0x00000000}},  //   _küch, _pažy, zići_,
  { {0x3a2d00bb, 0x83350049, 0xdee60a85, 0x00000000}},  //   _liep_, _גאַס_, гоги,
  { {0x2fc501e5, 0x00000000, 0x00000000, 0x00000000}},  //   ölga_,   ,   ,
  { {0x6b9c0089, 0xa01b0010, 0x68fb006b, 0x00000000}},  //   _sarg, gtöb, _oxud,
  { {0x6b9c006c, 0xb88600b9, 0x5baa132a, 0x00000000}},  // [22e0] _parg, _kníž, нкам_,
  { {0x69c00038, 0x628a0009, 0xd37811af, 0x00000000}},  //   _some, _ypfo, tići_,
  { {0x69c0132b, 0x68fb081d, 0xc33200b6, 0x00000000}},  //   _pome, _axud, צוא_,
  { {0x6b9c0149, 0xd378016e, 0x9f580129, 0x00000000}},  //   _warg, rići_, forç_,
  { {0x6b9c0a44, 0x17540827, 0x2d92011f, 0x00000000}},  //   _targ, авля, meye_,
  { {0x6fcb001f, 0x69c00038, 0x78a20161, 0x00000000}},  //   _rück, _wome, rvov,
  { {0x6442048c, 0x69c00036, 0xa2630082, 0x00000000}},  //   _stoi, _tome, _quố,
  { {0x2d92132c, 0x7c2e132d, 0x20d70061, 0x00000000}},  //   neye_, _hibr, डनमध,
  { {0xf7460069, 0x98a30069, 0x98760545, 0x00000000}},  //   _безо, _лите, _љубљ,
  { {0x7c2e0066, 0x08c3013b, 0x2d920045, 0x00000000}},  //   _jibr, _убун, heye_,
  { {0x8646132e, 0x2d92132c, 0x0bb700b3, 0x00000000}},  //   _снеж, keye_, אלים_,
  { {0xf651026c, 0x6fcb01a2, 0x00000000, 0x00000000}},  //   _گئے_, _züch,   ,
  { {0x7c2e002a, 0x2d920095, 0x3f9104eb, 0x00000000}},  //   _oibr, deye_, tezu_,
  { {0x403400e2, 0xf651009e, 0x00000000, 0x00000000}},  //   серс, _دئے_,   ,
  { {0x6298037e, 0x442e0912, 0x25af005b, 0x00000000}},  //   _usvo, _iif_, _yngl_,
  { {0x7c2e002a, 0x442e00f8, 0x32090487, 0x00000000}},  //   _aibr, _hif_, _ukay_,
  { {0x442e0f68, 0x3b550603, 0xdb6b0088, 0x00000000}},  // [22f0] _kif_, икар, ерел_,
  { {0x3a2d00d9, 0x00000000, 0x00000000, 0x00000000}},  //   _siep_,   ,   ,
  { {0x7c2e132f, 0x442e04a5, 0xfc3f000c, 0x00000000}},  //   _dibr, _mif_, _grín_,
  { {0x442e0145, 0x2d920095, 0x6fcb01a2, 0x00000000}},  //   _lif_, ceye_, _süch,
  { {0x6d4d1330, 0xbcfb009d, 0x442e06ed, 0x00000000}},  //   mbaa, _idéo, _oif_,
  { {0xdcfd001e, 0xf771002c, 0x7c2e0007, 0x00000000}},  //   _lasī, زات_, _gibr,
  { {0x45d50113, 0xd3780107, 0x3a2d0082, 0x00000000}},  //   ицит, niću_, _tiep_,
  { {0x6d4d015c, 0xb88600b9, 0x442e1331, 0x00000000}},  //   nbaa, _sníž, _aif_,
  { {0xe456007e, 0x851f006e, 0x442e032e, 0x00000000}},  //   ажы_, मेंट_, _bif_,
  { {0x29f81332, 0x98170025, 0x78a90035, 0x00000000}},  //   nčan_, _إبرا, _irev,
  { {0x442e1333, 0x629e0cce, 0x6d4d049b, 0x00000000}},  //   _dif_, _špor, kbaa,
  { {0x78a91334, 0x10a6004d, 0x6d4d00bb, 0x00000000}},  //   _krev, аимн, jbaa,
  { {0x442e0190, 0x2d920f5c, 0x6d4d0328, 0x00000000}},  //   _fif_, veye_, dbaa,
  { {0x442e0365, 0xfe460264, 0x64491335, 0x00000000}},  //   _gif_, инго, mpei,
  { {0xed5a0404, 0x2d92014a, 0x7c2e0173, 0x00000000}},  //   ков_, teye_, _ribr,
  { {0x6d4d07a5, 0x64491336, 0x442e000a, 0x00000000}},  //   gbaa, opei, _zif_,
  { {0xd00f026c, 0x2d92132c, 0x64491337, 0x00000000}},  // [2300] سلہ_, reye_, npei,
  { {0x2d921338, 0xd3780107, 0x00000000, 0x00000000}},  //   seye_, biću_,   ,
  { {0x7f5c0fdb, 0x78a91339, 0xfc3f008e, 0x00000000}},  //   marq, _arev, _frío_,
  { {0x78a9133a, 0x22510161, 0x180e007d, 0x00000000}},  //   _brev, ázky_, ित्व_,
  { {0x38600051, 0x913b0049, 0x78a9133b, 0x00000000}},  //   éir_, דענק, _crev,
  { {0x78a90027, 0x7f5c06c2, 0xe66600ed, 0x00000000}},  //   _drev, narq, атио,
  { {0x442e133c, 0x78a9133d, 0xd91002fd, 0x00000000}},  //   _rif_, _erev, _کیش_,
  { {0x69d90bc6, 0x442e027b, 0x7dd8002a, 0x00000000}},  //   chwe, _sif_, _físe,
  { {0x030b03d7, 0x2e3c000c, 0xd378016c, 0x00000000}},  //   _सुबह_, _líf_, ziću_,
  { {0x66e60088, 0x2b5800d4, 0x442e000a, 0x00000000}},  //   _коза, _jerc_, _qif_,
  { {0xe737007c, 0x2b580ba8, 0x442e009d, 0x00000000}},  //   _тех_, _merc_, _vif_,
  { {0xd378037e, 0x9257007c, 0x9f8f013f, 0x00000000}},  //   viću_, шают_, _küç_,
  { {0x9098046c, 0x92b60044, 0x7dd101bf, 0x00000000}},  //   авят_, ছনে_, _såso,
  { {0xd378037e, 0xc8840477, 0x7f5c004a, 0x00000000}},  //   tiću_, mağı_, garq,
  { {0x6d4d133e, 0x6e2f00f6, 0x628100d9, 0x00000000}},  //   tbaa, _picb, ctlo,
  { {0xcdd8012b, 0x6d4d01d6, 0xdb1c00fa, 0x00000000}},  //   ању_, ubaa, _corí,
  { {0xdce6038c, 0x6d4d00c7, 0xd3780107, 0x00000000}},  // [2310] _bakı, rbaa, siću_,
  { {0x6d4d00c7, 0x6c6a00a1, 0x3ceb0061, 0x00000000}},  //   sbaa, اللہ_, _घेणे_,
  { {0x6d4d00c7, 0xfc3f008e, 0x29f8133f, 0x00000000}},  //   pbaa, _trío_, rčan_,
  { {0xf9930558, 0x7dd801dc, 0x64490052, 0x00000000}},  //   تبط_, _píse, ypei,
  { {0x98a50920, 0xaf080167, 0xf7450b86, 0x00000000}},  //   силе, _مقیم_, бело,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x5a44007e, 0x00000000, 0x00000000, 0x00000000}},  //   _мэта,   ,   ,
  { {0x78a91340, 0xdce80036, 0x29f800ca, 0x00000000}},  //   _trev, śląs, nčal_,
  { {0xdce6011f, 0xcdb8009b, 0x6fcb0477, 0x00000000}},  //   _yakı, שפחה_, _hücu,
  { {0xa3e103d7, 0xe299012b, 0x3cff013d, 0x00000000}},  //   नों_, гао_, _रखने_,
  { {0x644907e6, 0x11d60025, 0x2d8b067f, 0x00000000}},  //   spei, متحد, _obce_,
  { {0xc8840477, 0x9f510010, 0x64491341, 0x00000000}},  //   bağı_, kozó_, ppei,
  { {0xc884005d, 0x7f5c0181, 0xd4690aed, 0x00000000}},  //   cağı_, tarq, _силе_,
  { {0x66091342, 0xd91a01ce, 0x7dca000c, 0x00000000}},  //   loek, טורל, _lýst,
  { {0x7f5c1343, 0x6fd00a5d, 0x00000000, 0x00000000}},  //   rarq, _häck,   ,
  { {0x25bf0022, 0xdce6014a, 0xad9b000c, 0x00000000}},  //   njul_, _sakı, _ljúf,
  { {0x2b580010, 0x5b36006d, 0x30860025, 0x00000000}},  // [2320] _perc_, معار, _الخف,
  { {0x25bf00eb, 0x660900c7, 0x2f561344, 0x00000000}},  //   hjul_, hoek, _утис,
  { {0x6fd00039, 0x6609002d, 0x4e1a0167, 0x00000000}},  //   _läck, koek, _متحد_,
  { {0x200a1345, 0xa01b0cba, 0xc884019a, 0x00000000}},  //   lobi_, ntön, yağı_,
  { {0x1cba0d0b, 0xdce6011f, 0x06e50055, 0x00000000}},  //   _صاحب_, _takı, _পুলি,
  { {0x200a1346, 0x3a380065, 0x9ad605b8, 0x00000000}},  //   nobi_, _turp_, _любі,
  { {0xe0df0197, 0x91fd0089, 0x00000000, 0x00000000}},  //   zzò_, nsāc,   ,
  { {0x6fd003aa, 0xceb30104, 0xd6d90088, 0x00000000}},  //   _bäck, ליו_, шті_,
  { {0xdb1c00d4, 0x656f0048, 0x00000000, 0x00000000}},  //   _horà, ócha,   ,
  { {0x6fd00039, 0x249d000a, 0xc884019a, 0x00000000}},  //   _däck, _dswm_, rağı_,
  { {0x660901b5, 0x51f90088, 0x91fd0089, 0x00000000}},  //   boek, иною_, krāt,
  { {0x09ca0044, 0x00000000, 0x00000000, 0x00000000}},  //   লোরা,   ,   ,
  { {0x63bc0538, 0x200a0239, 0x91fd0089, 0x00000000}},  //   örns, fobi_, drāt,
  { {0x3fe70044, 0xe0df0026, 0x6574009e, 0x00000000}},  //   পক্ষ, rzò_, _ایکڑ_,
  { {0xd35b01f8, 0xe2460d3a, 0x6fd001a2, 0x00000000}},  //   _גדול, _اختي, _mäch,
  { {0x720700a1, 0x8e1501e1, 0x6fd0010f, 0x00000000}},  //   _دفعہ_, ідац, _läch,
  { {0xf1f800a6, 0x71f8006d, 0x320b0036, 0x00000000}},  // [2330] _دعوت_, _دروس_, mocy_,
  { {0x6fd0001f, 0x660902ae, 0x61ef060c, 0x00000000}},  //   _näch, zoek, licl,
  { {0x6fb5007a, 0xad270123, 0xfbd00025, 0x00000000}},  //   _همکا, _گردو, رتك_,
  { {0x7dd10018, 0x6fcb01df, 0x39150069, 0x00000000}},  //   _måsk, _vücu, омер,
  { {0x7dca004f, 0x9ccb0147, 0x89340025, 0x00000000}},  //   _výst, _сына_, أعما,
  { {0x6fd00039, 0x61ef12a0, 0x6d5f1347, 0x00000000}},  //   _räck, hicl, laqa,
  { {0x7ac401e0, 0x6fd00210, 0x6609044a, 0x00000000}},  //   _есте, _säck, toek,
  { {0x59f90057, 0xe61901f9, 0x3ebe0052, 0x00000000}},  //   _тебя_, јди_, ätti_,
  { {0x4425001c, 0x22470093, 0x38600051, 0x00000000}},  //   tml_, _stnk_, áirt_,
  { {0xdb1c1348, 0x66091349, 0x6498005e, 0x00000000}},  //   _horá, soek, стър_,
  { {0xdb1c134a, 0x2bde0061, 0x2ca90443, 0x00000000}},  //   _korá, फोटा, hvad_,
  { {0x6fd00039, 0x2ca900ea, 0x61ef0258, 0x00000000}},  //   _täck, kvad_, gicl,
  { {0x200a0022, 0x3494134b, 0xdb1c0161, 0x00000000}},  //   tobi_, _нацр, _morá,
  { {0x34b20a90, 0x2329134c, 0xbcfb00ea, 0x00000000}},  //   _آموز, _коли_, _idéh,
  { {0x443f0983, 0x200a0020, 0x63a30197, 0x00000000}},  //   lqu_, robi_, _iann,
  { {0x63a30198, 0xdd92004b, 0xa01b134d, 0x00000000}},  //   _hann, بور_, ltöl,
  { {0x63a30836, 0x443f0066, 0x2f23009d, 0x00000000}},  // [2340] _kann, nqu_, tégé_,
  { {0x63a3002b, 0x7bc7004a, 0x443f009d, 0x00000000}},  //   _jann, _coju, iqu_,
  { {0x63a3009f, 0x3f9801d9, 0x5fb7009b, 0x00000000}},  //   _mann, meru_, _והיא_,
  { {0x63a3134e, 0xdb1c0919, 0x6fd001a2, 0x00000000}},  //   _lann, _corá, _säch,
  { {0x91a00011, 0x6d440a55, 0x00000000, 0x00000000}},  //   _chỉ_, mcia,   ,
  { {0x6d440207, 0x466a01c0, 0x1ae601ee, 0x00000000}},  //   lcia, арим_, _догм,
  { {0xd90d026c, 0xdb1c0051, 0x443f002b, 0x00000000}},  //   نیہ_, _forá, equ_,
  { {0x6d44134f, 0x39420004, 0x63a301b5, 0x00000000}},  //   ncia, _üks_, _aann,
  { {0x63a31350, 0x6d441351, 0x61ef01ee, 0x00000000}},  //   _bann, icia, vicl,
  { {0x69c200c7, 0x63a300ab, 0x3f980166, 0x00000000}},  //   ljoe, _cann, jeru_,
  { {0x61ef028a, 0x63a30383, 0x3f980ad8, 0x00000000}},  //   ticl, _dann, deru_,
  { {0x260b0061, 0x63a30085, 0x00000000, 0x00000000}},  //   ावणी_, _eann,   ,
  { {0x63a30a8e, 0x3f98002b, 0x61ef1352, 0x00000000}},  //   _fann, feru_, ricl,
  { {0x65600b57, 0x80270025, 0x6d46101b, 0x00000000}},  //   lamh, ترجم, _afka,
  { {0xbcfb0181, 0xfeb80014, 0x24400082, 0x00000000}},  //   _idéi, يافت_, _hòm_,
  { {0x24400263, 0x65600051, 0x63a309e5, 0x00000000}},  //   _kòm_, namh, _zann,
  { {0x61ed1353, 0x3f981354, 0x63a3009d, 0x00000000}},  // [2350] _imal, beru_, _yann,
  { {0xdb1c0010, 0x7dd8000c, 0x2ca9010e, 0x00000000}},  //   _sorá, _vísa, rvad_,
  { {0xdd910054, 0x5a350517, 0x61ed0059, 0x00000000}},  //   _كود_, чнет, _kmal,
  { {0x6d440198, 0xfe9a0476, 0xf1bf12c5, 0x00000000}},  //   ccia, _פירמ, zmán_,
  { {0x6d5d001e, 0x24400173, 0x00000000, 0x00000000}},  //   _iesa, _nòm_,   ,
  { {0x6d5d038c, 0x67d4004d, 0x60c00933, 0x00000000}},  //   _hesa, мочу, ämmi,
  { {0x63a30fe9, 0x6d5d0db4, 0x61ed003c, 0x00000000}},  //   _rann, _kesa, _omal,
  { {0x63a303fa, 0xfb34008b, 0x6d5d0091, 0x00000000}},  //   _sann, _інтэ, _jesa,
  { {0x6d5d1355, 0x63a30004, 0xb4d5007d, 0x00000000}},  //   _mesa, _pann, सने_,
  { {0x61ed0127, 0x6d5d03fa, 0x443f0066, 0x00000000}},  //   _amal, _lesa, rqu_,
  { {0x63a30047, 0x443f028c, 0x3f980062, 0x00000000}},  //   _vann, squ_, veru_,
  { {0x63a30100, 0xdb1c0018, 0x24400263, 0x00000000}},  //   _wann, _foræ, _fòm_,
  { {0x63a31356, 0xe20b009f, 0xe4490025, 0x00000000}},  //   _tann, _slóð_, _التى_,
  { {0xf8a5007a, 0x0454026c, 0x69db1357, 0x00000000}},  //   _یک_, _آئند, _llue,
  { {0x6d5d0149, 0x7c3d1358, 0x443d0016, 0x00000000}},  //   _besa, _ausr, _huw_,
  { {0xf06604f9, 0xf1bf000c, 0x3f980145, 0x00000000}},  //   _екип, nmál_, seru_,
  { {0x7c350061, 0x3f980066, 0x3ea10065, 0x00000000}},  // [2360] _bizr, peru_, _esht_,
  { {0x6d440198, 0x69db021e, 0x00000000, 0x00000000}},  //   scia, _alue,   ,
  { {0xcf57009b, 0x291f0bb2, 0x69c90288, 0x00000000}},  //   _מבית_, _azua_, _boee,
  { {0x6d5d1359, 0x69db0133, 0x2018000c, 0x00000000}},  //   _gesa, _clue, llri_,
  { {0x2d820039, 0x27ec0022, 0x69c201c3, 0x00000000}},  //   _icke_, _pmdn_, rjoe,
  { {0x569401be, 0x2440135a, 0x69db135b, 0x00000000}},  //   дакт, _ròm_, _elue,
  { {0x69db01e3, 0x6d5d0541, 0x244001aa, 0x00000000}},  //   _flue, _yesa, _sòm_,
  { {0xe9a3007e, 0x75e6007e, 0x7c3d003f, 0x00000000}},  //   _пасп, яўле, _yusr,
  { {0x281600a1, 0xdb1c005a, 0x6560135c, 0x00000000}},  //   _فورس, _borç, ramh,
  { {0x46a60121, 0x61ed0866, 0x6560135d, 0x00000000}},  //   _назв, _smal, samh,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x3946029d, 0x7ae10010, 0x00000000, 0x00000000}},  //   ncos_, _ülte,   ,
  { {0x3866135e, 0xdb1c09f7, 0x7dd800b9, 0x00000000}},  //   nsor_, _forç, _písn,
  { {0x9257007a, 0x6d5d135f, 0xa01b000c, 0x00000000}},  //   _کشور_, _sesa, mtök,
  { {0x6d5d020c, 0x7c3d0091, 0xdb050065, 0x00000000}},  //   _pesa, _susr, rdhë,
  { {0x61ed011c, 0x42fb009b, 0x7c3d1360, 0x00000000}},  //   _umal, _להוס, _pusr,
  { {0x6d5d00ea, 0xa01b1361, 0x4c941362, 0x00000000}},  // [2370] _vesa, ntök, нитс,
  { {0x6e99005e, 0x39461363, 0x2d820c92, 0x00000000}},  //   _двор_, ecos_, _ecke_,
  { {0x6d5d01a3, 0xdb58007c, 0x61fd0239, 0x00000000}},  //   _tesa, яют_, onsl,
  { {0x61fd009f, 0x973c012d, 0xc333009b, 0x00000000}},  //   nnsl, _baćo, גוע_,
  { {0x07a51364, 0xe73900e2, 0x61fd0332, 0x00000000}},  //   далн, оел_, insl,
  { {0x945d0036, 0x3946004a, 0x27c701ab, 0x00000000}},  //   zyńs, acos_, ящег,
  { {0x569200ec, 0x6446000c, 0x25a60048, 0x00000000}},  //   вајт, íkin, _baol_,
  { {0x394610c0, 0x63b8000a, 0x25a60048, 0x00000000}},  //   ccos_, _anvn, _caol_,
  { {0xf1bf0daf, 0xdb1c00c4, 0xfc3f00f6, 0x00000000}},  //   rmál_, _porç, _juí_,
  { {0xf1bf1365, 0x395f00bb, 0xa01b00b0, 0x00000000}},  //   smál_, _heus_, stöj,
  { {0xfc3f0051, 0x395f00b5, 0x9f5101aa, 0x00000000}},  //   _luí_, _keus_, mizè_,
  { {0x25a60048, 0x67210166, 0x644b012d, 0x00000000}},  //   _gaol_, _izlj, _ttgi,
  { {0x395f09f7, 0x644b067e, 0xdb1c0ddb, 0x00000000}},  //   _meus_, _utgi, _torç,
  { {0x61fd00bb, 0x7dd80142, 0x00000000, 0x00000000}},  //   ansl, _píso,   ,
  { {0x628800bb, 0xe7e50316, 0x00000000, 0x00000000}},  //   ctdo, _कतना_,   ,
  { {0x26130181, 0x395f1366, 0xa6af0044, 0x00000000}},  //   mãos_, _neus_, _কথাট,
  { {0x39a6010a, 0xfc3f0051, 0x9f9400b0, 0x00000000}},  // [2380] _jūsų_, _cuí_, _pää_,
  { {0x39a6010a, 0x6721016e, 0xafdb1367, 0x00000000}},  //   _mūsų_, _ozlj, spør,
  { {0x776300f6, 0xa5bd007f, 0x00000000, 0x00000000}},  //   danx, rmųj,   ,
  { {0xbcfb00f6, 0xfc3f008e, 0x395f00fa, 0x00000000}},  //   _adéu, _fuí_, _ceus_,
  { {0x5fd203d7, 0x395f02d5, 0x3946029d, 0x00000000}},  //   _हवाल, _deus_, rcos_,
  { {0x3946049a, 0x38660061, 0x25a61368, 0x00000000}},  //   scos_, rsor_, _saol_,
  { {0xc7b8001d, 0x69d80065, 0xdb1c0039, 0x00000000}},  //   _vnđ_, ëves, _borå,
  { {0x746a0373, 0x69d80089, 0x2d800020, 0x00000000}},  //   оров_, īves, ngie_,
  { {0xd49a0088, 0x00000000, 0x00000000, 0x00000000}},  //   іри_,   ,   ,
  { {0x1b210055, 0xd3700014, 0xa01b01e5, 0x00000000}},  //   _বলতে_, دهد_, rtök,
  { {0xc7b300b3, 0x26130181, 0xdb1c0637, 0x00000000}},  //   _שבע_, gãos_, _forå,
  { {0x22ac00b9, 0xa01b000c, 0x00000000, 0x00000000}},  //   _věk_, ptök,   ,
  { {0x7dd10073, 0x61fd032e, 0x2d800145, 0x00000000}},  //   _måst, rnsl, dgie_,
  { {0x7522002d, 0x2d8001c3, 0x00000000, 0x00000000}},  //   _izoz, egie_,   ,
  { {0x40340594, 0xfc3f0051, 0xa19502dc, 0x00000000}},  //   терс, _suí_, _зайч,
  { {0x2d800007, 0x442c00bb, 0x660200f6, 0x00000000}},  //   ggie_, lmd_, _jjok,
  { {0x395f0129, 0xfc3f0011, 0x2b4a0333, 0x00000000}},  // [2390] _reus_, _quí_, _bfbc_,
  { {0x395f1369, 0xd8380cce, 0x7e7c002d, 0x00000000}},  //   _seus_, _nič_, burp,
  { {0xe1ff008e, 0x395f0129, 0x7dd10039, 0x00000000}},  //   onó_, _peus_, _båst,
  { {0x20110a6e, 0x9f58008e, 0x1dd30316, 0x00000000}},  //   lozi_, boró_, _सवित,
  { {0x7b670057, 0x6e2d0946, 0x3869002a, 0x00000000}},  //   _отве, mmab, éar_,
  { {0x48e00044, 0x660200b0, 0x442c08d9, 0x00000000}},  //   বপূর, _ajok, jmd_,
  { {0x395f0a06, 0xe73600c0, 0xd83801ca, 0x00000000}},  //   _teus_, неш_, _dič_,
  { {0xdcef0477, 0x442c01b5, 0xd5b10137, 0x00000000}},  //   _hacı, emd_, افظ_,
  { {0x6602136a, 0x3160136b, 0x20110cd1, 0x00000000}},  //   _djok, _reiz_, kozi_,
  { {0x69d90116, 0x75220925, 0xe1900082, 0x00000000}},  //   lkwe, _dzoz, _cẳng_,
  { {0xd24e089d, 0x7dd810af, 0xb81b013d, 0x00000000}},  //   ینی_, _sísm, _पीएम_,
  { {0x69d9002b, 0x66020065, 0x7dd80161, 0x00000000}},  //   nkwe, _gjok, _písm,
  { {0xa3d50242, 0x7641011c, 0xf9da0049, 0x00000000}},  //   _подч, _huly, פֿטל,
  { {0x20110207, 0x661b003c, 0x2ca00009, 0x00000000}},  //   gozi_, lluk, vwid_,
  { {0x4427001f, 0xdee60407, 0xfc3f00d4, 0x00000000}},  //   _ihn_, хови, _orís_,
  { {0xd24e0025, 0x7641023a, 0x6da3003b, 0x00000000}},  //   _اني_, _muly, лиса,
  { {0x2011136c, 0xfce3012c, 0x92170049, 0x00000000}},  // [23a0] bozi_, гото, _אַזױ_,
  { {0xfc3f002a, 0x26e50055, 0xbea60545, 0x00000000}},  //   _arís_, _কখনো_, _заок,
  { {0x2f5b0452, 0x7dd103bd, 0x44270022, 0x00000000}},  //   _מדינ, _påst, _mhn_,
  { {0xceb30104, 0xf8660256, 0x69d90058, 0x00000000}},  //   _עיר_, евдо, gkwe,
  { {0xd838016c, 0x661b136d, 0x2365136e, 0x00000000}},  //   _pič_, dluk, kalj_,
  { {0x442701d6, 0x6602136f, 0xfb5600a2, 0x00000000}},  //   _nhn_, _sjok, _سپرد,
  { {0xfc0301bd, 0x09e601fb, 0x69961370, 0x00000000}},  //   _спро, _зовн, _прах,
  { {0x69d90f10, 0x7bce006c, 0x4427016b, 0x00000000}},  //   ckwe, _hobu, _ahn_,
  { {0x7bce1371, 0x09e30b87, 0x44271372, 0x00000000}},  //   _kobu, _сотн, _bhn_,
  { {0x7bce001a, 0x44271373, 0x00000000, 0x00000000}},  //   _jobu, _chn_,   ,
  { {0x442c00b5, 0x2011089f, 0x45e40011, 0x00000000}},  //   rmd_, vozi_, _đượ,
  { {0x79820036, 0x7bce0145, 0x661b016c, 0x00000000}},  //   ngow, _lobu, cluk,
  { {0x23650107, 0x78a20022, 0xe3b20063, 0x00000000}},  //   balj_, nwov, _مرغ_,
  { {0x644f1374, 0xa3d70061, 0x9f4a00fa, 0x00000000}},  //   ície, _सवय_, tibá_,
  { {0x20111375, 0xe28f0025, 0x6e940a1e, 0x00000000}},  //   rozi_, _هذي_, лиру,
  { {0x63aa03da, 0x20110009, 0x51871376, 0x00000000}},  //   _hafn, sozi_, _чука,
  { {0x7dd81377, 0x6e2d008e, 0x20111378, 0x00000000}},  // [23b0] _získ, rmab, pozi_,
  { {0x63aa009f, 0x7bce063c, 0x64420197, 0x00000000}},  //   _jafn, _cobu, _muoi,
  { {0xa03600b6, 0x9f8f006c, 0xbb840025, 0x00000000}},  //   _שאתה_, _müü_, المي,
  { {0x9f58009f, 0xdb0e00c4, 0x2b4d012d, 0x00000000}},  //   lorð_, _robô, _đecu_,
  { {0x69d90116, 0x661b0107, 0x99140088, 0x00000000}},  //   rkwe, vluk, льші,
  { {0x62981379, 0x63aa009f, 0x3f83000c, 0x00000000}},  //   _opvo, _nafn, ngju_,
  { {0x67d200e2, 0x00000000, 0x00000000, 0x00000000}},  //   роју,   ,   ,
  { {0xceb4061e, 0xf9930879, 0x442702d4, 0x00000000}},  //   ריק_, _حبس_, _shn_,
  { {0x661b020c, 0x44270ec1, 0x6442137a, 0x00000000}},  //   rluk, _phn_, _cuoi,
  { {0x9aa4026c, 0x7dd80802, 0x764100e0, 0x00000000}},  //   _جمہو, _písk, _tuly,
  { {0x386d137b, 0xd6db0057, 0xb17b05b7, 0x00000000}},  //   _hver_, _эта_, rhån,
  { {0x9998001e, 0x2365016c, 0xa06a137c, 0x00000000}},  //   _kurš_, salj_, мама_,
  { {0x442704cb, 0xd1320025, 0x91a00082, 0x00000000}},  //   _thn_, شمس_, _chí_,
  { {0xb4bf001c, 0xb4cd0061, 0xa0a300ed, 0x00000000}},  //   ीही_, रही_, јард,
  { {0x248d0010, 0x91a00011, 0x00000000, 0x00000000}},  //   ltem_, _thì_,   ,
  { {0x386d0f12, 0xbcfb009d, 0x248d00b4, 0x00000000}},  //   _over_, _adéq, otem_,
  { {0x248d0d9f, 0x9f58000c, 0xe7f2013d, 0x00000000}},  // [23c0] ntem_, borð_, _अगला_,
  { {0xeafa0647, 0x7bce137d, 0x00000000, 0x00000000}},  //   ورات_, _qobu,   ,
  { {0x386d0207, 0xed5a0088, 0x6f790049, 0x00000000}},  //   _aver_, _оон_, _אָרג,
  { {0xe9da0152, 0x248d137e, 0xc33200a0, 0x00000000}},  //   ьке_, ktem_, בוב_,
  { {0xe894085f, 0x7bce0006, 0x79820036, 0x00000000}},  //   уаль, _tobu, rgow,
  { {0x248d137f, 0x79821380, 0xd823004d, 0x00000000}},  //   dtem_, sgow, адчи,
  { {0x386d1381, 0x00000000, 0x00000000, 0x00000000}},  //   _ever_,   ,   ,
  { {0x63aa000c, 0xa01b0010, 0xe60f0439, 0x00000000}},  //   _safn, ltöt, يشي_,
  { {0x6442009d, 0x7c3c1382, 0x248d02fa, 0x00000000}},  //   _quoi, _kirr, gtem_,
  { {0xa8570097, 0x7c3c01d5, 0x32020027, 0x00000000}},  //   _סיבה_, _jirr, enky_,
  { {0x51f901ff, 0x7c3c00ab, 0xe81b013d, 0x00000000}},  //   енню_, _mirr, _पीटा_,
  { {0x7dd81383, 0xcb13019b, 0x64420082, 0x00000000}},  //   _físi, ילת_, _tuoi,
  { {0x6abf0204, 0x248d00d4, 0xfc3f06c2, 0x00000000}},  //   _एप्र, ctem_, _asín_,
  { {0x7c3c002b, 0xdb1c0190, 0x2005006c, 0x00000000}},  //   _nirr, _forø, õli_,
  { {0x9294008b, 0x9f58000c, 0x00000000, 0x00000000}},  //   _сайц, rorð_,   ,
  { {0x32530265, 0x1b210044, 0x00000000, 0x00000000}},  //   _твър, _বললে_,   ,
  { {0x7c3c0a19, 0xbddb009d, 0xdb050051, 0x00000000}},  // [23d0] _birr, _lièg, rdhí,
  { {0x7c3c00ea, 0x7c8401fc, 0xe7bd0044, 0x00000000}},  //   _cirr, јуте, _অত্য,
  { {0x7c3c01f3, 0x248d0010, 0x25ad00f6, 0x00000000}},  //   _dirr, ztem_, ydel_,
  { {0x443c1384, 0xe7e5007d, 0x973c0243, 0x00000000}},  //   _liv_, कसभा_, _gaći,
  { {0x67d501bd, 0x00000000, 0x00000000, 0x00000000}},  //   лоду,   ,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x6e3d0337, 0xb17b00f8, 0x00000000, 0x00000000}},  //   _kisb, thål,   ,
  { {0x248d0047, 0x06960054, 0x26c90091, 0x00000000}},  //   ttem_, انية_, ćao_,
  { {0x25ad00eb, 0x6e3d018d, 0xb17b0039, 0x00000000}},  //   rdel_, _misb, rhål,
  { {0x6e3d0181, 0x443c06f9, 0x7dd8009f, 0x00000000}},  //   _lisb, _civ_, _vísi,
  { {0x443c0365, 0x2003092f, 0x7d1d05cc, 0x00000000}},  //   _div_, dnji_, _lyss,
  { {0x64b5002c, 0x6e3d1385, 0x5ed70044, 0x00000000}},  //   _محتر, _nisb, _ডেভে,
  { {0x7d1d01d6, 0x79891386, 0x443c1387, 0x00000000}},  //   _nyss, _mcew, _fiv_,
  { {0x443c0030, 0x75fe0089, 0x9f580023, 0x00000000}},  //   _giv_, vīzi, mirë_,
  { {0x6e3d1388, 0xf3f00025, 0xdee3092b, 0x00000000}},  //   _bisb, _بأن_, бори,
  { {0x443c0107, 0xdca6003b, 0x7c3c006b, 0x00000000}},  //   _ziv_, лаби, _sirr,
  { {0x7c3c000c, 0x61e40eb0, 0x00000000, 0x00000000}},  // [23e0] _pirr, _ilil,   ,
  { {0xfc3f0051, 0x7d1d0190, 0x6e3d01a2, 0x00000000}},  //   _tsín_, _dyss, _eisb,
  { {0x62810161, 0x7c3c00b0, 0x78a91389, 0x00000000}},  //   nulo, _virr, _asev,
  { {0x6d4d001c, 0x7cda0089, 0x8e7b0049, 0x00000000}},  //   ccaa, _pārā, _אנטה,
  { {0xd91702f0, 0x7c3c01d5, 0x63a1138a, 0x00000000}},  //   льш_, _tirr, keln,
  { {0x6281011c, 0xbddb009d, 0x61e400f6, 0x00000000}},  //   kulo, _pièg, _llil,
  { {0x63a107e4, 0x1ae6007c, 0x443c00f8, 0x00000000}},  //   deln, _совм, _riv_,
  { {0x6281138b, 0xa01b0039, 0x45d4138c, 0x00000000}},  //   dulo, ntör, роис,
  { {0x6449001c, 0x69c00211, 0xd91000d3, 0x00000000}},  //   gqei, _inme, _بیش_,
  { {0x61e40020, 0x27f8000c, 0x63a10c75, 0x00000000}},  //   _alil, _örn_, geln,
  { {0x443c0263, 0xa01b138d, 0x62810395, 0x00000000}},  //   _viv_, ktör, gulo,
  { {0x15461364, 0xa01b00b0, 0x31c701a4, 0x00000000}},  //   _седм, ytös, усов,
  { {0x20030091, 0x6e3d138e, 0x00000000, 0x00000000}},  //   tnji_, _risb,   ,
  { {0x6281011c, 0x63a10107, 0xd7c70061, 0x00000000}},  //   bulo, celn, लायच,
  { {0x6d4d001c, 0x62810219, 0x539b00b6, 0x00000000}},  //   tcaa, culo, _ניהו,
  { {0x2003037e, 0x5d55026b, 0x7d1d043a, 0x00000000}},  //   snji_, ркат, _pyss,
  { {0x20030c0a, 0x8f550014, 0x6e3d138f, 0x00000000}},  // [23f0] pnji_, _پنجش, _visb,
  { {0x69c01390, 0x21290180, 0x6d4d00bb, 0x00000000}},  //   _anme, _izah_, scaa,
  { {0x6e3d0066, 0xa01b00b0, 0x61f6005b, 0x00000000}},  //   _tisb, stös, _ymyl,
  { {0x63a10036, 0xdb07000c, 0x6e3d01c3, 0x00000000}},  //   zeln, _snjó, _uisb,
  { {0x79c90123, 0x62810032, 0xad9b000c, 0x00000000}},  //   _یوسف_, zulo, _ljúk,
  { {0x69c01391, 0x2d84014a, 0x24491392, 0x00000000}},  //   _enme, _ömer_, _rúm_,
  { {0x0f58009b, 0xbddb009d, 0x63a11183, 0x00000000}},  //   ניהם_, _tièd, veln,
  { {0x660d0746, 0x9f580065, 0x0495007e, 0x00000000}},  //   čako, tirë_, ароў,
  { {0x63a101c8, 0xa78702fd, 0x78a9012d, 0x00000000}},  //   teln, _مشاو, _usev,
  { {0x6281006a, 0x66190093, 0x9f580023, 0x00000000}},  //   tulo, _wkwk, rirë_,
  { {0xdce40006, 0x9f580065, 0x63a110fa, 0x00000000}},  //   vaič, sirë_, reln,
  { {0x63a10235, 0xdb07093f, 0xb495003b, 0x00000000}},  //   seln, _nají, _видљ,
  { {0x7dd80224, 0x63a105d2, 0x3d04013d, 0x00000000}},  //   _míst, peln, _रखें_,
  { {0x6281011c, 0x7dd804bb, 0xdff5007e, 0x00000000}},  //   pulo, _líst, бясь,
  { {0x316b0046, 0xdb07004a, 0x00000000, 0x00000000}},  //   bacz_, _bají,   ,
  { {0x61e40503, 0x3a2d0082, 0x00000000, 0x00000000}},  //   _ulil, _nhep_,   ,

  { {0xab660a27, 0x22470066, 0xa01b1393, 0x00000000}},  // [2400] ивал, _hunk_, rtör,
  { {0x8b26007e, 0x973c016c, 0xfbdf0007, 0x00000000}},  //   адзе, _zaću, _stêr_,
  { {0x7bde01d6, 0x22470133, 0xa01b1394, 0x00000000}},  //   rkpu, _junk_, ptör,
  { {0x201804b4, 0xf2960049, 0x22470190, 0x00000000}},  //   lori_, יכער_, _munk_,
  { {0xc7c600ed, 0x69c00011, 0x9f510181, 0x00000000}},  //   иски, _vnme, lizá_,
  { {0x20181395, 0xdb070224, 0x2240006c, 0x00000000}},  //   nori_, _zají, _liik_,
  { {0xb76501fb, 0xa5f800ed, 0xf77200a1, 0x00000000}},  //   стій, леку_, ماں_,
  { {0xd5b70604, 0x2018018e, 0x3a3f0082, 0x00000000}},  //   ась_, hori_, _giup_,
  { {0xad9b009f, 0x20180010, 0x236702d0, 0x00000000}},  //   _sjúk, kori_, _benj_,
  { {0x9f58004a, 0xf1bf0010, 0xf7430900, 0x00000000}},  //   biré_, ymás_, _дефо,
  { {0xa6ca0054, 0x20180617, 0x0bb7009b, 0x00000000}},  //   _جوال_, dori_, בלים_,
  { {0x22470093, 0xdb1c0489, 0x7dd81396, 0x00000000}},  //   _dunk_, _horó, _míss,
  { {0x2bc90164, 0x2018005b, 0x7648011c, 0x00000000}},  //   रामा, fori_, _hudy,
  { {0x224706f8, 0xb7f8007d, 0x7a23006c, 0x00000000}},  //   _funk_, ्चिम_, võtm,
  { {0x224701f3, 0x623500e3, 0xdb1c02a0, 0x00000000}},  //   _gunk_, _леку, _moró,
  { {0x5d78007c, 0x236700e7, 0xfe79013e, 0x00000000}},  //   ийся_, _zenj_, čů_,
  { {0x61fd0119, 0x40950025, 0x20180091, 0x00000000}},  // [2410] misl, _الخر, bori_,
  { {0x61fd0890, 0x20180617, 0x3a3f0093, 0x00000000}},  //   lisl, cori_, _siup_,
  { {0x2bc90164, 0xdb0e0173, 0x2ac7003b, 0x00000000}},  //   राबा, _jabè, шљав,
  { {0x61fd0142, 0x29d70279, 0x9f58004a, 0x00000000}},  //   nisl, _açar_, viré_,
  { {0xa8a7007c, 0x76480036, 0xdb0e0e6d, 0x00000000}},  //   ррек, _audy, _labè,
  { {0xf7710464, 0x76480036, 0xab8400d7, 0x00000000}},  //   سات_, _budy, _муск,
  { {0x61fd01e5, 0x2ca90016, 0x9557009e, 0x00000000}},  //   kisl, lwad_, لیاء_,
  { {0x61fd1397, 0x644f1398, 0x2d8900e7, 0x00000000}},  //   jisl, ício, ngae_,
  { {0x61fd1399, 0x2240006c, 0x201801aa, 0x00000000}},  //   disl, _riik_, yori_,
  { {0x53c90175, 0x2247016e, 0x60dd01d6, 0x00000000}},  //   угом_, _punk_, dysm,
  { {0x2018037a, 0x7a23006c, 0x442e139a, 0x00000000}},  //   vori_, võtj, _dhf_,
  { {0x442e000c, 0x78bb139b, 0x2ca9000a, 0x00000000}},  //   _ehf_, _kruv, kwad_,
  { {0x2018139c, 0x63c200b9, 0x442e0173, 0x00000000}},  //   tori_, ávní, _fhf_,
  { {0xd91a009b, 0xe8df0011, 0x90d5007e, 0x00000000}},  //   רושל, _ngọn_, іцяч,
  { {0x20180747, 0xc2550151, 0xdee30072, 0x00000000}},  //   rori_, _اختت, пори,
  { {0xfbdf001d, 0x22910a50, 0xdb1c01a2, 0x00000000}},  //   _quên_, mák_, _vorü,
  { {0xbddb00f4, 0x7bd5014a, 0x2291139d, 0x00000000}},  // [2420] _sièc, _bozu, lák_,
  { {0xbddb028c, 0x9f860088, 0x6faa012b, 0x00000000}},  //   _pièc, _угод, _свог_,
  { {0xfe720379, 0x6c330025, 0x7bd5002d, 0x00000000}},  //   _عدد_, أفلا, _dozu,
  { {0xed5a005e, 0x00000000, 0x00000000, 0x00000000}},  //   _щом_,   ,   ,
  { {0xdb1c139e, 0x22b70082, 0x2291139f, 0x00000000}},  //   _poró, _lăk_, hák_,
  { {0x6e2401e5, 0xa09b00a3, 0x61fd016c, 0x00000000}},  //   llib, ריסט, zisl,
  { {0x2291134a, 0x3eb800ca, 0x1be700e2, 0x00000000}},  //   ják_, nvrt_, _удри_,
  { {0x545401f9, 0x61fd049a, 0x6e240058, 0x00000000}},  //   овит, xisl, nlib,
  { {0x61fd0428, 0x78bb0479, 0x92a80036, 0x00000000}},  //   visl, _gruv, _małż,
  { {0xb27413a0, 0x42740364, 0x61fd0016, 0x00000000}},  //   олош, огос, wisl,
  { {0x61fd13a1, 0x17570104, 0xdb9b0097, 0x00000000}},  //   tisl, _הסבר_, נסטר,
  { {0xd46a01f9, 0x9293007e, 0x6446000c, 0x00000000}},  //   _биде_, чаюц, íkis,
  { {0x6e2413a2, 0x3f98002b, 0x61fd13a3, 0x00000000}},  //   dlib, ffru_, risl,
  { {0x61fd13a4, 0x229113a5, 0x60dd0943, 0x00000000}},  //   sisl, bák_, rysm,
  { {0x7bd513a6, 0x61fd00ca, 0x8c000044, 0x00000000}},  //   _rozu, pisl, ্তান_,
  { {0xbcfb0047, 0x6e2413a7, 0x4cd10044, 0x00000000}},  //   _idéz, glib, _সেগু,
  { {0x7bd5006b, 0xe1ff0efe, 0x76420d16, 0x00000000}},  // [2430] _pozu, mió_, _mioy,
  { {0xe1ff13a8, 0x6aae0009, 0x2bc901f5, 0x00000000}},  //   lió_, _bsbf, राधा,
  { {0x6e2413a9, 0x7bd5012d, 0x00000000, 0x00000000}},  //   blib, _vozu,   ,
  { {0xe1ff0129, 0x3ebe0737, 0x6d460093, 0x00000000}},  //   nió_, ætte_, _ggka,
  { {0xeab000a1, 0x00000000, 0x00000000, 0x00000000}},  //   وٹے_,   ,   ,
  { {0x22910010, 0xd2460379, 0x00000000, 0x00000000}},  //   yák_, _ين_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x91a90011, 0x229113aa, 0x00000000, 0x00000000}},  //   _nhà_, vák_,   ,
  { {0xe1ff13ab, 0xb4e3006e, 0xa509005e, 0x00000000}},  //   dió_, नने_, репа_,
  { {0x229113a5, 0xdb0e13ac, 0xe2910025, 0x00000000}},  //   ták_, _sabé, وذج_,
  { {0xd5ae007a, 0xe2990098, 0x645b04fd, 0x00000000}},  //   رفی_, шан_, spui,
  { {0xe1ff13ad, 0x229113ae, 0x36340025, 0x00000000}},  //   gió_, rák_, _فرنس,
  { {0x2291139d, 0x661b0052, 0x601b0035, 0x00000000}},  //   sák_, mouk, tîmp,
  { {0xa2e5004c, 0x661b13af, 0x64590045, 0x00000000}},  //   _молд, louk, _itwi,
  { {0x7f430e09, 0xe1ff0211, 0x6609000b, 0x00000000}},  //   держ, bió_, onek,
  { {0xe1ff13b0, 0x6609055f, 0x644b0061, 0x00000000}},  //   ció_, nnek, _kugi,
  { {0x656b0047, 0x644313b1, 0x6e2404cb, 0x00000000}},  // [2440] _megh, _kini, rlib,
  { {0x9f58002a, 0xdb070047, 0x644b022b, 0x00000000}},  //   oirí_, _sajá, _mugi,
  { {0x442513b2, 0x9d4600da, 0x661b13b3, 0x00000000}},  //   ill_, _менд, kouk,
  { {0xa9260200, 0x18a60088, 0x661b00b0, 0x00000000}},  //   одел, жадм, jouk,
  { {0x9f43000c, 0xdce60087, 0x644b13b4, 0x00000000}},  //   mhjá_, _kekč, _nugi,
  { {0x64430036, 0x6609002d, 0xdb1c000c, 0x00000000}},  //   _nini, enek, _forð,
  { {0x644b010a, 0x656b0026, 0x98a30006, 0x00000000}},  //   _augi, _begh, _ąją_,
  { {0xe1ff0129, 0xd49a00aa, 0xd5ba0783, 0x00000000}},  //   xió_, аро_, рск_,
  { {0x6443006a, 0xe1ff13b5, 0x644b13b6, 0x00000000}},  //   _bini, vió_, _cugi,
  { {0x986800a1, 0xa2f40088, 0x644b0091, 0x00000000}},  //   _نیچے_, зпоч, _dugi,
  { {0xe1ff0211, 0xe3b8014a, 0x661b0341, 0x00000000}},  //   tió_, llık_, bouk,
  { {0x64430ea0, 0x644b03d1, 0x3a260253, 0x00000000}},  //   _eini, _fugi, nlop_,
  { {0xe1ff0211, 0x644306da, 0xe3b8014a, 0x00000000}},  //   rió_, _fini, nlık_,
  { {0xd2500054, 0xe1ff04bd, 0x6443011c, 0x00000000}},  //   _كنت_, sió_, _gini,
  { {0x3a2613b7, 0x2ee5000c, 0x2bc90204, 0x00000000}},  //   klop_, álf_, रासा,
  { {0x63a813b8, 0x660013b9, 0x62880016, 0x00000000}},  //   ledn, nimk, mudo,
  { {0x62880219, 0x7dd8008e, 0x201a000c, 0x00000000}},  // [2450] ludo, _vísp, ófið_,
  { {0x644313ba, 0x660d0087, 0x2ca20022, 0x00000000}},  //   _xini, čaki, _dpkd_,
  { {0x660013bb, 0x660913bc, 0x00000000, 0x00000000}},  //   kimk, ynek,   ,
  { {0xda7801ff, 0x660000b9, 0x63a80146, 0x00000000}},  //   іях_, jimk, hedn,
  { {0x442507b5, 0x998d0027, 0xad9b0010, 0x00000000}},  //   yll_, _tiež_, _amúg,
  { {0x63a80119, 0x644b13bd, 0x656b0197, 0x00000000}},  //   jedn, _rugi, _segh,
  { {0xfbd200b6, 0x644b13be, 0x64430065, 0x00000000}},  //   _אתם_, _sugi, _rini,
  { {0x6443006a, 0x644b13bf, 0x3a2600f6, 0x00000000}},  //   _sini, _pugi, clop_,
  { {0x644313c0, 0x656b0e66, 0x63a813c1, 0x00000000}},  //   _pini, _vegh, fedn,
  { {0x656b0168, 0x661b000a, 0x6609007f, 0x00000000}},  //   _wegh, souk, snek,
  { {0x6443000c, 0xf0890097, 0x4425005b, 0x00000000}},  //   _vini, _תנ_, rll_,
  { {0x644b006c, 0x644300b4, 0xe2961280, 0x00000000}},  //   _tugi, _wini, чаю_,
  { {0x6443006a, 0x63a8003b, 0x7bc700b5, 0x00000000}},  //   _tini, bedn, _onju,
  { {0x628813c2, 0xdfd205f3, 0x63a80142, 0x00000000}},  //   budo, ريز_, cedn,
  { {0xf1bf002a, 0xe3b8014a, 0x62880325, 0x00000000}},  //   mlán_, zlık_, cudo,
  { {0x67ef0030, 0xf1bf13c3, 0x6d4b13c4, 0x00000000}},  //   _højd, llán_, žgan,
  { {0xdca301f9, 0x32020161, 0x00000000, 0x00000000}},  // [2460] нати, miky_,   ,
  { {0xa09700a3, 0x66000279, 0x00000000, 0x00000000}},  //   _צדיק_, zimk,   ,
  { {0xca75007e, 0x3ce606b8, 0x3fdb009b, 0x00000000}},  //   дучы, šov_, _הקיב,
  { {0x63a80046, 0x8c46007c, 0x32020161, 0x00000000}},  //   zedn, _неме, niky_,
  { {0xd7c70061, 0xfbd100a1, 0xe8940b87, 0x00000000}},  //   लांच, رتے_, фаль,
  { {0xdb0e0219, 0x9f580c42, 0xe3b8014a, 0x00000000}},  //   _habí, nirà_, rlık_,
  { {0x63a80027, 0xa01b0210, 0x3a260093, 0x00000000}},  //   vedn, krön, plop_,
  { {0xceb3009b, 0xbb43022a, 0x682d0051, 0x00000000}},  //   תיה_, _ческ, rúda,
  { {0x660010ed, 0x67ef0146, 0x00000000, 0x00000000}},  //   rimk, _bøjd,   ,
  { {0x628813c5, 0x660000e7, 0xb05b00f8, 0x00000000}},  //   tudo, simk, lväg,
  { {0x63a80027, 0xa75b009b, 0x9f5813c6, 0x00000000}},  //   redn, _הדבר, dirà_,
  { {0xdb0e13c7, 0x62880030, 0x63a813c8, 0x00000000}},  //   _nabí, rudo, sedn,
  { {0x7a23006c, 0xf9930049, 0x2fda00d4, 0x00000000}},  //   mõtt, ערש_, _bopg_,
  { {0x2d9c0010, 0xa01b0010, 0xe47b0049, 0x00000000}},  //   ővel_, ltöz, _פרוכ,
  { {0x24520011, 0xe3b80276, 0xa3b5006e, 0x00000000}},  //   _hâm_, mdı_, _चोट_,
  { {0xe3b801f6, 0xdb0e0d7b, 0x00000000, 0x00000000}},  //   ldı_, _cabí,   ,
  { {0x61ed13c9, 0x67ef0030, 0x9f5813ca, 0x00000000}},  // [2470] _ilal, _høje, birà_,
  { {0xe3b801f6, 0x9f580197, 0x24520082, 0x00000000}},  //   ndı_, cirà_, _mâm_,
  { {0x2452001d, 0x61ed0107, 0xdb0e00fa, 0x00000000}},  //   _lâm_, _klal, _fabí,
  { {0x200300ee, 0x9f5800d6, 0xa9540088, 0x00000000}},  //   liji_, mirá_, екці,
  { {0x9f58004a, 0x61ed13cb, 0x00000000, 0x00000000}},  //   lirá_, _mlal,   ,
  { {0x200313cc, 0x7bc713cd, 0xb8d5006e, 0x00000000}},  //   niji_, _unju, _जन_,
  { {0xdce6001e, 0x9f580285, 0x67ef0030, 0x00000000}},  //   _iekā, nirá_, _nøje,
  { {0xb9c50426, 0x200313ce, 0xe459005e, 0x00000000}},  //   _تقري, hiji_, ожи_,
  { {0xdcfd005a, 0x69c900b5, 0xf1bf008e, 0x00000000}},  //   _kası, _inee, tlán_,
  { {0x2003000b, 0x61ed006a, 0x24520011, 0x00000000}},  //   jiji_, _alal, _dâm_,
  { {0x200313cf, 0x61ed0066, 0x32020161, 0x00000000}},  //   diji_, _blal, tiky_,
  { {0x471a007b, 0x69db028c, 0xd6d80057, 0x00000000}},  //   _וועג, _joue, _эту_,
  { {0x25090a90, 0x69db0f57, 0x05740439, 0x00000000}},  //   _برای_, _moue, _ساند,
  { {0xdcfd011f, 0xdce6001e, 0x69db00f4, 0x00000000}},  //   _nası, _nekā, _loue,
  { {0x9f5813d0, 0x5043007c, 0x69c913d1, 0x00000000}},  //   rirà_, терб, _onee,
  { {0x69db009d, 0x69c90045, 0x00000000, 0x00000000}},  //   _noue, _nnee,   ,
  { {0x2003012b, 0xdcfd0676, 0xfbc90061, 0x00000000}},  // [2480] biji_, _bası, रांम,
  { {0x20030295, 0x9f5800dc, 0x69c900c4, 0x00000000}},  //   ciji_, birá_, _anee,
  { {0x69db07f3, 0x9f58008e, 0xfc3f004a, 0x00000000}},  //   _boue, cirá_, _asís_,
  { {0x79a302a8, 0xef17008b, 0xa967137c, 0x00000000}},  //   врше, _імя_, дица_,
  { {0x7a230004, 0x33270052, 0xe3b8005d, 0x00000000}},  //   võtt, _lynx_, ydı_,
  { {0xb05b0039, 0xe3b8006b, 0x69c913d2, 0x00000000}},  //   sväg, xdı_, _enee,
  { {0x7a23006c, 0x245213d3, 0x69db009d, 0x00000000}},  //   tõtt, _sâm_, _foue,
  { {0xc883011f, 0x7bdc09fc, 0x69db0dce, 0x00000000}},  //   üğü_, _horu, _goue,
  { {0x7bdc0563, 0xe3b8006b, 0x9f5800c4, 0x00000000}},  //   _koru, tdı_, zirá_,
  { {0x88bd0046, 0x61ed01a3, 0x7bdc00ea, 0x00000000}},  //   _myśl, _slal, _joru,
  { {0x2003037e, 0xe3b801f6, 0x7bdc00c4, 0x00000000}},  //   viji_, rdı_, _moru,
  { {0xd257008b, 0x2452001d, 0x9f58004a, 0x00000000}},  //   ьць_, _tâm_, virá_,
  { {0x60f800a5, 0x20030ecc, 0xdb0e000a, 0x00000000}},  //   дняя_, tiji_, _labà,
  { {0x9f5813d4, 0x67ef0030, 0x00000000, 0x00000000}},  //   tirá_, _tøje,   ,
  { {0x61ed008e, 0xc7b8016c, 0xdb150173, 0x00000000}},  //   _tlal, _mađ_, _gazè,
  { {0x6009016c, 0x63b8068f, 0x9f580b33, 0x00000000}},  //   džme, _havn, rirá_,
  { {0x7bdc0059, 0x200313d5, 0x69db00f4, 0x00000000}},  // [2490] _boru, piji_, _roue,
  { {0x63b80de0, 0xfe7100e9, 0x7bdc049a, 0x00000000}},  //   _javn, _مگر_, _coru,
  { {0x7bdc04c8, 0x69db0e6d, 0xdcfd014a, 0x00000000}},  //   _doru, _poue, _vası,
  { {0x63b801aa, 0xc3330104, 0xdb0e00c4, 0x00000000}},  //   _lavn, דוע_, _sabã,
  { {0x1869041f, 0x07a5014c, 0xd5cf0082, 0x00000000}},  //   чали_, еалн, _bềnh_,
  { {0x63b802cc, 0x7bdc13d6, 0x76b3006b, 0x00000000}},  //   _navn, _goru, _həyə,
  { {0xd6d10a4f, 0x26c10224, 0x00000000, 0x00000000}},  //   اقع_, ího_,   ,
  { {0x7bdc014a, 0x22980010, 0x99980006, 0x00000000}},  //   _zoru, dék_, _durų_,
  { {0x7bdc011f, 0x5436026c, 0x629a13d7, 0x00000000}},  //   _yoru, کرٹر, etto,
  { {0xf6e70069, 0x2bd20061, 0x629a0203, 0x00000000}},  //   _оцен, साया, ftto,
  { {0xe9ff0011, 0x63b80091, 0xfbd2009b, 0x00000000}},  //   _giản_, _davn, אתי_,
  { {0x22490026, 0xbbdc006e, 0x386d000a, 0x00000000}},  //   _ciak_, _मक्क, _kwer_,
  { {0x64a5008b, 0x629a021e, 0x2bd20204, 0x00000000}},  //   _чала, atto, सामा,
  { {0x21290093, 0x63b80190, 0x25ad13d8, 0x00000000}},  //   _dyah_, _gavn, leel_,
  { {0x6da60175, 0xada6007c, 0x76b3006b, 0x00000000}},  //   нива, навл, _bəyə,
  { {0x7bdc0676, 0x25ad01b5, 0xc1ba13d9, 0x00000000}},  //   _soru, neel_, _رابط_,
  { {0x7bdc06a6, 0x76b3005f, 0x248d13da, 0x00000000}},  // [24a0] _poru, _dəyə, nuem_,
  { {0xa09b007b, 0x7bdc005f, 0x25ad0250, 0x00000000}},  //   _צייט, _qoru, heel_,
  { {0x88bd0046, 0x7bdc009f, 0xdb0e0010, 0x00000000}},  //   _wyśl, _voru, _babá,
  { {0xd9100123, 0x707702fd, 0x7a3100ea, 0x00000000}},  //   لیز_, _تمیز_, tåta,
  { {0x25ad00c7, 0x7bdc13db, 0x22980010, 0x00000000}},  //   deel_, _toru, zék_,
  { {0x25ad00bb, 0xdb0e00f6, 0x00000000, 0x00000000}},  //   eeel_, _tabà,   ,
  { {0x63b80bf8, 0x629a0009, 0x2cb20016, 0x00000000}},  //   _ravn, xtto, lwyd_,
  { {0x7c3e06d3, 0x63b813dc, 0x7af2014a, 0x00000000}},  //   lmpr, _savn, ıktı,
  { {0x2cb2018e, 0x248d09f7, 0x22490281, 0x00000000}},  //   nwyd_, guem_, _riak_,
  { {0xa87b012e, 0x22980010, 0xa01b03aa, 0x00000000}},  //   _מאמר, ték_, tröm,
  { {0x60c40032, 0x0566004d, 0x7c3e0026, 0x00000000}},  //   _arim, _звен, impr,
  { {0x60c413dd, 0x629a0052, 0x248d00c4, 0x00000000}},  //   _brim, rtto, buem_,
  { {0x60c41044, 0x644f1261, 0x629a00ea, 0x00000000}},  //   _crim, ícit, stto,
  { {0x2cb2018e, 0x6e260022, 0x60c40ad6, 0x00000000}},  //   dwyd_, _akkb, _drim,
  { {0x443e13de, 0x6e260093, 0x60c41045, 0x00000000}},  //   mmt_, _bkkb, _erim,
  { {0x60c4032e, 0x442c06a1, 0x644a0052, 0x00000000}},  //   _frim, lld_, _hifi,
  { {0x644a13df, 0x2cb20016, 0x442c13e0, 0x00000000}},  // [24b0] _kifi, gwyd_, old_,
  { {0x62880026, 0x644a0066, 0xdb0e0325, 0x00000000}},  //   ordo, _jifi, _sabá,
  { {0x442c000c, 0x67ef0030, 0x1df901ab, 0x00000000}},  //   ild_, _nøja, _жены_,
  { {0x644a000c, 0x443e01a2, 0x386d005b, 0x00000000}},  //   _lifi, hmt_, _pwer_,
  { {0x25ad0100, 0x644a002a, 0x67d50088, 0x00000000}},  //   veel_, _oifi, коду,
  { {0x644a13e1, 0x07a501fc, 0x6e2d051b, 0x00000000}},  //   _nifi, такн, llab,
  { {0x79a7008b, 0x443e0050, 0x25ad010e, 0x00000000}},  //   _прае, dmt_, teel_,
  { {0x6e2d011c, 0x442c13e2, 0x248d13e3, 0x00000000}},  //   nlab, eld_, tuem_,
  { {0x6e2d0038, 0x8cc403d7, 0x25ad00c7, 0x00000000}},  //   ilab, रियो, reel_,
  { {0xd7f80256, 0x60c40023, 0x00000000, 0x00000000}},  //   _пух_, _rrim,   ,
  { {0x6d5d01e5, 0x6e2d13e4, 0x25ad01d6, 0x00000000}},  //   _ofsa, klab, peel_,
  { {0x442c00b5, 0x443e01a2, 0x2cb2005b, 0x00000000}},  //   ald_, amt_, ywyd_,
  { {0x248d13e5, 0xe3ae041f, 0x62880471, 0x00000000}},  //   quem_, _кб_, ardo,
  { {0x65690030, 0x60c4016e, 0x6e2d095d, 0x00000000}},  //   lbeh, _vrim, elab,
  { {0x91fd0089, 0x7a380010, 0x6e2d0efe, 0x00000000}},  //   mpān, líte, flab,
  { {0x6e2d13e6, 0xa6e90011, 0x6569002d, 0x00000000}},  //   glab, _trươ, nbeh,
  { {0x1d0713e7, 0x44270093, 0x60c413e8, 0x00000000}},  // [24c0] вети_, _kkn_, _urim,
  { {0x2cb20016, 0x6e2d001a, 0x26c50197, 0x00000000}},  //   rwyd_, alab, _orlo_,
  { {0xeb9713e9, 0xee3a007c, 0x6e2d008e, 0x00000000}},  //   тих_, _оно_, blab,
  { {0x6e2d117e, 0x656900bb, 0x588600a5, 0x00000000}},  //   clab, jbeh, выка,
  { {0x442c068f, 0x443e06a1, 0x26c5002d, 0x00000000}},  //   yld_, ymt_, _arlo_,
  { {0x660200ab, 0x628800f8, 0x6b6302d3, 0x00000000}},  //   _smok, yrdo, _вкра,
  { {0x644a0207, 0x7bce13ea, 0x764b011c, 0x00000000}},  //   _rifi, _inbu, _bigy,
  { {0x644a0016, 0x6adb0044, 0x54b8004d, 0x00000000}},  //   _sifi, _যেকো, егия_,
  { {0x41d60309, 0x7a380010, 0x442c0035, 0x00000000}},  //   धानस, gíte, tld_,
  { {0x442c0038, 0x386613eb, 0x6e2d01c5, 0x00000000}},  //   uld_, mpor_, zlab,
  { {0x442c13ec, 0x443e0239, 0x764b0047, 0x00000000}},  //   rld_, rmt_, _figy,
  { {0x644a071d, 0x660200e0, 0x00000000, 0x00000000}},  //   _wifi, _umok,   ,
  { {0x644a13ed, 0x443e00f6, 0x7bce05a6, 0x00000000}},  //   _tifi, pmt_, _onbu,
  { {0x6e2d0048, 0xa91d012d, 0x00000000, 0x00000000}},  //   wlab, _udže,   ,
  { {0x6e2d0089, 0xdbdc000c, 0xd3780036, 0x00000000}},  //   tlab, _ráðl, mać_,
  { {0x6e24002d, 0x7bce13ee, 0xe3b8006b, 0x00000000}},  //   goib, _anbu, mlıq_,
  { {0x6e2d13ef, 0x31791072, 0xe3b8006b, 0x00000000}},  // [24d0] rlab, masz_, llıq_,
  { {0x31790047, 0x6e2d0089, 0xd3780036, 0x00000000}},  //   lasz_, slab, nać_,
  { {0xf09f13f0, 0x162202d2, 0xe3b8006b, 0x00000000}},  //   ltà_, मवार_, nlıq_,
  { {0xa01b000c, 0xf1bf00c4, 0xd37813f1, 0x00000000}},  //   fsög, ndá_, hać_,
  { {0xd3780046, 0xf09f13f2, 0x9d140088, 0x00000000}},  //   kać_, ntà_, _вдяч,
  { {0xe739026b, 0xf09f0197, 0xd3780036, 0x00000000}},  //   нел_, ità_, jać_,
  { {0xd3780046, 0x9f510211, 0x31790ef2, 0x00000000}},  //   dać_, lizó_, kasz_,
  { {0x26c50119, 0xe3b8005f, 0x7c2501ee, 0x00000000}},  //   _vrlo_, dlıq_, lohr,
  { {0x75f500b9, 0x9f51008e, 0x39150783, 0x00000000}},  //   _náze, nizó_, _смар,
  { {0x7a3813f3, 0x7c2501ca, 0xd3780036, 0x00000000}},  //   ríte, nohr, gać_,
  { {0x420a022a, 0xf09f0207, 0x7a3813f4, 0x00000000}},  //   енно_, età_, síte,
  { {0x7a3813f5, 0x09b10044, 0x00000000, 0x00000000}},  //   píte, ছাকা,   ,
  { {0x7c250d9b, 0x660900bb, 0xdb1c13f6, 0x00000000}},  //   kohr, miek, _carê,
  { {0x6609010a, 0x25bd018e, 0xd3780036, 0x00000000}},  //   liek, _hawl_, cać_,
  { {0x442513f7, 0x249f000c, 0x539a009b, 0x00000000}},  //   mol_, ltum_, _ניקו,
  { {0x6609001e, 0x4425002b, 0xe1f200d3, 0x00000000}},  //   niek, lol_, _دست_,
  { {0xa3c8006e, 0xf09f00f6, 0x00000000, 0x00000000}},  // [24e0] _लोड_, ctà_,   ,
  { {0x44250bc4, 0x249f01e5, 0x00000000, 0x00000000}},  //   nol_, itum_,   ,
  { {0x7f9b009b, 0xb05b0039, 0x91d80061, 0x00000000}},  //   _אביז, nvän, यापै,
  { {0x442513f8, 0x249f05ed, 0xd37813f9, 0x00000000}},  //   hol_, ktum_, zać_,
  { {0x4425006a, 0x7a1c00b9, 0xdbd2010e, 0x00000000}},  //   kol_, jčte, _küüs,
  { {0x44250129, 0x2ca003bd, 0xa01b000c, 0x00000000}},  //   jol_, mtid_, rsög,
  { {0x442513fa, 0x09a90055, 0x2ca00c72, 0x00000000}},  //   dol_, ওয়া, ltid_,
  { {0xd3780046, 0x200a047f, 0x963400ec, 0x00000000}},  //   wać_, hibi_, јниц,
  { {0x4425018e, 0x2ca00061, 0xc7960879, 0x00000000}},  //   fol_, ntid_, _مشاب,
  { {0x44251014, 0x3a260343, 0xe3b8006b, 0x00000000}},  //   gol_, loop_, tlıq_,
  { {0xd37813fb, 0x5334005e, 0x1666003b, 0x00000000}},  //   rać_, рент, _свем,
  { {0xf09f0198, 0xe3b8005f, 0xd3780036, 0x00000000}},  //   ttà_, rlıq_, sać_,
  { {0x442513fc, 0x3dc0018e, 0x200a13fd, 0x00000000}},  //   bol_, ddiw_, fibi_,
  { {0x4425000d, 0xf09f0a19, 0xc3560265, 0x00000000}},  //   col_, rtà_, _съдъ,
  { {0x3a2613fe, 0xf09f13ff, 0x70ae01f5, 0x00000000}},  //   koop_, stà_, टबॉल,
  { {0x270e005f, 0x443c0190, 0x9f51008e, 0x00000000}},  //   _mən_, _hhv_, tizó_,
  { {0x9f41008d, 0x1ae20055, 0x3a260007, 0x00000000}},  // [24f0] _kohë_, _গেলে_, doop_,
  { {0x320b0038, 0x66091400, 0x3eba0009, 0x00000000}},  //   licy_, ziek, _fspt_,
  { {0xddd00676, 0xa3d50164, 0x9e3501fc, 0x00000000}},  //   _çeşi, हात_, _венч,
  { {0x442510fa, 0x320b0036, 0xa91d00d0, 0x00000000}},  //   zol_, nicy_, _adža,
  { {0x44250f99, 0x2ca00016, 0x6925025f, 0x00000000}},  //   yol_, ctid_, јмла,
  { {0x66090036, 0x25bd0016, 0xba7703d6, 0x00000000}},  //   wiek, _sawl_, _مارت,
  { {0xec3600b6, 0x6609001e, 0x44251401, 0x00000000}},  //   _כאשר_, tiek, vol_,
  { {0x249f1402, 0x270e005f, 0x442501aa, 0x00000000}},  //   ttum_, _dən_, wol_,
  { {0x442504bd, 0x25bf1403, 0xfa340014, 0x00000000}},  //   tol_, rdul_, _طرفد,
  { {0x66091404, 0x249f01e5, 0x78bb0107, 0x00000000}},  //   siek, rtum_, _isuv,
  { {0x4425018e, 0x249f009f, 0xc5d501e1, 0x00000000}},  //   rol_, stum_, _віль,
  { {0x4425018e, 0x249f000c, 0xb05b0039, 0x00000000}},  //   sol_, ptum_, rvän,
  { {0x44250142, 0x200a006b, 0xdb1c0065, 0x00000000}},  //   pol_, tibi_, _parë,
  { {0x88bd0046, 0xb4fa009b, 0x645b0146, 0x00000000}},  //   _wyśw, _בפני, mqui,
  { {0x645b0219, 0x200a1405, 0xdb1c0065, 0x00000000}},  //   lqui, ribi_, _varë,
  { {0xdd9205f3, 0x06af0055, 0x8e5501fb, 0x00000000}},  //   تور_, কিপি, стрі,
  { {0xeb9a09da, 0x248d0093, 0x51f600a1, 0x00000000}},  // [2500] киа_, nrem_, _مسکر,
  { {0x907b0476, 0x307b009b, 0x2ca00056, 0x00000000}},  //   _שטיי, _שאינ, rtid_,
  { {0x703b026c, 0x2ca00004, 0xdb150181, 0x00000000}},  //   _جسٹس_, stid_, _razã,
  { {0x705301ef, 0x7ae30a3c, 0x61e400b0, 0x00000000}},  //   _دنیا, änta, _joil,
  { {0x270e005f, 0x3a2601d6, 0xdb1c00f4, 0x00000000}},  //   _sən_, roop_, _maré,
  { {0x1867012b, 0x248d1406, 0xdb071407, 0x00000000}},  //   шаљи_, drem_, _cajó,
  { {0x645b0b32, 0x5b35007e, 0xdb0501a2, 0x00000000}},  //   equi, _гэту, gehä,
  { {0xe5c60679, 0x248d1408, 0x61e40cc9, 0x00000000}},  //   рско, frem_, _noil,
  { {0x69c012bb, 0x91830082, 0x00000000, 0x00000000}},  //   _iame, _nếu_,   ,
  { {0xdb1c0263, 0x69c21409, 0xdb150010, 0x00000000}},  //   _parè, ldoe, _hazá,
  { {0x4b7b007b, 0x78a20161, 0x248d140a, 0x00000000}},  //   כטיג, ltov, arem_,
  { {0x69c200b5, 0x61e4140b, 0x69c000ab, 0x00000000}},  //   ndoe, _coil, _jame,
  { {0x78a20428, 0x69c0001a, 0xfeb801ef, 0x00000000}},  //   ntov, _mame, یافت_,
  { {0xb17b00ea, 0xdb07000a, 0xb22701e5, 0x00000000}},  //   gkår, _majò, _blæð,
  { {0x69c0000d, 0x61e4002a, 0x5187007e, 0x00000000}},  //   _oame, _foil, _купа,
  { {0x5d550113, 0xdb050073, 0x69c0140c, 0x00000000}},  //   скат, nehå, _name,
  { {0x78a2003b, 0xd7c60061, 0xbddb009d, 0x00000000}},  // [2510] jtov, लयाच, _bièr,
  { {0x6fb5025a, 0xeb930d3a, 0x0a6b06e3, 0x00000000}},  //   _امدا, تظر_, врди_,
  { {0x69c0140d, 0xcf92009b, 0x75f5140e, 0x00000000}},  //   _bame, _צטט_, _láza,
  { {0xc9870f09, 0x78a207ff, 0x00000000, 0x00000000}},  //   ружи, ftov,   ,
  { {0xf0940049, 0xf1bf0010, 0xb05b0039, 0x00000000}},  //   ַנק_, llás_, kväm,
  { {0x645d0211, 0xe8f8007e, 0x69c00085, 0x00000000}},  //   ísim, шлі_, _eame,
  { {0x69c000f4, 0x7a38140f, 0x657b011c, 0x00000000}},  //   _fame, síta, tauh,
  { {0x248d1410, 0x69c013ec, 0xff1800b3, 0x00000000}},  //   trem_, _game, יקות_,
  { {0x32f7005f, 0xf99200a3, 0x657b00b0, 0x00000000}},  //   məyə_, _מרן_, rauh,
  { {0x61e40949, 0x69c00027, 0x645b0576, 0x00000000}},  //   _soil, _zame, rqui,
  { {0x645b02d5, 0x61e41411, 0x69c0000b, 0x00000000}},  //   squi, _poil, _yame,
  { {0x245b0181, 0xa06a003b, 0xdb080010, 0x00000000}},  //   _têm_, лама_, ülés,
  { {0x61e4028c, 0x70560025, 0x27e5093e, 0x00000000}},  //   _voil, إنسا, _koln_,
  { {0x76aa005f, 0x51f60014, 0x32f7006b, 0x00000000}},  //   _həya, _گستر, həyə_,
  { {0x22950025, 0x52850025, 0x64590066, 0x00000000}},  //   _العس, _البك, _huwi,
  { {0x78a20428, 0x51f600d3, 0xdb0e033f, 0x00000000}},  //   ytov, _دستر, _tabú,
  { {0x2283011f, 0x5baa007e, 0x32f7006b, 0x00000000}},  // [2520] lık_, лкам_, dəyə_,
  { {0x69c00376, 0xaf9a003b, 0x78a20925, 0x00000000}},  //   _same, _стих_, vtov,
  { {0x69c01412, 0x62811413, 0xdcef001e, 0x00000000}},  //   _pame, nslo, _vecā,
  { {0x78a21414, 0x69c00ea9, 0x7db60025, 0x00000000}},  //   ttov, _qame, _اصدا,
  { {0x69c201b5, 0x175402d3, 0xb3b701f5, 0x00000000}},  //   rdoe, овля, _असंख,
  { {0x69c0000b, 0x78a20428, 0x69c20328, 0x00000000}},  //   _wame, rtov, sdoe,
  { {0x78a21415, 0x76aa005f, 0x75f50062, 0x00000000}},  //   stov, _bəya, _sáza,
  { {0x2283014a, 0x78a20142, 0xf1bf0051, 0x00000000}},  //   dık_, ptov, hlár_,
  { {0x62830107, 0x7a380010, 0x98b5013d, 0x00000000}},  //   _avno, líto, _आईएए,
  { {0x75f51416, 0x6459005b, 0x8cbb00a0, 0x00000000}},  //   _váza, _duwi, נציק,
  { {0x02a30805, 0xdb0500f8, 0x20180022, 0x00000000}},  //   прям, pehå, dnri_,
  { {0x22400ee1, 0x00000000, 0x00000000, 0x00000000}},  //   _chik_,   ,   ,
  { {0x25b7007a, 0xb114007e, 0x4de10044, 0x00000000}},  //   _دهند_, змяш, নসমূ,
  { {0x765a0010, 0xb4e40061, 0xb4d401f5, 0x00000000}},  //   _kuty, नही_, हमी_,
  { {0xa3d502fb, 0x32f7006b, 0x2283014a, 0x00000000}},  //   हार_, yəyə_, cık_,
  { {0x5ebb0044, 0x76aa006b, 0x75f500b9, 0x00000000}},  //   _উপদে, _xəya, _lázn,
  { {0x13ac0044, 0xc4b6007d, 0x00000000, 0x00000000}},  // [2530] _কোয়, _अनोख,   ,
  { {0x3a2d0007, 0x60cd008a, 0x765a01d6, 0x00000000}},  //   _skep_, _iram, _outy,
  { {0xbddb01aa, 0x1dc400e8, 0x60cd0091, 0x00000000}},  //   _chèc, _लोकत, _hram,
  { {0x777a0288, 0x2bf50061, 0x00000000, 0x00000000}},  //   _aetx, _इतकं_,   ,
  { {0x26cc1417, 0x32f7006b, 0x2283014a, 0x00000000}},  //   _ardo_, rəyə_, zık_,
  { {0x60cd0b4a, 0x628101ca, 0xf7710025, 0x00000000}},  //   _mram, yslo, ذات_,
  { {0xe739007c, 0xcf940049, 0x64590145, 0x00000000}},  //   шек_, לטס_, _suwi,
  { {0x7d090359, 0x60cd0197, 0x26c7021c, 0x00000000}},  //   _þess, _oram, rvno_,
  { {0x6aa50c0d, 0x442e0d25, 0xa3d5007d, 0x00000000}},  //   lthf, _bkf_, हाल_,
  { {0x981706dd, 0x2283011f, 0x52a91418, 0x00000000}},  //   _ابرا, tık_, авом_,
  { {0x60cd011f, 0xe9ff0011, 0x765a0009, 0x00000000}},  //   _aram, _nhẫn_, _guty,
  { {0x60cd137e, 0x6459011c, 0x75f50161, 0x00000000}},  //   _bram, _tuwi, _zázn,
  { {0x628101c9, 0x24191001, 0x645900e0, 0x00000000}},  //   sslo, _коды_, _uuwi,
  { {0x60cd1419, 0x7d0001e5, 0x3f9e010e, 0x00000000}},  //   _dram, _ýmsi, ütu_,
  { {0x60cd022b, 0xd3470014, 0x22400082, 0x00000000}},  //   _eram, _دیده_, _thik_,
  { {0x60cd141a, 0x7bd5010f, 0x61fd010f, 0x00000000}},  //   _fram, _anzu, chsl,
  { {0xdca30264, 0xac0a00ed, 0x00000000, 0x00000000}},  // [2540] мати, анаа_,   ,
  { {0x60260088, 0x91a600a1, 0x9f6000b0, 0x00000000}},  //   _єдна, _اچھے_, ärät_,
  { {0x2bce001c, 0x75f506b8, 0xda650025, 0x00000000}},  //   _होणा, _názo, كاني,
  { {0x7a380010, 0x7bd50288, 0x00000000, 0x00000000}},  //   ríto, _enzu,   ,
  { {0x7989018e, 0x2db7009b, 0x636601dc, 0x00000000}},  //   _ddew, _ולכן_, nční,
  { {0x7a3812c2, 0xdb1c008e, 0x2d801172, 0x00000000}},  //   píto, _harí, laie_,
  { {0xf1ca007d, 0x5694058e, 0x00000000, 0x00000000}},  //   ियान, чайт,   ,
  { {0x95ca012b, 0x442e141b, 0x2bce141c, 0x00000000}},  //   рука_, _skf_, _होता,
  { {0xe9ff0011, 0x75fc0010, 0x18670088, 0x00000000}},  //   _hiến_, _néze, _мати_,
  { {0xe9ff001d, 0x26cc00ca, 0x765a0045, 0x00000000}},  //   _kiến_, _trdo_, _tuty,
  { {0x60cd0295, 0x6fde0316, 0x75f50010, 0x00000000}},  //   _sram, मानं, _gázo,
  { {0x60cd010a, 0xe9ff0082, 0x00000000, 0x00000000}},  //   _pram, _miến_,   ,
  { {0x845a00ed, 0x4fc705bb, 0x00000000, 0x00000000}},  //   _трет_, осва,   ,
  { {0xe9ff0082, 0x00000000, 0x00000000, 0x00000000}},  //   _phẫn_,   ,   ,
  { {0x442c0030, 0xe29700ed, 0x22630142, 0x00000000}},  //   mod_, _дај_, ľské_,
  { {0x60cd141d, 0x442c141e, 0x2d58041f, 0x00000000}},  //   _tram, lod_, жить_,
  { {0xa802011f, 0x60cd0020, 0xdb1c008e, 0x00000000}},  // [2550] şıyo, _uram, _darí,
  { {0x442c141f, 0xe9ff001d, 0x7bc502c2, 0x00000000}},  //   nod_, _biến_, udhu,
  { {0x20111420, 0xdb1c00d4, 0x7bc50065, 0x00000000}},  //   mizi_, _farí, rdhu,
  { {0x442c1421, 0x24860119, 0x2011000b, 0x00000000}},  //   hod_, _ovom_, lizi_,
  { {0x442c09f3, 0x7e62089f, 0x6e2d059e, 0x00000000}},  //   kod_, _čopi, moab,
  { {0x2011047f, 0xcc760097, 0x7bd5010f, 0x00000000}},  //   nizi_, _מעשה_, _unzu,
  { {0xea63026c, 0x442c1422, 0x9675007e, 0x00000000}},  //   _آپری, dod_, чылі,
  { {0x20111423, 0x9f580026, 0x7642113e, 0x00000000}},  //   hizi_, nirò_, _choy,
  { {0x442c018e, 0x5884007e, 0x20110020, 0x00000000}},  //   fod_, _жыха, kizi_,
  { {0x442c006a, 0x20110091, 0x2d801424, 0x00000000}},  //   god_, jizi_, zaie_,
  { {0x20111425, 0x00000000, 0x00000000, 0x00000000}},  //   dizi_,   ,   ,
  { {0x27340051, 0x76420145, 0x00000000, 0x00000000}},  //   súnú_, _ghoy,   ,
  { {0xa01b010f, 0x442c018e, 0x455a0104, 0x00000000}},  //   rsön, bod_, _הכנס,
  { {0x7fd50099, 0x7649014a, 0x20111426, 0x00000000}},  //   місі, lmey, gizi_,
  { {0x2d80001a, 0xdee60088, 0xd0070140, 0x00000000}},  //   taie_, чови, чере_,
  { {0x661b1427, 0x7649014a, 0xee3a07d0, 0x00000000}},  //   nnuk, nmey, ёна_,
  { {0xd347007a, 0x2d800a86, 0x20110032, 0x00000000}},  // [2560] _دیگه_, raie_, bizi_,
  { {0x2d80009d, 0x5ebb0044, 0x20110035, 0x00000000}},  //   saie_, _উপরে, cizi_,
  { {0x05bd0061, 0x7a380010, 0x661b0058, 0x00000000}},  //   ्याब, sítm, knuk,
  { {0x442c1428, 0xdb1c1429, 0x98a60088, 0x00000000}},  //   zod_, _parâ, зиде,
  { {0xed520014, 0x442c011c, 0xdb1c00c4, 0x00000000}},  //   _سپس_, yod_, _barã,
  { {0xe9ff001d, 0xdb0e00b9, 0xdc6700aa, 0x00000000}},  //   _tiến_, _zabý, _хард_,
  { {0x8c4307ca, 0x24860119, 0x7649142a, 0x00000000}},  //   _чере, _svom_, fmey,
  { {0xd49a0216, 0xceb300b6, 0x442c0016, 0x00000000}},  //   бро_, גיה_, wod_,
  { {0x38c800d3, 0x442c142b, 0x7d04000b, 0x00000000}},  //   _بازی_, tod_, nzis,
  { {0xa2f40088, 0x7d00000c, 0x07a3142c, 0x00000000}},  //   дпоч, _ýmsu, _паун,
  { {0x442c0016, 0x64480089, 0x201100b9, 0x00000000}},  //   rod_, rmdi, vizi_,
  { {0xd257008b, 0x442c142d, 0x79820020, 0x00000000}},  //   яць_, sod_, naow,
  { {0x442c0119, 0x2011142e, 0x5067142f, 0x00000000}},  //   pod_, tizi_, ятна,
  { {0x1ae20055, 0x7d040036, 0xdb0e008e, 0x00000000}},  //   _গেছে_, dzis, _jabó,
  { {0x63ba073a, 0x533306e3, 0x20110041, 0x00000000}},  //   metn, _пешт, rizi_,
  { {0x63ba01d9, 0x67ef0030, 0x629a07b4, 0x00000000}},  //   letn, _højt, muto,
  { {0x629a011c, 0x20110173, 0x9f580026, 0x00000000}},  // [2570] luto, pizi_, rirò_,
  { {0xf0450167, 0x7a381430, 0x63ba04eb, 0x00000000}},  //   _تعبی, líth, netn,
  { {0x629a0489, 0x3f830119, 0xdb1c0129, 0x00000000}},  //   nuto, maju_, _carà,
  { {0x63ba0010, 0x3915007c, 0x7aea0039, 0x00000000}},  //   hetn, ммер, äfta,
  { {0x48ab01bd, 0x1a6800a1, 0x76aa006b, 0x00000000}},  //   стем_, _ہیلی_, _dəym,
  { {0x63ba11cc, 0x629a0142, 0xfe700014, 0x00000000}},  //   jetn, kuto, _جدی_,
  { {0x629a1431, 0x2ca9076a, 0x7649014a, 0x00000000}},  //   juto, ltad_, tmey,
  { {0x629a1432, 0x7bc70b37, 0x661b016c, 0x00000000}},  //   duto, _haju, unuk,
  { {0x7649011f, 0x2ca91433, 0x3f831434, 0x00000000}},  //   rmey, ntad_, kaju_,
  { {0x3f830119, 0x386d0197, 0xdb1c008e, 0x00000000}},  //   jaju_, _iter_, _hará,
  { {0x7bc706fe, 0x3f831435, 0x7d040197, 0x00000000}},  //   _maju, daju_, zzis,
  { {0x2ca91436, 0x7bc701a3, 0xe5e500a2, 0x00000000}},  //   ktad_, _laju, _تزئی,
  { {0x629a0ef7, 0xa3c802f4, 0x53a50b11, 0x00000000}},  //   auto, _लोक_, _жалб,
  { {0x629a1437, 0x63ba016c, 0xad9b00f6, 0x00000000}},  //   buto, cetn, _llúd,
  { {0xe9ff001d, 0x67ef0030, 0xbea302dc, 0x00000000}},  //   _nhắn_, _højs, карк,
  { {0xee3a0822, 0x00000000, 0x00000000, 0x00000000}},  //   іна_,   ,   ,
  { {0xbc6a0070, 0x3f830091, 0x7a380802, 0x00000000}},  // [2580] زمان_, baju_, sítk,
  { {0x3f83016c, 0x60c4011f, 0x7d04001a, 0x00000000}},  //   caju_, _isim, rzis,
  { {0x7a3806c2, 0xdb1c11e7, 0xfbd1026c, 0x00000000}},  //   líti, _bará, ھتے_,
  { {0xdb1c0489, 0x63ba1438, 0xad9b0051, 0x00000000}},  //   _cará, zetn, _clúd,
  { {0x307a0049, 0xdb1c077b, 0x61fd0065, 0x00000000}},  //   קאַנ, _dará, ërli,
  { {0x60c4000b, 0x466a017f, 0xdb0e0173, 0x00000000}},  //   _msim, орим_, _dabò,
  { {0xa3c802fb, 0x25ad063c, 0x63ba0059, 0x00000000}},  //   _लोग_, ffel_, vetn,
  { {0x3f830107, 0x60c404c6, 0xdb1c0387, 0x00000000}},  //   zaju_, _osim, _gará,
  { {0x63ba0059, 0x60c40009, 0x7bc700e7, 0x00000000}},  //   tetn, _nsim, _yaju,
  { {0x629a1439, 0xb05b010f, 0xa91d0087, 0x00000000}},  //   tuto, hwäc, _sežg,
  { {0x63ba143a, 0x3f831435, 0x65c60326, 0x00000000}},  //   retn, vaju_, _обжа,
  { {0x629a0039, 0x63ba021a, 0x741300a6, 0x00000000}},  //   ruto, setn, _یونا,
  { {0x3f83037e, 0xc5f3009b, 0x798001aa, 0x00000000}},  //   taju_, _בדף_, _memw,
  { {0x67ef0030, 0x7a380010, 0x60c40087, 0x00000000}},  //   _højr, síth, _dsim,
  { {0x60c408b2, 0x3f830119, 0x7bc7143b, 0x00000000}},  //   _esim, raju_, _raju,
  { {0x3f83037e, 0x2ca9143c, 0x7bc701c5, 0x00000000}},  //   saju_, ttad_, _saju,
  { {0x64580ac2, 0x7bc7143d, 0x3f830091, 0x00000000}},  // [2590] _kivi, _paju, paju_,
  { {0x2ca90211, 0x2c640039, 0x9f450010, 0x00000000}},  //   rtad_, _död_, óló_,
  { {0x2ca9143e, 0x61ed0142, 0x62880007, 0x00000000}},  //   stad_, _koal, nsdo,
  { {0x645811d1, 0xdb26007a, 0xceb2007b, 0x00000000}},  //   _livi, رونی, _גיט_,
  { {0x9f580051, 0x7bc70127, 0x61ed0035, 0x00000000}},  //   mhrá_, _taju, _moal,
  { {0x07a20893, 0xb05b0c4d, 0x27fe0022, 0x00000000}},  //   гашн, lväs, _cltn_,
  { {0x25ad000d, 0x49bb0014, 0x1995007e, 0x00000000}},  //   tfel_, _وارد_, _павя,
  { {0xcf58012e, 0x6b8504cb, 0x62880239, 0x00000000}},  //   ובות_, lahg, dsdo,
  { {0x6458143f, 0x25ad0678, 0x628a00ea, 0x00000000}},  //   _bivi, rfel_, _avfo,
  { {0xc747006d, 0xd9f50061, 0x13091001, 0x00000000}},  //   _قضاي, _आवडत_, зной_,
  { {0xa91d0059, 0x61ed001a, 0x60c401f3, 0x00000000}},  //   _deže, _boal, _ssim,
  { {0x61ed027b, 0x25e0001c, 0x69cb1440, 0x00000000}},  //   _coal, काणी_, ndge,
  { {0xe9ff001d, 0x61ed0032, 0x69c900e0, 0x00000000}},  //   _nhận_, _doal, _maee,
  { {0x7a381441, 0x64581442, 0x2c640039, 0x00000000}},  //   ríti, _givi, _röd_,
  { {0x62880045, 0x6e290161, 0x00000000, 0x00000000}},  //   csdo, čebn,   ,
  { {0x6458037e, 0x91fd0089, 0xa3c50061, 0x00000000}},  //   _zivi, spār, _उघड_,
  { {0xdd8f0318, 0x60c40020, 0xf6520049, 0x00000000}},  // [25a0] صول_, _usim, רצן_,
  { {0x61ed02ae, 0x26c50292, 0x69c900f6, 0x00000000}},  //   _zoal, _oslo_, _aaee,
  { {0xdb1c02d5, 0x8f9b01ce, 0x2c52000a, 0x00000000}},  //   _març, _ציטי, _jņdi_,
  { {0x427a0049, 0x27fe0022, 0xb05b00f8, 0x00000000}},  //   פאנג, _sltn_, mvär,
  { {0x27fe0093, 0xb05b00f8, 0x27ec0087, 0x00000000}},  //   _pltn_, lvär, _podn_,
  { {0xfaa6007e, 0xf7780066, 0x69cb01c3, 0x00000000}},  //   _паго, _roħs_, adge,
  { {0x64580207, 0x798001aa, 0x8f9b01ce, 0x00000000}},  //   _rivi, _temw, ליסי,
  { {0x6458099e, 0xc1ca006e, 0xa91d1443, 0x00000000}},  //   _sivi, ियोग, _seže,
  { {0x7659018e, 0xdb1c0129, 0x61ed013f, 0x00000000}},  //   _diwy, _barç, _roal,
  { {0xa01b0073, 0xb4c00061, 0x61ed1444, 0x00000000}},  //   rsök, _ंनी_, _soal,
  { {0x64580219, 0x61ed0035, 0x00000000, 0x00000000}},  //   _vivi, _poal,   ,
  { {0x2d820059, 0x62880125, 0xb05b00f8, 0x00000000}},  //   _neke_, rsdo, dvär,
  { {0xa91d050f, 0x61ed0b94, 0x7bdc0116, 0x00000000}},  //   _teže, _voal, _onru,
  { {0xdb1c1184, 0x00000000, 0x00000000, 0x00000000}},  //   _garç,   ,   ,
  { {0x2d820173, 0x76aa013f, 0x00000000, 0x00000000}},  //   _beke_, _bəyi,   ,
  { {0xbddb00f4, 0xe9ff0011, 0x7bdc010f, 0x00000000}},  //   _thèm, _phận_, _anru,
  { {0x76aa005f, 0x5d55026b, 0xa3d50061, 0x00000000}},  // [25b0] _dəyi, ткат, हाच_,
  { {0xb6030027, 0xfe710167, 0xf1bf1445, 0x00000000}},  //   čšin, _نگر_, leá_,
  { {0x20130066, 0xa01b0010, 0xb05b00f8, 0x00000000}},  //   _imxi_, kröz, sväs,
  { {0xe9ff0011, 0x38a91446, 0x7bdc0325, 0x00000000}},  //   _thận_, túr_, _enru,
  { {0x69cb037f, 0x28f803e8, 0x00000000, 0x00000000}},  //   rdge, нець_,   ,
  { {0x6b850045, 0x673a01d6, 0x00000000, 0x00000000}},  //   qahg, _bytj,   ,
  { {0x3d150061, 0x38a90a87, 0x2d820145, 0x00000000}},  //   _नेते_, súr_, _yeke_,
  { {0xa91d05fa, 0x9b5800aa, 0xb60601ed, 0x00000000}},  //   _vežb, _чист_, ješć,
  { {0xdb1c047f, 0xf1bf0027, 0x65690023, 0x00000000}},  //   _parç, deá_, rceh,
  { {0x75f50161, 0x00000000, 0x00000000, 0x00000000}},  //   _názv,   ,   ,
  { {0xf1dd0365, 0xfbd200b6, 0x41dd0061, 0x00000000}},  //   यांन, בתי_, यांस,
  { {0x22490263, 0x15150ae0, 0x7a380010, 0x00000000}},  //   _chak_, _идея, sítv,
  { {0x2d82003b, 0xd9e30044, 0x28c7013d, 0x00000000}},  //   _reke_, _মতাম, लिटि,
  { {0x35a7006e, 0x395f00e0, 0x22490032, 0x00000000}},  //   _गाड़, _lgus_, _ehak_,
  { {0x2d820020, 0x2be00067, 0x0eb90783, 0x00000000}},  //   _peke_, नासा, нуты_,
  { {0xc69201f8, 0xf1bf0051, 0x25bf00e5, 0x00000000}},  //   יאל_, ceá_, neul_,
  { {0xb05b0039, 0x25b2014a, 0xd24f0379, 0x00000000}},  // [25c0] rvär, _öyle_, _بني_,
  { {0x395f0195, 0x0e661447, 0xd00f0076, 0x00000000}},  //   _agus_, _икон, _ولي_,
  { {0xbad5008b, 0x76aa006b, 0x2d820056, 0x00000000}},  //   ліцы, _təyi, _teke_,
  { {0xb33c01d5, 0x2018011c, 0x60d60036, 0x00000000}},  //   ngħa, liri_, _krym,
  { {0x1867033c, 0x8b660151, 0x00000000, 0x00000000}},  //   вачи_, _لازم,   ,
  { {0xe9ff001d, 0x6d46115c, 0x7bdc01a2, 0x00000000}},  //   _phản_, _izka, _unru,
  { {0xcac70175, 0x2ca00250, 0x1ae3007c, 0x00000000}},  //   _игре_, luid_, _корм,
  { {0x20180020, 0x7c3e09b0, 0xbddb000a, 0x00000000}},  //   hiri_, llpr, _chèh,
  { {0x20181448, 0xb6060521, 0x2ca0010e, 0x00000000}},  //   kiri_, vešć, nuid_,
  { {0x2018000b, 0xe9ff0082, 0x9f5a00f6, 0x00000000}},  //   jiri_, _thản_, _alpí_,
  { {0x201804d4, 0xdd2f00b9, 0xf2c30605, 0x00000000}},  //   diri_, měťo, асян,
  { {0x7a380489, 0x2ca0006c, 0x25bf0035, 0x00000000}},  //   pítu, kuid_, ceul_,
  { {0x20180294, 0x66021449, 0x3eba062a, 0x00000000}},  //   firi_, _ilok, _appt_,
  { {0x201804d4, 0xdb170181, 0x3eba0093, 0x00000000}},  //   giri_, nexã, _bppt_,
  { {0x660201e3, 0x6d46002d, 0xb33c002b, 0x00000000}},  //   _klok, _azka, bgħa,
  { {0x60d60065, 0x7c3e144a, 0xe3b000a1, 0x00000000}},  //   _frym, elpr, _خرچ_,
  { {0x2018000b, 0x60d6144b, 0x2ca0004a, 0x00000000}},  // [25d0] biri_, _grym, guid_,
  { {0x2018144c, 0x61fd01d6, 0x25bf001a, 0x00000000}},  //   ciri_, lksl, zeul_,
  { {0x443e1274, 0x6602144d, 0x4975003b, 0x00000000}},  //   ilt_, _olok, глес,
  { {0x443e001f, 0x61fd007f, 0x7c3e144e, 0x00000000}},  //   hlt_, nksl, alpr,
  { {0x693400ed, 0x5d9a012f, 0xa91d144f, 0x00000000}},  //   анцу, _אברה, _beža,
  { {0x66020b80, 0x7e650022, 0x00000000, 0x00000000}},  //   _alok, _kuhp,   ,
  { {0x66020209, 0x7a380047, 0x25bf0035, 0x00000000}},  //   _blok, gíts, teul_,
  { {0x20180294, 0x00000000, 0x00000000, 0x00000000}},  //   ziri_,   ,   ,
  { {0x644a002a, 0x629a0211, 0x20181450, 0x00000000}},  //   _bhfi, erto, yiri_,
  { {0x6602021e, 0x3fce0044, 0x60d60065, 0x00000000}},  //   _elok, _রক্ষ, _rrym,
  { {0x6602009f, 0x2018014a, 0xb33c002b, 0x00000000}},  //   _flok, viri_, tgħa,
  { {0x443e06a8, 0x20180729, 0x00000000, 0x00000000}},  //   alt_, wiri_,   ,
  { {0x201811af, 0x25e002fb, 0x657b1451, 0x00000000}},  //   tiri_, कारी_, mbuh,
  { {0x5ebb0044, 0x04920025, 0x23290256, 0x00000000}},  //   _উপজে, _الوح, _поли_,
  { {0x2018000b, 0x7f1901ff, 0x629a00ca, 0x00000000}},  //   riri_, віту_, crto,
  { {0x20180da4, 0x61fd1452, 0x2ca0006c, 0x00000000}},  //   siri_, cksl, tuid_,
  { {0xfce30069, 0x248d1453, 0x271f013d, 0x00000000}},  // [25e0] бото, nsem_, यपुर_,
  { {0x6d4601dc, 0x207b0049, 0x2ca003b3, 0x00000000}},  //   _vzka, _ראיא, ruid_,
  { {0x23a60061, 0x7c3e0009, 0x657b011c, 0x00000000}},  //   _खासद, rlpr, kbuh,
  { {0x5336007b, 0x248d095c, 0x3f8a00a9, 0x00000000}},  //   אנען_, ksem_, labu_,
  { {0x81ce0055, 0x46140014, 0xddc40036, 0x00000000}},  //   রাপ_, یوتر, rmiń,
  { {0x660201c5, 0x67d40131, 0x3f8a00e7, 0x00000000}},  //   _slok, року, nabu_,
  { {0x66020006, 0x443e0190, 0xdcfd0089, 0x00000000}},  //   _plok, vlt_, _iesā,
  { {0x6e2401e5, 0x3f8a000b, 0x7bce01a3, 0x00000000}},  //   nnib, habu_, _habu,
  { {0x7bce1454, 0xa91d0746, 0x248d0010, 0x00000000}},  //   _kabu, _teža, gsem_,
  { {0x78a21455, 0x443e009d, 0x439401fc, 0x00000000}},  //   muov, ult_, јанс,
  { {0x7bce006a, 0x81ce0044, 0x3f85000c, 0x00000000}},  //   _mabu, রান_, ðlum_,
  { {0x7bce1456, 0x25e00061, 0xdb1c0051, 0x00000000}},  //   _labu, काळी_, _barú,
  { {0x78a20197, 0x00000000, 0x00000000, 0x00000000}},  //   nuov,   ,   ,
  { {0x7bce011c, 0x629a00ca, 0xcbbf0044, 0x00000000}},  //   _nabu, prto, _উচ্ছ,
  { {0x321908d2, 0xa91d1457, 0xb7db0049, 0x00000000}},  //   pisy_, _nežn, עקלי,
  { {0x821500a1, 0x7bce011c, 0x00000000, 0x00000000}},  //   _خوبص, _aabu,   ,
  { {0x3f8a000b, 0x69c21458, 0x9c3900ed, 0x00000000}},  // [25f0] babu_, deoe, впат_,
  { {0x5d5400ed, 0x7bce01a3, 0x26e4013d, 0x00000000}},  //   скут, _cabu, _कपूर_,
  { {0xdb150211, 0x5e470025, 0x7bce01c5, 0x00000000}},  //   _razó, _مضحك, _dabu,
  { {0x248d1083, 0xdb15004a, 0xa91d00ca, 0x00000000}},  //   ysem_, _sazó, _dežn,
  { {0x7bce1459, 0x225907e4, 0x00000000, 0x00000000}},  //   _fabu, írky_,   ,
  { {0xb8cd03d7, 0x7bce145a, 0xa695098c, 0x00000000}},  //   _कम_, _gabu, ариј,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7bce0027, 0x3f8a0087, 0x6b87012d, 0x00000000}},  //   _zabu, zabu_, _hejg,
  { {0x81ce0055, 0xccf2007b, 0xdb05010f, 0x00000000}},  //   রাম_, ַכט_, gehö,
  { {0x3ea30065, 0x798b0058, 0x7d0d016c, 0x00000000}},  //   kujt_, lagw, izas,
  { {0x248d0181, 0xfbcf0044, 0x657b011c, 0x00000000}},  //   ssem_, রাপত, pbuh,
  { {0xdb0503a9, 0xa06a0c27, 0xc1060025, 0x00000000}},  //   behö, кама_, لوجي,
  { {0x3f8a000b, 0xa91d01c5, 0x00000000, 0x00000000}},  //   tabu_, _mežo,   ,
  { {0x8fa601f9, 0x661b010a, 0x660901d5, 0x00000000}},  //   јаве, liuk, lhek,
  { {0x3f8a0020, 0xa2250014, 0x539a009b, 0x00000000}},  //   rabu_, _گروه, _סיקו,
  { {0x3f8a0020, 0x661b0006, 0x442508d9, 0x00000000}},  //   sabu_, niuk, lnl_,
  { {0xed5a01f9, 0x3b86005e, 0x7bce13b1, 0x00000000}},  // [2600] тоа_, илаг, _pabu,
  { {0x4f960153, 0x9b850647, 0x644100ff, 0x00000000}},  //   _триу, مؤمن, nlli,
  { {0x644100f4, 0xbf9b00a3, 0x661b0a64, 0x00000000}},  //   illi, _בייש, kiuk,
  { {0x7bce145b, 0xe8fa012b, 0xbcfb0047, 0x00000000}},  //   _wabu, кле_, _igén,
  { {0x7fe904e1, 0x7d0d0036, 0x8d630088, 0x00000000}},  //   _شریف_, czas, _євре,
  { {0x48130088, 0xa91d0ecc, 0x69c20032, 0x00000000}},  //   оміс, _težn, seoe,
  { {0xddc40089, 0x2cb20007, 0xe5c6030d, 0x00000000}},  //   rmiņ, ltyd_, аспо,
  { {0x8881026c, 0x6441021e, 0xa01b145c, 0x00000000}},  //   _کیون, elli, nsör,
  { {0x2cb201d6, 0x186a0088, 0x75fc000a, 0x00000000}},  //   ntyd_, _рази_, _jézi,
  { {0xf366098c, 0xe9ff001d, 0x6908005d, 0x00000000}},  //   штин, _phần_, ırdı,
  { {0x7bd90049, 0x5334005e, 0x326602ea, 0x00000000}},  //   אַרק, сент, јтов,
  { {0xd5b002fd, 0x9f580051, 0x66090020, 0x00000000}},  //   _رفت_, bhrú_, chek,
  { {0x6441145d, 0x600200c4, 0xba5708cd, 0x00000000}},  //   blli, _cômo, יסטו_,
  { {0xe9ff001d, 0xfe73031d, 0x2005000c, 0x00000000}},  //   _thần_, قدر_, óli_,
  { {0x54390049, 0x22940025, 0x3a2600bb, 0x00000000}},  //   _געװא, _البس, knop_,
  { {0x2cb201d6, 0xb7fe0044, 0x75fc009d, 0x00000000}},  //   ftyd_, ্চিত_, _bézi,
  { {0x6b870065, 0xacf802e9, 0x7c87007c, 0x00000000}},  // [2610] _pejg, анту_, рубе,
  { {0x60cd0013, 0x81ce0044, 0x3ea30065, 0x00000000}},  //   _isam, রাণ_, pujt_,
  { {0xa91d145e, 0xdce70180, 0x6fb6009e, 0x00000000}},  //   _pežo, ılıd, _امپا,
  { {0xa2d7006e, 0x00000000, 0x00000000, 0x00000000}},  //   यित्,   ,   ,
  { {0x491103d7, 0x644100b0, 0x798b0f65, 0x00000000}},  //   _देखो_, ylli, ragw,
  { {0x60cd0020, 0x798b107e, 0x8d5a009b, 0x00000000}},  //   _msam, sagw, _תכשי,
  { {0x660905c6, 0x7bc5145f, 0xfeca0049, 0x00000000}},  //   thek, mehu, ָמפּ,
  { {0xc4850265, 0x60cd06a6, 0x7bc50146, 0x00000000}},  //   блик, _osam, lehu,
  { {0xf795008b, 0xe9ff0011, 0x64411460, 0x00000000}},  //   _газэ, _chấn_, tlli,
  { {0xf09f01e8, 0x66090f87, 0xf7700025, 0x00000000}},  //   drà_, shek, _قام_,
  { {0xd7f80b87, 0x60cd07ed, 0x7c2200f4, 0x00000000}},  //   _тут_, _asam, éori,
  { {0x64411461, 0x7bc50065, 0x60cd0145, 0x00000000}},  //   slli, hehu, _bsam,
  { {0x7bc500ea, 0x79890112, 0xf09f00f6, 0x00000000}},  //   kehu, _meew, grà_,
  { {0x43850054, 0x18350049, 0x249f0190, 0x00000000}},  //   _الثق, מאָל_, mrum_,
  { {0x60cd06bd, 0x7bc50190, 0xf09f0129, 0x00000000}},  //   _esam, dehu, arà_,
  { {0xf09f00d4, 0x249f1462, 0x4d66007e, 0x00000000}},  //   brà_, orum_, скав,
  { {0x1b150055, 0x61e41463, 0xfce30140, 0x00000000}},  // [2620] _তুলে_, _inil, пото,
  { {0x7bc50030, 0xf1bf0051, 0x61f600e0, 0x00000000}},  //   gehu, nnán_, _hoyl,
  { {0x249f0180, 0x2cb20007, 0x201a00e0, 0x00000000}},  //   hrum_, styd_, _impi_,
  { {0x994a0025, 0x9b9602fd, 0xc332009b, 0x00000000}},  //   هلال_, _گلست, הוב_,
  { {0x2d800020, 0x98a30242, 0x5e570049, 0x00000000}},  //   mbie_, зиче, _ליטע_,
  { {0x249f1464, 0x2d800bd3, 0xdb1e1465, 0x00000000}},  //   drum_, lbie_, lepí,
  { {0x05240044, 0x667400a6, 0x201a0022, 0x00000000}},  //   _পরের_, زگار, _mmpi_,
  { {0xe5c6007c, 0xe9ff0011, 0x443c000c, 0x00000000}},  //   сско, _phấn_, _skv_,
  { {0x32ee006b, 0x8cdb006e, 0xb9060364, 0x00000000}},  //   məyi_, नियो, _узак,
  { {0x61e40f6a, 0xf09f0207, 0x2ca00f9b, 0x00000000}},  //   _anil, vrà_, irid_,
  { {0x61f6014a, 0x249f00f6, 0x60cd00ea, 0x00000000}},  //   _boyl, arum_, _ssam,
  { {0xf09f04b9, 0x64a6007e, 0x201a1466, 0x00000000}},  //   trà_, _гада, _ampi_,
  { {0x339407d0, 0x7bc500e7, 0x44fa0439, 0x00000000}},  //   _далё, yehu, _حراج_,
  { {0x3e6e0224, 0xf09f1467, 0x2ca01468, 0x00000000}},  //   _být_, rrà_, drid_,
  { {0x7bc50190, 0x61f60544, 0x32b70025, 0x00000000}},  //   vehu, _foyl, _هدية_,
  { {0xf09f0197, 0x60cd0051, 0x2ceb007c, 0x00000000}},  //   prà_, _tsam, льзо_,
  { {0x60cd0091, 0x7bc51469, 0x00000000, 0x00000000}},  // [2630] _usam, tehu,   ,
  { {0x7b67146a, 0xbddb146b, 0xdcfd0006, 0x00000000}},  //   стае, _chèr, _nesą,
  { {0x2d800ace, 0x2ca00004, 0x79890022, 0x00000000}},  //   bbie_, arid_, _peew,
  { {0x80cc0044, 0x7bc50190, 0xdb1c000c, 0x00000000}},  //   ামর্, sehu, _farþ,
  { {0x7bc50190, 0x75fc0010, 0xe3b80095, 0x00000000}},  //   pehu, _jézu, kfı_,
  { {0x4cba0049, 0xbddb009d, 0x8699007c, 0x00000000}},  //   _דזשו, _thès, атит_,
  { {0x3209005a, 0x7989146c, 0x24860022, 0x00000000}},  //   _olay_, _teew, _awom_,
  { {0x249f092d, 0xb05b010f, 0x32ee006b, 0x00000000}},  //   trum_, swäh, cəyi_,
  { {0xdb1e001a, 0x61f60203, 0x00000000, 0x00000000}},  //   cepâ, _royl,   ,
  { {0x61e4000c, 0x3209146d, 0x249f000c, 0x00000000}},  //   _snil, _alay_, rrum_,
  { {0x81ce0044, 0xf1bf13ab, 0x320900d4, 0x00000000}},  //   রাস_, rnán_, _blay_,
  { {0x2d8b146e, 0xcad6009b, 0x32090133, 0x00000000}},  //   _nece_, קורת_, _clay_,
  { {0xa06a0816, 0x628e0010, 0xb5c80014, 0x00000000}},  //   рага_, ábor, _دونم_,
  { {0x320907b1, 0xee3f0142, 0x00000000, 0x00000000}},  //   _elay_, _aký_,   ,
  { {0x32090b3d, 0x9e0501f5, 0x61f6013f, 0x00000000}},  //   _flay_, रसंघ_, _toyl,
  { {0x61e40093, 0x3d150061, 0x2d8b01ed, 0x00000000}},  //   _unil, _नइखे_, _cece_,
  { {0x2d8b003b, 0xee370245, 0xbddb00f4, 0x00000000}},  // [2640] _dece_, іну_, _chèq,
  { {0x8b26007e, 0xeb9a0d99, 0x2ca008ce, 0x00000000}},  //   одзе, риж_, rrid_,
  { {0x2d8b0207, 0xf1bf0010, 0x6ac603d6, 0x00000000}},  //   _fece_, knál_, تقام,
  { {0xa3d503d7, 0x752f0036, 0x2d8b01df, 0x00000000}},  //   ाएँ_, żczy, _gece_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xec3400a6, 0x2d8b001a, 0x00000000, 0x00000000}},  //   _روزگ, _zece_,   ,
  { {0xdb1c0065, 0x491a013d, 0xab270517, 0x00000000}},  //   _mbrë, _मेरो_, _дора_,
  { {0x16370054, 0x7ae10047, 0xd5b7041f, 0x00000000}},  //   يسية_, _álta, ось_,
  { {0xa3d503d7, 0x6fca0061, 0x442a003b, 0x00000000}},  //   ाएं_, ाजां, ицом_,
  { {0x22400047, 0x344a00e2, 0x00000000, 0x00000000}},  //   _akik_, јчин_,   ,
  { {0x32090038, 0xe73a0088, 0x2a6400e7, 0x00000000}},  //   _play_, _теж_, _kimb_,
  { {0x60100073, 0x78a20062, 0x80ac006e, 0x00000000}},  //   _jämf, orov, _जमशे,
  { {0xd258008b, 0x2d8b001a, 0xf9930104, 0x00000000}},  //   юць_, _rece_, ורר_,
  { {0x2d8b016c, 0x600b146f, 0x78a2007f, 0x00000000}},  //   _sece_, _sümb, irov,
  { {0x28d1007d, 0xed8b003b, 0x6579009d, 0x00000000}},  //   _दैनि, исак_, _éché,
  { {0xdb1c010f, 0x31350f62, 0x00000000, 0x00000000}},  //   _darü, _нейр,   ,
  { {0x2d8b037e, 0x31690010, 0x69c6000c, 0x00000000}},  // [2650] _vece_, _igaz_, _ókey,
  { {0x9f58009f, 0x78a20142, 0x26de0197, 0x00000000}},  //   skrá_, drov, _orto_,
  { {0x81ce0055, 0x3f910107, 0xa91d0059, 0x00000000}},  //   রার_, mazu_, _težk,
  { {0x3f910091, 0x2a64008a, 0xdb1c004a, 0x00000000}},  //   lazu_, _cimb_, _aaró,
  { {0x78a20387, 0xdb150181, 0xe9d8007e, 0x00000000}},  //   grov, _razõ, ўкі_,
  { {0xf7710137, 0xa91d0142, 0x3f91016c, 0x00000000}},  //   رات_, _ježi, nazu_,
  { {0x1ab4081e, 0xf4200044, 0x26de0087, 0x00000000}},  //   _обря, নকার_, _crto_,
  { {0x78a2049c, 0xa91d1470, 0xc4850256, 0x00000000}},  //   brov, _leži, плик,
  { {0xdb1c1471, 0x26de0026, 0x7bd504eb, 0x00000000}},  //   _abrè, _erto_, _kazu,
  { {0xa91d1472, 0xb68600a1, 0xf1bf0010, 0x00000000}},  //   _neži, _کھول_, snál_,
  { {0x7bd50ba3, 0x3f91002d, 0x442e1473, 0x00000000}},  //   _mazu, dazu_, _djf_,
  { {0x7bd500ca, 0xdb1c0036, 0x06c30044, 0x00000000}},  //   _lazu, _zaró, ্মদি,
  { {0xad9b0051, 0x442e0087, 0x386d004a, 0x00000000}},  //   _glúi, _fjf_, _juer_,
  { {0xdb1c0173, 0x31690288, 0x25ad010e, 0x00000000}},  //   _marò, _egaz_, lgel_,
  { {0x25ad0016, 0x6d4f004a, 0x25e00061, 0x00000000}},  //   ogel_, _azca, काची_,
  { {0x386d0007, 0x3f91012d, 0xe9ff0082, 0x00000000}},  //   _ouer_, aazu_, _thẹn_,
  { {0x7bd51474, 0xed5700ed, 0x00000000, 0x00000000}},  // [2660] _bazu, зот_,   ,
  { {0x7bd5000d, 0x91a800a1, 0x799b0085, 0x00000000}},  //   _cazu, _انکے_, _aduw,
  { {0x7bd501a2, 0x6d4f004a, 0x00000000, 0x00000000}},  //   _dazu, _ezca,   ,
  { {0x78a20027, 0x38c800a6, 0x6abb016c, 0x00000000}},  //   trov, قاتی_, _ćuft,
  { {0x2d921475, 0xdb1c090b, 0x79820036, 0x00000000}},  //   maye_, _paró, rbow,
  { {0x25ad010f, 0x2fca0a26, 0x7bd50035, 0x00000000}},  //   egel_, nebg_, _gazu,
  { {0x78a2012b, 0xdb1c008e, 0x386d01a2, 0x00000000}},  //   srov, _varó, _euer_,
  { {0x78a20038, 0x25ad0010, 0x2d921476, 0x00000000}},  //   prov, ggel_, naye_,
  { {0xb4d60164, 0x98a3007c, 0x7bd500e7, 0x00000000}},  //   ाटे_, _пите, _yazu,
  { {0xd7760025, 0x2d921477, 0xb8650025, 0x00000000}},  //   _رائع, haye_, _قالو,
  { {0x600b005f, 0x056606e1, 0x2d92055b, 0x00000000}},  //   _nüma, _евен, kaye_,
  { {0x7c3e0253, 0x442e0045, 0xa91d00ca, 0x00000000}},  //   hopr, _wjf_, _seži,
  { {0x2d92000b, 0x7c3e0c8a, 0x463b0049, 0x00000000}},  //   daye_, kopr, _פעדע,
  { {0x54530088, 0x644f0666, 0xa3e30316, 0x00000000}},  //   _звіт, ïcit, _पोप_,
  { {0x645a0fde, 0x7bd50295, 0x3f910387, 0x00000000}},  //   mmti, _razu, razu_,
  { {0x443e006a, 0x2d920061, 0x6d460007, 0x00000000}},  //   lot_, gaye_, _byka,
  { {0x423801f8, 0x7bd51478, 0x443e0007, 0x00000000}},  // [2670] _מנהל_, _pazu, oot_,
  { {0x443e001e, 0xf092019b, 0x442c000c, 0x00000000}},  //   not_, _שני_, nnd_,
  { {0x2d92000b, 0x644801e5, 0x7bd5001a, 0x00000000}},  //   baye_, ildi, _vazu,
  { {0x7bd50020, 0x2d920009, 0xa2a4006e, 0x00000000}},  //   _wazu, caye_, _किन्,
  { {0xddc4038c, 0x443e006a, 0x89370054, 0x00000000}},  //   lmiş, kot_, أعضا,
  { {0xd3660b59, 0x443e001e, 0x7c3e0197, 0x00000000}},  //   _له_, jot_, copr,
  { {0x443e1479, 0x6e2d05f0, 0xddc4005a, 0x00000000}},  //   dot_, onab, nmiş,
  { {0x442c05d0, 0x644800c7, 0x386d009d, 0x00000000}},  //   end_, eldi, _tuer_,
  { {0x442c009f, 0x62980207, 0x69cb147a, 0x00000000}},  //   fnd_, _avvo, mege,
  { {0x443e147b, 0x69cb03a1, 0x442c0009, 0x00000000}},  //   got_, lege, gnd_,
  { {0x81d70055, 0xdb1c000c, 0xd1ca007c, 0x00000000}},  //   সান_, _jarð, олне_,
  { {0x6448022b, 0x69d9147c, 0x442c01b5, 0x00000000}},  //   aldi, ndwe, and_,
  { {0x20040181, 0x6e2d0016, 0x628a01f3, 0x00000000}},  //   êmio_, dnab, _ewfo,
  { {0x443e0687, 0x2d920263, 0x81ce0044, 0x00000000}},  //   cot_, waye_, রাই_,
  { {0x2d92147d, 0x7f43007c, 0x7c3e09fc, 0x00000000}},  //   taye_, верж, vopr,
  { {0x6281147e, 0x6e2d000c, 0x7649014a, 0x00000000}},  //   mplo, gnab, nley,
  { {0x7c3e0263, 0x2d920173, 0x60c400e7, 0x00000000}},  // [2680] topr, raye_, _upim,
  { {0x2d92147f, 0x69d901c3, 0x7649049d, 0x00000000}},  //   saye_, edwe, hley,
  { {0x600b006c, 0x7649014a, 0x62810173, 0x00000000}},  //   _kümn, kley, nplo,
  { {0x6b8e022b, 0x69cb05c6, 0x443e0089, 0x00000000}},  //   _webg, gege, zot_,
  { {0x442c009f, 0x443e0058, 0x69c00061, 0x00000000}},  //   ynd_, yot_, _vbme,
  { {0x69d901d6, 0x443e1480, 0x656b0026, 0x00000000}},  //   adwe, xot_, _aggh,
  { {0x443e004f, 0x69cb054e, 0xdb1c000c, 0x00000000}},  //   vot_, bege, _garð,
  { {0xd49a00d7, 0xceb300b6, 0x442c10a5, 0x00000000}},  //   оро_, דיה_, wnd_,
  { {0x443e1481, 0x7d040093, 0x64a300ed, 0x00000000}},  //   tot_, nyis, вања,
  { {0x442c1482, 0x9f5a0023, 0xb05b01a2, 0x00000000}},  //   und_, _copë_, hwär,
  { {0x443e001e, 0x442c00db, 0xe57a008b, 0x00000000}},  //   rot_, rnd_, _дзе_,
  { {0x443e0089, 0x7d0400b0, 0x84ea01d8, 0x00000000}},  //   sot_, kyis, _وفاق_,
  { {0x443e1483, 0x92be0044, 0xdb1e0961, 0x00000000}},  //   pot_, ঁটে_, lepä,
  { {0xa29401ff, 0xdb1e0181, 0xddc4005d, 0x00000000}},  //   _закі, cepç, tmiş,
  { {0x81d70044, 0x69d90016, 0xb05b01a2, 0x00000000}},  //   সাব_, ydwe, fwär,
  { {0xddc4038c, 0x76400319, 0xc333009b, 0x00000000}},  //   rmiş, nomy, _שוק_,
  { {0x6e2d000c, 0x69cb1484, 0xdc5501fc, 0x00000000}},  // [2690] rnab, vege, евањ,
  { {0x69cb07eb, 0x9f89000c, 0x6e2d00f8, 0x00000000}},  //   wege, _góðu_, snab,
  { {0x76400006, 0x7649014a, 0xe0df0026, 0x00000000}},  //   komy, yley, lvò_,
  { {0xdb1c009f, 0x76400036, 0xdddd0036, 0x00000000}},  //   _varð, jomy, _wisł,
  { {0x69cb0599, 0x7d160036, 0x999600a1, 0x00000000}},  //   rege, czys, رپور_,
  { {0x69cb0059, 0x78ab00c7, 0xd76300a1, 0x00000000}},  //   sege, rugv, نچای,
  { {0x76491402, 0x69cb0030, 0x628100b4, 0x00000000}},  //   tley, pege, xplo,
  { {0xb8d50055, 0x00000000, 0x00000000, 0x00000000}},  //   _জন_,   ,   ,
  { {0x3e750039, 0xe7e00164, 0x764903fb, 0x00000000}},  //   _låt_, _गोवा_, rley,
  { {0x764906b5, 0x62810116, 0x00000000, 0x00000000}},  //   sley, tplo,   ,
  { {0x3e750039, 0x7649011c, 0xc7d6009b, 0x00000000}},  //   _nåt_, pley, _רועי_,
  { {0x6281088d, 0x76400912, 0x31790009, 0x00000000}},  //   rplo, comy, gcsz_,
  { {0x62810209, 0x00000000, 0x00000000, 0x00000000}},  //   splo,   ,   ,
  { {0x25bf0951, 0x3e7500d8, 0x660905b7, 0x00000000}},  //   lful_, _båt_, lkek,
  { {0x64410091, 0x6e241485, 0x8464005e, 0x00000000}},  //   moli, tiib, _ръце,
  { {0xee3a01fb, 0x7d04021e, 0xa2a40204, 0x00000000}},  //   їна_, tyis, _कित्,
  { {0xdca30216, 0x44251486, 0x25bf04be, 0x00000000}},  // [26a0] лати, oil_, iful_,
  { {0x7d160046, 0x64410016, 0x6e241487, 0x00000000}},  //   rzys, noli, siib,
  { {0xa3b70204, 0x387f1488, 0xad9b0d62, 0x00000000}},  //   _छान_, _atur_, _clús,
  { {0x6441018e, 0x44250811, 0x7d041489, 0x00000000}},  //   holi, hil_, pyis,
  { {0x6441091e, 0x25bf0016, 0x4973007e, 0x00000000}},  //   koli, dful_, уліс,
  { {0x442501a3, 0xf093009b, 0x6441073a, 0x00000000}},  //   jil_, ננו_, joli,
  { {0x6441148a, 0x442507ac, 0x7640013e, 0x00000000}},  //   doli, dil_, tomy,
  { {0xdb1e006c, 0xd90d00a1, 0xcb67007e, 0x00000000}},  //   repä, _ڈیم_, _часе_,
  { {0xddde001e, 0xdb1e01b1, 0x764005ac, 0x00000000}},  //   _atpū, sepä, romy,
  { {0x6441018e, 0x442503b0, 0x600b0279, 0x00000000}},  //   goli, gil_, _cüml,
  { {0x60d60133, 0xdb1c00f6, 0xb05b01a2, 0x00000000}},  //   _asym, _obrí, ltäg,
  { {0x44250051, 0x6609148b, 0xad9b00f6, 0x00000000}},  //   ail_, ckek, _llúr,
  { {0x6441148c, 0xb5fb0104, 0xc05b0088, 0x00000000}},  //   boli, _מלאכ, зів_,
  { {0x20d60107, 0x64410207, 0x31790061, 0x00000000}},  //   džić_, coli, scsz_,
  { {0xdd95007e, 0x80c40044, 0x00000000, 0x00000000}},  //   кавы, শিষ্,   ,
  { {0x931200a1, 0x3e7502e1, 0x629a148d, 0x00000000}},  //   _لوڈش, _våt_, msto,
  { {0x629a001e, 0x61ed148e, 0xd2f8026c, 0x00000000}},  // [26b0] lsto, _inal, _رکھا_,
  { {0x600b0eaa, 0x629a0052, 0x00000000, 0x00000000}},  //   _kümm, osto,   ,
  { {0xd011026c, 0x61ed0030, 0x76aa006b, 0x00000000}},  //   _ملک_, _knal, _təyy,
  { {0x6441148f, 0x629a00b0, 0xdbd7003c, 0x00000000}},  //   zoli, isto, _sääs,
  { {0xdbd70368, 0x442506db, 0xfd9601f8, 0x00000000}},  //   _pääs, yil_, _בדרך_,
  { {0x629a0ade, 0x4425005f, 0x2ca900f8, 0x00000000}},  //   ksto, xil_, mrad_,
  { {0x4425060b, 0x629a0091, 0xe7e00061, 0x00000000}},  //   vil_, jsto, _गोळा_,
  { {0x44250016, 0x64411490, 0x78a4016e, 0x00000000}},  //   wil_, woli, šiva,
  { {0x629a0027, 0x25bf00ab, 0x66090145, 0x00000000}},  //   esto, rful_, rkek,
  { {0x69db022b, 0x629a000c, 0x2b9c00b9, 0x00000000}},  //   _haue, fsto, mácí_,
  { {0x629a127f, 0x69db1491, 0x38bb01d6, 0x00000000}},  //   gsto, _kaue, lêr_,
  { {0x44251492, 0x412a02d3, 0xe5e500a2, 0x00000000}},  //   sil_, домо_, _جزئی,
  { {0x44250607, 0x66060047, 0x69db010f, 0x00000000}},  //   pil_, ökke, _maue,
  { {0x2ca91493, 0x629a01a2, 0x69db0e42, 0x00000000}},  //   drad_, bsto, _laue,
  { {0xa067132e, 0x629a1494, 0x7db60131, 0x00000000}},  //   тара_, csto, ксац,
  { {0x6458008d, 0x3ea51430, 0xf1bf008e, 0x00000000}},  //   _zhvi, álta_, lián_,
  { {0x2ca9012b, 0x8e5501fb, 0xdd8f01d8, 0x00000000}},  // [26c0] grad_, утрі, زول_,
  { {0x61ed091e, 0x81ce0044, 0x62860107, 0x00000000}},  //   _znal, রাও_, ćkov,
  { {0x69db010f, 0x3f9801ed, 0x93bc0035, 0x00000000}},  //   _baue, maru_, onăr,
  { {0x2ca9006c, 0xa2a4006e, 0x69db0f57, 0x00000000}},  //   brad_, _किस्, _caue,
  { {0x69db0fa5, 0xa967017f, 0x629a0087, 0x00000000}},  //   _daue, вица_, zsto,
  { {0xbcfb0047, 0x629a0036, 0x81ce0044, 0x00000000}},  //   _egés, ysto, রাট_,
  { {0x48ee03d7, 0x59dd0061, 0x629a1495, 0x00000000}},  //   _आपको_, _नोकर, xsto,
  { {0x7bdc0149, 0xe5c60679, 0x76591496, 0x00000000}},  //   _haru, тско, _chwy,
  { {0x26030219, 0x3f980089, 0x7bdc1497, 0x00000000}},  //   _años_, karu_, _karu,
  { {0x7bde00c7, 0x629a05c6, 0x7bdc1498, 0x00000000}},  //   ndpu, tsto, _jaru,
  { {0x7bdc1499, 0x81dc0055, 0x629a00b0, 0x00000000}},  //   _maru, ঠান_, usto,
  { {0x7bdc149a, 0x3f93149b, 0xe8df0082, 0x00000000}},  //   _laru, _sexu_, _uyển_,
  { {0x629a0056, 0x3f9804c0, 0xf1bf149c, 0x00000000}},  //   ssto, faru_, bián_,
  { {0x7bdc149d, 0x629a0056, 0x4394005e, 0x00000000}},  //   _naru, psto, _сакс,
  { {0x5f940594, 0x81ce0044, 0xc43400a1, 0x00000000}},  //   рист, রাজ_, _لکھت,
  { {0x2ca908c9, 0x61ed016a, 0x7bdc149e, 0x00000000}},  //   trad_, _unal, _aaru,
  { {0x68e2003b, 0x7bdc00f0, 0x3f980142, 0x00000000}},  // [26d0] jvod, _baru, baru_,
  { {0x600b038c, 0x7bdc001a, 0x2ca9010f, 0x00000000}},  //   _mümk, _caru, rrad_,
  { {0xba740379, 0x69db0032, 0x68e20035, 0x00000000}},  //   لانت, _paue, evod,
  { {0xc33300b6, 0xb05b0a5d, 0x60100039, 0x00000000}},  //   בוע_, städ, _jämn,
  { {0x7659018e, 0x80d9013d, 0x7bdc149f, 0x00000000}},  //   _rhwy, मिटे, _faru,
  { {0x60100073, 0x7bdc1108, 0x386c0022, 0x00000000}},  //   _lämn, _garu, _cidr_,
  { {0xaa670780, 0x8cdb006e, 0x76590016, 0x00000000}},  //   _атак, निको, _phwy,
  { {0x7bdc04c8, 0x3f9814a0, 0x60100039, 0x00000000}},  //   _zaru, zaru_, _nämn,
  { {0x29190039, 0x7bdc00e7, 0x2459009d, 0x00000000}},  //   _åsa_, _yaru, hème_,
  { {0x87d70879, 0x23d50478, 0x6b9514a1, 0x00000000}},  //   _جغرا, уцир, _jezg,
  { {0x3f980027, 0x6b95008f, 0xf1bf0142, 0x00000000}},  //   varu_, _mezg, rián_,
  { {0x3f9814a2, 0x79990085, 0x394d0173, 0x00000000}},  //   waru_, naww, _kyes_,
  { {0x3f98016e, 0x00000000, 0x00000000, 0x00000000}},  //   taru_,   ,   ,
  { {0x70560426, 0x6b950825, 0x2a6d01a2, 0x00000000}},  //   انسا, _nezg, _lieb_,
  { {0xdb1c0428, 0x68e204c8, 0x6da6041f, 0x00000000}},  //   _obrá, zvod, лива,
  { {0x7bdc001e, 0x3f9801c5, 0x2bc6013d, 0x00000000}},  //   _saru, saru_, र्ना,
  { {0x3f980089, 0x6b950ad8, 0x229800b9, 0x00000000}},  // [26e0] paru_, _bezg, _týká_,
  { {0xb05b00b0, 0xd0f7009b, 0xdb1c10c9, 0x00000000}},  //   ttäe, _עמית_, _abrá,
  { {0x7bdc0ac2, 0x81d70055, 0x2a6d002b, 0x00000000}},  //   _varu, সার_, _bieb_,
  { {0x7bdc0a70, 0xe947025a, 0x02b60049, 0x00000000}},  //   _waru, گرمی, טלעך_,
  { {0xa3b301f5, 0x7bdc04cb, 0x69c2018d, 0x00000000}},  //   टला_, _taru, rfoe,
  { {0xd6da017f, 0xa2a40164, 0x600b006b, 0x00000000}},  //   ети_, _किल्, _cümh,
  { {0x394d00ab, 0xfd500082, 0x68e2013e, 0x00000000}},  //   _eyes_, _nghẹ, svod,
  { {0xa5bd0006, 0x00000000, 0x00000000, 0x00000000}},  //   liųj,   ,   ,
  { {0x27ef0224, 0x20180022, 0x9916007e, 0x00000000}},  //   ální_, khri_, _сьві,
  { {0x1cbb0049, 0xd5a4009e, 0x77920241, 0x00000000}},  //   עמיע, _چلای, _ایثا,
  { {0x2bc602f4, 0xe9ff0011, 0x2bf70104, 0x00000000}},  //   र्या, _chặn_, אמין_,
  { {0x54e6004b, 0xdb0501a2, 0xf1bf0062, 0x00000000}},  //   _مستق, pfhö, ciál_,
  { {0x62830056, 0x75d30379, 0x00000000, 0x00000000}},  //   _etno, _دينا,   ,
  { {0x2bc602fb, 0xc5bc0044, 0xddd00340, 0x00000000}},  //   र्मा, _অফটপ, _češk,
  { {0xe1ff0010, 0x00000000, 0x00000000, 0x00000000}},  //   tmód_,   ,   ,
  { {0x66020004, 0xfc240055, 0x62880a7e, 0x00000000}},  //   _jook, বকোষ_, mpdo,
  { {0x82340167, 0x2001006c, 0x2a6d14a3, 0x00000000}},  // [26f0] _دروا, _tohi_, _rieb_,
  { {0x66020038, 0x6fb2013d, 0x60cd011c, 0x00000000}},  //   _look, _जाएं, _ipam,
  { {0xdddc11af, 0xf09f00f6, 0x00000000, 0x00000000}},  //   sprš, lsà_,   ,
  { {0x394d14a4, 0x5efa00a0, 0xfde9007d, 0x00000000}},  //   _pyes_, _ספרד, _ऑफिस_,
  { {0x0ff800a1, 0x7c840140, 0x6b950823, 0x00000000}},  //   _شعیب_, _гусе, _tezg,
  { {0x601003a9, 0x60cd14a5, 0x79990145, 0x00000000}},  //   _näml, _mpam, saww,
  { {0x66020038, 0xe5710025, 0x4ac90061, 0x00000000}},  //   _book, يطة_, _रहिव,
  { {0x660201a6, 0x7aea0030, 0x1b1e0044, 0x00000000}},  //   _cook, æfte, _বুকে_,
  { {0xf1bf0161, 0xc7d9005e, 0x660214a6, 0x00000000}},  //   riál_, _имах_, _dook,
  { {0x291d00e7, 0x4ac90061, 0xe4c80025, 0x00000000}},  //   mzwa_, _रहाव, ابين_,
  { {0xfbd200b6, 0x60cd0085, 0x2d9b0023, 0x00000000}},  //   חתי_, _apam, kaqe_,
  { {0x01660ae0, 0xb34500f6, 0x998f0006, 0x00000000}},  //   икно, _alçà, mogų_,
  { {0xe0d70265, 0x2bc60061, 0x291d00e7, 0x00000000}},  //   авя_, र्डा, nzwa_,
  { {0x249f0022, 0x660204a5, 0x6e260145, 0x00000000}},  //   msum_, _zook, _smkb,
  { {0x44d60046, 0x69c900d4, 0x92f601fa, 0x00000000}},  //   _zł_, _obee, _نفوذ_,
  { {0x409601ee, 0x442700e0, 0x68e90203, 0x00000000}},  //   _крот, _hmn_, _ored,
  { {0x249f0a16, 0x8fa6003b, 0x6010044e, 0x00000000}},  // [2700] nsum_, _капе, _hämm,
  { {0x81d70044, 0x69c904e6, 0x601014a7, 0x00000000}},  //   সাঃ_, _abee, _kämm,
  { {0xdef9008b, 0xf77801d5, 0x68e90544, 0x00000000}},  //   _быў_, _naħa_, _ared,
  { {0x68e90239, 0xda650025, 0xb05b0039, 0x00000000}},  //   _bred, ماني, ptäc,
  { {0x601000b0, 0x3e7c0082, 0x7e64010e, 0x00000000}},  //   _lämm, _hít_, mmip,
  { {0xb8ce02d2, 0x68e914a8, 0x4427011c, 0x00000000}},  //   _कि_, _dred, _nmn_,
  { {0x68e914a9, 0xfaa3007e, 0x8f9b0049, 0x00000000}},  //   _ered, _маро, דיצי,
  { {0x68e904d7, 0x2d8014aa, 0x3e7c0224, 0x00000000}},  //   _fred, ncie_, _mít_,
  { {0x3e7c14ab, 0x2bc60061, 0x2ca014ac, 0x00000000}},  //   _lít_, र्था, nsid_,
  { {0xe3b8027d, 0x442714ad, 0x2a78006c, 0x00000000}},  //   lnız_, _cmn_, _kurb_,
  { {0x2d8014ae, 0x44270022, 0x68e90d0a, 0x00000000}},  //   kcie_, _dmn_, _zred,
  { {0x2ca00004, 0x2d800036, 0x2bc6007d, 0x00000000}},  //   ksid_, jcie_, र्ता,
  { {0x25a60c3b, 0x44270023, 0x601000f8, 0x00000000}},  //   _idol_, _fmn_, _täml,
  { {0x2d800036, 0x44270093, 0x3e7c0011, 0x00000000}},  //   ecie_, _gmn_, _bít_,
  { {0xf09f04b9, 0x442c14af, 0x6d4f0675, 0x00000000}},  //   ssà_, mid_, _syca,
  { {0x442c0004, 0xef190036, 0x1317009b, 0x00000000}},  //   lid_, ąż_, _כחול_,
  { {0x442c00bb, 0x60cd0a0f, 0x44270022, 0x00000000}},  // [2710] oid_, _upam, _ymn_,
  { {0x442c0b83, 0x6448046a, 0x1fa70478, 0x00000000}},  //   nid_, nodi, _триг,
  { {0x68e90bf8, 0x2bc6007d, 0x25a6002d, 0x00000000}},  //   _sred, र्धा, _odol_,
  { {0x68e913a1, 0x442c005f, 0x64480161, 0x00000000}},  //   _pred, hid_, hodi,
  { {0x442c0b1a, 0x2ca014b0, 0xb9c40025, 0x00000000}},  //   kid_, csid_, تقني,
  { {0x6e2d14b1, 0x68e9037a, 0x442c0427, 0x00000000}},  //   liab, _vred, jid_,
  { {0x442c017b, 0x7d0d14b2, 0x2d9901ee, 0x00000000}},  //   did_, lyas, _kese_,
  { {0x68e901e2, 0xdb160051, 0x6e2d14b3, 0x00000000}},  //   _tred, _ócái, niab,
  { {0x68e91034, 0x7d0d047f, 0x2d990207, 0x00000000}},  //   _ured, nyas, _mese_,
  { {0x644810ec, 0x249f0270, 0x2d990292, 0x00000000}},  //   godi, rsum_, _lese_,
  { {0x249f14b4, 0x8c1a009b, 0x2d800036, 0x00000000}},  //   ssum_, רותי, ycie_,
  { {0x2d99008d, 0x442c14b5, 0x7d0d0173, 0x00000000}},  //   _nese_, aid_, kyas,
  { {0x442c006c, 0x644814b6, 0x44270145, 0x00000000}},  //   bid_, bodi, _tmn_,
  { {0x2d9906c2, 0x7d0d09e5, 0x3e7c14b7, 0x00000000}},  //   _aese_, dyas, _pít_,
  { {0x81bf0055, 0x2d9901aa, 0xddc60006, 0x00000000}},  //   ীয়_, _bese_, _aikš,
  { {0xf2d20049, 0x2ca0006c, 0xdb1700c4, 0x00000000}},  //   _זעה_, tsid_, nexõ,
  { {0x2d8014b8, 0x7d0d0010, 0x6e360006, 0x00000000}},  // [2720] rcie_, gyas, rnyb,
  { {0x2d800036, 0x2ca0006c, 0x3e7c0082, 0x00000000}},  //   scie_, rsid_, _tít_,
  { {0x2ca009e7, 0x2d990065, 0xd24f00a2, 0x00000000}},  //   ssid_, _fese_, _زنی_,
  { {0x6e2d0f6a, 0x2d990007, 0x753d0036, 0x00000000}},  //   ciab, _gese_, ższy,
  { {0xdb1e0010, 0x442c013f, 0x28f80194, 0x00000000}},  //   lepü, yid_, рель_,
  { {0xf093009b, 0x00000000, 0x00000000, 0x00000000}},  //   לנד_,   ,   ,
  { {0x64480340, 0x24860116, 0x07a3025f, 0x00000000}},  //   vodi, _stom_, чајн,
  { {0x442c018e, 0x3f9a05fa, 0xf1bf0010, 0x00000000}},  //   wid_, _lepu_, riák_,
  { {0x64480142, 0x38cb00a6, 0xa3b30061, 0x00000000}},  //   todi, _مالی_, टलं_,
  { {0x3e410006, 0x79820036, 0x00000000, 0x00000000}},  //   mėte_, lcow,   ,
  { {0x442c14b9, 0x644814ba, 0x95ca01fb, 0x00000000}},  //   rid_, rodi, _була_,
  { {0x442c061f, 0x26de14bb, 0x64480010, 0x00000000}},  //   sid_, _isto_, sodi,
  { {0x64480059, 0x6e2d00d6, 0x2d9914bc, 0x00000000}},  //   podi, viab, _rese_,
  { {0x442c0003, 0x3f9a04be, 0xddc6129d, 0x00000000}},  //   qid_, _cepu_, _rikš,
  { {0x533314bd, 0x877b01f8, 0x6e2d08a8, 0x00000000}},  //   _нешт, ראלי, tiab,
  { {0x7d0d14be, 0x00000000, 0x00000000, 0x00000000}},  //   tyas,   ,   ,
  { {0x2d9914bf, 0x78a2016c, 0x443c013f, 0x00000000}},  // [2730] _vese_, jsov, _kjv_,
  { {0x224b0030, 0x2d9914c0, 0x78a214c1, 0x00000000}},  //   lock_, _wese_, dsov,
  { {0x2d9900c4, 0x7d0d09e5, 0x6d410036, 0x00000000}},  //   _tese_, syas, _ślad,
  { {0x75200061, 0x224b0b3d, 0x13e10044, 0x00000000}},  //   kzmz, nock_, বায়,
  { {0x6e3d14c2, 0x7d0d006b, 0xc879006b, 0x00000000}},  //   _ijsb, qyas, _quş_,
  { {0x18690437, 0x6d5d0089, 0x224b14c3, 0x00000000}},  //   шали_, _izsa, hock_,
  { {0xb05b021e, 0xe3ae0044, 0x661b0258, 0x00000000}},  //   ytän, কভাব, thuk,
  { {0xc485012b, 0x0609005e, 0x34a9012b, 0x00000000}},  //   олик, рник_, авио_,
  { {0x26de0219, 0xe3b10076, 0x2bc6007d, 0x00000000}},  //   _esto_, ورد_, र्वा,
  { {0x661b000b, 0x799b01d6, 0x42c900e2, 0x00000000}},  //   shuk, _heuw, агон_,
  { {0xd7f80011, 0xb05b00b0, 0xe2990098, 0x00000000}},  //   _khăn_, ttän, јам_,
  { {0xb68600a1, 0xcf8900a0, 0x00000000, 0x00000000}},  //   _بھول_, _יט_,   ,
  { {0xb05b14c4, 0x799b00d9, 0x443c1408, 0x00000000}},  //   rtän, _meuw, _fjv_,
  { {0xb05b14c5, 0x799b0022, 0x248d14c6, 0x00000000}},  //   stän, _leuw, mpem_,
  { {0xdee30072, 0x7bd714c7, 0x3f6a05a5, 0x00000000}},  //   мори, dexu, риво_,
  { {0x799b010f, 0xe1ff008e, 0xd7f80082, 0x00000000}},  //   _neuw, lmón_, _nhăn_,
  { {0xad66007a, 0x3f9a0145, 0x00000000, 0x00000000}},  // [2740] زاره, _tepu_,   ,
  { {0x61e60bc7, 0x6b560a27, 0xb05b00b0, 0x00000000}},  //   ldkl, отех, ntäl,
  { {0x61e4006a, 0x41b3009e, 0xfe460ab6, 0x00000000}},  //   _kail, _عمیر, _мноо,
  { {0xd7f80011, 0x78a20e38, 0xdcfd0006, 0x00000000}},  //   _chăn_, tsov, _nesė,
  { {0x61e414c8, 0xe89409b5, 0xc7ba008b, 0x00000000}},  //   _mail, чаль, аёй_,
  { {0xacd9007b, 0x2cb2018e, 0x61e400b0, 0x00000000}},  //   _פֿרי, mryd_, _lail,
  { {0x78a20161, 0xa01b00b0, 0x26de0026, 0x00000000}},  //   ssov, mpöt, _qsto_,
  { {0x78ad0119, 0x6b9c14c9, 0x61e414ca, 0x00000000}},  //   šava, _herg, _nail,
  { {0x6b9c0004, 0x7aee0059, 0xdb07000a, 0x00000000}},  //   _kerg, _hrbt, _adjè,
  { {0x3eb80065, 0x2fd80030, 0xdb1c00c4, 0x00000000}},  //   kurt_, jerg_, _acré,
  { {0x61e4002a, 0x4b7b0049, 0x6b9c14cb, 0x00000000}},  //   _bail, יטיג, _merg,
  { {0x61e4002a, 0x201a0197, 0x6b9c0203, 0x00000000}},  //   _cail, _alpi_, _lerg,
  { {0x61e40273, 0x660f0a5d, 0x2d920133, 0x00000000}},  //   _dail, öcke, dbye_,
  { {0xcbd50055, 0x3eb8010f, 0x6b9c00b5, 0x00000000}},  //   _হচ্ছ, furt_, _nerg,
  { {0xdd9b0216, 0x93cb00a1, 0x69c00009, 0x00000000}},  //   иша_, _خانہ_, _ocme,
  { {0x3ead004f, 0x61e414cc, 0x7bce01d5, 0x00000000}},  //   čet_, _gail, _abbu,
  { {0x2fd806d3, 0x6b9c020c, 0xc05b01fb, 0x00000000}},  // [2750] berg_, _berg, _він_,
  { {0x61e4002d, 0x69c014cd, 0x3eb8010f, 0x00000000}},  //   _zail, _acme, burt_,
  { {0x6b9c14ce, 0x23c2006e, 0xb05b00b0, 0x00000000}},  //   _derg, _शानद, ntäm,
  { {0x6b9c0116, 0x2cb20016, 0x69c0000a, 0x00000000}},  //   _eerg, bryd_, _ccme,
  { {0x6b9c002b, 0x6d5d14cf, 0xd94500e2, 0x00000000}},  //   _ferg, _uzsa, џели,
  { {0x3abb007a, 0xa69500ec, 0x6b9c14d0, 0x00000000}},  //   _پاسخ_, приј, _gerg,
  { {0x09c20055, 0x199514d1, 0x290200f6, 0x00000000}},  //   োয়া, _навя, _àkan_,
  { {0x6b9c022b, 0xd6ce0379, 0x6b850016, 0x00000000}},  //   _zerg, اقي_, lchg,
  { {0x69d914d2, 0x6d43010f, 0x61e400ab, 0x00000000}},  //   mewe, ßnah, _rail,
  { {0x69d90007, 0x61e40238, 0x9422007c, 0x00000000}},  //   lewe, _sail, емье,
  { {0x81e50055, 0x61e40ffc, 0xef200036, 0x00000000}},  //   নান_, _pail, ążki_,
  { {0xb05b0073, 0x614600ed, 0x628a004a, 0x00000000}},  //   stäl, зема, _dtfo,
  { {0x61e40dd9, 0x61e614d3, 0xf992009b, 0x00000000}},  //   _vail, rdkl, ערך_,
  { {0xdff5007e, 0x27e50022, 0xe3b30014, 0x00000000}},  //   мясь, _jaln_, _آرش_,
  { {0x61e400f4, 0x69d900ea, 0x26c70f3a, 0x00000000}},  //   _tail, kewe, ntno_,
  { {0x69d9020f, 0x2cb20007, 0xbc760025, 0x00000000}},  //   jewe, tryd_, كهرب,
  { {0x69d900b5, 0xee370088, 0x721b009b, 0x00000000}},  // [2760] dewe, їну_, _לוקח,
  { {0x63a114d4, 0x26c714d5, 0xdce6001e, 0x00000000}},  //   naln, ktno_, _iekļ,
  { {0x6b9c14d6, 0xc986017a, 0x9f97009b, 0x00000000}},  //   _verg, пули, _מדיה_,
  { {0x69d90168, 0x63a100ca, 0x32090011, 0x00000000}},  //   gewe, haln, _xoay_,
  { {0x63a101d9, 0x6b9c0169, 0xc5c30044, 0x00000000}},  //   kaln, _terg, ্যাপ,
  { {0x63a10213, 0xfaa60088, 0x3a3f002f, 0x00000000}},  //   jaln, _наго, _ejup_,
  { {0x69d90c0c, 0x7c2e001a, 0x8c1b009b, 0x00000000}},  //   bewe, _imbr, _פולי,
  { {0x44f40764, 0xbb3b00b3, 0x09e301ee, 0x00000000}},  //   дпис, _העלי, _посн,
  { {0x81e50044, 0x3e41007f, 0x00000000, 0x00000000}},  //   নাম_, nėta_,   ,
  { {0xb05b021e, 0x2281000c, 0x00000000, 0x00000000}},  //   ttäm, _bók_,   ,
  { {0xe1d901fb, 0x316014d7, 0x7e7e05e0, 0x00000000}},  //   одні_, _aziz_, _nupp,
  { {0xe71700a0, 0x63a1006c, 0xa1940245, 0x00000000}},  //   _מחבר_, aaln, наюч,
  { {0xd6250025, 0xb05b14d8, 0x7c2e03e2, 0x00000000}},  //   _تعلي, stäm, _ombr,
  { {0x63a114d9, 0x3e41007f, 0x00000000, 0x00000000}},  //   caln, dėta_,   ,
  { {0x442e0010, 0x7e7e0190, 0x628a01c9, 0x00000000}},  //   _imf_, _cupp, _utfo,
  { {0x7e7e00ea, 0xc333009b, 0x433b009b, 0x00000000}},  //   _dupp, _רוק_, _לעוב,
  { {0x442e0697, 0xb05b0b6f, 0x69d90253, 0x00000000}},  // [2770] _kmf_, ntäk, vewe,
  { {0x31380097, 0x70550014, 0xf7780066, 0x00000000}},  //   _מנחם_, _زنجا, _daħk_,
  { {0xd7f8001d, 0x6b85010f, 0x69d90112, 0x00000000}},  //   _chăm_, rchg, tewe,
  { {0x63a114da, 0xf1bf14db, 0x7c2e14dc, 0x00000000}},  //   zaln, ngá_, _embr,
  { {0x37e500da, 0x7e7e0197, 0x69d90a6b, 0x00000000}},  //   долг, _zupp, rewe,
  { {0x69d90c4c, 0x442e04a5, 0x00000000, 0x00000000}},  //   sewe, _nmf_,   ,
  { {0x63a101d9, 0xb05b021e, 0x00000000, 0x00000000}},  //   valn, ttäj,   ,
  { {0x60100039, 0x26c70059, 0x442e00f8, 0x00000000}},  //   _hämt, rtno_, _amf_,
  { {0x26c701d9, 0xf2b60044, 0x93fd007e, 0x00000000}},  //   stno_, _জনগণ, аўнi,
  { {0x52a914dd, 0x60100039, 0x442e0145, 0x00000000}},  //   овом_, _jämt, _cmf_,
  { {0x63a114de, 0x2bcf0309, 0x387f01b5, 0x00000000}},  //   raln, स्या, _huur_,
  { {0x63a10169, 0x7e7e0109, 0x387f0cf0, 0x00000000}},  //   saln, _rupp, _kuur_,
  { {0x7e7e030a, 0x63a10aa9, 0xa5bd010a, 0x00000000}},  //   _supp, paln, siųs,
  { {0x2281009f, 0xa2d8013d, 0x387f00c7, 0x00000000}},  //   _tók_, _फैक्, _muur_,
  { {0x41c6013d, 0x00000000, 0x00000000, 0x00000000}},  //   _वापस,   ,   ,
  { {0x25bf048f, 0x00000000, 0x00000000, 0x00000000}},  //   ngul_,   ,   ,
  { {0xed5701f9, 0xdca30088, 0x387f06a4, 0x00000000}},  // [2780] дот_, кати, _nuur_,
  { {0x8d63007c, 0x7e7e006c, 0x4d630088, 0x00000000}},  //   твуе, _tupp, ткув,
  { {0x78a90198, 0x0e6614df, 0xb9e60088, 0x00000000}},  //   _avev, _окон, діли,
  { {0x81e50044, 0x8b650257, 0x387f14e0, 0x00000000}},  //   নাথ_, رالم, _buur_,
  { {0xd37805fa, 0x00000000, 0x00000000, 0x00000000}},  //   leće_,   ,   ,
  { {0xd7f8001d, 0x387f01b5, 0x368a0088, 0x00000000}},  //   _thăm_, _duur_, осин_,
  { {0xd378016c, 0x6a8300ed, 0x660b0190, 0x00000000}},  //   neće_, _алса, _bogk,
  { {0x973c0091, 0x25bf0169, 0xd5b000a1, 0x00000000}},  //   _neće, ggul_, اہش_,
  { {0xe3ce001d, 0x47c6012b, 0x442e00f6, 0x00000000}},  //   _dựng_, _обав, _pmf_,
  { {0x7c3e0145, 0x7e660022, 0x4ad20061, 0x00000000}},  //   nnpr, _lhkp, _सहाव,
  { {0x0bb700b6, 0xd3780166, 0xe2f80088, 0x00000000}},  //   ולים_, jeće_, чені_,
  { {0xd3780091, 0x442e0e42, 0x00000000, 0x00000000}},  //   deće_, _wmf_,   ,
  { {0x442e00d9, 0x00000000, 0x00000000, 0x00000000}},  //   _tmf_,   ,   ,
  { {0xdb1c1343, 0x8ca2013d, 0x442e14e1, 0x00000000}},  //   _acrí, गठनो, _umf_,
  { {0x443e02e1, 0x7687014a, 0xadd5003b, 0x00000000}},  //   mnt_, _kıya, новљ,
  { {0x645a018e, 0xf1d0001d, 0x6010010f, 0x00000000}},  //   llti, _hạng_, _sämt,
  { {0x2d5807ca, 0x443e0e94, 0xf4bc0044, 0x00000000}},  // [2790] дить_, ont_, _অনুব,
  { {0x443e14e2, 0x7c3e0146, 0x2bbb0025, 0x00000000}},  //   nnt_, gnpr, تارة_,
  { {0x443e016d, 0xf1d0001d, 0x387f14e3, 0x00000000}},  //   int_, _mạng_, _suur_,
  { {0x443e010f, 0xdb1c0051, 0x32190007, 0x00000000}},  //   hnt_, _gcrí, nksy_,
  { {0x7e6d00f8, 0x645a012d, 0x625d0068, 0x00000000}},  //   mmap, klti, véol,
  { {0xb90702d2, 0x81d30055, 0x7e6d006c, 0x00000000}},  //   _बन_, _হোম_, lmap,
  { {0x7ac40216, 0x973c012d, 0x443e0133, 0x00000000}},  //   _исте, _odću, dnt_,
  { {0x443e028c, 0xceb4061e, 0xb05b14e4, 0x00000000}},  //   ent_, דיק_, stäh,
  { {0x2bcf02f4, 0x79c805f3, 0x443e000c, 0x00000000}},  //   स्था, _توقف_, fnt_,
  { {0x6932026c, 0x7305025f, 0x443e092e, 0x00000000}},  //   _حکمر, епоз, gnt_,
  { {0xf1d0001d, 0x65620032, 0x00000000, 0x00000000}},  //   _dạng_, _ezoh,   ,
  { {0x443e018e, 0x2bcf02fb, 0x645a0dd7, 0x00000000}},  //   ant_, स्ता, alti,
  { {0xa1550265, 0x973c0166, 0x7e6d0085, 0x00000000}},  //   върш, _veće, dmap,
  { {0xdb1c002a, 0x443e14e5, 0x6606000c, 0x00000000}},  //   _scrí, cnt_, ökkv,
  { {0xd3780107, 0x60100039, 0x6d59002b, 0x00000000}},  //   teće_, _säms, żwal,
  { {0x201814e6, 0x7e6d00e0, 0x7c3e14e7, 0x00000000}},  //   skri_, gmap, wnpr,
  { {0xfe430500, 0xc7a500a1, 0x1016007e, 0x00000000}},  // [27a0] унто, _پڑ_, _зьня,
  { {0xaf9a007c, 0x00000000, 0x00000000, 0x00000000}},  //   _этих_,   ,   ,
  { {0x3f9814e8, 0x2bc601f5, 0xe80300e8, 0x00000000}},  //   mbru_, र्गा, लाना_,
  { {0x2d96081e, 0xda650025, 0x0f370049, 0x00000000}},  //   _ярос, ناني, _טריט_,
  { {0x443e14e9, 0x3f98012d, 0x00000000, 0x00000000}},  //   ynt_, obru_,   ,
  { {0xb05b021e, 0x7d160052, 0x00000000, 0x00000000}},  //   ttäi, myys,   ,
  { {0x8c430805, 0xd6d70a78, 0x765b008e, 0x00000000}},  //   _сере, еты_, fluy,
  { {0xcfe90044, 0x7bde14ea, 0x443e14eb, 0x00000000}},  //   খায়_, lepu, wnt_,
  { {0x29020065, 0x684600ed, 0xdb1c00c4, 0x00000000}},  //   _çka_, _знаа, _ucrâ,
  { {0xe8d700b6, 0x443e00ab, 0x69c2040f, 0x00000000}},  //   _אומר_, unt_, lgoe,
  { {0xa1950147, 0x443e03a1, 0x68e2005b, 0x00000000}},  //   канч, rnt_, lwod,
  { {0x765b0211, 0x69c2002d, 0x3eb80009, 0x00000000}},  //   cluy, ngoe, drrt_,
  { {0x6e240020, 0x7bde0065, 0xf1d00082, 0x00000000}},  //   dhib, kepu, _tạng_,
  { {0xb05b021e, 0x60100039, 0x251b0049, 0x00000000}},  //   htäv, _sämr, _צוגא,
  { {0x7e6d0062, 0x2cab0052, 0x00000000, 0x00000000}},  //   tmap, _svcd_,   ,
  { {0x09d50044, 0x2ca90614, 0xddc4013f, 0x00000000}},  //   _সোনা, tsad_, rliş,
  { {0xd90401ef, 0xdb1c0036, 0x2ca900e0, 0x00000000}},  // [27b0] _ای_, _obró, usad_,
  { {0x7bde0240, 0x7e6d0c7a, 0x2bd8013d, 0x00000000}},  //   gepu, smap, ड़गा,
  { {0x2ca90039, 0xa3d20164, 0x1eab006d, 0x00000000}},  //   ssad_, ह्य_, _عادي_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x601005b4, 0x9f5a0173, 0x2604006e, 0x00000000}},  //   _kämp, _anpè_, वानी_,
  { {0xec35007b, 0x7bde000d, 0x69c20032, 0x00000000}},  //   _יאָר_, cepu, agoe,
  { {0xf4c20055, 0x765b014a, 0x99850025, 0x00000000}},  //   ্টোব, tluy, _للزو,
  { {0x60100bf4, 0x644711cc, 0x00000000, 0x00000000}},  //   _lämp, čjim,   ,
  { {0xe1ff0036, 0x00000000, 0x00000000, 0x00000000}},  //   lmów_,   ,   ,
  { {0xa93400ed, 0x6e2400ca, 0x24960014, 0x00000000}},  //   _сеуш, zhib, کنید_,
  { {0x232914ec, 0x2bc60204, 0x00000000, 0x00000000}},  //   фони_, र्टा,   ,
  { {0x65950175, 0x7aea0030, 0x7bde0036, 0x00000000}},  //   _раду, æfti, zepu,
  { {0xc2431280, 0xbcfb0010, 0x00000000, 0x00000000}},  //   рняк, _szén,   ,
  { {0x66091382, 0xd2b9009e, 0x00000000, 0x00000000}},  //   ljek, _قابض_,   ,
  { {0x60100210, 0x6e240020, 0x8fa3007e, 0x00000000}},  //   _dämp, thib, расе,
  { {0x63a305ce, 0x68e2018e, 0x7bd5010f, 0x00000000}},  //   _henn, ywod, _abzu,
  { {0x644114ed, 0x6026008b, 0x7af5010f, 0x00000000}},  // [27c0] onli, _адпа, _arzt,
  { {0x6e2414ee, 0x644114ef, 0xd3780107, 0x00000000}},  //   shib, nnli, leća_,
  { {0x81e508b7, 0xb05b021e, 0x7bde002d, 0x00000000}},  //   নার_, ttäv, repu,
  { {0x63a30f39, 0x6441010f, 0x7bde14f0, 0x00000000}},  //   _lenn, hnli, sepu,
  { {0xe3a704e1, 0x69c200b5, 0x62830058, 0x00000000}},  //   _پر_, rgoe, _luno,
  { {0x63a300db, 0x644100b5, 0xb05b0c4d, 0x00000000}},  //   _nenn, jnli, stäv,
  { {0x2900000d, 0xc5eb0055, 0x628314f1, 0x00000000}},  //   ţia_, কানা_, _nuno,
  { {0xd3780182, 0x644101b5, 0x661b011c, 0x00000000}},  //   jeća_, enli, gkuk,
  { {0x63a314f2, 0xd378037e, 0x70dc0061, 0x00000000}},  //   _benn, deća_, यबोल,
  { {0x63a30027, 0x62830058, 0xb05b14f3, 0x00000000}},  //   _cenn, _buno, ntät,
  { {0x63a305d5, 0x6283000d, 0xddc40059, 0x00000000}},  //   _denn, _cuno, zmiš,
  { {0x27ec0133, 0x644114f4, 0x00000000, 0x00000000}},  //   _hadn_, anli,   ,
  { {0xc05b01fb, 0x63a30047, 0x81e50044, 0x00000000}},  //   дів_, _fenn, নাল_,
  { {0x63a314f5, 0x4425090d, 0xe44f0123, 0x00000000}},  //   _genn, chl_, _وضو_,
  { {0x64580089, 0x80d60044, 0x6283001a, 0x00000000}},  //   _ikvi, দিষ্, _guno,
  { {0x63a80161, 0x337700b6, 0x63a314f6, 0x00000000}},  //   ladn, _בתוך_, _zenn,
  { {0x63a30283, 0xde580088, 0x61ed0058, 0x00000000}},  // [27d0] _yenn, таті_, _iaal,
  { {0x63a80a14, 0x61ed0157, 0x06d90044, 0x00000000}},  //   nadn, _haal, থিতি,
  { {0x61ed14f7, 0xfe6e02fd, 0xddc414f8, 0x00000000}},  //   _kaal, تگی_, smiš,
  { {0xc333009b, 0xf9890014, 0x61ef14f9, 0x00000000}},  //   סוף_, رنتي_, ndcl,
  { {0x61ed0b37, 0x394902d5, 0x645801ae, 0x00000000}},  //   _maal, ças_, _okvi,
  { {0xd378037e, 0x973c01a8, 0xab9401fb, 0x00000000}},  //   zeća_, _seća, _вирі,
  { {0x63a314fa, 0x973c0521, 0x644114fb, 0x00000000}},  //   _renn, _peća, vnli,
  { {0x63a3000c, 0x628300b0, 0x61ed14fc, 0x00000000}},  //   _senn, _runo, _naal,
  { {0x7e7d0173, 0x6283011c, 0x34b20025, 0x00000000}},  //   _misp, _suno, مميز,
  { {0x6283008d, 0x660914fd, 0x7bc5033b, 0x00000000}},  //   _puno, sjek, nghu,
  { {0xc5d501fb, 0x6d5d05ad, 0x63a30292, 0x00000000}},  //   _біль, _lysa, _venn,
  { {0x63a3037f, 0x7e7d14fe, 0x2604006e, 0x00000000}},  //   _wenn, _nisp, वाणी_,
  { {0x04c80025, 0x63a30e69, 0x61ed00bb, 0x00000000}},  //   _لوني_, _tenn, _daal,
  { {0xf77801d5, 0x6283011c, 0x34b20014, 0x00000000}},  //   _taħt_, _tuno, _اموز,
  { {0xb05b0002, 0x7e7d14ff, 0x61ed1500, 0x00000000}},  //   kräf, _bisp, _faal,
  { {0xc6920476, 0xfce6025f, 0x7e7d0048, 0x00000000}},  //   מאל_, лобо, _cisp,
  { {0x4d66007e, 0xdd8f01fa, 0xb05b059f, 0x00000000}},  // [27e0] укав, سول_, ttät,
  { {0x309b019b, 0x69c9000d, 0xab2a026b, 0x00000000}},  //   _רשימ, _acee, ноза_,
  { {0x68e90016, 0xb05b04ce, 0x00000000, 0x00000000}},  //   _ased, rtät,   ,
  { {0xb05b010f, 0x63a80059, 0x2906002d, 0x00000000}},  //   stät, zadn, txoa_,
  { {0x522d0049, 0x00000000, 0x00000000, 0x00000000}},  //   וואַ,   ,   ,
  { {0xcaa60025, 0xdd3b0049, 0x00000000, 0x00000000}},  //   _مصري, _װעלכ,   ,
  { {0x63a81501, 0xd5e20082, 0x3a260a60, 0x00000000}},  //   vadn, _phò, phop_,
  { {0xe4e601fb, 0xa2810036, 0x64581502, 0x00000000}},  //   гіон, łość_, _skvi,
  { {0x3946012b, 0x61ed00bb, 0x00000000, 0x00000000}},  //   _снаг, _raal,   ,
  { {0x61ed006c, 0x250700a1, 0x00000000, 0x00000000}},  //   _saal, ارٹی_,   ,
  { {0x26040309, 0x61ed011c, 0xb05b00f8, 0x00000000}},  //   वादी_, _paal, ktär,
  { {0xa2270014, 0x387e00ca, 0x64a6007e, 0x00000000}},  //   ارده, _hitr_, _бада,
  { {0x7e7d0409, 0x61ed0158, 0x41c601f5, 0x00000000}},  //   _risp, _vaal, _वारस,
  { {0x4394008b, 0xf1bf002a, 0x7e7d0263, 0x00000000}},  //   _такс, chán_, _sisp,
  { {0x61ed0168, 0x5f9401fc, 0x3e410006, 0x00000000}},  //   _taal, сист, lėti_,
  { {0x92b30445, 0x00000000, 0x00000000, 0x00000000}},  //   _احوا,   ,   ,
  { {0x7e7d001e, 0x3e410006, 0xc047025a, 0x00000000}},  // [27f0] _visp, nėti_, _مخدو,
  { {0x25a6018e, 0x7e7d0ace, 0x6d5d01ca, 0x00000000}},  //   _leol_, _wisp, _vysa,
  { {0x7bc507a9, 0xb05b09f0, 0x78bc0089, 0x00000000}},  //   rghu, träf, _ārva,
  { {0x3e410006, 0x636f0010, 0x2bc70164, 0x00000000}},  //   kėti_, lóné, _लावा,
  { {0x05260044, 0x00000000, 0x00000000, 0x00000000}},  //   মপুর_,   ,   ,
  { {0x3e41010a, 0x25a90059, 0x973c016c, 0x00000000}},  //   dėti_, _žal_, _većn,
  { {0x3dd90022, 0x00000000, 0x00000000, 0x00000000}},  //   _kbsw_,   ,   ,
  { {0x25a6002a, 0x38c900a1, 0x24861503, 0x00000000}},  //   _ceol_, _لائی_, _buom_,
  { {0x68e91504, 0xf1bf0051, 0x387e0da4, 0x00000000}},  //   _used, thán_, _fitr_,
  { {0x2249003f, 0x24860145, 0x00000000, 0x00000000}},  //   _ajak_, _duom_,   ,
  { {0x63bc000c, 0x31690010, 0xe7840014, 0x00000000}},  //   órna, _azaz_, _المپ,
  { {0xd57509b5, 0xe3b100a6, 0xa4d50088, 0x00000000}},  //   _куль, حرک_, _воді,
  { {0x2249012d, 0x00000000, 0x00000000, 0x00000000}},  //   _djak_,   ,   ,
  { {0xa06a008b, 0xfaf80089, 0xe3b90131, 0x00000000}},  //   тага_, _šīm_, _рбк_,
  { {0x43750049, 0xb05b00b0, 0x6e36004d, 0x00000000}},  //   _דײַן_, ttär, ахах,
  { {0x644f00f4, 0x22490065, 0x9ac70066, 0x00000000}},  //   écif, _gjak_, _miċħ,

  { {0xc0e6026b, 0x6fd60088, 0xb05b04ce, 0x00000000}},  // [2800] _топк, _кінц, rtär,
  { {0xb05b09b0, 0xd00f0025, 0x00000000, 0x00000000}},  //   stär, _يلي_,   ,
  { {0x394d06fa, 0x395f0058, 0x79a600e2, 0x00000000}},  //   _axes_, _ayus_, арле,
  { {0xb05b001f, 0x2a6d00b9, 0x2efa1505, 0x00000000}},  //   träg, _cheb_, _irpf_,
  { {0x2604006e, 0x25a61506, 0xda650379, 0x00000000}},  //   वासी_, _reol_, حالي,
  { {0x25a6002a, 0x6843007c, 0x6352013e, 0x00000000}},  //   _seol_, онча, něné,
  { {0x6f1c0016, 0x973c04eb, 0x03ee0044, 0x00000000}},  //   nyrc, _većo, জামী_,
  { {0xb05b0788, 0x6b630088, 0x00000000, 0x00000000}},  //   präg, _єкта,   ,
  { {0x87da02fd, 0x6f1c0016, 0x746a0140, 0x00000000}},  //   _لباس_, hyrc, кров_,
  { {0xbcfb0010, 0x3e410006, 0x2604007d, 0x00000000}},  //   _szék, rėti_, वाही_,
  { {0x23380147, 0xb6cb00a1, 0x20131507, 0x00000000}},  //   упны_, _لانے_, _roxi_,
  { {0xd377008b, 0xd2580088, 0x00000000, 0x00000000}},  //   шчы_, иця_,   ,
  { {0x04940379, 0x625d009d, 0x00000000, 0x00000000}},  //   _التح, déot,   ,
  { {0x04db01ce, 0x26040061, 0x251b0097, 0x00000000}},  //   _סקול, वावी_, _בודא,
  { {0x6f1c018e, 0xbe880407, 0x660205d5, 0x00000000}},  //   gyrc, исте_, _knok,
  { {0x30a71508, 0xdd980aed, 0xe37b00b3, 0x00000000}},  //   _кров, ишу_, _ברור,
  { {0x629a0a0e, 0xb05b0039, 0x786d00c4, 0x00000000}},  // [2810] lpto, träd, lúve,
  { {0x2bb80025, 0x00000000, 0x00000000, 0x00000000}},  //   لامة_,   ,   ,
  { {0x5fdc0097, 0xb05b053d, 0x66020087, 0x00000000}},  //   _יחזק, rräd, _onok,
  { {0x4975034b, 0x9f430023, 0x00000000, 0x00000000}},  //   блес, hejë_,   ,
  { {0x8cf4008b, 0x26de0285, 0xe8030204, 0x00000000}},  //   _дзяц, _apto_, लाला_,
  { {0x1d16009b, 0x660204a5, 0x3dc900e0, 0x00000000}},  //   _הקשר_, _anok, lgaw_,
  { {0x6dbb00b4, 0x00000000, 0x00000000, 0x00000000}},  //   ałał,   ,   ,
  { {0xb8cd0055, 0x3dc9011c, 0x26de008e, 0x00000000}},  //   _কম_, ngaw_, _dpto_,
  { {0xe45900e3, 0x81d60044, 0x629a0168, 0x00000000}},  //   лжи_, _সফল_, epto,
  { {0x9b44009c, 0x9814007a, 0x68fb022b, 0x00000000}},  //   _انہو, _وبلا, _irud,
  { {0xe71904e8, 0x00000000, 0x00000000, 0x00000000}},  //   _حيات_,   ,   ,
  { {0x68fb0d44, 0x66020026, 0x00000000, 0x00000000}},  //   _krud, _gnok,   ,
  { {0x26040201, 0x291d1509, 0x8505007a, 0x00000000}},  //   वारी_, nywa_, _دوشن,
  { {0x3cfe00b9, 0x33950025, 0xe3b8014a, 0x00000000}},  //   _čtv_, _الغز, lkın_,
  { {0xfbcd0044, 0x442700ea, 0xd7f10082, 0x00000000}},  //   রজাত, _iln_, _mã_,
  { {0x0d86012b, 0x25ad01d6, 0x68fb016c, 0x00000000}},  //   слан, nael_, _orud,
  { {0x61e6150a, 0x44270022, 0x00000000, 0x00000000}},  // [2820] mekl, _kln_,   ,
  { {0x69db0211, 0x442704be, 0x61e6014a, 0x00000000}},  //   _abue, _jln_, lekl,
  { {0x6d4f06c2, 0x442709a8, 0xfc3f04bd, 0x00000000}},  //   _exca, _mln_, _avís_,
  { {0x80cb0055, 0x61e6011f, 0xb3460181, 0x00000000}},  //   িবর্, nekl, leçõ,
  { {0xddcd0477, 0x25ad0016, 0x7e64150b, 0x00000000}},  //   llaş, dael_, mlip,
  { {0x61e6129a, 0x6602150c, 0x00000000, 0x00000000}},  //   hekl, _snok,   ,
  { {0xddcd027d, 0x25ad00d6, 0x61e6014a, 0x00000000}},  //   nlaş, fael_, kekl,
  { {0x44270026, 0x7e64011c, 0x7c3e010e, 0x00000000}},  //   _aln_, nlip, lipr,
  { {0x68fb150d, 0xa9260057, 0x61e60010, 0x00000000}},  //   _grud, _удал, dekl,
  { {0xddcd011f, 0x7c3e00ea, 0xe82400a1, 0x00000000}},  //   klaş, nipr, _بذری,
  { {0x5c5b007b, 0x2bf7009b, 0x63a4012d, 0x00000000}},  //   רדיק, זמין_, _đind,
  { {0xad9b02d5, 0xcb13009b, 0xc0cb003b, 0x00000000}},  //   _anún, ללת_, луге_,
  { {0x661d0c4d, 0x7bdc0738, 0xdb070023, 0x00000000}},  //   öske, _obru, _pejë,
  { {0x133900a1, 0x4427016b, 0x629a150e, 0x00000000}},  //   اتیں_, _gln_, ppto,
  { {0x443e150f, 0x543b007b, 0x645a1510, 0x00000000}},  //   mit_, _געגא, moti,
  { {0x443e006a, 0x645a0089, 0x7bdc0207, 0x00000000}},  //   lit_, loti, _abru,
  { {0x973c0521, 0x68e4006b, 0x9c3900e2, 0x00000000}},  // [2830] _bećk, çidl, апат_,
  { {0x443e1511, 0x645a0089, 0x628a1512, 0x00000000}},  //   nit_, noti, _kufo,
  { {0x6448022b, 0x207c0049, 0x7bce0022, 0x00000000}},  //   indi, _גאזא, _dcbu,
  { {0x443e0b9a, 0x1df90057, 0x7e64094e, 0x00000000}},  //   hit_, _темы_, clip,
  { {0x443e0d56, 0x00000000, 0x00000000, 0x00000000}},  //   kit_,   ,   ,
  { {0x629804a3, 0x443e1513, 0x7c3e0375, 0x00000000}},  //   _otvo, jit_, cipr,
  { {0x645a0ba5, 0xa3be006e, 0x628a007f, 0x00000000}},  //   doti, ेलन_, _nufo,
  { {0x68fb1514, 0x6e2d1515, 0xe61901f9, 0x00000000}},  //   _trud, nhab, рди_,
  { {0x44271516, 0x644806d6, 0xddcd0180, 0x00000000}},  //   _pln_, fndi, zlaş,
  { {0x443e006a, 0xddcd011f, 0x63aa018e, 0x00000000}},  //   git_, ylaş, _cefn,
  { {0x63aa018e, 0x27e71517, 0xdb1c0051, 0x00000000}},  //   _defn, menn_, _scrú,
  { {0x443e1518, 0x64480020, 0x69cb020c, 0x00000000}},  //   ait_, andi, ngge,
  { {0xe3ae0373, 0x61e6011f, 0x6e2d1519, 0x00000000}},  //   _об_, rekl, dhab,
  { {0x443e151a, 0x645a0089, 0x442c0061, 0x00000000}},  //   cit_, coti, chd_,
  { {0x26c70709, 0x61e6014a, 0xa3d2013d, 0x00000000}},  //   nuno_, pekl, _हॉट_,
  { {0xddcd0180, 0x22b50089, 0xa3d70061, 0x00000000}},  //   rlaş, māk_, ाभव_,
  { {0x81d30055, 0xd7c90316, 0x22b5001e, 0x00000000}},  // [2840] _হোক_, _रांच, lāk_,
  { {0xebe30081, 0xddcd0180, 0x69d900d9, 0x00000000}},  //   моуп, plaş, efwe,
  { {0x22b50089, 0xd24f0167, 0x27e70173, 0x00000000}},  //   nāk_, _سنی_, denn_,
  { {0x443e151b, 0xe8fa151c, 0x6e2d008e, 0x00000000}},  //   zit_, иле_, chab,
  { {0x3ead037e, 0x6448009f, 0x443e0148, 0x00000000}},  //   ćete_, yndi, yit_,
  { {0x443e0f51, 0x7bdc0190, 0x645a151d, 0x00000000}},  //   xit_, _ubru, xoti,
  { {0xdcf6038c, 0x645a0119, 0x26c70211, 0x00000000}},  //   mayı, voti, guno_,
  { {0xdcf6038c, 0x765b01aa, 0x628a00fa, 0x00000000}},  //   layı, gouy, _rufo,
  { {0x443e151e, 0x645a0089, 0x62980119, 0x00000000}},  //   tit_, toti, _stvo,
  { {0x186a0265, 0x64481153, 0x47c301e0, 0x00000000}},  //   _тази_, undi, _обув,
  { {0x443e071e, 0x1bfb0049, 0x2bcf006e, 0x00000000}},  //   rit_, בליב, स्टा,
  { {0x95c7003b, 0x443e151f, 0x645a0089, 0x00000000}},  //   _душа_, sit_, soti,
  { {0x443e006a, 0xda7b00b6, 0x645a016e, 0x00000000}},  //   pit_, ינטר, poti,
  { {0xddcd1520, 0x7640010a, 0x22b5001e, 0x00000000}},  //   dmaš, limy, bāk_,
  { {0x69cb0693, 0x6e2d0051, 0x539b00b3, 0x00000000}},  //   ygge, thab, _דיוו,
  { {0xd3780166, 0x2bdd0309, 0x6e2400e0, 0x00000000}},  //   jeći_, न्ना, gkib,
  { {0xd3780119, 0x6e2d014a, 0xacf80451, 0x00000000}},  // [2850] deći_, rhab, онту_,
  { {0x6e2d0020, 0x26c71521, 0xad9b0181, 0x00000000}},  //   shab, yuno_, _inúm,
  { {0x76401522, 0x6e2d028a, 0x00000000, 0x00000000}},  //   kimy, phab,   ,
  { {0x26c700e7, 0x27e7000a, 0x00000000, 0x00000000}},  //   vuno_, wenn_,   ,
  { {0x22b50089, 0x22a70010, 0x443c064f, 0x00000000}},  //   zāk_, zők_, _omv_,
  { {0xf8071523, 0x26c70016, 0x443c0087, 0x00000000}},  //   ючен, tuno_, _nmv_,
  { {0xd3780107, 0x27e701aa, 0x2a6600e0, 0x00000000}},  //   beći_, renn_, blob_,
  { {0x06090072, 0x22b50089, 0x22a70010, 0x00000000}},  //   сник_, vāk_, vők_,
  { {0xe4d60025, 0x27e71524, 0x26c700e0, 0x00000000}},  //   كويت_, penn_, suno_,
  { {0x87070025, 0x26c71525, 0x22a70010, 0x00000000}},  //   _وبال, puno_, tők_,
  { {0x2bdd0201, 0x443c00bb, 0x625d009d, 0x00000000}},  //   न्या, _dmv_, téop,
  { {0x22b5001e, 0x26f903d7, 0x2c6d0428, 0x00000000}},  //   rāk_, ्मीर_, _vždy_,
  { {0x973c012d, 0x22b50089, 0x22a70010, 0x00000000}},  //   _reći, sāk_, sők_,
  { {0xb4fa009b, 0x16090061, 0xd3780091, 0x00000000}},  //   _לפני, वावर_, zeći_,
  { {0x64410475, 0x0e6a0025, 0x973c04eb, 0x00000000}},  //   mili, مصري_, _peći,
  { {0xe1ff1526, 0x64410504, 0xa2c0006e, 0x00000000}},  //   llón_, lili, _वित्,
  { {0x973c0119, 0x6e241527, 0x2bc70061, 0x00000000}},  // [2860] _veći, rkib, _लाखा,
  { {0x61f60284, 0x66190093, 0x6e241528, 0x00000000}},  //   _hayl, _lowk, skib,
  { {0x61f61163, 0xd3780363, 0xdcf6005d, 0x00000000}},  //   _kayl, teći_, rayı,
  { {0x6441011c, 0x201a1529, 0x98a0152a, 0x00000000}},  //   hili, _hopi_, šič_,
  { {0x6441000b, 0x61f607b1, 0xd3780091, 0x00000000}},  //   kili, _mayl, reći_,
  { {0x61f607b1, 0x64410020, 0xb05b010f, 0x00000000}},  //   _layl, jili, hrän,
  { {0x6441000b, 0x7640000a, 0xe9a60088, 0x00000000}},  //   dili, timy, _навп,
  { {0xa3d9006e, 0x443c0c48, 0xf77200a1, 0x00000000}},  //   ड्स_, _smv_, واں_,
  { {0x6441152b, 0xb05b053d, 0x682f0190, 0x00000000}},  //   fili, drän, _bødd,
  { {0xa2c002f4, 0x644108a1, 0x3a2601d6, 0x00000000}},  //   _विद्, gili, lkop_,
  { {0x46a3003b, 0x644f028c, 0xe7b3025a, 0x00000000}},  //   _захв, écia, _سمند,
  { {0xb05b152c, 0x7ae1010f, 0x3a26018f, 0x00000000}},  //   grän, _älte, nkop_,
  { {0x6441152d, 0x216709b5, 0x682f01e3, 0x00000000}},  //   bili, ятог, _fødd,
  { {0x201a0016, 0x6e3d0066, 0xe1ff004a, 0x00000000}},  //   _copi_, _smsb, clón_,
  { {0x629c004f, 0xf1c60204, 0x33db009b, 0x00000000}},  //   írod, _वाचन, _החוד,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xbcfb0047, 0xc1bc009b, 0x91bc009b, 0x00000000}},  // [2870] _azér, _המחש, _המחי,
  { {0x201a005b, 0x682f0190, 0x32090082, 0x00000000}},  //   _gopi_, _køde, _hnay_,
  { {0x998900b9, 0x682f043e, 0x61f6005a, 0x00000000}},  //   íkům_, _jøde, _yayl,
  { {0x682f0030, 0x3a26011c, 0x78a9000a, 0x00000000}},  //   _møde, gkop_, _pwev,
  { {0xa3be024c, 0xbcfb0047, 0xf8ae00a1, 0x00000000}},  //   ेला_, _ezér, لکل_,
  { {0x64410ddd, 0xd3780521, 0x00000000, 0x00000000}},  //   xili, leću_,   ,
  { {0x3209014a, 0x682f0190, 0x2d9f010e, 0x00000000}},  //   _onay_, _rødd, _õues_,
  { {0x6441018e, 0xc7440054, 0xdb0700b9, 0x00000000}},  //   wili, عضوي, _její,
  { {0x64410b1a, 0x280800b9, 0xdb0702a0, 0x00000000}},  //   tili, átní_, _mejí,
  { {0xe7b500d3, 0x61f6006b, 0x32090058, 0x00000000}},  //   _آماد, _sayl, _anay_,
  { {0x6441005f, 0x61f60676, 0x1b1f0055, 0x00000000}},  //   rili, _payl, _যেতে_,
  { {0x6441152e, 0xdb0e0181, 0xd3780243, 0x00000000}},  //   sili, _bebê, jeću_,
  { {0x6441006a, 0x22420292, 0xb05b0c4d, 0x00000000}},  //   pili, rikk_, rrän,
  { {0x682f05b7, 0xdee6007c, 0x22420056, 0x00000000}},  //   _føde, моги, sikk_,
  { {0x61f605ac, 0x25af0087, 0x682f0146, 0x00000000}},  //   _tayl, _kegl_, _gøde,
  { {0x7bc3000c, 0x61f6013f, 0x00000000, 0x00000000}},  //   ónun, _uayl,   ,
  { {0x201a11a7, 0x2ca0152f, 0xdb0e01d6, 0x00000000}},  // [2880] _topi_, upid_, _gebê,
  { {0x2ca00009, 0x25dd0204, 0x3a2d0068, 0x00000000}},  //   rpid_, क्ती_, _alep_,
  { {0x63bc1530, 0x248701aa, 0xa2a10061, 0x00000000}},  //   órni, _minm_, कीच्,
  { {0xa2c002fb, 0xfaf8001e, 0xc7b8012d, 0x00000000}},  //   _विस्, _šīs_, _mođe_,
  { {0x3a26123c, 0xd83a007e, 0x08970025, 0x00000000}},  //   rkop_, жэй_, وضوع_,
  { {0x3a260235, 0x68ed00c4, 0x0ee2006e, 0x00000000}},  //   skop_, çada, _पहाड,
  { {0x3a26067c, 0x7c2e0026, 0x66e30545, 0x00000000}},  //   pkop_, _ilbr, воја,
  { {0x26c012f8, 0x2487002a, 0x44f40216, 0x00000000}},  //   čio_, _ainm_, епис,
  { {0x25af0026, 0x682f0190, 0x00000000, 0x00000000}},  //   _degl_, _søde,   ,
  { {0x83fc0182, 0x22400f37, 0x00000000, 0x00000000}},  //   kođe, _amik_,   ,
  { {0xd6cf004b, 0x97260014, 0x78a201ed, 0x00000000}},  //   _نقل_, _تفاو, lpov,
  { {0xc7b80091, 0x64a6007e, 0x7afa000c, 0x00000000}},  //   _dođe_, _жада, _áttu,
  { {0xe8030061, 0x7c2e00b4, 0x00000000, 0x00000000}},  //   लाचा_, _olbr,   ,
  { {0x656f010f, 0x9f43013e, 0x00000000, 0x00000000}},  //   üche, sejí_,   ,
  { {0x83fc0166, 0x442e0288, 0x00000000, 0x00000000}},  //   gođe, _ilf_,   ,
  { {0x41e70822, 0x7c2e01a2, 0xddc40036, 0x00000000}},  //   _ціка, _albr, enił,
  { {0x5c750057, 0x7bde010f, 0x101800a1, 0x00000000}},  // [2890] елат, ffpu, سکیں_,
  { {0x78a206b8, 0x3a2d1531, 0x83fc0091, 0x00000000}},  //   dpov, _slep_, bođe,
  { {0xb5fd003b, 0x00000000, 0x00000000, 0x00000000}},  //   loše,   ,   ,
  { {0xd37b0049, 0xdb1c004a, 0x2cc4019a, 0x00000000}},  //   קראט, _acró, ürdü_,
  { {0x5d8501d8, 0xb5fd0340, 0x682f068f, 0x00000000}},  //   _سلسل, noše, _rødb,
  { {0x46f50088, 0xec350049, 0x2c05013d, 0x00000000}},  //   ечит, _טאָר_, राओं_,
  { {0xa2c00309, 0x661d0c43, 0x00000000, 0x00000000}},  //   _विष्, ösko,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xdb1c01aa, 0x260401f5, 0xb5fd0645, 0x00000000}},  //   _adrè, वाजी_, joše,
  { {0xa2c002fb, 0xb5fd050f, 0x7af50036, 0x00000000}},  //   _विश्, doše, _kszt,
  { {0x442e0190, 0x31690276, 0xe5e1007e, 0x00000000}},  //   _dlf_, _ayaz_, _былi_,
  { {0x349503f3, 0x83fc0091, 0xdb0e000a, 0x00000000}},  //   _задр, vođe, _debè,
  { {0x6594012b, 0xb5fd0b18, 0x660b1532, 0x00000000}},  //   _рачу, goše, _ingk,
  { {0x26c70207, 0x7af50047, 0x95cc006b, 0x00000000}},  //   orno_, _oszt, _çərç,
  { {0xbcfb0047, 0x26040061, 0xdee30256, 0x00000000}},  //   _szép, वाची_, лори,
  { {0x9f580919, 0x433a009b, 0x83fc0166, 0x00000000}},  //   ndré_, _מעצב, rođe,
  { {0x61e41533, 0x7af50010, 0x93f30061, 0x00000000}},  // [28a0] _ibil, _aszt, _असाच_,
  { {0x4d631534, 0x3ec5005a, 0xa7fc014a, 0x00000000}},  //   укув, üstü_, _akın,
  { {0x4fd7007b, 0x7fd7007b, 0x660b10ed, 0x00000000}},  //   _אויב_, _אויס_, _ongk,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x61e4000b, 0x67d401fc, 0x7af50010, 0x00000000}},  //   _mbil, волу, _eszt,
  { {0x660b1535, 0x25dd006e, 0xfaf100a1, 0x00000000}},  //   _angk, क्सी_, دثے_,
  { {0x61e40091, 0x78a2057c, 0xad9b000c, 0x00000000}},  //   _obil, spov, _snúi,
  { {0x660b0085, 0xdb0e0173, 0x00000000, 0x00000000}},  //   _cngk, _rebè,   ,
  { {0x54541536, 0x69c000f6, 0x442e0203, 0x00000000}},  //   квит, _idme, _plf_,
  { {0xccf300b6, 0x61e41537, 0x290403ba, 0x00000000}},  //   רכז_, _abil, _irma_,
  { {0xdb0e0b76, 0x61e401f3, 0x7e660022, 0x00000000}},  //   _bebé, _bbil, _okkp,
  { {0x5ab700bd, 0x7e6600e0, 0x00000000, 0x00000000}},  //   עלכע_, _nkkp,   ,
  { {0x442e0018, 0xdb0e004a, 0xd83f00ca, 0x00000000}},  //   _tlf_, _debé, _ščit_,
  { {0xb5fd0627, 0x442e02e1, 0xdb070010, 0x00000000}},  //   roše, _ulf_, _lejá,
  { {0xc0ab00a6, 0x69c00465, 0x2baf006e, 0x00000000}},  //   _کابل_, _odme, टरसा,
  { {0xb5fd016c, 0x29041538, 0x27ee0016, 0x00000000}},  //   poše, _orma_, hefn_,
  { {0xf1bf1539, 0x61ef153a, 0x8bc7153b, 0x00000000}},  // [28b0] nkám_, mecl, есед,
  { {0x69c0153c, 0x61e4016e, 0x61fd0056, 0x00000000}},  //   _adme, _zbil, ldsl,
  { {0x7e660022, 0xdb070010, 0x00000000, 0x00000000}},  //   _fkkp, _bejá,   ,
  { {0x61fd06a1, 0x68ed153d, 0x61ef153e, 0x00000000}},  //   ndsl, çado, necl,
  { {0xd366007a, 0x7e6d153f, 0x60dd1540, 0x00000000}},  //   _چه_, mlap, ntsm,
  { {0x7e6d0010, 0xd3660014, 0x69c000e0, 0x00000000}},  //   llap, _نه_, _edme,
  { {0x8f9c0049, 0x29040145, 0xcc54005e, 0x00000000}},  //   ליגי, _erma_, _свръ,
  { {0x7e6d0010, 0x24990285, 0x61fd0030, 0x00000000}},  //   nlap, ísmo_, jdsl,
  { {0xe895008b, 0x61ef1541, 0x9f4a0129, 0x00000000}},  //   _разь, decl, rebé_,
  { {0x7e6d00b0, 0x61e40197, 0x00000000, 0x00000000}},  //   hlap, _sbil,   ,
  { {0x3f8c016c, 0xe6c70379, 0x26dc0f6c, 0x00000000}},  //   žduk_, _ستاي, ctvo_,
  { {0x660b0169, 0x60dd01a2, 0xa6960097, 0x00000000}},  //   _ungk, ftsm, _סכנה_,
  { {0x463a007b, 0x7e6d0089, 0x60dd0030, 0x00000000}},  //   _קענע, dlap, gtsm,
  { {0x6a7810af, 0x25dd007d, 0x701901e1, 0x00000000}},  //   mífe, क्री_, ніст_,
  { {0x61e4006b, 0x998f0006, 0x6a781542, 0x00000000}},  //   _tbil, nigų_, lífe,
  { {0x61e40825, 0xc6920049, 0xa7fc014a, 0x00000000}},  //   _ubil, שאן_, _akıl,
  { {0x6a78052a, 0x3e5a013e, 0x60dd0045, 0x00000000}},  // [28c0] nífe, jďte_, ctsm,
  { {0xe0b7061e, 0x9f5a0065, 0xfce3142c, 0x00000000}},  //   _שליט_, _japë_, рофо,
  { {0x68e906c0, 0xe9da007c, 0x3daa007c, 0x00000000}},  //   _aped, дке_, _окно_,
  { {0x98a60081, 0x831a0049, 0x60c9016c, 0x00000000}},  //   виде, וועז, šeme,
  { {0x64430006, 0x00000000, 0x00000000, 0x00000000}},  //   _omni,   ,   ,
  { {0x6b9c00c4, 0x26ce004a, 0x00000000, 0x00000000}},  //   _ufrg, tufo_,   ,
  { {0x8c43025f, 0xddcd001a, 0x69c00009, 0x00000000}},  //   _тере, noaş, _tdme,
  { {0x35f40331, 0xceb300b3, 0x69c008c8, 0x00000000}},  //   упир, ביה_, _udme,
  { {0x26dc016c, 0x2904000d, 0xd9100123, 0x00000000}},  //   stvo_, _urma_, _دیش_,
  { {0xa84a025a, 0x26dc012d, 0x00000000, 0x00000000}},  //   _غلام_, ptvo_,   ,
  { {0x1db20164, 0x0bb700b3, 0x64430009, 0x00000000}},  //   जरात, כלים_, _dmni,
  { {0x27e9037e, 0x60dd02e1, 0x6443014a, 0x00000000}},  //   đane_, ttsm, _emni,
  { {0x61fd1543, 0x041e0044, 0x61ef0585, 0x00000000}},  //   rdsl, যোগী_, recl,
  { {0xdb05000c, 0x61ef009d, 0xa4b7009b, 0x00000000}},  //   rahú, secl, _ילדה_,
  { {0xb5fd01c5, 0x7e6d0010, 0xf1bf0010, 0x00000000}},  //   loša, tlap, nkák_,
  { {0x64480996, 0x2d8f0030, 0x64430036, 0x00000000}},  //   lidi, øge_, _zmni,
  { {0xb5fd001e, 0x3d0d013d, 0x9f5a01aa, 0x00000000}},  // [28d0] noša, समें_, _lapè_,
  { {0x7e6d010a, 0xd0f8012f, 0x64481544, 0x00000000}},  //   slap, _יצחק_, nidi,
  { {0x68e90198, 0xe0df0197, 0x7e6d1545, 0x00000000}},  //   _sped, ltò_, plap,
  { {0xe1ff0010, 0x64480b1f, 0x628d0066, 0x00000000}},  //   ndó_, hidi, _jiao,
  { {0x6e2d0020, 0xe0df0e5d, 0x89a80088, 0x00000000}},  //   mkab, ntò_, тків_,
  { {0xb5fd001e, 0x628d01f3, 0x644809d8, 0x00000000}},  //   doša, _liao, jidi,
  { {0x36690057, 0x64480006, 0x81cb0044, 0x00000000}},  //   нако_, didi, র্য_,
  { {0x83fc0091, 0xc7b804eb, 0x6a7803d1, 0x00000000}},  //   vođa, _vođa_, tífe,
  { {0x64480b1f, 0x9f4300b0, 0x5a44007e, 0x00000000}},  //   fidi, lejä_, _тэра,
  { {0x6448014a, 0x81cb0044, 0x683400f6, 0x00000000}},  //   gidi, র্ম_, _pàde,
  { {0x6e2d014a, 0x05130044, 0x8458005e, 0x00000000}},  //   kkab, িনের_, ърът_,
  { {0x83fc0107, 0x823604e8, 0x628d0197, 0x00000000}},  //   rođa, اردا, _ciao,
  { {0x64480b62, 0x628d1546, 0x7d0904eb, 0x00000000}},  //   bidi, _diao, _šesn,
  { {0x64480919, 0xddc400b9, 0x64431547, 0x00000000}},  //   cidi, dliš, _umni,
  { {0x3ebe009f, 0x75290047, 0x00000000, 0x00000000}},  //   étt_, lyez,   ,
  { {0x81cb0055, 0x661b020c, 0x6e2d011c, 0x00000000}},  //   র্ব_, njuk, gkab,
  { {0x75291483, 0xdcff006b, 0xddc4007f, 0x00000000}},  // [28e0] nyez, faqı, gliš,
  { {0xbc6a023c, 0x661b0934, 0x00000000, 0x00000000}},  //   رمان_, hjuk,   ,
  { {0x49ca1548, 0x9f8b010e, 0x00000000, 0x00000000}},  //   елен_, _söök_,   ,
  { {0x6e2d003b, 0x64480142, 0xddc40087, 0x00000000}},  //   ckab, zidi, bliš,
  { {0x28f80e09, 0x627c0036, 0xad9b0027, 0x00000000}},  //   тель_, _głoś, _vnút,
  { {0x64480096, 0xb5fd0089, 0x00000000, 0x00000000}},  //   xidi, voša,   ,
  { {0x7d04044e, 0x644809dd, 0xfaa300ec, 0x00000000}},  //   lvis, vidi, _гасо,
  { {0xb5fd001e, 0xceb3009b, 0x6448018e, 0x00000000}},  //   toša, זיה_, widi,
  { {0x81cb0055, 0x644811c6, 0x7d0405fe, 0x00000000}},  //   র্ড_, tidi, nvis,
  { {0xb5fd0089, 0x5c370049, 0x2a66011c, 0x00000000}},  //   roša, ָרטן_, loob_,
  { {0xd7930054, 0x442c1549, 0xddc401ca, 0x00000000}},  //   _المخ, rkd_, zliš,
  { {0x3ce004d3, 0x6448005d, 0x667600a1, 0x00000000}},  //   ktiv_, sidi, _صدار,
  { {0x7d04154a, 0xe1ff154b, 0xc5f300b6, 0x00000000}},  //   jvis, rdó_, _לדף_,
  { {0x7d0400b5, 0xe0df0197, 0x9f530066, 0x00000000}},  //   dvis, rtò_, _paxà_,
  { {0xd904026c, 0xf8d1006e, 0x63ba154c, 0x00000000}},  //   _کی_, _सम्प, matn,
  { {0x63ba154d, 0x7d040146, 0x00000000, 0x00000000}},  //   latn, fvis,   ,
  { {0xdb0e008e, 0x2fda0009, 0x5bcb003b, 0x00000000}},  // [28f0] _debí, _fcpg_, ећег_,
  { {0xad9b0917, 0x224b154e, 0x6e2d0030, 0x00000000}},  //   _saúd, lick_, skab,
  { {0x09bc0055, 0x1a6500a1, 0x81cb0044, 0x00000000}},  //   _ইউজা, لیسی_, র্ণ_,
  { {0x224b154f, 0xdb070039, 0x63ba1550, 0x00000000}},  //   nick_, _rejä, hatn,
  { {0x212b1551, 0x63ba033b, 0x3ce0001a, 0x00000000}},  //   nych_, katn, ctiv_,
  { {0x63ba0119, 0x2ca900f8, 0x224b01a2, 0x00000000}},  //   jatn, mpad_, hick_,
  { {0x63ba01d9, 0x224b098e, 0x75d50014, 0x00000000}},  //   datn, kick_, ليغا,
  { {0x06090057, 0x81cb0044, 0xf625034b, 0x00000000}},  //   тник_, র্ত_, рдио,
  { {0x680b001e, 0x63ba04be, 0x2ca90168, 0x00000000}},  //   _pēdē, fatn, npad_,
  { {0x212b1552, 0x1309007c, 0x63ba0010, 0x00000000}},  //   dych_, вной_, gatn,
  { {0x35f5041f, 0xb05b01a2, 0x9f5a0068, 0x00000000}},  //   _впер, nräu, _tapé_,
  { {0x224b0039, 0x7d0400b0, 0x2ca9046a, 0x00000000}},  //   gick_, yvis, kpad_,
  { {0xae000061, 0x63ba04cb, 0x25ad1553, 0x00000000}},  //   _लोगन_, batn, mbel_,
  { {0x7d040a19, 0x645d00f4, 0x98a00166, 0x00000000}},  //   vvis, ésid, šić_,
  { {0xc447026c, 0xdfcf0025, 0x81c00044, 0x00000000}},  //   _لیکن_, ظيف_, ুভব_,
  { {0x7d040089, 0x3ce001d5, 0x3126005e, 0x00000000}},  //   tvis, ttiv_, _вдиг,
  { {0x212b0046, 0x1c46008b, 0x00000000, 0x00000000}},  // [2900] cych_, анам,   ,
  { {0x69db0211, 0x629e029d, 0x3ce01554, 0x00000000}},  //   _acue, _époc, rtiv_,
  { {0x3ce01140, 0x2ca90f02, 0x68fb12b6, 0x00000000}},  //   stiv_, apad_, _asud,
  { {0x7d040010, 0x25ad00b5, 0x63ba1555, 0x00000000}},  //   pvis, jbel_, zatn,
  { {0xb5fd1556, 0x7d0400f8, 0x9f580129, 0x00000000}},  //   tošn, qvis, ldrà_,
  { {0x25ad021f, 0xd90d0167, 0x69db004a, 0x00000000}},  //   ebel_, عیل_, _ecue,
  { {0x63ba01cd, 0x212b0046, 0x9f580129, 0x00000000}},  //   vatn, zych_, ndrà_,
  { {0x27e9037e, 0x2c0a001c, 0xb05b0a2f, 0x00000000}},  //   đana_, _होतं_, lrät,
  { {0x63ba0387, 0x15e20164, 0x98a30478, 0x00000000}},  //   tatn, क्षर_, _мите,
  { {0x3cf9013d, 0xb05b0210, 0x224b0133, 0x00000000}},  //   _उनसे_, nrät, wick_,
  { {0x212b0046, 0x3a240091, 0x2ca900ca, 0x00000000}},  //   wych_, _komp_, zpad_,
  { {0x212b0832, 0xdb15000a, 0xbddb000a, 0x00000000}},  //   tych_, _dezè, _emèj,
  { {0x224b01d5, 0x63ba0169, 0x9258005e, 0x00000000}},  //   rick_, patn, раят_,
  { {0x212b1557, 0x104b004c, 0x3a240168, 0x00000000}},  //   rych_, тями_, _lomp_,
  { {0xe29701f9, 0xc05801fb, 0x645d0f57, 0x00000000}},  //   _кај_, рія_, ésie,
  { {0x2ca901d6, 0x00000000, 0x00000000, 0x00000000}},  //   tpad_,   ,   ,
  { {0xdb05002a, 0xb5fd0465, 0x22490022, 0x00000000}},  // [2910] rbhí, došl, _imak_,
  { {0x2ca91558, 0x63b81559, 0xdd110066, 0x00000000}},  //   rpad_, _jevn, _iżże,
  { {0x2ca90107, 0xdb150010, 0xb9950025, 0x00000000}},  //   spad_, _kezé, ملاب,
  { {0x63b800b9, 0x2ca900f8, 0x00000000, 0x00000000}},  //   _levn, ppad_,   ,
  { {0xa3b60164, 0xe1ff155a, 0x20010058, 0x00000000}},  //   जरा_, llós_, _kahi_,
  { {0x81dd0055, 0x9f58008e, 0x20030022, 0x00000000}},  //   ড়ি_, ldrá_, ndji_,
  { {0x26c10428, 0xad9b0181, 0x62980207, 0x00000000}},  //   ého_, _gaúc, _nuvo,
  { {0xa2c002d2, 0xcf5801f8, 0x9f580211, 0x00000000}},  //   _विज्, יבות_, ndrá_,
  { {0x81dd0055, 0x68fb1434, 0x25ad155b, 0x00000000}},  //   ড়া_, _usud, rbel_,
  { {0xc6e701fb, 0x2001022b, 0x395f155c, 0x00000000}},  //   _відп, _nahi_, _ixus_,
  { {0xd6db012b, 0x63b80173, 0xe365004c, 0x00000000}},  //   _шта_, _devn, скни,
  { {0xf5950054, 0x81cb0044, 0x6298083f, 0x00000000}},  //   _الإج, র্স_, _duvo,
  { {0x66ea006b, 0x20010085, 0x661d01e5, 0x00000000}},  //   _təkc, _bahi_, ösku,
  { {0x8fa3003b, 0xa8790049, 0xf66a000c, 0x00000000}},  //   заре, טאָר, phæð_,
  { {0x2001155d, 0xb05b00f8, 0x00000000, 0x00000000}},  //   _dahi_, vrät,   ,
  { {0x7bc71468, 0xb05b155e, 0x682f0146, 0x00000000}},  //   _adju, tsäc, _bødk,
  { {0x3a2400bb, 0x66ea006b, 0x6298010f, 0x00000000}},  // [2920] _romp_, _məka, _zuvo,
  { {0xddcd0036, 0x00000000, 0x00000000, 0x00000000}},  //   gnał,   ,   ,
  { {0x5f061036, 0xb05b155f, 0x3a2400bb, 0x00000000}},  //   _узна, rrät, _pomp_,
  { {0xb05b0039, 0x9acb00a1, 0x68e20197, 0x00000000}},  //   srät, ادلہ_, ttod,
  { {0xa3d70164, 0xb05b0039, 0x628600ca, 0x00000000}},  //   िला_, prät, imko,
  { {0x6c3600a6, 0xc5e50044, 0xd6da02d3, 0x00000000}},  //   _افسا, _খোলা_, гти_,
  { {0x68e20207, 0x63b81560, 0xb5fd04eb, 0x00000000}},  //   stod, _revn, pošl,
  { {0xb8ce08b7, 0x63b800ca, 0xf1bf0010, 0x00000000}},  //   _কি_, _sevn, nkát_,
  { {0x629814f8, 0x63b80161, 0xdb050276, 0x00000000}},  //   _suvo, _pevn, zahü,
  { {0x96ba1561, 0x22491562, 0x932600a1, 0x00000000}},  //   _буду_, _smak_, مرجن,
  { {0xe6960025, 0xd5af02e9, 0x888102fd, 0x00000000}},  //   _الصد, _нс_, _تیون,
  { {0xe71700b6, 0x80dd0055, 0xfbde0044, 0x00000000}},  //   _לחבר_, যবস্, ড়িত,
  { {0xdb150010, 0x85761234, 0x067b0049, 0x00000000}},  //   _vezé, _ادائ, _ענדל,
  { {0x25de0204, 0xf1db0309, 0xdb1c0030, 0x00000000}},  //   _गाडी_, _भावन, _idræ,
  { {0xfbde0044, 0x9f340088, 0xadbd007e, 0x00000000}},  //   ড়াত, пері, кавi,
  { {0x66020004, 0x6a78004a, 0x200100e7, 0x00000000}},  //   _jaok, dífo, _wahi_,
  { {0xd7c80061, 0x61ed011c, 0x20011563, 0x00000000}},  // [2930] रणाच, _ibal, _tahi_,
  { {0x44e2000c, 0x81cb0044, 0xb6060521, 0x00000000}},  //   ið_, র্শ_, lašć,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x66020627, 0x998d1556, 0xb05b010f, 0x00000000}},  //   _naok, _aleš_, präs,
  { {0x61ed000b, 0x7bc3009f, 0x69d91564, 0x00000000}},  //   _mbal, ónus, rgwe,
  { {0x16a9005c, 0xbcfb00f4, 0xdb050048, 0x00000000}},  //   авки_, _exéc, abhá,
  { {0xb21b000c, 0xe7390827, 0x682f1565, 0x00000000}},  //   tmæl, рей_, _jødi,
  { {0xe7f503d7, 0x79e700a1, 0x644a0142, 0x00000000}},  //   _इसका_, _دورہ_, _amfi,
  { {0xb5fd0e3b, 0x845900ed, 0x7ae50022, 0x00000000}},  //   lošk, ирот_, ltht,
  { {0x61ed011c, 0x00000000, 0x00000000, 0x00000000}},  //   _abal,   ,   ,
  { {0x60c40119, 0xfbd2019b, 0x61ed1566, 0x00000000}},  //   _svim, ותי_, _bbal,
  { {0x7c270065, 0x7b200107, 0xe5ef00b0, 0x00000000}},  //   _lojr, _ušuš, äkää,
  { {0x644f00f4, 0x25bf0433, 0x61ed00d4, 0x00000000}},  //   écis, maul_, _dbal,
  { {0x61ed002d, 0xb5fd0142, 0xdfd20025, 0x00000000}},  //   _ebal, košk, بيس_,
  { {0x44271567, 0x81b90044, 0xb5fd0166, 0x00000000}},  //   _ion_, _চার_, jošk,
  { {0x44271568, 0x78a90224, 0x3d060061, 0x00000000}},  //   _hon_, _otev, हटले_,
  { {0x44271569, 0xec4a007c, 0x0c260088, 0x00000000}},  // [2940] _kon_, азал_, оман,
  { {0x4427156a, 0x69c90145, 0x61ed156b, 0x00000000}},  //   _jon_, _adee, _zbal,
  { {0x4427028c, 0x290d130f, 0xb5fd0bf8, 0x00000000}},  //   _mon_, _area_, gošk,
  { {0x44270011, 0x290d0a49, 0x38c802fd, 0x00000000}},  //   _lon_, _brea_, ماتی_,
  { {0xb05b0444, 0x442700b0, 0x69c90045, 0x00000000}},  //   isän, _oon_, _ddee,
  { {0x442705d3, 0x764b018e, 0x290d012d, 0x00000000}},  //   _non_, _amgy, _drea_,
  { {0xab2a0017, 0xd6d00025, 0x3e480035, 0x00000000}},  //   _това_, رقة_, eşti_,
  { {0x4427002a, 0xcf93009b, 0x7d09012d, 0x00000000}},  //   _aon_, וטו_, _šesi,
  { {0x4427156c, 0xe4e601fb, 0x25eb0061, 0x00000000}},  //   _bon_, ційн, _अउरी_,
  { {0x4427156d, 0x44e2009f, 0x61ed04b8, 0x00000000}},  //   _con_, rð_, _sbal,
  { {0x4427156e, 0xd251007a, 0x2be20204, 0x00000000}},  //   _don_, فند_, _पाना,
  { {0x9258007c, 0x25bf00e5, 0x00000000, 0x00000000}},  //   жают_, caul_,   ,
  { {0x442701aa, 0xc21801fb, 0x855603ec, 0x00000000}},  //   _fon_, ією_, _بخاط,
  { {0x9f4c004f, 0x4427156f, 0xdb1e00c4, 0x00000000}},  //   ždý_, _gon_, rapê,
  { {0x764b018e, 0xb6060521, 0x7ae50045, 0x00000000}},  //   _ymgy, pašć, xtht,
  { {0x61ed0020, 0xc7b80166, 0x7c270009, 0x00000000}},  //   _ubal, _dođi_, _sojr,
  { {0x44270607, 0x2d8f001f, 0x645a1570, 0x00000000}},  // [2950] _yon_, äge_, onti,
  { {0x645a1571, 0x44270f1d, 0xb5fd1572, 0x00000000}},  //   nnti, _xon_, tošk,
  { {0x645a00b0, 0x443e01a2, 0xdefb007e, 0x00000000}},  //   inti, iht_, _тып_,
  { {0x290d000d, 0xb5fd01d9, 0xf9c701fb, 0x00000000}},  //   _prea_, rošk, іщен,
  { {0x8d8702be, 0xf99003ec, 0x443e0982, 0x00000000}},  //   _фунд, نبه_, kht_,
  { {0x290d000d, 0x2be20061, 0x09340025, 0x00000000}},  //   _vrea_, _पाया, برمج,
  { {0x4427000d, 0x2b570014, 0x7ac4005c, 0x00000000}},  //   _ron_, _بیاد_, _осте,
  { {0x682f02cc, 0x569200ec, 0x443e010f, 0x00000000}},  //   _nødv, најт, eht_,
  { {0x442701a3, 0x290d0300, 0xb5fd10d9, 0x00000000}},  //   _pon_, _urea_, noši,
  { {0x443e0866, 0x645a00ea, 0x00000000, 0x00000000}},  //   ght_, gnti,   ,
  { {0x442708ba, 0xdb0e010f, 0xa8220014, 0x00000000}},  //   _von_, _gebä, _سکون,
  { {0xfc3f1573, 0x645a0006, 0x442700ab, 0x00000000}},  //   _stíl_, anti, _won_,
  { {0x4427028c, 0xb05b04ce, 0xb5fd0089, 0x00000000}},  //   _ton_, rsän, joši,
  { {0x443e1574, 0xc7b80107, 0x9f5a0197, 0x00000000}},  //   cht_, _pođi_, _papà_,
  { {0xe7ed0365, 0xfbd200a1, 0x25bd00e0, 0x00000000}},  //   च्या_, ہتا_, _kewl_,
  { {0x9f4b0010, 0x00000000, 0x00000000, 0x00000000}},  //   áját_,   ,   ,
  { {0xdb1c00c4, 0x229a0089, 0x629600e0, 0x00000000}},  // [2960] _gerê, _rīki_, _iiyo,
  { {0x6296047b, 0x9f580023, 0x00000000, 0x00000000}},  //   _hiyo, nerë_,   ,
  { {0xeb970088, 0x62961575, 0x628400ea, 0x00000000}},  //   чих_, _kiyo, _khio,
  { {0xdb1c0065, 0x9f580065, 0x628701dc, 0x00000000}},  //   _herë, herë_, ňkov,
  { {0x645a1576, 0x62840051, 0x6e240d16, 0x00000000}},  //   ynti, _mhio, mjib,
  { {0x9f580023, 0x00000000, 0x00000000, 0x00000000}},  //   jerë_,   ,   ,
  { {0x81d40055, 0xe3c30044, 0x8f9b00a3, 0x00000000}},  //   স্য_, ্ভাব, זיצי,
  { {0x645a0b78, 0x6296011c, 0x6e360006, 0x00000000}},  //   wnti, _niyo, nkyb,
  { {0x6d440198, 0xa3d70061, 0x682f08c8, 0x00000000}},  //   nzia, िलं_, _rødv,
  { {0x81b90055, 0x7bde1577, 0x53340478, 0x00000000}},  //   _চাই_, ngpu, деот,
  { {0x62961578, 0xddcd00b9, 0x645a00f8, 0x00000000}},  //   _biyo, hlaš, rnti,
  { {0x443e048a, 0x6284111b, 0xa77b0049, 0x00000000}},  //   sht_, _chio, _פראפ,
  { {0x6296034f, 0x443e0658, 0x62840048, 0x00000000}},  //   _diyo, pht_, _dhio,
  { {0x6d441579, 0xc95300b6, 0xc05b0451, 0x00000000}},  //   dzia, תמש_, сім_,
  { {0x6284002a, 0x7e6d0161, 0x9f5a008e, 0x00000000}},  //   _fhio, toap, _papá_,
  { {0x337700b6, 0x443c0011, 0xb5fd0089, 0x00000000}},  //   _מתוך_, _hlv_, toši,
  { {0x7e6d000d, 0xddcd0ce4, 0x8d770025, 0x00000000}},  // [2970] roap, glaš, سارا,
  { {0x62960288, 0x7e6d0035, 0x7a33026d, 0x00000000}},  //   _ziyo, soap, _içti,
  { {0x3cf903d7, 0x539b0104, 0x443c00d9, 0x00000000}},  //   _उनके_, ציאו, _mlv_,
  { {0xddcd0059, 0x6e3602d4, 0xdb1c00f6, 0x00000000}},  //   blaš, ckyb, _merè,
  { {0x8c3b001f, 0x998400b9, 0x443c01c3, 0x00000000}},  //   _auße, _domů_, _olv_,
  { {0x66ea005f, 0xe8f8007e, 0x7d0d0232, 0x00000000}},  //   _təkl, ялі_, mvas,
  { {0x7d0d157a, 0x00000000, 0x00000000, 0x00000000}},  //   lvas,   ,   ,
  { {0x7d0d0784, 0x443c00b0, 0x00000000, 0x00000000}},  //   ovas, _alv_,   ,
  { {0x7d0d00b0, 0x3a84007e, 0x58d4157b, 0x00000000}},  //   nvas, _чырв, _потт,
  { {0x62961338, 0x62840048, 0xdb1c000a, 0x00000000}},  //   _siyo, _shio, _berè,
  { {0x6fd70061, 0xcfe30055, 0xb05b0039, 0x00000000}},  //   _बाजू, য়ান, rsäl,
  { {0x1c0a001c, 0x5eac0055, 0x443c121b, 0x00000000}},  //   _होईल_, _ছিলে, _elv_,
  { {0xd012026c, 0xdb1c008d, 0xdb1e008e, 0x00000000}},  //   پلز_, _perë, rapé,
  { {0x4095029b, 0x6609022b, 0xddcd0107, 0x00000000}},  //   ерст, ldek, vlaš,
  { {0xdee301fb, 0x6284002a, 0x6441056f, 0x00000000}},  //   кори, _thio, mhli,
  { {0x6609011f, 0x6d44022b, 0x7c3c00e0, 0x00000000}},  //   ndek, tzia, _slrr,
  { {0x15e202fb, 0x7d0d12c3, 0x6e240022, 0x00000000}},  // [2980] क्टर_, gvas, rjib,
  { {0x6d440207, 0x26c7089f, 0x443c00f6, 0x00000000}},  //   rzia, ksno_, _xlv_,
  { {0x7d0d157c, 0xf0930104, 0xdb051259, 0x00000000}},  //   avas, _שנת_, nchè,
  { {0xddcd0089, 0x8c48005f, 0xceb300b3, 0x00000000}},  //   plaš, _başç, _שיר_,
  { {0x81cb0055, 0x66090066, 0x81d40044, 0x00000000}},  //   র্ক_, ddek, স্থ_,
  { {0x76aa0d51, 0x9f5801aa, 0x645d009d, 0x00000000}},  //   отив_, terè_, ésil,
  { {0x6441157d, 0x8c3b010f, 0x66ea006b, 0x00000000}},  //   dhli, _fußb, _təkm,
  { {0x81d40055, 0xa3b00164, 0x66090058, 0x00000000}},  //   স্ত_, टुन_, gdek,
  { {0x6ad30044, 0x69c00089, 0xb7bc0089, 0x00000000}},  //   _সহযো, _ieme, _loģi,
  { {0x69c0022b, 0x644100ab, 0x682f01e3, 0x00000000}},  //   _heme, ghli, _døds,
  { {0x69c0020c, 0xbbd70097, 0x3946004a, 0x00000000}},  //   _keme, וויץ_, lzos_,
  { {0x78a001dd, 0x682f01e3, 0x69c01303, 0x00000000}},  //   _kumv, _føds, _jeme,
  { {0x69c0020c, 0x3946157e, 0x656f010f, 0x00000000}},  //   _meme, nzos_, ücht,
  { {0x6441001f, 0x69c00010, 0xbe0500a1, 0x00000000}},  //   chli, _leme, کورٹ,
  { {0xfe730188, 0x3267005e, 0x9f410197, 0x00000000}},  //   ندر_, _отив, _xchè_,
  { {0x27e9037e, 0x69c0157f, 0xe508001d, 0x00000000}},  //   đani_, _neme, _kỷ_,
  { {0x6a78045b, 0xddc40514, 0xa2da0201, 0x00000000}},  // [2990] cífi, bliž, पूर्,
  { {0x61fd1580, 0x244001aa, 0x6609014a, 0x00000000}},  //   lesl, _fòme_, zdek,
  { {0x3ce91581, 0x69c01582, 0x2904008a, 0x00000000}},  //   stav_, _beme, _asma_,
  { {0xfe35007b, 0x61fd1556, 0x78a00009, 0x00000000}},  //   _נאָך_, nesl, _bumv,
  { {0x69c00483, 0xadd6019b, 0x78a0001a, 0x00000000}},  //   _deme, _אורח_, _cumv,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x69c0000d, 0x7bc5011c, 0x660900b5, 0x00000000}},  //   _feme, mahu, tdek,
  { {0x69c0037f, 0x7bc51583, 0xd90e026c, 0x00000000}},  //   _geme, lahu, جیے_,
  { {0x6609033b, 0x64410124, 0x29040087, 0x00000000}},  //   rdek, thli, _gsma_,
  { {0x69c0001e, 0xc9840072, 0x7bc5036b, 0x00000000}},  //   _zeme, _руси, nahu,
  { {0x69c0011f, 0x35b501fb, 0x69cc00b9, 0x00000000}},  //   _yeme, _збер, ůlež,
  { {0xcb12007b, 0x61fd00c7, 0x683404bd, 0x00000000}},  //   אלט_, gesl, _ràdi,
  { {0x7bc5011c, 0x25b9000c, 0x6d5b0079, 0x00000000}},  //   kahu, ðslu_, _žuan,
  { {0xf8b2009b, 0x6a781261, 0x7bc5010e, 0x00000000}},  //   רשם_, rífi, jahu,
  { {0x3a3f014a, 0x5e960025, 0x61fd002d, 0x00000000}},  //   _olup_, فلسط, besl,
  { {0x61e4041a, 0x2be20061, 0x66ea006b, 0x00000000}},  //   _ucil, _पाहा, _səkk,
  { {0xc692061e, 0x8fa601e1, 0x7afb01a8, 0x00000000}},  // [29a0] ראן_, _папе, _ćuta,
  { {0x69c01584, 0x09d80061, 0x7bc50eb0, 0x00000000}},  //   _seme, डल्य, gahu,
  { {0x69c004fa, 0x4fbb00a0, 0x3a2d01c3, 0x00000000}},  //   _peme, _מציא, _boep_,
  { {0x4ad10061, 0xc9861585, 0x0f570097, 0x00000000}},  //   _हिरव, нули, _טיים_,
  { {0x7bc50058, 0xa3cf0309, 0x69c00065, 0x00000000}},  //   bahu, षणा_, _veme,
  { {0x26dc0556, 0x39461586, 0x69c00168, 0x00000000}},  //   tuvo_, rzos_, _weme,
  { {0x8c1b007b, 0x316c0046, 0x81cb0055, 0x00000000}},  //   _צולי, ędzy_, র্ট_,
  { {0x7c2e0190, 0x9b17009b, 0x3a3f0091, 0x00000000}},  //   _hobr, _אחלה_, _glup_,
  { {0x7c2e002d, 0xb21b0030, 0x61fd1587, 0x00000000}},  //   _kobr, llæg, vesl,
  { {0xb806026c, 0xb05b0039, 0x73380216, 0x00000000}},  //   _سکتے_, rsäk, дзор_,
  { {0xb21b0f4b, 0x22400168, 0xe1ff0051, 0x00000000}},  //   nlæg, _blik_, nnóg_,
  { {0xe508001d, 0x60dd03b6, 0x22401588, 0x00000000}},  //   _tỷ_, tusm, _clik_,
  { {0xdb051321, 0x7bc50020, 0xe5080011, 0x00000000}},  //   rché, yahu, _uỷ_,
  { {0x7c2e1589, 0x61fd006b, 0xb4be0061, 0x00000000}},  //   _nobr, sesl, ेळी_,
  { {0x60dd006c, 0xddc40036, 0xb5fd0091, 0x00000000}},  //   susm, bliż, pošt,
  { {0x442e037f, 0xb21b0030, 0x7bc50020, 0x00000000}},  //   _hof_, dlæg, wahu,
  { {0x7bc5020c, 0x442e158a, 0x3a2d07a5, 0x00000000}},  // [29b0] tahu, _kof_, _roep_,
  { {0xddeb007a, 0xe1ff158b, 0x3a2d00bb, 0x00000000}},  //   _کرده_, leó_, _soep_,
  { {0x442e0145, 0x3a2d0116, 0x00000000, 0x00000000}},  //   _mof_, _poep_,   ,
  { {0x442e01d6, 0x7bc50428, 0x60cd00ea, 0x00000000}},  //   _lof_, sahu, _kvam,
  { {0xbddb0129, 0x26cc0521, 0x7bc50058, 0x00000000}},  //   _elèc, _avdo_, pahu,
  { {0x81cb0055, 0xbddb03eb, 0x46f50088, 0x00000000}},  //   র্চ_, _flèc, вчит,
  { {0x1c0a03d7, 0xaa59158c, 0xddcd0036, 0x00000000}},  //   _होटल_, _живу_, miał,
  { {0x7c2e0428, 0x60cd04eb, 0x9f4a00ea, 0x00000000}},  //   _zobr, _ovam, rebø_,
  { {0xe1ff0010, 0x98f4002c, 0x26cc0022, 0x00000000}},  //   deó_, _مثلا, _evdo_,
  { {0x22400292, 0x442e0016, 0xddcd0036, 0x00000000}},  //   _slik_, _cof_, niał,
  { {0xb21b0f4b, 0x60cd006c, 0x22400036, 0x00000000}},  //   klæd, _avam, _plik_,
  { {0x442e158d, 0x6b9a000c, 0x27e90521, 0x00000000}},  //   _eof_, _útge, đanu_,
  { {0xa509158e, 0xf1bf0047, 0xdd0100b9, 0x00000000}},  //   _цела_, pján_, čtět,
  { {0xd4790049, 0x628f0ace, 0x660b000c, 0x00000000}},  //   _קאַל, amco, _hagk,
  { {0xe456007b, 0x7c2e1089, 0x60cd0f4a, 0x00000000}},  //   _ביסט_, _robr, _evam,
  { {0x7c2e00d6, 0xb17b0039, 0x22400056, 0x00000000}},  //   _sobr, mgån, _ulik_,
  { {0xed570113, 0x660b006a, 0xdca301e0, 0x00000000}},  // [29c0] вот_, _magk, иати,
  { {0x14d40061, 0x213701ce, 0x660b02e7, 0x00000000}},  //   _दिसण, _סטיל_, _lagk,
  { {0x9f4800b0, 0x8b9606e7, 0x403b00b3, 0x00000000}},  //   ähän_, трач, _חגיג,
  { {0xb21b158f, 0x660b006a, 0x7c2e0016, 0x00000000}},  //   rlæg, _nagk, _wobr,
  { {0xd94601e0, 0x61f6008d, 0xd8380107, 0x00000000}},  //   ъеди, _mbyl, _liče_,
  { {0xddcd0036, 0x98730451, 0x7c2e0107, 0x00000000}},  //   ciał, аліц, _uobr,
  { {0x442000ad, 0xd8380107, 0x442e1590, 0x00000000}},  //   _đi_, _niče_, _rof_,
  { {0x442e0173, 0x261901f5, 0xb17b0039, 0x00000000}},  //   _sof_, भागी_, dgån,
  { {0x2ca6002a, 0x442e0638, 0x57ea00ed, 0x00000000}},  //   íodh_, _pof_, _одам_,
  { {0x6a780325, 0xe9670467, 0x683400f6, 0x00000000}},  //   rífu, _раул_, _pàdu,
  { {0x60cd01bf, 0x660b0292, 0x442e00bb, 0x00000000}},  //   _svam, _fagk, _vof_,
  { {0x7d0406a9, 0xddcd0036, 0xd838016c, 0x00000000}},  //   kwis, ział, _diče_,
  { {0x442e00bb, 0x628f00bb, 0x6a78000c, 0x00000000}},  //   _tof_, rmco, lífs,
  { {0x6e2f0082, 0x66001591, 0x7d040544, 0x00000000}},  //   _socb, lemk, dwis,
  { {0x67380010, 0x7afb012d, 0xbcfb00f6, 0x00000000}},  //   nyvj, _ćuto, _txék,
  { {0x30a70a1e, 0x6d0e0309, 0xddcd0036, 0x00000000}},  //   _иров, सिंग_, wiał,
  { {0xd90406c6, 0x2d5805c7, 0x2259080a, 0x00000000}},  // [29d0] _بی_, вить_, misk_,
  { {0x764207be, 0x225905ad, 0x61f6013e, 0x00000000}},  //   _lloy, lisk_, _zbyl,
  { {0xddcd0036, 0x98b80089, 0x0ba41592, 0x00000000}},  //   riał, _ārā_, ршум,
  { {0x225901c4, 0x629e00f4, 0x7d040058, 0x00000000}},  //   nisk_, _épou, bwis,
  { {0x4dda019b, 0xdb1c0f6e, 0xa3e20061, 0x00000000}},  //   _אחרו, _cerâ, धला_,
  { {0x764200e7, 0x660b1593, 0xd3660439, 0x00000000}},  //   _aloy, _sagk, _هه_,
  { {0x660b0811, 0x63ba0009, 0x225902e1, 0x00000000}},  //   _pagk, dbtn, kisk_,
  { {0xf5090d03, 0x3eb30082, 0x9f9c009b, 0x00000000}},  //   енил_, _mtxt_, וסופ,
  { {0x2259004e, 0x03a5017f, 0x79ea00a1, 0x00000000}},  //   disk_, липо, _سولہ_,
  { {0x58870783, 0x7642000a, 0x2c1c013d, 0x00000000}},  //   _рыба, _eloy, नाएं_,
  { {0x7d041594, 0xc735035b, 0x225901e3, 0x00000000}},  //   zwis, _حفاظ, fisk_,
  { {0x2259080a, 0x7d040036, 0xb17b0039, 0x00000000}},  //   gisk_, ywis, rgån,
  { {0x3eb30009, 0x25ad1595, 0x00000000, 0x00000000}},  //   _atxt_, mcel_,   ,
  { {0xdb1c0e7c, 0xd8381000, 0x25ad008e, 0x00000000}},  //   _serí, _tiče_, lcel_,
  { {0xdb1c1596, 0x3eb30009, 0x2259043e, 0x00000000}},  //   _perí, _ctxt_, bisk_,
  { {0x25ad0284, 0x6d41005f, 0x7d0400b5, 0x00000000}},  //   ncel_, _əlav, twis,
  { {0xdb1c0142, 0x00000000, 0x00000000, 0x00000000}},  // [29e0] _verí,   ,   ,
  { {0x7d040046, 0xc0060256, 0x660006b8, 0x00000000}},  //   rwis, _спок, zemk,
  { {0xe9da0140, 0x7d0401a2, 0x660000e7, 0x00000000}},  //   еке_, swis, yemk,
  { {0x66ea005f, 0x61e604be, 0x9f580c42, 0x00000000}},  //   _məkt, ngkl, merà_,
  { {0x9f580197, 0x00000000, 0x00000000, 0x00000000}},  //   lerà_,   ,   ,
  { {0xdcfd0089, 0x6d48006b, 0x7e6400ca, 0x00000000}},  //   _uzsā, _ədal, lnip,
  { {0xf1ba001d, 0x9f580197, 0x66001597, 0x00000000}},  //   _đơn_, nerà_, temk,
  { {0x9634025f, 0x7e64006c, 0xfb1b00b3, 0x00000000}},  //   рниц, nnip, _אולמ,
  { {0x89660454, 0xc966008b, 0x8886025f, 0x00000000}},  //   _скаж, _свай, _блаж,
  { {0x26190061, 0x5454005e, 0xb05b1598, 0x00000000}},  //   _मोठी_, рвот, nsät,
  { {0xa3e50183, 0x225901c4, 0xb8930025, 0x00000000}},  //   _फार_, tisk_, _اللع,
  { {0x9f580207, 0xbb3b0049, 0x6443007f, 0x00000000}},  //   derà_, געטי, _elni,
  { {0x225901c4, 0xf1bf0010, 0xe3af0014, 0x00000000}},  //   risk_, lják_, غری_,
  { {0x2259080a, 0x3394007e, 0x00000000, 0x00000000}},  //   sisk_, _калё,   ,
  { {0x645a006a, 0x21390065, 0x225911b6, 0x00000000}},  //   miti, sysh_, pisk_,
  { {0x442c1599, 0x443e159a, 0xdb0e013f, 0x00000000}},  //   ljd_, lkt_, _debü,
  { {0xdc55098c, 0x5d99007e, 0x26c10010, 0x00000000}},  // [29f0] авањ, ткаў_, ához_,
  { {0xe7e00201, 0x68e20006, 0xb05b0039, 0x00000000}},  //   _नागप, duod, gsät,
  { {0x443e159b, 0xcb55012b, 0xdb0e010f, 0x00000000}},  //   ikt_, јвећ, _gebü,
  { {0xdb1c02d5, 0x39150057, 0x645a0020, 0x00000000}},  //   _serã, имер, hiti,
  { {0x645a0020, 0x628d131d, 0xfc3f0051, 0x00000000}},  //   kiti, _mhao, _dtír_,
  { {0x645a1089, 0x443e02ae, 0x7c3e06d3, 0x00000000}},  //   jiti, jkt_, ckpr,
  { {0x645a0038, 0xfc3f0211, 0x6a78049a, 0x00000000}},  //   diti, _guía_, rífr,
  { {0x6e2d023a, 0xceb40097, 0xea63026c, 0x00000000}},  //   njab, זיק_, _اپری,
  { {0xdb1c0181, 0x69cb0866, 0x7bc7003f, 0x00000000}},  //   _terã, mage, _keju,
  { {0x69cb06d3, 0x6448120b, 0x7bc7159c, 0x00000000}},  //   lage, ghdi, _jeju,
  { {0x20030802, 0x38ab0030, 0x60dd00bb, 0x00000000}},  //   deji_, _hør_, ersm,
  { {0x628d0051, 0x69cb0038, 0x7bc71308, 0x00000000}},  //   _chao, nage, _leju,
  { {0x645a159d, 0x628d002a, 0x9f58159e, 0x00000000}},  //   biti, _dhao, derá_,
  { {0x443e001f, 0x69cb0030, 0x9f58159f, 0x00000000}},  //   ckt_, hage, terà_,
  { {0x7e56004c, 0x69cb01e3, 0x38ab0737, 0x00000000}},  //   атац, kage, _lør_,
  { {0x628d0051, 0x9f580cdd, 0xfe43053f, 0x00000000}},  //   _ghao, rerà_, онсо,
  { {0x69cb0239, 0xb05b09f0, 0x753b0dfc, 0x00000000}},  // [2a00] dage, tsät, nyuz,
  { {0x9f580197, 0xdb1c0051, 0x628d02d4, 0x00000000}},  //   perà_, _aerá, _zhao,
  { {0x9f5815a0, 0xb05b0a5d, 0x69cb0190, 0x00000000}},  //   berá_, rsät, fage,
  { {0x645a000d, 0x9f58029d, 0xfce6025f, 0x00000000}},  //   ziti, cerá_, _комо,
  { {0x394015a1, 0x443e0056, 0x7bc70023, 0x00000000}},  //   áis_, ykt_, _feju,
  { {0xf1bf0047, 0x2c1c013d, 0x26dc01a8, 0x00000000}},  //   tják_, नाओं_, trvo_,
  { {0x645a15a2, 0x12e00044, 0x78ab0009, 0x00000000}},  //   viti, _বন্দ, aqgv,
  { {0x2619007d, 0x38ab02cc, 0x69cb15a3, 0x00000000}},  //   _मोदी_, _før_, cage,
  { {0x38ab0018, 0x645a15a4, 0xd9430aed, 0x00000000}},  //   _gør_, titi, _дети,
  { {0x628d002a, 0x443e0089, 0x26dc016c, 0x00000000}},  //   _shao, ukt_, prvo_,
  { {0x645a15a5, 0x443e15a6, 0xd5af004d, 0x00000000}},  //   riti, rkt_, _мс_,
  { {0x443e15a7, 0x60dd0009, 0x7649000a, 0x00000000}},  //   skt_, trsm, chey,
  { {0x645a000b, 0x9f580181, 0xc05b01fb, 0x00000000}},  //   piti, verá_, вів_,
  { {0x02a601fb, 0x69cb0181, 0xc05b0088, 0x00000000}},  //   _крим, zage, тім_,
  { {0x69cb00f4, 0xa2e301f9, 0x44f000f4, 0x00000000}},  //   yage, _дојд, là_,
  { {0x7bc70169, 0xb05b00b0, 0x69cb00c4, 0x00000000}},  //   _seju, tsäs, xage,
  { {0x629f00f4, 0x69cb15a8, 0xdb1e006c, 0x00000000}},  // [2a10] _époq, vage, hapä,
  { {0xdb1c0211, 0x69cb010f, 0x6d4d00b5, 0x00000000}},  //   _será, wage, rzaa,
  { {0x69cb04d7, 0x38ab0056, 0x6486000c, 0x00000000}},  //   tage, _sør_, yðin,
  { {0xceb200bd, 0xbddb0173, 0xe0df0026, 0x00000000}},  //   _מיט_, _klèm, orò_,
  { {0x69cb15a6, 0xdb1c064d, 0xe9d8007e, 0x00000000}},  //   rage, _verá, ркі_,
  { {0x69cb15a9, 0xdb050051, 0x44f000d4, 0x00000000}},  //   sage, achá, dà_,
  { {0x69cb0061, 0xb9e70088, 0x61ed00b4, 0x00000000}},  //   page, _візи, _ocal,
  { {0x81cc0044, 0x683d0129, 0x38ab0030, 0x00000000}},  //   _লাভ_, _mèdi, _tør_,
  { {0x6486009f, 0x79800016, 0xf8070088, 0x00000000}},  //   rðin, _gymw, _вчен,
  { {0x69c900bb, 0xe0df0197, 0x61ed0d7b, 0x00000000}},  //   _heee, drò_, _acal,
  { {0x78a90211, 0x9f580129, 0x60c400ab, 0x00000000}},  //   _huev, merç_, _swim,
  { {0x66ea006b, 0x78a115aa, 0x69c9016e, 0x00000000}},  //   _təkr, _hilv, _jeee,
  { {0x78a915ab, 0x69c90a9d, 0xf6740a4f, 0x00000000}},  //   _juev, _meee, _بالخ,
  { {0x78a90211, 0xf1bf0181, 0x69c901ee, 0x00000000}},  //   _muev, abá_, _leee,
  { {0x7ae5006c, 0x3e860025, 0xf1bf0010, 0x00000000}},  //   juht, مشرف, bbá_,
  { {0x25bf011f, 0xf8a5007a, 0x64410fcf, 0x00000000}},  //   nbul_, _يک_, lkli,
  { {0x78a90219, 0x644115ac, 0x925a0123, 0x00000000}},  // [2a20] _nuev, okli, _لشکر_,
  { {0x09d00061, 0x64410aba, 0xdd8f1095, 0x00000000}},  //   हण्य, nkli, رول_,
  { {0xb09b009b, 0xd91000a1, 0x7c350b4a, 0x00000000}},  //   _תייר, ڈیز_, _dozr,
  { {0xd91004e1, 0x61ed01f3, 0x281900a1, 0x00000000}},  //   ویز_, _xcal, یفنگ_,
  { {0x627b007b, 0x6441002b, 0x78a9008e, 0x00000000}},  //   ננננ, kkli, _cuev,
  { {0x78a1001e, 0x69c90045, 0xfc4400a1, 0x00000000}},  //   _cilv, _eeee, _بھرپ,
  { {0x1ae30264, 0x22420145, 0x569401bd, 0x00000000}},  //   _норм, kkkk_, оакт,
  { {0x44f00409, 0x44b401fb, 0xbb3b0049, 0x00000000}},  //   tà_, обис, _געלי,
  { {0x7afb0107, 0xdb1c00c4, 0x78a115ad, 0x00000000}},  //   _ćuti, _berç, _filv,
  { {0x44f015ae, 0x61ed085d, 0xe0df0197, 0x00000000}},  //   rà_, _scal, vrò_,
  { {0x6d41005f, 0xd764026c, 0x44f000d4, 0x00000000}},  //   _əlaq, _بنای, sà_,
  { {0x64410007, 0x3ea20036, 0xe0df0197, 0x00000000}},  //   akli, _nikt_, trò_,
  { {0xdb1c00b0, 0x644115af, 0xf5960025, 0x00000000}},  //   _herä, bkli, _الشج,
  { {0x64410073, 0xdb1c15b0, 0xe0df0197, 0x00000000}},  //   ckli, _gerç, rrò_,
  { {0xc05801e1, 0x7c3515b1, 0xce6b005e, 0x00000000}},  //   сія_, _rozr, град_,
  { {0x4caa0055, 0xe0df0026, 0x61ed006b, 0x00000000}},  //   _চৌধু, prò_, _ucal,
  { {0x7c350027, 0x69c915b2, 0x3ea215b3, 0x00000000}},  // [2a30] _pozr, _reee, _dikt_,
  { {0x4d9804af, 0x69c915b4, 0x99ba0044, 0x00000000}},  //   скую_, _seee, ুলোক,
  { {0xa91d0087, 0x69c9004a, 0x22490eff, 0x00000000}},  //   _izži, _peee, _klak_,
  { {0x78a10335, 0x3a2400fa, 0x7ae50943, 0x00000000}},  //   _silv, _cnmp_, ruht,
  { {0x78a115b5, 0xbcfb0181, 0x7ae50103, 0x00000000}},  //   _pilv, _exér, suht,
  { {0x8aa70216, 0xdb1c0073, 0xdd310036, 0x00000000}},  //   _град, _berä, zęśc,
  { {0x81d408b7, 0x78a100d9, 0x78bc016c, 0x00000000}},  //   স্ট_, _vilv, _črve,
  { {0xd8380087, 0xb05b01a2, 0x00000000, 0x00000000}},  //   _fičo_, lpäd,   ,
  { {0x89370123, 0x78a115b6, 0x64410039, 0x00000000}},  //   _اعزا, _tilv, tkli,
  { {0x99480025, 0x224915b7, 0x7d0f0009, 0x00000000}},  //   _الكل_, _alak_, _mscs,
  { {0x644115b8, 0xdb1c010f, 0xb21b0030, 0x00000000}},  //   rkli, _gerä, rlæn,
  { {0x81e20055, 0x7d0f0061, 0x6441006c, 0x00000000}},  //   ন্ন_, _oscs, skli,
  { {0xdb1c0181, 0x3ea202e1, 0xbddb0173, 0x00000000}},  //   _terç, _rikt_, _elèk,
  { {0x224915b9, 0x3ea20479, 0x2d8201d6, 0x00000000}},  //   _elak_, _sikt_, _ryke_,
  { {0x03250088, 0x22490ce3, 0x7d1d00d9, 0x00000000}},  //   _єдин, _flak_, _arss,
  { {0x3f840089, 0x00e6058e, 0x00000000, 0x00000000}},  //   āmu_, _джин,   ,
  { {0x3ea20039, 0x2cb901c3, 0x00000000, 0x00000000}},  // [2a40] _vikt_, _ctsd_,   ,
  { {0x628606d3, 0x3942006c, 0x2cb90082, 0x00000000}},  //   llko, _üksi_, _dtsd_,
  { {0x6da60200, 0xe7ed01f5, 0x3ea20089, 0x00000000}},  //   _мина, च्छा_, _tikt_,
  { {0x387e0022, 0x00000000, 0x00000000, 0x00000000}},  //   _sktr_,   ,   ,
  { {0xa3e90183, 0x00000000, 0x00000000, 0x00000000}},  //   यला_,   ,   ,
  { {0xd6da103e, 0xdb1c00b0, 0x00000000, 0x00000000}},  //   ати_, _perä,   ,
  { {0x27e0011f, 0x81e20055, 0xdca301fc, 0x00000000}},  //   ğin_, ন্য_, _цари,
  { {0xdb1c010f, 0x27e00279, 0xa5340603, 0x00000000}},  //   _verä, şin_, знич,
  { {0xd4060242, 0x69c20116, 0x746a007c, 0x00000000}},  //   ояни, mboe, иров_,
  { {0x81e20055, 0xb3540088, 0x69c215ba, 0x00000000}},  //   ন্ম_, зкош, lboe,
  { {0x2249083a, 0x683d00f6, 0x68e40048, 0x00000000}},  //   _plak_, _cèdu, áidf,
  { {0x64a615bb, 0x69c200b5, 0x27fe0009, 0x00000000}},  //   _дада, nboe, _hbtn_,
  { {0x1a9b007b, 0xba9b012f, 0x2beb0164, 0x00000000}},  //   ייטע, יסטי, _चालू_,
  { {0x9f5a01aa, 0x74140014, 0x27fe0145, 0x00000000}},  //   _rapò_, _روبا, _jbtn_,
  { {0x22490161, 0xd8380cd6, 0x69c20116, 0x00000000}},  //   _tlak_, _moč_, kboe,
  { {0x68e20006, 0xa91d00b9, 0x5f940545, 0x00000000}},  //   krod, _lyža, фист,
  { {0xa3ae03d7, 0x5d550113, 0xfbab041f, 0x00000000}},  // [2a50] _कला_, чкат, атей_,
  { {0x68e210fd, 0x64dd0061, 0xd8380059, 0x00000000}},  //   drod, _मिसळ, _noč_,
  { {0xb5fd15bc, 0x00000000, 0x00000000, 0x00000000}},  //   liše,   ,   ,
  { {0xc333007b, 0x69c200c7, 0x244001aa, 0x00000000}},  //   ווע_, gboe, _dòmi_,
  { {0x2ca302ae, 0x68e20036, 0x7d1d0068, 0x00000000}},  //   _tijd_, grod, _urss,
  { {0x9f580026, 0x7d0d00e7, 0x387c016c, 0x00000000}},  //   ffrè_, mwas, govr_,
  { {0x3ffc007b, 0x4429001d, 0x7d0d15bd, 0x00000000}},  //   יפגע, _đa_, lwas,
  { {0x68e207ac, 0xecdf03d7, 0x7d0d00e7, 0x00000000}},  //   brod, _फटाफ, owas,
  { {0xdb05001f, 0x81e20055, 0x68e204d2, 0x00000000}},  //   schä, ন্ড_, crod,
  { {0x7d0d0058, 0x67f4000c, 0x00000000, 0x00000000}},  //   iwas, rþjó,   ,
  { {0x59cf0309, 0x7d0d15be, 0x5884007e, 0x00000000}},  //   _हजार, hwas, _цыта,
  { {0x80b30044, 0xdb120010, 0xdb070065, 0x00000000}},  //   _জিজ্, égév, _agjë,
  { {0xa5670014, 0x271c0011, 0x660915bf, 0x00000000}},  //   _بدان, _ảnh_, meek,
  { {0x660915c0, 0xdb15010f, 0x3af500f8, 0x00000000}},  //   leek, _bezü, kåp_,
  { {0x442715c1, 0x00000000, 0x00000000, 0x00000000}},  //   _inn_,   ,   ,
  { {0x7d0d15c2, 0xdd920025, 0x7c270022, 0x00000000}},  //   fwas, فوز_, _anjr,
  { {0x7d0d15c3, 0x00000000, 0x00000000, 0x00000000}},  // [2a60] gwas,   ,   ,
  { {0x8b960517, 0x4c8315c4, 0xac830264, 0x00000000}},  //   преч, елув, егул,
  { {0x442701f3, 0x103b009b, 0x69c20112, 0x00000000}},  //   _mnn_, _הגיע, tboe,
  { {0xdca60265, 0x7d0d097e, 0x2018000c, 0x00000000}},  //   _нами, bwas, ldri_,
  { {0x291f0051, 0xb05b006c, 0x69c201b5, 0x00000000}},  //   _crua_, späe, rboe,
  { {0x68e2005b, 0x69c20112, 0xb17b15c5, 0x00000000}},  //   rrod, sboe, mgåt,
  { {0xa09b01ce, 0x7bdc0093, 0xe73700ec, 0x00000000}},  //   זיסט, _idru, зеј_,
  { {0x442715c6, 0x81e20055, 0x54b80242, 0x00000000}},  //   _ann_, ন্ত_, огия_,
  { {0x7bce0149, 0x48e30849, 0x291f0065, 0x00000000}},  //   _kebu, _потв, _grua_,
  { {0xb5fd0ce4, 0x200a11af, 0x29040087, 0x00000000}},  //   više, jebi_, _ipma_,
  { {0x67bb009b, 0x44270082, 0x66090032, 0x00000000}},  //   _המבק, _dnn_, beek,
  { {0x442705d1, 0x7bce0f4d, 0xb5fd012d, 0x00000000}},  //   _enn_, _lebu, tiše,
  { {0xba570049, 0x7bdc15c7, 0xbddb000a, 0x00000000}},  //   לסטו_, _odru, _klèv,
  { {0x7bce0cd5, 0xb5fd016c, 0xc058008b, 0x00000000}},  //   _nebu, riše, піс_,
  { {0xff04007c, 0x5433035b, 0x81e20044, 0x00000000}},  //   нятн, _سرور, ন্ধ_,
  { {0x7d0d011c, 0xb5fd0c1e, 0x7bdc0145, 0x00000000}},  //   twas, piše, _adru,
  { {0x62560964, 0x41c3007d, 0xdcef0089, 0x00000000}},  // [2a70] ršot, _व्यस, _izcī,
  { {0x81e20055, 0xe0df01aa, 0x200a00c4, 0x00000000}},  //   ন্দ_, ryòd_, cebi_,
  { {0x7d0d15be, 0x78bb0cb2, 0x290400f6, 0x00000000}},  //   swas, _stuv, _apma_,
  { {0xfd1f0011, 0x320b009d, 0x61ef0082, 0x00000000}},  //   _trì_, necy_, ngcl,
  { {0x9f510211, 0x7bce033b, 0xdb050051, 0x00000000}},  //   pezó_, _febu, nchú,
  { {0x7bce010f, 0x66090116, 0xdb1501aa, 0x00000000}},  //   _gebu, week, _dezò,
  { {0x660900b0, 0xe736005e, 0xac94033c, 0x00000000}},  //   teek, дещ_, _чарш,
  { {0x7e6d0d88, 0x7bdc0465, 0x291f05d7, 0x00000000}},  //   nnap, _zdru, _trua_,
  { {0x14dd0061, 0x660901b5, 0x81cc0044, 0x00000000}},  //   _मिळण, reek, _লাল_,
  { {0x68e4002a, 0x66090052, 0x7e6d01a2, 0x00000000}},  //   áide, seek, hnap,
  { {0xe29a0216, 0x420a0d99, 0x7e6d15c8, 0x00000000}},  //   жан_, онно_, knap,
  { {0xd9ff007d, 0x7bc50048, 0x21200087, 0x00000000}},  //   ोजित_, hbhu, _prih_,
  { {0x7e6d0381, 0xd4350025, 0x24190783, 0x00000000}},  //   dnap, _يعتب, _моды_,
  { {0x6721016c, 0xa91d0161, 0x00000000, 0x00000000}},  //   _krlj, _lyžo,   ,
  { {0x7bce12e0, 0x10a30131, 0xa0a302ea, 0x00000000}},  //   _rebu, тирн, тард,
  { {0x7bce0149, 0x7bdc00b9, 0x7e6d0010, 0x00000000}},  //   _sebu, _sdru, gnap,
  { {0x6aae15c9, 0x62840034, 0x7bce0022, 0x00000000}},  // [2a80] _subf, _ikio, _pebu,
  { {0xfce30256, 0x8b6a0a85, 0x00000000, 0x00000000}},  //   тофо, оизв_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7bce0190, 0x53360049, 0xc98601ab, 0x00000000}},  //   _webu, ונען_, мули,
  { {0xb17b0cb2, 0x644f0089, 0x7bce15ca, 0x00000000}},  //   lgår, īcij, _tebu,
  { {0x7bdc0166, 0x7e6407a4, 0x00000000, 0x00000000}},  //   _udru, liip,   ,
  { {0x2bc40164, 0x68e40051, 0xb17b02e7, 0x00000000}},  //   _ल्या, áidb, ngår,
  { {0x44201305, 0x7c3c0238, 0x8c3b01a2, 0x00000000}},  //   _şi_, _horr, _wußt,
  { {0x7c3c0cfd, 0xd838037e, 0x6d4404cb, 0x00000000}},  //   _korr, _liči_, nyia,
  { {0x62840020, 0xdb1c05b7, 0x7c3c002d, 0x00000000}},  //   _akio, _berø, _jorr,
  { {0x7c3c0181, 0x7d060022, 0xbddb000a, 0x00000000}},  //   _morr, _lpks, _klèt,
  { {0x7c3c00f4, 0x81e20044, 0x63ad15cb, 0x00000000}},  //   _lorr, ন্স_, _şant,
  { {0x61fd000c, 0x7c3c01d6, 0x20010022, 0x00000000}},  //   rfsl, _oorr, _pbhi_,
  { {0x7c3c0073, 0x62840288, 0xdb050048, 0x00000000}},  //   _norr, _ekio, rchú,
  { {0xe800001c, 0x9f5f011f, 0x1ee700a1, 0x00000000}},  //   ल्या_, _ürün_, ظوری_,
  { {0x443c0afd, 0x7d060022, 0x7e640058, 0x00000000}},  //   _hov_, _bpks, giip,
  { {0x443c0dc6, 0x7c3c1295, 0x7e6d15cc, 0x00000000}},  // [2a90] _kov_, _borr, rnap,
  { {0xe3b80676, 0x6fc00061, 0x6f050011, 0x00000000}},  //   ncı_, वडणू, _tphc,
  { {0x7c3c0c54, 0x30780025, 0x7bc50048, 0x00000000}},  //   _dorr, _تحية_, rbhu,
  { {0x60cd0be3, 0x443c05b7, 0x752204f3, 0x00000000}},  //   _kwam, _lov_, _oroz,
  { {0x7c3c0d22, 0xa803014a, 0xf8b1025a, 0x00000000}},  //   _forr, _çıkt, اکر_,
  { {0x443c01d9, 0x7c3c002d, 0x60cd0020, 0x00000000}},  //   _nov_, _gorr, _mwam,
  { {0x39490ebc, 0xddc401d9, 0x6e3d0007, 0x00000000}},  //   šas_, lniš, _kosb,
  { {0x7c3c15cd, 0x75220107, 0xfc3f0051, 0x00000000}},  //   _zorr, _broz, _cuív_,
  { {0x443c15ce, 0x6e3d0023, 0xd7fb15cf, 0x00000000}},  //   _bov_, _mosb, _муж_,
  { {0x20cd01c5, 0xdb2600a1, 0x6e3d01d6, 0x00000000}},  //   dži_, _توہی, _losb,
  { {0x13a700e9, 0x60cd0020, 0x443c0197, 0x00000000}},  //   بندی_, _awam, _dov_,
  { {0x23bf007d, 0x60cd0a5f, 0xf089009b, 0x00000000}},  //   _श्रद, _bwam, _הנ_,
  { {0x7522001e, 0xc56b025a, 0xddc40059, 0x00000000}},  //   _groz, _بحال_, jniš,
  { {0x6aa915d0, 0x443c1042, 0xddc401ae, 0x00000000}},  //   _lief, _gov_, dniš,
  { {0x44f90263, 0x752215b1, 0x661915d1, 0x00000000}},  //   lè_, _zroz, _kawk,
  { {0x661b15d2, 0xb17b01bf, 0x6e3d0016, 0x00000000}},  //   nduk, rgår, _cosb,
  { {0x7c3c002d, 0x44f90263, 0x6e3d018e, 0x00000000}},  // [2aa0] _porr, nè_, _dosb,
  { {0x31570049, 0x7d1b002b, 0x7c3c15d3, 0x00000000}},  //   _ניין_, _ġust, _qorr,
  { {0x7c3c15d4, 0xb5fd016c, 0x201a12aa, 0x00000000}},  //   _vorr, ziša, _iapi_,
  { {0xddc401d9, 0x7ae315d5, 0x661b016e, 0x00000000}},  //   bniš, ánta, jduk,
  { {0x44f90263, 0x6aa90112, 0x201a15d6, 0x00000000}},  //   jè_, _dief, _kapi_,
  { {0x98a310a9, 0x201a002f, 0xb5fd00ca, 0x00000000}},  //   гиче, _japi_, viša,
  { {0x09e601fb, 0x752215d7, 0x201a00ca, 0x00000000}},  //   _повн, _sroz, _mapi_,
  { {0x443c0239, 0x44f901aa, 0x6aa90026, 0x00000000}},  //   _sov_, fè_, _gief,
  { {0x443c15d8, 0xc8ca03ec, 0x66190036, 0x00000000}},  //   _pov_, _روان_, _dawk,
  { {0x07a60106, 0x201a0010, 0x60cd09df, 0x00000000}},  //   _зазн, _napi_, _rwam,
  { {0xcf120044, 0xddc40059, 0x39460010, 0x00000000}},  //   হমুদ_, zniš, lyos_,
  { {0x76490039, 0xb5fd040d, 0x752215d9, 0x00000000}},  //   ckey, lišn, _troz,
  { {0x81a90055, 0x39460047, 0x443c0145, 0x00000000}},  //   খুন_, nyos_, _tov_,
  { {0xddc4092f, 0x201a0197, 0xc5690d3a, 0x00000000}},  //   vniš, _capi_, _تحمل_,
  { {0x6e3d0007, 0x141b009b, 0x201a0386, 0x00000000}},  //   _posb, _מוגב, _dapi_,
  { {0xddc410b9, 0x60cd15da, 0x6d1c007d, 0x00000000}},  //   tniš, _twam, निंग_,
  { {0x30a70373, 0x313501f9, 0x22ac00b9, 0x00000000}},  // [2ab0] _пров, _репр, _věku_,
  { {0xddc40059, 0xbbcb0061, 0x31580049, 0x00000000}},  //   rniš, िरेक, _ריזן_,
  { {0xb5fd0119, 0xcfb6009b, 0x99f5007e, 0x00000000}},  //   dišn, _בלתי_, вялі,
  { {0x44f90263, 0xddc40fd0, 0x201a15db, 0x00000000}},  //   yè_, pniš, _zapi_,
  { {0x201a15dc, 0xca7415dd, 0x00000000, 0x00000000}},  //   _yapi_, دالغ,   ,
  { {0x6bd4004b, 0x44f915de, 0x00000000, 0x00000000}},  //   _متفر, vè_,   ,
  { {0x6aa9010f, 0x79c90379, 0x44f901aa, 0x00000000}},  //   _tief, _يوسف_, wè_,
  { {0x44f90263, 0x3eab0022, 0x00000000, 0x00000000}},  //   tè_, _jict_,   ,
  { {0x764915df, 0x661b04a0, 0x3a2d00c4, 0x00000000}},  //   rkey, rduk, _inep_,
  { {0x7bd715e0, 0x2d8b00bb, 0x44f901aa, 0x00000000}},  //   naxu, _myce_, rè_,
  { {0x3a3f01aa, 0x44f901aa, 0x35f5007e, 0x00000000}},  //   _koup_, sè_, _апер,
  { {0x201a023a, 0x44f915e1, 0xd83801aa, 0x00000000}},  //   _sapi_, pè_, _chčf_,
  { {0x2124002a, 0x6486000c, 0x9f58000c, 0x00000000}},  //   ímh_, gðis, rfrí_,
  { {0x3a3f009d, 0xb05b04ce, 0x00000000, 0x00000000}},  //   _loup_, spän,   ,
  { {0xfc3f15e2, 0xe1ff15e3, 0x00000000, 0x00000000}},  //   _luís_, mión_,   ,
  { {0x201a0020, 0x337600b3, 0x2ee5000c, 0x00000000}},  //   _wapi_, _בעצם_, álfa_,
  { {0x201a0149, 0xada6008b, 0xbea309b2, 0x00000000}},  // [2ac0] _tapi_, таал, ратк,
  { {0xe1ff0219, 0xddc9012d, 0x22400288, 0x00000000}},  //   nión_, čošk, _hoik_,
  { {0xb5fd0166, 0x8fa600ec, 0x3a3f0173, 0x00000000}},  //   višn, _јане, _boup_,
  { {0x3a3f00f4, 0x7524016c, 0xc33200b3, 0x00000000}},  //   _coup_, _šizm, יוב_,
  { {0x3ea015e4, 0x99dd000a, 0x00000000, 0x00000000}},  //   mmit_, _alňs,   ,
  { {0xdb1c0047, 0x3ea00065, 0xb7d80025, 0x00000000}},  //   _kerü, lmit_, روبا_,
  { {0x7c2e0fcf, 0xb5fd0e00, 0xe70402fd, 0x00000000}},  //   _inbr, rišn, استی,
  { {0xeb97004c, 0x9f58004a, 0x00000000, 0x00000000}},  //   _рис_, leró_,   ,
  { {0xb5fd0825, 0x00000000, 0x00000000, 0x00000000}},  //   mišl,   ,   ,
  { {0xe1ff15e5, 0x9f58008e, 0x3ea00023, 0x00000000}},  //   gión_, neró_, hmit_,
  { {0x22520007, 0x00000000, 0x00000000, 0x00000000}},  //   _blyk_,   ,   ,
  { {0xdb1c15e6, 0xacbb00f4, 0x3ea015e7, 0x00000000}},  //   _heró, _brûl, jmit_,
  { {0x81cc0044, 0x7c2e0112, 0x00000000, 0x00000000}},  //   _লাখ_, _onbr,   ,
  { {0xe1ff0819, 0x14d7007b, 0x6486009f, 0x00000000}},  //   ción_, _יודל_, rðis,
  { {0x3eab0061, 0x9f58008e, 0x00000000, 0x00000000}},  //   _pict_, deró_,   ,
  { {0x320f0047, 0x7c2e0240, 0x02a400a5, 0x00000000}},  //   _úgy_, _anbr, _крым,
  { {0x628f01c3, 0xcc990184, 0x5c750745, 0x00000000}},  // [2ad0] mlco, евац_, глат,
  { {0x3a2d15e8, 0x7ae315e9, 0x628f01ed, 0x00000000}},  //   _snep_, ánto, llco,
  { {0x3ea00866, 0xdb1c010f, 0x5ba7017f, 0x00000000}},  //   bmit_, _gerü, траз,
  { {0x3ce901d9, 0x2011094f, 0x7c2e15ea, 0x00000000}},  //   prav_, lezi_, _enbr,
  { {0x26de15eb, 0x628f000a, 0x9f580919, 0x00000000}},  //   _avto_, ilco, beró_,
  { {0x2011001a, 0xe1ff0211, 0x81d90044, 0x00000000}},  //   nezi_, xión_, ালি_,
  { {0x27e901f6, 0x3a3f01aa, 0x9f580026, 0x00000000}},  //   ğan_, _toup_, lerò_,
  { {0x27e915ec, 0x7bd50032, 0x201115ed, 0x00000000}},  //   şan_, _hezu, hezi_,
  { {0xe800024c, 0x2a640265, 0x2717005f, 0x00000000}},  //   ल्हा_, _търг, _mənə_,
  { {0x3ea0008d, 0x69d915ee, 0x7bd515ef, 0x00000000}},  //   zmit_, lawe, _jezu,
  { {0x7bd515f0, 0x442e0146, 0x9f580197, 0x00000000}},  //   _mezu, _dnf_, herò_,
  { {0xe1ff15f1, 0x69d9000b, 0x442e15f2, 0x00000000}},  //   sión_, nawe, _enf_,
  { {0x6486000c, 0x442e0085, 0xd5ae0257, 0x00000000}},  //   rðir, _fnf_, _عفو_,
  { {0x201115f3, 0x9f580197, 0xb5fd0b54, 0x00000000}},  //   gezi_, derò_, zišl,
  { {0x37d80044, 0x2d8f010f, 0x9f58004a, 0x00000000}},  //   _সামর, ügen_, veró_,
  { {0xdb050051, 0x69d915f4, 0xfbcd0044, 0x00000000}},  //   hchó, jawe, _লাগত,
  { {0x62860429, 0x7bd5010f, 0xed5700ed, 0x00000000}},  // [2ae0] moko, _bezu, гот_,
  { {0x6286011c, 0xdb1c0047, 0x3ea00089, 0x00000000}},  //   loko, _terü, smit_,
  { {0x272301f6, 0x7bd502eb, 0xdb1c00d4, 0x00000000}},  //   _nın_, _dezu, _aerò,
  { {0x248515f5, 0x69d90fb6, 0x9f41008e, 0x00000000}},  //   holm_, gawe, _echó_,
  { {0x9f58008e, 0xdb1c008e, 0xc7ba007e, 0x00000000}},  //   peró_, _peró, нёй_,
  { {0x628615f6, 0x7bd50ab3, 0x26dc041a, 0x00000000}},  //   hoko, _gezu, tsvo_,
  { {0x628600b0, 0xdb1c008e, 0x7d160016, 0x00000000}},  //   koko, _veró, lwys,
  { {0x60c415f7, 0x61e40020, 0x628615f8, 0x00000000}},  //   _otim, _ndil, joko,
  { {0x628615f9, 0x60c415fa, 0x54540069, 0x00000000}},  //   doko, _ntim, ивит,
  { {0x61e415fb, 0xe6440279, 0x6aa215fc, 0x00000000}},  //   _adil, ılış, lmof,
  { {0x439401f9, 0x20110035, 0x60c415fd, 0x00000000}},  //   ранс, vezi_, _atim,
  { {0xe45206c6, 0x2011000b, 0x62860266, 0x00000000}},  //   _گفتگ, wezi_, goko,
  { {0x2011000b, 0x61e40016, 0x855700a1, 0x00000000}},  //   tezi_, _ddil, _میٹر_,
  { {0x61e415fe, 0x2717006b, 0x442e01ee, 0x00000000}},  //   _edil, _sənə_, _unf_,
  { {0x60c4049a, 0x2011002d, 0x69d900e7, 0x00000000}},  //   _etim, rezi_, yawe,
  { {0x20110035, 0x9f580197, 0x6728012d, 0x00000000}},  //   sezi_, terò_, _mrdj,
  { {0xdb05010f, 0x7bd50065, 0x2beb00ed, 0x00000000}},  // [2af0] schü, _pezu, еќен_,
  { {0x69d90020, 0x69c015ff, 0x9f580197, 0x00000000}},  //   wawe, _afme, rerò_,
  { {0x7bd50107, 0x8af9005e, 0x69d90020, 0x00000000}},  //   _vezu, тнес_, tawe,
  { {0xd01100a1, 0x7f3a0049, 0x7d160016, 0x00000000}},  //   _الگ_, _סערו, bwys,
  { {0x80a402fd, 0xe0df0e5d, 0x67281600, 0x00000000}},  //   _خمین, nsò_, _ardj,
  { {0xb346014a, 0x62860e49, 0x6353006b, 0x00000000}},  //   _kaçı, zoko, sənə,
  { {0xe7390373, 0x764201d6, 0xdb050a41, 0x00000000}},  //   тей_, _booy, rchó,
  { {0x8aa4004c, 0xb5fd0006, 0x26c70e0d, 0x00000000}},  //   _груд, mišk, rpno_,
  { {0xb5fd09f4, 0xf1c800b9, 0x76421601, 0x00000000}},  //   lišk, ndář_, _dooy,
  { {0x32090058, 0x290d00c4, 0x44651602, 0x00000000}},  //   _abay_, _ipea_, рвов,
  { {0x62861603, 0x60c4010f, 0xe29a012b, 0x00000000}},  //   toko, _stim, као_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x628601d9, 0xe44e0131, 0x2d8f01a2, 0x00000000}},  //   roko, _дж_, ügel_,
  { {0x3209001c, 0x9f58000c, 0x25bf1604, 0x00000000}},  //   _ebay_, ferð_, lcul_,
  { {0x8fa60265, 0xb5fd00d0, 0x62860142, 0x00000000}},  //   раве, jišk, poko,
  { {0xb5fd0b4d, 0x13da0055, 0x64430abe, 0x00000000}},  //   dišk, _দায়, _honi,
  { {0x64431605, 0xbc661606, 0x60c400e7, 0x00000000}},  // [2b00] _koni, авак, _utim,
  { {0x7d160343, 0x64430006, 0x78a30009, 0x00000000}},  //   rwys, _joni, jmnv,
  { {0xb5fd0006, 0xe9da0cee, 0x00000000, 0x00000000}},  //   gišk, вке_,   ,
  { {0xa9260102, 0x539a00b3, 0x62870fcd, 0x00000000}},  //   идел, דיעו, čkog,
  { {0x6728003b, 0x764201d6, 0xd3780091, 0x00000000}},  //   _srdj, _rooy, maće_,
  { {0xdb1c009f, 0x9866026c, 0x6aa201aa, 0x00000000}},  //   _ferð, جیئے_, smof,
  { {0xd6d704af, 0xdb1c009f, 0x290d002d, 0x00000000}},  //   аты_, _gerð, _epea_,
  { {0x963400e1, 0xd01f0044, 0x960a007e, 0x00000000}},  //   сниц, দায়_, тэка_,
  { {0x3ce01607, 0xd90e00a6, 0x993400a1, 0x00000000}},  //   nsiv_, _آیت_, _دہشت,
  { {0x656f1608, 0x27e50022, 0x32090058, 0x00000000}},  //   úcha, _gdln_, _sbay_,
  { {0x0bb700b6, 0x6f090046, 0xc5e80055, 0x00000000}},  //   ילים_, łecz, ক্ষা_,
  { {0xd3780107, 0x9f58000c, 0x21290340, 0x00000000}},  //   jaće_, verð_, _prah_,
  { {0xdfdb0265, 0xc693009b, 0x64430016, 0x00000000}},  //   къв_, _ואף_, _foni,
  { {0x644300d0, 0xd48f0088, 0xe0df0026, 0x00000000}},  //   _goni, _єр_, rsò_,
  { {0x09d70055, 0xe0df0c42, 0xb346006b, 0x00000000}},  //   _হাসা, ssò_, _qaçı,
  { {0xb5fd010a, 0x877b0049, 0x443e00f8, 0x00000000}},  //   višk, דאלי, ljt_,
  { {0x64430022, 0x2d8f0030, 0x8bb70025, 0x00000000}},  // [2b10] _yoni, æge_, لإضا,
  { {0xb5fd0006, 0x270e006b, 0xa8020477, 0x00000000}},  //   tišk, _kənd_, çıla,
  { {0xf2d30049, 0xd3780521, 0x95ff0044, 0x00000000}},  //   ַעס_, baće_, ্যতম_,
  { {0xdb1c0359, 0xb5fd09f4, 0x270e006b, 0x00000000}},  //   _verð, rišk, _zəng_,
  { {0x634a005f, 0xb5fd010a, 0x728a0049, 0x00000000}},  //   lənd, sišk, נננְ,
  { {0x893401d8, 0x1ed80167, 0xb5fd0006, 0x00000000}},  //   تعما, _حبیب_, pišk,
  { {0x81e20055, 0x64431609, 0x36690ca6, 0x00000000}},  //   ন্ট_, _roni, лако_,
  { {0x64430211, 0x80b80055, 0x7e6d0035, 0x00000000}},  //   _soni, _অবস্, niap,
  { {0x64430046, 0x6d4d04cb, 0x25bf001a, 0x00000000}},  //   _poni, nyaa, rcul_,
  { {0x645a00ab, 0x25bf160a, 0x7e6d160b, 0x00000000}},  //   ghti, scul_, hiap,
  { {0xd7950054, 0xe1ff0010, 0x64430006, 0x00000000}},  //   _الاخ, ciók_, _voni,
  { {0xc049061e, 0x644300c1, 0x634a006b, 0x00000000}},  //   _אז_, _woni, dənd,
  { {0x7e6d0cfe, 0xd3780107, 0x2ba70061, 0x00000000}},  //   diap, vaće_, केता,
  { {0x645a160c, 0x46130014, 0x00000000, 0x00000000}},  //   chti, _دوچر,   ,
  { {0xd3780521, 0xddc40035, 0x634a013f, 0x00000000}},  //   taće_, ghiş, gənd,
  { {0x765b160d, 0x7e6d0d96, 0x00000000, 0x00000000}},  //   nhuy, giap,   ,
  { {0xd3780107, 0x6da30920, 0x26c2012d, 0x00000000}},  // [2b20] raće_, зита, _čkom_,
  { {0x3ce000ea, 0xd3780521, 0x00000000, 0x00000000}},  //   rsiv_, saće_,   ,
  { {0xff260140, 0x6d4d04cb, 0xeafa0431, 0x00000000}},  //   _умно, ayaa, طرات_,
  { {0xeb970e09, 0xddcd001a, 0x00000000, 0x00000000}},  //   щих_, rnaţ,   ,
  { {0xdd920084, 0x2d8400f4, 0x645a00b0, 0x00000000}},  //   _روس_, _âme_, yhti,
  { {0x6e24002d, 0x13af0044, 0x7d04094f, 0x00000000}},  //   ldib, চুয়, mtis,
  { {0x7d040207, 0x09d70044, 0x6b63005e, 0x00000000}},  //   ltis, _হারা, _екра,
  { {0x6e24059a, 0xceb300b6, 0x645d0065, 0x00000000}},  //   ndib, היה_, ësin,
  { {0xb05b00b0, 0x645a0023, 0x00000000, 0x00000000}},  //   späi, thti,   ,
  { {0x634a005f, 0x7bde04be, 0x7d040051, 0x00000000}},  //   yənd, napu, itis,
  { {0x53980088, 0x7d0403b6, 0x9f45005a, 0x00000000}},  //   рвня_, htis, ülü_,
  { {0x645a008d, 0x7bde04cb, 0x7ae3008e, 0x00000000}},  //   shti, hapu, ánti,
  { {0x7bde011c, 0x68e2160e, 0xc05b0088, 0x00000000}},  //   kapu, nsod, гів_,
  { {0x80b80055, 0x634a005f, 0x7bde0052, 0x00000000}},  //   _অবশ্, tənd, japu,
  { {0x7e6d0032, 0x7bde160f, 0x9f5801aa, 0x00000000}},  //   tiap, dapu, ngrè_,
  { {0x7d0401e5, 0x634a006b, 0xdceb0142, 0x00000000}},  //   ftis, rənd, žičk,
  { {0x7d041002, 0x7e6d1610, 0x6f1e00fa, 0x00000000}},  // [2b30] gtis, riap, _espc,
  { {0x7e6d1611, 0xb5fd016e, 0x7bde027c, 0x00000000}},  //   siap, riši, gapu,
  { {0x2004006b, 0x6d4d01a3, 0x7e6d0c1b, 0x00000000}},  //   əmi_, syaa, piap,
  { {0xb5fd07a0, 0x7d1d0058, 0x02fb0049, 0x00000000}},  //   piši, _tsss, רלאמ,
  { {0xe9d8008b, 0x64580219, 0x7d0402a4, 0x00000000}},  //   скі_, _olvi, ctis,
  { {0x7bde00d6, 0xe9d90036, 0x7e7d1612, 0x00000000}},  //   capu, _weź_, _hjsp,
  { {0x07a20517, 0x765b0082, 0x70b5013d, 0x00000000}},  //   машн, thuy, ंदुल,
  { {0x245b028c, 0x64580181, 0xb658007e, 0x00000000}},  //   _même_, _alvi, йшых_,
  { {0xe4590794, 0x69db0016, 0x81bf0044, 0x00000000}},  //   ижи_, _ieue, ইরা_,
  { {0xdb1c05e9, 0x69db01a2, 0x395200ea, 0x00000000}},  //   _verö, _heue, øyse_,
  { {0x7af701f3, 0x7c250048, 0x00000000, 0x00000000}},  //   nuxt, idhr,   ,
  { {0x7de60010, 0x7d04000c, 0xdb1c014a, 0x00000000}},  //   _késő, ytis, _terö,
  { {0x7bde09e4, 0x3eba1613, 0x69db00d4, 0x00000000}},  //   yapu, _supt_, _meue,
  { {0x9f5800f4, 0x69db0007, 0x66091614, 0x00000000}},  //   lgré_, _leue, lfek,
  { {0xe29a0680, 0x1faa081e, 0x75291615, 0x00000000}},  //   _как_, ркви_, lvez,
  { {0x69db001f, 0xe1ff0036, 0x7d040e2d, 0x00000000}},  //   _neue, diów_, ttis,
  { {0x7bde1616, 0x1c46005e, 0x7d0400b0, 0x00000000}},  // [2b40] tapu, онам, utis,
  { {0x7659018e, 0x7d040038, 0x6e2406c2, 0x00000000}},  //   _llwy, rtis, sdib,
  { {0x20180207, 0x9f060076, 0x69db1617, 0x00000000}},  //   meri_, _بوجو, _beue,
  { {0x20181355, 0x7ff602fd, 0x7bde0ed1, 0x00000000}},  //   leri_, _اسکا, sapu,
  { {0xcaa50054, 0x7bde04d4, 0x69db00d4, 0x00000000}},  //   أصلي, papu, _deue,
  { {0x20180208, 0xab2a1618, 0x75290010, 0x00000000}},  //   neri_, _кога_, dvez,
  { {0xf8bf02ae, 0x69db010f, 0x68e2002b, 0x00000000}},  //   _één_, _feue, ssod,
  { {0xe3b8047f, 0x7bdc01e7, 0x76590016, 0x00000000}},  //   rdım_, _heru, _clwy,
  { {0x7bdc020c, 0x2018014a, 0xdb2100b0, 0x00000000}},  //   _keru, keri_, ätös,
  { {0xddc40b41, 0x2018016e, 0x3a240146, 0x00000000}},  //   jniž, jeri_, _hamp_,
  { {0x7bdc0149, 0x3a240030, 0x7659018e, 0x00000000}},  //   _meru, _kamp_, _flwy,
  { {0xbddb00f4, 0x6abc00e5, 0x75290059, 0x00000000}},  //   _poèm, _murf, bvez,
  { {0xe3af026c, 0x29061619, 0xddcd00b9, 0x00000000}},  //   ٹری_, ntoa_, chař,
  { {0x20180281, 0xe3af025a, 0x270e006b, 0x00000000}},  //   geri_, عری_, _gənc_,
  { {0xcddb00e1, 0xff040783, 0x04200044, 0x00000000}},  //   иња_, мятн, বাদী_,
  { {0x7bdc001a, 0xb3bc0044, 0x29060032, 0x00000000}},  //   _aeru, _আজিজ, ktoa_,
  { {0x7bdc0281, 0x2018161a, 0x69db00d9, 0x00000000}},  // [2b50] _beru, beri_, _reue,
  { {0x2018161b, 0xb5fd0209, 0x7bdc001a, 0x00000000}},  //   ceri_, lišt, _ceru,
  { {0x7bdc161c, 0x20010016, 0x6abc161d, 0x00000000}},  //   _deru, _ichi_, _curf,
  { {0x61fd0292, 0xb5fd0340, 0x3a2401cb, 0x00000000}},  //   ngsl, ništ, _camp_,
  { {0x3ea9021e, 0x3a2400eb, 0x61fd161e, 0x00000000}},  //   mmat_, _damp_, igsl,
  { {0x7bdc00c7, 0x3ea90ae4, 0xb5fd0059, 0x00000000}},  //   _geru, lmat_, hišt,
  { {0x7bc5161f, 0x69db010f, 0x645d0065, 0x00000000}},  //   mchu, _teue, ësim,
  { {0xe9df009f, 0xb5fd1620, 0x7bdc002d, 0x00000000}},  //   _þú_, jišt, _zeru,
  { {0xb5fd036a, 0x1a680cd9, 0x3e7701d5, 0x00000000}},  //   dišt, _بینی_, għti_,
  { {0x2001000b, 0x75290047, 0x7bc50051, 0x00000000}},  //   _nchi_, rvez, nchu,
  { {0x7ae50065, 0x7bc5010f, 0x3ea904cb, 0x00000000}},  //   nsht, ichu, kmat_,
  { {0x212000ca, 0x61fd00f8, 0x7bc50048, 0x00000000}},  //   _psih_, ggsl, hchu,
  { {0x20181092, 0x55ba009b, 0x3ea90127, 0x00000000}},  //   teri_, _המנו, dmat_,
  { {0x2a7f07d1, 0xb5fd016c, 0x394000b0, 0x00000000}},  //   _ljub_, rišu, äisi_,
  { {0x4375007b, 0x2018001a, 0x634a006b, 0x00000000}},  //   _מײַן_, reri_, rənc,
  { {0x7bdc033b, 0x3ea900ea, 0x20010638, 0x00000000}},  //   _seru, gmat_, _echi_,
  { {0x7bdc04d4, 0x2018008d, 0x3a24046a, 0x00000000}},  // [2b60] _peru, peri_, _ramp_,
  { {0x8fa601a4, 0x20180065, 0x6abc0544, 0x00000000}},  //   _напе, qeri_, _purf,
  { {0x7bdc012b, 0x3a2400e0, 0x68f900bb, 0x00000000}},  //   _veru, _pamp_, euwd,
  { {0x7bdc1621, 0xda65006d, 0x290600b0, 0x00000000}},  //   _weru, واني, ttoa_,
  { {0x3a26040f, 0x29060883, 0xf9180014, 0x00000000}},  //   rdop_, utoa_, تراژ_,
  { {0x7bc501d6, 0x7c5a0025, 0x6e26011c, 0x00000000}},  //   cchu, _السر_, _hakb,
  { {0x29061622, 0x6e260460, 0xdc370049, 0x00000000}},  //   stoa_, _kakb, _צאלט_,
  { {0xb86600e9, 0xa534003b, 0x6e260036, 0x00000000}},  //   _کارو, днич, _jakb,
  { {0xb5fd00b9, 0x04200044, 0x6e260095, 0x00000000}},  //   višt, বাসী_, _makb,
  { {0x22490784, 0x3ea90023, 0xe9ff0082, 0x00000000}},  //   _soak_, zmat_, _toản_,
  { {0xb5fd013e, 0x04fe0044, 0xe9ff0082, 0x00000000}},  //   tišt, ্টের_, _hoạn_,
  { {0x20011623, 0x76bb009b, 0x6e260288, 0x00000000}},  //   _schi_, _המאפ, _nakb,
  { {0xb5fd0091, 0x321913c2, 0x61fd0239, 0x00000000}},  //   rišt, resy_, rgsl,
  { {0x75221624, 0x04200044, 0x00000000, 0x00000000}},  //   _isoz, বাহী_,   ,
  { {0xb5fd00b9, 0xe9ff0011, 0x6e2604d3, 0x00000000}},  //   pišt, _loạn_, _bakb,
  { {0x5f940088, 0x5eb4058e, 0x644a0657, 0x00000000}},  //   хист, ейст, _hofi,
  { {0x61ed0107, 0x628f0142, 0x644a00e7, 0x00000000}},  // [2b70] _idal, moco, _kofi,
  { {0x5ba700ed, 0x60cd1335, 0x628f00c4, 0x00000000}},  //   през, _itam, loco,
  { {0x7bc51625, 0xa1340123, 0xe7a50089, 0x00000000}},  //   rchu, _قریش, ādīš,
  { {0x7bc51626, 0x7ae5008d, 0x628f1627, 0x00000000}},  //   schu, rsht, noco,
  { {0xa95401fb, 0x61ed0eb0, 0x00000000, 0x00000000}},  //   нкці, _mdal,   ,
  { {0xf7700a90, 0x60cd0020, 0x644a1628, 0x00000000}},  //   گاه_, _mtam, _nofi,
  { {0x16a90264, 0x61ed014a, 0xab950088, 0x00000000}},  //   овки_, _odal, _циві,
  { {0x61ed008d, 0x60cd002d, 0x7c271002, 0x00000000}},  //   _ndal, _otam, _hajr,
  { {0x68e40051, 0x60cd1629, 0x644a00d4, 0x00000000}},  //   áidt, _ntam, _bofi,
  { {0x61ed020c, 0x644a018e, 0x55ff0044, 0x00000000}},  //   _adal, _cofi, ্যেক_,
  { {0x5884008b, 0x60cd162a, 0x644a00b4, 0x00000000}},  //   _чыта, _atam, _dofi,
  { {0x60cd0009, 0x00000000, 0x00000000, 0x00000000}},  //   _btam,   ,   ,
  { {0x61ed0016, 0x644a162b, 0x98a4001a, 0x00000000}},  //   _ddal, _fofi, _urmă_,
  { {0x7c270142, 0x764b162c, 0x661b11fe, 0x00000000}},  //   _najr, _hogy, leuk,
  { {0x4427001a, 0x628f04d4, 0x92e80025, 0x00000000}},  //   _ian_, boco, _فريق_,
  { {0x661b162d, 0x764b04be, 0xbea3003b, 0x00000000}},  //   neuk, _jogy, васк,
  { {0xfce30057, 0x1d0701fc, 0x7c270065, 0x00000000}},  // [2b80] кото, мети_, _bajr,
  { {0x4427060b, 0x61ed07e4, 0xb05b0614, 0x00000000}},  //   _jan_, _zdal, spär,
  { {0x4427162e, 0xe1ff162f, 0xe9ff0011, 0x00000000}},  //   _man_, ciós_, _soạn_,
  { {0x44271630, 0xe1ff0036, 0x7c270032, 0x00000000}},  //   _lan_, chód_, _eajr,
  { {0xe3e30055, 0x44270011, 0x3e77002b, 0x00000000}},  //   _মানব, _oan_, għtu_,
  { {0x44271631, 0xd943003b, 0x00000000, 0x00000000}},  //   _nan_, тељи,   ,
  { {0x644a0635, 0x69c901cf, 0x628f10c9, 0x00000000}},  //   _rofi, _ffee, yoco,
  { {0x4427049b, 0x644a0039, 0x661b0020, 0x00000000}},  //   _aan_, _sofi, geuk,
  { {0x442702d4, 0xe7cf0164, 0xd7cf007d, 0x00000000}},  //   _ban_, _स्वप, _स्वच,
  { {0x44270a8a, 0x00000000, 0x00000000, 0x00000000}},  //   _can_,   ,   ,
  { {0x44270149, 0x60cd0198, 0x764b0047, 0x00000000}},  //   _dan_, _stam, _fogy,
  { {0x4427022b, 0x9258007c, 0xc7b80166, 0x00000000}},  //   _ean_, дают_, _nađi_,
  { {0x628f1632, 0xe1ff147e, 0x644a006b, 0x00000000}},  //   roco, rgó_, _tofi,
  { {0x44271633, 0x628f0197, 0xa3df007d, 0x00000000}},  //   _gan_, soco, तरण_,
  { {0x764b0390, 0xe5800089, 0x00000000, 0x00000000}},  //   _yogy, šķā_,   ,
  { {0x61ed1634, 0x13e30055, 0x44271635, 0x00000000}},  //   _udal, _মায়, _zan_,
  { {0x4427006a, 0x60cd1636, 0x6e94004c, 0x00000000}},  // [2b90] _yan_, _utam, титу,
  { {0x69c900c1, 0x4427006b, 0x4cc80044, 0x00000000}},  //   _sfee, _xan_, _লিখু,
  { {0x68e90255, 0x634a006b, 0x7c270ede, 0x00000000}},  //   _sved, zənn, _vajr,
  { {0xdd910879, 0xdb0e0010, 0x37d80044, 0x00000000}},  //   _موج_, áján, _সাগর,
  { {0xcce70025, 0xe6ed0027, 0x7c270066, 0x00000000}},  //   _تسجي, _väčš, _tajr,
  { {0x3eb9049a, 0x07a504f9, 0xa158009b, 0x00000000}},  //   _hist_, налн, ובדה_,
  { {0x4427018e, 0x3eb91637, 0x00000000, 0x00000000}},  //   _ran_, _kist_,   ,
  { {0x44270071, 0xd0280044, 0x1995007e, 0x00000000}},  //   _san_, মায়_, _забя,
  { {0x68e9004f, 0x3eb9054e, 0xe579007c, 0x00000000}},  //   _uved, _mist_, язи_,
  { {0x3eb90038, 0x44271638, 0x98ad016c, 0x00000000}},  //   _list_, _qan_, _kreč_,
  { {0x4427049b, 0xe29a00c0, 0x2d9908e0, 0x00000000}},  //   _van_, зан_, _lyse_,
  { {0x442701a3, 0x80d40044, 0x3eb901ed, 0x00000000}},  //   _wan_, _তিব্, _nist_,
  { {0xdb1c0039, 0x4427060b, 0x634a006b, 0x00000000}},  //   _ifrå, _tan_, lənl,
  { {0x44270093, 0x00000000, 0x00000000, 0x00000000}},  //   _uan_,   ,   ,
  { {0x3eb9010f, 0x66c7014a, 0x322900b0, 0x00000000}},  //   _bist_, _yıka, ötyä_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x61e60996, 0x3eb90555, 0x6e9300f3, 0x00000000}},  // [2ba0] makl, _dist_, القا,
  { {0x61e6066b, 0x4f261534, 0x3eb900bb, 0x00000000}},  //   lakl, _здоб, _eist_,
  { {0x09d70055, 0xb3460181, 0x20c60011, 0x00000000}},  //   _হাজা, maçõ, _hôi_,
  { {0x2cb8001f, 0xb3460181, 0x61e6014a, 0x00000000}},  //   _wird_, laçõ, nakl,
  { {0x2d990146, 0x00000000, 0x00000000, 0x00000000}},  //   _gyse_,   ,   ,
  { {0x20c6001d, 0xeee7007a, 0xd6da005e, 0x00000000}},  //   _môi_, _تغیی, пти_,
  { {0xf09300a3, 0x20c60011, 0x61e61109, 0x00000000}},  //   אנג_, _lôi_, kakl,
  { {0x3546017f, 0x61e61639, 0x7e6400e7, 0x00000000}},  //   ехов, jakl, nhip,
  { {0x7afe163a, 0x61e6163b, 0x20c60082, 0x00000000}},  //   lupt, dakl, _nôi_,
  { {0x54540113, 0xdb1c0023, 0x00000000, 0x00000000}},  //   твот, _ngrë,   ,
  { {0xb34600c4, 0x66c70095, 0x00000000, 0x00000000}},  //   daçõ, _tıka,   ,
  { {0xa75b034e, 0x20c60011, 0x634a006b, 0x00000000}},  //   _מדבר, _bôi_, səno,
  { {0x5184003b, 0xc68f00a1, 0x20c60082, 0x00000000}},  //   гура, _اِن_, _côi_,
  { {0xb3460181, 0x634a006b, 0x3eb901c9, 0x00000000}},  //   gaçõ, lənm, _sist_,
  { {0x61e6163c, 0x443c0716, 0x61f40039, 0x00000000}},  //   bakl, _inv_, ådlö,
  { {0x61e6011f, 0x78ba163d, 0x645d0065, 0x00000000}},  //   cakl, _litv, ësiv,
  { {0x442c018e, 0x4f5800a1, 0x3f9e000c, 0x00000000}},  // [2bb0] odd_, وجہد_, ýtur_,
  { {0xb34602d5, 0x634a006b, 0x3eb900b5, 0x00000000}},  //   caçõ, yənl, _wist_,
  { {0x442c163e, 0x2d990007, 0x7afe01f3, 0x00000000}},  //   idd_, _wyse_, gupt,
  { {0x7e640035, 0x7c3c12b2, 0x2003163f, 0x00000000}},  //   chip, _enrr, lgji_,
  { {0x6e3d010f, 0x20c60082, 0x78ba00b9, 0x00000000}},  //   _insb, _xôi_, _bitv,
  { {0xa3bc03d7, 0x6e2d000c, 0x7d0d007f, 0x00000000}},  //   _अलग_, ldab, mtas,
  { {0x7d0d1640, 0xddcd001a, 0x81e70044, 0x00000000}},  //   ltas, ciaţ, _পান_,
  { {0x442c018e, 0xb3460181, 0x7f3c0049, 0x00000000}},  //   edd_, zaçõ, לעוו,
  { {0xc4850088, 0x12bd0044, 0x2c640039, 0x00000000}},  //   клик, _আবেদ, _född_,
  { {0x443c0a8b, 0x69d901a2, 0x00000000, 0x00000000}},  //   _cnv_, lbwe,   ,
  { {0x61e6009f, 0x7d0d006c, 0x06f40076, 0x00000000}},  //   takl, htas, _مسنج,
  { {0x27e708cc, 0x7d0d014a, 0x443c009d, 0x00000000}},  //   lann_, ktas, _env_,
  { {0xb3460181, 0x61e6014a, 0x443c0f0a, 0x00000000}},  //   taçõ, rakl, _fnv_,
  { {0x27e7002a, 0x7d0d0030, 0x10a61641, 0x00000000}},  //   nann_, dtas, тигн,
  { {0xb34602d5, 0xdee30081, 0x7d0d0026, 0x00000000}},  //   raçõ, иори, etas,
  { {0x20c600ad, 0x27e71642, 0x6d44002d, 0x00000000}},  //   _tôi_, hann_, txia,
  { {0x7d0d011c, 0xb3460181, 0x27e7000c, 0x00000000}},  // [2bc0] gtas, paçõ, kann_,
  { {0x61e405d1, 0xe3b8027d, 0x3f9a08d2, 0x00000000}},  //   _heil, mdır_, _typu_,
  { {0xbddb0f57, 0x27e71643, 0x09e600da, 0x00000000}},  //   _poèt, dann_, воен,
  { {0x7afe121e, 0x60c40020, 0x6abb07ae, 0x00000000}},  //   rupt, _kuim, _ciuf,
  { {0x442c0bc4, 0x61e4028c, 0xe3b80279, 0x00000000}},  //   ydd_, _meil, ndır_,
  { {0xcee906c6, 0x27e7002a, 0x61e40181, 0x00000000}},  //   _ترین_, gann_, _leil,
  { {0xa7fc005a, 0x60c40051, 0x78ba00f8, 0x00000000}},  //   _alıc, _luim, _vitv,
  { {0xfaa60069, 0x61e4006c, 0x442c018e, 0x00000000}},  //   _рабо, _neil, wdd_,
  { {0x27e71644, 0x090600ec, 0x47e10055, 0x00000000}},  //   bann_, _шпан, _নারী,
  { {0x78ba049b, 0xdb1c00f4, 0x27e70051, 0x00000000}},  //   _uitv, _agré, cann_,
  { {0x442c018e, 0x7d0d1645, 0xa279003b, 0x00000000}},  //   rdd_, ztas, ебну_,
  { {0xd3780166, 0x7d0d000c, 0x443c0b3d, 0x00000000}},  //   naći_, ytas, _wnv_,
  { {0x61e4009f, 0x60c4002a, 0xd251025a, 0x00000000}},  //   _deil, _cuim, لنگ_,
  { {0x2bfe0309, 0x645d0065, 0x443c00d9, 0x00000000}},  //   _लागू_, ësit, _unv_,
  { {0x61e40056, 0x20030065, 0x260f006e, 0x00000000}},  //   _feil, rgji_, थ्वी_,
  { {0x7d0d0635, 0x61e41440, 0x60c4008e, 0x00000000}},  //   ttas, _geil, _fuim,
  { {0x60c40181, 0x27e70058, 0x7d0d1646, 0x00000000}},  // [2bd0] _guim, yann_, utas,
  { {0x7d0d022b, 0x6aa90065, 0x61e405c6, 0x00000000}},  //   rtas, _shef, _zeil,
  { {0x7d0d0004, 0x27e71647, 0xddc60036, 0x00000000}},  //   stas, vann_, _dokł,
  { {0x27e7010f, 0x99d4006d, 0x21290085, 0x00000000}},  //   wann_, لتها, _ksah_,
  { {0xe9d80ee0, 0x27e71648, 0xee3f0142, 0x00000000}},  //   ткі_, tann_, _iný_,
  { {0xfa230044, 0xd7091649, 0x00000000, 0x00000000}},  //   ফাইল_, енке_,   ,
  { {0x27e70263, 0x12bd0055, 0xe3b8005a, 0x00000000}},  //   rann_, _আব্দ, zdır_,
  { {0x27e70263, 0xddcd001e, 0x9980049c, 0x00000000}},  //   sann_, skaņ, žiš_,
  { {0x61e400b0, 0x27e701aa, 0xf8070088, 0x00000000}},  //   _reil, pann_, _ачен,
  { {0x61e41014, 0x60c4015c, 0xe3e30055, 0x00000000}},  //   _seil, _ruim, _মাহব,
  { {0x60c4164a, 0x65690010, 0x91e6004d, 0x00000000}},  //   _suim, szeh, лоне,
  { {0xe3b8006b, 0x00000000, 0x00000000, 0x00000000}},  //   tdır_,   ,   ,
  { {0x61e402ae, 0x645d008d, 0x60c40211, 0x00000000}},  //   _veil, ësis, _quim,
  { {0xe3b801f6, 0x61e4010f, 0x26c508e3, 0x00000000}},  //   rdır_, _weil, _kulo_,
  { {0x61e4164b, 0x99750036, 0x21290145, 0x00000000}},  //   _teil, nęło_, _esah_,
  { {0x26c50026, 0x60c40755, 0x3a2d00d2, 0x00000000}},  //   _mulo_, _tuim, _naep_,
  { {0x0eb904af, 0x4c860265, 0xe3b8006b, 0x00000000}},  // [2be0] туры_, глав, qdır_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x26c5164c, 0x2240040f, 0xfaa6003b, 0x00000000}},  //   _nulo_, _knik_, гажо,
  { {0x3ce80316, 0x1efb0049, 0xc986005e, 0x00000000}},  //   _चौथे_, _אלטע, лули,
  { {0xed57004d, 0xf99201b7, 0xc27b071c, 0x00000000}},  //   _боя_, حبا_, ערני,
  { {0x3ea0164d, 0x66c7011f, 0xf772026c, 0x00000000}},  //   llit_, _tıkl, یاں_,
  { {0x26c50e1d, 0xd3780243, 0x22400032, 0x00000000}},  //   _culo_, paći_, _onik_,
  { {0x7c2e0211, 0x3ea0000c, 0x26c5011c, 0x00000000}},  //   _habr, nlit_, _dulo_,
  { {0x634a005f, 0x290f001c, 0x7c2e01aa, 0x00000000}},  //   məni, ctga_, _kabr,
  { {0x634a005f, 0x22400058, 0x24520035, 0x00000000}},  //   ləni, _anik_, _câmp_,
  { {0x360605f3, 0x3ea0006c, 0x26c5011c, 0x00000000}},  //   _مواف, klit_, _gulo_,
  { {0x21b501fb, 0xdbdf000c, 0xa2950245, 0x00000000}},  //   ийня, _líðu, рамі,
  { {0x667b0049, 0x463b0049, 0x067b0097, 0x00000000}},  //   _אטאק, _רעדע, _אנאל,
  { {0x7c2e0091, 0x3e67006c, 0x634a006b, 0x00000000}},  //   _nabr, _mõte_, həni,
  { {0x634a005f, 0x442e0039, 0x316b0036, 0x00000000}},  //   kəni, _iaf_, szcz_,
  { {0x442e0016, 0x3ea00d9c, 0x7c2e00e0, 0x00000000}},  //   _haf_, glit_, _aabr,
  { {0x3cee03d7, 0x634a005f, 0x9f4300b9, 0x00000000}},  // [2bf0] ेंगे_, dəni, mají_,
  { {0x442e002b, 0x3ea000b0, 0x9f4300b9, 0x00000000}},  //   _jaf_, alit_, lají_,
  { {0x2baa001c, 0x442e00d9, 0x3ea0164e, 0x00000000}},  //   _करणा, _maf_, blit_,
  { {0x9f4300b9, 0x442e0095, 0x3ea000e5, 0x00000000}},  //   nají_, _laf_, clit_,
  { {0xd945007c, 0xd37804eb, 0x00000000, 0x00000000}},  //   рели, maću_,   ,
  { {0x442e002b, 0x26c51577, 0x2c14007d, 0x00000000}},  //   _naf_, _pulo_, न्दू_,
  { {0xf77103ec, 0x366903f3, 0x270e006b, 0x00000000}},  //   غات_, како_, _yəni_,
  { {0x7c2e037b, 0xbb840054, 0x2baa001c, 0x00000000}},  //   _zabr, _الفي, _करता,
  { {0x81eb0055, 0x9f4300b9, 0x442e164f, 0x00000000}},  //   মলা_, dají_, _baf_,
  { {0x26c51449, 0xf8b90076, 0x22401650, 0x00000000}},  //   _tulo_, _شهاب_, _snik_,
  { {0xd3780107, 0x52aa003b, 0x53a500e2, 0x00000000}},  //   kaću_, квом_, ранб,
  { {0x67b800f9, 0xcb12009b, 0x442e0dfc, 0x00000000}},  //   _صالح_, חלט_, _eaf_,
  { {0x442e1651, 0xd37804eb, 0x00000000, 0x00000000}},  //   _faf_, daću_,   ,
  { {0x442e1652, 0x270e006b, 0x05a80088, 0x00000000}},  //   _gaf_, _səni_, _свій_,
  { {0x634a006b, 0xa2a70061, 0xdee60088, 0x00000000}},  //   yəni, _टीव्, роби,
  { {0xdbdf009f, 0x7c2e01a3, 0x22400390, 0x00000000}},  //   _síðu, _sabr, _unik_,

  { {0x7c2e023a, 0x3ea0000c, 0x645c1653, 0x00000000}},  // [2c00] _pabr, rlit_, örig,
  { {0xa7fc01f6, 0x3ea01654, 0x00000000, 0x00000000}},  //   _alın, slit_,   ,
  { {0x62870428, 0x634a006b, 0xd3780521, 0x00000000}},  //   čkov, təni, baću_,
  { {0xeb970373, 0x628611b2, 0x2c640039, 0x00000000}},  //   ших_, nnko, _döda_,
  { {0x7c2e0093, 0x634a006b, 0x62860cba, 0x00000000}},  //   _tabr, rəni, inko,
  { {0x7d04000b, 0xceb4006b, 0x6e24010f, 0x00000000}},  //   muis, lmə_, leib,
  { {0x7d04021e, 0xa2ca0164, 0x00000000, 0x00000000}},  //   luis, _संध्,   ,
  { {0x442e019a, 0x95d7005e, 0x634a006b, 0x00000000}},  //   _saf_, адът_, qəni,
  { {0x9f4300b9, 0x7d04009d, 0x442e1655, 0x00000000}},  //   vají_, nuis, _paf_,
  { {0x62861656, 0x6e24010f, 0xb8060014, 0x00000000}},  //   enko, heib, _خبره,
  { {0x7d040007, 0x4394025f, 0x1c0b013d, 0x00000000}},  //   huis, санс, स्टल_,
  { {0x7d0400b0, 0x442e0173, 0x628600ea, 0x00000000}},  //   kuis, _waf_, gnko,
  { {0x442e09e2, 0xe4d4025a, 0x61f6018e, 0x00000000}},  //   _taf_, _اقتد, _ddyl,
  { {0xdb1c0df5, 0x7d0400f4, 0x03770123, 0x00000000}},  //   _agrí, duis, احیت_,
  { {0x60d600ea, 0xf0b40088, 0xd3780521, 0x00000000}},  //   _etym, ійсь, taću_,
  { {0x2c640039, 0x5f94003b, 0xdce6014a, 0x00000000}},  //   _röda_, цист, _aykı,
  { {0xa2ca007d, 0x7d0400f4, 0xd90402fd, 0x00000000}},  // [2c10] _सूत्, guis, _تی_,
  { {0x80dd0044, 0xd3780645, 0x00000000, 0x00000000}},  //   _বিপ্, saću_,   ,
  { {0x5b150679, 0x00000000, 0x00000000, 0x00000000}},  //   смет,   ,   ,
  { {0xe8f50025, 0x7d040207, 0x6aa201ee, 0x00000000}},  //   مستخ, buis, glof,
  { {0x3cfe03d7, 0xb927007c, 0x7d04009d, 0x00000000}},  //   _लिये_, рфей, cuis,
  { {0xf1bf0010, 0x00000000, 0x00000000, 0x00000000}},  //   ldás_,   ,   ,
  { {0x81bf0044, 0xda350147, 0x62860024, 0x00000000}},  //   েরি_, _левы, ynko,
  { {0x7c251657, 0x80dd0044, 0xf1bf0010, 0x00000000}},  //   lehr, _বিন্, ndás_,
  { {0x673a01d6, 0x00000000, 0x00000000, 0x00000000}},  //   _ertj,   ,   ,
  { {0xb4650057, 0x9865026c, 0x81bf0044, 0x00000000}},  //   скол, _دیتے_, েরা_,
  { {0x6e241658, 0x673a00d9, 0x60d600b4, 0x00000000}},  //   yeib, _grtj, _stym,
  { {0x99800027, 0x6286002d, 0x00000000, 0x00000000}},  //   žiť_, unko,   ,
  { {0xf65200b6, 0x628602e1, 0xd5480380, 0x00000000}},  //   _מצא_, rnko, _نجوم_,
  { {0x7536007b, 0x1c030061, 0x200c006c, 0x00000000}},  //   _לאנד_, _लागल_, üdi_,
  { {0x44251659, 0x64431446, 0xceb4006b, 0x00000000}},  //   mel_, _inni, tmə_,
  { {0x7d040625, 0x752900e7, 0x00000000, 0x00000000}},  //   tuis, owez,   ,
  { {0x6e24010f, 0x752900b5, 0xceb4006b, 0x00000000}},  // [2c20] reib, nwez, rmə_,
  { {0x4425011f, 0x313700a0, 0x7d040dc9, 0x00000000}},  //   nel_, _פנים_, ruis,
  { {0x291f00b0, 0x7d040052, 0x00000000, 0x00000000}},  //   _apua_, suis,   ,
  { {0xa2ca02f4, 0x4425165a, 0x7d040c7e, 0x00000000}},  //   _संस्, hel_, puis,
  { {0x6443021e, 0x7d04051b, 0x660901b5, 0x00000000}},  //   _onni, quis, dgek,
  { {0xd90d00e9, 0xbb46165b, 0xab2a004d, 0x00000000}},  //   ئیل_, _легк, _йога_,
  { {0x44250390, 0xf1c80164, 0xfaa6007e, 0x00000000}},  //   del_, रखान, _гаво,
  { {0x44250250, 0x6609123b, 0x6443165c, 0x00000000}},  //   eel_, ggek, _anni,
  { {0x44250562, 0x896600da, 0xc966007e, 0x00000000}},  //   fel_, _укаж, _увай,
  { {0xe8d7009b, 0x290600e7, 0x00000000, 0x00000000}},  //   _לומר_, muoa_,   ,
  { {0x2f380173, 0xdc9b08cd, 0x00000000, 0x00000000}},  //   _nčg_, רייל,   ,
  { {0x32670920, 0x6443018e, 0x46690088, 0x00000000}},  //   стов, _enni, _крім_,
  { {0x4425165d, 0x2018002b, 0x00000000, 0x00000000}},  //   bel_, ffri_,   ,
  { {0x44250142, 0x27ee000c, 0xe81b0164, 0x00000000}},  //   cel_, nafn_, प्पा_,
  { {0x447b009b, 0x7c25013e, 0x00000000, 0x00000000}},  //   _תנוע, vehr,   ,
  { {0x7c25010f, 0x290600e7, 0x00000000, 0x00000000}},  //   wehr, kuoa_,   ,
  { {0xdc55012b, 0x463b0049, 0xa7fc014a, 0x00000000}},  // [2c30] овањ, נעמע, _alım,
  { {0xba3d00b9, 0x00000000, 0x00000000, 0x00000000}},  //   _lhůt,   ,   ,
  { {0x50d404e1, 0x212b018e, 0x99d70025, 0x00000000}},  //   _وزیر, lwch_, متشا,
  { {0x4425079a, 0x61ef0035, 0x2be90044, 0x00000000}},  //   zel_, nacl, খলেই_,
  { {0x4425165e, 0x212b018e, 0xa2bc0049, 0x00000000}},  //   yel_, nwch_, אמאט,
  { {0x4425077d, 0x7e6d165f, 0x27ee0016, 0x00000000}},  //   xel_, lhap, gafn_,
  { {0x44251660, 0x2bdf02d2, 0xb8d0007d, 0x00000000}},  //   vel_, _प्या, _टी_,
  { {0x44251661, 0x628d012d, 0x0f7c009b, 0x00000000}},  //   wel_, _njao, טרול,
  { {0x66090007, 0x75290b43, 0x395200ea, 0x00000000}},  //   rgek, uwez, øyst_,
  { {0x6609144a, 0x212b018e, 0x44250bed, 0x00000000}},  //   sgek, dwch_, uel_,
  { {0x224a02b3, 0x7e6d017b, 0x634a013f, 0x00000000}},  //   апни_, khap, dəns,
  { {0x4425061f, 0xe29a06b6, 0xd6ab05d4, 0x00000000}},  //   sel_, рам_, _صدام_,
  { {0xa4f70167, 0x212b0016, 0x2f380087, 0x00000000}},  //   _اکبر_, gwch_, _sčg_,
  { {0x6443000c, 0x316c0036, 0x61ef0045, 0x00000000}},  //   _unni, ądz_, aacl,
  { {0x1fb51662, 0xae7a013a, 0xe81b01f5, 0x00000000}},  //   зстр, асах_, प्या_,
  { {0x00ca1663, 0x7e6d011c, 0x7bd500bb, 0x00000000}},  //   _клик_, ghap, _afzu,
  { {0x63a3018e, 0xf1bf0051, 0x9f4300c4, 0x00000000}},  // [2c40] _hynn, leán_, rajá_,
  { {0xad9b049a, 0x63a31664, 0xdb1c1665, 0x00000000}},  //   _acús, _kynn, _agrá,
  { {0x49ca1666, 0xddc40035, 0xad9b0048, 0x00000000}},  //   ален_, ghiţ, _scút,
  { {0x7e6d1667, 0x09e300ed, 0x63a31668, 0x00000000}},  //   chap, доцн, _mynn,
  { {0x63a301d6, 0x522d0049, 0x00000000, 0x00000000}},  //   _lynn, טואַ,   ,
  { {0x6e36010a, 0x7e640052, 0x00000000, 0x00000000}},  //   ldyb, lkip,   ,
  { {0x7d161669, 0x7c22012d, 0x61ef013f, 0x00000000}},  //   ltys, đord, yacl,
  { {0x27ee009f, 0xf1bf0051, 0x7bc70065, 0x00000000}},  //   safn_, deán_, _zgju,
  { {0xceb3019b, 0x7d160bd7, 0x61ef00d9, 0x00000000}},  //   ויה_, ntys, vacl,
  { {0x31e30183, 0x63a3018e, 0xb86604e8, 0x00000000}},  //   पर्ध, _bynn, _بارو,
  { {0x63a30bc4, 0x61ef0129, 0xe3b8014a, 0x00000000}},  //   _cynn, tacl, ldız_,
  { {0x212b018e, 0x63a30016, 0x00000000, 0x00000000}},  //   twch_, _dynn,   ,
  { {0xa2ca0309, 0x26cc166a, 0x00000000, 0x00000000}},  //   _सूर्, _hudo_,   ,
  { {0x80dd0055, 0x26cc0065, 0x212b0016, 0x00000000}},  //   _বিদ্, _kudo_, rwch_,
  { {0x63a3166b, 0x8f34166c, 0x7e6d0058, 0x00000000}},  //   _gynn, мерц, thap,
  { {0x26cc0325, 0x64580052, 0xa19501e1, 0x00000000}},  //   _mudo_, _hovi, _найч,
  { {0x629d0211, 0x645800b0, 0x7e6d166d, 0x00000000}},  // [2c50] moso, _kovi, rhap,
  { {0x61ed0038, 0x6458003b, 0x2ba7012b, 0x00000000}},  //   _heal, _jovi, ојев,
  { {0x64580866, 0x26cc166e, 0x60cd00e7, 0x00000000}},  //   _movi, _nudo_, _huam,
  { {0x6458001a, 0x7522166f, 0x60cd000b, 0x00000000}},  //   _lovi, _opoz, _kuam,
  { {0xcfbd0044, 0x6d4b0039, 0xd92b005e, 0x00000000}},  //   _অভিন, ågad, рцел_,
  { {0x61ed0066, 0x629d005b, 0x60cd12d9, 0x00000000}},  //   _leal, hoso, _muam,
  { {0x629d1670, 0x26cc1671, 0x25a9050f, 0x00000000}},  //   koso, _cudo_, _šal_,
  { {0x26cc1672, 0xdb1c0010, 0x61ed0471, 0x00000000}},  //   _dudo_, _ugrá, _neal,
  { {0x63a31673, 0x629d008e, 0x65600016, 0x00000000}},  //   _synn, doso, gymh,
  { {0xf1bf0051, 0x645801ed, 0x1309007c, 0x00000000}},  //   teán_, _covi, бной_,
  { {0x61ed1674, 0xbddb00f6, 0x752200f5, 0x00000000}},  //   _beal, _anèm, _epoz,
  { {0xf1bf002a, 0x629d0020, 0x61ed0fff, 0x00000000}},  //   reán_, goso, _ceal,
  { {0xf1bf002a, 0x63a3005b, 0x661b00e7, 0x00000000}},  //   seán_, _wynn, mfuk,
  { {0x653a007b, 0x645801c5, 0x63a30016, 0x00000000}},  //   _לענד, _govi, _tynn,
  { {0x1eaa023c, 0x61ed1675, 0xdfcf0380, 0x00000000}},  //   ماري_, _feal, ايف_,
  { {0x6446001e, 0x61ed0051, 0x7d160052, 0x00000000}},  //   ēkie, _geal, ttys,
  { {0xf1bf002a, 0x60cd01a3, 0x6e360190, 0x00000000}},  // [2c60] neál_, _guam, rdyb,
  { {0x7e641676, 0x61ed00ab, 0x76591677, 0x00000000}},  //   skip, _zeal, _lowy,
  { {0xe8050164, 0x7d161678, 0x6d4b0039, 0x00000000}},  //   _राजा_, stys, ägar,
  { {0x76590046, 0x7d161562, 0x0ae90025, 0x00000000}},  //   _nowy, ptys, تركي_,
  { {0x63a60036, 0x00000000, 0x00000000, 0x00000000}},  //   ękni,   ,   ,
  { {0x26cc0211, 0xa3ab0061, 0x7d041679, 0x00000000}},  //   _pudo_, _खरं_, mris,
  { {0x7522167a, 0x25c1005f, 0xe1ff0036, 0x00000000}},  //   _spoz, ərlə_, chów_,
  { {0x6458167b, 0x80dd0055, 0xfaa301fb, 0x00000000}},  //   _sovi, _বিস্, _засо,
  { {0x6458040d, 0x68e90016, 0x629d02bb, 0x00000000}},  //   _povi, _gwed, voso,
  { {0x26cc02d5, 0x7d04002a, 0x61ed167c, 0x00000000}},  //   _tudo_, iris, _seal,
  { {0xe61a0057, 0x61ed0004, 0x229501e0, 0x00000000}},  //   _где_, _peal, диня,
  { {0x7d040020, 0xbddb01aa, 0xd377007e, 0x00000000}},  //   kris, _enèj, ячы_,
  { {0x629d167d, 0xe534007c, 0x64580052, 0x00000000}},  //   roso, _цель, _tovi,
  { {0x7d040089, 0x61e0005a, 0x55bb00b3, 0x00000000}},  //   dris, ımla, _המדו,
  { {0x629d167e, 0x7c350ed8, 0x25af010f, 0x00000000}},  //   poso, _razr, _zzgl_,
  { {0x7d04010f, 0x816b003b, 0xe0df0026, 0x00000000}},  //   fris, _гроб_, ppò_,
  { {0x823403ec, 0x22490027, 0x786f06ec, 0x00000000}},  // [2c70] _سريا, _inak_, _høve,
  { {0xdfd10025, 0x00000000, 0x00000000, 0x00000000}},  //   _جيد_,   ,   ,
  { {0xaac70070, 0x7d04006c, 0xde590088, 0x00000000}},  //   ستان, aris, _дані_,
  { {0x7d18002a, 0x68e9006a, 0x7d04016e, 0x00000000}},  //   éasá, _pwed, bris,
  { {0x7d0408d3, 0x3ea90039, 0x786f08e0, 0x00000000}},  //   cris, mlat_, _løve,
  { {0x3ea90065, 0x07a50751, 0xc7a50088, 0x00000000}},  //   llat_, малн, милк,
  { {0x12c70055, 0x7659047a, 0x2249167f, 0x00000000}},  //   _শব্দ, _powy, _onak_,
  { {0xd877007a, 0x645c1680, 0x569202ea, 0x00000000}},  //   _کارب, örin, кајт,
  { {0xbddb0173, 0xddcd0006, 0xb8150098, 0x00000000}},  //   _anèk, kiaž, _одај,
  { {0x22491451, 0x249e0009, 0x25a60173, 0x00000000}},  //   _anak_, gotm_, _dyol_,
  { {0x3ea90169, 0x04ff0044, 0x80dd0044, 0x00000000}},  //   klat_, ্বের_, _বিষ্,
  { {0x7d04000c, 0x1fc50044, 0xcfc50044, 0x00000000}},  //   yris, ্রাস, ্রান,
  { {0x66c7014a, 0x3ea90058, 0x22490288, 0x00000000}},  //   _fıkr, dlat_, _dnak_,
  { {0x80dd0055, 0x638501fc, 0x22491681, 0x00000000}},  //   _বিশ্, _огла, _enak_,
  { {0xe29f000c, 0x3ea90035, 0x7d040016, 0x00000000}},  //   boð_, flat_, wris,
  { {0x3ea91682, 0xecea0ae0, 0x00000000, 0x00000000}},  //   glat_, ждал_,   ,
  { {0x32d3001d, 0x7d041683, 0xd12f007a, 0x00000000}},  // [2c80] _hãy_, uris, _نمي_,
  { {0x7d0401bc, 0x22490091, 0x3ac8006b, 0x00000000}},  //   rris, _znak_, _aşpa_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x7d04032c, 0x3ea900d4, 0x201e0173, 0x00000000}},  //   pris, clat_, òtif_,
  { {0x20d408b2, 0xaac50014, 0xbdfb0bb6, 0x00000000}},  //   _jäi_, رتمن, _برپا_,
  { {0xd6da107f, 0x1867017f, 0x00000000, 0x00000000}},  //   оти_, мачи_,   ,
  { {0xf793008b, 0x32d30082, 0xdc3701ce, 0x00000000}},  //   кашэ, _nãy_, _קאלט_,
  { {0xa3c302fb, 0xa534017a, 0x3ea01684, 0x00000000}},  //   ्शन_, енич, noit_,
  { {0x64c80164, 0x26c600e7, 0x786f0146, 0x00000000}},  //   रदेश, _vioo_, _døvb,
  { {0x22490030, 0x80dd0044, 0x00000000, 0x00000000}},  //   _snak_, _বিল্,   ,
  { {0xd37a0aef, 0xe29f01e5, 0x00000000, 0x00000000}},  //   ючи_, toð_,   ,
  { {0x32d30011, 0x0566142c, 0x00000000, 0x00000000}},  //   _dãy_, _овен,   ,
  { {0xa2ca006e, 0xf1ab0014, 0x3ea00035, 0x00000000}},  //   _संक्, تاده_, doit_,
  { {0xdbf30279, 0x961d0089, 0x104b0088, 0x00000000}},  //   _işçi, miņa, цями_,
  { {0xc05801e1, 0x3ea90222, 0x32d30082, 0x00000000}},  //   фія_, tlat_, _gãy_,
  { {0x442c1685, 0x3ea90831, 0x2906012d, 0x00000000}},  //   led_, ulat_, kroa_,
  { {0x3ea91686, 0x442c0016, 0xdfd51001, 0x00000000}},  // [2c90] rlat_, oed_, _попы,
  { {0x442c0038, 0x3ea90224, 0xa1f900a1, 0x00000000}},  //   ned_, slat_, _بڑھا_,
  { {0x3ea90035, 0x628f0cfe, 0x442c005b, 0x00000000}},  //   plat_, onco, ied_,
  { {0x442c1687, 0x2bdf02fb, 0xfbdf02f4, 0x00000000}},  //   hed_, _प्रा, _प्रम,
  { {0x442c0038, 0x26de0207, 0xd82500ed, 0x00000000}},  //   ked_, _atto_, едли,
  { {0x442c0209, 0x6e2d0051, 0x7d0d04cb, 0x00000000}},  //   jed_, leab, muas,
  { {0x442c0038, 0xa2ca02fb, 0x7d0d0169, 0x00000000}},  //   ded_, _संग्, luas,
  { {0xbb48007a, 0x6e2d004a, 0x442c06ed, 0x00000000}},  //   _تلفن_, neab, eed_,
  { {0x79a703f3, 0x442c0016, 0x7d0d0048, 0x00000000}},  //   _црве, fed_, nuas,
  { {0xa2ca02fb, 0xe4510054, 0x442c1688, 0x00000000}},  //   _संख्, اضة_, ged_,
  { {0xe2860751, 0x00000000, 0x00000000, 0x00000000}},  //   елни,   ,   ,
  { {0x644a00f4, 0x7d0d04cb, 0x442c006c, 0x00000000}},  //   _enfi, kuas, aed_,
  { {0x442c0ace, 0x764b0047, 0x1fe10044, 0x00000000}},  //   bed_, _ingy, _বয়স,
  { {0x442c0038, 0x2bdf006e, 0xa06a007e, 0x00000000}},  //   ced_, _प्ला, чага_,
  { {0x3ea0010e, 0x625800fa, 0x00000000, 0x00000000}},  //   toit_, _mãoz,   ,
  { {0x6e2d02a4, 0x7d0d0020, 0x68e20022, 0x00000000}},  //   geab, fuas, ypod,
  { {0x62860288, 0x3ea01689, 0x7d0d168a, 0x00000000}},  // [2ca0] miko, roit_, guas,
  { {0x69db008e, 0xef1a0478, 0xc19b0104, 0x00000000}},  //   _afue, _емо_, _משפי,
  { {0x961d0089, 0xb5fd0089, 0x9f430142, 0x00000000}},  //   ziņa, ekšm, zajú_,
  { {0x442c168b, 0x2906002d, 0x6e2d0133, 0x00000000}},  //   zed_, troa_, ceab,
  { {0x442c0038, 0xd83801d9, 0x6f0e012d, 0x00000000}},  //   yed_, _pač_, lubc,
  { {0x62860d49, 0x2906022b, 0x442c00ab, 0x00000000}},  //   hiko, rroa_, xed_,
  { {0x442c0038, 0x62860315, 0xe66600ec, 0x00000000}},  //   ved_, kiko, етпо,
  { {0x442c168c, 0x6286168d, 0x68e2009d, 0x00000000}},  //   wed_, jiko, ppod,
  { {0x442c0a8a, 0x6286002d, 0xdb1c0051, 0x00000000}},  //   ted_, diko, _ngrú,
  { {0x6aa200c7, 0x9980010a, 0x628601c3, 0x00000000}},  //   loof, žių_, eiko,
  { {0x442c0a8a, 0xb21b00ea, 0x00000000, 0x00000000}},  //   red_, dnær,   ,
  { {0x442c109b, 0x6286168e, 0x00000000, 0x00000000}},  //   sed_, giko,   ,
  { {0x442c00ab, 0x6e2d0056, 0x628f00d9, 0x00000000}},  //   ped_, veab, rnco,
  { {0x6aa20168, 0x74130014, 0x7bce00e0, 0x00000000}},  //   hoof, _موها, _ngbu,
  { {0x02a7102a, 0x53340827, 0x6286168f, 0x00000000}},  //   _прим, _рейт, biko,
  { {0x7bdc0065, 0xb21b101b, 0x00000000, 0x00000000}},  //   _afru, rnæs,   ,
  { {0x6e2d0051, 0x9f4a1690, 0xbbeb0025, 0x00000000}},  // [2cb0] reab, rabá_, كرام_,
  { {0x6e2d008e, 0xf8b80082, 0x00000000, 0x00000000}},  //   seab, _nhĩ_,   ,
  { {0x68fb037e, 0x3944112b, 0x7afc0e0d, 0x00000000}},  //   _svud, _arms_, _cvrt,
  { {0x636b0010, 0x7d0d04cb, 0xd7f10082, 0x00000000}},  //   lönö, puas, _sẽ_,
  { {0x7d0d0026, 0x3a240022, 0xb5fd0006, 0x00000000}},  //   quas, _dbmp_, ukšm,
  { {0x62860006, 0x9be7009e, 0x00000000, 0x00000000}},  //   ziko, _سورۃ_,   ,
  { {0xa695025f, 0x62860a63, 0xe7390256, 0x00000000}},  //   криј, yiko, фей_,
  { {0x6286084b, 0x6edc00ca, 0xbddb000a, 0x00000000}},  //   xiko, _učbe, _enèv,
  { {0xf993004b, 0x628601b1, 0x58d50088, 0x00000000}},  //   _صبر_, viko, _розт,
  { {0x58d400e3, 0x44650679, 0x290f1691, 0x00000000}},  //   _софт, твов, muga_,
  { {0x62861692, 0xfbd200b6, 0xe29a012b, 0x00000000}},  //   tiko, יתי_, дан_,
  { {0x20010022, 0x63aa005b, 0x00000000, 0x00000000}},  //   _adhi_, _dyfn,   ,
  { {0x6286022b, 0xa5640025, 0x290f006c, 0x00000000}},  //   riko, _مدون, nuga_,
  { {0x62860e33, 0x291d0020, 0x78a30052, 0x00000000}},  //   siko, itwa_, nonv,
  { {0x8fa6026b, 0x63aa0016, 0x290f0fc7, 0x00000000}},  //   таве, _gyfn, huga_,
  { {0x291d01aa, 0x7bdc0207, 0x290f006c, 0x00000000}},  //   ktwa_, _sfru, kuga_,
  { {0xc5f20097, 0x78a31693, 0x290f1694, 0x00000000}},  // [2cc0] ידן_, konv, juga_,
  { {0x290f033b, 0x20040006, 0x00000000, 0x00000000}},  //   duga_, ėmis_,   ,
  { {0x78a3000a, 0x00000000, 0x00000000, 0x00000000}},  //   donv,   ,   ,
  { {0xc98601ee, 0x290f00e7, 0x00000000, 0x00000000}},  //   кули, fuga_,   ,
  { {0x6aa2010e, 0x78a300ea, 0x290f010e, 0x00000000}},  //   roof, fonv, guga_,
  { {0x7afc016e, 0xa7fc005d, 0xa3c3013d, 0x00000000}},  //   _tvrt, _alır, ्शा_,
  { {0x7c3c002a, 0x7afc016c, 0x394400fa, 0x00000000}},  //   _iarr, _uvrt, _wrms_,
  { {0x7c3c1695, 0x6d4601ee, 0x7c3e1696, 0x00000000}},  //   _harr, _krka, ldpr,
  { {0x7c3c022b, 0x291d0036, 0x81d80044, 0x00000000}},  //   _karr, ctwa_, িরা_,
  { {0x7c3c022b, 0x78a31697, 0x62840173, 0x00000000}},  //   _jarr, conv, _amio,
  { {0x7c3c071e, 0xd25101ef, 0x64a300ed, 0x00000000}},  //   _marr, مند_, раќа,
  { {0x7c3c022b, 0x6d460039, 0xa77b0049, 0x00000000}},  //   _larr, _orka, _קראפ,
  { {0x95530014, 0x316d004a, 0xaf340014, 0x00000000}},  //   _نخوا, áez_, یرفت,
  { {0x8c080055, 0x25840089, 0x3e750292, 0x00000000}},  //   র্তন_, rīlī_, _måte_,
  { {0x54330188, 0x3ce2142a, 0x6d46114e, 0x00000000}},  //   _ضرور, _atkv_, _arka,
  { {0x443e0018, 0x443c00eb, 0x3cfe006e, 0x00000000}},  //   ldt_, _hav_, _लिखे_,
  { {0x7c3c1698, 0x961d001e, 0x80dd0044, 0x00000000}},  // [2cd0] _barr, ziņo, _বিক্,
  { {0x443e1699, 0x7c3c169a, 0x290f169b, 0x00000000}},  //   ndt_, _carr, vuga_,
  { {0x7c3c04bd, 0x6d46169c, 0x443e00d9, 0x00000000}},  //   _darr, _erka, idt_,
  { {0x7c3c002a, 0x443c0030, 0x99840006, 0x00000000}},  //   _earr, _lav_, _namų_,
  { {0x7c3c0051, 0xe8df0011, 0x443c169d, 0x00000000}},  //   _farr, _trọn_, _oav_,
  { {0x443c169e, 0x7c3c022b, 0x6e3d03b0, 0x00000000}},  //   _nav_, _garr, _hasb,
  { {0x291d169f, 0x46f4007e, 0x290f006c, 0x00000000}},  //   stwa_, ачыт, suga_,
  { {0xc1e30316, 0x443e00b5, 0x7c3c0032, 0x00000000}},  //   _क्लब_, edt_, _zarr,
  { {0x7c3c0095, 0x6e3d033b, 0x7e6d16a0, 0x00000000}},  //   _yarr, _masb, ikap,
  { {0x649d04bd, 0x7c3c16a1, 0x6e3d0116, 0x00000000}},  //   nèix, _xarr, _lasb,
  { {0x461503ec, 0x7e6d00b0, 0xf770023c, 0x00000000}},  //   _موار, kkap, _وام_,
  { {0xe0c9007b, 0x32ba0025, 0x443e00d9, 0x00000000}},  //   _זײ_, عددة_, adt_,
  { {0x443c0048, 0x81ac0044, 0x321e0036, 0x00000000}},  //   _fav_, কেন_, ęty_,
  { {0x40950bbd, 0x443c05cb, 0x80dd0044, 0x00000000}},  //   арст, _gav_, _বিখ্,
  { {0x4427006b, 0x6e3d163c, 0x9f580023, 0x00000000}},  //   _ibn_, _basb, marë_,
  { {0x7c3c022b, 0x7e6d011c, 0x443c0087, 0x00000000}},  //   _sarr, gkap, _zav_,
  { {0x614601f9, 0x1d0700c0, 0x65690093, 0x00000000}},  // [2ce0] _сепа, лети_, nyeh,
  { {0x7c3c002b, 0x9f580023, 0x786f0190, 0x00000000}},  //   _qarr, narë_, _søvn,
  { {0x7c3c0065, 0x16030061, 0x645c0934, 0x00000000}},  //   _varr, ळणार_, örii,
  { {0xe3c50044, 0x7c3c00ab, 0x998d0036, 0x00000000}},  //   _এভাব, _warr, _oceń_,
  { {0x7c3c04bd, 0x443e16a2, 0x6e2402c2, 0x00000000}},  //   _tarr, ydt_, mfib,
  { {0x61f60279, 0x60d60058, 0x6d4416a3, 0x00000000}},  //   _leyl, _muym, mvia,
  { {0x6d4400d4, 0x443c0253, 0x9f580023, 0x00000000}},  //   lvia, _rav_, darë_,
  { {0x443c16a4, 0x9b930054, 0xfaa616a5, 0x00000000}},  //   _sav_, _الفت, _сабо,
  { {0x6d440a53, 0xd94301e0, 0x443c007f, 0x00000000}},  //   nvia, _лети, _pav_,
  { {0x443e00bb, 0xe8d70104, 0xd5c0013d, 0x00000000}},  //   udt_, _עובר_, शेषज,
  { {0x443e0662, 0x61f6014a, 0x7e6d011c, 0x00000000}},  //   rdt_, _beyl, ykap,
  { {0x201a0066, 0x61f60095, 0x443e00d9, 0x00000000}},  //   _acpi_, _ceyl, sdt_,
  { {0x443c0ed6, 0x6d440027, 0x61f8007e, 0x00000000}},  //   _tav_, jvia, ыняў_,
  { {0x60d6005a, 0x00000000, 0x00000000, 0x00000000}},  //   _duym,   ,   ,
  { {0xb4c002fb, 0xb4c2007d, 0x7e6d16a6, 0x00000000}},  //   ंगी_, ्दी_, tkap,
  { {0xe80e013d, 0x764016a7, 0x38bb01d6, 0x00000000}},  //   _साझा_, ndmy, mêre_,
  { {0xb8040164, 0x5d55026b, 0x7d1d0009, 0x00000000}},  // [2cf0] रणाम_, шкат, _qqss,
  { {0x7e6d0292, 0x9ed900e3, 0x673a006c, 0x00000000}},  //   skap, _имот_, _ostj,
  { {0x649d0129, 0x6e3d16a8, 0xd1b800a1, 0x00000000}},  //   rèix, _tasb, _لایا_,
  { {0x81f30044, 0x61f6006b, 0x6e3d0093, 0x00000000}},  //   _ঝাঁপ_, _xeyl, _uasb,
  { {0xc27c0049, 0xe9d8007e, 0x527c0049, 0x00000000}},  //   ערדי, укі_, ענדא,
  { {0x1bd416a9, 0x7d0d0f3e, 0xa96600e2, 0x00000000}},  //   _горя, mras, риша_,
  { {0x9f580023, 0x00000000, 0x00000000, 0x00000000}},  //   varë_,   ,   ,
  { {0x673a0087, 0x00000000, 0x00000000, 0x00000000}},  //   _dstj,   ,   ,
  { {0x9f580065, 0x7d0d014a, 0x4427107b, 0x00000000}},  //   tarë_, nras, _pbn_,
  { {0x032500ec, 0xddc40006, 0x291f00f6, 0x00000000}},  //   адон, nkiš, _iqua_,
  { {0xe1ff0046, 0x3a3f069e, 0x44270296, 0x00000000}},  //   nków_, _kaup_, _vbn_,
  { {0x80dd0055, 0x216a0088, 0x614600a5, 0x00000000}},  //   _বিজ্, вими_, аема,
  { {0x34950264, 0xe2970057, 0x44270082, 0x00000000}},  //   _кадр, рая_, _tbn_,
  { {0xd466012b, 0x6d440197, 0xe5c4007e, 0x00000000}},  //   _више_, vvia, _усхо,
  { {0x26cf0009, 0x6e240026, 0x7d0d16aa, 0x00000000}},  //   _kigo_, tfib, eras,
  { {0x7d0d049a, 0xe1ff0036, 0x9f5812b2, 0x00000000}},  //   fras, dków_, naré_,
  { {0xac860088, 0x26cf008e, 0x629d004a, 0x00000000}},  // [2d00] агал, _migo_, éroe,
  { {0xd12f089d, 0x0eb80061, 0x26cf16ab, 0x00000000}},  //   _کمی_, _आठवड, _ligo_,
  { {0x6d4406c2, 0xdddd0010, 0x2abc008e, 0x00000000}},  //   svia, _első, híbe_,
  { {0x6da60088, 0x64410022, 0x7d0d16ac, 0x00000000}},  //   _вима, hdli, bras,
  { {0x44e916ad, 0x29000181, 0x9f580b32, 0x00000000}},  //   _nº_, éia_, daré_,
  { {0x201816ae, 0x3706007c, 0x3eb216af, 0x00000000}},  //   ngri_, ачив, llyt_,
  { {0x64410186, 0x26cf16b0, 0x291f0026, 0x00000000}},  //   ddli, _bigo_, _equa_,
  { {0x6441010f, 0x22400149, 0xeb9701fb, 0x00000000}},  //   edli, _naik_, _тис_,
  { {0xd5b707ca, 0x26cf0b76, 0x44250678, 0x00000000}},  //   ись_, _digo_, ffl_,
  { {0xb4c003d7, 0x38bb0007, 0x64410270, 0x00000000}},  //   ंगे_, têre_, gdli,
  { {0x22400149, 0x39460006, 0x3e750039, 0x00000000}},  //   _baik_, lvos_, _låta_,
  { {0xc5f00055, 0x644116b1, 0x9f5816b2, 0x00000000}},  //   _টাকা_, adli, caré_,
  { {0x22400022, 0x867b00a0, 0x00000000, 0x00000000}},  //   _daik_, _בראו,   ,
  { {0x83f80069, 0x7d0d16b3, 0x27fc05ba, 0x00000000}},  //   _секс_, vras, navn_,
  { {0x06fd00b9, 0x224016b4, 0x3eb200ea, 0x00000000}},  //   žívá_, _faik_, flyt_,
  { {0x27fc0030, 0x2c190061, 0x2a64000a, 0x00000000}},  //   havn_, _पाहू_, _nomb_,
  { {0x6d400059, 0xdb1c0036, 0x3a3f0022, 0x00000000}},  // [2d10] _šmar, _ogró, _raup_,
  { {0x7d0d021e, 0xe1ff0036, 0x9f5816b5, 0x00000000}},  //   rras, tków_, zaré_,
  { {0x291f0061, 0x3a3f000a, 0x2a640133, 0x00000000}},  //   _squa_, _paup_, _bomb_,
  { {0x7d0d1669, 0x61fd001c, 0xde590245, 0x00000000}},  //   pras, nasl, _самі_,
  { {0x39490211, 0x0dcb00ed, 0xd9450726, 0x00000000}},  //   ías_, _јуни_, сели,
  { {0x26cf0211, 0x3ea913a2, 0xf8a8007e, 0x00000000}},  //   _sigo_, loat_, авік_,
  { {0x61fd022b, 0x9f580b32, 0x261b0204, 0x00000000}},  //   kasl, taré_, _यादी_,
  { {0x2f98009b, 0x61fd0089, 0x7d1b01a2, 0x00000000}},  //   יכון_, jasl, _äuss,
  { {0x26cf049a, 0x880704e8, 0x497516b6, 0x00000000}},  //   _vigo_, _نظام, _улас,
  { {0x9f5812b2, 0x26cf00e7, 0x26c40026, 0x00000000}},  //   saré_, _wigo_, ammo_,
  { {0x644104b2, 0xa25b00c4, 0x9f58009d, 0x00000000}},  //   rdli, rmôn, paré_,
  { {0x27210211, 0x6f1504a8, 0x625a0364, 0x00000000}},  //   món_, duzc, урор_,
  { {0x272116b7, 0xa5090088, 0x95cb003b, 0x00000000}},  //   lón_, _села_, _ружа_,
  { {0x645c00b0, 0x00000000, 0x00000000, 0x00000000}},  //   örit,   ,   ,
  { {0x2721027b, 0xb21b0030, 0xdee6007c, 0x00000000}},  //   nón_, dhæf, соби,
  { {0x39460006, 0x225200d6, 0xbda60025, 0x00000000}},  //   yvos_, _unyk_, محذو,
  { {0xed5708d6, 0x272116b8, 0x00000000, 0x00000000}},  // [2d20] бот_, hón_,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x272116b9, 0xdb1c00d4, 0x5f460426, 0x00000000}},  //   jón_, _agrò, _انجل,
  { {0x2721008e, 0x82d60049, 0xa3c90061, 0x00000000}},  //   dón_, צונג_, लेय_,
  { {0xceb4006b, 0x186a0088, 0x92e30044, 0x00000000}},  //   mlə_, лади_, _ফটো_,
  { {0xfce30057, 0x39460010, 0x27210027, 0x00000000}},  //   _хоро, rvos_, fón_,
  { {0x27210211, 0xa3c901f5, 0x61e40035, 0x00000000}},  //   gón_, लेम_, _ofil,
  { {0xceb4006b, 0x20cf0066, 0x2d8001c3, 0x00000000}},  //   nlə_, _ażil_, ozie_,
  { {0x2d8016ba, 0xb5fd0089, 0x61fd0010, 0x00000000}},  //   nzie_, ekšs, vasl,
  { {0xd6d205f3, 0xb86516bb, 0x2721008e, 0x00000000}},  //   _فقط_, _والو, bón_,
  { {0xceb4005f, 0x27210efe, 0x61fd01c5, 0x00000000}},  //   klə_, cón_, tasl,
  { {0x41e4007e, 0x9c87093f, 0x29000006, 0x00000000}},  //   зіра, _kočá, šiau_,
  { {0x61fd00ee, 0xb5fd007f, 0x645c16bc, 0x00000000}},  //   rasl, rkšt, öris,
  { {0x2d8016bd, 0x61fd006b, 0x236a0025, 0x00000000}},  //   dzie_, sasl, _محبي_,
  { {0x61e4018e, 0x4fc40b49, 0x93fb0097, 0x00000000}},  //   _ffil, зста, _גלוי,
  { {0x5f94005e, 0xa195005e, 0x00000000, 0x00000000}},  //   чист, _майч,   ,
  { {0x27210845, 0x2d58041f, 0x628f16be, 0x00000000}},  // [2d30] zón_, бить_, mico,
  { {0xebc7003b, 0x6f1504de, 0x9d1800e2, 0x00000000}},  //   бљен, puzc, софт_,
  { {0xb5fd0059, 0xb21b000c, 0x2721004a, 0x00000000}},  //   ljše, rhæf, xón_,
  { {0x2721004a, 0x61e416bf, 0x7e6600d9, 0x00000000}},  //   vón_, _xfil, _gokp,
  { {0xae1a007b, 0xd5a600a1, 0xb5fd00ca, 0x00000000}},  //   _דורכ, _آف_, njše,
  { {0x272116c0, 0x628f0035, 0x00000000, 0x00000000}},  //   tón_, hico,   ,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x27210211, 0xb5fd0089, 0x628f0466, 0x00000000}},  //   rón_, ekšr, jico,
  { {0x2721027b, 0x628f029d, 0x00000000, 0x00000000}},  //   són_, dico,   ,
  { {0x27210211, 0x73050088, 0x61e40197, 0x00000000}},  //   pón_, опоз, _sfil,
  { {0x628f029d, 0x32090058, 0xe7ef0061, 0x00000000}},  //   fico, _bday_, _घ्या_,
  { {0x628f029d, 0xd57516c1, 0xe297078e, 0x00000000}},  //   gico, _муль, жаю_,
  { {0x2a3a0049, 0xceb4006b, 0x7e6600e0, 0x00000000}},  //   בערמ, vlə_, _rokp,
  { {0x201e16c2, 0x00000000, 0x00000000, 0x00000000}},  //   üti_,   ,   ,
  { {0xceb4005f, 0x7e660058, 0x64430035, 0x00000000}},  //   tlə_, _pokp, _iani,
  { {0x661b16c3, 0x394d145d, 0xee3a00e1, 0x00000000}},  //   nguk, _ores_, јна_,
  { {0x64430811, 0x7fd60099, 0xceb4005f, 0x00000000}},  // [2d40] _kani, _міні, rlə_,
  { {0xceb4006b, 0x2d800142, 0x00000000, 0x00000000}},  //   slə_, rzie_,   ,
  { {0xe9da0aed, 0x6a8616c4, 0x2904012d, 0x00000000}},  //   аке_, олжа, _svma_,
  { {0x644316c5, 0x9c8700b9, 0x394d005b, 0x00000000}},  //   _lani, _počá, _bres_,
  { {0x81ac0055, 0x59a50061, 0xdb0700b9, 0x00000000}},  //   কের_, गॅलर, _vyjá,
  { {0x6443006a, 0xc17300b6, 0xd90d007a, 0x00000000}},  //   _nani, וחד_, ایل_,
  { {0x8b2302a8, 0x394d0211, 0xe3a70084, 0x00000000}},  //   _одре, _eres_, _آر_,
  { {0xba1a0025, 0x64430058, 0x7d040dc9, 0x00000000}},  //   _خيرا_, _aani, osis,
  { {0x6443001a, 0x628f0142, 0xd90d025a, 0x00000000}},  //   _bani, vico, _مین_,
  { {0x64430bab, 0x7d0416c6, 0xe46a09da, 0x00000000}},  //   _cani, isis, ршил_,
  { {0x628f10d7, 0x7d040d85, 0x00000000, 0x00000000}},  //   tico, hsis,   ,
  { {0x7d04021e, 0xd377008b, 0xdb211152, 0x00000000}},  //   ksis, ючы_, étét,
  { {0x628f0198, 0x644316c7, 0x66d50006, 0x00000000}},  //   rico, _fani, _iška,
  { {0x6443006a, 0x628f0489, 0x66000145, 0x00000000}},  //   _gani, sico, lamk,
  { {0x628f0181, 0x442e04b3, 0x44e00011, 0x00000000}},  //   pico, _ibf_, _hò_,
  { {0x644300ee, 0x7c2e16c8, 0x44e00263, 0x00000000}},  //   _zani, _abbr, _kò_,
  { {0xd90400e9, 0x7d04006a, 0xdddd0036, 0x00000000}},  // [2d50] _جی_, gsis, _posł,
  { {0x44e016c9, 0xfc330025, 0x6ed50036, 0x00000000}},  //   _mò_, بحر_, _dąbr,
  { {0x68e902cc, 0x44e012ba, 0x66001636, 0x00000000}},  //   _sted, _lò_, kamk,
  { {0x7c2e065d, 0x660005cd, 0x787d000a, 0x00000000}},  //   _ebbr, jamk, _mève,
  { {0x44e001aa, 0x2292089f, 0x81cd0044, 0x00000000}},  //   _nò_, nška_, শুর_,
  { {0x628d000a, 0x3e7c00b9, 0x442e00d9, 0x00000000}},  //   _lmao, _víte_, _nbf_,
  { {0xf771031d, 0x6443037e, 0x68e90036, 0x00000000}},  //   عات_, _rani, _wted,
  { {0x394d16ca, 0x44e016cb, 0x05650088, 0x00000000}},  //   _tres_, _bò_, звин,
  { {0x644316cc, 0x79820036, 0x44e00082, 0x00000000}},  //   _pani, czow, _cò_,
  { {0x442e00c4, 0x44e016cd, 0xd87701af, 0x00000000}},  //   _cbf_, _dò_, _بارب,
  { {0xf1a900bd, 0x2292010a, 0x0322007e, 0x00000000}},  //   _עס_, eška_, ндэн,
  { {0xe29a08fd, 0x64430149, 0x44e00263, 0x00000000}},  //   сам_, _wani, _fò_,
  { {0x64430036, 0x2bb802f4, 0x44e00011, 0x00000000}},  //   _tani, _अर्थ, _gò_,
  { {0x7ae916ce, 0x15420478, 0xf09f00d4, 0x00000000}},  //   _četn, _чешм, dràs_,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x3e6e009f, 0x7d0400b0, 0x6d4f0087, 0x00000000}},  //   _nýtt_, tsis, _brca,
  { {0xed5700ed, 0x44e0159f, 0x7d0400e5, 0x00000000}},  // [2d60] пот_, _xò_, usis,
  { {0x7d0416cf, 0x6e2f0061, 0xe0580014, 0x00000000}},  //   rsis, _ebcb, _بیست_,
  { {0x6d4f0095, 0x66000022, 0x00000000, 0x00000000}},  //   _erca, yamk,   ,
  { {0x61e60b3d, 0x7d0400b0, 0xfaa30245, 0x00000000}},  //   nckl, psis, нахо,
  { {0x7d040023, 0x6d4f16d0, 0x9f5800d4, 0x00000000}},  //   qsis, _grca, larà_,
  { {0x79820036, 0x44e00082, 0x91bb009b, 0x00000000}},  //   rzow, _rò_, זמני,
  { {0xa3ab03d7, 0x6d4f16d1, 0x44e016d2, 0x00000000}},  //   _कुल_, _zrca, _sò_,
  { {0x44e016d3, 0x442e0203, 0x7e760146, 0x00000000}},  //   _pò_, _sbf_, nkyp,
  { {0x660001a3, 0x3f83002b, 0xa3c9007d, 0x00000000}},  //   ramk, zzju_, लेस_,
  { {0x69c00119, 0x628d002a, 0x66000218, 0x00000000}},  //   _izme, _smao, samk,
  { {0xd25100d3, 0x442e16d4, 0x9f5800d4, 0x00000000}},  //   نند_, _vbf_, jarà_,
  { {0x9f580129, 0xa75b009b, 0x44e0099c, 0x00000000}},  //   darà_, _לדבר, _tò_,
  { {0xc05b01fb, 0x6ed60204, 0x2906012d, 0x00000000}},  //   бів_, _मंजु, nsoa_,
  { {0x26de027f, 0x2292050f, 0x9f5800f6, 0x00000000}},  //   _kuto_, rška_, farà_,
  { {0xb5fd01ae, 0x6458051b, 0x9f580129, 0x00000000}},  //   ljša, _invi, garà_,
  { {0x81ac0055, 0x02a4008b, 0x26de16d5, 0x00000000}},  //   কেই_, _прым, _muto_,
  { {0x2d580057, 0xb5fd0059, 0x442c00bb, 0x00000000}},  // [2d70] пить_, njša, ofd_,
  { {0x6d4f0107, 0x9f580129, 0xddc6000a, 0x00000000}},  //   _vrca, barà_, _makň,
  { {0x200316d6, 0x644816d7, 0x629d068f, 0x00000000}},  //   maji_, iddi, onso,
  { {0x20030052, 0x2ea80061, 0x629d00ea, 0x00000000}},  //   laji_, ककृत, nnso,
  { {0x186900c0, 0x9f580b33, 0x6d4f001a, 0x00000000}},  //   жали_, mará_, _urca,
  { {0x200316d8, 0x26de13b1, 0x9f5816d9, 0x00000000}},  //   naji_, _buto_, lará_,
  { {0x47d00044, 0x6d4d01d6, 0x61e600f8, 0x00000000}},  //   _স্বী, lvaa, yckl,
  { {0x6e2d004e, 0x9f5800dc, 0x442c00b5, 0x00000000}},  //   nfab, nará_, efd_,
  { {0x200316da, 0x6d4d16db, 0x442c16dc, 0x00000000}},  //   kaji_, nvaa, ffd_,
  { {0xd90d026c, 0x200316dd, 0x2b430066, 0x00000000}},  //   _میچ_, jaji_, _ksjc_,
  { {0x20030235, 0x06d70044, 0x3e7c000c, 0x00000000}},  //   daji_, _সবকি, _líta_,
  { {0x64480061, 0x9f5816de, 0x60c500e0, 0x00000000}},  //   addi, jará_, _ahhm,
  { {0x9f580b33, 0x26de0107, 0x765901c3, 0x00000000}},  //   dará_, _zuto_, _inwy,
  { {0x9f580129, 0x20030020, 0x76490c87, 0x00000000}},  //   tarà_, gaji_, ldey,
  { {0x6e2d16df, 0x7e640093, 0x98a4007f, 0x00000000}},  //   ffab, tjip, _esmė_,
  { {0x9f581195, 0x7649014a, 0x00000000, 0x00000000}},  //   gará_, ndey,   ,
  { {0x7529001a, 0xdb0e01dc, 0xe8df0011, 0x00000000}},  // [2d80] ntez, _vybí, _trộn_,
  { {0x69db00c4, 0xfbd201d8, 0x7e7d02a9, 0x00000000}},  //   _ague, نتا_, _elsp,
  { {0xaec616e0, 0x9f580285, 0x0ae90025, 0x00000000}},  //   _обол, bará_, كرني_,
  { {0x9f58029d, 0x99dd0161, 0x290600b0, 0x00000000}},  //   cará_, _daňo, tsoa_,
  { {0x64480bc4, 0x752911b7, 0xa96701fc, 0x00000000}},  //   yddi, jtez, мица_,
  { {0xd6ea092b, 0x3ead0618, 0x69db002d, 0x00000000}},  //   офил_, čete_, _egue,
  { {0x290602d5, 0x75290026, 0x00000000, 0x00000000}},  //   ssoa_, etez,   ,
  { {0x2003000b, 0xc9560057, 0x786f0146, 0x00000000}},  //   zaji_, _отзы, _bøvs,
  { {0x200316e1, 0x6f1c031e, 0x69c00091, 0x00000000}},  //   yaji_, hurc, _uzme,
  { {0x26de16e2, 0x1620001c, 0x9f580b76, 0x00000000}},  //   _tuto_, _यावर_, zará_,
  { {0xd62a16e3, 0x6448018e, 0x200300ca, 0x00000000}},  //   _може_, rddi, vaji_,
  { {0x6f1c010f, 0x20030020, 0x7d1600ea, 0x00000000}},  //   durc, waji_, krys,
  { {0x2003000b, 0x60d70142, 0x9f580b33, 0x00000000}},  //   taji_, _pixm, vará_,
  { {0x656f010f, 0x7d160065, 0x7bdc0022, 0x00000000}},  //   äche, drys, _ngru,
  { {0x9f580489, 0xa295008b, 0x200316e4, 0x00000000}},  //   tará_, _пакі, raji_,
  { {0x7bdc06c2, 0x4ea400e3, 0x6d4d00b5, 0x00000000}},  //   _agru, вруа, tvaa,
  { {0x9f580489, 0x20030020, 0xdd940147, 0x00000000}},  // [2d90] rará_, paji_, ваты,
  { {0x315600b6, 0x6d4d16e5, 0x9f580b33, 0x00000000}},  //   _ניתן_, rvaa, sará_,
  { {0x9f580285, 0x6f1c0035, 0x6d4d00b0, 0x00000000}},  //   pará_, curc, svaa,
  { {0x75290065, 0x7d1616e6, 0x2249006c, 0x00000000}},  //   ytez, brys, _jaak_,
  { {0x224906b2, 0x801806c6, 0xf5480011, 0x00000000}},  //   _maak_, _عزیز_, _nụ_,
  { {0x68e016e7, 0x2a660026, 0x2b4300d4, 0x00000000}},  //   _dumd, ajob_, _tsjc_,
  { {0x7afc018e, 0x38c900a1, 0x2001006c, 0x00000000}},  //   _gwrt, _ہائی_, _mehi_,
  { {0x060901e0, 0x75290282, 0x26c600e7, 0x00000000}},  //   чник_, ttez, _choo_,
  { {0xf548001d, 0x7649014a, 0x75290026, 0x00000000}},  //   _cụ_, rdey, utez,
  { {0x75290181, 0x336516e8, 0xf5480011, 0x00000000}},  //   rtez, евог, _dụ_,
  { {0xa3c9006e, 0x291d011c, 0xe8d6009b, 0x00000000}},  //   लें_, luwa_, _נוער_,
  { {0xbbdc013d, 0x2292050f, 0x75290035, 0x00000000}},  //   _बल्क, rško_, ptez,
  { {0x20010032, 0x45220044, 0x26cd0026, 0x00000000}},  //   _behi_, _বৈঠক_, mmeo_,
  { {0x03a50256, 0x2a6d006c, 0x6f1c0145, 0x00000000}},  //   _пило, _loeb_, turc,
  { {0xc7b2007b, 0x2a7f005f, 0x2baf03d7, 0x00000000}},  //   ָבן_, _olub_, _जुला,
  { {0x291d0be3, 0x9f5c0359, 0x6833038c, 0x00000000}},  //   kuwa_, _því_, lıdı,
  { {0xafe600ed, 0x291d00e7, 0xe3b8014a, 0x00000000}},  // [2da0] _попл, juwa_, ngın_,
  { {0x2a66152f, 0x224900b5, 0xb21b0030, 0x00000000}},  //   wjob_, _zaak_, nhæn,
  { {0x2a660066, 0x2a7f0cfe, 0xddcd0091, 0x00000000}},  //   tjob_, _blub_, rkaš,
  { {0x09e603e0, 0x7d160fb6, 0xb9060783, 0x00000000}},  //   ходн, prys, ездк,
  { {0x2a6616e9, 0x3ea00052, 0x1c1e0061, 0x00000000}},  //   rjob_, mnit_, _पाऊल_,
  { {0x3b0a0c96, 0x6d4601d9, 0x3ea016ea, 0x00000000}},  //   _него_, _iska, lnit_,
  { {0x3ea00065, 0x7c3e16eb, 0x2a6616ec, 0x00000000}},  //   onit_, mepr, pjob_,
  { {0x3ea009f0, 0x9405006b, 0xa5340088, 0x00000000}},  //   nnit_, milə_, внич,
  { {0x224916ed, 0x3ea01449, 0xb21b0030, 0x00000000}},  //   _raak_, init_, fhæn,
  { {0xf548001d, 0x224916ee, 0x26c6016b, 0x00000000}},  //   _vụ_, _saak_, _whoo_,
  { {0x7ae910ec, 0xd7640014, 0x00000000, 0x00000000}},  //   _četk, _جنای,   ,
  { {0x6d46006c, 0x09d40055, 0xf5480011, 0x00000000}},  //   _oska, _হ্যা, _tụ_,
  { {0x224902ae, 0x638600f4, 0x7c3e00ea, 0x00000000}},  //   _vaak_, _béné, kepr,
  { {0x7c3e05d5, 0x224901d6, 0x660216ef, 0x00000000}},  //   jepr, _waak_, _heok,
  { {0x443e048a, 0x6d4616f0, 0x224900c7, 0x00000000}},  //   met_, _aska, _taak_,
  { {0x443e04d3, 0x626706b4, 0x644a1402, 0x00000000}},  //   let_, _سابق, _hafi,
  { {0x7c3e0019, 0x61ed16f1, 0xdb0e0161, 0x00000000}},  // [2db0] fepr, _ifal, _rybá,
  { {0x6386028c, 0x64840009, 0x7c3e01a2, 0x00000000}},  //   _géné, _dòig, gepr,
  { {0x6d46022b, 0x644a16f2, 0x7f450065, 0x00000000}},  //   _eska, _mafi, _ushq,
  { {0x443e16f3, 0x81ac0055, 0xd9990054, 0x00000000}},  //   het_, কেও_, ونات_,
  { {0x443e0047, 0xd94500d7, 0x61ed0020, 0x00000000}},  //   ket_, тели, _mfal,
  { {0x443e16f4, 0x7c3e049a, 0xa3c2024c, 0x00000000}},  //   jet_, cepr, ्धा_,
  { {0x443e0374, 0x9424006b, 0x61ed0016, 0x00000000}},  //   det_, _ötən_, _ofal,
  { {0x81ac0044, 0x443e00b0, 0x2f5c0049, 0x00000000}},  //   কেট_, eet_, לדונ,
  { {0x443e00f4, 0x644a0061, 0x660200e0, 0x00000000}},  //   fet_, _bafi, _deok,
  { {0x443e05ec, 0x3ea0013e, 0xf990023c, 0x00000000}},  //   get_, znit_, _طبق_,
  { {0x70270044, 0x6833005d, 0x644a16f5, 0x00000000}},  //   য়াজ_, rıdı, _dafi,
  { {0x7c3e0036, 0x6833005d, 0x638600f4, 0x00000000}},  //   zepr, sıdı, _séné,
  { {0x443e0018, 0x6386009d, 0x7c3e0023, 0x00000000}},  //   bet_, _péné, yepr,
  { {0x61ed018e, 0x764b0047, 0x644a01a3, 0x00000000}},  //   _efal, _hagy, _gafi,
  { {0x44270009, 0x7c3e0023, 0x6386009d, 0x00000000}},  //   _icn_, vepr, _véné,
  { {0x644a0471, 0x9405006b, 0x7c3e05d2, 0x00000000}},  //   _zafi, vilə_, wepr,
  { {0x764b0047, 0x3ea016f6, 0x7c3e0207, 0x00000000}},  // [2dc0] _magy, rnit_, tepr,
  { {0x3ea00030, 0x711b0049, 0x9405006b, 0x00000000}},  //   snit_, _קויפ, tilə_,
  { {0x290d000d, 0x7c3e002d, 0x6d460036, 0x00000000}},  //   _avea_, repr, _wska,
  { {0x443e16f7, 0x764b0047, 0x7c3e16f8, 0x00000000}},  //   zet_, _nagy, sepr,
  { {0x443e011f, 0x9405006b, 0x6d4600b0, 0x00000000}},  //   yet_, silə_, _uska,
  { {0x68ed00c4, 0x443e0239, 0x44270045, 0x00000000}},  //   íada, xet_, _ncn_,
  { {0x443e004e, 0x644a06fe, 0x37d50044, 0x00000000}},  //   vet_, _rafi, _স্বর,
  { {0x6e24011c, 0x443e0046, 0x44270129, 0x00000000}},  //   ngib, wet_, _acn_,
  { {0x7ae90166, 0x48e601fb, 0x442716f9, 0x00000000}},  //   _četi, _розв, _bcn_,
  { {0x443e0030, 0x5453007c, 0x644a071f, 0x00000000}},  //   uet_, авьт, _qafi,
  { {0x443e05ec, 0x8c1b0476, 0x261b001c, 0x00000000}},  //   ret_, וויי, _याची_,
  { {0x443e0f3c, 0x92580057, 0x644a0020, 0x00000000}},  //   set_, вают_, _wafi,
  { {0x443e0292, 0x44270190, 0x644a16fa, 0x00000000}},  //   pet_, _fcn_, _tafi,
  { {0x84380054, 0x443e16fb, 0x7414026c, 0x00000000}},  //   _أكثر_, qet_, _صوبا,
  { {0x6aa20f45, 0x61ed0066, 0x00000000, 0x00000000}},  //   knof, _tfal,   ,
  { {0x6e240197, 0x61ed16fc, 0x3e750039, 0x00000000}},  //   ggib, _ufal, _nått_,
  { {0x51870245, 0xa3c20164, 0x70590131, 0x00000000}},  // [2dd0] _шука, ्धव_, _запр_,
  { {0x04140055, 0x673a1220, 0x1acb0309, 0x00000000}},  //   ত্রী_, _optj, िष्ठ,
  { {0xc61a0044, 0x764000b0, 0xdfd1023c, 0x00000000}},  //   থ্যা_, kemy, _ديد_,
  { {0xb21b0030, 0x6aa201d6, 0xdea1025a, 0x00000000}},  //   skæf, gnof, _ایری,
  { {0x76400271, 0x0d64005e, 0x66ea0036, 0x00000000}},  //   demy, _кърм, _ręka,
  { {0x66d50006, 0xfaf3083e, 0x6aa201c3, 0x00000000}},  //   _iški, _نثر_, anof,
  { {0x3e75067e, 0x4427008e, 0x764b16fd, 0x00000000}},  //   _fått_, _rcn_, _pagy,
  { {0x3e75093b, 0x7bc70bf1, 0x25a00b4a, 0x00000000}},  //   _gått_, _izju, _žila_,
  { {0x764b0047, 0xdd12005a, 0x95550025, 0x00000000}},  //   _vagy, _müşt, اخبا,
  { {0x6e240c0a, 0x7c250fb8, 0x22920059, 0x00000000}},  //   zgib, nghr, mški_,
  { {0xe29a0081, 0x7c250048, 0x6d440036, 0x00000000}},  //   еан_, ighr, zwia,
  { {0xad9b029d, 0x955501f7, 0x7d0d16fe, 0x00000000}},  //   _reún, _مختا, ksas,
  { {0xd5bb008b, 0x44270082, 0x9f5816ff, 0x00000000}},  //   _ўсе_, _tcn_, mbré_,
  { {0x62860065, 0x20cf01f3, 0x7d0d0190, 0x00000000}},  //   shko, _bżiq_, dsas,
  { {0x644102ae, 0xe29a0200, 0x44e90082, 0x00000000}},  //   meli, _пак_, _hú_,
  { {0x6441014a, 0xdd920257, 0xb226017a, 0x00000000}},  //   leli, موز_, _смил,
  { {0x6e240240, 0x7d0d006a, 0x44e9000c, 0x00000000}},  // [2de0] rgib, gsas, _jú_,
  { {0x644105fb, 0x44251700, 0x76400036, 0x00000000}},  //   neli, ngl_, zemy,
  { {0x44e90051, 0x61e91701, 0x6441001a, 0x00000000}},  //   _lú_, žele, ieli,
  { {0xa3ab062e, 0x644108b2, 0xaaba00a6, 0x00000000}},  //   _कुछ_, heli, ردار_,
  { {0x44e9009f, 0x64411702, 0x6aa20bc7, 0x00000000}},  //   _nú_, keli, rnof,
  { {0x6441096f, 0x7ae90ce4, 0x200a006a, 0x00000000}},  //   jeli, _četv, nabi_,
  { {0xd6da00d7, 0x26dd0263, 0x62841703, 0x00000000}},  //   нти_, _biwo_, _olio,
  { {0x44e90011, 0x60de01c5, 0x66c50010, 0x00000000}},  //   _bú_, _lipm, tóka,
  { {0x764004b3, 0x64411704, 0x49ca012b, 0x00000000}},  //   remy, feli, _члан_,
  { {0x644102ae, 0x27f701c8, 0x6284000b, 0x00000000}},  //   geli, čení_, _alio,
  { {0xd7ef0054, 0x44e90027, 0x628404a5, 0x00000000}},  //   _ركن_, _eú_, _blio,
  { {0x75200020, 0x62841705, 0xf12700c2, 0x00000000}},  //   pumz, _clio, льго,
  { {0x5184013b, 0xd37800b4, 0x00000000, 0x00000000}},  //   бура, syć_,   ,
  { {0x6441014a, 0x224d018b, 0x6284006c, 0x00000000}},  //   celi, žek_, _elio,
  { {0x447b007b, 0x1ee7007a, 0xdfd50783, 0x00000000}},  //   _אנגע, اوری_, ровы,
  { {0x7d0d0943, 0x62841706, 0xf3130688, 0x00000000}},  //   tsas, _glio, _ابوظ,
  { {0xe2140380, 0xddc60006, 0x320b0133, 0x00000000}},  // [2df0] _طبيع, _pokš, macy_,
  { {0x7d0d1707, 0x320b0036, 0x7af70045, 0x00000000}},  //   rsas, lacy_, tpxt,
  { {0x7d0d00b0, 0x6284021e, 0x9f51004a, 0x00000000}},  //   ssas, _ylio, razó_,
  { {0x7c250051, 0xdb1c0065, 0x639b0049, 0x00000000}},  //   sghr, _zyrë, עסאנ,
  { {0x44250016, 0x6441014a, 0x7ae900ca, 0x00000000}},  //   ygl_, yeli, _četu,
  { {0x7e6d006c, 0x26dd01aa, 0xfc67005e, 0x00000000}},  //   ljap, _siwo_, _съмн,
  { {0x44e91708, 0xb5fd0059, 0x26dd1709, 0x00000000}},  //   _sú_, ljši, _piwo_,
  { {0x6441046a, 0x7f3c007b, 0xb8eb0044, 0x00000000}},  //   weli, געהו, _রং_,
  { {0x64410027, 0xc4850098, 0x26c30089, 0x00000000}},  //   teli, илик, ējo_,
  { {0x99840054, 0x7ae7008d, 0x62840051, 0x00000000}},  //   _الكو, _kujt, _slio,
  { {0x6266170a, 0x61ef0061, 0x200a00ca, 0x00000000}},  //   авна, fccl, vabi_,
  { {0x44e90195, 0xe29a008b, 0xc5d501fb, 0x00000000}},  //   _tú_, там_, _кіль,
  { {0x644100b0, 0x2731001d, 0x200a011c, 0x00000000}},  //   peli, _hơn_, tabi_,
  { {0xe3b00014, 0x00000000, 0x00000000, 0x00000000}},  //   _کره_,   ,   ,
  { {0xb4c30201, 0xb4c10164, 0x200a0087, 0x00000000}},  //   ्षी_, ंती_, rabi_,
  { {0x6284000b, 0x200a006a, 0x320b0133, 0x00000000}},  //   _ulio, sabi_, cacy_,
  { {0xb2bb00b6, 0x614600ed, 0x61e403d8, 0x00000000}},  // [2e00] _במקר, _тепа, _igil,
  { {0x6723033b, 0xc5d70044, 0xf8a50167, 0x00000000}},  //   kunj, _সভাপ, _رک_,
  { {0x0b4607e1, 0xa3c90061, 0x67230093, 0x00000000}},  //   рнен, लेच_, junj,
  { {0x5336007b, 0xb4c102f4, 0x7e6d0023, 0x00000000}},  //   ינען_, ंतु_, cjap,
  { {0x656f010f, 0xe6da000c, 0x00000000, 0x00000000}},  //   ächl, ðsíð,   ,
  { {0x57f303f3, 0xfb260014, 0x00000000, 0x00000000}},  //   општ, _پرسپ,   ,
  { {0x27310011, 0xa7b80a78, 0x61e400f8, 0x00000000}},  //   _cơn_, ылку_, _ogil,
  { {0x66c5009f, 0x61e4170b, 0xfaa60245, 0x00000000}},  //   sókn, _ngil, _табо,
  { {0x320b1537, 0x54b8005e, 0x2292016c, 0x00000000}},  //   vacy_, лгия_, nšku_,
  { {0x2bbf0061, 0x6723170c, 0x7ae00048, 0x00000000}},  //   _्रमा, bunj, _himt,
  { {0x947306ea, 0x69c00ced, 0x6723016c, 0x00000000}},  //   تديا, _hyme, cunj,
  { {0x7ae00066, 0x9f61009d, 0x69c00052, 0x00000000}},  //   _jimt, _épée_, _kyme,
  { {0xe298008b, 0x320b077a, 0xe69304e8, 0x00000000}},  //   раў_, racy_, _بلند,
  { {0x61e4170d, 0x653b00a3, 0x69c001a3, 0x00000000}},  //   _egil, _סעוד, _myme,
  { {0x9e07003b, 0xcebb012b, 0xa3b70167, 0x00000000}},  //   ичал, вља_, _پاور_,
  { {0x70270044, 0x33db009b, 0x7ae0170e, 0x00000000}},  //   য়েও_, _בחוד, _nimt,
  { {0x629d001a, 0xe1ff0f11, 0x7e6d01b1, 0x00000000}},  // [2e10] miso, mbó_, rjap,
  { {0x629d00b0, 0xfd4d001d, 0x91bc009b, 0x00000000}},  //   liso, _khoả, _במחי,
  { {0x69c00f57, 0x7ae00022, 0x00000000, 0x00000000}},  //   _ayme, _bimt,   ,
  { {0x67230020, 0x629d0161, 0x69c00007, 0x00000000}},  //   vunj, niso, _byme,
  { {0x2731001d, 0x69c0018e, 0xc87900e5, 0x00000000}},  //   _sơn_, _cyme, _huşi_,
  { {0x6c850054, 0x67230169, 0x00000000, 0x00000000}},  //   _السم, tunj,   ,
  { {0x629d0883, 0x3e7c00b9, 0x00000000, 0x00000000}},  //   kiso, _síti_,   ,
  { {0x9aa5007a, 0x7ae00006, 0x629d170f, 0x00000000}},  //   _امرو, _gimt, jiso,
  { {0xddc60046, 0x69c00016, 0x629d071e, 0x00000000}},  //   _zakł, _gyme, diso,
  { {0xd8740054, 0xb4c3001c, 0x67230091, 0x00000000}},  //   _والب, ्षे_, punj,
  { {0xdb1c00f4, 0x91e60581, 0xe3b10025, 0x00000000}},  //   _pyré, йоне, ثرة_,
  { {0x68e113e4, 0xeb3a0049, 0x629d09a3, 0x00000000}},  //   _hild, נערש, giso,
  { {0x68e101e3, 0x940c006b, 0x00000000, 0x00000000}},  //   _kild, hidə_,   ,
  { {0x037900e9, 0x940c006b, 0x629d0068, 0x00000000}},  //   _محبت_, kidə_, aiso,
  { {0xe3b30070, 0x00000000, 0x00000000, 0x00000000}},  //   _برش_,   ,   ,
  { {0x629d00c4, 0x681b0089, 0x394d0068, 0x00000000}},  //   ciso, lādē, _oses_,
  { {0x7ae00006, 0x00000000, 0x00000000, 0x00000000}},  // [2e20] _rimt,   ,   ,
  { {0x7ae91710, 0x7ae01711, 0xcb6a003b, 0x00000000}},  //   _četr, _simt, лазе_,
  { {0x394d004a, 0x69c01712, 0x80b60061, 0x00000000}},  //   _ases_, _syme, ृतीं,
  { {0x7f3b0049, 0x69c0008e, 0x68e10016, 0x00000000}},  //   _געטו, _pyme, _aild,
  { {0x39130088, 0xb5fd00ca, 0x44fb0325, 0x00000000}},  //   змір, njšu, _nª_,
  { {0xbcfb000c, 0x96f8007e, 0x68e11713, 0x00000000}},  //   _bréf, аект_, _cild,
  { {0xd6d00647, 0x68e1049d, 0xbb860025, 0x00000000}},  //   وقت_, _dild, _الأي,
  { {0x44f40175, 0x629d1714, 0xdd080027, 0x00000000}},  //   опис, xiso, _môže,
  { {0xc9aa008b, 0x68e100f8, 0x68e900c4, 0x00000000}},  //   _свае_, _fild, _gued,
  { {0x68e1009f, 0x0466012b, 0x629d005b, 0x00000000}},  //   _gild, стим, wiso,
  { {0x629d00b0, 0x291903b1, 0x00000000, 0x00000000}},  //   tiso, _åsar_,   ,
  { {0x68e100c4, 0x00000000, 0x00000000, 0x00000000}},  //   _zild,   ,   ,
  { {0x787d0263, 0x629d0835, 0xe1ff1715, 0x00000000}},  //   _sèvi, riso, rbó_,
  { {0x629d0a5b, 0xfd4d0011, 0x7d1f0045, 0x00000000}},  //   siso, _thoả, vrqs,
  { {0x629d0b41, 0x66d50006, 0xe437009b, 0x00000000}},  //   piso, _iškr, _הרוח_,
  { {0x442e0203, 0x7c2e00fa, 0x6e94019d, 0x00000000}},  //   _hcf_, _acbr, пису,
  { {0xe29f009f, 0x5c750745, 0xcc99003b, 0x00000000}},  // [2e30] mið_, олат, авац_,
  { {0xe29f009f, 0x68e91716, 0x00000000, 0x00000000}},  //   lið_, _rued,   ,
  { {0x68e91717, 0xda7b0245, 0xa036009b, 0x00000000}},  //   _sued, ляд_, _ואתה_,
  { {0x68e91718, 0x66f1001e, 0xe29f009f, 0x00000000}},  //   _pued, _nāka, nið_,
  { {0x68e91719, 0x68e10004, 0xa969012b, 0x00000000}},  //   _qued, _pild, рила_,
  { {0x46f50072, 0xbcfb028c, 0x26c40197, 0x00000000}},  //   очит, _préf, elmo_,
  { {0xe29f009f, 0x68e103b4, 0x3ea905f7, 0x00000000}},  //   kið_, _vild, onat_,
  { {0x3ea9171a, 0x68e10f12, 0x68e90016, 0x00000000}},  //   nnat_, _wild, _tued,
  { {0x68e101e3, 0xe29f000c, 0x394d00ab, 0x00000000}},  //   _tild, dið_, _uses_,
  { {0x442e02d0, 0x3ea9171b, 0x68e10026, 0x00000000}},  //   _ccf_, hnat_, _uild,
  { {0xe29f009f, 0x37ab0088, 0x442e171c, 0x00000000}},  //   fið_, _стан_, _dcf_,
  { {0x6d4f002a, 0xe29f009f, 0x6d5d0039, 0x00000000}},  //   _osca, gið_, _orsa,
  { {0x3ea900b9, 0xa509007c, 0x442e0009, 0x00000000}},  //   dnat_, _тела_, _fcf_,
  { {0x394002b9, 0x6e3d171d, 0x00000000, 0x00000000}},  //   çisi_, _absb,   ,
  { {0x6d5d101d, 0x6d4f171e, 0xe3d70044, 0x00000000}},  //   _arsa, _asca, _দ্রব,
  { {0x3ea900f6, 0xd5f90049, 0x6d5d0145, 0x00000000}},  //   gnat_, שפּר, _brsa,
  { {0x660b0047, 0x3ce300b5, 0x648d0051, 0x00000000}},  // [2e40] _megk, _bijv_, _cúig,
  { {0x852103d7, 0x660b171f, 0xa7fc01df, 0x00000000}},  //   _मिनट_, _legk, _anın,
  { {0x6d5d1720, 0x3ea91721, 0xbddb0173, 0x00000000}},  //   _ersa, bnat_, _abèd,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0xbcfb1722, 0x82d70049, 0x00000000, 0x00000000}},  //   _créd, קונג_,   ,
  { {0x3ea01723, 0xb4b3013d, 0x66f10089, 0x00000000}},  //   liit_, झको_, _sāka,
  { {0x443c00d9, 0x2a640022, 0x442e1724, 0x00000000}},  //   _rbv_, _tnmb_, _rcf_,
  { {0x7bce1140, 0xbcfb00f4, 0x9f58008e, 0x00000000}},  //   _izbu, _fréd, laró_,
  { {0x442e0f36, 0x94aa00ed, 0x2d801725, 0x00000000}},  //   _pcf_, итоа_, nyie_,
  { {0x3ea90e25, 0x3ead10f7, 0x7a40000c, 0x00000000}},  //   znat_, četi_, _fátæ,
  { {0xe29f009f, 0x249e0035, 0x442e01a2, 0x00000000}},  //   tið_, ritm_, _vcf_,
  { {0x442e0066, 0x81af0044, 0x00000000, 0x00000000}},  //   _wcf_, _করব_,   ,
  { {0xe29f0359, 0x3ea90802, 0x443c00d9, 0x00000000}},  //   rið_, vnat_, _tbv_,
  { {0xe29f009f, 0xf8ca013d, 0x443c00d6, 0x00000000}},  //   sið_, ितिय, _ubv_,
  { {0xc05801fb, 0x4fc40099, 0x3f850161, 0x00000000}},  //   ція_, дста, álu_,
  { {0x64481726, 0xe2980080, 0x82f700a6, 0x00000000}},  //   ledi, _мај_, _بروز_,
  { {0x3ea90a16, 0x442c00bb, 0x2d58007c, 0x00000000}},  // [2e50] rnat_, ogd_, оить_,
  { {0x6448018e, 0x442c03ed, 0x4d9807d0, 0x00000000}},  //   nedi, ngd_, цкую_,
  { {0x20111727, 0x442c00b5, 0x3ea91728, 0x00000000}},  //   mazi_, igd_, pnat_,
  { {0x20110119, 0xbcfb1729, 0x6448172a, 0x00000000}},  //   lazi_, _préd, hedi,
  { {0x6d4f172b, 0x64480792, 0x6d5d010f, 0x00000000}},  //   _usca, kedi, _ursa,
  { {0x64480363, 0xbcfb028c, 0x1fdf0044, 0x00000000}},  //   jedi, _crée, _ব্যস,
  { {0x64480016, 0x6d4d0112, 0xf7730445, 0x00000000}},  //   dedi, lwaa, باش_,
  { {0x6e2d0f4f, 0x201100e7, 0xbcfb0051, 0x00000000}},  //   ngab, hazi_, _tréd,
  { {0x2011000b, 0x64480adc, 0x6d4d172c, 0x00000000}},  //   kazi_, fedi, nwaa,
  { {0x660b172d, 0x442c0039, 0xa3cf0309, 0x00000000}},  //   _wegk, ggd_, _शरद_,
  { {0xe7f0013d, 0x395f0022, 0x779000a2, 0x00000000}},  //   _चलता_, _hrus_, _لیوا,
  { {0x442c00b5, 0x6d4d01a3, 0x395f172e, 0x00000000}},  //   agd_, kwaa, _krus_,
  { {0x6448172f, 0x6e2d0b5a, 0x6f150036, 0x00000000}},  //   bedi, dgab, eszc,
  { {0x644806c2, 0xb4fa009b, 0x6e2d0197, 0x00000000}},  //   cedi, _הפסי, egab,
  { {0x6e2d010f, 0x66f10089, 0x75290035, 0x00000000}},  //   fgab, _māko, luez,
  { {0x68fb0107, 0x628f0082, 0x88d10044, 0x00000000}},  //   _otud, chco, াদিক,
  { {0x2011002d, 0x9f580129, 0x4c8601fc, 0x00000000}},  // [2e60] bazi_, taró_, плав,
  { {0x313700b6, 0x66f10089, 0x3ea011f6, 0x00000000}},  //   _צריך_, _nāko, siit_,
  { {0x307b00b6, 0x395f0169, 0x6e2d01a2, 0x00000000}},  //   _האינ, _arus_, bgab,
  { {0x316004cd, 0x62860056, 0x64480232, 0x00000000}},  //   _kriz_, nkko, zedi,
  { {0x442c1730, 0x9f58008e, 0xb9e30088, 0x00000000}},  //   ygd_, paró_, ніши,
  { {0x7d1600ea, 0x644800d9, 0x648d0048, 0x00000000}},  //   msys, xedi, _lúib,
  { {0x68fb00f4, 0xa7370025, 0x64480738, 0x00000000}},  //   _etud, كثير_, vedi,
  { {0xd90d089d, 0x2011000b, 0x64480016, 0x00000000}},  //   _چین_, zazi_, wedi,
  { {0x6448011f, 0x7d16010f, 0x75290032, 0x00000000}},  //   tedi, nsys, guez,
  { {0x6aa20020, 0x6f150036, 0xc9170097, 0x00000000}},  //   liof, yszc, _מחמת_,
  { {0x442c00b5, 0x20110020, 0x6d4d00b5, 0x00000000}},  //   rgd_, vazi_, zwaa,
  { {0x20111731, 0xa25b00f4, 0x31601732, 0x00000000}},  //   wazi_, plôm, _briz_,
  { {0x2011001a, 0xd6270088, 0x00000000, 0x00000000}},  //   tazi_, _хоче_,   ,
  { {0xe4d70014, 0xe3af0123, 0x44f2005b, 0x00000000}},  //   _فونت_, ئری_, _iâ_,
  { {0x2011022b, 0x643b009b, 0x543b0049, 0x00000000}},  //   razi_, _העונ, _לעגא,
  { {0x6d4d0112, 0x8c090044, 0x31601733, 0x00000000}},  //   twaa, _লাইন_, _friz_,
  { {0x6e2d1073, 0x7d160270, 0x6d4d00e0, 0x00000000}},  // [2e70] rgab, gsys, uwaa,
  { {0x6d4d015c, 0x6e2d125c, 0x787d009d, 0x00000000}},  //   rwaa, sgab, _lèvr,
  { {0x81af0055, 0x6d4d0b36, 0x29000035, 0x00000000}},  //   _করি_, swaa, ţial_,
  { {0x7aee0129, 0xfbd00025, 0x66f10089, 0x00000000}},  //   _dubt, اتك_, _sāko,
  { {0x81df0044, 0x5c07094b, 0x44f20544, 0x00000000}},  //   দুর_, _нява, _nâ_,
  { {0x81af08b7, 0x224b01a2, 0xccf2009b, 0x00000000}},  //   _করা_, heck_, _בכך_,
  { {0xe7391734, 0x00000000, 0x00000000, 0x00000000}},  //   цей_,   ,   ,
  { {0x395f0169, 0x61e911cc, 0xbcfb0142, 0x00000000}},  //   _trus_, želj, _gréc,
  { {0xb34502d5, 0x09db0044, 0x7d29006b, 0x00000000}},  //   _opçã, _ড্রা, əssü,
  { {0xdeff01d5, 0xb21b0190, 0x628d0052, 0x00000000}},  //   ċċju_, skæl, _alao,
  { {0xdc380049, 0x78a300ca, 0x00000000, 0x00000000}},  //   לאזט_, minv,   ,
  { {0x628d0051, 0x316006af, 0x78a30052, 0x00000000}},  //   _clao, _priz_, linv,
  { {0x6286021e, 0x7529029d, 0x7d160203, 0x00000000}},  //   rkko, quez, xsys,
  { {0x62860004, 0x92ae0055, 0x78a30052, 0x00000000}},  //   skko, কতে_, ninv,
  { {0x1fb50256, 0x81df0044, 0x224b01a2, 0x00000000}},  //   естр, দুল_, beck_,
  { {0xee3a008b, 0x212b010f, 0x628d0051, 0x00000000}},  //   ўна_, buch_, _glao,
  { {0x7afc1735, 0xec7a00c0, 0x78a30190, 0x00000000}},  // [2e80] _strt, опа_, kinv,
  { {0x79820020, 0x00000000, 0x00000000, 0x00000000}},  //   vyow,   ,   ,
  { {0xbcfb028c, 0x00000000, 0x00000000, 0x00000000}},  //   _préc,   ,   ,
  { {0x8b650025, 0x49ca1736, 0x1e831737, 0x00000000}},  //   عالم, олен_, _алюм,
  { {0xd910007a, 0x6aa20197, 0x7bc7000c, 0x00000000}},  //   ایط_, riof, _eyju,
  { {0x787d009d, 0x6aa21738, 0x78a3141a, 0x00000000}},  //   _sèvr, siof, ginv,
  { {0x44f20035, 0x00000000, 0x00000000, 0x00000000}},  //   _sâ_,   ,   ,
  { {0xdb0e0036, 0x7c3e0253, 0xdced0095, 0x00000000}},  //   _wybó, lfpr, nyağ,
  { {0xfaa3003b, 0xfbb00044, 0x00000000, 0x00000000}},  //   _рато, _করিত,   ,
  { {0x337400c0, 0xb8661739, 0x00000000, 0x00000000}},  //   егор, _تارو,   ,
  { {0xe8ca0061, 0xd2510076, 0x224b01a2, 0x00000000}},  //   ितीच, هند_, teck_,
  { {0x68e80339, 0x6d460190, 0x3267173a, 0x00000000}},  //   _hidd, _opka, фтов,
  { {0x68e8173b, 0x656f010f, 0xbcfb009d, 0x00000000}},  //   _kidd, ächt, _oréa,
  { {0x5577007b, 0x212b010f, 0x68e802c0, 0x00000000}},  //   _קעגן_, ruch_, _jidd,
  { {0x68e80141, 0x212b010f, 0x6d4608ad, 0x00000000}},  //   _midd, such_, _apka,
  { {0x645803db, 0x443e173c, 0x645a0190, 0x00000000}},  //   _havi, lft_, ldti,
  { {0x6458173d, 0x7bca010f, 0xbcfb0051, 0x00000000}},  // [2e90] _kavi, üfun, _bréa,
  { {0xbcfb028c, 0x443e001f, 0x68e8002b, 0x00000000}},  //   _créa, nft_, _nidd,
  { {0x64580334, 0x443e173e, 0xbcfb0051, 0x00000000}},  //   _mavi, ift_, _dréa,
  { {0x64580263, 0x41d301f5, 0x68e8006b, 0x00000000}},  //   _lavi, _सरास, _aidd,
  { {0xdb1c01ca, 0x78a31603, 0xbcfb0048, 0x00000000}},  //   _vyrá, tinv, _fréa,
  { {0xbcfb002a, 0x68e8038c, 0x443e02ae, 0x00000000}},  //   _gréa, _cidd, jft_,
  { {0x68e8018e, 0x78a30f80, 0xf09400b3, 0x00000000}},  //   _didd, rinv, כנס_,
  { {0x443e173f, 0x61ed1740, 0x68e8018e, 0x00000000}},  //   eft_, _ngal, _eidd,
  { {0x443e1741, 0x64580091, 0x7e7d0065, 0x00000000}},  //   fft_, _bavi, _mosp,
  { {0x64581352, 0x68e81742, 0xe1fa02d2, 0x00000000}},  //   _cavi, _gidd, ूर्ण_,
  { {0x64581743, 0x53c90088, 0x7ae90006, 0x00000000}},  //   _davi, ягом_, _kiet,
  { {0xb607008b, 0x7e7d0089, 0x68e8006b, 0x00000000}},  //   _цяжк, _nosp, _zidd,
  { {0x7ae91744, 0x64580061, 0x656205e8, 0x00000000}},  //   _miet, _favi, _groh,
  { {0x7ae91745, 0x6458007f, 0x61ed00e5, 0x00000000}},  //   _liet, _gavi, _egal,
  { {0x7e7d01d6, 0xb4cb00e8, 0xf8b2009b, 0x00000000}},  //   _bosp, लती_, אשם_,
  { {0x7ae902ae, 0x64580b54, 0x7e7d1746, 0x00000000}},  //   _niet, _zavi, _cosp,
  { {0x7e7d0161, 0xbcfb0aea, 0x753b0266, 0x00000000}},  // [2ea0] _dosp, _préa, ntuz,
  { {0x64580129, 0xe0d2002c, 0x32120199, 0x00000000}},  //   _xavi, _حزب_, _heyy_,
  { {0x7ae903a8, 0xa09b0049, 0xcb090088, 0x00000000}},  //   _biet, _זייט, дхід_,
  { {0x68e80030, 0xc332009b, 0x7ae90089, 0x00000000}},  //   _sidd, רוא_, _ciet,
  { {0xe94700a1, 0x753b016c, 0x64430036, 0x00000000}},  //   ٹرنی, jtuz, _obni,
  { {0x7ae901d6, 0x64430066, 0xe8ca0061, 0x00000000}},  //   _eiet, _nbni, ितेच,
  { {0x64580368, 0x7ae90dbc, 0x7d040197, 0x00000000}},  //   _ravi, _fiet, lpis,
  { {0x64580a5c, 0xd6d703c8, 0x7d0400b0, 0x00000000}},  //   _savi, нты_, opis,
  { {0x64580ba5, 0xe4a6004c, 0xa90a006d, 0x00000000}},  //   _pavi, ерно, _ريال_,
  { {0xd91b00b6, 0x443e010f, 0x81af0044, 0x00000000}},  //   _מומל, uft_, _করল_,
  { {0x443e000c, 0x645a00eb, 0x229501e0, 0x00000000}},  //   rft_, rdti, виня,
  { {0x273a0065, 0xda10006e, 0x64580908, 0x00000000}},  //   mën_, ारित_, _wavi,
  { {0x273a008d, 0xd251007a, 0x1a9b007b, 0x00000000}},  //   lën_, هنگ_, ליטע,
  { {0x7e7d0207, 0x7d040b41, 0xe73100a1, 0x00000000}},  //   _sosp, dpis, _حصے_,
  { {0xd904026c, 0x7e7d0627, 0x273a008d, 0x00000000}},  //   _گی_, _posp, nën_,
  { {0x61ed0f2f, 0x00000000, 0x00000000, 0x00000000}},  //   _ugal,   ,   ,
  { {0xd904089d, 0x273a008d, 0x7ae90dec, 0x00000000}},  // [2eb0] _دی_, hën_, _riet,
  { {0x7ae90253, 0x273a008d, 0x387e00ca, 0x00000000}},  //   _siet, kën_, _notr_,
  { {0x7ae9001e, 0x273a0065, 0xb09c01ce, 0x00000000}},  //   _piet, jën_, _מיזר,
  { {0xed51026c, 0x273a0065, 0x7e7d012d, 0x00000000}},  //   _پھر_, dën_, _uosp,
  { {0x7ae90ba5, 0xe8f80245, 0x273a00b5, 0x00000000}},  //   _viet, елі_, eën_,
  { {0x07a506e1, 0x2ca5000c, 0x5c140123, 0x00000000}},  //   калн, _öld_, _مظفر,
  { {0x7ae91747, 0x648d009f, 0x273a0065, 0x00000000}},  //   _tiet, _búin, gën_,
  { {0xdddd001e, 0xd90c025a, 0xf1bf1748, 0x00000000}},  //   _nosū, _کیو_, ngás_,
  { {0x648d002a, 0x765b0996, 0x387e00ca, 0x00000000}},  //   _dúin, rduy, _fotr_,
  { {0xb4cb006e, 0x273a0023, 0x765901c3, 0x00000000}},  //   लते_, bën_, _wawy,
  { {0x753b15bc, 0x7d040059, 0x273a0065, 0x00000000}},  //   stuz, zpis, cën_,
  { {0x7d040cba, 0x00000000, 0x00000000, 0x00000000}},  //   ypis,   ,   ,
  { {0xe29704af, 0x660901a3, 0x00000000, 0x00000000}},  //   тая_, mbek,   ,
  { {0x9345026b, 0xbcfb00f4, 0xa28400a1, 0x00000000}},  //   _анке, _prén, ئیکو,
  { {0xc059008b, 0x00000000, 0x00000000, 0x00000000}},  //   хіў_,   ,   ,
  { {0xe3e8007b, 0x7d040091, 0x644101a2, 0x00000000}},  //   _אַפֿ, tpis, lfli,
  { {0x7bd50207, 0xdee300ed, 0x273a0065, 0x00000000}},  // [2ec0] _azzu, роти, zën_,
  { {0x0cbe013d, 0x7d0404cb, 0x2a6d0802, 0x00000000}},  //   ्तेम, rpis, _aneb_,
  { {0x20180129, 0x6609012b, 0x91f6013d, 0x00000000}},  //   mari_, kbek, _इलाज_,
  { {0x201816df, 0x273a0065, 0x7d0403b6, 0x00000000}},  //   lari_, vën_, ppis,
  { {0x2a7f01aa, 0xdb0e0039, 0x66090240, 0x00000000}},  //   _doub_, _nybö, dbek,
  { {0x2018022b, 0x273a008d, 0xfc03004c, 0x00000000}},  //   nari_, tën_, _впро,
  { {0xdca3004c, 0xd6da0184, 0xdb1c080a, 0x00000000}},  //   _тари, мти_, _byrå,
  { {0x20180281, 0x273a008d, 0x6b8303a9, 0x00000000}},  //   hari_, rën_, änge,
  { {0x20180ad4, 0x273a008d, 0xd946012b, 0x00000000}},  //   kari_, sën_, _јези,
  { {0x20181749, 0x273a0065, 0x3eb200b0, 0x00000000}},  //   jari_, pën_, hnyt_,
  { {0x201801a3, 0x75290197, 0x273a0065, 0x00000000}},  //   dari_, arez, qën_,
  { {0x75290325, 0x26cd174a, 0x26c60020, 0x00000000}},  //   brez, cleo_, _ukoo_,
  { {0x7529174b, 0x2018174c, 0x00000000, 0x00000000}},  //   crez, fari_,   ,
  { {0x2b580061, 0x26c4174d, 0x4ec40055, 0x00000000}},  //   _osrc_, lomo_, ্দোল,
  { {0xbcfb009d, 0x14b101f5, 0x78ad009d, 0x00000000}},  //   _préo, ीकरण, éavi,
  { {0x26c4049a, 0xceb8003b, 0x5eb4174e, 0x00000000}},  //   nomo_, вљу_, айст,
  { {0x20180be3, 0x00000000, 0x00000000, 0x00000000}},  // [2ed0] bari_,   ,   ,
  { {0x660900d9, 0x00000000, 0x00000000, 0x00000000}},  //   zbek,   ,   ,
  { {0x26c40416, 0x2b580022, 0x00000000, 0x00000000}},  //   komo_, _csrc_,   ,
  { {0x3e04005e, 0x00000000, 0x00000000, 0x00000000}},  //   _вярв,   ,   ,
  { {0x26c40036, 0xf9900379, 0x3ea900d4, 0x00000000}},  //   domo_, يبه_, miat_,
  { {0x475901e0, 0x2b580009, 0x7c871364, 0x00000000}},  //   ерия_, _fsrc_, _руме,
  { {0x46a5005e, 0x2bc80e75, 0x660901a2, 0x00000000}},  //   лакв, _ауто_, tbek,
  { {0x201804f8, 0x75290eb5, 0xcc1400a1, 0x00000000}},  //   zari_, trez, _مذہب,
  { {0xd41503c8, 0x2018174f, 0x66090513, 0x00000000}},  //   льны, yari_, rbek,
  { {0x13090057, 0x7529022b, 0x3ea90035, 0x00000000}},  //   нной_, rrez, hiat_,
  { {0x201801cd, 0x26cd0219, 0x6441037f, 0x00000000}},  //   vari_, pleo_, rfli,
  { {0x2018107e, 0x26c40207, 0x644101d6, 0x00000000}},  //   wari_, como_, sfli,
  { {0x3ea9001a, 0xe56e012b, 0x291d01aa, 0x00000000}},  //   diat_, _уз_, nswa_,
  { {0x03190054, 0x291f0020, 0xbcfb009d, 0x00000000}},  //   _كتبت_, _mvua_, _crém,
  { {0x20180982, 0x212b001c, 0x3eb20146, 0x00000000}},  //   rari_, arch_, tnyt_,
  { {0x3ea901a3, 0xe3b0023c, 0x00000000, 0x00000000}},  //   giat_, _بره_,   ,
  { {0xcbb00055, 0x20180010, 0x8d660eb1, 0x00000000}},  // [2ee0] _করেছ, pari_, ывае,
  { {0x7af50032, 0x26c400e7, 0x00000000, 0x00000000}},  //   _buzt, zomo_,   ,
  { {0x4b260175, 0x1bba0025, 0x26c40020, 0x00000000}},  //   умев, رائع_, yomo_,
  { {0x3ea905f7, 0x648d0051, 0x00000000, 0x00000000}},  //   ciat_, _súil,   ,
  { {0xa9670867, 0x229200b9, 0x00000000, 0x00000000}},  //   лица_, ušky_,   ,
  { {0x62960023, 0x321900b4, 0xbddb000a, 0x00000000}},  //   ëzoj, zasy_, _obèj,
  { {0x7af5022b, 0x26c41750, 0x29060032, 0x00000000}},  //   _guzt, tomo_, spoa_,
  { {0x21200119, 0x7f3b007b, 0x212b0016, 0x00000000}},  //   _ovih_, געקו, yrch_,
  { {0xa836025a, 0x1836031d, 0x7ae20052, 0x00000000}},  //   _معاش, _مراح, mmot,
  { {0xb9930054, 0x26c40020, 0xb80a0025, 0x00000000}},  //   _الكب, somo_, _أيام_,
  { {0x61ea006b, 0x04630930, 0x212b005b, 0x00000000}},  //   əllə, стым, wrch_,
  { {0x7bce01d6, 0x9258007c, 0x6b8100f6, 0x00000000}},  //   _mybu, гают_, _àlge,
  { {0x3ea90129, 0xe5a30098, 0xbddb000a, 0x00000000}},  //   viat_, _лици, _ebèj,
  { {0x92b50055, 0x859b034e, 0xe3a40014, 0x00000000}},  //   ঝতে_, _אשדו, _پشتی,
  { {0x7ae200f8, 0x3ea911eb, 0x15d700a1, 0x00000000}},  //   kmot, tiat_, _لگیں_,
  { {0x5e5801fb, 0x64840045, 0x25a904eb, 0x00000000}},  //   лися_, _tòis, _žali_,
  { {0xbcfb0923, 0x00000000, 0x00000000, 0x00000000}},  // [2ef0] _trém,   ,   ,
  { {0xe1ff0d62, 0x3ea901a3, 0x7af50032, 0x00000000}},  //   lcó_, siat_, _puzt,
  { {0x60c71751, 0x75eb0010, 0x3ea900e5, 0x00000000}},  //   mojm, _közü, piat_,
  { {0x628f0e9c, 0x7ae2130e, 0xe1ff008e, 0x00000000}},  //   nkco, gmot, ncó_,
  { {0x22490093, 0x00000000, 0x00000000, 0x00000000}},  //   _mbak_,   ,   ,
  { {0x316900ca, 0x60c70065, 0xf77101af, 0x00000000}},  //   _mraz_, nojm, قاب_,
  { {0x7ae200c4, 0xdd0e0095, 0x00000000, 0x00000000}},  //   bmot, _kışl,   ,
  { {0x31690046, 0x06850216, 0xa525017f, 0x00000000}},  //   _oraz_, ргин, амид,
  { {0x60c71752, 0xef190036, 0x04190044, 0x00000000}},  //   kojm, ąży_, _দাবী_,
  { {0x66f1001e, 0xbcfb009d, 0x60c70023, 0x00000000}},  //   _sāku, _préj, jojm,
  { {0xe29a102a, 0x21200119, 0x798b0016, 0x00000000}},  //   ван_, _svih_, lygw,
  { {0x91e60256, 0x316900c4, 0x61fa013e, 0x00000000}},  //   ионе, _braz_, ětlo,
  { {0x6f050051, 0x7d090023, 0x75eb013f, 0x00000000}},  //   _athc, _çesh, _dözü,
  { {0x661b1082, 0x31690521, 0x60c70023, 0x00000000}},  //   lauk, _draz_, gojm,
  { {0x44fb1753, 0x7ae21754, 0x23760063, 0x00000000}},  //   _hê_, ymot, _نمود_,
  { {0x661b1755, 0x44fb001d, 0x628f0019, 0x00000000}},  //   nauk, _kê_, ckco,
  { {0x316901a2, 0x6e361756, 0x00000000, 0x00000000}},  // [2f00] _graz_, rgyb,   ,
  { {0x44fb0011, 0x6e36018e, 0x661b1757, 0x00000000}},  //   _mê_, sgyb, hauk,
  { {0x44fb1758, 0x66f1001e, 0x394d01c5, 0x00000000}},  //   _lê_, _māks, _apes_,
  { {0x661b1759, 0x4fbb0104, 0x6b830039, 0x00000000}},  //   jauk, _יציא, änga,
  { {0x7ae204cb, 0x44fb160d, 0x661b002d, 0x00000000}},  //   rmot, _nê_, dauk,
  { {0x9915008b, 0x62840032, 0x00000000, 0x00000000}},  //   сьці, _loio,   ,
  { {0x78aa053d, 0x44fb00fa, 0x00000000, 0x00000000}},  //   rifv, _aê_,   ,
  { {0x44fb0011, 0x35460088, 0x62840197, 0x00000000}},  //   _bê_, ахов, _noio,
  { {0x66f10089, 0x44fb00fa, 0x245b007f, 0x00000000}},  //   _sākt, _cê_, kšmė_,
  { {0x07a601fc, 0x44fb0701, 0x75eb0279, 0x00000000}},  //   _казн, _dê_, _sözü,
  { {0x3169013e, 0x2bf700a0, 0x60c70023, 0x00000000}},  //   _sraz_, ימין_, vojm,
  { {0x31690375, 0x661b0022, 0x44fb1612, 0x00000000}},  //   _praz_, cauk, _fê_,
  { {0x60c70065, 0xe1ff02a0, 0x628f00d9, 0x00000000}},  //   tojm, rcó_, rkco,
  { {0xe1ff175a, 0x00000000, 0x00000000, 0x00000000}},  //   scó_,   ,   ,
  { {0xd4c50025, 0x443c0129, 0x62960606, 0x00000000}},  //   _اغني, _icv_, _flyo,
  { {0x443c05e6, 0x31690181, 0x60c70065, 0x00000000}},  //   _hcv_, _traz_, sojm,
  { {0x44fb0082, 0x60c709fc, 0x9df80140, 0x00000000}},  // [2f10] _xê_, pojm, рнут_,
  { {0x705506c6, 0xcc74012b, 0x7d020048, 0x00000000}},  //   _اندا, огућ, íosa,
  { {0x443c175b, 0x394d01e5, 0x6a170025, 0x00000000}},  //   _mcv_, _spes_, لبشر,
  { {0x99d90025, 0x00000000, 0x00000000, 0x00000000}},  //   هواء_,   ,   ,
  { {0x661b175c, 0x00000000, 0x00000000, 0x00000000}},  //   vauk,   ,   ,
  { {0x88c801fb, 0x6d5d0bd5, 0xab87132a, 0x00000000}},  //   алів_, _issa, _кубк,
  { {0xfbe508b7, 0x44fb1273, 0xbb850054, 0x00000000}},  //   _প্রত, _sê_, _الزي,
  { {0x443c00d9, 0xcfb8009b, 0xbcfb1059, 0x00000000}},  //   _acv_, ילוי_, _préh,
  { {0x661b0ba5, 0x056801f9, 0xa3e40316, 0x00000000}},  //   rauk, ајќи_, पेस_,
  { {0x661b001e, 0x44fb175d, 0xbcfb0129, 0x00000000}},  //   sauk, _vê_, _créi,
  { {0x661b00b0, 0xe6430279, 0xb4d70061, 0x00000000}},  //   pauk, şmış, _ाठी_,
  { {0x44fb08c6, 0xc7b2009b, 0x644a0009, 0x00000000}},  //   _tê_, _צבא_, _ebfi,
  { {0x75220107, 0xd6c6007a, 0xe3b100a2, 0x00000000}},  //   _gvoz, _امنی, ترک_,
  { {0xbcfb0051, 0x4095005e, 0x443c05d2, 0x00000000}},  //   _gréi, орст, _gcv_,
  { {0xdfd20379, 0x00000000, 0x00000000, 0x00000000}},  //   سير_,   ,   ,
  { {0xb21b0030, 0x00000000, 0x00000000, 0x00000000}},  //   skær,   ,   ,
  { {0x6b830a5d, 0x0c260088, 0xa2c5007d, 0x00000000}},  // [2f20] ängn, йман, रवर्,
  { {0x6aa90020, 0x4427009d, 0x8db50088, 0x00000000}},  //   _amef, _jdn_, істі,
  { {0x6d5d028c, 0x0b4601fb, 0xa3db0061, 0x00000000}},  //   _essa, снен, ढेच_,
  { {0x66190ace, 0xc33200b3, 0x442700d2, 0x00000000}},  //   _newk, לוב_, _ldn_,
  { {0xda65006d, 0x6abb0022, 0x823b0049, 0x00000000}},  //   تالي, _djuf, רענצ,
  { {0xddcd0477, 0xc7b000a1, 0x764b00e5, 0x00000000}},  //   ldaş, وڑا_, _abgy,
  { {0x6d44175e, 0x656b175f, 0x9f58008e, 0x00000000}},  //   ltia, _argh, mbró_,
  { {0xddcd0279, 0x201a0925, 0x7e64006c, 0x00000000}},  //   ndaş, _lepi_, ndip,
  { {0xbcfb124d, 0x44270145, 0x661d000c, 0x00000000}},  //   _préi, _bdn_, ðska,
  { {0x44270061, 0x81ae0044, 0x6d441760, 0x00000000}},  //   _cdn_, কথা_, itia,
  { {0x6d441761, 0xddcd0276, 0x00000000, 0x00000000}},  //   htia, kdaş,   ,
  { {0x6d4409e4, 0x44270ca4, 0x00000000, 0x00000000}},  //   ktia, _edn_,   ,
  { {0xe298008b, 0x752212ac, 0xbcfb002a, 0x00000000}},  //   саў_, _uvoz, _tréi,
  { {0x443c004a, 0x00000000, 0x00000000, 0x00000000}},  //   _ucv_,   ,   ,
  { {0x201a0263, 0xddcd006b, 0x6d5d00e0, 0x00000000}},  //   _depi_, fdaş, _sssa,
  { {0x644801d6, 0x6d441762, 0x66190066, 0x00000000}},  //   lfdi, ftia, _xewk,
  { {0x6d440058, 0x00000000, 0x00000000, 0x00000000}},  // [2f30] gtia,   ,   ,
  { {0x44270061, 0x2caa00f6, 0x00000000, 0x00000000}},  //   _xdn_, _cmbd_,   ,
  { {0xd9f9026b, 0x6d441763, 0x00000000, 0x00000000}},  //   анец_, atia,   ,
  { {0x70550063, 0x629d0082, 0x00000000, 0x00000000}},  //   _انگا, nhso,   ,
  { {0xa92401fb, 0x6d5d01c3, 0x6d4f0085, 0x00000000}},  //   зділ, _ussa, _upca,
  { {0x20030046, 0x186900ed, 0xd7091764, 0x00000000}},  //   ncji_, раки_, анке_,
  { {0x7d0d1765, 0x00000000, 0x00000000, 0x00000000}},  //   lpas,   ,   ,
  { {0x442701a3, 0x6aa90020, 0x941e013f, 0x00000000}},  //   _sdn_, _umef, mitə_,
  { {0x20030046, 0x7d0d1766, 0x44270085, 0x00000000}},  //   kcji_, npas, _pdn_,
  { {0x395f1767, 0x8d5c00b3, 0x00000000, 0x00000000}},  //   _isus_, רכזי,   ,
  { {0x6d44022b, 0xddcd0477, 0x65640087, 0x00000000}},  //   ztia, ydaş, _šiht,
  { {0x68fb01b0, 0x7d0d04be, 0x201a04cb, 0x00000000}},  //   _kuud, kpas, _sepi_,
  { {0x7d0d00bb, 0x68fb0934, 0x656b0048, 0x00000000}},  //   jpas, _juud, _urgh,
  { {0x68fb0004, 0xa06a008b, 0x00000000, 0x00000000}},  //   _muud, шага_,   ,
  { {0x7d0d1768, 0x68fb1487, 0x6723012d, 0x00000000}},  //   epas, _luud, nsnj,
  { {0x6d440dc9, 0x629d0109, 0x76490016, 0x00000000}},  //   ttia, chso, nfey,
  { {0x7d0d011c, 0xddcd006b, 0x6496001a, 0x00000000}},  // [2f40] gpas, rdaş, _mâin,
  { {0xd91000a1, 0x3a3f00f6, 0xd00a003b, 0x00000000}},  //   ہیر_, _acup_, _њене_,
  { {0x7d0d142e, 0x00000000, 0x00000000, 0x00000000}},  //   apas,   ,   ,
  { {0x6d440023, 0x00000000, 0x00000000, 0x00000000}},  //   ptia,   ,   ,
  { {0x18741769, 0x76490016, 0xc983007c, 0x00000000}},  //   згля, dfey, дущи,
  { {0xbcfb176a, 0x24870263, 0x941e006b, 0x00000000}},  //   _prév, _nonm_, bitə_,
  { {0xab271227, 0x7bdc176b, 0x00000000, 0x00000000}},  //   _мора_, _uzru,   ,
  { {0x6496001a, 0x76490016, 0x00000000, 0x00000000}},  //   _câin, gfey,   ,
  { {0x20030036, 0x22b60089, 0x7e9b00a3, 0x00000000}},  //   ycji_, cāki_, יסקו,
  { {0x7afc011f, 0x60c20051, 0x3946008f, 0x00000000}},  //   _kurt, _íomh, mtos_,
  { {0x39460325, 0xc606008b, 0x7afc01e5, 0x00000000}},  //   ltos_, _дзей, _jurt,
  { {0x7afc00b0, 0x9294008b, 0x2a64012d, 0x00000000}},  //   _murt, даюц, _jamb_,
  { {0x39460df9, 0xdb07000c, 0x506705f6, 0x00000000}},  //   ntos_, _ólög, отва,
  { {0x3946176c, 0xc0cb0783, 0x2a64176d, 0x00000000}},  //   itos_, руме_, _lamb_,
  { {0x14c70183, 0xa295007e, 0x7afc1459, 0x00000000}},  //   रकरण, _накі, _nurt,
  { {0xc333009b, 0x39460dec, 0x7d0d176e, 0x00000000}},  //   _חוק_, ktos_, tpas,
  { {0x7afc022b, 0x3ebe000c, 0x20030036, 0x00000000}},  // [2f50] _aurt, étta_, pcji_,
  { {0x7afc176f, 0x68fb003c, 0x21390023, 0x00000000}},  //   _burt, _ruud, mush_,
  { {0x68fb006c, 0x39461770, 0x7d0d0781, 0x00000000}},  //   _suud, etos_, spas,
  { {0xbcfb027b, 0x68fb0004, 0x7d0d059f, 0x00000000}},  //   _brét, _puud, ppas,
  { {0xa9690175, 0x4e7a00a0, 0xbcfb009d, 0x00000000}},  //   сила_, _הארצ, _crét,
  { {0x7afc00ab, 0xe9d8008b, 0xacfa009b, 0x00000000}},  //   _furt, цкі_, _להשכ,
  { {0x7afc0f30, 0xddcd016c, 0x64960035, 0x00000000}},  //   _gurt, njaž, _pâin,
  { {0xbcfb009f, 0x2139008d, 0xba770380, 0x00000000}},  //   _frét, kush_, _باست,
  { {0x39461771, 0x22590168, 0xc7b80521, 0x00000000}},  //   ctos_, desk_, _ređe_,
  { {0x7afc014a, 0x76490016, 0x65691772, 0x00000000}},  //   _yurt, sfey, rveh,
  { {0x61f1006b, 0xc7b8012d, 0x27070082, 0x00000000}},  //   ədlə, _peđe_, _qđnd_,
  { {0x21390022, 0x00000000, 0x00000000, 0x00000000}},  //   fush_,   ,   ,
  { {0x2139012d, 0x24870173, 0x00000000, 0x00000000}},  //   gush_, _tonm_,   ,
  { {0x648d0051, 0x00000000, 0x00000000, 0x00000000}},  //   _cúit,   ,   ,
  { {0x39460010, 0x66de0065, 0xdee60088, 0x00000000}},  //   ztos_, lëka, зови,
  { {0x21391511, 0x39460006, 0x531a0049, 0x00000000}},  //   bush_, ytos_, _פופצ,
  { {0x7afc00f4, 0xd00f026c, 0x39460df5, 0x00000000}},  // [2f60] _surt, ئلہ_, xtos_,
  { {0x7afc04b4, 0xe1ff073f, 0xc1730097, 0x00000000}},  //   _purt, ndón_, _נחת_,
  { {0xbcfb0eb4, 0x7afc006b, 0x6ffb00b3, 0x00000000}},  //   _brés, _qurt, _להיפ,
  { {0x394600c4, 0xbcfb00f4, 0x37d10044, 0x00000000}},  //   ttos_, _prét, াধার,
  { {0x394600b0, 0x00000000, 0x00000000, 0x00000000}},  //   utos_,   ,   ,
  { {0x98a301be, 0x7afc046e, 0x22b60089, 0x00000000}},  //   ниче, _turt, māku_,
  { {0xfbc301e1, 0x2a6406c0, 0x7afc00b5, 0x00000000}},  //   _збро, _tamb_, _uurt,
  { {0x39461773, 0xb9020044, 0xdb1c0036, 0x00000000}},  //   ptos_, _নং_, _wyró,
  { {0xf7f601d8, 0x7e66000a, 0x00000000, 0x00000000}},  //   _فساد, _makp,   ,
  { {0x3ebf00ca, 0x7e660022, 0x00000000, 0x00000000}},  //   čuti_, _lakp,   ,
  { {0x62351020, 0x22590190, 0x00000000, 0x00000000}},  //   мену, tesk_,   ,
  { {0x0bb70104, 0x7e6600e0, 0x5187007c, 0x00000000}},  //   ללים_, _nakp, пуга,
  { {0x22590ea9, 0x648d0051, 0xcfaa0044, 0x00000000}},  //   resk_, _cúis, _খুলন,
  { {0xa3b401fb, 0x212d01dc, 0x65621241, 0x00000000}},  //   _облі, šeho_, _isoh,
  { {0x4fc4012b, 0x645a0b25, 0xc7b80082, 0x00000000}},  //   еста, meti, _gdđt_,
  { {0x443e0374, 0x3ea01774, 0x00000000, 0x00000000}},  //   lgt_, ghit_,   ,
  { {0x645a0026, 0x443e00bb, 0x7e6600d9, 0x00000000}},  // [2f70] oeti, ogt_, _dakp,
  { {0x645a0612, 0x67280182, 0xa2c5007d, 0x00000000}},  //   neti, _ovdj, रवक्,
  { {0xbcfb028c, 0x9e150088, 0x443e059b, 0x00000000}},  //   _prés, _одні, igt_,
  { {0x645a1775, 0xd366007a, 0x629d0065, 0x00000000}},  //   heti, _یه_, ëroh,
  { {0x645a014a, 0xd914007e, 0x22b60089, 0x00000000}},  //   keti, едчы, cāku_,
  { {0x645a0247, 0x443e02ae, 0xbcfb0068, 0x00000000}},  //   jeti, jgt_, _frér,
  { {0x645a002d, 0xbcfb1776, 0x65620045, 0x00000000}},  //   deti, _trés, _asoh,
  { {0x443e1777, 0x22b60089, 0x67280087, 0x00000000}},  //   egt_, nākt_, _dvdj,
  { {0xdddd0046, 0x645a166d, 0x00000000, 0x00000000}},  //   _hasł, feti,   ,
  { {0x443e1778, 0x648d0051, 0x3ea00065, 0x00000000}},  //   ggt_, _rúis, zhit_,
  { {0x9c8700b9, 0xe1ff1779, 0xd6ce02fd, 0x00000000}},  //   _začá, rdón_, طقی_,
  { {0xd5ae089d, 0xe2971734, 0x443e00b5, 0x00000000}},  //   افی_, даю_, agt_,
  { {0x645a177a, 0x648d002a, 0x2d8001c3, 0x00000000}},  //   beti, _dúir, xxie_,
  { {0x443e001c, 0x645a00b9, 0x7e660056, 0x00000000}},  //   cgt_, ceti, _sakp,
  { {0x3ea0177b, 0x7e66011c, 0x21290203, 0x00000000}},  //   thit_, _pakp, _evah_,
  { {0xdee3007c, 0x3d02006e, 0xdee601ee, 0x00000000}},  //   воси, _वंदे_, фоби,
  { {0x3ea001d6, 0x6fe7009d, 0x290d0022, 0x00000000}},  // [2f80] rhit_, técé, _ntea_,
  { {0x6286037e, 0x3ea00065, 0x013700a0, 0x00000000}},  //   ljko, shit_, _קרית_,
  { {0x307b009b, 0x4a46017f, 0x290d002d, 0x00000000}},  //   _ואינ, днев, _atea_,
  { {0x645a177c, 0xe9da0679, 0x3a2d0035, 0x00000000}},  //   zeti, оке_, _cdep_,
  { {0xbcfb0aea, 0x645a014a, 0x443e0239, 0x00000000}},  //   _fréq, yeti, ygt_,
  { {0x96f80594, 0x645a002d, 0xf2bb007d, 0x00000000}},  //   пект_, xeti, _उद्घ,
  { {0x22b60089, 0x36d40069, 0x290d00e5, 0x00000000}},  //   nāks_, нокр, _etea_,
  { {0xcfc00044, 0x6e2400e7, 0x64430146, 0x00000000}},  //   _ইরান, naib, _acni,
  { {0x645a008d, 0xdddd0036, 0x3a0900a1, 0x00000000}},  //   teti, _zasł, _رکنی_,
  { {0x6e240c97, 0x443e01a2, 0x84e70025, 0x00000000}},  //   haib, ugt_, وفيق_,
  { {0x645a011f, 0x443e177d, 0x6e24011c, 0x00000000}},  //   reti, rgt_, kaib,
  { {0x645a037e, 0x6b83177e, 0x753b0009, 0x00000000}},  //   seti, ängi, buuz,
  { {0x6596004b, 0x7c2e05fa, 0x6e240032, 0x00000000}},  //   _تجار, _odbr, daib,
  { {0xe3af06c6, 0xf9930097, 0x61f8007e, 0x00000000}},  //   اری_, דרש_, ьняў_,
  { {0xceb4005f, 0xdfd4007e, 0xdfd8005e, 0x00000000}},  //   fiə_, воры, дът_,
  { {0x76400061, 0x7c2e0093, 0x6e240327, 0x00000000}},  //   ngmy, _adbr, gaib,
  { {0xbcfb009d, 0x3d1a007d, 0x00000000, 0x00000000}},  // [2f90] _crép, मीले_,   ,
  { {0x66de0065, 0x22b60089, 0x61e0014a, 0x00000000}},  //   këko, sākt_, ümle,
  { {0x290d0899, 0x5a351281, 0x3eb00051, 0x00000000}},  //   _stea_, енет, últú_,
  { {0x6e240b51, 0x6aa20016, 0x628d00c4, 0x00000000}},  //   caib, ghof, _joao,
  { {0x49b80014, 0xc7b8016c, 0x00000000, 0x00000000}},  //   واهد_, _ređa_,   ,
  { {0x442e02d4, 0x00000000, 0x00000000, 0x00000000}},  //   _ndf_,   ,   ,
  { {0xe739041f, 0xc7b80521, 0x46f50077, 0x00000000}},  //   чей_, _peđa_, нчит,
  { {0x442e00d4, 0x32c40477, 0x6aa20020, 0x00000000}},  //   _adf_, kıya_, chof,
  { {0x81b40055, 0x04b50ae0, 0x5a44007e, 0x00000000}},  //   _জুন_, есня, _шэра,
  { {0xb21b0030, 0x7c250471, 0x00000000, 0x00000000}},  //   sjæl, nahr,   ,
  { {0x442e177f, 0x889a009b, 0x6286012d, 0x00000000}},  //   _ddf_, _צבעי, tjko,
  { {0x442e009d, 0x753b0020, 0x51f700a1, 0x00000000}},  //   _edf_, puuz, کسپر,
  { {0x3495008b, 0x442e1780, 0xbddb00f4, 0x00000000}},  //   _падр, _fdf_, _scèn,
  { {0x92c20055, 0x7c25010f, 0x6e2400e7, 0x00000000}},  //   ্গে_, jahr, waib,
  { {0x44251781, 0x6e241782, 0x6609012d, 0x00000000}},  //   mal_, taib, ocek,
  { {0x44250643, 0xbcfb00f4, 0x64410007, 0x00000000}},  //   lal_, _prép, lgli,
  { {0x7c25001f, 0xed5701f9, 0xee37008b, 0x00000000}},  // [2fa0] fahr, нот_, энт_,
  { {0x644106d3, 0x7d040065, 0x6e241783, 0x00000000}},  //   ngli, rqis, saib,
  { {0x201801d5, 0x64411784, 0x4425005b, 0x00000000}},  //   mbri_, igli, ial_,
  { {0x4425006a, 0x629d0006, 0x2ea800a1, 0x00000000}},  //   hal_, ūrov, _کھڑی_,
  { {0x44250127, 0x7bc700f6, 0x6aa201a2, 0x00000000}},  //   kal_, _exju, rhof,
  { {0x44251785, 0xfbd1026c, 0x6aa2021f, 0x00000000}},  //   jal_, اتے_, shof,
  { {0x442e1786, 0xf093009b, 0x2bbe0061, 0x00000000}},  //   _rdf_, רנו_, ्थळा,
  { {0x442e009d, 0x41b20061, 0x6441010e, 0x00000000}},  //   _sdf_, ीपास, egli,
  { {0x4425018e, 0x00000000, 0x00000000, 0x00000000}},  //   fal_,   ,   ,
  { {0x6441098e, 0x1828007a, 0x33740077, 0x00000000}},  //   ggli, _آقای_, вгор,
  { {0x5c370049, 0xc61f0044, 0x00000000, 0x00000000}},  //   ערטן_, _ধারা_,   ,
  { {0x44251787, 0x64411788, 0x3bbb0104, 0x00000000}},  //   aal_, agli, למיד,
  { {0x00000000, 0x00000000, 0x00000000, 0x00000000}},  //     ,   ,   ,
  { {0x44250038, 0x32c401df, 0x00000000, 0x00000000}},  //   cal_, rıya_,   ,
  { {0x7ea30004, 0xdfd50783, 0xbcfb0010, 0x00000000}},  //   _lõpe, товы, _esél,
  { {0x7c25010f, 0x6b8100f6, 0x32c4026d, 0x00000000}},  //   wahr, _àlgi, pıya_,
  { {0x661d009f, 0x2d580194, 0xa2ce013d, 0x00000000}},  // [2fb0] ðski, нить_, सवर्,
  { {0x6ac90201, 0x2d870091, 0x00000000, 0x00000000}},  //   िक्र, ćne_,   ,
  { {0x212b010f, 0x2be60061, 0x00000000, 0x00000000}},  //   lsch_, _करणं_,   ,
  { {0x44251789, 0xc3330104, 0xc5fe0089, 0x00000000}},  //   zal_, רוף_, šējo_,
  { {0x212b0a35, 0x4425060b, 0x68fa013f, 0x00000000}},  //   nsch_, yal_, _bitd,
  { {0x4425006b, 0x212b010f, 0x7e6d0058, 0x00000000}},  //   xal_, isch_, ldap,
  { {0x2bb80054, 0x46a513e7, 0x6d4d178a, 0x00000000}},  //   _كافة_, какв, ltaa,
  { {0x7e6d020c, 0x44250504, 0xcb120452, 0x00000000}},  //   ndap, wal_, _כלל_,
  { {0x6d4d061f, 0x6441001f, 0x6609014a, 0x00000000}},  //   ntaa, tgli, rcek,
  { {0x97a7003b, 0xd90d007a, 0x6441178b, 0x00000000}},  //   _прел, _هیچ_, ugli,
  { {0x6d4d00b0, 0x61e40010, 0x7afb178c, 0x00000000}},  //   htaa, _szil, _kiut,
  { {0x6441018e, 0xddc4001a, 0x6d4d0dde, 0x00000000}},  //   sgli, ndiţ, ktaa,
  { {0x4425049a, 0x7afb0010, 0x00000000, 0x00000000}},  //   pal_, _miut,   ,
  { {0x7e7d010f, 0xe3b9178d, 0x4425178e, 0x00000000}},  //   _ansp, _обл_, qal_,
  { {0x03a20088, 0x00000000, 0x00000000, 0x00000000}},  //   _вищо,   ,   ,
  { {0x6d4d04fd, 0x7e6d0058, 0x212b01a2, 0x00000000}},  //   ftaa, gdap, bsch_,
  { {0x6d4d178f, 0x00000000, 0x00000000, 0x00000000}},  // [2fc0] gtaa,   ,   ,
  { {0x7afb0198, 0x7e7d01aa, 0xdd8f0318, 0x00000000}},  //   _aiut, _ensp, غول_,
  { {0x6d4d001c, 0x8fa604af, 0x0a4a008b, 0x00000000}},  //   ataa, _ране, дзей_,
  { {0x7afb04bd, 0x78a11790, 0x7ae90020, 0x00000000}},  //   _ciut, _allv, _chet,
  { {0x6d4d001c, 0x7ceb010f, 0x7afb003f, 0x00000000}},  //   ctaa, dürf, _diut,
  { {0xf77206dd, 0x672a00ea, 0x00000000, 0x00000000}},  //   لاع_, tsfj,   ,
  { {0x6b8304ce, 0x7afb07ad, 0x00000000, 0x00000000}},  //   ängt, _fiut,   ,
  { {0x7afb0026, 0x212b0032, 0x68fa01d6, 0x00000000}},  //   _giut, ysch_, _witd,
  { {0xceb300b6, 0x7bdc0052, 0x27e5004a, 0x00000000}},  //   ייה_, _hyru, _ezln_,
  { {0x68fa00c7, 0xb4cc013d, 0xb86502fd, 0x00000000}},  //   _uitd, लवे_, _مامو,
  { {0xa2950099, 0x29040f68, 0x387e000d, 0x00000000}},  //   гані, _huma_, _intr_,
  { {0x26c00006, 0x212b03a1, 0x29041791, 0x00000000}},  //   čios_, tsch_, _kuma_,
  { {0xe298008b, 0xe5340147, 0x29040020, 0x00000000}},  //   таў_, _сель, _juma_,
  { {0x212b010f, 0x29041792, 0x7ceb1793, 0x00000000}},  //   rsch_, _muma_, mürg,
  { {0xff040242, 0x29041794, 0x386c00e5, 0x00000000}},  //   иятн, _luma_, _madr_,
  { {0x6d4d1795, 0x29040007, 0x212b1796, 0x00000000}},  //   ttaa, _ouma_, psch_,
  { {0x29040181, 0x7e6d020c, 0x7afb1797, 0x00000000}},  // [2fd0] _numa_, rdap, _riut,
  { {0x7ae90020, 0x629d01d6, 0x80c10044, 0x00000000}},  //   _shet, lkso, _শীর্,
  { {0x6d4d0d6f, 0x50b8057d, 0x7afb1798, 0x00000000}},  //   staa, _جديد_, _piut,
  { {0x629d0146, 0x290400bb, 0x6d4d003f, 0x00000000}},  //   nkso, _buma_, ptaa,
  { {0x29040127, 0xb5fd01ee, 0x8d8400ed, 0x00000000}},  //   _cuma_, neše, _курд,
  { {0x98e50054, 0x7ae900ab, 0x6b8304ce, 0x00000000}},  //   دكتو, _whet, ängs,
  { {0x00580104, 0x2249014a, 0x386c00e5, 0x00000000}},  //   דשות_, _ocak_, _dadr_,
  { {0xdb240195, 0xd756023c, 0x387e0068, 0x00000000}},  //   _úsái, اليت_, _entr_,
  { {0x60d50c8a, 0xb5fd0243, 0x290401ed, 0x00000000}},  //   kozm, ješe, _guma_,
  { {0x34850b87, 0x20010011, 0x22490093, 0x00000000}},  //   угог, _nghi_, _acak_,
  { {0x947500d3, 0x29040657, 0xe81901f5, 0x00000000}},  //   ندگا, _zuma_, _न्या_,
  { {0x29041352, 0x20010026, 0x7ceb01a2, 0x00000000}},  //   _yuma_, _aghi_, bürg,
  { {0x661b1799, 0xd46801b2, 0x00000000, 0x00000000}},  //   mbuk, رحیم_,   ,
  { {0x55ba009b, 0x9103007c, 0x629d0065, 0x00000000}},  //   _אמנו, спре, ëror,
  { {0x2d8f0002, 0xf8b2009b, 0xb4c10309, 0x00000000}},  //   ägen_, משך_, ्की_,
  { {0x661b179a, 0xc24601ee, 0x00000000, 0x00000000}},  //   nbuk, _сник,   ,
  { {0x83fc0091, 0x3f9e179b, 0x661b0020, 0x00000000}},  // [2fe0] ređe, štu_, ibuk,
  { {0xf06601f9, 0xf28a00a1, 0x3a2400fa, 0x00000000}},  //   _скоп, _آپکو_, _semp_,
  { {0x2904179c, 0xddd40036, 0x7ceb019a, 0x00000000}},  //   _suma_, _łańc, dürd,
  { {0x753b057c, 0x7524014a, 0x094a00ed, 0x00000000}},  //   kruz, _çizg, ечки_,
  { {0x38a2000c, 0x82d70049, 0x753b016c, 0x00000000}},  //   _aðra_, נונג_, jruz,
  { {0x4b2603ec, 0x753b0107, 0x31570049, 0x00000000}},  //   _معرف, druz, ריסן_,
  { {0x3a24086a, 0xd6d012c0, 0x00000000, 0x00000000}},  //   _temp_, يقت_,   ,
  { {0xa534003b, 0x29040020, 0x6b830039, 0x00000000}},  //   анич, _tuma_, ånge,
  { {0x7d06179d, 0x753b0035, 0x29040058, 0x00000000}},  //   _juks, gruz, _uuma_,
  { {0xd5630265, 0x7d060052, 0x00000000, 0x00000000}},  //   стъп, _muks,   ,
  { {0x2ee00279, 0x00000000, 0x00000000, 0x00000000}},  //   klif_,   ,   ,
  { {0x753b0026, 0x81e90044, 0x66e31079, 0x00000000}},  //   bruz, _বলব_, _лоха,
  { {0x629d0378, 0xc05b01fb, 0x753b0285, 0x00000000}},  //   rkso, нів_, cruz,
  { {0x6fd60316, 0xf48402fd, 0x00000000, 0x00000000}},  //   _मुहू, _خاصی,   ,
  { {0x7d06008f, 0xb5fd179e, 0x60d5179f, 0x00000000}},  //   _auks, reše, rozm,
  { {0x7d06006a, 0x6e20010e, 0xd9f60061, 0x00000000}},  //   _buks, _õmbl, ेशात_,
  { {0xa3b80061, 0xb5fd00ca, 0x6e260328, 0x00000000}},  // [2ff0] _घेत_, peše, _dekb,
  { {0x7d060065, 0x20010026, 0x6e2600d9, 0x00000000}},  //   _duks, _ughi_, _eekb,
  { {0x70fa009b, 0x03e20082, 0x60fa009b, 0x00000000}},  //   _שהתח, _đuốn, _שהתק,
  { {0x19b9008b, 0x7ceb010f, 0xc333009b, 0x00000000}},  //   куль_, würd, מוע_,
  { {0xa9690175, 0x645809dd, 0x7ceb0279, 0x00000000}},  //   тила_, _obvi, türd,
  { {0x7c870147, 0x3ea90010, 0x2bd001f5, 0x00000000}},  //   _суме, lhat_, _तुका,
  { {0x07a5005e, 0x7522000a, 0x00000000, 0x00000000}},  //   райн, _awoz,   ,
  { {0x753b0282, 0x3ea917a0, 0xe7080014, 0x00000000}},  //   truz, nhat_, دتون_,
  { {0x661b020c, 0x7847025a, 0xca48023c, 0x00000000}},  //   rbuk, _مضام, _حلقه_,
  { {0xb4c10201, 0x6602022b, 0x753b01bc, 0x00000000}},  //   ्के_, _egok, rruz,
  { {0xe28604f9, 0x61e1005f, 0x987a0049, 0x00000000}},  //   ални, əlli, _שרעק,
  { {0x6d5d0030, 0x25b60014, 0x7c270030, 0x00000000}},  //   _opsa, اهید_, _lejr,
  { {0x3ea91002, 0xcad6009b, 0x75220c28, 0x00000000}},  //   dhat_, שורת_, _gwoz,
  { {0x7c2700b9, 0x6e260093, 0x7d060733, 0x00000000}},  //   _nejr, _sekb, _ruks,
  { {0x7d0617a1, 0x6d5d17a2, 0x442700d4, 0x00000000}},  //   _suks, _apsa, _ien_,
  { {0x442703cd, 0x3ea917a3, 0xee3717a4, 0x00000000}},  //   _hen_, ghat_, инс_,

  { {0xcbe208b7, 0x44270343, 0x25ad0342, 0x00000000}},  // [3000] _বলেছ, _ken_, nzel_,
  { {0x44270224, 0xac830230, 0x4c8300ed, 0x00000000}},  //   _jen_, огул, олув,
  { {0x80a60167, 0x9f4c00b0, 0x00000000, 0x00000000}},  //   _ممکن, ädä_,   ,
  { {0x44270027, 0x3ea900b9, 0x00000000, 0x00000000}},  //   _len_, chat_,   ,
  { {0x6d5d002d, 0x7c2717a5, 0x4427005b, 0x00000000}},  //   _gpsa, _fejr, _oen_,
  { {0x7e640e33, 0xddcd0035, 0x7c270022, 0x00000000}},  //   leip, leaş, _gejr,
  { {0x6d440035, 0xf727007e, 0x656b074e, 0x00000000}},  //   luia, ацый_, _asgh,
  { {0x3ea00943, 0xdc2e006b, 0x83fc0243, 0x00000000}},  //   nkit_, _yığm, jeđa,
  { {0x442717a6, 0xf8af00a1, 0x6d4417a7, 0x00000000}},  //   _ben_, سکے_, nuia,
  { {0x7ae217a8, 0x4427042e, 0x3ea90010, 0x00000000}},  //   llot, _cen_, zhat_,
  { {0x48070264, 0x3ea017a9, 0x7ae208a6, 0x00000000}},  //   _техн_, kkit_, olot,
  { {0x4427017c, 0x96fa031d, 0x6b810325, 0x00000000}},  //   _een_, _شعار_, _álge,
  { {0x442704cd, 0x7ae20026, 0x20d70025, 0x00000000}},  //   _fen_, ilot, لتسج,
  { {0x44270607, 0x3ea90133, 0x00000000, 0x00000000}},  //   _gen_, what_,   ,
  { {0x442c17aa, 0xb5fd003b, 0x3ea90010, 0x00000000}},  //   mad_, meša, that_,
  { {0x4427022b, 0x93fb007b, 0x2bda013d, 0x00000000}},  //   _zen_, _בלוי, _भड़ा,
  { {0x6d4f001c, 0x442717ab, 0x7ae217ac, 0x00000000}},  // [3010] _qqca, _yen_, dlot,
  { {0x6448000c, 0x3ea90065, 0x44270082, 0x00000000}},  //   ngdi, shat_, _xen_,
  { {0x7c270030, 0x81e90044, 0x3ea917ad, 0x00000000}},  //   _vejr, _বলি_, phat_,
  { {0x442c109a, 0xdd91026c, 0x3ea0059f, 0x00000000}},  //   had_, _فوج_, ckit_,
  { {0x442c0119, 0x777a002d, 0x6d5d17ae, 0x00000000}},  //   kad_, _artx, _upsa,
  { {0x442c0004, 0x81e90055, 0xb5fd0243, 0x00000000}},  //   jad_, _বলা_, ješa,
  { {0x442c1718, 0x4427022b, 0xccf2009b, 0x00000000}},  //   dad_, _ren_, _מכך_,
  { {0x4427021e, 0x7ae2059a, 0x442c17af, 0x00000000}},  //   _sen_, clot, ead_,
  { {0x44270904, 0xddc601d9, 0x442c0051, 0x00000000}},  //   _pen_, _kakš, fad_,
  { {0x442c001e, 0x44270065, 0x6e2d01f3, 0x00000000}},  //   gad_, _qen_, haab,
  { {0x44270018, 0xc6260055, 0xe29a0364, 0x00000000}},  //   _ven_, _যারা_, ган_,
  { {0x44270007, 0xddc60091, 0x64480112, 0x00000000}},  //   _wen_, _lakš, agdi,
  { {0x442c17b0, 0x83fc0521, 0xc7b8012d, 0x00000000}},  //   bad_, ređa, _ređi_,
 