/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.impl.CountOutputStream;
import com.adobe.xmp.impl.QName;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.options.SerializeOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class XMPSerializerRDF {
    private static final int DEFAULT_PAD = 2048;
    private static final String PACKET_HEADER = "<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>";
    private static final String PACKET_TRAILER = "<?xpacket end=\"";
    private static final String PACKET_TRAILER2 = "\"?>";
    private static final String RDF_XMPMETA_START = "<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"";
    private static final String RDF_XMPMETA_END = "</x:xmpmeta>";
    private static final String RDF_RDF_START = "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">";
    private static final String RDF_RDF_END = "</rdf:RDF>";
    private static final String RDF_SCHEMA_START = "<rdf:Description rdf:about=";
    private static final String RDF_SCHEMA_END = "</rdf:Description>";
    private static final String RDF_STRUCT_START = "<rdf:Description";
    private static final String RDF_STRUCT_END = "</rdf:Description>";
    private static final String RDF_EMPTY_STRUCT = "<rdf:Description/>";
    static final Set RDF_ATTR_QUALIFIER = new HashSet<String>(Arrays.asList("xml:lang", "rdf:resource", "rdf:ID", "rdf:bagID", "rdf:nodeID"));
    private XMPMetaImpl xmp;
    private CountOutputStream outputStream;
    private OutputStreamWriter writer;
    private SerializeOptions options;
    private int unicodeSize = 1;
    private int padding;

    public void serialize(XMPMeta xMPMeta, OutputStream outputStream, SerializeOptions serializeOptions) throws XMPException {
        try {
            this.outputStream = new CountOutputStream(outputStream);
            this.writer = new OutputStreamWriter((OutputStream)this.outputStream, serializeOptions.getEncoding());
            this.xmp = (XMPMetaImpl)xMPMeta;
            this.options = serializeOptions;
            this.padding = serializeOptions.getPadding();
            this.writer = new OutputStreamWriter((OutputStream)this.outputStream, serializeOptions.getEncoding());
            this.checkOptionsConsistence();
            String string = this.serializeAsRDF();
            this.writer.flush();
            this.addPadding(string.length());
            this.write(string);
            this.writer.flush();
            this.outputStream.close();
        }
        catch (IOException iOException) {
            throw new XMPException("Error writing to the OutputStream", 0);
        }
    }

    private void addPadding(int n) throws XMPException, IOException {
        int n2;
        if (this.options.getExactPacketLength()) {
            n2 = this.outputStream.getBytesWritten() + n * this.unicodeSize;
            if (n2 > this.padding) {
                throw new XMPException("Can't fit into specified packet size", 107);
            }
            this.padding -= n2;
        }
        this.padding /= this.unicodeSize;
        n2 = this.options.getNewline().length();
        if (this.padding >= n2) {
            this.padding -= n2;
            while (this.padding >= 100 + n2) {
                this.writeChars(100, ' ');
                this.writeNewline();
                this.padding -= 100 + n2;
            }
            this.writeChars(this.padding, ' ');
            this.writeNewline();
        } else {
            this.writeChars(this.padding, ' ');
        }
    }

    protected void checkOptionsConsistence() throws XMPException {
        if (this.options.getEncodeUTF16BE() | this.options.getEncodeUTF16LE()) {
            this.unicodeSize = 2;
        }
        if (this.options.getExactPacketLength()) {
            if (this.options.getOmitPacketWrapper() | this.options.getIncludeThumbnailPad()) {
                throw new XMPException("Inconsistent options for exact size serialize", 103);
            }
            if ((this.options.getPadding() & this.unicodeSize - 1) != 0) {
                throw new XMPException("Exact size must be a multiple of the Unicode element", 103);
            }
        } else if (this.options.getReadOnlyPacket()) {
            if (this.options.getOmitPacketWrapper() | this.options.getIncludeThumbnailPad()) {
                throw new XMPException("Inconsistent options for read-only packet", 103);
            }
            this.padding = 0;
        } else if (this.options.getOmitPacketWrapper()) {
            if (this.options.getIncludeThumbnailPad()) {
                throw new XMPException("Inconsistent options for non-packet serialize", 103);
            }
            this.padding = 0;
        } else {
            if (this.padding == 0) {
                this.padding = 2048 * this.unicodeSize;
            }
            if (this.options.getIncludeThumbnailPad() && !this.xmp.doesPropertyExist("http://ns.adobe.com/xap/1.0/", "Thumbnails")) {
                this.padding += 10000 * this.unicodeSize;
            }
        }
    }

    private String serializeAsRDF() throws IOException, XMPException {
        int n = 0;
        if (!this.options.getOmitPacketWrapper()) {
            this.writeIndent(n);
            this.write(PACKET_HEADER);
            this.writeNewline();
        }
        if (!this.options.getOmitXmpMetaElement()) {
            this.writeIndent(n);
            this.write(RDF_XMPMETA_START);
            if (!this.options.getOmitVersionAttribute()) {
                this.write(XMPMetaFactory.getVersionInfo().getMessage());
            }
            this.write("\">");
            this.writeNewline();
            ++n;
        }
        this.writeIndent(n);
        this.write(RDF_RDF_START);
        this.writeNewline();
        if (this.options.getUseCanonicalFormat()) {
            this.serializeCanonicalRDFSchemas(n);
        } else {
            this.serializeCompactRDFSchemas(n);
        }
        this.writeIndent(n);
        this.write(RDF_RDF_END);
        this.writeNewline();
        if (!this.options.getOmitXmpMetaElement()) {
            this.writeIndent(--n);
            this.write(RDF_XMPMETA_END);
            this.writeNewline();
        }
        String string = "";
        if (!this.options.getOmitPacketWrapper()) {
            for (n = this.options.getBaseIndent(); n > 0; --n) {
                string = string + this.options.getIndent();
            }
            string = string + PACKET_TRAILER;
            string = string + (this.options.getReadOnlyPacket() ? (char)'r' : 'w');
            string = string + PACKET_TRAILER2;
        }
        return string;
    }

    private void serializeCanonicalRDFSchemas(int n) throws IOException, XMPException {
        if (this.xmp.getRoot().getChildrenLength() > 0) {
            this.startOuterRDFDescription(this.xmp.getRoot(), n);
            Iterator iterator = this.xmp.getRoot().iterateChildren();
            while (iterator.hasNext()) {
                XMPNode xMPNode = (XMPNode)iterator.next();
                this.serializeCanonicalRDFSchema(xMPNode, n);
            }
            this.endOuterRDFDescription(n);
        } else {
            this.writeIndent(n + 1);
            this.write(RDF_SCHEMA_START);
            this.writeTreeName();
            this.write("/>");
            this.writeNewline();
        }
    }

    private void writeTreeName() throws IOException {
        this.write(34);
        String string = this.xmp.getRoot().getName();
        if (string != null) {
            this.appendNodeValue(string, true);
        }
        this.write(34);
    }

    private void serializeCompactRDFSchemas(int n) throws IOException, XMPException {
        XMPNode xMPNode;
        Object object;
        this.writeIndent(n + 1);
        this.write(RDF_SCHEMA_START);
        this.writeTreeName();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("xml");
        hashSet.add("rdf");
        Iterator iterator = this.xmp.getRoot().iterateChildren();
        while (iterator.hasNext()) {
            object = (XMPNode)iterator.next();
            this.declareUsedNamespaces((XMPNode)object, hashSet, n + 3);
        }
        boolean bl = true;
        object = this.xmp.getRoot().iterateChildren();
        while (object.hasNext()) {
            xMPNode = (XMPNode)object.next();
            bl &= this.serializeCompactRDFAttrProps(xMPNode, n + 2);
        }
        if (bl) {
            this.write("/>");
            this.writeNewline();
            return;
        }
        this.write(62);
        this.writeNewline();
        object = this.xmp.getRoot().iterateChildren();
        while (object.hasNext()) {
            xMPNode = (XMPNode)object.next();
            this.serializeCompactRDFElementProps(xMPNode, n + 2);
        }
        this.writeIndent(n + 1);
        this.write("</rdf:Description>");
        this.writeNewline();
    }

    private boolean serializeCompactRDFAttrProps(XMPNode xMPNode, int n) throws IOException {
        boolean bl = true;
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (this.canBeRDFAttrProp(xMPNode2)) {
                this.writeNewline();
                this.writeIndent(n);
                this.write(xMPNode2.getName());
                this.write("=\"");
                this.appendNodeValue(xMPNode2.getValue(), true);
                this.write(34);
                continue;
            }
            bl = false;
        }
        return bl;
    }

    private void serializeCompactRDFElementProps(XMPNode xMPNode, int n) throws IOException, XMPException {
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (this.canBeRDFAttrProp(xMPNode2)) continue;
            boolean bl = true;
            boolean bl2 = true;
            String string = xMPNode2.getName();
            if ("[]".equals(string)) {
                string = "rdf:li";
            }
            this.writeIndent(n);
            this.write(60);
            this.write(string);
            boolean bl3 = false;
            boolean bl4 = false;
            Object[] objectArray = xMPNode2.iterateQualifier();
            while (objectArray.hasNext()) {
                XMPNode xMPNode3 = (XMPNode)objectArray.next();
                if (!RDF_ATTR_QUALIFIER.contains(xMPNode3.getName())) {
                    bl3 = true;
                    continue;
                }
                bl4 = "rdf:resource".equals(xMPNode3.getName());
                this.write(32);
                this.write(xMPNode3.getName());
                this.write("=\"");
                this.appendNodeValue(xMPNode3.getValue(), true);
                this.write(34);
            }
            if (bl3) {
                this.serializeCompactRDFGeneralQualifier(n, xMPNode2);
            } else if (!xMPNode2.getOptions().isCompositeProperty()) {
                objectArray = this.serializeCompactRDFSimpleProp(xMPNode2);
                bl = (Boolean)objectArray[0];
                bl2 = (Boolean)objectArray[1];
            } else if (xMPNode2.getOptions().isArray()) {
                this.serializeCompactRDFArrayProp(xMPNode2, n);
            } else {
                bl = this.serializeCompactRDFStructProp(xMPNode2, n, bl4);
            }
            if (!bl) continue;
            if (bl2) {
                this.writeIndent(n);
            }
            this.write("</");
            this.write(string);
            this.write(62);
            this.writeNewline();
        }
    }

    private Object[] serializeCompactRDFSimpleProp(XMPNode xMPNode) throws IOException {
        Boolean bl = Boolean.TRUE;
        Boolean bl2 = Boolean.TRUE;
        if (xMPNode.getOptions().isURI()) {
            this.write(" rdf:resource=\"");
            this.appendNodeValue(xMPNode.getValue(), true);
            this.write("\"/>");
            this.writeNewline();
            bl = Boolean.FALSE;
        } else if (xMPNode.getValue() == null || xMPNode.getValue().length() == 0) {
            this.write("/>");
            this.writeNewline();
            bl = Boolean.FALSE;
        } else {
            this.write(62);
            this.appendNodeValue(xMPNode.getValue(), false);
            bl2 = Boolean.FALSE;
        }
        return new Object[]{bl, bl2};
    }

    private void serializeCompactRDFArrayProp(XMPNode xMPNode, int n) throws IOException, XMPException {
        this.write(62);
        this.writeNewline();
        this.emitRDFArrayTag(xMPNode, true, n + 1);
        if (xMPNode.getOptions().isArrayAltText()) {
            XMPNodeUtils.normalizeLangArray(xMPNode);
        }
        this.serializeCompactRDFElementProps(xMPNode, n + 2);
        this.emitRDFArrayTag(xMPNode, false, n + 1);
    }

    private boolean serializeCompactRDFStructProp(XMPNode xMPNode, int n, boolean bl) throws XMPException, IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (this.canBeRDFAttrProp(xMPNode2)) {
                bl2 = true;
            } else {
                bl3 = true;
            }
            if (!bl2 || !bl3) continue;
            break;
        }
        if (bl && bl3) {
            throw new XMPException("Can't mix rdf:resource qualifier and element fields", 202);
        }
        if (!xMPNode.hasChildren()) {
            this.write(" rdf:parseType=\"Resource\"/>");
            this.writeNewline();
            bl4 = false;
        } else if (!bl3) {
            this.serializeCompactRDFAttrProps(xMPNode, n + 1);
            this.write("/>");
            this.writeNewline();
            bl4 = false;
        } else if (!bl2) {
            this.write(" rdf:parseType=\"Resource\">");
            this.writeNewline();
            this.serializeCompactRDFElementProps(xMPNode, n + 1);
        } else {
            this.write(62);
            this.writeNewline();
            this.writeIndent(n + 1);
            this.write(RDF_STRUCT_START);
            this.serializeCompactRDFAttrProps(xMPNode, n + 2);
            this.write(">");
            this.writeNewline();
            this.serializeCompactRDFElementProps(xMPNode, n + 1);
            this.writeIndent(n + 1);
            this.write("</rdf:Description>");
            this.writeNewline();
        }
        return bl4;
    }

    private void serializeCompactRDFGeneralQualifier(int n, XMPNode xMPNode) throws IOException, XMPException {
        this.write(" rdf:parseType=\"Resource\">");
        this.writeNewline();
        this.serializeCanonicalRDFProperty(xMPNode, false, true, n + 1);
        Iterator iterator = xMPNode.iterateQualifier();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            this.serializeCanonicalRDFProperty(xMPNode2, false, false, n + 1);
        }
    }

    private void serializeCanonicalRDFSchema(XMPNode xMPNode, int n) throws IOException, XMPException {
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            this.serializeCanonicalRDFProperty(xMPNode2, this.options.getUseCanonicalFormat(), false, n + 2);
        }
    }

    private void declareUsedNamespaces(XMPNode xMPNode, Set set, int n) throws IOException {
        XMPNode xMPNode2;
        Object object;
        if (xMPNode.getOptions().isSchemaNode()) {
            object = xMPNode.getValue().substring(0, xMPNode.getValue().length() - 1);
            this.declareNamespace((String)object, xMPNode.getName(), set, n);
        } else if (xMPNode.getOptions().isStruct()) {
            object = xMPNode.iterateChildren();
            while (object.hasNext()) {
                xMPNode2 = (XMPNode)object.next();
                this.declareNamespace(xMPNode2.getName(), null, set, n);
            }
        }
        object = xMPNode.iterateChildren();
        while (object.hasNext()) {
            xMPNode2 = (XMPNode)object.next();
            this.declareUsedNamespaces(xMPNode2, set, n);
        }
        object = xMPNode.iterateQualifier();
        while (object.hasNext()) {
            xMPNode2 = (XMPNode)object.next();
            this.declareNamespace(xMPNode2.getName(), null, set, n);
            this.declareUsedNamespaces(xMPNode2, set, n);
        }
    }

    private void declareNamespace(String string, String string2, Set set, int n) throws IOException {
        if (string2 == null) {
            QName qName = new QName(string);
            if (qName.hasPrefix()) {
                string = qName.getPrefix();
                string2 = XMPMetaFactory.getSchemaRegistry().getNamespaceURI(string + ":");
                this.declareNamespace(string, string2, set, n);
            } else {
                return;
            }
        }
        if (!set.contains(string)) {
            this.writeNewline();
            this.writeIndent(n);
            this.write("xmlns:");
            this.write(string);
            this.write("=\"");
            this.write(string2);
            this.write(34);
            set.add(string);
        }
    }

    private void startOuterRDFDescription(XMPNode xMPNode, int n) throws IOException {
        this.writeIndent(n + 1);
        this.write(RDF_SCHEMA_START);
        this.writeTreeName();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("xml");
        hashSet.add("rdf");
        this.declareUsedNamespaces(xMPNode, hashSet, n + 3);
        this.write(62);
        this.writeNewline();
    }

    private void endOuterRDFDescription(int n) throws IOException {
        this.writeIndent(n + 1);
        this.write("</rdf:Description>");
        this.writeNewline();
    }

    private void serializeCanonicalRDFProperty(XMPNode xMPNode, boolean bl, boolean bl2, int n) throws IOException, XMPException {
        XMPNode xMPNode2;
        boolean bl3 = true;
        boolean bl4 = true;
        String string = xMPNode.getName();
        if (bl2) {
            string = "rdf:value";
        } else if ("[]".equals(string)) {
            string = "rdf:li";
        }
        this.writeIndent(n);
        this.write(60);
        this.write(string);
        boolean bl5 = false;
        boolean bl6 = false;
        Iterator iterator = xMPNode.iterateQualifier();
        while (iterator.hasNext()) {
            xMPNode2 = (XMPNode)iterator.next();
            if (!RDF_ATTR_QUALIFIER.contains(xMPNode2.getName())) {
                bl5 = true;
                continue;
            }
            bl6 = "rdf:resource".equals(xMPNode2.getName());
            if (bl2) continue;
            this.write(32);
            this.write(xMPNode2.getName());
            this.write("=\"");
            this.appendNodeValue(xMPNode2.getValue(), true);
            this.write(34);
        }
        if (bl5 && !bl2) {
            if (bl6) {
                throw new XMPException("Can't mix rdf:resource and general qualifiers", 202);
            }
            if (bl) {
                this.write(">");
                this.writeNewline();
                this.writeIndent(++n);
                this.write(RDF_STRUCT_START);
                this.write(">");
            } else {
                this.write(" rdf:parseType=\"Resource\">");
            }
            this.writeNewline();
            this.serializeCanonicalRDFProperty(xMPNode, bl, true, n + 1);
            iterator = xMPNode.iterateQualifier();
            while (iterator.hasNext()) {
                xMPNode2 = (XMPNode)iterator.next();
                if (RDF_ATTR_QUALIFIER.contains(xMPNode2.getName())) continue;
                this.serializeCanonicalRDFProperty(xMPNode2, bl, false, n + 1);
            }
            if (bl) {
                this.writeIndent(n);
                this.write("</rdf:Description>");
                this.writeNewline();
                --n;
            }
        } else if (!xMPNode.getOptions().isCompositeProperty()) {
            if (xMPNode.getOptions().isURI()) {
                this.write(" rdf:resource=\"");
                this.appendNodeValue(xMPNode.getValue(), true);
                this.write("\"/>");
                this.writeNewline();
                bl3 = false;
            } else if (xMPNode.getValue() == null || "".equals(xMPNode.getValue())) {
                this.write("/>");
                this.writeNewline();
                bl3 = false;
            } else {
                this.write(62);
                this.appendNodeValue(xMPNode.getValue(), false);
                bl4 = false;
            }
        } else if (xMPNode.getOptions().isArray()) {
            this.write(62);
            this.writeNewline();
            this.emitRDFArrayTag(xMPNode, true, n + 1);
            if (xMPNode.getOptions().isArrayAltText()) {
                XMPNodeUtils.normalizeLangArray(xMPNode);
            }
            iterator = xMPNode.iterateChildren();
            while (iterator.hasNext()) {
                xMPNode2 = (XMPNode)iterator.next();
                this.serializeCanonicalRDFProperty(xMPNode2, bl, false, n + 2);
            }
            this.emitRDFArrayTag(xMPNode, false, n + 1);
        } else if (!bl6) {
            if (!xMPNode.hasChildren()) {
                if (bl) {
                    this.write(">");
                    this.writeNewline();
                    this.writeIndent(n + 1);
                    this.write(RDF_EMPTY_STRUCT);
                } else {
                    this.write(" rdf:parseType=\"Resource\"/>");
                    bl3 = false;
                }
                this.writeNewline();
            } else {
                if (bl) {
                    this.write(">");
                    this.writeNewline();
                    this.writeIndent(++n);
                    this.write(RDF_STRUCT_START);
                    this.write(">");
                } else {
                    this.write(" rdf:parseType=\"Resource\">");
                }
                this.writeNewline();
                iterator = xMPNode.iterateChildren();
                while (iterator.hasNext()) {
                    xMPNode2 = (XMPNode)iterator.next();
                    this.serializeCanonicalRDFProperty(xMPNode2, bl, false, n + 1);
                }
                if (bl) {
                    this.writeIndent(n);
                    this.write("</rdf:Description>");
                    this.writeNewline();
                    --n;
                }
            }
        } else {
            iterator = xMPNode.iterateChildren();
            while (iterator.hasNext()) {
                xMPNode2 = (XMPNode)iterator.next();
                if (!this.canBeRDFAttrProp(xMPNode2)) {
                    throw new XMPException("Can't mix rdf:resource and complex fields", 202);
                }
                this.writeNewline();
                this.writeIndent(n + 1);
                this.write(32);
                this.write(xMPNode2.getName());
                this.write("=\"");
                this.appendNodeValue(xMPNode2.getValue(), true);
                this.write(34);
            }
            this.write("/>");
            this.writeNewline();
            bl3 = false;
        }
        if (bl3) {
            if (bl4) {
                this.writeIndent(n);
            }
            this.write("</");
            this.write(string);
            this.write(62);
            this.writeNewline();
        }
    }

    private void emitRDFArrayTag(XMPNode xMPNode, boolean bl, int n) throws IOException {
        if (bl || xMPNode.hasChildren()) {
            this.writeIndent(n);
            this.write(bl ? "<rdf:" : "</rdf:");
            if (xMPNode.getOptions().isArrayAlternate()) {
                this.write("Alt");
            } else if (xMPNode.getOptions().isArrayOrdered()) {
                this.write("Seq");
            } else {
                this.write("Bag");
            }
            if (bl && !xMPNode.hasChildren()) {
                this.write("/>");
            } else {
                this.write(">");
            }
            this.writeNewline();
        }
    }

    private void appendNodeValue(String string, boolean bl) throws IOException {
        if (string == null) {
            string = "";
        }
        this.write(Utils.escapeXML(string, bl, true));
    }

    private boolean canBeRDFAttrProp(XMPNode xMPNode) {
        return !xMPNode.hasQualifier() && !xMPNode.getOptions().isURI() && !xMPNode.getOptions().isCompositeProperty() && !"[]".equals(xMPNode.getName());
    }

    private void writeIndent(int n) throws IOException {
        for (int i = this.options.getBaseIndent() + n; i > 0; --i) {
            this.writer.write(this.options.getIndent());
        }
    }

    private void write(int n) throws IOException {
        this.writer.write(n);
    }

    private void write(String string) throws IOException {
        this.writer.write(string);
    }

    private void writeChars(int n, char c) throws IOException {
        while (n > 0) {
            this.writer.write(c);
            --n;
        }
    }

    private void writeNewline() throws IOException {
        this.writer.write(this.options.getNewline());
    }
}

