/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buf;
    private long limit;

    public ByteBufferInputStream(ByteBuffer buf, long limit) {
        this.buf = buf;
        this.limit = limit;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.limit <= 0L) {
            return -1;
        }
        --this.limit;
        return this.buf.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        if (this.limit <= 0L) {
            return -1;
        }
        len = (int)Math.min((long)len, this.limit);
        this.buf.get(bytes, off, len);
        this.limit -= (long)len;
        return len;
    }
}

