# Generated by default/object.tt
package Paws::IoTEventsData::CustomerAction;
  use Moose;
  has AcknowledgeActionConfiguration => (is => 'ro', isa => 'Paws::IoTEventsData::AcknowledgeActionConfiguration', request_name => 'acknowledgeActionConfiguration', traits => ['NameInRequest']);
  has ActionName => (is => 'ro', isa => 'Str', request_name => 'actionName', traits => ['NameInRequest']);
  has DisableActionConfiguration => (is => 'ro', isa => 'Paws::IoTEventsData::DisableActionConfiguration', request_name => 'disableActionConfiguration', traits => ['NameInRequest']);
  has EnableActionConfiguration => (is => 'ro', isa => 'Paws::IoTEventsData::EnableActionConfiguration', request_name => 'enableActionConfiguration', traits => ['NameInRequest']);
  has ResetActionConfiguration => (is => 'ro', isa => 'Paws::IoTEventsData::ResetActionConfiguration', request_name => 'resetActionConfiguration', traits => ['NameInRequest']);
  has SnoozeActionConfiguration => (is => 'ro', isa => 'Paws::IoTEventsData::SnoozeActionConfiguration', request_name => 'snoozeActionConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEventsData::CustomerAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEventsData::CustomerAction object:

  $service_obj->Method(Att1 => { AcknowledgeActionConfiguration => $value, ..., SnoozeActionConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEventsData::CustomerAction object:

  $result = $service_obj->Method(...);
  $result->Att1->AcknowledgeActionConfiguration

=head1 DESCRIPTION

Contains information about the action that you can take to respond to
the alarm.

=head1 ATTRIBUTES


=head2 AcknowledgeActionConfiguration => L<Paws::IoTEventsData::AcknowledgeActionConfiguration>

Contains the configuration information of an acknowledge action.


=head2 ActionName => Str

The name of the action. The action name can be one of the following
values:

=over

=item *

C<SNOOZE> - When you snooze the alarm, the alarm state changes to
C<SNOOZE_DISABLED>.

=item *

C<ENABLE> - When you enable the alarm, the alarm state changes to
C<NORMAL>.

=item *

C<DISABLE> - When you disable the alarm, the alarm state changes to
C<DISABLED>.

=item *

C<ACKNOWLEDGE> - When you acknowledge the alarm, the alarm state
changes to C<ACKNOWLEDGED>.

=item *

C<RESET> - When you reset the alarm, the alarm state changes to
C<NORMAL>.

=back

For more information, see the AlarmState
(https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html)
API.


=head2 DisableActionConfiguration => L<Paws::IoTEventsData::DisableActionConfiguration>

Contains the configuration information of a disable action.


=head2 EnableActionConfiguration => L<Paws::IoTEventsData::EnableActionConfiguration>

Contains the configuration information of an enable action.


=head2 ResetActionConfiguration => L<Paws::IoTEventsData::ResetActionConfiguration>

Contains the configuration information of a reset action.


=head2 SnoozeActionConfiguration => L<Paws::IoTEventsData::SnoozeActionConfiguration>

Contains the configuration information of a snooze action.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEventsData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

