# Generated by default/object.tt
package Paws::LakeFormation::LFTag;
  use Moose;
  has TagKey => (is => 'ro', isa => 'Str', required => 1);
  has TagValues => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LakeFormation::LFTag

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LakeFormation::LFTag object:

  $service_obj->Method(Att1 => { TagKey => $value, ..., TagValues => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LakeFormation::LFTag object:

  $result = $service_obj->Method(...);
  $result->Att1->TagKey

=head1 DESCRIPTION

A structure that allows an admin to grant user permissions on certain
conditions. For example, granting a role access to all columns not
tagged 'PII' of tables tagged 'Prod'.

=head1 ATTRIBUTES


=head2 B<REQUIRED> TagKey => Str

The key-name for the tag.


=head2 B<REQUIRED> TagValues => ArrayRef[Str|Undef]

A list of possible values an attribute can take.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LakeFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

