# Generated by default/object.tt
package Paws::Quicksight::ThemeConfiguration;
  use Moose;
  has DataColorPalette => (is => 'ro', isa => 'Paws::Quicksight::DataColorPalette');
  has Sheet => (is => 'ro', isa => 'Paws::Quicksight::SheetStyle');
  has UIColorPalette => (is => 'ro', isa => 'Paws::Quicksight::UIColorPalette');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::ThemeConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::ThemeConfiguration object:

  $service_obj->Method(Att1 => { DataColorPalette => $value, ..., UIColorPalette => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::ThemeConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DataColorPalette

=head1 DESCRIPTION

The theme configuration. This configuration contains all of the display
properties for a theme.

=head1 ATTRIBUTES


=head2 DataColorPalette => L<Paws::Quicksight::DataColorPalette>

Color properties that apply to chart data colors.


=head2 Sheet => L<Paws::Quicksight::SheetStyle>

Display options related to sheets.


=head2 UIColorPalette => L<Paws::Quicksight::UIColorPalette>

Color properties that apply to the UI and to charts, excluding the
colors that apply to data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

