

sub new {
	my ($class, $width, $height) = @_;

	my $self = {
		w => $width,
		h => $height,
		firstTile => tile->new(undef, 0,0),
		currentMatchedTile => firstTile
	}

	bless $self, $class;
}

### NOTE : you give the following tile and its xoffset,y in tile get set here  
sub addToTiles {
	my ($self, $t) = @_;

	$t->setXoffset(($self->{currentMatchedTile}->getXoffset++) % $self->{width});
	$t->setYoffset(floor(($self->{currentMatchedTile}->getYoffset++) / $self->{width}));

	$self->{currentMatchedTile}->setFollower($t);
	### FIXME $t->setFollower(undef);
}

### _full_ rewind
sub full_rewind {
	my $self = shift;

	$self->{currentMatchedTile} = $self->{firstTile};

}

### fetch tile _added_ to firstTile, idx is added to it
sub indexOf {
	my ($self, $idx) = @_;

	my $t = $self->{firstTile};

	### NOTE, $idx must be small enough, you do not know the length of 
	### the tile list, here we know the width and height of the matrix

	while ($idx-- > 0) {

		
		$t = $t->getNext;

	}	

	$self->{firstTile} = $t;
	return $t;

}

### rewind to index
### fetch tile _added_ to CurrentMatchedTile, idx is added to it
sub indexOfMatched {
	my ($self, $idx) = @_;

	my $t = $self->{currentMatchedTile};

	### NOTE, $idx must be small enough, you do not know the length of 
	### the tile list, here we know the width and height of the matrix

	while ($idx-- > 0) {

		
		$t = $t->getNext;

	}	

	$self->{currentMatchedTile} = $t;
	return $t;

}

### rewind to index
### there's on prev
sub rewindToIndex {
	my ($self, $idx) = @_;

	$self->full_rewind;

	$self->indexOf($idx);	

}

sub getNextTile {
	my ($self) = shift;

	return $self->{currentMatchedTile}->getNext;

}

