package Sport::Analytics::NHL::Errors;

use strict;
use warnings FATAL => 'all';

use Sport::Analytics::NHL::Config;

use parent 'Exporter';

our @EXPORT = qw(
	%BROKEN_FILES %BROKEN_HEADERS
	%BROKEN_COACHES %BROKEN_PLAYERS %BROKEN_EVENTS
	%BROKEN_ROSTERS %BROKEN_PLAYER_IDS
	%BROKEN_TIMES %BROKEN_COORDS
	%NAME_TYPOS %NAME_VARIATIONS %REVERSE_NAME_TYPOS
	%SPECIAL_EVENTS %FORCED_PUSH
	%MISSING_EVENTS %MISSING_COACHES %MISSING_PLAYERS
);

our %NAME_TYPOS = (
	'BRYCE VAN BRABRANT' => 'BRYCE VAN BRABANT',
	'TOMMY WESTLUND'     => 'TOMMY VESTLUND',
	'MATTIAS JOHANSSON'  => 'MATHIAS JOHANSSON',
	'WESTLUND'           => 'VESTLUND',
	'T. WESTLUND'        => 'T. VESTLUND',
	'N. KRONVALL'        => 'N. KRONWALL',
	'S. KRONVALL'        => 'S. KRONWALL',
	'A. KASTSITSYN'      => 'A. KOSTITSYN',
	'F. MEYER IV'        => 'F. MEYER',
	'P/ BRISEBOIS'       => 'P. BRISEBOIS',
	'K. PUSHKARYOV'      => 'K. PUSHKAREV',
	'M. SATIN'           => 'M. SATAN',
	'B. RADIVOJEVICE'    => 'B. RADIVOJEVIC',
	'J. BULLIS'          => 'J. BULIS',
	'PJ. AXELSSON'       => 'P.J. AXELSSON',
);
our %REVERSE_NAME_TYPOS = (
	'KRONWALL' => 'KRONVALL',
);

our %NAME_VARIATIONS = (
	'CHRIS KENADY'   => 'CHRISTOPHER KENADY',
	'JOHN THOMAS'    => 'S. THOMAS',
	'BILLY TIBBETTS' => 'W. TIBBETTS',
	'WILLIAM BOWLER' => 'B. BOWLER',
	'BOBBY HOLIK'    => 'R. HOLIK',
	'RANDY MCKAY'    => 'H. MCKAY',
);

our %BROKEN_COACHES = (
	STICKLE                => 'BOB MURDOCH',
	'CASHMAN/THIFFAULT'    => 'MICHEL BERGERON',
	'LEVER/SMITH'          => 'TED SATOR',
	'WILSON/RAEDER'        => 'TOM WEBSTER',
	'RAEDER/WILSON'        => 'TOM WEBSTER',
	'BAXTER/CHARRON'       => 'DOUG RISEBROUGH',
	'CHARRON/BAXTER'       => 'GUY CHARRON',
	'CHARON,BAXTER,HISLOP' => 'GUY CHARRON',
);

our %BROKEN_PLAYER_IDS = (8445204 => 8445202);

our %BROKEN_PLAYERS = (
	BS => {
		192730312 => {
			8448095 => { number => 16, }
		},
		200320009 => {
			8467349 => { number => 8,  position => 'D', },
			8468789 => { number => 29, position => 'C', },
			8464960 => { number => 21, position => 'C', },
		},
		200320013 => {
			8467333 => { number => 9, position => 'R', },
		},
		200320019 => {
			8466147 => { number => 17, position => 'C',},
		}
	},
);

our %FORCED_PUSH = (
        PL => {
                200820009 => { 82  => 1, 83 => 1, },
                201020989 => { 346 => 1 },
                201120094 => { 198 => 1 },
                201320083 => { 351 => 1 },
                201420921 => { 354 => 1 },
                201520057 => { 150 => 1, 158 => 1, 197 => 1 },
                201520064 => { 316 => 1 },
                201520436 => { 176 => 1 },
                201520518 => { 152 => 1 },
                201520593 => { 273 => 1 },
                201520741 => { 343 => 1, 344 => 1 },
                201521035 => { 172 => 1 },
                201530122 => { 347 => 1 },
                201620161 => { 286 => 1 },
                201620177 => { 197 => 1 },
                201620321 => {  64 => 1 },
                201620920 => { 296 => 1, 297 => 1 },
                #201621070 => {  35 => 1 },
                201621081 => { 101 => 1 },
                201720176 => { 303 => 1, 304 => 1, 305 => 1, 306 => 1},
                #200820681 => {  74 => 1 },
        },
);

our %BROKEN_ROSTERS = (
	198720509 => [ [], [ { 'No.' => 0, number => 30 } ], ],
	199020353 => [ [], [ { 'No.' => 0, number => 30 } ], ],
	199020696 => [ [], [ { 'No.' => 0, number => 35 } ], ],
	199120656 => [ [], [ { 'No.' => 16, penaltyMinutes => 4 }, ], ],
	199120753 => [ [ { 'No.' => 26, penaltyMinutes => 7 }, ], [], ],
	199120809 => [ [ { 'No.' => 5, penaltyMinutes => 2 }, ], [], ],
	199120839 => [ [ { 'No.' => 11, penaltyMinutes => 12 }, ], [], ],
	199120877 => [ [ { 'No.' => 27, penaltyMinutes => 18 }, ], [], ],
	199220449 => [ [ { 'No.' => 29, penaltyMinutes => 18 }, ], [], ],
	199220585 => [ [], [ { 'No.' => 39, penaltyMinutes => 17 }, ], ],
	199320044 => [ [ { 'No.' => 26, penaltyMinutes => 4 }, ], [], ],
	199320074 => [ [ { 'No.' => 27, penaltyMinutes => 4 }, ], [], ],
	199320404 => [ [ { 'No.' => 29, penaltyMinutes => 19 }, ], [], ],
	199320499 => [ [], [ { 'No.' => 32, penaltyMinutes => 2 }, ], ],
	199320640 => [ [], [ { 'No.' => 12, penaltyMinutes => 6 }, ], ],
	199520048 => [ [ { 'No.' => 12, penaltyMinutes => 2, }, ], [], ],
	199520790 => [ [ { 'No.' => 12, penaltyMinutes => 6, }, ], [], ],
	199530123 => [ [], [ { 'No.' => 23, penaltyMinutes => 14, }, ], ],
	199620473 => [ [ { 'No.' => 27, penaltyMinutes => 2, }, ], [], ],
	199620546 => [ [ { 'No.' => 17, penaltyMinutes => 2, }, ], [], ],
	199620548 => [ [ { 'No.' => 33, penaltyMinutes => 23 }, ], [], ],
	199620927 => [ [ { 'No.' => 20, penaltyMinutes => 2, },
		{ 'No.' => 77, penaltyMinutes => 2, }, ], [], ],
	199630222 => [ [], [ { 'No.' => 18, penaltyMinutes => 2, }, ], ],
	199720830 => [ [], [ { 'No.' => 35, 'EV' => '10 - 12' }, ], ],
	199720876 => [ [], [ { 'No.' => 27, 'EV' => '11 - 14' }, ], ],
	199720997 => [ [ { 'No.' => 31, 'SH' => '3 - 3' }, ], [], ],
	199820004 => [ [], [ { 'No.' => 34, 'EV' => '26 - 28' }, ], ],
	199820061 => [ [], [ { 'No.' => 35, 'EV' => '19 - 20' }, ], ],
	200320027 => [ [], [ { 'No.' => 29, 'name' => 'JAMIE MCLENNAN' }, ], ],
	200520312 => [ [ { 'No.' => 7, error => 1 } ], [] ],
);

our %BROKEN_EVENTS = (
	BS => {
		198520010 => { 16 => { time =>  '7:48' }, },
		198520611 => { 32 => { time => '10:09' }, },
		198820689 => {  5 => { player2 => 8446637 }, 6 => { player2 => 8446637 }, },
	},
	BH => {

	},
	PL => {
		200220255 => { 122 => { player2 => 29 } },
		200220266 => {
			81 => { player1 => 54 },
			146 => { on_ice2 => [1, 54,21, 18, 11, 4, ] }
		},
		200321115 => { 10 =>  { player2 => 38 } },
        200520084 => { 54  => { player1 => 35 } },
#        200520094 => {   3 => { team1 => 'NYR', strength => 'EV', }, },
		200520307 => { 176 => { player1 => 20 } },
		200520312 => {
			1 => {
				id          => 1, period => 1, time => '0:00', team => 'NSH', strength => 'EV',
				shot_type   => 'Snap', distance => 18, type => 'GOAL', location => 'Off',
				description => '22 JOHNSON, A: 20 SUTER, 7 UPSHALL, Snap, 18 ft',
				old         => 1, team1 => 'NSH', player1 => 22, assist1 => 20,
				on_ice      => [ [], [], ], special => 1, stage => 2, season => 2005,
			},
		},
		200520314 => {  47 => { player1 => 20 } },
        200520473 => { 254 => 0, },
        200520511 => { 247 => 0 },
        200520873 => { 143 => 0 },
		200520946 => { 211 => { player1 => 35 } },
        200521044 => { 313 => { player1 => 19, }, },
        200521114 => {   2 => 0 },
		200620433 => { 132 => { player1 => 31 } },
        200620597 => {  76 => 0, },
        200620637 => { 123 => 0, 217 => 0 },
        200620672 => { 131 => 0 },
        200620681 => { 305 => 0, },
        200620765 => { 266 => 0, },
        200621005 => { 180 => 0, },
        200621019 => {  66 => 0, },
		200621024 => { 139 => 0, 219 => { on_ice2 => [ 55, 47, 39, 3, 27, 94, ], }, 188 => 0, 194 => 0 },
		200621062 => { 220 => 0, },
        200621107 => { 151 => 0, },
        200621145 => { 194 => 0, },
		200720003 => { 275 => { description => 'CAR Team Too many men/ice - bench(2 min) Served By: #18 BAYDA, Neu. Zone', },
					   120 => {     on_ice => [ [14,6,84,44,71,39], [17,11,13,2,5,30] ], }, },
        200720014 => { 226 => { team1 => 'ARI', }, },
        200720019 => { 203 => { team1 => 'DAL', }, },
        200720026 => { 195 => { team1 => 'FLA', }, },
		200720028 => { 269 => 0, },
        200720039 => {  21 => { team1 => 'CAR', }, },
        200720199 => { 260 => 0, },
		200730174 => {
			221 => { on_ice => [ [15,25,6,33,41,29], [94,39,8,24,44,60] ]},
			222 => { on_ice => [ [15,25,6,33,41,29], [94,39,8,24,44,60] ]},
			223 => { on_ice => [ [15,25,6,33,41,29], [94,39,8,24,44,60] ]}
		} ,
		200921066 => {
			21 => { on_ice => [ [33,43,20,23,52,35], [17,38,40,3,29,1] ]},
		},
		201120110 => {
			89 => { on_ice => [ [81,84,19,2,51,50], [27,48,17,41,35] ]},
		},
		201220341 => { 301 => 0, },
		201321139 => {
			13 => { on_ice => [ [51,89,57,19,84,30], [8,19,88,7,61,31] ]},
		},
		201521197 => {
			27 => { on_ice => [ [ 21,10,15,5,6,1 ], [18,57,52,3,33,37] ] },
		},
		201621229 => {
			178 => { on_ice => [[15,21,73,6,53,32], [50,10,2,53,1]]},
		},
#        201230174 => { 396 => { penalty => 'ABUSIVE LANGUAGE' } },
        201020146 => { 311 => { player1 => 39, servedby => 26, }, },
		200820444 => { 190 => { player1 => $UNKNOWN_PLAYER_ID } },
		200820868 => { 299 => { length => 2, penalty => 'Instigator', description => 'EDM #18 MOREAU Instigator(2 min) Drawn By: DAL #29 OTT'}, },
        200821191 => { 289 => { player1 => 20, team1 => 'NSH', player2 => 2, team2 => 'CHI', }, },
		201020596 => { 275 => 0, },
		201020989 => { 346 => { reason => 'GOALIE STOPPED', description => 'GOALIE STOPPED', }, },
        201120094 => { 198 => { reason => 'GOALIE STOPPED', description => 'GOALIE STOPPED', }, },
		201120553 => { 294 => {
			length => 10, penalty => 'Misconduct', misconduct => 1,
			description => 'FLA #21 BARCH Game misconduct(10 min)',
		} },
		201320971 => {   1 => {
			id => 1, period => 1,
			time => '0:00',
			team => 'CBJ',
			strength => 'EV',
			shot_type => 'Snap',
			distance => 18,
			type => 'GOAL',
			location => 'Off',
			old => 1,
			description => 'CBJ #8 HORTON(5), A: 11 CALVERT(4); 21 WISNIEWSKI(43), Snap, 18 ft',
			team1 => 'NSH',
			player1 => 8470596,
			assist1 => 8476485,
			assist2 => 8470222,
			on_ice => [ [], [], ],
			special => 1, en => 0, gwg => 0,
		} },
        201420600 => { 328 => 0 },
        201420921 => { 354 => { reason => 'GOALIE STOPPED', description => 'GOALIE STOPPED', }, },
		201621127 => { 311 => { description => 'BOS #55 ACCIARI Misconduct(10 min), Def. Zone' }},
	},
	GS => {
	}
);

our %BROKEN_TIMES = (

);

our %BROKEN_COORDS = (

);

my $INCOMPLETE = -1;
my $REPLICA    = -2;
my $BROKEN     = -3;
my $NO_EVENTS  = -4;

our %BROKEN_FILES = (
	192130111 => { BS => $NO_EVENTS },
	192220010 => { BS => $NO_EVENTS },
	192620007 => { BS => $NO_EVENTS },
	192620097 => { BS => $NO_EVENTS },
	192620133 => { BS => $NO_EVENTS },
	192620149 => { BS => $NO_EVENTS },
	192720010 => { BS => $NO_EVENTS },
	192720016 => { BS => $NO_EVENTS },
	192720106 => { BS => $NO_EVENTS },
	192820158 => { BS => $NO_EVENTS },
	192920200 => { BS => $NO_EVENTS },
	193020213 => { BS => $NO_EVENTS },
	193120029 => { BS => $NO_EVENTS },
	193120079 => { BS => $NO_EVENTS },
	193120109 => { BS => $NO_EVENTS },
	193220004 => { BS => $NO_EVENTS },
	193220198 => { BS => $NO_EVENTS },
	193330141 => { BS => $NO_EVENTS },
	193520069 => { BS => $NO_EVENTS },
	193520118 => { BS => $NO_EVENTS },
	193720055 => { BS => $NO_EVENTS },
	193720156 => { BS => $NO_EVENTS },
	193820018 => { BS => $NO_EVENTS },
	193820123 => { BS => $NO_EVENTS },
	193920002 => { BS => $NO_EVENTS },
	194220008 => { BS => $NO_EVENTS },
	194220030 => { BS => $NO_EVENTS },
	194220125 => { BS => $NO_EVENTS },
	194320101 => { BS => $NO_EVENTS },
	194320118 => { BS => $NO_EVENTS },
	194420032 => { BS => $NO_EVENTS },
	194420120 => { BS => $NO_EVENTS },
	194430216 => { BS => $NO_EVENTS },
	194620098 => { BS => $NO_EVENTS },
	194620113 => { BS => $NO_EVENTS },
	194620134 => { BS => $NO_EVENTS },
	194720071 => { BS => $NO_EVENTS },
	194720129 => { BS => $NO_EVENTS },
	194730114 => { BS => $NO_EVENTS },
	194820012 => { BS => $NO_EVENTS },
	194820083 => { BS => $NO_EVENTS },
	194920036 => { BS => $NO_EVENTS },
	194920041 => { BS => $NO_EVENTS },
	194920051 => { BS => $NO_EVENTS },
	194920082 => { BS => $NO_EVENTS },
	195020056 => { BS => $NO_EVENTS },
	195020127 => { BS => $NO_EVENTS },
	195120010 => { BS => $NO_EVENTS },
	195120089 => { BS => $NO_EVENTS },
	195220059 => { BS => $NO_EVENTS },
	195220105 => { BS => $NO_EVENTS },
	195220140 => { BS => $NO_EVENTS },
	195220150 => { BS => $NO_EVENTS },
	195220164 => { BS => $NO_EVENTS },
	195230111 => { BS => $NO_EVENTS },
	195320012 => { BS => $NO_EVENTS },
	195320086 => { BS => $NO_EVENTS },
	195320148 => { BS => $NO_EVENTS },
	195320192 => { BS => $NO_EVENTS },
	195420046 => { BS => $NO_EVENTS },
	195420049 => { BS => $NO_EVENTS },
	195420151 => { BS => $NO_EVENTS },
	195420188 => { BS => $NO_EVENTS },
	195430111 => { BS => $NO_EVENTS },
	195520193 => { BS => $NO_EVENTS },
	195620013 => { BS => $NO_EVENTS },
	195720005 => { BS => $NO_EVENTS },
	195820192 => { BS => $NO_EVENTS },
	195920058 => { BS => $NO_EVENTS },
	195920071 => { BS => $NO_EVENTS },
	195920182 => { BS => $NO_EVENTS },
	195920202 => { BS => $NO_EVENTS },
	196020094 => { BS => $NO_EVENTS },
	196020139 => { BS => $NO_EVENTS },
	196120106 => { BS => $NO_EVENTS },
	196120137 => { BS => $NO_EVENTS },
	196130212 => { BS => $NO_EVENTS },
	196220204 => { BS => $NO_EVENTS },
	196320003 => { BS => $NO_EVENTS },
	196320089 => { BS => $NO_EVENTS },
	196320186 => { BS => $NO_EVENTS },
	196320195 => { BS => $NO_EVENTS },
	196420180 => { BS => $NO_EVENTS },
	196520131 => { BS => $NO_EVENTS },
	196520165 => { BS => $NO_EVENTS },
	196520189 => { BS => $NO_EVENTS },
	196620020 => { BS => $NO_EVENTS },
	196620095 => { BS => $NO_EVENTS },
	196620107 => { BS => $NO_EVENTS },
	196720019 => { BS => $NO_EVENTS },
	196720076 => { BS => $NO_EVENTS },
	196720183 => { BS => $NO_EVENTS },
	196720226 => { BS => $NO_EVENTS },
	196720356 => { BS => $NO_EVENTS },
	196720405 => { BS => $NO_EVENTS },
	196720437 => { BS => $NO_EVENTS },
	196820115 => { BS => $NO_EVENTS },
	196820127 => { BS => $NO_EVENTS },
	196820143 => { BS => $NO_EVENTS },
	196820158 => { BS => $NO_EVENTS },
	196820167 => { BS => $NO_EVENTS },
	196820189 => { BS => $NO_EVENTS },
	196820214 => { BS => $NO_EVENTS },
	196820315 => { BS => $NO_EVENTS },
	196820404 => { BS => $NO_EVENTS },
	196820425 => { BS => $NO_EVENTS },
	196820440 => { BS => $NO_EVENTS },
	196920012 => { BS => $NO_EVENTS },
	196920060 => { BS => $NO_EVENTS },
	196920121 => { BS => $NO_EVENTS },
	196920209 => { BS => $NO_EVENTS },
	196920314 => { BS => $NO_EVENTS },
	196920331 => { BS => $NO_EVENTS },
	196920390 => { BS => $NO_EVENTS },
	196920422 => { BS => $NO_EVENTS },
	196920432 => { BS => $NO_EVENTS },
	196920455 => { BS => $NO_EVENTS },
	197020112 => { BS => $NO_EVENTS },
	197020173 => { BS => $NO_EVENTS },
	197020245 => { BS => $NO_EVENTS },
	197020254 => { BS => $NO_EVENTS },
	197020365 => { BS => $NO_EVENTS },
	197020396 => { BS => $NO_EVENTS },
	197020506 => { BS => $NO_EVENTS },
	197020539 => { BS => $NO_EVENTS },
	197120017 => { BS => $NO_EVENTS },
	197120073 => { BS => $NO_EVENTS },
	197120076 => { BS => $NO_EVENTS },
	197120210 => { BS => $NO_EVENTS },
	197120275 => { BS => $NO_EVENTS },
	197120310 => { BS => $NO_EVENTS },
	197120326 => { BS => $NO_EVENTS },
	197120345 => { BS => $NO_EVENTS },
	197120446 => { BS => $NO_EVENTS },
	197120456 => { BS => $NO_EVENTS },
	197220106 => { BS => $NO_EVENTS },
	197220135 => { BS => $NO_EVENTS },
	197220179 => { BS => $NO_EVENTS },
	197220213 => { BS => $NO_EVENTS },
	197220281 => { BS => $NO_EVENTS },
	197220305 => { BS => $NO_EVENTS },
	197220324 => { BS => $NO_EVENTS },
	197220361 => { BS => $NO_EVENTS },
	197220368 => { BS => $NO_EVENTS },
	197220413 => { BS => $NO_EVENTS },
	197220566 => { BS => $NO_EVENTS },
	197220568 => { BS => $NO_EVENTS },
	197220587 => { BS => $NO_EVENTS },
	197320034 => { BS => $NO_EVENTS },
	197320039 => { BS => $NO_EVENTS },
	197320080 => { BS => $NO_EVENTS },
	197320134 => { BS => $NO_EVENTS },
	197320148 => { BS => $NO_EVENTS },
	197320165 => { BS => $NO_EVENTS },
	197320170 => { BS => $NO_EVENTS },
	197320174 => { BS => $NO_EVENTS },
	197320195 => { BS => $NO_EVENTS },
	197320245 => { BS => $NO_EVENTS },
	197320259 => { BS => $NO_EVENTS },
	197320266 => { BS => $NO_EVENTS },
	197320298 => { BS => $NO_EVENTS },
	197320322 => { BS => $NO_EVENTS },
	197320339 => { BS => $NO_EVENTS },
	197320351 => { BS => $NO_EVENTS },
	197320411 => { BS => $NO_EVENTS },
	197320478 => { BS => $NO_EVENTS },
	197320483 => { BS => $NO_EVENTS },
	197320490 => { BS => $NO_EVENTS },
	197320514 => { BS => $NO_EVENTS },
	197320520 => { BS => $NO_EVENTS },
	197320590 => { BS => $NO_EVENTS },
	197320593 => { BS => $NO_EVENTS },
	197320619 => { BS => $NO_EVENTS },
	197420040 => { BS => $NO_EVENTS },
	197420193 => { BS => $NO_EVENTS },
	197420205 => { BS => $NO_EVENTS },
	197420244 => { BS => $NO_EVENTS },
	197420283 => { BS => $NO_EVENTS },
	197420296 => { BS => $NO_EVENTS },
	197420314 => { BS => $NO_EVENTS },
	197420396 => { BS => $NO_EVENTS },
	197420421 => { BS => $NO_EVENTS },
	197420517 => { BS => $NO_EVENTS },
	197420522 => { BS => $NO_EVENTS },
	197420602 => { BS => $NO_EVENTS },
	197420641 => { BS => $NO_EVENTS },
	197520033 => { BS => $NO_EVENTS },
	197520051 => { BS => $NO_EVENTS },
	197520057 => { BS => $NO_EVENTS },
	197520110 => { BS => $NO_EVENTS },
	197520138 => { BS => $NO_EVENTS },
	197520181 => { BS => $NO_EVENTS },
	197520224 => { BS => $NO_EVENTS },
	197520233 => { BS => $NO_EVENTS },
	197520261 => { BS => $NO_EVENTS },
	197520263 => { BS => $NO_EVENTS },
	197520322 => { BS => $NO_EVENTS },
	197520329 => { BS => $NO_EVENTS },
	197520379 => { BS => $NO_EVENTS },
	197520382 => { BS => $NO_EVENTS },
	197520452 => { BS => $NO_EVENTS },
	197520492 => { BS => $NO_EVENTS },
	197520501 => { BS => $NO_EVENTS },
	197520568 => { BS => $NO_EVENTS },
	197520639 => { BS => $NO_EVENTS },
	197520671 => { BS => $NO_EVENTS },
	197520673 => { BS => $NO_EVENTS },
	197520680 => { BS => $NO_EVENTS },
	197520692 => { BS => $NO_EVENTS },
	197520718 => { BS => $NO_EVENTS },
	197530112 => { BS => $NO_EVENTS },
	197620008 => { BS => $NO_EVENTS },
	197620012 => { BS => $NO_EVENTS },
	197620071 => { BS => $NO_EVENTS },
	197620076 => { BS => $NO_EVENTS },
	197620154 => { BS => $NO_EVENTS },
	197620245 => { BS => $NO_EVENTS },
	197620378 => { BS => $NO_EVENTS },
	197620385 => { BS => $NO_EVENTS },
	197620511 => { BS => $NO_EVENTS },
	197620548 => { BS => $NO_EVENTS },
	197620564 => { BS => $NO_EVENTS },
	197620640 => { BS => $NO_EVENTS },
	197620707 => { BS => $NO_EVENTS },
	197720007 => { BS => $NO_EVENTS },
	197720070 => { BS => $NO_EVENTS },
	197720106 => { BS => $NO_EVENTS },
	197720132 => { BS => $NO_EVENTS },
	197720214 => { BS => $NO_EVENTS },
	197720276 => { BS => $NO_EVENTS },
	197720385 => { BS => $NO_EVENTS },
	197720418 => { BS => $NO_EVENTS },
	197720423 => { BS => $NO_EVENTS },
	197720469 => { BS => $NO_EVENTS },
	197720511 => { BS => $NO_EVENTS },
	197720582 => { BS => $NO_EVENTS },
	197730323 => { BS => $NO_EVENTS },
	197820012 => { BS => $NO_EVENTS },
	197820088 => { BS => $NO_EVENTS },
	197820114 => { BS => $NO_EVENTS },
	197820117 => { BS => $NO_EVENTS },
	197820296 => { BS => $NO_EVENTS },
	197820334 => { BS => $NO_EVENTS },
	197820344 => { BS => $NO_EVENTS },
	197820354 => { BS => $NO_EVENTS },
	197820486 => { BS => $NO_EVENTS },
	197820513 => { BS => $NO_EVENTS },
	197820544 => { BS => $NO_EVENTS },
	197820550 => { BS => $NO_EVENTS },
	197820577 => { BS => $NO_EVENTS },
	197830322 => { BS => $NO_EVENTS },
	197920152 => { BS => $NO_EVENTS },
	197920370 => { BS => $NO_EVENTS },
	197920374 => { BS => $NO_EVENTS },
	197920483 => { BS => $NO_EVENTS },
	197920492 => { BS => $NO_EVENTS },
	197920507 => { BS => $NO_EVENTS },
	197920593 => { BS => $NO_EVENTS },
	197920625 => { BS => $NO_EVENTS },
	197920630 => { BS => $NO_EVENTS },
	197920686 => { BS => $NO_EVENTS },
	197920711 => { BS => $NO_EVENTS },
	197920738 => { BS => $NO_EVENTS },
	197920744 => { BS => $NO_EVENTS },
	197920831 => { BS => $NO_EVENTS },
	197930162 => { BS => $NO_EVENTS },
	198020020 => { BS => $NO_EVENTS },
	198020042 => { BS => $NO_EVENTS },
	198020095 => { BS => $NO_EVENTS },
	198020174 => { BS => $NO_EVENTS },
	198020179 => { BS => $NO_EVENTS },
	198020202 => { BS => $NO_EVENTS },
	198020254 => { BS => $NO_EVENTS },
	198020273 => { BS => $NO_EVENTS },
	198020294 => { BS => $NO_EVENTS },
	198020417 => { BS => $NO_EVENTS },
	198020516 => { BS => $NO_EVENTS },
	198020518 => { BS => $NO_EVENTS },
	198020531 => { BS => $NO_EVENTS },
	198020598 => { BS => $NO_EVENTS },
	198020674 => { BS => $NO_EVENTS },
	198020719 => { BS => $NO_EVENTS },
	198020764 => { BS => $NO_EVENTS },
	198120013 => { BS => $NO_EVENTS },
	198120167 => { BS => $NO_EVENTS },
	198120221 => { BS => $NO_EVENTS },
	198120281 => { BS => $NO_EVENTS },
	198120339 => { BS => $NO_EVENTS },
	198120375 => { BS => $NO_EVENTS },
	198120399 => { BS => $NO_EVENTS },
	198120429 => { BS => $NO_EVENTS },
	198120526 => { BS => $NO_EVENTS },
	198120559 => { BS => $NO_EVENTS },
	198120608 => { BS => $NO_EVENTS },
	198120610 => { BS => $NO_EVENTS },
	198120693 => { BS => $NO_EVENTS },
	198120739 => { BS => $NO_EVENTS },
	198120742 => { BS => $NO_EVENTS },
	198220019 => { BS => $NO_EVENTS },
	198220145 => { BS => $NO_EVENTS },
	198220266 => { BS => $NO_EVENTS },
	198220290 => { BS => $NO_EVENTS },
	198220308 => { BS => $NO_EVENTS },
	198220333 => { BS => $NO_EVENTS },
	198220365 => { BS => $NO_EVENTS },
	198220464 => { BS => $NO_EVENTS },
	198220487 => { BS => $NO_EVENTS },
	198220517 => { BS => $NO_EVENTS },
	198220577 => { BS => $NO_EVENTS },
	198220641 => { BS => $NO_EVENTS },
	198220729 => { BS => $NO_EVENTS },
	198220831 => { BS => $NO_EVENTS },
	198220840 => { BS => $NO_EVENTS },
	198230123 => { BS => $NO_EVENTS },
	198230213 => { BS => $NO_EVENTS },
	198320019 => { BS => $NO_EVENTS },
	198320056 => { BS => $NO_EVENTS },
	198320066 => { BS => $NO_EVENTS },
	198320144 => { BS => $NO_EVENTS },
	198320198 => { BS => $NO_EVENTS },
	198320212 => { BS => $NO_EVENTS },
	198320215 => { BS => $NO_EVENTS },
	198320232 => { BS => $NO_EVENTS },
	198320285 => { BS => $NO_EVENTS },
	198320336 => { BS => $NO_EVENTS },
	198320386 => { BS => $NO_EVENTS },
	198320493 => { BS => $NO_EVENTS },
	198320517 => { BS => $NO_EVENTS },
	198320588 => { BS => $NO_EVENTS },
	198320607 => { BS => $NO_EVENTS },
	198320792 => { BS => $NO_EVENTS },
	198320797 => { BS => $NO_EVENTS },
	198330134 => { BS => $NO_EVENTS },
	198420035 => { BS => $NO_EVENTS },
	198420160 => { BS => $NO_EVENTS },
	198420196 => { BS => $NO_EVENTS },
	198420245 => { BS => $NO_EVENTS },
	198420307 => { BS => $NO_EVENTS },
	198420404 => { BS => $NO_EVENTS },
	198420415 => { BS => $NO_EVENTS },
	198420427 => { BS => $NO_EVENTS },
	198420608 => { BS => $NO_EVENTS },
	198420743 => { BS => $NO_EVENTS },
	198420761 => { BS => $NO_EVENTS },
	198430182 => { BS => $NO_EVENTS },
	198520175 => { BS => $NO_EVENTS },
	198520249 => { BS => $NO_EVENTS },
	198520255 => { BS => $NO_EVENTS },
	198520292 => { BS => $NO_EVENTS },
	198520367 => { BS => $NO_EVENTS },
	198520534 => { BS => $NO_EVENTS },
	198520558 => { BS => $NO_EVENTS },
	198520574 => { BS => $NO_EVENTS },
	198520575 => { BS => $NO_EVENTS },
	198520592 => { BS => $NO_EVENTS },
	198520603 => { BS => $NO_EVENTS },
	198520626 => { BS => $NO_EVENTS },
	198520649 => { BS => $NO_EVENTS },
	198520654 => { BS => $NO_EVENTS },
	198520680 => { BS => $NO_EVENTS },
	198520719 => { BS => $NO_EVENTS },
	198520778 => { BS => $NO_EVENTS },
	198520834 => { BS => $NO_EVENTS },
	198520835 => { BS => $NO_EVENTS },
	198530131 => { BS => $NO_EVENTS },
	198620039 => { BS => $NO_EVENTS },
	198620050 => { BS => $NO_EVENTS },
	198620082 => { BS => $NO_EVENTS },
	198620125 => { BS => $NO_EVENTS },
	198620127 => { BS => $NO_EVENTS },
	198620145 => { BS => $NO_EVENTS },
	198620154 => { BS => $NO_EVENTS },
	198620163 => { BS => $NO_EVENTS },
	198620247 => { BS => $NO_EVENTS },
	198620264 => { BS => $NO_EVENTS },
	198620280 => { BS => $NO_EVENTS },
	198620387 => { BS => $NO_EVENTS },
	198620402 => { BS => $NO_EVENTS },
	198620444 => { BS => $NO_EVENTS },
	198620481 => { BS => $NO_EVENTS },
	198620542 => { BS => $NO_EVENTS },
	198620547 => { BS => $NO_EVENTS },
	198620561 => { BS => $NO_EVENTS },
	198620568 => { BS => $NO_EVENTS },
	198620577 => { BS => $NO_EVENTS },
	198620743 => { BS => $NO_EVENTS },
	198630152 => { BS => $NO_EVENTS },
	198630223 => { BS => $NO_EVENTS },
	198630411 => { BS => $NO_EVENTS },
	198720020 => { BS => $NO_EVENTS },
	198720054 => { BS => $NO_EVENTS },
	198720089 => { BS => $NO_EVENTS },
	198720137 => { BS => $NO_EVENTS },
	198720184 => { BS => $NO_EVENTS },
	198720221 => { BS => $NO_EVENTS },
	198720264 => { BS => $NO_EVENTS },
	198720271 => { BS => $NO_EVENTS },
	198720326 => { BS => $NO_EVENTS },
	198720360 => { BS => $NO_EVENTS },
	198720379 => { BS => $NO_EVENTS },
	198720399 => { BS => $NO_EVENTS },
	198720508 => { BS => $NO_EVENTS },
	198720550 => { BS => $NO_EVENTS },
	198720589 => { BS => $NO_EVENTS },
	198720590 => { BS => $NO_EVENTS },
	198720608 => { BS => $NO_EVENTS },
	198720636 => { BS => $NO_EVENTS },
	198720659 => { BS => $NO_EVENTS },
	198720690 => { BS => $NO_EVENTS },
	198720711 => { BS => $NO_EVENTS },
	198720720 => { BS => $NO_EVENTS },
	198720722 => { BS => $NO_EVENTS },
	198720730 => { BS => $NO_EVENTS },
	198720793 => { BS => $NO_EVENTS },
	198730121 => { BS => $NO_EVENTS },
	198730244 => { BS => $NO_EVENTS },
	198730314 => { BS => $NO_EVENTS },
	198730413 => { BS => $NO_EVENTS },
	198820001 => { BS => $NO_EVENTS },
	198820049 => { BS => $NO_EVENTS },
	198820061 => { BS => $NO_EVENTS },
	198820106 => { BS => $NO_EVENTS },
	198820109 => { BS => $NO_EVENTS },
	198820205 => { BS => $NO_EVENTS },
	198820209 => { BS => $NO_EVENTS },
	198820247 => { BS => $NO_EVENTS },
	198820254 => { BS => $NO_EVENTS },
	198820301 => { BS => $NO_EVENTS },
	198820353 => { BS => $NO_EVENTS },
	198820467 => { BS => $NO_EVENTS },
	198820543 => { BS => $NO_EVENTS },
	198820637 => { BS => $NO_EVENTS },
	198820690 => { BS => $NO_EVENTS },
	198820742 => { BS => $NO_EVENTS },
	198820781 => { BS => $NO_EVENTS },
	198830215 => { BS => $NO_EVENTS },
	198920042 => { BS => $NO_EVENTS },
	198920072 => { BS => $NO_EVENTS },
	198920110 => { BS => $NO_EVENTS },
	198920187 => { BS => $NO_EVENTS },
	198920271 => { BS => $NO_EVENTS },
	198920347 => { BS => $NO_EVENTS },
	198920435 => { BS => $NO_EVENTS },
	198920506 => { BS => $NO_EVENTS },
	198920508 => { BS => $NO_EVENTS },
	198920520 => { BS => $NO_EVENTS },
	198920567 => { BS => $NO_EVENTS },
	198920608 => { BS => $NO_EVENTS },
	198920665 => { BS => $NO_EVENTS },
	198920689 => { BS => $NO_EVENTS },
	198920707 => { BS => $NO_EVENTS },
	198920731 => { BS => $NO_EVENTS },
	198920778 => { BS => $NO_EVENTS },
	198920801 => { BS => $NO_EVENTS },
	198930121 => { BS => $NO_EVENTS },
	198930174 => { BS => $NO_EVENTS },
	199020019 => { BS => $NO_EVENTS },
	199020031 => { BS => $NO_EVENTS },
	199020061 => { BS => $NO_EVENTS },
	199020074 => { BS => $NO_EVENTS },
	199020225 => { BS => $NO_EVENTS },
	199020304 => { BS => $NO_EVENTS },
	199020355 => { BS => $NO_EVENTS },
	199020398 => { BS => $NO_EVENTS },
	199020408 => { BS => $NO_EVENTS },
	199020413 => { BS => $NO_EVENTS },
	199020456 => { BS => $NO_EVENTS },
	199020549 => { BS => $NO_EVENTS },
	199020555 => { BS => $NO_EVENTS },
	199020615 => { BS => $NO_EVENTS },
	199020621 => { BS => $NO_EVENTS },
	199020623 => { BS => $NO_EVENTS },
	199020762 => { BS => $NO_EVENTS },
	199020813 => { BS => $NO_EVENTS },
	199030136 => { BS => $NO_EVENTS },
	199030172 => { BS => $NO_EVENTS },
	199030187 => { BS => $NO_EVENTS },
	199030413 => { BS => $NO_EVENTS },
	199120040 => { BS => $NO_EVENTS },
	199120053 => { BS => $NO_EVENTS },
	199120167 => { BS => $NO_EVENTS },
	199120228 => { BS => $NO_EVENTS },
	199120321 => { BS => $NO_EVENTS },
	199120416 => { BS => $NO_EVENTS },
	199120437 => { BS => $NO_EVENTS },
	199120444 => { BS => $NO_EVENTS },
	199120492 => { BS => $NO_EVENTS },
	199120499 => { BS => $NO_EVENTS },
	199120593 => { BS => $NO_EVENTS },
	199120627 => { BS => $NO_EVENTS },
	199120667 => { BS => $NO_EVENTS },
	199120708 => { BS => $NO_EVENTS },
	199120716 => { BS => $NO_EVENTS },
	199120759 => { BS => $NO_EVENTS },
	199120830 => { BS => $NO_EVENTS },
	199120850 => { BS => $NO_EVENTS },
	199130142 => { BS => $NO_EVENTS },
	199130246 => { BS => $NO_EVENTS },
	199220004 => { BS => $NO_EVENTS },
	199220082 => { BS => $NO_EVENTS },
	199220089 => { BS => $NO_EVENTS },
	199220125 => { BS => $NO_EVENTS },
	199220149 => { BS => $NO_EVENTS },
	199220206 => { BS => $NO_EVENTS },
	199220207 => { BS => $NO_EVENTS },
	199220213 => { BS => $NO_EVENTS },
	199220242 => { BS => $NO_EVENTS },
	199220362 => { BS => $NO_EVENTS },
	199220366 => { BS => $NO_EVENTS },
	199220412 => { BS => $NO_EVENTS },
	199220421 => { BS => $NO_EVENTS },
	199220475 => { BS => $NO_EVENTS },
	199220493 => { BS => $NO_EVENTS },
	199220511 => { BS => $NO_EVENTS },
	199220512 => { BS => $NO_EVENTS },
	199220516 => { BS => $NO_EVENTS },
	199220525 => { BS => $NO_EVENTS },
	199220611 => { BS => $NO_EVENTS },
	199220646 => { BS => $NO_EVENTS },
	199220656 => { BS => $NO_EVENTS },
	199220689 => { BS => $NO_EVENTS },
	199220722 => { BS => $NO_EVENTS },
	199220739 => { BS => $NO_EVENTS },
	199220798 => { BS => $NO_EVENTS },
	199220805 => { BS => $NO_EVENTS },
	199220823 => { BS => $NO_EVENTS },
	199220851 => { BS => $NO_EVENTS },
	199220920 => { BS => $NO_EVENTS },
	199220940 => { BS => $NO_EVENTS },
	199220963 => { BS => $NO_EVENTS },
	199220971 => { BS => $NO_EVENTS },
	199230125 => { BS => $NO_EVENTS },
	199230163 => { BS => $NO_EVENTS },
	199230182 => { BS => $NO_EVENTS },
	199230413 => { BS => $NO_EVENTS },
	199320155 => { BS => $NO_EVENTS },
	199320213 => { BS => $NO_EVENTS },
	199320223 => { BS => $NO_EVENTS },
	199320255 => { BS => $NO_EVENTS },
	199320278 => { BS => $NO_EVENTS },
	199320294 => { BS => $NO_EVENTS },
	199320317 => { BS => $NO_EVENTS },
	199320337 => { BS => $NO_EVENTS },
	199320383 => { BS => $NO_EVENTS },
	199320418 => { BS => $NO_EVENTS },
	199320434 => { BS => $NO_EVENTS },
	199320526 => { BS => $NO_EVENTS },
	199320538 => { BS => $NO_EVENTS },
	199320598 => { BS => $NO_EVENTS },
	199320599 => { BS => $NO_EVENTS },
	199320607 => { BS => $NO_EVENTS },
	199320646 => { BS => $NO_EVENTS },
	199320658 => { BS => $NO_EVENTS },
	199320680 => { BS => $NO_EVENTS },
	199320721 => { BS => $NO_EVENTS },
	199320740 => { BS => $NO_EVENTS },
	199320801 => { BS => $NO_EVENTS },
	199320806 => { BS => $NO_EVENTS },
	199320839 => { BS => $NO_EVENTS },
	199320949 => { BS => $NO_EVENTS },
	199320968 => { BS => $NO_EVENTS },
	199321001 => { BS => $NO_EVENTS },
	199321013 => { BS => $NO_EVENTS },
	199321034 => { BS => $NO_EVENTS },
	199321057 => { BS => $NO_EVENTS },
	199321081 => { BS => $NO_EVENTS },
	199330147 => { BS => $NO_EVENTS },
	199330151 => { BS => $NO_EVENTS },
	199330181 => { BS => $NO_EVENTS },
	199330231 => { BS => $NO_EVENTS },
	199420005 => { BS => $NO_EVENTS },
	199420043 => { BS => $NO_EVENTS },
	199420125 => { BS => $NO_EVENTS },
	199420127 => { BS => $NO_EVENTS },
	199420186 => { BS => $NO_EVENTS },
	199420189 => { BS => $NO_EVENTS },
	199420199 => { BS => $NO_EVENTS },
	199420208 => { BS => $NO_EVENTS },
	199420217 => { BS => $NO_EVENTS },
	199420288 => { BS => $NO_EVENTS },
	199420353 => { BS => $NO_EVENTS },
	199420510 => { BS => $NO_EVENTS },
	199420571 => { BS => $NO_EVENTS },
	199430211 => { BS => $NO_EVENTS },
	199430231 => { BS => $NO_EVENTS },
	199520006 => { BS => $NO_EVENTS },
	199520015 => { BS => $NO_EVENTS },
	199520060 => { BS => $NO_EVENTS },
	199520135 => { BS => $NO_EVENTS },
	199520136 => { BS => $NO_EVENTS },
	199520207 => { BS => $NO_EVENTS },
	199520298 => { BS => $NO_EVENTS },
	199520318 => { BS => $NO_EVENTS },
	199520385 => { BS => $NO_EVENTS },
	199520400 => { BS => $NO_EVENTS },
	199520406 => { BS => $NO_EVENTS },
	199520494 => { BS => $NO_EVENTS },
	199520639 => { BS => $NO_EVENTS },
	199520688 => { BS => $NO_EVENTS },
	199520700 => { BS => $NO_EVENTS },
	199520720 => { BS => $NO_EVENTS },
	199520767 => { BS => $NO_EVENTS },
	199520790 => { BS => $NO_EVENTS },
	199520808 => { BS => $NO_EVENTS },
	199520846 => { BS => $NO_EVENTS },
	199520856 => { BS => $NO_EVENTS },
	199520879 => { BS => $NO_EVENTS },
	199520973 => { BS => $NO_EVENTS },
	199530114 => { BS => $NO_EVENTS },
	199530182 => { BS => $NO_EVENTS },
	199620002 => { BS => $NO_EVENTS },
	199620011 => { BS => $NO_EVENTS },
	199620044 => { BS => $NO_EVENTS },
	199620065 => { BS => $NO_EVENTS },
	199620148 => { BS => $NO_EVENTS },
	199620155 => { BS => $NO_EVENTS },
	199620184 => { BS => $NO_EVENTS },
	199620192 => { BS => $NO_EVENTS },
	199620261 => { BS => $NO_EVENTS },
	199620352 => { BS => $NO_EVENTS },
	199620528 => { BS => $NO_EVENTS },
	199620649 => { BS => $NO_EVENTS },
	199620718 => { BS => $NO_EVENTS },
	199620749 => { BS => $NO_EVENTS },
	199620756 => { BS => $NO_EVENTS },
	199620757 => { BS => $NO_EVENTS },
	199620769 => { BS => $NO_EVENTS },
	199620875 => { BS => $NO_EVENTS },
	199620947 => { BS => $NO_EVENTS },
	199621018 => { BS => $NO_EVENTS },
	199621027 => { BS => $NO_EVENTS },
	199621039 => { BS => $NO_EVENTS },
	199621048 => { BS => $NO_EVENTS },
	199621058 => { BS => $NO_EVENTS },
	199630153 => { BS => $NO_EVENTS },
	199630182 => { BS => $NO_EVENTS },
	199630233 => { BS => $NO_EVENTS },
	199720005 => { BS => $NO_EVENTS },
	199720011 => { BS => $NO_EVENTS },
	199720058 => { BS => $NO_EVENTS },
	199720066 => { BS => $NO_EVENTS },
	199720087 => { BS => $NO_EVENTS },
	199720173 => { BS => $NO_EVENTS },
	199720358 => { BS => $NO_EVENTS },
	199720379 => { BS => $NO_EVENTS },
	199720384 => { BS => $NO_EVENTS },
	199720462 => { BS => $NO_EVENTS },
	199720508 => { BS => $NO_EVENTS },
	199720514 => { BS => $NO_EVENTS },
	199720665 => { BS => $NO_EVENTS },
	199720684 => { BS => $NO_EVENTS },
	199720698 => { BS => $NO_EVENTS },
	199720707 => { BS => $NO_EVENTS },
	199720710 => { BS => $NO_EVENTS },
	199720728 => { BS => $NO_EVENTS },
	199720878 => { BS => $NO_EVENTS },
	199720885 => { BS => $NO_EVENTS },
	199720946 => { BS => $NO_EVENTS },
	199720947 => { BS => $NO_EVENTS },
	199820068 => { BS => $NO_EVENTS },
	199820080 => { BS => $NO_EVENTS },
	199820123 => { BS => $NO_EVENTS },
	199820137 => { BS => $NO_EVENTS },
	199820177 => { BS => $NO_EVENTS },
	199820227 => { BS => $NO_EVENTS },
	199820237 => { BS => $NO_EVENTS },
	199820277 => { BS => $NO_EVENTS },
	199820283 => { BS => $NO_EVENTS },
	199820296 => { BS => $NO_EVENTS },
	199820298 => { BS => $NO_EVENTS },
	199820476 => { BS => $NO_EVENTS },
	199820542 => { BS => $NO_EVENTS },
	199820692 => { BS => $NO_EVENTS },
	199820760 => { BS => $NO_EVENTS },
	199820905 => { BS => $NO_EVENTS },
	199821013 => { BS => $NO_EVENTS },
	199821028 => { BS => $NO_EVENTS },
	199821031 => { BS => $NO_EVENTS },
	199821054 => { BS => $NO_EVENTS },
	199821066 => { BS => $NO_EVENTS },
	199830121 => { BS => $NO_EVENTS },
	199830146 => { BS => $NO_EVENTS },
	199920016 => { BS => $NO_EVENTS },
	199920029 => { ES => $REPLICA, GS => $REPLICA },
	199920045 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920050 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920058 => { ES => $REPLICA, GS => $REPLICA },
	199920071 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920072 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920081 => { BS => $NO_EVENTS, ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920109 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920130 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920323 => { BS => $NO_EVENTS, ES => $REPLICA, GS => $REPLICA },
	199920619 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920689 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199920690 => { ES => $BROKEN, GS => $INCOMPLETE },
	199920836 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	199921034 => { BH => $INCOMPLETE, ES => $INCOMPLETE, GS => $INCOMPLETE },
	199930325 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020029 => { ES => $REPLICA, GS => $REPLICA },
	200020038 => { ES => $REPLICA, GS => $REPLICA },
	200020039 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020041 => { ES => $REPLICA, GS => $REPLICA },
	200020042 => { ES => $REPLICA, GS => $REPLICA },
	200020043 => { ES => $REPLICA, GS => $REPLICA },
	200020044 => { BS => $NO_EVENTS, ES => $REPLICA, GS => $REPLICA },
	200020045 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020049 => { ES => $REPLICA, GS => $REPLICA },
	200020067 => { ES => $REPLICA, GS => $REPLICA },
	200020072 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020073 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020077 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020080 => { ES => $REPLICA, GS => $REPLICA },
	200020081 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020083 => { ES => $REPLICA, GS => $REPLICA },
	200020085 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020095 => { ES => $REPLICA, GS => $REPLICA },
	200020096 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020102 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020112 => { ES => $REPLICA, GS => $REPLICA },
	200020186 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020187 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020189 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020920 => { ES => $REPLICA, GS => $REPLICA },
	200020916 => { PL => $INCOMPLETE },
	200020921 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020924 => { ES => $REPLICA, GS => $REPLICA },
	200020925 => { ES => $REPLICA, GS => $REPLICA },
	200020926 => { ES => $REPLICA, GS => $REPLICA },
	200020928 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020964 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200020983 => { ES => $BROKEN },
	200021165 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200021166 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200021167 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200021171 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200220916 => { PL => $INCOMPLETE },
	200320191 => { GS => $INCOMPLETE },
	200321205 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $INCOMPLETE },
	200330134 => { PL => $BROKEN },
	200520298 => { ES => $REPLICA },
	200520458 => { ES => $BROKEN },
	200520677 => { RO => $BROKEN },
	200520679 => { RO => $BROKEN },
	200520681 => { RO => $BROKEN },
	200621024 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, },
	200621024 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, },
	200720470 => { GS => $INCOMPLETE, },
	200720483 => { GS => $INCOMPLETE, },
	200721178 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, RO => $INCOMPLETE },
	200820259 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, RO => $INCOMPLETE },
	200820409 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, RO => $INCOMPLETE },
	200821077 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, RO => $INCOMPLETE },
	200920081 => { ES => $INCOMPLETE, GS => $INCOMPLETE, PL => $BROKEN, RO => $INCOMPLETE },
	200920827 => { GS => $INCOMPLETE },
	200920836 => { GS => $INCOMPLETE },
	200920857 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200920863 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	200920874 => { ES => $INCOMPLETE, GS => $INCOMPLETE, RO => $INCOMPLETE },
	200920885 => { ES => $INCOMPLETE, RO => $INCOMPLETE },
	201020429 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	201120259 => { ES => $INCOMPLETE, GS => $INCOMPLETE },
	201320971 => { GS => $BROKEN },
	201520079 => {BH => $INCOMPLETE},
	201520120 => {BH => $INCOMPLETE},
	201520168 => {BH => $INCOMPLETE},
	201520214 => {BH => $INCOMPLETE},
	201520307 => {BH => $INCOMPLETE},
#	201720620 => {PL => $INCOMPLETE, RO => $INCOMPLETE, ES => $INCOMPLETE},
);

our %MANUAL_FIX = (
	200120123 => { GS => 'Remove "2" throughout the file' },
	200520094 => {
		GS => 'Insert missing period for 15:35 penalty',
		PL => 'Edited string with 00:28 penalty',
	},
	200520305 => { GS => 'Insert missing period for 5:13 penalty' },
	200520233 => { GS => 'Add missing TBODY closing tag' },
	200520264 => { GS => 'Fixed bogus on ice' },
	200620071 => { PL => 'Aligned period for event #1' },
	200620892 => { GS => 'Add missing TBODY closing tag' },
	201320331 => { PL => 'Remove invalid tag at the 7:50 event' },
	201720463 => { PL => 'Fixed time -16:0-1' },
);
our %BROKEN_HEADERS = (
	200720295 => {
		location => 'Scottrade Center',
	},
);

our %SPECIAL_EVENTS = (
	200520312 => { 0  => 1 },
	201320971 => { 0  => 1 },
);

our %MISSING_EVENTS = (
	198930176 => [
		{
			type => 'GOAL',
			period => 5,
			time => '03:14',
			team1 => 'LAK',
			assist1 => 8446494,
			player1 => 8448566,
			strength => 'EV',
			shot_type => 'Unknown',
			distance => 999,
			location => 'Off',
		},
	],
	199020456 => [
		{
			type => 'PENL',
			period => 4,
			time => '03:41',
			player1 => 8448449,
			team1 => 'BUF',
			length => 2,
			penalty => 'Holding',
			strength => 'EV',
			location => 'Unk',
		},
	],
	199030242 => [
		{
			type => 'GOAL',
			period => 5,
			time => '04:48',
			team1 => 'EDM',
			player1 => 8448490,
			assist1 => 8451905,
			assist2 => 8449020,
			shot_type => 'Unknown',
			distance => 999,
			location => 'Off',
			strength => 'EV',
		},
	],
	199030243 => [
		{
			type => 'GOAL',
			period => 5,
			time => '00:48',
			team1 => 'EDM',
			player1 => 8451905,
			assist1 => 8448490,
			assist2 => 8448641,
			shot_type => 'Unknown',
			distance => 999,
			location => 'Off',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 5,
			time => '00:48',
			player1 => 8450941,
			team1 => 'LAK',
			length => 10,
			penalty => 'Misconduct',
			misconduct => 1,
			strength => 'EV',
			location => 'Unk',
		},
	],
	199130002 => [
		{
			type => 'PENL',
			period => 5,
			time => '00:48',
			player1 => 8450941,
			team1 => 'LAK',
			length => 10,
			penalty => 'Misconduct',
			misconduct => 1,
			strength => 'EV',
			location => 'Unk',
		},
	],
	199130117 => [
		{
			type => 'GOAL',
			time => '05:26',
			period => 5,
			team1 => 'MTL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8446208,
			assist1 => 8446167,
			assist2 => 8446415,
		},
	],
	199130163 => [
		{
			type => 'GOAL',
			time => '03:33',
			period => 5,
			team1 => 'STL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8448091,
			assist1 => 8445281,
			assist2 => 8451793,
		},
	],
	199230142 => [
		{
			type => 'GOAL',
			time => '14:50',
			period => 5,
			team1 => 'NYI',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8449742,
			assist1 => 8446823,
			assist2 => 8446838,
		},
	],
	199230144 => [
		{
			type => 'GOAL',
			time => '05:40',
			period => 5,
			team1 => 'NYI',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8446823,
			assist1 => 8448870,
			assist2 => 8446830,
		},
	],
	199230231 => [
		{
			type => 'GOAL',
			time => '03:16',
			period => 5,
			team1 => 'TOR',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8447206,
			assist1 => 8447187,
			assist2 => 8449009,
		},
	],
	199230232 => [
		{
			type => 'GOAL',
			time => '03:03',
			period => 5,
			team1 => 'STL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8445700,
			assist1 => 8446675,
			assist2 => 8448222,
		},
	],
	199230245 => [
		{
			type => 'GOAL',
			time => '06:31',
			period => 5,
			team1 => 'LAK',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8458020,
			assist1 => 8450941,
			assist2 => 8448569,
		},
	],
	199230312 => [
		{
			type => 'GOAL',
			time => '06:21',
			period => 5,
			team1 => 'MTL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8448719,
			assist1 => 8446303,
			assist2 => 8445739,
		},
	],
	199330136 => [
		{
			type => 'GOAL',
			time => '05:43',
			period => 7,
			team1 => 'BUF',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8447515,
			assist1 => 8458549,
			assist2 => 8450523,
		},
		{
			type => 'PENL',
			period => 6,
			time => '00:00',
			player1 => 8450678,
			team1 => 'BUF',
			length => 10,
			penalty => 'Misconduct',
			misconduct => 1,
			strength => 'EV',
			location => 'Unk',
		},
		{
			type => 'PENL',
			period => 6,
			time => '12:10',
			player1 => $BENCH_PLAYER_ID,
			team1 => 'NJD',
			length => 2,
			penalty => 'Too many men/ice',
			strength => 'EV',
			location => 'Unk',
			servedby => 8450825,
		},
	],
	199330167 => [
		{
			type => 'GOAL',
			time => '02:20',
			period => 5,
			team1 => 'VAN',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8455738,
			assist1 => 8445700,
			assist2 => 8445208,
		},
	],
	199330311 => [
		{
			type => 'GOAL',
			time => '15:23',
			period => 5,
			team1 => 'NJD',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8450825,
			assist1 => 8445977,
		},
		{
			type => 'PENL',
			period => 5,
			time => '04:14',
			player1 => 8451905,
			team1 => 'NYR',
			length => 2,
			penalty => 'Unsportsmanlike conduct',
			strength => 'EV',
			location => 'Unk',
		},
		{
			type => 'PENL',
			period => 5,
			time => '04:14',
			player1 => 8445461,
			team1 => 'NYR',
			length => 2,
			penalty => 'Roughing',
			location => 'Unk',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 5,
			time => '04:14',
			player1 => 8448772,
			team1 => 'NJD',
			length => 2,
			penalty => 'Unsportsmanlike conduct',
			location => 'Unk',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 5,
			time => '04:14',
			player1 => 8450825,
			team1 => 'NJD',
			length => 2,
			penalty => 'Roughing',
			location => 'Unk',
			strength => 'EV',
		},
	],
	199330313 => [
		{
			type => 'GOAL',
			time => '06:13',
			period => 5,
			team1 => 'NYR',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8449295,
		},
	],
	199330317 => [
		{
			type => 'GOAL',
			time => '04:24',
			period => 5,
			team1 => 'NYR',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8449295,
			assist1 => 8451905,
		},
	],
	199330325 => [
		{
			type => 'GOAL',
			time => '00:14',
			period => 5,
			team1 => 'VAN',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8444894,
			assist1 => 8445208,
			assist2 => 8448825,
		},
	],
	199430167 => [
		{
			type => 'GOAL',
			time => '01:54',
			period => 5,
			team1 => 'SJS',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8458537,
			assist1 => 8448669,
			assist2 => 8449163,
		},
	],
	199430323 => [
		{
			type => 'GOAL',
			time => '09:25',
			period => 5,
			team1 => 'DET',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8456870,
			assist1 => 8446789,
		},
	],
	199430325 => [
		{
			type => 'GOAL',
			time => '02:25',
			period => 5,
			team1 => 'DET',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8456887,
			assist1 => 8446788,
			assist2 => 8445730,
		},
	],
	199530124 => [
		{
			type => 'GOAL',
			time => '19:15',
			period => 7,
			team1 => 'PIT',
			strength => 'PP',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8449807,
			assist1 => 8458494,
			assist2 => 8448208,
		},
		{
			type => 'PENL',
			period => 5,
			time => '04:33',
			player1 => 8458179,
			team1 => 'PIT',
			length => 2,
			penalty => 'Roughing',
			location => 'Unk',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 5,
			time => '04:33',
			player1 => 8445575,
			team1 => 'WSH',
			length => 2,
			penalty => 'Roughing',
			location => 'Unk',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 6,
			time => '03:24',
			player1 => 8448380,
			team1 => 'PIT',
			length => 2,
			penalty => 'Slashing',
			location => 'Unk',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 6,
			time => '04:36',
			player1 => 8446181,
			team1 => 'WSH',
			length => 2,
			location => 'Unk',
			penalty => 'Tripping - Obstruction',
			strength => 'PP',
		},
		{
			type => 'PENL',
			period => 6,
			time => '19:17',
			player1 => 8456150,
			team1 => 'PIT',
			length => 2,
			penalty => 'Slashing',
			location => 'Unk',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 7,
			time => '17:21',
			player1 => 8448303,
			team1 => 'WSH',
			length => 2,
			penalty => 'Hooking',
			location => 'Unk',
			strength => 'EV',
		},
	],
	199530174 => [
		{
			type => 'GOAL',
			time => '10:02',
			period => 6,
			team1 => 'CHI',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8449751,
			assist1 => 8446217,
		},
	],
	199530215 => [
		{
			type => 'GOAL',
			time => '08:05',
			period => 5,
			team1 => 'FLA',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8447985,
			assist1 => 8451427,
			assist2 => 8448092,
		},
	],
	199530237 => [
		{
			type => 'GOAL',
			time => '01:15',
			period => 5,
			team1 => 'DET',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8452578,
			assist1 => 8456870,
		},
	],
	199530244 => [
		{
			type => 'GOAL',
			time => '04:33',
			period => 6,
			team1 => 'COL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8451101,
			assist1 => 8447363,
			assist2 => 8450817,
		},
		{
			type => 'PENL',
			period => 5,
			time => '19:38',
			player1 => 8448772,
			location => 'Unk',
			team1 => 'COL',
			length => 2,
			penalty => 'Roughing',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 5,
			time => '19:38',
			player1 => 8450561,
			location => 'Unk',
			team1 => 'CHI',
			length => 2,
			penalty => 'Cross checking',
			strength => 'PP',
		},
	],
	199530246 => [
		{
			type => 'GOAL',
			time => '05:18',
			period => 5,
			team1 => 'COL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8458544,
			assist1 => 8456770,
			assist2 => 8451101,
		},
	],
	199530414 => [
		{
			type => 'GOAL',
			time => '04:31',
			period => 6,
			team1 => 'COL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8448554,
		},
		{
			type => 'PENL',
			period => 5,
			time => '09:57',
			player1 => 8448772,
			team1 => 'COL',
			location => 'Unk',
			length => 2,
			penalty => 'Roughing',
			strength => 'EV',
		},
		{
			type => 'PENL',
			period => 5,
			time => '09:57',
			player1 => 8451427,
			team1 => 'FLA',
			length => 2,
			location => 'Unk',
			penalty => 'Slashing',
			strength => 'EV',
		},
	],
	199630114 => [
		{
			type => 'GOAL',
			time => '07:37',
			period => 6,
			team1 => 'MTL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8445739,
			assist1 => 8459442,
			assist2 => 8445734,
		},
	],
	199630153 => [
		{
			type => 'GOAL',
			time => '11:03',
			period => 5,
			team1 => 'CHI',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8458949,
			assist1 => 8446295,
		},
		{
			type => 'PENL',
			location => 'Unk',
			period => 5,
			time => '06:09',
			player1 => 8452353,
			team1 => 'CHI',
			length => 2,
			penalty => 'Holding',
			strength => 'EV',
		},
		{
			type => 'PENL',
			location => 'Unk',
			period => 5,
			time => '06:09',
			player1 => 8450561,
			team1 => 'CHI',
			length => 10,
			penalty => 'Misconduct',
			misconduct => 1,
			strength => 'EV',
		},
	],
	199630165 => [
		{
			type => 'GOAL',
			time => '00:22',
			period => 5,
			team1 => 'EDM',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8460496,
			assist1 => 8459429,
			assist2 => 8458963,
		},
	],
	199630242 => [
		{
			type => 'GOAL',
			time => '01:31',
			period => 6,
			team1 => 'DET',
			strength => 'PP',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8456887,
			assist1 => 8456870,
			assist2 => 8446789,
		},
		{
			type => 'PENL',
			period => 6,
			time => '01:03',
			player1 => 8446286,
			location => 'Unk',
			team1 => 'ANA',
			length => 2,
			penalty => 'Hooking',
			strength => 'EV',
		},
	],
	199630244 => [
		{
			type => 'GOAL',
			time => '17:03',
			period => 5,
			team1 => 'DET',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8451302,
			assist1 => 8458524,
			assist2 => 8452578,
		},
		{
			type => 'PENL',
			period => 5,
			time => '10:52',
			player1 => 8446789,
			location => 'Unk',
			team1 => 'DET',
			length => 2,
			penalty => 'Hi-sticking',
			strength => 'EV',
		},
	],
	199720894 => [
		{
			id => 999,
			type => 'GOAL',
			period => 4,
			time => '04:39',
			location => 'Off',
			team1 => 'PHI',
			shot_type => 'Unknown',
			strength => 'EV',
			player1 => 8457704,
			assist1 => 8456849,
			assist2 => 8459458,
		},
	],
	199730142 => [
		{
			type => 'GOAL',
			time => '00:54',
			period => 5,
			team1 => 'BOS',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8459249,
			assist1 => 8459439,
			assist2 => 8448484,
		},
	],
	199730143 => [
		{
			type => 'GOAL',
			time => '06:31',
			period => 5,
			team1 => 'WSH',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8456760,
			assist1 => 8449951,
			assist2 => 8445417,
		},
	],
	199730223 => [
		{
			type => 'GOAL',
			time => '01:24',
			period => 5,
			team1 => 'BUF',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8458976,
			assist1 => 8458347,
			assist2 => 8460579,
		},
	],
	199730243 => [
		{
			type => 'GOAL',
			time => '11:12',
			period => 5,
			team1 => 'DET',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8451302,
			assist1 => 8448669,
			assist2 => 8457063,
		},
	],
	199830122 => [
		{
			type => 'GOAL',
			time => '10:35',
			period => 5,
			team1 => 'BUF',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8459534,
			assist1 => 8458454,
			assist2 => 8456760,
		},
	],
	199830135 => [
		{
			type => 'GOAL',
			time => '14:45',
			period => 5,
			team1 => 'BOS',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8459156,
			assist1 => 8466138,
			assist2 => 8445621,
		},
	],
	199830154 => [
		{
			type => 'GOAL',
			time => '17:34',
			period => 6,
			team1 => 'DAL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8449893,
			assist1 => 8458494,
			assist2 => 8445423,
		},
		{
			type => 'PENL',
			period => 6,
			time => '07:46',
			player1 => 8459640,
			team1 => 'EDM',
			location => 'Unk',
			length => 2,
			penalty => 'Boarding',
			strength => 'EV',
		},
	],
	199830416 => [
		{
			type => 'GOAL',
			time => '14:51',
			period => 6,
			team1 => 'DAL',
			strength => 'EV',
			location => 'Off',
			shot_type => 'Unknown',
			distance => 999,
			player1 => 8448091,
			assist1 => 8459024,
			assist2 => 8449645,
		},
	],
	200210427 => [
		{
			'period' => 3,
			'team' => 'PHI',
			'str' => 'EV',
			'player2' => 8465200,
			'penalty' => 'Game Misconduct',
			'length' => '10',
			'id' => 143,
			'location' => 'Unk',
			'type' => 'PENL',
			'description' => '97 ROENICK, Charging (maj), 5 min, Served By 29 FEDORUK',
			'old' => 1,
			'team2' => 'TOR',
			'team1' => 'PHI',
			'time' => '07:33',
			'player1' => 8459078,
			servedby => 8462292,
			misconduct => 1,
		},
	],
);

our %MISSING_COACHES = (
	198720094 => [
		'Terry Simpson',
		'John Brophy',
	],
	198720190 => [
		"Terry O'Reilly",
		'Dan Maloney',
	],
	198820044 => [
		"Terry O'Reilly",
		'Pierre Page',
	],
	198820695 => [
		'George Armstrong',
		'Larry Pleau',
	],
	199220021 => [
		'John Muckler',
		'Paul Holmgren',
	],
	200220148 => [
		'Andy Murray',
		'Brian Sutter',
	],
	200320732 => [
		'Peter Laviolette',
		'Bob Hartley',
	],
);

our %MISSING_PLAYERS = (
	192330311 => [
		[
			{
				_id       => 8400001,
				position  => 'G',
				decision  => 'L',
				timeOnIce => '60:00',
				name      => 'CHARLIE REID',
				number    => 1,
				pim       => 0,
				goals     => 0,
				assists   => 0,
			},
		],
		[],
	],
	192330312 => [
		[
			{
				_id       => 8400001,
				position  => 'G',
				decision  => 'L',
				timeOnIce => '60:00',
				name      => 'CHARLIE REID',
				number    => 1,
				pim       => 0,
				goals     => 0,
				assists   => 0,
			},
		],
		[],
	],
	199920450 => [
		[
			{
				_id => 8459457,
				number => 15,
				position  => 'L',
				timeOnIce => '00:27',
				name      => 'JAMIE LANGENBRUNNER',
				penaltyMinutes       => 0,
				goals     => 0,
				assists   => 0,
				missing => 1,
			}
		],
		[],
	],
);

=head1 NAME

Sport::Analytics::NHL::Errors - Hard fixes to errors in the NHL reports

=head1 SYNOPSYS

Hard fixes to errors in the NHL reports

Provides hard-coded corrections to the errors in the NHL reports or marks certain files as broken and unoperatable

This list shall expand as the release grows.

    use Sport::Analytics::NHL::Errors;
    # TBA

=cut

1;

=head1 AUTHOR

More Hockey Stats, C<< <contact at morehockeystats.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<contact at morehockeystats.com>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Sport::Analytics::NHL::Errors>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Sport::Analytics::NHL::Errors


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Sport::Analytics::NHL::Errors>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Sport::Analytics::NHL::Errors>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/Sport::Analytics::NHL::Errors>

=item * Search CPAN

L<https://metacpan.org/release/Sport::Analytics::NHL::Errors>

=back

