# Generated by default/object.tt
package Paws::LicenseManager::Grant;
  use Moose;
  has GrantArn => (is => 'ro', isa => 'Str', required => 1);
  has GrantedOperations => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has GranteePrincipalArn => (is => 'ro', isa => 'Str', required => 1);
  has GrantName => (is => 'ro', isa => 'Str', required => 1);
  has GrantStatus => (is => 'ro', isa => 'Str', required => 1);
  has HomeRegion => (is => 'ro', isa => 'Str', required => 1);
  has LicenseArn => (is => 'ro', isa => 'Str', required => 1);
  has ParentArn => (is => 'ro', isa => 'Str', required => 1);
  has StatusReason => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LicenseManager::Grant

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LicenseManager::Grant object:

  $service_obj->Method(Att1 => { GrantArn => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LicenseManager::Grant object:

  $result = $service_obj->Method(...);
  $result->Att1->GrantArn

=head1 DESCRIPTION

Describes a grant.

=head1 ATTRIBUTES


=head2 B<REQUIRED> GrantArn => Str

Amazon Resource Name (ARN) of the grant.


=head2 B<REQUIRED> GrantedOperations => ArrayRef[Str|Undef]

Granted operations.


=head2 B<REQUIRED> GranteePrincipalArn => Str

The grantee principal ARN.


=head2 B<REQUIRED> GrantName => Str

Grant name.


=head2 B<REQUIRED> GrantStatus => Str

Grant status.


=head2 B<REQUIRED> HomeRegion => Str

Home Region of the grant.


=head2 B<REQUIRED> LicenseArn => Str

License ARN.


=head2 B<REQUIRED> ParentArn => Str

Parent ARN.


=head2 StatusReason => Str

Grant status reason.


=head2 B<REQUIRED> Version => Str

Grant version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LicenseManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

