#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::PaymentStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PaymentStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::PaymentStatusCodeType

=head1 DESCRIPTION

Indicates the success or failure of the buyer's online payment for a transaction.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 NoPaymentFailure

(out) No payment failure.



=cut


use constant NoPaymentFailure => scalar('NoPaymentFailure');


=head2 BuyerECheckBounced

(out) The buyer's eCheck bounced.



=cut


use constant BuyerECheckBounced => scalar('BuyerECheckBounced');


=head2 BuyerCreditCardFailed

(out) The buyer's credit card failed.



=cut


use constant BuyerCreditCardFailed => scalar('BuyerCreditCardFailed');


=head2 BuyerFailedPaymentReportedBySeller

(out) The seller reports that the buyer's payment failed.



=cut


use constant BuyerFailedPaymentReportedBySeller => scalar('BuyerFailedPaymentReportedBySeller');


=head2 PayPalPaymentInProcess

(out) The payment from buyer to seller is in PayPal process, but has not
yet been completed.



=cut


use constant PayPalPaymentInProcess => scalar('PayPalPaymentInProcess');


=head2 PaymentInProcess

(out) Currently for eBay Germany only.



=cut


use constant PaymentInProcess => scalar('PaymentInProcess');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
