package MyInterfaces::BarCode::BarCodeSoap;
use strict;
use warnings;
use Class::Std::Fast::Storable;
use Scalar::Util qw(blessed);
use base qw(SOAP::WSDL::Client::Base);

# only load if it hasn't been loaded before
require MyTypemaps::BarCode
    if not MyTypemaps::BarCode->can('get_class');

sub START {
    $_[0]->set_proxy('http://www.webservicex.net/genericbarcode.asmx') if not $_[2]->{proxy};
    $_[0]->set_class_resolver('MyTypemaps::BarCode')
        if not $_[2]->{class_resolver};
}

sub GenerateBarCode {
    my ($self, $body, $header) = @_;
    die "GenerateBarCode must be called as object method (\$self is <$self>)" if not blessed($self);
    return $self->SUPER::call({
        operation => 'GenerateBarCode',
        soap_action => 'http://www.webservicex.net/GenerateBarCode',
        style => 'document',
        body => {
            
           'use' => 'literal',
            namespace => '',
            encodingStyle => '',
            parts => [qw( MyElements::GenerateBarCode )],
        },
        header => {
            
        },
        headerfault => {
            
        }
    }, $body, $header);
}



1;



__END__

=pod

=head1 NAME


MyInterfaces::BarCode::BarCodeSoap - SOAP Interface for the BarCode Web Service

=head1 SYNOPSIS

 use MyInterfaces::BarCode::BarCodeSoap;
 my $interface = MyInterfaces::BarCode::BarCodeSoap->new();
 
 my $response;
 $response = $interface->GenerateBarCode();

 

=head1 DESCRIPTION

SOAP Interface for the BarCode web service
located at http://www.webservicex.net/genericbarcode.asmx.

=head1 SERVICE BarCode

Barcode generator

=head2 Port BarCodeSoap



=head1 METHODS

=head2 General methods

=head3 new

Constructor.

All arguments are forwarded to L<SOAP::WSDL::Client|SOAP::WSDL::Client>.

=head2 SOAP Service methods

Method synopsis is displayed with hash refs as parameters.

The commented class names in the method's parameters denote that objects
of the corresponding class can be passed instead of the marked hash ref.

You may pass any combination of objects, hash and list refs to these
methods, as long as you meet the structure.



=head3 GenerateBarCode

WebserviceX.NET barcode library that provides the means to create barcodes for printing and display in any internet enabled applications. This web service supports Code 128, Industrial 2 of 5, Interleaved 2 of 5, Code 2 5 Matrix, Code 39, Code 39 Extended, Code 93, Code 93 Extended, Codabar, EAN13, EAN8, MSI, Postnet, Supp2, Supp5, UPC A, UPC E0 and UPC E1 barcode formats. This Barcodes returns byte image. It supports following image format JPEG, GIF, PNG, BMP, EMF, EXIF, ICON, MEMORY BMP, TIFF and WMF.

 $interface->GenerateBarCode(  {
    BarCodeParam =>     { # MyTypes::BarCodeData
      Height =>  $some_value, # int
      Width =>  $some_value, # int
      Angle =>  $some_value, # int
      Ratio =>  $some_value, # int
      Module =>  $some_value, # int
      Left =>  $some_value, # int
      Top =>  $some_value, # int
      CheckSum =>  $some_value, # boolean
      FontName =>  $some_value, # string
      BarColor =>  $some_value, # string
      BGColor =>  $some_value, # string
      FontSize =>  $some_value, # float
      barcodeOption => $some_value, # BarcodeOption
      barcodeType => $some_value, # BarcodeType
      checkSumMethod => $some_value, # CheckSumMethod
      showTextPosition => $some_value, # ShowTextPosition
      BarCodeImageFormat => $some_value, # ImageFormats
    },
    BarCodeText =>  $some_value, # string
  },,
 );
 


=head1 AUTHOR

Generated by SOAP::WSDL on Sun Dec 16 20:10:20 2007

=pod