/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.utils;

import at.ac.tuwien.dbai.pdfwrap.comparators.XComparator;
import at.ac.tuwien.dbai.pdfwrap.model.document.CharSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.ImageSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.LineSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.RectSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextBlock;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextFragment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextLine;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ListUtils {
    public static void removeDuplicates(List<?> l) {
        LinkedHashSet set = new LinkedHashSet();
        set.addAll(l);
        l.clear();
        l.addAll(set);
    }

    public static void selectItemsByClass(List<? extends Object> inputList, Class c, List resultList) {
        for (Object object : inputList) {
            if (object.getClass() != c) continue;
            resultList.add(object);
        }
    }

    public static List<CharSegment> selectCharacters(List<GenericSegment> l) {
        ArrayList<CharSegment> retVal = new ArrayList<CharSegment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != CharSegment.class) continue;
            retVal.add((CharSegment)thisSegment);
        }
        return retVal;
    }

    public static List<TextFragment> selectTextFragments(List<GenericSegment> l) {
        ArrayList<TextFragment> retVal = new ArrayList<TextFragment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != TextFragment.class) continue;
            retVal.add((TextFragment)thisSegment);
        }
        return retVal;
    }

    public static List<TextSegment> selectTextSegments(List<GenericSegment> l) {
        ArrayList<TextSegment> retVal = new ArrayList<TextSegment>();
        for (GenericSegment thisSegment : l) {
            if (!(thisSegment instanceof TextSegment)) continue;
            retVal.add((TextSegment)thisSegment);
        }
        return retVal;
    }

    public static List<TextBlock> selectTextBlocks(List<GenericSegment> l) {
        ArrayList<TextBlock> retVal = new ArrayList<TextBlock>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != TextBlock.class) continue;
            retVal.add((TextBlock)thisSegment);
        }
        return retVal;
    }

    public static List<TextLine> selectTextLines(List<GenericSegment> l) {
        ArrayList<TextLine> retVal = new ArrayList<TextLine>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != TextLine.class) continue;
            retVal.add((TextLine)thisSegment);
        }
        return retVal;
    }

    public static List<LineSegment> selectLineSegments(List<GenericSegment> l) {
        ArrayList<LineSegment> retVal = new ArrayList<LineSegment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != LineSegment.class) continue;
            retVal.add((LineSegment)thisSegment);
        }
        return retVal;
    }

    public static List<LineSegment> selectHorizLineSegments(List<GenericSegment> l) {
        ArrayList<LineSegment> retVal = new ArrayList<LineSegment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != LineSegment.class || ((LineSegment)thisSegment).getDirection() != 1) continue;
            retVal.add((LineSegment)thisSegment);
        }
        return retVal;
    }

    public static List<LineSegment> selectVertLineSegments(List<GenericSegment> l) {
        ArrayList<LineSegment> retVal = new ArrayList<LineSegment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != LineSegment.class || ((LineSegment)thisSegment).getDirection() != 2) continue;
            retVal.add((LineSegment)thisSegment);
        }
        return retVal;
    }

    public static List<RectSegment> selectRectSegments(List<GenericSegment> l) {
        ArrayList<RectSegment> retVal = new ArrayList<RectSegment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != RectSegment.class) continue;
            retVal.add((RectSegment)thisSegment);
        }
        return retVal;
    }

    public static List<ImageSegment> selectImageSegments(List<GenericSegment> l) {
        ArrayList<ImageSegment> retVal = new ArrayList<ImageSegment>();
        for (GenericSegment thisSegment : l) {
            if (thisSegment.getClass() != ImageSegment.class) continue;
            retVal.add((ImageSegment)thisSegment);
        }
        return retVal;
    }

    public static GenericSegment findLeftMostSegment(List<? extends GenericSegment> l) {
        ArrayList<GenericSegment> sortedList = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            sortedList.add(genericSegment);
        }
        Collections.sort(l, new XComparator());
        return l.get(0);
    }

    public static GenericSegment findRightMostSegment(List<? extends GenericSegment> l) {
        ArrayList<GenericSegment> sortedList = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            sortedList.add(genericSegment);
        }
        Collections.sort(l, new XComparator());
        return l.get(l.size() - 1);
    }

    public static List<GenericSegment> findElementsFullyWithinBBox(List<? extends GenericSegment> l, GenericSegment bBox) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            if (!(genericSegment.getX1() >= bBox.getX1()) || !(genericSegment.getX2() <= bBox.getX2()) || !(genericSegment.getY1() >= bBox.getY1()) || !(genericSegment.getY2() <= bBox.getY2())) continue;
            retVal.add(genericSegment);
        }
        return retVal;
    }

    public static List<GenericSegment> findElementsIntersectingBBox(List<? extends GenericSegment> l, GenericSegment bBox) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            if (!SegmentUtils.intersects(bBox, genericSegment)) continue;
            retVal.add(genericSegment);
        }
        return retVal;
    }

    public static List<GenericSegment> findElementsWithCentresWithinBBox(List<? extends GenericSegment> l, GenericSegment bBox) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            if (!(genericSegment.getXmid() >= bBox.getX1()) || !(genericSegment.getXmid() <= bBox.getX2()) || !(genericSegment.getYmid() >= bBox.getY1()) || !(genericSegment.getYmid() <= bBox.getY2())) continue;
            retVal.add(genericSegment);
        }
        return retVal;
    }

    public static List<GenericSegment> findElementsWithCentresWithinBBoxOrViceVersa(List<? extends GenericSegment> l, GenericSegment bBox) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            if (!(genericSegment.getXmid() >= bBox.getX1() && genericSegment.getXmid() <= bBox.getX2() && genericSegment.getYmid() >= bBox.getY1() && genericSegment.getYmid() <= bBox.getY2()) && (!(bBox.getXmid() >= genericSegment.getX1()) || !(bBox.getXmid() <= genericSegment.getX2()) || !(bBox.getYmid() >= genericSegment.getY1()) || !(bBox.getYmid() <= genericSegment.getY2()))) continue;
            retVal.add(genericSegment);
        }
        return retVal;
    }

    public static List<GenericSegment> findElementsFullyWithinBBox(List<? extends GenericSegment> l, float[] bBox) {
        return ListUtils.findElementsFullyWithinBBox(l, new GenericSegment(bBox));
    }

    public static void printList(List<?> l) {
        System.out.println("List with items: " + l.size());
        for (Object o : l) {
            System.out.println(o);
        }
    }

    public static void printListWithSubItems(List<? extends GenericSegment> l) {
        System.out.println("Segment list: " + l + " items: " + l.size());
        for (GenericSegment genericSegment : l) {
            System.out.println(genericSegment);
            if (!(genericSegment instanceof CompositeSegment)) continue;
            CompositeSegment cs = (CompositeSegment)genericSegment;
            cs.printSubItems(1);
        }
    }

    public static void printListWithOneLevelSubItems(List<? extends GenericSegment> l) {
        System.out.println("Segment list: " + l + " items: " + l.size());
        for (GenericSegment genericSegment : l) {
            System.out.println(genericSegment);
            if (!(genericSegment instanceof CompositeSegment)) continue;
            CompositeSegment cs = (CompositeSegment)genericSegment;
            for (GenericSegment item : cs.getItems()) {
                System.out.println("    " + item);
            }
        }
    }

    public static List<GenericSegment> shallowCopy(List<? extends GenericSegment> l) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            retVal.add(genericSegment);
        }
        return retVal;
    }

    public static List<GenericSegment> deepCopy(List<? extends GenericSegment> l) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        for (GenericSegment genericSegment : l) {
            retVal.add((GenericSegment)genericSegment.clone());
        }
        return retVal;
    }

    public static List<GenericSegment> intersection(List<? extends GenericSegment> l1, List<? extends GenericSegment> l2) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        List intersect = org.apache.commons.collections.ListUtils.intersection(l1, l2);
        for (Object o : intersect) {
            GenericSegment gs = (GenericSegment)o;
            retVal.add(gs);
        }
        return retVal;
    }
}

