use Mojo::Base -strict;

use Test::More;
use Test::Mojo;

use Mojolicious::Lite;

get '/' => sub {
    my $c = shift;
    $c->render(text => 'Hello Mojo!');
};

my @tests = (
    {
        param  => '*',
        result => '*',
    },
    {
        param  => 'http://perl-services.de',
        result => "http://perl-services.de",
    },
    {
        param  => [qw/X-Test Origin/],
        result => "X-Test, Origin",
    },
);

for my $test ( @tests ) {
    plugin SecurityHeader => [
        'Access-Control-Expose-Headers' => $test->{param},
    ];
    
    my $t = Test::Mojo->new;
    $t->get_ok('/')->status_is(200)->header_is('Access-Control-Expose-Headers', $test->{result} );
}

done_testing();
