package Chart::Plotly::Trace::Pointcloud::Marker;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

use Chart::Plotly::Trace::Pointcloud::Marker::Border;

our $VERSION = '0.041';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace pointcloud.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has blend => (
    is  => "rw",
    isa => "Bool",
    documentation =>
      "Determines if colors are blended together for a translucency effect in case `opacity` is specified as a value less then `1`. Setting `blend` to `true` reduces zoom/pan speed if used with large numbers of points.",
);

has border => ( is  => "rw",
                isa => "Maybe[HashRef]|Chart::Plotly::Trace::Pointcloud::Marker::Border", );

has color => (
    is  => "rw",
    isa => "Str",
    documentation =>
      "Sets the marker fill color. It accepts a specific color.If the color is not fully opaque and there are hundreds of thousandsof points, it may cause slower zooming and panning.",
);

has opacity => (
    is  => "rw",
    isa => "Num",
    documentation =>
      "Sets the marker opacity. The default value is `1` (fully opaque). If the markers are not fully opaque and there are hundreds of thousands of points, it may cause slower zooming and panning. Opacity fades the color even if `blend` is left on `false` even if there is no translucency effect in that case.",
);

has sizemax => (
    is  => "rw",
    isa => "Num",
    documentation =>
      "Sets the maximum size (in px) of the rendered marker points. Effective when the `pointcloud` shows only few points.",
);

has sizemin => (
    is  => "rw",
    isa => "Num",
    documentation =>
      "Sets the minimum size (in px) of the rendered marker points, effective when the `pointcloud` shows a million or more points.",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Pointcloud::Marker - This attribute is one of the possible options for the trace pointcloud.

=head1 VERSION

version 0.041

=head1 SYNOPSIS

 use HTML::Show;
 use Chart::Plotly;
 use Chart::Plotly::Trace::Pointcloud;
 my $pointcloud = Chart::Plotly::Trace::Pointcloud->new( x => [ 1 .. 100000 ], y => [ map { rand() } ( 1 .. 100000 ) ] );
 
 HTML::Show::show( Chart::Plotly::render_full_html( data => [$pointcloud] ) );

=head1 DESCRIPTION

This attribute is part of the possible options for the trace pointcloud.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#pointcloud>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * blend

Determines if colors are blended together for a translucency effect in case `opacity` is specified as a value less then `1`. Setting `blend` to `true` reduces zoom/pan speed if used with large numbers of points.

=item * border

=item * color

Sets the marker fill color. It accepts a specific color.If the color is not fully opaque and there are hundreds of thousandsof points, it may cause slower zooming and panning.

=item * opacity

Sets the marker opacity. The default value is `1` (fully opaque). If the markers are not fully opaque and there are hundreds of thousands of points, it may cause slower zooming and panning. Opacity fades the color even if `blend` is left on `false` even if there is no translucency effect in that case.

=item * sizemax

Sets the maximum size (in px) of the rendered marker points. Effective when the `pointcloud` shows only few points.

=item * sizemin

Sets the minimum size (in px) of the rendered marker points, effective when the `pointcloud` shows a million or more points.

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
