/* -*- C++ -*- */
/**********************************************************************
 **********************************************************************
 ****
 **** UML 1.5 Meta-model Specification
 **** Based on UML Specification 1.5 final/03-03-01
 **** Author: kstephens@users.sourceforge.net
 **** Version: $Revision: 1.20 $
 **** Date: 2003/04/17
 **** Reference: http://ummf.sourceforge.net/
 ****
 **** Note: This document is machine-readable by UMMF::UML::Import::MetaMetaModel;
 **** Please see it for language definition.
 ****
 **** This specification is incomplete.
 ****
 **********************************************************************
 **********************************************************************
 */


/**********************************************************************
 **********************************************************************
 **********************************************************************
 **
 ** This description is parsed into objects in the UMMF::UML::MetaMetaModel
 ** (or UMMF::UML::MetaModel) package.
 **	
 ** UMMF::UML::MetaMetaModel implements a subset of the UML Metamodel for the purpose
 ** of boot-strapping the UML.
 **
 ** The UMMF::UML::Export classes only use a subset of the UML intefaces, 
 ** which allow the Export classes to manipulate meta-meta-model and 
 ** meta-model levels
 **
 ** Thus the Export classes have double-duty:
 ** 1. Generate code for the UML Meta-model implementation,
 ** 2. Generate code for new models generated by UML editors.
 **
 **********************************************************************
 **********************************************************************
 **********************************************************************
 */


/* See p. 5-3 for UML Package Dependencies. */

Model "UML 1.5 final/03-03-01"
{

Package Foundation
{

Package Data_Types 
{ 

  /* Primitives */
  Primitive Integer;

  Primitive UnlimitedInteger;

  Primitive Real; /* Needed for OCL 2.0 ??? */

  Primitive String;

  Primitive Name;


  Enumeration AggregationKind 
  {
    none;
    aggregate;
    composite;
  }

  Enumeration Boolean
  {
    false;
    true;
  }

  Enumeration CallConcurrencyKind
  {
    sequential;
    guarded;
    concurrent;
  }

  Enumeration ChangeableKind
  {
    changeable;
    frozen;
    addOnly;
  }

  Enumeration OrderingKind
  {
    unordered;
    ordered;
  }

  Enumeration PseudostateKind
  {
    choice;
    deepHistory;
    fork;
    initial;
    join;
    junction;
    shallowHistory;
  }

  Enumeration ScopeKind
  {
    instance;
    classifier;
  }

  Enumeration VisibilityKind
  {
    public;
    protected;
    private;
    package;
  }


  Enumeration ParameterDirectionKind
  {
    in;
    out;
    inout;
    return;
  }

  Class Geometry;

  Class LocationReference;

  Class Mapping
  {
    body : String;
    ;
  }


  Class Multiplicity
  {
    @ <#> 1 , +range : MultiplicityRange 1..* ;
  }


  Class MultiplicityRange
  {
    lower : Integer = 0;
    upper : UnlimitedInteger = "*";
  }

  Class Expression
  {
    language : Name;
    body : String;
  }

  : Expression
  {
    Class ArgListExpression;

    Class BooleanExpression;

    Class MappingExpression;

    Class ProcedureExpression;

    Class TimeExpression;

    Class TypeExpression;
  }

} /* End Package Foundation::Data_Types */


Package Core
{
  :: Foundation::Data_Types::*;


  /* Page 2-13; Core Package - Backbone */

  Class /Element/;

  Class /ModelElement/ : Element
  {
    name            : Name;

    /* From ElementOwnership: ???*/
    visibility      : VisibilityKind = public ;
    isSpecification : Boolean        = false  ;
  }

  AssociationClass ElementOwnership
  {
    visibility      : VisibilityKind = public ;
    isSpecification : Boolean        = false  ;

    @ . +ownedElement : ModelElement * , <#> +namespace : Namespace 0..1;
  }

  Class /Namespace/ : ModelElement
  {
    /* @ namespace  0..1 , ownedElement : ModelElement * /* ElementOwnership ??? */;
  }

  Class /GeneralizableElement/ : ModelElement
  {
    isRoot : Boolean       = false ;
    isLeaf : Boolean       = false ;
    isAbstract : Boolean   = false ;
  }

  Class /Classifier/ : Namespace, GeneralizableElement;

  Class Parameter : ModelElement
  {
    defaultValue  : Expression;
    kind          : ParameterDirectionKind = inout ; 
    
    @            *           , +type : Classifier;
    @ +parameter * {ordered} ,       : BehavioralFeature 0..1;
  }

  Class Constraint : ModelElement
  {
    body : BooleanExpression;

    @ +constraint * , +constrainedElement : ModelElement 0..1;
  }

  Class /Feature/ : ModelElement
  {
    ownerScope : ScopeKind       = instance  ;
    visibility : VisibilityKind  = public    ;
    
    @ +feature * {ordered} , <#> +owner : Classifier 0..1;
  }

  Class /StructuralFeature/ : Feature
  {
    multiplicity : Multiplicity;
    changeability : ChangeableKind = changeable ;
    targetScope : ScopeKind        = instance   ;
    ordering : OrderingKind        = unordered  ;

    @ +typedFeature *, +type : Classifier;
  }

  Class Attribute : StructuralFeature
  {
    initialValue : Expression;
  }

  Class /BehavioralFeature/ : Feature
  {
    isQuery : Boolean = false ;
  }

  : BehavioralFeature
  {
    Class Operation
    {
      concurrency : CallConcurrencyKind = sequential ;
      isRoot : Boolean                  = false      ;
      isLeaf : Boolean                  = false      ;
      isAbstract : Boolean              = false      ;

      /* specification : String; /* Error? see UML 1.5 Spec, pg. 2-13, 2-45 */
      
      @ +specification , : Method *;
    }

    Class Method
    {
      body : ProcedureExpression;
    }
  }

  /* Page 2-13; Core Package - Relationships */

  Class /Relationship/ : ModelElement;

  : Relationship
  {

    Class Flow
    {
      @ +sourceFlow * , +source : ModelElement *;
      @ +targetFlow * , +target : ModelElement *;
    }

    Class Generalization
    {
      @ +generalization * , +child     : GeneralizableElement 1;
      @ +specialization * , +parent    : GeneralizableElement 1;
      @ +powertypeRange * , +powertype : Classifier           0..1;
    }

  }

  Class Association : GeneralizableElement, Relationship  /* GeneralizableElement is more dominant */
  {
/*
   This simplifies a bunch of code.
    @ <#>               1 , +connection  : AssociationEnd   2..* {ordered};
*/
    @ <#> +_association 1 , +connection  : AssociationEnd   2..* {ordered};
  }

  Class AssociationClass :  Class, Association; /* Class is more dominant */

  Class AssociationEnd : ModelElement
  {
    isNavigable : Boolean          = true       ;
    ordering : OrderingKind        = unordered  ;
    aggregation : AggregationKind  = none       ;
    targetScope : ScopeKind        = instance   ;
    multiplicity : Multiplicity;
    changeability : ChangeableKind = changeable ;
    visibility : VisibilityKind    = public     ;
    
    @     +association    *              , +participant   : Classifier 1;
    @     +specifiedEnd   *              , +specification : Classifier *;
    @ <#> +associationEnd 0..1           , +qualifier     : Attribute  * {ordered} ;
  }

  /* Page 2-15; Core Package - Dependencies */

  Class Dependency :Relationship
  {
    @ +supplierDependency * , +supplier : ModelElement 1..*;
    @ +clientDependency   * , +client   : ModelElement 1..*;
  }

  : Dependency
  {

    Class Binding;

    Class Usage;

    Class Permission;

    Class Abstraction
    {
      mapping : MappingExpression;
    }

  }

  /* Page 2-16: Core Package - Classifiers */

  : Classifier
  {

    Class "Class"
    {
      isActive : Boolean = false;
    }

    Class Interface;

    Class Node
    {
      @ +deploymentLocation *    , +deployedComponent : Component *;
    }

    Class Component
    {
      @ +implementationLocation * , +implementation : Artifact *;
      @ +container              * , +resident       : ModelElement *;
    }

    Class Artifact;

    Class DataType;

  }

  : DataType
  {

    Class "Primitive";

    Class ProgrammingLanguageDataType
    {
      expression : TypeExpression;
    }

    Class "Enumeration"
    {
      @ +enumeration , +literal : EnumerationLiteral 1..* {ordered} ;
    }

  }

  Class EnumerationLiteral : ModelElement;
 
  /* Page 2-17: Core Package - Auxililary elements */

  : Element /* Implied?? */
  {

    AssociationClass TemplateParameter
    {
      @                                     *           ,     +defaultElement : ModelElement 0..1;

      @ . +templateParameter : ModelElement * {ordered} , <#> +template       : ModelElement 0..1;
    }

    Class TemplateArgument
    {
      @           *              , +modelElement : ModelElement 1;
      @ +argument 1..* {ordered} , +binding      : Binding      1;
    }

    Class /PresentationElement/ : Element
    {
      @ +presentation  * , +subject : ModelElement *;
    }

  }

  Class Comment : ModelElement
  {
    name : String;

    @ * , +annotatedElement : ModelElement *;
  }
  
} /* End Package Foundation::Core */


Package Extension_Mechanisms
{
  :: Foundation::Core::*, Foundation::Data_Types::*;

  /* Page 2-76; Extension Mechanisms */


  Class Stereotype : GeneralizableElement
  {
    icon : Geometry;
    baseClass : Name[*];

    @ +constrainedStereotype 0..1 , +stereotypeConstraint : Constraint    *;
    @ +owner                 0..1 , +definedTag           : TagDefinition *;
    @ +stereotype            *    , +extendedElement      : ModelElement  *;
  }

  Class TagDefinition : ModelElement
  {  
    tagType : Name;
    multiplicity : Multiplicity;
    
    @ +type 1 , +typedValue : TaggedValue *;
  }

  Class TaggedValue : ModelElement
  {
    dataValue : String[*];

    @ +taggedValue  * ,                 : ModelElement 1;
    @ +referenceTag * , +referenceValue : ModelElement *;
  }

} /* End Package Foundation::Extension_Mechanisms */


} /* End Package Foundation */


/* Page 2-182: Model Management */

Package Model_Management
{
  :: Foundation::Core::*, Foundation::Data_Types::*;

  Class "Package" : Namespace, GeneralizableElement; /* Namespace is more dominant */
  Class Subsystem : Classifier, Package /* Classifier is more dominant */
  {
    isInstantiable : Boolean; /* = ??? */
  }

  Class "Model" : Package;

  AssociationClass ElementImport
  { 
    visibility : VisibilityKind = public ;
    alias : Name;
    isSpecification : Boolean   = false  ;

    @ . : Package * , +importedElement : ModelElement *;
  }

} /* END Package ::Model_Management */


/* Page 2-93: Behavioral Elements Package */

Package Behavioral_Elements
{


  Package Common_Behavior
  {
    :: Foundation::Core::*, Foundation::Data_Types::*;

    /* Page 2-94: Common Behavior - Signals */
    Class Signal : Classifier
    {
      @ +raisedSignal * , +context   : BehavioralFeature *;
      @ +signal 1       , +reception : Reception         0..*;
    }

    Class Exception : Signal;

    Class Reception : BehavioralFeature /* from Foundation::Core */
    {
      specification : String;
      isRoot : Boolean     = false ;
      isLeaf : Boolean     = false ;
      isAbstract : Boolean = false ;
    }

    /* Page 2-95: Common Behavior - Procedure */
    : ModelElement
    {
      Class Procedure
      {
	language : Name;
	body : String;
	isList : Boolean; /* = ??? */

	@ +procedure 0..1 , +expression : Expression 0..*;
	@ +procedure 0..1 , +method     : Method     0..*;
      }

      /* Page 2-96: Common Behavior - Instances */
      Class AttributeLink
      {
	@       *    ,     +attribute : Attribute 1     ;
	@ +slot 0..* , <#>            : Instance  1     ;
	@       *    ,     +value     : Instance  1     ;
      }

      Class Stimulus
      {
	@      * , <> +argument       : Instance  * {ordered} ;
	@      * ,    +receiver       : Instance  1           ;
	@      * ,    +sender         : Instance  1           ;
	@      * ,    +dispatchAction : Procedure 1           ;
      }

      Class /Instance/
      {
        @                *    ,     +classifier : Classifier 1..*;
	@ +ownedInstance 0..* , <#> +owner                   0..1; 
      }
    }

    : Instance 
    {
      Class DataValue;

      Class SubsystemInstance;

      Class ComponentInstance
      {
	@ 0..1        , +resident : Instance;
        @ +resident * ,           : NodeInstance 0..1;
      }

      Class NodeInstance;

      Class Object;
    }

    /* Page 2-97: Common Behavior - Links */
    Class Link : ModelElement
    {
      @     +communicationsLink 0..1 ,                  : Stimulus      *              ;
      @     +ownedLink          *    , <#> +owner       : Instance      0..1           ;
      @ <#>                     1    ,     +connection  : LinkEnd       2..* {ordered} ;
      @                         *    ,     +association : Association   1              ;
    }

    Class LinkEnd : ModelElement
    {
      @ <#>                    0..1  , +qualifierValue  : AttributeLink  *   {ordered} ;
      @     +linkEnd           *     , +instance        : Instance       1             ;
      @                        *     , +associationEnd  : AssociationEnd 1             ;
    }

    Class LinkObject : Object, Link;

  } /* End Package ::Behavioral_Elements::Common_Behavior */


  Package Collaborations
  {
    :: Behavioral_Elements::Common_Behavior::*, 
       Foundation::Core::*, 
       Foundation::Data_Types::*
       ;

    /* Page 2-113: Collaboration - Roles */
    Class Collaboration : GeneralizableElement, Namespace
    {
      @ <#>          1 ,    +/ownedElement         : AssociationRole *    ;
      @ <#>          1 ,    +/ownedElement         : ClassifierRole  1..* ; /* two ownedElement associationEnds? */
      @ <>           * ,    +constrainingElement   : ModelElement    *    ;

      /* p. 2-114: Collaborations - Interactions */
      @              * ,    +usedCollaboration                       *    ;
      @ <#> +context 1 ,                           : Interaction     *    ;
      @              * ,    +representedOperation  : Operation       0..1 ; /* --- {xor} --- */
      @              * ,    +representedClassifier : Operation       0..1 ;
    }


    Class AssociationRole : Association
    {
      multiplicity : Multiplicity;
      @ <#>                          1    , +/connection : AssociationEndRole 2..*;
      @                              *    , +base        : Association        0..1; 
      @     +communicationConnection 0..1 ,              : Message            *;
    }


    Class AssociationEndRole : AssociationEnd
    {
      collaborationMultiplicity : Multiplicity;

      @                * , +/base              : AssociationEnd 0..1    ; 
      @                * , +/type              : ClassifierRole 1       ;
      @ <>             * , +avaliableQualifier : Attribute      *       ;
    }
    

    Class ClassifierRole : Classifier
    {
      multiplicity : Multiplicity;

      @ <>             * , +availableFeature   : Feature            *    ;
      @                * , +base               : Classifier         1..* ;
      @    +sender     1 ,                     : Message            *    ;
      @    +receiver   1 ,                     : Message            *    ;

      /* p ??? */
      @    +playedRole * , +conformingInstance : Instance           *    ;
    }

    /* Ommission from UML Spec. 1.5 formal/03-03-01??
    ** 
    ** p. 2-112, fig. 2-18: Association between "Message" and "Action (from Common Behavior)"
    ** In Sec. 2.9 Common Behavior; none of the diagrams or text specify Class "Action".
    ** p. Index-1 cites "Action" p 2-103.
    ** p. 2-103 has no mention of "Action".  
    ** The first item in 2.9.3 is "2.9.3.1 AttributeLink".
    **
    ** Class /Action/ 
    ** {
    **  WHAT IS IT'S DEFINITION?
    **  ;
    ** }
    **
    ** This is most likely Behavioral_Elements::Actions::Action_Foundation::Action
    **  -- kstephens@users.sourceforge.net 2003/09/30
    */

    Class Message : Behavioral_Elements::Actions::Action_Foundation::Action
    {
      @ +predecessor *    , +sucessor                            * ;
/*
      @ +activator   0..1 ,                                      * ;
*/
      @ +playedRole  *    , +conformingStimulus : Stimulus       * ;
    } 

    /* p.2-114, Fig. 2-19 Collaborations - Interactions */
    Class Interaction : ModelElement
    {
      @ <#> +interaction 1  , +message : Message 1..* ;
    }

    /* p.2-115, Fig. 2-20 Collaborations - Instances */
    Class InteractionInstanceSet : ModelElement
    {
      @                      * ,     +particpatingStimulus : Stimulus                 1..* ;
      @                      * ,     +interaction          : Interaction              0..1 ;
      @ +interactionInstance * , <#> +context              : CollaborationInstanceSet 1    ;
    }

    Class CollaborationInstanceSet : ModelElement
    {
      @         * , +constrainingElement  : ModelElement  *    ;
      @         * , +collaboration        : Collaboration 0..1 ;  
      @         * , +particpatingInstance : Instance      1..* ;
      @         * , +particpatingLink     : Link          *    ;
    }
   
   /* Continue specification?!?!?! */
  } /* END Package ::Behavioral_Elements::Collaborations */


  Package Use_Cases
  {
    :: Behavioral_Elements::Common_Behavior::*, 
       Foundation::Data_Types::*,
       Foundation::Core::*
       ;

    /* p.2-130, fig.2-21   Use Cases */
    Class Actor : Classifier;

    Class UseCase : Classifier
    {
	@ +addition  1 ,                 : Include        * ;
        @ +base      1 , +include        : Include        * ;
	@ +extension 1 , +extended       : Extend         * ;
        @ +base      1 ,                 : Extend         * ;
        @            1 , +extensionPoint : ExtensionPoint * ;
    }

    Class UseCaseInstance : Instance;

    Class Include : Relationship;

    Class Extend : Relationship
    {
	condition : BooleanExpression;

    }

    Class ExtensionPoint : ModelElement
    {
	location : LocationReference;

	@ +extensionPoint 1..* {ordered} , : Extend * ;
    }


    /* Continue specification!!! */
  } /* End Package Behavioral_Elements::Use_Cases */


  Package State_Machines
  {
    :: Behavioral_Elements::Common_Behavior::*,
       Foundation::Core::*,
       Foundation::Data_Types::*
       ;

    /* p. 2-141, fig. 2-24.  State Machines - Events */

    Class StateMachine : ModelElement
    {
      @     +behavior   *    , <> +context      : ModelElement    0..1 ;
      @ <#>             0..1 ,    +top          : State           1 ; /* 0..1??? */
      @ <#>             0..1 ,    +transitions  : Transition      * ; /* +??? */
    }

    Class Guard : ModelElement
    {
      expression : BooleanExpression;
    
      @ +guard 0..1 , <#> : Transition 1 ;
    }

    Class Transition : ModelElement
    {
      @     +internalTransition *    , <#>          : State     0..1 ;
      @ <#>                     0..1 ,     +effect  : Procedure 0..1 ;
      @ <>                      0..0 ,     +trigger : Event     0..1 ;
    }

    Class /StateVertex/ : ModelElement
    {
      @ +source    1    ,     +outgoing  : Transition     * ;
      @ +target    1    ,     +incoming  : Transition     * ;
    }

    : StateVertex {

      Class State 
      {
        @ <#> 0..1 , +entry           : Procedure 0..1 ;
        @ <#> 0..1 , +exit            : Procedure 0..1 ;
        @ <#> 0..1 , +doActivity      : Procedure 0..1 ;
	@     0..* , +deferrableEvent : Event     0..* ;
      }

      Class SynchState
      {
	bound : UnlimitedInteger;
      }

      /* p. 2-141, 2.12.2 */
      Class Pseudostate
	/* p. 2-141 .vs. p. 2-145: 
           Should be "PseudoState" or "Pseudostate"??? 
	   Poseidon uses "Pseudostate"
           -- kstephens@users.sourceforge.net 2003/10/14
         */
      {
	kind : PseudostateKind;
      }


      Class StubState
      {
	referenceState : Name;
      }

    }

    : State {

      Class CompositeState
      {
        @ <#> +container 0..1 , +subvertex : StateVertex 0..* ;
      }

      Class SimpleState;

      Class FinalState;
    }

    Class SubmachineState : CompositeState
    {
      @ * , +submachine : StateMachine 1;
    }

    Class /Event/
    {
      @ <#> 0..1 , +parameter : Parameter * {ordered} ; 
    }

    /* p. 2-142, fig. 2-25.  State Machines - Events */
    : Event {

      Class SignalEvent
      {
        @ +occurance * , +signal : Signal 1 ;
      }

      Class CallEvent
      {
        @ +occurance * , +operation : Operation 1 ;
      }

      Class TimeEvent
      {
        when : TimeExpression;
      }

      Class ChangeEvent
      {
        changeExpression : BooleanExpression;
      }

    }

  } /* End Package Behavioral_Elements::State_Machines */


  Package Activity_Graphs
  {
    :: Behavioral_Elements::Common_Behavior::*,
       Behavioral_Elements::State_Machines::*,
       Foundation::Core::*,
       Foundation::Data_Types::*
       ;

    /* p. 2-271, fig. 2-30  Activity Graphs */
    Class ActivityGraph : StateMachine
    {
      @ <#> 1 , +partition : Partition 0..* ;
    }

    Class Partition : ModelElement
    {
      @ * , +contents : ModelElement * ; 
    }

    Class SubactivityState : SubmachineState
    {
      isDynanmic : Boolean;
      dyanmicArguments : ArgListExpression;
      dynamicMultiplicity : Multiplicity;
    }

    Class ActionState : SimpleState;

    Class ObjectFlowState : SimpleState
    {
      isSynch : Boolean;
     
      @ +state *    , +parameter : Parameter  * ;
      @        *    , +type      : Classifier 1 ;
    }

    Class ClassifierInState : Classifier
    {
      @        0..* , +inState : State      1..* ;
      @        *    , +type    : Classifier 1    ;
    }

  } /* End Package Behavioral_Elements::Activity_Graphs */


  Package Actions
  {

    Package Action_Foundation
    {
      :: Foundation::Core::*,
         Foundation::Data_Types::*
         ;

      /* p. 2-211, fig. 2-38  Action foundation model */

      Class Action : ModelElement
      {
        isReadOnly : Boolean;
 
        @ +predecessor 1 ,     +consequent : ControlFlow 0..* ;
        @ +successor   1 ,     +antecedent : ControlFlow 0..* ;
        @ +action      1 , <#>             : Procedure   0..1 ; /* Assume Foundation::Core::Procedure? */
      }

      Class /Pin/ : ModelElement
      {
        multiplicity : Multiplicity;
        ordering     : OrderingKind = unordered ;

        @ 0..* , +type : Classifier 0..1 ;
      }

      Class OutputPin : Pin
      {
        @ +/availableOutput 0..*           ,                : Action    0..* ;
        @ +outputPin        0..* {ordered} , <#> +action    : Action    0..1 ;
        @ +argument         0..* {ordered} , <#> +procedure : Procedure 0..1 ;        
        @ +source           1              ,     +flow      : DataFlow  0..* ; 
      }

      Class InputPin : Pin
      {
        @ +/availableInput  0..*           ,                : Action    0..* ;
        @ +inputPin         0..* {ordered} , <#> +action    : Action    0..1 ;
        @ +result           0..* {ordered} , <#> +procedure : Procedure 0..1 ;
        @ +destination      1              ,     +flow      : DataFlow  1    ; 
      }

      Class ControlFlow : ModelElement
      {
        ;
      }

      Class DataFlow : ModelElement
      {
        ;
      }

      Class /PrimitiveAction/ : Action;

      Class Procedure /* 2.19.3.8 Procedure */
      {
        language : Name;
        body : String;
        isList : Boolean;
      }

      /* In this Package or Variable_Actions???? */
      Class Variable : ModelElement /* NOT AN ACTION */
      {  
	multiplicity : Multiplicity;
	ordering : OrderingKind = unordered ;

	@                      0..* , -> +type              : Classifier 0..1          ;
	/* IMPLEMENT */
      }

    } /* End Package Behavioral_Elements::Actions::Action_Foundation */


    Package Composite_Actions
    {
      :: 
         Behavioral_Elements::Actions::Action_Foundation::*,
         Foundation::Core::*,
         Foundation::Data_Types::*
         ;

      /* p. 2-228, fig. 2-41  Composite Actions metamodel */
      Class Clause : Element
      {  
        @                      0..* , -> +testOutput        : OutputPin  0..*           ;
        @                      0..* , -> +bodyOutput        : OutputPin  0..* {ordered} ;
	@     +successorClause 0..* ,    +predecessorClause : Clause     0..*           ;
	@ <#>                  0..1 , -> +test              : Action     1              ;
	@ <#>                  0..1 , -> +body              : Action     1              ;
      }

      Class ConditionalAction : Action
      { 
	isDeterminate : Boolean;

	@ <#>                  0..1 , -> +clause            : Action     1..*           ;
	/* ^ --- xor --- LoopAction.clause */
      }

      Class GroupAction : Action
      {  
 	mustIsolate : Boolean;

	@ <#> +group           0..1 ,    +subaction         : Action     0..*           ;
	@ <#> +scope           1    ,    +variable          : Variable   0..*           ;
      }

      Class LoopAction : Action
      {  
	@ <#>                  0..1 , -> +clause            : Action     1              ;
        /* ^ --- xor --- ConditionalAction.clause */
	@ <#> +loop            0..1 ,    +loopVariable      : OutputPin  0..* {ordered} ;
      }

    }  /* End Package Behavioral_Elements::Actions::Composite_Actions */


    /* p. 2-263, 2.21.7 Read and Write Action Classes */
    Package Read_Write_Actions
    {
      :: Behavioral_Elements::Actions::Action_Foundation::*,
         Foundation::Core::*,
         Foundation::Data_Types::*
         ;


      /* p. 2-253, 2.21.1 Object Actions */
      Package Object_Actions
      {
        :: Behavioral_Elements::Actions::Read_Write_Actions::*,
	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class CreateObjectAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result : OutputPin 1  ;
        */
	@     0..* , -> +classifier : Classifier 1 ;
      }

      Class DestroyObjectAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/input : InputPin 1  ;
        */
	/* IMPLEMENT */
        ;
      }

      Class ReclassifyObjectAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/input : InputPin 1  ;
        */
	@ 0..* , -> +oldClassifer  : Classifier 0..* ;
	@ 0..* , -> +newClassifier : Classifier 0..* ;
      }

      Class ReadIsClassifiedObjectAction : PrimitiveAction
      {  
	isDirect : Boolean;

	/* SUPER CLASS?
        @ <#> 0..1 , -> +/input     : InputPin   1  ;
        @ <#> 0..1 , -> +/result    : OutputPin  1  ;
        */
	@     0..* , -> +classifier : Classifier 1 ;
      }

      } /* End Package Behavioral_Elements::Actions::Read_Write_Actions::Object_Actions */
      

      /* p. 2-254, 2.21.2 Attribute Actions */
      Package Attribute_Actions
      {
        :: Behavioral_Elements::Actions::Read_Write_Actions::*,
	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class /AttributeAction/ : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/object     : InputPin   1  ;
        */

	@     0..* , -> +attribute   : Attribute 1  ;
      }

      Class ReadAttributeAction : AttributeAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result    : OutputPin  1  ;
        */
        ;
      }

      Class /WriteAttributeAction/ : AttributeAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/value     : InputPin   0..1  ;
        */
        ;
      }

      Class AddAttributeValueAction : WriteAttributeAction
      {  
	isReplaceAll : Boolean;

	/* SUPER CLASS?
        @ <#> 0..1 , -> +/insertAt  : InputPin   0..1  ;
        */
        ;
      }

      Class RemoveAttributeValueAction : WriteAttributeAction
      {  
        ;
      }

      Class ClearAttributeAction : AttributeAction
      {  
        ;
      }

      } /* End Package Behavioral_Elements::Actions::Read_Write_Actions::Attribute_Actions */


      /* p.2-255, 2.21.3 Association Actions */
      Package Association_Actions
      {
        :: Behavioral_Elements::Actions::Read_Write_Actions::*,
	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class /LinkAction/ : PrimitiveAction
      {  
	@ <#> 1 , -> +endData : LinkEndData 2..* ;
      }

      Class LinkEndData : Element /* NOT AN ACTION: ??? */
      {  
	@ <#> 1    , -> +qualifier  : QualifierValue 0..*  ;
	@     0..* , -> +end        : AssociationEnd 1     ;
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/value     : InputPin       0..1  ;
        */
      }

      Class LinkEndCreationData : LinkEndData
      {  
	/* SUPER CLASS?
        @ <#> 1 , -> +/endData      : LinkEndCreationData 0..1  ;
        */
        ;
      }

      Class QualifierValue : Element /* NOT AN ACTION: ??? */
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/value     : InputPin       1     ;
        */
	@     0..* , -> +qualifier  : Attribute      1     ;
      }


      /* p.2-257, 2.21.3.2 Navigating Across an Association */
      Class ReadLinkAction : LinkAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     1     ;
        */
        ;
      }


      /* p.2-257, 2.21.3.3 Reading Link Objects */
      Class ReadLinkObjectEndAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/object     : InputPin       1    ;
        @ <#> 0..1 , -> +/result     : OutputPin      1    ;
        */
	@     0..1 , -> +end         : AssociationEnd 1    ;
      }

      Class ReadLinkObjectQualifierAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/object     : InputPin       1    ;
        @ <#> 0..1 , -> +/result     : OutputPin      1    ;
        */
	@     0..1 , -> +qualifier   : Attribute      1    ;
      }


      /* p.2-258, 2.21.3.4 Writing Links */
      Class /WriteLinkAction/ : LinkAction
      { 
	;
      }

      Class CreateLinkAction : WriteLinkAction
      {  
	/* SUPER CLASS?
        @ <#>    1 , -> +/endData    : LinkEndCreationData  2..* ;
        */
        ;
      }

      Class DestroyLinkAction : WriteLinkAction
      {  
        ;
      }

      Class CreateLinkObjectAction : CreateLinkAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     1     ;
        */
        ;
      }

      Class ClearAssociationAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/object     : InputPin       1    ;
        */
	@     0..1 , -> +association : Association    1    ;
      }

      } /* End Package Behavioral_Elements::Actions::Read_Write_Actions::Association_Actions */


      /* p.2-259, 2.21.4 Variable Actions */
      Package Variable_Actions
      {
        :: Behavioral_Elements::Actions::Read_Write_Actions::*,
	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class /VariableAction/ : PrimitiveAction
      {  
	@     0..* , -> +variable : Variable 1 ;
      }

      Class ReadVariableAction : VariableAction
      {  
	/* IMPLEMENT */
        ;
      }

      Class /WriteVariableAction/ : VariableAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/value     : InputPin       0..1  ;
        */
        ;
      }

      Class AddVariableValueAction : WriteVariableAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/insertAt  : InputPin   0..1  ;
        */
        ;
      }

      Class RemoveVariableValueAction : WriteVariableAction
      {  
        ;
      }

      Class ClearVariableAction : VariableAction
      {  
        ;
      }

      } /* End Package Behavioral_Elements::Actions::Variable_Actions */


      /* p.2-260, 2.21.5 Other Actions */
      Package Other_Actions
      {

        :: Behavioral_Elements::Actions::Read_Write_Actions::*,
  	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class ReadExtentAction : PrimitiveAction
      {  
	@    0..1 , -> +classifier : Classifier 1 ;
      }

      Class ReadSelfAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     1     ;
        */
        ;
      }

      Class CallProcedureAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/output    : InputPin   1  ;
        @ <#> 0..1 , -> +/input     : OutputPin  1  ;
        */
        @     1    , -> +procedure : Procedure 1 ;
      }

      Class StartObjectStateMachineAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/input     : InputPin  1   ;
        */
        ;
      }

      } /* End Package Behavioral_Elements::Actions::Read_Write_Actions::Other_Actions */

    } /* End Package Behavioral_Elements::Actions::Read_Write_Actions */


    /* p. 2-287, 2.22 Computation Actions */
    Package Computation_Actions 
    {
      :: Behavioral_Elements::Actions::Action_Foundation::*,
	 Behavioral_Elements::Common_Behavior::*, /* DataValue */
         Foundation::Core::*,
         Foundation::Data_Types::*
         ;
      
      /* p. 2-289, 2.22.2 Computation Classes */
      Class ApplyFunctionAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     1..* {ordered}     ;
        @ <#> 0..1 , -> +/argument   : InputPin      0..* {ordered}     ;
        */
	@ 0..* , -> +function : PrimitiveFunction 1;
      }

      Class PrimitiveFunction : ModelElement /* NOT AN ACTION */
      {  
        @ 0..* , -> +inputSpec  : ArgumentSpecification 0..* ;
        @ 0..* , -> +outputSpec : ArgumentSpecification 1..* ;
      }

      Class ArgumentSpecification : ModelElement
      {  
	@ 0..* , -> +type : DataType 1 ;
      }


      Class CodeAction : PrimitiveAction
      {  
	language : String;
	encoding : String;

	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     0..* {ordered}     ;
        @ <#> 0..1 , -> +/argument   : InputPin      0..* {ordered}     ;
        */
      }

      Class UnmarshalAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     1                  ;
        @ <#> 0..1 , -> +/argument   : InputPin      0..* {ordered}     ;
        */

	/* IMPLEMENT */
        @ 0..1 , -> +unmarshalType : "Class" 1 ;
      }

      Class MarshalAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     0..* {ordered}     ;
        @ <#> 0..1 , -> +/argument   : InputPin      1                  ;
        */

        @ 0..1 , -> +marshalType   : "Class" 1 ;
      }

      Class TestIdentifyAction : PrimitiveAction
      {  
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/first      : InputPin      1                  ;
        @ <#> 0..1 , -> +/second     : InputPin      1                  ;
        @ <#> 0..1 , -> +/result     : OutputPin     1                  ;
	*/
	;
      }

      Class LiteralValueAction : PrimitiveAction
      {
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     1                  ;
	*/
	@ 0..* , -> +value : DataValue 1 ;
      }

      Class NullAction : PrimitiveAction
      {  
        ;
      }

    } /* End Package Behavioral_Elements::Actions::Computation_Actions */


    /* p. 2-296, 2.23 Collection Actions */
    Package Collection_Actions
    {
      :: Behavioral_Elements::Actions::Action_Foundation::*,
         Foundation::Core::*,
         Foundation::Data_Types::*
         ;

      
      Class /CollectionAction/ : Action 
      { 
	@ * , +subaction : Action 1 /* {isNavigable=false} */ ;

	/* IMPLEMENT */
        ;
      }

      /* p.??? */
      Package Filter
      {

        :: Behavioral_Elements::Actions::Collection_Actions::*,
  	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class FilterAction : CollectionAction
      {
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result     : OutputPin     ???? 0..* {ordered}     ;
        @ <#> 0..1 , -> +/argument   : InputPin      1..* {ordered}     ;
        */

	@ 0..1 , -> +subinput : OutputPin 1..* {ordered} ;
	@ 0..1 , -> +subtest  : OutputPin 1              ;
      }

      } /* End Package Behavioral_Elements::Actions::Collection_Actions::Filter */


      /* p.???? */
      Package Iterate
      {

        :: Behavioral_Elements::Actions::Collection_Actions::*,
  	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class IterateAction : CollectionAction
      {
        isUnordered : Boolean;

	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result              : OutputPin     0..* {ordered}     ;
	*/
 	@ <#> 0..1 , -> +/loopVariableInput : InputPin  0..* {ordered} ;
 	@ <#> 0..1 , -> +/collectionInput   : InputPin  1..* {ordered} ;
	@ <#> 0..1 , -> +loopVariable       : OutputPin 0..* {ordered} ;
	@     0..1 , -> +suboutput          : OutputPin 0..* {ordered} ;
	@     0..1 , -> +subinput           : OutputPin 1..*           ;
      }

      } /* End Package Behavioral_Elements::Actions::Collection_Actions::Iterate */


      /* p.???? */
      Package Map
      {

        :: Behavioral_Elements::Actions::Collection_Actions::*,
  	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class MapAction : CollectionAction
      {
	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result              : OutputPin     0..* {ordered}     ;
        @ <#> 0..1 , -> +/argument            : InputPin      1..* {ordered}     ;
	*/
	@ <#> 0..1 , -> +subinput           : OutputPin 1..* {ordered} ;
	@     0..1 , -> +suboutput          : OutputPin 0..* {ordered} ;
      }

      } /* End Package Behavioral_Elements::Actions::Collection_Actions::Map */


      /* p.???? */
      Package Reduce
      {

        :: Behavioral_Elements::Actions::Collection_Actions::*,
  	   Behavioral_Elements::Actions::Action_Foundation::*,
           Foundation::Core::*,
           Foundation::Data_Types::*
           ;

      Class ReduceAction : CollectionAction
      {
        isUnordered : Boolean;

	/* SUPER CLASS?
        @ <#> 0..1 , -> +/result              : OutputPin     0..* {ordered}     ;
        @ <#> 0..1 , -> +/argument            : InputPin      1..* {ordered}     ;
	*/
	@ <#> 0..1 , -> +leftSubinput         : OutputPin     1..* {ordered}     ;
	@ <#> 0..1 , -> +rightSubinput        : OutputPin     1..* {ordered}     ; 
	@     0..1 , -> +suboutput            : OutputPin     1..* {ordered}     ;
      }

      } /* End Package Behavioral_Elements::Actions::Collection_Actions::Reduce */


    }  /* End Package Behavioral_Elements::Actions::Collection_Actions */


    /* p.??? Jump Actions */
    Package Jump_Actions
    {

      :: Behavioral_Elements::Actions::Action_Foundation::*,
         Foundation::Core::*,
         Foundation::Data_Types::*
         ;

      Class HandlerAction : Action
      {
        /* IMPLEMENT */
	@ <#> 0..*              , -> +body            : Action         1           ;
	@ <#> 0..*              , -> +/occurance      : OutputPin      1           ;
	@ <#> 0..*              , -> +/handlerOutput  : OutputPin      1 {ordered} ;
	;
      }

      Class JumpHandler : Element /* ???? */
      {
        /* IMPLEMENT */
	@                  0..* , -> +jumpType        : Classifier     1           ;
	@     +jumpHandler 0..* , -> +body            : HandlerAction  1           ;
	@     +jumpHandler 0..* , -> +protectedAction : Action         0..*        ;
      }  

      Class JumpAction : PrimitiveAction
      {
        /* IMPLEMENT */
	@ <#>              0..* , -> +/jumpOccurance  : InputPin       1           ;
      }

      /* IMPLEMENT */

    } /* End Package Behavioral_Elements::Actions::Jump_Actions */


    /* p. 2-331, 2.24 Messaging Actions */
    Package Messaging_Actions
    {
      :: Behavioral_Elements::Actions::Action_Foundation::*,
	 Behavioral_Elements::Common_Behavior::*, /* Signal */
         Foundation::Core::*,
         Foundation::Data_Types::*
         ;

      /* p. 2-321, 2.24.15 Messaging Classes */

      /* IMPLEMENT: Classs may need "/..." Associations */

      Class /ExplicitInvocationAction/ : PrimitiveAction
      {
	;
      }

      Class CallOperationAction : ExplicitInvocationAction
      {
	isAsynchronous : Boolean;

	@ 0..* , -> +operation : Operation 1;
      }

      Class BroadcastSignalAction : ExplicitInvocationAction
      {
	@ 0..* , -> +signal : Signal 1;
      }

      Class SendSignalAction : ExplicitInvocationAction
      {
	@ 0..* , -> +signal : Signal 1;
      }


      Class /InvocationAction/ : PrimitiveAction
      {
	;
      }

      Class SynchronousInvocationAction : InvocationAction
      {
	;
      }

      Class AsynchronousInvocationAction : InvocationAction
      {
	isRepliable : Boolean;
      }


    } /* End Pacakge Behavioral_Elements::Actions::Messaging_Actions */


  } /* End Package Behavioral_Elements::Actions */


} /* End Package Behavioral_Elements */


/****************************************************************************
 **  Based on OMG UML 2.0 OCL 2003/01/07
 **
 */

Package OCL /* What is this Package's name??? */ 
{
 
  Package Types 
  {
    :: Foundation::Core::*,                    /* Classifier */
       Foundation::Data_Types::*,              /* DataType */
       Behavioral_Elements::Common_Behavior::* /* Signal */
       ;
    
    Class OclMessageType : Classifier
    {
      /* IMPLEMENT */
      @ 1 , -> +referredSignal    : Signal    0..1 ;
      @ 1 , -> +referredOperation : Operation 0..1 ;
    }

    Class OCLModelElementType : Classifier
    {
      /* IMPLEMENT */
      ;
    }

    Class VoidType : Classifier
    {
      /* IMPLEMENT */
      ;
    }


    Class TupleType : DataType
    {
      /* IMPLEMENT */
      ;
    }

    Class CollectionType : Classifier
    {
      /* IMPLEMENT */
      ;

      @ +collectionTypes 0..4 , +elementType : Classifier 1 ;
    }

    Class SetType : CollectionType
    {
      /* IMPLEMENT */
      ;

    }

    Class SequenceType : CollectionType
    {
      /* IMPLEMENT */
      ;

    }

    Class OrdereredSetType : CollectionType
    {
      /* IMPLEMENT */
      ;

    }

    Class BagType : CollectionType
    {
      /* IMPLEMENT */
      ;

    }

  } /* End Package OCL::Types */


  Package Expressions
  {
    :: OCL::Types::*,
       Foundation::Core::*,                      /* Classifier */
       Foundation::Data_Types::*,                /* DataType */
       Behavioral_Elements::Common_Behavior::*,  /* Signal */
       Behavioral_Elements::Actions::Messaging_Actions::* /* CallOperationAction, SendSignalAction */
       ;
    
    /* UML 1.5 -- OCL 2.0 Mismatch ??? */
    Class CallAction : CallOperationAction; /* OCL 2.0 ???? */
    Class SendAction : SendSignalAction;    /* OCL 2.0 ???? */

    /* p.53, 3.3.1 Expressions Core */
    Class /OclExpression/ : ModelElement
    {
      ;
    }
 
    Class VariableExp : OclExpression
    {
      @ 0..* , +referredVariable : VariableDeclaration 1;
    }

    Class /LoopExp/ : PropertyCallExp /* //??? */
    {
      ;
      @ <#>           0..1 , +body      : OclExpression       1    ;
      @ <#> +loopExpr 0..1 , +iterators : VariableDeclaration 1..* ;
    }

    Class IteratorExp : LoopExp;

    Class IterateExp : LoopExp
    {
      @ <#> +baseExpr 0..1 , +result    : VariableDeclaration 1    ;
    }

    Class VariableDeclaration : Element /* ???? */
    {
      @ <#> +initializedVariable 0..1 ,    +initExpression : OclExpression 0..1 ;
      @                             1 , -> +type           : Classifier    1    ;
    }


    /* p.56, 3.3.2. Model PropertyCall Expressions */
    Class /PropertyCallExp/ : OclExpression;  /* //??? */

    Class /ModelPropertyCallExp/ : PropertyCallExp;  /* //??? */

    Class AttributeCallExp : ModelPropertyCallExp
    {
      @                      0..* , -> +referredAttribute : Attribute 1 ;
    }

    Class /NavigationCallExp/ : ModelPropertyCallExp  /* //??? */
    {
      @                      1    , -> +navigationSource : AssociationEnd 1 ;
      @ <#>                  0..1 ,    +qualifiers : OclExpression 0..* {ordered};
    } 

    Class AssociationEndCallExp : NavigationCallExp
    {
      @                      0..* , -> +referredAssociationEnd : AssociationEnd 1 ;
    } 

    Class AssociationClassEndCallExp : NavigationCallExp
    {
      @                      0..* , -> +referredAssociationClass : AssociationClass 1 ;
    } 

    Class OperationCallExp : ModelPropertyCallExp
    {
      @ <#> +parentOperation 0..1 ,    +arguments         : OclExpression 0..* {ordered} ;
      @                      0..* , -> +referredOperation : Operation     1 ;
    }


    /* p. 58, 3.3.3 if Expressions */
    Class IfExp : OclExpression
    {
      @ <#> 0..1 , -> +condition      : OclExpression 1 ;
      @ <#> 0..1 , -> +thenExpression : OclExpression 1 ;
      @ <#> 0..1 , -> +elseExpression : OclExpression 1 ;
    }


    /* p. 58, 3.3.4 Message Expressions */
    Class OclMessageExp : OclExpression
    {
      @     1    , -> +target          : OclExpression 1              ;
      @     1    , -> +arguments       : OclMessageArg 0..* {ordered} ;
      @     1    , -> +calledOperation : CallAction    1              ;
      @     1    , -> +sendSignal      : SendAction    1              ;
    }

    Class OclMessageArg : Element /* ??? */
    {
      @     1    , -> +unspecified     : UnspecifiedValueExp 0..1 ;
      @     1    , -> +expression      : OclExpression       0..1 ;
    }

    Class UnspecifiedValueExp : ModelElement
    {
      @     1    , -> type             : Classifier         1     ;
    }


    /* p. 60, 3.3.5 Literal Expressions */
    Class /LiteralExp/ : OclExpression;  /* //??? */

    Class /PrimitiveLiteralExp/ : LiteralExp;  /* //??? */

    Class /NumericLiteralExp/ : PrimitiveLiteralExp; /* //??? */

    Class IntegerLiteralExp : NumericLiteralExp
    {
      integerSymbol : Integer;
    }

    Class RealLiteralExp : NumericLiteralExp
    {
      realSymbol : Real;
    }

    Class BooleanLiteralExp : PrimitiveLiteralExp
    {
      booleanSymbol : Boolean;
    }

    Class StringLiteralExp : PrimitiveLiteralExp
    {
      stringSymbol : String;
    }


    Class EnumLiteralExp : LiteralExp
    {
      @     1    , -> +referredEnumLiteral : EnumerationLiteral 1 ; /* Spec sez "EnumLiteral" */
    }

    Class TupleLiteralExp : LiteralExp
    {
      @     1    ,    +tuplePart : VariableDeclaration 0..* ;
    }

    Class CollectionLiteralExp : LiteralExp
    {
      kind : CollectionKind;

      @     1    ,    +parts     : CollectionLiteralPart 0..* {ordered} ;
    }

    Class /CollectionLiteralPart/ : Element /* ??? */  /* //??? */
    {
      @     1   , -> +type      : Classifier 1 ;  
    }

    Class CollectionRange : CollectionLiteralPart
    {
      @     0..1 , -> +first     : OclExpression 1 ;
      @     0..1 , -> +last      : OclExpression 1 ;
    }

    Class CollectionItem : CollectionLiteralPart
    {
      @     0..1 , -> +item      : OclExpression 1 ;
    }

    Enumeration CollectionKind
    {
      Collection;
      Set;
      Bag;
      Sequence;
    }


    /* p. 62, 3.3.6 Let expressions */
    Class LetExp : OclExpression
    {
      @ <#> 0..1 , -> +in       : OclExpression       1;
      @ <#> 0..1 , -> +variable : VariableDeclaration 1;
    }

  } /* End Package OCL::Expressions */


} /* End Package OCL */


} /* End Model */


/* END OF FILE */
