#!/usr/bin/perl
use 5.016;
use strict;
use warnings;

use Test::More;

use File::Spec;

use App::newver::Version qw(version_compare);

# Tests adapted from libverions's tests/compare_test.c
my @comparisons = (
    [ [ "0",            "0"               ], 0  ],
    [ [ "0a",           "0a"              ], 0  ],
    [ [ "a",            "a"               ], 0  ],
    [ [ "a0",           "a0"              ], 0  ],
    [ [ "0a1",          "0a1"             ], 0  ],
    [ [ "0a1b2",        "0a1b2"           ], 0  ],
    [ [ "1alpha1",      "1alpha1"         ], 0  ],
    [ [ "foo",          "foo"             ], 0  ],
    [ [ "1.2.3",        "1.2.3"           ], 0  ],
    [ [ "hello.world",  "hello.world"     ], 0  ],
    [ [ "1",            "1.0"             ], 0  ],
    [ [ "1",            "1.0.0"           ], 0  ],
    [ [ "1.0",          "1.0.0"           ], 0  ],
    [ [ "1.0",          "1.0.0.0.0.0.0.0" ], 0  ],
    [ [ "00100.00100",  "100.100"         ], 0  ],
    [ [ "0",            "000000000000000" ], 0  ],

    [ [ "0.0.0",        "0.0.1"           ], -1 ],
    [ [ "0.0.1",        "0.0.2"           ], -1 ],
    [ [ "0.0.2",        "0.0.10"          ], -1 ],
    [ [ "0.0.2",        "0.1.0"           ], -1 ],
    [ [ "0.0.10",       "0.1.0"           ], -1 ],
    [ [ "0.1.1",        "1.0.0"           ], -1 ],
    [ [ "10.0.0",       "100.0.0"         ], -1 ],
    [ [ "10.1000.1000", "11.0.0"          ], -1 ],
    [ [ "20160101",     "20160102"        ], -1 ],
    [ [ "999999999999999999", "1000000000000000000" ], -1 ],
    [ [ "99999999999999999999999999999999999998", "99999999999999999999999999999999999999" ], -1 ],
    [ [ "1.0",          "1.0a"            ], 1  ],
    [ [ "1.0a",         "1.0b"            ], -1 ],
    [ [ "1.0b",         "1.1"             ], -1 ],
    [ [ "a",            "0"               ], -1 ],
    [ [ "1.a",          "1.0"             ], -1 ],
    [ [ "1.0.a",        "1.0.b"           ], -1 ],
    [ [ "1.0.b",        "1.0.c"           ], -1 ],
    [ [ "1.0.c",        "1.0"             ], -1 ],
    [ [ "1.0.c",        "1.0.0"           ], -1 ],
    [ [ "1.0a0",        "1.0.a0"          ], 0  ],
    [ [ "1.0beta3",     "1.0.b3"          ], 0  ],
    [ [ "a",            "A"               ], 0  ],
    [ [ "1alpha",       "1ALPHA"          ], 0  ],
    [ [ "alpha1",       "ALPHA1"          ], 0  ],
    [ [ "a",            "alpha"           ], 0  ],
    [ [ "b",            "beta"            ], 0  ],
    [ [ "1.0.alpha.2",  "1_0_alpha_2"     ], 0  ],
    [ [ "1.0.alpha.2",  "1-0-alpha-2"     ], 0  ],
    [ [ "1.0.alpha.1",  "1,0:alpha~1"     ], 0  ],
    [ [ "..1...2...3.", "1.2.3"           ], 0  ],
    [ [ ".,:;~+_",      "0"               ], 0  ],
    [ [ "",             ""                ], 0  ],
    [ [ "",             "0"               ], 0  ],
    [ [ "1.0alpha1",    "1.0alpha2"       ], -1 ],
    [ [ "1.0alpha2",    "1.0beta1"        ], -1 ],
    [ [ "1.0beta1",     "1.0beta2"        ], -1 ],
    [ [ "1.0beta2",     "1.0rc1"          ], -1 ],
    [ [ "1.0beta2",     "1.0pre1"         ], -1 ],
    [ [ "1.0rc1",       "1.0"             ], -1 ],
    [ [ "1.0pre1",      "1.0"             ], -1 ],
    [ [ "1.0.alpha1",   "1.0.alpha2"      ], -1 ],
    [ [ "1.0.alpha2",   "1.0.beta1"       ], -1 ],
    [ [ "1.0.beta1",    "1.0.beta2"       ], -1 ],
    [ [ "1.0.beta2",    "1.0.rc1"         ], -1 ],
    [ [ "1.0.beta2",    "1.0.pre1"        ], -1 ],
    [ [ "1.0.rc1",      "1.0"             ], -1 ],
    [ [ "1.0.pre1",     "1.0"             ], -1 ],
    [ [ "1.0alpha.1",   "1.0alpha.2"      ], -1 ],
    [ [ "1.0alpha.2",   "1.0beta.1"       ], -1 ],
    [ [ "1.0beta.1",    "1.0beta.2"       ], -1 ],
    [ [ "1.0beta.2",    "1.0rc.1"         ], -1 ],
    [ [ "1.0beta.2",    "1.0pre.1"        ], -1 ],
    [ [ "1.0rc.1",      "1.0"             ], -1 ],
    [ [ "1.0pre.1",     "1.0"             ], -1 ],
    [ [ "1.0alpha-1",   "0.9"             ], 1  ],
    [ [ "1.0alpha-1",   "1.0"             ], -1 ],
    [ [ "1.0alpha-1",   "1.0.1"           ], -1 ],
    [ [ "1.0alpha-1",   "1.1"             ], -1 ],
    [ [ "1.0beta-1",    "0.9"             ], 1  ],
    [ [ "1.0beta-1",    "1.0"             ], -1 ],
    [ [ "1.0beta-1",    "1.0.1"           ], -1 ],
    [ [ "1.0beta-1",    "1.1"             ], -1 ],
    [ [ "1.0pre-1",     "0.9"             ], 1  ],
    [ [ "1.0pre-1",     "1.0"             ], -1 ],
    [ [ "1.0pre-1",     "1.0.1"           ], -1 ],
    [ [ "1.0pre-1",     "1.1"             ], -1 ],
    [ [ "1.0rc-1",      "0.9"             ], 1  ],
    [ [ "1.0rc-1",      "1.0"             ], -1 ],
    [ [ "1.0rc-1",      "1.0.1"           ], -1 ],
    [ [ "1.0rc-1",      "1.1"             ], -1 ],
    [ [ "1.0patch1",    "0.9"             ], 1  ],
    [ [ "1.0patch1",    "1.0"             ], 1  ],
    [ [ "1.0patch1",    "1.0.1"           ], -1 ],
    [ [ "1.0patch1",    "1.1"             ], -1 ],
    [ [ "1.0.patch1",   "0.9"             ], 1  ],
    [ [ "1.0.patch1",   "1.0"             ], 1  ],
    [ [ "1.0.patch1",   "1.0.1"           ], -1 ],
    [ [ "1.0.patch1",   "1.1"             ], -1 ],
    [ [ "1.0patch.1",   "0.9"             ], 1  ],
    [ [ "1.0patch.1",   "1.0"             ], 1  ],
    [ [ "1.0patch.1",   "1.0.1"           ], -1 ],
    [ [ "1.0patch.1",   "1.1"             ], -1 ],
    [ [ "1.0.patch.1",  "0.9"             ], 1  ],
    [ [ "1.0.patch.1",  "1.0"             ], 1  ],
    [ [ "1.0.patch.1",  "1.0.1"           ], -1 ],
    [ [ "1.0.patch.1",  "1.1"             ], -1 ],
    [ [ "1.0post1",     "0.9"             ], 1  ],
    [ [ "1.0post1",     "1.0"             ], 1  ],
    [ [ "1.0post1",     "1.0.1"           ], -1 ],
    [ [ "1.0post1",     "1.1"             ], -1 ],
    [ [ "1.0postany1",  "0.9"             ], 1  ],
    [ [ "1.0postany1",  "1.0"             ], 1  ],
    [ [ "1.0postany1",  "1.0.1"           ], -1 ],
    [ [ "1.0postany1",  "1.1"             ], -1 ],
    [ [ "1.0pl1",       "0.9"             ], 1  ],
    [ [ "1.0pl1",       "1.0"             ], 1  ],
    [ [ "1.0pl1",       "1.0.1"           ], -1 ],
    [ [ "1.0pl1",       "1.1"             ], -1 ],
    [ [ "1.0errata1",   "0.9"             ], 1  ],
    [ [ "1.0errata1",   "1.0"             ], 1  ],
    [ [ "1.0errata1",   "1.0.1"           ], -1 ],
    [ [ "1.0errata1",   "1.1"             ], -1 ],
    [ [ "1.0p1",        "1.0p1"           ], 0  ],
    [ [ "1.0p1",        "1.0P1"           ], 0  ],
    [ [ "1.0",          "1.0p1"           ], -1 ],
    [ [ "1.0",          "1.0.p1"          ], -1 ],
    [ [ "1.0",          "1.0.p.1"         ], -1 ],
    [ [ "1.0",          "1.0p.1"          ], -1 ],
    [ [ "1.0a1",        "1.0a1"           ], 0  ],
    [ [ "1.0",          "1.0a1"           ], 1  ],
    [ [ "1.0",          "1.0.a1"          ], 1  ],
    [ [ "1.0",          "1.0.a.1"         ], 1  ],
    [ [ "1.0",          "1.0a.1"          ], 1  ],
    [ [ "1.0p1",        "1.0pre1"         ], 1  ],
    [ [ "1.0p1",        "1.0patch1"       ], 0  ],
    [ [ "1.0p1",        "1.0post1"        ], 0  ],
    [ [ "1.0alpha",     "1.0"             ], -1 ],
    [ [ "1.0.alpha",    "1.0"             ], -1 ],
    [ [ "1.0beta",      "1.0"             ], -1 ],
    [ [ "1.0.beta",     "1.0"             ], -1 ],
    [ [ "1.0rc",        "1.0"             ], -1 ],
    [ [ "1.0.rc",       "1.0"             ], -1 ],
    [ [ "1.0pre",       "1.0"             ], -1 ],
    [ [ "1.0.pre",      "1.0"             ], -1 ],
    [ [ "1.0prerelease",  "1.0"             ], -1 ],
    [ [ "1.0.prerelease", "1.0"             ], -1 ],
    [ [ "1.0patch",     "1.0"             ], 1  ],
    [ [ "1.0.patch",    "1.0"             ], 1  ],
    [ [ "0.9999",       "1.0"             ], -1 ],
);

for my $c (@comparisons) {
    my ($vs, $res) = @$c;
    is(version_compare(@$vs), $res, "$vs->[0] <=> $vs->[1] == $res");
}

done_testing;
