
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "All the stuff I install with a fresh perl",
  "AUTHOR" => "Pedro Melo <melo\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Task-BeLike-MELO",
  "EXE_FILES" => [],
  "LICENSE" => "artistic_2",
  "NAME" => "Task::BeLike::MELO",
  "PREREQ_PM" => {
    "Algorithm::C3" => "0.08",
    "AnyEvent" => "7.02",
    "AnyEvent::AIO" => "1.1",
    "AnyEvent::Gearman" => "0.09",
    "AnyEvent::HTTP" => "2.14",
    "AnyEvent::HTTPD" => "0.93",
    "AnyEvent::Redis" => "0.23",
    "AnyEvent::Twitter::Stream" => "0.22",
    "AnyEvent::WebService::Notifo" => "0.001",
    "AnyEvent::XMPP" => "0.52",
    "AnyMQ" => "0.34",
    "App::Ack" => "1.96",
    "App::AltSQL" => "0.05",
    "App::ArchiveDevelCover" => "1.001",
    "App::BashComplete" => "0.008",
    "App::Genpass" => "2.32",
    "App::HTTPThis" => "0.002",
    "App::Nopaste" => "0.35",
    "App::Notifo" => "0.001",
    "App::Uni" => 8,
    "App::Whiff" => "0.002",
    "App::cpanminus" => "1.5017",
    "App::cpanoutdated" => "0.23",
    "App::pod2pdf" => "0.42",
    "Archive::Tar" => "1.88",
    "Archive::Tar::Wrapper" => "0.16",
    "Archive::Zip" => "1.30",
    "Async::Hooks" => "0.16",
    "Authen::Simple::Passwd" => "0.6",
    "CGI::Emulate::PSGI" => "0.14",
    "CGI::Fast" => "1.09",
    "CHI" => "0.55",
    "CPAN" => "1.9800",
    "CPAN::Mini" => "1.111008",
    "CPAN::Mini::Webserver" => "0.58",
    "CPAN::Reporter" => "1.2006",
    "CPAN::SQLite" => "0.202",
    "CSS::Minifier" => "0.01",
    "Cache::CacheFactory" => "1.10",
    "Carp::Always" => "0.11",
    "Carp::Clan" => "6.04",
    "Carton" => "v0.9.4",
    "Catalyst::Action::RenderView" => "0.16",
    "Catalyst::Controller::REST" => "1.05",
    "Catalyst::Devel" => "1.37",
    "Catalyst::Engine::PSGI" => "0.13",
    "Catalyst::Log::Log4perl" => "1.06",
    "Catalyst::Plugin::Authentication" => "0.10021",
    "Catalyst::Plugin::Session" => "0.35",
    "Catalyst::Plugin::Session::State::Cookie" => "0.17",
    "Catalyst::Plugin::Session::Store::FastMmap" => "0.16",
    "Catalyst::Plugin::StackTrace" => "0.11",
    "Catalyst::Plugin::Unicode" => "0.93",
    "Catalyst::Runtime" => "5.90016",
    "Catalyst::View::TT" => "0.39",
    "Catalyst::View::Tenjin" => "0.050001",
    "Check::ISA" => "0.04",
    "Class::C3" => "0.24",
    "Class::C3::XS" => "0.13",
    "Class::Load" => "0.20",
    "Class::MOP" => "2.0603",
    "Class::XSAccessor" => "1.13",
    "Clipboard" => "0.13",
    "Code::TidyAll" => "0.04",
    "Code::TidyAll::Plugin::PerlTidy" => "0.04",
    "Code::TidyAll::Plugin::PodTidy" => "0.04",
    "Compress::Raw::Bzip2" => "2.055",
    "Compress::Raw::Zlib" => "2.056",
    "Compress::Zlib" => "2.055",
    "Config::Any" => "0.23",
    "Config::GitLike" => "1.09",
    "Coro" => "6.08",
    "Crypt::Eksblowfish::Bcrypt" => "0.009",
    "Crypt::SSLeay" => "0.64",
    "DBD::SQLite" => "1.37",
    "DBD::mysql" => "4.021",
    "DBI" => "1.622",
    "DBICx::DataDictionary" => "0.002",
    "DBICx::Indexing" => "0.002",
    "DBICx::Shortcuts" => "0.007",
    "DBIx::Class" => "0.08198",
    "DBIx::Class::Candy" => "0.002100",
    "DBIx::Class::DeploymentHandler" => "0.002201",
    "DBIx::Class::EncodedColumn" => "0.00011",
    "DBIx::Class::Helpers" => "2.015000",
    "DBIx::Class::InflateColumn::Currency" => "0.02005",
    "DBIx::Class::InflateColumn::URI" => "0.01002",
    "DBIx::Class::Schema::Loader" => "0.07025",
    "DBIx::Class::TimeStamp" => "0.14",
    "DBIx::Connector" => "0.52",
    "DBIx::Tracer" => "0.02",
    "Data::Dump" => "1.21",
    "Data::Dumper" => "2.131",
    "Data::ObjectDriver" => "0.09",
    "Data::UUID::MT" => "0.006",
    "Date::Manip" => "6.32",
    "Date::Tiny" => "1.04",
    "DateTime" => "0.76",
    "DateTime::Format::DateParse" => "0.05",
    "DateTime::Format::Excel" => "0.31",
    "DateTime::Format::MySQL" => "0.04",
    "DateTime::Format::SQLite" => "0.11",
    "Devel::BeginLift" => "0.001003",
    "Devel::Cycle" => "1.11",
    "Devel::LeakGuard::Object" => "0.06",
    "Devel::NYTProf" => "4.08",
    "Devel::REPL" => "1.003013",
    "Devel::StackTrace" => "1.27",
    "Devel::StackTrace::WithLexicals" => "0.10",
    "Devel::TraceUse" => "2.06",
    "Digest::HMAC" => "1.03",
    "Digest::MD5" => "2.52",
    "Digest::SHA" => "5.71",
    "Digest::SHA1" => "2.13",
    "Dist::Zilla" => "4.300021",
    "Dist::Zilla::App::Command::cover" => "1.101001",
    "Dist::Zilla::Plugin::InstallGuide" => "1.200000",
    "Dist::Zilla::Plugin::LatestPrereqs" => "0.4",
    "Dist::Zilla::Plugin::PodPurler" => "0.093400",
    "Dist::Zilla::PluginBundle::Author::MELO" => "0.004",
    "EV" => "4.11",
    "Email::Abstract" => "3.004",
    "Email::Simple" => "2.102",
    "Eval::Closure" => "0.08",
    "ExtUtils::CBuilder" => "0.280205",
    "ExtUtils::MakeMaker" => "6.62",
    "FCGI" => "0.74",
    "FCGI::Client" => "0.08",
    "FCGI::ProcManager" => "0.24",
    "File::ChangeNotify" => "0.22",
    "File::HomeDir" => "0.99",
    "File::HomeDir::PathClass" => "1.112060",
    "File::MMagic" => "1.29",
    "File::Spec" => "3.33",
    "File::Temp" => "0.22",
    "File::Which" => "1.09",
    "Format::Human::Bytes" => "0.06",
    "GD" => "2.46",
    "Gearman::Client" => "1.11",
    "Gearman::Worker" => 0,
    "Getopt::Long" => "2.38",
    "Github::Import" => "0.07",
    "Graph::Easy" => "0.71",
    "GraphViz" => "2.10",
    "Guard" => "1.022",
    "HTML::Mason" => "1.50",
    "HTML::Template" => "2.91",
    "HTML::Template::Expr" => "0.07",
    "HTML::Template::JIT" => "0.05",
    "HTML::Template::Pro" => "0.9509",
    "HTTP::Headers" => "6.00",
    "HTTP::Parser" => "0.06",
    "HTTP::Parser::XS" => "0.14",
    "HTTP::Tiny" => "0.022",
    "IO::AIO" => "4.15",
    "IO::All" => "0.46",
    "IO::Compress::Base" => "2.055",
    "IO::Handle::Util" => "0.01",
    "IO::Socket::SSL" => "1.76",
    "IO::Uncompress::Gunzip" => "2.055",
    "IO::Zlib" => "1.10",
    "Image::Size" => "3.232",
    "JSON::XS" => "2.33",
    "KiokuDB" => "0.52",
    "KiokuDB::Backend::DBI" => "1.22",
    "KiokuDB::Backend::Redis" => "0.02",
    "LWP::Protocol::https" => "6.03",
    "LWP::Simple" => "6.00",
    "List::Util" => "1.25",
    "Log::Any" => "0.14",
    "Log::Any::Adapter" => "0.08",
    "Log::Any::Adapter::Log4perl" => "0.06",
    "Log::Log4perl" => "1.37",
    "MIME::Base64" => "3.09",
    "MIME::Entity" => "5.503",
    "MIME::Lite" => "3.029",
    "MIME::Parser" => "5.503",
    "MIME::WordDecoder" => 0,
    "MLDBM" => "2.04",
    "Mac::Carbon" => "0.82",
    "Mac::FSEvents" => "0.09",
    "Mac::Glue" => "1.30",
    "Mac::Growl" => "0.67",
    "Mail::Address" => "2.09",
    "Mail::IMAPClient" => "3.32",
    "Markapl" => "0.14",
    "Mason" => "2.20",
    "Math::Round" => "0.06",
    "Message::Passing" => "0.100",
    "Message::Passing::Redis" => "0.005",
    "Message::Passing::ZeroMQ" => "0.005",
    "Method::Signatures" => 20120523,
    "Modern::Perl" => "1.20120521",
    "Module::Build" => "0.4003",
    "Module::CoreList" => "2.70",
    "Module::Info" => "0.32",
    "Module::Install" => "1.06",
    "Module::Install::AuthorTests" => "0.002",
    "Module::Install::AutoManifest" => "0.003",
    "Module::Install::ProvidesClass" => "1.000000",
    "Module::Install::ReadmeFromPod" => "0.18",
    "Module::Install::Repository" => "0.06",
    "Module::Install::XSUtil" => "0.43",
    "Module::Which" => "0.0207",
    "Mojo" => 0,
    "Moose" => "2.0603",
    "Moose::Exporter" => "2.0603",
    "MooseX::Aliases" => "0.10",
    "MooseX::AttributeHelpers" => "0.23",
    "MooseX::AttributeShortcuts" => "0.014",
    "MooseX::ConfigFromFile" => "0.04",
    "MooseX::Declare" => "0.35",
    "MooseX::Getopt" => "0.45",
    "MooseX::Has::Sugar" => "0.05070421",
    "MooseX::HasDefaults::RO" => 0,
    "MooseX::LazyRequire" => "0.08",
    "MooseX::Method::Signatures" => "0.43",
    "MooseX::MethodAttributes" => "0.27",
    "MooseX::MultiMethods" => "0.10",
    "MooseX::Role::WithOverloading" => "0.09",
    "MooseX::StrictConstructor" => "0.19",
    "MooseX::Traits" => "0.11",
    "MooseX::Types" => "0.35",
    "MooseX::Types::DateTime" => "0.07",
    "MooseX::Types::Moose" => "0.35",
    "Mozilla::CA" => 20120309,
    "NTS::Template" => "2.1",
    "Net::Bonjour" => "0.96",
    "Net::Cmd" => "2.29",
    "Net::DNS" => "0.68",
    "Net::FTP" => "2.77",
    "Net::Rendezvous" => "0.92",
    "Net::Rendezvous::Publish::Backend::Apple" => "0.02",
    "Net::SMTP" => "2.31",
    "Net::SMTP::TLS" => "0.12",
    "Net::SSLeay" => "1.48",
    "Object::Event" => "1.23",
    "POE" => "1.354",
    "POE::XS::Queue::Array" => "0.006",
    "PPI" => "1.215",
    "PPI::HTML" => "1.08",
    "Package::Stash" => "0.33",
    "Package::Stash::XS" => "0.25",
    "Parallel::Prefork" => "0.13",
    "Params::Coerce" => "0.14",
    "Parse::CPAN::Meta" => "1.4404",
    "Parse::RecDescent" => "1.967009",
    "Path::Class" => "0.26",
    "Perl::Critic" => "1.118",
    "Perl::PrereqScanner" => "1.014",
    "Perl::Tidy" => 20120714,
    "Plack" => "1.0002",
    "Plack::Middleware::Debug" => "0.14",
    "Plack::Middleware::Debug::DBIC::QueryLog" => "0.09",
    "Plack::Middleware::Debug::DBIProfile" => "0.102",
    "Plack::Server::ReverseHTTP" => "0.03",
    "Pod::Coverage::TrustPod" => "0.100002",
    "Pod::Cpandoc" => "0.11",
    "Pod::Elemental" => "0.102362",
    "Pod::POM::Web" => "1.17",
    "Pod::PseudoPod" => "0.18",
    "Pod::Tidy" => "0.10",
    "Poet" => "0.12",
    "Redis" => "1.951",
    "Scalar::Util" => "1.25",
    "Server::Starter" => "0.11",
    "Spreadsheet::ParseExcel" => "0.59",
    "Spreadsheet::WriteExcel" => "2.37",
    "String::CRC32" => "1.4",
    "String::FriendlyID" => "0.019",
    "Sub::Name" => "0.05",
    "Sys::UniqueID" => "1.0",
    "TAP::Formatter::HTML" => "0.09",
    "TAP::Formatter::TextMate" => "0.1",
    "Task::Devel::Cover::Recommended" => "0.930001",
    "Task::Kensho" => "0.33",
    "Task::Moose" => "0.03",
    "Task::Plack" => "0.26",
    "Template" => "2.24",
    "Template::Alloy" => "1.016",
    "Template::Declare" => "0.45",
    "Template::Parser::CET" => "0.05",
    "Template::Sandbox" => "1.04",
    "Template::Tiny" => "1.12",
    "Tenjin" => "0.070001",
    "Term::ProgressBar" => "2.13",
    "Term::ReadKey" => "2.30",
    "Term::ReadLine::Gnu" => "1.20",
    "Term::ReadLine::Perl" => "1.0303",
    "Test::Base" => "0.60",
    "Test::CPAN::Meta" => "0.22",
    "Test::Compile" => "0.20",
    "Test::Continuous" => "0.73",
    "Test::Deep" => "0.110",
    "Test::Exception" => "0.31",
    "Test::Fatal" => "0.010",
    "Test::Harness" => "3.25",
    "Test::Inline::Extract" => "2.212",
    "Test::Kit" => "0.101",
    "Test::More" => "0.98",
    "Test::Output" => "1.01",
    "Test::Reporter" => "1.58",
    "Test::Reporter::Transport::Metabase" => "1.999008",
    "Test::TCP" => "1.17",
    "Test::WWW::Mechanize::Catalyst" => "0.58",
    "Text::Autoformat" => "1.669002",
    "Text::ClearSilver" => "0.010005004",
    "Text::Glob" => "0.09",
    "Text::Markdown" => "1.000031",
    "Text::MicroMason" => "2.13",
    "Text::MultiMarkdown" => "1.000034",
    "Text::ParseWords" => "3.27",
    "Text::Template::Simple" => "0.86",
    "Text::Textile" => "2.12",
    "Text::Tmpl" => "0.33",
    "Text::Unaccent" => "1.08",
    "Text::Wrap" => "2012.0818",
    "Text::Xslate" => "1.5017",
    "TextMate::JumpTo" => "0.07",
    "Throwable::X" => "0.006",
    "Tie::IxHash" => "1.22",
    "Time::HiRes" => "1.9725",
    "Time::ParseDate" => "2011.0517",
    "Time::y2038" => 20100403,
    "Try::Tiny" => "0.11",
    "TryCatch" => "1.003000",
    "Twiggy" => "0.1020",
    "URI" => "1.60",
    "URI::Escape" => "3.31",
    "URI::Find" => 20111103,
    "Unicode::String" => "2.09",
    "Unicode::Stringprep" => "1.104",
    "Unicode::Tussle" => "1.03",
    "Web::Scraper" => "0.36",
    "XML::Compile" => "1.26",
    "XML::Compile::WSDL11" => "2.29",
    "XML::Feed" => "0.50",
    "XML::LibXML" => "2.0004",
    "XML::Parser" => "2.41",
    "XML::Parser::Expat" => "2.41",
    "XML::Simple" => "2.20",
    "XML::XPath" => "1.13",
    "XS::Assert" => "0.002",
    "YAML" => "0.84",
    "YAML::XS" => "0.38",
    "ZMQ" => "1.01",
    "aliased" => "0.30",
    "autodie" => "2.12",
    "local::lib" => "1.008004",
    "namespace::autoclean" => "0.13",
    "namespace::clean" => "0.23"
  },
  "VERSION" => "0.009",
  "test" => {
    "TESTS" => ""
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



