#!/usr/bin/perl

package eBay::API::XML::DataType::CategoryFeatureType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CategoryFeatureType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CategoryFeatureType

=head1 DESCRIPTION

A container node that identifies a category that has one of the features
specified in FeatureID (in GetCategoryFeaturesRequest).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CategoryFeatureType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ListingDurationReferenceType;
use eBay::API::XML::DataType::ListingEnhancementDurationReferenceType;
use eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType;
use eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType;
use eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType;
use eBay::API::XML::DataType::Enum::GeographicExposureCodeType;
use eBay::API::XML::DataType::Enum::INEscrowWorkflowTimelineCodeType;
use eBay::API::XML::DataType::Enum::ItemSpecificsEnabledCodeType;


my @gaProperties = ( [ 'AdFormatEnabled', 'ns:AdFormatEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType', '' ]
	, [ 'BasicUpgradePackEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferCounterEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BuyerGuaranteeEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CategoryID', 'xs:string', '', '', '' ]
	, [ 'ClassifiedAdAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType', '' ]
	, [ 'ClassifiedAdCompanyNameEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdContactByAddressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdContactByEmailEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdContactByPhoneEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdCounterOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdPayPerLeadEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdPaymentMethodEnabled', 'ns:ClassifiedAdPaymentMethodEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType', '' ]
	, [ 'ClassifiedAdPhoneCount', 'xs:int', '', '', '' ]
	, [ 'ClassifiedAdShippingMethodEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdStreetCount', 'xs:int', '', '', '' ]
	, [ 'CombinedFixedPriceTreatmentEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossBorderTradeAustraliaEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossBorderTradeGBEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossBorderTradeNorthAmericaEnabled', 'xs:boolean', '', '', '' ]
	, [ 'DutchBINEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ExpressConditionRequired', 'xs:boolean', '', '', '' ]
	, [ 'ExpressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ExpressPicturesRequired', 'xs:boolean', '', '', '' ]
	, [ 'GalleryFeaturedDurations', 'ns:ListingEnhancementDurationReferenceType', ''
	     ,'eBay::API::XML::DataType::ListingEnhancementDurationReferenceType', '1' ]
	, [ 'HomePageFeaturedEnabled', 'xs:boolean', '', '', '' ]
	, [ 'INEscrowWorkflowTimeline', 'ns:INEscrowWorkflowTimelineCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::INEscrowWorkflowTimelineCodeType', '' ]
	, [ 'ItemSpecificsEnabled', 'ns:ItemSpecificsEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemSpecificsEnabledCodeType', '' ]
	, [ 'ListingDuration', 'ns:ListingDurationReferenceType', '1'
	     ,'eBay::API::XML::DataType::ListingDurationReferenceType', '1' ]
	, [ 'LocalMarketAdFormatEnabled', 'ns:AdFormatEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType', '' ]
	, [ 'LocalMarketAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType', '' ]
	, [ 'LocalMarketCompanyNameEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketContactByAddressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketContactByEmailEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketContactByPhoneEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketCounterOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketNonSubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketPaymentMethodCheckOutEnabled', 'ns:ClassifiedAdPaymentMethodEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType', '' ]
	, [ 'LocalMarketPhoneCount', 'xs:int', '', '', '' ]
	, [ 'LocalMarketPremiumSubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketRegularSubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketSellerContactDetailsEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketShippingMethodEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketSpecialitySubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketStreetCount', 'xs:int', '', '', '' ]
	, [ 'MinimumReservePrice', 'xs:double', '', '', '' ]
	, [ 'NonSubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'PaisaPayFullEscrowEnabled', 'xs:boolean', '', '', '' ]
	, [ 'PayPalBuyerProtectionEnabled', 'xs:boolean', '', '', '' ]
	, [ 'PayPalRequired', 'xs:boolean', '', '', '' ]
	, [ 'PremiumSubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'ProPackEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ProPackPlusEnabled', 'xs:boolean', '', '', '' ]
	, [ 'RegularSubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'SafePaymentRequired', 'xs:boolean', '', '', '' ]
	, [ 'SellerContactDetailsEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ShippingTermsRequired', 'xs:boolean', '', '', '' ]
	, [ 'SkypeMeNonTransactionalEnabled', 'xs:boolean', '', '', '' ]
	, [ 'SkypeMeTransactionalEnabled', 'xs:boolean', '', '', '' ]
	, [ 'SpecialitySubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'StoreInventoryEnabled', 'xs:boolean', '', '', '' ]
	, [ 'TransactionConfirmationRequestEnabled', 'xs:boolean', '', '', '' ]
	, [ 'UserConsentRequired', 'xs:boolean', '', '', '' ]
	, [ 'ValuePackEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProAdFormatEnabled', 'ns:AdFormatEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType', '' ]
	, [ 'eBayMotorsProAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType', '' ]
	, [ 'eBayMotorsProCompanyNameEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProContactByAddressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProContactByEmailEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProContactByPhoneEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProCounterOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProPaymentMethodCheckOutEnabled', 'ns:ClassifiedAdPaymentMethodEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType', '' ]
	, [ 'eBayMotorsProPhoneCount', 'xs:int', '', '', '' ]
	, [ 'eBayMotorsProSellerContactDetailsEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProShippingMethodEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProStreetCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdFormatEnabled()

Indicates whether the Classified Ad format feature is enabled for this
category.

#    Argument: 'ns:AdFormatEnabledCodeType'

=cut

sub setAdFormatEnabled {
  my $self = shift;
  $self->{'AdFormatEnabled'} = shift
}

=head2 getAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatEnabledCodeType'

=cut

sub getAdFormatEnabled {
  my $self = shift;
  return $self->{'AdFormatEnabled'};
}


=head2 setBasicUpgradePackEnabled()

Not applicable to any site.
Indicated whether the Basic Upgrade Pack bundle feature
was enabled for this category. Formerly, Australia site
(site ID 15, abbreviation AU) only.

#    Argument: 'xs:boolean'

=cut

sub setBasicUpgradePackEnabled {
  my $self = shift;
  $self->{'BasicUpgradePackEnabled'} = shift
}

=head2 isBasicUpgradePackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBasicUpgradePackEnabled {
  my $self = shift;
  return $self->{'BasicUpgradePackEnabled'};
}


=head2 setBestOfferAutoAcceptEnabled()

Indicates whether the category supports setting
a price at which best offers are automatically accepted.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferAutoAcceptEnabled {
  my $self = shift;
  $self->{'BestOfferAutoAcceptEnabled'} = shift
}

=head2 isBestOfferAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferAutoAcceptEnabled {
  my $self = shift;
  return $self->{'BestOfferAutoAcceptEnabled'};
}


=head2 setBestOfferAutoDeclineEnabled()

Indicates whether auto decline for best offers is allowed for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferAutoDeclineEnabled {
  my $self = shift;
  $self->{'BestOfferAutoDeclineEnabled'} = shift
}

=head2 isBestOfferAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferAutoDeclineEnabled {
  my $self = shift;
  return $self->{'BestOfferAutoDeclineEnabled'};
}


=head2 setBestOfferCounterEnabled()

Indicates whether counter offers are allowed on best offers for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferCounterEnabled {
  my $self = shift;
  $self->{'BestOfferCounterEnabled'} = shift
}

=head2 isBestOfferCounterEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferCounterEnabled {
  my $self = shift;
  return $self->{'BestOfferCounterEnabled'};
}


=head2 setBestOfferEnabled()

Indicates whether best offers is allowed for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferEnabled {
  my $self = shift;
  $self->{'BestOfferEnabled'} = shift
}

=head2 isBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferEnabled {
  my $self = shift;
  return $self->{'BestOfferEnabled'};
}


=head2 setBuyerGuaranteeEnabled()

For the Australia site, if both PayPalBuyerProtectionEnabled
and BuyerGuaranteeEnabled are returned, then
buyer protection is allowed for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setBuyerGuaranteeEnabled {
  my $self = shift;
  $self->{'BuyerGuaranteeEnabled'} = shift
}

=head2 isBuyerGuaranteeEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBuyerGuaranteeEnabled {
  my $self = shift;
  return $self->{'BuyerGuaranteeEnabled'};
}


=head2 setCategoryID()

Specifies the identifier of the category that has the feature.

MaxLength: 10

#    Argument: 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setClassifiedAdAutoAcceptEnabled()

Indicates whether the category supports setting
a price at which best offers are automatically accepted
for Classified Ads.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdAutoAcceptEnabled {
  my $self = shift;
  $self->{'ClassifiedAdAutoAcceptEnabled'} = shift
}

=head2 isClassifiedAdAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdAutoAcceptEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdAutoAcceptEnabled'};
}


=head2 setClassifiedAdAutoDeclineEnabled()

Indicates whether automatic decline for best offers for Classified Ad listings is allowed for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdAutoDeclineEnabled {
  my $self = shift;
  $self->{'ClassifiedAdAutoDeclineEnabled'} = shift
}

=head2 isClassifiedAdAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdAutoDeclineEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdAutoDeclineEnabled'};
}


=head2 setClassifiedAdBestOfferEnabled()

Indicates if Best offer is enabled for Classified Ad listings.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub setClassifiedAdBestOfferEnabled {
  my $self = shift;
  $self->{'ClassifiedAdBestOfferEnabled'} = shift
}

=head2 getClassifiedAdBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub getClassifiedAdBestOfferEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdBestOfferEnabled'};
}


=head2 setClassifiedAdCompanyNameEnabled()

Indicates whether most categories support including a company name in the
seller's contact information.
This element is for For Sale By Owner listings.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdCompanyNameEnabled {
  my $self = shift;
  $self->{'ClassifiedAdCompanyNameEnabled'} = shift
}

=head2 isClassifiedAdCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdCompanyNameEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdCompanyNameEnabled'};
}


=head2 setClassifiedAdContactByAddressEnabled()

Indicates whether most categories support including an address in the
seller's contact information.
This element is for For Sale By Owner listings.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdContactByAddressEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByAddressEnabled'} = shift
}

=head2 isClassifiedAdContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdContactByAddressEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdContactByAddressEnabled'};
}


=head2 setClassifiedAdContactByEmailEnabled()

Indicates whether the category supports email as a contact method.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdContactByEmailEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByEmailEnabled'} = shift
}

=head2 isClassifiedAdContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdContactByEmailEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdContactByEmailEnabled'};
}


=head2 setClassifiedAdContactByPhoneEnabled()

Indicates whether the telephone is supported as a contact method for the category.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdContactByPhoneEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByPhoneEnabled'} = shift
}

=head2 isClassifiedAdContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdContactByPhoneEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdContactByPhoneEnabled'};
}


=head2 setClassifiedAdCounterOfferEnabled()

Indicates whether counter offers are allowed on Classified Ad listings
for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdCounterOfferEnabled {
  my $self = shift;
  $self->{'ClassifiedAdCounterOfferEnabled'} = shift
}

=head2 isClassifiedAdCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdCounterOfferEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdCounterOfferEnabled'};
}


=head2 setClassifiedAdPayPerLeadEnabled()

Indicates if pay-per-lead listings are allowed for this category.
Pay-per-lead listings can be applicable if the ListingType is
LeadGeneration and the ListingSubtype is ClassifiedAd.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdPayPerLeadEnabled {
  my $self = shift;
  $self->{'ClassifiedAdPayPerLeadEnabled'} = shift
}

=head2 isClassifiedAdPayPerLeadEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdPayPerLeadEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdPayPerLeadEnabled'};
}


=head2 setClassifiedAdPaymentMethodEnabled()

Indicates whether the payment method should be displayed to the user for
Classified Ad format listings.
Even if enabled, checkout may or may not be enabled.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub setClassifiedAdPaymentMethodEnabled {
  my $self = shift;
  $self->{'ClassifiedAdPaymentMethodEnabled'} = shift
}

=head2 getClassifiedAdPaymentMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub getClassifiedAdPaymentMethodEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdPaymentMethodEnabled'};
}


=head2 setClassifiedAdPhoneCount()

Indicates which telephone option is included in the
seller's contact information.
This element is for For Sale By Owner listings.

#    Argument: 'xs:int'

=cut

sub setClassifiedAdPhoneCount {
  my $self = shift;
  $self->{'ClassifiedAdPhoneCount'} = shift
}

=head2 getClassifiedAdPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getClassifiedAdPhoneCount {
  my $self = shift;
  return $self->{'ClassifiedAdPhoneCount'};
}


=head2 setClassifiedAdShippingMethodEnabled()

Indicates if shipping options are available for Classified Ad listings
in the category.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdShippingMethodEnabled {
  my $self = shift;
  $self->{'ClassifiedAdShippingMethodEnabled'} = shift
}

=head2 isClassifiedAdShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdShippingMethodEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdShippingMethodEnabled'};
}


=head2 setClassifiedAdStreetCount()

Indicates which address option is included in the
seller's contact information.
This element is for For Sale By Owner listings.

#    Argument: 'xs:int'

=cut

sub setClassifiedAdStreetCount {
  my $self = shift;
  $self->{'ClassifiedAdStreetCount'} = shift
}

=head2 getClassifiedAdStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getClassifiedAdStreetCount {
  my $self = shift;
  return $self->{'ClassifiedAdStreetCount'};
}


=head2 setCombinedFixedPriceTreatmentEnabled()

On the Italy site, indicates whether the category supports
combined fixed price treatment for the following two listing
types:Store Inventory Format and Basic Fixed Price.

#    Argument: 'xs:boolean'

=cut

sub setCombinedFixedPriceTreatmentEnabled {
  my $self = shift;
  $self->{'CombinedFixedPriceTreatmentEnabled'} = shift
}

=head2 isCombinedFixedPriceTreatmentEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCombinedFixedPriceTreatmentEnabled {
  my $self = shift;
  return $self->{'CombinedFixedPriceTreatmentEnabled'};
}


=head2 setCrossBorderTradeAustraliaEnabled()

Indicates whether the category supports specifying that listings be displayed in the default search results of the Australia site.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setCrossBorderTradeAustraliaEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeAustraliaEnabled'} = shift
}

=head2 isCrossBorderTradeAustraliaEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCrossBorderTradeAustraliaEnabled {
  my $self = shift;
  return $self->{'CrossBorderTradeAustraliaEnabled'};
}


=head2 setCrossBorderTradeGBEnabled()

Indicates whether the category supports specifying that listings be displayed in the default search results of the UK site.

#    Argument: 'xs:boolean'

=cut

sub setCrossBorderTradeGBEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeGBEnabled'} = shift
}

=head2 isCrossBorderTradeGBEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCrossBorderTradeGBEnabled {
  my $self = shift;
  return $self->{'CrossBorderTradeGBEnabled'};
}


=head2 setCrossBorderTradeNorthAmericaEnabled()

Indicates whether the category supports specifying that listings be displayed in the default search results of North America sites.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setCrossBorderTradeNorthAmericaEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeNorthAmericaEnabled'} = shift
}

=head2 isCrossBorderTradeNorthAmericaEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCrossBorderTradeNorthAmericaEnabled {
  my $self = shift;
  return $self->{'CrossBorderTradeNorthAmericaEnabled'};
}


=head2 setDutchBINEnabled()

Indicates whether DutchBIN is allowed for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setDutchBINEnabled {
  my $self = shift;
  $self->{'DutchBINEnabled'} = shift
}

=head2 isDutchBINEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isDutchBINEnabled {
  my $self = shift;
  return $self->{'DutchBINEnabled'};
}


=head2 setExpressConditionRequired()

Indicates whether a listing requires the Item Condition
to be specified (using Item Specifics in AttributeSetArray) in order
to qualify for eBay Express when listed in this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setExpressConditionRequired {
  my $self = shift;
  $self->{'ExpressConditionRequired'} = shift
}

=head2 isExpressConditionRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpressConditionRequired {
  my $self = shift;
  return $self->{'ExpressConditionRequired'};
}


=head2 setExpressEnabled()

Indicates whether listings in this category are eligible for eBay Express
(assuming other item and user eligibility requirements are also met).
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setExpressEnabled {
  my $self = shift;
  $self->{'ExpressEnabled'} = shift
}

=head2 isExpressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpressEnabled {
  my $self = shift;
  return $self->{'ExpressEnabled'};
}


=head2 setExpressPicturesRequired()

Indicates whether a listing requires a picture (or gallery image) in order
to qualify for eBay Express when listed in this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setExpressPicturesRequired {
  my $self = shift;
  $self->{'ExpressPicturesRequired'} = shift
}

=head2 isExpressPicturesRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpressPicturesRequired {
  my $self = shift;
  return $self->{'ExpressPicturesRequired'};
}


=head2 setGalleryFeaturedDurations()

On the Italy site, indicates whether the category supports
durations for "Gallery Featured".

#    Argument: 'ns:ListingEnhancementDurationReferenceType'

=cut

sub setGalleryFeaturedDurations {
  my $self = shift;
  $self->{'GalleryFeaturedDurations'} = shift
}

=head2 getGalleryFeaturedDurations()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ListingEnhancementDurationReferenceType'

=cut

sub getGalleryFeaturedDurations {
  my $self = shift;
  return $self->_getDataTypeInstance( 'GalleryFeaturedDurations'
		,'eBay::API::XML::DataType::ListingEnhancementDurationReferenceType');
}


=head2 setHomePageFeaturedEnabled()

Indicates whether or not it is possible to enhance a listing by putting
it into a rotation for display on a special area of the eBay home page.
Support for this feature varies by site. Item or feedback restrictions may apply.

#    Argument: 'xs:boolean'

=cut

sub setHomePageFeaturedEnabled {
  my $self = shift;
  $self->{'HomePageFeaturedEnabled'} = shift
}

=head2 isHomePageFeaturedEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isHomePageFeaturedEnabled {
  my $self = shift;
  return $self->{'HomePageFeaturedEnabled'};
}


=head2 setINEscrowWorkflowTimeline()

Indicates the escrow workflow version that applies to the category on the
India site: Default Workflow, Workflow A or Workflow B.

#    Argument: 'ns:INEscrowWorkflowTimelineCodeType'

=cut

sub setINEscrowWorkflowTimeline {
  my $self = shift;
  $self->{'INEscrowWorkflowTimeline'} = shift
}

=head2 getINEscrowWorkflowTimeline()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:INEscrowWorkflowTimelineCodeType'

=cut

sub getINEscrowWorkflowTimeline {
  my $self = shift;
  return $self->{'INEscrowWorkflowTimeline'};
}


=head2 setItemSpecificsEnabled()

Indicates whether the category supports custom Item Specifics.
If enabled, sellers can use the Item.ItemSpecifics node in AddItem and
related calls to fill in Item Specifics.

#    Argument: 'ns:ItemSpecificsEnabledCodeType'

=cut

sub setItemSpecificsEnabled {
  my $self = shift;
  $self->{'ItemSpecificsEnabled'} = shift
}

=head2 getItemSpecificsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ItemSpecificsEnabledCodeType'

=cut

sub getItemSpecificsEnabled {
  my $self = shift;
  return $self->{'ItemSpecificsEnabled'};
}


=head2 setListingDuration()

Identifies the listing duration set that applies to the category.

#    Argument: reference to an array  
                      of 'ns:ListingDurationReferenceType'

=cut

sub setListingDuration {
  my $self = shift;
  $self->{'ListingDuration'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getListingDuration()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'ns:ListingDurationReferenceType'

=cut

sub getListingDuration {
  my $self = shift;
  return $self->_getDataTypeArray('ListingDuration');
}


=head2 setLocalMarketAdFormatEnabled()

Specifies the default site setting for Classified Ad listings.
True means the ad format for Classified Ads is allowed site-wide,
unless a specific category overrides the setting.
This is added for Local Market dealers.

#    Argument: 'ns:AdFormatEnabledCodeType'

=cut

sub setLocalMarketAdFormatEnabled {
  my $self = shift;
  $self->{'LocalMarketAdFormatEnabled'} = shift
}

=head2 getLocalMarketAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatEnabledCodeType'

=cut

sub getLocalMarketAdFormatEnabled {
  my $self = shift;
  return $self->{'LocalMarketAdFormatEnabled'};
}


=head2 setLocalMarketAutoAcceptEnabled()

Specifies the default site setting for auto-accept for best offers for Classified Ads. True means the auto-accept for best offers is allowed
site-wide, unless a specific category overrides the setting.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketAutoAcceptEnabled {
  my $self = shift;
  $self->{'LocalMarketAutoAcceptEnabled'} = shift
}

=head2 isLocalMarketAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketAutoAcceptEnabled {
  my $self = shift;
  return $self->{'LocalMarketAutoAcceptEnabled'};
}


=head2 setLocalMarketAutoDeclineEnabled()

Specifies the default site setting for auto-decline for best offers for Classified Ads. True means the auto-decline for best offers is allowed
site-wide, unless a specific category overrides the setting.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketAutoDeclineEnabled {
  my $self = shift;
  $self->{'LocalMarketAutoDeclineEnabled'} = shift
}

=head2 isLocalMarketAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketAutoDeclineEnabled {
  my $self = shift;
  return $self->{'LocalMarketAutoDeclineEnabled'};
}


=head2 setLocalMarketBestOfferEnabled()

Indicates if Best Offer is enabled for Classified Ad listings
in most categories.
This element is for Local Market dealers.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub setLocalMarketBestOfferEnabled {
  my $self = shift;
  $self->{'LocalMarketBestOfferEnabled'} = shift
}

=head2 getLocalMarketBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub getLocalMarketBestOfferEnabled {
  my $self = shift;
  return $self->{'LocalMarketBestOfferEnabled'};
}


=head2 setLocalMarketCompanyNameEnabled()

Indicates whether most categories support including a company name in the
seller's contact information.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketCompanyNameEnabled {
  my $self = shift;
  $self->{'LocalMarketCompanyNameEnabled'} = shift
}

=head2 isLocalMarketCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketCompanyNameEnabled {
  my $self = shift;
  return $self->{'LocalMarketCompanyNameEnabled'};
}


=head2 setLocalMarketContactByAddressEnabled()

Indicates whether most categories support including an address in the
seller's contact information.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketContactByAddressEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByAddressEnabled'} = shift
}

=head2 isLocalMarketContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketContactByAddressEnabled {
  my $self = shift;
  return $self->{'LocalMarketContactByAddressEnabled'};
}


=head2 setLocalMarketContactByEmailEnabled()

Indicates whether most categories support including an email address in the
seller's contact information.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketContactByEmailEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByEmailEnabled'} = shift
}

=head2 isLocalMarketContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketContactByEmailEnabled {
  my $self = shift;
  return $self->{'LocalMarketContactByEmailEnabled'};
}


=head2 setLocalMarketContactByPhoneEnabled()

Indicates whether most categories support including a telephone number in the
seller's contact information.
This element is added for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketContactByPhoneEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByPhoneEnabled'} = shift
}

=head2 isLocalMarketContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketContactByPhoneEnabled {
  my $self = shift;
  return $self->{'LocalMarketContactByPhoneEnabled'};
}


=head2 setLocalMarketCounterOfferEnabled()

Indicates whether counter offers are allowed on best offers for
most categories.
This element is for Local market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketCounterOfferEnabled {
  my $self = shift;
  $self->{'LocalMarketCounterOfferEnabled'} = shift
}

=head2 isLocalMarketCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketCounterOfferEnabled {
  my $self = shift;
  return $self->{'LocalMarketCounterOfferEnabled'};
}


=head2 setLocalMarketNonSubscription()

Indicates whether LocalMarketNonSubscription feature is supported for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketNonSubscription {
  my $self = shift;
  $self->{'LocalMarketNonSubscription'} = shift
}

=head2 isLocalMarketNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketNonSubscription {
  my $self = shift;
  return $self->{'LocalMarketNonSubscription'};
}


=head2 setLocalMarketPaymentMethodCheckOutEnabled()

Indicates if the payment method should be displayed to the user
for most categories. Even if enabled, checkout may or may not
be enabled.
This element is for Local Market dealers.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub setLocalMarketPaymentMethodCheckOutEnabled {
  my $self = shift;
  $self->{'LocalMarketPaymentMethodCheckOutEnabled'} = shift
}

=head2 getLocalMarketPaymentMethodCheckOutEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub getLocalMarketPaymentMethodCheckOutEnabled {
  my $self = shift;
  return $self->{'LocalMarketPaymentMethodCheckOutEnabled'};
}


=head2 setLocalMarketPhoneCount()

Indicates which telephone option is enabled for the seller's contact information.
This element is for Local Market dealers.

#    Argument: 'xs:int'

=cut

sub setLocalMarketPhoneCount {
  my $self = shift;
  $self->{'LocalMarketPhoneCount'} = shift
}

=head2 getLocalMarketPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getLocalMarketPhoneCount {
  my $self = shift;
  return $self->{'LocalMarketPhoneCount'};
}


=head2 setLocalMarketPremiumSubscription()

Indicates whether LocalMarketPremiumSubscription feature is supported for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketPremiumSubscription {
  my $self = shift;
  $self->{'LocalMarketPremiumSubscription'} = shift
}

=head2 isLocalMarketPremiumSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketPremiumSubscription {
  my $self = shift;
  return $self->{'LocalMarketPremiumSubscription'};
}


=head2 setLocalMarketRegularSubscription()

Indicates whether LocalMarketRegularSubscription feature is supported for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketRegularSubscription {
  my $self = shift;
  $self->{'LocalMarketRegularSubscription'} = shift
}

=head2 isLocalMarketRegularSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketRegularSubscription {
  my $self = shift;
  return $self->{'LocalMarketRegularSubscription'};
}


=head2 setLocalMarketSellerContactDetailsEnabled()

Specifies the default site setting for whether most categories allow
seller-level contact information for Classified Ad listings.
A value of true means seller-level contact information is available
for Classified Ad listings site-wide, unless a specific category
overrides the setting.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'LocalMarketSellerContactDetailsEnabled'} = shift
}

=head2 isLocalMarketSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketSellerContactDetailsEnabled {
  my $self = shift;
  return $self->{'LocalMarketSellerContactDetailsEnabled'};
}


=head2 setLocalMarketShippingMethodEnabled()

Indicates if shipping options are available for most categories.
This element is for Local market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketShippingMethodEnabled {
  my $self = shift;
  $self->{'LocalMarketShippingMethodEnabled'} = shift
}

=head2 isLocalMarketShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketShippingMethodEnabled {
  my $self = shift;
  return $self->{'LocalMarketShippingMethodEnabled'};
}


=head2 setLocalMarketSpecialitySubscription()

Indicates whether LocalMarketSpecialitySubscription feature is supported for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketSpecialitySubscription {
  my $self = shift;
  $self->{'LocalMarketSpecialitySubscription'} = shift
}

=head2 isLocalMarketSpecialitySubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketSpecialitySubscription {
  my $self = shift;
  return $self->{'LocalMarketSpecialitySubscription'};
}


=head2 setLocalMarketStreetCount()

Indicates which address option for is included in the
seller's contact information.
This element is for Local Market dealers.

#    Argument: 'xs:int'

=cut

sub setLocalMarketStreetCount {
  my $self = shift;
  $self->{'LocalMarketStreetCount'} = shift
}

=head2 getLocalMarketStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getLocalMarketStreetCount {
  my $self = shift;
  return $self->{'LocalMarketStreetCount'};
}


=head2 setMinimumReservePrice()

Indicates whether Minimum Reserve Price is enabled for this
category. Returned only if this category overrides the site default.
On the Germany, Austria, Belgium French, and Belgium Dutch
sites, Minimum Reserve Price is supported for the Art and Antiques, Watches and Jewelry, and Motorbikes categories.

#    Argument: 'xs:double'

=cut

sub setMinimumReservePrice {
  my $self = shift;
  $self->{'MinimumReservePrice'} = shift
}

=head2 getMinimumReservePrice()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:double'

=cut

sub getMinimumReservePrice {
  my $self = shift;
  return $self->{'MinimumReservePrice'};
}


=head2 setNonSubscription()

Specifies the supported local listing distances for most categories,
for users who have not subscribed to either Regular or Specialty vehicles.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setNonSubscription {
  my $self = shift;
  $self->{'NonSubscription'} = shift
}

=head2 getNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getNonSubscription {
  my $self = shift;
  return $self->{'NonSubscription'};
}


=head2 setPaisaPayFullEscrowEnabled()

Indicates whether the category supports the PaisaPayEscrow payment method.

#    Argument: 'xs:boolean'

=cut

sub setPaisaPayFullEscrowEnabled {
  my $self = shift;
  $self->{'PaisaPayFullEscrowEnabled'} = shift
}

=head2 isPaisaPayFullEscrowEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPaisaPayFullEscrowEnabled {
  my $self = shift;
  return $self->{'PaisaPayFullEscrowEnabled'};
}


=head2 setPayPalBuyerProtectionEnabled()

For the Australia site, if both PayPalBuyerProtectionEnabled
and BuyerGuaranteeEnabled are returned, then
buyer protection is allowed for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setPayPalBuyerProtectionEnabled {
  my $self = shift;
  $self->{'PayPalBuyerProtectionEnabled'} = shift
}

=head2 isPayPalBuyerProtectionEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPayPalBuyerProtectionEnabled {
  my $self = shift;
  return $self->{'PayPalBuyerProtectionEnabled'};
}


=head2 setPayPalRequired()

Indicates whether the category requires PayPal as a payment method.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setPayPalRequired {
  my $self = shift;
  $self->{'PayPalRequired'} = shift
}

=head2 isPayPalRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPayPalRequired {
  my $self = shift;
  return $self->{'PayPalRequired'};
}


=head2 setPremiumSubscription()

Specifies the default site setting for whether the
LocalMarketPremiumSubscription
feature is supported for most categories.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setPremiumSubscription {
  my $self = shift;
  $self->{'PremiumSubscription'} = shift
}

=head2 getPremiumSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getPremiumSubscription {
  my $self = shift;
  return $self->{'PremiumSubscription'};
}


=head2 setProPackEnabled()

Indicates whether ProPackBundle (a feature pack) is enabled for this category.

#    Argument: 'xs:boolean'

=cut

sub setProPackEnabled {
  my $self = shift;
  $self->{'ProPackEnabled'} = shift
}

=head2 isProPackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isProPackEnabled {
  my $self = shift;
  return $self->{'ProPackEnabled'};
}


=head2 setProPackPlusEnabled()

Indicates whether the ProPackPlus bundle (a feature pack) is enabled for this category.

#    Argument: 'xs:boolean'

=cut

sub setProPackPlusEnabled {
  my $self = shift;
  $self->{'ProPackPlusEnabled'} = shift
}

=head2 isProPackPlusEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isProPackPlusEnabled {
  my $self = shift;
  return $self->{'ProPackPlusEnabled'};
}


=head2 setRegularSubscription()

Specifies the default site setting for whether the LocalMarketRegularSubscription feature is supported for
most categories.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setRegularSubscription {
  my $self = shift;
  $self->{'RegularSubscription'} = shift
}

=head2 getRegularSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getRegularSubscription {
  my $self = shift;
  return $self->{'RegularSubscription'};
}


=head2 setSafePaymentRequired()

Indicates whether listings in this category need to have a safe
payment method, for all sellers registered after January 17,2007.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setSafePaymentRequired {
  my $self = shift;
  $self->{'SafePaymentRequired'} = shift
}

=head2 isSafePaymentRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSafePaymentRequired {
  my $self = shift;
  return $self->{'SafePaymentRequired'};
}


=head2 setSellerContactDetailsEnabled()

Indicates whether this category supports seller-level contact information for
Classified Ad format listings. Returned only if this category overrides the
site default.

#    Argument: 'xs:boolean'

=cut

sub setSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'SellerContactDetailsEnabled'} = shift
}

=head2 isSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSellerContactDetailsEnabled {
  my $self = shift;
  return $self->{'SellerContactDetailsEnabled'};
}


=head2 setShippingTermsRequired()

Indicates whether sellers are required to specify shipping items
for this category. Returned only if this category overrides the
site default.

#    Argument: 'xs:boolean'

=cut

sub setShippingTermsRequired {
  my $self = shift;
  $self->{'ShippingTermsRequired'} = shift
}

=head2 isShippingTermsRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isShippingTermsRequired {
  my $self = shift;
  return $self->{'ShippingTermsRequired'};
}


=head2 setSkypeMeNonTransactionalEnabled()

Indicates whether the addition of Skype buttons to listings is supported
for this category for non-transactional formats (e.g., the advertisement format).
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setSkypeMeNonTransactionalEnabled {
  my $self = shift;
  $self->{'SkypeMeNonTransactionalEnabled'} = shift
}

=head2 isSkypeMeNonTransactionalEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSkypeMeNonTransactionalEnabled {
  my $self = shift;
  return $self->{'SkypeMeNonTransactionalEnabled'};
}


=head2 setSkypeMeTransactionalEnabled()

Indicates whether the addition of Skype buttons to listings is supported for this category for transactional formats (e.g., the Chinese auction format).
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setSkypeMeTransactionalEnabled {
  my $self = shift;
  $self->{'SkypeMeTransactionalEnabled'} = shift
}

=head2 isSkypeMeTransactionalEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSkypeMeTransactionalEnabled {
  my $self = shift;
  return $self->{'SkypeMeTransactionalEnabled'};
}


=head2 setSpecialitySubscription()

Specifies the default site setting for whether the
LocalMarketSpecialitySubscription feature is supported for
most categories.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setSpecialitySubscription {
  my $self = shift;
  $self->{'SpecialitySubscription'} = shift
}

=head2 getSpecialitySubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getSpecialitySubscription {
  my $self = shift;
  return $self->{'SpecialitySubscription'};
}


=head2 setStoreInventoryEnabled()

Indicates whether SIF (Store Inventory Format) is enabled for this category.

#    Argument: 'xs:boolean'

=cut

sub setStoreInventoryEnabled {
  my $self = shift;
  $self->{'StoreInventoryEnabled'} = shift
}

=head2 isStoreInventoryEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isStoreInventoryEnabled {
  my $self = shift;
  return $self->{'StoreInventoryEnabled'};
}


=head2 setTransactionConfirmationRequestEnabled()

Indicates whether the Transaction Confirmation Request feature is supported for this category.
Returned only if this category overrides the site default.

#    Argument: 'xs:boolean'

=cut

sub setTransactionConfirmationRequestEnabled {
  my $self = shift;
  $self->{'TransactionConfirmationRequestEnabled'} = shift
}

=head2 isTransactionConfirmationRequestEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isTransactionConfirmationRequestEnabled {
  my $self = shift;
  return $self->{'TransactionConfirmationRequestEnabled'};
}


=head2 setUserConsentRequired()

Indicates whether a bidder must consent to the bid by confirming that
he or she read and agrees to the terms in eBay's privacy policy.

#    Argument: 'xs:boolean'

=cut

sub setUserConsentRequired {
  my $self = shift;
  $self->{'UserConsentRequired'} = shift
}

=head2 isUserConsentRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isUserConsentRequired {
  my $self = shift;
  return $self->{'UserConsentRequired'};
}


=head2 setValuePackEnabled()

Indicates whether ValuePack bundle (a feature pack) is enabled
for this category.

#    Argument: 'xs:boolean'

=cut

sub setValuePackEnabled {
  my $self = shift;
  $self->{'ValuePackEnabled'} = shift
}

=head2 isValuePackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isValuePackEnabled {
  my $self = shift;
  return $self->{'ValuePackEnabled'};
}


=head2 setEBayMotorsProAdFormatEnabled()

Specifies the default site setting for whether categories allow
Classified Ad listings. True means the feature is allowed
site-wide, unless a specific category overrides the setting.
This element is for eBay Motors Pro users.

#    Argument: 'ns:AdFormatEnabledCodeType'

=cut

sub setEBayMotorsProAdFormatEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAdFormatEnabled'} = shift
}

=head2 getEBayMotorsProAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatEnabledCodeType'

=cut

sub getEBayMotorsProAdFormatEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProAdFormatEnabled'};
}


=head2 setEBayMotorsProAutoAcceptEnabled()

Specifies the default site setting for whether categories allow
auto-accept for Best Offers for Classified Ads.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProAutoAcceptEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAutoAcceptEnabled'} = shift
}

=head2 isEBayMotorsProAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProAutoAcceptEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProAutoAcceptEnabled'};
}


=head2 setEBayMotorsProAutoDeclineEnabled()

Specifies the default site setting for whether categories allow
auto-decline for Best Offers for Classified Ads.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProAutoDeclineEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAutoDeclineEnabled'} = shift
}

=head2 isEBayMotorsProAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProAutoDeclineEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProAutoDeclineEnabled'};
}


=head2 setEBayMotorsProBestOfferEnabled()

Indicates if Best Offer is supported for Classified Ad listings
in most categories.
This element is for eBay Motors Pro users.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub setEBayMotorsProBestOfferEnabled {
  my $self = shift;
  $self->{'eBayMotorsProBestOfferEnabled'} = shift
}

=head2 getEBayMotorsProBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub getEBayMotorsProBestOfferEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProBestOfferEnabled'};
}


=head2 setEBayMotorsProCompanyNameEnabled()

Indicates whether most categories support including the company name in the
seller's contact information.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProCompanyNameEnabled {
  my $self = shift;
  $self->{'eBayMotorsProCompanyNameEnabled'} = shift
}

=head2 isEBayMotorsProCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProCompanyNameEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProCompanyNameEnabled'};
}


=head2 setEBayMotorsProContactByAddressEnabled()

Indicates whether most categories support including the address in the
seller's contact information.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProContactByAddressEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByAddressEnabled'} = shift
}

=head2 isEBayMotorsProContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProContactByAddressEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProContactByAddressEnabled'};
}


=head2 setEBayMotorsProContactByEmailEnabled()

Indicates whether most categories support including an email address in the
seller's contact information.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProContactByEmailEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByEmailEnabled'} = shift
}

=head2 isEBayMotorsProContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProContactByEmailEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProContactByEmailEnabled'};
}


=head2 setEBayMotorsProContactByPhoneEnabled()

Indicates whether most categories support including the telephone in the
seller's contact information.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProContactByPhoneEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByPhoneEnabled'} = shift
}

=head2 isEBayMotorsProContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProContactByPhoneEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProContactByPhoneEnabled'};
}


=head2 setEBayMotorsProCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for
most categories.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProCounterOfferEnabled {
  my $self = shift;
  $self->{'eBayMotorsProCounterOfferEnabled'} = shift
}

=head2 isEBayMotorsProCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProCounterOfferEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProCounterOfferEnabled'};
}


=head2 setEBayMotorsProPaymentMethodCheckOutEnabled()

Indicates if the payment method should be displayed to the user
for most categories. Even if enabled, checkout may or may not
be enabled.
This element is for eBay Motors Pro users.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub setEBayMotorsProPaymentMethodCheckOutEnabled {
  my $self = shift;
  $self->{'eBayMotorsProPaymentMethodCheckOutEnabled'} = shift
}

=head2 getEBayMotorsProPaymentMethodCheckOutEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub getEBayMotorsProPaymentMethodCheckOutEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProPaymentMethodCheckOutEnabled'};
}


=head2 setEBayMotorsProPhoneCount()

Indicates which telephone option is enabled for the seller's contact information.
This element is for eBay Motors Pro users.

#    Argument: 'xs:int'

=cut

sub setEBayMotorsProPhoneCount {
  my $self = shift;
  $self->{'eBayMotorsProPhoneCount'} = shift
}

=head2 getEBayMotorsProPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getEBayMotorsProPhoneCount {
  my $self = shift;
  return $self->{'eBayMotorsProPhoneCount'};
}


=head2 setEBayMotorsProSellerContactDetailsEnabled()

Specifies the default site setting for whether most categories allow seller-level contact information for Classified Ad listings. A value of true
means seller-level contact information is available for Classified Ad listings site-wide, unless a specific category overrides the setting.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'eBayMotorsProSellerContactDetailsEnabled'} = shift
}

=head2 isEBayMotorsProSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProSellerContactDetailsEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProSellerContactDetailsEnabled'};
}


=head2 setEBayMotorsProShippingMethodEnabled()

Indicates if shipping options are available for most categories.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProShippingMethodEnabled {
  my $self = shift;
  $self->{'eBayMotorsProShippingMethodEnabled'} = shift
}

=head2 isEBayMotorsProShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProShippingMethodEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProShippingMethodEnabled'};
}


=head2 setEBayMotorsProStreetCount()

Indicates which address option is enabled for the seller's contact information.
This element is for eBay Motors Pro users.

#    Argument: 'xs:int'

=cut

sub setEBayMotorsProStreetCount {
  my $self = shift;
  $self->{'eBayMotorsProStreetCount'} = shift
}

=head2 getEBayMotorsProStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getEBayMotorsProStreetCount {
  my $self = shift;
  return $self->{'eBayMotorsProStreetCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
